// Code generated by "libovsdb.modelgen"
// DO NOT EDIT.

package nbdb

import "github.com/ovn-org/libovsdb/model"

type (
	BFDStatus = string
)

var (
	BFDStatusDown      BFDStatus = "down"
	BFDStatusInit      BFDStatus = "init"
	BFDStatusUp        BFDStatus = "up"
	BFDStatusAdminDown BFDStatus = "admin_down"
)

// BFD defines an object in BFD table
type BFD struct {
	UUID        string            `ovsdb:"_uuid"`
	DetectMult  *int              `ovsdb:"detect_mult"`
	DstIP       string            `ovsdb:"dst_ip"`
	ExternalIDs map[string]string `ovsdb:"external_ids"`
	LogicalPort string            `ovsdb:"logical_port"`
	MinRx       *int              `ovsdb:"min_rx"`
	MinTx       *int              `ovsdb:"min_tx"`
	Options     map[string]string `ovsdb:"options"`
	Status      *BFDStatus        `ovsdb:"status"`
}

func copyBFDDetectMult(a *int) *int {
	if a == nil {
		return nil
	}
	b := *a
	return &b
}

func equalBFDDetectMult(a, b *int) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if a == b {
		return true
	}
	return *a == *b
}

func copyBFDExternalIDs(a map[string]string) map[string]string {
	if a == nil {
		return nil
	}
	b := make(map[string]string, len(a))
	for k, v := range a {
		b[k] = v
	}
	return b
}

func equalBFDExternalIDs(a, b map[string]string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || v != w {
			return false
		}
	}
	return true
}

func copyBFDMinRx(a *int) *int {
	if a == nil {
		return nil
	}
	b := *a
	return &b
}

func equalBFDMinRx(a, b *int) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if a == b {
		return true
	}
	return *a == *b
}

func copyBFDMinTx(a *int) *int {
	if a == nil {
		return nil
	}
	b := *a
	return &b
}

func equalBFDMinTx(a, b *int) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if a == b {
		return true
	}
	return *a == *b
}

func copyBFDOptions(a map[string]string) map[string]string {
	if a == nil {
		return nil
	}
	b := make(map[string]string, len(a))
	for k, v := range a {
		b[k] = v
	}
	return b
}

func equalBFDOptions(a, b map[string]string) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if len(a) != len(b) {
		return false
	}
	for k, v := range a {
		if w, ok := b[k]; !ok || v != w {
			return false
		}
	}
	return true
}

func copyBFDStatus(a *BFDStatus) *BFDStatus {
	if a == nil {
		return nil
	}
	b := *a
	return &b
}

func equalBFDStatus(a, b *BFDStatus) bool {
	if (a == nil) != (b == nil) {
		return false
	}
	if a == b {
		return true
	}
	return *a == *b
}

func (a *BFD) DeepCopyInto(b *BFD) {
	*b = *a
	b.DetectMult = copyBFDDetectMult(a.DetectMult)
	b.ExternalIDs = copyBFDExternalIDs(a.ExternalIDs)
	b.MinRx = copyBFDMinRx(a.MinRx)
	b.MinTx = copyBFDMinTx(a.MinTx)
	b.Options = copyBFDOptions(a.Options)
	b.Status = copyBFDStatus(a.Status)
}

func (a *BFD) DeepCopy() *BFD {
	b := new(BFD)
	a.DeepCopyInto(b)
	return b
}

func (a *BFD) CloneModelInto(b model.Model) {
	c := b.(*BFD)
	a.DeepCopyInto(c)
}

func (a *BFD) CloneModel() model.Model {
	return a.DeepCopy()
}

func (a *BFD) Equals(b *BFD) bool {
	return a.UUID == b.UUID &&
		equalBFDDetectMult(a.DetectMult, b.DetectMult) &&
		a.DstIP == b.DstIP &&
		equalBFDExternalIDs(a.ExternalIDs, b.ExternalIDs) &&
		a.LogicalPort == b.LogicalPort &&
		equalBFDMinRx(a.MinRx, b.MinRx) &&
		equalBFDMinTx(a.MinTx, b.MinTx) &&
		equalBFDOptions(a.Options, b.Options) &&
		equalBFDStatus(a.Status, b.Status)
}

func (a *BFD) EqualsModel(b model.Model) bool {
	c := b.(*BFD)
	return a.Equals(c)
}

var _ model.CloneableModel = &BFD{}
var _ model.ComparableModel = &BFD{}
