//
// Copyright (c) 2017 Joey <majunjiev@gmail.com>.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
package ovirtsdk

import (
	"fmt"
	"time"
)

type VmSummary struct {
	Struct
	active    *int64
	migrating *int64
	total     *int64
}

func (p *VmSummary) SetActive(attr int64) {
	p.active = &attr
}

func (p *VmSummary) Active() (int64, bool) {
	if p.active != nil {
		return *p.active, true
	}
	var zero int64
	return zero, false
}

func (p *VmSummary) MustActive() int64 {
	if p.active == nil {
		panic("the active must not be nil, please use Active() function instead")
	}
	return *p.active
}

func (p *VmSummary) SetMigrating(attr int64) {
	p.migrating = &attr
}

func (p *VmSummary) Migrating() (int64, bool) {
	if p.migrating != nil {
		return *p.migrating, true
	}
	var zero int64
	return zero, false
}

func (p *VmSummary) MustMigrating() int64 {
	if p.migrating == nil {
		panic("the migrating must not be nil, please use Migrating() function instead")
	}
	return *p.migrating
}

func (p *VmSummary) SetTotal(attr int64) {
	p.total = &attr
}

func (p *VmSummary) Total() (int64, bool) {
	if p.total != nil {
		return *p.total, true
	}
	var zero int64
	return zero, false
}

func (p *VmSummary) MustTotal() int64 {
	if p.total == nil {
		panic("the total must not be nil, please use Total() function instead")
	}
	return *p.total
}

type NetworkFilter struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
	version     *Version
}

func (p *NetworkFilter) SetComment(attr string) {
	p.comment = &attr
}

func (p *NetworkFilter) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *NetworkFilter) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *NetworkFilter) SetDescription(attr string) {
	p.description = &attr
}

func (p *NetworkFilter) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *NetworkFilter) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *NetworkFilter) SetId(attr string) {
	p.id = &attr
}

func (p *NetworkFilter) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *NetworkFilter) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *NetworkFilter) SetName(attr string) {
	p.name = &attr
}

func (p *NetworkFilter) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *NetworkFilter) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *NetworkFilter) SetVersion(attr *Version) {
	p.version = attr
}

func (p *NetworkFilter) Version() (*Version, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *NetworkFilter) MustVersion() *Version {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

type QuotaClusterLimit struct {
	Struct
	cluster     *Cluster
	comment     *string
	description *string
	id          *string
	memoryLimit *float64
	memoryUsage *float64
	name        *string
	quota       *Quota
	vcpuLimit   *int64
	vcpuUsage   *int64
}

func (p *QuotaClusterLimit) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *QuotaClusterLimit) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *QuotaClusterLimit) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *QuotaClusterLimit) SetComment(attr string) {
	p.comment = &attr
}

func (p *QuotaClusterLimit) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *QuotaClusterLimit) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *QuotaClusterLimit) SetDescription(attr string) {
	p.description = &attr
}

func (p *QuotaClusterLimit) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *QuotaClusterLimit) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *QuotaClusterLimit) SetId(attr string) {
	p.id = &attr
}

func (p *QuotaClusterLimit) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *QuotaClusterLimit) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *QuotaClusterLimit) SetMemoryLimit(attr float64) {
	p.memoryLimit = &attr
}

func (p *QuotaClusterLimit) MemoryLimit() (float64, bool) {
	if p.memoryLimit != nil {
		return *p.memoryLimit, true
	}
	var zero float64
	return zero, false
}

func (p *QuotaClusterLimit) MustMemoryLimit() float64 {
	if p.memoryLimit == nil {
		panic("the memoryLimit must not be nil, please use MemoryLimit() function instead")
	}
	return *p.memoryLimit
}

func (p *QuotaClusterLimit) SetMemoryUsage(attr float64) {
	p.memoryUsage = &attr
}

func (p *QuotaClusterLimit) MemoryUsage() (float64, bool) {
	if p.memoryUsage != nil {
		return *p.memoryUsage, true
	}
	var zero float64
	return zero, false
}

func (p *QuotaClusterLimit) MustMemoryUsage() float64 {
	if p.memoryUsage == nil {
		panic("the memoryUsage must not be nil, please use MemoryUsage() function instead")
	}
	return *p.memoryUsage
}

func (p *QuotaClusterLimit) SetName(attr string) {
	p.name = &attr
}

func (p *QuotaClusterLimit) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *QuotaClusterLimit) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *QuotaClusterLimit) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *QuotaClusterLimit) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *QuotaClusterLimit) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *QuotaClusterLimit) SetVcpuLimit(attr int64) {
	p.vcpuLimit = &attr
}

func (p *QuotaClusterLimit) VcpuLimit() (int64, bool) {
	if p.vcpuLimit != nil {
		return *p.vcpuLimit, true
	}
	var zero int64
	return zero, false
}

func (p *QuotaClusterLimit) MustVcpuLimit() int64 {
	if p.vcpuLimit == nil {
		panic("the vcpuLimit must not be nil, please use VcpuLimit() function instead")
	}
	return *p.vcpuLimit
}

func (p *QuotaClusterLimit) SetVcpuUsage(attr int64) {
	p.vcpuUsage = &attr
}

func (p *QuotaClusterLimit) VcpuUsage() (int64, bool) {
	if p.vcpuUsage != nil {
		return *p.vcpuUsage, true
	}
	var zero int64
	return zero, false
}

func (p *QuotaClusterLimit) MustVcpuUsage() int64 {
	if p.vcpuUsage == nil {
		panic("the vcpuUsage must not be nil, please use VcpuUsage() function instead")
	}
	return *p.vcpuUsage
}

type Bios struct {
	Struct
	bootMenu *BootMenu
	type_    *BiosType
}

func (p *Bios) SetBootMenu(attr *BootMenu) {
	p.bootMenu = attr
}

func (p *Bios) BootMenu() (*BootMenu, bool) {
	if p.bootMenu != nil {
		return p.bootMenu, true
	}
	return nil, false
}

func (p *Bios) MustBootMenu() *BootMenu {
	if p.bootMenu == nil {
		panic("the bootMenu must not be nil, please use BootMenu() function instead")
	}
	return p.bootMenu
}

func (p *Bios) SetType(attr BiosType) {
	p.type_ = &attr
}

func (p *Bios) Type() (BiosType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero BiosType
	return zero, false
}

func (p *Bios) MustType() BiosType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type Quota struct {
	Struct
	clusterHardLimitPct *int64
	clusterSoftLimitPct *int64
	comment             *string
	dataCenter          *DataCenter
	description         *string
	disks               *DiskSlice
	id                  *string
	name                *string
	permissions         *PermissionSlice
	quotaClusterLimits  *QuotaClusterLimitSlice
	quotaStorageLimits  *QuotaStorageLimitSlice
	storageHardLimitPct *int64
	storageSoftLimitPct *int64
	users               *UserSlice
	vms                 *VmSlice
}

func (p *Quota) SetClusterHardLimitPct(attr int64) {
	p.clusterHardLimitPct = &attr
}

func (p *Quota) ClusterHardLimitPct() (int64, bool) {
	if p.clusterHardLimitPct != nil {
		return *p.clusterHardLimitPct, true
	}
	var zero int64
	return zero, false
}

func (p *Quota) MustClusterHardLimitPct() int64 {
	if p.clusterHardLimitPct == nil {
		panic("the clusterHardLimitPct must not be nil, please use ClusterHardLimitPct() function instead")
	}
	return *p.clusterHardLimitPct
}

func (p *Quota) SetClusterSoftLimitPct(attr int64) {
	p.clusterSoftLimitPct = &attr
}

func (p *Quota) ClusterSoftLimitPct() (int64, bool) {
	if p.clusterSoftLimitPct != nil {
		return *p.clusterSoftLimitPct, true
	}
	var zero int64
	return zero, false
}

func (p *Quota) MustClusterSoftLimitPct() int64 {
	if p.clusterSoftLimitPct == nil {
		panic("the clusterSoftLimitPct must not be nil, please use ClusterSoftLimitPct() function instead")
	}
	return *p.clusterSoftLimitPct
}

func (p *Quota) SetComment(attr string) {
	p.comment = &attr
}

func (p *Quota) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Quota) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Quota) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *Quota) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *Quota) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *Quota) SetDescription(attr string) {
	p.description = &attr
}

func (p *Quota) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Quota) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Quota) SetDisks(attr *DiskSlice) {
	p.disks = attr
}

func (p *Quota) Disks() (*DiskSlice, bool) {
	if p.disks != nil {
		return p.disks, true
	}
	return nil, false
}

func (p *Quota) MustDisks() *DiskSlice {
	if p.disks == nil {
		panic("the disks must not be nil, please use Disks() function instead")
	}
	return p.disks
}

func (p *Quota) SetId(attr string) {
	p.id = &attr
}

func (p *Quota) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Quota) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Quota) SetName(attr string) {
	p.name = &attr
}

func (p *Quota) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Quota) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Quota) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *Quota) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *Quota) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *Quota) SetQuotaClusterLimits(attr *QuotaClusterLimitSlice) {
	p.quotaClusterLimits = attr
}

func (p *Quota) QuotaClusterLimits() (*QuotaClusterLimitSlice, bool) {
	if p.quotaClusterLimits != nil {
		return p.quotaClusterLimits, true
	}
	return nil, false
}

func (p *Quota) MustQuotaClusterLimits() *QuotaClusterLimitSlice {
	if p.quotaClusterLimits == nil {
		panic("the quotaClusterLimits must not be nil, please use QuotaClusterLimits() function instead")
	}
	return p.quotaClusterLimits
}

func (p *Quota) SetQuotaStorageLimits(attr *QuotaStorageLimitSlice) {
	p.quotaStorageLimits = attr
}

func (p *Quota) QuotaStorageLimits() (*QuotaStorageLimitSlice, bool) {
	if p.quotaStorageLimits != nil {
		return p.quotaStorageLimits, true
	}
	return nil, false
}

func (p *Quota) MustQuotaStorageLimits() *QuotaStorageLimitSlice {
	if p.quotaStorageLimits == nil {
		panic("the quotaStorageLimits must not be nil, please use QuotaStorageLimits() function instead")
	}
	return p.quotaStorageLimits
}

func (p *Quota) SetStorageHardLimitPct(attr int64) {
	p.storageHardLimitPct = &attr
}

func (p *Quota) StorageHardLimitPct() (int64, bool) {
	if p.storageHardLimitPct != nil {
		return *p.storageHardLimitPct, true
	}
	var zero int64
	return zero, false
}

func (p *Quota) MustStorageHardLimitPct() int64 {
	if p.storageHardLimitPct == nil {
		panic("the storageHardLimitPct must not be nil, please use StorageHardLimitPct() function instead")
	}
	return *p.storageHardLimitPct
}

func (p *Quota) SetStorageSoftLimitPct(attr int64) {
	p.storageSoftLimitPct = &attr
}

func (p *Quota) StorageSoftLimitPct() (int64, bool) {
	if p.storageSoftLimitPct != nil {
		return *p.storageSoftLimitPct, true
	}
	var zero int64
	return zero, false
}

func (p *Quota) MustStorageSoftLimitPct() int64 {
	if p.storageSoftLimitPct == nil {
		panic("the storageSoftLimitPct must not be nil, please use StorageSoftLimitPct() function instead")
	}
	return *p.storageSoftLimitPct
}

func (p *Quota) SetUsers(attr *UserSlice) {
	p.users = attr
}

func (p *Quota) Users() (*UserSlice, bool) {
	if p.users != nil {
		return p.users, true
	}
	return nil, false
}

func (p *Quota) MustUsers() *UserSlice {
	if p.users == nil {
		panic("the users must not be nil, please use Users() function instead")
	}
	return p.users
}

func (p *Quota) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *Quota) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *Quota) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

type MigrationOptions struct {
	Struct
	autoConverge *InheritableBoolean
	bandwidth    *MigrationBandwidth
	compressed   *InheritableBoolean
	encrypted    *InheritableBoolean
	policy       *MigrationPolicy
}

func (p *MigrationOptions) SetAutoConverge(attr InheritableBoolean) {
	p.autoConverge = &attr
}

func (p *MigrationOptions) AutoConverge() (InheritableBoolean, bool) {
	if p.autoConverge != nil {
		return *p.autoConverge, true
	}
	var zero InheritableBoolean
	return zero, false
}

func (p *MigrationOptions) MustAutoConverge() InheritableBoolean {
	if p.autoConverge == nil {
		panic("the autoConverge must not be nil, please use AutoConverge() function instead")
	}
	return *p.autoConverge
}

func (p *MigrationOptions) SetBandwidth(attr *MigrationBandwidth) {
	p.bandwidth = attr
}

func (p *MigrationOptions) Bandwidth() (*MigrationBandwidth, bool) {
	if p.bandwidth != nil {
		return p.bandwidth, true
	}
	return nil, false
}

func (p *MigrationOptions) MustBandwidth() *MigrationBandwidth {
	if p.bandwidth == nil {
		panic("the bandwidth must not be nil, please use Bandwidth() function instead")
	}
	return p.bandwidth
}

func (p *MigrationOptions) SetCompressed(attr InheritableBoolean) {
	p.compressed = &attr
}

func (p *MigrationOptions) Compressed() (InheritableBoolean, bool) {
	if p.compressed != nil {
		return *p.compressed, true
	}
	var zero InheritableBoolean
	return zero, false
}

func (p *MigrationOptions) MustCompressed() InheritableBoolean {
	if p.compressed == nil {
		panic("the compressed must not be nil, please use Compressed() function instead")
	}
	return *p.compressed
}

func (p *MigrationOptions) SetEncrypted(attr InheritableBoolean) {
	p.encrypted = &attr
}

func (p *MigrationOptions) Encrypted() (InheritableBoolean, bool) {
	if p.encrypted != nil {
		return *p.encrypted, true
	}
	var zero InheritableBoolean
	return zero, false
}

func (p *MigrationOptions) MustEncrypted() InheritableBoolean {
	if p.encrypted == nil {
		panic("the encrypted must not be nil, please use Encrypted() function instead")
	}
	return *p.encrypted
}

func (p *MigrationOptions) SetPolicy(attr *MigrationPolicy) {
	p.policy = attr
}

func (p *MigrationOptions) Policy() (*MigrationPolicy, bool) {
	if p.policy != nil {
		return p.policy, true
	}
	return nil, false
}

func (p *MigrationOptions) MustPolicy() *MigrationPolicy {
	if p.policy == nil {
		panic("the policy must not be nil, please use Policy() function instead")
	}
	return p.policy
}

type Range struct {
	Struct
	from *string
	to   *string
}

func (p *Range) SetFrom(attr string) {
	p.from = &attr
}

func (p *Range) From() (string, bool) {
	if p.from != nil {
		return *p.from, true
	}
	var zero string
	return zero, false
}

func (p *Range) MustFrom() string {
	if p.from == nil {
		panic("the from must not be nil, please use From() function instead")
	}
	return *p.from
}

func (p *Range) SetTo(attr string) {
	p.to = &attr
}

func (p *Range) To() (string, bool) {
	if p.to != nil {
		return *p.to, true
	}
	var zero string
	return zero, false
}

func (p *Range) MustTo() string {
	if p.to == nil {
		panic("the to must not be nil, please use To() function instead")
	}
	return *p.to
}

type VirtualNumaNode struct {
	Struct
	comment      *string
	cpu          *Cpu
	description  *string
	host         *Host
	id           *string
	index        *int64
	memory       *int64
	name         *string
	nodeDistance *string
	numaNodePins *NumaNodePinSlice
	statistics   *StatisticSlice
	vm           *Vm
}

func (p *VirtualNumaNode) SetComment(attr string) {
	p.comment = &attr
}

func (p *VirtualNumaNode) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *VirtualNumaNode) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *VirtualNumaNode) SetCpu(attr *Cpu) {
	p.cpu = attr
}

func (p *VirtualNumaNode) Cpu() (*Cpu, bool) {
	if p.cpu != nil {
		return p.cpu, true
	}
	return nil, false
}

func (p *VirtualNumaNode) MustCpu() *Cpu {
	if p.cpu == nil {
		panic("the cpu must not be nil, please use Cpu() function instead")
	}
	return p.cpu
}

func (p *VirtualNumaNode) SetDescription(attr string) {
	p.description = &attr
}

func (p *VirtualNumaNode) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *VirtualNumaNode) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *VirtualNumaNode) SetHost(attr *Host) {
	p.host = attr
}

func (p *VirtualNumaNode) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *VirtualNumaNode) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *VirtualNumaNode) SetId(attr string) {
	p.id = &attr
}

func (p *VirtualNumaNode) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *VirtualNumaNode) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *VirtualNumaNode) SetIndex(attr int64) {
	p.index = &attr
}

func (p *VirtualNumaNode) Index() (int64, bool) {
	if p.index != nil {
		return *p.index, true
	}
	var zero int64
	return zero, false
}

func (p *VirtualNumaNode) MustIndex() int64 {
	if p.index == nil {
		panic("the index must not be nil, please use Index() function instead")
	}
	return *p.index
}

func (p *VirtualNumaNode) SetMemory(attr int64) {
	p.memory = &attr
}

func (p *VirtualNumaNode) Memory() (int64, bool) {
	if p.memory != nil {
		return *p.memory, true
	}
	var zero int64
	return zero, false
}

func (p *VirtualNumaNode) MustMemory() int64 {
	if p.memory == nil {
		panic("the memory must not be nil, please use Memory() function instead")
	}
	return *p.memory
}

func (p *VirtualNumaNode) SetName(attr string) {
	p.name = &attr
}

func (p *VirtualNumaNode) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *VirtualNumaNode) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *VirtualNumaNode) SetNodeDistance(attr string) {
	p.nodeDistance = &attr
}

func (p *VirtualNumaNode) NodeDistance() (string, bool) {
	if p.nodeDistance != nil {
		return *p.nodeDistance, true
	}
	var zero string
	return zero, false
}

func (p *VirtualNumaNode) MustNodeDistance() string {
	if p.nodeDistance == nil {
		panic("the nodeDistance must not be nil, please use NodeDistance() function instead")
	}
	return *p.nodeDistance
}

func (p *VirtualNumaNode) SetNumaNodePins(attr *NumaNodePinSlice) {
	p.numaNodePins = attr
}

func (p *VirtualNumaNode) NumaNodePins() (*NumaNodePinSlice, bool) {
	if p.numaNodePins != nil {
		return p.numaNodePins, true
	}
	return nil, false
}

func (p *VirtualNumaNode) MustNumaNodePins() *NumaNodePinSlice {
	if p.numaNodePins == nil {
		panic("the numaNodePins must not be nil, please use NumaNodePins() function instead")
	}
	return p.numaNodePins
}

func (p *VirtualNumaNode) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *VirtualNumaNode) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *VirtualNumaNode) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *VirtualNumaNode) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *VirtualNumaNode) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *VirtualNumaNode) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type User struct {
	Struct
	comment       *string
	department    *string
	description   *string
	domain        *Domain
	domainEntryId *string
	email         *string
	groups        *GroupSlice
	id            *string
	lastName      *string
	loggedIn      *bool
	name          *string
	namespace     *string
	password      *string
	permissions   *PermissionSlice
	principal     *string
	roles         *RoleSlice
	sshPublicKeys *SshPublicKeySlice
	tags          *TagSlice
	userName      *string
	userOptions   *PropertySlice
}

func (p *User) SetComment(attr string) {
	p.comment = &attr
}

func (p *User) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *User) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *User) SetDepartment(attr string) {
	p.department = &attr
}

func (p *User) Department() (string, bool) {
	if p.department != nil {
		return *p.department, true
	}
	var zero string
	return zero, false
}

func (p *User) MustDepartment() string {
	if p.department == nil {
		panic("the department must not be nil, please use Department() function instead")
	}
	return *p.department
}

func (p *User) SetDescription(attr string) {
	p.description = &attr
}

func (p *User) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *User) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *User) SetDomain(attr *Domain) {
	p.domain = attr
}

func (p *User) Domain() (*Domain, bool) {
	if p.domain != nil {
		return p.domain, true
	}
	return nil, false
}

func (p *User) MustDomain() *Domain {
	if p.domain == nil {
		panic("the domain must not be nil, please use Domain() function instead")
	}
	return p.domain
}

func (p *User) SetDomainEntryId(attr string) {
	p.domainEntryId = &attr
}

func (p *User) DomainEntryId() (string, bool) {
	if p.domainEntryId != nil {
		return *p.domainEntryId, true
	}
	var zero string
	return zero, false
}

func (p *User) MustDomainEntryId() string {
	if p.domainEntryId == nil {
		panic("the domainEntryId must not be nil, please use DomainEntryId() function instead")
	}
	return *p.domainEntryId
}

func (p *User) SetEmail(attr string) {
	p.email = &attr
}

func (p *User) Email() (string, bool) {
	if p.email != nil {
		return *p.email, true
	}
	var zero string
	return zero, false
}

func (p *User) MustEmail() string {
	if p.email == nil {
		panic("the email must not be nil, please use Email() function instead")
	}
	return *p.email
}

func (p *User) SetGroups(attr *GroupSlice) {
	p.groups = attr
}

func (p *User) Groups() (*GroupSlice, bool) {
	if p.groups != nil {
		return p.groups, true
	}
	return nil, false
}

func (p *User) MustGroups() *GroupSlice {
	if p.groups == nil {
		panic("the groups must not be nil, please use Groups() function instead")
	}
	return p.groups
}

func (p *User) SetId(attr string) {
	p.id = &attr
}

func (p *User) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *User) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *User) SetLastName(attr string) {
	p.lastName = &attr
}

func (p *User) LastName() (string, bool) {
	if p.lastName != nil {
		return *p.lastName, true
	}
	var zero string
	return zero, false
}

func (p *User) MustLastName() string {
	if p.lastName == nil {
		panic("the lastName must not be nil, please use LastName() function instead")
	}
	return *p.lastName
}

func (p *User) SetLoggedIn(attr bool) {
	p.loggedIn = &attr
}

func (p *User) LoggedIn() (bool, bool) {
	if p.loggedIn != nil {
		return *p.loggedIn, true
	}
	var zero bool
	return zero, false
}

func (p *User) MustLoggedIn() bool {
	if p.loggedIn == nil {
		panic("the loggedIn must not be nil, please use LoggedIn() function instead")
	}
	return *p.loggedIn
}

func (p *User) SetName(attr string) {
	p.name = &attr
}

func (p *User) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *User) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *User) SetNamespace(attr string) {
	p.namespace = &attr
}

func (p *User) Namespace() (string, bool) {
	if p.namespace != nil {
		return *p.namespace, true
	}
	var zero string
	return zero, false
}

func (p *User) MustNamespace() string {
	if p.namespace == nil {
		panic("the namespace must not be nil, please use Namespace() function instead")
	}
	return *p.namespace
}

func (p *User) SetPassword(attr string) {
	p.password = &attr
}

func (p *User) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *User) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *User) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *User) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *User) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *User) SetPrincipal(attr string) {
	p.principal = &attr
}

func (p *User) Principal() (string, bool) {
	if p.principal != nil {
		return *p.principal, true
	}
	var zero string
	return zero, false
}

func (p *User) MustPrincipal() string {
	if p.principal == nil {
		panic("the principal must not be nil, please use Principal() function instead")
	}
	return *p.principal
}

func (p *User) SetRoles(attr *RoleSlice) {
	p.roles = attr
}

func (p *User) Roles() (*RoleSlice, bool) {
	if p.roles != nil {
		return p.roles, true
	}
	return nil, false
}

func (p *User) MustRoles() *RoleSlice {
	if p.roles == nil {
		panic("the roles must not be nil, please use Roles() function instead")
	}
	return p.roles
}

func (p *User) SetSshPublicKeys(attr *SshPublicKeySlice) {
	p.sshPublicKeys = attr
}

func (p *User) SshPublicKeys() (*SshPublicKeySlice, bool) {
	if p.sshPublicKeys != nil {
		return p.sshPublicKeys, true
	}
	return nil, false
}

func (p *User) MustSshPublicKeys() *SshPublicKeySlice {
	if p.sshPublicKeys == nil {
		panic("the sshPublicKeys must not be nil, please use SshPublicKeys() function instead")
	}
	return p.sshPublicKeys
}

func (p *User) SetTags(attr *TagSlice) {
	p.tags = attr
}

func (p *User) Tags() (*TagSlice, bool) {
	if p.tags != nil {
		return p.tags, true
	}
	return nil, false
}

func (p *User) MustTags() *TagSlice {
	if p.tags == nil {
		panic("the tags must not be nil, please use Tags() function instead")
	}
	return p.tags
}

func (p *User) SetUserName(attr string) {
	p.userName = &attr
}

func (p *User) UserName() (string, bool) {
	if p.userName != nil {
		return *p.userName, true
	}
	var zero string
	return zero, false
}

func (p *User) MustUserName() string {
	if p.userName == nil {
		panic("the userName must not be nil, please use UserName() function instead")
	}
	return *p.userName
}

func (p *User) SetUserOptions(attr *PropertySlice) {
	p.userOptions = attr
}

func (p *User) UserOptions() (*PropertySlice, bool) {
	if p.userOptions != nil {
		return p.userOptions, true
	}
	return nil, false
}

func (p *User) MustUserOptions() *PropertySlice {
	if p.userOptions == nil {
		panic("the userOptions must not be nil, please use UserOptions() function instead")
	}
	return p.userOptions
}

type Ssh struct {
	Struct
	authenticationMethod *SshAuthenticationMethod
	comment              *string
	description          *string
	fingerprint          *string
	id                   *string
	name                 *string
	port                 *int64
	user                 *User
}

func (p *Ssh) SetAuthenticationMethod(attr SshAuthenticationMethod) {
	p.authenticationMethod = &attr
}

func (p *Ssh) AuthenticationMethod() (SshAuthenticationMethod, bool) {
	if p.authenticationMethod != nil {
		return *p.authenticationMethod, true
	}
	var zero SshAuthenticationMethod
	return zero, false
}

func (p *Ssh) MustAuthenticationMethod() SshAuthenticationMethod {
	if p.authenticationMethod == nil {
		panic("the authenticationMethod must not be nil, please use AuthenticationMethod() function instead")
	}
	return *p.authenticationMethod
}

func (p *Ssh) SetComment(attr string) {
	p.comment = &attr
}

func (p *Ssh) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Ssh) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Ssh) SetDescription(attr string) {
	p.description = &attr
}

func (p *Ssh) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Ssh) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Ssh) SetFingerprint(attr string) {
	p.fingerprint = &attr
}

func (p *Ssh) Fingerprint() (string, bool) {
	if p.fingerprint != nil {
		return *p.fingerprint, true
	}
	var zero string
	return zero, false
}

func (p *Ssh) MustFingerprint() string {
	if p.fingerprint == nil {
		panic("the fingerprint must not be nil, please use Fingerprint() function instead")
	}
	return *p.fingerprint
}

func (p *Ssh) SetId(attr string) {
	p.id = &attr
}

func (p *Ssh) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Ssh) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Ssh) SetName(attr string) {
	p.name = &attr
}

func (p *Ssh) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Ssh) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Ssh) SetPort(attr int64) {
	p.port = &attr
}

func (p *Ssh) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *Ssh) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *Ssh) SetUser(attr *User) {
	p.user = attr
}

func (p *Ssh) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *Ssh) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

type Role struct {
	Struct
	administrative *bool
	comment        *string
	description    *string
	id             *string
	mutable        *bool
	name           *string
	permits        *PermitSlice
	user           *User
}

func (p *Role) SetAdministrative(attr bool) {
	p.administrative = &attr
}

func (p *Role) Administrative() (bool, bool) {
	if p.administrative != nil {
		return *p.administrative, true
	}
	var zero bool
	return zero, false
}

func (p *Role) MustAdministrative() bool {
	if p.administrative == nil {
		panic("the administrative must not be nil, please use Administrative() function instead")
	}
	return *p.administrative
}

func (p *Role) SetComment(attr string) {
	p.comment = &attr
}

func (p *Role) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Role) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Role) SetDescription(attr string) {
	p.description = &attr
}

func (p *Role) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Role) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Role) SetId(attr string) {
	p.id = &attr
}

func (p *Role) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Role) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Role) SetMutable(attr bool) {
	p.mutable = &attr
}

func (p *Role) Mutable() (bool, bool) {
	if p.mutable != nil {
		return *p.mutable, true
	}
	var zero bool
	return zero, false
}

func (p *Role) MustMutable() bool {
	if p.mutable == nil {
		panic("the mutable must not be nil, please use Mutable() function instead")
	}
	return *p.mutable
}

func (p *Role) SetName(attr string) {
	p.name = &attr
}

func (p *Role) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Role) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Role) SetPermits(attr *PermitSlice) {
	p.permits = attr
}

func (p *Role) Permits() (*PermitSlice, bool) {
	if p.permits != nil {
		return p.permits, true
	}
	return nil, false
}

func (p *Role) MustPermits() *PermitSlice {
	if p.permits == nil {
		panic("the permits must not be nil, please use Permits() function instead")
	}
	return p.permits
}

func (p *Role) SetUser(attr *User) {
	p.user = attr
}

func (p *Role) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *Role) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

type Product struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
}

func (p *Product) SetComment(attr string) {
	p.comment = &attr
}

func (p *Product) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Product) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Product) SetDescription(attr string) {
	p.description = &attr
}

func (p *Product) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Product) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Product) SetId(attr string) {
	p.id = &attr
}

func (p *Product) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Product) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Product) SetName(attr string) {
	p.name = &attr
}

func (p *Product) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Product) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type OpenStackVolumeType struct {
	Struct
	comment                 *string
	description             *string
	id                      *string
	name                    *string
	openstackVolumeProvider *OpenStackVolumeProvider
	properties              *PropertySlice
}

func (p *OpenStackVolumeType) SetComment(attr string) {
	p.comment = &attr
}

func (p *OpenStackVolumeType) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeType) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OpenStackVolumeType) SetDescription(attr string) {
	p.description = &attr
}

func (p *OpenStackVolumeType) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeType) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OpenStackVolumeType) SetId(attr string) {
	p.id = &attr
}

func (p *OpenStackVolumeType) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeType) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OpenStackVolumeType) SetName(attr string) {
	p.name = &attr
}

func (p *OpenStackVolumeType) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeType) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OpenStackVolumeType) SetOpenstackVolumeProvider(attr *OpenStackVolumeProvider) {
	p.openstackVolumeProvider = attr
}

func (p *OpenStackVolumeType) OpenstackVolumeProvider() (*OpenStackVolumeProvider, bool) {
	if p.openstackVolumeProvider != nil {
		return p.openstackVolumeProvider, true
	}
	return nil, false
}

func (p *OpenStackVolumeType) MustOpenstackVolumeProvider() *OpenStackVolumeProvider {
	if p.openstackVolumeProvider == nil {
		panic("the openstackVolumeProvider must not be nil, please use OpenstackVolumeProvider() function instead")
	}
	return p.openstackVolumeProvider
}

func (p *OpenStackVolumeType) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *OpenStackVolumeType) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *OpenStackVolumeType) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

type BootMenu struct {
	Struct
	enabled *bool
}

func (p *BootMenu) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *BootMenu) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *BootMenu) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

type Version struct {
	Struct
	build_      *int64
	comment     *string
	description *string
	fullVersion *string
	id          *string
	major       *int64
	minor       *int64
	name        *string
	revision    *int64
}

func (p *Version) SetBuild(attr int64) {
	p.build_ = &attr
}

func (p *Version) Build_() (int64, bool) {
	if p.build_ != nil {
		return *p.build_, true
	}
	var zero int64
	return zero, false
}

func (p *Version) MustBuild() int64 {
	if p.build_ == nil {
		panic("the build_ must not be nil, please use Build_() function instead")
	}
	return *p.build_
}

func (p *Version) SetComment(attr string) {
	p.comment = &attr
}

func (p *Version) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Version) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Version) SetDescription(attr string) {
	p.description = &attr
}

func (p *Version) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Version) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Version) SetFullVersion(attr string) {
	p.fullVersion = &attr
}

func (p *Version) FullVersion() (string, bool) {
	if p.fullVersion != nil {
		return *p.fullVersion, true
	}
	var zero string
	return zero, false
}

func (p *Version) MustFullVersion() string {
	if p.fullVersion == nil {
		panic("the fullVersion must not be nil, please use FullVersion() function instead")
	}
	return *p.fullVersion
}

func (p *Version) SetId(attr string) {
	p.id = &attr
}

func (p *Version) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Version) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Version) SetMajor(attr int64) {
	p.major = &attr
}

func (p *Version) Major() (int64, bool) {
	if p.major != nil {
		return *p.major, true
	}
	var zero int64
	return zero, false
}

func (p *Version) MustMajor() int64 {
	if p.major == nil {
		panic("the major must not be nil, please use Major() function instead")
	}
	return *p.major
}

func (p *Version) SetMinor(attr int64) {
	p.minor = &attr
}

func (p *Version) Minor() (int64, bool) {
	if p.minor != nil {
		return *p.minor, true
	}
	var zero int64
	return zero, false
}

func (p *Version) MustMinor() int64 {
	if p.minor == nil {
		panic("the minor must not be nil, please use Minor() function instead")
	}
	return *p.minor
}

func (p *Version) SetName(attr string) {
	p.name = &attr
}

func (p *Version) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Version) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Version) SetRevision(attr int64) {
	p.revision = &attr
}

func (p *Version) Revision() (int64, bool) {
	if p.revision != nil {
		return *p.revision, true
	}
	var zero int64
	return zero, false
}

func (p *Version) MustRevision() int64 {
	if p.revision == nil {
		panic("the revision must not be nil, please use Revision() function instead")
	}
	return *p.revision
}

type Watchdog struct {
	Struct
	action       *WatchdogAction
	comment      *string
	description  *string
	id           *string
	instanceType *InstanceType
	model        *WatchdogModel
	name         *string
	template     *Template
	vm           *Vm
	vms          *VmSlice
}

func (p *Watchdog) SetAction(attr WatchdogAction) {
	p.action = &attr
}

func (p *Watchdog) Action() (WatchdogAction, bool) {
	if p.action != nil {
		return *p.action, true
	}
	var zero WatchdogAction
	return zero, false
}

func (p *Watchdog) MustAction() WatchdogAction {
	if p.action == nil {
		panic("the action must not be nil, please use Action() function instead")
	}
	return *p.action
}

func (p *Watchdog) SetComment(attr string) {
	p.comment = &attr
}

func (p *Watchdog) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Watchdog) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Watchdog) SetDescription(attr string) {
	p.description = &attr
}

func (p *Watchdog) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Watchdog) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Watchdog) SetId(attr string) {
	p.id = &attr
}

func (p *Watchdog) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Watchdog) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Watchdog) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *Watchdog) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *Watchdog) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *Watchdog) SetModel(attr WatchdogModel) {
	p.model = &attr
}

func (p *Watchdog) Model() (WatchdogModel, bool) {
	if p.model != nil {
		return *p.model, true
	}
	var zero WatchdogModel
	return zero, false
}

func (p *Watchdog) MustModel() WatchdogModel {
	if p.model == nil {
		panic("the model must not be nil, please use Model() function instead")
	}
	return *p.model
}

func (p *Watchdog) SetName(attr string) {
	p.name = &attr
}

func (p *Watchdog) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Watchdog) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Watchdog) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Watchdog) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Watchdog) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Watchdog) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Watchdog) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Watchdog) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Watchdog) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *Watchdog) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *Watchdog) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

type StorageDomain struct {
	Struct
	available                  *int64
	backup                     *bool
	blockSize                  *int64
	comment                    *string
	committed                  *int64
	criticalSpaceActionBlocker *int64
	dataCenter                 *DataCenter
	dataCenters                *DataCenterSlice
	description                *string
	discardAfterDelete         *bool
	diskProfiles               *DiskProfileSlice
	diskSnapshots              *DiskSnapshotSlice
	disks                      *DiskSlice
	externalStatus             *ExternalStatus
	files                      *FileSlice
	host                       *Host
	id                         *string
	images                     *ImageSlice
	import_                    *bool
	master                     *bool
	name                       *string
	permissions                *PermissionSlice
	status                     *StorageDomainStatus
	storage                    *HostStorage
	storageConnections         *StorageConnectionSlice
	storageFormat              *StorageFormat
	supportsDiscard            *bool
	supportsDiscardZeroesData  *bool
	templates                  *TemplateSlice
	type_                      *StorageDomainType
	used                       *int64
	vms                        *VmSlice
	warningLowSpaceIndicator   *int64
	wipeAfterDelete            *bool
}

func (p *StorageDomain) SetAvailable(attr int64) {
	p.available = &attr
}

func (p *StorageDomain) Available() (int64, bool) {
	if p.available != nil {
		return *p.available, true
	}
	var zero int64
	return zero, false
}

func (p *StorageDomain) MustAvailable() int64 {
	if p.available == nil {
		panic("the available must not be nil, please use Available() function instead")
	}
	return *p.available
}

func (p *StorageDomain) SetBackup(attr bool) {
	p.backup = &attr
}

func (p *StorageDomain) Backup() (bool, bool) {
	if p.backup != nil {
		return *p.backup, true
	}
	var zero bool
	return zero, false
}

func (p *StorageDomain) MustBackup() bool {
	if p.backup == nil {
		panic("the backup must not be nil, please use Backup() function instead")
	}
	return *p.backup
}

func (p *StorageDomain) SetBlockSize(attr int64) {
	p.blockSize = &attr
}

func (p *StorageDomain) BlockSize() (int64, bool) {
	if p.blockSize != nil {
		return *p.blockSize, true
	}
	var zero int64
	return zero, false
}

func (p *StorageDomain) MustBlockSize() int64 {
	if p.blockSize == nil {
		panic("the blockSize must not be nil, please use BlockSize() function instead")
	}
	return *p.blockSize
}

func (p *StorageDomain) SetComment(attr string) {
	p.comment = &attr
}

func (p *StorageDomain) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *StorageDomain) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *StorageDomain) SetCommitted(attr int64) {
	p.committed = &attr
}

func (p *StorageDomain) Committed() (int64, bool) {
	if p.committed != nil {
		return *p.committed, true
	}
	var zero int64
	return zero, false
}

func (p *StorageDomain) MustCommitted() int64 {
	if p.committed == nil {
		panic("the committed must not be nil, please use Committed() function instead")
	}
	return *p.committed
}

func (p *StorageDomain) SetCriticalSpaceActionBlocker(attr int64) {
	p.criticalSpaceActionBlocker = &attr
}

func (p *StorageDomain) CriticalSpaceActionBlocker() (int64, bool) {
	if p.criticalSpaceActionBlocker != nil {
		return *p.criticalSpaceActionBlocker, true
	}
	var zero int64
	return zero, false
}

func (p *StorageDomain) MustCriticalSpaceActionBlocker() int64 {
	if p.criticalSpaceActionBlocker == nil {
		panic("the criticalSpaceActionBlocker must not be nil, please use CriticalSpaceActionBlocker() function instead")
	}
	return *p.criticalSpaceActionBlocker
}

func (p *StorageDomain) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *StorageDomain) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *StorageDomain) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *StorageDomain) SetDataCenters(attr *DataCenterSlice) {
	p.dataCenters = attr
}

func (p *StorageDomain) DataCenters() (*DataCenterSlice, bool) {
	if p.dataCenters != nil {
		return p.dataCenters, true
	}
	return nil, false
}

func (p *StorageDomain) MustDataCenters() *DataCenterSlice {
	if p.dataCenters == nil {
		panic("the dataCenters must not be nil, please use DataCenters() function instead")
	}
	return p.dataCenters
}

func (p *StorageDomain) SetDescription(attr string) {
	p.description = &attr
}

func (p *StorageDomain) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *StorageDomain) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *StorageDomain) SetDiscardAfterDelete(attr bool) {
	p.discardAfterDelete = &attr
}

func (p *StorageDomain) DiscardAfterDelete() (bool, bool) {
	if p.discardAfterDelete != nil {
		return *p.discardAfterDelete, true
	}
	var zero bool
	return zero, false
}

func (p *StorageDomain) MustDiscardAfterDelete() bool {
	if p.discardAfterDelete == nil {
		panic("the discardAfterDelete must not be nil, please use DiscardAfterDelete() function instead")
	}
	return *p.discardAfterDelete
}

func (p *StorageDomain) SetDiskProfiles(attr *DiskProfileSlice) {
	p.diskProfiles = attr
}

func (p *StorageDomain) DiskProfiles() (*DiskProfileSlice, bool) {
	if p.diskProfiles != nil {
		return p.diskProfiles, true
	}
	return nil, false
}

func (p *StorageDomain) MustDiskProfiles() *DiskProfileSlice {
	if p.diskProfiles == nil {
		panic("the diskProfiles must not be nil, please use DiskProfiles() function instead")
	}
	return p.diskProfiles
}

func (p *StorageDomain) SetDiskSnapshots(attr *DiskSnapshotSlice) {
	p.diskSnapshots = attr
}

func (p *StorageDomain) DiskSnapshots() (*DiskSnapshotSlice, bool) {
	if p.diskSnapshots != nil {
		return p.diskSnapshots, true
	}
	return nil, false
}

func (p *StorageDomain) MustDiskSnapshots() *DiskSnapshotSlice {
	if p.diskSnapshots == nil {
		panic("the diskSnapshots must not be nil, please use DiskSnapshots() function instead")
	}
	return p.diskSnapshots
}

func (p *StorageDomain) SetDisks(attr *DiskSlice) {
	p.disks = attr
}

func (p *StorageDomain) Disks() (*DiskSlice, bool) {
	if p.disks != nil {
		return p.disks, true
	}
	return nil, false
}

func (p *StorageDomain) MustDisks() *DiskSlice {
	if p.disks == nil {
		panic("the disks must not be nil, please use Disks() function instead")
	}
	return p.disks
}

func (p *StorageDomain) SetExternalStatus(attr ExternalStatus) {
	p.externalStatus = &attr
}

func (p *StorageDomain) ExternalStatus() (ExternalStatus, bool) {
	if p.externalStatus != nil {
		return *p.externalStatus, true
	}
	var zero ExternalStatus
	return zero, false
}

func (p *StorageDomain) MustExternalStatus() ExternalStatus {
	if p.externalStatus == nil {
		panic("the externalStatus must not be nil, please use ExternalStatus() function instead")
	}
	return *p.externalStatus
}

func (p *StorageDomain) SetFiles(attr *FileSlice) {
	p.files = attr
}

func (p *StorageDomain) Files() (*FileSlice, bool) {
	if p.files != nil {
		return p.files, true
	}
	return nil, false
}

func (p *StorageDomain) MustFiles() *FileSlice {
	if p.files == nil {
		panic("the files must not be nil, please use Files() function instead")
	}
	return p.files
}

func (p *StorageDomain) SetHost(attr *Host) {
	p.host = attr
}

func (p *StorageDomain) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *StorageDomain) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *StorageDomain) SetId(attr string) {
	p.id = &attr
}

func (p *StorageDomain) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *StorageDomain) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *StorageDomain) SetImages(attr *ImageSlice) {
	p.images = attr
}

func (p *StorageDomain) Images() (*ImageSlice, bool) {
	if p.images != nil {
		return p.images, true
	}
	return nil, false
}

func (p *StorageDomain) MustImages() *ImageSlice {
	if p.images == nil {
		panic("the images must not be nil, please use Images() function instead")
	}
	return p.images
}

func (p *StorageDomain) SetImport(attr bool) {
	p.import_ = &attr
}

func (p *StorageDomain) Import() (bool, bool) {
	if p.import_ != nil {
		return *p.import_, true
	}
	var zero bool
	return zero, false
}

func (p *StorageDomain) MustImport() bool {
	if p.import_ == nil {
		panic("the import_ must not be nil, please use Import() function instead")
	}
	return *p.import_
}

func (p *StorageDomain) SetMaster(attr bool) {
	p.master = &attr
}

func (p *StorageDomain) Master() (bool, bool) {
	if p.master != nil {
		return *p.master, true
	}
	var zero bool
	return zero, false
}

func (p *StorageDomain) MustMaster() bool {
	if p.master == nil {
		panic("the master must not be nil, please use Master() function instead")
	}
	return *p.master
}

func (p *StorageDomain) SetName(attr string) {
	p.name = &attr
}

func (p *StorageDomain) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *StorageDomain) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *StorageDomain) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *StorageDomain) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *StorageDomain) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *StorageDomain) SetStatus(attr StorageDomainStatus) {
	p.status = &attr
}

func (p *StorageDomain) Status() (StorageDomainStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero StorageDomainStatus
	return zero, false
}

func (p *StorageDomain) MustStatus() StorageDomainStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *StorageDomain) SetStorage(attr *HostStorage) {
	p.storage = attr
}

func (p *StorageDomain) Storage() (*HostStorage, bool) {
	if p.storage != nil {
		return p.storage, true
	}
	return nil, false
}

func (p *StorageDomain) MustStorage() *HostStorage {
	if p.storage == nil {
		panic("the storage must not be nil, please use Storage() function instead")
	}
	return p.storage
}

func (p *StorageDomain) SetStorageConnections(attr *StorageConnectionSlice) {
	p.storageConnections = attr
}

func (p *StorageDomain) StorageConnections() (*StorageConnectionSlice, bool) {
	if p.storageConnections != nil {
		return p.storageConnections, true
	}
	return nil, false
}

func (p *StorageDomain) MustStorageConnections() *StorageConnectionSlice {
	if p.storageConnections == nil {
		panic("the storageConnections must not be nil, please use StorageConnections() function instead")
	}
	return p.storageConnections
}

func (p *StorageDomain) SetStorageFormat(attr StorageFormat) {
	p.storageFormat = &attr
}

func (p *StorageDomain) StorageFormat() (StorageFormat, bool) {
	if p.storageFormat != nil {
		return *p.storageFormat, true
	}
	var zero StorageFormat
	return zero, false
}

func (p *StorageDomain) MustStorageFormat() StorageFormat {
	if p.storageFormat == nil {
		panic("the storageFormat must not be nil, please use StorageFormat() function instead")
	}
	return *p.storageFormat
}

func (p *StorageDomain) SetSupportsDiscard(attr bool) {
	p.supportsDiscard = &attr
}

func (p *StorageDomain) SupportsDiscard() (bool, bool) {
	if p.supportsDiscard != nil {
		return *p.supportsDiscard, true
	}
	var zero bool
	return zero, false
}

func (p *StorageDomain) MustSupportsDiscard() bool {
	if p.supportsDiscard == nil {
		panic("the supportsDiscard must not be nil, please use SupportsDiscard() function instead")
	}
	return *p.supportsDiscard
}

func (p *StorageDomain) SetSupportsDiscardZeroesData(attr bool) {
	p.supportsDiscardZeroesData = &attr
}

func (p *StorageDomain) SupportsDiscardZeroesData() (bool, bool) {
	if p.supportsDiscardZeroesData != nil {
		return *p.supportsDiscardZeroesData, true
	}
	var zero bool
	return zero, false
}

func (p *StorageDomain) MustSupportsDiscardZeroesData() bool {
	if p.supportsDiscardZeroesData == nil {
		panic("the supportsDiscardZeroesData must not be nil, please use SupportsDiscardZeroesData() function instead")
	}
	return *p.supportsDiscardZeroesData
}

func (p *StorageDomain) SetTemplates(attr *TemplateSlice) {
	p.templates = attr
}

func (p *StorageDomain) Templates() (*TemplateSlice, bool) {
	if p.templates != nil {
		return p.templates, true
	}
	return nil, false
}

func (p *StorageDomain) MustTemplates() *TemplateSlice {
	if p.templates == nil {
		panic("the templates must not be nil, please use Templates() function instead")
	}
	return p.templates
}

func (p *StorageDomain) SetType(attr StorageDomainType) {
	p.type_ = &attr
}

func (p *StorageDomain) Type() (StorageDomainType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero StorageDomainType
	return zero, false
}

func (p *StorageDomain) MustType() StorageDomainType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *StorageDomain) SetUsed(attr int64) {
	p.used = &attr
}

func (p *StorageDomain) Used() (int64, bool) {
	if p.used != nil {
		return *p.used, true
	}
	var zero int64
	return zero, false
}

func (p *StorageDomain) MustUsed() int64 {
	if p.used == nil {
		panic("the used must not be nil, please use Used() function instead")
	}
	return *p.used
}

func (p *StorageDomain) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *StorageDomain) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *StorageDomain) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

func (p *StorageDomain) SetWarningLowSpaceIndicator(attr int64) {
	p.warningLowSpaceIndicator = &attr
}

func (p *StorageDomain) WarningLowSpaceIndicator() (int64, bool) {
	if p.warningLowSpaceIndicator != nil {
		return *p.warningLowSpaceIndicator, true
	}
	var zero int64
	return zero, false
}

func (p *StorageDomain) MustWarningLowSpaceIndicator() int64 {
	if p.warningLowSpaceIndicator == nil {
		panic("the warningLowSpaceIndicator must not be nil, please use WarningLowSpaceIndicator() function instead")
	}
	return *p.warningLowSpaceIndicator
}

func (p *StorageDomain) SetWipeAfterDelete(attr bool) {
	p.wipeAfterDelete = &attr
}

func (p *StorageDomain) WipeAfterDelete() (bool, bool) {
	if p.wipeAfterDelete != nil {
		return *p.wipeAfterDelete, true
	}
	var zero bool
	return zero, false
}

func (p *StorageDomain) MustWipeAfterDelete() bool {
	if p.wipeAfterDelete == nil {
		panic("the wipeAfterDelete must not be nil, please use WipeAfterDelete() function instead")
	}
	return *p.wipeAfterDelete
}

type KatelloErratum struct {
	Struct
	comment     *string
	description *string
	host        *Host
	id          *string
	issued      *time.Time
	name        *string
	packages    *PackageSlice
	severity    *string
	solution    *string
	summary     *string
	title       *string
	type_       *string
	vm          *Vm
}

func (p *KatelloErratum) SetComment(attr string) {
	p.comment = &attr
}

func (p *KatelloErratum) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *KatelloErratum) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *KatelloErratum) SetDescription(attr string) {
	p.description = &attr
}

func (p *KatelloErratum) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *KatelloErratum) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *KatelloErratum) SetHost(attr *Host) {
	p.host = attr
}

func (p *KatelloErratum) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *KatelloErratum) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *KatelloErratum) SetId(attr string) {
	p.id = &attr
}

func (p *KatelloErratum) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *KatelloErratum) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *KatelloErratum) SetIssued(attr time.Time) {
	p.issued = &attr
}

func (p *KatelloErratum) Issued() (time.Time, bool) {
	if p.issued != nil {
		return *p.issued, true
	}
	var zero time.Time
	return zero, false
}

func (p *KatelloErratum) MustIssued() time.Time {
	if p.issued == nil {
		panic("the issued must not be nil, please use Issued() function instead")
	}
	return *p.issued
}

func (p *KatelloErratum) SetName(attr string) {
	p.name = &attr
}

func (p *KatelloErratum) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *KatelloErratum) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *KatelloErratum) SetPackages(attr *PackageSlice) {
	p.packages = attr
}

func (p *KatelloErratum) Packages() (*PackageSlice, bool) {
	if p.packages != nil {
		return p.packages, true
	}
	return nil, false
}

func (p *KatelloErratum) MustPackages() *PackageSlice {
	if p.packages == nil {
		panic("the packages must not be nil, please use Packages() function instead")
	}
	return p.packages
}

func (p *KatelloErratum) SetSeverity(attr string) {
	p.severity = &attr
}

func (p *KatelloErratum) Severity() (string, bool) {
	if p.severity != nil {
		return *p.severity, true
	}
	var zero string
	return zero, false
}

func (p *KatelloErratum) MustSeverity() string {
	if p.severity == nil {
		panic("the severity must not be nil, please use Severity() function instead")
	}
	return *p.severity
}

func (p *KatelloErratum) SetSolution(attr string) {
	p.solution = &attr
}

func (p *KatelloErratum) Solution() (string, bool) {
	if p.solution != nil {
		return *p.solution, true
	}
	var zero string
	return zero, false
}

func (p *KatelloErratum) MustSolution() string {
	if p.solution == nil {
		panic("the solution must not be nil, please use Solution() function instead")
	}
	return *p.solution
}

func (p *KatelloErratum) SetSummary(attr string) {
	p.summary = &attr
}

func (p *KatelloErratum) Summary() (string, bool) {
	if p.summary != nil {
		return *p.summary, true
	}
	var zero string
	return zero, false
}

func (p *KatelloErratum) MustSummary() string {
	if p.summary == nil {
		panic("the summary must not be nil, please use Summary() function instead")
	}
	return *p.summary
}

func (p *KatelloErratum) SetTitle(attr string) {
	p.title = &attr
}

func (p *KatelloErratum) Title() (string, bool) {
	if p.title != nil {
		return *p.title, true
	}
	var zero string
	return zero, false
}

func (p *KatelloErratum) MustTitle() string {
	if p.title == nil {
		panic("the title must not be nil, please use Title() function instead")
	}
	return *p.title
}

func (p *KatelloErratum) SetType(attr string) {
	p.type_ = &attr
}

func (p *KatelloErratum) Type() (string, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero string
	return zero, false
}

func (p *KatelloErratum) MustType() string {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *KatelloErratum) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *KatelloErratum) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *KatelloErratum) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type MemoryOverCommit struct {
	Struct
	percent *int64
}

func (p *MemoryOverCommit) SetPercent(attr int64) {
	p.percent = &attr
}

func (p *MemoryOverCommit) Percent() (int64, bool) {
	if p.percent != nil {
		return *p.percent, true
	}
	var zero int64
	return zero, false
}

func (p *MemoryOverCommit) MustPercent() int64 {
	if p.percent == nil {
		panic("the percent must not be nil, please use Percent() function instead")
	}
	return *p.percent
}

type MDevType struct {
	Struct
	availableInstances *int64
	description        *string
	name               *string
}

func (p *MDevType) SetAvailableInstances(attr int64) {
	p.availableInstances = &attr
}

func (p *MDevType) AvailableInstances() (int64, bool) {
	if p.availableInstances != nil {
		return *p.availableInstances, true
	}
	var zero int64
	return zero, false
}

func (p *MDevType) MustAvailableInstances() int64 {
	if p.availableInstances == nil {
		panic("the availableInstances must not be nil, please use AvailableInstances() function instead")
	}
	return *p.availableInstances
}

func (p *MDevType) SetDescription(attr string) {
	p.description = &attr
}

func (p *MDevType) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *MDevType) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *MDevType) SetName(attr string) {
	p.name = &attr
}

func (p *MDevType) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *MDevType) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type TemplateVersion struct {
	Struct
	baseTemplate  *Template
	versionName   *string
	versionNumber *int64
}

func (p *TemplateVersion) SetBaseTemplate(attr *Template) {
	p.baseTemplate = attr
}

func (p *TemplateVersion) BaseTemplate() (*Template, bool) {
	if p.baseTemplate != nil {
		return p.baseTemplate, true
	}
	return nil, false
}

func (p *TemplateVersion) MustBaseTemplate() *Template {
	if p.baseTemplate == nil {
		panic("the baseTemplate must not be nil, please use BaseTemplate() function instead")
	}
	return p.baseTemplate
}

func (p *TemplateVersion) SetVersionName(attr string) {
	p.versionName = &attr
}

func (p *TemplateVersion) VersionName() (string, bool) {
	if p.versionName != nil {
		return *p.versionName, true
	}
	var zero string
	return zero, false
}

func (p *TemplateVersion) MustVersionName() string {
	if p.versionName == nil {
		panic("the versionName must not be nil, please use VersionName() function instead")
	}
	return *p.versionName
}

func (p *TemplateVersion) SetVersionNumber(attr int64) {
	p.versionNumber = &attr
}

func (p *TemplateVersion) VersionNumber() (int64, bool) {
	if p.versionNumber != nil {
		return *p.versionNumber, true
	}
	var zero int64
	return zero, false
}

func (p *TemplateVersion) MustVersionNumber() int64 {
	if p.versionNumber == nil {
		panic("the versionNumber must not be nil, please use VersionNumber() function instead")
	}
	return *p.versionNumber
}

type StorageConnectionExtension struct {
	Struct
	comment     *string
	description *string
	host        *Host
	id          *string
	name        *string
	password    *string
	target      *string
	username    *string
}

func (p *StorageConnectionExtension) SetComment(attr string) {
	p.comment = &attr
}

func (p *StorageConnectionExtension) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnectionExtension) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *StorageConnectionExtension) SetDescription(attr string) {
	p.description = &attr
}

func (p *StorageConnectionExtension) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnectionExtension) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *StorageConnectionExtension) SetHost(attr *Host) {
	p.host = attr
}

func (p *StorageConnectionExtension) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *StorageConnectionExtension) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *StorageConnectionExtension) SetId(attr string) {
	p.id = &attr
}

func (p *StorageConnectionExtension) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnectionExtension) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *StorageConnectionExtension) SetName(attr string) {
	p.name = &attr
}

func (p *StorageConnectionExtension) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnectionExtension) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *StorageConnectionExtension) SetPassword(attr string) {
	p.password = &attr
}

func (p *StorageConnectionExtension) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnectionExtension) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *StorageConnectionExtension) SetTarget(attr string) {
	p.target = &attr
}

func (p *StorageConnectionExtension) Target() (string, bool) {
	if p.target != nil {
		return *p.target, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnectionExtension) MustTarget() string {
	if p.target == nil {
		panic("the target must not be nil, please use Target() function instead")
	}
	return *p.target
}

func (p *StorageConnectionExtension) SetUsername(attr string) {
	p.username = &attr
}

func (p *StorageConnectionExtension) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnectionExtension) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

type Core struct {
	Struct
	index  *int64
	socket *int64
}

func (p *Core) SetIndex(attr int64) {
	p.index = &attr
}

func (p *Core) Index() (int64, bool) {
	if p.index != nil {
		return *p.index, true
	}
	var zero int64
	return zero, false
}

func (p *Core) MustIndex() int64 {
	if p.index == nil {
		panic("the index must not be nil, please use Index() function instead")
	}
	return *p.index
}

func (p *Core) SetSocket(attr int64) {
	p.socket = &attr
}

func (p *Core) Socket() (int64, bool) {
	if p.socket != nil {
		return *p.socket, true
	}
	var zero int64
	return zero, false
}

func (p *Core) MustSocket() int64 {
	if p.socket == nil {
		panic("the socket must not be nil, please use Socket() function instead")
	}
	return *p.socket
}

type VcpuPin struct {
	Struct
	cpuSet *string
	vcpu   *int64
}

func (p *VcpuPin) SetCpuSet(attr string) {
	p.cpuSet = &attr
}

func (p *VcpuPin) CpuSet() (string, bool) {
	if p.cpuSet != nil {
		return *p.cpuSet, true
	}
	var zero string
	return zero, false
}

func (p *VcpuPin) MustCpuSet() string {
	if p.cpuSet == nil {
		panic("the cpuSet must not be nil, please use CpuSet() function instead")
	}
	return *p.cpuSet
}

func (p *VcpuPin) SetVcpu(attr int64) {
	p.vcpu = &attr
}

func (p *VcpuPin) Vcpu() (int64, bool) {
	if p.vcpu != nil {
		return *p.vcpu, true
	}
	var zero int64
	return zero, false
}

func (p *VcpuPin) MustVcpu() int64 {
	if p.vcpu == nil {
		panic("the vcpu must not be nil, please use Vcpu() function instead")
	}
	return *p.vcpu
}

type Template struct {
	Struct
	bios                        *Bios
	cdroms                      *CdromSlice
	cluster                     *Cluster
	comment                     *string
	console                     *Console
	cpu                         *Cpu
	cpuProfile                  *CpuProfile
	cpuShares                   *int64
	creationTime                *time.Time
	customCompatibilityVersion  *Version
	customCpuModel              *string
	customEmulatedMachine       *string
	customProperties            *CustomPropertySlice
	deleteProtected             *bool
	description                 *string
	diskAttachments             *DiskAttachmentSlice
	display                     *Display
	domain                      *Domain
	graphicsConsoles            *GraphicsConsoleSlice
	highAvailability            *HighAvailability
	id                          *string
	initialization              *Initialization
	io                          *Io
	largeIcon                   *Icon
	lease                       *StorageDomainLease
	memory                      *int64
	memoryPolicy                *MemoryPolicy
	migration                   *MigrationOptions
	migrationDowntime           *int64
	multiQueuesEnabled          *bool
	name                        *string
	nics                        *NicSlice
	origin                      *string
	os                          *OperatingSystem
	permissions                 *PermissionSlice
	placementPolicy             *VmPlacementPolicy
	quota                       *Quota
	rngDevice                   *RngDevice
	serialNumber                *SerialNumber
	smallIcon                   *Icon
	soundcardEnabled            *bool
	sso                         *Sso
	startPaused                 *bool
	stateless                   *bool
	status                      *TemplateStatus
	storageDomain               *StorageDomain
	storageErrorResumeBehaviour *VmStorageErrorResumeBehaviour
	tags                        *TagSlice
	timeZone                    *TimeZone
	tunnelMigration             *bool
	type_                       *VmType
	usb                         *Usb
	version                     *TemplateVersion
	virtioScsi                  *VirtioScsi
	vm                          *Vm
	watchdogs                   *WatchdogSlice
}

func (p *Template) SetBios(attr *Bios) {
	p.bios = attr
}

func (p *Template) Bios() (*Bios, bool) {
	if p.bios != nil {
		return p.bios, true
	}
	return nil, false
}

func (p *Template) MustBios() *Bios {
	if p.bios == nil {
		panic("the bios must not be nil, please use Bios() function instead")
	}
	return p.bios
}

func (p *Template) SetCdroms(attr *CdromSlice) {
	p.cdroms = attr
}

func (p *Template) Cdroms() (*CdromSlice, bool) {
	if p.cdroms != nil {
		return p.cdroms, true
	}
	return nil, false
}

func (p *Template) MustCdroms() *CdromSlice {
	if p.cdroms == nil {
		panic("the cdroms must not be nil, please use Cdroms() function instead")
	}
	return p.cdroms
}

func (p *Template) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *Template) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *Template) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *Template) SetComment(attr string) {
	p.comment = &attr
}

func (p *Template) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Template) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Template) SetConsole(attr *Console) {
	p.console = attr
}

func (p *Template) Console() (*Console, bool) {
	if p.console != nil {
		return p.console, true
	}
	return nil, false
}

func (p *Template) MustConsole() *Console {
	if p.console == nil {
		panic("the console must not be nil, please use Console() function instead")
	}
	return p.console
}

func (p *Template) SetCpu(attr *Cpu) {
	p.cpu = attr
}

func (p *Template) Cpu() (*Cpu, bool) {
	if p.cpu != nil {
		return p.cpu, true
	}
	return nil, false
}

func (p *Template) MustCpu() *Cpu {
	if p.cpu == nil {
		panic("the cpu must not be nil, please use Cpu() function instead")
	}
	return p.cpu
}

func (p *Template) SetCpuProfile(attr *CpuProfile) {
	p.cpuProfile = attr
}

func (p *Template) CpuProfile() (*CpuProfile, bool) {
	if p.cpuProfile != nil {
		return p.cpuProfile, true
	}
	return nil, false
}

func (p *Template) MustCpuProfile() *CpuProfile {
	if p.cpuProfile == nil {
		panic("the cpuProfile must not be nil, please use CpuProfile() function instead")
	}
	return p.cpuProfile
}

func (p *Template) SetCpuShares(attr int64) {
	p.cpuShares = &attr
}

func (p *Template) CpuShares() (int64, bool) {
	if p.cpuShares != nil {
		return *p.cpuShares, true
	}
	var zero int64
	return zero, false
}

func (p *Template) MustCpuShares() int64 {
	if p.cpuShares == nil {
		panic("the cpuShares must not be nil, please use CpuShares() function instead")
	}
	return *p.cpuShares
}

func (p *Template) SetCreationTime(attr time.Time) {
	p.creationTime = &attr
}

func (p *Template) CreationTime() (time.Time, bool) {
	if p.creationTime != nil {
		return *p.creationTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Template) MustCreationTime() time.Time {
	if p.creationTime == nil {
		panic("the creationTime must not be nil, please use CreationTime() function instead")
	}
	return *p.creationTime
}

func (p *Template) SetCustomCompatibilityVersion(attr *Version) {
	p.customCompatibilityVersion = attr
}

func (p *Template) CustomCompatibilityVersion() (*Version, bool) {
	if p.customCompatibilityVersion != nil {
		return p.customCompatibilityVersion, true
	}
	return nil, false
}

func (p *Template) MustCustomCompatibilityVersion() *Version {
	if p.customCompatibilityVersion == nil {
		panic("the customCompatibilityVersion must not be nil, please use CustomCompatibilityVersion() function instead")
	}
	return p.customCompatibilityVersion
}

func (p *Template) SetCustomCpuModel(attr string) {
	p.customCpuModel = &attr
}

func (p *Template) CustomCpuModel() (string, bool) {
	if p.customCpuModel != nil {
		return *p.customCpuModel, true
	}
	var zero string
	return zero, false
}

func (p *Template) MustCustomCpuModel() string {
	if p.customCpuModel == nil {
		panic("the customCpuModel must not be nil, please use CustomCpuModel() function instead")
	}
	return *p.customCpuModel
}

func (p *Template) SetCustomEmulatedMachine(attr string) {
	p.customEmulatedMachine = &attr
}

func (p *Template) CustomEmulatedMachine() (string, bool) {
	if p.customEmulatedMachine != nil {
		return *p.customEmulatedMachine, true
	}
	var zero string
	return zero, false
}

func (p *Template) MustCustomEmulatedMachine() string {
	if p.customEmulatedMachine == nil {
		panic("the customEmulatedMachine must not be nil, please use CustomEmulatedMachine() function instead")
	}
	return *p.customEmulatedMachine
}

func (p *Template) SetCustomProperties(attr *CustomPropertySlice) {
	p.customProperties = attr
}

func (p *Template) CustomProperties() (*CustomPropertySlice, bool) {
	if p.customProperties != nil {
		return p.customProperties, true
	}
	return nil, false
}

func (p *Template) MustCustomProperties() *CustomPropertySlice {
	if p.customProperties == nil {
		panic("the customProperties must not be nil, please use CustomProperties() function instead")
	}
	return p.customProperties
}

func (p *Template) SetDeleteProtected(attr bool) {
	p.deleteProtected = &attr
}

func (p *Template) DeleteProtected() (bool, bool) {
	if p.deleteProtected != nil {
		return *p.deleteProtected, true
	}
	var zero bool
	return zero, false
}

func (p *Template) MustDeleteProtected() bool {
	if p.deleteProtected == nil {
		panic("the deleteProtected must not be nil, please use DeleteProtected() function instead")
	}
	return *p.deleteProtected
}

func (p *Template) SetDescription(attr string) {
	p.description = &attr
}

func (p *Template) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Template) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Template) SetDiskAttachments(attr *DiskAttachmentSlice) {
	p.diskAttachments = attr
}

func (p *Template) DiskAttachments() (*DiskAttachmentSlice, bool) {
	if p.diskAttachments != nil {
		return p.diskAttachments, true
	}
	return nil, false
}

func (p *Template) MustDiskAttachments() *DiskAttachmentSlice {
	if p.diskAttachments == nil {
		panic("the diskAttachments must not be nil, please use DiskAttachments() function instead")
	}
	return p.diskAttachments
}

func (p *Template) SetDisplay(attr *Display) {
	p.display = attr
}

func (p *Template) Display() (*Display, bool) {
	if p.display != nil {
		return p.display, true
	}
	return nil, false
}

func (p *Template) MustDisplay() *Display {
	if p.display == nil {
		panic("the display must not be nil, please use Display() function instead")
	}
	return p.display
}

func (p *Template) SetDomain(attr *Domain) {
	p.domain = attr
}

func (p *Template) Domain() (*Domain, bool) {
	if p.domain != nil {
		return p.domain, true
	}
	return nil, false
}

func (p *Template) MustDomain() *Domain {
	if p.domain == nil {
		panic("the domain must not be nil, please use Domain() function instead")
	}
	return p.domain
}

func (p *Template) SetGraphicsConsoles(attr *GraphicsConsoleSlice) {
	p.graphicsConsoles = attr
}

func (p *Template) GraphicsConsoles() (*GraphicsConsoleSlice, bool) {
	if p.graphicsConsoles != nil {
		return p.graphicsConsoles, true
	}
	return nil, false
}

func (p *Template) MustGraphicsConsoles() *GraphicsConsoleSlice {
	if p.graphicsConsoles == nil {
		panic("the graphicsConsoles must not be nil, please use GraphicsConsoles() function instead")
	}
	return p.graphicsConsoles
}

func (p *Template) SetHighAvailability(attr *HighAvailability) {
	p.highAvailability = attr
}

func (p *Template) HighAvailability() (*HighAvailability, bool) {
	if p.highAvailability != nil {
		return p.highAvailability, true
	}
	return nil, false
}

func (p *Template) MustHighAvailability() *HighAvailability {
	if p.highAvailability == nil {
		panic("the highAvailability must not be nil, please use HighAvailability() function instead")
	}
	return p.highAvailability
}

func (p *Template) SetId(attr string) {
	p.id = &attr
}

func (p *Template) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Template) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Template) SetInitialization(attr *Initialization) {
	p.initialization = attr
}

func (p *Template) Initialization() (*Initialization, bool) {
	if p.initialization != nil {
		return p.initialization, true
	}
	return nil, false
}

func (p *Template) MustInitialization() *Initialization {
	if p.initialization == nil {
		panic("the initialization must not be nil, please use Initialization() function instead")
	}
	return p.initialization
}

func (p *Template) SetIo(attr *Io) {
	p.io = attr
}

func (p *Template) Io() (*Io, bool) {
	if p.io != nil {
		return p.io, true
	}
	return nil, false
}

func (p *Template) MustIo() *Io {
	if p.io == nil {
		panic("the io must not be nil, please use Io() function instead")
	}
	return p.io
}

func (p *Template) SetLargeIcon(attr *Icon) {
	p.largeIcon = attr
}

func (p *Template) LargeIcon() (*Icon, bool) {
	if p.largeIcon != nil {
		return p.largeIcon, true
	}
	return nil, false
}

func (p *Template) MustLargeIcon() *Icon {
	if p.largeIcon == nil {
		panic("the largeIcon must not be nil, please use LargeIcon() function instead")
	}
	return p.largeIcon
}

func (p *Template) SetLease(attr *StorageDomainLease) {
	p.lease = attr
}

func (p *Template) Lease() (*StorageDomainLease, bool) {
	if p.lease != nil {
		return p.lease, true
	}
	return nil, false
}

func (p *Template) MustLease() *StorageDomainLease {
	if p.lease == nil {
		panic("the lease must not be nil, please use Lease() function instead")
	}
	return p.lease
}

func (p *Template) SetMemory(attr int64) {
	p.memory = &attr
}

func (p *Template) Memory() (int64, bool) {
	if p.memory != nil {
		return *p.memory, true
	}
	var zero int64
	return zero, false
}

func (p *Template) MustMemory() int64 {
	if p.memory == nil {
		panic("the memory must not be nil, please use Memory() function instead")
	}
	return *p.memory
}

func (p *Template) SetMemoryPolicy(attr *MemoryPolicy) {
	p.memoryPolicy = attr
}

func (p *Template) MemoryPolicy() (*MemoryPolicy, bool) {
	if p.memoryPolicy != nil {
		return p.memoryPolicy, true
	}
	return nil, false
}

func (p *Template) MustMemoryPolicy() *MemoryPolicy {
	if p.memoryPolicy == nil {
		panic("the memoryPolicy must not be nil, please use MemoryPolicy() function instead")
	}
	return p.memoryPolicy
}

func (p *Template) SetMigration(attr *MigrationOptions) {
	p.migration = attr
}

func (p *Template) Migration() (*MigrationOptions, bool) {
	if p.migration != nil {
		return p.migration, true
	}
	return nil, false
}

func (p *Template) MustMigration() *MigrationOptions {
	if p.migration == nil {
		panic("the migration must not be nil, please use Migration() function instead")
	}
	return p.migration
}

func (p *Template) SetMigrationDowntime(attr int64) {
	p.migrationDowntime = &attr
}

func (p *Template) MigrationDowntime() (int64, bool) {
	if p.migrationDowntime != nil {
		return *p.migrationDowntime, true
	}
	var zero int64
	return zero, false
}

func (p *Template) MustMigrationDowntime() int64 {
	if p.migrationDowntime == nil {
		panic("the migrationDowntime must not be nil, please use MigrationDowntime() function instead")
	}
	return *p.migrationDowntime
}

func (p *Template) SetMultiQueuesEnabled(attr bool) {
	p.multiQueuesEnabled = &attr
}

func (p *Template) MultiQueuesEnabled() (bool, bool) {
	if p.multiQueuesEnabled != nil {
		return *p.multiQueuesEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Template) MustMultiQueuesEnabled() bool {
	if p.multiQueuesEnabled == nil {
		panic("the multiQueuesEnabled must not be nil, please use MultiQueuesEnabled() function instead")
	}
	return *p.multiQueuesEnabled
}

func (p *Template) SetName(attr string) {
	p.name = &attr
}

func (p *Template) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Template) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Template) SetNics(attr *NicSlice) {
	p.nics = attr
}

func (p *Template) Nics() (*NicSlice, bool) {
	if p.nics != nil {
		return p.nics, true
	}
	return nil, false
}

func (p *Template) MustNics() *NicSlice {
	if p.nics == nil {
		panic("the nics must not be nil, please use Nics() function instead")
	}
	return p.nics
}

func (p *Template) SetOrigin(attr string) {
	p.origin = &attr
}

func (p *Template) Origin() (string, bool) {
	if p.origin != nil {
		return *p.origin, true
	}
	var zero string
	return zero, false
}

func (p *Template) MustOrigin() string {
	if p.origin == nil {
		panic("the origin must not be nil, please use Origin() function instead")
	}
	return *p.origin
}

func (p *Template) SetOs(attr *OperatingSystem) {
	p.os = attr
}

func (p *Template) Os() (*OperatingSystem, bool) {
	if p.os != nil {
		return p.os, true
	}
	return nil, false
}

func (p *Template) MustOs() *OperatingSystem {
	if p.os == nil {
		panic("the os must not be nil, please use Os() function instead")
	}
	return p.os
}

func (p *Template) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *Template) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *Template) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *Template) SetPlacementPolicy(attr *VmPlacementPolicy) {
	p.placementPolicy = attr
}

func (p *Template) PlacementPolicy() (*VmPlacementPolicy, bool) {
	if p.placementPolicy != nil {
		return p.placementPolicy, true
	}
	return nil, false
}

func (p *Template) MustPlacementPolicy() *VmPlacementPolicy {
	if p.placementPolicy == nil {
		panic("the placementPolicy must not be nil, please use PlacementPolicy() function instead")
	}
	return p.placementPolicy
}

func (p *Template) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *Template) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *Template) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *Template) SetRngDevice(attr *RngDevice) {
	p.rngDevice = attr
}

func (p *Template) RngDevice() (*RngDevice, bool) {
	if p.rngDevice != nil {
		return p.rngDevice, true
	}
	return nil, false
}

func (p *Template) MustRngDevice() *RngDevice {
	if p.rngDevice == nil {
		panic("the rngDevice must not be nil, please use RngDevice() function instead")
	}
	return p.rngDevice
}

func (p *Template) SetSerialNumber(attr *SerialNumber) {
	p.serialNumber = attr
}

func (p *Template) SerialNumber() (*SerialNumber, bool) {
	if p.serialNumber != nil {
		return p.serialNumber, true
	}
	return nil, false
}

func (p *Template) MustSerialNumber() *SerialNumber {
	if p.serialNumber == nil {
		panic("the serialNumber must not be nil, please use SerialNumber() function instead")
	}
	return p.serialNumber
}

func (p *Template) SetSmallIcon(attr *Icon) {
	p.smallIcon = attr
}

func (p *Template) SmallIcon() (*Icon, bool) {
	if p.smallIcon != nil {
		return p.smallIcon, true
	}
	return nil, false
}

func (p *Template) MustSmallIcon() *Icon {
	if p.smallIcon == nil {
		panic("the smallIcon must not be nil, please use SmallIcon() function instead")
	}
	return p.smallIcon
}

func (p *Template) SetSoundcardEnabled(attr bool) {
	p.soundcardEnabled = &attr
}

func (p *Template) SoundcardEnabled() (bool, bool) {
	if p.soundcardEnabled != nil {
		return *p.soundcardEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Template) MustSoundcardEnabled() bool {
	if p.soundcardEnabled == nil {
		panic("the soundcardEnabled must not be nil, please use SoundcardEnabled() function instead")
	}
	return *p.soundcardEnabled
}

func (p *Template) SetSso(attr *Sso) {
	p.sso = attr
}

func (p *Template) Sso() (*Sso, bool) {
	if p.sso != nil {
		return p.sso, true
	}
	return nil, false
}

func (p *Template) MustSso() *Sso {
	if p.sso == nil {
		panic("the sso must not be nil, please use Sso() function instead")
	}
	return p.sso
}

func (p *Template) SetStartPaused(attr bool) {
	p.startPaused = &attr
}

func (p *Template) StartPaused() (bool, bool) {
	if p.startPaused != nil {
		return *p.startPaused, true
	}
	var zero bool
	return zero, false
}

func (p *Template) MustStartPaused() bool {
	if p.startPaused == nil {
		panic("the startPaused must not be nil, please use StartPaused() function instead")
	}
	return *p.startPaused
}

func (p *Template) SetStateless(attr bool) {
	p.stateless = &attr
}

func (p *Template) Stateless() (bool, bool) {
	if p.stateless != nil {
		return *p.stateless, true
	}
	var zero bool
	return zero, false
}

func (p *Template) MustStateless() bool {
	if p.stateless == nil {
		panic("the stateless must not be nil, please use Stateless() function instead")
	}
	return *p.stateless
}

func (p *Template) SetStatus(attr TemplateStatus) {
	p.status = &attr
}

func (p *Template) Status() (TemplateStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero TemplateStatus
	return zero, false
}

func (p *Template) MustStatus() TemplateStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *Template) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *Template) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *Template) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *Template) SetStorageErrorResumeBehaviour(attr VmStorageErrorResumeBehaviour) {
	p.storageErrorResumeBehaviour = &attr
}

func (p *Template) StorageErrorResumeBehaviour() (VmStorageErrorResumeBehaviour, bool) {
	if p.storageErrorResumeBehaviour != nil {
		return *p.storageErrorResumeBehaviour, true
	}
	var zero VmStorageErrorResumeBehaviour
	return zero, false
}

func (p *Template) MustStorageErrorResumeBehaviour() VmStorageErrorResumeBehaviour {
	if p.storageErrorResumeBehaviour == nil {
		panic("the storageErrorResumeBehaviour must not be nil, please use StorageErrorResumeBehaviour() function instead")
	}
	return *p.storageErrorResumeBehaviour
}

func (p *Template) SetTags(attr *TagSlice) {
	p.tags = attr
}

func (p *Template) Tags() (*TagSlice, bool) {
	if p.tags != nil {
		return p.tags, true
	}
	return nil, false
}

func (p *Template) MustTags() *TagSlice {
	if p.tags == nil {
		panic("the tags must not be nil, please use Tags() function instead")
	}
	return p.tags
}

func (p *Template) SetTimeZone(attr *TimeZone) {
	p.timeZone = attr
}

func (p *Template) TimeZone() (*TimeZone, bool) {
	if p.timeZone != nil {
		return p.timeZone, true
	}
	return nil, false
}

func (p *Template) MustTimeZone() *TimeZone {
	if p.timeZone == nil {
		panic("the timeZone must not be nil, please use TimeZone() function instead")
	}
	return p.timeZone
}

func (p *Template) SetTunnelMigration(attr bool) {
	p.tunnelMigration = &attr
}

func (p *Template) TunnelMigration() (bool, bool) {
	if p.tunnelMigration != nil {
		return *p.tunnelMigration, true
	}
	var zero bool
	return zero, false
}

func (p *Template) MustTunnelMigration() bool {
	if p.tunnelMigration == nil {
		panic("the tunnelMigration must not be nil, please use TunnelMigration() function instead")
	}
	return *p.tunnelMigration
}

func (p *Template) SetType(attr VmType) {
	p.type_ = &attr
}

func (p *Template) Type() (VmType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero VmType
	return zero, false
}

func (p *Template) MustType() VmType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *Template) SetUsb(attr *Usb) {
	p.usb = attr
}

func (p *Template) Usb() (*Usb, bool) {
	if p.usb != nil {
		return p.usb, true
	}
	return nil, false
}

func (p *Template) MustUsb() *Usb {
	if p.usb == nil {
		panic("the usb must not be nil, please use Usb() function instead")
	}
	return p.usb
}

func (p *Template) SetVersion(attr *TemplateVersion) {
	p.version = attr
}

func (p *Template) Version() (*TemplateVersion, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *Template) MustVersion() *TemplateVersion {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

func (p *Template) SetVirtioScsi(attr *VirtioScsi) {
	p.virtioScsi = attr
}

func (p *Template) VirtioScsi() (*VirtioScsi, bool) {
	if p.virtioScsi != nil {
		return p.virtioScsi, true
	}
	return nil, false
}

func (p *Template) MustVirtioScsi() *VirtioScsi {
	if p.virtioScsi == nil {
		panic("the virtioScsi must not be nil, please use VirtioScsi() function instead")
	}
	return p.virtioScsi
}

func (p *Template) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Template) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Template) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Template) SetWatchdogs(attr *WatchdogSlice) {
	p.watchdogs = attr
}

func (p *Template) Watchdogs() (*WatchdogSlice, bool) {
	if p.watchdogs != nil {
		return p.watchdogs, true
	}
	return nil, false
}

func (p *Template) MustWatchdogs() *WatchdogSlice {
	if p.watchdogs == nil {
		panic("the watchdogs must not be nil, please use Watchdogs() function instead")
	}
	return p.watchdogs
}

type NfsProfileDetail struct {
	Struct
	nfsServerIp    *string
	profileDetails *ProfileDetailSlice
}

func (p *NfsProfileDetail) SetNfsServerIp(attr string) {
	p.nfsServerIp = &attr
}

func (p *NfsProfileDetail) NfsServerIp() (string, bool) {
	if p.nfsServerIp != nil {
		return *p.nfsServerIp, true
	}
	var zero string
	return zero, false
}

func (p *NfsProfileDetail) MustNfsServerIp() string {
	if p.nfsServerIp == nil {
		panic("the nfsServerIp must not be nil, please use NfsServerIp() function instead")
	}
	return *p.nfsServerIp
}

func (p *NfsProfileDetail) SetProfileDetails(attr *ProfileDetailSlice) {
	p.profileDetails = attr
}

func (p *NfsProfileDetail) ProfileDetails() (*ProfileDetailSlice, bool) {
	if p.profileDetails != nil {
		return p.profileDetails, true
	}
	return nil, false
}

func (p *NfsProfileDetail) MustProfileDetails() *ProfileDetailSlice {
	if p.profileDetails == nil {
		panic("the profileDetails must not be nil, please use ProfileDetails() function instead")
	}
	return p.profileDetails
}

type BrickProfileDetail struct {
	Struct
	brick          *GlusterBrick
	profileDetails *ProfileDetailSlice
}

func (p *BrickProfileDetail) SetBrick(attr *GlusterBrick) {
	p.brick = attr
}

func (p *BrickProfileDetail) Brick() (*GlusterBrick, bool) {
	if p.brick != nil {
		return p.brick, true
	}
	return nil, false
}

func (p *BrickProfileDetail) MustBrick() *GlusterBrick {
	if p.brick == nil {
		panic("the brick must not be nil, please use Brick() function instead")
	}
	return p.brick
}

func (p *BrickProfileDetail) SetProfileDetails(attr *ProfileDetailSlice) {
	p.profileDetails = attr
}

func (p *BrickProfileDetail) ProfileDetails() (*ProfileDetailSlice, bool) {
	if p.profileDetails != nil {
		return p.profileDetails, true
	}
	return nil, false
}

func (p *BrickProfileDetail) MustProfileDetails() *ProfileDetailSlice {
	if p.profileDetails == nil {
		panic("the profileDetails must not be nil, please use ProfileDetails() function instead")
	}
	return p.profileDetails
}

type Floppy struct {
	Struct
	comment      *string
	description  *string
	file         *File
	id           *string
	instanceType *InstanceType
	name         *string
	template     *Template
	vm           *Vm
	vms          *VmSlice
}

func (p *Floppy) SetComment(attr string) {
	p.comment = &attr
}

func (p *Floppy) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Floppy) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Floppy) SetDescription(attr string) {
	p.description = &attr
}

func (p *Floppy) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Floppy) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Floppy) SetFile(attr *File) {
	p.file = attr
}

func (p *Floppy) File() (*File, bool) {
	if p.file != nil {
		return p.file, true
	}
	return nil, false
}

func (p *Floppy) MustFile() *File {
	if p.file == nil {
		panic("the file must not be nil, please use File() function instead")
	}
	return p.file
}

func (p *Floppy) SetId(attr string) {
	p.id = &attr
}

func (p *Floppy) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Floppy) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Floppy) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *Floppy) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *Floppy) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *Floppy) SetName(attr string) {
	p.name = &attr
}

func (p *Floppy) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Floppy) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Floppy) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Floppy) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Floppy) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Floppy) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Floppy) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Floppy) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Floppy) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *Floppy) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *Floppy) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

type MacPool struct {
	Struct
	allowDuplicates *bool
	comment         *string
	defaultPool     *bool
	description     *string
	id              *string
	name            *string
	permissions     *PermissionSlice
	ranges          *RangeSlice
}

func (p *MacPool) SetAllowDuplicates(attr bool) {
	p.allowDuplicates = &attr
}

func (p *MacPool) AllowDuplicates() (bool, bool) {
	if p.allowDuplicates != nil {
		return *p.allowDuplicates, true
	}
	var zero bool
	return zero, false
}

func (p *MacPool) MustAllowDuplicates() bool {
	if p.allowDuplicates == nil {
		panic("the allowDuplicates must not be nil, please use AllowDuplicates() function instead")
	}
	return *p.allowDuplicates
}

func (p *MacPool) SetComment(attr string) {
	p.comment = &attr
}

func (p *MacPool) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *MacPool) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *MacPool) SetDefaultPool(attr bool) {
	p.defaultPool = &attr
}

func (p *MacPool) DefaultPool() (bool, bool) {
	if p.defaultPool != nil {
		return *p.defaultPool, true
	}
	var zero bool
	return zero, false
}

func (p *MacPool) MustDefaultPool() bool {
	if p.defaultPool == nil {
		panic("the defaultPool must not be nil, please use DefaultPool() function instead")
	}
	return *p.defaultPool
}

func (p *MacPool) SetDescription(attr string) {
	p.description = &attr
}

func (p *MacPool) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *MacPool) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *MacPool) SetId(attr string) {
	p.id = &attr
}

func (p *MacPool) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *MacPool) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *MacPool) SetName(attr string) {
	p.name = &attr
}

func (p *MacPool) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *MacPool) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *MacPool) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *MacPool) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *MacPool) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *MacPool) SetRanges(attr *RangeSlice) {
	p.ranges = attr
}

func (p *MacPool) Ranges() (*RangeSlice, bool) {
	if p.ranges != nil {
		return p.ranges, true
	}
	return nil, false
}

func (p *MacPool) MustRanges() *RangeSlice {
	if p.ranges == nil {
		panic("the ranges must not be nil, please use Ranges() function instead")
	}
	return p.ranges
}

type VmPlacementPolicy struct {
	Struct
	affinity *VmAffinity
	hosts    *HostSlice
}

func (p *VmPlacementPolicy) SetAffinity(attr VmAffinity) {
	p.affinity = &attr
}

func (p *VmPlacementPolicy) Affinity() (VmAffinity, bool) {
	if p.affinity != nil {
		return *p.affinity, true
	}
	var zero VmAffinity
	return zero, false
}

func (p *VmPlacementPolicy) MustAffinity() VmAffinity {
	if p.affinity == nil {
		panic("the affinity must not be nil, please use Affinity() function instead")
	}
	return *p.affinity
}

func (p *VmPlacementPolicy) SetHosts(attr *HostSlice) {
	p.hosts = attr
}

func (p *VmPlacementPolicy) Hosts() (*HostSlice, bool) {
	if p.hosts != nil {
		return p.hosts, true
	}
	return nil, false
}

func (p *VmPlacementPolicy) MustHosts() *HostSlice {
	if p.hosts == nil {
		panic("the hosts must not be nil, please use Hosts() function instead")
	}
	return p.hosts
}

type ProductInfo struct {
	Struct
	id      *string
	name    *string
	vendor  *string
	version *Version
}

func (p *ProductInfo) SetId(attr string) {
	p.id = &attr
}

func (p *ProductInfo) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ProductInfo) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ProductInfo) SetName(attr string) {
	p.name = &attr
}

func (p *ProductInfo) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ProductInfo) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ProductInfo) SetVendor(attr string) {
	p.vendor = &attr
}

func (p *ProductInfo) Vendor() (string, bool) {
	if p.vendor != nil {
		return *p.vendor, true
	}
	var zero string
	return zero, false
}

func (p *ProductInfo) MustVendor() string {
	if p.vendor == nil {
		panic("the vendor must not be nil, please use Vendor() function instead")
	}
	return *p.vendor
}

func (p *ProductInfo) SetVersion(attr *Version) {
	p.version = attr
}

func (p *ProductInfo) Version() (*Version, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *ProductInfo) MustVersion() *Version {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

type CpuTune struct {
	Struct
	vcpuPins *VcpuPinSlice
}

func (p *CpuTune) SetVcpuPins(attr *VcpuPinSlice) {
	p.vcpuPins = attr
}

func (p *CpuTune) VcpuPins() (*VcpuPinSlice, bool) {
	if p.vcpuPins != nil {
		return p.vcpuPins, true
	}
	return nil, false
}

func (p *CpuTune) MustVcpuPins() *VcpuPinSlice {
	if p.vcpuPins == nil {
		panic("the vcpuPins must not be nil, please use VcpuPins() function instead")
	}
	return p.vcpuPins
}

type AffinityRule struct {
	Struct
	enabled   *bool
	enforcing *bool
	positive  *bool
}

func (p *AffinityRule) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *AffinityRule) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *AffinityRule) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

func (p *AffinityRule) SetEnforcing(attr bool) {
	p.enforcing = &attr
}

func (p *AffinityRule) Enforcing() (bool, bool) {
	if p.enforcing != nil {
		return *p.enforcing, true
	}
	var zero bool
	return zero, false
}

func (p *AffinityRule) MustEnforcing() bool {
	if p.enforcing == nil {
		panic("the enforcing must not be nil, please use Enforcing() function instead")
	}
	return *p.enforcing
}

func (p *AffinityRule) SetPositive(attr bool) {
	p.positive = &attr
}

func (p *AffinityRule) Positive() (bool, bool) {
	if p.positive != nil {
		return *p.positive, true
	}
	var zero bool
	return zero, false
}

func (p *AffinityRule) MustPositive() bool {
	if p.positive == nil {
		panic("the positive must not be nil, please use Positive() function instead")
	}
	return *p.positive
}

type HostNic struct {
	Struct
	adAggregatorId                *int64
	baseInterface                 *string
	bonding                       *Bonding
	bootProtocol                  *BootProtocol
	bridged                       *bool
	checkConnectivity             *bool
	comment                       *string
	customConfiguration           *bool
	description                   *string
	host                          *Host
	id                            *string
	ip                            *Ip
	ipv6                          *Ip
	ipv6BootProtocol              *BootProtocol
	mac                           *Mac
	mtu                           *int64
	name                          *string
	network                       *Network
	networkLabels                 *NetworkLabelSlice
	overrideConfiguration         *bool
	physicalFunction              *HostNic
	properties                    *PropertySlice
	qos                           *Qos
	speed                         *int64
	statistics                    *StatisticSlice
	status                        *NicStatus
	virtualFunctionsConfiguration *HostNicVirtualFunctionsConfiguration
	vlan                          *Vlan
}

func (p *HostNic) SetAdAggregatorId(attr int64) {
	p.adAggregatorId = &attr
}

func (p *HostNic) AdAggregatorId() (int64, bool) {
	if p.adAggregatorId != nil {
		return *p.adAggregatorId, true
	}
	var zero int64
	return zero, false
}

func (p *HostNic) MustAdAggregatorId() int64 {
	if p.adAggregatorId == nil {
		panic("the adAggregatorId must not be nil, please use AdAggregatorId() function instead")
	}
	return *p.adAggregatorId
}

func (p *HostNic) SetBaseInterface(attr string) {
	p.baseInterface = &attr
}

func (p *HostNic) BaseInterface() (string, bool) {
	if p.baseInterface != nil {
		return *p.baseInterface, true
	}
	var zero string
	return zero, false
}

func (p *HostNic) MustBaseInterface() string {
	if p.baseInterface == nil {
		panic("the baseInterface must not be nil, please use BaseInterface() function instead")
	}
	return *p.baseInterface
}

func (p *HostNic) SetBonding(attr *Bonding) {
	p.bonding = attr
}

func (p *HostNic) Bonding() (*Bonding, bool) {
	if p.bonding != nil {
		return p.bonding, true
	}
	return nil, false
}

func (p *HostNic) MustBonding() *Bonding {
	if p.bonding == nil {
		panic("the bonding must not be nil, please use Bonding() function instead")
	}
	return p.bonding
}

func (p *HostNic) SetBootProtocol(attr BootProtocol) {
	p.bootProtocol = &attr
}

func (p *HostNic) BootProtocol() (BootProtocol, bool) {
	if p.bootProtocol != nil {
		return *p.bootProtocol, true
	}
	var zero BootProtocol
	return zero, false
}

func (p *HostNic) MustBootProtocol() BootProtocol {
	if p.bootProtocol == nil {
		panic("the bootProtocol must not be nil, please use BootProtocol() function instead")
	}
	return *p.bootProtocol
}

func (p *HostNic) SetBridged(attr bool) {
	p.bridged = &attr
}

func (p *HostNic) Bridged() (bool, bool) {
	if p.bridged != nil {
		return *p.bridged, true
	}
	var zero bool
	return zero, false
}

func (p *HostNic) MustBridged() bool {
	if p.bridged == nil {
		panic("the bridged must not be nil, please use Bridged() function instead")
	}
	return *p.bridged
}

func (p *HostNic) SetCheckConnectivity(attr bool) {
	p.checkConnectivity = &attr
}

func (p *HostNic) CheckConnectivity() (bool, bool) {
	if p.checkConnectivity != nil {
		return *p.checkConnectivity, true
	}
	var zero bool
	return zero, false
}

func (p *HostNic) MustCheckConnectivity() bool {
	if p.checkConnectivity == nil {
		panic("the checkConnectivity must not be nil, please use CheckConnectivity() function instead")
	}
	return *p.checkConnectivity
}

func (p *HostNic) SetComment(attr string) {
	p.comment = &attr
}

func (p *HostNic) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *HostNic) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *HostNic) SetCustomConfiguration(attr bool) {
	p.customConfiguration = &attr
}

func (p *HostNic) CustomConfiguration() (bool, bool) {
	if p.customConfiguration != nil {
		return *p.customConfiguration, true
	}
	var zero bool
	return zero, false
}

func (p *HostNic) MustCustomConfiguration() bool {
	if p.customConfiguration == nil {
		panic("the customConfiguration must not be nil, please use CustomConfiguration() function instead")
	}
	return *p.customConfiguration
}

func (p *HostNic) SetDescription(attr string) {
	p.description = &attr
}

func (p *HostNic) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *HostNic) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *HostNic) SetHost(attr *Host) {
	p.host = attr
}

func (p *HostNic) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *HostNic) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *HostNic) SetId(attr string) {
	p.id = &attr
}

func (p *HostNic) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *HostNic) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *HostNic) SetIp(attr *Ip) {
	p.ip = attr
}

func (p *HostNic) Ip() (*Ip, bool) {
	if p.ip != nil {
		return p.ip, true
	}
	return nil, false
}

func (p *HostNic) MustIp() *Ip {
	if p.ip == nil {
		panic("the ip must not be nil, please use Ip() function instead")
	}
	return p.ip
}

func (p *HostNic) SetIpv6(attr *Ip) {
	p.ipv6 = attr
}

func (p *HostNic) Ipv6() (*Ip, bool) {
	if p.ipv6 != nil {
		return p.ipv6, true
	}
	return nil, false
}

func (p *HostNic) MustIpv6() *Ip {
	if p.ipv6 == nil {
		panic("the ipv6 must not be nil, please use Ipv6() function instead")
	}
	return p.ipv6
}

func (p *HostNic) SetIpv6BootProtocol(attr BootProtocol) {
	p.ipv6BootProtocol = &attr
}

func (p *HostNic) Ipv6BootProtocol() (BootProtocol, bool) {
	if p.ipv6BootProtocol != nil {
		return *p.ipv6BootProtocol, true
	}
	var zero BootProtocol
	return zero, false
}

func (p *HostNic) MustIpv6BootProtocol() BootProtocol {
	if p.ipv6BootProtocol == nil {
		panic("the ipv6BootProtocol must not be nil, please use Ipv6BootProtocol() function instead")
	}
	return *p.ipv6BootProtocol
}

func (p *HostNic) SetMac(attr *Mac) {
	p.mac = attr
}

func (p *HostNic) Mac() (*Mac, bool) {
	if p.mac != nil {
		return p.mac, true
	}
	return nil, false
}

func (p *HostNic) MustMac() *Mac {
	if p.mac == nil {
		panic("the mac must not be nil, please use Mac() function instead")
	}
	return p.mac
}

func (p *HostNic) SetMtu(attr int64) {
	p.mtu = &attr
}

func (p *HostNic) Mtu() (int64, bool) {
	if p.mtu != nil {
		return *p.mtu, true
	}
	var zero int64
	return zero, false
}

func (p *HostNic) MustMtu() int64 {
	if p.mtu == nil {
		panic("the mtu must not be nil, please use Mtu() function instead")
	}
	return *p.mtu
}

func (p *HostNic) SetName(attr string) {
	p.name = &attr
}

func (p *HostNic) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *HostNic) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *HostNic) SetNetwork(attr *Network) {
	p.network = attr
}

func (p *HostNic) Network() (*Network, bool) {
	if p.network != nil {
		return p.network, true
	}
	return nil, false
}

func (p *HostNic) MustNetwork() *Network {
	if p.network == nil {
		panic("the network must not be nil, please use Network() function instead")
	}
	return p.network
}

func (p *HostNic) SetNetworkLabels(attr *NetworkLabelSlice) {
	p.networkLabels = attr
}

func (p *HostNic) NetworkLabels() (*NetworkLabelSlice, bool) {
	if p.networkLabels != nil {
		return p.networkLabels, true
	}
	return nil, false
}

func (p *HostNic) MustNetworkLabels() *NetworkLabelSlice {
	if p.networkLabels == nil {
		panic("the networkLabels must not be nil, please use NetworkLabels() function instead")
	}
	return p.networkLabels
}

func (p *HostNic) SetOverrideConfiguration(attr bool) {
	p.overrideConfiguration = &attr
}

func (p *HostNic) OverrideConfiguration() (bool, bool) {
	if p.overrideConfiguration != nil {
		return *p.overrideConfiguration, true
	}
	var zero bool
	return zero, false
}

func (p *HostNic) MustOverrideConfiguration() bool {
	if p.overrideConfiguration == nil {
		panic("the overrideConfiguration must not be nil, please use OverrideConfiguration() function instead")
	}
	return *p.overrideConfiguration
}

func (p *HostNic) SetPhysicalFunction(attr *HostNic) {
	p.physicalFunction = attr
}

func (p *HostNic) PhysicalFunction() (*HostNic, bool) {
	if p.physicalFunction != nil {
		return p.physicalFunction, true
	}
	return nil, false
}

func (p *HostNic) MustPhysicalFunction() *HostNic {
	if p.physicalFunction == nil {
		panic("the physicalFunction must not be nil, please use PhysicalFunction() function instead")
	}
	return p.physicalFunction
}

func (p *HostNic) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *HostNic) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *HostNic) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *HostNic) SetQos(attr *Qos) {
	p.qos = attr
}

func (p *HostNic) Qos() (*Qos, bool) {
	if p.qos != nil {
		return p.qos, true
	}
	return nil, false
}

func (p *HostNic) MustQos() *Qos {
	if p.qos == nil {
		panic("the qos must not be nil, please use Qos() function instead")
	}
	return p.qos
}

func (p *HostNic) SetSpeed(attr int64) {
	p.speed = &attr
}

func (p *HostNic) Speed() (int64, bool) {
	if p.speed != nil {
		return *p.speed, true
	}
	var zero int64
	return zero, false
}

func (p *HostNic) MustSpeed() int64 {
	if p.speed == nil {
		panic("the speed must not be nil, please use Speed() function instead")
	}
	return *p.speed
}

func (p *HostNic) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *HostNic) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *HostNic) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *HostNic) SetStatus(attr NicStatus) {
	p.status = &attr
}

func (p *HostNic) Status() (NicStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero NicStatus
	return zero, false
}

func (p *HostNic) MustStatus() NicStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *HostNic) SetVirtualFunctionsConfiguration(attr *HostNicVirtualFunctionsConfiguration) {
	p.virtualFunctionsConfiguration = attr
}

func (p *HostNic) VirtualFunctionsConfiguration() (*HostNicVirtualFunctionsConfiguration, bool) {
	if p.virtualFunctionsConfiguration != nil {
		return p.virtualFunctionsConfiguration, true
	}
	return nil, false
}

func (p *HostNic) MustVirtualFunctionsConfiguration() *HostNicVirtualFunctionsConfiguration {
	if p.virtualFunctionsConfiguration == nil {
		panic("the virtualFunctionsConfiguration must not be nil, please use VirtualFunctionsConfiguration() function instead")
	}
	return p.virtualFunctionsConfiguration
}

func (p *HostNic) SetVlan(attr *Vlan) {
	p.vlan = attr
}

func (p *HostNic) Vlan() (*Vlan, bool) {
	if p.vlan != nil {
		return p.vlan, true
	}
	return nil, false
}

func (p *HostNic) MustVlan() *Vlan {
	if p.vlan == nil {
		panic("the vlan must not be nil, please use Vlan() function instead")
	}
	return p.vlan
}

type CustomProperty struct {
	Struct
	name   *string
	regexp *string
	value  *string
}

func (p *CustomProperty) SetName(attr string) {
	p.name = &attr
}

func (p *CustomProperty) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *CustomProperty) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *CustomProperty) SetRegexp(attr string) {
	p.regexp = &attr
}

func (p *CustomProperty) Regexp() (string, bool) {
	if p.regexp != nil {
		return *p.regexp, true
	}
	var zero string
	return zero, false
}

func (p *CustomProperty) MustRegexp() string {
	if p.regexp == nil {
		panic("the regexp must not be nil, please use Regexp() function instead")
	}
	return *p.regexp
}

func (p *CustomProperty) SetValue(attr string) {
	p.value = &attr
}

func (p *CustomProperty) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *CustomProperty) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

type PortMirroring struct {
	Struct
}

type Bookmark struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
	value       *string
}

func (p *Bookmark) SetComment(attr string) {
	p.comment = &attr
}

func (p *Bookmark) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Bookmark) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Bookmark) SetDescription(attr string) {
	p.description = &attr
}

func (p *Bookmark) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Bookmark) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Bookmark) SetId(attr string) {
	p.id = &attr
}

func (p *Bookmark) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Bookmark) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Bookmark) SetName(attr string) {
	p.name = &attr
}

func (p *Bookmark) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Bookmark) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Bookmark) SetValue(attr string) {
	p.value = &attr
}

func (p *Bookmark) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *Bookmark) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

type RegistrationAffinityGroupMapping struct {
	Struct
	from *AffinityGroup
	to   *AffinityGroup
}

func (p *RegistrationAffinityGroupMapping) SetFrom(attr *AffinityGroup) {
	p.from = attr
}

func (p *RegistrationAffinityGroupMapping) From() (*AffinityGroup, bool) {
	if p.from != nil {
		return p.from, true
	}
	return nil, false
}

func (p *RegistrationAffinityGroupMapping) MustFrom() *AffinityGroup {
	if p.from == nil {
		panic("the from must not be nil, please use From() function instead")
	}
	return p.from
}

func (p *RegistrationAffinityGroupMapping) SetTo(attr *AffinityGroup) {
	p.to = attr
}

func (p *RegistrationAffinityGroupMapping) To() (*AffinityGroup, bool) {
	if p.to != nil {
		return p.to, true
	}
	return nil, false
}

func (p *RegistrationAffinityGroupMapping) MustTo() *AffinityGroup {
	if p.to == nil {
		panic("the to must not be nil, please use To() function instead")
	}
	return p.to
}

type ProfileDetail struct {
	Struct
	blockStatistics *BlockStatisticSlice
	duration        *int64
	fopStatistics   *FopStatisticSlice
	profileType     *string
	statistics      *StatisticSlice
}

func (p *ProfileDetail) SetBlockStatistics(attr *BlockStatisticSlice) {
	p.blockStatistics = attr
}

func (p *ProfileDetail) BlockStatistics() (*BlockStatisticSlice, bool) {
	if p.blockStatistics != nil {
		return p.blockStatistics, true
	}
	return nil, false
}

func (p *ProfileDetail) MustBlockStatistics() *BlockStatisticSlice {
	if p.blockStatistics == nil {
		panic("the blockStatistics must not be nil, please use BlockStatistics() function instead")
	}
	return p.blockStatistics
}

func (p *ProfileDetail) SetDuration(attr int64) {
	p.duration = &attr
}

func (p *ProfileDetail) Duration() (int64, bool) {
	if p.duration != nil {
		return *p.duration, true
	}
	var zero int64
	return zero, false
}

func (p *ProfileDetail) MustDuration() int64 {
	if p.duration == nil {
		panic("the duration must not be nil, please use Duration() function instead")
	}
	return *p.duration
}

func (p *ProfileDetail) SetFopStatistics(attr *FopStatisticSlice) {
	p.fopStatistics = attr
}

func (p *ProfileDetail) FopStatistics() (*FopStatisticSlice, bool) {
	if p.fopStatistics != nil {
		return p.fopStatistics, true
	}
	return nil, false
}

func (p *ProfileDetail) MustFopStatistics() *FopStatisticSlice {
	if p.fopStatistics == nil {
		panic("the fopStatistics must not be nil, please use FopStatistics() function instead")
	}
	return p.fopStatistics
}

func (p *ProfileDetail) SetProfileType(attr string) {
	p.profileType = &attr
}

func (p *ProfileDetail) ProfileType() (string, bool) {
	if p.profileType != nil {
		return *p.profileType, true
	}
	var zero string
	return zero, false
}

func (p *ProfileDetail) MustProfileType() string {
	if p.profileType == nil {
		panic("the profileType must not be nil, please use ProfileType() function instead")
	}
	return *p.profileType
}

func (p *ProfileDetail) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *ProfileDetail) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *ProfileDetail) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

type TimeZone struct {
	Struct
	name      *string
	utcOffset *string
}

func (p *TimeZone) SetName(attr string) {
	p.name = &attr
}

func (p *TimeZone) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *TimeZone) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *TimeZone) SetUtcOffset(attr string) {
	p.utcOffset = &attr
}

func (p *TimeZone) UtcOffset() (string, bool) {
	if p.utcOffset != nil {
		return *p.utcOffset, true
	}
	var zero string
	return zero, false
}

func (p *TimeZone) MustUtcOffset() string {
	if p.utcOffset == nil {
		panic("the utcOffset must not be nil, please use UtcOffset() function instead")
	}
	return *p.utcOffset
}

type Event struct {
	Struct
	cluster       *Cluster
	code          *int64
	comment       *string
	correlationId *string
	customData    *string
	customId      *int64
	dataCenter    *DataCenter
	description   *string
	floodRate     *int64
	host          *Host
	id            *string
	index         *int64
	logOnHost     *bool
	name          *string
	origin        *string
	severity      *LogSeverity
	storageDomain *StorageDomain
	template      *Template
	time          *time.Time
	user          *User
	vm            *Vm
}

func (p *Event) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *Event) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *Event) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *Event) SetCode(attr int64) {
	p.code = &attr
}

func (p *Event) Code() (int64, bool) {
	if p.code != nil {
		return *p.code, true
	}
	var zero int64
	return zero, false
}

func (p *Event) MustCode() int64 {
	if p.code == nil {
		panic("the code must not be nil, please use Code() function instead")
	}
	return *p.code
}

func (p *Event) SetComment(attr string) {
	p.comment = &attr
}

func (p *Event) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Event) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Event) SetCorrelationId(attr string) {
	p.correlationId = &attr
}

func (p *Event) CorrelationId() (string, bool) {
	if p.correlationId != nil {
		return *p.correlationId, true
	}
	var zero string
	return zero, false
}

func (p *Event) MustCorrelationId() string {
	if p.correlationId == nil {
		panic("the correlationId must not be nil, please use CorrelationId() function instead")
	}
	return *p.correlationId
}

func (p *Event) SetCustomData(attr string) {
	p.customData = &attr
}

func (p *Event) CustomData() (string, bool) {
	if p.customData != nil {
		return *p.customData, true
	}
	var zero string
	return zero, false
}

func (p *Event) MustCustomData() string {
	if p.customData == nil {
		panic("the customData must not be nil, please use CustomData() function instead")
	}
	return *p.customData
}

func (p *Event) SetCustomId(attr int64) {
	p.customId = &attr
}

func (p *Event) CustomId() (int64, bool) {
	if p.customId != nil {
		return *p.customId, true
	}
	var zero int64
	return zero, false
}

func (p *Event) MustCustomId() int64 {
	if p.customId == nil {
		panic("the customId must not be nil, please use CustomId() function instead")
	}
	return *p.customId
}

func (p *Event) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *Event) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *Event) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *Event) SetDescription(attr string) {
	p.description = &attr
}

func (p *Event) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Event) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Event) SetFloodRate(attr int64) {
	p.floodRate = &attr
}

func (p *Event) FloodRate() (int64, bool) {
	if p.floodRate != nil {
		return *p.floodRate, true
	}
	var zero int64
	return zero, false
}

func (p *Event) MustFloodRate() int64 {
	if p.floodRate == nil {
		panic("the floodRate must not be nil, please use FloodRate() function instead")
	}
	return *p.floodRate
}

func (p *Event) SetHost(attr *Host) {
	p.host = attr
}

func (p *Event) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *Event) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *Event) SetId(attr string) {
	p.id = &attr
}

func (p *Event) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Event) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Event) SetIndex(attr int64) {
	p.index = &attr
}

func (p *Event) Index() (int64, bool) {
	if p.index != nil {
		return *p.index, true
	}
	var zero int64
	return zero, false
}

func (p *Event) MustIndex() int64 {
	if p.index == nil {
		panic("the index must not be nil, please use Index() function instead")
	}
	return *p.index
}

func (p *Event) SetLogOnHost(attr bool) {
	p.logOnHost = &attr
}

func (p *Event) LogOnHost() (bool, bool) {
	if p.logOnHost != nil {
		return *p.logOnHost, true
	}
	var zero bool
	return zero, false
}

func (p *Event) MustLogOnHost() bool {
	if p.logOnHost == nil {
		panic("the logOnHost must not be nil, please use LogOnHost() function instead")
	}
	return *p.logOnHost
}

func (p *Event) SetName(attr string) {
	p.name = &attr
}

func (p *Event) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Event) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Event) SetOrigin(attr string) {
	p.origin = &attr
}

func (p *Event) Origin() (string, bool) {
	if p.origin != nil {
		return *p.origin, true
	}
	var zero string
	return zero, false
}

func (p *Event) MustOrigin() string {
	if p.origin == nil {
		panic("the origin must not be nil, please use Origin() function instead")
	}
	return *p.origin
}

func (p *Event) SetSeverity(attr LogSeverity) {
	p.severity = &attr
}

func (p *Event) Severity() (LogSeverity, bool) {
	if p.severity != nil {
		return *p.severity, true
	}
	var zero LogSeverity
	return zero, false
}

func (p *Event) MustSeverity() LogSeverity {
	if p.severity == nil {
		panic("the severity must not be nil, please use Severity() function instead")
	}
	return *p.severity
}

func (p *Event) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *Event) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *Event) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *Event) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Event) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Event) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Event) SetTime(attr time.Time) {
	p.time = &attr
}

func (p *Event) Time() (time.Time, bool) {
	if p.time != nil {
		return *p.time, true
	}
	var zero time.Time
	return zero, false
}

func (p *Event) MustTime() time.Time {
	if p.time == nil {
		panic("the time must not be nil, please use Time() function instead")
	}
	return *p.time
}

func (p *Event) SetUser(attr *User) {
	p.user = attr
}

func (p *Event) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *Event) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

func (p *Event) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Event) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Event) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type File struct {
	Struct
	comment       *string
	content       *string
	description   *string
	id            *string
	name          *string
	storageDomain *StorageDomain
	type_         *string
}

func (p *File) SetComment(attr string) {
	p.comment = &attr
}

func (p *File) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *File) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *File) SetContent(attr string) {
	p.content = &attr
}

func (p *File) Content() (string, bool) {
	if p.content != nil {
		return *p.content, true
	}
	var zero string
	return zero, false
}

func (p *File) MustContent() string {
	if p.content == nil {
		panic("the content must not be nil, please use Content() function instead")
	}
	return *p.content
}

func (p *File) SetDescription(attr string) {
	p.description = &attr
}

func (p *File) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *File) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *File) SetId(attr string) {
	p.id = &attr
}

func (p *File) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *File) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *File) SetName(attr string) {
	p.name = &attr
}

func (p *File) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *File) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *File) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *File) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *File) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *File) SetType(attr string) {
	p.type_ = &attr
}

func (p *File) Type() (string, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero string
	return zero, false
}

func (p *File) MustType() string {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type LogicalUnit struct {
	Struct
	address           *string
	discardMaxSize    *int64
	discardZeroesData *bool
	diskId            *string
	id                *string
	lunMapping        *int64
	password          *string
	paths             *int64
	port              *int64
	portal            *string
	productId         *string
	serial            *string
	size              *int64
	status            *LunStatus
	storageDomainId   *string
	target            *string
	username          *string
	vendorId          *string
	volumeGroupId     *string
}

func (p *LogicalUnit) SetAddress(attr string) {
	p.address = &attr
}

func (p *LogicalUnit) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *LogicalUnit) SetDiscardMaxSize(attr int64) {
	p.discardMaxSize = &attr
}

func (p *LogicalUnit) DiscardMaxSize() (int64, bool) {
	if p.discardMaxSize != nil {
		return *p.discardMaxSize, true
	}
	var zero int64
	return zero, false
}

func (p *LogicalUnit) MustDiscardMaxSize() int64 {
	if p.discardMaxSize == nil {
		panic("the discardMaxSize must not be nil, please use DiscardMaxSize() function instead")
	}
	return *p.discardMaxSize
}

func (p *LogicalUnit) SetDiscardZeroesData(attr bool) {
	p.discardZeroesData = &attr
}

func (p *LogicalUnit) DiscardZeroesData() (bool, bool) {
	if p.discardZeroesData != nil {
		return *p.discardZeroesData, true
	}
	var zero bool
	return zero, false
}

func (p *LogicalUnit) MustDiscardZeroesData() bool {
	if p.discardZeroesData == nil {
		panic("the discardZeroesData must not be nil, please use DiscardZeroesData() function instead")
	}
	return *p.discardZeroesData
}

func (p *LogicalUnit) SetDiskId(attr string) {
	p.diskId = &attr
}

func (p *LogicalUnit) DiskId() (string, bool) {
	if p.diskId != nil {
		return *p.diskId, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustDiskId() string {
	if p.diskId == nil {
		panic("the diskId must not be nil, please use DiskId() function instead")
	}
	return *p.diskId
}

func (p *LogicalUnit) SetId(attr string) {
	p.id = &attr
}

func (p *LogicalUnit) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *LogicalUnit) SetLunMapping(attr int64) {
	p.lunMapping = &attr
}

func (p *LogicalUnit) LunMapping() (int64, bool) {
	if p.lunMapping != nil {
		return *p.lunMapping, true
	}
	var zero int64
	return zero, false
}

func (p *LogicalUnit) MustLunMapping() int64 {
	if p.lunMapping == nil {
		panic("the lunMapping must not be nil, please use LunMapping() function instead")
	}
	return *p.lunMapping
}

func (p *LogicalUnit) SetPassword(attr string) {
	p.password = &attr
}

func (p *LogicalUnit) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *LogicalUnit) SetPaths(attr int64) {
	p.paths = &attr
}

func (p *LogicalUnit) Paths() (int64, bool) {
	if p.paths != nil {
		return *p.paths, true
	}
	var zero int64
	return zero, false
}

func (p *LogicalUnit) MustPaths() int64 {
	if p.paths == nil {
		panic("the paths must not be nil, please use Paths() function instead")
	}
	return *p.paths
}

func (p *LogicalUnit) SetPort(attr int64) {
	p.port = &attr
}

func (p *LogicalUnit) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *LogicalUnit) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *LogicalUnit) SetPortal(attr string) {
	p.portal = &attr
}

func (p *LogicalUnit) Portal() (string, bool) {
	if p.portal != nil {
		return *p.portal, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustPortal() string {
	if p.portal == nil {
		panic("the portal must not be nil, please use Portal() function instead")
	}
	return *p.portal
}

func (p *LogicalUnit) SetProductId(attr string) {
	p.productId = &attr
}

func (p *LogicalUnit) ProductId() (string, bool) {
	if p.productId != nil {
		return *p.productId, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustProductId() string {
	if p.productId == nil {
		panic("the productId must not be nil, please use ProductId() function instead")
	}
	return *p.productId
}

func (p *LogicalUnit) SetSerial(attr string) {
	p.serial = &attr
}

func (p *LogicalUnit) Serial() (string, bool) {
	if p.serial != nil {
		return *p.serial, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustSerial() string {
	if p.serial == nil {
		panic("the serial must not be nil, please use Serial() function instead")
	}
	return *p.serial
}

func (p *LogicalUnit) SetSize(attr int64) {
	p.size = &attr
}

func (p *LogicalUnit) Size() (int64, bool) {
	if p.size != nil {
		return *p.size, true
	}
	var zero int64
	return zero, false
}

func (p *LogicalUnit) MustSize() int64 {
	if p.size == nil {
		panic("the size must not be nil, please use Size() function instead")
	}
	return *p.size
}

func (p *LogicalUnit) SetStatus(attr LunStatus) {
	p.status = &attr
}

func (p *LogicalUnit) Status() (LunStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero LunStatus
	return zero, false
}

func (p *LogicalUnit) MustStatus() LunStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *LogicalUnit) SetStorageDomainId(attr string) {
	p.storageDomainId = &attr
}

func (p *LogicalUnit) StorageDomainId() (string, bool) {
	if p.storageDomainId != nil {
		return *p.storageDomainId, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustStorageDomainId() string {
	if p.storageDomainId == nil {
		panic("the storageDomainId must not be nil, please use StorageDomainId() function instead")
	}
	return *p.storageDomainId
}

func (p *LogicalUnit) SetTarget(attr string) {
	p.target = &attr
}

func (p *LogicalUnit) Target() (string, bool) {
	if p.target != nil {
		return *p.target, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustTarget() string {
	if p.target == nil {
		panic("the target must not be nil, please use Target() function instead")
	}
	return *p.target
}

func (p *LogicalUnit) SetUsername(attr string) {
	p.username = &attr
}

func (p *LogicalUnit) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

func (p *LogicalUnit) SetVendorId(attr string) {
	p.vendorId = &attr
}

func (p *LogicalUnit) VendorId() (string, bool) {
	if p.vendorId != nil {
		return *p.vendorId, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustVendorId() string {
	if p.vendorId == nil {
		panic("the vendorId must not be nil, please use VendorId() function instead")
	}
	return *p.vendorId
}

func (p *LogicalUnit) SetVolumeGroupId(attr string) {
	p.volumeGroupId = &attr
}

func (p *LogicalUnit) VolumeGroupId() (string, bool) {
	if p.volumeGroupId != nil {
		return *p.volumeGroupId, true
	}
	var zero string
	return zero, false
}

func (p *LogicalUnit) MustVolumeGroupId() string {
	if p.volumeGroupId == nil {
		panic("the volumeGroupId must not be nil, please use VolumeGroupId() function instead")
	}
	return *p.volumeGroupId
}

type Application struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
	vm          *Vm
}

func (p *Application) SetComment(attr string) {
	p.comment = &attr
}

func (p *Application) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Application) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Application) SetDescription(attr string) {
	p.description = &attr
}

func (p *Application) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Application) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Application) SetId(attr string) {
	p.id = &attr
}

func (p *Application) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Application) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Application) SetName(attr string) {
	p.name = &attr
}

func (p *Application) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Application) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Application) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Application) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Application) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type ImageTransfer struct {
	Struct
	active            *bool
	backup            *Backup
	comment           *string
	description       *string
	direction         *ImageTransferDirection
	disk              *Disk
	format            *DiskFormat
	host              *Host
	id                *string
	image             *Image
	inactivityTimeout *int64
	name              *string
	phase             *ImageTransferPhase
	proxyUrl          *string
	shallow           *bool
	snapshot          *DiskSnapshot
	transferUrl       *string
	transferred       *int64
}

func (p *ImageTransfer) SetActive(attr bool) {
	p.active = &attr
}

func (p *ImageTransfer) Active() (bool, bool) {
	if p.active != nil {
		return *p.active, true
	}
	var zero bool
	return zero, false
}

func (p *ImageTransfer) MustActive() bool {
	if p.active == nil {
		panic("the active must not be nil, please use Active() function instead")
	}
	return *p.active
}

func (p *ImageTransfer) SetBackup(attr *Backup) {
	p.backup = attr
}

func (p *ImageTransfer) Backup() (*Backup, bool) {
	if p.backup != nil {
		return p.backup, true
	}
	return nil, false
}

func (p *ImageTransfer) MustBackup() *Backup {
	if p.backup == nil {
		panic("the backup must not be nil, please use Backup() function instead")
	}
	return p.backup
}

func (p *ImageTransfer) SetComment(attr string) {
	p.comment = &attr
}

func (p *ImageTransfer) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ImageTransfer) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ImageTransfer) SetDescription(attr string) {
	p.description = &attr
}

func (p *ImageTransfer) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ImageTransfer) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ImageTransfer) SetDirection(attr ImageTransferDirection) {
	p.direction = &attr
}

func (p *ImageTransfer) Direction() (ImageTransferDirection, bool) {
	if p.direction != nil {
		return *p.direction, true
	}
	var zero ImageTransferDirection
	return zero, false
}

func (p *ImageTransfer) MustDirection() ImageTransferDirection {
	if p.direction == nil {
		panic("the direction must not be nil, please use Direction() function instead")
	}
	return *p.direction
}

func (p *ImageTransfer) SetDisk(attr *Disk) {
	p.disk = attr
}

func (p *ImageTransfer) Disk() (*Disk, bool) {
	if p.disk != nil {
		return p.disk, true
	}
	return nil, false
}

func (p *ImageTransfer) MustDisk() *Disk {
	if p.disk == nil {
		panic("the disk must not be nil, please use Disk() function instead")
	}
	return p.disk
}

func (p *ImageTransfer) SetFormat(attr DiskFormat) {
	p.format = &attr
}

func (p *ImageTransfer) Format() (DiskFormat, bool) {
	if p.format != nil {
		return *p.format, true
	}
	var zero DiskFormat
	return zero, false
}

func (p *ImageTransfer) MustFormat() DiskFormat {
	if p.format == nil {
		panic("the format must not be nil, please use Format() function instead")
	}
	return *p.format
}

func (p *ImageTransfer) SetHost(attr *Host) {
	p.host = attr
}

func (p *ImageTransfer) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *ImageTransfer) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *ImageTransfer) SetId(attr string) {
	p.id = &attr
}

func (p *ImageTransfer) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ImageTransfer) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ImageTransfer) SetImage(attr *Image) {
	p.image = attr
}

func (p *ImageTransfer) Image() (*Image, bool) {
	if p.image != nil {
		return p.image, true
	}
	return nil, false
}

func (p *ImageTransfer) MustImage() *Image {
	if p.image == nil {
		panic("the image must not be nil, please use Image() function instead")
	}
	return p.image
}

func (p *ImageTransfer) SetInactivityTimeout(attr int64) {
	p.inactivityTimeout = &attr
}

func (p *ImageTransfer) InactivityTimeout() (int64, bool) {
	if p.inactivityTimeout != nil {
		return *p.inactivityTimeout, true
	}
	var zero int64
	return zero, false
}

func (p *ImageTransfer) MustInactivityTimeout() int64 {
	if p.inactivityTimeout == nil {
		panic("the inactivityTimeout must not be nil, please use InactivityTimeout() function instead")
	}
	return *p.inactivityTimeout
}

func (p *ImageTransfer) SetName(attr string) {
	p.name = &attr
}

func (p *ImageTransfer) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ImageTransfer) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ImageTransfer) SetPhase(attr ImageTransferPhase) {
	p.phase = &attr
}

func (p *ImageTransfer) Phase() (ImageTransferPhase, bool) {
	if p.phase != nil {
		return *p.phase, true
	}
	var zero ImageTransferPhase
	return zero, false
}

func (p *ImageTransfer) MustPhase() ImageTransferPhase {
	if p.phase == nil {
		panic("the phase must not be nil, please use Phase() function instead")
	}
	return *p.phase
}

func (p *ImageTransfer) SetProxyUrl(attr string) {
	p.proxyUrl = &attr
}

func (p *ImageTransfer) ProxyUrl() (string, bool) {
	if p.proxyUrl != nil {
		return *p.proxyUrl, true
	}
	var zero string
	return zero, false
}

func (p *ImageTransfer) MustProxyUrl() string {
	if p.proxyUrl == nil {
		panic("the proxyUrl must not be nil, please use ProxyUrl() function instead")
	}
	return *p.proxyUrl
}

func (p *ImageTransfer) SetShallow(attr bool) {
	p.shallow = &attr
}

func (p *ImageTransfer) Shallow() (bool, bool) {
	if p.shallow != nil {
		return *p.shallow, true
	}
	var zero bool
	return zero, false
}

func (p *ImageTransfer) MustShallow() bool {
	if p.shallow == nil {
		panic("the shallow must not be nil, please use Shallow() function instead")
	}
	return *p.shallow
}

func (p *ImageTransfer) SetSnapshot(attr *DiskSnapshot) {
	p.snapshot = attr
}

func (p *ImageTransfer) Snapshot() (*DiskSnapshot, bool) {
	if p.snapshot != nil {
		return p.snapshot, true
	}
	return nil, false
}

func (p *ImageTransfer) MustSnapshot() *DiskSnapshot {
	if p.snapshot == nil {
		panic("the snapshot must not be nil, please use Snapshot() function instead")
	}
	return p.snapshot
}

func (p *ImageTransfer) SetTransferUrl(attr string) {
	p.transferUrl = &attr
}

func (p *ImageTransfer) TransferUrl() (string, bool) {
	if p.transferUrl != nil {
		return *p.transferUrl, true
	}
	var zero string
	return zero, false
}

func (p *ImageTransfer) MustTransferUrl() string {
	if p.transferUrl == nil {
		panic("the transferUrl must not be nil, please use TransferUrl() function instead")
	}
	return *p.transferUrl
}

func (p *ImageTransfer) SetTransferred(attr int64) {
	p.transferred = &attr
}

func (p *ImageTransfer) Transferred() (int64, bool) {
	if p.transferred != nil {
		return *p.transferred, true
	}
	var zero int64
	return zero, false
}

func (p *ImageTransfer) MustTransferred() int64 {
	if p.transferred == nil {
		panic("the transferred must not be nil, please use Transferred() function instead")
	}
	return *p.transferred
}

type Ip struct {
	Struct
	address *string
	gateway *string
	netmask *string
	version *IpVersion
}

func (p *Ip) SetAddress(attr string) {
	p.address = &attr
}

func (p *Ip) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *Ip) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *Ip) SetGateway(attr string) {
	p.gateway = &attr
}

func (p *Ip) Gateway() (string, bool) {
	if p.gateway != nil {
		return *p.gateway, true
	}
	var zero string
	return zero, false
}

func (p *Ip) MustGateway() string {
	if p.gateway == nil {
		panic("the gateway must not be nil, please use Gateway() function instead")
	}
	return *p.gateway
}

func (p *Ip) SetNetmask(attr string) {
	p.netmask = &attr
}

func (p *Ip) Netmask() (string, bool) {
	if p.netmask != nil {
		return *p.netmask, true
	}
	var zero string
	return zero, false
}

func (p *Ip) MustNetmask() string {
	if p.netmask == nil {
		panic("the netmask must not be nil, please use Netmask() function instead")
	}
	return *p.netmask
}

func (p *Ip) SetVersion(attr IpVersion) {
	p.version = &attr
}

func (p *Ip) Version() (IpVersion, bool) {
	if p.version != nil {
		return *p.version, true
	}
	var zero IpVersion
	return zero, false
}

func (p *Ip) MustVersion() IpVersion {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return *p.version
}

type VnicProfileMapping struct {
	Struct
	sourceNetworkName        *string
	sourceNetworkProfileName *string
	targetVnicProfile        *VnicProfile
}

func (p *VnicProfileMapping) SetSourceNetworkName(attr string) {
	p.sourceNetworkName = &attr
}

func (p *VnicProfileMapping) SourceNetworkName() (string, bool) {
	if p.sourceNetworkName != nil {
		return *p.sourceNetworkName, true
	}
	var zero string
	return zero, false
}

func (p *VnicProfileMapping) MustSourceNetworkName() string {
	if p.sourceNetworkName == nil {
		panic("the sourceNetworkName must not be nil, please use SourceNetworkName() function instead")
	}
	return *p.sourceNetworkName
}

func (p *VnicProfileMapping) SetSourceNetworkProfileName(attr string) {
	p.sourceNetworkProfileName = &attr
}

func (p *VnicProfileMapping) SourceNetworkProfileName() (string, bool) {
	if p.sourceNetworkProfileName != nil {
		return *p.sourceNetworkProfileName, true
	}
	var zero string
	return zero, false
}

func (p *VnicProfileMapping) MustSourceNetworkProfileName() string {
	if p.sourceNetworkProfileName == nil {
		panic("the sourceNetworkProfileName must not be nil, please use SourceNetworkProfileName() function instead")
	}
	return *p.sourceNetworkProfileName
}

func (p *VnicProfileMapping) SetTargetVnicProfile(attr *VnicProfile) {
	p.targetVnicProfile = attr
}

func (p *VnicProfileMapping) TargetVnicProfile() (*VnicProfile, bool) {
	if p.targetVnicProfile != nil {
		return p.targetVnicProfile, true
	}
	return nil, false
}

func (p *VnicProfileMapping) MustTargetVnicProfile() *VnicProfile {
	if p.targetVnicProfile == nil {
		panic("the targetVnicProfile must not be nil, please use TargetVnicProfile() function instead")
	}
	return p.targetVnicProfile
}

type SystemOption struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
	values      *SystemOptionValueSlice
}

func (p *SystemOption) SetComment(attr string) {
	p.comment = &attr
}

func (p *SystemOption) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *SystemOption) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *SystemOption) SetDescription(attr string) {
	p.description = &attr
}

func (p *SystemOption) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *SystemOption) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *SystemOption) SetId(attr string) {
	p.id = &attr
}

func (p *SystemOption) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *SystemOption) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *SystemOption) SetName(attr string) {
	p.name = &attr
}

func (p *SystemOption) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *SystemOption) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *SystemOption) SetValues(attr *SystemOptionValueSlice) {
	p.values = attr
}

func (p *SystemOption) Values() (*SystemOptionValueSlice, bool) {
	if p.values != nil {
		return p.values, true
	}
	return nil, false
}

func (p *SystemOption) MustValues() *SystemOptionValueSlice {
	if p.values == nil {
		panic("the values must not be nil, please use Values() function instead")
	}
	return p.values
}

type GlusterBrick struct {
	Struct
	brickDir       *string
	comment        *string
	description    *string
	device         *string
	fsName         *string
	glusterClients *GlusterClientSlice
	glusterVolume  *GlusterVolume
	id             *string
	instanceType   *InstanceType
	memoryPools    *GlusterMemoryPoolSlice
	mntOptions     *string
	name           *string
	pid            *int64
	port           *int64
	serverId       *string
	statistics     *StatisticSlice
	status         *GlusterBrickStatus
	template       *Template
	vm             *Vm
	vms            *VmSlice
}

func (p *GlusterBrick) SetBrickDir(attr string) {
	p.brickDir = &attr
}

func (p *GlusterBrick) BrickDir() (string, bool) {
	if p.brickDir != nil {
		return *p.brickDir, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrick) MustBrickDir() string {
	if p.brickDir == nil {
		panic("the brickDir must not be nil, please use BrickDir() function instead")
	}
	return *p.brickDir
}

func (p *GlusterBrick) SetComment(attr string) {
	p.comment = &attr
}

func (p *GlusterBrick) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrick) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *GlusterBrick) SetDescription(attr string) {
	p.description = &attr
}

func (p *GlusterBrick) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrick) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *GlusterBrick) SetDevice(attr string) {
	p.device = &attr
}

func (p *GlusterBrick) Device() (string, bool) {
	if p.device != nil {
		return *p.device, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrick) MustDevice() string {
	if p.device == nil {
		panic("the device must not be nil, please use Device() function instead")
	}
	return *p.device
}

func (p *GlusterBrick) SetFsName(attr string) {
	p.fsName = &attr
}

func (p *GlusterBrick) FsName() (string, bool) {
	if p.fsName != nil {
		return *p.fsName, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrick) MustFsName() string {
	if p.fsName == nil {
		panic("the fsName must not be nil, please use FsName() function instead")
	}
	return *p.fsName
}

func (p *GlusterBrick) SetGlusterClients(attr *GlusterClientSlice) {
	p.glusterClients = attr
}

func (p *GlusterBrick) GlusterClients() (*GlusterClientSlice, bool) {
	if p.glusterClients != nil {
		return p.glusterClients, true
	}
	return nil, false
}

func (p *GlusterBrick) MustGlusterClients() *GlusterClientSlice {
	if p.glusterClients == nil {
		panic("the glusterClients must not be nil, please use GlusterClients() function instead")
	}
	return p.glusterClients
}

func (p *GlusterBrick) SetGlusterVolume(attr *GlusterVolume) {
	p.glusterVolume = attr
}

func (p *GlusterBrick) GlusterVolume() (*GlusterVolume, bool) {
	if p.glusterVolume != nil {
		return p.glusterVolume, true
	}
	return nil, false
}

func (p *GlusterBrick) MustGlusterVolume() *GlusterVolume {
	if p.glusterVolume == nil {
		panic("the glusterVolume must not be nil, please use GlusterVolume() function instead")
	}
	return p.glusterVolume
}

func (p *GlusterBrick) SetId(attr string) {
	p.id = &attr
}

func (p *GlusterBrick) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrick) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *GlusterBrick) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *GlusterBrick) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *GlusterBrick) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *GlusterBrick) SetMemoryPools(attr *GlusterMemoryPoolSlice) {
	p.memoryPools = attr
}

func (p *GlusterBrick) MemoryPools() (*GlusterMemoryPoolSlice, bool) {
	if p.memoryPools != nil {
		return p.memoryPools, true
	}
	return nil, false
}

func (p *GlusterBrick) MustMemoryPools() *GlusterMemoryPoolSlice {
	if p.memoryPools == nil {
		panic("the memoryPools must not be nil, please use MemoryPools() function instead")
	}
	return p.memoryPools
}

func (p *GlusterBrick) SetMntOptions(attr string) {
	p.mntOptions = &attr
}

func (p *GlusterBrick) MntOptions() (string, bool) {
	if p.mntOptions != nil {
		return *p.mntOptions, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrick) MustMntOptions() string {
	if p.mntOptions == nil {
		panic("the mntOptions must not be nil, please use MntOptions() function instead")
	}
	return *p.mntOptions
}

func (p *GlusterBrick) SetName(attr string) {
	p.name = &attr
}

func (p *GlusterBrick) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrick) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *GlusterBrick) SetPid(attr int64) {
	p.pid = &attr
}

func (p *GlusterBrick) Pid() (int64, bool) {
	if p.pid != nil {
		return *p.pid, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterBrick) MustPid() int64 {
	if p.pid == nil {
		panic("the pid must not be nil, please use Pid() function instead")
	}
	return *p.pid
}

func (p *GlusterBrick) SetPort(attr int64) {
	p.port = &attr
}

func (p *GlusterBrick) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterBrick) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *GlusterBrick) SetServerId(attr string) {
	p.serverId = &attr
}

func (p *GlusterBrick) ServerId() (string, bool) {
	if p.serverId != nil {
		return *p.serverId, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrick) MustServerId() string {
	if p.serverId == nil {
		panic("the serverId must not be nil, please use ServerId() function instead")
	}
	return *p.serverId
}

func (p *GlusterBrick) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *GlusterBrick) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *GlusterBrick) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *GlusterBrick) SetStatus(attr GlusterBrickStatus) {
	p.status = &attr
}

func (p *GlusterBrick) Status() (GlusterBrickStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero GlusterBrickStatus
	return zero, false
}

func (p *GlusterBrick) MustStatus() GlusterBrickStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *GlusterBrick) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *GlusterBrick) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *GlusterBrick) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *GlusterBrick) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *GlusterBrick) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *GlusterBrick) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *GlusterBrick) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *GlusterBrick) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *GlusterBrick) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

type OpenStackProvider struct {
	Struct
	authenticationUrl      *string
	comment                *string
	description            *string
	id                     *string
	name                   *string
	password               *string
	properties             *PropertySlice
	requiresAuthentication *bool
	tenantName             *string
	url                    *string
	username               *string
}

func (p *OpenStackProvider) SetAuthenticationUrl(attr string) {
	p.authenticationUrl = &attr
}

func (p *OpenStackProvider) AuthenticationUrl() (string, bool) {
	if p.authenticationUrl != nil {
		return *p.authenticationUrl, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackProvider) MustAuthenticationUrl() string {
	if p.authenticationUrl == nil {
		panic("the authenticationUrl must not be nil, please use AuthenticationUrl() function instead")
	}
	return *p.authenticationUrl
}

func (p *OpenStackProvider) SetComment(attr string) {
	p.comment = &attr
}

func (p *OpenStackProvider) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackProvider) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OpenStackProvider) SetDescription(attr string) {
	p.description = &attr
}

func (p *OpenStackProvider) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackProvider) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OpenStackProvider) SetId(attr string) {
	p.id = &attr
}

func (p *OpenStackProvider) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackProvider) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OpenStackProvider) SetName(attr string) {
	p.name = &attr
}

func (p *OpenStackProvider) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackProvider) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OpenStackProvider) SetPassword(attr string) {
	p.password = &attr
}

func (p *OpenStackProvider) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackProvider) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *OpenStackProvider) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *OpenStackProvider) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *OpenStackProvider) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *OpenStackProvider) SetRequiresAuthentication(attr bool) {
	p.requiresAuthentication = &attr
}

func (p *OpenStackProvider) RequiresAuthentication() (bool, bool) {
	if p.requiresAuthentication != nil {
		return *p.requiresAuthentication, true
	}
	var zero bool
	return zero, false
}

func (p *OpenStackProvider) MustRequiresAuthentication() bool {
	if p.requiresAuthentication == nil {
		panic("the requiresAuthentication must not be nil, please use RequiresAuthentication() function instead")
	}
	return *p.requiresAuthentication
}

func (p *OpenStackProvider) SetTenantName(attr string) {
	p.tenantName = &attr
}

func (p *OpenStackProvider) TenantName() (string, bool) {
	if p.tenantName != nil {
		return *p.tenantName, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackProvider) MustTenantName() string {
	if p.tenantName == nil {
		panic("the tenantName must not be nil, please use TenantName() function instead")
	}
	return *p.tenantName
}

func (p *OpenStackProvider) SetUrl(attr string) {
	p.url = &attr
}

func (p *OpenStackProvider) Url() (string, bool) {
	if p.url != nil {
		return *p.url, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackProvider) MustUrl() string {
	if p.url == nil {
		panic("the url must not be nil, please use Url() function instead")
	}
	return *p.url
}

func (p *OpenStackProvider) SetUsername(attr string) {
	p.username = &attr
}

func (p *OpenStackProvider) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackProvider) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

type RegistrationClusterMapping struct {
	Struct
	from *Cluster
	to   *Cluster
}

func (p *RegistrationClusterMapping) SetFrom(attr *Cluster) {
	p.from = attr
}

func (p *RegistrationClusterMapping) From() (*Cluster, bool) {
	if p.from != nil {
		return p.from, true
	}
	return nil, false
}

func (p *RegistrationClusterMapping) MustFrom() *Cluster {
	if p.from == nil {
		panic("the from must not be nil, please use From() function instead")
	}
	return p.from
}

func (p *RegistrationClusterMapping) SetTo(attr *Cluster) {
	p.to = attr
}

func (p *RegistrationClusterMapping) To() (*Cluster, bool) {
	if p.to != nil {
		return p.to, true
	}
	return nil, false
}

func (p *RegistrationClusterMapping) MustTo() *Cluster {
	if p.to == nil {
		panic("the to must not be nil, please use To() function instead")
	}
	return p.to
}

type SystemOptionValue struct {
	Struct
	value   *string
	version *string
}

func (p *SystemOptionValue) SetValue(attr string) {
	p.value = &attr
}

func (p *SystemOptionValue) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *SystemOptionValue) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

func (p *SystemOptionValue) SetVersion(attr string) {
	p.version = &attr
}

func (p *SystemOptionValue) Version() (string, bool) {
	if p.version != nil {
		return *p.version, true
	}
	var zero string
	return zero, false
}

func (p *SystemOptionValue) MustVersion() string {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return *p.version
}

type Bonding struct {
	Struct
	activeSlave  *HostNic
	adPartnerMac *Mac
	options      *OptionSlice
	slaves       *HostNicSlice
}

func (p *Bonding) SetActiveSlave(attr *HostNic) {
	p.activeSlave = attr
}

func (p *Bonding) ActiveSlave() (*HostNic, bool) {
	if p.activeSlave != nil {
		return p.activeSlave, true
	}
	return nil, false
}

func (p *Bonding) MustActiveSlave() *HostNic {
	if p.activeSlave == nil {
		panic("the activeSlave must not be nil, please use ActiveSlave() function instead")
	}
	return p.activeSlave
}

func (p *Bonding) SetAdPartnerMac(attr *Mac) {
	p.adPartnerMac = attr
}

func (p *Bonding) AdPartnerMac() (*Mac, bool) {
	if p.adPartnerMac != nil {
		return p.adPartnerMac, true
	}
	return nil, false
}

func (p *Bonding) MustAdPartnerMac() *Mac {
	if p.adPartnerMac == nil {
		panic("the adPartnerMac must not be nil, please use AdPartnerMac() function instead")
	}
	return p.adPartnerMac
}

func (p *Bonding) SetOptions(attr *OptionSlice) {
	p.options = attr
}

func (p *Bonding) Options() (*OptionSlice, bool) {
	if p.options != nil {
		return p.options, true
	}
	return nil, false
}

func (p *Bonding) MustOptions() *OptionSlice {
	if p.options == nil {
		panic("the options must not be nil, please use Options() function instead")
	}
	return p.options
}

func (p *Bonding) SetSlaves(attr *HostNicSlice) {
	p.slaves = attr
}

func (p *Bonding) Slaves() (*HostNicSlice, bool) {
	if p.slaves != nil {
		return p.slaves, true
	}
	return nil, false
}

func (p *Bonding) MustSlaves() *HostNicSlice {
	if p.slaves == nil {
		panic("the slaves must not be nil, please use Slaves() function instead")
	}
	return p.slaves
}

type SeLinux struct {
	Struct
	mode *SeLinuxMode
}

func (p *SeLinux) SetMode(attr SeLinuxMode) {
	p.mode = &attr
}

func (p *SeLinux) Mode() (SeLinuxMode, bool) {
	if p.mode != nil {
		return *p.mode, true
	}
	var zero SeLinuxMode
	return zero, false
}

func (p *SeLinux) MustMode() SeLinuxMode {
	if p.mode == nil {
		panic("the mode must not be nil, please use Mode() function instead")
	}
	return *p.mode
}

type Api struct {
	Struct
	authenticatedUser *User
	effectiveUser     *User
	productInfo       *ProductInfo
	specialObjects    *SpecialObjects
	summary           *ApiSummary
	time              *time.Time
}

func (p *Api) SetAuthenticatedUser(attr *User) {
	p.authenticatedUser = attr
}

func (p *Api) AuthenticatedUser() (*User, bool) {
	if p.authenticatedUser != nil {
		return p.authenticatedUser, true
	}
	return nil, false
}

func (p *Api) MustAuthenticatedUser() *User {
	if p.authenticatedUser == nil {
		panic("the authenticatedUser must not be nil, please use AuthenticatedUser() function instead")
	}
	return p.authenticatedUser
}

func (p *Api) SetEffectiveUser(attr *User) {
	p.effectiveUser = attr
}

func (p *Api) EffectiveUser() (*User, bool) {
	if p.effectiveUser != nil {
		return p.effectiveUser, true
	}
	return nil, false
}

func (p *Api) MustEffectiveUser() *User {
	if p.effectiveUser == nil {
		panic("the effectiveUser must not be nil, please use EffectiveUser() function instead")
	}
	return p.effectiveUser
}

func (p *Api) SetProductInfo(attr *ProductInfo) {
	p.productInfo = attr
}

func (p *Api) ProductInfo() (*ProductInfo, bool) {
	if p.productInfo != nil {
		return p.productInfo, true
	}
	return nil, false
}

func (p *Api) MustProductInfo() *ProductInfo {
	if p.productInfo == nil {
		panic("the productInfo must not be nil, please use ProductInfo() function instead")
	}
	return p.productInfo
}

func (p *Api) SetSpecialObjects(attr *SpecialObjects) {
	p.specialObjects = attr
}

func (p *Api) SpecialObjects() (*SpecialObjects, bool) {
	if p.specialObjects != nil {
		return p.specialObjects, true
	}
	return nil, false
}

func (p *Api) MustSpecialObjects() *SpecialObjects {
	if p.specialObjects == nil {
		panic("the specialObjects must not be nil, please use SpecialObjects() function instead")
	}
	return p.specialObjects
}

func (p *Api) SetSummary(attr *ApiSummary) {
	p.summary = attr
}

func (p *Api) Summary() (*ApiSummary, bool) {
	if p.summary != nil {
		return p.summary, true
	}
	return nil, false
}

func (p *Api) MustSummary() *ApiSummary {
	if p.summary == nil {
		panic("the summary must not be nil, please use Summary() function instead")
	}
	return p.summary
}

func (p *Api) SetTime(attr time.Time) {
	p.time = &attr
}

func (p *Api) Time() (time.Time, bool) {
	if p.time != nil {
		return *p.time, true
	}
	var zero time.Time
	return zero, false
}

func (p *Api) MustTime() time.Time {
	if p.time == nil {
		panic("the time must not be nil, please use Time() function instead")
	}
	return *p.time
}

type MemoryPolicy struct {
	Struct
	ballooning           *bool
	guaranteed           *int64
	max                  *int64
	overCommit           *MemoryOverCommit
	transparentHugePages *TransparentHugePages
}

func (p *MemoryPolicy) SetBallooning(attr bool) {
	p.ballooning = &attr
}

func (p *MemoryPolicy) Ballooning() (bool, bool) {
	if p.ballooning != nil {
		return *p.ballooning, true
	}
	var zero bool
	return zero, false
}

func (p *MemoryPolicy) MustBallooning() bool {
	if p.ballooning == nil {
		panic("the ballooning must not be nil, please use Ballooning() function instead")
	}
	return *p.ballooning
}

func (p *MemoryPolicy) SetGuaranteed(attr int64) {
	p.guaranteed = &attr
}

func (p *MemoryPolicy) Guaranteed() (int64, bool) {
	if p.guaranteed != nil {
		return *p.guaranteed, true
	}
	var zero int64
	return zero, false
}

func (p *MemoryPolicy) MustGuaranteed() int64 {
	if p.guaranteed == nil {
		panic("the guaranteed must not be nil, please use Guaranteed() function instead")
	}
	return *p.guaranteed
}

func (p *MemoryPolicy) SetMax(attr int64) {
	p.max = &attr
}

func (p *MemoryPolicy) Max() (int64, bool) {
	if p.max != nil {
		return *p.max, true
	}
	var zero int64
	return zero, false
}

func (p *MemoryPolicy) MustMax() int64 {
	if p.max == nil {
		panic("the max must not be nil, please use Max() function instead")
	}
	return *p.max
}

func (p *MemoryPolicy) SetOverCommit(attr *MemoryOverCommit) {
	p.overCommit = attr
}

func (p *MemoryPolicy) OverCommit() (*MemoryOverCommit, bool) {
	if p.overCommit != nil {
		return p.overCommit, true
	}
	return nil, false
}

func (p *MemoryPolicy) MustOverCommit() *MemoryOverCommit {
	if p.overCommit == nil {
		panic("the overCommit must not be nil, please use OverCommit() function instead")
	}
	return p.overCommit
}

func (p *MemoryPolicy) SetTransparentHugePages(attr *TransparentHugePages) {
	p.transparentHugePages = attr
}

func (p *MemoryPolicy) TransparentHugePages() (*TransparentHugePages, bool) {
	if p.transparentHugePages != nil {
		return p.transparentHugePages, true
	}
	return nil, false
}

func (p *MemoryPolicy) MustTransparentHugePages() *TransparentHugePages {
	if p.transparentHugePages == nil {
		panic("the transparentHugePages must not be nil, please use TransparentHugePages() function instead")
	}
	return p.transparentHugePages
}

type OpenStackNetwork struct {
	Struct
	comment                  *string
	description              *string
	id                       *string
	name                     *string
	openstackNetworkProvider *OpenStackNetworkProvider
}

func (p *OpenStackNetwork) SetComment(attr string) {
	p.comment = &attr
}

func (p *OpenStackNetwork) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetwork) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OpenStackNetwork) SetDescription(attr string) {
	p.description = &attr
}

func (p *OpenStackNetwork) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetwork) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OpenStackNetwork) SetId(attr string) {
	p.id = &attr
}

func (p *OpenStackNetwork) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetwork) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OpenStackNetwork) SetName(attr string) {
	p.name = &attr
}

func (p *OpenStackNetwork) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetwork) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OpenStackNetwork) SetOpenstackNetworkProvider(attr *OpenStackNetworkProvider) {
	p.openstackNetworkProvider = attr
}

func (p *OpenStackNetwork) OpenstackNetworkProvider() (*OpenStackNetworkProvider, bool) {
	if p.openstackNetworkProvider != nil {
		return p.openstackNetworkProvider, true
	}
	return nil, false
}

func (p *OpenStackNetwork) MustOpenstackNetworkProvider() *OpenStackNetworkProvider {
	if p.openstackNetworkProvider == nil {
		panic("the openstackNetworkProvider must not be nil, please use OpenstackNetworkProvider() function instead")
	}
	return p.openstackNetworkProvider
}

type Vm struct {
	Struct
	affinityLabels              *AffinityLabelSlice
	applications                *ApplicationSlice
	bios                        *Bios
	cdroms                      *CdromSlice
	cluster                     *Cluster
	comment                     *string
	console                     *Console
	cpu                         *Cpu
	cpuProfile                  *CpuProfile
	cpuShares                   *int64
	creationTime                *time.Time
	customCompatibilityVersion  *Version
	customCpuModel              *string
	customEmulatedMachine       *string
	customProperties            *CustomPropertySlice
	deleteProtected             *bool
	description                 *string
	diskAttachments             *DiskAttachmentSlice
	display                     *Display
	domain                      *Domain
	externalHostProvider        *ExternalHostProvider
	floppies                    *FloppySlice
	fqdn                        *string
	graphicsConsoles            *GraphicsConsoleSlice
	guestOperatingSystem        *GuestOperatingSystem
	guestTimeZone               *TimeZone
	hasIllegalImages            *bool
	highAvailability            *HighAvailability
	host                        *Host
	hostDevices                 *HostDeviceSlice
	id                          *string
	initialization              *Initialization
	instanceType                *InstanceType
	io                          *Io
	katelloErrata               *KatelloErratumSlice
	largeIcon                   *Icon
	lease                       *StorageDomainLease
	memory                      *int64
	memoryPolicy                *MemoryPolicy
	migration                   *MigrationOptions
	migrationDowntime           *int64
	multiQueuesEnabled          *bool
	name                        *string
	nextRunConfigurationExists  *bool
	nics                        *NicSlice
	numaNodes                   *NumaNodeSlice
	numaTuneMode                *NumaTuneMode
	origin                      *string
	originalTemplate            *Template
	os                          *OperatingSystem
	payloads                    *PayloadSlice
	permissions                 *PermissionSlice
	placementPolicy             *VmPlacementPolicy
	quota                       *Quota
	reportedDevices             *ReportedDeviceSlice
	rngDevice                   *RngDevice
	runOnce                     *bool
	serialNumber                *SerialNumber
	sessions                    *SessionSlice
	smallIcon                   *Icon
	snapshots                   *SnapshotSlice
	soundcardEnabled            *bool
	sso                         *Sso
	startPaused                 *bool
	startTime                   *time.Time
	stateless                   *bool
	statistics                  *StatisticSlice
	status                      *VmStatus
	statusDetail                *string
	stopReason                  *string
	stopTime                    *time.Time
	storageDomain               *StorageDomain
	storageErrorResumeBehaviour *VmStorageErrorResumeBehaviour
	tags                        *TagSlice
	template                    *Template
	timeZone                    *TimeZone
	tunnelMigration             *bool
	type_                       *VmType
	usb                         *Usb
	useLatestTemplateVersion    *bool
	virtioScsi                  *VirtioScsi
	vmPool                      *VmPool
	watchdogs                   *WatchdogSlice
}

func (p *Vm) SetAffinityLabels(attr *AffinityLabelSlice) {
	p.affinityLabels = attr
}

func (p *Vm) AffinityLabels() (*AffinityLabelSlice, bool) {
	if p.affinityLabels != nil {
		return p.affinityLabels, true
	}
	return nil, false
}

func (p *Vm) MustAffinityLabels() *AffinityLabelSlice {
	if p.affinityLabels == nil {
		panic("the affinityLabels must not be nil, please use AffinityLabels() function instead")
	}
	return p.affinityLabels
}

func (p *Vm) SetApplications(attr *ApplicationSlice) {
	p.applications = attr
}

func (p *Vm) Applications() (*ApplicationSlice, bool) {
	if p.applications != nil {
		return p.applications, true
	}
	return nil, false
}

func (p *Vm) MustApplications() *ApplicationSlice {
	if p.applications == nil {
		panic("the applications must not be nil, please use Applications() function instead")
	}
	return p.applications
}

func (p *Vm) SetBios(attr *Bios) {
	p.bios = attr
}

func (p *Vm) Bios() (*Bios, bool) {
	if p.bios != nil {
		return p.bios, true
	}
	return nil, false
}

func (p *Vm) MustBios() *Bios {
	if p.bios == nil {
		panic("the bios must not be nil, please use Bios() function instead")
	}
	return p.bios
}

func (p *Vm) SetCdroms(attr *CdromSlice) {
	p.cdroms = attr
}

func (p *Vm) Cdroms() (*CdromSlice, bool) {
	if p.cdroms != nil {
		return p.cdroms, true
	}
	return nil, false
}

func (p *Vm) MustCdroms() *CdromSlice {
	if p.cdroms == nil {
		panic("the cdroms must not be nil, please use Cdroms() function instead")
	}
	return p.cdroms
}

func (p *Vm) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *Vm) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *Vm) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *Vm) SetComment(attr string) {
	p.comment = &attr
}

func (p *Vm) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Vm) SetConsole(attr *Console) {
	p.console = attr
}

func (p *Vm) Console() (*Console, bool) {
	if p.console != nil {
		return p.console, true
	}
	return nil, false
}

func (p *Vm) MustConsole() *Console {
	if p.console == nil {
		panic("the console must not be nil, please use Console() function instead")
	}
	return p.console
}

func (p *Vm) SetCpu(attr *Cpu) {
	p.cpu = attr
}

func (p *Vm) Cpu() (*Cpu, bool) {
	if p.cpu != nil {
		return p.cpu, true
	}
	return nil, false
}

func (p *Vm) MustCpu() *Cpu {
	if p.cpu == nil {
		panic("the cpu must not be nil, please use Cpu() function instead")
	}
	return p.cpu
}

func (p *Vm) SetCpuProfile(attr *CpuProfile) {
	p.cpuProfile = attr
}

func (p *Vm) CpuProfile() (*CpuProfile, bool) {
	if p.cpuProfile != nil {
		return p.cpuProfile, true
	}
	return nil, false
}

func (p *Vm) MustCpuProfile() *CpuProfile {
	if p.cpuProfile == nil {
		panic("the cpuProfile must not be nil, please use CpuProfile() function instead")
	}
	return p.cpuProfile
}

func (p *Vm) SetCpuShares(attr int64) {
	p.cpuShares = &attr
}

func (p *Vm) CpuShares() (int64, bool) {
	if p.cpuShares != nil {
		return *p.cpuShares, true
	}
	var zero int64
	return zero, false
}

func (p *Vm) MustCpuShares() int64 {
	if p.cpuShares == nil {
		panic("the cpuShares must not be nil, please use CpuShares() function instead")
	}
	return *p.cpuShares
}

func (p *Vm) SetCreationTime(attr time.Time) {
	p.creationTime = &attr
}

func (p *Vm) CreationTime() (time.Time, bool) {
	if p.creationTime != nil {
		return *p.creationTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Vm) MustCreationTime() time.Time {
	if p.creationTime == nil {
		panic("the creationTime must not be nil, please use CreationTime() function instead")
	}
	return *p.creationTime
}

func (p *Vm) SetCustomCompatibilityVersion(attr *Version) {
	p.customCompatibilityVersion = attr
}

func (p *Vm) CustomCompatibilityVersion() (*Version, bool) {
	if p.customCompatibilityVersion != nil {
		return p.customCompatibilityVersion, true
	}
	return nil, false
}

func (p *Vm) MustCustomCompatibilityVersion() *Version {
	if p.customCompatibilityVersion == nil {
		panic("the customCompatibilityVersion must not be nil, please use CustomCompatibilityVersion() function instead")
	}
	return p.customCompatibilityVersion
}

func (p *Vm) SetCustomCpuModel(attr string) {
	p.customCpuModel = &attr
}

func (p *Vm) CustomCpuModel() (string, bool) {
	if p.customCpuModel != nil {
		return *p.customCpuModel, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustCustomCpuModel() string {
	if p.customCpuModel == nil {
		panic("the customCpuModel must not be nil, please use CustomCpuModel() function instead")
	}
	return *p.customCpuModel
}

func (p *Vm) SetCustomEmulatedMachine(attr string) {
	p.customEmulatedMachine = &attr
}

func (p *Vm) CustomEmulatedMachine() (string, bool) {
	if p.customEmulatedMachine != nil {
		return *p.customEmulatedMachine, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustCustomEmulatedMachine() string {
	if p.customEmulatedMachine == nil {
		panic("the customEmulatedMachine must not be nil, please use CustomEmulatedMachine() function instead")
	}
	return *p.customEmulatedMachine
}

func (p *Vm) SetCustomProperties(attr *CustomPropertySlice) {
	p.customProperties = attr
}

func (p *Vm) CustomProperties() (*CustomPropertySlice, bool) {
	if p.customProperties != nil {
		return p.customProperties, true
	}
	return nil, false
}

func (p *Vm) MustCustomProperties() *CustomPropertySlice {
	if p.customProperties == nil {
		panic("the customProperties must not be nil, please use CustomProperties() function instead")
	}
	return p.customProperties
}

func (p *Vm) SetDeleteProtected(attr bool) {
	p.deleteProtected = &attr
}

func (p *Vm) DeleteProtected() (bool, bool) {
	if p.deleteProtected != nil {
		return *p.deleteProtected, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustDeleteProtected() bool {
	if p.deleteProtected == nil {
		panic("the deleteProtected must not be nil, please use DeleteProtected() function instead")
	}
	return *p.deleteProtected
}

func (p *Vm) SetDescription(attr string) {
	p.description = &attr
}

func (p *Vm) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Vm) SetDiskAttachments(attr *DiskAttachmentSlice) {
	p.diskAttachments = attr
}

func (p *Vm) DiskAttachments() (*DiskAttachmentSlice, bool) {
	if p.diskAttachments != nil {
		return p.diskAttachments, true
	}
	return nil, false
}

func (p *Vm) MustDiskAttachments() *DiskAttachmentSlice {
	if p.diskAttachments == nil {
		panic("the diskAttachments must not be nil, please use DiskAttachments() function instead")
	}
	return p.diskAttachments
}

func (p *Vm) SetDisplay(attr *Display) {
	p.display = attr
}

func (p *Vm) Display() (*Display, bool) {
	if p.display != nil {
		return p.display, true
	}
	return nil, false
}

func (p *Vm) MustDisplay() *Display {
	if p.display == nil {
		panic("the display must not be nil, please use Display() function instead")
	}
	return p.display
}

func (p *Vm) SetDomain(attr *Domain) {
	p.domain = attr
}

func (p *Vm) Domain() (*Domain, bool) {
	if p.domain != nil {
		return p.domain, true
	}
	return nil, false
}

func (p *Vm) MustDomain() *Domain {
	if p.domain == nil {
		panic("the domain must not be nil, please use Domain() function instead")
	}
	return p.domain
}

func (p *Vm) SetExternalHostProvider(attr *ExternalHostProvider) {
	p.externalHostProvider = attr
}

func (p *Vm) ExternalHostProvider() (*ExternalHostProvider, bool) {
	if p.externalHostProvider != nil {
		return p.externalHostProvider, true
	}
	return nil, false
}

func (p *Vm) MustExternalHostProvider() *ExternalHostProvider {
	if p.externalHostProvider == nil {
		panic("the externalHostProvider must not be nil, please use ExternalHostProvider() function instead")
	}
	return p.externalHostProvider
}

func (p *Vm) SetFloppies(attr *FloppySlice) {
	p.floppies = attr
}

func (p *Vm) Floppies() (*FloppySlice, bool) {
	if p.floppies != nil {
		return p.floppies, true
	}
	return nil, false
}

func (p *Vm) MustFloppies() *FloppySlice {
	if p.floppies == nil {
		panic("the floppies must not be nil, please use Floppies() function instead")
	}
	return p.floppies
}

func (p *Vm) SetFqdn(attr string) {
	p.fqdn = &attr
}

func (p *Vm) Fqdn() (string, bool) {
	if p.fqdn != nil {
		return *p.fqdn, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustFqdn() string {
	if p.fqdn == nil {
		panic("the fqdn must not be nil, please use Fqdn() function instead")
	}
	return *p.fqdn
}

func (p *Vm) SetGraphicsConsoles(attr *GraphicsConsoleSlice) {
	p.graphicsConsoles = attr
}

func (p *Vm) GraphicsConsoles() (*GraphicsConsoleSlice, bool) {
	if p.graphicsConsoles != nil {
		return p.graphicsConsoles, true
	}
	return nil, false
}

func (p *Vm) MustGraphicsConsoles() *GraphicsConsoleSlice {
	if p.graphicsConsoles == nil {
		panic("the graphicsConsoles must not be nil, please use GraphicsConsoles() function instead")
	}
	return p.graphicsConsoles
}

func (p *Vm) SetGuestOperatingSystem(attr *GuestOperatingSystem) {
	p.guestOperatingSystem = attr
}

func (p *Vm) GuestOperatingSystem() (*GuestOperatingSystem, bool) {
	if p.guestOperatingSystem != nil {
		return p.guestOperatingSystem, true
	}
	return nil, false
}

func (p *Vm) MustGuestOperatingSystem() *GuestOperatingSystem {
	if p.guestOperatingSystem == nil {
		panic("the guestOperatingSystem must not be nil, please use GuestOperatingSystem() function instead")
	}
	return p.guestOperatingSystem
}

func (p *Vm) SetGuestTimeZone(attr *TimeZone) {
	p.guestTimeZone = attr
}

func (p *Vm) GuestTimeZone() (*TimeZone, bool) {
	if p.guestTimeZone != nil {
		return p.guestTimeZone, true
	}
	return nil, false
}

func (p *Vm) MustGuestTimeZone() *TimeZone {
	if p.guestTimeZone == nil {
		panic("the guestTimeZone must not be nil, please use GuestTimeZone() function instead")
	}
	return p.guestTimeZone
}

func (p *Vm) SetHasIllegalImages(attr bool) {
	p.hasIllegalImages = &attr
}

func (p *Vm) HasIllegalImages() (bool, bool) {
	if p.hasIllegalImages != nil {
		return *p.hasIllegalImages, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustHasIllegalImages() bool {
	if p.hasIllegalImages == nil {
		panic("the hasIllegalImages must not be nil, please use HasIllegalImages() function instead")
	}
	return *p.hasIllegalImages
}

func (p *Vm) SetHighAvailability(attr *HighAvailability) {
	p.highAvailability = attr
}

func (p *Vm) HighAvailability() (*HighAvailability, bool) {
	if p.highAvailability != nil {
		return p.highAvailability, true
	}
	return nil, false
}

func (p *Vm) MustHighAvailability() *HighAvailability {
	if p.highAvailability == nil {
		panic("the highAvailability must not be nil, please use HighAvailability() function instead")
	}
	return p.highAvailability
}

func (p *Vm) SetHost(attr *Host) {
	p.host = attr
}

func (p *Vm) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *Vm) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *Vm) SetHostDevices(attr *HostDeviceSlice) {
	p.hostDevices = attr
}

func (p *Vm) HostDevices() (*HostDeviceSlice, bool) {
	if p.hostDevices != nil {
		return p.hostDevices, true
	}
	return nil, false
}

func (p *Vm) MustHostDevices() *HostDeviceSlice {
	if p.hostDevices == nil {
		panic("the hostDevices must not be nil, please use HostDevices() function instead")
	}
	return p.hostDevices
}

func (p *Vm) SetId(attr string) {
	p.id = &attr
}

func (p *Vm) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Vm) SetInitialization(attr *Initialization) {
	p.initialization = attr
}

func (p *Vm) Initialization() (*Initialization, bool) {
	if p.initialization != nil {
		return p.initialization, true
	}
	return nil, false
}

func (p *Vm) MustInitialization() *Initialization {
	if p.initialization == nil {
		panic("the initialization must not be nil, please use Initialization() function instead")
	}
	return p.initialization
}

func (p *Vm) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *Vm) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *Vm) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *Vm) SetIo(attr *Io) {
	p.io = attr
}

func (p *Vm) Io() (*Io, bool) {
	if p.io != nil {
		return p.io, true
	}
	return nil, false
}

func (p *Vm) MustIo() *Io {
	if p.io == nil {
		panic("the io must not be nil, please use Io() function instead")
	}
	return p.io
}

func (p *Vm) SetKatelloErrata(attr *KatelloErratumSlice) {
	p.katelloErrata = attr
}

func (p *Vm) KatelloErrata() (*KatelloErratumSlice, bool) {
	if p.katelloErrata != nil {
		return p.katelloErrata, true
	}
	return nil, false
}

func (p *Vm) MustKatelloErrata() *KatelloErratumSlice {
	if p.katelloErrata == nil {
		panic("the katelloErrata must not be nil, please use KatelloErrata() function instead")
	}
	return p.katelloErrata
}

func (p *Vm) SetLargeIcon(attr *Icon) {
	p.largeIcon = attr
}

func (p *Vm) LargeIcon() (*Icon, bool) {
	if p.largeIcon != nil {
		return p.largeIcon, true
	}
	return nil, false
}

func (p *Vm) MustLargeIcon() *Icon {
	if p.largeIcon == nil {
		panic("the largeIcon must not be nil, please use LargeIcon() function instead")
	}
	return p.largeIcon
}

func (p *Vm) SetLease(attr *StorageDomainLease) {
	p.lease = attr
}

func (p *Vm) Lease() (*StorageDomainLease, bool) {
	if p.lease != nil {
		return p.lease, true
	}
	return nil, false
}

func (p *Vm) MustLease() *StorageDomainLease {
	if p.lease == nil {
		panic("the lease must not be nil, please use Lease() function instead")
	}
	return p.lease
}

func (p *Vm) SetMemory(attr int64) {
	p.memory = &attr
}

func (p *Vm) Memory() (int64, bool) {
	if p.memory != nil {
		return *p.memory, true
	}
	var zero int64
	return zero, false
}

func (p *Vm) MustMemory() int64 {
	if p.memory == nil {
		panic("the memory must not be nil, please use Memory() function instead")
	}
	return *p.memory
}

func (p *Vm) SetMemoryPolicy(attr *MemoryPolicy) {
	p.memoryPolicy = attr
}

func (p *Vm) MemoryPolicy() (*MemoryPolicy, bool) {
	if p.memoryPolicy != nil {
		return p.memoryPolicy, true
	}
	return nil, false
}

func (p *Vm) MustMemoryPolicy() *MemoryPolicy {
	if p.memoryPolicy == nil {
		panic("the memoryPolicy must not be nil, please use MemoryPolicy() function instead")
	}
	return p.memoryPolicy
}

func (p *Vm) SetMigration(attr *MigrationOptions) {
	p.migration = attr
}

func (p *Vm) Migration() (*MigrationOptions, bool) {
	if p.migration != nil {
		return p.migration, true
	}
	return nil, false
}

func (p *Vm) MustMigration() *MigrationOptions {
	if p.migration == nil {
		panic("the migration must not be nil, please use Migration() function instead")
	}
	return p.migration
}

func (p *Vm) SetMigrationDowntime(attr int64) {
	p.migrationDowntime = &attr
}

func (p *Vm) MigrationDowntime() (int64, bool) {
	if p.migrationDowntime != nil {
		return *p.migrationDowntime, true
	}
	var zero int64
	return zero, false
}

func (p *Vm) MustMigrationDowntime() int64 {
	if p.migrationDowntime == nil {
		panic("the migrationDowntime must not be nil, please use MigrationDowntime() function instead")
	}
	return *p.migrationDowntime
}

func (p *Vm) SetMultiQueuesEnabled(attr bool) {
	p.multiQueuesEnabled = &attr
}

func (p *Vm) MultiQueuesEnabled() (bool, bool) {
	if p.multiQueuesEnabled != nil {
		return *p.multiQueuesEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustMultiQueuesEnabled() bool {
	if p.multiQueuesEnabled == nil {
		panic("the multiQueuesEnabled must not be nil, please use MultiQueuesEnabled() function instead")
	}
	return *p.multiQueuesEnabled
}

func (p *Vm) SetName(attr string) {
	p.name = &attr
}

func (p *Vm) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Vm) SetNextRunConfigurationExists(attr bool) {
	p.nextRunConfigurationExists = &attr
}

func (p *Vm) NextRunConfigurationExists() (bool, bool) {
	if p.nextRunConfigurationExists != nil {
		return *p.nextRunConfigurationExists, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustNextRunConfigurationExists() bool {
	if p.nextRunConfigurationExists == nil {
		panic("the nextRunConfigurationExists must not be nil, please use NextRunConfigurationExists() function instead")
	}
	return *p.nextRunConfigurationExists
}

func (p *Vm) SetNics(attr *NicSlice) {
	p.nics = attr
}

func (p *Vm) Nics() (*NicSlice, bool) {
	if p.nics != nil {
		return p.nics, true
	}
	return nil, false
}

func (p *Vm) MustNics() *NicSlice {
	if p.nics == nil {
		panic("the nics must not be nil, please use Nics() function instead")
	}
	return p.nics
}

func (p *Vm) SetNumaNodes(attr *NumaNodeSlice) {
	p.numaNodes = attr
}

func (p *Vm) NumaNodes() (*NumaNodeSlice, bool) {
	if p.numaNodes != nil {
		return p.numaNodes, true
	}
	return nil, false
}

func (p *Vm) MustNumaNodes() *NumaNodeSlice {
	if p.numaNodes == nil {
		panic("the numaNodes must not be nil, please use NumaNodes() function instead")
	}
	return p.numaNodes
}

func (p *Vm) SetNumaTuneMode(attr NumaTuneMode) {
	p.numaTuneMode = &attr
}

func (p *Vm) NumaTuneMode() (NumaTuneMode, bool) {
	if p.numaTuneMode != nil {
		return *p.numaTuneMode, true
	}
	var zero NumaTuneMode
	return zero, false
}

func (p *Vm) MustNumaTuneMode() NumaTuneMode {
	if p.numaTuneMode == nil {
		panic("the numaTuneMode must not be nil, please use NumaTuneMode() function instead")
	}
	return *p.numaTuneMode
}

func (p *Vm) SetOrigin(attr string) {
	p.origin = &attr
}

func (p *Vm) Origin() (string, bool) {
	if p.origin != nil {
		return *p.origin, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustOrigin() string {
	if p.origin == nil {
		panic("the origin must not be nil, please use Origin() function instead")
	}
	return *p.origin
}

func (p *Vm) SetOriginalTemplate(attr *Template) {
	p.originalTemplate = attr
}

func (p *Vm) OriginalTemplate() (*Template, bool) {
	if p.originalTemplate != nil {
		return p.originalTemplate, true
	}
	return nil, false
}

func (p *Vm) MustOriginalTemplate() *Template {
	if p.originalTemplate == nil {
		panic("the originalTemplate must not be nil, please use OriginalTemplate() function instead")
	}
	return p.originalTemplate
}

func (p *Vm) SetOs(attr *OperatingSystem) {
	p.os = attr
}

func (p *Vm) Os() (*OperatingSystem, bool) {
	if p.os != nil {
		return p.os, true
	}
	return nil, false
}

func (p *Vm) MustOs() *OperatingSystem {
	if p.os == nil {
		panic("the os must not be nil, please use Os() function instead")
	}
	return p.os
}

func (p *Vm) SetPayloads(attr *PayloadSlice) {
	p.payloads = attr
}

func (p *Vm) Payloads() (*PayloadSlice, bool) {
	if p.payloads != nil {
		return p.payloads, true
	}
	return nil, false
}

func (p *Vm) MustPayloads() *PayloadSlice {
	if p.payloads == nil {
		panic("the payloads must not be nil, please use Payloads() function instead")
	}
	return p.payloads
}

func (p *Vm) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *Vm) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *Vm) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *Vm) SetPlacementPolicy(attr *VmPlacementPolicy) {
	p.placementPolicy = attr
}

func (p *Vm) PlacementPolicy() (*VmPlacementPolicy, bool) {
	if p.placementPolicy != nil {
		return p.placementPolicy, true
	}
	return nil, false
}

func (p *Vm) MustPlacementPolicy() *VmPlacementPolicy {
	if p.placementPolicy == nil {
		panic("the placementPolicy must not be nil, please use PlacementPolicy() function instead")
	}
	return p.placementPolicy
}

func (p *Vm) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *Vm) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *Vm) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *Vm) SetReportedDevices(attr *ReportedDeviceSlice) {
	p.reportedDevices = attr
}

func (p *Vm) ReportedDevices() (*ReportedDeviceSlice, bool) {
	if p.reportedDevices != nil {
		return p.reportedDevices, true
	}
	return nil, false
}

func (p *Vm) MustReportedDevices() *ReportedDeviceSlice {
	if p.reportedDevices == nil {
		panic("the reportedDevices must not be nil, please use ReportedDevices() function instead")
	}
	return p.reportedDevices
}

func (p *Vm) SetRngDevice(attr *RngDevice) {
	p.rngDevice = attr
}

func (p *Vm) RngDevice() (*RngDevice, bool) {
	if p.rngDevice != nil {
		return p.rngDevice, true
	}
	return nil, false
}

func (p *Vm) MustRngDevice() *RngDevice {
	if p.rngDevice == nil {
		panic("the rngDevice must not be nil, please use RngDevice() function instead")
	}
	return p.rngDevice
}

func (p *Vm) SetRunOnce(attr bool) {
	p.runOnce = &attr
}

func (p *Vm) RunOnce() (bool, bool) {
	if p.runOnce != nil {
		return *p.runOnce, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustRunOnce() bool {
	if p.runOnce == nil {
		panic("the runOnce must not be nil, please use RunOnce() function instead")
	}
	return *p.runOnce
}

func (p *Vm) SetSerialNumber(attr *SerialNumber) {
	p.serialNumber = attr
}

func (p *Vm) SerialNumber() (*SerialNumber, bool) {
	if p.serialNumber != nil {
		return p.serialNumber, true
	}
	return nil, false
}

func (p *Vm) MustSerialNumber() *SerialNumber {
	if p.serialNumber == nil {
		panic("the serialNumber must not be nil, please use SerialNumber() function instead")
	}
	return p.serialNumber
}

func (p *Vm) SetSessions(attr *SessionSlice) {
	p.sessions = attr
}

func (p *Vm) Sessions() (*SessionSlice, bool) {
	if p.sessions != nil {
		return p.sessions, true
	}
	return nil, false
}

func (p *Vm) MustSessions() *SessionSlice {
	if p.sessions == nil {
		panic("the sessions must not be nil, please use Sessions() function instead")
	}
	return p.sessions
}

func (p *Vm) SetSmallIcon(attr *Icon) {
	p.smallIcon = attr
}

func (p *Vm) SmallIcon() (*Icon, bool) {
	if p.smallIcon != nil {
		return p.smallIcon, true
	}
	return nil, false
}

func (p *Vm) MustSmallIcon() *Icon {
	if p.smallIcon == nil {
		panic("the smallIcon must not be nil, please use SmallIcon() function instead")
	}
	return p.smallIcon
}

func (p *Vm) SetSnapshots(attr *SnapshotSlice) {
	p.snapshots = attr
}

func (p *Vm) Snapshots() (*SnapshotSlice, bool) {
	if p.snapshots != nil {
		return p.snapshots, true
	}
	return nil, false
}

func (p *Vm) MustSnapshots() *SnapshotSlice {
	if p.snapshots == nil {
		panic("the snapshots must not be nil, please use Snapshots() function instead")
	}
	return p.snapshots
}

func (p *Vm) SetSoundcardEnabled(attr bool) {
	p.soundcardEnabled = &attr
}

func (p *Vm) SoundcardEnabled() (bool, bool) {
	if p.soundcardEnabled != nil {
		return *p.soundcardEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustSoundcardEnabled() bool {
	if p.soundcardEnabled == nil {
		panic("the soundcardEnabled must not be nil, please use SoundcardEnabled() function instead")
	}
	return *p.soundcardEnabled
}

func (p *Vm) SetSso(attr *Sso) {
	p.sso = attr
}

func (p *Vm) Sso() (*Sso, bool) {
	if p.sso != nil {
		return p.sso, true
	}
	return nil, false
}

func (p *Vm) MustSso() *Sso {
	if p.sso == nil {
		panic("the sso must not be nil, please use Sso() function instead")
	}
	return p.sso
}

func (p *Vm) SetStartPaused(attr bool) {
	p.startPaused = &attr
}

func (p *Vm) StartPaused() (bool, bool) {
	if p.startPaused != nil {
		return *p.startPaused, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustStartPaused() bool {
	if p.startPaused == nil {
		panic("the startPaused must not be nil, please use StartPaused() function instead")
	}
	return *p.startPaused
}

func (p *Vm) SetStartTime(attr time.Time) {
	p.startTime = &attr
}

func (p *Vm) StartTime() (time.Time, bool) {
	if p.startTime != nil {
		return *p.startTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Vm) MustStartTime() time.Time {
	if p.startTime == nil {
		panic("the startTime must not be nil, please use StartTime() function instead")
	}
	return *p.startTime
}

func (p *Vm) SetStateless(attr bool) {
	p.stateless = &attr
}

func (p *Vm) Stateless() (bool, bool) {
	if p.stateless != nil {
		return *p.stateless, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustStateless() bool {
	if p.stateless == nil {
		panic("the stateless must not be nil, please use Stateless() function instead")
	}
	return *p.stateless
}

func (p *Vm) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *Vm) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *Vm) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *Vm) SetStatus(attr VmStatus) {
	p.status = &attr
}

func (p *Vm) Status() (VmStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero VmStatus
	return zero, false
}

func (p *Vm) MustStatus() VmStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *Vm) SetStatusDetail(attr string) {
	p.statusDetail = &attr
}

func (p *Vm) StatusDetail() (string, bool) {
	if p.statusDetail != nil {
		return *p.statusDetail, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustStatusDetail() string {
	if p.statusDetail == nil {
		panic("the statusDetail must not be nil, please use StatusDetail() function instead")
	}
	return *p.statusDetail
}

func (p *Vm) SetStopReason(attr string) {
	p.stopReason = &attr
}

func (p *Vm) StopReason() (string, bool) {
	if p.stopReason != nil {
		return *p.stopReason, true
	}
	var zero string
	return zero, false
}

func (p *Vm) MustStopReason() string {
	if p.stopReason == nil {
		panic("the stopReason must not be nil, please use StopReason() function instead")
	}
	return *p.stopReason
}

func (p *Vm) SetStopTime(attr time.Time) {
	p.stopTime = &attr
}

func (p *Vm) StopTime() (time.Time, bool) {
	if p.stopTime != nil {
		return *p.stopTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Vm) MustStopTime() time.Time {
	if p.stopTime == nil {
		panic("the stopTime must not be nil, please use StopTime() function instead")
	}
	return *p.stopTime
}

func (p *Vm) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *Vm) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *Vm) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *Vm) SetStorageErrorResumeBehaviour(attr VmStorageErrorResumeBehaviour) {
	p.storageErrorResumeBehaviour = &attr
}

func (p *Vm) StorageErrorResumeBehaviour() (VmStorageErrorResumeBehaviour, bool) {
	if p.storageErrorResumeBehaviour != nil {
		return *p.storageErrorResumeBehaviour, true
	}
	var zero VmStorageErrorResumeBehaviour
	return zero, false
}

func (p *Vm) MustStorageErrorResumeBehaviour() VmStorageErrorResumeBehaviour {
	if p.storageErrorResumeBehaviour == nil {
		panic("the storageErrorResumeBehaviour must not be nil, please use StorageErrorResumeBehaviour() function instead")
	}
	return *p.storageErrorResumeBehaviour
}

func (p *Vm) SetTags(attr *TagSlice) {
	p.tags = attr
}

func (p *Vm) Tags() (*TagSlice, bool) {
	if p.tags != nil {
		return p.tags, true
	}
	return nil, false
}

func (p *Vm) MustTags() *TagSlice {
	if p.tags == nil {
		panic("the tags must not be nil, please use Tags() function instead")
	}
	return p.tags
}

func (p *Vm) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Vm) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Vm) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Vm) SetTimeZone(attr *TimeZone) {
	p.timeZone = attr
}

func (p *Vm) TimeZone() (*TimeZone, bool) {
	if p.timeZone != nil {
		return p.timeZone, true
	}
	return nil, false
}

func (p *Vm) MustTimeZone() *TimeZone {
	if p.timeZone == nil {
		panic("the timeZone must not be nil, please use TimeZone() function instead")
	}
	return p.timeZone
}

func (p *Vm) SetTunnelMigration(attr bool) {
	p.tunnelMigration = &attr
}

func (p *Vm) TunnelMigration() (bool, bool) {
	if p.tunnelMigration != nil {
		return *p.tunnelMigration, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustTunnelMigration() bool {
	if p.tunnelMigration == nil {
		panic("the tunnelMigration must not be nil, please use TunnelMigration() function instead")
	}
	return *p.tunnelMigration
}

func (p *Vm) SetType(attr VmType) {
	p.type_ = &attr
}

func (p *Vm) Type() (VmType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero VmType
	return zero, false
}

func (p *Vm) MustType() VmType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *Vm) SetUsb(attr *Usb) {
	p.usb = attr
}

func (p *Vm) Usb() (*Usb, bool) {
	if p.usb != nil {
		return p.usb, true
	}
	return nil, false
}

func (p *Vm) MustUsb() *Usb {
	if p.usb == nil {
		panic("the usb must not be nil, please use Usb() function instead")
	}
	return p.usb
}

func (p *Vm) SetUseLatestTemplateVersion(attr bool) {
	p.useLatestTemplateVersion = &attr
}

func (p *Vm) UseLatestTemplateVersion() (bool, bool) {
	if p.useLatestTemplateVersion != nil {
		return *p.useLatestTemplateVersion, true
	}
	var zero bool
	return zero, false
}

func (p *Vm) MustUseLatestTemplateVersion() bool {
	if p.useLatestTemplateVersion == nil {
		panic("the useLatestTemplateVersion must not be nil, please use UseLatestTemplateVersion() function instead")
	}
	return *p.useLatestTemplateVersion
}

func (p *Vm) SetVirtioScsi(attr *VirtioScsi) {
	p.virtioScsi = attr
}

func (p *Vm) VirtioScsi() (*VirtioScsi, bool) {
	if p.virtioScsi != nil {
		return p.virtioScsi, true
	}
	return nil, false
}

func (p *Vm) MustVirtioScsi() *VirtioScsi {
	if p.virtioScsi == nil {
		panic("the virtioScsi must not be nil, please use VirtioScsi() function instead")
	}
	return p.virtioScsi
}

func (p *Vm) SetVmPool(attr *VmPool) {
	p.vmPool = attr
}

func (p *Vm) VmPool() (*VmPool, bool) {
	if p.vmPool != nil {
		return p.vmPool, true
	}
	return nil, false
}

func (p *Vm) MustVmPool() *VmPool {
	if p.vmPool == nil {
		panic("the vmPool must not be nil, please use VmPool() function instead")
	}
	return p.vmPool
}

func (p *Vm) SetWatchdogs(attr *WatchdogSlice) {
	p.watchdogs = attr
}

func (p *Vm) Watchdogs() (*WatchdogSlice, bool) {
	if p.watchdogs != nil {
		return p.watchdogs, true
	}
	return nil, false
}

func (p *Vm) MustWatchdogs() *WatchdogSlice {
	if p.watchdogs == nil {
		panic("the watchdogs must not be nil, please use Watchdogs() function instead")
	}
	return p.watchdogs
}

type ExternalHostGroup struct {
	Struct
	architectureName     *string
	comment              *string
	description          *string
	domainName           *string
	externalHostProvider *ExternalHostProvider
	id                   *string
	name                 *string
	operatingSystemName  *string
	subnetName           *string
}

func (p *ExternalHostGroup) SetArchitectureName(attr string) {
	p.architectureName = &attr
}

func (p *ExternalHostGroup) ArchitectureName() (string, bool) {
	if p.architectureName != nil {
		return *p.architectureName, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostGroup) MustArchitectureName() string {
	if p.architectureName == nil {
		panic("the architectureName must not be nil, please use ArchitectureName() function instead")
	}
	return *p.architectureName
}

func (p *ExternalHostGroup) SetComment(attr string) {
	p.comment = &attr
}

func (p *ExternalHostGroup) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostGroup) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ExternalHostGroup) SetDescription(attr string) {
	p.description = &attr
}

func (p *ExternalHostGroup) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostGroup) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ExternalHostGroup) SetDomainName(attr string) {
	p.domainName = &attr
}

func (p *ExternalHostGroup) DomainName() (string, bool) {
	if p.domainName != nil {
		return *p.domainName, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostGroup) MustDomainName() string {
	if p.domainName == nil {
		panic("the domainName must not be nil, please use DomainName() function instead")
	}
	return *p.domainName
}

func (p *ExternalHostGroup) SetExternalHostProvider(attr *ExternalHostProvider) {
	p.externalHostProvider = attr
}

func (p *ExternalHostGroup) ExternalHostProvider() (*ExternalHostProvider, bool) {
	if p.externalHostProvider != nil {
		return p.externalHostProvider, true
	}
	return nil, false
}

func (p *ExternalHostGroup) MustExternalHostProvider() *ExternalHostProvider {
	if p.externalHostProvider == nil {
		panic("the externalHostProvider must not be nil, please use ExternalHostProvider() function instead")
	}
	return p.externalHostProvider
}

func (p *ExternalHostGroup) SetId(attr string) {
	p.id = &attr
}

func (p *ExternalHostGroup) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostGroup) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ExternalHostGroup) SetName(attr string) {
	p.name = &attr
}

func (p *ExternalHostGroup) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostGroup) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ExternalHostGroup) SetOperatingSystemName(attr string) {
	p.operatingSystemName = &attr
}

func (p *ExternalHostGroup) OperatingSystemName() (string, bool) {
	if p.operatingSystemName != nil {
		return *p.operatingSystemName, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostGroup) MustOperatingSystemName() string {
	if p.operatingSystemName == nil {
		panic("the operatingSystemName must not be nil, please use OperatingSystemName() function instead")
	}
	return *p.operatingSystemName
}

func (p *ExternalHostGroup) SetSubnetName(attr string) {
	p.subnetName = &attr
}

func (p *ExternalHostGroup) SubnetName() (string, bool) {
	if p.subnetName != nil {
		return *p.subnetName, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostGroup) MustSubnetName() string {
	if p.subnetName == nil {
		panic("the subnetName must not be nil, please use SubnetName() function instead")
	}
	return *p.subnetName
}

type ExternalComputeResource struct {
	Struct
	comment              *string
	description          *string
	externalHostProvider *ExternalHostProvider
	id                   *string
	name                 *string
	provider             *string
	url                  *string
	user                 *string
}

func (p *ExternalComputeResource) SetComment(attr string) {
	p.comment = &attr
}

func (p *ExternalComputeResource) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ExternalComputeResource) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ExternalComputeResource) SetDescription(attr string) {
	p.description = &attr
}

func (p *ExternalComputeResource) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ExternalComputeResource) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ExternalComputeResource) SetExternalHostProvider(attr *ExternalHostProvider) {
	p.externalHostProvider = attr
}

func (p *ExternalComputeResource) ExternalHostProvider() (*ExternalHostProvider, bool) {
	if p.externalHostProvider != nil {
		return p.externalHostProvider, true
	}
	return nil, false
}

func (p *ExternalComputeResource) MustExternalHostProvider() *ExternalHostProvider {
	if p.externalHostProvider == nil {
		panic("the externalHostProvider must not be nil, please use ExternalHostProvider() function instead")
	}
	return p.externalHostProvider
}

func (p *ExternalComputeResource) SetId(attr string) {
	p.id = &attr
}

func (p *ExternalComputeResource) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ExternalComputeResource) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ExternalComputeResource) SetName(attr string) {
	p.name = &attr
}

func (p *ExternalComputeResource) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ExternalComputeResource) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ExternalComputeResource) SetProvider(attr string) {
	p.provider = &attr
}

func (p *ExternalComputeResource) Provider() (string, bool) {
	if p.provider != nil {
		return *p.provider, true
	}
	var zero string
	return zero, false
}

func (p *ExternalComputeResource) MustProvider() string {
	if p.provider == nil {
		panic("the provider must not be nil, please use Provider() function instead")
	}
	return *p.provider
}

func (p *ExternalComputeResource) SetUrl(attr string) {
	p.url = &attr
}

func (p *ExternalComputeResource) Url() (string, bool) {
	if p.url != nil {
		return *p.url, true
	}
	var zero string
	return zero, false
}

func (p *ExternalComputeResource) MustUrl() string {
	if p.url == nil {
		panic("the url must not be nil, please use Url() function instead")
	}
	return *p.url
}

func (p *ExternalComputeResource) SetUser(attr string) {
	p.user = &attr
}

func (p *ExternalComputeResource) User() (string, bool) {
	if p.user != nil {
		return *p.user, true
	}
	var zero string
	return zero, false
}

func (p *ExternalComputeResource) MustUser() string {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return *p.user
}

type OpenStackVolumeProvider struct {
	Struct
	authenticationKeys     *OpenstackVolumeAuthenticationKeySlice
	authenticationUrl      *string
	certificates           *CertificateSlice
	comment                *string
	dataCenter             *DataCenter
	description            *string
	id                     *string
	name                   *string
	password               *string
	properties             *PropertySlice
	requiresAuthentication *bool
	tenantName             *string
	url                    *string
	username               *string
	volumeTypes            *OpenStackVolumeTypeSlice
}

func (p *OpenStackVolumeProvider) SetAuthenticationKeys(attr *OpenstackVolumeAuthenticationKeySlice) {
	p.authenticationKeys = attr
}

func (p *OpenStackVolumeProvider) AuthenticationKeys() (*OpenstackVolumeAuthenticationKeySlice, bool) {
	if p.authenticationKeys != nil {
		return p.authenticationKeys, true
	}
	return nil, false
}

func (p *OpenStackVolumeProvider) MustAuthenticationKeys() *OpenstackVolumeAuthenticationKeySlice {
	if p.authenticationKeys == nil {
		panic("the authenticationKeys must not be nil, please use AuthenticationKeys() function instead")
	}
	return p.authenticationKeys
}

func (p *OpenStackVolumeProvider) SetAuthenticationUrl(attr string) {
	p.authenticationUrl = &attr
}

func (p *OpenStackVolumeProvider) AuthenticationUrl() (string, bool) {
	if p.authenticationUrl != nil {
		return *p.authenticationUrl, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeProvider) MustAuthenticationUrl() string {
	if p.authenticationUrl == nil {
		panic("the authenticationUrl must not be nil, please use AuthenticationUrl() function instead")
	}
	return *p.authenticationUrl
}

func (p *OpenStackVolumeProvider) SetCertificates(attr *CertificateSlice) {
	p.certificates = attr
}

func (p *OpenStackVolumeProvider) Certificates() (*CertificateSlice, bool) {
	if p.certificates != nil {
		return p.certificates, true
	}
	return nil, false
}

func (p *OpenStackVolumeProvider) MustCertificates() *CertificateSlice {
	if p.certificates == nil {
		panic("the certificates must not be nil, please use Certificates() function instead")
	}
	return p.certificates
}

func (p *OpenStackVolumeProvider) SetComment(attr string) {
	p.comment = &attr
}

func (p *OpenStackVolumeProvider) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeProvider) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OpenStackVolumeProvider) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *OpenStackVolumeProvider) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *OpenStackVolumeProvider) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *OpenStackVolumeProvider) SetDescription(attr string) {
	p.description = &attr
}

func (p *OpenStackVolumeProvider) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeProvider) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OpenStackVolumeProvider) SetId(attr string) {
	p.id = &attr
}

func (p *OpenStackVolumeProvider) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeProvider) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OpenStackVolumeProvider) SetName(attr string) {
	p.name = &attr
}

func (p *OpenStackVolumeProvider) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeProvider) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OpenStackVolumeProvider) SetPassword(attr string) {
	p.password = &attr
}

func (p *OpenStackVolumeProvider) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeProvider) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *OpenStackVolumeProvider) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *OpenStackVolumeProvider) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *OpenStackVolumeProvider) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *OpenStackVolumeProvider) SetRequiresAuthentication(attr bool) {
	p.requiresAuthentication = &attr
}

func (p *OpenStackVolumeProvider) RequiresAuthentication() (bool, bool) {
	if p.requiresAuthentication != nil {
		return *p.requiresAuthentication, true
	}
	var zero bool
	return zero, false
}

func (p *OpenStackVolumeProvider) MustRequiresAuthentication() bool {
	if p.requiresAuthentication == nil {
		panic("the requiresAuthentication must not be nil, please use RequiresAuthentication() function instead")
	}
	return *p.requiresAuthentication
}

func (p *OpenStackVolumeProvider) SetTenantName(attr string) {
	p.tenantName = &attr
}

func (p *OpenStackVolumeProvider) TenantName() (string, bool) {
	if p.tenantName != nil {
		return *p.tenantName, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeProvider) MustTenantName() string {
	if p.tenantName == nil {
		panic("the tenantName must not be nil, please use TenantName() function instead")
	}
	return *p.tenantName
}

func (p *OpenStackVolumeProvider) SetUrl(attr string) {
	p.url = &attr
}

func (p *OpenStackVolumeProvider) Url() (string, bool) {
	if p.url != nil {
		return *p.url, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeProvider) MustUrl() string {
	if p.url == nil {
		panic("the url must not be nil, please use Url() function instead")
	}
	return *p.url
}

func (p *OpenStackVolumeProvider) SetUsername(attr string) {
	p.username = &attr
}

func (p *OpenStackVolumeProvider) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackVolumeProvider) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

func (p *OpenStackVolumeProvider) SetVolumeTypes(attr *OpenStackVolumeTypeSlice) {
	p.volumeTypes = attr
}

func (p *OpenStackVolumeProvider) VolumeTypes() (*OpenStackVolumeTypeSlice, bool) {
	if p.volumeTypes != nil {
		return p.volumeTypes, true
	}
	return nil, false
}

func (p *OpenStackVolumeProvider) MustVolumeTypes() *OpenStackVolumeTypeSlice {
	if p.volumeTypes == nil {
		panic("the volumeTypes must not be nil, please use VolumeTypes() function instead")
	}
	return p.volumeTypes
}

type Step struct {
	Struct
	comment       *string
	description   *string
	endTime       *time.Time
	executionHost *Host
	external      *bool
	externalType  *ExternalSystemType
	id            *string
	job           *Job
	name          *string
	number        *int64
	parentStep    *Step
	progress      *int64
	startTime     *time.Time
	statistics    *StatisticSlice
	status        *StepStatus
	type_         *StepEnum
}

func (p *Step) SetComment(attr string) {
	p.comment = &attr
}

func (p *Step) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Step) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Step) SetDescription(attr string) {
	p.description = &attr
}

func (p *Step) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Step) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Step) SetEndTime(attr time.Time) {
	p.endTime = &attr
}

func (p *Step) EndTime() (time.Time, bool) {
	if p.endTime != nil {
		return *p.endTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Step) MustEndTime() time.Time {
	if p.endTime == nil {
		panic("the endTime must not be nil, please use EndTime() function instead")
	}
	return *p.endTime
}

func (p *Step) SetExecutionHost(attr *Host) {
	p.executionHost = attr
}

func (p *Step) ExecutionHost() (*Host, bool) {
	if p.executionHost != nil {
		return p.executionHost, true
	}
	return nil, false
}

func (p *Step) MustExecutionHost() *Host {
	if p.executionHost == nil {
		panic("the executionHost must not be nil, please use ExecutionHost() function instead")
	}
	return p.executionHost
}

func (p *Step) SetExternal(attr bool) {
	p.external = &attr
}

func (p *Step) External() (bool, bool) {
	if p.external != nil {
		return *p.external, true
	}
	var zero bool
	return zero, false
}

func (p *Step) MustExternal() bool {
	if p.external == nil {
		panic("the external must not be nil, please use External() function instead")
	}
	return *p.external
}

func (p *Step) SetExternalType(attr ExternalSystemType) {
	p.externalType = &attr
}

func (p *Step) ExternalType() (ExternalSystemType, bool) {
	if p.externalType != nil {
		return *p.externalType, true
	}
	var zero ExternalSystemType
	return zero, false
}

func (p *Step) MustExternalType() ExternalSystemType {
	if p.externalType == nil {
		panic("the externalType must not be nil, please use ExternalType() function instead")
	}
	return *p.externalType
}

func (p *Step) SetId(attr string) {
	p.id = &attr
}

func (p *Step) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Step) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Step) SetJob(attr *Job) {
	p.job = attr
}

func (p *Step) Job() (*Job, bool) {
	if p.job != nil {
		return p.job, true
	}
	return nil, false
}

func (p *Step) MustJob() *Job {
	if p.job == nil {
		panic("the job must not be nil, please use Job() function instead")
	}
	return p.job
}

func (p *Step) SetName(attr string) {
	p.name = &attr
}

func (p *Step) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Step) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Step) SetNumber(attr int64) {
	p.number = &attr
}

func (p *Step) Number() (int64, bool) {
	if p.number != nil {
		return *p.number, true
	}
	var zero int64
	return zero, false
}

func (p *Step) MustNumber() int64 {
	if p.number == nil {
		panic("the number must not be nil, please use Number() function instead")
	}
	return *p.number
}

func (p *Step) SetParentStep(attr *Step) {
	p.parentStep = attr
}

func (p *Step) ParentStep() (*Step, bool) {
	if p.parentStep != nil {
		return p.parentStep, true
	}
	return nil, false
}

func (p *Step) MustParentStep() *Step {
	if p.parentStep == nil {
		panic("the parentStep must not be nil, please use ParentStep() function instead")
	}
	return p.parentStep
}

func (p *Step) SetProgress(attr int64) {
	p.progress = &attr
}

func (p *Step) Progress() (int64, bool) {
	if p.progress != nil {
		return *p.progress, true
	}
	var zero int64
	return zero, false
}

func (p *Step) MustProgress() int64 {
	if p.progress == nil {
		panic("the progress must not be nil, please use Progress() function instead")
	}
	return *p.progress
}

func (p *Step) SetStartTime(attr time.Time) {
	p.startTime = &attr
}

func (p *Step) StartTime() (time.Time, bool) {
	if p.startTime != nil {
		return *p.startTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Step) MustStartTime() time.Time {
	if p.startTime == nil {
		panic("the startTime must not be nil, please use StartTime() function instead")
	}
	return *p.startTime
}

func (p *Step) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *Step) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *Step) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *Step) SetStatus(attr StepStatus) {
	p.status = &attr
}

func (p *Step) Status() (StepStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero StepStatus
	return zero, false
}

func (p *Step) MustStatus() StepStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *Step) SetType(attr StepEnum) {
	p.type_ = &attr
}

func (p *Step) Type() (StepEnum, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero StepEnum
	return zero, false
}

func (p *Step) MustType() StepEnum {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type OpenStackNetworkProvider struct {
	Struct
	agentConfiguration     *AgentConfiguration
	authenticationUrl      *string
	autoSync               *bool
	certificates           *CertificateSlice
	comment                *string
	description            *string
	externalPluginType     *string
	id                     *string
	name                   *string
	networks               *OpenStackNetworkSlice
	password               *string
	pluginType             *NetworkPluginType
	projectDomainName      *string
	projectName            *string
	properties             *PropertySlice
	readOnly               *bool
	requiresAuthentication *bool
	subnets                *OpenStackSubnetSlice
	tenantName             *string
	type_                  *OpenStackNetworkProviderType
	unmanaged              *bool
	url                    *string
	userDomainName         *string
	username               *string
}

func (p *OpenStackNetworkProvider) SetAgentConfiguration(attr *AgentConfiguration) {
	p.agentConfiguration = attr
}

func (p *OpenStackNetworkProvider) AgentConfiguration() (*AgentConfiguration, bool) {
	if p.agentConfiguration != nil {
		return p.agentConfiguration, true
	}
	return nil, false
}

func (p *OpenStackNetworkProvider) MustAgentConfiguration() *AgentConfiguration {
	if p.agentConfiguration == nil {
		panic("the agentConfiguration must not be nil, please use AgentConfiguration() function instead")
	}
	return p.agentConfiguration
}

func (p *OpenStackNetworkProvider) SetAuthenticationUrl(attr string) {
	p.authenticationUrl = &attr
}

func (p *OpenStackNetworkProvider) AuthenticationUrl() (string, bool) {
	if p.authenticationUrl != nil {
		return *p.authenticationUrl, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustAuthenticationUrl() string {
	if p.authenticationUrl == nil {
		panic("the authenticationUrl must not be nil, please use AuthenticationUrl() function instead")
	}
	return *p.authenticationUrl
}

func (p *OpenStackNetworkProvider) SetAutoSync(attr bool) {
	p.autoSync = &attr
}

func (p *OpenStackNetworkProvider) AutoSync() (bool, bool) {
	if p.autoSync != nil {
		return *p.autoSync, true
	}
	var zero bool
	return zero, false
}

func (p *OpenStackNetworkProvider) MustAutoSync() bool {
	if p.autoSync == nil {
		panic("the autoSync must not be nil, please use AutoSync() function instead")
	}
	return *p.autoSync
}

func (p *OpenStackNetworkProvider) SetCertificates(attr *CertificateSlice) {
	p.certificates = attr
}

func (p *OpenStackNetworkProvider) Certificates() (*CertificateSlice, bool) {
	if p.certificates != nil {
		return p.certificates, true
	}
	return nil, false
}

func (p *OpenStackNetworkProvider) MustCertificates() *CertificateSlice {
	if p.certificates == nil {
		panic("the certificates must not be nil, please use Certificates() function instead")
	}
	return p.certificates
}

func (p *OpenStackNetworkProvider) SetComment(attr string) {
	p.comment = &attr
}

func (p *OpenStackNetworkProvider) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OpenStackNetworkProvider) SetDescription(attr string) {
	p.description = &attr
}

func (p *OpenStackNetworkProvider) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OpenStackNetworkProvider) SetExternalPluginType(attr string) {
	p.externalPluginType = &attr
}

func (p *OpenStackNetworkProvider) ExternalPluginType() (string, bool) {
	if p.externalPluginType != nil {
		return *p.externalPluginType, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustExternalPluginType() string {
	if p.externalPluginType == nil {
		panic("the externalPluginType must not be nil, please use ExternalPluginType() function instead")
	}
	return *p.externalPluginType
}

func (p *OpenStackNetworkProvider) SetId(attr string) {
	p.id = &attr
}

func (p *OpenStackNetworkProvider) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OpenStackNetworkProvider) SetName(attr string) {
	p.name = &attr
}

func (p *OpenStackNetworkProvider) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OpenStackNetworkProvider) SetNetworks(attr *OpenStackNetworkSlice) {
	p.networks = attr
}

func (p *OpenStackNetworkProvider) Networks() (*OpenStackNetworkSlice, bool) {
	if p.networks != nil {
		return p.networks, true
	}
	return nil, false
}

func (p *OpenStackNetworkProvider) MustNetworks() *OpenStackNetworkSlice {
	if p.networks == nil {
		panic("the networks must not be nil, please use Networks() function instead")
	}
	return p.networks
}

func (p *OpenStackNetworkProvider) SetPassword(attr string) {
	p.password = &attr
}

func (p *OpenStackNetworkProvider) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *OpenStackNetworkProvider) SetPluginType(attr NetworkPluginType) {
	p.pluginType = &attr
}

func (p *OpenStackNetworkProvider) PluginType() (NetworkPluginType, bool) {
	if p.pluginType != nil {
		return *p.pluginType, true
	}
	var zero NetworkPluginType
	return zero, false
}

func (p *OpenStackNetworkProvider) MustPluginType() NetworkPluginType {
	if p.pluginType == nil {
		panic("the pluginType must not be nil, please use PluginType() function instead")
	}
	return *p.pluginType
}

func (p *OpenStackNetworkProvider) SetProjectDomainName(attr string) {
	p.projectDomainName = &attr
}

func (p *OpenStackNetworkProvider) ProjectDomainName() (string, bool) {
	if p.projectDomainName != nil {
		return *p.projectDomainName, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustProjectDomainName() string {
	if p.projectDomainName == nil {
		panic("the projectDomainName must not be nil, please use ProjectDomainName() function instead")
	}
	return *p.projectDomainName
}

func (p *OpenStackNetworkProvider) SetProjectName(attr string) {
	p.projectName = &attr
}

func (p *OpenStackNetworkProvider) ProjectName() (string, bool) {
	if p.projectName != nil {
		return *p.projectName, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustProjectName() string {
	if p.projectName == nil {
		panic("the projectName must not be nil, please use ProjectName() function instead")
	}
	return *p.projectName
}

func (p *OpenStackNetworkProvider) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *OpenStackNetworkProvider) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *OpenStackNetworkProvider) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *OpenStackNetworkProvider) SetReadOnly(attr bool) {
	p.readOnly = &attr
}

func (p *OpenStackNetworkProvider) ReadOnly() (bool, bool) {
	if p.readOnly != nil {
		return *p.readOnly, true
	}
	var zero bool
	return zero, false
}

func (p *OpenStackNetworkProvider) MustReadOnly() bool {
	if p.readOnly == nil {
		panic("the readOnly must not be nil, please use ReadOnly() function instead")
	}
	return *p.readOnly
}

func (p *OpenStackNetworkProvider) SetRequiresAuthentication(attr bool) {
	p.requiresAuthentication = &attr
}

func (p *OpenStackNetworkProvider) RequiresAuthentication() (bool, bool) {
	if p.requiresAuthentication != nil {
		return *p.requiresAuthentication, true
	}
	var zero bool
	return zero, false
}

func (p *OpenStackNetworkProvider) MustRequiresAuthentication() bool {
	if p.requiresAuthentication == nil {
		panic("the requiresAuthentication must not be nil, please use RequiresAuthentication() function instead")
	}
	return *p.requiresAuthentication
}

func (p *OpenStackNetworkProvider) SetSubnets(attr *OpenStackSubnetSlice) {
	p.subnets = attr
}

func (p *OpenStackNetworkProvider) Subnets() (*OpenStackSubnetSlice, bool) {
	if p.subnets != nil {
		return p.subnets, true
	}
	return nil, false
}

func (p *OpenStackNetworkProvider) MustSubnets() *OpenStackSubnetSlice {
	if p.subnets == nil {
		panic("the subnets must not be nil, please use Subnets() function instead")
	}
	return p.subnets
}

func (p *OpenStackNetworkProvider) SetTenantName(attr string) {
	p.tenantName = &attr
}

func (p *OpenStackNetworkProvider) TenantName() (string, bool) {
	if p.tenantName != nil {
		return *p.tenantName, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustTenantName() string {
	if p.tenantName == nil {
		panic("the tenantName must not be nil, please use TenantName() function instead")
	}
	return *p.tenantName
}

func (p *OpenStackNetworkProvider) SetType(attr OpenStackNetworkProviderType) {
	p.type_ = &attr
}

func (p *OpenStackNetworkProvider) Type() (OpenStackNetworkProviderType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero OpenStackNetworkProviderType
	return zero, false
}

func (p *OpenStackNetworkProvider) MustType() OpenStackNetworkProviderType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *OpenStackNetworkProvider) SetUnmanaged(attr bool) {
	p.unmanaged = &attr
}

func (p *OpenStackNetworkProvider) Unmanaged() (bool, bool) {
	if p.unmanaged != nil {
		return *p.unmanaged, true
	}
	var zero bool
	return zero, false
}

func (p *OpenStackNetworkProvider) MustUnmanaged() bool {
	if p.unmanaged == nil {
		panic("the unmanaged must not be nil, please use Unmanaged() function instead")
	}
	return *p.unmanaged
}

func (p *OpenStackNetworkProvider) SetUrl(attr string) {
	p.url = &attr
}

func (p *OpenStackNetworkProvider) Url() (string, bool) {
	if p.url != nil {
		return *p.url, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustUrl() string {
	if p.url == nil {
		panic("the url must not be nil, please use Url() function instead")
	}
	return *p.url
}

func (p *OpenStackNetworkProvider) SetUserDomainName(attr string) {
	p.userDomainName = &attr
}

func (p *OpenStackNetworkProvider) UserDomainName() (string, bool) {
	if p.userDomainName != nil {
		return *p.userDomainName, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustUserDomainName() string {
	if p.userDomainName == nil {
		panic("the userDomainName must not be nil, please use UserDomainName() function instead")
	}
	return *p.userDomainName
}

func (p *OpenStackNetworkProvider) SetUsername(attr string) {
	p.username = &attr
}

func (p *OpenStackNetworkProvider) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackNetworkProvider) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

type Hook struct {
	Struct
	comment     *string
	description *string
	eventName   *string
	host        *Host
	id          *string
	md5         *string
	name        *string
}

func (p *Hook) SetComment(attr string) {
	p.comment = &attr
}

func (p *Hook) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Hook) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Hook) SetDescription(attr string) {
	p.description = &attr
}

func (p *Hook) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Hook) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Hook) SetEventName(attr string) {
	p.eventName = &attr
}

func (p *Hook) EventName() (string, bool) {
	if p.eventName != nil {
		return *p.eventName, true
	}
	var zero string
	return zero, false
}

func (p *Hook) MustEventName() string {
	if p.eventName == nil {
		panic("the eventName must not be nil, please use EventName() function instead")
	}
	return *p.eventName
}

func (p *Hook) SetHost(attr *Host) {
	p.host = attr
}

func (p *Hook) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *Hook) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *Hook) SetId(attr string) {
	p.id = &attr
}

func (p *Hook) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Hook) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Hook) SetMd5(attr string) {
	p.md5 = &attr
}

func (p *Hook) Md5() (string, bool) {
	if p.md5 != nil {
		return *p.md5, true
	}
	var zero string
	return zero, false
}

func (p *Hook) MustMd5() string {
	if p.md5 == nil {
		panic("the md5 must not be nil, please use Md5() function instead")
	}
	return *p.md5
}

func (p *Hook) SetName(attr string) {
	p.name = &attr
}

func (p *Hook) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Hook) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type Configuration struct {
	Struct
	data  *string
	type_ *ConfigurationType
}

func (p *Configuration) SetData(attr string) {
	p.data = &attr
}

func (p *Configuration) Data() (string, bool) {
	if p.data != nil {
		return *p.data, true
	}
	var zero string
	return zero, false
}

func (p *Configuration) MustData() string {
	if p.data == nil {
		panic("the data must not be nil, please use Data() function instead")
	}
	return *p.data
}

func (p *Configuration) SetType(attr ConfigurationType) {
	p.type_ = &attr
}

func (p *Configuration) Type() (ConfigurationType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero ConfigurationType
	return zero, false
}

func (p *Configuration) MustType() ConfigurationType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type OperatingSystemInfo struct {
	Struct
	architecture *Architecture
	comment      *string
	description  *string
	id           *string
	largeIcon    *Icon
	name         *string
	smallIcon    *Icon
}

func (p *OperatingSystemInfo) SetArchitecture(attr Architecture) {
	p.architecture = &attr
}

func (p *OperatingSystemInfo) Architecture() (Architecture, bool) {
	if p.architecture != nil {
		return *p.architecture, true
	}
	var zero Architecture
	return zero, false
}

func (p *OperatingSystemInfo) MustArchitecture() Architecture {
	if p.architecture == nil {
		panic("the architecture must not be nil, please use Architecture() function instead")
	}
	return *p.architecture
}

func (p *OperatingSystemInfo) SetComment(attr string) {
	p.comment = &attr
}

func (p *OperatingSystemInfo) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystemInfo) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OperatingSystemInfo) SetDescription(attr string) {
	p.description = &attr
}

func (p *OperatingSystemInfo) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystemInfo) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OperatingSystemInfo) SetId(attr string) {
	p.id = &attr
}

func (p *OperatingSystemInfo) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystemInfo) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OperatingSystemInfo) SetLargeIcon(attr *Icon) {
	p.largeIcon = attr
}

func (p *OperatingSystemInfo) LargeIcon() (*Icon, bool) {
	if p.largeIcon != nil {
		return p.largeIcon, true
	}
	return nil, false
}

func (p *OperatingSystemInfo) MustLargeIcon() *Icon {
	if p.largeIcon == nil {
		panic("the largeIcon must not be nil, please use LargeIcon() function instead")
	}
	return p.largeIcon
}

func (p *OperatingSystemInfo) SetName(attr string) {
	p.name = &attr
}

func (p *OperatingSystemInfo) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystemInfo) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OperatingSystemInfo) SetSmallIcon(attr *Icon) {
	p.smallIcon = attr
}

func (p *OperatingSystemInfo) SmallIcon() (*Icon, bool) {
	if p.smallIcon != nil {
		return p.smallIcon, true
	}
	return nil, false
}

func (p *OperatingSystemInfo) MustSmallIcon() *Icon {
	if p.smallIcon == nil {
		panic("the smallIcon must not be nil, please use SmallIcon() function instead")
	}
	return p.smallIcon
}

type RegistrationLunMapping struct {
	Struct
	from *Disk
	to   *Disk
}

func (p *RegistrationLunMapping) SetFrom(attr *Disk) {
	p.from = attr
}

func (p *RegistrationLunMapping) From() (*Disk, bool) {
	if p.from != nil {
		return p.from, true
	}
	return nil, false
}

func (p *RegistrationLunMapping) MustFrom() *Disk {
	if p.from == nil {
		panic("the from must not be nil, please use From() function instead")
	}
	return p.from
}

func (p *RegistrationLunMapping) SetTo(attr *Disk) {
	p.to = attr
}

func (p *RegistrationLunMapping) To() (*Disk, bool) {
	if p.to != nil {
		return p.to, true
	}
	return nil, false
}

func (p *RegistrationLunMapping) MustTo() *Disk {
	if p.to == nil {
		panic("the to must not be nil, please use To() function instead")
	}
	return p.to
}

type Device struct {
	Struct
	comment      *string
	description  *string
	id           *string
	instanceType *InstanceType
	name         *string
	template     *Template
	vm           *Vm
	vms          *VmSlice
}

func (p *Device) SetComment(attr string) {
	p.comment = &attr
}

func (p *Device) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Device) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Device) SetDescription(attr string) {
	p.description = &attr
}

func (p *Device) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Device) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Device) SetId(attr string) {
	p.id = &attr
}

func (p *Device) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Device) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Device) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *Device) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *Device) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *Device) SetName(attr string) {
	p.name = &attr
}

func (p *Device) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Device) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Device) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Device) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Device) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Device) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Device) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Device) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Device) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *Device) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *Device) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

type NumaNodePin struct {
	Struct
	hostNumaNode *NumaNode
	index        *int64
	pinned       *bool
}

func (p *NumaNodePin) SetHostNumaNode(attr *NumaNode) {
	p.hostNumaNode = attr
}

func (p *NumaNodePin) HostNumaNode() (*NumaNode, bool) {
	if p.hostNumaNode != nil {
		return p.hostNumaNode, true
	}
	return nil, false
}

func (p *NumaNodePin) MustHostNumaNode() *NumaNode {
	if p.hostNumaNode == nil {
		panic("the hostNumaNode must not be nil, please use HostNumaNode() function instead")
	}
	return p.hostNumaNode
}

func (p *NumaNodePin) SetIndex(attr int64) {
	p.index = &attr
}

func (p *NumaNodePin) Index() (int64, bool) {
	if p.index != nil {
		return *p.index, true
	}
	var zero int64
	return zero, false
}

func (p *NumaNodePin) MustIndex() int64 {
	if p.index == nil {
		panic("the index must not be nil, please use Index() function instead")
	}
	return *p.index
}

func (p *NumaNodePin) SetPinned(attr bool) {
	p.pinned = &attr
}

func (p *NumaNodePin) Pinned() (bool, bool) {
	if p.pinned != nil {
		return *p.pinned, true
	}
	var zero bool
	return zero, false
}

func (p *NumaNodePin) MustPinned() bool {
	if p.pinned == nil {
		panic("the pinned must not be nil, please use Pinned() function instead")
	}
	return *p.pinned
}

type ReportedDevice struct {
	Struct
	comment     *string
	description *string
	id          *string
	ips         *IpSlice
	mac         *Mac
	name        *string
	type_       *ReportedDeviceType
	vm          *Vm
}

func (p *ReportedDevice) SetComment(attr string) {
	p.comment = &attr
}

func (p *ReportedDevice) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ReportedDevice) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ReportedDevice) SetDescription(attr string) {
	p.description = &attr
}

func (p *ReportedDevice) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ReportedDevice) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ReportedDevice) SetId(attr string) {
	p.id = &attr
}

func (p *ReportedDevice) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ReportedDevice) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ReportedDevice) SetIps(attr *IpSlice) {
	p.ips = attr
}

func (p *ReportedDevice) Ips() (*IpSlice, bool) {
	if p.ips != nil {
		return p.ips, true
	}
	return nil, false
}

func (p *ReportedDevice) MustIps() *IpSlice {
	if p.ips == nil {
		panic("the ips must not be nil, please use Ips() function instead")
	}
	return p.ips
}

func (p *ReportedDevice) SetMac(attr *Mac) {
	p.mac = attr
}

func (p *ReportedDevice) Mac() (*Mac, bool) {
	if p.mac != nil {
		return p.mac, true
	}
	return nil, false
}

func (p *ReportedDevice) MustMac() *Mac {
	if p.mac == nil {
		panic("the mac must not be nil, please use Mac() function instead")
	}
	return p.mac
}

func (p *ReportedDevice) SetName(attr string) {
	p.name = &attr
}

func (p *ReportedDevice) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ReportedDevice) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ReportedDevice) SetType(attr ReportedDeviceType) {
	p.type_ = &attr
}

func (p *ReportedDevice) Type() (ReportedDeviceType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero ReportedDeviceType
	return zero, false
}

func (p *ReportedDevice) MustType() ReportedDeviceType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *ReportedDevice) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *ReportedDevice) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *ReportedDevice) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type HostDevicePassthrough struct {
	Struct
	enabled *bool
}

func (p *HostDevicePassthrough) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *HostDevicePassthrough) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *HostDevicePassthrough) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

type Agent struct {
	Struct
	address        *string
	comment        *string
	concurrent     *bool
	description    *string
	encryptOptions *bool
	host           *Host
	id             *string
	name           *string
	options        *OptionSlice
	order          *int64
	password       *string
	port           *int64
	type_          *string
	username       *string
}

func (p *Agent) SetAddress(attr string) {
	p.address = &attr
}

func (p *Agent) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *Agent) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *Agent) SetComment(attr string) {
	p.comment = &attr
}

func (p *Agent) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Agent) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Agent) SetConcurrent(attr bool) {
	p.concurrent = &attr
}

func (p *Agent) Concurrent() (bool, bool) {
	if p.concurrent != nil {
		return *p.concurrent, true
	}
	var zero bool
	return zero, false
}

func (p *Agent) MustConcurrent() bool {
	if p.concurrent == nil {
		panic("the concurrent must not be nil, please use Concurrent() function instead")
	}
	return *p.concurrent
}

func (p *Agent) SetDescription(attr string) {
	p.description = &attr
}

func (p *Agent) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Agent) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Agent) SetEncryptOptions(attr bool) {
	p.encryptOptions = &attr
}

func (p *Agent) EncryptOptions() (bool, bool) {
	if p.encryptOptions != nil {
		return *p.encryptOptions, true
	}
	var zero bool
	return zero, false
}

func (p *Agent) MustEncryptOptions() bool {
	if p.encryptOptions == nil {
		panic("the encryptOptions must not be nil, please use EncryptOptions() function instead")
	}
	return *p.encryptOptions
}

func (p *Agent) SetHost(attr *Host) {
	p.host = attr
}

func (p *Agent) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *Agent) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *Agent) SetId(attr string) {
	p.id = &attr
}

func (p *Agent) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Agent) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Agent) SetName(attr string) {
	p.name = &attr
}

func (p *Agent) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Agent) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Agent) SetOptions(attr *OptionSlice) {
	p.options = attr
}

func (p *Agent) Options() (*OptionSlice, bool) {
	if p.options != nil {
		return p.options, true
	}
	return nil, false
}

func (p *Agent) MustOptions() *OptionSlice {
	if p.options == nil {
		panic("the options must not be nil, please use Options() function instead")
	}
	return p.options
}

func (p *Agent) SetOrder(attr int64) {
	p.order = &attr
}

func (p *Agent) Order() (int64, bool) {
	if p.order != nil {
		return *p.order, true
	}
	var zero int64
	return zero, false
}

func (p *Agent) MustOrder() int64 {
	if p.order == nil {
		panic("the order must not be nil, please use Order() function instead")
	}
	return *p.order
}

func (p *Agent) SetPassword(attr string) {
	p.password = &attr
}

func (p *Agent) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *Agent) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *Agent) SetPort(attr int64) {
	p.port = &attr
}

func (p *Agent) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *Agent) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *Agent) SetType(attr string) {
	p.type_ = &attr
}

func (p *Agent) Type() (string, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero string
	return zero, false
}

func (p *Agent) MustType() string {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *Agent) SetUsername(attr string) {
	p.username = &attr
}

func (p *Agent) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *Agent) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

type SerialNumber struct {
	Struct
	policy *SerialNumberPolicy
	value  *string
}

func (p *SerialNumber) SetPolicy(attr SerialNumberPolicy) {
	p.policy = &attr
}

func (p *SerialNumber) Policy() (SerialNumberPolicy, bool) {
	if p.policy != nil {
		return *p.policy, true
	}
	var zero SerialNumberPolicy
	return zero, false
}

func (p *SerialNumber) MustPolicy() SerialNumberPolicy {
	if p.policy == nil {
		panic("the policy must not be nil, please use Policy() function instead")
	}
	return *p.policy
}

func (p *SerialNumber) SetValue(attr string) {
	p.value = &attr
}

func (p *SerialNumber) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *SerialNumber) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

type Usb struct {
	Struct
	enabled *bool
	type_   *UsbType
}

func (p *Usb) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *Usb) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *Usb) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

func (p *Usb) SetType(attr UsbType) {
	p.type_ = &attr
}

func (p *Usb) Type() (UsbType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero UsbType
	return zero, false
}

func (p *Usb) MustType() UsbType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type RegistrationDomainMapping struct {
	Struct
	from *Domain
	to   *Domain
}

func (p *RegistrationDomainMapping) SetFrom(attr *Domain) {
	p.from = attr
}

func (p *RegistrationDomainMapping) From() (*Domain, bool) {
	if p.from != nil {
		return p.from, true
	}
	return nil, false
}

func (p *RegistrationDomainMapping) MustFrom() *Domain {
	if p.from == nil {
		panic("the from must not be nil, please use From() function instead")
	}
	return p.from
}

func (p *RegistrationDomainMapping) SetTo(attr *Domain) {
	p.to = attr
}

func (p *RegistrationDomainMapping) To() (*Domain, bool) {
	if p.to != nil {
		return p.to, true
	}
	return nil, false
}

func (p *RegistrationDomainMapping) MustTo() *Domain {
	if p.to == nil {
		panic("the to must not be nil, please use To() function instead")
	}
	return p.to
}

type Group struct {
	Struct
	comment       *string
	description   *string
	domain        *Domain
	domainEntryId *string
	id            *string
	name          *string
	namespace     *string
	permissions   *PermissionSlice
	roles         *RoleSlice
	tags          *TagSlice
}

func (p *Group) SetComment(attr string) {
	p.comment = &attr
}

func (p *Group) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Group) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Group) SetDescription(attr string) {
	p.description = &attr
}

func (p *Group) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Group) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Group) SetDomain(attr *Domain) {
	p.domain = attr
}

func (p *Group) Domain() (*Domain, bool) {
	if p.domain != nil {
		return p.domain, true
	}
	return nil, false
}

func (p *Group) MustDomain() *Domain {
	if p.domain == nil {
		panic("the domain must not be nil, please use Domain() function instead")
	}
	return p.domain
}

func (p *Group) SetDomainEntryId(attr string) {
	p.domainEntryId = &attr
}

func (p *Group) DomainEntryId() (string, bool) {
	if p.domainEntryId != nil {
		return *p.domainEntryId, true
	}
	var zero string
	return zero, false
}

func (p *Group) MustDomainEntryId() string {
	if p.domainEntryId == nil {
		panic("the domainEntryId must not be nil, please use DomainEntryId() function instead")
	}
	return *p.domainEntryId
}

func (p *Group) SetId(attr string) {
	p.id = &attr
}

func (p *Group) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Group) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Group) SetName(attr string) {
	p.name = &attr
}

func (p *Group) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Group) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Group) SetNamespace(attr string) {
	p.namespace = &attr
}

func (p *Group) Namespace() (string, bool) {
	if p.namespace != nil {
		return *p.namespace, true
	}
	var zero string
	return zero, false
}

func (p *Group) MustNamespace() string {
	if p.namespace == nil {
		panic("the namespace must not be nil, please use Namespace() function instead")
	}
	return *p.namespace
}

func (p *Group) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *Group) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *Group) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *Group) SetRoles(attr *RoleSlice) {
	p.roles = attr
}

func (p *Group) Roles() (*RoleSlice, bool) {
	if p.roles != nil {
		return p.roles, true
	}
	return nil, false
}

func (p *Group) MustRoles() *RoleSlice {
	if p.roles == nil {
		panic("the roles must not be nil, please use Roles() function instead")
	}
	return p.roles
}

func (p *Group) SetTags(attr *TagSlice) {
	p.tags = attr
}

func (p *Group) Tags() (*TagSlice, bool) {
	if p.tags != nil {
		return p.tags, true
	}
	return nil, false
}

func (p *Group) MustTags() *TagSlice {
	if p.tags == nil {
		panic("the tags must not be nil, please use Tags() function instead")
	}
	return p.tags
}

type Rate struct {
	Struct
	bytes  *int64
	period *int64
}

func (p *Rate) SetBytes(attr int64) {
	p.bytes = &attr
}

func (p *Rate) Bytes() (int64, bool) {
	if p.bytes != nil {
		return *p.bytes, true
	}
	var zero int64
	return zero, false
}

func (p *Rate) MustBytes() int64 {
	if p.bytes == nil {
		panic("the bytes must not be nil, please use Bytes() function instead")
	}
	return *p.bytes
}

func (p *Rate) SetPeriod(attr int64) {
	p.period = &attr
}

func (p *Rate) Period() (int64, bool) {
	if p.period != nil {
		return *p.period, true
	}
	var zero int64
	return zero, false
}

func (p *Rate) MustPeriod() int64 {
	if p.period == nil {
		panic("the period must not be nil, please use Period() function instead")
	}
	return *p.period
}

type AffinityLabel struct {
	Struct
	comment                  *string
	description              *string
	hasImplicitAffinityGroup *bool
	hosts                    *HostSlice
	id                       *string
	name                     *string
	readOnly                 *bool
	vms                      *VmSlice
}

func (p *AffinityLabel) SetComment(attr string) {
	p.comment = &attr
}

func (p *AffinityLabel) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *AffinityLabel) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *AffinityLabel) SetDescription(attr string) {
	p.description = &attr
}

func (p *AffinityLabel) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *AffinityLabel) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *AffinityLabel) SetHasImplicitAffinityGroup(attr bool) {
	p.hasImplicitAffinityGroup = &attr
}

func (p *AffinityLabel) HasImplicitAffinityGroup() (bool, bool) {
	if p.hasImplicitAffinityGroup != nil {
		return *p.hasImplicitAffinityGroup, true
	}
	var zero bool
	return zero, false
}

func (p *AffinityLabel) MustHasImplicitAffinityGroup() bool {
	if p.hasImplicitAffinityGroup == nil {
		panic("the hasImplicitAffinityGroup must not be nil, please use HasImplicitAffinityGroup() function instead")
	}
	return *p.hasImplicitAffinityGroup
}

func (p *AffinityLabel) SetHosts(attr *HostSlice) {
	p.hosts = attr
}

func (p *AffinityLabel) Hosts() (*HostSlice, bool) {
	if p.hosts != nil {
		return p.hosts, true
	}
	return nil, false
}

func (p *AffinityLabel) MustHosts() *HostSlice {
	if p.hosts == nil {
		panic("the hosts must not be nil, please use Hosts() function instead")
	}
	return p.hosts
}

func (p *AffinityLabel) SetId(attr string) {
	p.id = &attr
}

func (p *AffinityLabel) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *AffinityLabel) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *AffinityLabel) SetName(attr string) {
	p.name = &attr
}

func (p *AffinityLabel) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *AffinityLabel) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *AffinityLabel) SetReadOnly(attr bool) {
	p.readOnly = &attr
}

func (p *AffinityLabel) ReadOnly() (bool, bool) {
	if p.readOnly != nil {
		return *p.readOnly, true
	}
	var zero bool
	return zero, false
}

func (p *AffinityLabel) MustReadOnly() bool {
	if p.readOnly == nil {
		panic("the readOnly must not be nil, please use ReadOnly() function instead")
	}
	return *p.readOnly
}

func (p *AffinityLabel) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *AffinityLabel) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *AffinityLabel) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

type HostNicVirtualFunctionsConfiguration struct {
	Struct
	allNetworksAllowed          *bool
	maxNumberOfVirtualFunctions *int64
	numberOfVirtualFunctions    *int64
}

func (p *HostNicVirtualFunctionsConfiguration) SetAllNetworksAllowed(attr bool) {
	p.allNetworksAllowed = &attr
}

func (p *HostNicVirtualFunctionsConfiguration) AllNetworksAllowed() (bool, bool) {
	if p.allNetworksAllowed != nil {
		return *p.allNetworksAllowed, true
	}
	var zero bool
	return zero, false
}

func (p *HostNicVirtualFunctionsConfiguration) MustAllNetworksAllowed() bool {
	if p.allNetworksAllowed == nil {
		panic("the allNetworksAllowed must not be nil, please use AllNetworksAllowed() function instead")
	}
	return *p.allNetworksAllowed
}

func (p *HostNicVirtualFunctionsConfiguration) SetMaxNumberOfVirtualFunctions(attr int64) {
	p.maxNumberOfVirtualFunctions = &attr
}

func (p *HostNicVirtualFunctionsConfiguration) MaxNumberOfVirtualFunctions() (int64, bool) {
	if p.maxNumberOfVirtualFunctions != nil {
		return *p.maxNumberOfVirtualFunctions, true
	}
	var zero int64
	return zero, false
}

func (p *HostNicVirtualFunctionsConfiguration) MustMaxNumberOfVirtualFunctions() int64 {
	if p.maxNumberOfVirtualFunctions == nil {
		panic("the maxNumberOfVirtualFunctions must not be nil, please use MaxNumberOfVirtualFunctions() function instead")
	}
	return *p.maxNumberOfVirtualFunctions
}

func (p *HostNicVirtualFunctionsConfiguration) SetNumberOfVirtualFunctions(attr int64) {
	p.numberOfVirtualFunctions = &attr
}

func (p *HostNicVirtualFunctionsConfiguration) NumberOfVirtualFunctions() (int64, bool) {
	if p.numberOfVirtualFunctions != nil {
		return *p.numberOfVirtualFunctions, true
	}
	var zero int64
	return zero, false
}

func (p *HostNicVirtualFunctionsConfiguration) MustNumberOfVirtualFunctions() int64 {
	if p.numberOfVirtualFunctions == nil {
		panic("the numberOfVirtualFunctions must not be nil, please use NumberOfVirtualFunctions() function instead")
	}
	return *p.numberOfVirtualFunctions
}

type OpenStackImage struct {
	Struct
	comment                *string
	description            *string
	id                     *string
	name                   *string
	openstackImageProvider *OpenStackImageProvider
}

func (p *OpenStackImage) SetComment(attr string) {
	p.comment = &attr
}

func (p *OpenStackImage) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImage) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OpenStackImage) SetDescription(attr string) {
	p.description = &attr
}

func (p *OpenStackImage) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImage) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OpenStackImage) SetId(attr string) {
	p.id = &attr
}

func (p *OpenStackImage) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImage) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OpenStackImage) SetName(attr string) {
	p.name = &attr
}

func (p *OpenStackImage) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImage) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OpenStackImage) SetOpenstackImageProvider(attr *OpenStackImageProvider) {
	p.openstackImageProvider = attr
}

func (p *OpenStackImage) OpenstackImageProvider() (*OpenStackImageProvider, bool) {
	if p.openstackImageProvider != nil {
		return p.openstackImageProvider, true
	}
	return nil, false
}

func (p *OpenStackImage) MustOpenstackImageProvider() *OpenStackImageProvider {
	if p.openstackImageProvider == nil {
		panic("the openstackImageProvider must not be nil, please use OpenstackImageProvider() function instead")
	}
	return p.openstackImageProvider
}

type Kernel struct {
	Struct
	version *Version
}

func (p *Kernel) SetVersion(attr *Version) {
	p.version = attr
}

func (p *Kernel) Version() (*Version, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *Kernel) MustVersion() *Version {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

type ExternalHostProvider struct {
	Struct
	authenticationUrl      *string
	certificates           *CertificateSlice
	comment                *string
	computeResources       *ExternalComputeResourceSlice
	description            *string
	discoveredHosts        *ExternalDiscoveredHostSlice
	hostGroups             *ExternalHostGroupSlice
	hosts                  *HostSlice
	id                     *string
	name                   *string
	password               *string
	properties             *PropertySlice
	requiresAuthentication *bool
	url                    *string
	username               *string
}

func (p *ExternalHostProvider) SetAuthenticationUrl(attr string) {
	p.authenticationUrl = &attr
}

func (p *ExternalHostProvider) AuthenticationUrl() (string, bool) {
	if p.authenticationUrl != nil {
		return *p.authenticationUrl, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostProvider) MustAuthenticationUrl() string {
	if p.authenticationUrl == nil {
		panic("the authenticationUrl must not be nil, please use AuthenticationUrl() function instead")
	}
	return *p.authenticationUrl
}

func (p *ExternalHostProvider) SetCertificates(attr *CertificateSlice) {
	p.certificates = attr
}

func (p *ExternalHostProvider) Certificates() (*CertificateSlice, bool) {
	if p.certificates != nil {
		return p.certificates, true
	}
	return nil, false
}

func (p *ExternalHostProvider) MustCertificates() *CertificateSlice {
	if p.certificates == nil {
		panic("the certificates must not be nil, please use Certificates() function instead")
	}
	return p.certificates
}

func (p *ExternalHostProvider) SetComment(attr string) {
	p.comment = &attr
}

func (p *ExternalHostProvider) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostProvider) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ExternalHostProvider) SetComputeResources(attr *ExternalComputeResourceSlice) {
	p.computeResources = attr
}

func (p *ExternalHostProvider) ComputeResources() (*ExternalComputeResourceSlice, bool) {
	if p.computeResources != nil {
		return p.computeResources, true
	}
	return nil, false
}

func (p *ExternalHostProvider) MustComputeResources() *ExternalComputeResourceSlice {
	if p.computeResources == nil {
		panic("the computeResources must not be nil, please use ComputeResources() function instead")
	}
	return p.computeResources
}

func (p *ExternalHostProvider) SetDescription(attr string) {
	p.description = &attr
}

func (p *ExternalHostProvider) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostProvider) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ExternalHostProvider) SetDiscoveredHosts(attr *ExternalDiscoveredHostSlice) {
	p.discoveredHosts = attr
}

func (p *ExternalHostProvider) DiscoveredHosts() (*ExternalDiscoveredHostSlice, bool) {
	if p.discoveredHosts != nil {
		return p.discoveredHosts, true
	}
	return nil, false
}

func (p *ExternalHostProvider) MustDiscoveredHosts() *ExternalDiscoveredHostSlice {
	if p.discoveredHosts == nil {
		panic("the discoveredHosts must not be nil, please use DiscoveredHosts() function instead")
	}
	return p.discoveredHosts
}

func (p *ExternalHostProvider) SetHostGroups(attr *ExternalHostGroupSlice) {
	p.hostGroups = attr
}

func (p *ExternalHostProvider) HostGroups() (*ExternalHostGroupSlice, bool) {
	if p.hostGroups != nil {
		return p.hostGroups, true
	}
	return nil, false
}

func (p *ExternalHostProvider) MustHostGroups() *ExternalHostGroupSlice {
	if p.hostGroups == nil {
		panic("the hostGroups must not be nil, please use HostGroups() function instead")
	}
	return p.hostGroups
}

func (p *ExternalHostProvider) SetHosts(attr *HostSlice) {
	p.hosts = attr
}

func (p *ExternalHostProvider) Hosts() (*HostSlice, bool) {
	if p.hosts != nil {
		return p.hosts, true
	}
	return nil, false
}

func (p *ExternalHostProvider) MustHosts() *HostSlice {
	if p.hosts == nil {
		panic("the hosts must not be nil, please use Hosts() function instead")
	}
	return p.hosts
}

func (p *ExternalHostProvider) SetId(attr string) {
	p.id = &attr
}

func (p *ExternalHostProvider) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostProvider) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ExternalHostProvider) SetName(attr string) {
	p.name = &attr
}

func (p *ExternalHostProvider) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostProvider) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ExternalHostProvider) SetPassword(attr string) {
	p.password = &attr
}

func (p *ExternalHostProvider) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostProvider) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *ExternalHostProvider) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *ExternalHostProvider) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *ExternalHostProvider) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *ExternalHostProvider) SetRequiresAuthentication(attr bool) {
	p.requiresAuthentication = &attr
}

func (p *ExternalHostProvider) RequiresAuthentication() (bool, bool) {
	if p.requiresAuthentication != nil {
		return *p.requiresAuthentication, true
	}
	var zero bool
	return zero, false
}

func (p *ExternalHostProvider) MustRequiresAuthentication() bool {
	if p.requiresAuthentication == nil {
		panic("the requiresAuthentication must not be nil, please use RequiresAuthentication() function instead")
	}
	return *p.requiresAuthentication
}

func (p *ExternalHostProvider) SetUrl(attr string) {
	p.url = &attr
}

func (p *ExternalHostProvider) Url() (string, bool) {
	if p.url != nil {
		return *p.url, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostProvider) MustUrl() string {
	if p.url == nil {
		panic("the url must not be nil, please use Url() function instead")
	}
	return *p.url
}

func (p *ExternalHostProvider) SetUsername(attr string) {
	p.username = &attr
}

func (p *ExternalHostProvider) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHostProvider) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

type Sso struct {
	Struct
	methods *MethodSlice
}

func (p *Sso) SetMethods(attr *MethodSlice) {
	p.methods = attr
}

func (p *Sso) Methods() (*MethodSlice, bool) {
	if p.methods != nil {
		return p.methods, true
	}
	return nil, false
}

func (p *Sso) MustMethods() *MethodSlice {
	if p.methods == nil {
		panic("the methods must not be nil, please use Methods() function instead")
	}
	return p.methods
}

type IscsiDetails struct {
	Struct
	address         *string
	diskId          *string
	initiator       *string
	lunMapping      *int64
	password        *string
	paths           *int64
	port            *int64
	portal          *string
	productId       *string
	serial          *string
	size            *int64
	status          *string
	storageDomainId *string
	target          *string
	username        *string
	vendorId        *string
	volumeGroupId   *string
}

func (p *IscsiDetails) SetAddress(attr string) {
	p.address = &attr
}

func (p *IscsiDetails) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *IscsiDetails) SetDiskId(attr string) {
	p.diskId = &attr
}

func (p *IscsiDetails) DiskId() (string, bool) {
	if p.diskId != nil {
		return *p.diskId, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustDiskId() string {
	if p.diskId == nil {
		panic("the diskId must not be nil, please use DiskId() function instead")
	}
	return *p.diskId
}

func (p *IscsiDetails) SetInitiator(attr string) {
	p.initiator = &attr
}

func (p *IscsiDetails) Initiator() (string, bool) {
	if p.initiator != nil {
		return *p.initiator, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustInitiator() string {
	if p.initiator == nil {
		panic("the initiator must not be nil, please use Initiator() function instead")
	}
	return *p.initiator
}

func (p *IscsiDetails) SetLunMapping(attr int64) {
	p.lunMapping = &attr
}

func (p *IscsiDetails) LunMapping() (int64, bool) {
	if p.lunMapping != nil {
		return *p.lunMapping, true
	}
	var zero int64
	return zero, false
}

func (p *IscsiDetails) MustLunMapping() int64 {
	if p.lunMapping == nil {
		panic("the lunMapping must not be nil, please use LunMapping() function instead")
	}
	return *p.lunMapping
}

func (p *IscsiDetails) SetPassword(attr string) {
	p.password = &attr
}

func (p *IscsiDetails) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *IscsiDetails) SetPaths(attr int64) {
	p.paths = &attr
}

func (p *IscsiDetails) Paths() (int64, bool) {
	if p.paths != nil {
		return *p.paths, true
	}
	var zero int64
	return zero, false
}

func (p *IscsiDetails) MustPaths() int64 {
	if p.paths == nil {
		panic("the paths must not be nil, please use Paths() function instead")
	}
	return *p.paths
}

func (p *IscsiDetails) SetPort(attr int64) {
	p.port = &attr
}

func (p *IscsiDetails) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *IscsiDetails) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *IscsiDetails) SetPortal(attr string) {
	p.portal = &attr
}

func (p *IscsiDetails) Portal() (string, bool) {
	if p.portal != nil {
		return *p.portal, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustPortal() string {
	if p.portal == nil {
		panic("the portal must not be nil, please use Portal() function instead")
	}
	return *p.portal
}

func (p *IscsiDetails) SetProductId(attr string) {
	p.productId = &attr
}

func (p *IscsiDetails) ProductId() (string, bool) {
	if p.productId != nil {
		return *p.productId, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustProductId() string {
	if p.productId == nil {
		panic("the productId must not be nil, please use ProductId() function instead")
	}
	return *p.productId
}

func (p *IscsiDetails) SetSerial(attr string) {
	p.serial = &attr
}

func (p *IscsiDetails) Serial() (string, bool) {
	if p.serial != nil {
		return *p.serial, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustSerial() string {
	if p.serial == nil {
		panic("the serial must not be nil, please use Serial() function instead")
	}
	return *p.serial
}

func (p *IscsiDetails) SetSize(attr int64) {
	p.size = &attr
}

func (p *IscsiDetails) Size() (int64, bool) {
	if p.size != nil {
		return *p.size, true
	}
	var zero int64
	return zero, false
}

func (p *IscsiDetails) MustSize() int64 {
	if p.size == nil {
		panic("the size must not be nil, please use Size() function instead")
	}
	return *p.size
}

func (p *IscsiDetails) SetStatus(attr string) {
	p.status = &attr
}

func (p *IscsiDetails) Status() (string, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustStatus() string {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *IscsiDetails) SetStorageDomainId(attr string) {
	p.storageDomainId = &attr
}

func (p *IscsiDetails) StorageDomainId() (string, bool) {
	if p.storageDomainId != nil {
		return *p.storageDomainId, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustStorageDomainId() string {
	if p.storageDomainId == nil {
		panic("the storageDomainId must not be nil, please use StorageDomainId() function instead")
	}
	return *p.storageDomainId
}

func (p *IscsiDetails) SetTarget(attr string) {
	p.target = &attr
}

func (p *IscsiDetails) Target() (string, bool) {
	if p.target != nil {
		return *p.target, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustTarget() string {
	if p.target == nil {
		panic("the target must not be nil, please use Target() function instead")
	}
	return *p.target
}

func (p *IscsiDetails) SetUsername(attr string) {
	p.username = &attr
}

func (p *IscsiDetails) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

func (p *IscsiDetails) SetVendorId(attr string) {
	p.vendorId = &attr
}

func (p *IscsiDetails) VendorId() (string, bool) {
	if p.vendorId != nil {
		return *p.vendorId, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustVendorId() string {
	if p.vendorId == nil {
		panic("the vendorId must not be nil, please use VendorId() function instead")
	}
	return *p.vendorId
}

func (p *IscsiDetails) SetVolumeGroupId(attr string) {
	p.volumeGroupId = &attr
}

func (p *IscsiDetails) VolumeGroupId() (string, bool) {
	if p.volumeGroupId != nil {
		return *p.volumeGroupId, true
	}
	var zero string
	return zero, false
}

func (p *IscsiDetails) MustVolumeGroupId() string {
	if p.volumeGroupId == nil {
		panic("the volumeGroupId must not be nil, please use VolumeGroupId() function instead")
	}
	return *p.volumeGroupId
}

type DnsResolverConfiguration struct {
	Struct
	nameServers []string
}

func (p *DnsResolverConfiguration) SetNameServers(attr []string) {
	p.nameServers = attr
}

func (p *DnsResolverConfiguration) NameServers() ([]string, bool) {
	if p.nameServers != nil {
		return p.nameServers, true
	}
	return nil, false
}

func (p *DnsResolverConfiguration) MustNameServers() []string {
	if p.nameServers == nil {
		panic("the nameServers must not be nil, please use NameServers() function instead")
	}
	return p.nameServers
}

type Method struct {
	Struct
	id *SsoMethod
}

func (p *Method) SetId(attr SsoMethod) {
	p.id = &attr
}

func (p *Method) Id() (SsoMethod, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero SsoMethod
	return zero, false
}

func (p *Method) MustId() SsoMethod {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

type DataCenter struct {
	Struct
	clusters          *ClusterSlice
	comment           *string
	description       *string
	id                *string
	iscsiBonds        *IscsiBondSlice
	local             *bool
	macPool           *MacPool
	name              *string
	networks          *NetworkSlice
	permissions       *PermissionSlice
	qoss              *QosSlice
	quotaMode         *QuotaModeType
	quotas            *QuotaSlice
	status            *DataCenterStatus
	storageDomains    *StorageDomainSlice
	storageFormat     *StorageFormat
	supportedVersions *VersionSlice
	version           *Version
}

func (p *DataCenter) SetClusters(attr *ClusterSlice) {
	p.clusters = attr
}

func (p *DataCenter) Clusters() (*ClusterSlice, bool) {
	if p.clusters != nil {
		return p.clusters, true
	}
	return nil, false
}

func (p *DataCenter) MustClusters() *ClusterSlice {
	if p.clusters == nil {
		panic("the clusters must not be nil, please use Clusters() function instead")
	}
	return p.clusters
}

func (p *DataCenter) SetComment(attr string) {
	p.comment = &attr
}

func (p *DataCenter) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *DataCenter) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *DataCenter) SetDescription(attr string) {
	p.description = &attr
}

func (p *DataCenter) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *DataCenter) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *DataCenter) SetId(attr string) {
	p.id = &attr
}

func (p *DataCenter) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *DataCenter) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *DataCenter) SetIscsiBonds(attr *IscsiBondSlice) {
	p.iscsiBonds = attr
}

func (p *DataCenter) IscsiBonds() (*IscsiBondSlice, bool) {
	if p.iscsiBonds != nil {
		return p.iscsiBonds, true
	}
	return nil, false
}

func (p *DataCenter) MustIscsiBonds() *IscsiBondSlice {
	if p.iscsiBonds == nil {
		panic("the iscsiBonds must not be nil, please use IscsiBonds() function instead")
	}
	return p.iscsiBonds
}

func (p *DataCenter) SetLocal(attr bool) {
	p.local = &attr
}

func (p *DataCenter) Local() (bool, bool) {
	if p.local != nil {
		return *p.local, true
	}
	var zero bool
	return zero, false
}

func (p *DataCenter) MustLocal() bool {
	if p.local == nil {
		panic("the local must not be nil, please use Local() function instead")
	}
	return *p.local
}

func (p *DataCenter) SetMacPool(attr *MacPool) {
	p.macPool = attr
}

func (p *DataCenter) MacPool() (*MacPool, bool) {
	if p.macPool != nil {
		return p.macPool, true
	}
	return nil, false
}

func (p *DataCenter) MustMacPool() *MacPool {
	if p.macPool == nil {
		panic("the macPool must not be nil, please use MacPool() function instead")
	}
	return p.macPool
}

func (p *DataCenter) SetName(attr string) {
	p.name = &attr
}

func (p *DataCenter) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *DataCenter) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *DataCenter) SetNetworks(attr *NetworkSlice) {
	p.networks = attr
}

func (p *DataCenter) Networks() (*NetworkSlice, bool) {
	if p.networks != nil {
		return p.networks, true
	}
	return nil, false
}

func (p *DataCenter) MustNetworks() *NetworkSlice {
	if p.networks == nil {
		panic("the networks must not be nil, please use Networks() function instead")
	}
	return p.networks
}

func (p *DataCenter) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *DataCenter) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *DataCenter) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *DataCenter) SetQoss(attr *QosSlice) {
	p.qoss = attr
}

func (p *DataCenter) Qoss() (*QosSlice, bool) {
	if p.qoss != nil {
		return p.qoss, true
	}
	return nil, false
}

func (p *DataCenter) MustQoss() *QosSlice {
	if p.qoss == nil {
		panic("the qoss must not be nil, please use Qoss() function instead")
	}
	return p.qoss
}

func (p *DataCenter) SetQuotaMode(attr QuotaModeType) {
	p.quotaMode = &attr
}

func (p *DataCenter) QuotaMode() (QuotaModeType, bool) {
	if p.quotaMode != nil {
		return *p.quotaMode, true
	}
	var zero QuotaModeType
	return zero, false
}

func (p *DataCenter) MustQuotaMode() QuotaModeType {
	if p.quotaMode == nil {
		panic("the quotaMode must not be nil, please use QuotaMode() function instead")
	}
	return *p.quotaMode
}

func (p *DataCenter) SetQuotas(attr *QuotaSlice) {
	p.quotas = attr
}

func (p *DataCenter) Quotas() (*QuotaSlice, bool) {
	if p.quotas != nil {
		return p.quotas, true
	}
	return nil, false
}

func (p *DataCenter) MustQuotas() *QuotaSlice {
	if p.quotas == nil {
		panic("the quotas must not be nil, please use Quotas() function instead")
	}
	return p.quotas
}

func (p *DataCenter) SetStatus(attr DataCenterStatus) {
	p.status = &attr
}

func (p *DataCenter) Status() (DataCenterStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero DataCenterStatus
	return zero, false
}

func (p *DataCenter) MustStatus() DataCenterStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *DataCenter) SetStorageDomains(attr *StorageDomainSlice) {
	p.storageDomains = attr
}

func (p *DataCenter) StorageDomains() (*StorageDomainSlice, bool) {
	if p.storageDomains != nil {
		return p.storageDomains, true
	}
	return nil, false
}

func (p *DataCenter) MustStorageDomains() *StorageDomainSlice {
	if p.storageDomains == nil {
		panic("the storageDomains must not be nil, please use StorageDomains() function instead")
	}
	return p.storageDomains
}

func (p *DataCenter) SetStorageFormat(attr StorageFormat) {
	p.storageFormat = &attr
}

func (p *DataCenter) StorageFormat() (StorageFormat, bool) {
	if p.storageFormat != nil {
		return *p.storageFormat, true
	}
	var zero StorageFormat
	return zero, false
}

func (p *DataCenter) MustStorageFormat() StorageFormat {
	if p.storageFormat == nil {
		panic("the storageFormat must not be nil, please use StorageFormat() function instead")
	}
	return *p.storageFormat
}

func (p *DataCenter) SetSupportedVersions(attr *VersionSlice) {
	p.supportedVersions = attr
}

func (p *DataCenter) SupportedVersions() (*VersionSlice, bool) {
	if p.supportedVersions != nil {
		return p.supportedVersions, true
	}
	return nil, false
}

func (p *DataCenter) MustSupportedVersions() *VersionSlice {
	if p.supportedVersions == nil {
		panic("the supportedVersions must not be nil, please use SupportedVersions() function instead")
	}
	return p.supportedVersions
}

func (p *DataCenter) SetVersion(attr *Version) {
	p.version = attr
}

func (p *DataCenter) Version() (*Version, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *DataCenter) MustVersion() *Version {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

type RegistrationRoleMapping struct {
	Struct
	from *Role
	to   *Role
}

func (p *RegistrationRoleMapping) SetFrom(attr *Role) {
	p.from = attr
}

func (p *RegistrationRoleMapping) From() (*Role, bool) {
	if p.from != nil {
		return p.from, true
	}
	return nil, false
}

func (p *RegistrationRoleMapping) MustFrom() *Role {
	if p.from == nil {
		panic("the from must not be nil, please use From() function instead")
	}
	return p.from
}

func (p *RegistrationRoleMapping) SetTo(attr *Role) {
	p.to = attr
}

func (p *RegistrationRoleMapping) To() (*Role, bool) {
	if p.to != nil {
		return p.to, true
	}
	return nil, false
}

func (p *RegistrationRoleMapping) MustTo() *Role {
	if p.to == nil {
		panic("the to must not be nil, please use To() function instead")
	}
	return p.to
}

type FopStatistic struct {
	Struct
	name       *string
	statistics *StatisticSlice
}

func (p *FopStatistic) SetName(attr string) {
	p.name = &attr
}

func (p *FopStatistic) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *FopStatistic) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *FopStatistic) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *FopStatistic) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *FopStatistic) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

type Identified struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
}

func (p *Identified) SetComment(attr string) {
	p.comment = &attr
}

func (p *Identified) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Identified) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Identified) SetDescription(attr string) {
	p.description = &attr
}

func (p *Identified) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Identified) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Identified) SetId(attr string) {
	p.id = &attr
}

func (p *Identified) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Identified) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Identified) SetName(attr string) {
	p.name = &attr
}

func (p *Identified) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Identified) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type EntityProfileDetail struct {
	Struct
	profileDetails *ProfileDetailSlice
}

func (p *EntityProfileDetail) SetProfileDetails(attr *ProfileDetailSlice) {
	p.profileDetails = attr
}

func (p *EntityProfileDetail) ProfileDetails() (*ProfileDetailSlice, bool) {
	if p.profileDetails != nil {
		return p.profileDetails, true
	}
	return nil, false
}

func (p *EntityProfileDetail) MustProfileDetails() *ProfileDetailSlice {
	if p.profileDetails == nil {
		panic("the profileDetails must not be nil, please use ProfileDetails() function instead")
	}
	return p.profileDetails
}

type Weight struct {
	Struct
	comment              *string
	description          *string
	factor               *int64
	id                   *string
	name                 *string
	schedulingPolicy     *SchedulingPolicy
	schedulingPolicyUnit *SchedulingPolicyUnit
}

func (p *Weight) SetComment(attr string) {
	p.comment = &attr
}

func (p *Weight) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Weight) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Weight) SetDescription(attr string) {
	p.description = &attr
}

func (p *Weight) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Weight) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Weight) SetFactor(attr int64) {
	p.factor = &attr
}

func (p *Weight) Factor() (int64, bool) {
	if p.factor != nil {
		return *p.factor, true
	}
	var zero int64
	return zero, false
}

func (p *Weight) MustFactor() int64 {
	if p.factor == nil {
		panic("the factor must not be nil, please use Factor() function instead")
	}
	return *p.factor
}

func (p *Weight) SetId(attr string) {
	p.id = &attr
}

func (p *Weight) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Weight) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Weight) SetName(attr string) {
	p.name = &attr
}

func (p *Weight) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Weight) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Weight) SetSchedulingPolicy(attr *SchedulingPolicy) {
	p.schedulingPolicy = attr
}

func (p *Weight) SchedulingPolicy() (*SchedulingPolicy, bool) {
	if p.schedulingPolicy != nil {
		return p.schedulingPolicy, true
	}
	return nil, false
}

func (p *Weight) MustSchedulingPolicy() *SchedulingPolicy {
	if p.schedulingPolicy == nil {
		panic("the schedulingPolicy must not be nil, please use SchedulingPolicy() function instead")
	}
	return p.schedulingPolicy
}

func (p *Weight) SetSchedulingPolicyUnit(attr *SchedulingPolicyUnit) {
	p.schedulingPolicyUnit = attr
}

func (p *Weight) SchedulingPolicyUnit() (*SchedulingPolicyUnit, bool) {
	if p.schedulingPolicyUnit != nil {
		return p.schedulingPolicyUnit, true
	}
	return nil, false
}

func (p *Weight) MustSchedulingPolicyUnit() *SchedulingPolicyUnit {
	if p.schedulingPolicyUnit == nil {
		panic("the schedulingPolicyUnit must not be nil, please use SchedulingPolicyUnit() function instead")
	}
	return p.schedulingPolicyUnit
}

type GlusterVolume struct {
	Struct
	bricks          *GlusterBrickSlice
	cluster         *Cluster
	comment         *string
	description     *string
	disperseCount   *int64
	id              *string
	name            *string
	options         *OptionSlice
	redundancyCount *int64
	replicaCount    *int64
	statistics      *StatisticSlice
	status          *GlusterVolumeStatus
	stripeCount     *int64
	transportTypes  []TransportType
	volumeType      *GlusterVolumeType
}

func (p *GlusterVolume) SetBricks(attr *GlusterBrickSlice) {
	p.bricks = attr
}

func (p *GlusterVolume) Bricks() (*GlusterBrickSlice, bool) {
	if p.bricks != nil {
		return p.bricks, true
	}
	return nil, false
}

func (p *GlusterVolume) MustBricks() *GlusterBrickSlice {
	if p.bricks == nil {
		panic("the bricks must not be nil, please use Bricks() function instead")
	}
	return p.bricks
}

func (p *GlusterVolume) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *GlusterVolume) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *GlusterVolume) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *GlusterVolume) SetComment(attr string) {
	p.comment = &attr
}

func (p *GlusterVolume) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *GlusterVolume) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *GlusterVolume) SetDescription(attr string) {
	p.description = &attr
}

func (p *GlusterVolume) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *GlusterVolume) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *GlusterVolume) SetDisperseCount(attr int64) {
	p.disperseCount = &attr
}

func (p *GlusterVolume) DisperseCount() (int64, bool) {
	if p.disperseCount != nil {
		return *p.disperseCount, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterVolume) MustDisperseCount() int64 {
	if p.disperseCount == nil {
		panic("the disperseCount must not be nil, please use DisperseCount() function instead")
	}
	return *p.disperseCount
}

func (p *GlusterVolume) SetId(attr string) {
	p.id = &attr
}

func (p *GlusterVolume) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *GlusterVolume) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *GlusterVolume) SetName(attr string) {
	p.name = &attr
}

func (p *GlusterVolume) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *GlusterVolume) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *GlusterVolume) SetOptions(attr *OptionSlice) {
	p.options = attr
}

func (p *GlusterVolume) Options() (*OptionSlice, bool) {
	if p.options != nil {
		return p.options, true
	}
	return nil, false
}

func (p *GlusterVolume) MustOptions() *OptionSlice {
	if p.options == nil {
		panic("the options must not be nil, please use Options() function instead")
	}
	return p.options
}

func (p *GlusterVolume) SetRedundancyCount(attr int64) {
	p.redundancyCount = &attr
}

func (p *GlusterVolume) RedundancyCount() (int64, bool) {
	if p.redundancyCount != nil {
		return *p.redundancyCount, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterVolume) MustRedundancyCount() int64 {
	if p.redundancyCount == nil {
		panic("the redundancyCount must not be nil, please use RedundancyCount() function instead")
	}
	return *p.redundancyCount
}

func (p *GlusterVolume) SetReplicaCount(attr int64) {
	p.replicaCount = &attr
}

func (p *GlusterVolume) ReplicaCount() (int64, bool) {
	if p.replicaCount != nil {
		return *p.replicaCount, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterVolume) MustReplicaCount() int64 {
	if p.replicaCount == nil {
		panic("the replicaCount must not be nil, please use ReplicaCount() function instead")
	}
	return *p.replicaCount
}

func (p *GlusterVolume) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *GlusterVolume) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *GlusterVolume) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *GlusterVolume) SetStatus(attr GlusterVolumeStatus) {
	p.status = &attr
}

func (p *GlusterVolume) Status() (GlusterVolumeStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero GlusterVolumeStatus
	return zero, false
}

func (p *GlusterVolume) MustStatus() GlusterVolumeStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *GlusterVolume) SetStripeCount(attr int64) {
	p.stripeCount = &attr
}

func (p *GlusterVolume) StripeCount() (int64, bool) {
	if p.stripeCount != nil {
		return *p.stripeCount, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterVolume) MustStripeCount() int64 {
	if p.stripeCount == nil {
		panic("the stripeCount must not be nil, please use StripeCount() function instead")
	}
	return *p.stripeCount
}

func (p *GlusterVolume) SetTransportTypes(attr []TransportType) {
	p.transportTypes = attr
}

func (p *GlusterVolume) TransportTypes() ([]TransportType, bool) {
	if p.transportTypes != nil {
		return p.transportTypes, true
	}
	return nil, false
}

func (p *GlusterVolume) MustTransportTypes() []TransportType {
	if p.transportTypes == nil {
		panic("the transportTypes must not be nil, please use TransportTypes() function instead")
	}
	return p.transportTypes
}

func (p *GlusterVolume) SetVolumeType(attr GlusterVolumeType) {
	p.volumeType = &attr
}

func (p *GlusterVolume) VolumeType() (GlusterVolumeType, bool) {
	if p.volumeType != nil {
		return *p.volumeType, true
	}
	var zero GlusterVolumeType
	return zero, false
}

func (p *GlusterVolume) MustVolumeType() GlusterVolumeType {
	if p.volumeType == nil {
		panic("the volumeType must not be nil, please use VolumeType() function instead")
	}
	return *p.volumeType
}

type StorageConnection struct {
	Struct
	address       *string
	comment       *string
	description   *string
	glusterVolume *GlusterVolume
	host          *Host
	id            *string
	mountOptions  *string
	name          *string
	nfsRetrans    *int64
	nfsTimeo      *int64
	nfsVersion    *NfsVersion
	password      *string
	path          *string
	port          *int64
	portal        *string
	target        *string
	type_         *StorageType
	username      *string
	vfsType       *string
}

func (p *StorageConnection) SetAddress(attr string) {
	p.address = &attr
}

func (p *StorageConnection) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *StorageConnection) SetComment(attr string) {
	p.comment = &attr
}

func (p *StorageConnection) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *StorageConnection) SetDescription(attr string) {
	p.description = &attr
}

func (p *StorageConnection) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *StorageConnection) SetGlusterVolume(attr *GlusterVolume) {
	p.glusterVolume = attr
}

func (p *StorageConnection) GlusterVolume() (*GlusterVolume, bool) {
	if p.glusterVolume != nil {
		return p.glusterVolume, true
	}
	return nil, false
}

func (p *StorageConnection) MustGlusterVolume() *GlusterVolume {
	if p.glusterVolume == nil {
		panic("the glusterVolume must not be nil, please use GlusterVolume() function instead")
	}
	return p.glusterVolume
}

func (p *StorageConnection) SetHost(attr *Host) {
	p.host = attr
}

func (p *StorageConnection) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *StorageConnection) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *StorageConnection) SetId(attr string) {
	p.id = &attr
}

func (p *StorageConnection) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *StorageConnection) SetMountOptions(attr string) {
	p.mountOptions = &attr
}

func (p *StorageConnection) MountOptions() (string, bool) {
	if p.mountOptions != nil {
		return *p.mountOptions, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustMountOptions() string {
	if p.mountOptions == nil {
		panic("the mountOptions must not be nil, please use MountOptions() function instead")
	}
	return *p.mountOptions
}

func (p *StorageConnection) SetName(attr string) {
	p.name = &attr
}

func (p *StorageConnection) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *StorageConnection) SetNfsRetrans(attr int64) {
	p.nfsRetrans = &attr
}

func (p *StorageConnection) NfsRetrans() (int64, bool) {
	if p.nfsRetrans != nil {
		return *p.nfsRetrans, true
	}
	var zero int64
	return zero, false
}

func (p *StorageConnection) MustNfsRetrans() int64 {
	if p.nfsRetrans == nil {
		panic("the nfsRetrans must not be nil, please use NfsRetrans() function instead")
	}
	return *p.nfsRetrans
}

func (p *StorageConnection) SetNfsTimeo(attr int64) {
	p.nfsTimeo = &attr
}

func (p *StorageConnection) NfsTimeo() (int64, bool) {
	if p.nfsTimeo != nil {
		return *p.nfsTimeo, true
	}
	var zero int64
	return zero, false
}

func (p *StorageConnection) MustNfsTimeo() int64 {
	if p.nfsTimeo == nil {
		panic("the nfsTimeo must not be nil, please use NfsTimeo() function instead")
	}
	return *p.nfsTimeo
}

func (p *StorageConnection) SetNfsVersion(attr NfsVersion) {
	p.nfsVersion = &attr
}

func (p *StorageConnection) NfsVersion() (NfsVersion, bool) {
	if p.nfsVersion != nil {
		return *p.nfsVersion, true
	}
	var zero NfsVersion
	return zero, false
}

func (p *StorageConnection) MustNfsVersion() NfsVersion {
	if p.nfsVersion == nil {
		panic("the nfsVersion must not be nil, please use NfsVersion() function instead")
	}
	return *p.nfsVersion
}

func (p *StorageConnection) SetPassword(attr string) {
	p.password = &attr
}

func (p *StorageConnection) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *StorageConnection) SetPath(attr string) {
	p.path = &attr
}

func (p *StorageConnection) Path() (string, bool) {
	if p.path != nil {
		return *p.path, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustPath() string {
	if p.path == nil {
		panic("the path must not be nil, please use Path() function instead")
	}
	return *p.path
}

func (p *StorageConnection) SetPort(attr int64) {
	p.port = &attr
}

func (p *StorageConnection) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *StorageConnection) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *StorageConnection) SetPortal(attr string) {
	p.portal = &attr
}

func (p *StorageConnection) Portal() (string, bool) {
	if p.portal != nil {
		return *p.portal, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustPortal() string {
	if p.portal == nil {
		panic("the portal must not be nil, please use Portal() function instead")
	}
	return *p.portal
}

func (p *StorageConnection) SetTarget(attr string) {
	p.target = &attr
}

func (p *StorageConnection) Target() (string, bool) {
	if p.target != nil {
		return *p.target, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustTarget() string {
	if p.target == nil {
		panic("the target must not be nil, please use Target() function instead")
	}
	return *p.target
}

func (p *StorageConnection) SetType(attr StorageType) {
	p.type_ = &attr
}

func (p *StorageConnection) Type() (StorageType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero StorageType
	return zero, false
}

func (p *StorageConnection) MustType() StorageType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *StorageConnection) SetUsername(attr string) {
	p.username = &attr
}

func (p *StorageConnection) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

func (p *StorageConnection) SetVfsType(attr string) {
	p.vfsType = &attr
}

func (p *StorageConnection) VfsType() (string, bool) {
	if p.vfsType != nil {
		return *p.vfsType, true
	}
	var zero string
	return zero, false
}

func (p *StorageConnection) MustVfsType() string {
	if p.vfsType == nil {
		panic("the vfsType must not be nil, please use VfsType() function instead")
	}
	return *p.vfsType
}

type NetworkFilterParameter struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
	nic         *Nic
	value       *string
}

func (p *NetworkFilterParameter) SetComment(attr string) {
	p.comment = &attr
}

func (p *NetworkFilterParameter) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *NetworkFilterParameter) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *NetworkFilterParameter) SetDescription(attr string) {
	p.description = &attr
}

func (p *NetworkFilterParameter) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *NetworkFilterParameter) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *NetworkFilterParameter) SetId(attr string) {
	p.id = &attr
}

func (p *NetworkFilterParameter) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *NetworkFilterParameter) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *NetworkFilterParameter) SetName(attr string) {
	p.name = &attr
}

func (p *NetworkFilterParameter) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *NetworkFilterParameter) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *NetworkFilterParameter) SetNic(attr *Nic) {
	p.nic = attr
}

func (p *NetworkFilterParameter) Nic() (*Nic, bool) {
	if p.nic != nil {
		return p.nic, true
	}
	return nil, false
}

func (p *NetworkFilterParameter) MustNic() *Nic {
	if p.nic == nil {
		panic("the nic must not be nil, please use Nic() function instead")
	}
	return p.nic
}

func (p *NetworkFilterParameter) SetValue(attr string) {
	p.value = &attr
}

func (p *NetworkFilterParameter) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *NetworkFilterParameter) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

type OpenStackSubnet struct {
	Struct
	cidr             *string
	comment          *string
	description      *string
	dnsServers       []string
	gateway          *string
	id               *string
	ipVersion        *string
	name             *string
	openstackNetwork *OpenStackNetwork
}

func (p *OpenStackSubnet) SetCidr(attr string) {
	p.cidr = &attr
}

func (p *OpenStackSubnet) Cidr() (string, bool) {
	if p.cidr != nil {
		return *p.cidr, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackSubnet) MustCidr() string {
	if p.cidr == nil {
		panic("the cidr must not be nil, please use Cidr() function instead")
	}
	return *p.cidr
}

func (p *OpenStackSubnet) SetComment(attr string) {
	p.comment = &attr
}

func (p *OpenStackSubnet) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackSubnet) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OpenStackSubnet) SetDescription(attr string) {
	p.description = &attr
}

func (p *OpenStackSubnet) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackSubnet) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OpenStackSubnet) SetDnsServers(attr []string) {
	p.dnsServers = attr
}

func (p *OpenStackSubnet) DnsServers() ([]string, bool) {
	if p.dnsServers != nil {
		return p.dnsServers, true
	}
	return nil, false
}

func (p *OpenStackSubnet) MustDnsServers() []string {
	if p.dnsServers == nil {
		panic("the dnsServers must not be nil, please use DnsServers() function instead")
	}
	return p.dnsServers
}

func (p *OpenStackSubnet) SetGateway(attr string) {
	p.gateway = &attr
}

func (p *OpenStackSubnet) Gateway() (string, bool) {
	if p.gateway != nil {
		return *p.gateway, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackSubnet) MustGateway() string {
	if p.gateway == nil {
		panic("the gateway must not be nil, please use Gateway() function instead")
	}
	return *p.gateway
}

func (p *OpenStackSubnet) SetId(attr string) {
	p.id = &attr
}

func (p *OpenStackSubnet) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackSubnet) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OpenStackSubnet) SetIpVersion(attr string) {
	p.ipVersion = &attr
}

func (p *OpenStackSubnet) IpVersion() (string, bool) {
	if p.ipVersion != nil {
		return *p.ipVersion, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackSubnet) MustIpVersion() string {
	if p.ipVersion == nil {
		panic("the ipVersion must not be nil, please use IpVersion() function instead")
	}
	return *p.ipVersion
}

func (p *OpenStackSubnet) SetName(attr string) {
	p.name = &attr
}

func (p *OpenStackSubnet) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackSubnet) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OpenStackSubnet) SetOpenstackNetwork(attr *OpenStackNetwork) {
	p.openstackNetwork = attr
}

func (p *OpenStackSubnet) OpenstackNetwork() (*OpenStackNetwork, bool) {
	if p.openstackNetwork != nil {
		return p.openstackNetwork, true
	}
	return nil, false
}

func (p *OpenStackSubnet) MustOpenstackNetwork() *OpenStackNetwork {
	if p.openstackNetwork == nil {
		panic("the openstackNetwork must not be nil, please use OpenstackNetwork() function instead")
	}
	return p.openstackNetwork
}

type Tag struct {
	Struct
	comment     *string
	description *string
	group       *Group
	host        *Host
	id          *string
	name        *string
	parent      *Tag
	template    *Template
	user        *User
	vm          *Vm
}

func (p *Tag) SetComment(attr string) {
	p.comment = &attr
}

func (p *Tag) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Tag) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Tag) SetDescription(attr string) {
	p.description = &attr
}

func (p *Tag) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Tag) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Tag) SetGroup(attr *Group) {
	p.group = attr
}

func (p *Tag) Group() (*Group, bool) {
	if p.group != nil {
		return p.group, true
	}
	return nil, false
}

func (p *Tag) MustGroup() *Group {
	if p.group == nil {
		panic("the group must not be nil, please use Group() function instead")
	}
	return p.group
}

func (p *Tag) SetHost(attr *Host) {
	p.host = attr
}

func (p *Tag) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *Tag) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *Tag) SetId(attr string) {
	p.id = &attr
}

func (p *Tag) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Tag) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Tag) SetName(attr string) {
	p.name = &attr
}

func (p *Tag) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Tag) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Tag) SetParent(attr *Tag) {
	p.parent = attr
}

func (p *Tag) Parent() (*Tag, bool) {
	if p.parent != nil {
		return p.parent, true
	}
	return nil, false
}

func (p *Tag) MustParent() *Tag {
	if p.parent == nil {
		panic("the parent must not be nil, please use Parent() function instead")
	}
	return p.parent
}

func (p *Tag) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Tag) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Tag) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Tag) SetUser(attr *User) {
	p.user = attr
}

func (p *Tag) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *Tag) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

func (p *Tag) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Tag) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Tag) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type AuthorizedKey struct {
	Struct
	comment     *string
	description *string
	id          *string
	key         *string
	name        *string
	user        *User
}

func (p *AuthorizedKey) SetComment(attr string) {
	p.comment = &attr
}

func (p *AuthorizedKey) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *AuthorizedKey) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *AuthorizedKey) SetDescription(attr string) {
	p.description = &attr
}

func (p *AuthorizedKey) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *AuthorizedKey) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *AuthorizedKey) SetId(attr string) {
	p.id = &attr
}

func (p *AuthorizedKey) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *AuthorizedKey) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *AuthorizedKey) SetKey(attr string) {
	p.key = &attr
}

func (p *AuthorizedKey) Key() (string, bool) {
	if p.key != nil {
		return *p.key, true
	}
	var zero string
	return zero, false
}

func (p *AuthorizedKey) MustKey() string {
	if p.key == nil {
		panic("the key must not be nil, please use Key() function instead")
	}
	return *p.key
}

func (p *AuthorizedKey) SetName(attr string) {
	p.name = &attr
}

func (p *AuthorizedKey) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *AuthorizedKey) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *AuthorizedKey) SetUser(attr *User) {
	p.user = attr
}

func (p *AuthorizedKey) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *AuthorizedKey) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

type VnicProfile struct {
	Struct
	comment          *string
	customProperties *CustomPropertySlice
	description      *string
	id               *string
	migratable       *bool
	name             *string
	network          *Network
	networkFilter    *NetworkFilter
	passThrough      *VnicPassThrough
	permissions      *PermissionSlice
	portMirroring    *bool
	qos              *Qos
}

func (p *VnicProfile) SetComment(attr string) {
	p.comment = &attr
}

func (p *VnicProfile) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *VnicProfile) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *VnicProfile) SetCustomProperties(attr *CustomPropertySlice) {
	p.customProperties = attr
}

func (p *VnicProfile) CustomProperties() (*CustomPropertySlice, bool) {
	if p.customProperties != nil {
		return p.customProperties, true
	}
	return nil, false
}

func (p *VnicProfile) MustCustomProperties() *CustomPropertySlice {
	if p.customProperties == nil {
		panic("the customProperties must not be nil, please use CustomProperties() function instead")
	}
	return p.customProperties
}

func (p *VnicProfile) SetDescription(attr string) {
	p.description = &attr
}

func (p *VnicProfile) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *VnicProfile) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *VnicProfile) SetId(attr string) {
	p.id = &attr
}

func (p *VnicProfile) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *VnicProfile) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *VnicProfile) SetMigratable(attr bool) {
	p.migratable = &attr
}

func (p *VnicProfile) Migratable() (bool, bool) {
	if p.migratable != nil {
		return *p.migratable, true
	}
	var zero bool
	return zero, false
}

func (p *VnicProfile) MustMigratable() bool {
	if p.migratable == nil {
		panic("the migratable must not be nil, please use Migratable() function instead")
	}
	return *p.migratable
}

func (p *VnicProfile) SetName(attr string) {
	p.name = &attr
}

func (p *VnicProfile) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *VnicProfile) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *VnicProfile) SetNetwork(attr *Network) {
	p.network = attr
}

func (p *VnicProfile) Network() (*Network, bool) {
	if p.network != nil {
		return p.network, true
	}
	return nil, false
}

func (p *VnicProfile) MustNetwork() *Network {
	if p.network == nil {
		panic("the network must not be nil, please use Network() function instead")
	}
	return p.network
}

func (p *VnicProfile) SetNetworkFilter(attr *NetworkFilter) {
	p.networkFilter = attr
}

func (p *VnicProfile) NetworkFilter() (*NetworkFilter, bool) {
	if p.networkFilter != nil {
		return p.networkFilter, true
	}
	return nil, false
}

func (p *VnicProfile) MustNetworkFilter() *NetworkFilter {
	if p.networkFilter == nil {
		panic("the networkFilter must not be nil, please use NetworkFilter() function instead")
	}
	return p.networkFilter
}

func (p *VnicProfile) SetPassThrough(attr *VnicPassThrough) {
	p.passThrough = attr
}

func (p *VnicProfile) PassThrough() (*VnicPassThrough, bool) {
	if p.passThrough != nil {
		return p.passThrough, true
	}
	return nil, false
}

func (p *VnicProfile) MustPassThrough() *VnicPassThrough {
	if p.passThrough == nil {
		panic("the passThrough must not be nil, please use PassThrough() function instead")
	}
	return p.passThrough
}

func (p *VnicProfile) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *VnicProfile) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *VnicProfile) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *VnicProfile) SetPortMirroring(attr bool) {
	p.portMirroring = &attr
}

func (p *VnicProfile) PortMirroring() (bool, bool) {
	if p.portMirroring != nil {
		return *p.portMirroring, true
	}
	var zero bool
	return zero, false
}

func (p *VnicProfile) MustPortMirroring() bool {
	if p.portMirroring == nil {
		panic("the portMirroring must not be nil, please use PortMirroring() function instead")
	}
	return *p.portMirroring
}

func (p *VnicProfile) SetQos(attr *Qos) {
	p.qos = attr
}

func (p *VnicProfile) Qos() (*Qos, bool) {
	if p.qos != nil {
		return p.qos, true
	}
	return nil, false
}

func (p *VnicProfile) MustQos() *Qos {
	if p.qos == nil {
		panic("the qos must not be nil, please use Qos() function instead")
	}
	return p.qos
}

type GraphicsConsole struct {
	Struct
	address      *string
	comment      *string
	description  *string
	id           *string
	instanceType *InstanceType
	name         *string
	port         *int64
	protocol     *GraphicsType
	template     *Template
	tlsPort      *int64
	vm           *Vm
}

func (p *GraphicsConsole) SetAddress(attr string) {
	p.address = &attr
}

func (p *GraphicsConsole) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *GraphicsConsole) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *GraphicsConsole) SetComment(attr string) {
	p.comment = &attr
}

func (p *GraphicsConsole) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *GraphicsConsole) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *GraphicsConsole) SetDescription(attr string) {
	p.description = &attr
}

func (p *GraphicsConsole) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *GraphicsConsole) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *GraphicsConsole) SetId(attr string) {
	p.id = &attr
}

func (p *GraphicsConsole) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *GraphicsConsole) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *GraphicsConsole) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *GraphicsConsole) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *GraphicsConsole) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *GraphicsConsole) SetName(attr string) {
	p.name = &attr
}

func (p *GraphicsConsole) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *GraphicsConsole) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *GraphicsConsole) SetPort(attr int64) {
	p.port = &attr
}

func (p *GraphicsConsole) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *GraphicsConsole) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *GraphicsConsole) SetProtocol(attr GraphicsType) {
	p.protocol = &attr
}

func (p *GraphicsConsole) Protocol() (GraphicsType, bool) {
	if p.protocol != nil {
		return *p.protocol, true
	}
	var zero GraphicsType
	return zero, false
}

func (p *GraphicsConsole) MustProtocol() GraphicsType {
	if p.protocol == nil {
		panic("the protocol must not be nil, please use Protocol() function instead")
	}
	return *p.protocol
}

func (p *GraphicsConsole) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *GraphicsConsole) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *GraphicsConsole) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *GraphicsConsole) SetTlsPort(attr int64) {
	p.tlsPort = &attr
}

func (p *GraphicsConsole) TlsPort() (int64, bool) {
	if p.tlsPort != nil {
		return *p.tlsPort, true
	}
	var zero int64
	return zero, false
}

func (p *GraphicsConsole) MustTlsPort() int64 {
	if p.tlsPort == nil {
		panic("the tlsPort must not be nil, please use TlsPort() function instead")
	}
	return *p.tlsPort
}

func (p *GraphicsConsole) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *GraphicsConsole) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *GraphicsConsole) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type Icon struct {
	Struct
	comment     *string
	data        *string
	description *string
	id          *string
	mediaType   *string
	name        *string
}

func (p *Icon) SetComment(attr string) {
	p.comment = &attr
}

func (p *Icon) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Icon) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Icon) SetData(attr string) {
	p.data = &attr
}

func (p *Icon) Data() (string, bool) {
	if p.data != nil {
		return *p.data, true
	}
	var zero string
	return zero, false
}

func (p *Icon) MustData() string {
	if p.data == nil {
		panic("the data must not be nil, please use Data() function instead")
	}
	return *p.data
}

func (p *Icon) SetDescription(attr string) {
	p.description = &attr
}

func (p *Icon) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Icon) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Icon) SetId(attr string) {
	p.id = &attr
}

func (p *Icon) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Icon) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Icon) SetMediaType(attr string) {
	p.mediaType = &attr
}

func (p *Icon) MediaType() (string, bool) {
	if p.mediaType != nil {
		return *p.mediaType, true
	}
	var zero string
	return zero, false
}

func (p *Icon) MustMediaType() string {
	if p.mediaType == nil {
		panic("the mediaType must not be nil, please use MediaType() function instead")
	}
	return *p.mediaType
}

func (p *Icon) SetName(attr string) {
	p.name = &attr
}

func (p *Icon) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Icon) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type DiskProfile struct {
	Struct
	comment       *string
	description   *string
	id            *string
	name          *string
	permissions   *PermissionSlice
	qos           *Qos
	storageDomain *StorageDomain
}

func (p *DiskProfile) SetComment(attr string) {
	p.comment = &attr
}

func (p *DiskProfile) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *DiskProfile) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *DiskProfile) SetDescription(attr string) {
	p.description = &attr
}

func (p *DiskProfile) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *DiskProfile) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *DiskProfile) SetId(attr string) {
	p.id = &attr
}

func (p *DiskProfile) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *DiskProfile) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *DiskProfile) SetName(attr string) {
	p.name = &attr
}

func (p *DiskProfile) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *DiskProfile) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *DiskProfile) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *DiskProfile) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *DiskProfile) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *DiskProfile) SetQos(attr *Qos) {
	p.qos = attr
}

func (p *DiskProfile) Qos() (*Qos, bool) {
	if p.qos != nil {
		return p.qos, true
	}
	return nil, false
}

func (p *DiskProfile) MustQos() *Qos {
	if p.qos == nil {
		panic("the qos must not be nil, please use Qos() function instead")
	}
	return p.qos
}

func (p *DiskProfile) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *DiskProfile) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *DiskProfile) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

type Image struct {
	Struct
	comment       *string
	description   *string
	id            *string
	name          *string
	size          *int64
	storageDomain *StorageDomain
	type_         *ImageFileType
}

func (p *Image) SetComment(attr string) {
	p.comment = &attr
}

func (p *Image) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Image) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Image) SetDescription(attr string) {
	p.description = &attr
}

func (p *Image) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Image) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Image) SetId(attr string) {
	p.id = &attr
}

func (p *Image) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Image) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Image) SetName(attr string) {
	p.name = &attr
}

func (p *Image) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Image) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Image) SetSize(attr int64) {
	p.size = &attr
}

func (p *Image) Size() (int64, bool) {
	if p.size != nil {
		return *p.size, true
	}
	var zero int64
	return zero, false
}

func (p *Image) MustSize() int64 {
	if p.size == nil {
		panic("the size must not be nil, please use Size() function instead")
	}
	return *p.size
}

func (p *Image) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *Image) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *Image) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *Image) SetType(attr ImageFileType) {
	p.type_ = &attr
}

func (p *Image) Type() (ImageFileType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero ImageFileType
	return zero, false
}

func (p *Image) MustType() ImageFileType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type EventSubscription struct {
	Struct
	address            *string
	comment            *string
	description        *string
	event              *NotifiableEvent
	id                 *string
	name               *string
	notificationMethod *NotificationMethod
	user               *User
}

func (p *EventSubscription) SetAddress(attr string) {
	p.address = &attr
}

func (p *EventSubscription) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *EventSubscription) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *EventSubscription) SetComment(attr string) {
	p.comment = &attr
}

func (p *EventSubscription) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *EventSubscription) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *EventSubscription) SetDescription(attr string) {
	p.description = &attr
}

func (p *EventSubscription) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *EventSubscription) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *EventSubscription) SetEvent(attr NotifiableEvent) {
	p.event = &attr
}

func (p *EventSubscription) Event() (NotifiableEvent, bool) {
	if p.event != nil {
		return *p.event, true
	}
	var zero NotifiableEvent
	return zero, false
}

func (p *EventSubscription) MustEvent() NotifiableEvent {
	if p.event == nil {
		panic("the event must not be nil, please use Event() function instead")
	}
	return *p.event
}

func (p *EventSubscription) SetId(attr string) {
	p.id = &attr
}

func (p *EventSubscription) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *EventSubscription) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *EventSubscription) SetName(attr string) {
	p.name = &attr
}

func (p *EventSubscription) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *EventSubscription) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *EventSubscription) SetNotificationMethod(attr NotificationMethod) {
	p.notificationMethod = &attr
}

func (p *EventSubscription) NotificationMethod() (NotificationMethod, bool) {
	if p.notificationMethod != nil {
		return *p.notificationMethod, true
	}
	var zero NotificationMethod
	return zero, false
}

func (p *EventSubscription) MustNotificationMethod() NotificationMethod {
	if p.notificationMethod == nil {
		panic("the notificationMethod must not be nil, please use NotificationMethod() function instead")
	}
	return *p.notificationMethod
}

func (p *EventSubscription) SetUser(attr *User) {
	p.user = attr
}

func (p *EventSubscription) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *EventSubscription) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

type QuotaStorageLimit struct {
	Struct
	comment       *string
	description   *string
	id            *string
	limit         *int64
	name          *string
	quota         *Quota
	storageDomain *StorageDomain
	usage         *float64
}

func (p *QuotaStorageLimit) SetComment(attr string) {
	p.comment = &attr
}

func (p *QuotaStorageLimit) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *QuotaStorageLimit) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *QuotaStorageLimit) SetDescription(attr string) {
	p.description = &attr
}

func (p *QuotaStorageLimit) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *QuotaStorageLimit) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *QuotaStorageLimit) SetId(attr string) {
	p.id = &attr
}

func (p *QuotaStorageLimit) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *QuotaStorageLimit) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *QuotaStorageLimit) SetLimit(attr int64) {
	p.limit = &attr
}

func (p *QuotaStorageLimit) Limit() (int64, bool) {
	if p.limit != nil {
		return *p.limit, true
	}
	var zero int64
	return zero, false
}

func (p *QuotaStorageLimit) MustLimit() int64 {
	if p.limit == nil {
		panic("the limit must not be nil, please use Limit() function instead")
	}
	return *p.limit
}

func (p *QuotaStorageLimit) SetName(attr string) {
	p.name = &attr
}

func (p *QuotaStorageLimit) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *QuotaStorageLimit) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *QuotaStorageLimit) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *QuotaStorageLimit) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *QuotaStorageLimit) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *QuotaStorageLimit) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *QuotaStorageLimit) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *QuotaStorageLimit) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *QuotaStorageLimit) SetUsage(attr float64) {
	p.usage = &attr
}

func (p *QuotaStorageLimit) Usage() (float64, bool) {
	if p.usage != nil {
		return *p.usage, true
	}
	var zero float64
	return zero, false
}

func (p *QuotaStorageLimit) MustUsage() float64 {
	if p.usage == nil {
		panic("the usage must not be nil, please use Usage() function instead")
	}
	return *p.usage
}

type OperatingSystem struct {
	Struct
	boot                  *Boot
	cmdline               *string
	customKernelCmdline   *string
	initrd                *string
	kernel                *string
	reportedKernelCmdline *string
	type_                 *string
	version               *Version
}

func (p *OperatingSystem) SetBoot(attr *Boot) {
	p.boot = attr
}

func (p *OperatingSystem) Boot() (*Boot, bool) {
	if p.boot != nil {
		return p.boot, true
	}
	return nil, false
}

func (p *OperatingSystem) MustBoot() *Boot {
	if p.boot == nil {
		panic("the boot must not be nil, please use Boot() function instead")
	}
	return p.boot
}

func (p *OperatingSystem) SetCmdline(attr string) {
	p.cmdline = &attr
}

func (p *OperatingSystem) Cmdline() (string, bool) {
	if p.cmdline != nil {
		return *p.cmdline, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystem) MustCmdline() string {
	if p.cmdline == nil {
		panic("the cmdline must not be nil, please use Cmdline() function instead")
	}
	return *p.cmdline
}

func (p *OperatingSystem) SetCustomKernelCmdline(attr string) {
	p.customKernelCmdline = &attr
}

func (p *OperatingSystem) CustomKernelCmdline() (string, bool) {
	if p.customKernelCmdline != nil {
		return *p.customKernelCmdline, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystem) MustCustomKernelCmdline() string {
	if p.customKernelCmdline == nil {
		panic("the customKernelCmdline must not be nil, please use CustomKernelCmdline() function instead")
	}
	return *p.customKernelCmdline
}

func (p *OperatingSystem) SetInitrd(attr string) {
	p.initrd = &attr
}

func (p *OperatingSystem) Initrd() (string, bool) {
	if p.initrd != nil {
		return *p.initrd, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystem) MustInitrd() string {
	if p.initrd == nil {
		panic("the initrd must not be nil, please use Initrd() function instead")
	}
	return *p.initrd
}

func (p *OperatingSystem) SetKernel(attr string) {
	p.kernel = &attr
}

func (p *OperatingSystem) Kernel() (string, bool) {
	if p.kernel != nil {
		return *p.kernel, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystem) MustKernel() string {
	if p.kernel == nil {
		panic("the kernel must not be nil, please use Kernel() function instead")
	}
	return *p.kernel
}

func (p *OperatingSystem) SetReportedKernelCmdline(attr string) {
	p.reportedKernelCmdline = &attr
}

func (p *OperatingSystem) ReportedKernelCmdline() (string, bool) {
	if p.reportedKernelCmdline != nil {
		return *p.reportedKernelCmdline, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystem) MustReportedKernelCmdline() string {
	if p.reportedKernelCmdline == nil {
		panic("the reportedKernelCmdline must not be nil, please use ReportedKernelCmdline() function instead")
	}
	return *p.reportedKernelCmdline
}

func (p *OperatingSystem) SetType(attr string) {
	p.type_ = &attr
}

func (p *OperatingSystem) Type() (string, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero string
	return zero, false
}

func (p *OperatingSystem) MustType() string {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *OperatingSystem) SetVersion(attr *Version) {
	p.version = attr
}

func (p *OperatingSystem) Version() (*Version, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *OperatingSystem) MustVersion() *Version {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

type VirtioScsi struct {
	Struct
	enabled *bool
}

func (p *VirtioScsi) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *VirtioScsi) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *VirtioScsi) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

type Vendor struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
}

func (p *Vendor) SetComment(attr string) {
	p.comment = &attr
}

func (p *Vendor) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Vendor) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Vendor) SetDescription(attr string) {
	p.description = &attr
}

func (p *Vendor) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Vendor) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Vendor) SetId(attr string) {
	p.id = &attr
}

func (p *Vendor) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Vendor) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Vendor) SetName(attr string) {
	p.name = &attr
}

func (p *Vendor) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Vendor) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type AgentConfiguration struct {
	Struct
	address         *string
	brokerType      *MessageBrokerType
	networkMappings *string
	password        *string
	port            *int64
	username        *string
}

func (p *AgentConfiguration) SetAddress(attr string) {
	p.address = &attr
}

func (p *AgentConfiguration) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *AgentConfiguration) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *AgentConfiguration) SetBrokerType(attr MessageBrokerType) {
	p.brokerType = &attr
}

func (p *AgentConfiguration) BrokerType() (MessageBrokerType, bool) {
	if p.brokerType != nil {
		return *p.brokerType, true
	}
	var zero MessageBrokerType
	return zero, false
}

func (p *AgentConfiguration) MustBrokerType() MessageBrokerType {
	if p.brokerType == nil {
		panic("the brokerType must not be nil, please use BrokerType() function instead")
	}
	return *p.brokerType
}

func (p *AgentConfiguration) SetNetworkMappings(attr string) {
	p.networkMappings = &attr
}

func (p *AgentConfiguration) NetworkMappings() (string, bool) {
	if p.networkMappings != nil {
		return *p.networkMappings, true
	}
	var zero string
	return zero, false
}

func (p *AgentConfiguration) MustNetworkMappings() string {
	if p.networkMappings == nil {
		panic("the networkMappings must not be nil, please use NetworkMappings() function instead")
	}
	return *p.networkMappings
}

func (p *AgentConfiguration) SetPassword(attr string) {
	p.password = &attr
}

func (p *AgentConfiguration) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *AgentConfiguration) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *AgentConfiguration) SetPort(attr int64) {
	p.port = &attr
}

func (p *AgentConfiguration) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *AgentConfiguration) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *AgentConfiguration) SetUsername(attr string) {
	p.username = &attr
}

func (p *AgentConfiguration) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *AgentConfiguration) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

type OpenStackImageProvider struct {
	Struct
	authenticationUrl      *string
	certificates           *CertificateSlice
	comment                *string
	description            *string
	id                     *string
	images                 *OpenStackImageSlice
	name                   *string
	password               *string
	properties             *PropertySlice
	requiresAuthentication *bool
	tenantName             *string
	url                    *string
	username               *string
}

func (p *OpenStackImageProvider) SetAuthenticationUrl(attr string) {
	p.authenticationUrl = &attr
}

func (p *OpenStackImageProvider) AuthenticationUrl() (string, bool) {
	if p.authenticationUrl != nil {
		return *p.authenticationUrl, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImageProvider) MustAuthenticationUrl() string {
	if p.authenticationUrl == nil {
		panic("the authenticationUrl must not be nil, please use AuthenticationUrl() function instead")
	}
	return *p.authenticationUrl
}

func (p *OpenStackImageProvider) SetCertificates(attr *CertificateSlice) {
	p.certificates = attr
}

func (p *OpenStackImageProvider) Certificates() (*CertificateSlice, bool) {
	if p.certificates != nil {
		return p.certificates, true
	}
	return nil, false
}

func (p *OpenStackImageProvider) MustCertificates() *CertificateSlice {
	if p.certificates == nil {
		panic("the certificates must not be nil, please use Certificates() function instead")
	}
	return p.certificates
}

func (p *OpenStackImageProvider) SetComment(attr string) {
	p.comment = &attr
}

func (p *OpenStackImageProvider) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImageProvider) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OpenStackImageProvider) SetDescription(attr string) {
	p.description = &attr
}

func (p *OpenStackImageProvider) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImageProvider) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OpenStackImageProvider) SetId(attr string) {
	p.id = &attr
}

func (p *OpenStackImageProvider) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImageProvider) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OpenStackImageProvider) SetImages(attr *OpenStackImageSlice) {
	p.images = attr
}

func (p *OpenStackImageProvider) Images() (*OpenStackImageSlice, bool) {
	if p.images != nil {
		return p.images, true
	}
	return nil, false
}

func (p *OpenStackImageProvider) MustImages() *OpenStackImageSlice {
	if p.images == nil {
		panic("the images must not be nil, please use Images() function instead")
	}
	return p.images
}

func (p *OpenStackImageProvider) SetName(attr string) {
	p.name = &attr
}

func (p *OpenStackImageProvider) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImageProvider) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OpenStackImageProvider) SetPassword(attr string) {
	p.password = &attr
}

func (p *OpenStackImageProvider) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImageProvider) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *OpenStackImageProvider) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *OpenStackImageProvider) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *OpenStackImageProvider) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *OpenStackImageProvider) SetRequiresAuthentication(attr bool) {
	p.requiresAuthentication = &attr
}

func (p *OpenStackImageProvider) RequiresAuthentication() (bool, bool) {
	if p.requiresAuthentication != nil {
		return *p.requiresAuthentication, true
	}
	var zero bool
	return zero, false
}

func (p *OpenStackImageProvider) MustRequiresAuthentication() bool {
	if p.requiresAuthentication == nil {
		panic("the requiresAuthentication must not be nil, please use RequiresAuthentication() function instead")
	}
	return *p.requiresAuthentication
}

func (p *OpenStackImageProvider) SetTenantName(attr string) {
	p.tenantName = &attr
}

func (p *OpenStackImageProvider) TenantName() (string, bool) {
	if p.tenantName != nil {
		return *p.tenantName, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImageProvider) MustTenantName() string {
	if p.tenantName == nil {
		panic("the tenantName must not be nil, please use TenantName() function instead")
	}
	return *p.tenantName
}

func (p *OpenStackImageProvider) SetUrl(attr string) {
	p.url = &attr
}

func (p *OpenStackImageProvider) Url() (string, bool) {
	if p.url != nil {
		return *p.url, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImageProvider) MustUrl() string {
	if p.url == nil {
		panic("the url must not be nil, please use Url() function instead")
	}
	return *p.url
}

func (p *OpenStackImageProvider) SetUsername(attr string) {
	p.username = &attr
}

func (p *OpenStackImageProvider) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *OpenStackImageProvider) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

type MigrationBandwidth struct {
	Struct
	assignmentMethod *MigrationBandwidthAssignmentMethod
	customValue      *int64
}

func (p *MigrationBandwidth) SetAssignmentMethod(attr MigrationBandwidthAssignmentMethod) {
	p.assignmentMethod = &attr
}

func (p *MigrationBandwidth) AssignmentMethod() (MigrationBandwidthAssignmentMethod, bool) {
	if p.assignmentMethod != nil {
		return *p.assignmentMethod, true
	}
	var zero MigrationBandwidthAssignmentMethod
	return zero, false
}

func (p *MigrationBandwidth) MustAssignmentMethod() MigrationBandwidthAssignmentMethod {
	if p.assignmentMethod == nil {
		panic("the assignmentMethod must not be nil, please use AssignmentMethod() function instead")
	}
	return *p.assignmentMethod
}

func (p *MigrationBandwidth) SetCustomValue(attr int64) {
	p.customValue = &attr
}

func (p *MigrationBandwidth) CustomValue() (int64, bool) {
	if p.customValue != nil {
		return *p.customValue, true
	}
	var zero int64
	return zero, false
}

func (p *MigrationBandwidth) MustCustomValue() int64 {
	if p.customValue == nil {
		panic("the customValue must not be nil, please use CustomValue() function instead")
	}
	return *p.customValue
}

type UnmanagedNetwork struct {
	Struct
	comment     *string
	description *string
	host        *Host
	hostNic     *HostNic
	id          *string
	name        *string
}

func (p *UnmanagedNetwork) SetComment(attr string) {
	p.comment = &attr
}

func (p *UnmanagedNetwork) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *UnmanagedNetwork) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *UnmanagedNetwork) SetDescription(attr string) {
	p.description = &attr
}

func (p *UnmanagedNetwork) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *UnmanagedNetwork) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *UnmanagedNetwork) SetHost(attr *Host) {
	p.host = attr
}

func (p *UnmanagedNetwork) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *UnmanagedNetwork) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *UnmanagedNetwork) SetHostNic(attr *HostNic) {
	p.hostNic = attr
}

func (p *UnmanagedNetwork) HostNic() (*HostNic, bool) {
	if p.hostNic != nil {
		return p.hostNic, true
	}
	return nil, false
}

func (p *UnmanagedNetwork) MustHostNic() *HostNic {
	if p.hostNic == nil {
		panic("the hostNic must not be nil, please use HostNic() function instead")
	}
	return p.hostNic
}

func (p *UnmanagedNetwork) SetId(attr string) {
	p.id = &attr
}

func (p *UnmanagedNetwork) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *UnmanagedNetwork) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *UnmanagedNetwork) SetName(attr string) {
	p.name = &attr
}

func (p *UnmanagedNetwork) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *UnmanagedNetwork) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type HostStorage struct {
	Struct
	address                *string
	comment                *string
	description            *string
	driverOptions          *PropertySlice
	driverSensitiveOptions *PropertySlice
	host                   *Host
	id                     *string
	logicalUnits           *LogicalUnitSlice
	mountOptions           *string
	name                   *string
	nfsRetrans             *int64
	nfsTimeo               *int64
	nfsVersion             *NfsVersion
	overrideLuns           *bool
	password               *string
	path                   *string
	port                   *int64
	portal                 *string
	target                 *string
	type_                  *StorageType
	username               *string
	vfsType                *string
	volumeGroup            *VolumeGroup
}

func (p *HostStorage) SetAddress(attr string) {
	p.address = &attr
}

func (p *HostStorage) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *HostStorage) SetComment(attr string) {
	p.comment = &attr
}

func (p *HostStorage) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *HostStorage) SetDescription(attr string) {
	p.description = &attr
}

func (p *HostStorage) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *HostStorage) SetDriverOptions(attr *PropertySlice) {
	p.driverOptions = attr
}

func (p *HostStorage) DriverOptions() (*PropertySlice, bool) {
	if p.driverOptions != nil {
		return p.driverOptions, true
	}
	return nil, false
}

func (p *HostStorage) MustDriverOptions() *PropertySlice {
	if p.driverOptions == nil {
		panic("the driverOptions must not be nil, please use DriverOptions() function instead")
	}
	return p.driverOptions
}

func (p *HostStorage) SetDriverSensitiveOptions(attr *PropertySlice) {
	p.driverSensitiveOptions = attr
}

func (p *HostStorage) DriverSensitiveOptions() (*PropertySlice, bool) {
	if p.driverSensitiveOptions != nil {
		return p.driverSensitiveOptions, true
	}
	return nil, false
}

func (p *HostStorage) MustDriverSensitiveOptions() *PropertySlice {
	if p.driverSensitiveOptions == nil {
		panic("the driverSensitiveOptions must not be nil, please use DriverSensitiveOptions() function instead")
	}
	return p.driverSensitiveOptions
}

func (p *HostStorage) SetHost(attr *Host) {
	p.host = attr
}

func (p *HostStorage) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *HostStorage) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *HostStorage) SetId(attr string) {
	p.id = &attr
}

func (p *HostStorage) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *HostStorage) SetLogicalUnits(attr *LogicalUnitSlice) {
	p.logicalUnits = attr
}

func (p *HostStorage) LogicalUnits() (*LogicalUnitSlice, bool) {
	if p.logicalUnits != nil {
		return p.logicalUnits, true
	}
	return nil, false
}

func (p *HostStorage) MustLogicalUnits() *LogicalUnitSlice {
	if p.logicalUnits == nil {
		panic("the logicalUnits must not be nil, please use LogicalUnits() function instead")
	}
	return p.logicalUnits
}

func (p *HostStorage) SetMountOptions(attr string) {
	p.mountOptions = &attr
}

func (p *HostStorage) MountOptions() (string, bool) {
	if p.mountOptions != nil {
		return *p.mountOptions, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustMountOptions() string {
	if p.mountOptions == nil {
		panic("the mountOptions must not be nil, please use MountOptions() function instead")
	}
	return *p.mountOptions
}

func (p *HostStorage) SetName(attr string) {
	p.name = &attr
}

func (p *HostStorage) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *HostStorage) SetNfsRetrans(attr int64) {
	p.nfsRetrans = &attr
}

func (p *HostStorage) NfsRetrans() (int64, bool) {
	if p.nfsRetrans != nil {
		return *p.nfsRetrans, true
	}
	var zero int64
	return zero, false
}

func (p *HostStorage) MustNfsRetrans() int64 {
	if p.nfsRetrans == nil {
		panic("the nfsRetrans must not be nil, please use NfsRetrans() function instead")
	}
	return *p.nfsRetrans
}

func (p *HostStorage) SetNfsTimeo(attr int64) {
	p.nfsTimeo = &attr
}

func (p *HostStorage) NfsTimeo() (int64, bool) {
	if p.nfsTimeo != nil {
		return *p.nfsTimeo, true
	}
	var zero int64
	return zero, false
}

func (p *HostStorage) MustNfsTimeo() int64 {
	if p.nfsTimeo == nil {
		panic("the nfsTimeo must not be nil, please use NfsTimeo() function instead")
	}
	return *p.nfsTimeo
}

func (p *HostStorage) SetNfsVersion(attr NfsVersion) {
	p.nfsVersion = &attr
}

func (p *HostStorage) NfsVersion() (NfsVersion, bool) {
	if p.nfsVersion != nil {
		return *p.nfsVersion, true
	}
	var zero NfsVersion
	return zero, false
}

func (p *HostStorage) MustNfsVersion() NfsVersion {
	if p.nfsVersion == nil {
		panic("the nfsVersion must not be nil, please use NfsVersion() function instead")
	}
	return *p.nfsVersion
}

func (p *HostStorage) SetOverrideLuns(attr bool) {
	p.overrideLuns = &attr
}

func (p *HostStorage) OverrideLuns() (bool, bool) {
	if p.overrideLuns != nil {
		return *p.overrideLuns, true
	}
	var zero bool
	return zero, false
}

func (p *HostStorage) MustOverrideLuns() bool {
	if p.overrideLuns == nil {
		panic("the overrideLuns must not be nil, please use OverrideLuns() function instead")
	}
	return *p.overrideLuns
}

func (p *HostStorage) SetPassword(attr string) {
	p.password = &attr
}

func (p *HostStorage) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *HostStorage) SetPath(attr string) {
	p.path = &attr
}

func (p *HostStorage) Path() (string, bool) {
	if p.path != nil {
		return *p.path, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustPath() string {
	if p.path == nil {
		panic("the path must not be nil, please use Path() function instead")
	}
	return *p.path
}

func (p *HostStorage) SetPort(attr int64) {
	p.port = &attr
}

func (p *HostStorage) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *HostStorage) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *HostStorage) SetPortal(attr string) {
	p.portal = &attr
}

func (p *HostStorage) Portal() (string, bool) {
	if p.portal != nil {
		return *p.portal, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustPortal() string {
	if p.portal == nil {
		panic("the portal must not be nil, please use Portal() function instead")
	}
	return *p.portal
}

func (p *HostStorage) SetTarget(attr string) {
	p.target = &attr
}

func (p *HostStorage) Target() (string, bool) {
	if p.target != nil {
		return *p.target, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustTarget() string {
	if p.target == nil {
		panic("the target must not be nil, please use Target() function instead")
	}
	return *p.target
}

func (p *HostStorage) SetType(attr StorageType) {
	p.type_ = &attr
}

func (p *HostStorage) Type() (StorageType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero StorageType
	return zero, false
}

func (p *HostStorage) MustType() StorageType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *HostStorage) SetUsername(attr string) {
	p.username = &attr
}

func (p *HostStorage) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

func (p *HostStorage) SetVfsType(attr string) {
	p.vfsType = &attr
}

func (p *HostStorage) VfsType() (string, bool) {
	if p.vfsType != nil {
		return *p.vfsType, true
	}
	var zero string
	return zero, false
}

func (p *HostStorage) MustVfsType() string {
	if p.vfsType == nil {
		panic("the vfsType must not be nil, please use VfsType() function instead")
	}
	return *p.vfsType
}

func (p *HostStorage) SetVolumeGroup(attr *VolumeGroup) {
	p.volumeGroup = attr
}

func (p *HostStorage) VolumeGroup() (*VolumeGroup, bool) {
	if p.volumeGroup != nil {
		return p.volumeGroup, true
	}
	return nil, false
}

func (p *HostStorage) MustVolumeGroup() *VolumeGroup {
	if p.volumeGroup == nil {
		panic("the volumeGroup must not be nil, please use VolumeGroup() function instead")
	}
	return p.volumeGroup
}

type ErrorHandling struct {
	Struct
	onError *MigrateOnError
}

func (p *ErrorHandling) SetOnError(attr MigrateOnError) {
	p.onError = &attr
}

func (p *ErrorHandling) OnError() (MigrateOnError, bool) {
	if p.onError != nil {
		return *p.onError, true
	}
	var zero MigrateOnError
	return zero, false
}

func (p *ErrorHandling) MustOnError() MigrateOnError {
	if p.onError == nil {
		panic("the onError must not be nil, please use OnError() function instead")
	}
	return *p.onError
}

type GlusterHook struct {
	Struct
	checksum       *string
	cluster        *Cluster
	comment        *string
	conflictStatus *int64
	conflicts      *string
	content        *string
	contentType    *HookContentType
	description    *string
	glusterCommand *string
	id             *string
	name           *string
	serverHooks    *GlusterServerHookSlice
	stage          *HookStage
	status         *GlusterHookStatus
}

func (p *GlusterHook) SetChecksum(attr string) {
	p.checksum = &attr
}

func (p *GlusterHook) Checksum() (string, bool) {
	if p.checksum != nil {
		return *p.checksum, true
	}
	var zero string
	return zero, false
}

func (p *GlusterHook) MustChecksum() string {
	if p.checksum == nil {
		panic("the checksum must not be nil, please use Checksum() function instead")
	}
	return *p.checksum
}

func (p *GlusterHook) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *GlusterHook) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *GlusterHook) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *GlusterHook) SetComment(attr string) {
	p.comment = &attr
}

func (p *GlusterHook) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *GlusterHook) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *GlusterHook) SetConflictStatus(attr int64) {
	p.conflictStatus = &attr
}

func (p *GlusterHook) ConflictStatus() (int64, bool) {
	if p.conflictStatus != nil {
		return *p.conflictStatus, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterHook) MustConflictStatus() int64 {
	if p.conflictStatus == nil {
		panic("the conflictStatus must not be nil, please use ConflictStatus() function instead")
	}
	return *p.conflictStatus
}

func (p *GlusterHook) SetConflicts(attr string) {
	p.conflicts = &attr
}

func (p *GlusterHook) Conflicts() (string, bool) {
	if p.conflicts != nil {
		return *p.conflicts, true
	}
	var zero string
	return zero, false
}

func (p *GlusterHook) MustConflicts() string {
	if p.conflicts == nil {
		panic("the conflicts must not be nil, please use Conflicts() function instead")
	}
	return *p.conflicts
}

func (p *GlusterHook) SetContent(attr string) {
	p.content = &attr
}

func (p *GlusterHook) Content() (string, bool) {
	if p.content != nil {
		return *p.content, true
	}
	var zero string
	return zero, false
}

func (p *GlusterHook) MustContent() string {
	if p.content == nil {
		panic("the content must not be nil, please use Content() function instead")
	}
	return *p.content
}

func (p *GlusterHook) SetContentType(attr HookContentType) {
	p.contentType = &attr
}

func (p *GlusterHook) ContentType() (HookContentType, bool) {
	if p.contentType != nil {
		return *p.contentType, true
	}
	var zero HookContentType
	return zero, false
}

func (p *GlusterHook) MustContentType() HookContentType {
	if p.contentType == nil {
		panic("the contentType must not be nil, please use ContentType() function instead")
	}
	return *p.contentType
}

func (p *GlusterHook) SetDescription(attr string) {
	p.description = &attr
}

func (p *GlusterHook) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *GlusterHook) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *GlusterHook) SetGlusterCommand(attr string) {
	p.glusterCommand = &attr
}

func (p *GlusterHook) GlusterCommand() (string, bool) {
	if p.glusterCommand != nil {
		return *p.glusterCommand, true
	}
	var zero string
	return zero, false
}

func (p *GlusterHook) MustGlusterCommand() string {
	if p.glusterCommand == nil {
		panic("the glusterCommand must not be nil, please use GlusterCommand() function instead")
	}
	return *p.glusterCommand
}

func (p *GlusterHook) SetId(attr string) {
	p.id = &attr
}

func (p *GlusterHook) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *GlusterHook) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *GlusterHook) SetName(attr string) {
	p.name = &attr
}

func (p *GlusterHook) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *GlusterHook) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *GlusterHook) SetServerHooks(attr *GlusterServerHookSlice) {
	p.serverHooks = attr
}

func (p *GlusterHook) ServerHooks() (*GlusterServerHookSlice, bool) {
	if p.serverHooks != nil {
		return p.serverHooks, true
	}
	return nil, false
}

func (p *GlusterHook) MustServerHooks() *GlusterServerHookSlice {
	if p.serverHooks == nil {
		panic("the serverHooks must not be nil, please use ServerHooks() function instead")
	}
	return p.serverHooks
}

func (p *GlusterHook) SetStage(attr HookStage) {
	p.stage = &attr
}

func (p *GlusterHook) Stage() (HookStage, bool) {
	if p.stage != nil {
		return *p.stage, true
	}
	var zero HookStage
	return zero, false
}

func (p *GlusterHook) MustStage() HookStage {
	if p.stage == nil {
		panic("the stage must not be nil, please use Stage() function instead")
	}
	return *p.stage
}

func (p *GlusterHook) SetStatus(attr GlusterHookStatus) {
	p.status = &attr
}

func (p *GlusterHook) Status() (GlusterHookStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero GlusterHookStatus
	return zero, false
}

func (p *GlusterHook) MustStatus() GlusterHookStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

type VolumeGroup struct {
	Struct
	id           *string
	logicalUnits *LogicalUnitSlice
	name         *string
}

func (p *VolumeGroup) SetId(attr string) {
	p.id = &attr
}

func (p *VolumeGroup) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *VolumeGroup) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *VolumeGroup) SetLogicalUnits(attr *LogicalUnitSlice) {
	p.logicalUnits = attr
}

func (p *VolumeGroup) LogicalUnits() (*LogicalUnitSlice, bool) {
	if p.logicalUnits != nil {
		return p.logicalUnits, true
	}
	return nil, false
}

func (p *VolumeGroup) MustLogicalUnits() *LogicalUnitSlice {
	if p.logicalUnits == nil {
		panic("the logicalUnits must not be nil, please use LogicalUnits() function instead")
	}
	return p.logicalUnits
}

func (p *VolumeGroup) SetName(attr string) {
	p.name = &attr
}

func (p *VolumeGroup) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *VolumeGroup) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type Domain struct {
	Struct
	comment     *string
	description *string
	groups      *GroupSlice
	id          *string
	name        *string
	user        *User
	users       *UserSlice
}

func (p *Domain) SetComment(attr string) {
	p.comment = &attr
}

func (p *Domain) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Domain) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Domain) SetDescription(attr string) {
	p.description = &attr
}

func (p *Domain) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Domain) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Domain) SetGroups(attr *GroupSlice) {
	p.groups = attr
}

func (p *Domain) Groups() (*GroupSlice, bool) {
	if p.groups != nil {
		return p.groups, true
	}
	return nil, false
}

func (p *Domain) MustGroups() *GroupSlice {
	if p.groups == nil {
		panic("the groups must not be nil, please use Groups() function instead")
	}
	return p.groups
}

func (p *Domain) SetId(attr string) {
	p.id = &attr
}

func (p *Domain) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Domain) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Domain) SetName(attr string) {
	p.name = &attr
}

func (p *Domain) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Domain) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Domain) SetUser(attr *User) {
	p.user = attr
}

func (p *Domain) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *Domain) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

func (p *Domain) SetUsers(attr *UserSlice) {
	p.users = attr
}

func (p *Domain) Users() (*UserSlice, bool) {
	if p.users != nil {
		return p.users, true
	}
	return nil, false
}

func (p *Domain) MustUsers() *UserSlice {
	if p.users == nil {
		panic("the users must not be nil, please use Users() function instead")
	}
	return p.users
}

type RegistrationConfiguration struct {
	Struct
	affinityGroupMappings *RegistrationAffinityGroupMappingSlice
	affinityLabelMappings *RegistrationAffinityLabelMappingSlice
	clusterMappings       *RegistrationClusterMappingSlice
	domainMappings        *RegistrationDomainMappingSlice
	lunMappings           *RegistrationLunMappingSlice
	roleMappings          *RegistrationRoleMappingSlice
	vnicProfileMappings   *RegistrationVnicProfileMappingSlice
}

func (p *RegistrationConfiguration) SetAffinityGroupMappings(attr *RegistrationAffinityGroupMappingSlice) {
	p.affinityGroupMappings = attr
}

func (p *RegistrationConfiguration) AffinityGroupMappings() (*RegistrationAffinityGroupMappingSlice, bool) {
	if p.affinityGroupMappings != nil {
		return p.affinityGroupMappings, true
	}
	return nil, false
}

func (p *RegistrationConfiguration) MustAffinityGroupMappings() *RegistrationAffinityGroupMappingSlice {
	if p.affinityGroupMappings == nil {
		panic("the affinityGroupMappings must not be nil, please use AffinityGroupMappings() function instead")
	}
	return p.affinityGroupMappings
}

func (p *RegistrationConfiguration) SetAffinityLabelMappings(attr *RegistrationAffinityLabelMappingSlice) {
	p.affinityLabelMappings = attr
}

func (p *RegistrationConfiguration) AffinityLabelMappings() (*RegistrationAffinityLabelMappingSlice, bool) {
	if p.affinityLabelMappings != nil {
		return p.affinityLabelMappings, true
	}
	return nil, false
}

func (p *RegistrationConfiguration) MustAffinityLabelMappings() *RegistrationAffinityLabelMappingSlice {
	if p.affinityLabelMappings == nil {
		panic("the affinityLabelMappings must not be nil, please use AffinityLabelMappings() function instead")
	}
	return p.affinityLabelMappings
}

func (p *RegistrationConfiguration) SetClusterMappings(attr *RegistrationClusterMappingSlice) {
	p.clusterMappings = attr
}

func (p *RegistrationConfiguration) ClusterMappings() (*RegistrationClusterMappingSlice, bool) {
	if p.clusterMappings != nil {
		return p.clusterMappings, true
	}
	return nil, false
}

func (p *RegistrationConfiguration) MustClusterMappings() *RegistrationClusterMappingSlice {
	if p.clusterMappings == nil {
		panic("the clusterMappings must not be nil, please use ClusterMappings() function instead")
	}
	return p.clusterMappings
}

func (p *RegistrationConfiguration) SetDomainMappings(attr *RegistrationDomainMappingSlice) {
	p.domainMappings = attr
}

func (p *RegistrationConfiguration) DomainMappings() (*RegistrationDomainMappingSlice, bool) {
	if p.domainMappings != nil {
		return p.domainMappings, true
	}
	return nil, false
}

func (p *RegistrationConfiguration) MustDomainMappings() *RegistrationDomainMappingSlice {
	if p.domainMappings == nil {
		panic("the domainMappings must not be nil, please use DomainMappings() function instead")
	}
	return p.domainMappings
}

func (p *RegistrationConfiguration) SetLunMappings(attr *RegistrationLunMappingSlice) {
	p.lunMappings = attr
}

func (p *RegistrationConfiguration) LunMappings() (*RegistrationLunMappingSlice, bool) {
	if p.lunMappings != nil {
		return p.lunMappings, true
	}
	return nil, false
}

func (p *RegistrationConfiguration) MustLunMappings() *RegistrationLunMappingSlice {
	if p.lunMappings == nil {
		panic("the lunMappings must not be nil, please use LunMappings() function instead")
	}
	return p.lunMappings
}

func (p *RegistrationConfiguration) SetRoleMappings(attr *RegistrationRoleMappingSlice) {
	p.roleMappings = attr
}

func (p *RegistrationConfiguration) RoleMappings() (*RegistrationRoleMappingSlice, bool) {
	if p.roleMappings != nil {
		return p.roleMappings, true
	}
	return nil, false
}

func (p *RegistrationConfiguration) MustRoleMappings() *RegistrationRoleMappingSlice {
	if p.roleMappings == nil {
		panic("the roleMappings must not be nil, please use RoleMappings() function instead")
	}
	return p.roleMappings
}

func (p *RegistrationConfiguration) SetVnicProfileMappings(attr *RegistrationVnicProfileMappingSlice) {
	p.vnicProfileMappings = attr
}

func (p *RegistrationConfiguration) VnicProfileMappings() (*RegistrationVnicProfileMappingSlice, bool) {
	if p.vnicProfileMappings != nil {
		return p.vnicProfileMappings, true
	}
	return nil, false
}

func (p *RegistrationConfiguration) MustVnicProfileMappings() *RegistrationVnicProfileMappingSlice {
	if p.vnicProfileMappings == nil {
		panic("the vnicProfileMappings must not be nil, please use VnicProfileMappings() function instead")
	}
	return p.vnicProfileMappings
}

type InstanceType struct {
	Struct
	bios                        *Bios
	cdroms                      *CdromSlice
	cluster                     *Cluster
	comment                     *string
	console                     *Console
	cpu                         *Cpu
	cpuProfile                  *CpuProfile
	cpuShares                   *int64
	creationTime                *time.Time
	customCompatibilityVersion  *Version
	customCpuModel              *string
	customEmulatedMachine       *string
	customProperties            *CustomPropertySlice
	deleteProtected             *bool
	description                 *string
	diskAttachments             *DiskAttachmentSlice
	display                     *Display
	domain                      *Domain
	graphicsConsoles            *GraphicsConsoleSlice
	highAvailability            *HighAvailability
	id                          *string
	initialization              *Initialization
	io                          *Io
	largeIcon                   *Icon
	lease                       *StorageDomainLease
	memory                      *int64
	memoryPolicy                *MemoryPolicy
	migration                   *MigrationOptions
	migrationDowntime           *int64
	multiQueuesEnabled          *bool
	name                        *string
	nics                        *NicSlice
	origin                      *string
	os                          *OperatingSystem
	permissions                 *PermissionSlice
	placementPolicy             *VmPlacementPolicy
	quota                       *Quota
	rngDevice                   *RngDevice
	serialNumber                *SerialNumber
	smallIcon                   *Icon
	soundcardEnabled            *bool
	sso                         *Sso
	startPaused                 *bool
	stateless                   *bool
	status                      *TemplateStatus
	storageDomain               *StorageDomain
	storageErrorResumeBehaviour *VmStorageErrorResumeBehaviour
	tags                        *TagSlice
	timeZone                    *TimeZone
	tunnelMigration             *bool
	type_                       *VmType
	usb                         *Usb
	version                     *TemplateVersion
	virtioScsi                  *VirtioScsi
	vm                          *Vm
	watchdogs                   *WatchdogSlice
}

func (p *InstanceType) SetBios(attr *Bios) {
	p.bios = attr
}

func (p *InstanceType) Bios() (*Bios, bool) {
	if p.bios != nil {
		return p.bios, true
	}
	return nil, false
}

func (p *InstanceType) MustBios() *Bios {
	if p.bios == nil {
		panic("the bios must not be nil, please use Bios() function instead")
	}
	return p.bios
}

func (p *InstanceType) SetCdroms(attr *CdromSlice) {
	p.cdroms = attr
}

func (p *InstanceType) Cdroms() (*CdromSlice, bool) {
	if p.cdroms != nil {
		return p.cdroms, true
	}
	return nil, false
}

func (p *InstanceType) MustCdroms() *CdromSlice {
	if p.cdroms == nil {
		panic("the cdroms must not be nil, please use Cdroms() function instead")
	}
	return p.cdroms
}

func (p *InstanceType) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *InstanceType) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *InstanceType) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *InstanceType) SetComment(attr string) {
	p.comment = &attr
}

func (p *InstanceType) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *InstanceType) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *InstanceType) SetConsole(attr *Console) {
	p.console = attr
}

func (p *InstanceType) Console() (*Console, bool) {
	if p.console != nil {
		return p.console, true
	}
	return nil, false
}

func (p *InstanceType) MustConsole() *Console {
	if p.console == nil {
		panic("the console must not be nil, please use Console() function instead")
	}
	return p.console
}

func (p *InstanceType) SetCpu(attr *Cpu) {
	p.cpu = attr
}

func (p *InstanceType) Cpu() (*Cpu, bool) {
	if p.cpu != nil {
		return p.cpu, true
	}
	return nil, false
}

func (p *InstanceType) MustCpu() *Cpu {
	if p.cpu == nil {
		panic("the cpu must not be nil, please use Cpu() function instead")
	}
	return p.cpu
}

func (p *InstanceType) SetCpuProfile(attr *CpuProfile) {
	p.cpuProfile = attr
}

func (p *InstanceType) CpuProfile() (*CpuProfile, bool) {
	if p.cpuProfile != nil {
		return p.cpuProfile, true
	}
	return nil, false
}

func (p *InstanceType) MustCpuProfile() *CpuProfile {
	if p.cpuProfile == nil {
		panic("the cpuProfile must not be nil, please use CpuProfile() function instead")
	}
	return p.cpuProfile
}

func (p *InstanceType) SetCpuShares(attr int64) {
	p.cpuShares = &attr
}

func (p *InstanceType) CpuShares() (int64, bool) {
	if p.cpuShares != nil {
		return *p.cpuShares, true
	}
	var zero int64
	return zero, false
}

func (p *InstanceType) MustCpuShares() int64 {
	if p.cpuShares == nil {
		panic("the cpuShares must not be nil, please use CpuShares() function instead")
	}
	return *p.cpuShares
}

func (p *InstanceType) SetCreationTime(attr time.Time) {
	p.creationTime = &attr
}

func (p *InstanceType) CreationTime() (time.Time, bool) {
	if p.creationTime != nil {
		return *p.creationTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *InstanceType) MustCreationTime() time.Time {
	if p.creationTime == nil {
		panic("the creationTime must not be nil, please use CreationTime() function instead")
	}
	return *p.creationTime
}

func (p *InstanceType) SetCustomCompatibilityVersion(attr *Version) {
	p.customCompatibilityVersion = attr
}

func (p *InstanceType) CustomCompatibilityVersion() (*Version, bool) {
	if p.customCompatibilityVersion != nil {
		return p.customCompatibilityVersion, true
	}
	return nil, false
}

func (p *InstanceType) MustCustomCompatibilityVersion() *Version {
	if p.customCompatibilityVersion == nil {
		panic("the customCompatibilityVersion must not be nil, please use CustomCompatibilityVersion() function instead")
	}
	return p.customCompatibilityVersion
}

func (p *InstanceType) SetCustomCpuModel(attr string) {
	p.customCpuModel = &attr
}

func (p *InstanceType) CustomCpuModel() (string, bool) {
	if p.customCpuModel != nil {
		return *p.customCpuModel, true
	}
	var zero string
	return zero, false
}

func (p *InstanceType) MustCustomCpuModel() string {
	if p.customCpuModel == nil {
		panic("the customCpuModel must not be nil, please use CustomCpuModel() function instead")
	}
	return *p.customCpuModel
}

func (p *InstanceType) SetCustomEmulatedMachine(attr string) {
	p.customEmulatedMachine = &attr
}

func (p *InstanceType) CustomEmulatedMachine() (string, bool) {
	if p.customEmulatedMachine != nil {
		return *p.customEmulatedMachine, true
	}
	var zero string
	return zero, false
}

func (p *InstanceType) MustCustomEmulatedMachine() string {
	if p.customEmulatedMachine == nil {
		panic("the customEmulatedMachine must not be nil, please use CustomEmulatedMachine() function instead")
	}
	return *p.customEmulatedMachine
}

func (p *InstanceType) SetCustomProperties(attr *CustomPropertySlice) {
	p.customProperties = attr
}

func (p *InstanceType) CustomProperties() (*CustomPropertySlice, bool) {
	if p.customProperties != nil {
		return p.customProperties, true
	}
	return nil, false
}

func (p *InstanceType) MustCustomProperties() *CustomPropertySlice {
	if p.customProperties == nil {
		panic("the customProperties must not be nil, please use CustomProperties() function instead")
	}
	return p.customProperties
}

func (p *InstanceType) SetDeleteProtected(attr bool) {
	p.deleteProtected = &attr
}

func (p *InstanceType) DeleteProtected() (bool, bool) {
	if p.deleteProtected != nil {
		return *p.deleteProtected, true
	}
	var zero bool
	return zero, false
}

func (p *InstanceType) MustDeleteProtected() bool {
	if p.deleteProtected == nil {
		panic("the deleteProtected must not be nil, please use DeleteProtected() function instead")
	}
	return *p.deleteProtected
}

func (p *InstanceType) SetDescription(attr string) {
	p.description = &attr
}

func (p *InstanceType) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *InstanceType) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *InstanceType) SetDiskAttachments(attr *DiskAttachmentSlice) {
	p.diskAttachments = attr
}

func (p *InstanceType) DiskAttachments() (*DiskAttachmentSlice, bool) {
	if p.diskAttachments != nil {
		return p.diskAttachments, true
	}
	return nil, false
}

func (p *InstanceType) MustDiskAttachments() *DiskAttachmentSlice {
	if p.diskAttachments == nil {
		panic("the diskAttachments must not be nil, please use DiskAttachments() function instead")
	}
	return p.diskAttachments
}

func (p *InstanceType) SetDisplay(attr *Display) {
	p.display = attr
}

func (p *InstanceType) Display() (*Display, bool) {
	if p.display != nil {
		return p.display, true
	}
	return nil, false
}

func (p *InstanceType) MustDisplay() *Display {
	if p.display == nil {
		panic("the display must not be nil, please use Display() function instead")
	}
	return p.display
}

func (p *InstanceType) SetDomain(attr *Domain) {
	p.domain = attr
}

func (p *InstanceType) Domain() (*Domain, bool) {
	if p.domain != nil {
		return p.domain, true
	}
	return nil, false
}

func (p *InstanceType) MustDomain() *Domain {
	if p.domain == nil {
		panic("the domain must not be nil, please use Domain() function instead")
	}
	return p.domain
}

func (p *InstanceType) SetGraphicsConsoles(attr *GraphicsConsoleSlice) {
	p.graphicsConsoles = attr
}

func (p *InstanceType) GraphicsConsoles() (*GraphicsConsoleSlice, bool) {
	if p.graphicsConsoles != nil {
		return p.graphicsConsoles, true
	}
	return nil, false
}

func (p *InstanceType) MustGraphicsConsoles() *GraphicsConsoleSlice {
	if p.graphicsConsoles == nil {
		panic("the graphicsConsoles must not be nil, please use GraphicsConsoles() function instead")
	}
	return p.graphicsConsoles
}

func (p *InstanceType) SetHighAvailability(attr *HighAvailability) {
	p.highAvailability = attr
}

func (p *InstanceType) HighAvailability() (*HighAvailability, bool) {
	if p.highAvailability != nil {
		return p.highAvailability, true
	}
	return nil, false
}

func (p *InstanceType) MustHighAvailability() *HighAvailability {
	if p.highAvailability == nil {
		panic("the highAvailability must not be nil, please use HighAvailability() function instead")
	}
	return p.highAvailability
}

func (p *InstanceType) SetId(attr string) {
	p.id = &attr
}

func (p *InstanceType) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *InstanceType) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *InstanceType) SetInitialization(attr *Initialization) {
	p.initialization = attr
}

func (p *InstanceType) Initialization() (*Initialization, bool) {
	if p.initialization != nil {
		return p.initialization, true
	}
	return nil, false
}

func (p *InstanceType) MustInitialization() *Initialization {
	if p.initialization == nil {
		panic("the initialization must not be nil, please use Initialization() function instead")
	}
	return p.initialization
}

func (p *InstanceType) SetIo(attr *Io) {
	p.io = attr
}

func (p *InstanceType) Io() (*Io, bool) {
	if p.io != nil {
		return p.io, true
	}
	return nil, false
}

func (p *InstanceType) MustIo() *Io {
	if p.io == nil {
		panic("the io must not be nil, please use Io() function instead")
	}
	return p.io
}

func (p *InstanceType) SetLargeIcon(attr *Icon) {
	p.largeIcon = attr
}

func (p *InstanceType) LargeIcon() (*Icon, bool) {
	if p.largeIcon != nil {
		return p.largeIcon, true
	}
	return nil, false
}

func (p *InstanceType) MustLargeIcon() *Icon {
	if p.largeIcon == nil {
		panic("the largeIcon must not be nil, please use LargeIcon() function instead")
	}
	return p.largeIcon
}

func (p *InstanceType) SetLease(attr *StorageDomainLease) {
	p.lease = attr
}

func (p *InstanceType) Lease() (*StorageDomainLease, bool) {
	if p.lease != nil {
		return p.lease, true
	}
	return nil, false
}

func (p *InstanceType) MustLease() *StorageDomainLease {
	if p.lease == nil {
		panic("the lease must not be nil, please use Lease() function instead")
	}
	return p.lease
}

func (p *InstanceType) SetMemory(attr int64) {
	p.memory = &attr
}

func (p *InstanceType) Memory() (int64, bool) {
	if p.memory != nil {
		return *p.memory, true
	}
	var zero int64
	return zero, false
}

func (p *InstanceType) MustMemory() int64 {
	if p.memory == nil {
		panic("the memory must not be nil, please use Memory() function instead")
	}
	return *p.memory
}

func (p *InstanceType) SetMemoryPolicy(attr *MemoryPolicy) {
	p.memoryPolicy = attr
}

func (p *InstanceType) MemoryPolicy() (*MemoryPolicy, bool) {
	if p.memoryPolicy != nil {
		return p.memoryPolicy, true
	}
	return nil, false
}

func (p *InstanceType) MustMemoryPolicy() *MemoryPolicy {
	if p.memoryPolicy == nil {
		panic("the memoryPolicy must not be nil, please use MemoryPolicy() function instead")
	}
	return p.memoryPolicy
}

func (p *InstanceType) SetMigration(attr *MigrationOptions) {
	p.migration = attr
}

func (p *InstanceType) Migration() (*MigrationOptions, bool) {
	if p.migration != nil {
		return p.migration, true
	}
	return nil, false
}

func (p *InstanceType) MustMigration() *MigrationOptions {
	if p.migration == nil {
		panic("the migration must not be nil, please use Migration() function instead")
	}
	return p.migration
}

func (p *InstanceType) SetMigrationDowntime(attr int64) {
	p.migrationDowntime = &attr
}

func (p *InstanceType) MigrationDowntime() (int64, bool) {
	if p.migrationDowntime != nil {
		return *p.migrationDowntime, true
	}
	var zero int64
	return zero, false
}

func (p *InstanceType) MustMigrationDowntime() int64 {
	if p.migrationDowntime == nil {
		panic("the migrationDowntime must not be nil, please use MigrationDowntime() function instead")
	}
	return *p.migrationDowntime
}

func (p *InstanceType) SetMultiQueuesEnabled(attr bool) {
	p.multiQueuesEnabled = &attr
}

func (p *InstanceType) MultiQueuesEnabled() (bool, bool) {
	if p.multiQueuesEnabled != nil {
		return *p.multiQueuesEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *InstanceType) MustMultiQueuesEnabled() bool {
	if p.multiQueuesEnabled == nil {
		panic("the multiQueuesEnabled must not be nil, please use MultiQueuesEnabled() function instead")
	}
	return *p.multiQueuesEnabled
}

func (p *InstanceType) SetName(attr string) {
	p.name = &attr
}

func (p *InstanceType) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *InstanceType) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *InstanceType) SetNics(attr *NicSlice) {
	p.nics = attr
}

func (p *InstanceType) Nics() (*NicSlice, bool) {
	if p.nics != nil {
		return p.nics, true
	}
	return nil, false
}

func (p *InstanceType) MustNics() *NicSlice {
	if p.nics == nil {
		panic("the nics must not be nil, please use Nics() function instead")
	}
	return p.nics
}

func (p *InstanceType) SetOrigin(attr string) {
	p.origin = &attr
}

func (p *InstanceType) Origin() (string, bool) {
	if p.origin != nil {
		return *p.origin, true
	}
	var zero string
	return zero, false
}

func (p *InstanceType) MustOrigin() string {
	if p.origin == nil {
		panic("the origin must not be nil, please use Origin() function instead")
	}
	return *p.origin
}

func (p *InstanceType) SetOs(attr *OperatingSystem) {
	p.os = attr
}

func (p *InstanceType) Os() (*OperatingSystem, bool) {
	if p.os != nil {
		return p.os, true
	}
	return nil, false
}

func (p *InstanceType) MustOs() *OperatingSystem {
	if p.os == nil {
		panic("the os must not be nil, please use Os() function instead")
	}
	return p.os
}

func (p *InstanceType) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *InstanceType) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *InstanceType) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *InstanceType) SetPlacementPolicy(attr *VmPlacementPolicy) {
	p.placementPolicy = attr
}

func (p *InstanceType) PlacementPolicy() (*VmPlacementPolicy, bool) {
	if p.placementPolicy != nil {
		return p.placementPolicy, true
	}
	return nil, false
}

func (p *InstanceType) MustPlacementPolicy() *VmPlacementPolicy {
	if p.placementPolicy == nil {
		panic("the placementPolicy must not be nil, please use PlacementPolicy() function instead")
	}
	return p.placementPolicy
}

func (p *InstanceType) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *InstanceType) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *InstanceType) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *InstanceType) SetRngDevice(attr *RngDevice) {
	p.rngDevice = attr
}

func (p *InstanceType) RngDevice() (*RngDevice, bool) {
	if p.rngDevice != nil {
		return p.rngDevice, true
	}
	return nil, false
}

func (p *InstanceType) MustRngDevice() *RngDevice {
	if p.rngDevice == nil {
		panic("the rngDevice must not be nil, please use RngDevice() function instead")
	}
	return p.rngDevice
}

func (p *InstanceType) SetSerialNumber(attr *SerialNumber) {
	p.serialNumber = attr
}

func (p *InstanceType) SerialNumber() (*SerialNumber, bool) {
	if p.serialNumber != nil {
		return p.serialNumber, true
	}
	return nil, false
}

func (p *InstanceType) MustSerialNumber() *SerialNumber {
	if p.serialNumber == nil {
		panic("the serialNumber must not be nil, please use SerialNumber() function instead")
	}
	return p.serialNumber
}

func (p *InstanceType) SetSmallIcon(attr *Icon) {
	p.smallIcon = attr
}

func (p *InstanceType) SmallIcon() (*Icon, bool) {
	if p.smallIcon != nil {
		return p.smallIcon, true
	}
	return nil, false
}

func (p *InstanceType) MustSmallIcon() *Icon {
	if p.smallIcon == nil {
		panic("the smallIcon must not be nil, please use SmallIcon() function instead")
	}
	return p.smallIcon
}

func (p *InstanceType) SetSoundcardEnabled(attr bool) {
	p.soundcardEnabled = &attr
}

func (p *InstanceType) SoundcardEnabled() (bool, bool) {
	if p.soundcardEnabled != nil {
		return *p.soundcardEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *InstanceType) MustSoundcardEnabled() bool {
	if p.soundcardEnabled == nil {
		panic("the soundcardEnabled must not be nil, please use SoundcardEnabled() function instead")
	}
	return *p.soundcardEnabled
}

func (p *InstanceType) SetSso(attr *Sso) {
	p.sso = attr
}

func (p *InstanceType) Sso() (*Sso, bool) {
	if p.sso != nil {
		return p.sso, true
	}
	return nil, false
}

func (p *InstanceType) MustSso() *Sso {
	if p.sso == nil {
		panic("the sso must not be nil, please use Sso() function instead")
	}
	return p.sso
}

func (p *InstanceType) SetStartPaused(attr bool) {
	p.startPaused = &attr
}

func (p *InstanceType) StartPaused() (bool, bool) {
	if p.startPaused != nil {
		return *p.startPaused, true
	}
	var zero bool
	return zero, false
}

func (p *InstanceType) MustStartPaused() bool {
	if p.startPaused == nil {
		panic("the startPaused must not be nil, please use StartPaused() function instead")
	}
	return *p.startPaused
}

func (p *InstanceType) SetStateless(attr bool) {
	p.stateless = &attr
}

func (p *InstanceType) Stateless() (bool, bool) {
	if p.stateless != nil {
		return *p.stateless, true
	}
	var zero bool
	return zero, false
}

func (p *InstanceType) MustStateless() bool {
	if p.stateless == nil {
		panic("the stateless must not be nil, please use Stateless() function instead")
	}
	return *p.stateless
}

func (p *InstanceType) SetStatus(attr TemplateStatus) {
	p.status = &attr
}

func (p *InstanceType) Status() (TemplateStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero TemplateStatus
	return zero, false
}

func (p *InstanceType) MustStatus() TemplateStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *InstanceType) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *InstanceType) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *InstanceType) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *InstanceType) SetStorageErrorResumeBehaviour(attr VmStorageErrorResumeBehaviour) {
	p.storageErrorResumeBehaviour = &attr
}

func (p *InstanceType) StorageErrorResumeBehaviour() (VmStorageErrorResumeBehaviour, bool) {
	if p.storageErrorResumeBehaviour != nil {
		return *p.storageErrorResumeBehaviour, true
	}
	var zero VmStorageErrorResumeBehaviour
	return zero, false
}

func (p *InstanceType) MustStorageErrorResumeBehaviour() VmStorageErrorResumeBehaviour {
	if p.storageErrorResumeBehaviour == nil {
		panic("the storageErrorResumeBehaviour must not be nil, please use StorageErrorResumeBehaviour() function instead")
	}
	return *p.storageErrorResumeBehaviour
}

func (p *InstanceType) SetTags(attr *TagSlice) {
	p.tags = attr
}

func (p *InstanceType) Tags() (*TagSlice, bool) {
	if p.tags != nil {
		return p.tags, true
	}
	return nil, false
}

func (p *InstanceType) MustTags() *TagSlice {
	if p.tags == nil {
		panic("the tags must not be nil, please use Tags() function instead")
	}
	return p.tags
}

func (p *InstanceType) SetTimeZone(attr *TimeZone) {
	p.timeZone = attr
}

func (p *InstanceType) TimeZone() (*TimeZone, bool) {
	if p.timeZone != nil {
		return p.timeZone, true
	}
	return nil, false
}

func (p *InstanceType) MustTimeZone() *TimeZone {
	if p.timeZone == nil {
		panic("the timeZone must not be nil, please use TimeZone() function instead")
	}
	return p.timeZone
}

func (p *InstanceType) SetTunnelMigration(attr bool) {
	p.tunnelMigration = &attr
}

func (p *InstanceType) TunnelMigration() (bool, bool) {
	if p.tunnelMigration != nil {
		return *p.tunnelMigration, true
	}
	var zero bool
	return zero, false
}

func (p *InstanceType) MustTunnelMigration() bool {
	if p.tunnelMigration == nil {
		panic("the tunnelMigration must not be nil, please use TunnelMigration() function instead")
	}
	return *p.tunnelMigration
}

func (p *InstanceType) SetType(attr VmType) {
	p.type_ = &attr
}

func (p *InstanceType) Type() (VmType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero VmType
	return zero, false
}

func (p *InstanceType) MustType() VmType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *InstanceType) SetUsb(attr *Usb) {
	p.usb = attr
}

func (p *InstanceType) Usb() (*Usb, bool) {
	if p.usb != nil {
		return p.usb, true
	}
	return nil, false
}

func (p *InstanceType) MustUsb() *Usb {
	if p.usb == nil {
		panic("the usb must not be nil, please use Usb() function instead")
	}
	return p.usb
}

func (p *InstanceType) SetVersion(attr *TemplateVersion) {
	p.version = attr
}

func (p *InstanceType) Version() (*TemplateVersion, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *InstanceType) MustVersion() *TemplateVersion {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

func (p *InstanceType) SetVirtioScsi(attr *VirtioScsi) {
	p.virtioScsi = attr
}

func (p *InstanceType) VirtioScsi() (*VirtioScsi, bool) {
	if p.virtioScsi != nil {
		return p.virtioScsi, true
	}
	return nil, false
}

func (p *InstanceType) MustVirtioScsi() *VirtioScsi {
	if p.virtioScsi == nil {
		panic("the virtioScsi must not be nil, please use VirtioScsi() function instead")
	}
	return p.virtioScsi
}

func (p *InstanceType) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *InstanceType) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *InstanceType) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *InstanceType) SetWatchdogs(attr *WatchdogSlice) {
	p.watchdogs = attr
}

func (p *InstanceType) Watchdogs() (*WatchdogSlice, bool) {
	if p.watchdogs != nil {
		return p.watchdogs, true
	}
	return nil, false
}

func (p *InstanceType) MustWatchdogs() *WatchdogSlice {
	if p.watchdogs == nil {
		panic("the watchdogs must not be nil, please use Watchdogs() function instead")
	}
	return p.watchdogs
}

type Option struct {
	Struct
	name  *string
	type_ *string
	value *string
}

func (p *Option) SetName(attr string) {
	p.name = &attr
}

func (p *Option) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Option) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Option) SetType(attr string) {
	p.type_ = &attr
}

func (p *Option) Type() (string, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero string
	return zero, false
}

func (p *Option) MustType() string {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *Option) SetValue(attr string) {
	p.value = &attr
}

func (p *Option) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *Option) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

type Property struct {
	Struct
	name  *string
	value *string
}

func (p *Property) SetName(attr string) {
	p.name = &attr
}

func (p *Property) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Property) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Property) SetValue(attr string) {
	p.value = &attr
}

func (p *Property) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *Property) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

type Permission struct {
	Struct
	cluster       *Cluster
	comment       *string
	dataCenter    *DataCenter
	description   *string
	disk          *Disk
	group         *Group
	host          *Host
	id            *string
	name          *string
	role          *Role
	storageDomain *StorageDomain
	template      *Template
	user          *User
	vm            *Vm
	vmPool        *VmPool
}

func (p *Permission) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *Permission) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *Permission) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *Permission) SetComment(attr string) {
	p.comment = &attr
}

func (p *Permission) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Permission) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Permission) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *Permission) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *Permission) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *Permission) SetDescription(attr string) {
	p.description = &attr
}

func (p *Permission) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Permission) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Permission) SetDisk(attr *Disk) {
	p.disk = attr
}

func (p *Permission) Disk() (*Disk, bool) {
	if p.disk != nil {
		return p.disk, true
	}
	return nil, false
}

func (p *Permission) MustDisk() *Disk {
	if p.disk == nil {
		panic("the disk must not be nil, please use Disk() function instead")
	}
	return p.disk
}

func (p *Permission) SetGroup(attr *Group) {
	p.group = attr
}

func (p *Permission) Group() (*Group, bool) {
	if p.group != nil {
		return p.group, true
	}
	return nil, false
}

func (p *Permission) MustGroup() *Group {
	if p.group == nil {
		panic("the group must not be nil, please use Group() function instead")
	}
	return p.group
}

func (p *Permission) SetHost(attr *Host) {
	p.host = attr
}

func (p *Permission) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *Permission) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *Permission) SetId(attr string) {
	p.id = &attr
}

func (p *Permission) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Permission) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Permission) SetName(attr string) {
	p.name = &attr
}

func (p *Permission) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Permission) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Permission) SetRole(attr *Role) {
	p.role = attr
}

func (p *Permission) Role() (*Role, bool) {
	if p.role != nil {
		return p.role, true
	}
	return nil, false
}

func (p *Permission) MustRole() *Role {
	if p.role == nil {
		panic("the role must not be nil, please use Role() function instead")
	}
	return p.role
}

func (p *Permission) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *Permission) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *Permission) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *Permission) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Permission) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Permission) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Permission) SetUser(attr *User) {
	p.user = attr
}

func (p *Permission) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *Permission) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

func (p *Permission) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Permission) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Permission) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Permission) SetVmPool(attr *VmPool) {
	p.vmPool = attr
}

func (p *Permission) VmPool() (*VmPool, bool) {
	if p.vmPool != nil {
		return p.vmPool, true
	}
	return nil, false
}

func (p *Permission) MustVmPool() *VmPool {
	if p.vmPool == nil {
		panic("the vmPool must not be nil, please use VmPool() function instead")
	}
	return p.vmPool
}

type RngDevice struct {
	Struct
	rate   *Rate
	source *RngSource
}

func (p *RngDevice) SetRate(attr *Rate) {
	p.rate = attr
}

func (p *RngDevice) Rate() (*Rate, bool) {
	if p.rate != nil {
		return p.rate, true
	}
	return nil, false
}

func (p *RngDevice) MustRate() *Rate {
	if p.rate == nil {
		panic("the rate must not be nil, please use Rate() function instead")
	}
	return p.rate
}

func (p *RngDevice) SetSource(attr RngSource) {
	p.source = &attr
}

func (p *RngDevice) Source() (RngSource, bool) {
	if p.source != nil {
		return *p.source, true
	}
	var zero RngSource
	return zero, false
}

func (p *RngDevice) MustSource() RngSource {
	if p.source == nil {
		panic("the source must not be nil, please use Source() function instead")
	}
	return *p.source
}

type Ticket struct {
	Struct
	expiry *int64
	value  *string
}

func (p *Ticket) SetExpiry(attr int64) {
	p.expiry = &attr
}

func (p *Ticket) Expiry() (int64, bool) {
	if p.expiry != nil {
		return *p.expiry, true
	}
	var zero int64
	return zero, false
}

func (p *Ticket) MustExpiry() int64 {
	if p.expiry == nil {
		panic("the expiry must not be nil, please use Expiry() function instead")
	}
	return *p.expiry
}

func (p *Ticket) SetValue(attr string) {
	p.value = &attr
}

func (p *Ticket) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *Ticket) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

type Job struct {
	Struct
	autoCleared *bool
	comment     *string
	description *string
	endTime     *time.Time
	external    *bool
	id          *string
	lastUpdated *time.Time
	name        *string
	owner       *User
	startTime   *time.Time
	status      *JobStatus
	steps       *StepSlice
}

func (p *Job) SetAutoCleared(attr bool) {
	p.autoCleared = &attr
}

func (p *Job) AutoCleared() (bool, bool) {
	if p.autoCleared != nil {
		return *p.autoCleared, true
	}
	var zero bool
	return zero, false
}

func (p *Job) MustAutoCleared() bool {
	if p.autoCleared == nil {
		panic("the autoCleared must not be nil, please use AutoCleared() function instead")
	}
	return *p.autoCleared
}

func (p *Job) SetComment(attr string) {
	p.comment = &attr
}

func (p *Job) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Job) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Job) SetDescription(attr string) {
	p.description = &attr
}

func (p *Job) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Job) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Job) SetEndTime(attr time.Time) {
	p.endTime = &attr
}

func (p *Job) EndTime() (time.Time, bool) {
	if p.endTime != nil {
		return *p.endTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Job) MustEndTime() time.Time {
	if p.endTime == nil {
		panic("the endTime must not be nil, please use EndTime() function instead")
	}
	return *p.endTime
}

func (p *Job) SetExternal(attr bool) {
	p.external = &attr
}

func (p *Job) External() (bool, bool) {
	if p.external != nil {
		return *p.external, true
	}
	var zero bool
	return zero, false
}

func (p *Job) MustExternal() bool {
	if p.external == nil {
		panic("the external must not be nil, please use External() function instead")
	}
	return *p.external
}

func (p *Job) SetId(attr string) {
	p.id = &attr
}

func (p *Job) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Job) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Job) SetLastUpdated(attr time.Time) {
	p.lastUpdated = &attr
}

func (p *Job) LastUpdated() (time.Time, bool) {
	if p.lastUpdated != nil {
		return *p.lastUpdated, true
	}
	var zero time.Time
	return zero, false
}

func (p *Job) MustLastUpdated() time.Time {
	if p.lastUpdated == nil {
		panic("the lastUpdated must not be nil, please use LastUpdated() function instead")
	}
	return *p.lastUpdated
}

func (p *Job) SetName(attr string) {
	p.name = &attr
}

func (p *Job) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Job) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Job) SetOwner(attr *User) {
	p.owner = attr
}

func (p *Job) Owner() (*User, bool) {
	if p.owner != nil {
		return p.owner, true
	}
	return nil, false
}

func (p *Job) MustOwner() *User {
	if p.owner == nil {
		panic("the owner must not be nil, please use Owner() function instead")
	}
	return p.owner
}

func (p *Job) SetStartTime(attr time.Time) {
	p.startTime = &attr
}

func (p *Job) StartTime() (time.Time, bool) {
	if p.startTime != nil {
		return *p.startTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Job) MustStartTime() time.Time {
	if p.startTime == nil {
		panic("the startTime must not be nil, please use StartTime() function instead")
	}
	return *p.startTime
}

func (p *Job) SetStatus(attr JobStatus) {
	p.status = &attr
}

func (p *Job) Status() (JobStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero JobStatus
	return zero, false
}

func (p *Job) MustStatus() JobStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *Job) SetSteps(attr *StepSlice) {
	p.steps = attr
}

func (p *Job) Steps() (*StepSlice, bool) {
	if p.steps != nil {
		return p.steps, true
	}
	return nil, false
}

func (p *Job) MustSteps() *StepSlice {
	if p.steps == nil {
		panic("the steps must not be nil, please use Steps() function instead")
	}
	return p.steps
}

type ClusterFeature struct {
	Struct
	clusterLevel *ClusterLevel
	comment      *string
	description  *string
	id           *string
	name         *string
}

func (p *ClusterFeature) SetClusterLevel(attr *ClusterLevel) {
	p.clusterLevel = attr
}

func (p *ClusterFeature) ClusterLevel() (*ClusterLevel, bool) {
	if p.clusterLevel != nil {
		return p.clusterLevel, true
	}
	return nil, false
}

func (p *ClusterFeature) MustClusterLevel() *ClusterLevel {
	if p.clusterLevel == nil {
		panic("the clusterLevel must not be nil, please use ClusterLevel() function instead")
	}
	return p.clusterLevel
}

func (p *ClusterFeature) SetComment(attr string) {
	p.comment = &attr
}

func (p *ClusterFeature) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ClusterFeature) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ClusterFeature) SetDescription(attr string) {
	p.description = &attr
}

func (p *ClusterFeature) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ClusterFeature) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ClusterFeature) SetId(attr string) {
	p.id = &attr
}

func (p *ClusterFeature) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ClusterFeature) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ClusterFeature) SetName(attr string) {
	p.name = &attr
}

func (p *ClusterFeature) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ClusterFeature) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type Boot struct {
	Struct
	devices []BootDevice
}

func (p *Boot) SetDevices(attr []BootDevice) {
	p.devices = attr
}

func (p *Boot) Devices() ([]BootDevice, bool) {
	if p.devices != nil {
		return p.devices, true
	}
	return nil, false
}

func (p *Boot) MustDevices() []BootDevice {
	if p.devices == nil {
		panic("the devices must not be nil, please use Devices() function instead")
	}
	return p.devices
}

type TransparentHugePages struct {
	Struct
	enabled *bool
}

func (p *TransparentHugePages) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *TransparentHugePages) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *TransparentHugePages) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

type ExternalNetworkProviderConfiguration struct {
	Struct
	comment                 *string
	description             *string
	externalNetworkProvider *ExternalProvider
	host                    *Host
	id                      *string
	name                    *string
}

func (p *ExternalNetworkProviderConfiguration) SetComment(attr string) {
	p.comment = &attr
}

func (p *ExternalNetworkProviderConfiguration) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ExternalNetworkProviderConfiguration) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ExternalNetworkProviderConfiguration) SetDescription(attr string) {
	p.description = &attr
}

func (p *ExternalNetworkProviderConfiguration) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ExternalNetworkProviderConfiguration) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ExternalNetworkProviderConfiguration) SetExternalNetworkProvider(attr *ExternalProvider) {
	p.externalNetworkProvider = attr
}

func (p *ExternalNetworkProviderConfiguration) ExternalNetworkProvider() (*ExternalProvider, bool) {
	if p.externalNetworkProvider != nil {
		return p.externalNetworkProvider, true
	}
	return nil, false
}

func (p *ExternalNetworkProviderConfiguration) MustExternalNetworkProvider() *ExternalProvider {
	if p.externalNetworkProvider == nil {
		panic("the externalNetworkProvider must not be nil, please use ExternalNetworkProvider() function instead")
	}
	return p.externalNetworkProvider
}

func (p *ExternalNetworkProviderConfiguration) SetHost(attr *Host) {
	p.host = attr
}

func (p *ExternalNetworkProviderConfiguration) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *ExternalNetworkProviderConfiguration) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *ExternalNetworkProviderConfiguration) SetId(attr string) {
	p.id = &attr
}

func (p *ExternalNetworkProviderConfiguration) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ExternalNetworkProviderConfiguration) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ExternalNetworkProviderConfiguration) SetName(attr string) {
	p.name = &attr
}

func (p *ExternalNetworkProviderConfiguration) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ExternalNetworkProviderConfiguration) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type Vlan struct {
	Struct
	id *int64
}

func (p *Vlan) SetId(attr int64) {
	p.id = &attr
}

func (p *Vlan) Id() (int64, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero int64
	return zero, false
}

func (p *Vlan) MustId() int64 {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

type GlusterVolumeProfileDetails struct {
	Struct
	brickProfileDetails *BrickProfileDetailSlice
	comment             *string
	description         *string
	id                  *string
	name                *string
	nfsProfileDetails   *NfsProfileDetailSlice
}

func (p *GlusterVolumeProfileDetails) SetBrickProfileDetails(attr *BrickProfileDetailSlice) {
	p.brickProfileDetails = attr
}

func (p *GlusterVolumeProfileDetails) BrickProfileDetails() (*BrickProfileDetailSlice, bool) {
	if p.brickProfileDetails != nil {
		return p.brickProfileDetails, true
	}
	return nil, false
}

func (p *GlusterVolumeProfileDetails) MustBrickProfileDetails() *BrickProfileDetailSlice {
	if p.brickProfileDetails == nil {
		panic("the brickProfileDetails must not be nil, please use BrickProfileDetails() function instead")
	}
	return p.brickProfileDetails
}

func (p *GlusterVolumeProfileDetails) SetComment(attr string) {
	p.comment = &attr
}

func (p *GlusterVolumeProfileDetails) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *GlusterVolumeProfileDetails) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *GlusterVolumeProfileDetails) SetDescription(attr string) {
	p.description = &attr
}

func (p *GlusterVolumeProfileDetails) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *GlusterVolumeProfileDetails) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *GlusterVolumeProfileDetails) SetId(attr string) {
	p.id = &attr
}

func (p *GlusterVolumeProfileDetails) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *GlusterVolumeProfileDetails) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *GlusterVolumeProfileDetails) SetName(attr string) {
	p.name = &attr
}

func (p *GlusterVolumeProfileDetails) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *GlusterVolumeProfileDetails) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *GlusterVolumeProfileDetails) SetNfsProfileDetails(attr *NfsProfileDetailSlice) {
	p.nfsProfileDetails = attr
}

func (p *GlusterVolumeProfileDetails) NfsProfileDetails() (*NfsProfileDetailSlice, bool) {
	if p.nfsProfileDetails != nil {
		return p.nfsProfileDetails, true
	}
	return nil, false
}

func (p *GlusterVolumeProfileDetails) MustNfsProfileDetails() *NfsProfileDetailSlice {
	if p.nfsProfileDetails == nil {
		panic("the nfsProfileDetails must not be nil, please use NfsProfileDetails() function instead")
	}
	return p.nfsProfileDetails
}

type RegistrationVnicProfileMapping struct {
	Struct
	from *VnicProfile
	to   *VnicProfile
}

func (p *RegistrationVnicProfileMapping) SetFrom(attr *VnicProfile) {
	p.from = attr
}

func (p *RegistrationVnicProfileMapping) From() (*VnicProfile, bool) {
	if p.from != nil {
		return p.from, true
	}
	return nil, false
}

func (p *RegistrationVnicProfileMapping) MustFrom() *VnicProfile {
	if p.from == nil {
		panic("the from must not be nil, please use From() function instead")
	}
	return p.from
}

func (p *RegistrationVnicProfileMapping) SetTo(attr *VnicProfile) {
	p.to = attr
}

func (p *RegistrationVnicProfileMapping) To() (*VnicProfile, bool) {
	if p.to != nil {
		return p.to, true
	}
	return nil, false
}

func (p *RegistrationVnicProfileMapping) MustTo() *VnicProfile {
	if p.to == nil {
		panic("the to must not be nil, please use To() function instead")
	}
	return p.to
}

type Network struct {
	Struct
	cluster                         *Cluster
	comment                         *string
	dataCenter                      *DataCenter
	description                     *string
	display                         *bool
	dnsResolverConfiguration        *DnsResolverConfiguration
	externalProvider                *OpenStackNetworkProvider
	externalProviderPhysicalNetwork *Network
	id                              *string
	ip                              *Ip
	mtu                             *int64
	name                            *string
	networkLabels                   *NetworkLabelSlice
	permissions                     *PermissionSlice
	portIsolation                   *bool
	profileRequired                 *bool
	qos                             *Qos
	required                        *bool
	status                          *NetworkStatus
	stp                             *bool
	usages                          []NetworkUsage
	vdsmName                        *string
	vlan                            *Vlan
	vnicProfiles                    *VnicProfileSlice
}

func (p *Network) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *Network) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *Network) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *Network) SetComment(attr string) {
	p.comment = &attr
}

func (p *Network) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Network) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Network) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *Network) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *Network) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *Network) SetDescription(attr string) {
	p.description = &attr
}

func (p *Network) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Network) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Network) SetDisplay(attr bool) {
	p.display = &attr
}

func (p *Network) Display() (bool, bool) {
	if p.display != nil {
		return *p.display, true
	}
	var zero bool
	return zero, false
}

func (p *Network) MustDisplay() bool {
	if p.display == nil {
		panic("the display must not be nil, please use Display() function instead")
	}
	return *p.display
}

func (p *Network) SetDnsResolverConfiguration(attr *DnsResolverConfiguration) {
	p.dnsResolverConfiguration = attr
}

func (p *Network) DnsResolverConfiguration() (*DnsResolverConfiguration, bool) {
	if p.dnsResolverConfiguration != nil {
		return p.dnsResolverConfiguration, true
	}
	return nil, false
}

func (p *Network) MustDnsResolverConfiguration() *DnsResolverConfiguration {
	if p.dnsResolverConfiguration == nil {
		panic("the dnsResolverConfiguration must not be nil, please use DnsResolverConfiguration() function instead")
	}
	return p.dnsResolverConfiguration
}

func (p *Network) SetExternalProvider(attr *OpenStackNetworkProvider) {
	p.externalProvider = attr
}

func (p *Network) ExternalProvider() (*OpenStackNetworkProvider, bool) {
	if p.externalProvider != nil {
		return p.externalProvider, true
	}
	return nil, false
}

func (p *Network) MustExternalProvider() *OpenStackNetworkProvider {
	if p.externalProvider == nil {
		panic("the externalProvider must not be nil, please use ExternalProvider() function instead")
	}
	return p.externalProvider
}

func (p *Network) SetExternalProviderPhysicalNetwork(attr *Network) {
	p.externalProviderPhysicalNetwork = attr
}

func (p *Network) ExternalProviderPhysicalNetwork() (*Network, bool) {
	if p.externalProviderPhysicalNetwork != nil {
		return p.externalProviderPhysicalNetwork, true
	}
	return nil, false
}

func (p *Network) MustExternalProviderPhysicalNetwork() *Network {
	if p.externalProviderPhysicalNetwork == nil {
		panic("the externalProviderPhysicalNetwork must not be nil, please use ExternalProviderPhysicalNetwork() function instead")
	}
	return p.externalProviderPhysicalNetwork
}

func (p *Network) SetId(attr string) {
	p.id = &attr
}

func (p *Network) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Network) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Network) SetIp(attr *Ip) {
	p.ip = attr
}

func (p *Network) Ip() (*Ip, bool) {
	if p.ip != nil {
		return p.ip, true
	}
	return nil, false
}

func (p *Network) MustIp() *Ip {
	if p.ip == nil {
		panic("the ip must not be nil, please use Ip() function instead")
	}
	return p.ip
}

func (p *Network) SetMtu(attr int64) {
	p.mtu = &attr
}

func (p *Network) Mtu() (int64, bool) {
	if p.mtu != nil {
		return *p.mtu, true
	}
	var zero int64
	return zero, false
}

func (p *Network) MustMtu() int64 {
	if p.mtu == nil {
		panic("the mtu must not be nil, please use Mtu() function instead")
	}
	return *p.mtu
}

func (p *Network) SetName(attr string) {
	p.name = &attr
}

func (p *Network) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Network) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Network) SetNetworkLabels(attr *NetworkLabelSlice) {
	p.networkLabels = attr
}

func (p *Network) NetworkLabels() (*NetworkLabelSlice, bool) {
	if p.networkLabels != nil {
		return p.networkLabels, true
	}
	return nil, false
}

func (p *Network) MustNetworkLabels() *NetworkLabelSlice {
	if p.networkLabels == nil {
		panic("the networkLabels must not be nil, please use NetworkLabels() function instead")
	}
	return p.networkLabels
}

func (p *Network) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *Network) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *Network) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *Network) SetPortIsolation(attr bool) {
	p.portIsolation = &attr
}

func (p *Network) PortIsolation() (bool, bool) {
	if p.portIsolation != nil {
		return *p.portIsolation, true
	}
	var zero bool
	return zero, false
}

func (p *Network) MustPortIsolation() bool {
	if p.portIsolation == nil {
		panic("the portIsolation must not be nil, please use PortIsolation() function instead")
	}
	return *p.portIsolation
}

func (p *Network) SetProfileRequired(attr bool) {
	p.profileRequired = &attr
}

func (p *Network) ProfileRequired() (bool, bool) {
	if p.profileRequired != nil {
		return *p.profileRequired, true
	}
	var zero bool
	return zero, false
}

func (p *Network) MustProfileRequired() bool {
	if p.profileRequired == nil {
		panic("the profileRequired must not be nil, please use ProfileRequired() function instead")
	}
	return *p.profileRequired
}

func (p *Network) SetQos(attr *Qos) {
	p.qos = attr
}

func (p *Network) Qos() (*Qos, bool) {
	if p.qos != nil {
		return p.qos, true
	}
	return nil, false
}

func (p *Network) MustQos() *Qos {
	if p.qos == nil {
		panic("the qos must not be nil, please use Qos() function instead")
	}
	return p.qos
}

func (p *Network) SetRequired(attr bool) {
	p.required = &attr
}

func (p *Network) Required() (bool, bool) {
	if p.required != nil {
		return *p.required, true
	}
	var zero bool
	return zero, false
}

func (p *Network) MustRequired() bool {
	if p.required == nil {
		panic("the required must not be nil, please use Required() function instead")
	}
	return *p.required
}

func (p *Network) SetStatus(attr NetworkStatus) {
	p.status = &attr
}

func (p *Network) Status() (NetworkStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero NetworkStatus
	return zero, false
}

func (p *Network) MustStatus() NetworkStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *Network) SetStp(attr bool) {
	p.stp = &attr
}

func (p *Network) Stp() (bool, bool) {
	if p.stp != nil {
		return *p.stp, true
	}
	var zero bool
	return zero, false
}

func (p *Network) MustStp() bool {
	if p.stp == nil {
		panic("the stp must not be nil, please use Stp() function instead")
	}
	return *p.stp
}

func (p *Network) SetUsages(attr []NetworkUsage) {
	p.usages = attr
}

func (p *Network) Usages() ([]NetworkUsage, bool) {
	if p.usages != nil {
		return p.usages, true
	}
	return nil, false
}

func (p *Network) MustUsages() []NetworkUsage {
	if p.usages == nil {
		panic("the usages must not be nil, please use Usages() function instead")
	}
	return p.usages
}

func (p *Network) SetVdsmName(attr string) {
	p.vdsmName = &attr
}

func (p *Network) VdsmName() (string, bool) {
	if p.vdsmName != nil {
		return *p.vdsmName, true
	}
	var zero string
	return zero, false
}

func (p *Network) MustVdsmName() string {
	if p.vdsmName == nil {
		panic("the vdsmName must not be nil, please use VdsmName() function instead")
	}
	return *p.vdsmName
}

func (p *Network) SetVlan(attr *Vlan) {
	p.vlan = attr
}

func (p *Network) Vlan() (*Vlan, bool) {
	if p.vlan != nil {
		return p.vlan, true
	}
	return nil, false
}

func (p *Network) MustVlan() *Vlan {
	if p.vlan == nil {
		panic("the vlan must not be nil, please use Vlan() function instead")
	}
	return p.vlan
}

func (p *Network) SetVnicProfiles(attr *VnicProfileSlice) {
	p.vnicProfiles = attr
}

func (p *Network) VnicProfiles() (*VnicProfileSlice, bool) {
	if p.vnicProfiles != nil {
		return p.vnicProfiles, true
	}
	return nil, false
}

func (p *Network) MustVnicProfiles() *VnicProfileSlice {
	if p.vnicProfiles == nil {
		panic("the vnicProfiles must not be nil, please use VnicProfiles() function instead")
	}
	return p.vnicProfiles
}

type ClusterLevel struct {
	Struct
	clusterFeatures *ClusterFeatureSlice
	comment         *string
	cpuTypes        *CpuTypeSlice
	description     *string
	id              *string
	name            *string
	permits         *PermitSlice
}

func (p *ClusterLevel) SetClusterFeatures(attr *ClusterFeatureSlice) {
	p.clusterFeatures = attr
}

func (p *ClusterLevel) ClusterFeatures() (*ClusterFeatureSlice, bool) {
	if p.clusterFeatures != nil {
		return p.clusterFeatures, true
	}
	return nil, false
}

func (p *ClusterLevel) MustClusterFeatures() *ClusterFeatureSlice {
	if p.clusterFeatures == nil {
		panic("the clusterFeatures must not be nil, please use ClusterFeatures() function instead")
	}
	return p.clusterFeatures
}

func (p *ClusterLevel) SetComment(attr string) {
	p.comment = &attr
}

func (p *ClusterLevel) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ClusterLevel) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ClusterLevel) SetCpuTypes(attr *CpuTypeSlice) {
	p.cpuTypes = attr
}

func (p *ClusterLevel) CpuTypes() (*CpuTypeSlice, bool) {
	if p.cpuTypes != nil {
		return p.cpuTypes, true
	}
	return nil, false
}

func (p *ClusterLevel) MustCpuTypes() *CpuTypeSlice {
	if p.cpuTypes == nil {
		panic("the cpuTypes must not be nil, please use CpuTypes() function instead")
	}
	return p.cpuTypes
}

func (p *ClusterLevel) SetDescription(attr string) {
	p.description = &attr
}

func (p *ClusterLevel) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ClusterLevel) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ClusterLevel) SetId(attr string) {
	p.id = &attr
}

func (p *ClusterLevel) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ClusterLevel) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ClusterLevel) SetName(attr string) {
	p.name = &attr
}

func (p *ClusterLevel) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ClusterLevel) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ClusterLevel) SetPermits(attr *PermitSlice) {
	p.permits = attr
}

func (p *ClusterLevel) Permits() (*PermitSlice, bool) {
	if p.permits != nil {
		return p.permits, true
	}
	return nil, false
}

func (p *ClusterLevel) MustPermits() *PermitSlice {
	if p.permits == nil {
		panic("the permits must not be nil, please use Permits() function instead")
	}
	return p.permits
}

type PowerManagement struct {
	Struct
	address            *string
	agents             *AgentSlice
	automaticPmEnabled *bool
	enabled            *bool
	kdumpDetection     *bool
	options            *OptionSlice
	password           *string
	pmProxies          *PmProxySlice
	status             *PowerManagementStatus
	type_              *string
	username           *string
}

func (p *PowerManagement) SetAddress(attr string) {
	p.address = &attr
}

func (p *PowerManagement) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *PowerManagement) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *PowerManagement) SetAgents(attr *AgentSlice) {
	p.agents = attr
}

func (p *PowerManagement) Agents() (*AgentSlice, bool) {
	if p.agents != nil {
		return p.agents, true
	}
	return nil, false
}

func (p *PowerManagement) MustAgents() *AgentSlice {
	if p.agents == nil {
		panic("the agents must not be nil, please use Agents() function instead")
	}
	return p.agents
}

func (p *PowerManagement) SetAutomaticPmEnabled(attr bool) {
	p.automaticPmEnabled = &attr
}

func (p *PowerManagement) AutomaticPmEnabled() (bool, bool) {
	if p.automaticPmEnabled != nil {
		return *p.automaticPmEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *PowerManagement) MustAutomaticPmEnabled() bool {
	if p.automaticPmEnabled == nil {
		panic("the automaticPmEnabled must not be nil, please use AutomaticPmEnabled() function instead")
	}
	return *p.automaticPmEnabled
}

func (p *PowerManagement) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *PowerManagement) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *PowerManagement) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

func (p *PowerManagement) SetKdumpDetection(attr bool) {
	p.kdumpDetection = &attr
}

func (p *PowerManagement) KdumpDetection() (bool, bool) {
	if p.kdumpDetection != nil {
		return *p.kdumpDetection, true
	}
	var zero bool
	return zero, false
}

func (p *PowerManagement) MustKdumpDetection() bool {
	if p.kdumpDetection == nil {
		panic("the kdumpDetection must not be nil, please use KdumpDetection() function instead")
	}
	return *p.kdumpDetection
}

func (p *PowerManagement) SetOptions(attr *OptionSlice) {
	p.options = attr
}

func (p *PowerManagement) Options() (*OptionSlice, bool) {
	if p.options != nil {
		return p.options, true
	}
	return nil, false
}

func (p *PowerManagement) MustOptions() *OptionSlice {
	if p.options == nil {
		panic("the options must not be nil, please use Options() function instead")
	}
	return p.options
}

func (p *PowerManagement) SetPassword(attr string) {
	p.password = &attr
}

func (p *PowerManagement) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *PowerManagement) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *PowerManagement) SetPmProxies(attr *PmProxySlice) {
	p.pmProxies = attr
}

func (p *PowerManagement) PmProxies() (*PmProxySlice, bool) {
	if p.pmProxies != nil {
		return p.pmProxies, true
	}
	return nil, false
}

func (p *PowerManagement) MustPmProxies() *PmProxySlice {
	if p.pmProxies == nil {
		panic("the pmProxies must not be nil, please use PmProxies() function instead")
	}
	return p.pmProxies
}

func (p *PowerManagement) SetStatus(attr PowerManagementStatus) {
	p.status = &attr
}

func (p *PowerManagement) Status() (PowerManagementStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero PowerManagementStatus
	return zero, false
}

func (p *PowerManagement) MustStatus() PowerManagementStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *PowerManagement) SetType(attr string) {
	p.type_ = &attr
}

func (p *PowerManagement) Type() (string, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero string
	return zero, false
}

func (p *PowerManagement) MustType() string {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *PowerManagement) SetUsername(attr string) {
	p.username = &attr
}

func (p *PowerManagement) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *PowerManagement) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

type AffinityGroup struct {
	Struct
	cluster     *Cluster
	comment     *string
	description *string
	enforcing   *bool
	hostLabels  *AffinityLabelSlice
	hosts       *HostSlice
	hostsRule   *AffinityRule
	id          *string
	name        *string
	positive    *bool
	priority    *float64
	vmLabels    *AffinityLabelSlice
	vms         *VmSlice
	vmsRule     *AffinityRule
}

func (p *AffinityGroup) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *AffinityGroup) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *AffinityGroup) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *AffinityGroup) SetComment(attr string) {
	p.comment = &attr
}

func (p *AffinityGroup) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *AffinityGroup) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *AffinityGroup) SetDescription(attr string) {
	p.description = &attr
}

func (p *AffinityGroup) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *AffinityGroup) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *AffinityGroup) SetEnforcing(attr bool) {
	p.enforcing = &attr
}

func (p *AffinityGroup) Enforcing() (bool, bool) {
	if p.enforcing != nil {
		return *p.enforcing, true
	}
	var zero bool
	return zero, false
}

func (p *AffinityGroup) MustEnforcing() bool {
	if p.enforcing == nil {
		panic("the enforcing must not be nil, please use Enforcing() function instead")
	}
	return *p.enforcing
}

func (p *AffinityGroup) SetHostLabels(attr *AffinityLabelSlice) {
	p.hostLabels = attr
}

func (p *AffinityGroup) HostLabels() (*AffinityLabelSlice, bool) {
	if p.hostLabels != nil {
		return p.hostLabels, true
	}
	return nil, false
}

func (p *AffinityGroup) MustHostLabels() *AffinityLabelSlice {
	if p.hostLabels == nil {
		panic("the hostLabels must not be nil, please use HostLabels() function instead")
	}
	return p.hostLabels
}

func (p *AffinityGroup) SetHosts(attr *HostSlice) {
	p.hosts = attr
}

func (p *AffinityGroup) Hosts() (*HostSlice, bool) {
	if p.hosts != nil {
		return p.hosts, true
	}
	return nil, false
}

func (p *AffinityGroup) MustHosts() *HostSlice {
	if p.hosts == nil {
		panic("the hosts must not be nil, please use Hosts() function instead")
	}
	return p.hosts
}

func (p *AffinityGroup) SetHostsRule(attr *AffinityRule) {
	p.hostsRule = attr
}

func (p *AffinityGroup) HostsRule() (*AffinityRule, bool) {
	if p.hostsRule != nil {
		return p.hostsRule, true
	}
	return nil, false
}

func (p *AffinityGroup) MustHostsRule() *AffinityRule {
	if p.hostsRule == nil {
		panic("the hostsRule must not be nil, please use HostsRule() function instead")
	}
	return p.hostsRule
}

func (p *AffinityGroup) SetId(attr string) {
	p.id = &attr
}

func (p *AffinityGroup) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *AffinityGroup) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *AffinityGroup) SetName(attr string) {
	p.name = &attr
}

func (p *AffinityGroup) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *AffinityGroup) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *AffinityGroup) SetPositive(attr bool) {
	p.positive = &attr
}

func (p *AffinityGroup) Positive() (bool, bool) {
	if p.positive != nil {
		return *p.positive, true
	}
	var zero bool
	return zero, false
}

func (p *AffinityGroup) MustPositive() bool {
	if p.positive == nil {
		panic("the positive must not be nil, please use Positive() function instead")
	}
	return *p.positive
}

func (p *AffinityGroup) SetPriority(attr float64) {
	p.priority = &attr
}

func (p *AffinityGroup) Priority() (float64, bool) {
	if p.priority != nil {
		return *p.priority, true
	}
	var zero float64
	return zero, false
}

func (p *AffinityGroup) MustPriority() float64 {
	if p.priority == nil {
		panic("the priority must not be nil, please use Priority() function instead")
	}
	return *p.priority
}

func (p *AffinityGroup) SetVmLabels(attr *AffinityLabelSlice) {
	p.vmLabels = attr
}

func (p *AffinityGroup) VmLabels() (*AffinityLabelSlice, bool) {
	if p.vmLabels != nil {
		return p.vmLabels, true
	}
	return nil, false
}

func (p *AffinityGroup) MustVmLabels() *AffinityLabelSlice {
	if p.vmLabels == nil {
		panic("the vmLabels must not be nil, please use VmLabels() function instead")
	}
	return p.vmLabels
}

func (p *AffinityGroup) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *AffinityGroup) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *AffinityGroup) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

func (p *AffinityGroup) SetVmsRule(attr *AffinityRule) {
	p.vmsRule = attr
}

func (p *AffinityGroup) VmsRule() (*AffinityRule, bool) {
	if p.vmsRule != nil {
		return p.vmsRule, true
	}
	return nil, false
}

func (p *AffinityGroup) MustVmsRule() *AffinityRule {
	if p.vmsRule == nil {
		panic("the vmsRule must not be nil, please use VmsRule() function instead")
	}
	return p.vmsRule
}

type HardwareInformation struct {
	Struct
	family              *string
	manufacturer        *string
	productName         *string
	serialNumber        *string
	supportedRngSources []RngSource
	uuid                *string
	version             *string
}

func (p *HardwareInformation) SetFamily(attr string) {
	p.family = &attr
}

func (p *HardwareInformation) Family() (string, bool) {
	if p.family != nil {
		return *p.family, true
	}
	var zero string
	return zero, false
}

func (p *HardwareInformation) MustFamily() string {
	if p.family == nil {
		panic("the family must not be nil, please use Family() function instead")
	}
	return *p.family
}

func (p *HardwareInformation) SetManufacturer(attr string) {
	p.manufacturer = &attr
}

func (p *HardwareInformation) Manufacturer() (string, bool) {
	if p.manufacturer != nil {
		return *p.manufacturer, true
	}
	var zero string
	return zero, false
}

func (p *HardwareInformation) MustManufacturer() string {
	if p.manufacturer == nil {
		panic("the manufacturer must not be nil, please use Manufacturer() function instead")
	}
	return *p.manufacturer
}

func (p *HardwareInformation) SetProductName(attr string) {
	p.productName = &attr
}

func (p *HardwareInformation) ProductName() (string, bool) {
	if p.productName != nil {
		return *p.productName, true
	}
	var zero string
	return zero, false
}

func (p *HardwareInformation) MustProductName() string {
	if p.productName == nil {
		panic("the productName must not be nil, please use ProductName() function instead")
	}
	return *p.productName
}

func (p *HardwareInformation) SetSerialNumber(attr string) {
	p.serialNumber = &attr
}

func (p *HardwareInformation) SerialNumber() (string, bool) {
	if p.serialNumber != nil {
		return *p.serialNumber, true
	}
	var zero string
	return zero, false
}

func (p *HardwareInformation) MustSerialNumber() string {
	if p.serialNumber == nil {
		panic("the serialNumber must not be nil, please use SerialNumber() function instead")
	}
	return *p.serialNumber
}

func (p *HardwareInformation) SetSupportedRngSources(attr []RngSource) {
	p.supportedRngSources = attr
}

func (p *HardwareInformation) SupportedRngSources() ([]RngSource, bool) {
	if p.supportedRngSources != nil {
		return p.supportedRngSources, true
	}
	return nil, false
}

func (p *HardwareInformation) MustSupportedRngSources() []RngSource {
	if p.supportedRngSources == nil {
		panic("the supportedRngSources must not be nil, please use SupportedRngSources() function instead")
	}
	return p.supportedRngSources
}

func (p *HardwareInformation) SetUuid(attr string) {
	p.uuid = &attr
}

func (p *HardwareInformation) Uuid() (string, bool) {
	if p.uuid != nil {
		return *p.uuid, true
	}
	var zero string
	return zero, false
}

func (p *HardwareInformation) MustUuid() string {
	if p.uuid == nil {
		panic("the uuid must not be nil, please use Uuid() function instead")
	}
	return *p.uuid
}

func (p *HardwareInformation) SetVersion(attr string) {
	p.version = &attr
}

func (p *HardwareInformation) Version() (string, bool) {
	if p.version != nil {
		return *p.version, true
	}
	var zero string
	return zero, false
}

func (p *HardwareInformation) MustVersion() string {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return *p.version
}

type Checkpoint struct {
	Struct
	comment      *string
	creationDate *time.Time
	description  *string
	disks        *DiskSlice
	id           *string
	name         *string
	parentId     *string
	vm           *Vm
}

func (p *Checkpoint) SetComment(attr string) {
	p.comment = &attr
}

func (p *Checkpoint) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Checkpoint) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Checkpoint) SetCreationDate(attr time.Time) {
	p.creationDate = &attr
}

func (p *Checkpoint) CreationDate() (time.Time, bool) {
	if p.creationDate != nil {
		return *p.creationDate, true
	}
	var zero time.Time
	return zero, false
}

func (p *Checkpoint) MustCreationDate() time.Time {
	if p.creationDate == nil {
		panic("the creationDate must not be nil, please use CreationDate() function instead")
	}
	return *p.creationDate
}

func (p *Checkpoint) SetDescription(attr string) {
	p.description = &attr
}

func (p *Checkpoint) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Checkpoint) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Checkpoint) SetDisks(attr *DiskSlice) {
	p.disks = attr
}

func (p *Checkpoint) Disks() (*DiskSlice, bool) {
	if p.disks != nil {
		return p.disks, true
	}
	return nil, false
}

func (p *Checkpoint) MustDisks() *DiskSlice {
	if p.disks == nil {
		panic("the disks must not be nil, please use Disks() function instead")
	}
	return p.disks
}

func (p *Checkpoint) SetId(attr string) {
	p.id = &attr
}

func (p *Checkpoint) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Checkpoint) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Checkpoint) SetName(attr string) {
	p.name = &attr
}

func (p *Checkpoint) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Checkpoint) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Checkpoint) SetParentId(attr string) {
	p.parentId = &attr
}

func (p *Checkpoint) ParentId() (string, bool) {
	if p.parentId != nil {
		return *p.parentId, true
	}
	var zero string
	return zero, false
}

func (p *Checkpoint) MustParentId() string {
	if p.parentId == nil {
		panic("the parentId must not be nil, please use ParentId() function instead")
	}
	return *p.parentId
}

func (p *Checkpoint) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Checkpoint) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Checkpoint) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type Balance struct {
	Struct
	comment              *string
	description          *string
	id                   *string
	name                 *string
	schedulingPolicy     *SchedulingPolicy
	schedulingPolicyUnit *SchedulingPolicyUnit
}

func (p *Balance) SetComment(attr string) {
	p.comment = &attr
}

func (p *Balance) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Balance) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Balance) SetDescription(attr string) {
	p.description = &attr
}

func (p *Balance) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Balance) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Balance) SetId(attr string) {
	p.id = &attr
}

func (p *Balance) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Balance) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Balance) SetName(attr string) {
	p.name = &attr
}

func (p *Balance) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Balance) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Balance) SetSchedulingPolicy(attr *SchedulingPolicy) {
	p.schedulingPolicy = attr
}

func (p *Balance) SchedulingPolicy() (*SchedulingPolicy, bool) {
	if p.schedulingPolicy != nil {
		return p.schedulingPolicy, true
	}
	return nil, false
}

func (p *Balance) MustSchedulingPolicy() *SchedulingPolicy {
	if p.schedulingPolicy == nil {
		panic("the schedulingPolicy must not be nil, please use SchedulingPolicy() function instead")
	}
	return p.schedulingPolicy
}

func (p *Balance) SetSchedulingPolicyUnit(attr *SchedulingPolicyUnit) {
	p.schedulingPolicyUnit = attr
}

func (p *Balance) SchedulingPolicyUnit() (*SchedulingPolicyUnit, bool) {
	if p.schedulingPolicyUnit != nil {
		return p.schedulingPolicyUnit, true
	}
	return nil, false
}

func (p *Balance) MustSchedulingPolicyUnit() *SchedulingPolicyUnit {
	if p.schedulingPolicyUnit == nil {
		panic("the schedulingPolicyUnit must not be nil, please use SchedulingPolicyUnit() function instead")
	}
	return p.schedulingPolicyUnit
}

type Io struct {
	Struct
	threads *int64
}

func (p *Io) SetThreads(attr int64) {
	p.threads = &attr
}

func (p *Io) Threads() (int64, bool) {
	if p.threads != nil {
		return *p.threads, true
	}
	var zero int64
	return zero, false
}

func (p *Io) MustThreads() int64 {
	if p.threads == nil {
		panic("the threads must not be nil, please use Threads() function instead")
	}
	return *p.threads
}

type GlusterClient struct {
	Struct
	bytesRead    *int64
	bytesWritten *int64
	clientPort   *int64
	hostName     *string
}

func (p *GlusterClient) SetBytesRead(attr int64) {
	p.bytesRead = &attr
}

func (p *GlusterClient) BytesRead() (int64, bool) {
	if p.bytesRead != nil {
		return *p.bytesRead, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterClient) MustBytesRead() int64 {
	if p.bytesRead == nil {
		panic("the bytesRead must not be nil, please use BytesRead() function instead")
	}
	return *p.bytesRead
}

func (p *GlusterClient) SetBytesWritten(attr int64) {
	p.bytesWritten = &attr
}

func (p *GlusterClient) BytesWritten() (int64, bool) {
	if p.bytesWritten != nil {
		return *p.bytesWritten, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterClient) MustBytesWritten() int64 {
	if p.bytesWritten == nil {
		panic("the bytesWritten must not be nil, please use BytesWritten() function instead")
	}
	return *p.bytesWritten
}

func (p *GlusterClient) SetClientPort(attr int64) {
	p.clientPort = &attr
}

func (p *GlusterClient) ClientPort() (int64, bool) {
	if p.clientPort != nil {
		return *p.clientPort, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterClient) MustClientPort() int64 {
	if p.clientPort == nil {
		panic("the clientPort must not be nil, please use ClientPort() function instead")
	}
	return *p.clientPort
}

func (p *GlusterClient) SetHostName(attr string) {
	p.hostName = &attr
}

func (p *GlusterClient) HostName() (string, bool) {
	if p.hostName != nil {
		return *p.hostName, true
	}
	var zero string
	return zero, false
}

func (p *GlusterClient) MustHostName() string {
	if p.hostName == nil {
		panic("the hostName must not be nil, please use HostName() function instead")
	}
	return *p.hostName
}

type GlusterMemoryPool struct {
	Struct
	allocCount  *int64
	coldCount   *int64
	comment     *string
	description *string
	hotCount    *int64
	id          *string
	maxAlloc    *int64
	maxStdalloc *int64
	name        *string
	paddedSize  *int64
	poolMisses  *int64
	type_       *string
}

func (p *GlusterMemoryPool) SetAllocCount(attr int64) {
	p.allocCount = &attr
}

func (p *GlusterMemoryPool) AllocCount() (int64, bool) {
	if p.allocCount != nil {
		return *p.allocCount, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterMemoryPool) MustAllocCount() int64 {
	if p.allocCount == nil {
		panic("the allocCount must not be nil, please use AllocCount() function instead")
	}
	return *p.allocCount
}

func (p *GlusterMemoryPool) SetColdCount(attr int64) {
	p.coldCount = &attr
}

func (p *GlusterMemoryPool) ColdCount() (int64, bool) {
	if p.coldCount != nil {
		return *p.coldCount, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterMemoryPool) MustColdCount() int64 {
	if p.coldCount == nil {
		panic("the coldCount must not be nil, please use ColdCount() function instead")
	}
	return *p.coldCount
}

func (p *GlusterMemoryPool) SetComment(attr string) {
	p.comment = &attr
}

func (p *GlusterMemoryPool) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *GlusterMemoryPool) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *GlusterMemoryPool) SetDescription(attr string) {
	p.description = &attr
}

func (p *GlusterMemoryPool) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *GlusterMemoryPool) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *GlusterMemoryPool) SetHotCount(attr int64) {
	p.hotCount = &attr
}

func (p *GlusterMemoryPool) HotCount() (int64, bool) {
	if p.hotCount != nil {
		return *p.hotCount, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterMemoryPool) MustHotCount() int64 {
	if p.hotCount == nil {
		panic("the hotCount must not be nil, please use HotCount() function instead")
	}
	return *p.hotCount
}

func (p *GlusterMemoryPool) SetId(attr string) {
	p.id = &attr
}

func (p *GlusterMemoryPool) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *GlusterMemoryPool) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *GlusterMemoryPool) SetMaxAlloc(attr int64) {
	p.maxAlloc = &attr
}

func (p *GlusterMemoryPool) MaxAlloc() (int64, bool) {
	if p.maxAlloc != nil {
		return *p.maxAlloc, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterMemoryPool) MustMaxAlloc() int64 {
	if p.maxAlloc == nil {
		panic("the maxAlloc must not be nil, please use MaxAlloc() function instead")
	}
	return *p.maxAlloc
}

func (p *GlusterMemoryPool) SetMaxStdalloc(attr int64) {
	p.maxStdalloc = &attr
}

func (p *GlusterMemoryPool) MaxStdalloc() (int64, bool) {
	if p.maxStdalloc != nil {
		return *p.maxStdalloc, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterMemoryPool) MustMaxStdalloc() int64 {
	if p.maxStdalloc == nil {
		panic("the maxStdalloc must not be nil, please use MaxStdalloc() function instead")
	}
	return *p.maxStdalloc
}

func (p *GlusterMemoryPool) SetName(attr string) {
	p.name = &attr
}

func (p *GlusterMemoryPool) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *GlusterMemoryPool) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *GlusterMemoryPool) SetPaddedSize(attr int64) {
	p.paddedSize = &attr
}

func (p *GlusterMemoryPool) PaddedSize() (int64, bool) {
	if p.paddedSize != nil {
		return *p.paddedSize, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterMemoryPool) MustPaddedSize() int64 {
	if p.paddedSize == nil {
		panic("the paddedSize must not be nil, please use PaddedSize() function instead")
	}
	return *p.paddedSize
}

func (p *GlusterMemoryPool) SetPoolMisses(attr int64) {
	p.poolMisses = &attr
}

func (p *GlusterMemoryPool) PoolMisses() (int64, bool) {
	if p.poolMisses != nil {
		return *p.poolMisses, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterMemoryPool) MustPoolMisses() int64 {
	if p.poolMisses == nil {
		panic("the poolMisses must not be nil, please use PoolMisses() function instead")
	}
	return *p.poolMisses
}

func (p *GlusterMemoryPool) SetType(attr string) {
	p.type_ = &attr
}

func (p *GlusterMemoryPool) Type() (string, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero string
	return zero, false
}

func (p *GlusterMemoryPool) MustType() string {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type Initialization struct {
	Struct
	activeDirectoryOu        *string
	authorizedSshKeys        *string
	cloudInit                *CloudInit
	cloudInitNetworkProtocol *CloudInitNetworkProtocol
	configuration            *Configuration
	customScript             *string
	dnsSearch                *string
	dnsServers               *string
	domain                   *string
	hostName                 *string
	inputLocale              *string
	nicConfigurations        *NicConfigurationSlice
	orgName                  *string
	regenerateIds            *bool
	regenerateSshKeys        *bool
	rootPassword             *string
	systemLocale             *string
	timezone                 *string
	uiLanguage               *string
	userLocale               *string
	userName                 *string
	windowsLicenseKey        *string
}

func (p *Initialization) SetActiveDirectoryOu(attr string) {
	p.activeDirectoryOu = &attr
}

func (p *Initialization) ActiveDirectoryOu() (string, bool) {
	if p.activeDirectoryOu != nil {
		return *p.activeDirectoryOu, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustActiveDirectoryOu() string {
	if p.activeDirectoryOu == nil {
		panic("the activeDirectoryOu must not be nil, please use ActiveDirectoryOu() function instead")
	}
	return *p.activeDirectoryOu
}

func (p *Initialization) SetAuthorizedSshKeys(attr string) {
	p.authorizedSshKeys = &attr
}

func (p *Initialization) AuthorizedSshKeys() (string, bool) {
	if p.authorizedSshKeys != nil {
		return *p.authorizedSshKeys, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustAuthorizedSshKeys() string {
	if p.authorizedSshKeys == nil {
		panic("the authorizedSshKeys must not be nil, please use AuthorizedSshKeys() function instead")
	}
	return *p.authorizedSshKeys
}

func (p *Initialization) SetCloudInit(attr *CloudInit) {
	p.cloudInit = attr
}

func (p *Initialization) CloudInit() (*CloudInit, bool) {
	if p.cloudInit != nil {
		return p.cloudInit, true
	}
	return nil, false
}

func (p *Initialization) MustCloudInit() *CloudInit {
	if p.cloudInit == nil {
		panic("the cloudInit must not be nil, please use CloudInit() function instead")
	}
	return p.cloudInit
}

func (p *Initialization) SetCloudInitNetworkProtocol(attr CloudInitNetworkProtocol) {
	p.cloudInitNetworkProtocol = &attr
}

func (p *Initialization) CloudInitNetworkProtocol() (CloudInitNetworkProtocol, bool) {
	if p.cloudInitNetworkProtocol != nil {
		return *p.cloudInitNetworkProtocol, true
	}
	var zero CloudInitNetworkProtocol
	return zero, false
}

func (p *Initialization) MustCloudInitNetworkProtocol() CloudInitNetworkProtocol {
	if p.cloudInitNetworkProtocol == nil {
		panic("the cloudInitNetworkProtocol must not be nil, please use CloudInitNetworkProtocol() function instead")
	}
	return *p.cloudInitNetworkProtocol
}

func (p *Initialization) SetConfiguration(attr *Configuration) {
	p.configuration = attr
}

func (p *Initialization) Configuration() (*Configuration, bool) {
	if p.configuration != nil {
		return p.configuration, true
	}
	return nil, false
}

func (p *Initialization) MustConfiguration() *Configuration {
	if p.configuration == nil {
		panic("the configuration must not be nil, please use Configuration() function instead")
	}
	return p.configuration
}

func (p *Initialization) SetCustomScript(attr string) {
	p.customScript = &attr
}

func (p *Initialization) CustomScript() (string, bool) {
	if p.customScript != nil {
		return *p.customScript, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustCustomScript() string {
	if p.customScript == nil {
		panic("the customScript must not be nil, please use CustomScript() function instead")
	}
	return *p.customScript
}

func (p *Initialization) SetDnsSearch(attr string) {
	p.dnsSearch = &attr
}

func (p *Initialization) DnsSearch() (string, bool) {
	if p.dnsSearch != nil {
		return *p.dnsSearch, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustDnsSearch() string {
	if p.dnsSearch == nil {
		panic("the dnsSearch must not be nil, please use DnsSearch() function instead")
	}
	return *p.dnsSearch
}

func (p *Initialization) SetDnsServers(attr string) {
	p.dnsServers = &attr
}

func (p *Initialization) DnsServers() (string, bool) {
	if p.dnsServers != nil {
		return *p.dnsServers, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustDnsServers() string {
	if p.dnsServers == nil {
		panic("the dnsServers must not be nil, please use DnsServers() function instead")
	}
	return *p.dnsServers
}

func (p *Initialization) SetDomain(attr string) {
	p.domain = &attr
}

func (p *Initialization) Domain() (string, bool) {
	if p.domain != nil {
		return *p.domain, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustDomain() string {
	if p.domain == nil {
		panic("the domain must not be nil, please use Domain() function instead")
	}
	return *p.domain
}

func (p *Initialization) SetHostName(attr string) {
	p.hostName = &attr
}

func (p *Initialization) HostName() (string, bool) {
	if p.hostName != nil {
		return *p.hostName, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustHostName() string {
	if p.hostName == nil {
		panic("the hostName must not be nil, please use HostName() function instead")
	}
	return *p.hostName
}

func (p *Initialization) SetInputLocale(attr string) {
	p.inputLocale = &attr
}

func (p *Initialization) InputLocale() (string, bool) {
	if p.inputLocale != nil {
		return *p.inputLocale, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustInputLocale() string {
	if p.inputLocale == nil {
		panic("the inputLocale must not be nil, please use InputLocale() function instead")
	}
	return *p.inputLocale
}

func (p *Initialization) SetNicConfigurations(attr *NicConfigurationSlice) {
	p.nicConfigurations = attr
}

func (p *Initialization) NicConfigurations() (*NicConfigurationSlice, bool) {
	if p.nicConfigurations != nil {
		return p.nicConfigurations, true
	}
	return nil, false
}

func (p *Initialization) MustNicConfigurations() *NicConfigurationSlice {
	if p.nicConfigurations == nil {
		panic("the nicConfigurations must not be nil, please use NicConfigurations() function instead")
	}
	return p.nicConfigurations
}

func (p *Initialization) SetOrgName(attr string) {
	p.orgName = &attr
}

func (p *Initialization) OrgName() (string, bool) {
	if p.orgName != nil {
		return *p.orgName, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustOrgName() string {
	if p.orgName == nil {
		panic("the orgName must not be nil, please use OrgName() function instead")
	}
	return *p.orgName
}

func (p *Initialization) SetRegenerateIds(attr bool) {
	p.regenerateIds = &attr
}

func (p *Initialization) RegenerateIds() (bool, bool) {
	if p.regenerateIds != nil {
		return *p.regenerateIds, true
	}
	var zero bool
	return zero, false
}

func (p *Initialization) MustRegenerateIds() bool {
	if p.regenerateIds == nil {
		panic("the regenerateIds must not be nil, please use RegenerateIds() function instead")
	}
	return *p.regenerateIds
}

func (p *Initialization) SetRegenerateSshKeys(attr bool) {
	p.regenerateSshKeys = &attr
}

func (p *Initialization) RegenerateSshKeys() (bool, bool) {
	if p.regenerateSshKeys != nil {
		return *p.regenerateSshKeys, true
	}
	var zero bool
	return zero, false
}

func (p *Initialization) MustRegenerateSshKeys() bool {
	if p.regenerateSshKeys == nil {
		panic("the regenerateSshKeys must not be nil, please use RegenerateSshKeys() function instead")
	}
	return *p.regenerateSshKeys
}

func (p *Initialization) SetRootPassword(attr string) {
	p.rootPassword = &attr
}

func (p *Initialization) RootPassword() (string, bool) {
	if p.rootPassword != nil {
		return *p.rootPassword, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustRootPassword() string {
	if p.rootPassword == nil {
		panic("the rootPassword must not be nil, please use RootPassword() function instead")
	}
	return *p.rootPassword
}

func (p *Initialization) SetSystemLocale(attr string) {
	p.systemLocale = &attr
}

func (p *Initialization) SystemLocale() (string, bool) {
	if p.systemLocale != nil {
		return *p.systemLocale, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustSystemLocale() string {
	if p.systemLocale == nil {
		panic("the systemLocale must not be nil, please use SystemLocale() function instead")
	}
	return *p.systemLocale
}

func (p *Initialization) SetTimezone(attr string) {
	p.timezone = &attr
}

func (p *Initialization) Timezone() (string, bool) {
	if p.timezone != nil {
		return *p.timezone, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustTimezone() string {
	if p.timezone == nil {
		panic("the timezone must not be nil, please use Timezone() function instead")
	}
	return *p.timezone
}

func (p *Initialization) SetUiLanguage(attr string) {
	p.uiLanguage = &attr
}

func (p *Initialization) UiLanguage() (string, bool) {
	if p.uiLanguage != nil {
		return *p.uiLanguage, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustUiLanguage() string {
	if p.uiLanguage == nil {
		panic("the uiLanguage must not be nil, please use UiLanguage() function instead")
	}
	return *p.uiLanguage
}

func (p *Initialization) SetUserLocale(attr string) {
	p.userLocale = &attr
}

func (p *Initialization) UserLocale() (string, bool) {
	if p.userLocale != nil {
		return *p.userLocale, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustUserLocale() string {
	if p.userLocale == nil {
		panic("the userLocale must not be nil, please use UserLocale() function instead")
	}
	return *p.userLocale
}

func (p *Initialization) SetUserName(attr string) {
	p.userName = &attr
}

func (p *Initialization) UserName() (string, bool) {
	if p.userName != nil {
		return *p.userName, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustUserName() string {
	if p.userName == nil {
		panic("the userName must not be nil, please use UserName() function instead")
	}
	return *p.userName
}

func (p *Initialization) SetWindowsLicenseKey(attr string) {
	p.windowsLicenseKey = &attr
}

func (p *Initialization) WindowsLicenseKey() (string, bool) {
	if p.windowsLicenseKey != nil {
		return *p.windowsLicenseKey, true
	}
	var zero string
	return zero, false
}

func (p *Initialization) MustWindowsLicenseKey() string {
	if p.windowsLicenseKey == nil {
		panic("the windowsLicenseKey must not be nil, please use WindowsLicenseKey() function instead")
	}
	return *p.windowsLicenseKey
}

type NumaNode struct {
	Struct
	comment      *string
	cpu          *Cpu
	description  *string
	host         *Host
	id           *string
	index        *int64
	memory       *int64
	name         *string
	nodeDistance *string
	statistics   *StatisticSlice
}

func (p *NumaNode) SetComment(attr string) {
	p.comment = &attr
}

func (p *NumaNode) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *NumaNode) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *NumaNode) SetCpu(attr *Cpu) {
	p.cpu = attr
}

func (p *NumaNode) Cpu() (*Cpu, bool) {
	if p.cpu != nil {
		return p.cpu, true
	}
	return nil, false
}

func (p *NumaNode) MustCpu() *Cpu {
	if p.cpu == nil {
		panic("the cpu must not be nil, please use Cpu() function instead")
	}
	return p.cpu
}

func (p *NumaNode) SetDescription(attr string) {
	p.description = &attr
}

func (p *NumaNode) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *NumaNode) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *NumaNode) SetHost(attr *Host) {
	p.host = attr
}

func (p *NumaNode) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *NumaNode) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *NumaNode) SetId(attr string) {
	p.id = &attr
}

func (p *NumaNode) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *NumaNode) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *NumaNode) SetIndex(attr int64) {
	p.index = &attr
}

func (p *NumaNode) Index() (int64, bool) {
	if p.index != nil {
		return *p.index, true
	}
	var zero int64
	return zero, false
}

func (p *NumaNode) MustIndex() int64 {
	if p.index == nil {
		panic("the index must not be nil, please use Index() function instead")
	}
	return *p.index
}

func (p *NumaNode) SetMemory(attr int64) {
	p.memory = &attr
}

func (p *NumaNode) Memory() (int64, bool) {
	if p.memory != nil {
		return *p.memory, true
	}
	var zero int64
	return zero, false
}

func (p *NumaNode) MustMemory() int64 {
	if p.memory == nil {
		panic("the memory must not be nil, please use Memory() function instead")
	}
	return *p.memory
}

func (p *NumaNode) SetName(attr string) {
	p.name = &attr
}

func (p *NumaNode) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *NumaNode) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *NumaNode) SetNodeDistance(attr string) {
	p.nodeDistance = &attr
}

func (p *NumaNode) NodeDistance() (string, bool) {
	if p.nodeDistance != nil {
		return *p.nodeDistance, true
	}
	var zero string
	return zero, false
}

func (p *NumaNode) MustNodeDistance() string {
	if p.nodeDistance == nil {
		panic("the nodeDistance must not be nil, please use NodeDistance() function instead")
	}
	return *p.nodeDistance
}

func (p *NumaNode) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *NumaNode) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *NumaNode) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

type Mac struct {
	Struct
	address *string
}

func (p *Mac) SetAddress(attr string) {
	p.address = &attr
}

func (p *Mac) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *Mac) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

type NetworkConfiguration struct {
	Struct
	dns  *Dns
	nics *NicSlice
}

func (p *NetworkConfiguration) SetDns(attr *Dns) {
	p.dns = attr
}

func (p *NetworkConfiguration) Dns() (*Dns, bool) {
	if p.dns != nil {
		return p.dns, true
	}
	return nil, false
}

func (p *NetworkConfiguration) MustDns() *Dns {
	if p.dns == nil {
		panic("the dns must not be nil, please use Dns() function instead")
	}
	return p.dns
}

func (p *NetworkConfiguration) SetNics(attr *NicSlice) {
	p.nics = attr
}

func (p *NetworkConfiguration) Nics() (*NicSlice, bool) {
	if p.nics != nil {
		return p.nics, true
	}
	return nil, false
}

func (p *NetworkConfiguration) MustNics() *NicSlice {
	if p.nics == nil {
		panic("the nics must not be nil, please use Nics() function instead")
	}
	return p.nics
}

type ExternalDiscoveredHost struct {
	Struct
	comment              *string
	description          *string
	externalHostProvider *ExternalHostProvider
	id                   *string
	ip                   *string
	lastReport           *string
	mac                  *string
	name                 *string
	subnetName           *string
}

func (p *ExternalDiscoveredHost) SetComment(attr string) {
	p.comment = &attr
}

func (p *ExternalDiscoveredHost) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ExternalDiscoveredHost) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ExternalDiscoveredHost) SetDescription(attr string) {
	p.description = &attr
}

func (p *ExternalDiscoveredHost) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ExternalDiscoveredHost) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ExternalDiscoveredHost) SetExternalHostProvider(attr *ExternalHostProvider) {
	p.externalHostProvider = attr
}

func (p *ExternalDiscoveredHost) ExternalHostProvider() (*ExternalHostProvider, bool) {
	if p.externalHostProvider != nil {
		return p.externalHostProvider, true
	}
	return nil, false
}

func (p *ExternalDiscoveredHost) MustExternalHostProvider() *ExternalHostProvider {
	if p.externalHostProvider == nil {
		panic("the externalHostProvider must not be nil, please use ExternalHostProvider() function instead")
	}
	return p.externalHostProvider
}

func (p *ExternalDiscoveredHost) SetId(attr string) {
	p.id = &attr
}

func (p *ExternalDiscoveredHost) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ExternalDiscoveredHost) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ExternalDiscoveredHost) SetIp(attr string) {
	p.ip = &attr
}

func (p *ExternalDiscoveredHost) Ip() (string, bool) {
	if p.ip != nil {
		return *p.ip, true
	}
	var zero string
	return zero, false
}

func (p *ExternalDiscoveredHost) MustIp() string {
	if p.ip == nil {
		panic("the ip must not be nil, please use Ip() function instead")
	}
	return *p.ip
}

func (p *ExternalDiscoveredHost) SetLastReport(attr string) {
	p.lastReport = &attr
}

func (p *ExternalDiscoveredHost) LastReport() (string, bool) {
	if p.lastReport != nil {
		return *p.lastReport, true
	}
	var zero string
	return zero, false
}

func (p *ExternalDiscoveredHost) MustLastReport() string {
	if p.lastReport == nil {
		panic("the lastReport must not be nil, please use LastReport() function instead")
	}
	return *p.lastReport
}

func (p *ExternalDiscoveredHost) SetMac(attr string) {
	p.mac = &attr
}

func (p *ExternalDiscoveredHost) Mac() (string, bool) {
	if p.mac != nil {
		return *p.mac, true
	}
	var zero string
	return zero, false
}

func (p *ExternalDiscoveredHost) MustMac() string {
	if p.mac == nil {
		panic("the mac must not be nil, please use Mac() function instead")
	}
	return *p.mac
}

func (p *ExternalDiscoveredHost) SetName(attr string) {
	p.name = &attr
}

func (p *ExternalDiscoveredHost) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ExternalDiscoveredHost) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ExternalDiscoveredHost) SetSubnetName(attr string) {
	p.subnetName = &attr
}

func (p *ExternalDiscoveredHost) SubnetName() (string, bool) {
	if p.subnetName != nil {
		return *p.subnetName, true
	}
	var zero string
	return zero, false
}

func (p *ExternalDiscoveredHost) MustSubnetName() string {
	if p.subnetName == nil {
		panic("the subnetName must not be nil, please use SubnetName() function instead")
	}
	return *p.subnetName
}

type VmBase struct {
	Struct
	bios                        *Bios
	cluster                     *Cluster
	comment                     *string
	console                     *Console
	cpu                         *Cpu
	cpuProfile                  *CpuProfile
	cpuShares                   *int64
	creationTime                *time.Time
	customCompatibilityVersion  *Version
	customCpuModel              *string
	customEmulatedMachine       *string
	customProperties            *CustomPropertySlice
	deleteProtected             *bool
	description                 *string
	display                     *Display
	domain                      *Domain
	highAvailability            *HighAvailability
	id                          *string
	initialization              *Initialization
	io                          *Io
	largeIcon                   *Icon
	lease                       *StorageDomainLease
	memory                      *int64
	memoryPolicy                *MemoryPolicy
	migration                   *MigrationOptions
	migrationDowntime           *int64
	multiQueuesEnabled          *bool
	name                        *string
	origin                      *string
	os                          *OperatingSystem
	placementPolicy             *VmPlacementPolicy
	quota                       *Quota
	rngDevice                   *RngDevice
	serialNumber                *SerialNumber
	smallIcon                   *Icon
	soundcardEnabled            *bool
	sso                         *Sso
	startPaused                 *bool
	stateless                   *bool
	storageDomain               *StorageDomain
	storageErrorResumeBehaviour *VmStorageErrorResumeBehaviour
	timeZone                    *TimeZone
	tunnelMigration             *bool
	type_                       *VmType
	usb                         *Usb
	virtioScsi                  *VirtioScsi
}

func (p *VmBase) SetBios(attr *Bios) {
	p.bios = attr
}

func (p *VmBase) Bios() (*Bios, bool) {
	if p.bios != nil {
		return p.bios, true
	}
	return nil, false
}

func (p *VmBase) MustBios() *Bios {
	if p.bios == nil {
		panic("the bios must not be nil, please use Bios() function instead")
	}
	return p.bios
}

func (p *VmBase) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *VmBase) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *VmBase) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *VmBase) SetComment(attr string) {
	p.comment = &attr
}

func (p *VmBase) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *VmBase) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *VmBase) SetConsole(attr *Console) {
	p.console = attr
}

func (p *VmBase) Console() (*Console, bool) {
	if p.console != nil {
		return p.console, true
	}
	return nil, false
}

func (p *VmBase) MustConsole() *Console {
	if p.console == nil {
		panic("the console must not be nil, please use Console() function instead")
	}
	return p.console
}

func (p *VmBase) SetCpu(attr *Cpu) {
	p.cpu = attr
}

func (p *VmBase) Cpu() (*Cpu, bool) {
	if p.cpu != nil {
		return p.cpu, true
	}
	return nil, false
}

func (p *VmBase) MustCpu() *Cpu {
	if p.cpu == nil {
		panic("the cpu must not be nil, please use Cpu() function instead")
	}
	return p.cpu
}

func (p *VmBase) SetCpuProfile(attr *CpuProfile) {
	p.cpuProfile = attr
}

func (p *VmBase) CpuProfile() (*CpuProfile, bool) {
	if p.cpuProfile != nil {
		return p.cpuProfile, true
	}
	return nil, false
}

func (p *VmBase) MustCpuProfile() *CpuProfile {
	if p.cpuProfile == nil {
		panic("the cpuProfile must not be nil, please use CpuProfile() function instead")
	}
	return p.cpuProfile
}

func (p *VmBase) SetCpuShares(attr int64) {
	p.cpuShares = &attr
}

func (p *VmBase) CpuShares() (int64, bool) {
	if p.cpuShares != nil {
		return *p.cpuShares, true
	}
	var zero int64
	return zero, false
}

func (p *VmBase) MustCpuShares() int64 {
	if p.cpuShares == nil {
		panic("the cpuShares must not be nil, please use CpuShares() function instead")
	}
	return *p.cpuShares
}

func (p *VmBase) SetCreationTime(attr time.Time) {
	p.creationTime = &attr
}

func (p *VmBase) CreationTime() (time.Time, bool) {
	if p.creationTime != nil {
		return *p.creationTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *VmBase) MustCreationTime() time.Time {
	if p.creationTime == nil {
		panic("the creationTime must not be nil, please use CreationTime() function instead")
	}
	return *p.creationTime
}

func (p *VmBase) SetCustomCompatibilityVersion(attr *Version) {
	p.customCompatibilityVersion = attr
}

func (p *VmBase) CustomCompatibilityVersion() (*Version, bool) {
	if p.customCompatibilityVersion != nil {
		return p.customCompatibilityVersion, true
	}
	return nil, false
}

func (p *VmBase) MustCustomCompatibilityVersion() *Version {
	if p.customCompatibilityVersion == nil {
		panic("the customCompatibilityVersion must not be nil, please use CustomCompatibilityVersion() function instead")
	}
	return p.customCompatibilityVersion
}

func (p *VmBase) SetCustomCpuModel(attr string) {
	p.customCpuModel = &attr
}

func (p *VmBase) CustomCpuModel() (string, bool) {
	if p.customCpuModel != nil {
		return *p.customCpuModel, true
	}
	var zero string
	return zero, false
}

func (p *VmBase) MustCustomCpuModel() string {
	if p.customCpuModel == nil {
		panic("the customCpuModel must not be nil, please use CustomCpuModel() function instead")
	}
	return *p.customCpuModel
}

func (p *VmBase) SetCustomEmulatedMachine(attr string) {
	p.customEmulatedMachine = &attr
}

func (p *VmBase) CustomEmulatedMachine() (string, bool) {
	if p.customEmulatedMachine != nil {
		return *p.customEmulatedMachine, true
	}
	var zero string
	return zero, false
}

func (p *VmBase) MustCustomEmulatedMachine() string {
	if p.customEmulatedMachine == nil {
		panic("the customEmulatedMachine must not be nil, please use CustomEmulatedMachine() function instead")
	}
	return *p.customEmulatedMachine
}

func (p *VmBase) SetCustomProperties(attr *CustomPropertySlice) {
	p.customProperties = attr
}

func (p *VmBase) CustomProperties() (*CustomPropertySlice, bool) {
	if p.customProperties != nil {
		return p.customProperties, true
	}
	return nil, false
}

func (p *VmBase) MustCustomProperties() *CustomPropertySlice {
	if p.customProperties == nil {
		panic("the customProperties must not be nil, please use CustomProperties() function instead")
	}
	return p.customProperties
}

func (p *VmBase) SetDeleteProtected(attr bool) {
	p.deleteProtected = &attr
}

func (p *VmBase) DeleteProtected() (bool, bool) {
	if p.deleteProtected != nil {
		return *p.deleteProtected, true
	}
	var zero bool
	return zero, false
}

func (p *VmBase) MustDeleteProtected() bool {
	if p.deleteProtected == nil {
		panic("the deleteProtected must not be nil, please use DeleteProtected() function instead")
	}
	return *p.deleteProtected
}

func (p *VmBase) SetDescription(attr string) {
	p.description = &attr
}

func (p *VmBase) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *VmBase) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *VmBase) SetDisplay(attr *Display) {
	p.display = attr
}

func (p *VmBase) Display() (*Display, bool) {
	if p.display != nil {
		return p.display, true
	}
	return nil, false
}

func (p *VmBase) MustDisplay() *Display {
	if p.display == nil {
		panic("the display must not be nil, please use Display() function instead")
	}
	return p.display
}

func (p *VmBase) SetDomain(attr *Domain) {
	p.domain = attr
}

func (p *VmBase) Domain() (*Domain, bool) {
	if p.domain != nil {
		return p.domain, true
	}
	return nil, false
}

func (p *VmBase) MustDomain() *Domain {
	if p.domain == nil {
		panic("the domain must not be nil, please use Domain() function instead")
	}
	return p.domain
}

func (p *VmBase) SetHighAvailability(attr *HighAvailability) {
	p.highAvailability = attr
}

func (p *VmBase) HighAvailability() (*HighAvailability, bool) {
	if p.highAvailability != nil {
		return p.highAvailability, true
	}
	return nil, false
}

func (p *VmBase) MustHighAvailability() *HighAvailability {
	if p.highAvailability == nil {
		panic("the highAvailability must not be nil, please use HighAvailability() function instead")
	}
	return p.highAvailability
}

func (p *VmBase) SetId(attr string) {
	p.id = &attr
}

func (p *VmBase) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *VmBase) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *VmBase) SetInitialization(attr *Initialization) {
	p.initialization = attr
}

func (p *VmBase) Initialization() (*Initialization, bool) {
	if p.initialization != nil {
		return p.initialization, true
	}
	return nil, false
}

func (p *VmBase) MustInitialization() *Initialization {
	if p.initialization == nil {
		panic("the initialization must not be nil, please use Initialization() function instead")
	}
	return p.initialization
}

func (p *VmBase) SetIo(attr *Io) {
	p.io = attr
}

func (p *VmBase) Io() (*Io, bool) {
	if p.io != nil {
		return p.io, true
	}
	return nil, false
}

func (p *VmBase) MustIo() *Io {
	if p.io == nil {
		panic("the io must not be nil, please use Io() function instead")
	}
	return p.io
}

func (p *VmBase) SetLargeIcon(attr *Icon) {
	p.largeIcon = attr
}

func (p *VmBase) LargeIcon() (*Icon, bool) {
	if p.largeIcon != nil {
		return p.largeIcon, true
	}
	return nil, false
}

func (p *VmBase) MustLargeIcon() *Icon {
	if p.largeIcon == nil {
		panic("the largeIcon must not be nil, please use LargeIcon() function instead")
	}
	return p.largeIcon
}

func (p *VmBase) SetLease(attr *StorageDomainLease) {
	p.lease = attr
}

func (p *VmBase) Lease() (*StorageDomainLease, bool) {
	if p.lease != nil {
		return p.lease, true
	}
	return nil, false
}

func (p *VmBase) MustLease() *StorageDomainLease {
	if p.lease == nil {
		panic("the lease must not be nil, please use Lease() function instead")
	}
	return p.lease
}

func (p *VmBase) SetMemory(attr int64) {
	p.memory = &attr
}

func (p *VmBase) Memory() (int64, bool) {
	if p.memory != nil {
		return *p.memory, true
	}
	var zero int64
	return zero, false
}

func (p *VmBase) MustMemory() int64 {
	if p.memory == nil {
		panic("the memory must not be nil, please use Memory() function instead")
	}
	return *p.memory
}

func (p *VmBase) SetMemoryPolicy(attr *MemoryPolicy) {
	p.memoryPolicy = attr
}

func (p *VmBase) MemoryPolicy() (*MemoryPolicy, bool) {
	if p.memoryPolicy != nil {
		return p.memoryPolicy, true
	}
	return nil, false
}

func (p *VmBase) MustMemoryPolicy() *MemoryPolicy {
	if p.memoryPolicy == nil {
		panic("the memoryPolicy must not be nil, please use MemoryPolicy() function instead")
	}
	return p.memoryPolicy
}

func (p *VmBase) SetMigration(attr *MigrationOptions) {
	p.migration = attr
}

func (p *VmBase) Migration() (*MigrationOptions, bool) {
	if p.migration != nil {
		return p.migration, true
	}
	return nil, false
}

func (p *VmBase) MustMigration() *MigrationOptions {
	if p.migration == nil {
		panic("the migration must not be nil, please use Migration() function instead")
	}
	return p.migration
}

func (p *VmBase) SetMigrationDowntime(attr int64) {
	p.migrationDowntime = &attr
}

func (p *VmBase) MigrationDowntime() (int64, bool) {
	if p.migrationDowntime != nil {
		return *p.migrationDowntime, true
	}
	var zero int64
	return zero, false
}

func (p *VmBase) MustMigrationDowntime() int64 {
	if p.migrationDowntime == nil {
		panic("the migrationDowntime must not be nil, please use MigrationDowntime() function instead")
	}
	return *p.migrationDowntime
}

func (p *VmBase) SetMultiQueuesEnabled(attr bool) {
	p.multiQueuesEnabled = &attr
}

func (p *VmBase) MultiQueuesEnabled() (bool, bool) {
	if p.multiQueuesEnabled != nil {
		return *p.multiQueuesEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *VmBase) MustMultiQueuesEnabled() bool {
	if p.multiQueuesEnabled == nil {
		panic("the multiQueuesEnabled must not be nil, please use MultiQueuesEnabled() function instead")
	}
	return *p.multiQueuesEnabled
}

func (p *VmBase) SetName(attr string) {
	p.name = &attr
}

func (p *VmBase) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *VmBase) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *VmBase) SetOrigin(attr string) {
	p.origin = &attr
}

func (p *VmBase) Origin() (string, bool) {
	if p.origin != nil {
		return *p.origin, true
	}
	var zero string
	return zero, false
}

func (p *VmBase) MustOrigin() string {
	if p.origin == nil {
		panic("the origin must not be nil, please use Origin() function instead")
	}
	return *p.origin
}

func (p *VmBase) SetOs(attr *OperatingSystem) {
	p.os = attr
}

func (p *VmBase) Os() (*OperatingSystem, bool) {
	if p.os != nil {
		return p.os, true
	}
	return nil, false
}

func (p *VmBase) MustOs() *OperatingSystem {
	if p.os == nil {
		panic("the os must not be nil, please use Os() function instead")
	}
	return p.os
}

func (p *VmBase) SetPlacementPolicy(attr *VmPlacementPolicy) {
	p.placementPolicy = attr
}

func (p *VmBase) PlacementPolicy() (*VmPlacementPolicy, bool) {
	if p.placementPolicy != nil {
		return p.placementPolicy, true
	}
	return nil, false
}

func (p *VmBase) MustPlacementPolicy() *VmPlacementPolicy {
	if p.placementPolicy == nil {
		panic("the placementPolicy must not be nil, please use PlacementPolicy() function instead")
	}
	return p.placementPolicy
}

func (p *VmBase) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *VmBase) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *VmBase) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *VmBase) SetRngDevice(attr *RngDevice) {
	p.rngDevice = attr
}

func (p *VmBase) RngDevice() (*RngDevice, bool) {
	if p.rngDevice != nil {
		return p.rngDevice, true
	}
	return nil, false
}

func (p *VmBase) MustRngDevice() *RngDevice {
	if p.rngDevice == nil {
		panic("the rngDevice must not be nil, please use RngDevice() function instead")
	}
	return p.rngDevice
}

func (p *VmBase) SetSerialNumber(attr *SerialNumber) {
	p.serialNumber = attr
}

func (p *VmBase) SerialNumber() (*SerialNumber, bool) {
	if p.serialNumber != nil {
		return p.serialNumber, true
	}
	return nil, false
}

func (p *VmBase) MustSerialNumber() *SerialNumber {
	if p.serialNumber == nil {
		panic("the serialNumber must not be nil, please use SerialNumber() function instead")
	}
	return p.serialNumber
}

func (p *VmBase) SetSmallIcon(attr *Icon) {
	p.smallIcon = attr
}

func (p *VmBase) SmallIcon() (*Icon, bool) {
	if p.smallIcon != nil {
		return p.smallIcon, true
	}
	return nil, false
}

func (p *VmBase) MustSmallIcon() *Icon {
	if p.smallIcon == nil {
		panic("the smallIcon must not be nil, please use SmallIcon() function instead")
	}
	return p.smallIcon
}

func (p *VmBase) SetSoundcardEnabled(attr bool) {
	p.soundcardEnabled = &attr
}

func (p *VmBase) SoundcardEnabled() (bool, bool) {
	if p.soundcardEnabled != nil {
		return *p.soundcardEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *VmBase) MustSoundcardEnabled() bool {
	if p.soundcardEnabled == nil {
		panic("the soundcardEnabled must not be nil, please use SoundcardEnabled() function instead")
	}
	return *p.soundcardEnabled
}

func (p *VmBase) SetSso(attr *Sso) {
	p.sso = attr
}

func (p *VmBase) Sso() (*Sso, bool) {
	if p.sso != nil {
		return p.sso, true
	}
	return nil, false
}

func (p *VmBase) MustSso() *Sso {
	if p.sso == nil {
		panic("the sso must not be nil, please use Sso() function instead")
	}
	return p.sso
}

func (p *VmBase) SetStartPaused(attr bool) {
	p.startPaused = &attr
}

func (p *VmBase) StartPaused() (bool, bool) {
	if p.startPaused != nil {
		return *p.startPaused, true
	}
	var zero bool
	return zero, false
}

func (p *VmBase) MustStartPaused() bool {
	if p.startPaused == nil {
		panic("the startPaused must not be nil, please use StartPaused() function instead")
	}
	return *p.startPaused
}

func (p *VmBase) SetStateless(attr bool) {
	p.stateless = &attr
}

func (p *VmBase) Stateless() (bool, bool) {
	if p.stateless != nil {
		return *p.stateless, true
	}
	var zero bool
	return zero, false
}

func (p *VmBase) MustStateless() bool {
	if p.stateless == nil {
		panic("the stateless must not be nil, please use Stateless() function instead")
	}
	return *p.stateless
}

func (p *VmBase) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *VmBase) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *VmBase) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *VmBase) SetStorageErrorResumeBehaviour(attr VmStorageErrorResumeBehaviour) {
	p.storageErrorResumeBehaviour = &attr
}

func (p *VmBase) StorageErrorResumeBehaviour() (VmStorageErrorResumeBehaviour, bool) {
	if p.storageErrorResumeBehaviour != nil {
		return *p.storageErrorResumeBehaviour, true
	}
	var zero VmStorageErrorResumeBehaviour
	return zero, false
}

func (p *VmBase) MustStorageErrorResumeBehaviour() VmStorageErrorResumeBehaviour {
	if p.storageErrorResumeBehaviour == nil {
		panic("the storageErrorResumeBehaviour must not be nil, please use StorageErrorResumeBehaviour() function instead")
	}
	return *p.storageErrorResumeBehaviour
}

func (p *VmBase) SetTimeZone(attr *TimeZone) {
	p.timeZone = attr
}

func (p *VmBase) TimeZone() (*TimeZone, bool) {
	if p.timeZone != nil {
		return p.timeZone, true
	}
	return nil, false
}

func (p *VmBase) MustTimeZone() *TimeZone {
	if p.timeZone == nil {
		panic("the timeZone must not be nil, please use TimeZone() function instead")
	}
	return p.timeZone
}

func (p *VmBase) SetTunnelMigration(attr bool) {
	p.tunnelMigration = &attr
}

func (p *VmBase) TunnelMigration() (bool, bool) {
	if p.tunnelMigration != nil {
		return *p.tunnelMigration, true
	}
	var zero bool
	return zero, false
}

func (p *VmBase) MustTunnelMigration() bool {
	if p.tunnelMigration == nil {
		panic("the tunnelMigration must not be nil, please use TunnelMigration() function instead")
	}
	return *p.tunnelMigration
}

func (p *VmBase) SetType(attr VmType) {
	p.type_ = &attr
}

func (p *VmBase) Type() (VmType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero VmType
	return zero, false
}

func (p *VmBase) MustType() VmType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *VmBase) SetUsb(attr *Usb) {
	p.usb = attr
}

func (p *VmBase) Usb() (*Usb, bool) {
	if p.usb != nil {
		return p.usb, true
	}
	return nil, false
}

func (p *VmBase) MustUsb() *Usb {
	if p.usb == nil {
		panic("the usb must not be nil, please use Usb() function instead")
	}
	return p.usb
}

func (p *VmBase) SetVirtioScsi(attr *VirtioScsi) {
	p.virtioScsi = attr
}

func (p *VmBase) VirtioScsi() (*VirtioScsi, bool) {
	if p.virtioScsi != nil {
		return p.virtioScsi, true
	}
	return nil, false
}

func (p *VmBase) MustVirtioScsi() *VirtioScsi {
	if p.virtioScsi == nil {
		panic("the virtioScsi must not be nil, please use VirtioScsi() function instead")
	}
	return p.virtioScsi
}

type Dns struct {
	Struct
	searchDomains *HostSlice
	servers       *HostSlice
}

func (p *Dns) SetSearchDomains(attr *HostSlice) {
	p.searchDomains = attr
}

func (p *Dns) SearchDomains() (*HostSlice, bool) {
	if p.searchDomains != nil {
		return p.searchDomains, true
	}
	return nil, false
}

func (p *Dns) MustSearchDomains() *HostSlice {
	if p.searchDomains == nil {
		panic("the searchDomains must not be nil, please use SearchDomains() function instead")
	}
	return p.searchDomains
}

func (p *Dns) SetServers(attr *HostSlice) {
	p.servers = attr
}

func (p *Dns) Servers() (*HostSlice, bool) {
	if p.servers != nil {
		return p.servers, true
	}
	return nil, false
}

func (p *Dns) MustServers() *HostSlice {
	if p.servers == nil {
		panic("the servers must not be nil, please use Servers() function instead")
	}
	return p.servers
}

type CpuProfile struct {
	Struct
	cluster     *Cluster
	comment     *string
	description *string
	id          *string
	name        *string
	permissions *PermissionSlice
	qos         *Qos
}

func (p *CpuProfile) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *CpuProfile) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *CpuProfile) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *CpuProfile) SetComment(attr string) {
	p.comment = &attr
}

func (p *CpuProfile) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *CpuProfile) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *CpuProfile) SetDescription(attr string) {
	p.description = &attr
}

func (p *CpuProfile) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *CpuProfile) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *CpuProfile) SetId(attr string) {
	p.id = &attr
}

func (p *CpuProfile) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *CpuProfile) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *CpuProfile) SetName(attr string) {
	p.name = &attr
}

func (p *CpuProfile) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *CpuProfile) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *CpuProfile) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *CpuProfile) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *CpuProfile) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *CpuProfile) SetQos(attr *Qos) {
	p.qos = attr
}

func (p *CpuProfile) Qos() (*Qos, bool) {
	if p.qos != nil {
		return p.qos, true
	}
	return nil, false
}

func (p *CpuProfile) MustQos() *Qos {
	if p.qos == nil {
		panic("the qos must not be nil, please use Qos() function instead")
	}
	return p.qos
}

type ExternalHost struct {
	Struct
	address              *string
	comment              *string
	description          *string
	externalHostProvider *ExternalHostProvider
	id                   *string
	name                 *string
}

func (p *ExternalHost) SetAddress(attr string) {
	p.address = &attr
}

func (p *ExternalHost) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHost) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *ExternalHost) SetComment(attr string) {
	p.comment = &attr
}

func (p *ExternalHost) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHost) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ExternalHost) SetDescription(attr string) {
	p.description = &attr
}

func (p *ExternalHost) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHost) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ExternalHost) SetExternalHostProvider(attr *ExternalHostProvider) {
	p.externalHostProvider = attr
}

func (p *ExternalHost) ExternalHostProvider() (*ExternalHostProvider, bool) {
	if p.externalHostProvider != nil {
		return p.externalHostProvider, true
	}
	return nil, false
}

func (p *ExternalHost) MustExternalHostProvider() *ExternalHostProvider {
	if p.externalHostProvider == nil {
		panic("the externalHostProvider must not be nil, please use ExternalHostProvider() function instead")
	}
	return p.externalHostProvider
}

func (p *ExternalHost) SetId(attr string) {
	p.id = &attr
}

func (p *ExternalHost) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHost) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ExternalHost) SetName(attr string) {
	p.name = &attr
}

func (p *ExternalHost) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ExternalHost) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type Nic struct {
	Struct
	bootProtocol                   *BootProtocol
	comment                        *string
	description                    *string
	id                             *string
	instanceType                   *InstanceType
	interface_                     *NicInterface
	linked                         *bool
	mac                            *Mac
	name                           *string
	network                        *Network
	networkAttachments             *NetworkAttachmentSlice
	networkFilterParameters        *NetworkFilterParameterSlice
	networkLabels                  *NetworkLabelSlice
	onBoot                         *bool
	plugged                        *bool
	reportedDevices                *ReportedDeviceSlice
	statistics                     *StatisticSlice
	template                       *Template
	virtualFunctionAllowedLabels   *NetworkLabelSlice
	virtualFunctionAllowedNetworks *NetworkSlice
	vm                             *Vm
	vms                            *VmSlice
	vnicProfile                    *VnicProfile
}

func (p *Nic) SetBootProtocol(attr BootProtocol) {
	p.bootProtocol = &attr
}

func (p *Nic) BootProtocol() (BootProtocol, bool) {
	if p.bootProtocol != nil {
		return *p.bootProtocol, true
	}
	var zero BootProtocol
	return zero, false
}

func (p *Nic) MustBootProtocol() BootProtocol {
	if p.bootProtocol == nil {
		panic("the bootProtocol must not be nil, please use BootProtocol() function instead")
	}
	return *p.bootProtocol
}

func (p *Nic) SetComment(attr string) {
	p.comment = &attr
}

func (p *Nic) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Nic) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Nic) SetDescription(attr string) {
	p.description = &attr
}

func (p *Nic) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Nic) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Nic) SetId(attr string) {
	p.id = &attr
}

func (p *Nic) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Nic) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Nic) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *Nic) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *Nic) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *Nic) SetInterface(attr NicInterface) {
	p.interface_ = &attr
}

func (p *Nic) Interface() (NicInterface, bool) {
	if p.interface_ != nil {
		return *p.interface_, true
	}
	var zero NicInterface
	return zero, false
}

func (p *Nic) MustInterface() NicInterface {
	if p.interface_ == nil {
		panic("the interface_ must not be nil, please use Interface() function instead")
	}
	return *p.interface_
}

func (p *Nic) SetLinked(attr bool) {
	p.linked = &attr
}

func (p *Nic) Linked() (bool, bool) {
	if p.linked != nil {
		return *p.linked, true
	}
	var zero bool
	return zero, false
}

func (p *Nic) MustLinked() bool {
	if p.linked == nil {
		panic("the linked must not be nil, please use Linked() function instead")
	}
	return *p.linked
}

func (p *Nic) SetMac(attr *Mac) {
	p.mac = attr
}

func (p *Nic) Mac() (*Mac, bool) {
	if p.mac != nil {
		return p.mac, true
	}
	return nil, false
}

func (p *Nic) MustMac() *Mac {
	if p.mac == nil {
		panic("the mac must not be nil, please use Mac() function instead")
	}
	return p.mac
}

func (p *Nic) SetName(attr string) {
	p.name = &attr
}

func (p *Nic) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Nic) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Nic) SetNetwork(attr *Network) {
	p.network = attr
}

func (p *Nic) Network() (*Network, bool) {
	if p.network != nil {
		return p.network, true
	}
	return nil, false
}

func (p *Nic) MustNetwork() *Network {
	if p.network == nil {
		panic("the network must not be nil, please use Network() function instead")
	}
	return p.network
}

func (p *Nic) SetNetworkAttachments(attr *NetworkAttachmentSlice) {
	p.networkAttachments = attr
}

func (p *Nic) NetworkAttachments() (*NetworkAttachmentSlice, bool) {
	if p.networkAttachments != nil {
		return p.networkAttachments, true
	}
	return nil, false
}

func (p *Nic) MustNetworkAttachments() *NetworkAttachmentSlice {
	if p.networkAttachments == nil {
		panic("the networkAttachments must not be nil, please use NetworkAttachments() function instead")
	}
	return p.networkAttachments
}

func (p *Nic) SetNetworkFilterParameters(attr *NetworkFilterParameterSlice) {
	p.networkFilterParameters = attr
}

func (p *Nic) NetworkFilterParameters() (*NetworkFilterParameterSlice, bool) {
	if p.networkFilterParameters != nil {
		return p.networkFilterParameters, true
	}
	return nil, false
}

func (p *Nic) MustNetworkFilterParameters() *NetworkFilterParameterSlice {
	if p.networkFilterParameters == nil {
		panic("the networkFilterParameters must not be nil, please use NetworkFilterParameters() function instead")
	}
	return p.networkFilterParameters
}

func (p *Nic) SetNetworkLabels(attr *NetworkLabelSlice) {
	p.networkLabels = attr
}

func (p *Nic) NetworkLabels() (*NetworkLabelSlice, bool) {
	if p.networkLabels != nil {
		return p.networkLabels, true
	}
	return nil, false
}

func (p *Nic) MustNetworkLabels() *NetworkLabelSlice {
	if p.networkLabels == nil {
		panic("the networkLabels must not be nil, please use NetworkLabels() function instead")
	}
	return p.networkLabels
}

func (p *Nic) SetOnBoot(attr bool) {
	p.onBoot = &attr
}

func (p *Nic) OnBoot() (bool, bool) {
	if p.onBoot != nil {
		return *p.onBoot, true
	}
	var zero bool
	return zero, false
}

func (p *Nic) MustOnBoot() bool {
	if p.onBoot == nil {
		panic("the onBoot must not be nil, please use OnBoot() function instead")
	}
	return *p.onBoot
}

func (p *Nic) SetPlugged(attr bool) {
	p.plugged = &attr
}

func (p *Nic) Plugged() (bool, bool) {
	if p.plugged != nil {
		return *p.plugged, true
	}
	var zero bool
	return zero, false
}

func (p *Nic) MustPlugged() bool {
	if p.plugged == nil {
		panic("the plugged must not be nil, please use Plugged() function instead")
	}
	return *p.plugged
}

func (p *Nic) SetReportedDevices(attr *ReportedDeviceSlice) {
	p.reportedDevices = attr
}

func (p *Nic) ReportedDevices() (*ReportedDeviceSlice, bool) {
	if p.reportedDevices != nil {
		return p.reportedDevices, true
	}
	return nil, false
}

func (p *Nic) MustReportedDevices() *ReportedDeviceSlice {
	if p.reportedDevices == nil {
		panic("the reportedDevices must not be nil, please use ReportedDevices() function instead")
	}
	return p.reportedDevices
}

func (p *Nic) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *Nic) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *Nic) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *Nic) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Nic) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Nic) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Nic) SetVirtualFunctionAllowedLabels(attr *NetworkLabelSlice) {
	p.virtualFunctionAllowedLabels = attr
}

func (p *Nic) VirtualFunctionAllowedLabels() (*NetworkLabelSlice, bool) {
	if p.virtualFunctionAllowedLabels != nil {
		return p.virtualFunctionAllowedLabels, true
	}
	return nil, false
}

func (p *Nic) MustVirtualFunctionAllowedLabels() *NetworkLabelSlice {
	if p.virtualFunctionAllowedLabels == nil {
		panic("the virtualFunctionAllowedLabels must not be nil, please use VirtualFunctionAllowedLabels() function instead")
	}
	return p.virtualFunctionAllowedLabels
}

func (p *Nic) SetVirtualFunctionAllowedNetworks(attr *NetworkSlice) {
	p.virtualFunctionAllowedNetworks = attr
}

func (p *Nic) VirtualFunctionAllowedNetworks() (*NetworkSlice, bool) {
	if p.virtualFunctionAllowedNetworks != nil {
		return p.virtualFunctionAllowedNetworks, true
	}
	return nil, false
}

func (p *Nic) MustVirtualFunctionAllowedNetworks() *NetworkSlice {
	if p.virtualFunctionAllowedNetworks == nil {
		panic("the virtualFunctionAllowedNetworks must not be nil, please use VirtualFunctionAllowedNetworks() function instead")
	}
	return p.virtualFunctionAllowedNetworks
}

func (p *Nic) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Nic) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Nic) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Nic) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *Nic) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *Nic) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

func (p *Nic) SetVnicProfile(attr *VnicProfile) {
	p.vnicProfile = attr
}

func (p *Nic) VnicProfile() (*VnicProfile, bool) {
	if p.vnicProfile != nil {
		return p.vnicProfile, true
	}
	return nil, false
}

func (p *Nic) MustVnicProfile() *VnicProfile {
	if p.vnicProfile == nil {
		panic("the vnicProfile must not be nil, please use VnicProfile() function instead")
	}
	return p.vnicProfile
}

type OpenstackVolumeAuthenticationKey struct {
	Struct
	comment                 *string
	creationDate            *time.Time
	description             *string
	id                      *string
	name                    *string
	openstackVolumeProvider *OpenStackVolumeProvider
	usageType               *OpenstackVolumeAuthenticationKeyUsageType
	uuid                    *string
	value                   *string
}

func (p *OpenstackVolumeAuthenticationKey) SetComment(attr string) {
	p.comment = &attr
}

func (p *OpenstackVolumeAuthenticationKey) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *OpenstackVolumeAuthenticationKey) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *OpenstackVolumeAuthenticationKey) SetCreationDate(attr time.Time) {
	p.creationDate = &attr
}

func (p *OpenstackVolumeAuthenticationKey) CreationDate() (time.Time, bool) {
	if p.creationDate != nil {
		return *p.creationDate, true
	}
	var zero time.Time
	return zero, false
}

func (p *OpenstackVolumeAuthenticationKey) MustCreationDate() time.Time {
	if p.creationDate == nil {
		panic("the creationDate must not be nil, please use CreationDate() function instead")
	}
	return *p.creationDate
}

func (p *OpenstackVolumeAuthenticationKey) SetDescription(attr string) {
	p.description = &attr
}

func (p *OpenstackVolumeAuthenticationKey) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *OpenstackVolumeAuthenticationKey) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *OpenstackVolumeAuthenticationKey) SetId(attr string) {
	p.id = &attr
}

func (p *OpenstackVolumeAuthenticationKey) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *OpenstackVolumeAuthenticationKey) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *OpenstackVolumeAuthenticationKey) SetName(attr string) {
	p.name = &attr
}

func (p *OpenstackVolumeAuthenticationKey) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *OpenstackVolumeAuthenticationKey) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *OpenstackVolumeAuthenticationKey) SetOpenstackVolumeProvider(attr *OpenStackVolumeProvider) {
	p.openstackVolumeProvider = attr
}

func (p *OpenstackVolumeAuthenticationKey) OpenstackVolumeProvider() (*OpenStackVolumeProvider, bool) {
	if p.openstackVolumeProvider != nil {
		return p.openstackVolumeProvider, true
	}
	return nil, false
}

func (p *OpenstackVolumeAuthenticationKey) MustOpenstackVolumeProvider() *OpenStackVolumeProvider {
	if p.openstackVolumeProvider == nil {
		panic("the openstackVolumeProvider must not be nil, please use OpenstackVolumeProvider() function instead")
	}
	return p.openstackVolumeProvider
}

func (p *OpenstackVolumeAuthenticationKey) SetUsageType(attr OpenstackVolumeAuthenticationKeyUsageType) {
	p.usageType = &attr
}

func (p *OpenstackVolumeAuthenticationKey) UsageType() (OpenstackVolumeAuthenticationKeyUsageType, bool) {
	if p.usageType != nil {
		return *p.usageType, true
	}
	var zero OpenstackVolumeAuthenticationKeyUsageType
	return zero, false
}

func (p *OpenstackVolumeAuthenticationKey) MustUsageType() OpenstackVolumeAuthenticationKeyUsageType {
	if p.usageType == nil {
		panic("the usageType must not be nil, please use UsageType() function instead")
	}
	return *p.usageType
}

func (p *OpenstackVolumeAuthenticationKey) SetUuid(attr string) {
	p.uuid = &attr
}

func (p *OpenstackVolumeAuthenticationKey) Uuid() (string, bool) {
	if p.uuid != nil {
		return *p.uuid, true
	}
	var zero string
	return zero, false
}

func (p *OpenstackVolumeAuthenticationKey) MustUuid() string {
	if p.uuid == nil {
		panic("the uuid must not be nil, please use Uuid() function instead")
	}
	return *p.uuid
}

func (p *OpenstackVolumeAuthenticationKey) SetValue(attr string) {
	p.value = &attr
}

func (p *OpenstackVolumeAuthenticationKey) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *OpenstackVolumeAuthenticationKey) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

type CpuTopology struct {
	Struct
	cores   *int64
	sockets *int64
	threads *int64
}

func (p *CpuTopology) SetCores(attr int64) {
	p.cores = &attr
}

func (p *CpuTopology) Cores() (int64, bool) {
	if p.cores != nil {
		return *p.cores, true
	}
	var zero int64
	return zero, false
}

func (p *CpuTopology) MustCores() int64 {
	if p.cores == nil {
		panic("the cores must not be nil, please use Cores() function instead")
	}
	return *p.cores
}

func (p *CpuTopology) SetSockets(attr int64) {
	p.sockets = &attr
}

func (p *CpuTopology) Sockets() (int64, bool) {
	if p.sockets != nil {
		return *p.sockets, true
	}
	var zero int64
	return zero, false
}

func (p *CpuTopology) MustSockets() int64 {
	if p.sockets == nil {
		panic("the sockets must not be nil, please use Sockets() function instead")
	}
	return *p.sockets
}

func (p *CpuTopology) SetThreads(attr int64) {
	p.threads = &attr
}

func (p *CpuTopology) Threads() (int64, bool) {
	if p.threads != nil {
		return *p.threads, true
	}
	var zero int64
	return zero, false
}

func (p *CpuTopology) MustThreads() int64 {
	if p.threads == nil {
		panic("the threads must not be nil, please use Threads() function instead")
	}
	return *p.threads
}

type ExternalProvider struct {
	Struct
	authenticationUrl      *string
	comment                *string
	description            *string
	id                     *string
	name                   *string
	password               *string
	properties             *PropertySlice
	requiresAuthentication *bool
	url                    *string
	username               *string
}

func (p *ExternalProvider) SetAuthenticationUrl(attr string) {
	p.authenticationUrl = &attr
}

func (p *ExternalProvider) AuthenticationUrl() (string, bool) {
	if p.authenticationUrl != nil {
		return *p.authenticationUrl, true
	}
	var zero string
	return zero, false
}

func (p *ExternalProvider) MustAuthenticationUrl() string {
	if p.authenticationUrl == nil {
		panic("the authenticationUrl must not be nil, please use AuthenticationUrl() function instead")
	}
	return *p.authenticationUrl
}

func (p *ExternalProvider) SetComment(attr string) {
	p.comment = &attr
}

func (p *ExternalProvider) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *ExternalProvider) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *ExternalProvider) SetDescription(attr string) {
	p.description = &attr
}

func (p *ExternalProvider) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *ExternalProvider) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *ExternalProvider) SetId(attr string) {
	p.id = &attr
}

func (p *ExternalProvider) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *ExternalProvider) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *ExternalProvider) SetName(attr string) {
	p.name = &attr
}

func (p *ExternalProvider) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ExternalProvider) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ExternalProvider) SetPassword(attr string) {
	p.password = &attr
}

func (p *ExternalProvider) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *ExternalProvider) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *ExternalProvider) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *ExternalProvider) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *ExternalProvider) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *ExternalProvider) SetRequiresAuthentication(attr bool) {
	p.requiresAuthentication = &attr
}

func (p *ExternalProvider) RequiresAuthentication() (bool, bool) {
	if p.requiresAuthentication != nil {
		return *p.requiresAuthentication, true
	}
	var zero bool
	return zero, false
}

func (p *ExternalProvider) MustRequiresAuthentication() bool {
	if p.requiresAuthentication == nil {
		panic("the requiresAuthentication must not be nil, please use RequiresAuthentication() function instead")
	}
	return *p.requiresAuthentication
}

func (p *ExternalProvider) SetUrl(attr string) {
	p.url = &attr
}

func (p *ExternalProvider) Url() (string, bool) {
	if p.url != nil {
		return *p.url, true
	}
	var zero string
	return zero, false
}

func (p *ExternalProvider) MustUrl() string {
	if p.url == nil {
		panic("the url must not be nil, please use Url() function instead")
	}
	return *p.url
}

func (p *ExternalProvider) SetUsername(attr string) {
	p.username = &attr
}

func (p *ExternalProvider) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *ExternalProvider) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

type ExternalVmImport struct {
	Struct
	cluster       *Cluster
	cpuProfile    *CpuProfile
	driversIso    *File
	host          *Host
	name          *string
	password      *string
	provider      *ExternalVmProviderType
	quota         *Quota
	sparse        *bool
	storageDomain *StorageDomain
	url           *string
	username      *string
	vm            *Vm
}

func (p *ExternalVmImport) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *ExternalVmImport) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *ExternalVmImport) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *ExternalVmImport) SetCpuProfile(attr *CpuProfile) {
	p.cpuProfile = attr
}

func (p *ExternalVmImport) CpuProfile() (*CpuProfile, bool) {
	if p.cpuProfile != nil {
		return p.cpuProfile, true
	}
	return nil, false
}

func (p *ExternalVmImport) MustCpuProfile() *CpuProfile {
	if p.cpuProfile == nil {
		panic("the cpuProfile must not be nil, please use CpuProfile() function instead")
	}
	return p.cpuProfile
}

func (p *ExternalVmImport) SetDriversIso(attr *File) {
	p.driversIso = attr
}

func (p *ExternalVmImport) DriversIso() (*File, bool) {
	if p.driversIso != nil {
		return p.driversIso, true
	}
	return nil, false
}

func (p *ExternalVmImport) MustDriversIso() *File {
	if p.driversIso == nil {
		panic("the driversIso must not be nil, please use DriversIso() function instead")
	}
	return p.driversIso
}

func (p *ExternalVmImport) SetHost(attr *Host) {
	p.host = attr
}

func (p *ExternalVmImport) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *ExternalVmImport) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *ExternalVmImport) SetName(attr string) {
	p.name = &attr
}

func (p *ExternalVmImport) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ExternalVmImport) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *ExternalVmImport) SetPassword(attr string) {
	p.password = &attr
}

func (p *ExternalVmImport) Password() (string, bool) {
	if p.password != nil {
		return *p.password, true
	}
	var zero string
	return zero, false
}

func (p *ExternalVmImport) MustPassword() string {
	if p.password == nil {
		panic("the password must not be nil, please use Password() function instead")
	}
	return *p.password
}

func (p *ExternalVmImport) SetProvider(attr ExternalVmProviderType) {
	p.provider = &attr
}

func (p *ExternalVmImport) Provider() (ExternalVmProviderType, bool) {
	if p.provider != nil {
		return *p.provider, true
	}
	var zero ExternalVmProviderType
	return zero, false
}

func (p *ExternalVmImport) MustProvider() ExternalVmProviderType {
	if p.provider == nil {
		panic("the provider must not be nil, please use Provider() function instead")
	}
	return *p.provider
}

func (p *ExternalVmImport) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *ExternalVmImport) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *ExternalVmImport) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *ExternalVmImport) SetSparse(attr bool) {
	p.sparse = &attr
}

func (p *ExternalVmImport) Sparse() (bool, bool) {
	if p.sparse != nil {
		return *p.sparse, true
	}
	var zero bool
	return zero, false
}

func (p *ExternalVmImport) MustSparse() bool {
	if p.sparse == nil {
		panic("the sparse must not be nil, please use Sparse() function instead")
	}
	return *p.sparse
}

func (p *ExternalVmImport) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *ExternalVmImport) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *ExternalVmImport) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *ExternalVmImport) SetUrl(attr string) {
	p.url = &attr
}

func (p *ExternalVmImport) Url() (string, bool) {
	if p.url != nil {
		return *p.url, true
	}
	var zero string
	return zero, false
}

func (p *ExternalVmImport) MustUrl() string {
	if p.url == nil {
		panic("the url must not be nil, please use Url() function instead")
	}
	return *p.url
}

func (p *ExternalVmImport) SetUsername(attr string) {
	p.username = &attr
}

func (p *ExternalVmImport) Username() (string, bool) {
	if p.username != nil {
		return *p.username, true
	}
	var zero string
	return zero, false
}

func (p *ExternalVmImport) MustUsername() string {
	if p.username == nil {
		panic("the username must not be nil, please use Username() function instead")
	}
	return *p.username
}

func (p *ExternalVmImport) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *ExternalVmImport) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *ExternalVmImport) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type Package struct {
	Struct
	name *string
}

func (p *Package) SetName(attr string) {
	p.name = &attr
}

func (p *Package) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Package) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type Qos struct {
	Struct
	comment                   *string
	cpuLimit                  *int64
	dataCenter                *DataCenter
	description               *string
	id                        *string
	inboundAverage            *int64
	inboundBurst              *int64
	inboundPeak               *int64
	maxIops                   *int64
	maxReadIops               *int64
	maxReadThroughput         *int64
	maxThroughput             *int64
	maxWriteIops              *int64
	maxWriteThroughput        *int64
	name                      *string
	outboundAverage           *int64
	outboundAverageLinkshare  *int64
	outboundAverageRealtime   *int64
	outboundAverageUpperlimit *int64
	outboundBurst             *int64
	outboundPeak              *int64
	type_                     *QosType
}

func (p *Qos) SetComment(attr string) {
	p.comment = &attr
}

func (p *Qos) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Qos) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Qos) SetCpuLimit(attr int64) {
	p.cpuLimit = &attr
}

func (p *Qos) CpuLimit() (int64, bool) {
	if p.cpuLimit != nil {
		return *p.cpuLimit, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustCpuLimit() int64 {
	if p.cpuLimit == nil {
		panic("the cpuLimit must not be nil, please use CpuLimit() function instead")
	}
	return *p.cpuLimit
}

func (p *Qos) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *Qos) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *Qos) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *Qos) SetDescription(attr string) {
	p.description = &attr
}

func (p *Qos) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Qos) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Qos) SetId(attr string) {
	p.id = &attr
}

func (p *Qos) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Qos) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Qos) SetInboundAverage(attr int64) {
	p.inboundAverage = &attr
}

func (p *Qos) InboundAverage() (int64, bool) {
	if p.inboundAverage != nil {
		return *p.inboundAverage, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustInboundAverage() int64 {
	if p.inboundAverage == nil {
		panic("the inboundAverage must not be nil, please use InboundAverage() function instead")
	}
	return *p.inboundAverage
}

func (p *Qos) SetInboundBurst(attr int64) {
	p.inboundBurst = &attr
}

func (p *Qos) InboundBurst() (int64, bool) {
	if p.inboundBurst != nil {
		return *p.inboundBurst, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustInboundBurst() int64 {
	if p.inboundBurst == nil {
		panic("the inboundBurst must not be nil, please use InboundBurst() function instead")
	}
	return *p.inboundBurst
}

func (p *Qos) SetInboundPeak(attr int64) {
	p.inboundPeak = &attr
}

func (p *Qos) InboundPeak() (int64, bool) {
	if p.inboundPeak != nil {
		return *p.inboundPeak, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustInboundPeak() int64 {
	if p.inboundPeak == nil {
		panic("the inboundPeak must not be nil, please use InboundPeak() function instead")
	}
	return *p.inboundPeak
}

func (p *Qos) SetMaxIops(attr int64) {
	p.maxIops = &attr
}

func (p *Qos) MaxIops() (int64, bool) {
	if p.maxIops != nil {
		return *p.maxIops, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustMaxIops() int64 {
	if p.maxIops == nil {
		panic("the maxIops must not be nil, please use MaxIops() function instead")
	}
	return *p.maxIops
}

func (p *Qos) SetMaxReadIops(attr int64) {
	p.maxReadIops = &attr
}

func (p *Qos) MaxReadIops() (int64, bool) {
	if p.maxReadIops != nil {
		return *p.maxReadIops, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustMaxReadIops() int64 {
	if p.maxReadIops == nil {
		panic("the maxReadIops must not be nil, please use MaxReadIops() function instead")
	}
	return *p.maxReadIops
}

func (p *Qos) SetMaxReadThroughput(attr int64) {
	p.maxReadThroughput = &attr
}

func (p *Qos) MaxReadThroughput() (int64, bool) {
	if p.maxReadThroughput != nil {
		return *p.maxReadThroughput, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustMaxReadThroughput() int64 {
	if p.maxReadThroughput == nil {
		panic("the maxReadThroughput must not be nil, please use MaxReadThroughput() function instead")
	}
	return *p.maxReadThroughput
}

func (p *Qos) SetMaxThroughput(attr int64) {
	p.maxThroughput = &attr
}

func (p *Qos) MaxThroughput() (int64, bool) {
	if p.maxThroughput != nil {
		return *p.maxThroughput, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustMaxThroughput() int64 {
	if p.maxThroughput == nil {
		panic("the maxThroughput must not be nil, please use MaxThroughput() function instead")
	}
	return *p.maxThroughput
}

func (p *Qos) SetMaxWriteIops(attr int64) {
	p.maxWriteIops = &attr
}

func (p *Qos) MaxWriteIops() (int64, bool) {
	if p.maxWriteIops != nil {
		return *p.maxWriteIops, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustMaxWriteIops() int64 {
	if p.maxWriteIops == nil {
		panic("the maxWriteIops must not be nil, please use MaxWriteIops() function instead")
	}
	return *p.maxWriteIops
}

func (p *Qos) SetMaxWriteThroughput(attr int64) {
	p.maxWriteThroughput = &attr
}

func (p *Qos) MaxWriteThroughput() (int64, bool) {
	if p.maxWriteThroughput != nil {
		return *p.maxWriteThroughput, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustMaxWriteThroughput() int64 {
	if p.maxWriteThroughput == nil {
		panic("the maxWriteThroughput must not be nil, please use MaxWriteThroughput() function instead")
	}
	return *p.maxWriteThroughput
}

func (p *Qos) SetName(attr string) {
	p.name = &attr
}

func (p *Qos) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Qos) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Qos) SetOutboundAverage(attr int64) {
	p.outboundAverage = &attr
}

func (p *Qos) OutboundAverage() (int64, bool) {
	if p.outboundAverage != nil {
		return *p.outboundAverage, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustOutboundAverage() int64 {
	if p.outboundAverage == nil {
		panic("the outboundAverage must not be nil, please use OutboundAverage() function instead")
	}
	return *p.outboundAverage
}

func (p *Qos) SetOutboundAverageLinkshare(attr int64) {
	p.outboundAverageLinkshare = &attr
}

func (p *Qos) OutboundAverageLinkshare() (int64, bool) {
	if p.outboundAverageLinkshare != nil {
		return *p.outboundAverageLinkshare, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustOutboundAverageLinkshare() int64 {
	if p.outboundAverageLinkshare == nil {
		panic("the outboundAverageLinkshare must not be nil, please use OutboundAverageLinkshare() function instead")
	}
	return *p.outboundAverageLinkshare
}

func (p *Qos) SetOutboundAverageRealtime(attr int64) {
	p.outboundAverageRealtime = &attr
}

func (p *Qos) OutboundAverageRealtime() (int64, bool) {
	if p.outboundAverageRealtime != nil {
		return *p.outboundAverageRealtime, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustOutboundAverageRealtime() int64 {
	if p.outboundAverageRealtime == nil {
		panic("the outboundAverageRealtime must not be nil, please use OutboundAverageRealtime() function instead")
	}
	return *p.outboundAverageRealtime
}

func (p *Qos) SetOutboundAverageUpperlimit(attr int64) {
	p.outboundAverageUpperlimit = &attr
}

func (p *Qos) OutboundAverageUpperlimit() (int64, bool) {
	if p.outboundAverageUpperlimit != nil {
		return *p.outboundAverageUpperlimit, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustOutboundAverageUpperlimit() int64 {
	if p.outboundAverageUpperlimit == nil {
		panic("the outboundAverageUpperlimit must not be nil, please use OutboundAverageUpperlimit() function instead")
	}
	return *p.outboundAverageUpperlimit
}

func (p *Qos) SetOutboundBurst(attr int64) {
	p.outboundBurst = &attr
}

func (p *Qos) OutboundBurst() (int64, bool) {
	if p.outboundBurst != nil {
		return *p.outboundBurst, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustOutboundBurst() int64 {
	if p.outboundBurst == nil {
		panic("the outboundBurst must not be nil, please use OutboundBurst() function instead")
	}
	return *p.outboundBurst
}

func (p *Qos) SetOutboundPeak(attr int64) {
	p.outboundPeak = &attr
}

func (p *Qos) OutboundPeak() (int64, bool) {
	if p.outboundPeak != nil {
		return *p.outboundPeak, true
	}
	var zero int64
	return zero, false
}

func (p *Qos) MustOutboundPeak() int64 {
	if p.outboundPeak == nil {
		panic("the outboundPeak must not be nil, please use OutboundPeak() function instead")
	}
	return *p.outboundPeak
}

func (p *Qos) SetType(attr QosType) {
	p.type_ = &attr
}

func (p *Qos) Type() (QosType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero QosType
	return zero, false
}

func (p *Qos) MustType() QosType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type NicConfiguration struct {
	Struct
	bootProtocol     *BootProtocol
	ip               *Ip
	ipv6             *Ip
	ipv6BootProtocol *BootProtocol
	name             *string
	onBoot           *bool
}

func (p *NicConfiguration) SetBootProtocol(attr BootProtocol) {
	p.bootProtocol = &attr
}

func (p *NicConfiguration) BootProtocol() (BootProtocol, bool) {
	if p.bootProtocol != nil {
		return *p.bootProtocol, true
	}
	var zero BootProtocol
	return zero, false
}

func (p *NicConfiguration) MustBootProtocol() BootProtocol {
	if p.bootProtocol == nil {
		panic("the bootProtocol must not be nil, please use BootProtocol() function instead")
	}
	return *p.bootProtocol
}

func (p *NicConfiguration) SetIp(attr *Ip) {
	p.ip = attr
}

func (p *NicConfiguration) Ip() (*Ip, bool) {
	if p.ip != nil {
		return p.ip, true
	}
	return nil, false
}

func (p *NicConfiguration) MustIp() *Ip {
	if p.ip == nil {
		panic("the ip must not be nil, please use Ip() function instead")
	}
	return p.ip
}

func (p *NicConfiguration) SetIpv6(attr *Ip) {
	p.ipv6 = attr
}

func (p *NicConfiguration) Ipv6() (*Ip, bool) {
	if p.ipv6 != nil {
		return p.ipv6, true
	}
	return nil, false
}

func (p *NicConfiguration) MustIpv6() *Ip {
	if p.ipv6 == nil {
		panic("the ipv6 must not be nil, please use Ipv6() function instead")
	}
	return p.ipv6
}

func (p *NicConfiguration) SetIpv6BootProtocol(attr BootProtocol) {
	p.ipv6BootProtocol = &attr
}

func (p *NicConfiguration) Ipv6BootProtocol() (BootProtocol, bool) {
	if p.ipv6BootProtocol != nil {
		return *p.ipv6BootProtocol, true
	}
	var zero BootProtocol
	return zero, false
}

func (p *NicConfiguration) MustIpv6BootProtocol() BootProtocol {
	if p.ipv6BootProtocol == nil {
		panic("the ipv6BootProtocol must not be nil, please use Ipv6BootProtocol() function instead")
	}
	return *p.ipv6BootProtocol
}

func (p *NicConfiguration) SetName(attr string) {
	p.name = &attr
}

func (p *NicConfiguration) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *NicConfiguration) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *NicConfiguration) SetOnBoot(attr bool) {
	p.onBoot = &attr
}

func (p *NicConfiguration) OnBoot() (bool, bool) {
	if p.onBoot != nil {
		return *p.onBoot, true
	}
	var zero bool
	return zero, false
}

func (p *NicConfiguration) MustOnBoot() bool {
	if p.onBoot == nil {
		panic("the onBoot must not be nil, please use OnBoot() function instead")
	}
	return *p.onBoot
}

type BlockStatistic struct {
	Struct
	statistics *StatisticSlice
}

func (p *BlockStatistic) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *BlockStatistic) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *BlockStatistic) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

type HighAvailability struct {
	Struct
	enabled  *bool
	priority *int64
}

func (p *HighAvailability) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *HighAvailability) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *HighAvailability) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

func (p *HighAvailability) SetPriority(attr int64) {
	p.priority = &attr
}

func (p *HighAvailability) Priority() (int64, bool) {
	if p.priority != nil {
		return *p.priority, true
	}
	var zero int64
	return zero, false
}

func (p *HighAvailability) MustPriority() int64 {
	if p.priority == nil {
		panic("the priority must not be nil, please use Priority() function instead")
	}
	return *p.priority
}

type DiskSnapshot struct {
	Struct
	active              *bool
	actualSize          *int64
	alias               *string
	backup              *DiskBackup
	bootable            *bool
	comment             *string
	contentType         *DiskContentType
	description         *string
	disk                *Disk
	diskProfile         *DiskProfile
	diskSnapshots       *DiskSnapshotSlice
	externalDisk        *string
	format              *DiskFormat
	id                  *string
	imageId             *string
	initialSize         *int64
	instanceType        *InstanceType
	interface_          *DiskInterface
	logicalName         *string
	lunStorage          *HostStorage
	name                *string
	openstackVolumeType *OpenStackVolumeType
	parent              *DiskSnapshot
	permissions         *PermissionSlice
	propagateErrors     *bool
	provisionedSize     *int64
	qcowVersion         *QcowVersion
	quota               *Quota
	readOnly            *bool
	sgio                *ScsiGenericIO
	shareable           *bool
	snapshot            *Snapshot
	sparse              *bool
	statistics          *StatisticSlice
	status              *DiskStatus
	storageDomain       *StorageDomain
	storageDomains      *StorageDomainSlice
	storageType         *DiskStorageType
	template            *Template
	totalSize           *int64
	usesScsiReservation *bool
	vm                  *Vm
	vms                 *VmSlice
	wipeAfterDelete     *bool
}

func (p *DiskSnapshot) SetActive(attr bool) {
	p.active = &attr
}

func (p *DiskSnapshot) Active() (bool, bool) {
	if p.active != nil {
		return *p.active, true
	}
	var zero bool
	return zero, false
}

func (p *DiskSnapshot) MustActive() bool {
	if p.active == nil {
		panic("the active must not be nil, please use Active() function instead")
	}
	return *p.active
}

func (p *DiskSnapshot) SetActualSize(attr int64) {
	p.actualSize = &attr
}

func (p *DiskSnapshot) ActualSize() (int64, bool) {
	if p.actualSize != nil {
		return *p.actualSize, true
	}
	var zero int64
	return zero, false
}

func (p *DiskSnapshot) MustActualSize() int64 {
	if p.actualSize == nil {
		panic("the actualSize must not be nil, please use ActualSize() function instead")
	}
	return *p.actualSize
}

func (p *DiskSnapshot) SetAlias(attr string) {
	p.alias = &attr
}

func (p *DiskSnapshot) Alias() (string, bool) {
	if p.alias != nil {
		return *p.alias, true
	}
	var zero string
	return zero, false
}

func (p *DiskSnapshot) MustAlias() string {
	if p.alias == nil {
		panic("the alias must not be nil, please use Alias() function instead")
	}
	return *p.alias
}

func (p *DiskSnapshot) SetBackup(attr DiskBackup) {
	p.backup = &attr
}

func (p *DiskSnapshot) Backup() (DiskBackup, bool) {
	if p.backup != nil {
		return *p.backup, true
	}
	var zero DiskBackup
	return zero, false
}

func (p *DiskSnapshot) MustBackup() DiskBackup {
	if p.backup == nil {
		panic("the backup must not be nil, please use Backup() function instead")
	}
	return *p.backup
}

func (p *DiskSnapshot) SetBootable(attr bool) {
	p.bootable = &attr
}

func (p *DiskSnapshot) Bootable() (bool, bool) {
	if p.bootable != nil {
		return *p.bootable, true
	}
	var zero bool
	return zero, false
}

func (p *DiskSnapshot) MustBootable() bool {
	if p.bootable == nil {
		panic("the bootable must not be nil, please use Bootable() function instead")
	}
	return *p.bootable
}

func (p *DiskSnapshot) SetComment(attr string) {
	p.comment = &attr
}

func (p *DiskSnapshot) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *DiskSnapshot) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *DiskSnapshot) SetContentType(attr DiskContentType) {
	p.contentType = &attr
}

func (p *DiskSnapshot) ContentType() (DiskContentType, bool) {
	if p.contentType != nil {
		return *p.contentType, true
	}
	var zero DiskContentType
	return zero, false
}

func (p *DiskSnapshot) MustContentType() DiskContentType {
	if p.contentType == nil {
		panic("the contentType must not be nil, please use ContentType() function instead")
	}
	return *p.contentType
}

func (p *DiskSnapshot) SetDescription(attr string) {
	p.description = &attr
}

func (p *DiskSnapshot) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *DiskSnapshot) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *DiskSnapshot) SetDisk(attr *Disk) {
	p.disk = attr
}

func (p *DiskSnapshot) Disk() (*Disk, bool) {
	if p.disk != nil {
		return p.disk, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustDisk() *Disk {
	if p.disk == nil {
		panic("the disk must not be nil, please use Disk() function instead")
	}
	return p.disk
}

func (p *DiskSnapshot) SetDiskProfile(attr *DiskProfile) {
	p.diskProfile = attr
}

func (p *DiskSnapshot) DiskProfile() (*DiskProfile, bool) {
	if p.diskProfile != nil {
		return p.diskProfile, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustDiskProfile() *DiskProfile {
	if p.diskProfile == nil {
		panic("the diskProfile must not be nil, please use DiskProfile() function instead")
	}
	return p.diskProfile
}

func (p *DiskSnapshot) SetDiskSnapshots(attr *DiskSnapshotSlice) {
	p.diskSnapshots = attr
}

func (p *DiskSnapshot) DiskSnapshots() (*DiskSnapshotSlice, bool) {
	if p.diskSnapshots != nil {
		return p.diskSnapshots, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustDiskSnapshots() *DiskSnapshotSlice {
	if p.diskSnapshots == nil {
		panic("the diskSnapshots must not be nil, please use DiskSnapshots() function instead")
	}
	return p.diskSnapshots
}

func (p *DiskSnapshot) SetExternalDisk(attr string) {
	p.externalDisk = &attr
}

func (p *DiskSnapshot) ExternalDisk() (string, bool) {
	if p.externalDisk != nil {
		return *p.externalDisk, true
	}
	var zero string
	return zero, false
}

func (p *DiskSnapshot) MustExternalDisk() string {
	if p.externalDisk == nil {
		panic("the externalDisk must not be nil, please use ExternalDisk() function instead")
	}
	return *p.externalDisk
}

func (p *DiskSnapshot) SetFormat(attr DiskFormat) {
	p.format = &attr
}

func (p *DiskSnapshot) Format() (DiskFormat, bool) {
	if p.format != nil {
		return *p.format, true
	}
	var zero DiskFormat
	return zero, false
}

func (p *DiskSnapshot) MustFormat() DiskFormat {
	if p.format == nil {
		panic("the format must not be nil, please use Format() function instead")
	}
	return *p.format
}

func (p *DiskSnapshot) SetId(attr string) {
	p.id = &attr
}

func (p *DiskSnapshot) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *DiskSnapshot) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *DiskSnapshot) SetImageId(attr string) {
	p.imageId = &attr
}

func (p *DiskSnapshot) ImageId() (string, bool) {
	if p.imageId != nil {
		return *p.imageId, true
	}
	var zero string
	return zero, false
}

func (p *DiskSnapshot) MustImageId() string {
	if p.imageId == nil {
		panic("the imageId must not be nil, please use ImageId() function instead")
	}
	return *p.imageId
}

func (p *DiskSnapshot) SetInitialSize(attr int64) {
	p.initialSize = &attr
}

func (p *DiskSnapshot) InitialSize() (int64, bool) {
	if p.initialSize != nil {
		return *p.initialSize, true
	}
	var zero int64
	return zero, false
}

func (p *DiskSnapshot) MustInitialSize() int64 {
	if p.initialSize == nil {
		panic("the initialSize must not be nil, please use InitialSize() function instead")
	}
	return *p.initialSize
}

func (p *DiskSnapshot) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *DiskSnapshot) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *DiskSnapshot) SetInterface(attr DiskInterface) {
	p.interface_ = &attr
}

func (p *DiskSnapshot) Interface() (DiskInterface, bool) {
	if p.interface_ != nil {
		return *p.interface_, true
	}
	var zero DiskInterface
	return zero, false
}

func (p *DiskSnapshot) MustInterface() DiskInterface {
	if p.interface_ == nil {
		panic("the interface_ must not be nil, please use Interface() function instead")
	}
	return *p.interface_
}

func (p *DiskSnapshot) SetLogicalName(attr string) {
	p.logicalName = &attr
}

func (p *DiskSnapshot) LogicalName() (string, bool) {
	if p.logicalName != nil {
		return *p.logicalName, true
	}
	var zero string
	return zero, false
}

func (p *DiskSnapshot) MustLogicalName() string {
	if p.logicalName == nil {
		panic("the logicalName must not be nil, please use LogicalName() function instead")
	}
	return *p.logicalName
}

func (p *DiskSnapshot) SetLunStorage(attr *HostStorage) {
	p.lunStorage = attr
}

func (p *DiskSnapshot) LunStorage() (*HostStorage, bool) {
	if p.lunStorage != nil {
		return p.lunStorage, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustLunStorage() *HostStorage {
	if p.lunStorage == nil {
		panic("the lunStorage must not be nil, please use LunStorage() function instead")
	}
	return p.lunStorage
}

func (p *DiskSnapshot) SetName(attr string) {
	p.name = &attr
}

func (p *DiskSnapshot) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *DiskSnapshot) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *DiskSnapshot) SetOpenstackVolumeType(attr *OpenStackVolumeType) {
	p.openstackVolumeType = attr
}

func (p *DiskSnapshot) OpenstackVolumeType() (*OpenStackVolumeType, bool) {
	if p.openstackVolumeType != nil {
		return p.openstackVolumeType, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustOpenstackVolumeType() *OpenStackVolumeType {
	if p.openstackVolumeType == nil {
		panic("the openstackVolumeType must not be nil, please use OpenstackVolumeType() function instead")
	}
	return p.openstackVolumeType
}

func (p *DiskSnapshot) SetParent(attr *DiskSnapshot) {
	p.parent = attr
}

func (p *DiskSnapshot) Parent() (*DiskSnapshot, bool) {
	if p.parent != nil {
		return p.parent, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustParent() *DiskSnapshot {
	if p.parent == nil {
		panic("the parent must not be nil, please use Parent() function instead")
	}
	return p.parent
}

func (p *DiskSnapshot) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *DiskSnapshot) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *DiskSnapshot) SetPropagateErrors(attr bool) {
	p.propagateErrors = &attr
}

func (p *DiskSnapshot) PropagateErrors() (bool, bool) {
	if p.propagateErrors != nil {
		return *p.propagateErrors, true
	}
	var zero bool
	return zero, false
}

func (p *DiskSnapshot) MustPropagateErrors() bool {
	if p.propagateErrors == nil {
		panic("the propagateErrors must not be nil, please use PropagateErrors() function instead")
	}
	return *p.propagateErrors
}

func (p *DiskSnapshot) SetProvisionedSize(attr int64) {
	p.provisionedSize = &attr
}

func (p *DiskSnapshot) ProvisionedSize() (int64, bool) {
	if p.provisionedSize != nil {
		return *p.provisionedSize, true
	}
	var zero int64
	return zero, false
}

func (p *DiskSnapshot) MustProvisionedSize() int64 {
	if p.provisionedSize == nil {
		panic("the provisionedSize must not be nil, please use ProvisionedSize() function instead")
	}
	return *p.provisionedSize
}

func (p *DiskSnapshot) SetQcowVersion(attr QcowVersion) {
	p.qcowVersion = &attr
}

func (p *DiskSnapshot) QcowVersion() (QcowVersion, bool) {
	if p.qcowVersion != nil {
		return *p.qcowVersion, true
	}
	var zero QcowVersion
	return zero, false
}

func (p *DiskSnapshot) MustQcowVersion() QcowVersion {
	if p.qcowVersion == nil {
		panic("the qcowVersion must not be nil, please use QcowVersion() function instead")
	}
	return *p.qcowVersion
}

func (p *DiskSnapshot) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *DiskSnapshot) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *DiskSnapshot) SetReadOnly(attr bool) {
	p.readOnly = &attr
}

func (p *DiskSnapshot) ReadOnly() (bool, bool) {
	if p.readOnly != nil {
		return *p.readOnly, true
	}
	var zero bool
	return zero, false
}

func (p *DiskSnapshot) MustReadOnly() bool {
	if p.readOnly == nil {
		panic("the readOnly must not be nil, please use ReadOnly() function instead")
	}
	return *p.readOnly
}

func (p *DiskSnapshot) SetSgio(attr ScsiGenericIO) {
	p.sgio = &attr
}

func (p *DiskSnapshot) Sgio() (ScsiGenericIO, bool) {
	if p.sgio != nil {
		return *p.sgio, true
	}
	var zero ScsiGenericIO
	return zero, false
}

func (p *DiskSnapshot) MustSgio() ScsiGenericIO {
	if p.sgio == nil {
		panic("the sgio must not be nil, please use Sgio() function instead")
	}
	return *p.sgio
}

func (p *DiskSnapshot) SetShareable(attr bool) {
	p.shareable = &attr
}

func (p *DiskSnapshot) Shareable() (bool, bool) {
	if p.shareable != nil {
		return *p.shareable, true
	}
	var zero bool
	return zero, false
}

func (p *DiskSnapshot) MustShareable() bool {
	if p.shareable == nil {
		panic("the shareable must not be nil, please use Shareable() function instead")
	}
	return *p.shareable
}

func (p *DiskSnapshot) SetSnapshot(attr *Snapshot) {
	p.snapshot = attr
}

func (p *DiskSnapshot) Snapshot() (*Snapshot, bool) {
	if p.snapshot != nil {
		return p.snapshot, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustSnapshot() *Snapshot {
	if p.snapshot == nil {
		panic("the snapshot must not be nil, please use Snapshot() function instead")
	}
	return p.snapshot
}

func (p *DiskSnapshot) SetSparse(attr bool) {
	p.sparse = &attr
}

func (p *DiskSnapshot) Sparse() (bool, bool) {
	if p.sparse != nil {
		return *p.sparse, true
	}
	var zero bool
	return zero, false
}

func (p *DiskSnapshot) MustSparse() bool {
	if p.sparse == nil {
		panic("the sparse must not be nil, please use Sparse() function instead")
	}
	return *p.sparse
}

func (p *DiskSnapshot) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *DiskSnapshot) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *DiskSnapshot) SetStatus(attr DiskStatus) {
	p.status = &attr
}

func (p *DiskSnapshot) Status() (DiskStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero DiskStatus
	return zero, false
}

func (p *DiskSnapshot) MustStatus() DiskStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *DiskSnapshot) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *DiskSnapshot) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *DiskSnapshot) SetStorageDomains(attr *StorageDomainSlice) {
	p.storageDomains = attr
}

func (p *DiskSnapshot) StorageDomains() (*StorageDomainSlice, bool) {
	if p.storageDomains != nil {
		return p.storageDomains, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustStorageDomains() *StorageDomainSlice {
	if p.storageDomains == nil {
		panic("the storageDomains must not be nil, please use StorageDomains() function instead")
	}
	return p.storageDomains
}

func (p *DiskSnapshot) SetStorageType(attr DiskStorageType) {
	p.storageType = &attr
}

func (p *DiskSnapshot) StorageType() (DiskStorageType, bool) {
	if p.storageType != nil {
		return *p.storageType, true
	}
	var zero DiskStorageType
	return zero, false
}

func (p *DiskSnapshot) MustStorageType() DiskStorageType {
	if p.storageType == nil {
		panic("the storageType must not be nil, please use StorageType() function instead")
	}
	return *p.storageType
}

func (p *DiskSnapshot) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *DiskSnapshot) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *DiskSnapshot) SetTotalSize(attr int64) {
	p.totalSize = &attr
}

func (p *DiskSnapshot) TotalSize() (int64, bool) {
	if p.totalSize != nil {
		return *p.totalSize, true
	}
	var zero int64
	return zero, false
}

func (p *DiskSnapshot) MustTotalSize() int64 {
	if p.totalSize == nil {
		panic("the totalSize must not be nil, please use TotalSize() function instead")
	}
	return *p.totalSize
}

func (p *DiskSnapshot) SetUsesScsiReservation(attr bool) {
	p.usesScsiReservation = &attr
}

func (p *DiskSnapshot) UsesScsiReservation() (bool, bool) {
	if p.usesScsiReservation != nil {
		return *p.usesScsiReservation, true
	}
	var zero bool
	return zero, false
}

func (p *DiskSnapshot) MustUsesScsiReservation() bool {
	if p.usesScsiReservation == nil {
		panic("the usesScsiReservation must not be nil, please use UsesScsiReservation() function instead")
	}
	return *p.usesScsiReservation
}

func (p *DiskSnapshot) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *DiskSnapshot) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *DiskSnapshot) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *DiskSnapshot) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *DiskSnapshot) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

func (p *DiskSnapshot) SetWipeAfterDelete(attr bool) {
	p.wipeAfterDelete = &attr
}

func (p *DiskSnapshot) WipeAfterDelete() (bool, bool) {
	if p.wipeAfterDelete != nil {
		return *p.wipeAfterDelete, true
	}
	var zero bool
	return zero, false
}

func (p *DiskSnapshot) MustWipeAfterDelete() bool {
	if p.wipeAfterDelete == nil {
		panic("the wipeAfterDelete must not be nil, please use WipeAfterDelete() function instead")
	}
	return *p.wipeAfterDelete
}

type Cdrom struct {
	Struct
	comment      *string
	description  *string
	file         *File
	id           *string
	instanceType *InstanceType
	name         *string
	template     *Template
	vm           *Vm
	vms          *VmSlice
}

func (p *Cdrom) SetComment(attr string) {
	p.comment = &attr
}

func (p *Cdrom) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Cdrom) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Cdrom) SetDescription(attr string) {
	p.description = &attr
}

func (p *Cdrom) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Cdrom) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Cdrom) SetFile(attr *File) {
	p.file = attr
}

func (p *Cdrom) File() (*File, bool) {
	if p.file != nil {
		return p.file, true
	}
	return nil, false
}

func (p *Cdrom) MustFile() *File {
	if p.file == nil {
		panic("the file must not be nil, please use File() function instead")
	}
	return p.file
}

func (p *Cdrom) SetId(attr string) {
	p.id = &attr
}

func (p *Cdrom) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Cdrom) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Cdrom) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *Cdrom) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *Cdrom) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *Cdrom) SetName(attr string) {
	p.name = &attr
}

func (p *Cdrom) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Cdrom) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Cdrom) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Cdrom) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Cdrom) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Cdrom) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Cdrom) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Cdrom) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Cdrom) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *Cdrom) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *Cdrom) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

type Console struct {
	Struct
	enabled *bool
}

func (p *Console) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *Console) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *Console) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

type FencingPolicy struct {
	Struct
	enabled                   *bool
	skipIfConnectivityBroken  *SkipIfConnectivityBroken
	skipIfGlusterBricksUp     *bool
	skipIfGlusterQuorumNotMet *bool
	skipIfSdActive            *SkipIfSdActive
}

func (p *FencingPolicy) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *FencingPolicy) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *FencingPolicy) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

func (p *FencingPolicy) SetSkipIfConnectivityBroken(attr *SkipIfConnectivityBroken) {
	p.skipIfConnectivityBroken = attr
}

func (p *FencingPolicy) SkipIfConnectivityBroken() (*SkipIfConnectivityBroken, bool) {
	if p.skipIfConnectivityBroken != nil {
		return p.skipIfConnectivityBroken, true
	}
	return nil, false
}

func (p *FencingPolicy) MustSkipIfConnectivityBroken() *SkipIfConnectivityBroken {
	if p.skipIfConnectivityBroken == nil {
		panic("the skipIfConnectivityBroken must not be nil, please use SkipIfConnectivityBroken() function instead")
	}
	return p.skipIfConnectivityBroken
}

func (p *FencingPolicy) SetSkipIfGlusterBricksUp(attr bool) {
	p.skipIfGlusterBricksUp = &attr
}

func (p *FencingPolicy) SkipIfGlusterBricksUp() (bool, bool) {
	if p.skipIfGlusterBricksUp != nil {
		return *p.skipIfGlusterBricksUp, true
	}
	var zero bool
	return zero, false
}

func (p *FencingPolicy) MustSkipIfGlusterBricksUp() bool {
	if p.skipIfGlusterBricksUp == nil {
		panic("the skipIfGlusterBricksUp must not be nil, please use SkipIfGlusterBricksUp() function instead")
	}
	return *p.skipIfGlusterBricksUp
}

func (p *FencingPolicy) SetSkipIfGlusterQuorumNotMet(attr bool) {
	p.skipIfGlusterQuorumNotMet = &attr
}

func (p *FencingPolicy) SkipIfGlusterQuorumNotMet() (bool, bool) {
	if p.skipIfGlusterQuorumNotMet != nil {
		return *p.skipIfGlusterQuorumNotMet, true
	}
	var zero bool
	return zero, false
}

func (p *FencingPolicy) MustSkipIfGlusterQuorumNotMet() bool {
	if p.skipIfGlusterQuorumNotMet == nil {
		panic("the skipIfGlusterQuorumNotMet must not be nil, please use SkipIfGlusterQuorumNotMet() function instead")
	}
	return *p.skipIfGlusterQuorumNotMet
}

func (p *FencingPolicy) SetSkipIfSdActive(attr *SkipIfSdActive) {
	p.skipIfSdActive = attr
}

func (p *FencingPolicy) SkipIfSdActive() (*SkipIfSdActive, bool) {
	if p.skipIfSdActive != nil {
		return p.skipIfSdActive, true
	}
	return nil, false
}

func (p *FencingPolicy) MustSkipIfSdActive() *SkipIfSdActive {
	if p.skipIfSdActive == nil {
		panic("the skipIfSdActive must not be nil, please use SkipIfSdActive() function instead")
	}
	return p.skipIfSdActive
}

type SkipIfSdActive struct {
	Struct
	enabled *bool
}

func (p *SkipIfSdActive) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *SkipIfSdActive) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *SkipIfSdActive) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

type Payload struct {
	Struct
	files    *FileSlice
	type_    *VmDeviceType
	volumeId *string
}

func (p *Payload) SetFiles(attr *FileSlice) {
	p.files = attr
}

func (p *Payload) Files() (*FileSlice, bool) {
	if p.files != nil {
		return p.files, true
	}
	return nil, false
}

func (p *Payload) MustFiles() *FileSlice {
	if p.files == nil {
		panic("the files must not be nil, please use Files() function instead")
	}
	return p.files
}

func (p *Payload) SetType(attr VmDeviceType) {
	p.type_ = &attr
}

func (p *Payload) Type() (VmDeviceType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero VmDeviceType
	return zero, false
}

func (p *Payload) MustType() VmDeviceType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *Payload) SetVolumeId(attr string) {
	p.volumeId = &attr
}

func (p *Payload) VolumeId() (string, bool) {
	if p.volumeId != nil {
		return *p.volumeId, true
	}
	var zero string
	return zero, false
}

func (p *Payload) MustVolumeId() string {
	if p.volumeId == nil {
		panic("the volumeId must not be nil, please use VolumeId() function instead")
	}
	return *p.volumeId
}

type SshPublicKey struct {
	Struct
	comment     *string
	content     *string
	description *string
	id          *string
	name        *string
	user        *User
}

func (p *SshPublicKey) SetComment(attr string) {
	p.comment = &attr
}

func (p *SshPublicKey) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *SshPublicKey) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *SshPublicKey) SetContent(attr string) {
	p.content = &attr
}

func (p *SshPublicKey) Content() (string, bool) {
	if p.content != nil {
		return *p.content, true
	}
	var zero string
	return zero, false
}

func (p *SshPublicKey) MustContent() string {
	if p.content == nil {
		panic("the content must not be nil, please use Content() function instead")
	}
	return *p.content
}

func (p *SshPublicKey) SetDescription(attr string) {
	p.description = &attr
}

func (p *SshPublicKey) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *SshPublicKey) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *SshPublicKey) SetId(attr string) {
	p.id = &attr
}

func (p *SshPublicKey) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *SshPublicKey) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *SshPublicKey) SetName(attr string) {
	p.name = &attr
}

func (p *SshPublicKey) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *SshPublicKey) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *SshPublicKey) SetUser(attr *User) {
	p.user = attr
}

func (p *SshPublicKey) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *SshPublicKey) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

type ApiSummaryItem struct {
	Struct
	active *int64
	total  *int64
}

func (p *ApiSummaryItem) SetActive(attr int64) {
	p.active = &attr
}

func (p *ApiSummaryItem) Active() (int64, bool) {
	if p.active != nil {
		return *p.active, true
	}
	var zero int64
	return zero, false
}

func (p *ApiSummaryItem) MustActive() int64 {
	if p.active == nil {
		panic("the active must not be nil, please use Active() function instead")
	}
	return *p.active
}

func (p *ApiSummaryItem) SetTotal(attr int64) {
	p.total = &attr
}

func (p *ApiSummaryItem) Total() (int64, bool) {
	if p.total != nil {
		return *p.total, true
	}
	var zero int64
	return zero, false
}

func (p *ApiSummaryItem) MustTotal() int64 {
	if p.total == nil {
		panic("the total must not be nil, please use Total() function instead")
	}
	return *p.total
}

type Disk struct {
	Struct
	active              *bool
	actualSize          *int64
	alias               *string
	backup              *DiskBackup
	bootable            *bool
	comment             *string
	contentType         *DiskContentType
	description         *string
	diskProfile         *DiskProfile
	diskSnapshots       *DiskSnapshotSlice
	externalDisk        *string
	format              *DiskFormat
	id                  *string
	imageId             *string
	initialSize         *int64
	instanceType        *InstanceType
	interface_          *DiskInterface
	logicalName         *string
	lunStorage          *HostStorage
	name                *string
	openstackVolumeType *OpenStackVolumeType
	permissions         *PermissionSlice
	propagateErrors     *bool
	provisionedSize     *int64
	qcowVersion         *QcowVersion
	quota               *Quota
	readOnly            *bool
	sgio                *ScsiGenericIO
	shareable           *bool
	snapshot            *Snapshot
	sparse              *bool
	statistics          *StatisticSlice
	status              *DiskStatus
	storageDomain       *StorageDomain
	storageDomains      *StorageDomainSlice
	storageType         *DiskStorageType
	template            *Template
	totalSize           *int64
	usesScsiReservation *bool
	vm                  *Vm
	vms                 *VmSlice
	wipeAfterDelete     *bool
}

func (p *Disk) SetActive(attr bool) {
	p.active = &attr
}

func (p *Disk) Active() (bool, bool) {
	if p.active != nil {
		return *p.active, true
	}
	var zero bool
	return zero, false
}

func (p *Disk) MustActive() bool {
	if p.active == nil {
		panic("the active must not be nil, please use Active() function instead")
	}
	return *p.active
}

func (p *Disk) SetActualSize(attr int64) {
	p.actualSize = &attr
}

func (p *Disk) ActualSize() (int64, bool) {
	if p.actualSize != nil {
		return *p.actualSize, true
	}
	var zero int64
	return zero, false
}

func (p *Disk) MustActualSize() int64 {
	if p.actualSize == nil {
		panic("the actualSize must not be nil, please use ActualSize() function instead")
	}
	return *p.actualSize
}

func (p *Disk) SetAlias(attr string) {
	p.alias = &attr
}

func (p *Disk) Alias() (string, bool) {
	if p.alias != nil {
		return *p.alias, true
	}
	var zero string
	return zero, false
}

func (p *Disk) MustAlias() string {
	if p.alias == nil {
		panic("the alias must not be nil, please use Alias() function instead")
	}
	return *p.alias
}

func (p *Disk) SetBackup(attr DiskBackup) {
	p.backup = &attr
}

func (p *Disk) Backup() (DiskBackup, bool) {
	if p.backup != nil {
		return *p.backup, true
	}
	var zero DiskBackup
	return zero, false
}

func (p *Disk) MustBackup() DiskBackup {
	if p.backup == nil {
		panic("the backup must not be nil, please use Backup() function instead")
	}
	return *p.backup
}

func (p *Disk) SetBootable(attr bool) {
	p.bootable = &attr
}

func (p *Disk) Bootable() (bool, bool) {
	if p.bootable != nil {
		return *p.bootable, true
	}
	var zero bool
	return zero, false
}

func (p *Disk) MustBootable() bool {
	if p.bootable == nil {
		panic("the bootable must not be nil, please use Bootable() function instead")
	}
	return *p.bootable
}

func (p *Disk) SetComment(attr string) {
	p.comment = &attr
}

func (p *Disk) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Disk) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Disk) SetContentType(attr DiskContentType) {
	p.contentType = &attr
}

func (p *Disk) ContentType() (DiskContentType, bool) {
	if p.contentType != nil {
		return *p.contentType, true
	}
	var zero DiskContentType
	return zero, false
}

func (p *Disk) MustContentType() DiskContentType {
	if p.contentType == nil {
		panic("the contentType must not be nil, please use ContentType() function instead")
	}
	return *p.contentType
}

func (p *Disk) SetDescription(attr string) {
	p.description = &attr
}

func (p *Disk) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Disk) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Disk) SetDiskProfile(attr *DiskProfile) {
	p.diskProfile = attr
}

func (p *Disk) DiskProfile() (*DiskProfile, bool) {
	if p.diskProfile != nil {
		return p.diskProfile, true
	}
	return nil, false
}

func (p *Disk) MustDiskProfile() *DiskProfile {
	if p.diskProfile == nil {
		panic("the diskProfile must not be nil, please use DiskProfile() function instead")
	}
	return p.diskProfile
}

func (p *Disk) SetDiskSnapshots(attr *DiskSnapshotSlice) {
	p.diskSnapshots = attr
}

func (p *Disk) DiskSnapshots() (*DiskSnapshotSlice, bool) {
	if p.diskSnapshots != nil {
		return p.diskSnapshots, true
	}
	return nil, false
}

func (p *Disk) MustDiskSnapshots() *DiskSnapshotSlice {
	if p.diskSnapshots == nil {
		panic("the diskSnapshots must not be nil, please use DiskSnapshots() function instead")
	}
	return p.diskSnapshots
}

func (p *Disk) SetExternalDisk(attr string) {
	p.externalDisk = &attr
}

func (p *Disk) ExternalDisk() (string, bool) {
	if p.externalDisk != nil {
		return *p.externalDisk, true
	}
	var zero string
	return zero, false
}

func (p *Disk) MustExternalDisk() string {
	if p.externalDisk == nil {
		panic("the externalDisk must not be nil, please use ExternalDisk() function instead")
	}
	return *p.externalDisk
}

func (p *Disk) SetFormat(attr DiskFormat) {
	p.format = &attr
}

func (p *Disk) Format() (DiskFormat, bool) {
	if p.format != nil {
		return *p.format, true
	}
	var zero DiskFormat
	return zero, false
}

func (p *Disk) MustFormat() DiskFormat {
	if p.format == nil {
		panic("the format must not be nil, please use Format() function instead")
	}
	return *p.format
}

func (p *Disk) SetId(attr string) {
	p.id = &attr
}

func (p *Disk) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Disk) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Disk) SetImageId(attr string) {
	p.imageId = &attr
}

func (p *Disk) ImageId() (string, bool) {
	if p.imageId != nil {
		return *p.imageId, true
	}
	var zero string
	return zero, false
}

func (p *Disk) MustImageId() string {
	if p.imageId == nil {
		panic("the imageId must not be nil, please use ImageId() function instead")
	}
	return *p.imageId
}

func (p *Disk) SetInitialSize(attr int64) {
	p.initialSize = &attr
}

func (p *Disk) InitialSize() (int64, bool) {
	if p.initialSize != nil {
		return *p.initialSize, true
	}
	var zero int64
	return zero, false
}

func (p *Disk) MustInitialSize() int64 {
	if p.initialSize == nil {
		panic("the initialSize must not be nil, please use InitialSize() function instead")
	}
	return *p.initialSize
}

func (p *Disk) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *Disk) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *Disk) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *Disk) SetInterface(attr DiskInterface) {
	p.interface_ = &attr
}

func (p *Disk) Interface() (DiskInterface, bool) {
	if p.interface_ != nil {
		return *p.interface_, true
	}
	var zero DiskInterface
	return zero, false
}

func (p *Disk) MustInterface() DiskInterface {
	if p.interface_ == nil {
		panic("the interface_ must not be nil, please use Interface() function instead")
	}
	return *p.interface_
}

func (p *Disk) SetLogicalName(attr string) {
	p.logicalName = &attr
}

func (p *Disk) LogicalName() (string, bool) {
	if p.logicalName != nil {
		return *p.logicalName, true
	}
	var zero string
	return zero, false
}

func (p *Disk) MustLogicalName() string {
	if p.logicalName == nil {
		panic("the logicalName must not be nil, please use LogicalName() function instead")
	}
	return *p.logicalName
}

func (p *Disk) SetLunStorage(attr *HostStorage) {
	p.lunStorage = attr
}

func (p *Disk) LunStorage() (*HostStorage, bool) {
	if p.lunStorage != nil {
		return p.lunStorage, true
	}
	return nil, false
}

func (p *Disk) MustLunStorage() *HostStorage {
	if p.lunStorage == nil {
		panic("the lunStorage must not be nil, please use LunStorage() function instead")
	}
	return p.lunStorage
}

func (p *Disk) SetName(attr string) {
	p.name = &attr
}

func (p *Disk) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Disk) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Disk) SetOpenstackVolumeType(attr *OpenStackVolumeType) {
	p.openstackVolumeType = attr
}

func (p *Disk) OpenstackVolumeType() (*OpenStackVolumeType, bool) {
	if p.openstackVolumeType != nil {
		return p.openstackVolumeType, true
	}
	return nil, false
}

func (p *Disk) MustOpenstackVolumeType() *OpenStackVolumeType {
	if p.openstackVolumeType == nil {
		panic("the openstackVolumeType must not be nil, please use OpenstackVolumeType() function instead")
	}
	return p.openstackVolumeType
}

func (p *Disk) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *Disk) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *Disk) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *Disk) SetPropagateErrors(attr bool) {
	p.propagateErrors = &attr
}

func (p *Disk) PropagateErrors() (bool, bool) {
	if p.propagateErrors != nil {
		return *p.propagateErrors, true
	}
	var zero bool
	return zero, false
}

func (p *Disk) MustPropagateErrors() bool {
	if p.propagateErrors == nil {
		panic("the propagateErrors must not be nil, please use PropagateErrors() function instead")
	}
	return *p.propagateErrors
}

func (p *Disk) SetProvisionedSize(attr int64) {
	p.provisionedSize = &attr
}

func (p *Disk) ProvisionedSize() (int64, bool) {
	if p.provisionedSize != nil {
		return *p.provisionedSize, true
	}
	var zero int64
	return zero, false
}

func (p *Disk) MustProvisionedSize() int64 {
	if p.provisionedSize == nil {
		panic("the provisionedSize must not be nil, please use ProvisionedSize() function instead")
	}
	return *p.provisionedSize
}

func (p *Disk) SetQcowVersion(attr QcowVersion) {
	p.qcowVersion = &attr
}

func (p *Disk) QcowVersion() (QcowVersion, bool) {
	if p.qcowVersion != nil {
		return *p.qcowVersion, true
	}
	var zero QcowVersion
	return zero, false
}

func (p *Disk) MustQcowVersion() QcowVersion {
	if p.qcowVersion == nil {
		panic("the qcowVersion must not be nil, please use QcowVersion() function instead")
	}
	return *p.qcowVersion
}

func (p *Disk) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *Disk) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *Disk) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *Disk) SetReadOnly(attr bool) {
	p.readOnly = &attr
}

func (p *Disk) ReadOnly() (bool, bool) {
	if p.readOnly != nil {
		return *p.readOnly, true
	}
	var zero bool
	return zero, false
}

func (p *Disk) MustReadOnly() bool {
	if p.readOnly == nil {
		panic("the readOnly must not be nil, please use ReadOnly() function instead")
	}
	return *p.readOnly
}

func (p *Disk) SetSgio(attr ScsiGenericIO) {
	p.sgio = &attr
}

func (p *Disk) Sgio() (ScsiGenericIO, bool) {
	if p.sgio != nil {
		return *p.sgio, true
	}
	var zero ScsiGenericIO
	return zero, false
}

func (p *Disk) MustSgio() ScsiGenericIO {
	if p.sgio == nil {
		panic("the sgio must not be nil, please use Sgio() function instead")
	}
	return *p.sgio
}

func (p *Disk) SetShareable(attr bool) {
	p.shareable = &attr
}

func (p *Disk) Shareable() (bool, bool) {
	if p.shareable != nil {
		return *p.shareable, true
	}
	var zero bool
	return zero, false
}

func (p *Disk) MustShareable() bool {
	if p.shareable == nil {
		panic("the shareable must not be nil, please use Shareable() function instead")
	}
	return *p.shareable
}

func (p *Disk) SetSnapshot(attr *Snapshot) {
	p.snapshot = attr
}

func (p *Disk) Snapshot() (*Snapshot, bool) {
	if p.snapshot != nil {
		return p.snapshot, true
	}
	return nil, false
}

func (p *Disk) MustSnapshot() *Snapshot {
	if p.snapshot == nil {
		panic("the snapshot must not be nil, please use Snapshot() function instead")
	}
	return p.snapshot
}

func (p *Disk) SetSparse(attr bool) {
	p.sparse = &attr
}

func (p *Disk) Sparse() (bool, bool) {
	if p.sparse != nil {
		return *p.sparse, true
	}
	var zero bool
	return zero, false
}

func (p *Disk) MustSparse() bool {
	if p.sparse == nil {
		panic("the sparse must not be nil, please use Sparse() function instead")
	}
	return *p.sparse
}

func (p *Disk) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *Disk) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *Disk) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *Disk) SetStatus(attr DiskStatus) {
	p.status = &attr
}

func (p *Disk) Status() (DiskStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero DiskStatus
	return zero, false
}

func (p *Disk) MustStatus() DiskStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *Disk) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *Disk) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *Disk) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *Disk) SetStorageDomains(attr *StorageDomainSlice) {
	p.storageDomains = attr
}

func (p *Disk) StorageDomains() (*StorageDomainSlice, bool) {
	if p.storageDomains != nil {
		return p.storageDomains, true
	}
	return nil, false
}

func (p *Disk) MustStorageDomains() *StorageDomainSlice {
	if p.storageDomains == nil {
		panic("the storageDomains must not be nil, please use StorageDomains() function instead")
	}
	return p.storageDomains
}

func (p *Disk) SetStorageType(attr DiskStorageType) {
	p.storageType = &attr
}

func (p *Disk) StorageType() (DiskStorageType, bool) {
	if p.storageType != nil {
		return *p.storageType, true
	}
	var zero DiskStorageType
	return zero, false
}

func (p *Disk) MustStorageType() DiskStorageType {
	if p.storageType == nil {
		panic("the storageType must not be nil, please use StorageType() function instead")
	}
	return *p.storageType
}

func (p *Disk) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Disk) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Disk) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Disk) SetTotalSize(attr int64) {
	p.totalSize = &attr
}

func (p *Disk) TotalSize() (int64, bool) {
	if p.totalSize != nil {
		return *p.totalSize, true
	}
	var zero int64
	return zero, false
}

func (p *Disk) MustTotalSize() int64 {
	if p.totalSize == nil {
		panic("the totalSize must not be nil, please use TotalSize() function instead")
	}
	return *p.totalSize
}

func (p *Disk) SetUsesScsiReservation(attr bool) {
	p.usesScsiReservation = &attr
}

func (p *Disk) UsesScsiReservation() (bool, bool) {
	if p.usesScsiReservation != nil {
		return *p.usesScsiReservation, true
	}
	var zero bool
	return zero, false
}

func (p *Disk) MustUsesScsiReservation() bool {
	if p.usesScsiReservation == nil {
		panic("the usesScsiReservation must not be nil, please use UsesScsiReservation() function instead")
	}
	return *p.usesScsiReservation
}

func (p *Disk) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Disk) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Disk) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Disk) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *Disk) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *Disk) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

func (p *Disk) SetWipeAfterDelete(attr bool) {
	p.wipeAfterDelete = &attr
}

func (p *Disk) WipeAfterDelete() (bool, bool) {
	if p.wipeAfterDelete != nil {
		return *p.wipeAfterDelete, true
	}
	var zero bool
	return zero, false
}

func (p *Disk) MustWipeAfterDelete() bool {
	if p.wipeAfterDelete == nil {
		panic("the wipeAfterDelete must not be nil, please use WipeAfterDelete() function instead")
	}
	return *p.wipeAfterDelete
}

type NetworkLabel struct {
	Struct
	comment     *string
	description *string
	hostNic     *HostNic
	id          *string
	name        *string
	network     *Network
}

func (p *NetworkLabel) SetComment(attr string) {
	p.comment = &attr
}

func (p *NetworkLabel) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *NetworkLabel) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *NetworkLabel) SetDescription(attr string) {
	p.description = &attr
}

func (p *NetworkLabel) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *NetworkLabel) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *NetworkLabel) SetHostNic(attr *HostNic) {
	p.hostNic = attr
}

func (p *NetworkLabel) HostNic() (*HostNic, bool) {
	if p.hostNic != nil {
		return p.hostNic, true
	}
	return nil, false
}

func (p *NetworkLabel) MustHostNic() *HostNic {
	if p.hostNic == nil {
		panic("the hostNic must not be nil, please use HostNic() function instead")
	}
	return p.hostNic
}

func (p *NetworkLabel) SetId(attr string) {
	p.id = &attr
}

func (p *NetworkLabel) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *NetworkLabel) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *NetworkLabel) SetName(attr string) {
	p.name = &attr
}

func (p *NetworkLabel) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *NetworkLabel) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *NetworkLabel) SetNetwork(attr *Network) {
	p.network = attr
}

func (p *NetworkLabel) Network() (*Network, bool) {
	if p.network != nil {
		return p.network, true
	}
	return nil, false
}

func (p *NetworkLabel) MustNetwork() *Network {
	if p.network == nil {
		panic("the network must not be nil, please use Network() function instead")
	}
	return p.network
}

type Spm struct {
	Struct
	priority *int64
	status   *SpmStatus
}

func (p *Spm) SetPriority(attr int64) {
	p.priority = &attr
}

func (p *Spm) Priority() (int64, bool) {
	if p.priority != nil {
		return *p.priority, true
	}
	var zero int64
	return zero, false
}

func (p *Spm) MustPriority() int64 {
	if p.priority == nil {
		panic("the priority must not be nil, please use Priority() function instead")
	}
	return *p.priority
}

func (p *Spm) SetStatus(attr SpmStatus) {
	p.status = &attr
}

func (p *Spm) Status() (SpmStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero SpmStatus
	return zero, false
}

func (p *Spm) MustStatus() SpmStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

type HostDevice struct {
	Struct
	capability       *string
	comment          *string
	description      *string
	driver           *string
	host             *Host
	id               *string
	iommuGroup       *int64
	mDevTypes        *MDevTypeSlice
	name             *string
	parentDevice     *HostDevice
	physicalFunction *HostDevice
	placeholder      *bool
	product          *Product
	vendor           *Vendor
	virtualFunctions *int64
	vm               *Vm
}

func (p *HostDevice) SetCapability(attr string) {
	p.capability = &attr
}

func (p *HostDevice) Capability() (string, bool) {
	if p.capability != nil {
		return *p.capability, true
	}
	var zero string
	return zero, false
}

func (p *HostDevice) MustCapability() string {
	if p.capability == nil {
		panic("the capability must not be nil, please use Capability() function instead")
	}
	return *p.capability
}

func (p *HostDevice) SetComment(attr string) {
	p.comment = &attr
}

func (p *HostDevice) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *HostDevice) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *HostDevice) SetDescription(attr string) {
	p.description = &attr
}

func (p *HostDevice) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *HostDevice) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *HostDevice) SetDriver(attr string) {
	p.driver = &attr
}

func (p *HostDevice) Driver() (string, bool) {
	if p.driver != nil {
		return *p.driver, true
	}
	var zero string
	return zero, false
}

func (p *HostDevice) MustDriver() string {
	if p.driver == nil {
		panic("the driver must not be nil, please use Driver() function instead")
	}
	return *p.driver
}

func (p *HostDevice) SetHost(attr *Host) {
	p.host = attr
}

func (p *HostDevice) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *HostDevice) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *HostDevice) SetId(attr string) {
	p.id = &attr
}

func (p *HostDevice) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *HostDevice) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *HostDevice) SetIommuGroup(attr int64) {
	p.iommuGroup = &attr
}

func (p *HostDevice) IommuGroup() (int64, bool) {
	if p.iommuGroup != nil {
		return *p.iommuGroup, true
	}
	var zero int64
	return zero, false
}

func (p *HostDevice) MustIommuGroup() int64 {
	if p.iommuGroup == nil {
		panic("the iommuGroup must not be nil, please use IommuGroup() function instead")
	}
	return *p.iommuGroup
}

func (p *HostDevice) SetMDevTypes(attr *MDevTypeSlice) {
	p.mDevTypes = attr
}

func (p *HostDevice) MDevTypes() (*MDevTypeSlice, bool) {
	if p.mDevTypes != nil {
		return p.mDevTypes, true
	}
	return nil, false
}

func (p *HostDevice) MustMDevTypes() *MDevTypeSlice {
	if p.mDevTypes == nil {
		panic("the mDevTypes must not be nil, please use MDevTypes() function instead")
	}
	return p.mDevTypes
}

func (p *HostDevice) SetName(attr string) {
	p.name = &attr
}

func (p *HostDevice) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *HostDevice) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *HostDevice) SetParentDevice(attr *HostDevice) {
	p.parentDevice = attr
}

func (p *HostDevice) ParentDevice() (*HostDevice, bool) {
	if p.parentDevice != nil {
		return p.parentDevice, true
	}
	return nil, false
}

func (p *HostDevice) MustParentDevice() *HostDevice {
	if p.parentDevice == nil {
		panic("the parentDevice must not be nil, please use ParentDevice() function instead")
	}
	return p.parentDevice
}

func (p *HostDevice) SetPhysicalFunction(attr *HostDevice) {
	p.physicalFunction = attr
}

func (p *HostDevice) PhysicalFunction() (*HostDevice, bool) {
	if p.physicalFunction != nil {
		return p.physicalFunction, true
	}
	return nil, false
}

func (p *HostDevice) MustPhysicalFunction() *HostDevice {
	if p.physicalFunction == nil {
		panic("the physicalFunction must not be nil, please use PhysicalFunction() function instead")
	}
	return p.physicalFunction
}

func (p *HostDevice) SetPlaceholder(attr bool) {
	p.placeholder = &attr
}

func (p *HostDevice) Placeholder() (bool, bool) {
	if p.placeholder != nil {
		return *p.placeholder, true
	}
	var zero bool
	return zero, false
}

func (p *HostDevice) MustPlaceholder() bool {
	if p.placeholder == nil {
		panic("the placeholder must not be nil, please use Placeholder() function instead")
	}
	return *p.placeholder
}

func (p *HostDevice) SetProduct(attr *Product) {
	p.product = attr
}

func (p *HostDevice) Product() (*Product, bool) {
	if p.product != nil {
		return p.product, true
	}
	return nil, false
}

func (p *HostDevice) MustProduct() *Product {
	if p.product == nil {
		panic("the product must not be nil, please use Product() function instead")
	}
	return p.product
}

func (p *HostDevice) SetVendor(attr *Vendor) {
	p.vendor = attr
}

func (p *HostDevice) Vendor() (*Vendor, bool) {
	if p.vendor != nil {
		return p.vendor, true
	}
	return nil, false
}

func (p *HostDevice) MustVendor() *Vendor {
	if p.vendor == nil {
		panic("the vendor must not be nil, please use Vendor() function instead")
	}
	return p.vendor
}

func (p *HostDevice) SetVirtualFunctions(attr int64) {
	p.virtualFunctions = &attr
}

func (p *HostDevice) VirtualFunctions() (int64, bool) {
	if p.virtualFunctions != nil {
		return *p.virtualFunctions, true
	}
	var zero int64
	return zero, false
}

func (p *HostDevice) MustVirtualFunctions() int64 {
	if p.virtualFunctions == nil {
		panic("the virtualFunctions must not be nil, please use VirtualFunctions() function instead")
	}
	return *p.virtualFunctions
}

func (p *HostDevice) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *HostDevice) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *HostDevice) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type PmProxy struct {
	Struct
	type_ *PmProxyType
}

func (p *PmProxy) SetType(attr PmProxyType) {
	p.type_ = &attr
}

func (p *PmProxy) Type() (PmProxyType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero PmProxyType
	return zero, false
}

func (p *PmProxy) MustType() PmProxyType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type SkipIfConnectivityBroken struct {
	Struct
	enabled   *bool
	threshold *int64
}

func (p *SkipIfConnectivityBroken) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *SkipIfConnectivityBroken) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *SkipIfConnectivityBroken) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

func (p *SkipIfConnectivityBroken) SetThreshold(attr int64) {
	p.threshold = &attr
}

func (p *SkipIfConnectivityBroken) Threshold() (int64, bool) {
	if p.threshold != nil {
		return *p.threshold, true
	}
	var zero int64
	return zero, false
}

func (p *SkipIfConnectivityBroken) MustThreshold() int64 {
	if p.threshold == nil {
		panic("the threshold must not be nil, please use Threshold() function instead")
	}
	return *p.threshold
}

type SchedulingPolicyUnit struct {
	Struct
	comment     *string
	description *string
	enabled     *bool
	id          *string
	internal    *bool
	name        *string
	properties  *PropertySlice
	type_       *PolicyUnitType
}

func (p *SchedulingPolicyUnit) SetComment(attr string) {
	p.comment = &attr
}

func (p *SchedulingPolicyUnit) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *SchedulingPolicyUnit) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *SchedulingPolicyUnit) SetDescription(attr string) {
	p.description = &attr
}

func (p *SchedulingPolicyUnit) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *SchedulingPolicyUnit) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *SchedulingPolicyUnit) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *SchedulingPolicyUnit) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *SchedulingPolicyUnit) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

func (p *SchedulingPolicyUnit) SetId(attr string) {
	p.id = &attr
}

func (p *SchedulingPolicyUnit) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *SchedulingPolicyUnit) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *SchedulingPolicyUnit) SetInternal(attr bool) {
	p.internal = &attr
}

func (p *SchedulingPolicyUnit) Internal() (bool, bool) {
	if p.internal != nil {
		return *p.internal, true
	}
	var zero bool
	return zero, false
}

func (p *SchedulingPolicyUnit) MustInternal() bool {
	if p.internal == nil {
		panic("the internal must not be nil, please use Internal() function instead")
	}
	return *p.internal
}

func (p *SchedulingPolicyUnit) SetName(attr string) {
	p.name = &attr
}

func (p *SchedulingPolicyUnit) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *SchedulingPolicyUnit) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *SchedulingPolicyUnit) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *SchedulingPolicyUnit) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *SchedulingPolicyUnit) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *SchedulingPolicyUnit) SetType(attr PolicyUnitType) {
	p.type_ = &attr
}

func (p *SchedulingPolicyUnit) Type() (PolicyUnitType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero PolicyUnitType
	return zero, false
}

func (p *SchedulingPolicyUnit) MustType() PolicyUnitType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type VnicPassThrough struct {
	Struct
	mode *VnicPassThroughMode
}

func (p *VnicPassThrough) SetMode(attr VnicPassThroughMode) {
	p.mode = &attr
}

func (p *VnicPassThrough) Mode() (VnicPassThroughMode, bool) {
	if p.mode != nil {
		return *p.mode, true
	}
	var zero VnicPassThroughMode
	return zero, false
}

func (p *VnicPassThrough) MustMode() VnicPassThroughMode {
	if p.mode == nil {
		panic("the mode must not be nil, please use Mode() function instead")
	}
	return *p.mode
}

type Permit struct {
	Struct
	administrative *bool
	comment        *string
	description    *string
	id             *string
	name           *string
	role           *Role
}

func (p *Permit) SetAdministrative(attr bool) {
	p.administrative = &attr
}

func (p *Permit) Administrative() (bool, bool) {
	if p.administrative != nil {
		return *p.administrative, true
	}
	var zero bool
	return zero, false
}

func (p *Permit) MustAdministrative() bool {
	if p.administrative == nil {
		panic("the administrative must not be nil, please use Administrative() function instead")
	}
	return *p.administrative
}

func (p *Permit) SetComment(attr string) {
	p.comment = &attr
}

func (p *Permit) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Permit) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Permit) SetDescription(attr string) {
	p.description = &attr
}

func (p *Permit) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Permit) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Permit) SetId(attr string) {
	p.id = &attr
}

func (p *Permit) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Permit) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Permit) SetName(attr string) {
	p.name = &attr
}

func (p *Permit) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Permit) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Permit) SetRole(attr *Role) {
	p.role = attr
}

func (p *Permit) Role() (*Role, bool) {
	if p.role != nil {
		return p.role, true
	}
	return nil, false
}

func (p *Permit) MustRole() *Role {
	if p.role == nil {
		panic("the role must not be nil, please use Role() function instead")
	}
	return p.role
}

type Cluster struct {
	Struct
	affinityGroups                   *AffinityGroupSlice
	ballooningEnabled                *bool
	biosType                         *BiosType
	comment                          *string
	cpu                              *Cpu
	cpuProfiles                      *CpuProfileSlice
	customSchedulingPolicyProperties *PropertySlice
	dataCenter                       *DataCenter
	description                      *string
	display                          *Display
	enabledFeatures                  *ClusterFeatureSlice
	errorHandling                    *ErrorHandling
	externalNetworkProviders         *ExternalProviderSlice
	fencingPolicy                    *FencingPolicy
	firewallType                     *FirewallType
	glusterHooks                     *GlusterHookSlice
	glusterService                   *bool
	glusterTunedProfile              *string
	glusterVolumes                   *GlusterVolumeSlice
	haReservation                    *bool
	id                               *string
	ksm                              *Ksm
	logMaxMemoryUsedThreshold        *int64
	logMaxMemoryUsedThresholdType    *LogMaxMemoryUsedThresholdType
	macPool                          *MacPool
	maintenanceReasonRequired        *bool
	managementNetwork                *Network
	memoryPolicy                     *MemoryPolicy
	migration                        *MigrationOptions
	name                             *string
	networkFilters                   *NetworkFilterSlice
	networks                         *NetworkSlice
	optionalReason                   *bool
	permissions                      *PermissionSlice
	requiredRngSources               []RngSource
	schedulingPolicy                 *SchedulingPolicy
	serialNumber                     *SerialNumber
	supportedVersions                *VersionSlice
	switchType                       *SwitchType
	threadsAsCores                   *bool
	trustedService                   *bool
	tunnelMigration                  *bool
	version                          *Version
	virtService                      *bool
	vncEncryption                    *bool
}

func (p *Cluster) SetAffinityGroups(attr *AffinityGroupSlice) {
	p.affinityGroups = attr
}

func (p *Cluster) AffinityGroups() (*AffinityGroupSlice, bool) {
	if p.affinityGroups != nil {
		return p.affinityGroups, true
	}
	return nil, false
}

func (p *Cluster) MustAffinityGroups() *AffinityGroupSlice {
	if p.affinityGroups == nil {
		panic("the affinityGroups must not be nil, please use AffinityGroups() function instead")
	}
	return p.affinityGroups
}

func (p *Cluster) SetBallooningEnabled(attr bool) {
	p.ballooningEnabled = &attr
}

func (p *Cluster) BallooningEnabled() (bool, bool) {
	if p.ballooningEnabled != nil {
		return *p.ballooningEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustBallooningEnabled() bool {
	if p.ballooningEnabled == nil {
		panic("the ballooningEnabled must not be nil, please use BallooningEnabled() function instead")
	}
	return *p.ballooningEnabled
}

func (p *Cluster) SetBiosType(attr BiosType) {
	p.biosType = &attr
}

func (p *Cluster) BiosType() (BiosType, bool) {
	if p.biosType != nil {
		return *p.biosType, true
	}
	var zero BiosType
	return zero, false
}

func (p *Cluster) MustBiosType() BiosType {
	if p.biosType == nil {
		panic("the biosType must not be nil, please use BiosType() function instead")
	}
	return *p.biosType
}

func (p *Cluster) SetComment(attr string) {
	p.comment = &attr
}

func (p *Cluster) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Cluster) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Cluster) SetCpu(attr *Cpu) {
	p.cpu = attr
}

func (p *Cluster) Cpu() (*Cpu, bool) {
	if p.cpu != nil {
		return p.cpu, true
	}
	return nil, false
}

func (p *Cluster) MustCpu() *Cpu {
	if p.cpu == nil {
		panic("the cpu must not be nil, please use Cpu() function instead")
	}
	return p.cpu
}

func (p *Cluster) SetCpuProfiles(attr *CpuProfileSlice) {
	p.cpuProfiles = attr
}

func (p *Cluster) CpuProfiles() (*CpuProfileSlice, bool) {
	if p.cpuProfiles != nil {
		return p.cpuProfiles, true
	}
	return nil, false
}

func (p *Cluster) MustCpuProfiles() *CpuProfileSlice {
	if p.cpuProfiles == nil {
		panic("the cpuProfiles must not be nil, please use CpuProfiles() function instead")
	}
	return p.cpuProfiles
}

func (p *Cluster) SetCustomSchedulingPolicyProperties(attr *PropertySlice) {
	p.customSchedulingPolicyProperties = attr
}

func (p *Cluster) CustomSchedulingPolicyProperties() (*PropertySlice, bool) {
	if p.customSchedulingPolicyProperties != nil {
		return p.customSchedulingPolicyProperties, true
	}
	return nil, false
}

func (p *Cluster) MustCustomSchedulingPolicyProperties() *PropertySlice {
	if p.customSchedulingPolicyProperties == nil {
		panic("the customSchedulingPolicyProperties must not be nil, please use CustomSchedulingPolicyProperties() function instead")
	}
	return p.customSchedulingPolicyProperties
}

func (p *Cluster) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *Cluster) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *Cluster) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *Cluster) SetDescription(attr string) {
	p.description = &attr
}

func (p *Cluster) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Cluster) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Cluster) SetDisplay(attr *Display) {
	p.display = attr
}

func (p *Cluster) Display() (*Display, bool) {
	if p.display != nil {
		return p.display, true
	}
	return nil, false
}

func (p *Cluster) MustDisplay() *Display {
	if p.display == nil {
		panic("the display must not be nil, please use Display() function instead")
	}
	return p.display
}

func (p *Cluster) SetEnabledFeatures(attr *ClusterFeatureSlice) {
	p.enabledFeatures = attr
}

func (p *Cluster) EnabledFeatures() (*ClusterFeatureSlice, bool) {
	if p.enabledFeatures != nil {
		return p.enabledFeatures, true
	}
	return nil, false
}

func (p *Cluster) MustEnabledFeatures() *ClusterFeatureSlice {
	if p.enabledFeatures == nil {
		panic("the enabledFeatures must not be nil, please use EnabledFeatures() function instead")
	}
	return p.enabledFeatures
}

func (p *Cluster) SetErrorHandling(attr *ErrorHandling) {
	p.errorHandling = attr
}

func (p *Cluster) ErrorHandling() (*ErrorHandling, bool) {
	if p.errorHandling != nil {
		return p.errorHandling, true
	}
	return nil, false
}

func (p *Cluster) MustErrorHandling() *ErrorHandling {
	if p.errorHandling == nil {
		panic("the errorHandling must not be nil, please use ErrorHandling() function instead")
	}
	return p.errorHandling
}

func (p *Cluster) SetExternalNetworkProviders(attr *ExternalProviderSlice) {
	p.externalNetworkProviders = attr
}

func (p *Cluster) ExternalNetworkProviders() (*ExternalProviderSlice, bool) {
	if p.externalNetworkProviders != nil {
		return p.externalNetworkProviders, true
	}
	return nil, false
}

func (p *Cluster) MustExternalNetworkProviders() *ExternalProviderSlice {
	if p.externalNetworkProviders == nil {
		panic("the externalNetworkProviders must not be nil, please use ExternalNetworkProviders() function instead")
	}
	return p.externalNetworkProviders
}

func (p *Cluster) SetFencingPolicy(attr *FencingPolicy) {
	p.fencingPolicy = attr
}

func (p *Cluster) FencingPolicy() (*FencingPolicy, bool) {
	if p.fencingPolicy != nil {
		return p.fencingPolicy, true
	}
	return nil, false
}

func (p *Cluster) MustFencingPolicy() *FencingPolicy {
	if p.fencingPolicy == nil {
		panic("the fencingPolicy must not be nil, please use FencingPolicy() function instead")
	}
	return p.fencingPolicy
}

func (p *Cluster) SetFirewallType(attr FirewallType) {
	p.firewallType = &attr
}

func (p *Cluster) FirewallType() (FirewallType, bool) {
	if p.firewallType != nil {
		return *p.firewallType, true
	}
	var zero FirewallType
	return zero, false
}

func (p *Cluster) MustFirewallType() FirewallType {
	if p.firewallType == nil {
		panic("the firewallType must not be nil, please use FirewallType() function instead")
	}
	return *p.firewallType
}

func (p *Cluster) SetGlusterHooks(attr *GlusterHookSlice) {
	p.glusterHooks = attr
}

func (p *Cluster) GlusterHooks() (*GlusterHookSlice, bool) {
	if p.glusterHooks != nil {
		return p.glusterHooks, true
	}
	return nil, false
}

func (p *Cluster) MustGlusterHooks() *GlusterHookSlice {
	if p.glusterHooks == nil {
		panic("the glusterHooks must not be nil, please use GlusterHooks() function instead")
	}
	return p.glusterHooks
}

func (p *Cluster) SetGlusterService(attr bool) {
	p.glusterService = &attr
}

func (p *Cluster) GlusterService() (bool, bool) {
	if p.glusterService != nil {
		return *p.glusterService, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustGlusterService() bool {
	if p.glusterService == nil {
		panic("the glusterService must not be nil, please use GlusterService() function instead")
	}
	return *p.glusterService
}

func (p *Cluster) SetGlusterTunedProfile(attr string) {
	p.glusterTunedProfile = &attr
}

func (p *Cluster) GlusterTunedProfile() (string, bool) {
	if p.glusterTunedProfile != nil {
		return *p.glusterTunedProfile, true
	}
	var zero string
	return zero, false
}

func (p *Cluster) MustGlusterTunedProfile() string {
	if p.glusterTunedProfile == nil {
		panic("the glusterTunedProfile must not be nil, please use GlusterTunedProfile() function instead")
	}
	return *p.glusterTunedProfile
}

func (p *Cluster) SetGlusterVolumes(attr *GlusterVolumeSlice) {
	p.glusterVolumes = attr
}

func (p *Cluster) GlusterVolumes() (*GlusterVolumeSlice, bool) {
	if p.glusterVolumes != nil {
		return p.glusterVolumes, true
	}
	return nil, false
}

func (p *Cluster) MustGlusterVolumes() *GlusterVolumeSlice {
	if p.glusterVolumes == nil {
		panic("the glusterVolumes must not be nil, please use GlusterVolumes() function instead")
	}
	return p.glusterVolumes
}

func (p *Cluster) SetHaReservation(attr bool) {
	p.haReservation = &attr
}

func (p *Cluster) HaReservation() (bool, bool) {
	if p.haReservation != nil {
		return *p.haReservation, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustHaReservation() bool {
	if p.haReservation == nil {
		panic("the haReservation must not be nil, please use HaReservation() function instead")
	}
	return *p.haReservation
}

func (p *Cluster) SetId(attr string) {
	p.id = &attr
}

func (p *Cluster) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Cluster) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Cluster) SetKsm(attr *Ksm) {
	p.ksm = attr
}

func (p *Cluster) Ksm() (*Ksm, bool) {
	if p.ksm != nil {
		return p.ksm, true
	}
	return nil, false
}

func (p *Cluster) MustKsm() *Ksm {
	if p.ksm == nil {
		panic("the ksm must not be nil, please use Ksm() function instead")
	}
	return p.ksm
}

func (p *Cluster) SetLogMaxMemoryUsedThreshold(attr int64) {
	p.logMaxMemoryUsedThreshold = &attr
}

func (p *Cluster) LogMaxMemoryUsedThreshold() (int64, bool) {
	if p.logMaxMemoryUsedThreshold != nil {
		return *p.logMaxMemoryUsedThreshold, true
	}
	var zero int64
	return zero, false
}

func (p *Cluster) MustLogMaxMemoryUsedThreshold() int64 {
	if p.logMaxMemoryUsedThreshold == nil {
		panic("the logMaxMemoryUsedThreshold must not be nil, please use LogMaxMemoryUsedThreshold() function instead")
	}
	return *p.logMaxMemoryUsedThreshold
}

func (p *Cluster) SetLogMaxMemoryUsedThresholdType(attr LogMaxMemoryUsedThresholdType) {
	p.logMaxMemoryUsedThresholdType = &attr
}

func (p *Cluster) LogMaxMemoryUsedThresholdType() (LogMaxMemoryUsedThresholdType, bool) {
	if p.logMaxMemoryUsedThresholdType != nil {
		return *p.logMaxMemoryUsedThresholdType, true
	}
	var zero LogMaxMemoryUsedThresholdType
	return zero, false
}

func (p *Cluster) MustLogMaxMemoryUsedThresholdType() LogMaxMemoryUsedThresholdType {
	if p.logMaxMemoryUsedThresholdType == nil {
		panic("the logMaxMemoryUsedThresholdType must not be nil, please use LogMaxMemoryUsedThresholdType() function instead")
	}
	return *p.logMaxMemoryUsedThresholdType
}

func (p *Cluster) SetMacPool(attr *MacPool) {
	p.macPool = attr
}

func (p *Cluster) MacPool() (*MacPool, bool) {
	if p.macPool != nil {
		return p.macPool, true
	}
	return nil, false
}

func (p *Cluster) MustMacPool() *MacPool {
	if p.macPool == nil {
		panic("the macPool must not be nil, please use MacPool() function instead")
	}
	return p.macPool
}

func (p *Cluster) SetMaintenanceReasonRequired(attr bool) {
	p.maintenanceReasonRequired = &attr
}

func (p *Cluster) MaintenanceReasonRequired() (bool, bool) {
	if p.maintenanceReasonRequired != nil {
		return *p.maintenanceReasonRequired, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustMaintenanceReasonRequired() bool {
	if p.maintenanceReasonRequired == nil {
		panic("the maintenanceReasonRequired must not be nil, please use MaintenanceReasonRequired() function instead")
	}
	return *p.maintenanceReasonRequired
}

func (p *Cluster) SetManagementNetwork(attr *Network) {
	p.managementNetwork = attr
}

func (p *Cluster) ManagementNetwork() (*Network, bool) {
	if p.managementNetwork != nil {
		return p.managementNetwork, true
	}
	return nil, false
}

func (p *Cluster) MustManagementNetwork() *Network {
	if p.managementNetwork == nil {
		panic("the managementNetwork must not be nil, please use ManagementNetwork() function instead")
	}
	return p.managementNetwork
}

func (p *Cluster) SetMemoryPolicy(attr *MemoryPolicy) {
	p.memoryPolicy = attr
}

func (p *Cluster) MemoryPolicy() (*MemoryPolicy, bool) {
	if p.memoryPolicy != nil {
		return p.memoryPolicy, true
	}
	return nil, false
}

func (p *Cluster) MustMemoryPolicy() *MemoryPolicy {
	if p.memoryPolicy == nil {
		panic("the memoryPolicy must not be nil, please use MemoryPolicy() function instead")
	}
	return p.memoryPolicy
}

func (p *Cluster) SetMigration(attr *MigrationOptions) {
	p.migration = attr
}

func (p *Cluster) Migration() (*MigrationOptions, bool) {
	if p.migration != nil {
		return p.migration, true
	}
	return nil, false
}

func (p *Cluster) MustMigration() *MigrationOptions {
	if p.migration == nil {
		panic("the migration must not be nil, please use Migration() function instead")
	}
	return p.migration
}

func (p *Cluster) SetName(attr string) {
	p.name = &attr
}

func (p *Cluster) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Cluster) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Cluster) SetNetworkFilters(attr *NetworkFilterSlice) {
	p.networkFilters = attr
}

func (p *Cluster) NetworkFilters() (*NetworkFilterSlice, bool) {
	if p.networkFilters != nil {
		return p.networkFilters, true
	}
	return nil, false
}

func (p *Cluster) MustNetworkFilters() *NetworkFilterSlice {
	if p.networkFilters == nil {
		panic("the networkFilters must not be nil, please use NetworkFilters() function instead")
	}
	return p.networkFilters
}

func (p *Cluster) SetNetworks(attr *NetworkSlice) {
	p.networks = attr
}

func (p *Cluster) Networks() (*NetworkSlice, bool) {
	if p.networks != nil {
		return p.networks, true
	}
	return nil, false
}

func (p *Cluster) MustNetworks() *NetworkSlice {
	if p.networks == nil {
		panic("the networks must not be nil, please use Networks() function instead")
	}
	return p.networks
}

func (p *Cluster) SetOptionalReason(attr bool) {
	p.optionalReason = &attr
}

func (p *Cluster) OptionalReason() (bool, bool) {
	if p.optionalReason != nil {
		return *p.optionalReason, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustOptionalReason() bool {
	if p.optionalReason == nil {
		panic("the optionalReason must not be nil, please use OptionalReason() function instead")
	}
	return *p.optionalReason
}

func (p *Cluster) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *Cluster) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *Cluster) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *Cluster) SetRequiredRngSources(attr []RngSource) {
	p.requiredRngSources = attr
}

func (p *Cluster) RequiredRngSources() ([]RngSource, bool) {
	if p.requiredRngSources != nil {
		return p.requiredRngSources, true
	}
	return nil, false
}

func (p *Cluster) MustRequiredRngSources() []RngSource {
	if p.requiredRngSources == nil {
		panic("the requiredRngSources must not be nil, please use RequiredRngSources() function instead")
	}
	return p.requiredRngSources
}

func (p *Cluster) SetSchedulingPolicy(attr *SchedulingPolicy) {
	p.schedulingPolicy = attr
}

func (p *Cluster) SchedulingPolicy() (*SchedulingPolicy, bool) {
	if p.schedulingPolicy != nil {
		return p.schedulingPolicy, true
	}
	return nil, false
}

func (p *Cluster) MustSchedulingPolicy() *SchedulingPolicy {
	if p.schedulingPolicy == nil {
		panic("the schedulingPolicy must not be nil, please use SchedulingPolicy() function instead")
	}
	return p.schedulingPolicy
}

func (p *Cluster) SetSerialNumber(attr *SerialNumber) {
	p.serialNumber = attr
}

func (p *Cluster) SerialNumber() (*SerialNumber, bool) {
	if p.serialNumber != nil {
		return p.serialNumber, true
	}
	return nil, false
}

func (p *Cluster) MustSerialNumber() *SerialNumber {
	if p.serialNumber == nil {
		panic("the serialNumber must not be nil, please use SerialNumber() function instead")
	}
	return p.serialNumber
}

func (p *Cluster) SetSupportedVersions(attr *VersionSlice) {
	p.supportedVersions = attr
}

func (p *Cluster) SupportedVersions() (*VersionSlice, bool) {
	if p.supportedVersions != nil {
		return p.supportedVersions, true
	}
	return nil, false
}

func (p *Cluster) MustSupportedVersions() *VersionSlice {
	if p.supportedVersions == nil {
		panic("the supportedVersions must not be nil, please use SupportedVersions() function instead")
	}
	return p.supportedVersions
}

func (p *Cluster) SetSwitchType(attr SwitchType) {
	p.switchType = &attr
}

func (p *Cluster) SwitchType() (SwitchType, bool) {
	if p.switchType != nil {
		return *p.switchType, true
	}
	var zero SwitchType
	return zero, false
}

func (p *Cluster) MustSwitchType() SwitchType {
	if p.switchType == nil {
		panic("the switchType must not be nil, please use SwitchType() function instead")
	}
	return *p.switchType
}

func (p *Cluster) SetThreadsAsCores(attr bool) {
	p.threadsAsCores = &attr
}

func (p *Cluster) ThreadsAsCores() (bool, bool) {
	if p.threadsAsCores != nil {
		return *p.threadsAsCores, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustThreadsAsCores() bool {
	if p.threadsAsCores == nil {
		panic("the threadsAsCores must not be nil, please use ThreadsAsCores() function instead")
	}
	return *p.threadsAsCores
}

func (p *Cluster) SetTrustedService(attr bool) {
	p.trustedService = &attr
}

func (p *Cluster) TrustedService() (bool, bool) {
	if p.trustedService != nil {
		return *p.trustedService, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustTrustedService() bool {
	if p.trustedService == nil {
		panic("the trustedService must not be nil, please use TrustedService() function instead")
	}
	return *p.trustedService
}

func (p *Cluster) SetTunnelMigration(attr bool) {
	p.tunnelMigration = &attr
}

func (p *Cluster) TunnelMigration() (bool, bool) {
	if p.tunnelMigration != nil {
		return *p.tunnelMigration, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustTunnelMigration() bool {
	if p.tunnelMigration == nil {
		panic("the tunnelMigration must not be nil, please use TunnelMigration() function instead")
	}
	return *p.tunnelMigration
}

func (p *Cluster) SetVersion(attr *Version) {
	p.version = attr
}

func (p *Cluster) Version() (*Version, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *Cluster) MustVersion() *Version {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

func (p *Cluster) SetVirtService(attr bool) {
	p.virtService = &attr
}

func (p *Cluster) VirtService() (bool, bool) {
	if p.virtService != nil {
		return *p.virtService, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustVirtService() bool {
	if p.virtService == nil {
		panic("the virtService must not be nil, please use VirtService() function instead")
	}
	return *p.virtService
}

func (p *Cluster) SetVncEncryption(attr bool) {
	p.vncEncryption = &attr
}

func (p *Cluster) VncEncryption() (bool, bool) {
	if p.vncEncryption != nil {
		return *p.vncEncryption, true
	}
	var zero bool
	return zero, false
}

func (p *Cluster) MustVncEncryption() bool {
	if p.vncEncryption == nil {
		panic("the vncEncryption must not be nil, please use VncEncryption() function instead")
	}
	return *p.vncEncryption
}

type GlusterBrickMemoryInfo struct {
	Struct
	memoryPools *GlusterMemoryPoolSlice
}

func (p *GlusterBrickMemoryInfo) SetMemoryPools(attr *GlusterMemoryPoolSlice) {
	p.memoryPools = attr
}

func (p *GlusterBrickMemoryInfo) MemoryPools() (*GlusterMemoryPoolSlice, bool) {
	if p.memoryPools != nil {
		return p.memoryPools, true
	}
	return nil, false
}

func (p *GlusterBrickMemoryInfo) MustMemoryPools() *GlusterMemoryPoolSlice {
	if p.memoryPools == nil {
		panic("the memoryPools must not be nil, please use MemoryPools() function instead")
	}
	return p.memoryPools
}

type VmPool struct {
	Struct
	autoStorageSelect        *bool
	cluster                  *Cluster
	comment                  *string
	description              *string
	display                  *Display
	id                       *string
	instanceType             *InstanceType
	maxUserVms               *int64
	name                     *string
	permissions              *PermissionSlice
	prestartedVms            *int64
	rngDevice                *RngDevice
	size                     *int64
	soundcardEnabled         *bool
	stateful                 *bool
	template                 *Template
	type_                    *VmPoolType
	useLatestTemplateVersion *bool
	vm                       *Vm
}

func (p *VmPool) SetAutoStorageSelect(attr bool) {
	p.autoStorageSelect = &attr
}

func (p *VmPool) AutoStorageSelect() (bool, bool) {
	if p.autoStorageSelect != nil {
		return *p.autoStorageSelect, true
	}
	var zero bool
	return zero, false
}

func (p *VmPool) MustAutoStorageSelect() bool {
	if p.autoStorageSelect == nil {
		panic("the autoStorageSelect must not be nil, please use AutoStorageSelect() function instead")
	}
	return *p.autoStorageSelect
}

func (p *VmPool) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *VmPool) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *VmPool) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *VmPool) SetComment(attr string) {
	p.comment = &attr
}

func (p *VmPool) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *VmPool) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *VmPool) SetDescription(attr string) {
	p.description = &attr
}

func (p *VmPool) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *VmPool) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *VmPool) SetDisplay(attr *Display) {
	p.display = attr
}

func (p *VmPool) Display() (*Display, bool) {
	if p.display != nil {
		return p.display, true
	}
	return nil, false
}

func (p *VmPool) MustDisplay() *Display {
	if p.display == nil {
		panic("the display must not be nil, please use Display() function instead")
	}
	return p.display
}

func (p *VmPool) SetId(attr string) {
	p.id = &attr
}

func (p *VmPool) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *VmPool) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *VmPool) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *VmPool) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *VmPool) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *VmPool) SetMaxUserVms(attr int64) {
	p.maxUserVms = &attr
}

func (p *VmPool) MaxUserVms() (int64, bool) {
	if p.maxUserVms != nil {
		return *p.maxUserVms, true
	}
	var zero int64
	return zero, false
}

func (p *VmPool) MustMaxUserVms() int64 {
	if p.maxUserVms == nil {
		panic("the maxUserVms must not be nil, please use MaxUserVms() function instead")
	}
	return *p.maxUserVms
}

func (p *VmPool) SetName(attr string) {
	p.name = &attr
}

func (p *VmPool) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *VmPool) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *VmPool) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *VmPool) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *VmPool) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *VmPool) SetPrestartedVms(attr int64) {
	p.prestartedVms = &attr
}

func (p *VmPool) PrestartedVms() (int64, bool) {
	if p.prestartedVms != nil {
		return *p.prestartedVms, true
	}
	var zero int64
	return zero, false
}

func (p *VmPool) MustPrestartedVms() int64 {
	if p.prestartedVms == nil {
		panic("the prestartedVms must not be nil, please use PrestartedVms() function instead")
	}
	return *p.prestartedVms
}

func (p *VmPool) SetRngDevice(attr *RngDevice) {
	p.rngDevice = attr
}

func (p *VmPool) RngDevice() (*RngDevice, bool) {
	if p.rngDevice != nil {
		return p.rngDevice, true
	}
	return nil, false
}

func (p *VmPool) MustRngDevice() *RngDevice {
	if p.rngDevice == nil {
		panic("the rngDevice must not be nil, please use RngDevice() function instead")
	}
	return p.rngDevice
}

func (p *VmPool) SetSize(attr int64) {
	p.size = &attr
}

func (p *VmPool) Size() (int64, bool) {
	if p.size != nil {
		return *p.size, true
	}
	var zero int64
	return zero, false
}

func (p *VmPool) MustSize() int64 {
	if p.size == nil {
		panic("the size must not be nil, please use Size() function instead")
	}
	return *p.size
}

func (p *VmPool) SetSoundcardEnabled(attr bool) {
	p.soundcardEnabled = &attr
}

func (p *VmPool) SoundcardEnabled() (bool, bool) {
	if p.soundcardEnabled != nil {
		return *p.soundcardEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *VmPool) MustSoundcardEnabled() bool {
	if p.soundcardEnabled == nil {
		panic("the soundcardEnabled must not be nil, please use SoundcardEnabled() function instead")
	}
	return *p.soundcardEnabled
}

func (p *VmPool) SetStateful(attr bool) {
	p.stateful = &attr
}

func (p *VmPool) Stateful() (bool, bool) {
	if p.stateful != nil {
		return *p.stateful, true
	}
	var zero bool
	return zero, false
}

func (p *VmPool) MustStateful() bool {
	if p.stateful == nil {
		panic("the stateful must not be nil, please use Stateful() function instead")
	}
	return *p.stateful
}

func (p *VmPool) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *VmPool) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *VmPool) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *VmPool) SetType(attr VmPoolType) {
	p.type_ = &attr
}

func (p *VmPool) Type() (VmPoolType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero VmPoolType
	return zero, false
}

func (p *VmPool) MustType() VmPoolType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *VmPool) SetUseLatestTemplateVersion(attr bool) {
	p.useLatestTemplateVersion = &attr
}

func (p *VmPool) UseLatestTemplateVersion() (bool, bool) {
	if p.useLatestTemplateVersion != nil {
		return *p.useLatestTemplateVersion, true
	}
	var zero bool
	return zero, false
}

func (p *VmPool) MustUseLatestTemplateVersion() bool {
	if p.useLatestTemplateVersion == nil {
		panic("the useLatestTemplateVersion must not be nil, please use UseLatestTemplateVersion() function instead")
	}
	return *p.useLatestTemplateVersion
}

func (p *VmPool) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *VmPool) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *VmPool) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type ProxyTicket struct {
	Struct
	value *string
}

func (p *ProxyTicket) SetValue(attr string) {
	p.value = &attr
}

func (p *ProxyTicket) Value() (string, bool) {
	if p.value != nil {
		return *p.value, true
	}
	var zero string
	return zero, false
}

func (p *ProxyTicket) MustValue() string {
	if p.value == nil {
		panic("the value must not be nil, please use Value() function instead")
	}
	return *p.value
}

type GlusterServerHook struct {
	Struct
	checksum    *string
	comment     *string
	contentType *HookContentType
	description *string
	host        *Host
	id          *string
	name        *string
	status      *GlusterHookStatus
}

func (p *GlusterServerHook) SetChecksum(attr string) {
	p.checksum = &attr
}

func (p *GlusterServerHook) Checksum() (string, bool) {
	if p.checksum != nil {
		return *p.checksum, true
	}
	var zero string
	return zero, false
}

func (p *GlusterServerHook) MustChecksum() string {
	if p.checksum == nil {
		panic("the checksum must not be nil, please use Checksum() function instead")
	}
	return *p.checksum
}

func (p *GlusterServerHook) SetComment(attr string) {
	p.comment = &attr
}

func (p *GlusterServerHook) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *GlusterServerHook) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *GlusterServerHook) SetContentType(attr HookContentType) {
	p.contentType = &attr
}

func (p *GlusterServerHook) ContentType() (HookContentType, bool) {
	if p.contentType != nil {
		return *p.contentType, true
	}
	var zero HookContentType
	return zero, false
}

func (p *GlusterServerHook) MustContentType() HookContentType {
	if p.contentType == nil {
		panic("the contentType must not be nil, please use ContentType() function instead")
	}
	return *p.contentType
}

func (p *GlusterServerHook) SetDescription(attr string) {
	p.description = &attr
}

func (p *GlusterServerHook) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *GlusterServerHook) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *GlusterServerHook) SetHost(attr *Host) {
	p.host = attr
}

func (p *GlusterServerHook) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *GlusterServerHook) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *GlusterServerHook) SetId(attr string) {
	p.id = &attr
}

func (p *GlusterServerHook) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *GlusterServerHook) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *GlusterServerHook) SetName(attr string) {
	p.name = &attr
}

func (p *GlusterServerHook) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *GlusterServerHook) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *GlusterServerHook) SetStatus(attr GlusterHookStatus) {
	p.status = &attr
}

func (p *GlusterServerHook) Status() (GlusterHookStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero GlusterHookStatus
	return zero, false
}

func (p *GlusterServerHook) MustStatus() GlusterHookStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

type Statistic struct {
	Struct
	brick         *GlusterBrick
	comment       *string
	description   *string
	disk          *Disk
	glusterVolume *GlusterVolume
	host          *Host
	hostNic       *HostNic
	hostNumaNode  *NumaNode
	id            *string
	kind          *StatisticKind
	name          *string
	nic           *Nic
	step          *Step
	type_         *ValueType
	unit          *StatisticUnit
	values        *ValueSlice
	vm            *Vm
}

func (p *Statistic) SetBrick(attr *GlusterBrick) {
	p.brick = attr
}

func (p *Statistic) Brick() (*GlusterBrick, bool) {
	if p.brick != nil {
		return p.brick, true
	}
	return nil, false
}

func (p *Statistic) MustBrick() *GlusterBrick {
	if p.brick == nil {
		panic("the brick must not be nil, please use Brick() function instead")
	}
	return p.brick
}

func (p *Statistic) SetComment(attr string) {
	p.comment = &attr
}

func (p *Statistic) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Statistic) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Statistic) SetDescription(attr string) {
	p.description = &attr
}

func (p *Statistic) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Statistic) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Statistic) SetDisk(attr *Disk) {
	p.disk = attr
}

func (p *Statistic) Disk() (*Disk, bool) {
	if p.disk != nil {
		return p.disk, true
	}
	return nil, false
}

func (p *Statistic) MustDisk() *Disk {
	if p.disk == nil {
		panic("the disk must not be nil, please use Disk() function instead")
	}
	return p.disk
}

func (p *Statistic) SetGlusterVolume(attr *GlusterVolume) {
	p.glusterVolume = attr
}

func (p *Statistic) GlusterVolume() (*GlusterVolume, bool) {
	if p.glusterVolume != nil {
		return p.glusterVolume, true
	}
	return nil, false
}

func (p *Statistic) MustGlusterVolume() *GlusterVolume {
	if p.glusterVolume == nil {
		panic("the glusterVolume must not be nil, please use GlusterVolume() function instead")
	}
	return p.glusterVolume
}

func (p *Statistic) SetHost(attr *Host) {
	p.host = attr
}

func (p *Statistic) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *Statistic) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *Statistic) SetHostNic(attr *HostNic) {
	p.hostNic = attr
}

func (p *Statistic) HostNic() (*HostNic, bool) {
	if p.hostNic != nil {
		return p.hostNic, true
	}
	return nil, false
}

func (p *Statistic) MustHostNic() *HostNic {
	if p.hostNic == nil {
		panic("the hostNic must not be nil, please use HostNic() function instead")
	}
	return p.hostNic
}

func (p *Statistic) SetHostNumaNode(attr *NumaNode) {
	p.hostNumaNode = attr
}

func (p *Statistic) HostNumaNode() (*NumaNode, bool) {
	if p.hostNumaNode != nil {
		return p.hostNumaNode, true
	}
	return nil, false
}

func (p *Statistic) MustHostNumaNode() *NumaNode {
	if p.hostNumaNode == nil {
		panic("the hostNumaNode must not be nil, please use HostNumaNode() function instead")
	}
	return p.hostNumaNode
}

func (p *Statistic) SetId(attr string) {
	p.id = &attr
}

func (p *Statistic) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Statistic) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Statistic) SetKind(attr StatisticKind) {
	p.kind = &attr
}

func (p *Statistic) Kind() (StatisticKind, bool) {
	if p.kind != nil {
		return *p.kind, true
	}
	var zero StatisticKind
	return zero, false
}

func (p *Statistic) MustKind() StatisticKind {
	if p.kind == nil {
		panic("the kind must not be nil, please use Kind() function instead")
	}
	return *p.kind
}

func (p *Statistic) SetName(attr string) {
	p.name = &attr
}

func (p *Statistic) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Statistic) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Statistic) SetNic(attr *Nic) {
	p.nic = attr
}

func (p *Statistic) Nic() (*Nic, bool) {
	if p.nic != nil {
		return p.nic, true
	}
	return nil, false
}

func (p *Statistic) MustNic() *Nic {
	if p.nic == nil {
		panic("the nic must not be nil, please use Nic() function instead")
	}
	return p.nic
}

func (p *Statistic) SetStep(attr *Step) {
	p.step = attr
}

func (p *Statistic) Step() (*Step, bool) {
	if p.step != nil {
		return p.step, true
	}
	return nil, false
}

func (p *Statistic) MustStep() *Step {
	if p.step == nil {
		panic("the step must not be nil, please use Step() function instead")
	}
	return p.step
}

func (p *Statistic) SetType(attr ValueType) {
	p.type_ = &attr
}

func (p *Statistic) Type() (ValueType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero ValueType
	return zero, false
}

func (p *Statistic) MustType() ValueType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *Statistic) SetUnit(attr StatisticUnit) {
	p.unit = &attr
}

func (p *Statistic) Unit() (StatisticUnit, bool) {
	if p.unit != nil {
		return *p.unit, true
	}
	var zero StatisticUnit
	return zero, false
}

func (p *Statistic) MustUnit() StatisticUnit {
	if p.unit == nil {
		panic("the unit must not be nil, please use Unit() function instead")
	}
	return *p.unit
}

func (p *Statistic) SetValues(attr *ValueSlice) {
	p.values = attr
}

func (p *Statistic) Values() (*ValueSlice, bool) {
	if p.values != nil {
		return p.values, true
	}
	return nil, false
}

func (p *Statistic) MustValues() *ValueSlice {
	if p.values == nil {
		panic("the values must not be nil, please use Values() function instead")
	}
	return p.values
}

func (p *Statistic) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Statistic) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Statistic) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type Snapshot struct {
	Struct
	affinityLabels              *AffinityLabelSlice
	applications                *ApplicationSlice
	bios                        *Bios
	cdroms                      *CdromSlice
	cluster                     *Cluster
	comment                     *string
	console                     *Console
	cpu                         *Cpu
	cpuProfile                  *CpuProfile
	cpuShares                   *int64
	creationTime                *time.Time
	customCompatibilityVersion  *Version
	customCpuModel              *string
	customEmulatedMachine       *string
	customProperties            *CustomPropertySlice
	date                        *time.Time
	deleteProtected             *bool
	description                 *string
	diskAttachments             *DiskAttachmentSlice
	disks                       *DiskSlice
	display                     *Display
	domain                      *Domain
	externalHostProvider        *ExternalHostProvider
	floppies                    *FloppySlice
	fqdn                        *string
	graphicsConsoles            *GraphicsConsoleSlice
	guestOperatingSystem        *GuestOperatingSystem
	guestTimeZone               *TimeZone
	hasIllegalImages            *bool
	highAvailability            *HighAvailability
	host                        *Host
	hostDevices                 *HostDeviceSlice
	id                          *string
	initialization              *Initialization
	instanceType                *InstanceType
	io                          *Io
	katelloErrata               *KatelloErratumSlice
	largeIcon                   *Icon
	lease                       *StorageDomainLease
	memory                      *int64
	memoryPolicy                *MemoryPolicy
	migration                   *MigrationOptions
	migrationDowntime           *int64
	multiQueuesEnabled          *bool
	name                        *string
	nextRunConfigurationExists  *bool
	nics                        *NicSlice
	numaNodes                   *NumaNodeSlice
	numaTuneMode                *NumaTuneMode
	origin                      *string
	originalTemplate            *Template
	os                          *OperatingSystem
	payloads                    *PayloadSlice
	permissions                 *PermissionSlice
	persistMemorystate          *bool
	placementPolicy             *VmPlacementPolicy
	quota                       *Quota
	reportedDevices             *ReportedDeviceSlice
	rngDevice                   *RngDevice
	runOnce                     *bool
	serialNumber                *SerialNumber
	sessions                    *SessionSlice
	smallIcon                   *Icon
	snapshotStatus              *SnapshotStatus
	snapshotType                *SnapshotType
	snapshots                   *SnapshotSlice
	soundcardEnabled            *bool
	sso                         *Sso
	startPaused                 *bool
	startTime                   *time.Time
	stateless                   *bool
	statistics                  *StatisticSlice
	status                      *VmStatus
	statusDetail                *string
	stopReason                  *string
	stopTime                    *time.Time
	storageDomain               *StorageDomain
	storageErrorResumeBehaviour *VmStorageErrorResumeBehaviour
	tags                        *TagSlice
	template                    *Template
	timeZone                    *TimeZone
	tunnelMigration             *bool
	type_                       *VmType
	usb                         *Usb
	useLatestTemplateVersion    *bool
	virtioScsi                  *VirtioScsi
	vm                          *Vm
	vmPool                      *VmPool
	watchdogs                   *WatchdogSlice
}

func (p *Snapshot) SetAffinityLabels(attr *AffinityLabelSlice) {
	p.affinityLabels = attr
}

func (p *Snapshot) AffinityLabels() (*AffinityLabelSlice, bool) {
	if p.affinityLabels != nil {
		return p.affinityLabels, true
	}
	return nil, false
}

func (p *Snapshot) MustAffinityLabels() *AffinityLabelSlice {
	if p.affinityLabels == nil {
		panic("the affinityLabels must not be nil, please use AffinityLabels() function instead")
	}
	return p.affinityLabels
}

func (p *Snapshot) SetApplications(attr *ApplicationSlice) {
	p.applications = attr
}

func (p *Snapshot) Applications() (*ApplicationSlice, bool) {
	if p.applications != nil {
		return p.applications, true
	}
	return nil, false
}

func (p *Snapshot) MustApplications() *ApplicationSlice {
	if p.applications == nil {
		panic("the applications must not be nil, please use Applications() function instead")
	}
	return p.applications
}

func (p *Snapshot) SetBios(attr *Bios) {
	p.bios = attr
}

func (p *Snapshot) Bios() (*Bios, bool) {
	if p.bios != nil {
		return p.bios, true
	}
	return nil, false
}

func (p *Snapshot) MustBios() *Bios {
	if p.bios == nil {
		panic("the bios must not be nil, please use Bios() function instead")
	}
	return p.bios
}

func (p *Snapshot) SetCdroms(attr *CdromSlice) {
	p.cdroms = attr
}

func (p *Snapshot) Cdroms() (*CdromSlice, bool) {
	if p.cdroms != nil {
		return p.cdroms, true
	}
	return nil, false
}

func (p *Snapshot) MustCdroms() *CdromSlice {
	if p.cdroms == nil {
		panic("the cdroms must not be nil, please use Cdroms() function instead")
	}
	return p.cdroms
}

func (p *Snapshot) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *Snapshot) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *Snapshot) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *Snapshot) SetComment(attr string) {
	p.comment = &attr
}

func (p *Snapshot) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Snapshot) SetConsole(attr *Console) {
	p.console = attr
}

func (p *Snapshot) Console() (*Console, bool) {
	if p.console != nil {
		return p.console, true
	}
	return nil, false
}

func (p *Snapshot) MustConsole() *Console {
	if p.console == nil {
		panic("the console must not be nil, please use Console() function instead")
	}
	return p.console
}

func (p *Snapshot) SetCpu(attr *Cpu) {
	p.cpu = attr
}

func (p *Snapshot) Cpu() (*Cpu, bool) {
	if p.cpu != nil {
		return p.cpu, true
	}
	return nil, false
}

func (p *Snapshot) MustCpu() *Cpu {
	if p.cpu == nil {
		panic("the cpu must not be nil, please use Cpu() function instead")
	}
	return p.cpu
}

func (p *Snapshot) SetCpuProfile(attr *CpuProfile) {
	p.cpuProfile = attr
}

func (p *Snapshot) CpuProfile() (*CpuProfile, bool) {
	if p.cpuProfile != nil {
		return p.cpuProfile, true
	}
	return nil, false
}

func (p *Snapshot) MustCpuProfile() *CpuProfile {
	if p.cpuProfile == nil {
		panic("the cpuProfile must not be nil, please use CpuProfile() function instead")
	}
	return p.cpuProfile
}

func (p *Snapshot) SetCpuShares(attr int64) {
	p.cpuShares = &attr
}

func (p *Snapshot) CpuShares() (int64, bool) {
	if p.cpuShares != nil {
		return *p.cpuShares, true
	}
	var zero int64
	return zero, false
}

func (p *Snapshot) MustCpuShares() int64 {
	if p.cpuShares == nil {
		panic("the cpuShares must not be nil, please use CpuShares() function instead")
	}
	return *p.cpuShares
}

func (p *Snapshot) SetCreationTime(attr time.Time) {
	p.creationTime = &attr
}

func (p *Snapshot) CreationTime() (time.Time, bool) {
	if p.creationTime != nil {
		return *p.creationTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Snapshot) MustCreationTime() time.Time {
	if p.creationTime == nil {
		panic("the creationTime must not be nil, please use CreationTime() function instead")
	}
	return *p.creationTime
}

func (p *Snapshot) SetCustomCompatibilityVersion(attr *Version) {
	p.customCompatibilityVersion = attr
}

func (p *Snapshot) CustomCompatibilityVersion() (*Version, bool) {
	if p.customCompatibilityVersion != nil {
		return p.customCompatibilityVersion, true
	}
	return nil, false
}

func (p *Snapshot) MustCustomCompatibilityVersion() *Version {
	if p.customCompatibilityVersion == nil {
		panic("the customCompatibilityVersion must not be nil, please use CustomCompatibilityVersion() function instead")
	}
	return p.customCompatibilityVersion
}

func (p *Snapshot) SetCustomCpuModel(attr string) {
	p.customCpuModel = &attr
}

func (p *Snapshot) CustomCpuModel() (string, bool) {
	if p.customCpuModel != nil {
		return *p.customCpuModel, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustCustomCpuModel() string {
	if p.customCpuModel == nil {
		panic("the customCpuModel must not be nil, please use CustomCpuModel() function instead")
	}
	return *p.customCpuModel
}

func (p *Snapshot) SetCustomEmulatedMachine(attr string) {
	p.customEmulatedMachine = &attr
}

func (p *Snapshot) CustomEmulatedMachine() (string, bool) {
	if p.customEmulatedMachine != nil {
		return *p.customEmulatedMachine, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustCustomEmulatedMachine() string {
	if p.customEmulatedMachine == nil {
		panic("the customEmulatedMachine must not be nil, please use CustomEmulatedMachine() function instead")
	}
	return *p.customEmulatedMachine
}

func (p *Snapshot) SetCustomProperties(attr *CustomPropertySlice) {
	p.customProperties = attr
}

func (p *Snapshot) CustomProperties() (*CustomPropertySlice, bool) {
	if p.customProperties != nil {
		return p.customProperties, true
	}
	return nil, false
}

func (p *Snapshot) MustCustomProperties() *CustomPropertySlice {
	if p.customProperties == nil {
		panic("the customProperties must not be nil, please use CustomProperties() function instead")
	}
	return p.customProperties
}

func (p *Snapshot) SetDate(attr time.Time) {
	p.date = &attr
}

func (p *Snapshot) Date() (time.Time, bool) {
	if p.date != nil {
		return *p.date, true
	}
	var zero time.Time
	return zero, false
}

func (p *Snapshot) MustDate() time.Time {
	if p.date == nil {
		panic("the date must not be nil, please use Date() function instead")
	}
	return *p.date
}

func (p *Snapshot) SetDeleteProtected(attr bool) {
	p.deleteProtected = &attr
}

func (p *Snapshot) DeleteProtected() (bool, bool) {
	if p.deleteProtected != nil {
		return *p.deleteProtected, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustDeleteProtected() bool {
	if p.deleteProtected == nil {
		panic("the deleteProtected must not be nil, please use DeleteProtected() function instead")
	}
	return *p.deleteProtected
}

func (p *Snapshot) SetDescription(attr string) {
	p.description = &attr
}

func (p *Snapshot) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Snapshot) SetDiskAttachments(attr *DiskAttachmentSlice) {
	p.diskAttachments = attr
}

func (p *Snapshot) DiskAttachments() (*DiskAttachmentSlice, bool) {
	if p.diskAttachments != nil {
		return p.diskAttachments, true
	}
	return nil, false
}

func (p *Snapshot) MustDiskAttachments() *DiskAttachmentSlice {
	if p.diskAttachments == nil {
		panic("the diskAttachments must not be nil, please use DiskAttachments() function instead")
	}
	return p.diskAttachments
}

func (p *Snapshot) SetDisks(attr *DiskSlice) {
	p.disks = attr
}

func (p *Snapshot) Disks() (*DiskSlice, bool) {
	if p.disks != nil {
		return p.disks, true
	}
	return nil, false
}

func (p *Snapshot) MustDisks() *DiskSlice {
	if p.disks == nil {
		panic("the disks must not be nil, please use Disks() function instead")
	}
	return p.disks
}

func (p *Snapshot) SetDisplay(attr *Display) {
	p.display = attr
}

func (p *Snapshot) Display() (*Display, bool) {
	if p.display != nil {
		return p.display, true
	}
	return nil, false
}

func (p *Snapshot) MustDisplay() *Display {
	if p.display == nil {
		panic("the display must not be nil, please use Display() function instead")
	}
	return p.display
}

func (p *Snapshot) SetDomain(attr *Domain) {
	p.domain = attr
}

func (p *Snapshot) Domain() (*Domain, bool) {
	if p.domain != nil {
		return p.domain, true
	}
	return nil, false
}

func (p *Snapshot) MustDomain() *Domain {
	if p.domain == nil {
		panic("the domain must not be nil, please use Domain() function instead")
	}
	return p.domain
}

func (p *Snapshot) SetExternalHostProvider(attr *ExternalHostProvider) {
	p.externalHostProvider = attr
}

func (p *Snapshot) ExternalHostProvider() (*ExternalHostProvider, bool) {
	if p.externalHostProvider != nil {
		return p.externalHostProvider, true
	}
	return nil, false
}

func (p *Snapshot) MustExternalHostProvider() *ExternalHostProvider {
	if p.externalHostProvider == nil {
		panic("the externalHostProvider must not be nil, please use ExternalHostProvider() function instead")
	}
	return p.externalHostProvider
}

func (p *Snapshot) SetFloppies(attr *FloppySlice) {
	p.floppies = attr
}

func (p *Snapshot) Floppies() (*FloppySlice, bool) {
	if p.floppies != nil {
		return p.floppies, true
	}
	return nil, false
}

func (p *Snapshot) MustFloppies() *FloppySlice {
	if p.floppies == nil {
		panic("the floppies must not be nil, please use Floppies() function instead")
	}
	return p.floppies
}

func (p *Snapshot) SetFqdn(attr string) {
	p.fqdn = &attr
}

func (p *Snapshot) Fqdn() (string, bool) {
	if p.fqdn != nil {
		return *p.fqdn, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustFqdn() string {
	if p.fqdn == nil {
		panic("the fqdn must not be nil, please use Fqdn() function instead")
	}
	return *p.fqdn
}

func (p *Snapshot) SetGraphicsConsoles(attr *GraphicsConsoleSlice) {
	p.graphicsConsoles = attr
}

func (p *Snapshot) GraphicsConsoles() (*GraphicsConsoleSlice, bool) {
	if p.graphicsConsoles != nil {
		return p.graphicsConsoles, true
	}
	return nil, false
}

func (p *Snapshot) MustGraphicsConsoles() *GraphicsConsoleSlice {
	if p.graphicsConsoles == nil {
		panic("the graphicsConsoles must not be nil, please use GraphicsConsoles() function instead")
	}
	return p.graphicsConsoles
}

func (p *Snapshot) SetGuestOperatingSystem(attr *GuestOperatingSystem) {
	p.guestOperatingSystem = attr
}

func (p *Snapshot) GuestOperatingSystem() (*GuestOperatingSystem, bool) {
	if p.guestOperatingSystem != nil {
		return p.guestOperatingSystem, true
	}
	return nil, false
}

func (p *Snapshot) MustGuestOperatingSystem() *GuestOperatingSystem {
	if p.guestOperatingSystem == nil {
		panic("the guestOperatingSystem must not be nil, please use GuestOperatingSystem() function instead")
	}
	return p.guestOperatingSystem
}

func (p *Snapshot) SetGuestTimeZone(attr *TimeZone) {
	p.guestTimeZone = attr
}

func (p *Snapshot) GuestTimeZone() (*TimeZone, bool) {
	if p.guestTimeZone != nil {
		return p.guestTimeZone, true
	}
	return nil, false
}

func (p *Snapshot) MustGuestTimeZone() *TimeZone {
	if p.guestTimeZone == nil {
		panic("the guestTimeZone must not be nil, please use GuestTimeZone() function instead")
	}
	return p.guestTimeZone
}

func (p *Snapshot) SetHasIllegalImages(attr bool) {
	p.hasIllegalImages = &attr
}

func (p *Snapshot) HasIllegalImages() (bool, bool) {
	if p.hasIllegalImages != nil {
		return *p.hasIllegalImages, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustHasIllegalImages() bool {
	if p.hasIllegalImages == nil {
		panic("the hasIllegalImages must not be nil, please use HasIllegalImages() function instead")
	}
	return *p.hasIllegalImages
}

func (p *Snapshot) SetHighAvailability(attr *HighAvailability) {
	p.highAvailability = attr
}

func (p *Snapshot) HighAvailability() (*HighAvailability, bool) {
	if p.highAvailability != nil {
		return p.highAvailability, true
	}
	return nil, false
}

func (p *Snapshot) MustHighAvailability() *HighAvailability {
	if p.highAvailability == nil {
		panic("the highAvailability must not be nil, please use HighAvailability() function instead")
	}
	return p.highAvailability
}

func (p *Snapshot) SetHost(attr *Host) {
	p.host = attr
}

func (p *Snapshot) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *Snapshot) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *Snapshot) SetHostDevices(attr *HostDeviceSlice) {
	p.hostDevices = attr
}

func (p *Snapshot) HostDevices() (*HostDeviceSlice, bool) {
	if p.hostDevices != nil {
		return p.hostDevices, true
	}
	return nil, false
}

func (p *Snapshot) MustHostDevices() *HostDeviceSlice {
	if p.hostDevices == nil {
		panic("the hostDevices must not be nil, please use HostDevices() function instead")
	}
	return p.hostDevices
}

func (p *Snapshot) SetId(attr string) {
	p.id = &attr
}

func (p *Snapshot) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Snapshot) SetInitialization(attr *Initialization) {
	p.initialization = attr
}

func (p *Snapshot) Initialization() (*Initialization, bool) {
	if p.initialization != nil {
		return p.initialization, true
	}
	return nil, false
}

func (p *Snapshot) MustInitialization() *Initialization {
	if p.initialization == nil {
		panic("the initialization must not be nil, please use Initialization() function instead")
	}
	return p.initialization
}

func (p *Snapshot) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *Snapshot) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *Snapshot) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *Snapshot) SetIo(attr *Io) {
	p.io = attr
}

func (p *Snapshot) Io() (*Io, bool) {
	if p.io != nil {
		return p.io, true
	}
	return nil, false
}

func (p *Snapshot) MustIo() *Io {
	if p.io == nil {
		panic("the io must not be nil, please use Io() function instead")
	}
	return p.io
}

func (p *Snapshot) SetKatelloErrata(attr *KatelloErratumSlice) {
	p.katelloErrata = attr
}

func (p *Snapshot) KatelloErrata() (*KatelloErratumSlice, bool) {
	if p.katelloErrata != nil {
		return p.katelloErrata, true
	}
	return nil, false
}

func (p *Snapshot) MustKatelloErrata() *KatelloErratumSlice {
	if p.katelloErrata == nil {
		panic("the katelloErrata must not be nil, please use KatelloErrata() function instead")
	}
	return p.katelloErrata
}

func (p *Snapshot) SetLargeIcon(attr *Icon) {
	p.largeIcon = attr
}

func (p *Snapshot) LargeIcon() (*Icon, bool) {
	if p.largeIcon != nil {
		return p.largeIcon, true
	}
	return nil, false
}

func (p *Snapshot) MustLargeIcon() *Icon {
	if p.largeIcon == nil {
		panic("the largeIcon must not be nil, please use LargeIcon() function instead")
	}
	return p.largeIcon
}

func (p *Snapshot) SetLease(attr *StorageDomainLease) {
	p.lease = attr
}

func (p *Snapshot) Lease() (*StorageDomainLease, bool) {
	if p.lease != nil {
		return p.lease, true
	}
	return nil, false
}

func (p *Snapshot) MustLease() *StorageDomainLease {
	if p.lease == nil {
		panic("the lease must not be nil, please use Lease() function instead")
	}
	return p.lease
}

func (p *Snapshot) SetMemory(attr int64) {
	p.memory = &attr
}

func (p *Snapshot) Memory() (int64, bool) {
	if p.memory != nil {
		return *p.memory, true
	}
	var zero int64
	return zero, false
}

func (p *Snapshot) MustMemory() int64 {
	if p.memory == nil {
		panic("the memory must not be nil, please use Memory() function instead")
	}
	return *p.memory
}

func (p *Snapshot) SetMemoryPolicy(attr *MemoryPolicy) {
	p.memoryPolicy = attr
}

func (p *Snapshot) MemoryPolicy() (*MemoryPolicy, bool) {
	if p.memoryPolicy != nil {
		return p.memoryPolicy, true
	}
	return nil, false
}

func (p *Snapshot) MustMemoryPolicy() *MemoryPolicy {
	if p.memoryPolicy == nil {
		panic("the memoryPolicy must not be nil, please use MemoryPolicy() function instead")
	}
	return p.memoryPolicy
}

func (p *Snapshot) SetMigration(attr *MigrationOptions) {
	p.migration = attr
}

func (p *Snapshot) Migration() (*MigrationOptions, bool) {
	if p.migration != nil {
		return p.migration, true
	}
	return nil, false
}

func (p *Snapshot) MustMigration() *MigrationOptions {
	if p.migration == nil {
		panic("the migration must not be nil, please use Migration() function instead")
	}
	return p.migration
}

func (p *Snapshot) SetMigrationDowntime(attr int64) {
	p.migrationDowntime = &attr
}

func (p *Snapshot) MigrationDowntime() (int64, bool) {
	if p.migrationDowntime != nil {
		return *p.migrationDowntime, true
	}
	var zero int64
	return zero, false
}

func (p *Snapshot) MustMigrationDowntime() int64 {
	if p.migrationDowntime == nil {
		panic("the migrationDowntime must not be nil, please use MigrationDowntime() function instead")
	}
	return *p.migrationDowntime
}

func (p *Snapshot) SetMultiQueuesEnabled(attr bool) {
	p.multiQueuesEnabled = &attr
}

func (p *Snapshot) MultiQueuesEnabled() (bool, bool) {
	if p.multiQueuesEnabled != nil {
		return *p.multiQueuesEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustMultiQueuesEnabled() bool {
	if p.multiQueuesEnabled == nil {
		panic("the multiQueuesEnabled must not be nil, please use MultiQueuesEnabled() function instead")
	}
	return *p.multiQueuesEnabled
}

func (p *Snapshot) SetName(attr string) {
	p.name = &attr
}

func (p *Snapshot) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Snapshot) SetNextRunConfigurationExists(attr bool) {
	p.nextRunConfigurationExists = &attr
}

func (p *Snapshot) NextRunConfigurationExists() (bool, bool) {
	if p.nextRunConfigurationExists != nil {
		return *p.nextRunConfigurationExists, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustNextRunConfigurationExists() bool {
	if p.nextRunConfigurationExists == nil {
		panic("the nextRunConfigurationExists must not be nil, please use NextRunConfigurationExists() function instead")
	}
	return *p.nextRunConfigurationExists
}

func (p *Snapshot) SetNics(attr *NicSlice) {
	p.nics = attr
}

func (p *Snapshot) Nics() (*NicSlice, bool) {
	if p.nics != nil {
		return p.nics, true
	}
	return nil, false
}

func (p *Snapshot) MustNics() *NicSlice {
	if p.nics == nil {
		panic("the nics must not be nil, please use Nics() function instead")
	}
	return p.nics
}

func (p *Snapshot) SetNumaNodes(attr *NumaNodeSlice) {
	p.numaNodes = attr
}

func (p *Snapshot) NumaNodes() (*NumaNodeSlice, bool) {
	if p.numaNodes != nil {
		return p.numaNodes, true
	}
	return nil, false
}

func (p *Snapshot) MustNumaNodes() *NumaNodeSlice {
	if p.numaNodes == nil {
		panic("the numaNodes must not be nil, please use NumaNodes() function instead")
	}
	return p.numaNodes
}

func (p *Snapshot) SetNumaTuneMode(attr NumaTuneMode) {
	p.numaTuneMode = &attr
}

func (p *Snapshot) NumaTuneMode() (NumaTuneMode, bool) {
	if p.numaTuneMode != nil {
		return *p.numaTuneMode, true
	}
	var zero NumaTuneMode
	return zero, false
}

func (p *Snapshot) MustNumaTuneMode() NumaTuneMode {
	if p.numaTuneMode == nil {
		panic("the numaTuneMode must not be nil, please use NumaTuneMode() function instead")
	}
	return *p.numaTuneMode
}

func (p *Snapshot) SetOrigin(attr string) {
	p.origin = &attr
}

func (p *Snapshot) Origin() (string, bool) {
	if p.origin != nil {
		return *p.origin, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustOrigin() string {
	if p.origin == nil {
		panic("the origin must not be nil, please use Origin() function instead")
	}
	return *p.origin
}

func (p *Snapshot) SetOriginalTemplate(attr *Template) {
	p.originalTemplate = attr
}

func (p *Snapshot) OriginalTemplate() (*Template, bool) {
	if p.originalTemplate != nil {
		return p.originalTemplate, true
	}
	return nil, false
}

func (p *Snapshot) MustOriginalTemplate() *Template {
	if p.originalTemplate == nil {
		panic("the originalTemplate must not be nil, please use OriginalTemplate() function instead")
	}
	return p.originalTemplate
}

func (p *Snapshot) SetOs(attr *OperatingSystem) {
	p.os = attr
}

func (p *Snapshot) Os() (*OperatingSystem, bool) {
	if p.os != nil {
		return p.os, true
	}
	return nil, false
}

func (p *Snapshot) MustOs() *OperatingSystem {
	if p.os == nil {
		panic("the os must not be nil, please use Os() function instead")
	}
	return p.os
}

func (p *Snapshot) SetPayloads(attr *PayloadSlice) {
	p.payloads = attr
}

func (p *Snapshot) Payloads() (*PayloadSlice, bool) {
	if p.payloads != nil {
		return p.payloads, true
	}
	return nil, false
}

func (p *Snapshot) MustPayloads() *PayloadSlice {
	if p.payloads == nil {
		panic("the payloads must not be nil, please use Payloads() function instead")
	}
	return p.payloads
}

func (p *Snapshot) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *Snapshot) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *Snapshot) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *Snapshot) SetPersistMemorystate(attr bool) {
	p.persistMemorystate = &attr
}

func (p *Snapshot) PersistMemorystate() (bool, bool) {
	if p.persistMemorystate != nil {
		return *p.persistMemorystate, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustPersistMemorystate() bool {
	if p.persistMemorystate == nil {
		panic("the persistMemorystate must not be nil, please use PersistMemorystate() function instead")
	}
	return *p.persistMemorystate
}

func (p *Snapshot) SetPlacementPolicy(attr *VmPlacementPolicy) {
	p.placementPolicy = attr
}

func (p *Snapshot) PlacementPolicy() (*VmPlacementPolicy, bool) {
	if p.placementPolicy != nil {
		return p.placementPolicy, true
	}
	return nil, false
}

func (p *Snapshot) MustPlacementPolicy() *VmPlacementPolicy {
	if p.placementPolicy == nil {
		panic("the placementPolicy must not be nil, please use PlacementPolicy() function instead")
	}
	return p.placementPolicy
}

func (p *Snapshot) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *Snapshot) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *Snapshot) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *Snapshot) SetReportedDevices(attr *ReportedDeviceSlice) {
	p.reportedDevices = attr
}

func (p *Snapshot) ReportedDevices() (*ReportedDeviceSlice, bool) {
	if p.reportedDevices != nil {
		return p.reportedDevices, true
	}
	return nil, false
}

func (p *Snapshot) MustReportedDevices() *ReportedDeviceSlice {
	if p.reportedDevices == nil {
		panic("the reportedDevices must not be nil, please use ReportedDevices() function instead")
	}
	return p.reportedDevices
}

func (p *Snapshot) SetRngDevice(attr *RngDevice) {
	p.rngDevice = attr
}

func (p *Snapshot) RngDevice() (*RngDevice, bool) {
	if p.rngDevice != nil {
		return p.rngDevice, true
	}
	return nil, false
}

func (p *Snapshot) MustRngDevice() *RngDevice {
	if p.rngDevice == nil {
		panic("the rngDevice must not be nil, please use RngDevice() function instead")
	}
	return p.rngDevice
}

func (p *Snapshot) SetRunOnce(attr bool) {
	p.runOnce = &attr
}

func (p *Snapshot) RunOnce() (bool, bool) {
	if p.runOnce != nil {
		return *p.runOnce, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustRunOnce() bool {
	if p.runOnce == nil {
		panic("the runOnce must not be nil, please use RunOnce() function instead")
	}
	return *p.runOnce
}

func (p *Snapshot) SetSerialNumber(attr *SerialNumber) {
	p.serialNumber = attr
}

func (p *Snapshot) SerialNumber() (*SerialNumber, bool) {
	if p.serialNumber != nil {
		return p.serialNumber, true
	}
	return nil, false
}

func (p *Snapshot) MustSerialNumber() *SerialNumber {
	if p.serialNumber == nil {
		panic("the serialNumber must not be nil, please use SerialNumber() function instead")
	}
	return p.serialNumber
}

func (p *Snapshot) SetSessions(attr *SessionSlice) {
	p.sessions = attr
}

func (p *Snapshot) Sessions() (*SessionSlice, bool) {
	if p.sessions != nil {
		return p.sessions, true
	}
	return nil, false
}

func (p *Snapshot) MustSessions() *SessionSlice {
	if p.sessions == nil {
		panic("the sessions must not be nil, please use Sessions() function instead")
	}
	return p.sessions
}

func (p *Snapshot) SetSmallIcon(attr *Icon) {
	p.smallIcon = attr
}

func (p *Snapshot) SmallIcon() (*Icon, bool) {
	if p.smallIcon != nil {
		return p.smallIcon, true
	}
	return nil, false
}

func (p *Snapshot) MustSmallIcon() *Icon {
	if p.smallIcon == nil {
		panic("the smallIcon must not be nil, please use SmallIcon() function instead")
	}
	return p.smallIcon
}

func (p *Snapshot) SetSnapshotStatus(attr SnapshotStatus) {
	p.snapshotStatus = &attr
}

func (p *Snapshot) SnapshotStatus() (SnapshotStatus, bool) {
	if p.snapshotStatus != nil {
		return *p.snapshotStatus, true
	}
	var zero SnapshotStatus
	return zero, false
}

func (p *Snapshot) MustSnapshotStatus() SnapshotStatus {
	if p.snapshotStatus == nil {
		panic("the snapshotStatus must not be nil, please use SnapshotStatus() function instead")
	}
	return *p.snapshotStatus
}

func (p *Snapshot) SetSnapshotType(attr SnapshotType) {
	p.snapshotType = &attr
}

func (p *Snapshot) SnapshotType() (SnapshotType, bool) {
	if p.snapshotType != nil {
		return *p.snapshotType, true
	}
	var zero SnapshotType
	return zero, false
}

func (p *Snapshot) MustSnapshotType() SnapshotType {
	if p.snapshotType == nil {
		panic("the snapshotType must not be nil, please use SnapshotType() function instead")
	}
	return *p.snapshotType
}

func (p *Snapshot) SetSnapshots(attr *SnapshotSlice) {
	p.snapshots = attr
}

func (p *Snapshot) Snapshots() (*SnapshotSlice, bool) {
	if p.snapshots != nil {
		return p.snapshots, true
	}
	return nil, false
}

func (p *Snapshot) MustSnapshots() *SnapshotSlice {
	if p.snapshots == nil {
		panic("the snapshots must not be nil, please use Snapshots() function instead")
	}
	return p.snapshots
}

func (p *Snapshot) SetSoundcardEnabled(attr bool) {
	p.soundcardEnabled = &attr
}

func (p *Snapshot) SoundcardEnabled() (bool, bool) {
	if p.soundcardEnabled != nil {
		return *p.soundcardEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustSoundcardEnabled() bool {
	if p.soundcardEnabled == nil {
		panic("the soundcardEnabled must not be nil, please use SoundcardEnabled() function instead")
	}
	return *p.soundcardEnabled
}

func (p *Snapshot) SetSso(attr *Sso) {
	p.sso = attr
}

func (p *Snapshot) Sso() (*Sso, bool) {
	if p.sso != nil {
		return p.sso, true
	}
	return nil, false
}

func (p *Snapshot) MustSso() *Sso {
	if p.sso == nil {
		panic("the sso must not be nil, please use Sso() function instead")
	}
	return p.sso
}

func (p *Snapshot) SetStartPaused(attr bool) {
	p.startPaused = &attr
}

func (p *Snapshot) StartPaused() (bool, bool) {
	if p.startPaused != nil {
		return *p.startPaused, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustStartPaused() bool {
	if p.startPaused == nil {
		panic("the startPaused must not be nil, please use StartPaused() function instead")
	}
	return *p.startPaused
}

func (p *Snapshot) SetStartTime(attr time.Time) {
	p.startTime = &attr
}

func (p *Snapshot) StartTime() (time.Time, bool) {
	if p.startTime != nil {
		return *p.startTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Snapshot) MustStartTime() time.Time {
	if p.startTime == nil {
		panic("the startTime must not be nil, please use StartTime() function instead")
	}
	return *p.startTime
}

func (p *Snapshot) SetStateless(attr bool) {
	p.stateless = &attr
}

func (p *Snapshot) Stateless() (bool, bool) {
	if p.stateless != nil {
		return *p.stateless, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustStateless() bool {
	if p.stateless == nil {
		panic("the stateless must not be nil, please use Stateless() function instead")
	}
	return *p.stateless
}

func (p *Snapshot) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *Snapshot) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *Snapshot) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *Snapshot) SetStatus(attr VmStatus) {
	p.status = &attr
}

func (p *Snapshot) Status() (VmStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero VmStatus
	return zero, false
}

func (p *Snapshot) MustStatus() VmStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *Snapshot) SetStatusDetail(attr string) {
	p.statusDetail = &attr
}

func (p *Snapshot) StatusDetail() (string, bool) {
	if p.statusDetail != nil {
		return *p.statusDetail, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustStatusDetail() string {
	if p.statusDetail == nil {
		panic("the statusDetail must not be nil, please use StatusDetail() function instead")
	}
	return *p.statusDetail
}

func (p *Snapshot) SetStopReason(attr string) {
	p.stopReason = &attr
}

func (p *Snapshot) StopReason() (string, bool) {
	if p.stopReason != nil {
		return *p.stopReason, true
	}
	var zero string
	return zero, false
}

func (p *Snapshot) MustStopReason() string {
	if p.stopReason == nil {
		panic("the stopReason must not be nil, please use StopReason() function instead")
	}
	return *p.stopReason
}

func (p *Snapshot) SetStopTime(attr time.Time) {
	p.stopTime = &attr
}

func (p *Snapshot) StopTime() (time.Time, bool) {
	if p.stopTime != nil {
		return *p.stopTime, true
	}
	var zero time.Time
	return zero, false
}

func (p *Snapshot) MustStopTime() time.Time {
	if p.stopTime == nil {
		panic("the stopTime must not be nil, please use StopTime() function instead")
	}
	return *p.stopTime
}

func (p *Snapshot) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *Snapshot) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *Snapshot) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *Snapshot) SetStorageErrorResumeBehaviour(attr VmStorageErrorResumeBehaviour) {
	p.storageErrorResumeBehaviour = &attr
}

func (p *Snapshot) StorageErrorResumeBehaviour() (VmStorageErrorResumeBehaviour, bool) {
	if p.storageErrorResumeBehaviour != nil {
		return *p.storageErrorResumeBehaviour, true
	}
	var zero VmStorageErrorResumeBehaviour
	return zero, false
}

func (p *Snapshot) MustStorageErrorResumeBehaviour() VmStorageErrorResumeBehaviour {
	if p.storageErrorResumeBehaviour == nil {
		panic("the storageErrorResumeBehaviour must not be nil, please use StorageErrorResumeBehaviour() function instead")
	}
	return *p.storageErrorResumeBehaviour
}

func (p *Snapshot) SetTags(attr *TagSlice) {
	p.tags = attr
}

func (p *Snapshot) Tags() (*TagSlice, bool) {
	if p.tags != nil {
		return p.tags, true
	}
	return nil, false
}

func (p *Snapshot) MustTags() *TagSlice {
	if p.tags == nil {
		panic("the tags must not be nil, please use Tags() function instead")
	}
	return p.tags
}

func (p *Snapshot) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Snapshot) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Snapshot) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Snapshot) SetTimeZone(attr *TimeZone) {
	p.timeZone = attr
}

func (p *Snapshot) TimeZone() (*TimeZone, bool) {
	if p.timeZone != nil {
		return p.timeZone, true
	}
	return nil, false
}

func (p *Snapshot) MustTimeZone() *TimeZone {
	if p.timeZone == nil {
		panic("the timeZone must not be nil, please use TimeZone() function instead")
	}
	return p.timeZone
}

func (p *Snapshot) SetTunnelMigration(attr bool) {
	p.tunnelMigration = &attr
}

func (p *Snapshot) TunnelMigration() (bool, bool) {
	if p.tunnelMigration != nil {
		return *p.tunnelMigration, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustTunnelMigration() bool {
	if p.tunnelMigration == nil {
		panic("the tunnelMigration must not be nil, please use TunnelMigration() function instead")
	}
	return *p.tunnelMigration
}

func (p *Snapshot) SetType(attr VmType) {
	p.type_ = &attr
}

func (p *Snapshot) Type() (VmType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero VmType
	return zero, false
}

func (p *Snapshot) MustType() VmType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *Snapshot) SetUsb(attr *Usb) {
	p.usb = attr
}

func (p *Snapshot) Usb() (*Usb, bool) {
	if p.usb != nil {
		return p.usb, true
	}
	return nil, false
}

func (p *Snapshot) MustUsb() *Usb {
	if p.usb == nil {
		panic("the usb must not be nil, please use Usb() function instead")
	}
	return p.usb
}

func (p *Snapshot) SetUseLatestTemplateVersion(attr bool) {
	p.useLatestTemplateVersion = &attr
}

func (p *Snapshot) UseLatestTemplateVersion() (bool, bool) {
	if p.useLatestTemplateVersion != nil {
		return *p.useLatestTemplateVersion, true
	}
	var zero bool
	return zero, false
}

func (p *Snapshot) MustUseLatestTemplateVersion() bool {
	if p.useLatestTemplateVersion == nil {
		panic("the useLatestTemplateVersion must not be nil, please use UseLatestTemplateVersion() function instead")
	}
	return *p.useLatestTemplateVersion
}

func (p *Snapshot) SetVirtioScsi(attr *VirtioScsi) {
	p.virtioScsi = attr
}

func (p *Snapshot) VirtioScsi() (*VirtioScsi, bool) {
	if p.virtioScsi != nil {
		return p.virtioScsi, true
	}
	return nil, false
}

func (p *Snapshot) MustVirtioScsi() *VirtioScsi {
	if p.virtioScsi == nil {
		panic("the virtioScsi must not be nil, please use VirtioScsi() function instead")
	}
	return p.virtioScsi
}

func (p *Snapshot) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Snapshot) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Snapshot) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Snapshot) SetVmPool(attr *VmPool) {
	p.vmPool = attr
}

func (p *Snapshot) VmPool() (*VmPool, bool) {
	if p.vmPool != nil {
		return p.vmPool, true
	}
	return nil, false
}

func (p *Snapshot) MustVmPool() *VmPool {
	if p.vmPool == nil {
		panic("the vmPool must not be nil, please use VmPool() function instead")
	}
	return p.vmPool
}

func (p *Snapshot) SetWatchdogs(attr *WatchdogSlice) {
	p.watchdogs = attr
}

func (p *Snapshot) Watchdogs() (*WatchdogSlice, bool) {
	if p.watchdogs != nil {
		return p.watchdogs, true
	}
	return nil, false
}

func (p *Snapshot) MustWatchdogs() *WatchdogSlice {
	if p.watchdogs == nil {
		panic("the watchdogs must not be nil, please use Watchdogs() function instead")
	}
	return p.watchdogs
}

type HostedEngine struct {
	Struct
	active            *bool
	configured        *bool
	globalMaintenance *bool
	localMaintenance  *bool
	score             *int64
}

func (p *HostedEngine) SetActive(attr bool) {
	p.active = &attr
}

func (p *HostedEngine) Active() (bool, bool) {
	if p.active != nil {
		return *p.active, true
	}
	var zero bool
	return zero, false
}

func (p *HostedEngine) MustActive() bool {
	if p.active == nil {
		panic("the active must not be nil, please use Active() function instead")
	}
	return *p.active
}

func (p *HostedEngine) SetConfigured(attr bool) {
	p.configured = &attr
}

func (p *HostedEngine) Configured() (bool, bool) {
	if p.configured != nil {
		return *p.configured, true
	}
	var zero bool
	return zero, false
}

func (p *HostedEngine) MustConfigured() bool {
	if p.configured == nil {
		panic("the configured must not be nil, please use Configured() function instead")
	}
	return *p.configured
}

func (p *HostedEngine) SetGlobalMaintenance(attr bool) {
	p.globalMaintenance = &attr
}

func (p *HostedEngine) GlobalMaintenance() (bool, bool) {
	if p.globalMaintenance != nil {
		return *p.globalMaintenance, true
	}
	var zero bool
	return zero, false
}

func (p *HostedEngine) MustGlobalMaintenance() bool {
	if p.globalMaintenance == nil {
		panic("the globalMaintenance must not be nil, please use GlobalMaintenance() function instead")
	}
	return *p.globalMaintenance
}

func (p *HostedEngine) SetLocalMaintenance(attr bool) {
	p.localMaintenance = &attr
}

func (p *HostedEngine) LocalMaintenance() (bool, bool) {
	if p.localMaintenance != nil {
		return *p.localMaintenance, true
	}
	var zero bool
	return zero, false
}

func (p *HostedEngine) MustLocalMaintenance() bool {
	if p.localMaintenance == nil {
		panic("the localMaintenance must not be nil, please use LocalMaintenance() function instead")
	}
	return *p.localMaintenance
}

func (p *HostedEngine) SetScore(attr int64) {
	p.score = &attr
}

func (p *HostedEngine) Score() (int64, bool) {
	if p.score != nil {
		return *p.score, true
	}
	var zero int64
	return zero, false
}

func (p *HostedEngine) MustScore() int64 {
	if p.score == nil {
		panic("the score must not be nil, please use Score() function instead")
	}
	return *p.score
}

type DiskAttachment struct {
	Struct
	active              *bool
	bootable            *bool
	comment             *string
	description         *string
	disk                *Disk
	id                  *string
	interface_          *DiskInterface
	logicalName         *string
	name                *string
	passDiscard         *bool
	readOnly            *bool
	template            *Template
	usesScsiReservation *bool
	vm                  *Vm
}

func (p *DiskAttachment) SetActive(attr bool) {
	p.active = &attr
}

func (p *DiskAttachment) Active() (bool, bool) {
	if p.active != nil {
		return *p.active, true
	}
	var zero bool
	return zero, false
}

func (p *DiskAttachment) MustActive() bool {
	if p.active == nil {
		panic("the active must not be nil, please use Active() function instead")
	}
	return *p.active
}

func (p *DiskAttachment) SetBootable(attr bool) {
	p.bootable = &attr
}

func (p *DiskAttachment) Bootable() (bool, bool) {
	if p.bootable != nil {
		return *p.bootable, true
	}
	var zero bool
	return zero, false
}

func (p *DiskAttachment) MustBootable() bool {
	if p.bootable == nil {
		panic("the bootable must not be nil, please use Bootable() function instead")
	}
	return *p.bootable
}

func (p *DiskAttachment) SetComment(attr string) {
	p.comment = &attr
}

func (p *DiskAttachment) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *DiskAttachment) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *DiskAttachment) SetDescription(attr string) {
	p.description = &attr
}

func (p *DiskAttachment) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *DiskAttachment) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *DiskAttachment) SetDisk(attr *Disk) {
	p.disk = attr
}

func (p *DiskAttachment) Disk() (*Disk, bool) {
	if p.disk != nil {
		return p.disk, true
	}
	return nil, false
}

func (p *DiskAttachment) MustDisk() *Disk {
	if p.disk == nil {
		panic("the disk must not be nil, please use Disk() function instead")
	}
	return p.disk
}

func (p *DiskAttachment) SetId(attr string) {
	p.id = &attr
}

func (p *DiskAttachment) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *DiskAttachment) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *DiskAttachment) SetInterface(attr DiskInterface) {
	p.interface_ = &attr
}

func (p *DiskAttachment) Interface() (DiskInterface, bool) {
	if p.interface_ != nil {
		return *p.interface_, true
	}
	var zero DiskInterface
	return zero, false
}

func (p *DiskAttachment) MustInterface() DiskInterface {
	if p.interface_ == nil {
		panic("the interface_ must not be nil, please use Interface() function instead")
	}
	return *p.interface_
}

func (p *DiskAttachment) SetLogicalName(attr string) {
	p.logicalName = &attr
}

func (p *DiskAttachment) LogicalName() (string, bool) {
	if p.logicalName != nil {
		return *p.logicalName, true
	}
	var zero string
	return zero, false
}

func (p *DiskAttachment) MustLogicalName() string {
	if p.logicalName == nil {
		panic("the logicalName must not be nil, please use LogicalName() function instead")
	}
	return *p.logicalName
}

func (p *DiskAttachment) SetName(attr string) {
	p.name = &attr
}

func (p *DiskAttachment) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *DiskAttachment) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *DiskAttachment) SetPassDiscard(attr bool) {
	p.passDiscard = &attr
}

func (p *DiskAttachment) PassDiscard() (bool, bool) {
	if p.passDiscard != nil {
		return *p.passDiscard, true
	}
	var zero bool
	return zero, false
}

func (p *DiskAttachment) MustPassDiscard() bool {
	if p.passDiscard == nil {
		panic("the passDiscard must not be nil, please use PassDiscard() function instead")
	}
	return *p.passDiscard
}

func (p *DiskAttachment) SetReadOnly(attr bool) {
	p.readOnly = &attr
}

func (p *DiskAttachment) ReadOnly() (bool, bool) {
	if p.readOnly != nil {
		return *p.readOnly, true
	}
	var zero bool
	return zero, false
}

func (p *DiskAttachment) MustReadOnly() bool {
	if p.readOnly == nil {
		panic("the readOnly must not be nil, please use ReadOnly() function instead")
	}
	return *p.readOnly
}

func (p *DiskAttachment) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *DiskAttachment) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *DiskAttachment) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *DiskAttachment) SetUsesScsiReservation(attr bool) {
	p.usesScsiReservation = &attr
}

func (p *DiskAttachment) UsesScsiReservation() (bool, bool) {
	if p.usesScsiReservation != nil {
		return *p.usesScsiReservation, true
	}
	var zero bool
	return zero, false
}

func (p *DiskAttachment) MustUsesScsiReservation() bool {
	if p.usesScsiReservation == nil {
		panic("the usesScsiReservation must not be nil, please use UsesScsiReservation() function instead")
	}
	return *p.usesScsiReservation
}

func (p *DiskAttachment) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *DiskAttachment) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *DiskAttachment) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type Certificate struct {
	Struct
	comment      *string
	content      *string
	description  *string
	id           *string
	name         *string
	organization *string
	subject      *string
}

func (p *Certificate) SetComment(attr string) {
	p.comment = &attr
}

func (p *Certificate) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Certificate) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Certificate) SetContent(attr string) {
	p.content = &attr
}

func (p *Certificate) Content() (string, bool) {
	if p.content != nil {
		return *p.content, true
	}
	var zero string
	return zero, false
}

func (p *Certificate) MustContent() string {
	if p.content == nil {
		panic("the content must not be nil, please use Content() function instead")
	}
	return *p.content
}

func (p *Certificate) SetDescription(attr string) {
	p.description = &attr
}

func (p *Certificate) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Certificate) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Certificate) SetId(attr string) {
	p.id = &attr
}

func (p *Certificate) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Certificate) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Certificate) SetName(attr string) {
	p.name = &attr
}

func (p *Certificate) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Certificate) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Certificate) SetOrganization(attr string) {
	p.organization = &attr
}

func (p *Certificate) Organization() (string, bool) {
	if p.organization != nil {
		return *p.organization, true
	}
	var zero string
	return zero, false
}

func (p *Certificate) MustOrganization() string {
	if p.organization == nil {
		panic("the organization must not be nil, please use Organization() function instead")
	}
	return *p.organization
}

func (p *Certificate) SetSubject(attr string) {
	p.subject = &attr
}

func (p *Certificate) Subject() (string, bool) {
	if p.subject != nil {
		return *p.subject, true
	}
	var zero string
	return zero, false
}

func (p *Certificate) MustSubject() string {
	if p.subject == nil {
		panic("the subject must not be nil, please use Subject() function instead")
	}
	return *p.subject
}

type ReportedConfiguration struct {
	Struct
	actualValue   *string
	expectedValue *string
	inSync        *bool
	name          *string
}

func (p *ReportedConfiguration) SetActualValue(attr string) {
	p.actualValue = &attr
}

func (p *ReportedConfiguration) ActualValue() (string, bool) {
	if p.actualValue != nil {
		return *p.actualValue, true
	}
	var zero string
	return zero, false
}

func (p *ReportedConfiguration) MustActualValue() string {
	if p.actualValue == nil {
		panic("the actualValue must not be nil, please use ActualValue() function instead")
	}
	return *p.actualValue
}

func (p *ReportedConfiguration) SetExpectedValue(attr string) {
	p.expectedValue = &attr
}

func (p *ReportedConfiguration) ExpectedValue() (string, bool) {
	if p.expectedValue != nil {
		return *p.expectedValue, true
	}
	var zero string
	return zero, false
}

func (p *ReportedConfiguration) MustExpectedValue() string {
	if p.expectedValue == nil {
		panic("the expectedValue must not be nil, please use ExpectedValue() function instead")
	}
	return *p.expectedValue
}

func (p *ReportedConfiguration) SetInSync(attr bool) {
	p.inSync = &attr
}

func (p *ReportedConfiguration) InSync() (bool, bool) {
	if p.inSync != nil {
		return *p.inSync, true
	}
	var zero bool
	return zero, false
}

func (p *ReportedConfiguration) MustInSync() bool {
	if p.inSync == nil {
		panic("the inSync must not be nil, please use InSync() function instead")
	}
	return *p.inSync
}

func (p *ReportedConfiguration) SetName(attr string) {
	p.name = &attr
}

func (p *ReportedConfiguration) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *ReportedConfiguration) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type Backup struct {
	Struct
	comment          *string
	creationDate     *time.Time
	description      *string
	disks            *DiskSlice
	fromCheckpointId *string
	id               *string
	name             *string
	phase            *BackupPhase
	toCheckpointId   *string
	vm               *Vm
}

func (p *Backup) SetComment(attr string) {
	p.comment = &attr
}

func (p *Backup) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Backup) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Backup) SetCreationDate(attr time.Time) {
	p.creationDate = &attr
}

func (p *Backup) CreationDate() (time.Time, bool) {
	if p.creationDate != nil {
		return *p.creationDate, true
	}
	var zero time.Time
	return zero, false
}

func (p *Backup) MustCreationDate() time.Time {
	if p.creationDate == nil {
		panic("the creationDate must not be nil, please use CreationDate() function instead")
	}
	return *p.creationDate
}

func (p *Backup) SetDescription(attr string) {
	p.description = &attr
}

func (p *Backup) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Backup) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Backup) SetDisks(attr *DiskSlice) {
	p.disks = attr
}

func (p *Backup) Disks() (*DiskSlice, bool) {
	if p.disks != nil {
		return p.disks, true
	}
	return nil, false
}

func (p *Backup) MustDisks() *DiskSlice {
	if p.disks == nil {
		panic("the disks must not be nil, please use Disks() function instead")
	}
	return p.disks
}

func (p *Backup) SetFromCheckpointId(attr string) {
	p.fromCheckpointId = &attr
}

func (p *Backup) FromCheckpointId() (string, bool) {
	if p.fromCheckpointId != nil {
		return *p.fromCheckpointId, true
	}
	var zero string
	return zero, false
}

func (p *Backup) MustFromCheckpointId() string {
	if p.fromCheckpointId == nil {
		panic("the fromCheckpointId must not be nil, please use FromCheckpointId() function instead")
	}
	return *p.fromCheckpointId
}

func (p *Backup) SetId(attr string) {
	p.id = &attr
}

func (p *Backup) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Backup) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Backup) SetName(attr string) {
	p.name = &attr
}

func (p *Backup) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Backup) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Backup) SetPhase(attr BackupPhase) {
	p.phase = &attr
}

func (p *Backup) Phase() (BackupPhase, bool) {
	if p.phase != nil {
		return *p.phase, true
	}
	var zero BackupPhase
	return zero, false
}

func (p *Backup) MustPhase() BackupPhase {
	if p.phase == nil {
		panic("the phase must not be nil, please use Phase() function instead")
	}
	return *p.phase
}

func (p *Backup) SetToCheckpointId(attr string) {
	p.toCheckpointId = &attr
}

func (p *Backup) ToCheckpointId() (string, bool) {
	if p.toCheckpointId != nil {
		return *p.toCheckpointId, true
	}
	var zero string
	return zero, false
}

func (p *Backup) MustToCheckpointId() string {
	if p.toCheckpointId == nil {
		panic("the toCheckpointId must not be nil, please use ToCheckpointId() function instead")
	}
	return *p.toCheckpointId
}

func (p *Backup) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Backup) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Backup) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type SchedulingPolicy struct {
	Struct
	balances      *BalanceSlice
	comment       *string
	defaultPolicy *bool
	description   *string
	filters       *FilterSlice
	id            *string
	locked        *bool
	name          *string
	properties    *PropertySlice
	weight        *WeightSlice
}

func (p *SchedulingPolicy) SetBalances(attr *BalanceSlice) {
	p.balances = attr
}

func (p *SchedulingPolicy) Balances() (*BalanceSlice, bool) {
	if p.balances != nil {
		return p.balances, true
	}
	return nil, false
}

func (p *SchedulingPolicy) MustBalances() *BalanceSlice {
	if p.balances == nil {
		panic("the balances must not be nil, please use Balances() function instead")
	}
	return p.balances
}

func (p *SchedulingPolicy) SetComment(attr string) {
	p.comment = &attr
}

func (p *SchedulingPolicy) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *SchedulingPolicy) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *SchedulingPolicy) SetDefaultPolicy(attr bool) {
	p.defaultPolicy = &attr
}

func (p *SchedulingPolicy) DefaultPolicy() (bool, bool) {
	if p.defaultPolicy != nil {
		return *p.defaultPolicy, true
	}
	var zero bool
	return zero, false
}

func (p *SchedulingPolicy) MustDefaultPolicy() bool {
	if p.defaultPolicy == nil {
		panic("the defaultPolicy must not be nil, please use DefaultPolicy() function instead")
	}
	return *p.defaultPolicy
}

func (p *SchedulingPolicy) SetDescription(attr string) {
	p.description = &attr
}

func (p *SchedulingPolicy) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *SchedulingPolicy) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *SchedulingPolicy) SetFilters(attr *FilterSlice) {
	p.filters = attr
}

func (p *SchedulingPolicy) Filters() (*FilterSlice, bool) {
	if p.filters != nil {
		return p.filters, true
	}
	return nil, false
}

func (p *SchedulingPolicy) MustFilters() *FilterSlice {
	if p.filters == nil {
		panic("the filters must not be nil, please use Filters() function instead")
	}
	return p.filters
}

func (p *SchedulingPolicy) SetId(attr string) {
	p.id = &attr
}

func (p *SchedulingPolicy) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *SchedulingPolicy) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *SchedulingPolicy) SetLocked(attr bool) {
	p.locked = &attr
}

func (p *SchedulingPolicy) Locked() (bool, bool) {
	if p.locked != nil {
		return *p.locked, true
	}
	var zero bool
	return zero, false
}

func (p *SchedulingPolicy) MustLocked() bool {
	if p.locked == nil {
		panic("the locked must not be nil, please use Locked() function instead")
	}
	return *p.locked
}

func (p *SchedulingPolicy) SetName(attr string) {
	p.name = &attr
}

func (p *SchedulingPolicy) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *SchedulingPolicy) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *SchedulingPolicy) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *SchedulingPolicy) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *SchedulingPolicy) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *SchedulingPolicy) SetWeight(attr *WeightSlice) {
	p.weight = attr
}

func (p *SchedulingPolicy) Weight() (*WeightSlice, bool) {
	if p.weight != nil {
		return p.weight, true
	}
	return nil, false
}

func (p *SchedulingPolicy) MustWeight() *WeightSlice {
	if p.weight == nil {
		panic("the weight must not be nil, please use Weight() function instead")
	}
	return p.weight
}

type Cpu struct {
	Struct
	architecture *Architecture
	cores        *CoreSlice
	cpuTune      *CpuTune
	level        *int64
	mode         *CpuMode
	name         *string
	speed        *float64
	topology     *CpuTopology
	type_        *string
}

func (p *Cpu) SetArchitecture(attr Architecture) {
	p.architecture = &attr
}

func (p *Cpu) Architecture() (Architecture, bool) {
	if p.architecture != nil {
		return *p.architecture, true
	}
	var zero Architecture
	return zero, false
}

func (p *Cpu) MustArchitecture() Architecture {
	if p.architecture == nil {
		panic("the architecture must not be nil, please use Architecture() function instead")
	}
	return *p.architecture
}

func (p *Cpu) SetCores(attr *CoreSlice) {
	p.cores = attr
}

func (p *Cpu) Cores() (*CoreSlice, bool) {
	if p.cores != nil {
		return p.cores, true
	}
	return nil, false
}

func (p *Cpu) MustCores() *CoreSlice {
	if p.cores == nil {
		panic("the cores must not be nil, please use Cores() function instead")
	}
	return p.cores
}

func (p *Cpu) SetCpuTune(attr *CpuTune) {
	p.cpuTune = attr
}

func (p *Cpu) CpuTune() (*CpuTune, bool) {
	if p.cpuTune != nil {
		return p.cpuTune, true
	}
	return nil, false
}

func (p *Cpu) MustCpuTune() *CpuTune {
	if p.cpuTune == nil {
		panic("the cpuTune must not be nil, please use CpuTune() function instead")
	}
	return p.cpuTune
}

func (p *Cpu) SetLevel(attr int64) {
	p.level = &attr
}

func (p *Cpu) Level() (int64, bool) {
	if p.level != nil {
		return *p.level, true
	}
	var zero int64
	return zero, false
}

func (p *Cpu) MustLevel() int64 {
	if p.level == nil {
		panic("the level must not be nil, please use Level() function instead")
	}
	return *p.level
}

func (p *Cpu) SetMode(attr CpuMode) {
	p.mode = &attr
}

func (p *Cpu) Mode() (CpuMode, bool) {
	if p.mode != nil {
		return *p.mode, true
	}
	var zero CpuMode
	return zero, false
}

func (p *Cpu) MustMode() CpuMode {
	if p.mode == nil {
		panic("the mode must not be nil, please use Mode() function instead")
	}
	return *p.mode
}

func (p *Cpu) SetName(attr string) {
	p.name = &attr
}

func (p *Cpu) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Cpu) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Cpu) SetSpeed(attr float64) {
	p.speed = &attr
}

func (p *Cpu) Speed() (float64, bool) {
	if p.speed != nil {
		return *p.speed, true
	}
	var zero float64
	return zero, false
}

func (p *Cpu) MustSpeed() float64 {
	if p.speed == nil {
		panic("the speed must not be nil, please use Speed() function instead")
	}
	return *p.speed
}

func (p *Cpu) SetTopology(attr *CpuTopology) {
	p.topology = attr
}

func (p *Cpu) Topology() (*CpuTopology, bool) {
	if p.topology != nil {
		return p.topology, true
	}
	return nil, false
}

func (p *Cpu) MustTopology() *CpuTopology {
	if p.topology == nil {
		panic("the topology must not be nil, please use Topology() function instead")
	}
	return p.topology
}

func (p *Cpu) SetType(attr string) {
	p.type_ = &attr
}

func (p *Cpu) Type() (string, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero string
	return zero, false
}

func (p *Cpu) MustType() string {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type RegistrationAffinityLabelMapping struct {
	Struct
	from *AffinityLabel
	to   *AffinityLabel
}

func (p *RegistrationAffinityLabelMapping) SetFrom(attr *AffinityLabel) {
	p.from = attr
}

func (p *RegistrationAffinityLabelMapping) From() (*AffinityLabel, bool) {
	if p.from != nil {
		return p.from, true
	}
	return nil, false
}

func (p *RegistrationAffinityLabelMapping) MustFrom() *AffinityLabel {
	if p.from == nil {
		panic("the from must not be nil, please use From() function instead")
	}
	return p.from
}

func (p *RegistrationAffinityLabelMapping) SetTo(attr *AffinityLabel) {
	p.to = attr
}

func (p *RegistrationAffinityLabelMapping) To() (*AffinityLabel, bool) {
	if p.to != nil {
		return p.to, true
	}
	return nil, false
}

func (p *RegistrationAffinityLabelMapping) MustTo() *AffinityLabel {
	if p.to == nil {
		panic("the to must not be nil, please use To() function instead")
	}
	return p.to
}

type IpAddressAssignment struct {
	Struct
	assignmentMethod *BootProtocol
	ip               *Ip
}

func (p *IpAddressAssignment) SetAssignmentMethod(attr BootProtocol) {
	p.assignmentMethod = &attr
}

func (p *IpAddressAssignment) AssignmentMethod() (BootProtocol, bool) {
	if p.assignmentMethod != nil {
		return *p.assignmentMethod, true
	}
	var zero BootProtocol
	return zero, false
}

func (p *IpAddressAssignment) MustAssignmentMethod() BootProtocol {
	if p.assignmentMethod == nil {
		panic("the assignmentMethod must not be nil, please use AssignmentMethod() function instead")
	}
	return *p.assignmentMethod
}

func (p *IpAddressAssignment) SetIp(attr *Ip) {
	p.ip = attr
}

func (p *IpAddressAssignment) Ip() (*Ip, bool) {
	if p.ip != nil {
		return p.ip, true
	}
	return nil, false
}

func (p *IpAddressAssignment) MustIp() *Ip {
	if p.ip == nil {
		panic("the ip must not be nil, please use Ip() function instead")
	}
	return p.ip
}

type GuestOperatingSystem struct {
	Struct
	architecture *string
	codename     *string
	distribution *string
	family       *string
	kernel       *Kernel
	version      *Version
}

func (p *GuestOperatingSystem) SetArchitecture(attr string) {
	p.architecture = &attr
}

func (p *GuestOperatingSystem) Architecture() (string, bool) {
	if p.architecture != nil {
		return *p.architecture, true
	}
	var zero string
	return zero, false
}

func (p *GuestOperatingSystem) MustArchitecture() string {
	if p.architecture == nil {
		panic("the architecture must not be nil, please use Architecture() function instead")
	}
	return *p.architecture
}

func (p *GuestOperatingSystem) SetCodename(attr string) {
	p.codename = &attr
}

func (p *GuestOperatingSystem) Codename() (string, bool) {
	if p.codename != nil {
		return *p.codename, true
	}
	var zero string
	return zero, false
}

func (p *GuestOperatingSystem) MustCodename() string {
	if p.codename == nil {
		panic("the codename must not be nil, please use Codename() function instead")
	}
	return *p.codename
}

func (p *GuestOperatingSystem) SetDistribution(attr string) {
	p.distribution = &attr
}

func (p *GuestOperatingSystem) Distribution() (string, bool) {
	if p.distribution != nil {
		return *p.distribution, true
	}
	var zero string
	return zero, false
}

func (p *GuestOperatingSystem) MustDistribution() string {
	if p.distribution == nil {
		panic("the distribution must not be nil, please use Distribution() function instead")
	}
	return *p.distribution
}

func (p *GuestOperatingSystem) SetFamily(attr string) {
	p.family = &attr
}

func (p *GuestOperatingSystem) Family() (string, bool) {
	if p.family != nil {
		return *p.family, true
	}
	var zero string
	return zero, false
}

func (p *GuestOperatingSystem) MustFamily() string {
	if p.family == nil {
		panic("the family must not be nil, please use Family() function instead")
	}
	return *p.family
}

func (p *GuestOperatingSystem) SetKernel(attr *Kernel) {
	p.kernel = attr
}

func (p *GuestOperatingSystem) Kernel() (*Kernel, bool) {
	if p.kernel != nil {
		return p.kernel, true
	}
	return nil, false
}

func (p *GuestOperatingSystem) MustKernel() *Kernel {
	if p.kernel == nil {
		panic("the kernel must not be nil, please use Kernel() function instead")
	}
	return p.kernel
}

func (p *GuestOperatingSystem) SetVersion(attr *Version) {
	p.version = attr
}

func (p *GuestOperatingSystem) Version() (*Version, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *GuestOperatingSystem) MustVersion() *Version {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

type CpuType struct {
	Struct
	architecture *Architecture
	level        *int64
	name         *string
}

func (p *CpuType) SetArchitecture(attr Architecture) {
	p.architecture = &attr
}

func (p *CpuType) Architecture() (Architecture, bool) {
	if p.architecture != nil {
		return *p.architecture, true
	}
	var zero Architecture
	return zero, false
}

func (p *CpuType) MustArchitecture() Architecture {
	if p.architecture == nil {
		panic("the architecture must not be nil, please use Architecture() function instead")
	}
	return *p.architecture
}

func (p *CpuType) SetLevel(attr int64) {
	p.level = &attr
}

func (p *CpuType) Level() (int64, bool) {
	if p.level != nil {
		return *p.level, true
	}
	var zero int64
	return zero, false
}

func (p *CpuType) MustLevel() int64 {
	if p.level == nil {
		panic("the level must not be nil, please use Level() function instead")
	}
	return *p.level
}

func (p *CpuType) SetName(attr string) {
	p.name = &attr
}

func (p *CpuType) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *CpuType) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type SpecialObjects struct {
	Struct
	blankTemplate *Template
	rootTag       *Tag
}

func (p *SpecialObjects) SetBlankTemplate(attr *Template) {
	p.blankTemplate = attr
}

func (p *SpecialObjects) BlankTemplate() (*Template, bool) {
	if p.blankTemplate != nil {
		return p.blankTemplate, true
	}
	return nil, false
}

func (p *SpecialObjects) MustBlankTemplate() *Template {
	if p.blankTemplate == nil {
		panic("the blankTemplate must not be nil, please use BlankTemplate() function instead")
	}
	return p.blankTemplate
}

func (p *SpecialObjects) SetRootTag(attr *Tag) {
	p.rootTag = attr
}

func (p *SpecialObjects) RootTag() (*Tag, bool) {
	if p.rootTag != nil {
		return p.rootTag, true
	}
	return nil, false
}

func (p *SpecialObjects) MustRootTag() *Tag {
	if p.rootTag == nil {
		panic("the rootTag must not be nil, please use RootTag() function instead")
	}
	return p.rootTag
}

type Session struct {
	Struct
	comment     *string
	consoleUser *bool
	description *string
	id          *string
	ip          *Ip
	name        *string
	protocol    *string
	user        *User
	vm          *Vm
}

func (p *Session) SetComment(attr string) {
	p.comment = &attr
}

func (p *Session) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Session) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Session) SetConsoleUser(attr bool) {
	p.consoleUser = &attr
}

func (p *Session) ConsoleUser() (bool, bool) {
	if p.consoleUser != nil {
		return *p.consoleUser, true
	}
	var zero bool
	return zero, false
}

func (p *Session) MustConsoleUser() bool {
	if p.consoleUser == nil {
		panic("the consoleUser must not be nil, please use ConsoleUser() function instead")
	}
	return *p.consoleUser
}

func (p *Session) SetDescription(attr string) {
	p.description = &attr
}

func (p *Session) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Session) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Session) SetId(attr string) {
	p.id = &attr
}

func (p *Session) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Session) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Session) SetIp(attr *Ip) {
	p.ip = attr
}

func (p *Session) Ip() (*Ip, bool) {
	if p.ip != nil {
		return p.ip, true
	}
	return nil, false
}

func (p *Session) MustIp() *Ip {
	if p.ip == nil {
		panic("the ip must not be nil, please use Ip() function instead")
	}
	return p.ip
}

func (p *Session) SetName(attr string) {
	p.name = &attr
}

func (p *Session) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Session) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Session) SetProtocol(attr string) {
	p.protocol = &attr
}

func (p *Session) Protocol() (string, bool) {
	if p.protocol != nil {
		return *p.protocol, true
	}
	var zero string
	return zero, false
}

func (p *Session) MustProtocol() string {
	if p.protocol == nil {
		panic("the protocol must not be nil, please use Protocol() function instead")
	}
	return *p.protocol
}

func (p *Session) SetUser(attr *User) {
	p.user = attr
}

func (p *Session) User() (*User, bool) {
	if p.user != nil {
		return p.user, true
	}
	return nil, false
}

func (p *Session) MustUser() *User {
	if p.user == nil {
		panic("the user must not be nil, please use User() function instead")
	}
	return p.user
}

func (p *Session) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Session) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Session) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

type GlusterBrickAdvancedDetails struct {
	Struct
	comment        *string
	description    *string
	device         *string
	fsName         *string
	glusterClients *GlusterClientSlice
	id             *string
	instanceType   *InstanceType
	memoryPools    *GlusterMemoryPoolSlice
	mntOptions     *string
	name           *string
	pid            *int64
	port           *int64
	template       *Template
	vm             *Vm
	vms            *VmSlice
}

func (p *GlusterBrickAdvancedDetails) SetComment(attr string) {
	p.comment = &attr
}

func (p *GlusterBrickAdvancedDetails) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrickAdvancedDetails) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *GlusterBrickAdvancedDetails) SetDescription(attr string) {
	p.description = &attr
}

func (p *GlusterBrickAdvancedDetails) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrickAdvancedDetails) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *GlusterBrickAdvancedDetails) SetDevice(attr string) {
	p.device = &attr
}

func (p *GlusterBrickAdvancedDetails) Device() (string, bool) {
	if p.device != nil {
		return *p.device, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrickAdvancedDetails) MustDevice() string {
	if p.device == nil {
		panic("the device must not be nil, please use Device() function instead")
	}
	return *p.device
}

func (p *GlusterBrickAdvancedDetails) SetFsName(attr string) {
	p.fsName = &attr
}

func (p *GlusterBrickAdvancedDetails) FsName() (string, bool) {
	if p.fsName != nil {
		return *p.fsName, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrickAdvancedDetails) MustFsName() string {
	if p.fsName == nil {
		panic("the fsName must not be nil, please use FsName() function instead")
	}
	return *p.fsName
}

func (p *GlusterBrickAdvancedDetails) SetGlusterClients(attr *GlusterClientSlice) {
	p.glusterClients = attr
}

func (p *GlusterBrickAdvancedDetails) GlusterClients() (*GlusterClientSlice, bool) {
	if p.glusterClients != nil {
		return p.glusterClients, true
	}
	return nil, false
}

func (p *GlusterBrickAdvancedDetails) MustGlusterClients() *GlusterClientSlice {
	if p.glusterClients == nil {
		panic("the glusterClients must not be nil, please use GlusterClients() function instead")
	}
	return p.glusterClients
}

func (p *GlusterBrickAdvancedDetails) SetId(attr string) {
	p.id = &attr
}

func (p *GlusterBrickAdvancedDetails) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrickAdvancedDetails) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *GlusterBrickAdvancedDetails) SetInstanceType(attr *InstanceType) {
	p.instanceType = attr
}

func (p *GlusterBrickAdvancedDetails) InstanceType() (*InstanceType, bool) {
	if p.instanceType != nil {
		return p.instanceType, true
	}
	return nil, false
}

func (p *GlusterBrickAdvancedDetails) MustInstanceType() *InstanceType {
	if p.instanceType == nil {
		panic("the instanceType must not be nil, please use InstanceType() function instead")
	}
	return p.instanceType
}

func (p *GlusterBrickAdvancedDetails) SetMemoryPools(attr *GlusterMemoryPoolSlice) {
	p.memoryPools = attr
}

func (p *GlusterBrickAdvancedDetails) MemoryPools() (*GlusterMemoryPoolSlice, bool) {
	if p.memoryPools != nil {
		return p.memoryPools, true
	}
	return nil, false
}

func (p *GlusterBrickAdvancedDetails) MustMemoryPools() *GlusterMemoryPoolSlice {
	if p.memoryPools == nil {
		panic("the memoryPools must not be nil, please use MemoryPools() function instead")
	}
	return p.memoryPools
}

func (p *GlusterBrickAdvancedDetails) SetMntOptions(attr string) {
	p.mntOptions = &attr
}

func (p *GlusterBrickAdvancedDetails) MntOptions() (string, bool) {
	if p.mntOptions != nil {
		return *p.mntOptions, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrickAdvancedDetails) MustMntOptions() string {
	if p.mntOptions == nil {
		panic("the mntOptions must not be nil, please use MntOptions() function instead")
	}
	return *p.mntOptions
}

func (p *GlusterBrickAdvancedDetails) SetName(attr string) {
	p.name = &attr
}

func (p *GlusterBrickAdvancedDetails) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *GlusterBrickAdvancedDetails) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *GlusterBrickAdvancedDetails) SetPid(attr int64) {
	p.pid = &attr
}

func (p *GlusterBrickAdvancedDetails) Pid() (int64, bool) {
	if p.pid != nil {
		return *p.pid, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterBrickAdvancedDetails) MustPid() int64 {
	if p.pid == nil {
		panic("the pid must not be nil, please use Pid() function instead")
	}
	return *p.pid
}

func (p *GlusterBrickAdvancedDetails) SetPort(attr int64) {
	p.port = &attr
}

func (p *GlusterBrickAdvancedDetails) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *GlusterBrickAdvancedDetails) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *GlusterBrickAdvancedDetails) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *GlusterBrickAdvancedDetails) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *GlusterBrickAdvancedDetails) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *GlusterBrickAdvancedDetails) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *GlusterBrickAdvancedDetails) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *GlusterBrickAdvancedDetails) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *GlusterBrickAdvancedDetails) SetVms(attr *VmSlice) {
	p.vms = attr
}

func (p *GlusterBrickAdvancedDetails) Vms() (*VmSlice, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *GlusterBrickAdvancedDetails) MustVms() *VmSlice {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

type Ksm struct {
	Struct
	enabled          *bool
	mergeAcrossNodes *bool
}

func (p *Ksm) SetEnabled(attr bool) {
	p.enabled = &attr
}

func (p *Ksm) Enabled() (bool, bool) {
	if p.enabled != nil {
		return *p.enabled, true
	}
	var zero bool
	return zero, false
}

func (p *Ksm) MustEnabled() bool {
	if p.enabled == nil {
		panic("the enabled must not be nil, please use Enabled() function instead")
	}
	return *p.enabled
}

func (p *Ksm) SetMergeAcrossNodes(attr bool) {
	p.mergeAcrossNodes = &attr
}

func (p *Ksm) MergeAcrossNodes() (bool, bool) {
	if p.mergeAcrossNodes != nil {
		return *p.mergeAcrossNodes, true
	}
	var zero bool
	return zero, false
}

func (p *Ksm) MustMergeAcrossNodes() bool {
	if p.mergeAcrossNodes == nil {
		panic("the mergeAcrossNodes must not be nil, please use MergeAcrossNodes() function instead")
	}
	return *p.mergeAcrossNodes
}

type Value struct {
	Struct
	datum  *float64
	detail *string
}

func (p *Value) SetDatum(attr float64) {
	p.datum = &attr
}

func (p *Value) Datum() (float64, bool) {
	if p.datum != nil {
		return *p.datum, true
	}
	var zero float64
	return zero, false
}

func (p *Value) MustDatum() float64 {
	if p.datum == nil {
		panic("the datum must not be nil, please use Datum() function instead")
	}
	return *p.datum
}

func (p *Value) SetDetail(attr string) {
	p.detail = &attr
}

func (p *Value) Detail() (string, bool) {
	if p.detail != nil {
		return *p.detail, true
	}
	var zero string
	return zero, false
}

func (p *Value) MustDetail() string {
	if p.detail == nil {
		panic("the detail must not be nil, please use Detail() function instead")
	}
	return *p.detail
}

type CloudInit struct {
	Struct
	authorizedKeys       *AuthorizedKeySlice
	files                *FileSlice
	host                 *Host
	networkConfiguration *NetworkConfiguration
	regenerateSshKeys    *bool
	timezone             *string
	users                *UserSlice
}

func (p *CloudInit) SetAuthorizedKeys(attr *AuthorizedKeySlice) {
	p.authorizedKeys = attr
}

func (p *CloudInit) AuthorizedKeys() (*AuthorizedKeySlice, bool) {
	if p.authorizedKeys != nil {
		return p.authorizedKeys, true
	}
	return nil, false
}

func (p *CloudInit) MustAuthorizedKeys() *AuthorizedKeySlice {
	if p.authorizedKeys == nil {
		panic("the authorizedKeys must not be nil, please use AuthorizedKeys() function instead")
	}
	return p.authorizedKeys
}

func (p *CloudInit) SetFiles(attr *FileSlice) {
	p.files = attr
}

func (p *CloudInit) Files() (*FileSlice, bool) {
	if p.files != nil {
		return p.files, true
	}
	return nil, false
}

func (p *CloudInit) MustFiles() *FileSlice {
	if p.files == nil {
		panic("the files must not be nil, please use Files() function instead")
	}
	return p.files
}

func (p *CloudInit) SetHost(attr *Host) {
	p.host = attr
}

func (p *CloudInit) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *CloudInit) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *CloudInit) SetNetworkConfiguration(attr *NetworkConfiguration) {
	p.networkConfiguration = attr
}

func (p *CloudInit) NetworkConfiguration() (*NetworkConfiguration, bool) {
	if p.networkConfiguration != nil {
		return p.networkConfiguration, true
	}
	return nil, false
}

func (p *CloudInit) MustNetworkConfiguration() *NetworkConfiguration {
	if p.networkConfiguration == nil {
		panic("the networkConfiguration must not be nil, please use NetworkConfiguration() function instead")
	}
	return p.networkConfiguration
}

func (p *CloudInit) SetRegenerateSshKeys(attr bool) {
	p.regenerateSshKeys = &attr
}

func (p *CloudInit) RegenerateSshKeys() (bool, bool) {
	if p.regenerateSshKeys != nil {
		return *p.regenerateSshKeys, true
	}
	var zero bool
	return zero, false
}

func (p *CloudInit) MustRegenerateSshKeys() bool {
	if p.regenerateSshKeys == nil {
		panic("the regenerateSshKeys must not be nil, please use RegenerateSshKeys() function instead")
	}
	return *p.regenerateSshKeys
}

func (p *CloudInit) SetTimezone(attr string) {
	p.timezone = &attr
}

func (p *CloudInit) Timezone() (string, bool) {
	if p.timezone != nil {
		return *p.timezone, true
	}
	var zero string
	return zero, false
}

func (p *CloudInit) MustTimezone() string {
	if p.timezone == nil {
		panic("the timezone must not be nil, please use Timezone() function instead")
	}
	return *p.timezone
}

func (p *CloudInit) SetUsers(attr *UserSlice) {
	p.users = attr
}

func (p *CloudInit) Users() (*UserSlice, bool) {
	if p.users != nil {
		return p.users, true
	}
	return nil, false
}

func (p *CloudInit) MustUsers() *UserSlice {
	if p.users == nil {
		panic("the users must not be nil, please use Users() function instead")
	}
	return p.users
}

type Display struct {
	Struct
	address             *string
	allowOverride       *bool
	certificate         *Certificate
	copyPasteEnabled    *bool
	disconnectAction    *string
	fileTransferEnabled *bool
	keyboardLayout      *string
	monitors            *int64
	port                *int64
	proxy               *string
	securePort          *int64
	singleQxlPci        *bool
	smartcardEnabled    *bool
	type_               *DisplayType
}

func (p *Display) SetAddress(attr string) {
	p.address = &attr
}

func (p *Display) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *Display) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *Display) SetAllowOverride(attr bool) {
	p.allowOverride = &attr
}

func (p *Display) AllowOverride() (bool, bool) {
	if p.allowOverride != nil {
		return *p.allowOverride, true
	}
	var zero bool
	return zero, false
}

func (p *Display) MustAllowOverride() bool {
	if p.allowOverride == nil {
		panic("the allowOverride must not be nil, please use AllowOverride() function instead")
	}
	return *p.allowOverride
}

func (p *Display) SetCertificate(attr *Certificate) {
	p.certificate = attr
}

func (p *Display) Certificate() (*Certificate, bool) {
	if p.certificate != nil {
		return p.certificate, true
	}
	return nil, false
}

func (p *Display) MustCertificate() *Certificate {
	if p.certificate == nil {
		panic("the certificate must not be nil, please use Certificate() function instead")
	}
	return p.certificate
}

func (p *Display) SetCopyPasteEnabled(attr bool) {
	p.copyPasteEnabled = &attr
}

func (p *Display) CopyPasteEnabled() (bool, bool) {
	if p.copyPasteEnabled != nil {
		return *p.copyPasteEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Display) MustCopyPasteEnabled() bool {
	if p.copyPasteEnabled == nil {
		panic("the copyPasteEnabled must not be nil, please use CopyPasteEnabled() function instead")
	}
	return *p.copyPasteEnabled
}

func (p *Display) SetDisconnectAction(attr string) {
	p.disconnectAction = &attr
}

func (p *Display) DisconnectAction() (string, bool) {
	if p.disconnectAction != nil {
		return *p.disconnectAction, true
	}
	var zero string
	return zero, false
}

func (p *Display) MustDisconnectAction() string {
	if p.disconnectAction == nil {
		panic("the disconnectAction must not be nil, please use DisconnectAction() function instead")
	}
	return *p.disconnectAction
}

func (p *Display) SetFileTransferEnabled(attr bool) {
	p.fileTransferEnabled = &attr
}

func (p *Display) FileTransferEnabled() (bool, bool) {
	if p.fileTransferEnabled != nil {
		return *p.fileTransferEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Display) MustFileTransferEnabled() bool {
	if p.fileTransferEnabled == nil {
		panic("the fileTransferEnabled must not be nil, please use FileTransferEnabled() function instead")
	}
	return *p.fileTransferEnabled
}

func (p *Display) SetKeyboardLayout(attr string) {
	p.keyboardLayout = &attr
}

func (p *Display) KeyboardLayout() (string, bool) {
	if p.keyboardLayout != nil {
		return *p.keyboardLayout, true
	}
	var zero string
	return zero, false
}

func (p *Display) MustKeyboardLayout() string {
	if p.keyboardLayout == nil {
		panic("the keyboardLayout must not be nil, please use KeyboardLayout() function instead")
	}
	return *p.keyboardLayout
}

func (p *Display) SetMonitors(attr int64) {
	p.monitors = &attr
}

func (p *Display) Monitors() (int64, bool) {
	if p.monitors != nil {
		return *p.monitors, true
	}
	var zero int64
	return zero, false
}

func (p *Display) MustMonitors() int64 {
	if p.monitors == nil {
		panic("the monitors must not be nil, please use Monitors() function instead")
	}
	return *p.monitors
}

func (p *Display) SetPort(attr int64) {
	p.port = &attr
}

func (p *Display) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *Display) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *Display) SetProxy(attr string) {
	p.proxy = &attr
}

func (p *Display) Proxy() (string, bool) {
	if p.proxy != nil {
		return *p.proxy, true
	}
	var zero string
	return zero, false
}

func (p *Display) MustProxy() string {
	if p.proxy == nil {
		panic("the proxy must not be nil, please use Proxy() function instead")
	}
	return *p.proxy
}

func (p *Display) SetSecurePort(attr int64) {
	p.securePort = &attr
}

func (p *Display) SecurePort() (int64, bool) {
	if p.securePort != nil {
		return *p.securePort, true
	}
	var zero int64
	return zero, false
}

func (p *Display) MustSecurePort() int64 {
	if p.securePort == nil {
		panic("the securePort must not be nil, please use SecurePort() function instead")
	}
	return *p.securePort
}

func (p *Display) SetSingleQxlPci(attr bool) {
	p.singleQxlPci = &attr
}

func (p *Display) SingleQxlPci() (bool, bool) {
	if p.singleQxlPci != nil {
		return *p.singleQxlPci, true
	}
	var zero bool
	return zero, false
}

func (p *Display) MustSingleQxlPci() bool {
	if p.singleQxlPci == nil {
		panic("the singleQxlPci must not be nil, please use SingleQxlPci() function instead")
	}
	return *p.singleQxlPci
}

func (p *Display) SetSmartcardEnabled(attr bool) {
	p.smartcardEnabled = &attr
}

func (p *Display) SmartcardEnabled() (bool, bool) {
	if p.smartcardEnabled != nil {
		return *p.smartcardEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Display) MustSmartcardEnabled() bool {
	if p.smartcardEnabled == nil {
		panic("the smartcardEnabled must not be nil, please use SmartcardEnabled() function instead")
	}
	return *p.smartcardEnabled
}

func (p *Display) SetType(attr DisplayType) {
	p.type_ = &attr
}

func (p *Display) Type() (DisplayType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero DisplayType
	return zero, false
}

func (p *Display) MustType() DisplayType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type StorageDomainLease struct {
	Struct
	storageDomain *StorageDomain
}

func (p *StorageDomainLease) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *StorageDomainLease) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *StorageDomainLease) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

type MigrationPolicy struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
}

func (p *MigrationPolicy) SetComment(attr string) {
	p.comment = &attr
}

func (p *MigrationPolicy) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *MigrationPolicy) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *MigrationPolicy) SetDescription(attr string) {
	p.description = &attr
}

func (p *MigrationPolicy) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *MigrationPolicy) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *MigrationPolicy) SetId(attr string) {
	p.id = &attr
}

func (p *MigrationPolicy) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *MigrationPolicy) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *MigrationPolicy) SetName(attr string) {
	p.name = &attr
}

func (p *MigrationPolicy) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *MigrationPolicy) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

type Host struct {
	Struct
	address                               *string
	affinityLabels                        *AffinityLabelSlice
	agents                                *AgentSlice
	autoNumaStatus                        *AutoNumaStatus
	certificate                           *Certificate
	cluster                               *Cluster
	comment                               *string
	cpu                                   *Cpu
	description                           *string
	devicePassthrough                     *HostDevicePassthrough
	devices                               *HostDeviceSlice
	display                               *Display
	externalHostProvider                  *ExternalHostProvider
	externalNetworkProviderConfigurations *ExternalNetworkProviderConfigurationSlice
	externalStatus                        *ExternalStatus
	hardwareInformation                   *HardwareInformation
	hooks                                 *HookSlice
	hostedEngine                          *HostedEngine
	id                                    *string
	iscsi                                 *IscsiDetails
	katelloErrata                         *KatelloErratumSlice
	kdumpStatus                           *KdumpStatus
	ksm                                   *Ksm
	libvirtVersion                        *Version
	maxSchedulingMemory                   *int64
	memory                                *int64
	name                                  *string
	networkAttachments                    *NetworkAttachmentSlice
	networkOperationInProgress            *bool
	nics                                  *HostNicSlice
	numaNodes                             *NumaNodeSlice
	numaSupported                         *bool
	os                                    *OperatingSystem
	overrideIptables                      *bool
	permissions                           *PermissionSlice
	port                                  *int64
	powerManagement                       *PowerManagement
	protocol                              *HostProtocol
	reinstallationRequired                *bool
	rootPassword                          *string
	seLinux                               *SeLinux
	spm                                   *Spm
	ssh                                   *Ssh
	statistics                            *StatisticSlice
	status                                *HostStatus
	statusDetail                          *string
	storageConnectionExtensions           *StorageConnectionExtensionSlice
	storages                              *HostStorageSlice
	summary                               *VmSummary
	tags                                  *TagSlice
	transparentHugePages                  *TransparentHugePages
	type_                                 *HostType
	unmanagedNetworks                     *UnmanagedNetworkSlice
	updateAvailable                       *bool
	version                               *Version
	vgpuPlacement                         *VgpuPlacement
}

func (p *Host) SetAddress(attr string) {
	p.address = &attr
}

func (p *Host) Address() (string, bool) {
	if p.address != nil {
		return *p.address, true
	}
	var zero string
	return zero, false
}

func (p *Host) MustAddress() string {
	if p.address == nil {
		panic("the address must not be nil, please use Address() function instead")
	}
	return *p.address
}

func (p *Host) SetAffinityLabels(attr *AffinityLabelSlice) {
	p.affinityLabels = attr
}

func (p *Host) AffinityLabels() (*AffinityLabelSlice, bool) {
	if p.affinityLabels != nil {
		return p.affinityLabels, true
	}
	return nil, false
}

func (p *Host) MustAffinityLabels() *AffinityLabelSlice {
	if p.affinityLabels == nil {
		panic("the affinityLabels must not be nil, please use AffinityLabels() function instead")
	}
	return p.affinityLabels
}

func (p *Host) SetAgents(attr *AgentSlice) {
	p.agents = attr
}

func (p *Host) Agents() (*AgentSlice, bool) {
	if p.agents != nil {
		return p.agents, true
	}
	return nil, false
}

func (p *Host) MustAgents() *AgentSlice {
	if p.agents == nil {
		panic("the agents must not be nil, please use Agents() function instead")
	}
	return p.agents
}

func (p *Host) SetAutoNumaStatus(attr AutoNumaStatus) {
	p.autoNumaStatus = &attr
}

func (p *Host) AutoNumaStatus() (AutoNumaStatus, bool) {
	if p.autoNumaStatus != nil {
		return *p.autoNumaStatus, true
	}
	var zero AutoNumaStatus
	return zero, false
}

func (p *Host) MustAutoNumaStatus() AutoNumaStatus {
	if p.autoNumaStatus == nil {
		panic("the autoNumaStatus must not be nil, please use AutoNumaStatus() function instead")
	}
	return *p.autoNumaStatus
}

func (p *Host) SetCertificate(attr *Certificate) {
	p.certificate = attr
}

func (p *Host) Certificate() (*Certificate, bool) {
	if p.certificate != nil {
		return p.certificate, true
	}
	return nil, false
}

func (p *Host) MustCertificate() *Certificate {
	if p.certificate == nil {
		panic("the certificate must not be nil, please use Certificate() function instead")
	}
	return p.certificate
}

func (p *Host) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *Host) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *Host) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *Host) SetComment(attr string) {
	p.comment = &attr
}

func (p *Host) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Host) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Host) SetCpu(attr *Cpu) {
	p.cpu = attr
}

func (p *Host) Cpu() (*Cpu, bool) {
	if p.cpu != nil {
		return p.cpu, true
	}
	return nil, false
}

func (p *Host) MustCpu() *Cpu {
	if p.cpu == nil {
		panic("the cpu must not be nil, please use Cpu() function instead")
	}
	return p.cpu
}

func (p *Host) SetDescription(attr string) {
	p.description = &attr
}

func (p *Host) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Host) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Host) SetDevicePassthrough(attr *HostDevicePassthrough) {
	p.devicePassthrough = attr
}

func (p *Host) DevicePassthrough() (*HostDevicePassthrough, bool) {
	if p.devicePassthrough != nil {
		return p.devicePassthrough, true
	}
	return nil, false
}

func (p *Host) MustDevicePassthrough() *HostDevicePassthrough {
	if p.devicePassthrough == nil {
		panic("the devicePassthrough must not be nil, please use DevicePassthrough() function instead")
	}
	return p.devicePassthrough
}

func (p *Host) SetDevices(attr *HostDeviceSlice) {
	p.devices = attr
}

func (p *Host) Devices() (*HostDeviceSlice, bool) {
	if p.devices != nil {
		return p.devices, true
	}
	return nil, false
}

func (p *Host) MustDevices() *HostDeviceSlice {
	if p.devices == nil {
		panic("the devices must not be nil, please use Devices() function instead")
	}
	return p.devices
}

func (p *Host) SetDisplay(attr *Display) {
	p.display = attr
}

func (p *Host) Display() (*Display, bool) {
	if p.display != nil {
		return p.display, true
	}
	return nil, false
}

func (p *Host) MustDisplay() *Display {
	if p.display == nil {
		panic("the display must not be nil, please use Display() function instead")
	}
	return p.display
}

func (p *Host) SetExternalHostProvider(attr *ExternalHostProvider) {
	p.externalHostProvider = attr
}

func (p *Host) ExternalHostProvider() (*ExternalHostProvider, bool) {
	if p.externalHostProvider != nil {
		return p.externalHostProvider, true
	}
	return nil, false
}

func (p *Host) MustExternalHostProvider() *ExternalHostProvider {
	if p.externalHostProvider == nil {
		panic("the externalHostProvider must not be nil, please use ExternalHostProvider() function instead")
	}
	return p.externalHostProvider
}

func (p *Host) SetExternalNetworkProviderConfigurations(attr *ExternalNetworkProviderConfigurationSlice) {
	p.externalNetworkProviderConfigurations = attr
}

func (p *Host) ExternalNetworkProviderConfigurations() (*ExternalNetworkProviderConfigurationSlice, bool) {
	if p.externalNetworkProviderConfigurations != nil {
		return p.externalNetworkProviderConfigurations, true
	}
	return nil, false
}

func (p *Host) MustExternalNetworkProviderConfigurations() *ExternalNetworkProviderConfigurationSlice {
	if p.externalNetworkProviderConfigurations == nil {
		panic("the externalNetworkProviderConfigurations must not be nil, please use ExternalNetworkProviderConfigurations() function instead")
	}
	return p.externalNetworkProviderConfigurations
}

func (p *Host) SetExternalStatus(attr ExternalStatus) {
	p.externalStatus = &attr
}

func (p *Host) ExternalStatus() (ExternalStatus, bool) {
	if p.externalStatus != nil {
		return *p.externalStatus, true
	}
	var zero ExternalStatus
	return zero, false
}

func (p *Host) MustExternalStatus() ExternalStatus {
	if p.externalStatus == nil {
		panic("the externalStatus must not be nil, please use ExternalStatus() function instead")
	}
	return *p.externalStatus
}

func (p *Host) SetHardwareInformation(attr *HardwareInformation) {
	p.hardwareInformation = attr
}

func (p *Host) HardwareInformation() (*HardwareInformation, bool) {
	if p.hardwareInformation != nil {
		return p.hardwareInformation, true
	}
	return nil, false
}

func (p *Host) MustHardwareInformation() *HardwareInformation {
	if p.hardwareInformation == nil {
		panic("the hardwareInformation must not be nil, please use HardwareInformation() function instead")
	}
	return p.hardwareInformation
}

func (p *Host) SetHooks(attr *HookSlice) {
	p.hooks = attr
}

func (p *Host) Hooks() (*HookSlice, bool) {
	if p.hooks != nil {
		return p.hooks, true
	}
	return nil, false
}

func (p *Host) MustHooks() *HookSlice {
	if p.hooks == nil {
		panic("the hooks must not be nil, please use Hooks() function instead")
	}
	return p.hooks
}

func (p *Host) SetHostedEngine(attr *HostedEngine) {
	p.hostedEngine = attr
}

func (p *Host) HostedEngine() (*HostedEngine, bool) {
	if p.hostedEngine != nil {
		return p.hostedEngine, true
	}
	return nil, false
}

func (p *Host) MustHostedEngine() *HostedEngine {
	if p.hostedEngine == nil {
		panic("the hostedEngine must not be nil, please use HostedEngine() function instead")
	}
	return p.hostedEngine
}

func (p *Host) SetId(attr string) {
	p.id = &attr
}

func (p *Host) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Host) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Host) SetIscsi(attr *IscsiDetails) {
	p.iscsi = attr
}

func (p *Host) Iscsi() (*IscsiDetails, bool) {
	if p.iscsi != nil {
		return p.iscsi, true
	}
	return nil, false
}

func (p *Host) MustIscsi() *IscsiDetails {
	if p.iscsi == nil {
		panic("the iscsi must not be nil, please use Iscsi() function instead")
	}
	return p.iscsi
}

func (p *Host) SetKatelloErrata(attr *KatelloErratumSlice) {
	p.katelloErrata = attr
}

func (p *Host) KatelloErrata() (*KatelloErratumSlice, bool) {
	if p.katelloErrata != nil {
		return p.katelloErrata, true
	}
	return nil, false
}

func (p *Host) MustKatelloErrata() *KatelloErratumSlice {
	if p.katelloErrata == nil {
		panic("the katelloErrata must not be nil, please use KatelloErrata() function instead")
	}
	return p.katelloErrata
}

func (p *Host) SetKdumpStatus(attr KdumpStatus) {
	p.kdumpStatus = &attr
}

func (p *Host) KdumpStatus() (KdumpStatus, bool) {
	if p.kdumpStatus != nil {
		return *p.kdumpStatus, true
	}
	var zero KdumpStatus
	return zero, false
}

func (p *Host) MustKdumpStatus() KdumpStatus {
	if p.kdumpStatus == nil {
		panic("the kdumpStatus must not be nil, please use KdumpStatus() function instead")
	}
	return *p.kdumpStatus
}

func (p *Host) SetKsm(attr *Ksm) {
	p.ksm = attr
}

func (p *Host) Ksm() (*Ksm, bool) {
	if p.ksm != nil {
		return p.ksm, true
	}
	return nil, false
}

func (p *Host) MustKsm() *Ksm {
	if p.ksm == nil {
		panic("the ksm must not be nil, please use Ksm() function instead")
	}
	return p.ksm
}

func (p *Host) SetLibvirtVersion(attr *Version) {
	p.libvirtVersion = attr
}

func (p *Host) LibvirtVersion() (*Version, bool) {
	if p.libvirtVersion != nil {
		return p.libvirtVersion, true
	}
	return nil, false
}

func (p *Host) MustLibvirtVersion() *Version {
	if p.libvirtVersion == nil {
		panic("the libvirtVersion must not be nil, please use LibvirtVersion() function instead")
	}
	return p.libvirtVersion
}

func (p *Host) SetMaxSchedulingMemory(attr int64) {
	p.maxSchedulingMemory = &attr
}

func (p *Host) MaxSchedulingMemory() (int64, bool) {
	if p.maxSchedulingMemory != nil {
		return *p.maxSchedulingMemory, true
	}
	var zero int64
	return zero, false
}

func (p *Host) MustMaxSchedulingMemory() int64 {
	if p.maxSchedulingMemory == nil {
		panic("the maxSchedulingMemory must not be nil, please use MaxSchedulingMemory() function instead")
	}
	return *p.maxSchedulingMemory
}

func (p *Host) SetMemory(attr int64) {
	p.memory = &attr
}

func (p *Host) Memory() (int64, bool) {
	if p.memory != nil {
		return *p.memory, true
	}
	var zero int64
	return zero, false
}

func (p *Host) MustMemory() int64 {
	if p.memory == nil {
		panic("the memory must not be nil, please use Memory() function instead")
	}
	return *p.memory
}

func (p *Host) SetName(attr string) {
	p.name = &attr
}

func (p *Host) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Host) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Host) SetNetworkAttachments(attr *NetworkAttachmentSlice) {
	p.networkAttachments = attr
}

func (p *Host) NetworkAttachments() (*NetworkAttachmentSlice, bool) {
	if p.networkAttachments != nil {
		return p.networkAttachments, true
	}
	return nil, false
}

func (p *Host) MustNetworkAttachments() *NetworkAttachmentSlice {
	if p.networkAttachments == nil {
		panic("the networkAttachments must not be nil, please use NetworkAttachments() function instead")
	}
	return p.networkAttachments
}

func (p *Host) SetNetworkOperationInProgress(attr bool) {
	p.networkOperationInProgress = &attr
}

func (p *Host) NetworkOperationInProgress() (bool, bool) {
	if p.networkOperationInProgress != nil {
		return *p.networkOperationInProgress, true
	}
	var zero bool
	return zero, false
}

func (p *Host) MustNetworkOperationInProgress() bool {
	if p.networkOperationInProgress == nil {
		panic("the networkOperationInProgress must not be nil, please use NetworkOperationInProgress() function instead")
	}
	return *p.networkOperationInProgress
}

func (p *Host) SetNics(attr *HostNicSlice) {
	p.nics = attr
}

func (p *Host) Nics() (*HostNicSlice, bool) {
	if p.nics != nil {
		return p.nics, true
	}
	return nil, false
}

func (p *Host) MustNics() *HostNicSlice {
	if p.nics == nil {
		panic("the nics must not be nil, please use Nics() function instead")
	}
	return p.nics
}

func (p *Host) SetNumaNodes(attr *NumaNodeSlice) {
	p.numaNodes = attr
}

func (p *Host) NumaNodes() (*NumaNodeSlice, bool) {
	if p.numaNodes != nil {
		return p.numaNodes, true
	}
	return nil, false
}

func (p *Host) MustNumaNodes() *NumaNodeSlice {
	if p.numaNodes == nil {
		panic("the numaNodes must not be nil, please use NumaNodes() function instead")
	}
	return p.numaNodes
}

func (p *Host) SetNumaSupported(attr bool) {
	p.numaSupported = &attr
}

func (p *Host) NumaSupported() (bool, bool) {
	if p.numaSupported != nil {
		return *p.numaSupported, true
	}
	var zero bool
	return zero, false
}

func (p *Host) MustNumaSupported() bool {
	if p.numaSupported == nil {
		panic("the numaSupported must not be nil, please use NumaSupported() function instead")
	}
	return *p.numaSupported
}

func (p *Host) SetOs(attr *OperatingSystem) {
	p.os = attr
}

func (p *Host) Os() (*OperatingSystem, bool) {
	if p.os != nil {
		return p.os, true
	}
	return nil, false
}

func (p *Host) MustOs() *OperatingSystem {
	if p.os == nil {
		panic("the os must not be nil, please use Os() function instead")
	}
	return p.os
}

func (p *Host) SetOverrideIptables(attr bool) {
	p.overrideIptables = &attr
}

func (p *Host) OverrideIptables() (bool, bool) {
	if p.overrideIptables != nil {
		return *p.overrideIptables, true
	}
	var zero bool
	return zero, false
}

func (p *Host) MustOverrideIptables() bool {
	if p.overrideIptables == nil {
		panic("the overrideIptables must not be nil, please use OverrideIptables() function instead")
	}
	return *p.overrideIptables
}

func (p *Host) SetPermissions(attr *PermissionSlice) {
	p.permissions = attr
}

func (p *Host) Permissions() (*PermissionSlice, bool) {
	if p.permissions != nil {
		return p.permissions, true
	}
	return nil, false
}

func (p *Host) MustPermissions() *PermissionSlice {
	if p.permissions == nil {
		panic("the permissions must not be nil, please use Permissions() function instead")
	}
	return p.permissions
}

func (p *Host) SetPort(attr int64) {
	p.port = &attr
}

func (p *Host) Port() (int64, bool) {
	if p.port != nil {
		return *p.port, true
	}
	var zero int64
	return zero, false
}

func (p *Host) MustPort() int64 {
	if p.port == nil {
		panic("the port must not be nil, please use Port() function instead")
	}
	return *p.port
}

func (p *Host) SetPowerManagement(attr *PowerManagement) {
	p.powerManagement = attr
}

func (p *Host) PowerManagement() (*PowerManagement, bool) {
	if p.powerManagement != nil {
		return p.powerManagement, true
	}
	return nil, false
}

func (p *Host) MustPowerManagement() *PowerManagement {
	if p.powerManagement == nil {
		panic("the powerManagement must not be nil, please use PowerManagement() function instead")
	}
	return p.powerManagement
}

func (p *Host) SetProtocol(attr HostProtocol) {
	p.protocol = &attr
}

func (p *Host) Protocol() (HostProtocol, bool) {
	if p.protocol != nil {
		return *p.protocol, true
	}
	var zero HostProtocol
	return zero, false
}

func (p *Host) MustProtocol() HostProtocol {
	if p.protocol == nil {
		panic("the protocol must not be nil, please use Protocol() function instead")
	}
	return *p.protocol
}

func (p *Host) SetReinstallationRequired(attr bool) {
	p.reinstallationRequired = &attr
}

func (p *Host) ReinstallationRequired() (bool, bool) {
	if p.reinstallationRequired != nil {
		return *p.reinstallationRequired, true
	}
	var zero bool
	return zero, false
}

func (p *Host) MustReinstallationRequired() bool {
	if p.reinstallationRequired == nil {
		panic("the reinstallationRequired must not be nil, please use ReinstallationRequired() function instead")
	}
	return *p.reinstallationRequired
}

func (p *Host) SetRootPassword(attr string) {
	p.rootPassword = &attr
}

func (p *Host) RootPassword() (string, bool) {
	if p.rootPassword != nil {
		return *p.rootPassword, true
	}
	var zero string
	return zero, false
}

func (p *Host) MustRootPassword() string {
	if p.rootPassword == nil {
		panic("the rootPassword must not be nil, please use RootPassword() function instead")
	}
	return *p.rootPassword
}

func (p *Host) SetSeLinux(attr *SeLinux) {
	p.seLinux = attr
}

func (p *Host) SeLinux() (*SeLinux, bool) {
	if p.seLinux != nil {
		return p.seLinux, true
	}
	return nil, false
}

func (p *Host) MustSeLinux() *SeLinux {
	if p.seLinux == nil {
		panic("the seLinux must not be nil, please use SeLinux() function instead")
	}
	return p.seLinux
}

func (p *Host) SetSpm(attr *Spm) {
	p.spm = attr
}

func (p *Host) Spm() (*Spm, bool) {
	if p.spm != nil {
		return p.spm, true
	}
	return nil, false
}

func (p *Host) MustSpm() *Spm {
	if p.spm == nil {
		panic("the spm must not be nil, please use Spm() function instead")
	}
	return p.spm
}

func (p *Host) SetSsh(attr *Ssh) {
	p.ssh = attr
}

func (p *Host) Ssh() (*Ssh, bool) {
	if p.ssh != nil {
		return p.ssh, true
	}
	return nil, false
}

func (p *Host) MustSsh() *Ssh {
	if p.ssh == nil {
		panic("the ssh must not be nil, please use Ssh() function instead")
	}
	return p.ssh
}

func (p *Host) SetStatistics(attr *StatisticSlice) {
	p.statistics = attr
}

func (p *Host) Statistics() (*StatisticSlice, bool) {
	if p.statistics != nil {
		return p.statistics, true
	}
	return nil, false
}

func (p *Host) MustStatistics() *StatisticSlice {
	if p.statistics == nil {
		panic("the statistics must not be nil, please use Statistics() function instead")
	}
	return p.statistics
}

func (p *Host) SetStatus(attr HostStatus) {
	p.status = &attr
}

func (p *Host) Status() (HostStatus, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero HostStatus
	return zero, false
}

func (p *Host) MustStatus() HostStatus {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *Host) SetStatusDetail(attr string) {
	p.statusDetail = &attr
}

func (p *Host) StatusDetail() (string, bool) {
	if p.statusDetail != nil {
		return *p.statusDetail, true
	}
	var zero string
	return zero, false
}

func (p *Host) MustStatusDetail() string {
	if p.statusDetail == nil {
		panic("the statusDetail must not be nil, please use StatusDetail() function instead")
	}
	return *p.statusDetail
}

func (p *Host) SetStorageConnectionExtensions(attr *StorageConnectionExtensionSlice) {
	p.storageConnectionExtensions = attr
}

func (p *Host) StorageConnectionExtensions() (*StorageConnectionExtensionSlice, bool) {
	if p.storageConnectionExtensions != nil {
		return p.storageConnectionExtensions, true
	}
	return nil, false
}

func (p *Host) MustStorageConnectionExtensions() *StorageConnectionExtensionSlice {
	if p.storageConnectionExtensions == nil {
		panic("the storageConnectionExtensions must not be nil, please use StorageConnectionExtensions() function instead")
	}
	return p.storageConnectionExtensions
}

func (p *Host) SetStorages(attr *HostStorageSlice) {
	p.storages = attr
}

func (p *Host) Storages() (*HostStorageSlice, bool) {
	if p.storages != nil {
		return p.storages, true
	}
	return nil, false
}

func (p *Host) MustStorages() *HostStorageSlice {
	if p.storages == nil {
		panic("the storages must not be nil, please use Storages() function instead")
	}
	return p.storages
}

func (p *Host) SetSummary(attr *VmSummary) {
	p.summary = attr
}

func (p *Host) Summary() (*VmSummary, bool) {
	if p.summary != nil {
		return p.summary, true
	}
	return nil, false
}

func (p *Host) MustSummary() *VmSummary {
	if p.summary == nil {
		panic("the summary must not be nil, please use Summary() function instead")
	}
	return p.summary
}

func (p *Host) SetTags(attr *TagSlice) {
	p.tags = attr
}

func (p *Host) Tags() (*TagSlice, bool) {
	if p.tags != nil {
		return p.tags, true
	}
	return nil, false
}

func (p *Host) MustTags() *TagSlice {
	if p.tags == nil {
		panic("the tags must not be nil, please use Tags() function instead")
	}
	return p.tags
}

func (p *Host) SetTransparentHugePages(attr *TransparentHugePages) {
	p.transparentHugePages = attr
}

func (p *Host) TransparentHugePages() (*TransparentHugePages, bool) {
	if p.transparentHugePages != nil {
		return p.transparentHugePages, true
	}
	return nil, false
}

func (p *Host) MustTransparentHugePages() *TransparentHugePages {
	if p.transparentHugePages == nil {
		panic("the transparentHugePages must not be nil, please use TransparentHugePages() function instead")
	}
	return p.transparentHugePages
}

func (p *Host) SetType(attr HostType) {
	p.type_ = &attr
}

func (p *Host) Type() (HostType, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero HostType
	return zero, false
}

func (p *Host) MustType() HostType {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

func (p *Host) SetUnmanagedNetworks(attr *UnmanagedNetworkSlice) {
	p.unmanagedNetworks = attr
}

func (p *Host) UnmanagedNetworks() (*UnmanagedNetworkSlice, bool) {
	if p.unmanagedNetworks != nil {
		return p.unmanagedNetworks, true
	}
	return nil, false
}

func (p *Host) MustUnmanagedNetworks() *UnmanagedNetworkSlice {
	if p.unmanagedNetworks == nil {
		panic("the unmanagedNetworks must not be nil, please use UnmanagedNetworks() function instead")
	}
	return p.unmanagedNetworks
}

func (p *Host) SetUpdateAvailable(attr bool) {
	p.updateAvailable = &attr
}

func (p *Host) UpdateAvailable() (bool, bool) {
	if p.updateAvailable != nil {
		return *p.updateAvailable, true
	}
	var zero bool
	return zero, false
}

func (p *Host) MustUpdateAvailable() bool {
	if p.updateAvailable == nil {
		panic("the updateAvailable must not be nil, please use UpdateAvailable() function instead")
	}
	return *p.updateAvailable
}

func (p *Host) SetVersion(attr *Version) {
	p.version = attr
}

func (p *Host) Version() (*Version, bool) {
	if p.version != nil {
		return p.version, true
	}
	return nil, false
}

func (p *Host) MustVersion() *Version {
	if p.version == nil {
		panic("the version must not be nil, please use Version() function instead")
	}
	return p.version
}

func (p *Host) SetVgpuPlacement(attr VgpuPlacement) {
	p.vgpuPlacement = &attr
}

func (p *Host) VgpuPlacement() (VgpuPlacement, bool) {
	if p.vgpuPlacement != nil {
		return *p.vgpuPlacement, true
	}
	var zero VgpuPlacement
	return zero, false
}

func (p *Host) MustVgpuPlacement() VgpuPlacement {
	if p.vgpuPlacement == nil {
		panic("the vgpuPlacement must not be nil, please use VgpuPlacement() function instead")
	}
	return *p.vgpuPlacement
}

type NetworkAttachment struct {
	Struct
	comment                  *string
	description              *string
	dnsResolverConfiguration *DnsResolverConfiguration
	host                     *Host
	hostNic                  *HostNic
	id                       *string
	inSync                   *bool
	ipAddressAssignments     *IpAddressAssignmentSlice
	name                     *string
	network                  *Network
	properties               *PropertySlice
	qos                      *Qos
	reportedConfigurations   *ReportedConfigurationSlice
}

func (p *NetworkAttachment) SetComment(attr string) {
	p.comment = &attr
}

func (p *NetworkAttachment) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *NetworkAttachment) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *NetworkAttachment) SetDescription(attr string) {
	p.description = &attr
}

func (p *NetworkAttachment) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *NetworkAttachment) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *NetworkAttachment) SetDnsResolverConfiguration(attr *DnsResolverConfiguration) {
	p.dnsResolverConfiguration = attr
}

func (p *NetworkAttachment) DnsResolverConfiguration() (*DnsResolverConfiguration, bool) {
	if p.dnsResolverConfiguration != nil {
		return p.dnsResolverConfiguration, true
	}
	return nil, false
}

func (p *NetworkAttachment) MustDnsResolverConfiguration() *DnsResolverConfiguration {
	if p.dnsResolverConfiguration == nil {
		panic("the dnsResolverConfiguration must not be nil, please use DnsResolverConfiguration() function instead")
	}
	return p.dnsResolverConfiguration
}

func (p *NetworkAttachment) SetHost(attr *Host) {
	p.host = attr
}

func (p *NetworkAttachment) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *NetworkAttachment) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *NetworkAttachment) SetHostNic(attr *HostNic) {
	p.hostNic = attr
}

func (p *NetworkAttachment) HostNic() (*HostNic, bool) {
	if p.hostNic != nil {
		return p.hostNic, true
	}
	return nil, false
}

func (p *NetworkAttachment) MustHostNic() *HostNic {
	if p.hostNic == nil {
		panic("the hostNic must not be nil, please use HostNic() function instead")
	}
	return p.hostNic
}

func (p *NetworkAttachment) SetId(attr string) {
	p.id = &attr
}

func (p *NetworkAttachment) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *NetworkAttachment) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *NetworkAttachment) SetInSync(attr bool) {
	p.inSync = &attr
}

func (p *NetworkAttachment) InSync() (bool, bool) {
	if p.inSync != nil {
		return *p.inSync, true
	}
	var zero bool
	return zero, false
}

func (p *NetworkAttachment) MustInSync() bool {
	if p.inSync == nil {
		panic("the inSync must not be nil, please use InSync() function instead")
	}
	return *p.inSync
}

func (p *NetworkAttachment) SetIpAddressAssignments(attr *IpAddressAssignmentSlice) {
	p.ipAddressAssignments = attr
}

func (p *NetworkAttachment) IpAddressAssignments() (*IpAddressAssignmentSlice, bool) {
	if p.ipAddressAssignments != nil {
		return p.ipAddressAssignments, true
	}
	return nil, false
}

func (p *NetworkAttachment) MustIpAddressAssignments() *IpAddressAssignmentSlice {
	if p.ipAddressAssignments == nil {
		panic("the ipAddressAssignments must not be nil, please use IpAddressAssignments() function instead")
	}
	return p.ipAddressAssignments
}

func (p *NetworkAttachment) SetName(attr string) {
	p.name = &attr
}

func (p *NetworkAttachment) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *NetworkAttachment) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *NetworkAttachment) SetNetwork(attr *Network) {
	p.network = attr
}

func (p *NetworkAttachment) Network() (*Network, bool) {
	if p.network != nil {
		return p.network, true
	}
	return nil, false
}

func (p *NetworkAttachment) MustNetwork() *Network {
	if p.network == nil {
		panic("the network must not be nil, please use Network() function instead")
	}
	return p.network
}

func (p *NetworkAttachment) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *NetworkAttachment) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *NetworkAttachment) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *NetworkAttachment) SetQos(attr *Qos) {
	p.qos = attr
}

func (p *NetworkAttachment) Qos() (*Qos, bool) {
	if p.qos != nil {
		return p.qos, true
	}
	return nil, false
}

func (p *NetworkAttachment) MustQos() *Qos {
	if p.qos == nil {
		panic("the qos must not be nil, please use Qos() function instead")
	}
	return p.qos
}

func (p *NetworkAttachment) SetReportedConfigurations(attr *ReportedConfigurationSlice) {
	p.reportedConfigurations = attr
}

func (p *NetworkAttachment) ReportedConfigurations() (*ReportedConfigurationSlice, bool) {
	if p.reportedConfigurations != nil {
		return p.reportedConfigurations, true
	}
	return nil, false
}

func (p *NetworkAttachment) MustReportedConfigurations() *ReportedConfigurationSlice {
	if p.reportedConfigurations == nil {
		panic("the reportedConfigurations must not be nil, please use ReportedConfigurations() function instead")
	}
	return p.reportedConfigurations
}

type Filter struct {
	Struct
	comment              *string
	description          *string
	id                   *string
	name                 *string
	position             *int64
	schedulingPolicyUnit *SchedulingPolicyUnit
}

func (p *Filter) SetComment(attr string) {
	p.comment = &attr
}

func (p *Filter) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Filter) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Filter) SetDescription(attr string) {
	p.description = &attr
}

func (p *Filter) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Filter) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Filter) SetId(attr string) {
	p.id = &attr
}

func (p *Filter) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Filter) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Filter) SetName(attr string) {
	p.name = &attr
}

func (p *Filter) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Filter) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Filter) SetPosition(attr int64) {
	p.position = &attr
}

func (p *Filter) Position() (int64, bool) {
	if p.position != nil {
		return *p.position, true
	}
	var zero int64
	return zero, false
}

func (p *Filter) MustPosition() int64 {
	if p.position == nil {
		panic("the position must not be nil, please use Position() function instead")
	}
	return *p.position
}

func (p *Filter) SetSchedulingPolicyUnit(attr *SchedulingPolicyUnit) {
	p.schedulingPolicyUnit = attr
}

func (p *Filter) SchedulingPolicyUnit() (*SchedulingPolicyUnit, bool) {
	if p.schedulingPolicyUnit != nil {
		return p.schedulingPolicyUnit, true
	}
	return nil, false
}

func (p *Filter) MustSchedulingPolicyUnit() *SchedulingPolicyUnit {
	if p.schedulingPolicyUnit == nil {
		panic("the schedulingPolicyUnit must not be nil, please use SchedulingPolicyUnit() function instead")
	}
	return p.schedulingPolicyUnit
}

type IscsiBond struct {
	Struct
	comment            *string
	dataCenter         *DataCenter
	description        *string
	id                 *string
	name               *string
	networks           *NetworkSlice
	storageConnections *StorageConnectionSlice
}

func (p *IscsiBond) SetComment(attr string) {
	p.comment = &attr
}

func (p *IscsiBond) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *IscsiBond) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *IscsiBond) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *IscsiBond) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *IscsiBond) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *IscsiBond) SetDescription(attr string) {
	p.description = &attr
}

func (p *IscsiBond) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *IscsiBond) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *IscsiBond) SetId(attr string) {
	p.id = &attr
}

func (p *IscsiBond) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *IscsiBond) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *IscsiBond) SetName(attr string) {
	p.name = &attr
}

func (p *IscsiBond) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *IscsiBond) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *IscsiBond) SetNetworks(attr *NetworkSlice) {
	p.networks = attr
}

func (p *IscsiBond) Networks() (*NetworkSlice, bool) {
	if p.networks != nil {
		return p.networks, true
	}
	return nil, false
}

func (p *IscsiBond) MustNetworks() *NetworkSlice {
	if p.networks == nil {
		panic("the networks must not be nil, please use Networks() function instead")
	}
	return p.networks
}

func (p *IscsiBond) SetStorageConnections(attr *StorageConnectionSlice) {
	p.storageConnections = attr
}

func (p *IscsiBond) StorageConnections() (*StorageConnectionSlice, bool) {
	if p.storageConnections != nil {
		return p.storageConnections, true
	}
	return nil, false
}

func (p *IscsiBond) MustStorageConnections() *StorageConnectionSlice {
	if p.storageConnections == nil {
		panic("the storageConnections must not be nil, please use StorageConnections() function instead")
	}
	return p.storageConnections
}

type LinkLayerDiscoveryProtocolElement struct {
	Struct
	comment     *string
	description *string
	id          *string
	name        *string
	oui         *int64
	properties  *PropertySlice
	subtype     *int64
	type_       *int64
}

func (p *LinkLayerDiscoveryProtocolElement) SetComment(attr string) {
	p.comment = &attr
}

func (p *LinkLayerDiscoveryProtocolElement) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *LinkLayerDiscoveryProtocolElement) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *LinkLayerDiscoveryProtocolElement) SetDescription(attr string) {
	p.description = &attr
}

func (p *LinkLayerDiscoveryProtocolElement) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *LinkLayerDiscoveryProtocolElement) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *LinkLayerDiscoveryProtocolElement) SetId(attr string) {
	p.id = &attr
}

func (p *LinkLayerDiscoveryProtocolElement) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *LinkLayerDiscoveryProtocolElement) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *LinkLayerDiscoveryProtocolElement) SetName(attr string) {
	p.name = &attr
}

func (p *LinkLayerDiscoveryProtocolElement) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *LinkLayerDiscoveryProtocolElement) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *LinkLayerDiscoveryProtocolElement) SetOui(attr int64) {
	p.oui = &attr
}

func (p *LinkLayerDiscoveryProtocolElement) Oui() (int64, bool) {
	if p.oui != nil {
		return *p.oui, true
	}
	var zero int64
	return zero, false
}

func (p *LinkLayerDiscoveryProtocolElement) MustOui() int64 {
	if p.oui == nil {
		panic("the oui must not be nil, please use Oui() function instead")
	}
	return *p.oui
}

func (p *LinkLayerDiscoveryProtocolElement) SetProperties(attr *PropertySlice) {
	p.properties = attr
}

func (p *LinkLayerDiscoveryProtocolElement) Properties() (*PropertySlice, bool) {
	if p.properties != nil {
		return p.properties, true
	}
	return nil, false
}

func (p *LinkLayerDiscoveryProtocolElement) MustProperties() *PropertySlice {
	if p.properties == nil {
		panic("the properties must not be nil, please use Properties() function instead")
	}
	return p.properties
}

func (p *LinkLayerDiscoveryProtocolElement) SetSubtype(attr int64) {
	p.subtype = &attr
}

func (p *LinkLayerDiscoveryProtocolElement) Subtype() (int64, bool) {
	if p.subtype != nil {
		return *p.subtype, true
	}
	var zero int64
	return zero, false
}

func (p *LinkLayerDiscoveryProtocolElement) MustSubtype() int64 {
	if p.subtype == nil {
		panic("the subtype must not be nil, please use Subtype() function instead")
	}
	return *p.subtype
}

func (p *LinkLayerDiscoveryProtocolElement) SetType(attr int64) {
	p.type_ = &attr
}

func (p *LinkLayerDiscoveryProtocolElement) Type() (int64, bool) {
	if p.type_ != nil {
		return *p.type_, true
	}
	var zero int64
	return zero, false
}

func (p *LinkLayerDiscoveryProtocolElement) MustType() int64 {
	if p.type_ == nil {
		panic("the type_ must not be nil, please use Type() function instead")
	}
	return *p.type_
}

type ApiSummary struct {
	Struct
	hosts          *ApiSummaryItem
	storageDomains *ApiSummaryItem
	users          *ApiSummaryItem
	vms            *ApiSummaryItem
}

func (p *ApiSummary) SetHosts(attr *ApiSummaryItem) {
	p.hosts = attr
}

func (p *ApiSummary) Hosts() (*ApiSummaryItem, bool) {
	if p.hosts != nil {
		return p.hosts, true
	}
	return nil, false
}

func (p *ApiSummary) MustHosts() *ApiSummaryItem {
	if p.hosts == nil {
		panic("the hosts must not be nil, please use Hosts() function instead")
	}
	return p.hosts
}

func (p *ApiSummary) SetStorageDomains(attr *ApiSummaryItem) {
	p.storageDomains = attr
}

func (p *ApiSummary) StorageDomains() (*ApiSummaryItem, bool) {
	if p.storageDomains != nil {
		return p.storageDomains, true
	}
	return nil, false
}

func (p *ApiSummary) MustStorageDomains() *ApiSummaryItem {
	if p.storageDomains == nil {
		panic("the storageDomains must not be nil, please use StorageDomains() function instead")
	}
	return p.storageDomains
}

func (p *ApiSummary) SetUsers(attr *ApiSummaryItem) {
	p.users = attr
}

func (p *ApiSummary) Users() (*ApiSummaryItem, bool) {
	if p.users != nil {
		return p.users, true
	}
	return nil, false
}

func (p *ApiSummary) MustUsers() *ApiSummaryItem {
	if p.users == nil {
		panic("the users must not be nil, please use Users() function instead")
	}
	return p.users
}

func (p *ApiSummary) SetVms(attr *ApiSummaryItem) {
	p.vms = attr
}

func (p *ApiSummary) Vms() (*ApiSummaryItem, bool) {
	if p.vms != nil {
		return p.vms, true
	}
	return nil, false
}

func (p *ApiSummary) MustVms() *ApiSummaryItem {
	if p.vms == nil {
		panic("the vms must not be nil, please use Vms() function instead")
	}
	return p.vms
}

type Fault struct {
	Struct
	detail *string
	reason *string
}

func (p *Fault) SetDetail(attr string) {
	p.detail = &attr
}

func (p *Fault) Detail() (string, bool) {
	if p.detail != nil {
		return *p.detail, true
	}
	var zero string
	return zero, false
}

func (p *Fault) MustDetail() string {
	if p.detail == nil {
		panic("the detail must not be nil, please use Detail() function instead")
	}
	return *p.detail
}

func (p *Fault) SetReason(attr string) {
	p.reason = &attr
}

func (p *Fault) Reason() (string, bool) {
	if p.reason != nil {
		return *p.reason, true
	}
	var zero string
	return zero, false
}

func (p *Fault) MustReason() string {
	if p.reason == nil {
		panic("the reason must not be nil, please use Reason() function instead")
	}
	return *p.reason
}

type GracePeriod struct {
	Struct
	expiry *int64
}

func (p *GracePeriod) SetExpiry(attr int64) {
	p.expiry = &attr
}

func (p *GracePeriod) Expiry() (int64, bool) {
	if p.expiry != nil {
		return *p.expiry, true
	}
	var zero int64
	return zero, false
}

func (p *GracePeriod) MustExpiry() int64 {
	if p.expiry == nil {
		panic("the expiry must not be nil, please use Expiry() function instead")
	}
	return *p.expiry
}

type Action struct {
	Struct
	activate                       *bool
	allowPartialImport             *bool
	async                          *bool
	attachment                     *DiskAttachment
	authorizedKey                  *AuthorizedKey
	autoPinningPolicy              *AutoPinningPolicy
	bricks                         *GlusterBrickSlice
	certificates                   *CertificateSlice
	checkConnectivity              *bool
	clone                          *bool
	clonePermissions               *bool
	cluster                        *Cluster
	collapseSnapshots              *bool
	comment                        *string
	commitOnSuccess                *bool
	connection                     *StorageConnection
	connectivityTimeout            *int64
	dataCenter                     *DataCenter
	deployHostedEngine             *bool
	description                    *string
	details                        *GlusterVolumeProfileDetails
	directory                      *string
	discardSnapshots               *bool
	discoveredTargets              *IscsiDetailsSlice
	disk                           *Disk
	diskProfile                    *DiskProfile
	disks                          *DiskSlice
	exclusive                      *bool
	fault                          *Fault
	fenceType                      *string
	filename                       *string
	filter                         *bool
	fixLayout                      *bool
	force                          *bool
	gracePeriod                    *GracePeriod
	host                           *Host
	id                             *string
	image                          *string
	imageTransfer                  *ImageTransfer
	importAsTemplate               *bool
	isAttached                     *bool
	iscsi                          *IscsiDetails
	iscsiTargets                   []string
	job                            *Job
	lease                          *StorageDomainLease
	logicalUnits                   *LogicalUnitSlice
	maintenanceAfterRestart        *bool
	maintenanceEnabled             *bool
	migrateVmsInAffinityClosure    *bool
	modifiedBonds                  *HostNicSlice
	modifiedLabels                 *NetworkLabelSlice
	modifiedNetworkAttachments     *NetworkAttachmentSlice
	name                           *string
	option                         *Option
	pause                          *bool
	permission                     *Permission
	powerManagement                *PowerManagement
	proxyTicket                    *ProxyTicket
	quota                          *Quota
	reason                         *string
	reassignBadMacs                *bool
	reboot                         *bool
	registrationConfiguration      *RegistrationConfiguration
	remoteViewerConnectionFile     *string
	removedBonds                   *HostNicSlice
	removedLabels                  *NetworkLabelSlice
	removedNetworkAttachments      *NetworkAttachmentSlice
	resolutionType                 *string
	restoreMemory                  *bool
	rootPassword                   *string
	seal                           *bool
	snapshot                       *Snapshot
	sourceHost                     *Host
	ssh                            *Ssh
	status                         *string
	stopGlusterService             *bool
	storageDomain                  *StorageDomain
	storageDomains                 *StorageDomainSlice
	succeeded                      *bool
	synchronizedNetworkAttachments *NetworkAttachmentSlice
	template                       *Template
	ticket                         *Ticket
	timeout                        *int64
	undeployHostedEngine           *bool
	upgradeAction                  *ClusterUpgradeAction
	useCloudInit                   *bool
	useIgnition                    *bool
	useInitialization              *bool
	useSysprep                     *bool
	virtualFunctionsConfiguration  *HostNicVirtualFunctionsConfiguration
	vm                             *Vm
	vnicProfileMappings            *VnicProfileMappingSlice
	volatile                       *bool
}

func (p *Action) SetActivate(attr bool) {
	p.activate = &attr
}

func (p *Action) Activate() (bool, bool) {
	if p.activate != nil {
		return *p.activate, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustActivate() bool {
	if p.activate == nil {
		panic("the activate must not be nil, please use Activate() function instead")
	}
	return *p.activate
}

func (p *Action) SetAllowPartialImport(attr bool) {
	p.allowPartialImport = &attr
}

func (p *Action) AllowPartialImport() (bool, bool) {
	if p.allowPartialImport != nil {
		return *p.allowPartialImport, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustAllowPartialImport() bool {
	if p.allowPartialImport == nil {
		panic("the allowPartialImport must not be nil, please use AllowPartialImport() function instead")
	}
	return *p.allowPartialImport
}

func (p *Action) SetAsync(attr bool) {
	p.async = &attr
}

func (p *Action) Async() (bool, bool) {
	if p.async != nil {
		return *p.async, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustAsync() bool {
	if p.async == nil {
		panic("the async must not be nil, please use Async() function instead")
	}
	return *p.async
}

func (p *Action) SetAttachment(attr *DiskAttachment) {
	p.attachment = attr
}

func (p *Action) Attachment() (*DiskAttachment, bool) {
	if p.attachment != nil {
		return p.attachment, true
	}
	return nil, false
}

func (p *Action) MustAttachment() *DiskAttachment {
	if p.attachment == nil {
		panic("the attachment must not be nil, please use Attachment() function instead")
	}
	return p.attachment
}

func (p *Action) SetAuthorizedKey(attr *AuthorizedKey) {
	p.authorizedKey = attr
}

func (p *Action) AuthorizedKey() (*AuthorizedKey, bool) {
	if p.authorizedKey != nil {
		return p.authorizedKey, true
	}
	return nil, false
}

func (p *Action) MustAuthorizedKey() *AuthorizedKey {
	if p.authorizedKey == nil {
		panic("the authorizedKey must not be nil, please use AuthorizedKey() function instead")
	}
	return p.authorizedKey
}

func (p *Action) SetAutoPinningPolicy(attr AutoPinningPolicy) {
	p.autoPinningPolicy = &attr
}

func (p *Action) AutoPinningPolicy() (AutoPinningPolicy, bool) {
	if p.autoPinningPolicy != nil {
		return *p.autoPinningPolicy, true
	}
	var zero AutoPinningPolicy
	return zero, false
}

func (p *Action) MustAutoPinningPolicy() AutoPinningPolicy {
	if p.autoPinningPolicy == nil {
		panic("the autoPinningPolicy must not be nil, please use AutoPinningPolicy() function instead")
	}
	return *p.autoPinningPolicy
}

func (p *Action) SetBricks(attr *GlusterBrickSlice) {
	p.bricks = attr
}

func (p *Action) Bricks() (*GlusterBrickSlice, bool) {
	if p.bricks != nil {
		return p.bricks, true
	}
	return nil, false
}

func (p *Action) MustBricks() *GlusterBrickSlice {
	if p.bricks == nil {
		panic("the bricks must not be nil, please use Bricks() function instead")
	}
	return p.bricks
}

func (p *Action) SetCertificates(attr *CertificateSlice) {
	p.certificates = attr
}

func (p *Action) Certificates() (*CertificateSlice, bool) {
	if p.certificates != nil {
		return p.certificates, true
	}
	return nil, false
}

func (p *Action) MustCertificates() *CertificateSlice {
	if p.certificates == nil {
		panic("the certificates must not be nil, please use Certificates() function instead")
	}
	return p.certificates
}

func (p *Action) SetCheckConnectivity(attr bool) {
	p.checkConnectivity = &attr
}

func (p *Action) CheckConnectivity() (bool, bool) {
	if p.checkConnectivity != nil {
		return *p.checkConnectivity, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustCheckConnectivity() bool {
	if p.checkConnectivity == nil {
		panic("the checkConnectivity must not be nil, please use CheckConnectivity() function instead")
	}
	return *p.checkConnectivity
}

func (p *Action) SetClone(attr bool) {
	p.clone = &attr
}

func (p *Action) Clone() (bool, bool) {
	if p.clone != nil {
		return *p.clone, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustClone() bool {
	if p.clone == nil {
		panic("the clone must not be nil, please use Clone() function instead")
	}
	return *p.clone
}

func (p *Action) SetClonePermissions(attr bool) {
	p.clonePermissions = &attr
}

func (p *Action) ClonePermissions() (bool, bool) {
	if p.clonePermissions != nil {
		return *p.clonePermissions, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustClonePermissions() bool {
	if p.clonePermissions == nil {
		panic("the clonePermissions must not be nil, please use ClonePermissions() function instead")
	}
	return *p.clonePermissions
}

func (p *Action) SetCluster(attr *Cluster) {
	p.cluster = attr
}

func (p *Action) Cluster() (*Cluster, bool) {
	if p.cluster != nil {
		return p.cluster, true
	}
	return nil, false
}

func (p *Action) MustCluster() *Cluster {
	if p.cluster == nil {
		panic("the cluster must not be nil, please use Cluster() function instead")
	}
	return p.cluster
}

func (p *Action) SetCollapseSnapshots(attr bool) {
	p.collapseSnapshots = &attr
}

func (p *Action) CollapseSnapshots() (bool, bool) {
	if p.collapseSnapshots != nil {
		return *p.collapseSnapshots, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustCollapseSnapshots() bool {
	if p.collapseSnapshots == nil {
		panic("the collapseSnapshots must not be nil, please use CollapseSnapshots() function instead")
	}
	return *p.collapseSnapshots
}

func (p *Action) SetComment(attr string) {
	p.comment = &attr
}

func (p *Action) Comment() (string, bool) {
	if p.comment != nil {
		return *p.comment, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustComment() string {
	if p.comment == nil {
		panic("the comment must not be nil, please use Comment() function instead")
	}
	return *p.comment
}

func (p *Action) SetCommitOnSuccess(attr bool) {
	p.commitOnSuccess = &attr
}

func (p *Action) CommitOnSuccess() (bool, bool) {
	if p.commitOnSuccess != nil {
		return *p.commitOnSuccess, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustCommitOnSuccess() bool {
	if p.commitOnSuccess == nil {
		panic("the commitOnSuccess must not be nil, please use CommitOnSuccess() function instead")
	}
	return *p.commitOnSuccess
}

func (p *Action) SetConnection(attr *StorageConnection) {
	p.connection = attr
}

func (p *Action) Connection() (*StorageConnection, bool) {
	if p.connection != nil {
		return p.connection, true
	}
	return nil, false
}

func (p *Action) MustConnection() *StorageConnection {
	if p.connection == nil {
		panic("the connection must not be nil, please use Connection() function instead")
	}
	return p.connection
}

func (p *Action) SetConnectivityTimeout(attr int64) {
	p.connectivityTimeout = &attr
}

func (p *Action) ConnectivityTimeout() (int64, bool) {
	if p.connectivityTimeout != nil {
		return *p.connectivityTimeout, true
	}
	var zero int64
	return zero, false
}

func (p *Action) MustConnectivityTimeout() int64 {
	if p.connectivityTimeout == nil {
		panic("the connectivityTimeout must not be nil, please use ConnectivityTimeout() function instead")
	}
	return *p.connectivityTimeout
}

func (p *Action) SetDataCenter(attr *DataCenter) {
	p.dataCenter = attr
}

func (p *Action) DataCenter() (*DataCenter, bool) {
	if p.dataCenter != nil {
		return p.dataCenter, true
	}
	return nil, false
}

func (p *Action) MustDataCenter() *DataCenter {
	if p.dataCenter == nil {
		panic("the dataCenter must not be nil, please use DataCenter() function instead")
	}
	return p.dataCenter
}

func (p *Action) SetDeployHostedEngine(attr bool) {
	p.deployHostedEngine = &attr
}

func (p *Action) DeployHostedEngine() (bool, bool) {
	if p.deployHostedEngine != nil {
		return *p.deployHostedEngine, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustDeployHostedEngine() bool {
	if p.deployHostedEngine == nil {
		panic("the deployHostedEngine must not be nil, please use DeployHostedEngine() function instead")
	}
	return *p.deployHostedEngine
}

func (p *Action) SetDescription(attr string) {
	p.description = &attr
}

func (p *Action) Description() (string, bool) {
	if p.description != nil {
		return *p.description, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustDescription() string {
	if p.description == nil {
		panic("the description must not be nil, please use Description() function instead")
	}
	return *p.description
}

func (p *Action) SetDetails(attr *GlusterVolumeProfileDetails) {
	p.details = attr
}

func (p *Action) Details() (*GlusterVolumeProfileDetails, bool) {
	if p.details != nil {
		return p.details, true
	}
	return nil, false
}

func (p *Action) MustDetails() *GlusterVolumeProfileDetails {
	if p.details == nil {
		panic("the details must not be nil, please use Details() function instead")
	}
	return p.details
}

func (p *Action) SetDirectory(attr string) {
	p.directory = &attr
}

func (p *Action) Directory() (string, bool) {
	if p.directory != nil {
		return *p.directory, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustDirectory() string {
	if p.directory == nil {
		panic("the directory must not be nil, please use Directory() function instead")
	}
	return *p.directory
}

func (p *Action) SetDiscardSnapshots(attr bool) {
	p.discardSnapshots = &attr
}

func (p *Action) DiscardSnapshots() (bool, bool) {
	if p.discardSnapshots != nil {
		return *p.discardSnapshots, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustDiscardSnapshots() bool {
	if p.discardSnapshots == nil {
		panic("the discardSnapshots must not be nil, please use DiscardSnapshots() function instead")
	}
	return *p.discardSnapshots
}

func (p *Action) SetDiscoveredTargets(attr *IscsiDetailsSlice) {
	p.discoveredTargets = attr
}

func (p *Action) DiscoveredTargets() (*IscsiDetailsSlice, bool) {
	if p.discoveredTargets != nil {
		return p.discoveredTargets, true
	}
	return nil, false
}

func (p *Action) MustDiscoveredTargets() *IscsiDetailsSlice {
	if p.discoveredTargets == nil {
		panic("the discoveredTargets must not be nil, please use DiscoveredTargets() function instead")
	}
	return p.discoveredTargets
}

func (p *Action) SetDisk(attr *Disk) {
	p.disk = attr
}

func (p *Action) Disk() (*Disk, bool) {
	if p.disk != nil {
		return p.disk, true
	}
	return nil, false
}

func (p *Action) MustDisk() *Disk {
	if p.disk == nil {
		panic("the disk must not be nil, please use Disk() function instead")
	}
	return p.disk
}

func (p *Action) SetDiskProfile(attr *DiskProfile) {
	p.diskProfile = attr
}

func (p *Action) DiskProfile() (*DiskProfile, bool) {
	if p.diskProfile != nil {
		return p.diskProfile, true
	}
	return nil, false
}

func (p *Action) MustDiskProfile() *DiskProfile {
	if p.diskProfile == nil {
		panic("the diskProfile must not be nil, please use DiskProfile() function instead")
	}
	return p.diskProfile
}

func (p *Action) SetDisks(attr *DiskSlice) {
	p.disks = attr
}

func (p *Action) Disks() (*DiskSlice, bool) {
	if p.disks != nil {
		return p.disks, true
	}
	return nil, false
}

func (p *Action) MustDisks() *DiskSlice {
	if p.disks == nil {
		panic("the disks must not be nil, please use Disks() function instead")
	}
	return p.disks
}

func (p *Action) SetExclusive(attr bool) {
	p.exclusive = &attr
}

func (p *Action) Exclusive() (bool, bool) {
	if p.exclusive != nil {
		return *p.exclusive, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustExclusive() bool {
	if p.exclusive == nil {
		panic("the exclusive must not be nil, please use Exclusive() function instead")
	}
	return *p.exclusive
}

func (p *Action) SetFault(attr *Fault) {
	p.fault = attr
}

func (p *Action) Fault() (*Fault, bool) {
	if p.fault != nil {
		return p.fault, true
	}
	return nil, false
}

func (p *Action) MustFault() *Fault {
	if p.fault == nil {
		panic("the fault must not be nil, please use Fault() function instead")
	}
	return p.fault
}

func (p *Action) SetFenceType(attr string) {
	p.fenceType = &attr
}

func (p *Action) FenceType() (string, bool) {
	if p.fenceType != nil {
		return *p.fenceType, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustFenceType() string {
	if p.fenceType == nil {
		panic("the fenceType must not be nil, please use FenceType() function instead")
	}
	return *p.fenceType
}

func (p *Action) SetFilename(attr string) {
	p.filename = &attr
}

func (p *Action) Filename() (string, bool) {
	if p.filename != nil {
		return *p.filename, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustFilename() string {
	if p.filename == nil {
		panic("the filename must not be nil, please use Filename() function instead")
	}
	return *p.filename
}

func (p *Action) SetFilter(attr bool) {
	p.filter = &attr
}

func (p *Action) Filter() (bool, bool) {
	if p.filter != nil {
		return *p.filter, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustFilter() bool {
	if p.filter == nil {
		panic("the filter must not be nil, please use Filter() function instead")
	}
	return *p.filter
}

func (p *Action) SetFixLayout(attr bool) {
	p.fixLayout = &attr
}

func (p *Action) FixLayout() (bool, bool) {
	if p.fixLayout != nil {
		return *p.fixLayout, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustFixLayout() bool {
	if p.fixLayout == nil {
		panic("the fixLayout must not be nil, please use FixLayout() function instead")
	}
	return *p.fixLayout
}

func (p *Action) SetForce(attr bool) {
	p.force = &attr
}

func (p *Action) Force() (bool, bool) {
	if p.force != nil {
		return *p.force, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustForce() bool {
	if p.force == nil {
		panic("the force must not be nil, please use Force() function instead")
	}
	return *p.force
}

func (p *Action) SetGracePeriod(attr *GracePeriod) {
	p.gracePeriod = attr
}

func (p *Action) GracePeriod() (*GracePeriod, bool) {
	if p.gracePeriod != nil {
		return p.gracePeriod, true
	}
	return nil, false
}

func (p *Action) MustGracePeriod() *GracePeriod {
	if p.gracePeriod == nil {
		panic("the gracePeriod must not be nil, please use GracePeriod() function instead")
	}
	return p.gracePeriod
}

func (p *Action) SetHost(attr *Host) {
	p.host = attr
}

func (p *Action) Host() (*Host, bool) {
	if p.host != nil {
		return p.host, true
	}
	return nil, false
}

func (p *Action) MustHost() *Host {
	if p.host == nil {
		panic("the host must not be nil, please use Host() function instead")
	}
	return p.host
}

func (p *Action) SetId(attr string) {
	p.id = &attr
}

func (p *Action) Id() (string, bool) {
	if p.id != nil {
		return *p.id, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustId() string {
	if p.id == nil {
		panic("the id must not be nil, please use Id() function instead")
	}
	return *p.id
}

func (p *Action) SetImage(attr string) {
	p.image = &attr
}

func (p *Action) Image() (string, bool) {
	if p.image != nil {
		return *p.image, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustImage() string {
	if p.image == nil {
		panic("the image must not be nil, please use Image() function instead")
	}
	return *p.image
}

func (p *Action) SetImageTransfer(attr *ImageTransfer) {
	p.imageTransfer = attr
}

func (p *Action) ImageTransfer() (*ImageTransfer, bool) {
	if p.imageTransfer != nil {
		return p.imageTransfer, true
	}
	return nil, false
}

func (p *Action) MustImageTransfer() *ImageTransfer {
	if p.imageTransfer == nil {
		panic("the imageTransfer must not be nil, please use ImageTransfer() function instead")
	}
	return p.imageTransfer
}

func (p *Action) SetImportAsTemplate(attr bool) {
	p.importAsTemplate = &attr
}

func (p *Action) ImportAsTemplate() (bool, bool) {
	if p.importAsTemplate != nil {
		return *p.importAsTemplate, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustImportAsTemplate() bool {
	if p.importAsTemplate == nil {
		panic("the importAsTemplate must not be nil, please use ImportAsTemplate() function instead")
	}
	return *p.importAsTemplate
}

func (p *Action) SetIsAttached(attr bool) {
	p.isAttached = &attr
}

func (p *Action) IsAttached() (bool, bool) {
	if p.isAttached != nil {
		return *p.isAttached, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustIsAttached() bool {
	if p.isAttached == nil {
		panic("the isAttached must not be nil, please use IsAttached() function instead")
	}
	return *p.isAttached
}

func (p *Action) SetIscsi(attr *IscsiDetails) {
	p.iscsi = attr
}

func (p *Action) Iscsi() (*IscsiDetails, bool) {
	if p.iscsi != nil {
		return p.iscsi, true
	}
	return nil, false
}

func (p *Action) MustIscsi() *IscsiDetails {
	if p.iscsi == nil {
		panic("the iscsi must not be nil, please use Iscsi() function instead")
	}
	return p.iscsi
}

func (p *Action) SetIscsiTargets(attr []string) {
	p.iscsiTargets = attr
}

func (p *Action) IscsiTargets() ([]string, bool) {
	if p.iscsiTargets != nil {
		return p.iscsiTargets, true
	}
	return nil, false
}

func (p *Action) MustIscsiTargets() []string {
	if p.iscsiTargets == nil {
		panic("the iscsiTargets must not be nil, please use IscsiTargets() function instead")
	}
	return p.iscsiTargets
}

func (p *Action) SetJob(attr *Job) {
	p.job = attr
}

func (p *Action) Job() (*Job, bool) {
	if p.job != nil {
		return p.job, true
	}
	return nil, false
}

func (p *Action) MustJob() *Job {
	if p.job == nil {
		panic("the job must not be nil, please use Job() function instead")
	}
	return p.job
}

func (p *Action) SetLease(attr *StorageDomainLease) {
	p.lease = attr
}

func (p *Action) Lease() (*StorageDomainLease, bool) {
	if p.lease != nil {
		return p.lease, true
	}
	return nil, false
}

func (p *Action) MustLease() *StorageDomainLease {
	if p.lease == nil {
		panic("the lease must not be nil, please use Lease() function instead")
	}
	return p.lease
}

func (p *Action) SetLogicalUnits(attr *LogicalUnitSlice) {
	p.logicalUnits = attr
}

func (p *Action) LogicalUnits() (*LogicalUnitSlice, bool) {
	if p.logicalUnits != nil {
		return p.logicalUnits, true
	}
	return nil, false
}

func (p *Action) MustLogicalUnits() *LogicalUnitSlice {
	if p.logicalUnits == nil {
		panic("the logicalUnits must not be nil, please use LogicalUnits() function instead")
	}
	return p.logicalUnits
}

func (p *Action) SetMaintenanceAfterRestart(attr bool) {
	p.maintenanceAfterRestart = &attr
}

func (p *Action) MaintenanceAfterRestart() (bool, bool) {
	if p.maintenanceAfterRestart != nil {
		return *p.maintenanceAfterRestart, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustMaintenanceAfterRestart() bool {
	if p.maintenanceAfterRestart == nil {
		panic("the maintenanceAfterRestart must not be nil, please use MaintenanceAfterRestart() function instead")
	}
	return *p.maintenanceAfterRestart
}

func (p *Action) SetMaintenanceEnabled(attr bool) {
	p.maintenanceEnabled = &attr
}

func (p *Action) MaintenanceEnabled() (bool, bool) {
	if p.maintenanceEnabled != nil {
		return *p.maintenanceEnabled, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustMaintenanceEnabled() bool {
	if p.maintenanceEnabled == nil {
		panic("the maintenanceEnabled must not be nil, please use MaintenanceEnabled() function instead")
	}
	return *p.maintenanceEnabled
}

func (p *Action) SetMigrateVmsInAffinityClosure(attr bool) {
	p.migrateVmsInAffinityClosure = &attr
}

func (p *Action) MigrateVmsInAffinityClosure() (bool, bool) {
	if p.migrateVmsInAffinityClosure != nil {
		return *p.migrateVmsInAffinityClosure, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustMigrateVmsInAffinityClosure() bool {
	if p.migrateVmsInAffinityClosure == nil {
		panic("the migrateVmsInAffinityClosure must not be nil, please use MigrateVmsInAffinityClosure() function instead")
	}
	return *p.migrateVmsInAffinityClosure
}

func (p *Action) SetModifiedBonds(attr *HostNicSlice) {
	p.modifiedBonds = attr
}

func (p *Action) ModifiedBonds() (*HostNicSlice, bool) {
	if p.modifiedBonds != nil {
		return p.modifiedBonds, true
	}
	return nil, false
}

func (p *Action) MustModifiedBonds() *HostNicSlice {
	if p.modifiedBonds == nil {
		panic("the modifiedBonds must not be nil, please use ModifiedBonds() function instead")
	}
	return p.modifiedBonds
}

func (p *Action) SetModifiedLabels(attr *NetworkLabelSlice) {
	p.modifiedLabels = attr
}

func (p *Action) ModifiedLabels() (*NetworkLabelSlice, bool) {
	if p.modifiedLabels != nil {
		return p.modifiedLabels, true
	}
	return nil, false
}

func (p *Action) MustModifiedLabels() *NetworkLabelSlice {
	if p.modifiedLabels == nil {
		panic("the modifiedLabels must not be nil, please use ModifiedLabels() function instead")
	}
	return p.modifiedLabels
}

func (p *Action) SetModifiedNetworkAttachments(attr *NetworkAttachmentSlice) {
	p.modifiedNetworkAttachments = attr
}

func (p *Action) ModifiedNetworkAttachments() (*NetworkAttachmentSlice, bool) {
	if p.modifiedNetworkAttachments != nil {
		return p.modifiedNetworkAttachments, true
	}
	return nil, false
}

func (p *Action) MustModifiedNetworkAttachments() *NetworkAttachmentSlice {
	if p.modifiedNetworkAttachments == nil {
		panic("the modifiedNetworkAttachments must not be nil, please use ModifiedNetworkAttachments() function instead")
	}
	return p.modifiedNetworkAttachments
}

func (p *Action) SetName(attr string) {
	p.name = &attr
}

func (p *Action) Name() (string, bool) {
	if p.name != nil {
		return *p.name, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustName() string {
	if p.name == nil {
		panic("the name must not be nil, please use Name() function instead")
	}
	return *p.name
}

func (p *Action) SetOption(attr *Option) {
	p.option = attr
}

func (p *Action) Option() (*Option, bool) {
	if p.option != nil {
		return p.option, true
	}
	return nil, false
}

func (p *Action) MustOption() *Option {
	if p.option == nil {
		panic("the option must not be nil, please use Option() function instead")
	}
	return p.option
}

func (p *Action) SetPause(attr bool) {
	p.pause = &attr
}

func (p *Action) Pause() (bool, bool) {
	if p.pause != nil {
		return *p.pause, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustPause() bool {
	if p.pause == nil {
		panic("the pause must not be nil, please use Pause() function instead")
	}
	return *p.pause
}

func (p *Action) SetPermission(attr *Permission) {
	p.permission = attr
}

func (p *Action) Permission() (*Permission, bool) {
	if p.permission != nil {
		return p.permission, true
	}
	return nil, false
}

func (p *Action) MustPermission() *Permission {
	if p.permission == nil {
		panic("the permission must not be nil, please use Permission() function instead")
	}
	return p.permission
}

func (p *Action) SetPowerManagement(attr *PowerManagement) {
	p.powerManagement = attr
}

func (p *Action) PowerManagement() (*PowerManagement, bool) {
	if p.powerManagement != nil {
		return p.powerManagement, true
	}
	return nil, false
}

func (p *Action) MustPowerManagement() *PowerManagement {
	if p.powerManagement == nil {
		panic("the powerManagement must not be nil, please use PowerManagement() function instead")
	}
	return p.powerManagement
}

func (p *Action) SetProxyTicket(attr *ProxyTicket) {
	p.proxyTicket = attr
}

func (p *Action) ProxyTicket() (*ProxyTicket, bool) {
	if p.proxyTicket != nil {
		return p.proxyTicket, true
	}
	return nil, false
}

func (p *Action) MustProxyTicket() *ProxyTicket {
	if p.proxyTicket == nil {
		panic("the proxyTicket must not be nil, please use ProxyTicket() function instead")
	}
	return p.proxyTicket
}

func (p *Action) SetQuota(attr *Quota) {
	p.quota = attr
}

func (p *Action) Quota() (*Quota, bool) {
	if p.quota != nil {
		return p.quota, true
	}
	return nil, false
}

func (p *Action) MustQuota() *Quota {
	if p.quota == nil {
		panic("the quota must not be nil, please use Quota() function instead")
	}
	return p.quota
}

func (p *Action) SetReason(attr string) {
	p.reason = &attr
}

func (p *Action) Reason() (string, bool) {
	if p.reason != nil {
		return *p.reason, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustReason() string {
	if p.reason == nil {
		panic("the reason must not be nil, please use Reason() function instead")
	}
	return *p.reason
}

func (p *Action) SetReassignBadMacs(attr bool) {
	p.reassignBadMacs = &attr
}

func (p *Action) ReassignBadMacs() (bool, bool) {
	if p.reassignBadMacs != nil {
		return *p.reassignBadMacs, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustReassignBadMacs() bool {
	if p.reassignBadMacs == nil {
		panic("the reassignBadMacs must not be nil, please use ReassignBadMacs() function instead")
	}
	return *p.reassignBadMacs
}

func (p *Action) SetReboot(attr bool) {
	p.reboot = &attr
}

func (p *Action) Reboot() (bool, bool) {
	if p.reboot != nil {
		return *p.reboot, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustReboot() bool {
	if p.reboot == nil {
		panic("the reboot must not be nil, please use Reboot() function instead")
	}
	return *p.reboot
}

func (p *Action) SetRegistrationConfiguration(attr *RegistrationConfiguration) {
	p.registrationConfiguration = attr
}

func (p *Action) RegistrationConfiguration() (*RegistrationConfiguration, bool) {
	if p.registrationConfiguration != nil {
		return p.registrationConfiguration, true
	}
	return nil, false
}

func (p *Action) MustRegistrationConfiguration() *RegistrationConfiguration {
	if p.registrationConfiguration == nil {
		panic("the registrationConfiguration must not be nil, please use RegistrationConfiguration() function instead")
	}
	return p.registrationConfiguration
}

func (p *Action) SetRemoteViewerConnectionFile(attr string) {
	p.remoteViewerConnectionFile = &attr
}

func (p *Action) RemoteViewerConnectionFile() (string, bool) {
	if p.remoteViewerConnectionFile != nil {
		return *p.remoteViewerConnectionFile, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustRemoteViewerConnectionFile() string {
	if p.remoteViewerConnectionFile == nil {
		panic("the remoteViewerConnectionFile must not be nil, please use RemoteViewerConnectionFile() function instead")
	}
	return *p.remoteViewerConnectionFile
}

func (p *Action) SetRemovedBonds(attr *HostNicSlice) {
	p.removedBonds = attr
}

func (p *Action) RemovedBonds() (*HostNicSlice, bool) {
	if p.removedBonds != nil {
		return p.removedBonds, true
	}
	return nil, false
}

func (p *Action) MustRemovedBonds() *HostNicSlice {
	if p.removedBonds == nil {
		panic("the removedBonds must not be nil, please use RemovedBonds() function instead")
	}
	return p.removedBonds
}

func (p *Action) SetRemovedLabels(attr *NetworkLabelSlice) {
	p.removedLabels = attr
}

func (p *Action) RemovedLabels() (*NetworkLabelSlice, bool) {
	if p.removedLabels != nil {
		return p.removedLabels, true
	}
	return nil, false
}

func (p *Action) MustRemovedLabels() *NetworkLabelSlice {
	if p.removedLabels == nil {
		panic("the removedLabels must not be nil, please use RemovedLabels() function instead")
	}
	return p.removedLabels
}

func (p *Action) SetRemovedNetworkAttachments(attr *NetworkAttachmentSlice) {
	p.removedNetworkAttachments = attr
}

func (p *Action) RemovedNetworkAttachments() (*NetworkAttachmentSlice, bool) {
	if p.removedNetworkAttachments != nil {
		return p.removedNetworkAttachments, true
	}
	return nil, false
}

func (p *Action) MustRemovedNetworkAttachments() *NetworkAttachmentSlice {
	if p.removedNetworkAttachments == nil {
		panic("the removedNetworkAttachments must not be nil, please use RemovedNetworkAttachments() function instead")
	}
	return p.removedNetworkAttachments
}

func (p *Action) SetResolutionType(attr string) {
	p.resolutionType = &attr
}

func (p *Action) ResolutionType() (string, bool) {
	if p.resolutionType != nil {
		return *p.resolutionType, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustResolutionType() string {
	if p.resolutionType == nil {
		panic("the resolutionType must not be nil, please use ResolutionType() function instead")
	}
	return *p.resolutionType
}

func (p *Action) SetRestoreMemory(attr bool) {
	p.restoreMemory = &attr
}

func (p *Action) RestoreMemory() (bool, bool) {
	if p.restoreMemory != nil {
		return *p.restoreMemory, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustRestoreMemory() bool {
	if p.restoreMemory == nil {
		panic("the restoreMemory must not be nil, please use RestoreMemory() function instead")
	}
	return *p.restoreMemory
}

func (p *Action) SetRootPassword(attr string) {
	p.rootPassword = &attr
}

func (p *Action) RootPassword() (string, bool) {
	if p.rootPassword != nil {
		return *p.rootPassword, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustRootPassword() string {
	if p.rootPassword == nil {
		panic("the rootPassword must not be nil, please use RootPassword() function instead")
	}
	return *p.rootPassword
}

func (p *Action) SetSeal(attr bool) {
	p.seal = &attr
}

func (p *Action) Seal() (bool, bool) {
	if p.seal != nil {
		return *p.seal, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustSeal() bool {
	if p.seal == nil {
		panic("the seal must not be nil, please use Seal() function instead")
	}
	return *p.seal
}

func (p *Action) SetSnapshot(attr *Snapshot) {
	p.snapshot = attr
}

func (p *Action) Snapshot() (*Snapshot, bool) {
	if p.snapshot != nil {
		return p.snapshot, true
	}
	return nil, false
}

func (p *Action) MustSnapshot() *Snapshot {
	if p.snapshot == nil {
		panic("the snapshot must not be nil, please use Snapshot() function instead")
	}
	return p.snapshot
}

func (p *Action) SetSourceHost(attr *Host) {
	p.sourceHost = attr
}

func (p *Action) SourceHost() (*Host, bool) {
	if p.sourceHost != nil {
		return p.sourceHost, true
	}
	return nil, false
}

func (p *Action) MustSourceHost() *Host {
	if p.sourceHost == nil {
		panic("the sourceHost must not be nil, please use SourceHost() function instead")
	}
	return p.sourceHost
}

func (p *Action) SetSsh(attr *Ssh) {
	p.ssh = attr
}

func (p *Action) Ssh() (*Ssh, bool) {
	if p.ssh != nil {
		return p.ssh, true
	}
	return nil, false
}

func (p *Action) MustSsh() *Ssh {
	if p.ssh == nil {
		panic("the ssh must not be nil, please use Ssh() function instead")
	}
	return p.ssh
}

func (p *Action) SetStatus(attr string) {
	p.status = &attr
}

func (p *Action) Status() (string, bool) {
	if p.status != nil {
		return *p.status, true
	}
	var zero string
	return zero, false
}

func (p *Action) MustStatus() string {
	if p.status == nil {
		panic("the status must not be nil, please use Status() function instead")
	}
	return *p.status
}

func (p *Action) SetStopGlusterService(attr bool) {
	p.stopGlusterService = &attr
}

func (p *Action) StopGlusterService() (bool, bool) {
	if p.stopGlusterService != nil {
		return *p.stopGlusterService, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustStopGlusterService() bool {
	if p.stopGlusterService == nil {
		panic("the stopGlusterService must not be nil, please use StopGlusterService() function instead")
	}
	return *p.stopGlusterService
}

func (p *Action) SetStorageDomain(attr *StorageDomain) {
	p.storageDomain = attr
}

func (p *Action) StorageDomain() (*StorageDomain, bool) {
	if p.storageDomain != nil {
		return p.storageDomain, true
	}
	return nil, false
}

func (p *Action) MustStorageDomain() *StorageDomain {
	if p.storageDomain == nil {
		panic("the storageDomain must not be nil, please use StorageDomain() function instead")
	}
	return p.storageDomain
}

func (p *Action) SetStorageDomains(attr *StorageDomainSlice) {
	p.storageDomains = attr
}

func (p *Action) StorageDomains() (*StorageDomainSlice, bool) {
	if p.storageDomains != nil {
		return p.storageDomains, true
	}
	return nil, false
}

func (p *Action) MustStorageDomains() *StorageDomainSlice {
	if p.storageDomains == nil {
		panic("the storageDomains must not be nil, please use StorageDomains() function instead")
	}
	return p.storageDomains
}

func (p *Action) SetSucceeded(attr bool) {
	p.succeeded = &attr
}

func (p *Action) Succeeded() (bool, bool) {
	if p.succeeded != nil {
		return *p.succeeded, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustSucceeded() bool {
	if p.succeeded == nil {
		panic("the succeeded must not be nil, please use Succeeded() function instead")
	}
	return *p.succeeded
}

func (p *Action) SetSynchronizedNetworkAttachments(attr *NetworkAttachmentSlice) {
	p.synchronizedNetworkAttachments = attr
}

func (p *Action) SynchronizedNetworkAttachments() (*NetworkAttachmentSlice, bool) {
	if p.synchronizedNetworkAttachments != nil {
		return p.synchronizedNetworkAttachments, true
	}
	return nil, false
}

func (p *Action) MustSynchronizedNetworkAttachments() *NetworkAttachmentSlice {
	if p.synchronizedNetworkAttachments == nil {
		panic("the synchronizedNetworkAttachments must not be nil, please use SynchronizedNetworkAttachments() function instead")
	}
	return p.synchronizedNetworkAttachments
}

func (p *Action) SetTemplate(attr *Template) {
	p.template = attr
}

func (p *Action) Template() (*Template, bool) {
	if p.template != nil {
		return p.template, true
	}
	return nil, false
}

func (p *Action) MustTemplate() *Template {
	if p.template == nil {
		panic("the template must not be nil, please use Template() function instead")
	}
	return p.template
}

func (p *Action) SetTicket(attr *Ticket) {
	p.ticket = attr
}

func (p *Action) Ticket() (*Ticket, bool) {
	if p.ticket != nil {
		return p.ticket, true
	}
	return nil, false
}

func (p *Action) MustTicket() *Ticket {
	if p.ticket == nil {
		panic("the ticket must not be nil, please use Ticket() function instead")
	}
	return p.ticket
}

func (p *Action) SetTimeout(attr int64) {
	p.timeout = &attr
}

func (p *Action) Timeout() (int64, bool) {
	if p.timeout != nil {
		return *p.timeout, true
	}
	var zero int64
	return zero, false
}

func (p *Action) MustTimeout() int64 {
	if p.timeout == nil {
		panic("the timeout must not be nil, please use Timeout() function instead")
	}
	return *p.timeout
}

func (p *Action) SetUndeployHostedEngine(attr bool) {
	p.undeployHostedEngine = &attr
}

func (p *Action) UndeployHostedEngine() (bool, bool) {
	if p.undeployHostedEngine != nil {
		return *p.undeployHostedEngine, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustUndeployHostedEngine() bool {
	if p.undeployHostedEngine == nil {
		panic("the undeployHostedEngine must not be nil, please use UndeployHostedEngine() function instead")
	}
	return *p.undeployHostedEngine
}

func (p *Action) SetUpgradeAction(attr ClusterUpgradeAction) {
	p.upgradeAction = &attr
}

func (p *Action) UpgradeAction() (ClusterUpgradeAction, bool) {
	if p.upgradeAction != nil {
		return *p.upgradeAction, true
	}
	var zero ClusterUpgradeAction
	return zero, false
}

func (p *Action) MustUpgradeAction() ClusterUpgradeAction {
	if p.upgradeAction == nil {
		panic("the upgradeAction must not be nil, please use UpgradeAction() function instead")
	}
	return *p.upgradeAction
}

func (p *Action) SetUseCloudInit(attr bool) {
	p.useCloudInit = &attr
}

func (p *Action) UseCloudInit() (bool, bool) {
	if p.useCloudInit != nil {
		return *p.useCloudInit, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustUseCloudInit() bool {
	if p.useCloudInit == nil {
		panic("the useCloudInit must not be nil, please use UseCloudInit() function instead")
	}
	return *p.useCloudInit
}

func (p *Action) SetUseIgnition(attr bool) {
	p.useIgnition = &attr
}

func (p *Action) UseIgnition() (bool, bool) {
	if p.useIgnition != nil {
		return *p.useIgnition, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustUseIgnition() bool {
	if p.useIgnition == nil {
		panic("the useIgnition must not be nil, please use UseIgnition() function instead")
	}
	return *p.useIgnition
}

func (p *Action) SetUseInitialization(attr bool) {
	p.useInitialization = &attr
}

func (p *Action) UseInitialization() (bool, bool) {
	if p.useInitialization != nil {
		return *p.useInitialization, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustUseInitialization() bool {
	if p.useInitialization == nil {
		panic("the useInitialization must not be nil, please use UseInitialization() function instead")
	}
	return *p.useInitialization
}

func (p *Action) SetUseSysprep(attr bool) {
	p.useSysprep = &attr
}

func (p *Action) UseSysprep() (bool, bool) {
	if p.useSysprep != nil {
		return *p.useSysprep, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustUseSysprep() bool {
	if p.useSysprep == nil {
		panic("the useSysprep must not be nil, please use UseSysprep() function instead")
	}
	return *p.useSysprep
}

func (p *Action) SetVirtualFunctionsConfiguration(attr *HostNicVirtualFunctionsConfiguration) {
	p.virtualFunctionsConfiguration = attr
}

func (p *Action) VirtualFunctionsConfiguration() (*HostNicVirtualFunctionsConfiguration, bool) {
	if p.virtualFunctionsConfiguration != nil {
		return p.virtualFunctionsConfiguration, true
	}
	return nil, false
}

func (p *Action) MustVirtualFunctionsConfiguration() *HostNicVirtualFunctionsConfiguration {
	if p.virtualFunctionsConfiguration == nil {
		panic("the virtualFunctionsConfiguration must not be nil, please use VirtualFunctionsConfiguration() function instead")
	}
	return p.virtualFunctionsConfiguration
}

func (p *Action) SetVm(attr *Vm) {
	p.vm = attr
}

func (p *Action) Vm() (*Vm, bool) {
	if p.vm != nil {
		return p.vm, true
	}
	return nil, false
}

func (p *Action) MustVm() *Vm {
	if p.vm == nil {
		panic("the vm must not be nil, please use Vm() function instead")
	}
	return p.vm
}

func (p *Action) SetVnicProfileMappings(attr *VnicProfileMappingSlice) {
	p.vnicProfileMappings = attr
}

func (p *Action) VnicProfileMappings() (*VnicProfileMappingSlice, bool) {
	if p.vnicProfileMappings != nil {
		return p.vnicProfileMappings, true
	}
	return nil, false
}

func (p *Action) MustVnicProfileMappings() *VnicProfileMappingSlice {
	if p.vnicProfileMappings == nil {
		panic("the vnicProfileMappings must not be nil, please use VnicProfileMappings() function instead")
	}
	return p.vnicProfileMappings
}

func (p *Action) SetVolatile(attr bool) {
	p.volatile = &attr
}

func (p *Action) Volatile() (bool, bool) {
	if p.volatile != nil {
		return *p.volatile, true
	}
	var zero bool
	return zero, false
}

func (p *Action) MustVolatile() bool {
	if p.volatile == nil {
		panic("the volatile must not be nil, please use Volatile() function instead")
	}
	return *p.volatile
}

type VmSummarySlice struct {
	href  *string
	slice []*VmSummary
}

func (op *VmSummarySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VmSummarySlice) SetHref(href string) {
	op.href = &href
}

func (op *VmSummarySlice) Slice() []*VmSummary {
	return op.slice
}

func (op *VmSummarySlice) SetSlice(slice []*VmSummary) {
	op.slice = slice
}

type NetworkFilterSlice struct {
	href  *string
	slice []*NetworkFilter
}

func (op *NetworkFilterSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NetworkFilterSlice) SetHref(href string) {
	op.href = &href
}

func (op *NetworkFilterSlice) Slice() []*NetworkFilter {
	return op.slice
}

func (op *NetworkFilterSlice) SetSlice(slice []*NetworkFilter) {
	op.slice = slice
}

type QuotaClusterLimitSlice struct {
	href  *string
	slice []*QuotaClusterLimit
}

func (op *QuotaClusterLimitSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *QuotaClusterLimitSlice) SetHref(href string) {
	op.href = &href
}

func (op *QuotaClusterLimitSlice) Slice() []*QuotaClusterLimit {
	return op.slice
}

func (op *QuotaClusterLimitSlice) SetSlice(slice []*QuotaClusterLimit) {
	op.slice = slice
}

type BiosSlice struct {
	href  *string
	slice []*Bios
}

func (op *BiosSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *BiosSlice) SetHref(href string) {
	op.href = &href
}

func (op *BiosSlice) Slice() []*Bios {
	return op.slice
}

func (op *BiosSlice) SetSlice(slice []*Bios) {
	op.slice = slice
}

type QuotaSlice struct {
	href  *string
	slice []*Quota
}

func (op *QuotaSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *QuotaSlice) SetHref(href string) {
	op.href = &href
}

func (op *QuotaSlice) Slice() []*Quota {
	return op.slice
}

func (op *QuotaSlice) SetSlice(slice []*Quota) {
	op.slice = slice
}

type MigrationOptionsSlice struct {
	href  *string
	slice []*MigrationOptions
}

func (op *MigrationOptionsSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *MigrationOptionsSlice) SetHref(href string) {
	op.href = &href
}

func (op *MigrationOptionsSlice) Slice() []*MigrationOptions {
	return op.slice
}

func (op *MigrationOptionsSlice) SetSlice(slice []*MigrationOptions) {
	op.slice = slice
}

type RangeSlice struct {
	href  *string
	slice []*Range
}

func (op *RangeSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RangeSlice) SetHref(href string) {
	op.href = &href
}

func (op *RangeSlice) Slice() []*Range {
	return op.slice
}

func (op *RangeSlice) SetSlice(slice []*Range) {
	op.slice = slice
}

type VirtualNumaNodeSlice struct {
	href  *string
	slice []*VirtualNumaNode
}

func (op *VirtualNumaNodeSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VirtualNumaNodeSlice) SetHref(href string) {
	op.href = &href
}

func (op *VirtualNumaNodeSlice) Slice() []*VirtualNumaNode {
	return op.slice
}

func (op *VirtualNumaNodeSlice) SetSlice(slice []*VirtualNumaNode) {
	op.slice = slice
}

type UserSlice struct {
	href  *string
	slice []*User
}

func (op *UserSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *UserSlice) SetHref(href string) {
	op.href = &href
}

func (op *UserSlice) Slice() []*User {
	return op.slice
}

func (op *UserSlice) SetSlice(slice []*User) {
	op.slice = slice
}

type SshSlice struct {
	href  *string
	slice []*Ssh
}

func (op *SshSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SshSlice) SetHref(href string) {
	op.href = &href
}

func (op *SshSlice) Slice() []*Ssh {
	return op.slice
}

func (op *SshSlice) SetSlice(slice []*Ssh) {
	op.slice = slice
}

type RoleSlice struct {
	href  *string
	slice []*Role
}

func (op *RoleSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RoleSlice) SetHref(href string) {
	op.href = &href
}

func (op *RoleSlice) Slice() []*Role {
	return op.slice
}

func (op *RoleSlice) SetSlice(slice []*Role) {
	op.slice = slice
}

type ProductSlice struct {
	href  *string
	slice []*Product
}

func (op *ProductSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ProductSlice) SetHref(href string) {
	op.href = &href
}

func (op *ProductSlice) Slice() []*Product {
	return op.slice
}

func (op *ProductSlice) SetSlice(slice []*Product) {
	op.slice = slice
}

type OpenStackVolumeTypeSlice struct {
	href  *string
	slice []*OpenStackVolumeType
}

func (op *OpenStackVolumeTypeSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OpenStackVolumeTypeSlice) SetHref(href string) {
	op.href = &href
}

func (op *OpenStackVolumeTypeSlice) Slice() []*OpenStackVolumeType {
	return op.slice
}

func (op *OpenStackVolumeTypeSlice) SetSlice(slice []*OpenStackVolumeType) {
	op.slice = slice
}

type BootMenuSlice struct {
	href  *string
	slice []*BootMenu
}

func (op *BootMenuSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *BootMenuSlice) SetHref(href string) {
	op.href = &href
}

func (op *BootMenuSlice) Slice() []*BootMenu {
	return op.slice
}

func (op *BootMenuSlice) SetSlice(slice []*BootMenu) {
	op.slice = slice
}

type VersionSlice struct {
	href  *string
	slice []*Version
}

func (op *VersionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VersionSlice) SetHref(href string) {
	op.href = &href
}

func (op *VersionSlice) Slice() []*Version {
	return op.slice
}

func (op *VersionSlice) SetSlice(slice []*Version) {
	op.slice = slice
}

type WatchdogSlice struct {
	href  *string
	slice []*Watchdog
}

func (op *WatchdogSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *WatchdogSlice) SetHref(href string) {
	op.href = &href
}

func (op *WatchdogSlice) Slice() []*Watchdog {
	return op.slice
}

func (op *WatchdogSlice) SetSlice(slice []*Watchdog) {
	op.slice = slice
}

type StorageDomainSlice struct {
	href  *string
	slice []*StorageDomain
}

func (op *StorageDomainSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *StorageDomainSlice) SetHref(href string) {
	op.href = &href
}

func (op *StorageDomainSlice) Slice() []*StorageDomain {
	return op.slice
}

func (op *StorageDomainSlice) SetSlice(slice []*StorageDomain) {
	op.slice = slice
}

type KatelloErratumSlice struct {
	href  *string
	slice []*KatelloErratum
}

func (op *KatelloErratumSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *KatelloErratumSlice) SetHref(href string) {
	op.href = &href
}

func (op *KatelloErratumSlice) Slice() []*KatelloErratum {
	return op.slice
}

func (op *KatelloErratumSlice) SetSlice(slice []*KatelloErratum) {
	op.slice = slice
}

type MemoryOverCommitSlice struct {
	href  *string
	slice []*MemoryOverCommit
}

func (op *MemoryOverCommitSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *MemoryOverCommitSlice) SetHref(href string) {
	op.href = &href
}

func (op *MemoryOverCommitSlice) Slice() []*MemoryOverCommit {
	return op.slice
}

func (op *MemoryOverCommitSlice) SetSlice(slice []*MemoryOverCommit) {
	op.slice = slice
}

type MDevTypeSlice struct {
	href  *string
	slice []*MDevType
}

func (op *MDevTypeSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *MDevTypeSlice) SetHref(href string) {
	op.href = &href
}

func (op *MDevTypeSlice) Slice() []*MDevType {
	return op.slice
}

func (op *MDevTypeSlice) SetSlice(slice []*MDevType) {
	op.slice = slice
}

type TemplateVersionSlice struct {
	href  *string
	slice []*TemplateVersion
}

func (op *TemplateVersionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *TemplateVersionSlice) SetHref(href string) {
	op.href = &href
}

func (op *TemplateVersionSlice) Slice() []*TemplateVersion {
	return op.slice
}

func (op *TemplateVersionSlice) SetSlice(slice []*TemplateVersion) {
	op.slice = slice
}

type StorageConnectionExtensionSlice struct {
	href  *string
	slice []*StorageConnectionExtension
}

func (op *StorageConnectionExtensionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *StorageConnectionExtensionSlice) SetHref(href string) {
	op.href = &href
}

func (op *StorageConnectionExtensionSlice) Slice() []*StorageConnectionExtension {
	return op.slice
}

func (op *StorageConnectionExtensionSlice) SetSlice(slice []*StorageConnectionExtension) {
	op.slice = slice
}

type CoreSlice struct {
	href  *string
	slice []*Core
}

func (op *CoreSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CoreSlice) SetHref(href string) {
	op.href = &href
}

func (op *CoreSlice) Slice() []*Core {
	return op.slice
}

func (op *CoreSlice) SetSlice(slice []*Core) {
	op.slice = slice
}

type VcpuPinSlice struct {
	href  *string
	slice []*VcpuPin
}

func (op *VcpuPinSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VcpuPinSlice) SetHref(href string) {
	op.href = &href
}

func (op *VcpuPinSlice) Slice() []*VcpuPin {
	return op.slice
}

func (op *VcpuPinSlice) SetSlice(slice []*VcpuPin) {
	op.slice = slice
}

type TemplateSlice struct {
	href  *string
	slice []*Template
}

func (op *TemplateSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *TemplateSlice) SetHref(href string) {
	op.href = &href
}

func (op *TemplateSlice) Slice() []*Template {
	return op.slice
}

func (op *TemplateSlice) SetSlice(slice []*Template) {
	op.slice = slice
}

type NfsProfileDetailSlice struct {
	href  *string
	slice []*NfsProfileDetail
}

func (op *NfsProfileDetailSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NfsProfileDetailSlice) SetHref(href string) {
	op.href = &href
}

func (op *NfsProfileDetailSlice) Slice() []*NfsProfileDetail {
	return op.slice
}

func (op *NfsProfileDetailSlice) SetSlice(slice []*NfsProfileDetail) {
	op.slice = slice
}

type BrickProfileDetailSlice struct {
	href  *string
	slice []*BrickProfileDetail
}

func (op *BrickProfileDetailSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *BrickProfileDetailSlice) SetHref(href string) {
	op.href = &href
}

func (op *BrickProfileDetailSlice) Slice() []*BrickProfileDetail {
	return op.slice
}

func (op *BrickProfileDetailSlice) SetSlice(slice []*BrickProfileDetail) {
	op.slice = slice
}

type FloppySlice struct {
	href  *string
	slice []*Floppy
}

func (op *FloppySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *FloppySlice) SetHref(href string) {
	op.href = &href
}

func (op *FloppySlice) Slice() []*Floppy {
	return op.slice
}

func (op *FloppySlice) SetSlice(slice []*Floppy) {
	op.slice = slice
}

type MacPoolSlice struct {
	href  *string
	slice []*MacPool
}

func (op *MacPoolSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *MacPoolSlice) SetHref(href string) {
	op.href = &href
}

func (op *MacPoolSlice) Slice() []*MacPool {
	return op.slice
}

func (op *MacPoolSlice) SetSlice(slice []*MacPool) {
	op.slice = slice
}

type VmPlacementPolicySlice struct {
	href  *string
	slice []*VmPlacementPolicy
}

func (op *VmPlacementPolicySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VmPlacementPolicySlice) SetHref(href string) {
	op.href = &href
}

func (op *VmPlacementPolicySlice) Slice() []*VmPlacementPolicy {
	return op.slice
}

func (op *VmPlacementPolicySlice) SetSlice(slice []*VmPlacementPolicy) {
	op.slice = slice
}

type ProductInfoSlice struct {
	href  *string
	slice []*ProductInfo
}

func (op *ProductInfoSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ProductInfoSlice) SetHref(href string) {
	op.href = &href
}

func (op *ProductInfoSlice) Slice() []*ProductInfo {
	return op.slice
}

func (op *ProductInfoSlice) SetSlice(slice []*ProductInfo) {
	op.slice = slice
}

type CpuTuneSlice struct {
	href  *string
	slice []*CpuTune
}

func (op *CpuTuneSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CpuTuneSlice) SetHref(href string) {
	op.href = &href
}

func (op *CpuTuneSlice) Slice() []*CpuTune {
	return op.slice
}

func (op *CpuTuneSlice) SetSlice(slice []*CpuTune) {
	op.slice = slice
}

type AffinityRuleSlice struct {
	href  *string
	slice []*AffinityRule
}

func (op *AffinityRuleSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *AffinityRuleSlice) SetHref(href string) {
	op.href = &href
}

func (op *AffinityRuleSlice) Slice() []*AffinityRule {
	return op.slice
}

func (op *AffinityRuleSlice) SetSlice(slice []*AffinityRule) {
	op.slice = slice
}

type HostNicSlice struct {
	href  *string
	slice []*HostNic
}

func (op *HostNicSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HostNicSlice) SetHref(href string) {
	op.href = &href
}

func (op *HostNicSlice) Slice() []*HostNic {
	return op.slice
}

func (op *HostNicSlice) SetSlice(slice []*HostNic) {
	op.slice = slice
}

type CustomPropertySlice struct {
	href  *string
	slice []*CustomProperty
}

func (op *CustomPropertySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CustomPropertySlice) SetHref(href string) {
	op.href = &href
}

func (op *CustomPropertySlice) Slice() []*CustomProperty {
	return op.slice
}

func (op *CustomPropertySlice) SetSlice(slice []*CustomProperty) {
	op.slice = slice
}

type PortMirroringSlice struct {
	href  *string
	slice []*PortMirroring
}

func (op *PortMirroringSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *PortMirroringSlice) SetHref(href string) {
	op.href = &href
}

func (op *PortMirroringSlice) Slice() []*PortMirroring {
	return op.slice
}

func (op *PortMirroringSlice) SetSlice(slice []*PortMirroring) {
	op.slice = slice
}

type BookmarkSlice struct {
	href  *string
	slice []*Bookmark
}

func (op *BookmarkSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *BookmarkSlice) SetHref(href string) {
	op.href = &href
}

func (op *BookmarkSlice) Slice() []*Bookmark {
	return op.slice
}

func (op *BookmarkSlice) SetSlice(slice []*Bookmark) {
	op.slice = slice
}

type RegistrationAffinityGroupMappingSlice struct {
	href  *string
	slice []*RegistrationAffinityGroupMapping
}

func (op *RegistrationAffinityGroupMappingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RegistrationAffinityGroupMappingSlice) SetHref(href string) {
	op.href = &href
}

func (op *RegistrationAffinityGroupMappingSlice) Slice() []*RegistrationAffinityGroupMapping {
	return op.slice
}

func (op *RegistrationAffinityGroupMappingSlice) SetSlice(slice []*RegistrationAffinityGroupMapping) {
	op.slice = slice
}

type ProfileDetailSlice struct {
	href  *string
	slice []*ProfileDetail
}

func (op *ProfileDetailSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ProfileDetailSlice) SetHref(href string) {
	op.href = &href
}

func (op *ProfileDetailSlice) Slice() []*ProfileDetail {
	return op.slice
}

func (op *ProfileDetailSlice) SetSlice(slice []*ProfileDetail) {
	op.slice = slice
}

type TimeZoneSlice struct {
	href  *string
	slice []*TimeZone
}

func (op *TimeZoneSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *TimeZoneSlice) SetHref(href string) {
	op.href = &href
}

func (op *TimeZoneSlice) Slice() []*TimeZone {
	return op.slice
}

func (op *TimeZoneSlice) SetSlice(slice []*TimeZone) {
	op.slice = slice
}

type EventSlice struct {
	href  *string
	slice []*Event
}

func (op *EventSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *EventSlice) SetHref(href string) {
	op.href = &href
}

func (op *EventSlice) Slice() []*Event {
	return op.slice
}

func (op *EventSlice) SetSlice(slice []*Event) {
	op.slice = slice
}

type FileSlice struct {
	href  *string
	slice []*File
}

func (op *FileSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *FileSlice) SetHref(href string) {
	op.href = &href
}

func (op *FileSlice) Slice() []*File {
	return op.slice
}

func (op *FileSlice) SetSlice(slice []*File) {
	op.slice = slice
}

type LogicalUnitSlice struct {
	href  *string
	slice []*LogicalUnit
}

func (op *LogicalUnitSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *LogicalUnitSlice) SetHref(href string) {
	op.href = &href
}

func (op *LogicalUnitSlice) Slice() []*LogicalUnit {
	return op.slice
}

func (op *LogicalUnitSlice) SetSlice(slice []*LogicalUnit) {
	op.slice = slice
}

type ApplicationSlice struct {
	href  *string
	slice []*Application
}

func (op *ApplicationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ApplicationSlice) SetHref(href string) {
	op.href = &href
}

func (op *ApplicationSlice) Slice() []*Application {
	return op.slice
}

func (op *ApplicationSlice) SetSlice(slice []*Application) {
	op.slice = slice
}

type ImageTransferSlice struct {
	href  *string
	slice []*ImageTransfer
}

func (op *ImageTransferSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ImageTransferSlice) SetHref(href string) {
	op.href = &href
}

func (op *ImageTransferSlice) Slice() []*ImageTransfer {
	return op.slice
}

func (op *ImageTransferSlice) SetSlice(slice []*ImageTransfer) {
	op.slice = slice
}

type IpSlice struct {
	href  *string
	slice []*Ip
}

func (op *IpSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *IpSlice) SetHref(href string) {
	op.href = &href
}

func (op *IpSlice) Slice() []*Ip {
	return op.slice
}

func (op *IpSlice) SetSlice(slice []*Ip) {
	op.slice = slice
}

type VnicProfileMappingSlice struct {
	href  *string
	slice []*VnicProfileMapping
}

func (op *VnicProfileMappingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VnicProfileMappingSlice) SetHref(href string) {
	op.href = &href
}

func (op *VnicProfileMappingSlice) Slice() []*VnicProfileMapping {
	return op.slice
}

func (op *VnicProfileMappingSlice) SetSlice(slice []*VnicProfileMapping) {
	op.slice = slice
}

type SystemOptionSlice struct {
	href  *string
	slice []*SystemOption
}

func (op *SystemOptionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SystemOptionSlice) SetHref(href string) {
	op.href = &href
}

func (op *SystemOptionSlice) Slice() []*SystemOption {
	return op.slice
}

func (op *SystemOptionSlice) SetSlice(slice []*SystemOption) {
	op.slice = slice
}

type GlusterBrickSlice struct {
	href  *string
	slice []*GlusterBrick
}

func (op *GlusterBrickSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GlusterBrickSlice) SetHref(href string) {
	op.href = &href
}

func (op *GlusterBrickSlice) Slice() []*GlusterBrick {
	return op.slice
}

func (op *GlusterBrickSlice) SetSlice(slice []*GlusterBrick) {
	op.slice = slice
}

type OpenStackProviderSlice struct {
	href  *string
	slice []*OpenStackProvider
}

func (op *OpenStackProviderSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OpenStackProviderSlice) SetHref(href string) {
	op.href = &href
}

func (op *OpenStackProviderSlice) Slice() []*OpenStackProvider {
	return op.slice
}

func (op *OpenStackProviderSlice) SetSlice(slice []*OpenStackProvider) {
	op.slice = slice
}

type RegistrationClusterMappingSlice struct {
	href  *string
	slice []*RegistrationClusterMapping
}

func (op *RegistrationClusterMappingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RegistrationClusterMappingSlice) SetHref(href string) {
	op.href = &href
}

func (op *RegistrationClusterMappingSlice) Slice() []*RegistrationClusterMapping {
	return op.slice
}

func (op *RegistrationClusterMappingSlice) SetSlice(slice []*RegistrationClusterMapping) {
	op.slice = slice
}

type SystemOptionValueSlice struct {
	href  *string
	slice []*SystemOptionValue
}

func (op *SystemOptionValueSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SystemOptionValueSlice) SetHref(href string) {
	op.href = &href
}

func (op *SystemOptionValueSlice) Slice() []*SystemOptionValue {
	return op.slice
}

func (op *SystemOptionValueSlice) SetSlice(slice []*SystemOptionValue) {
	op.slice = slice
}

type BondingSlice struct {
	href  *string
	slice []*Bonding
}

func (op *BondingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *BondingSlice) SetHref(href string) {
	op.href = &href
}

func (op *BondingSlice) Slice() []*Bonding {
	return op.slice
}

func (op *BondingSlice) SetSlice(slice []*Bonding) {
	op.slice = slice
}

type SeLinuxSlice struct {
	href  *string
	slice []*SeLinux
}

func (op *SeLinuxSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SeLinuxSlice) SetHref(href string) {
	op.href = &href
}

func (op *SeLinuxSlice) Slice() []*SeLinux {
	return op.slice
}

func (op *SeLinuxSlice) SetSlice(slice []*SeLinux) {
	op.slice = slice
}

type ApiSlice struct {
	href  *string
	slice []*Api
}

func (op *ApiSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ApiSlice) SetHref(href string) {
	op.href = &href
}

func (op *ApiSlice) Slice() []*Api {
	return op.slice
}

func (op *ApiSlice) SetSlice(slice []*Api) {
	op.slice = slice
}

type MemoryPolicySlice struct {
	href  *string
	slice []*MemoryPolicy
}

func (op *MemoryPolicySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *MemoryPolicySlice) SetHref(href string) {
	op.href = &href
}

func (op *MemoryPolicySlice) Slice() []*MemoryPolicy {
	return op.slice
}

func (op *MemoryPolicySlice) SetSlice(slice []*MemoryPolicy) {
	op.slice = slice
}

type OpenStackNetworkSlice struct {
	href  *string
	slice []*OpenStackNetwork
}

func (op *OpenStackNetworkSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OpenStackNetworkSlice) SetHref(href string) {
	op.href = &href
}

func (op *OpenStackNetworkSlice) Slice() []*OpenStackNetwork {
	return op.slice
}

func (op *OpenStackNetworkSlice) SetSlice(slice []*OpenStackNetwork) {
	op.slice = slice
}

type VmSlice struct {
	href  *string
	slice []*Vm
}

func (op *VmSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VmSlice) SetHref(href string) {
	op.href = &href
}

func (op *VmSlice) Slice() []*Vm {
	return op.slice
}

func (op *VmSlice) SetSlice(slice []*Vm) {
	op.slice = slice
}

type ExternalHostGroupSlice struct {
	href  *string
	slice []*ExternalHostGroup
}

func (op *ExternalHostGroupSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ExternalHostGroupSlice) SetHref(href string) {
	op.href = &href
}

func (op *ExternalHostGroupSlice) Slice() []*ExternalHostGroup {
	return op.slice
}

func (op *ExternalHostGroupSlice) SetSlice(slice []*ExternalHostGroup) {
	op.slice = slice
}

type ExternalComputeResourceSlice struct {
	href  *string
	slice []*ExternalComputeResource
}

func (op *ExternalComputeResourceSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ExternalComputeResourceSlice) SetHref(href string) {
	op.href = &href
}

func (op *ExternalComputeResourceSlice) Slice() []*ExternalComputeResource {
	return op.slice
}

func (op *ExternalComputeResourceSlice) SetSlice(slice []*ExternalComputeResource) {
	op.slice = slice
}

type OpenStackVolumeProviderSlice struct {
	href  *string
	slice []*OpenStackVolumeProvider
}

func (op *OpenStackVolumeProviderSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OpenStackVolumeProviderSlice) SetHref(href string) {
	op.href = &href
}

func (op *OpenStackVolumeProviderSlice) Slice() []*OpenStackVolumeProvider {
	return op.slice
}

func (op *OpenStackVolumeProviderSlice) SetSlice(slice []*OpenStackVolumeProvider) {
	op.slice = slice
}

type StepSlice struct {
	href  *string
	slice []*Step
}

func (op *StepSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *StepSlice) SetHref(href string) {
	op.href = &href
}

func (op *StepSlice) Slice() []*Step {
	return op.slice
}

func (op *StepSlice) SetSlice(slice []*Step) {
	op.slice = slice
}

type OpenStackNetworkProviderSlice struct {
	href  *string
	slice []*OpenStackNetworkProvider
}

func (op *OpenStackNetworkProviderSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OpenStackNetworkProviderSlice) SetHref(href string) {
	op.href = &href
}

func (op *OpenStackNetworkProviderSlice) Slice() []*OpenStackNetworkProvider {
	return op.slice
}

func (op *OpenStackNetworkProviderSlice) SetSlice(slice []*OpenStackNetworkProvider) {
	op.slice = slice
}

type HookSlice struct {
	href  *string
	slice []*Hook
}

func (op *HookSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HookSlice) SetHref(href string) {
	op.href = &href
}

func (op *HookSlice) Slice() []*Hook {
	return op.slice
}

func (op *HookSlice) SetSlice(slice []*Hook) {
	op.slice = slice
}

type ConfigurationSlice struct {
	href  *string
	slice []*Configuration
}

func (op *ConfigurationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ConfigurationSlice) SetHref(href string) {
	op.href = &href
}

func (op *ConfigurationSlice) Slice() []*Configuration {
	return op.slice
}

func (op *ConfigurationSlice) SetSlice(slice []*Configuration) {
	op.slice = slice
}

type OperatingSystemInfoSlice struct {
	href  *string
	slice []*OperatingSystemInfo
}

func (op *OperatingSystemInfoSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OperatingSystemInfoSlice) SetHref(href string) {
	op.href = &href
}

func (op *OperatingSystemInfoSlice) Slice() []*OperatingSystemInfo {
	return op.slice
}

func (op *OperatingSystemInfoSlice) SetSlice(slice []*OperatingSystemInfo) {
	op.slice = slice
}

type RegistrationLunMappingSlice struct {
	href  *string
	slice []*RegistrationLunMapping
}

func (op *RegistrationLunMappingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RegistrationLunMappingSlice) SetHref(href string) {
	op.href = &href
}

func (op *RegistrationLunMappingSlice) Slice() []*RegistrationLunMapping {
	return op.slice
}

func (op *RegistrationLunMappingSlice) SetSlice(slice []*RegistrationLunMapping) {
	op.slice = slice
}

type DeviceSlice struct {
	href  *string
	slice []*Device
}

func (op *DeviceSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DeviceSlice) SetHref(href string) {
	op.href = &href
}

func (op *DeviceSlice) Slice() []*Device {
	return op.slice
}

func (op *DeviceSlice) SetSlice(slice []*Device) {
	op.slice = slice
}

type NumaNodePinSlice struct {
	href  *string
	slice []*NumaNodePin
}

func (op *NumaNodePinSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NumaNodePinSlice) SetHref(href string) {
	op.href = &href
}

func (op *NumaNodePinSlice) Slice() []*NumaNodePin {
	return op.slice
}

func (op *NumaNodePinSlice) SetSlice(slice []*NumaNodePin) {
	op.slice = slice
}

type ReportedDeviceSlice struct {
	href  *string
	slice []*ReportedDevice
}

func (op *ReportedDeviceSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ReportedDeviceSlice) SetHref(href string) {
	op.href = &href
}

func (op *ReportedDeviceSlice) Slice() []*ReportedDevice {
	return op.slice
}

func (op *ReportedDeviceSlice) SetSlice(slice []*ReportedDevice) {
	op.slice = slice
}

type HostDevicePassthroughSlice struct {
	href  *string
	slice []*HostDevicePassthrough
}

func (op *HostDevicePassthroughSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HostDevicePassthroughSlice) SetHref(href string) {
	op.href = &href
}

func (op *HostDevicePassthroughSlice) Slice() []*HostDevicePassthrough {
	return op.slice
}

func (op *HostDevicePassthroughSlice) SetSlice(slice []*HostDevicePassthrough) {
	op.slice = slice
}

type AgentSlice struct {
	href  *string
	slice []*Agent
}

func (op *AgentSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *AgentSlice) SetHref(href string) {
	op.href = &href
}

func (op *AgentSlice) Slice() []*Agent {
	return op.slice
}

func (op *AgentSlice) SetSlice(slice []*Agent) {
	op.slice = slice
}

type SerialNumberSlice struct {
	href  *string
	slice []*SerialNumber
}

func (op *SerialNumberSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SerialNumberSlice) SetHref(href string) {
	op.href = &href
}

func (op *SerialNumberSlice) Slice() []*SerialNumber {
	return op.slice
}

func (op *SerialNumberSlice) SetSlice(slice []*SerialNumber) {
	op.slice = slice
}

type UsbSlice struct {
	href  *string
	slice []*Usb
}

func (op *UsbSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *UsbSlice) SetHref(href string) {
	op.href = &href
}

func (op *UsbSlice) Slice() []*Usb {
	return op.slice
}

func (op *UsbSlice) SetSlice(slice []*Usb) {
	op.slice = slice
}

type RegistrationDomainMappingSlice struct {
	href  *string
	slice []*RegistrationDomainMapping
}

func (op *RegistrationDomainMappingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RegistrationDomainMappingSlice) SetHref(href string) {
	op.href = &href
}

func (op *RegistrationDomainMappingSlice) Slice() []*RegistrationDomainMapping {
	return op.slice
}

func (op *RegistrationDomainMappingSlice) SetSlice(slice []*RegistrationDomainMapping) {
	op.slice = slice
}

type GroupSlice struct {
	href  *string
	slice []*Group
}

func (op *GroupSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GroupSlice) SetHref(href string) {
	op.href = &href
}

func (op *GroupSlice) Slice() []*Group {
	return op.slice
}

func (op *GroupSlice) SetSlice(slice []*Group) {
	op.slice = slice
}

type RateSlice struct {
	href  *string
	slice []*Rate
}

func (op *RateSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RateSlice) SetHref(href string) {
	op.href = &href
}

func (op *RateSlice) Slice() []*Rate {
	return op.slice
}

func (op *RateSlice) SetSlice(slice []*Rate) {
	op.slice = slice
}

type AffinityLabelSlice struct {
	href  *string
	slice []*AffinityLabel
}

func (op *AffinityLabelSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *AffinityLabelSlice) SetHref(href string) {
	op.href = &href
}

func (op *AffinityLabelSlice) Slice() []*AffinityLabel {
	return op.slice
}

func (op *AffinityLabelSlice) SetSlice(slice []*AffinityLabel) {
	op.slice = slice
}

type HostNicVirtualFunctionsConfigurationSlice struct {
	href  *string
	slice []*HostNicVirtualFunctionsConfiguration
}

func (op *HostNicVirtualFunctionsConfigurationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HostNicVirtualFunctionsConfigurationSlice) SetHref(href string) {
	op.href = &href
}

func (op *HostNicVirtualFunctionsConfigurationSlice) Slice() []*HostNicVirtualFunctionsConfiguration {
	return op.slice
}

func (op *HostNicVirtualFunctionsConfigurationSlice) SetSlice(slice []*HostNicVirtualFunctionsConfiguration) {
	op.slice = slice
}

type OpenStackImageSlice struct {
	href  *string
	slice []*OpenStackImage
}

func (op *OpenStackImageSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OpenStackImageSlice) SetHref(href string) {
	op.href = &href
}

func (op *OpenStackImageSlice) Slice() []*OpenStackImage {
	return op.slice
}

func (op *OpenStackImageSlice) SetSlice(slice []*OpenStackImage) {
	op.slice = slice
}

type KernelSlice struct {
	href  *string
	slice []*Kernel
}

func (op *KernelSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *KernelSlice) SetHref(href string) {
	op.href = &href
}

func (op *KernelSlice) Slice() []*Kernel {
	return op.slice
}

func (op *KernelSlice) SetSlice(slice []*Kernel) {
	op.slice = slice
}

type ExternalHostProviderSlice struct {
	href  *string
	slice []*ExternalHostProvider
}

func (op *ExternalHostProviderSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ExternalHostProviderSlice) SetHref(href string) {
	op.href = &href
}

func (op *ExternalHostProviderSlice) Slice() []*ExternalHostProvider {
	return op.slice
}

func (op *ExternalHostProviderSlice) SetSlice(slice []*ExternalHostProvider) {
	op.slice = slice
}

type SsoSlice struct {
	href  *string
	slice []*Sso
}

func (op *SsoSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SsoSlice) SetHref(href string) {
	op.href = &href
}

func (op *SsoSlice) Slice() []*Sso {
	return op.slice
}

func (op *SsoSlice) SetSlice(slice []*Sso) {
	op.slice = slice
}

type IscsiDetailsSlice struct {
	href  *string
	slice []*IscsiDetails
}

func (op *IscsiDetailsSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *IscsiDetailsSlice) SetHref(href string) {
	op.href = &href
}

func (op *IscsiDetailsSlice) Slice() []*IscsiDetails {
	return op.slice
}

func (op *IscsiDetailsSlice) SetSlice(slice []*IscsiDetails) {
	op.slice = slice
}

type DnsResolverConfigurationSlice struct {
	href  *string
	slice []*DnsResolverConfiguration
}

func (op *DnsResolverConfigurationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DnsResolverConfigurationSlice) SetHref(href string) {
	op.href = &href
}

func (op *DnsResolverConfigurationSlice) Slice() []*DnsResolverConfiguration {
	return op.slice
}

func (op *DnsResolverConfigurationSlice) SetSlice(slice []*DnsResolverConfiguration) {
	op.slice = slice
}

type MethodSlice struct {
	href  *string
	slice []*Method
}

func (op *MethodSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *MethodSlice) SetHref(href string) {
	op.href = &href
}

func (op *MethodSlice) Slice() []*Method {
	return op.slice
}

func (op *MethodSlice) SetSlice(slice []*Method) {
	op.slice = slice
}

type DataCenterSlice struct {
	href  *string
	slice []*DataCenter
}

func (op *DataCenterSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DataCenterSlice) SetHref(href string) {
	op.href = &href
}

func (op *DataCenterSlice) Slice() []*DataCenter {
	return op.slice
}

func (op *DataCenterSlice) SetSlice(slice []*DataCenter) {
	op.slice = slice
}

type RegistrationRoleMappingSlice struct {
	href  *string
	slice []*RegistrationRoleMapping
}

func (op *RegistrationRoleMappingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RegistrationRoleMappingSlice) SetHref(href string) {
	op.href = &href
}

func (op *RegistrationRoleMappingSlice) Slice() []*RegistrationRoleMapping {
	return op.slice
}

func (op *RegistrationRoleMappingSlice) SetSlice(slice []*RegistrationRoleMapping) {
	op.slice = slice
}

type FopStatisticSlice struct {
	href  *string
	slice []*FopStatistic
}

func (op *FopStatisticSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *FopStatisticSlice) SetHref(href string) {
	op.href = &href
}

func (op *FopStatisticSlice) Slice() []*FopStatistic {
	return op.slice
}

func (op *FopStatisticSlice) SetSlice(slice []*FopStatistic) {
	op.slice = slice
}

type IdentifiedSlice struct {
	href  *string
	slice []*Identified
}

func (op *IdentifiedSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *IdentifiedSlice) SetHref(href string) {
	op.href = &href
}

func (op *IdentifiedSlice) Slice() []*Identified {
	return op.slice
}

func (op *IdentifiedSlice) SetSlice(slice []*Identified) {
	op.slice = slice
}

type EntityProfileDetailSlice struct {
	href  *string
	slice []*EntityProfileDetail
}

func (op *EntityProfileDetailSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *EntityProfileDetailSlice) SetHref(href string) {
	op.href = &href
}

func (op *EntityProfileDetailSlice) Slice() []*EntityProfileDetail {
	return op.slice
}

func (op *EntityProfileDetailSlice) SetSlice(slice []*EntityProfileDetail) {
	op.slice = slice
}

type WeightSlice struct {
	href  *string
	slice []*Weight
}

func (op *WeightSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *WeightSlice) SetHref(href string) {
	op.href = &href
}

func (op *WeightSlice) Slice() []*Weight {
	return op.slice
}

func (op *WeightSlice) SetSlice(slice []*Weight) {
	op.slice = slice
}

type GlusterVolumeSlice struct {
	href  *string
	slice []*GlusterVolume
}

func (op *GlusterVolumeSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GlusterVolumeSlice) SetHref(href string) {
	op.href = &href
}

func (op *GlusterVolumeSlice) Slice() []*GlusterVolume {
	return op.slice
}

func (op *GlusterVolumeSlice) SetSlice(slice []*GlusterVolume) {
	op.slice = slice
}

type StorageConnectionSlice struct {
	href  *string
	slice []*StorageConnection
}

func (op *StorageConnectionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *StorageConnectionSlice) SetHref(href string) {
	op.href = &href
}

func (op *StorageConnectionSlice) Slice() []*StorageConnection {
	return op.slice
}

func (op *StorageConnectionSlice) SetSlice(slice []*StorageConnection) {
	op.slice = slice
}

type NetworkFilterParameterSlice struct {
	href  *string
	slice []*NetworkFilterParameter
}

func (op *NetworkFilterParameterSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NetworkFilterParameterSlice) SetHref(href string) {
	op.href = &href
}

func (op *NetworkFilterParameterSlice) Slice() []*NetworkFilterParameter {
	return op.slice
}

func (op *NetworkFilterParameterSlice) SetSlice(slice []*NetworkFilterParameter) {
	op.slice = slice
}

type OpenStackSubnetSlice struct {
	href  *string
	slice []*OpenStackSubnet
}

func (op *OpenStackSubnetSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OpenStackSubnetSlice) SetHref(href string) {
	op.href = &href
}

func (op *OpenStackSubnetSlice) Slice() []*OpenStackSubnet {
	return op.slice
}

func (op *OpenStackSubnetSlice) SetSlice(slice []*OpenStackSubnet) {
	op.slice = slice
}

type TagSlice struct {
	href  *string
	slice []*Tag
}

func (op *TagSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *TagSlice) SetHref(href string) {
	op.href = &href
}

func (op *TagSlice) Slice() []*Tag {
	return op.slice
}

func (op *TagSlice) SetSlice(slice []*Tag) {
	op.slice = slice
}

type AuthorizedKeySlice struct {
	href  *string
	slice []*AuthorizedKey
}

func (op *AuthorizedKeySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *AuthorizedKeySlice) SetHref(href string) {
	op.href = &href
}

func (op *AuthorizedKeySlice) Slice() []*AuthorizedKey {
	return op.slice
}

func (op *AuthorizedKeySlice) SetSlice(slice []*AuthorizedKey) {
	op.slice = slice
}

type VnicProfileSlice struct {
	href  *string
	slice []*VnicProfile
}

func (op *VnicProfileSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VnicProfileSlice) SetHref(href string) {
	op.href = &href
}

func (op *VnicProfileSlice) Slice() []*VnicProfile {
	return op.slice
}

func (op *VnicProfileSlice) SetSlice(slice []*VnicProfile) {
	op.slice = slice
}

type GraphicsConsoleSlice struct {
	href  *string
	slice []*GraphicsConsole
}

func (op *GraphicsConsoleSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GraphicsConsoleSlice) SetHref(href string) {
	op.href = &href
}

func (op *GraphicsConsoleSlice) Slice() []*GraphicsConsole {
	return op.slice
}

func (op *GraphicsConsoleSlice) SetSlice(slice []*GraphicsConsole) {
	op.slice = slice
}

type IconSlice struct {
	href  *string
	slice []*Icon
}

func (op *IconSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *IconSlice) SetHref(href string) {
	op.href = &href
}

func (op *IconSlice) Slice() []*Icon {
	return op.slice
}

func (op *IconSlice) SetSlice(slice []*Icon) {
	op.slice = slice
}

type DiskProfileSlice struct {
	href  *string
	slice []*DiskProfile
}

func (op *DiskProfileSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DiskProfileSlice) SetHref(href string) {
	op.href = &href
}

func (op *DiskProfileSlice) Slice() []*DiskProfile {
	return op.slice
}

func (op *DiskProfileSlice) SetSlice(slice []*DiskProfile) {
	op.slice = slice
}

type ImageSlice struct {
	href  *string
	slice []*Image
}

func (op *ImageSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ImageSlice) SetHref(href string) {
	op.href = &href
}

func (op *ImageSlice) Slice() []*Image {
	return op.slice
}

func (op *ImageSlice) SetSlice(slice []*Image) {
	op.slice = slice
}

type EventSubscriptionSlice struct {
	href  *string
	slice []*EventSubscription
}

func (op *EventSubscriptionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *EventSubscriptionSlice) SetHref(href string) {
	op.href = &href
}

func (op *EventSubscriptionSlice) Slice() []*EventSubscription {
	return op.slice
}

func (op *EventSubscriptionSlice) SetSlice(slice []*EventSubscription) {
	op.slice = slice
}

type QuotaStorageLimitSlice struct {
	href  *string
	slice []*QuotaStorageLimit
}

func (op *QuotaStorageLimitSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *QuotaStorageLimitSlice) SetHref(href string) {
	op.href = &href
}

func (op *QuotaStorageLimitSlice) Slice() []*QuotaStorageLimit {
	return op.slice
}

func (op *QuotaStorageLimitSlice) SetSlice(slice []*QuotaStorageLimit) {
	op.slice = slice
}

type OperatingSystemSlice struct {
	href  *string
	slice []*OperatingSystem
}

func (op *OperatingSystemSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OperatingSystemSlice) SetHref(href string) {
	op.href = &href
}

func (op *OperatingSystemSlice) Slice() []*OperatingSystem {
	return op.slice
}

func (op *OperatingSystemSlice) SetSlice(slice []*OperatingSystem) {
	op.slice = slice
}

type VirtioScsiSlice struct {
	href  *string
	slice []*VirtioScsi
}

func (op *VirtioScsiSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VirtioScsiSlice) SetHref(href string) {
	op.href = &href
}

func (op *VirtioScsiSlice) Slice() []*VirtioScsi {
	return op.slice
}

func (op *VirtioScsiSlice) SetSlice(slice []*VirtioScsi) {
	op.slice = slice
}

type VendorSlice struct {
	href  *string
	slice []*Vendor
}

func (op *VendorSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VendorSlice) SetHref(href string) {
	op.href = &href
}

func (op *VendorSlice) Slice() []*Vendor {
	return op.slice
}

func (op *VendorSlice) SetSlice(slice []*Vendor) {
	op.slice = slice
}

type AgentConfigurationSlice struct {
	href  *string
	slice []*AgentConfiguration
}

func (op *AgentConfigurationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *AgentConfigurationSlice) SetHref(href string) {
	op.href = &href
}

func (op *AgentConfigurationSlice) Slice() []*AgentConfiguration {
	return op.slice
}

func (op *AgentConfigurationSlice) SetSlice(slice []*AgentConfiguration) {
	op.slice = slice
}

type OpenStackImageProviderSlice struct {
	href  *string
	slice []*OpenStackImageProvider
}

func (op *OpenStackImageProviderSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OpenStackImageProviderSlice) SetHref(href string) {
	op.href = &href
}

func (op *OpenStackImageProviderSlice) Slice() []*OpenStackImageProvider {
	return op.slice
}

func (op *OpenStackImageProviderSlice) SetSlice(slice []*OpenStackImageProvider) {
	op.slice = slice
}

type MigrationBandwidthSlice struct {
	href  *string
	slice []*MigrationBandwidth
}

func (op *MigrationBandwidthSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *MigrationBandwidthSlice) SetHref(href string) {
	op.href = &href
}

func (op *MigrationBandwidthSlice) Slice() []*MigrationBandwidth {
	return op.slice
}

func (op *MigrationBandwidthSlice) SetSlice(slice []*MigrationBandwidth) {
	op.slice = slice
}

type UnmanagedNetworkSlice struct {
	href  *string
	slice []*UnmanagedNetwork
}

func (op *UnmanagedNetworkSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *UnmanagedNetworkSlice) SetHref(href string) {
	op.href = &href
}

func (op *UnmanagedNetworkSlice) Slice() []*UnmanagedNetwork {
	return op.slice
}

func (op *UnmanagedNetworkSlice) SetSlice(slice []*UnmanagedNetwork) {
	op.slice = slice
}

type HostStorageSlice struct {
	href  *string
	slice []*HostStorage
}

func (op *HostStorageSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HostStorageSlice) SetHref(href string) {
	op.href = &href
}

func (op *HostStorageSlice) Slice() []*HostStorage {
	return op.slice
}

func (op *HostStorageSlice) SetSlice(slice []*HostStorage) {
	op.slice = slice
}

type ErrorHandlingSlice struct {
	href  *string
	slice []*ErrorHandling
}

func (op *ErrorHandlingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ErrorHandlingSlice) SetHref(href string) {
	op.href = &href
}

func (op *ErrorHandlingSlice) Slice() []*ErrorHandling {
	return op.slice
}

func (op *ErrorHandlingSlice) SetSlice(slice []*ErrorHandling) {
	op.slice = slice
}

type GlusterHookSlice struct {
	href  *string
	slice []*GlusterHook
}

func (op *GlusterHookSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GlusterHookSlice) SetHref(href string) {
	op.href = &href
}

func (op *GlusterHookSlice) Slice() []*GlusterHook {
	return op.slice
}

func (op *GlusterHookSlice) SetSlice(slice []*GlusterHook) {
	op.slice = slice
}

type VolumeGroupSlice struct {
	href  *string
	slice []*VolumeGroup
}

func (op *VolumeGroupSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VolumeGroupSlice) SetHref(href string) {
	op.href = &href
}

func (op *VolumeGroupSlice) Slice() []*VolumeGroup {
	return op.slice
}

func (op *VolumeGroupSlice) SetSlice(slice []*VolumeGroup) {
	op.slice = slice
}

type DomainSlice struct {
	href  *string
	slice []*Domain
}

func (op *DomainSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DomainSlice) SetHref(href string) {
	op.href = &href
}

func (op *DomainSlice) Slice() []*Domain {
	return op.slice
}

func (op *DomainSlice) SetSlice(slice []*Domain) {
	op.slice = slice
}

type RegistrationConfigurationSlice struct {
	href  *string
	slice []*RegistrationConfiguration
}

func (op *RegistrationConfigurationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RegistrationConfigurationSlice) SetHref(href string) {
	op.href = &href
}

func (op *RegistrationConfigurationSlice) Slice() []*RegistrationConfiguration {
	return op.slice
}

func (op *RegistrationConfigurationSlice) SetSlice(slice []*RegistrationConfiguration) {
	op.slice = slice
}

type InstanceTypeSlice struct {
	href  *string
	slice []*InstanceType
}

func (op *InstanceTypeSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *InstanceTypeSlice) SetHref(href string) {
	op.href = &href
}

func (op *InstanceTypeSlice) Slice() []*InstanceType {
	return op.slice
}

func (op *InstanceTypeSlice) SetSlice(slice []*InstanceType) {
	op.slice = slice
}

type OptionSlice struct {
	href  *string
	slice []*Option
}

func (op *OptionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OptionSlice) SetHref(href string) {
	op.href = &href
}

func (op *OptionSlice) Slice() []*Option {
	return op.slice
}

func (op *OptionSlice) SetSlice(slice []*Option) {
	op.slice = slice
}

type PropertySlice struct {
	href  *string
	slice []*Property
}

func (op *PropertySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *PropertySlice) SetHref(href string) {
	op.href = &href
}

func (op *PropertySlice) Slice() []*Property {
	return op.slice
}

func (op *PropertySlice) SetSlice(slice []*Property) {
	op.slice = slice
}

type PermissionSlice struct {
	href  *string
	slice []*Permission
}

func (op *PermissionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *PermissionSlice) SetHref(href string) {
	op.href = &href
}

func (op *PermissionSlice) Slice() []*Permission {
	return op.slice
}

func (op *PermissionSlice) SetSlice(slice []*Permission) {
	op.slice = slice
}

type RngDeviceSlice struct {
	href  *string
	slice []*RngDevice
}

func (op *RngDeviceSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RngDeviceSlice) SetHref(href string) {
	op.href = &href
}

func (op *RngDeviceSlice) Slice() []*RngDevice {
	return op.slice
}

func (op *RngDeviceSlice) SetSlice(slice []*RngDevice) {
	op.slice = slice
}

type TicketSlice struct {
	href  *string
	slice []*Ticket
}

func (op *TicketSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *TicketSlice) SetHref(href string) {
	op.href = &href
}

func (op *TicketSlice) Slice() []*Ticket {
	return op.slice
}

func (op *TicketSlice) SetSlice(slice []*Ticket) {
	op.slice = slice
}

type JobSlice struct {
	href  *string
	slice []*Job
}

func (op *JobSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *JobSlice) SetHref(href string) {
	op.href = &href
}

func (op *JobSlice) Slice() []*Job {
	return op.slice
}

func (op *JobSlice) SetSlice(slice []*Job) {
	op.slice = slice
}

type ClusterFeatureSlice struct {
	href  *string
	slice []*ClusterFeature
}

func (op *ClusterFeatureSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ClusterFeatureSlice) SetHref(href string) {
	op.href = &href
}

func (op *ClusterFeatureSlice) Slice() []*ClusterFeature {
	return op.slice
}

func (op *ClusterFeatureSlice) SetSlice(slice []*ClusterFeature) {
	op.slice = slice
}

type BootSlice struct {
	href  *string
	slice []*Boot
}

func (op *BootSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *BootSlice) SetHref(href string) {
	op.href = &href
}

func (op *BootSlice) Slice() []*Boot {
	return op.slice
}

func (op *BootSlice) SetSlice(slice []*Boot) {
	op.slice = slice
}

type TransparentHugePagesSlice struct {
	href  *string
	slice []*TransparentHugePages
}

func (op *TransparentHugePagesSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *TransparentHugePagesSlice) SetHref(href string) {
	op.href = &href
}

func (op *TransparentHugePagesSlice) Slice() []*TransparentHugePages {
	return op.slice
}

func (op *TransparentHugePagesSlice) SetSlice(slice []*TransparentHugePages) {
	op.slice = slice
}

type ExternalNetworkProviderConfigurationSlice struct {
	href  *string
	slice []*ExternalNetworkProviderConfiguration
}

func (op *ExternalNetworkProviderConfigurationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ExternalNetworkProviderConfigurationSlice) SetHref(href string) {
	op.href = &href
}

func (op *ExternalNetworkProviderConfigurationSlice) Slice() []*ExternalNetworkProviderConfiguration {
	return op.slice
}

func (op *ExternalNetworkProviderConfigurationSlice) SetSlice(slice []*ExternalNetworkProviderConfiguration) {
	op.slice = slice
}

type VlanSlice struct {
	href  *string
	slice []*Vlan
}

func (op *VlanSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VlanSlice) SetHref(href string) {
	op.href = &href
}

func (op *VlanSlice) Slice() []*Vlan {
	return op.slice
}

func (op *VlanSlice) SetSlice(slice []*Vlan) {
	op.slice = slice
}

type GlusterVolumeProfileDetailsSlice struct {
	href  *string
	slice []*GlusterVolumeProfileDetails
}

func (op *GlusterVolumeProfileDetailsSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GlusterVolumeProfileDetailsSlice) SetHref(href string) {
	op.href = &href
}

func (op *GlusterVolumeProfileDetailsSlice) Slice() []*GlusterVolumeProfileDetails {
	return op.slice
}

func (op *GlusterVolumeProfileDetailsSlice) SetSlice(slice []*GlusterVolumeProfileDetails) {
	op.slice = slice
}

type RegistrationVnicProfileMappingSlice struct {
	href  *string
	slice []*RegistrationVnicProfileMapping
}

func (op *RegistrationVnicProfileMappingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RegistrationVnicProfileMappingSlice) SetHref(href string) {
	op.href = &href
}

func (op *RegistrationVnicProfileMappingSlice) Slice() []*RegistrationVnicProfileMapping {
	return op.slice
}

func (op *RegistrationVnicProfileMappingSlice) SetSlice(slice []*RegistrationVnicProfileMapping) {
	op.slice = slice
}

type NetworkSlice struct {
	href  *string
	slice []*Network
}

func (op *NetworkSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NetworkSlice) SetHref(href string) {
	op.href = &href
}

func (op *NetworkSlice) Slice() []*Network {
	return op.slice
}

func (op *NetworkSlice) SetSlice(slice []*Network) {
	op.slice = slice
}

type ClusterLevelSlice struct {
	href  *string
	slice []*ClusterLevel
}

func (op *ClusterLevelSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ClusterLevelSlice) SetHref(href string) {
	op.href = &href
}

func (op *ClusterLevelSlice) Slice() []*ClusterLevel {
	return op.slice
}

func (op *ClusterLevelSlice) SetSlice(slice []*ClusterLevel) {
	op.slice = slice
}

type PowerManagementSlice struct {
	href  *string
	slice []*PowerManagement
}

func (op *PowerManagementSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *PowerManagementSlice) SetHref(href string) {
	op.href = &href
}

func (op *PowerManagementSlice) Slice() []*PowerManagement {
	return op.slice
}

func (op *PowerManagementSlice) SetSlice(slice []*PowerManagement) {
	op.slice = slice
}

type AffinityGroupSlice struct {
	href  *string
	slice []*AffinityGroup
}

func (op *AffinityGroupSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *AffinityGroupSlice) SetHref(href string) {
	op.href = &href
}

func (op *AffinityGroupSlice) Slice() []*AffinityGroup {
	return op.slice
}

func (op *AffinityGroupSlice) SetSlice(slice []*AffinityGroup) {
	op.slice = slice
}

type HardwareInformationSlice struct {
	href  *string
	slice []*HardwareInformation
}

func (op *HardwareInformationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HardwareInformationSlice) SetHref(href string) {
	op.href = &href
}

func (op *HardwareInformationSlice) Slice() []*HardwareInformation {
	return op.slice
}

func (op *HardwareInformationSlice) SetSlice(slice []*HardwareInformation) {
	op.slice = slice
}

type CheckpointSlice struct {
	href  *string
	slice []*Checkpoint
}

func (op *CheckpointSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CheckpointSlice) SetHref(href string) {
	op.href = &href
}

func (op *CheckpointSlice) Slice() []*Checkpoint {
	return op.slice
}

func (op *CheckpointSlice) SetSlice(slice []*Checkpoint) {
	op.slice = slice
}

type BalanceSlice struct {
	href  *string
	slice []*Balance
}

func (op *BalanceSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *BalanceSlice) SetHref(href string) {
	op.href = &href
}

func (op *BalanceSlice) Slice() []*Balance {
	return op.slice
}

func (op *BalanceSlice) SetSlice(slice []*Balance) {
	op.slice = slice
}

type IoSlice struct {
	href  *string
	slice []*Io
}

func (op *IoSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *IoSlice) SetHref(href string) {
	op.href = &href
}

func (op *IoSlice) Slice() []*Io {
	return op.slice
}

func (op *IoSlice) SetSlice(slice []*Io) {
	op.slice = slice
}

type GlusterClientSlice struct {
	href  *string
	slice []*GlusterClient
}

func (op *GlusterClientSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GlusterClientSlice) SetHref(href string) {
	op.href = &href
}

func (op *GlusterClientSlice) Slice() []*GlusterClient {
	return op.slice
}

func (op *GlusterClientSlice) SetSlice(slice []*GlusterClient) {
	op.slice = slice
}

type GlusterMemoryPoolSlice struct {
	href  *string
	slice []*GlusterMemoryPool
}

func (op *GlusterMemoryPoolSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GlusterMemoryPoolSlice) SetHref(href string) {
	op.href = &href
}

func (op *GlusterMemoryPoolSlice) Slice() []*GlusterMemoryPool {
	return op.slice
}

func (op *GlusterMemoryPoolSlice) SetSlice(slice []*GlusterMemoryPool) {
	op.slice = slice
}

type InitializationSlice struct {
	href  *string
	slice []*Initialization
}

func (op *InitializationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *InitializationSlice) SetHref(href string) {
	op.href = &href
}

func (op *InitializationSlice) Slice() []*Initialization {
	return op.slice
}

func (op *InitializationSlice) SetSlice(slice []*Initialization) {
	op.slice = slice
}

type NumaNodeSlice struct {
	href  *string
	slice []*NumaNode
}

func (op *NumaNodeSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NumaNodeSlice) SetHref(href string) {
	op.href = &href
}

func (op *NumaNodeSlice) Slice() []*NumaNode {
	return op.slice
}

func (op *NumaNodeSlice) SetSlice(slice []*NumaNode) {
	op.slice = slice
}

type MacSlice struct {
	href  *string
	slice []*Mac
}

func (op *MacSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *MacSlice) SetHref(href string) {
	op.href = &href
}

func (op *MacSlice) Slice() []*Mac {
	return op.slice
}

func (op *MacSlice) SetSlice(slice []*Mac) {
	op.slice = slice
}

type NetworkConfigurationSlice struct {
	href  *string
	slice []*NetworkConfiguration
}

func (op *NetworkConfigurationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NetworkConfigurationSlice) SetHref(href string) {
	op.href = &href
}

func (op *NetworkConfigurationSlice) Slice() []*NetworkConfiguration {
	return op.slice
}

func (op *NetworkConfigurationSlice) SetSlice(slice []*NetworkConfiguration) {
	op.slice = slice
}

type ExternalDiscoveredHostSlice struct {
	href  *string
	slice []*ExternalDiscoveredHost
}

func (op *ExternalDiscoveredHostSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ExternalDiscoveredHostSlice) SetHref(href string) {
	op.href = &href
}

func (op *ExternalDiscoveredHostSlice) Slice() []*ExternalDiscoveredHost {
	return op.slice
}

func (op *ExternalDiscoveredHostSlice) SetSlice(slice []*ExternalDiscoveredHost) {
	op.slice = slice
}

type VmBaseSlice struct {
	href  *string
	slice []*VmBase
}

func (op *VmBaseSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VmBaseSlice) SetHref(href string) {
	op.href = &href
}

func (op *VmBaseSlice) Slice() []*VmBase {
	return op.slice
}

func (op *VmBaseSlice) SetSlice(slice []*VmBase) {
	op.slice = slice
}

type DnsSlice struct {
	href  *string
	slice []*Dns
}

func (op *DnsSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DnsSlice) SetHref(href string) {
	op.href = &href
}

func (op *DnsSlice) Slice() []*Dns {
	return op.slice
}

func (op *DnsSlice) SetSlice(slice []*Dns) {
	op.slice = slice
}

type CpuProfileSlice struct {
	href  *string
	slice []*CpuProfile
}

func (op *CpuProfileSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CpuProfileSlice) SetHref(href string) {
	op.href = &href
}

func (op *CpuProfileSlice) Slice() []*CpuProfile {
	return op.slice
}

func (op *CpuProfileSlice) SetSlice(slice []*CpuProfile) {
	op.slice = slice
}

type ExternalHostSlice struct {
	href  *string
	slice []*ExternalHost
}

func (op *ExternalHostSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ExternalHostSlice) SetHref(href string) {
	op.href = &href
}

func (op *ExternalHostSlice) Slice() []*ExternalHost {
	return op.slice
}

func (op *ExternalHostSlice) SetSlice(slice []*ExternalHost) {
	op.slice = slice
}

type NicSlice struct {
	href  *string
	slice []*Nic
}

func (op *NicSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NicSlice) SetHref(href string) {
	op.href = &href
}

func (op *NicSlice) Slice() []*Nic {
	return op.slice
}

func (op *NicSlice) SetSlice(slice []*Nic) {
	op.slice = slice
}

type OpenstackVolumeAuthenticationKeySlice struct {
	href  *string
	slice []*OpenstackVolumeAuthenticationKey
}

func (op *OpenstackVolumeAuthenticationKeySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *OpenstackVolumeAuthenticationKeySlice) SetHref(href string) {
	op.href = &href
}

func (op *OpenstackVolumeAuthenticationKeySlice) Slice() []*OpenstackVolumeAuthenticationKey {
	return op.slice
}

func (op *OpenstackVolumeAuthenticationKeySlice) SetSlice(slice []*OpenstackVolumeAuthenticationKey) {
	op.slice = slice
}

type CpuTopologySlice struct {
	href  *string
	slice []*CpuTopology
}

func (op *CpuTopologySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CpuTopologySlice) SetHref(href string) {
	op.href = &href
}

func (op *CpuTopologySlice) Slice() []*CpuTopology {
	return op.slice
}

func (op *CpuTopologySlice) SetSlice(slice []*CpuTopology) {
	op.slice = slice
}

type ExternalProviderSlice struct {
	href  *string
	slice []*ExternalProvider
}

func (op *ExternalProviderSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ExternalProviderSlice) SetHref(href string) {
	op.href = &href
}

func (op *ExternalProviderSlice) Slice() []*ExternalProvider {
	return op.slice
}

func (op *ExternalProviderSlice) SetSlice(slice []*ExternalProvider) {
	op.slice = slice
}

type ExternalVmImportSlice struct {
	href  *string
	slice []*ExternalVmImport
}

func (op *ExternalVmImportSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ExternalVmImportSlice) SetHref(href string) {
	op.href = &href
}

func (op *ExternalVmImportSlice) Slice() []*ExternalVmImport {
	return op.slice
}

func (op *ExternalVmImportSlice) SetSlice(slice []*ExternalVmImport) {
	op.slice = slice
}

type PackageSlice struct {
	href  *string
	slice []*Package
}

func (op *PackageSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *PackageSlice) SetHref(href string) {
	op.href = &href
}

func (op *PackageSlice) Slice() []*Package {
	return op.slice
}

func (op *PackageSlice) SetSlice(slice []*Package) {
	op.slice = slice
}

type QosSlice struct {
	href  *string
	slice []*Qos
}

func (op *QosSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *QosSlice) SetHref(href string) {
	op.href = &href
}

func (op *QosSlice) Slice() []*Qos {
	return op.slice
}

func (op *QosSlice) SetSlice(slice []*Qos) {
	op.slice = slice
}

type NicConfigurationSlice struct {
	href  *string
	slice []*NicConfiguration
}

func (op *NicConfigurationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NicConfigurationSlice) SetHref(href string) {
	op.href = &href
}

func (op *NicConfigurationSlice) Slice() []*NicConfiguration {
	return op.slice
}

func (op *NicConfigurationSlice) SetSlice(slice []*NicConfiguration) {
	op.slice = slice
}

type BlockStatisticSlice struct {
	href  *string
	slice []*BlockStatistic
}

func (op *BlockStatisticSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *BlockStatisticSlice) SetHref(href string) {
	op.href = &href
}

func (op *BlockStatisticSlice) Slice() []*BlockStatistic {
	return op.slice
}

func (op *BlockStatisticSlice) SetSlice(slice []*BlockStatistic) {
	op.slice = slice
}

type HighAvailabilitySlice struct {
	href  *string
	slice []*HighAvailability
}

func (op *HighAvailabilitySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HighAvailabilitySlice) SetHref(href string) {
	op.href = &href
}

func (op *HighAvailabilitySlice) Slice() []*HighAvailability {
	return op.slice
}

func (op *HighAvailabilitySlice) SetSlice(slice []*HighAvailability) {
	op.slice = slice
}

type DiskSnapshotSlice struct {
	href  *string
	slice []*DiskSnapshot
}

func (op *DiskSnapshotSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DiskSnapshotSlice) SetHref(href string) {
	op.href = &href
}

func (op *DiskSnapshotSlice) Slice() []*DiskSnapshot {
	return op.slice
}

func (op *DiskSnapshotSlice) SetSlice(slice []*DiskSnapshot) {
	op.slice = slice
}

type CdromSlice struct {
	href  *string
	slice []*Cdrom
}

func (op *CdromSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CdromSlice) SetHref(href string) {
	op.href = &href
}

func (op *CdromSlice) Slice() []*Cdrom {
	return op.slice
}

func (op *CdromSlice) SetSlice(slice []*Cdrom) {
	op.slice = slice
}

type ConsoleSlice struct {
	href  *string
	slice []*Console
}

func (op *ConsoleSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ConsoleSlice) SetHref(href string) {
	op.href = &href
}

func (op *ConsoleSlice) Slice() []*Console {
	return op.slice
}

func (op *ConsoleSlice) SetSlice(slice []*Console) {
	op.slice = slice
}

type FencingPolicySlice struct {
	href  *string
	slice []*FencingPolicy
}

func (op *FencingPolicySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *FencingPolicySlice) SetHref(href string) {
	op.href = &href
}

func (op *FencingPolicySlice) Slice() []*FencingPolicy {
	return op.slice
}

func (op *FencingPolicySlice) SetSlice(slice []*FencingPolicy) {
	op.slice = slice
}

type SkipIfSdActiveSlice struct {
	href  *string
	slice []*SkipIfSdActive
}

func (op *SkipIfSdActiveSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SkipIfSdActiveSlice) SetHref(href string) {
	op.href = &href
}

func (op *SkipIfSdActiveSlice) Slice() []*SkipIfSdActive {
	return op.slice
}

func (op *SkipIfSdActiveSlice) SetSlice(slice []*SkipIfSdActive) {
	op.slice = slice
}

type PayloadSlice struct {
	href  *string
	slice []*Payload
}

func (op *PayloadSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *PayloadSlice) SetHref(href string) {
	op.href = &href
}

func (op *PayloadSlice) Slice() []*Payload {
	return op.slice
}

func (op *PayloadSlice) SetSlice(slice []*Payload) {
	op.slice = slice
}

type SshPublicKeySlice struct {
	href  *string
	slice []*SshPublicKey
}

func (op *SshPublicKeySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SshPublicKeySlice) SetHref(href string) {
	op.href = &href
}

func (op *SshPublicKeySlice) Slice() []*SshPublicKey {
	return op.slice
}

func (op *SshPublicKeySlice) SetSlice(slice []*SshPublicKey) {
	op.slice = slice
}

type ApiSummaryItemSlice struct {
	href  *string
	slice []*ApiSummaryItem
}

func (op *ApiSummaryItemSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ApiSummaryItemSlice) SetHref(href string) {
	op.href = &href
}

func (op *ApiSummaryItemSlice) Slice() []*ApiSummaryItem {
	return op.slice
}

func (op *ApiSummaryItemSlice) SetSlice(slice []*ApiSummaryItem) {
	op.slice = slice
}

type DiskSlice struct {
	href  *string
	slice []*Disk
}

func (op *DiskSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DiskSlice) SetHref(href string) {
	op.href = &href
}

func (op *DiskSlice) Slice() []*Disk {
	return op.slice
}

func (op *DiskSlice) SetSlice(slice []*Disk) {
	op.slice = slice
}

type NetworkLabelSlice struct {
	href  *string
	slice []*NetworkLabel
}

func (op *NetworkLabelSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NetworkLabelSlice) SetHref(href string) {
	op.href = &href
}

func (op *NetworkLabelSlice) Slice() []*NetworkLabel {
	return op.slice
}

func (op *NetworkLabelSlice) SetSlice(slice []*NetworkLabel) {
	op.slice = slice
}

type SpmSlice struct {
	href  *string
	slice []*Spm
}

func (op *SpmSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SpmSlice) SetHref(href string) {
	op.href = &href
}

func (op *SpmSlice) Slice() []*Spm {
	return op.slice
}

func (op *SpmSlice) SetSlice(slice []*Spm) {
	op.slice = slice
}

type HostDeviceSlice struct {
	href  *string
	slice []*HostDevice
}

func (op *HostDeviceSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HostDeviceSlice) SetHref(href string) {
	op.href = &href
}

func (op *HostDeviceSlice) Slice() []*HostDevice {
	return op.slice
}

func (op *HostDeviceSlice) SetSlice(slice []*HostDevice) {
	op.slice = slice
}

type PmProxySlice struct {
	href  *string
	slice []*PmProxy
}

func (op *PmProxySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *PmProxySlice) SetHref(href string) {
	op.href = &href
}

func (op *PmProxySlice) Slice() []*PmProxy {
	return op.slice
}

func (op *PmProxySlice) SetSlice(slice []*PmProxy) {
	op.slice = slice
}

type SkipIfConnectivityBrokenSlice struct {
	href  *string
	slice []*SkipIfConnectivityBroken
}

func (op *SkipIfConnectivityBrokenSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SkipIfConnectivityBrokenSlice) SetHref(href string) {
	op.href = &href
}

func (op *SkipIfConnectivityBrokenSlice) Slice() []*SkipIfConnectivityBroken {
	return op.slice
}

func (op *SkipIfConnectivityBrokenSlice) SetSlice(slice []*SkipIfConnectivityBroken) {
	op.slice = slice
}

type SchedulingPolicyUnitSlice struct {
	href  *string
	slice []*SchedulingPolicyUnit
}

func (op *SchedulingPolicyUnitSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SchedulingPolicyUnitSlice) SetHref(href string) {
	op.href = &href
}

func (op *SchedulingPolicyUnitSlice) Slice() []*SchedulingPolicyUnit {
	return op.slice
}

func (op *SchedulingPolicyUnitSlice) SetSlice(slice []*SchedulingPolicyUnit) {
	op.slice = slice
}

type VnicPassThroughSlice struct {
	href  *string
	slice []*VnicPassThrough
}

func (op *VnicPassThroughSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VnicPassThroughSlice) SetHref(href string) {
	op.href = &href
}

func (op *VnicPassThroughSlice) Slice() []*VnicPassThrough {
	return op.slice
}

func (op *VnicPassThroughSlice) SetSlice(slice []*VnicPassThrough) {
	op.slice = slice
}

type PermitSlice struct {
	href  *string
	slice []*Permit
}

func (op *PermitSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *PermitSlice) SetHref(href string) {
	op.href = &href
}

func (op *PermitSlice) Slice() []*Permit {
	return op.slice
}

func (op *PermitSlice) SetSlice(slice []*Permit) {
	op.slice = slice
}

type ClusterSlice struct {
	href  *string
	slice []*Cluster
}

func (op *ClusterSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ClusterSlice) SetHref(href string) {
	op.href = &href
}

func (op *ClusterSlice) Slice() []*Cluster {
	return op.slice
}

func (op *ClusterSlice) SetSlice(slice []*Cluster) {
	op.slice = slice
}

type GlusterBrickMemoryInfoSlice struct {
	href  *string
	slice []*GlusterBrickMemoryInfo
}

func (op *GlusterBrickMemoryInfoSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GlusterBrickMemoryInfoSlice) SetHref(href string) {
	op.href = &href
}

func (op *GlusterBrickMemoryInfoSlice) Slice() []*GlusterBrickMemoryInfo {
	return op.slice
}

func (op *GlusterBrickMemoryInfoSlice) SetSlice(slice []*GlusterBrickMemoryInfo) {
	op.slice = slice
}

type VmPoolSlice struct {
	href  *string
	slice []*VmPool
}

func (op *VmPoolSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *VmPoolSlice) SetHref(href string) {
	op.href = &href
}

func (op *VmPoolSlice) Slice() []*VmPool {
	return op.slice
}

func (op *VmPoolSlice) SetSlice(slice []*VmPool) {
	op.slice = slice
}

type ProxyTicketSlice struct {
	href  *string
	slice []*ProxyTicket
}

func (op *ProxyTicketSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ProxyTicketSlice) SetHref(href string) {
	op.href = &href
}

func (op *ProxyTicketSlice) Slice() []*ProxyTicket {
	return op.slice
}

func (op *ProxyTicketSlice) SetSlice(slice []*ProxyTicket) {
	op.slice = slice
}

type GlusterServerHookSlice struct {
	href  *string
	slice []*GlusterServerHook
}

func (op *GlusterServerHookSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GlusterServerHookSlice) SetHref(href string) {
	op.href = &href
}

func (op *GlusterServerHookSlice) Slice() []*GlusterServerHook {
	return op.slice
}

func (op *GlusterServerHookSlice) SetSlice(slice []*GlusterServerHook) {
	op.slice = slice
}

type StatisticSlice struct {
	href  *string
	slice []*Statistic
}

func (op *StatisticSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *StatisticSlice) SetHref(href string) {
	op.href = &href
}

func (op *StatisticSlice) Slice() []*Statistic {
	return op.slice
}

func (op *StatisticSlice) SetSlice(slice []*Statistic) {
	op.slice = slice
}

type SnapshotSlice struct {
	href  *string
	slice []*Snapshot
}

func (op *SnapshotSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SnapshotSlice) SetHref(href string) {
	op.href = &href
}

func (op *SnapshotSlice) Slice() []*Snapshot {
	return op.slice
}

func (op *SnapshotSlice) SetSlice(slice []*Snapshot) {
	op.slice = slice
}

type HostedEngineSlice struct {
	href  *string
	slice []*HostedEngine
}

func (op *HostedEngineSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HostedEngineSlice) SetHref(href string) {
	op.href = &href
}

func (op *HostedEngineSlice) Slice() []*HostedEngine {
	return op.slice
}

func (op *HostedEngineSlice) SetSlice(slice []*HostedEngine) {
	op.slice = slice
}

type DiskAttachmentSlice struct {
	href  *string
	slice []*DiskAttachment
}

func (op *DiskAttachmentSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DiskAttachmentSlice) SetHref(href string) {
	op.href = &href
}

func (op *DiskAttachmentSlice) Slice() []*DiskAttachment {
	return op.slice
}

func (op *DiskAttachmentSlice) SetSlice(slice []*DiskAttachment) {
	op.slice = slice
}

type CertificateSlice struct {
	href  *string
	slice []*Certificate
}

func (op *CertificateSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CertificateSlice) SetHref(href string) {
	op.href = &href
}

func (op *CertificateSlice) Slice() []*Certificate {
	return op.slice
}

func (op *CertificateSlice) SetSlice(slice []*Certificate) {
	op.slice = slice
}

type ReportedConfigurationSlice struct {
	href  *string
	slice []*ReportedConfiguration
}

func (op *ReportedConfigurationSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ReportedConfigurationSlice) SetHref(href string) {
	op.href = &href
}

func (op *ReportedConfigurationSlice) Slice() []*ReportedConfiguration {
	return op.slice
}

func (op *ReportedConfigurationSlice) SetSlice(slice []*ReportedConfiguration) {
	op.slice = slice
}

type BackupSlice struct {
	href  *string
	slice []*Backup
}

func (op *BackupSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *BackupSlice) SetHref(href string) {
	op.href = &href
}

func (op *BackupSlice) Slice() []*Backup {
	return op.slice
}

func (op *BackupSlice) SetSlice(slice []*Backup) {
	op.slice = slice
}

type SchedulingPolicySlice struct {
	href  *string
	slice []*SchedulingPolicy
}

func (op *SchedulingPolicySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SchedulingPolicySlice) SetHref(href string) {
	op.href = &href
}

func (op *SchedulingPolicySlice) Slice() []*SchedulingPolicy {
	return op.slice
}

func (op *SchedulingPolicySlice) SetSlice(slice []*SchedulingPolicy) {
	op.slice = slice
}

type CpuSlice struct {
	href  *string
	slice []*Cpu
}

func (op *CpuSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CpuSlice) SetHref(href string) {
	op.href = &href
}

func (op *CpuSlice) Slice() []*Cpu {
	return op.slice
}

func (op *CpuSlice) SetSlice(slice []*Cpu) {
	op.slice = slice
}

type RegistrationAffinityLabelMappingSlice struct {
	href  *string
	slice []*RegistrationAffinityLabelMapping
}

func (op *RegistrationAffinityLabelMappingSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *RegistrationAffinityLabelMappingSlice) SetHref(href string) {
	op.href = &href
}

func (op *RegistrationAffinityLabelMappingSlice) Slice() []*RegistrationAffinityLabelMapping {
	return op.slice
}

func (op *RegistrationAffinityLabelMappingSlice) SetSlice(slice []*RegistrationAffinityLabelMapping) {
	op.slice = slice
}

type IpAddressAssignmentSlice struct {
	href  *string
	slice []*IpAddressAssignment
}

func (op *IpAddressAssignmentSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *IpAddressAssignmentSlice) SetHref(href string) {
	op.href = &href
}

func (op *IpAddressAssignmentSlice) Slice() []*IpAddressAssignment {
	return op.slice
}

func (op *IpAddressAssignmentSlice) SetSlice(slice []*IpAddressAssignment) {
	op.slice = slice
}

type GuestOperatingSystemSlice struct {
	href  *string
	slice []*GuestOperatingSystem
}

func (op *GuestOperatingSystemSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GuestOperatingSystemSlice) SetHref(href string) {
	op.href = &href
}

func (op *GuestOperatingSystemSlice) Slice() []*GuestOperatingSystem {
	return op.slice
}

func (op *GuestOperatingSystemSlice) SetSlice(slice []*GuestOperatingSystem) {
	op.slice = slice
}

type CpuTypeSlice struct {
	href  *string
	slice []*CpuType
}

func (op *CpuTypeSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CpuTypeSlice) SetHref(href string) {
	op.href = &href
}

func (op *CpuTypeSlice) Slice() []*CpuType {
	return op.slice
}

func (op *CpuTypeSlice) SetSlice(slice []*CpuType) {
	op.slice = slice
}

type SpecialObjectsSlice struct {
	href  *string
	slice []*SpecialObjects
}

func (op *SpecialObjectsSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SpecialObjectsSlice) SetHref(href string) {
	op.href = &href
}

func (op *SpecialObjectsSlice) Slice() []*SpecialObjects {
	return op.slice
}

func (op *SpecialObjectsSlice) SetSlice(slice []*SpecialObjects) {
	op.slice = slice
}

type SessionSlice struct {
	href  *string
	slice []*Session
}

func (op *SessionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *SessionSlice) SetHref(href string) {
	op.href = &href
}

func (op *SessionSlice) Slice() []*Session {
	return op.slice
}

func (op *SessionSlice) SetSlice(slice []*Session) {
	op.slice = slice
}

type GlusterBrickAdvancedDetailsSlice struct {
	href  *string
	slice []*GlusterBrickAdvancedDetails
}

func (op *GlusterBrickAdvancedDetailsSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GlusterBrickAdvancedDetailsSlice) SetHref(href string) {
	op.href = &href
}

func (op *GlusterBrickAdvancedDetailsSlice) Slice() []*GlusterBrickAdvancedDetails {
	return op.slice
}

func (op *GlusterBrickAdvancedDetailsSlice) SetSlice(slice []*GlusterBrickAdvancedDetails) {
	op.slice = slice
}

type KsmSlice struct {
	href  *string
	slice []*Ksm
}

func (op *KsmSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *KsmSlice) SetHref(href string) {
	op.href = &href
}

func (op *KsmSlice) Slice() []*Ksm {
	return op.slice
}

func (op *KsmSlice) SetSlice(slice []*Ksm) {
	op.slice = slice
}

type ValueSlice struct {
	href  *string
	slice []*Value
}

func (op *ValueSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ValueSlice) SetHref(href string) {
	op.href = &href
}

func (op *ValueSlice) Slice() []*Value {
	return op.slice
}

func (op *ValueSlice) SetSlice(slice []*Value) {
	op.slice = slice
}

type CloudInitSlice struct {
	href  *string
	slice []*CloudInit
}

func (op *CloudInitSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *CloudInitSlice) SetHref(href string) {
	op.href = &href
}

func (op *CloudInitSlice) Slice() []*CloudInit {
	return op.slice
}

func (op *CloudInitSlice) SetSlice(slice []*CloudInit) {
	op.slice = slice
}

type DisplaySlice struct {
	href  *string
	slice []*Display
}

func (op *DisplaySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *DisplaySlice) SetHref(href string) {
	op.href = &href
}

func (op *DisplaySlice) Slice() []*Display {
	return op.slice
}

func (op *DisplaySlice) SetSlice(slice []*Display) {
	op.slice = slice
}

type StorageDomainLeaseSlice struct {
	href  *string
	slice []*StorageDomainLease
}

func (op *StorageDomainLeaseSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *StorageDomainLeaseSlice) SetHref(href string) {
	op.href = &href
}

func (op *StorageDomainLeaseSlice) Slice() []*StorageDomainLease {
	return op.slice
}

func (op *StorageDomainLeaseSlice) SetSlice(slice []*StorageDomainLease) {
	op.slice = slice
}

type MigrationPolicySlice struct {
	href  *string
	slice []*MigrationPolicy
}

func (op *MigrationPolicySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *MigrationPolicySlice) SetHref(href string) {
	op.href = &href
}

func (op *MigrationPolicySlice) Slice() []*MigrationPolicy {
	return op.slice
}

func (op *MigrationPolicySlice) SetSlice(slice []*MigrationPolicy) {
	op.slice = slice
}

type HostSlice struct {
	href  *string
	slice []*Host
}

func (op *HostSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *HostSlice) SetHref(href string) {
	op.href = &href
}

func (op *HostSlice) Slice() []*Host {
	return op.slice
}

func (op *HostSlice) SetSlice(slice []*Host) {
	op.slice = slice
}

type NetworkAttachmentSlice struct {
	href  *string
	slice []*NetworkAttachment
}

func (op *NetworkAttachmentSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *NetworkAttachmentSlice) SetHref(href string) {
	op.href = &href
}

func (op *NetworkAttachmentSlice) Slice() []*NetworkAttachment {
	return op.slice
}

func (op *NetworkAttachmentSlice) SetSlice(slice []*NetworkAttachment) {
	op.slice = slice
}

type FilterSlice struct {
	href  *string
	slice []*Filter
}

func (op *FilterSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *FilterSlice) SetHref(href string) {
	op.href = &href
}

func (op *FilterSlice) Slice() []*Filter {
	return op.slice
}

func (op *FilterSlice) SetSlice(slice []*Filter) {
	op.slice = slice
}

type IscsiBondSlice struct {
	href  *string
	slice []*IscsiBond
}

func (op *IscsiBondSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *IscsiBondSlice) SetHref(href string) {
	op.href = &href
}

func (op *IscsiBondSlice) Slice() []*IscsiBond {
	return op.slice
}

func (op *IscsiBondSlice) SetSlice(slice []*IscsiBond) {
	op.slice = slice
}

type LinkLayerDiscoveryProtocolElementSlice struct {
	href  *string
	slice []*LinkLayerDiscoveryProtocolElement
}

func (op *LinkLayerDiscoveryProtocolElementSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *LinkLayerDiscoveryProtocolElementSlice) SetHref(href string) {
	op.href = &href
}

func (op *LinkLayerDiscoveryProtocolElementSlice) Slice() []*LinkLayerDiscoveryProtocolElement {
	return op.slice
}

func (op *LinkLayerDiscoveryProtocolElementSlice) SetSlice(slice []*LinkLayerDiscoveryProtocolElement) {
	op.slice = slice
}

type ApiSummarySlice struct {
	href  *string
	slice []*ApiSummary
}

func (op *ApiSummarySlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ApiSummarySlice) SetHref(href string) {
	op.href = &href
}

func (op *ApiSummarySlice) Slice() []*ApiSummary {
	return op.slice
}

func (op *ApiSummarySlice) SetSlice(slice []*ApiSummary) {
	op.slice = slice
}

type FaultSlice struct {
	href  *string
	slice []*Fault
}

func (op *FaultSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *FaultSlice) SetHref(href string) {
	op.href = &href
}

func (op *FaultSlice) Slice() []*Fault {
	return op.slice
}

func (op *FaultSlice) SetSlice(slice []*Fault) {
	op.slice = slice
}

type GracePeriodSlice struct {
	href  *string
	slice []*GracePeriod
}

func (op *GracePeriodSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *GracePeriodSlice) SetHref(href string) {
	op.href = &href
}

func (op *GracePeriodSlice) Slice() []*GracePeriod {
	return op.slice
}

func (op *GracePeriodSlice) SetSlice(slice []*GracePeriod) {
	op.slice = slice
}

type ActionSlice struct {
	href  *string
	slice []*Action
}

func (op *ActionSlice) Href() (string, bool) {
	if op.href == nil {
		return "", false
	}
	return *op.href, true
}

func (op *ActionSlice) SetHref(href string) {
	op.href = &href
}

func (op *ActionSlice) Slice() []*Action {
	return op.slice
}

func (op *ActionSlice) SetSlice(slice []*Action) {
	op.slice = slice
}

type VmSummaryBuilder struct {
	vmSummary *VmSummary
	err       error
}

func NewVmSummaryBuilder() *VmSummaryBuilder {
	return &VmSummaryBuilder{vmSummary: &VmSummary{}, err: nil}
}

func (builder *VmSummaryBuilder) Active(attr int64) *VmSummaryBuilder {
	if builder.err != nil {
		return builder
	}

	builder.vmSummary.SetActive(attr)
	return builder
}

func (builder *VmSummaryBuilder) Migrating(attr int64) *VmSummaryBuilder {
	if builder.err != nil {
		return builder
	}

	builder.vmSummary.SetMigrating(attr)
	return builder
}

func (builder *VmSummaryBuilder) Total(attr int64) *VmSummaryBuilder {
	if builder.err != nil {
		return builder
	}

	builder.vmSummary.SetTotal(attr)
	return builder
}

func (builder *VmSummaryBuilder) Href(href string) *VmSummaryBuilder {
	if builder.err != nil {
		return builder
	}

	builder.vmSummary.SetHref(href)
	return builder
}

func (builder *VmSummaryBuilder) Build() (*VmSummary, error) {
	if builder.err != nil {
		return nil, builder.err
	}
	return builder.vmSummary, nil
}

func (builder *VmSummaryBuilder) MustBuild() *VmSummary {
	if builder.err != nil {
		panic(fmt.Sprintf("Failed to build VmSummary instance, reason: %v", builder.err))
	}
	return builder.vmSummary
}

type NetworkFilterBuilder struct {
	networkFilter *NetworkFilter
	err           error
}

func NewNetworkFilterBuilder() *NetworkFilterBuilder {
	return &NetworkFilterBuilder{networkFilter: &NetworkFilter{}, err: nil}
}

func (builder *NetworkFilterBuilder) Comment(attr string) *NetworkFilterBuilder {
	if builder.err != nil {
		return builder
	}

	builder.networkFilter.SetComment(attr)
	return builder
}

func (builder *NetworkFilterBuilder) Description(attr string) *NetworkFilterBuilder {
	if builder.err != nil {
		return builder
	}

	builder.networkFilter.SetDescription(attr)
	return builder
}

func (builder *NetworkFilterBuilder) Id(attr string) *NetworkFilterBuilder {
	if builder.err != nil {
		return builder
	}

	builder.networkFilter.SetId(attr)
	return builder
}

func (builder *NetworkFilterBuilder) Name(attr string) *NetworkFilterBuilder {
	if builder.err != nil {
		return builder
	}

	builder.networkFilter.SetName(attr)
	return builder
}

func (builder *NetworkFilterBuilder) Version(attr *Version) *NetworkFilterBuilder {
	if builder.err != nil {
		return builder
	}

	builder.networkFilter.SetVersion(attr)
	return builder
}

func (builder *NetworkFilterBuilder) VersionBuilder(attrBuilder *VersionBuilder) *NetworkFilterBuilder {
	if builder.err != nil {
		return builder
	}

	if attrBuilder.err != nil {
		builder.err = attrBuilder.err
		return builder
	}
	attr, err := attrBuilder.Build()
	if err != nil {
		builder.err = err
		return builder
	}
	return builder.Version(attr)
}

func (builder *NetworkFilterBuilder) Href(href string) *NetworkFilterBuilder {
	if builder.err != nil {
		return builder
	}

	builder.networkFilter.SetHref(href)
	return builder
}

func (builder *NetworkFilterBuilder) Build() (*NetworkFilter, error) {
	if builder.err != nil {
		return nil, builder.err
	}
	return builder.networkFilter, nil
}

func (builder *NetworkFilterBuilder) MustBuild() *NetworkFilter {
	if builder.err != nil {
		panic(fmt.Sprintf("Failed to build NetworkFilter instance, reason: %v", builder.err))
	}
	return builder.networkFilter
}

type QuotaClusterLimitBuilder struct {
	quotaClusterLimit *QuotaClusterLimit
	err               error
}

func NewQuotaClusterLimitBuilder() *QuotaClusterLimitBuilder {
	return &QuotaClusterLimitBuilder{quotaClusterLimit: &QuotaClusterLimit{}, err: nil}
}

func (builder *QuotaClusterLimitBuilder) Cluster(attr *Cluster) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetCluster(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) ClusterBuilder(attrBuilder *ClusterBuilder) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	if attrBuilder.err != nil {
		builder.err = attrBuilder.err
		return builder
	}
	attr, err := attrBuilder.Build()
	if err != nil {
		builder.err = err
		return builder
	}
	return builder.Cluster(attr)
}

func (builder *QuotaClusterLimitBuilder) Comment(attr string) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetComment(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) Description(attr string) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetDescription(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) Id(attr string) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetId(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) MemoryLimit(attr float64) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetMemoryLimit(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) MemoryUsage(attr float64) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetMemoryUsage(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) Name(attr string) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetName(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) Quota(attr *Quota) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetQuota(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) QuotaBuilder(attrBuilder *QuotaBuilder) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	if attrBuilder.err != nil {
		builder.err = attrBuilder.err
		return builder
	}
	attr, err := attrBuilder.Build()
	if err != nil {
		builder.err = err
		return builder
	}
	return builder.Quota(attr)
}

func (builder *QuotaClusterLimitBuilder) VcpuLimit(attr int64) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetVcpuLimit(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) VcpuUsage(attr int64) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetVcpuUsage(attr)
	return builder
}

func (builder *QuotaClusterLimitBuilder) Href(href string) *QuotaClusterLimitBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quotaClusterLimit.SetHref(href)
	return builder
}

func (builder *QuotaClusterLimitBuilder) Build() (*QuotaClusterLimit, error) {
	if builder.err != nil {
		return nil, builder.err
	}
	return builder.quotaClusterLimit, nil
}

func (builder *QuotaClusterLimitBuilder) MustBuild() *QuotaClusterLimit {
	if builder.err != nil {
		panic(fmt.Sprintf("Failed to build QuotaClusterLimit instance, reason: %v", builder.err))
	}
	return builder.quotaClusterLimit
}

type BiosBuilder struct {
	bios *Bios
	err  error
}

func NewBiosBuilder() *BiosBuilder {
	return &BiosBuilder{bios: &Bios{}, err: nil}
}

func (builder *BiosBuilder) BootMenu(attr *BootMenu) *BiosBuilder {
	if builder.err != nil {
		return builder
	}

	builder.bios.SetBootMenu(attr)
	return builder
}

func (builder *BiosBuilder) BootMenuBuilder(attrBuilder *BootMenuBuilder) *BiosBuilder {
	if builder.err != nil {
		return builder
	}

	if attrBuilder.err != nil {
		builder.err = attrBuilder.err
		return builder
	}
	attr, err := attrBuilder.Build()
	if err != nil {
		builder.err = err
		return builder
	}
	return builder.BootMenu(attr)
}

func (builder *BiosBuilder) Type(attr BiosType) *BiosBuilder {
	if builder.err != nil {
		return builder
	}

	builder.bios.SetType(attr)
	return builder
}

func (builder *BiosBuilder) Href(href string) *BiosBuilder {
	if builder.err != nil {
		return builder
	}

	builder.bios.SetHref(href)
	return builder
}

func (builder *BiosBuilder) Build() (*Bios, error) {
	if builder.err != nil {
		return nil, builder.err
	}
	return builder.bios, nil
}

func (builder *BiosBuilder) MustBuild() *Bios {
	if builder.err != nil {
		panic(fmt.Sprintf("Failed to build Bios instance, reason: %v", builder.err))
	}
	return builder.bios
}

type QuotaBuilder struct {
	quota *Quota
	err   error
}

func NewQuotaBuilder() *QuotaBuilder {
	return &QuotaBuilder{quota: &Quota{}, err: nil}
}

func (builder *QuotaBuilder) ClusterHardLimitPct(attr int64) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetClusterHardLimitPct(attr)
	return builder
}

func (builder *QuotaBuilder) ClusterSoftLimitPct(attr int64) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetClusterSoftLimitPct(attr)
	return builder
}

func (builder *QuotaBuilder) Comment(attr string) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetComment(attr)
	return builder
}

func (builder *QuotaBuilder) DataCenter(attr *DataCenter) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetDataCenter(attr)
	return builder
}

func (builder *QuotaBuilder) DataCenterBuilder(attrBuilder *DataCenterBuilder) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	if attrBuilder.err != nil {
		builder.err = attrBuilder.err
		return builder
	}
	attr, err := attrBuilder.Build()
	if err != nil {
		builder.err = err
		return builder
	}
	return builder.DataCenter(attr)
}

func (builder *QuotaBuilder) Description(attr string) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetDescription(attr)
	return builder
}

func (builder *QuotaBuilder) Disks(attr *DiskSlice) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetDisks(attr)
	return builder
}

func (builder *QuotaBuilder) DisksOfAny(anys ...*Disk) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	if builder.quota.disks == nil {
		builder.quota.disks = new(DiskSlice)
	}
	builder.quota.disks.slice = append(builder.quota.disks.slice, anys...)
	return builder
}

func (builder *QuotaBuilder) DisksBuilderOfAny(anyBuilders ...DiskBuilder) *QuotaBuilder {
	if builder.err != nil || len(anyBuilders) == 0 {
		return builder
	}

	for _, b := range anyBuilders {
		if b.err != nil {
			builder.err = b.err
			return builder
		}
		attr, err := b.Build()
		if err != nil {
			builder.err = b.err
			return builder
		}
		builder.DisksOfAny(attr)
	}
	return builder
}

func (builder *QuotaBuilder) Id(attr string) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetId(attr)
	return builder
}

func (builder *QuotaBuilder) Name(attr string) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetName(attr)
	return builder
}

func (builder *QuotaBuilder) Permissions(attr *PermissionSlice) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetPermissions(attr)
	return builder
}

func (builder *QuotaBuilder) PermissionsOfAny(anys ...*Permission) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	if builder.quota.permissions == nil {
		builder.quota.permissions = new(PermissionSlice)
	}
	builder.quota.permissions.slice = append(builder.quota.permissions.slice, anys...)
	return builder
}

func (builder *QuotaBuilder) PermissionsBuilderOfAny(anyBuilders ...PermissionBuilder) *QuotaBuilder {
	if builder.err != nil || len(anyBuilders) == 0 {
		return builder
	}

	for _, b := range anyBuilders {
		if b.err != nil {
			builder.err = b.err
			return builder
		}
		attr, err := b.Build()
		if err != nil {
			builder.err = b.err
			return builder
		}
		builder.PermissionsOfAny(attr)
	}
	return builder
}

func (builder *QuotaBuilder) QuotaClusterLimits(attr *QuotaClusterLimitSlice) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetQuotaClusterLimits(attr)
	return builder
}

func (builder *QuotaBuilder) QuotaClusterLimitsOfAny(anys ...*QuotaClusterLimit) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	if builder.quota.quotaClusterLimits == nil {
		builder.quota.quotaClusterLimits = new(QuotaClusterLimitSlice)
	}
	builder.quota.quotaClusterLimits.slice = append(builder.quota.quotaClusterLimits.slice, anys...)
	return builder
}

func (builder *QuotaBuilder) QuotaClusterLimitsBuilderOfAny(anyBuilders ...QuotaClusterLimitBuilder) *QuotaBuilder {
	if builder.err != nil || len(anyBuilders) == 0 {
		return builder
	}

	for _, b := range anyBuilders {
		if b.err != nil {
			builder.err = b.err
			return builder
		}
		attr, err := b.Build()
		if err != nil {
			builder.err = b.err
			return builder
		}
		builder.QuotaClusterLimitsOfAny(attr)
	}
	return builder
}

func (builder *QuotaBuilder) QuotaStorageLimits(attr *QuotaStorageLimitSlice) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetQuotaStorageLimits(attr)
	return builder
}

func (builder *QuotaBuilder) QuotaStorageLimitsOfAny(anys ...*QuotaStorageLimit) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	if builder.quota.quotaStorageLimits == nil {
		builder.quota.quotaStorageLimits = new(QuotaStorageLimitSlice)
	}
	builder.quota.quotaStorageLimits.slice = append(builder.quota.quotaStorageLimits.slice, anys...)
	return builder
}

func (builder *QuotaBuilder) QuotaStorageLimitsBuilderOfAny(anyBuilders ...QuotaStorageLimitBuilder) *QuotaBuilder {
	if builder.err != nil || len(anyBuilders) == 0 {
		return builder
	}

	for _, b := range anyBuilders {
		if b.err != nil {
			builder.err = b.err
			return builder
		}
		attr, err := b.Build()
		if err != nil {
			builder.err = b.err
			return builder
		}
		builder.QuotaStorageLimitsOfAny(attr)
	}
	return builder
}

func (builder *QuotaBuilder) StorageHardLimitPct(attr int64) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetStorageHardLimitPct(attr)
	return builder
}

func (builder *QuotaBuilder) StorageSoftLimitPct(attr int64) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetStorageSoftLimitPct(attr)
	return builder
}

func (builder *QuotaBuilder) Users(attr *UserSlice) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetUsers(attr)
	return builder
}

func (builder *QuotaBuilder) UsersOfAny(anys ...*User) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	if builder.quota.users == nil {
		builder.quota.users = new(UserSlice)
	}
	builder.quota.users.slice = append(builder.quota.users.slice, anys...)
	return builder
}

func (builder *QuotaBuilder) UsersBuilderOfAny(anyBuilders ...UserBuilder) *QuotaBuilder {
	if builder.err != nil || len(anyBuilders) == 0 {
		return builder
	}

	for _, b := range anyBuilders {
		if b.err != nil {
			builder.err = b.err
			return builder
		}
		attr, err := b.Build()
		if err != nil {
			builder.err = b.err
			return builder
		}
		builder.UsersOfAny(attr)
	}
	return builder
}

func (builder *QuotaBuilder) Vms(attr *VmSlice) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetVms(attr)
	return builder
}

func (builder *QuotaBuilder) VmsOfAny(anys ...*Vm) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	if builder.quota.vms == nil {
		builder.quota.vms = new(VmSlice)
	}
	builder.quota.vms.slice = append(builder.quota.vms.slice, anys...)
	return builder
}

func (builder *QuotaBuilder) VmsBuilderOfAny(anyBuilders ...VmBuilder) *QuotaBuilder {
	if builder.err != nil || len(anyBuilders) == 0 {
		return builder
	}

	for _, b := range anyBuilders {
		if b.err != nil {
			builder.err = b.err
			return builder
		}
		attr, err := b.Build()
		if err != nil {
			builder.err = b.err
			return builder
		}
		builder.VmsOfAny(attr)
	}
	return builder
}

func (builder *QuotaBuilder) Href(href string) *QuotaBuilder {
	if builder.err != nil {
		return builder
	}

	builder.quota.SetHref(href)
	return builder
}

func (builder *QuotaBuilder) Build() (*Quota, error) {
	if builder.err != nil {
		return nil, builder.err
	}
	return builder.quota, nil
}

func (builder *QuotaBuilder) MustBuild() *Quota {
	if builder.err != nil {
		panic(fmt.Sprintf("Failed to build Quota instance, reason: %v", builder.err))
	}
	return builder.quota
}

type MigrationOptionsBuilder struct {
	migrationOptions *MigrationOptions
	err              error
}

func NewMigrationOptionsBuilder() *MigrationOptionsBuilder {
	return &MigrationOptionsBuilder{migrationOptions: &MigrationOptions{}, err: nil}
}

func (builder *MigrationOptionsBuilder) AutoConverge(attr InheritableBoolean) *MigrationOptionsBuilder {
	if builder.err != nil {
		return builder
	}

	builder.migrationOptions.SetAutoConverge(attr)
	return builder
}

func (builder *MigrationOptionsBuilder) Bandwidth(attr *MigrationBandwidth) *MigrationOptionsBuilder {
	if builder.err != nil {
		return builder
	}

	builder.migrationOptions.SetBandwidth(attr)
	return builder
}

func (builder *MigrationOptionsBuilder) BandwidthBuilder(attrBuilder *MigrationBandwidthBuilder) *MigrationOptionsBuilder {
	if builder.err != nil {
		return builder
	}

	if attrBuilder.err != nil {
		builder.err = attrBuilder.err
		return builder
	}
	attr, err := attrBuilder.Build()
	if err != nil {
		builder.err = err
		return builder
	}
	return builder.Bandwidth(attr)
}

func (builder *MigrationOptionsBuilder) Compressed(attr InheritableBoolean) *MigrationOptionsBuilder {
	if builder.err != nil {
		return builder
	}

	builder.migrationOptions.SetCompressed(attr)
	return builder
}

func (builder *MigrationOptionsBuilder) Encrypted(attr InheritableBoolean) *MigrationOptionsBuilder {
	if builder.err != nil {
		return builder
	}

	builder.migrationOptions.SetEncrypted(attr)
	return builder
}

func (builder *MigrationOptionsBuilder) Policy(attr *MigrationPolicy) *MigrationOptionsBuilder {
	if builder.err != nil {
		return builder
	}

	builder.migrationOptions.SetPolicy(attr)
	return builder
}

func (builder *MigrationOptionsBuilder) PolicyBuilder(attrBuilder *MigrationPolicyBuilder) *MigrationOptionsBuilder {
	if builder.err != nil {
		return builder
	}

	if attrBuilder.err != nil {
		builder.err = attrBuilder.err
		return builder
	}
	attr, err := attrBuilder.Build()
	if err != nil {
		builder.err = err
		return builder
	}
	return builder.Policy(attr)
}

func (builder *MigrationOptionsBuilder) Href(href string) *MigrationOptionsBuilder {
	if builder.err != nil {
		return builder
	}

	builder.migrationOptions.SetHref(href)
	return builder
}

func (builder *MigrationOptionsBuilder) Build() (*MigrationOptions, error) {
	if builder.err != nil {
		return nil, builder.err
	}
	return builder.migrationOptions, nil
}

func (builder *MigrationOptionsBuilder) MustBuild() *MigrationOptions {
	if builder.err != nil {
		panic(fmt.Sprintf("Failed to build MigrationOptions instance, reason: %v", builder.err))
	}
	return builder.migrationOptions
}

type RangeBuilder struct {
	range_ *Range
	err    error
}

func NewRangeBuilder() *RangeBuilder {
	return &RangeBuilder{range_: &Range{}, err: nil}
}

func (builder *RangeBuilder) From(attr string) *RangeBuilder {
	if builder.err != nil {
		return builder
	}

	builder.range_.SetFrom(attr)
	return builder
}

func (builder *RangeBuilder) To(attr string) *RangeBuilder {
	if builder.err != nil {
		return builder
	}

	builder.range_.SetTo(attr)
	return builder
}

func (builder *RangeBuilder) Href(href string) *RangeBuilder {
	if builder.err != nil {
		return builder
	}

	builder.range_.SetHref(href)
	return builder
}

func (builder *RangeBuilder) Build() (*Range, error) {
	if builder.err != nil {
		return nil, builder.err
	}
	return builder.range_, nil
}

func (builder *RangeBuilder) MustBuild() *Range {
	if builder.err != nil {
		panic(fmt.Sprintf("Failed to build Range instance, reason: %v", builder.err))
	}
	return builder.range_
}

type VirtualNumaNodeBuilder struct {
	virtualNumaNode *VirtualNumaNode
	err             error
}

func NewVirtualNumaNodeBuilder() *VirtualNumaNodeBuilder {
	return &VirtualNumaNodeBuilder{virtualNumaNode: &VirtualNumaNode{}, err: nil}
}

func (builder *VirtualNumaNodeBuilder) Comment(attr string) *VirtualNumaNodeBuilder {
	if builder.err != nil {
		return builder
	}

	builder.virtualNumaNode.SetComment(attr)
	return builder
}

func (builder *VirtualNumaNodeBuilder) Cpu(attr *Cpu) *VirtualN