/*
Copyright 2017 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package mount

import (
	mock "github.com/stretchr/testify/mock"
	"k8s.io/mount-utils"
	utilsexec "k8s.io/utils/exec"
	exec "k8s.io/utils/exec/testing"
)

// MountMock is an autogenerated mock type for the IMount type
// ORIGINALLY GENERATED BY mockery with hand edits
type MountMock struct {
	mock.Mock
}

func (_m *MountMock) GetDeviceStats(path string) (*DeviceStats, error) {
	ret := _m.Called(path)

	return ret.Get(0).(*DeviceStats), ret.Error(1)
}

// NewFakeMounter returns fake mounter instance
func NewFakeMounter() *mount.FakeMounter {
	return &mount.FakeMounter{
		MountPoints: []mount.MountPoint{},
	}
}

// NewFakeSafeFormatAndMounter returns base Fake mounter instance
func NewFakeSafeFormatAndMounter() *mount.SafeFormatAndMount {
	return &mount.SafeFormatAndMount{
		Interface: NewFakeMounter(),
		Exec:      &exec.FakeExec{DisableScripts: true},
	}
}

// GetInstanceID provides a mock function with given fields:
func (_m *MountMock) GetInstanceID() (string, error) {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// IsLikelyNotMountPointAttach provides a mock function with given fields: targetpath
func (_m *MountMock) IsLikelyNotMountPointAttach(targetpath string) (bool, error) {
	ret := _m.Called(targetpath)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(targetpath)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(targetpath)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ScanForAttach provides a mock function with given fields: devicePath
func (_m *MountMock) ScanForAttach(devicePath string) error {
	ret := _m.Called(devicePath)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(devicePath)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetDevicePath provides a mock function with given fields: volumeID
func (_m *MountMock) GetDevicePath(volumeID string) (string, error) {
	ret := _m.Called(volumeID)

	var r0 string
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(volumeID)
	} else {
		r0 = ret.Get(0).(string)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(volumeID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UnmountPath provides a mock function with given fields: mountPath
func (_m *MountMock) UnmountPath(mountPath string) error {
	ret := _m.Called(mountPath)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(mountPath)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetBaseMounter provides a mock function
func (_m *MountMock) Mounter() *mount.SafeFormatAndMount {
	scripts := []struct {
		cmd    string
		output []byte
		err    error
	}{
		{
			cmd:    "findmnt",
			output: []byte("devicepath"),
			err:    nil,
		},
		{
			cmd:    "blkid",
			output: []byte("UUID=\"1b47881a-1563-4896-a178-eec887b759de\" \n TYPE=\"ext4\""),
			err:    nil,
		},
	}

	fakeexec := &exec.FakeExec{}
	for _, s := range scripts {
		fakeCmd := &exec.FakeCmd{
			CombinedOutputScript: []exec.FakeAction{
				func() ([]byte, []byte, error) { return s.output, nil, s.err },
			},
		}
		cmdAction := func(cmd string, args ...string) utilsexec.Cmd {
			command := exec.InitFakeCmd(fakeCmd, s.cmd)
			return command
		}
		fakeexec.CommandScript = append(fakeexec.CommandScript, cmdAction)
	}

	return &mount.SafeFormatAndMount{
		Interface: NewFakeMounter(),
		Exec:      fakeexec,
	}
}

func (_m *MountMock) MakeDir(pathname string) error {
	return nil
}

// MakeFile creates an empty file
func (_m *MountMock) MakeFile(pathname string) error {
	return nil
}

func (_m *MountMock) GetMountFs(pathname string) ([]byte, error) {
	return []byte("devicepath"), nil
}
