// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ServiceCatalogControllerManagersGetter has a method to return a ServiceCatalogControllerManagerInterface.
// A group's client should implement this interface.
type ServiceCatalogControllerManagersGetter interface {
	ServiceCatalogControllerManagers() ServiceCatalogControllerManagerInterface
}

// ServiceCatalogControllerManagerInterface has methods to work with ServiceCatalogControllerManager resources.
type ServiceCatalogControllerManagerInterface interface {
	Create(ctx context.Context, serviceCatalogControllerManager *v1.ServiceCatalogControllerManager, opts metav1.CreateOptions) (*v1.ServiceCatalogControllerManager, error)
	Update(ctx context.Context, serviceCatalogControllerManager *v1.ServiceCatalogControllerManager, opts metav1.UpdateOptions) (*v1.ServiceCatalogControllerManager, error)
	UpdateStatus(ctx context.Context, serviceCatalogControllerManager *v1.ServiceCatalogControllerManager, opts metav1.UpdateOptions) (*v1.ServiceCatalogControllerManager, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ServiceCatalogControllerManager, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ServiceCatalogControllerManagerList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ServiceCatalogControllerManager, err error)
	ServiceCatalogControllerManagerExpansion
}

// serviceCatalogControllerManagers implements ServiceCatalogControllerManagerInterface
type serviceCatalogControllerManagers struct {
	client rest.Interface
}

// newServiceCatalogControllerManagers returns a ServiceCatalogControllerManagers
func newServiceCatalogControllerManagers(c *OperatorV1Client) *serviceCatalogControllerManagers {
	return &serviceCatalogControllerManagers{
		client: c.RESTClient(),
	}
}

// Get takes name of the serviceCatalogControllerManager, and returns the corresponding serviceCatalogControllerManager object, and an error if there is any.
func (c *serviceCatalogControllerManagers) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Get().
		Resource("servicecatalogcontrollermanagers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ServiceCatalogControllerManagers that match those selectors.
func (c *serviceCatalogControllerManagers) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ServiceCatalogControllerManagerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ServiceCatalogControllerManagerList{}
	err = c.client.Get().
		Resource("servicecatalogcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested serviceCatalogControllerManagers.
func (c *serviceCatalogControllerManagers) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("servicecatalogcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a serviceCatalogControllerManager and creates it.  Returns the server's representation of the serviceCatalogControllerManager, and an error, if there is any.
func (c *serviceCatalogControllerManagers) Create(ctx context.Context, serviceCatalogControllerManager *v1.ServiceCatalogControllerManager, opts metav1.CreateOptions) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Post().
		Resource("servicecatalogcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(serviceCatalogControllerManager).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a serviceCatalogControllerManager and updates it. Returns the server's representation of the serviceCatalogControllerManager, and an error, if there is any.
func (c *serviceCatalogControllerManagers) Update(ctx context.Context, serviceCatalogControllerManager *v1.ServiceCatalogControllerManager, opts metav1.UpdateOptions) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Put().
		Resource("servicecatalogcontrollermanagers").
		Name(serviceCatalogControllerManager.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(serviceCatalogControllerManager).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *serviceCatalogControllerManagers) UpdateStatus(ctx context.Context, serviceCatalogControllerManager *v1.ServiceCatalogControllerManager, opts metav1.UpdateOptions) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Put().
		Resource("servicecatalogcontrollermanagers").
		Name(serviceCatalogControllerManager.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(serviceCatalogControllerManager).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the serviceCatalogControllerManager and deletes it. Returns an error if one occurs.
func (c *serviceCatalogControllerManagers) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("servicecatalogcontrollermanagers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *serviceCatalogControllerManagers) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("servicecatalogcontrollermanagers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched serviceCatalogControllerManager.
func (c *serviceCatalogControllerManagers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Patch(pt).
		Resource("servicecatalogcontrollermanagers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
