/*
Copyright 2020 The Kubernetes Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/k8snetworkplumbingwg/multi-networkpolicy/pkg/apis/k8s.cni.cncf.io/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// MultiNetworkPolicyLister helps list MultiNetworkPolicies.
type MultiNetworkPolicyLister interface {
	// List lists all MultiNetworkPolicies in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.MultiNetworkPolicy, err error)
	// MultiNetworkPolicies returns an object that can list and get MultiNetworkPolicies.
	MultiNetworkPolicies(namespace string) MultiNetworkPolicyNamespaceLister
	MultiNetworkPolicyListerExpansion
}

// multiNetworkPolicyLister implements the MultiNetworkPolicyLister interface.
type multiNetworkPolicyLister struct {
	indexer cache.Indexer
}

// NewMultiNetworkPolicyLister returns a new MultiNetworkPolicyLister.
func NewMultiNetworkPolicyLister(indexer cache.Indexer) MultiNetworkPolicyLister {
	return &multiNetworkPolicyLister{indexer: indexer}
}

// List lists all MultiNetworkPolicies in the indexer.
func (s *multiNetworkPolicyLister) List(selector labels.Selector) (ret []*v1beta1.MultiNetworkPolicy, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.MultiNetworkPolicy))
	})
	return ret, err
}

// MultiNetworkPolicies returns an object that can list and get MultiNetworkPolicies.
func (s *multiNetworkPolicyLister) MultiNetworkPolicies(namespace string) MultiNetworkPolicyNamespaceLister {
	return multiNetworkPolicyNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// MultiNetworkPolicyNamespaceLister helps list and get MultiNetworkPolicies.
type MultiNetworkPolicyNamespaceLister interface {
	// List lists all MultiNetworkPolicies in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta1.MultiNetworkPolicy, err error)
	// Get retrieves the MultiNetworkPolicy from the indexer for a given namespace and name.
	Get(name string) (*v1beta1.MultiNetworkPolicy, error)
	MultiNetworkPolicyNamespaceListerExpansion
}

// multiNetworkPolicyNamespaceLister implements the MultiNetworkPolicyNamespaceLister
// interface.
type multiNetworkPolicyNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all MultiNetworkPolicies in the indexer for a given namespace.
func (s multiNetworkPolicyNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.MultiNetworkPolicy, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.MultiNetworkPolicy))
	})
	return ret, err
}

// Get retrieves the MultiNetworkPolicy from the indexer for a given namespace and name.
func (s multiNetworkPolicyNamespaceLister) Get(name string) (*v1beta1.MultiNetworkPolicy, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("multinetworkpolicy"), name)
	}
	return obj.(*v1beta1.MultiNetworkPolicy), nil
}
