package trafficmanager

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/trafficmanager/mgmt/2017-09-01-preview/trafficmanager instead.
// HeatMapClient is the client for the HeatMap methods of the Trafficmanager service.
type HeatMapClient struct {
	BaseClient
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/trafficmanager/mgmt/2017-09-01-preview/trafficmanager instead.
// NewHeatMapClient creates an instance of the HeatMapClient client.
func NewHeatMapClient(subscriptionID string) HeatMapClient {
	return NewHeatMapClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/trafficmanager/mgmt/2017-09-01-preview/trafficmanager instead.
// NewHeatMapClientWithBaseURI creates an instance of the HeatMapClient client.
func NewHeatMapClientWithBaseURI(baseURI string, subscriptionID string) HeatMapClient {
	return HeatMapClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/trafficmanager/mgmt/2017-09-01-preview/trafficmanager instead.
// Get gets latest heatmap for Traffic Manager profile.
//
// resourceGroupName is the name of the resource group containing the Traffic Manager endpoint. profileName is the
// name of the Traffic Manager profile. topLeft is the top left latitude,longitude pair of the rectangular viewport
// to query for. botRight is the bottom right latitude,longitude pair of the rectangular viewport to query for.
func (client HeatMapClient) Get(ctx context.Context, resourceGroupName string, profileName string, topLeft []float64, botRight []float64) (result HeatMapModel, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: topLeft,
			Constraints: []validation.Constraint{{Target: "topLeft", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "topLeft", Name: validation.MaxItems, Rule: 2, Chain: nil},
					{Target: "topLeft", Name: validation.MinItems, Rule: 2, Chain: nil},
				}}}},
		{TargetValue: botRight,
			Constraints: []validation.Constraint{{Target: "botRight", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "botRight", Name: validation.MaxItems, Rule: 2, Chain: nil},
					{Target: "botRight", Name: validation.MinItems, Rule: 2, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("trafficmanager.HeatMapClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, profileName, topLeft, botRight)
	if err != nil {
		err = autorest.NewErrorWithError(err, "trafficmanager.HeatMapClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "trafficmanager.HeatMapClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "trafficmanager.HeatMapClient", "Get", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/trafficmanager/mgmt/2017-09-01-preview/trafficmanager instead.
// GetPreparer prepares the Get request.
func (client HeatMapClient) GetPreparer(ctx context.Context, resourceGroupName string, profileName string, topLeft []float64, botRight []float64) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"heatMapType":       autorest.Encode("path", "default"),
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if topLeft != nil && len(topLeft) > 0 {
		queryParameters["topLeft"] = autorest.Encode("query", topLeft, ",")
	}
	if botRight != nil && len(botRight) > 0 {
		queryParameters["botRight"] = autorest.Encode("query", botRight, ",")
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/heatMaps/{heatMapType}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/trafficmanager/mgmt/2017-09-01-preview/trafficmanager instead.
// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client HeatMapClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/trafficmanager/mgmt/2017-09-01-preview/trafficmanager instead.
// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client HeatMapClient) GetResponder(resp *http.Response) (result HeatMapModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
