// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchGetReportsInput struct {
	_ struct{} `type:"structure"`

	// An array of ARNs that identify the Report objects to return.
	//
	// ReportArns is a required field
	ReportArns []string `locationName:"reportArns" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetReportsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetReportsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetReportsInput"}

	if s.ReportArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReportArns"))
	}
	if s.ReportArns != nil && len(s.ReportArns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ReportArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchGetReportsOutput struct {
	_ struct{} `type:"structure"`

	// The array of Report objects returned by BatchGetReports.
	Reports []Report `locationName:"reports" min:"1" type:"list"`

	// An array of ARNs passed to BatchGetReportGroups that are not associated with
	// a Report.
	ReportsNotFound []string `locationName:"reportsNotFound" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchGetReportsOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetReports = "BatchGetReports"

// BatchGetReportsRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Returns an array of reports.
//
//    // Example sending a request using BatchGetReportsRequest.
//    req := client.BatchGetReportsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetReports
func (c *Client) BatchGetReportsRequest(input *BatchGetReportsInput) BatchGetReportsRequest {
	op := &aws.Operation{
		Name:       opBatchGetReports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetReportsInput{}
	}

	req := c.newRequest(op, input, &BatchGetReportsOutput{})
	return BatchGetReportsRequest{Request: req, Input: input, Copy: c.BatchGetReportsRequest}
}

// BatchGetReportsRequest is the request type for the
// BatchGetReports API operation.
type BatchGetReportsRequest struct {
	*aws.Request
	Input *BatchGetReportsInput
	Copy  func(*BatchGetReportsInput) BatchGetReportsRequest
}

// Send marshals and sends the BatchGetReports API request.
func (r BatchGetReportsRequest) Send(ctx context.Context) (*BatchGetReportsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetReportsResponse{
		BatchGetReportsOutput: r.Request.Data.(*BatchGetReportsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetReportsResponse is the response type for the
// BatchGetReports API operation.
type BatchGetReportsResponse struct {
	*BatchGetReportsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetReports request.
func (r *BatchGetReportsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
