// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/speech/v1/cloud_speech.proto

package speech // import "google.golang.org/genproto/googleapis/cloud/speech/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/any"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import status "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Audio encoding of the data sent in the audio message. All encodings support
// only 1 channel (mono) audio. Only `FLAC` and `WAV` include a header that
// describes the bytes of audio that follow the header. The other encodings
// are raw audio bytes with no header.
//
// For best results, the audio source should be captured and transmitted using
// a lossless encoding (`FLAC` or `LINEAR16`). Recognition accuracy may be
// reduced if lossy codecs, which include the other codecs listed in
// this section, are used to capture or transmit the audio, particularly if
// background noise is present.
type RecognitionConfig_AudioEncoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
	RecognitionConfig_ENCODING_UNSPECIFIED RecognitionConfig_AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	RecognitionConfig_LINEAR16 RecognitionConfig_AudioEncoding = 1
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
	// Codec) is the recommended encoding because it is
	// lossless--therefore recognition is not compromised--and
	// requires only about half the bandwidth of `LINEAR16`. `FLAC` stream
	// encoding supports 16-bit and 24-bit samples, however, not all fields in
	// `STREAMINFO` are supported.
	RecognitionConfig_FLAC RecognitionConfig_AudioEncoding = 2
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	RecognitionConfig_MULAW RecognitionConfig_AudioEncoding = 3
	// Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
	RecognitionConfig_AMR RecognitionConfig_AudioEncoding = 4
	// Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
	RecognitionConfig_AMR_WB RecognitionConfig_AudioEncoding = 5
	// Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)).
	// `sample_rate_hertz` must be 16000.
	RecognitionConfig_OGG_OPUS RecognitionConfig_AudioEncoding = 6
	// Although the use of lossy encodings is not recommended, if a very low
	// bitrate encoding is required, `OGG_OPUS` is highly preferred over
	// Speex encoding. The [Speex](https://speex.org/)  encoding supported by
	// Cloud Speech API has a header byte in each block, as in MIME type
	// `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in
	// [RFC 5574](https://tools.ietf.org/html/rfc5574).
	// The stream is a sequence of blocks, one block per RTP packet. Each block
	// starts with a byte containing the length of the block, in bytes, followed
	// by one or more frames of Speex data, padded to an integral number of
	// bytes (octets) as specified in RFC 5574. In other words, each RTP header
	// is replaced with a single byte containing the block length. Only Speex
	// wideband is supported. `sample_rate_hertz` must be 16000.
	RecognitionConfig_SPEEX_WITH_HEADER_BYTE RecognitionConfig_AudioEncoding = 7
)

var RecognitionConfig_AudioEncoding_name = map[int32]string{
	0: "ENCODING_UNSPECIFIED",
	1: "LINEAR16",
	2: "FLAC",
	3: "MULAW",
	4: "AMR",
	5: "AMR_WB",
	6: "OGG_OPUS",
	7: "SPEEX_WITH_HEADER_BYTE",
}
var RecognitionConfig_AudioEncoding_value = map[string]int32{
	"ENCODING_UNSPECIFIED":   0,
	"LINEAR16":               1,
	"FLAC":                   2,
	"MULAW":                  3,
	"AMR":                    4,
	"AMR_WB":                 5,
	"OGG_OPUS":               6,
	"SPEEX_WITH_HEADER_BYTE": 7,
}

func (x RecognitionConfig_AudioEncoding) String() string {
	return proto.EnumName(RecognitionConfig_AudioEncoding_name, int32(x))
}
func (RecognitionConfig_AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{4, 0}
}

// Indicates the type of speech event.
type StreamingRecognizeResponse_SpeechEventType int32

const (
	// No speech event specified.
	StreamingRecognizeResponse_SPEECH_EVENT_UNSPECIFIED StreamingRecognizeResponse_SpeechEventType = 0
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection. This event is only sent if
	// `single_utterance` was set to `true`, and is not used otherwise.
	StreamingRecognizeResponse_END_OF_SINGLE_UTTERANCE StreamingRecognizeResponse_SpeechEventType = 1
)

var StreamingRecognizeResponse_SpeechEventType_name = map[int32]string{
	0: "SPEECH_EVENT_UNSPECIFIED",
	1: "END_OF_SINGLE_UTTERANCE",
}
var StreamingRecognizeResponse_SpeechEventType_value = map[string]int32{
	"SPEECH_EVENT_UNSPECIFIED": 0,
	"END_OF_SINGLE_UTTERANCE":  1,
}

func (x StreamingRecognizeResponse_SpeechEventType) String() string {
	return proto.EnumName(StreamingRecognizeResponse_SpeechEventType_name, int32(x))
}
func (StreamingRecognizeResponse_SpeechEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{10, 0}
}

// The top-level message sent by the client for the `Recognize` method.
type RecognizeRequest struct {
	// *Required* Provides information to the recognizer that specifies how to
	// process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// *Required* The audio data to be recognized.
	Audio                *RecognitionAudio `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RecognizeRequest) Reset()         { *m = RecognizeRequest{} }
func (m *RecognizeRequest) String() string { return proto.CompactTextString(m) }
func (*RecognizeRequest) ProtoMessage()    {}
func (*RecognizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{0}
}
func (m *RecognizeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecognizeRequest.Unmarshal(m, b)
}
func (m *RecognizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecognizeRequest.Marshal(b, m, deterministic)
}
func (dst *RecognizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecognizeRequest.Merge(dst, src)
}
func (m *RecognizeRequest) XXX_Size() int {
	return xxx_messageInfo_RecognizeRequest.Size(m)
}
func (m *RecognizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RecognizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RecognizeRequest proto.InternalMessageInfo

func (m *RecognizeRequest) GetConfig() *RecognitionConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *RecognizeRequest) GetAudio() *RecognitionAudio {
	if m != nil {
		return m.Audio
	}
	return nil
}

// The top-level message sent by the client for the `LongRunningRecognize`
// method.
type LongRunningRecognizeRequest struct {
	// *Required* Provides information to the recognizer that specifies how to
	// process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// *Required* The audio data to be recognized.
	Audio                *RecognitionAudio `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LongRunningRecognizeRequest) Reset()         { *m = LongRunningRecognizeRequest{} }
func (m *LongRunningRecognizeRequest) String() string { return proto.CompactTextString(m) }
func (*LongRunningRecognizeRequest) ProtoMessage()    {}
func (*LongRunningRecognizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{1}
}
func (m *LongRunningRecognizeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LongRunningRecognizeRequest.Unmarshal(m, b)
}
func (m *LongRunningRecognizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LongRunningRecognizeRequest.Marshal(b, m, deterministic)
}
func (dst *LongRunningRecognizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LongRunningRecognizeRequest.Merge(dst, src)
}
func (m *LongRunningRecognizeRequest) XXX_Size() int {
	return xxx_messageInfo_LongRunningRecognizeRequest.Size(m)
}
func (m *LongRunningRecognizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LongRunningRecognizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LongRunningRecognizeRequest proto.InternalMessageInfo

func (m *LongRunningRecognizeRequest) GetConfig() *RecognitionConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *LongRunningRecognizeRequest) GetAudio() *RecognitionAudio {
	if m != nil {
		return m.Audio
	}
	return nil
}

// The top-level message sent by the client for the `StreamingRecognize` method.
// Multiple `StreamingRecognizeRequest` messages are sent. The first message
// must contain a `streaming_config` message and must not contain `audio` data.
// All subsequent messages must contain `audio` data and must not contain a
// `streaming_config` message.
type StreamingRecognizeRequest struct {
	// The streaming request, which is either a streaming config or audio content.
	//
	// Types that are valid to be assigned to StreamingRequest:
	//	*StreamingRecognizeRequest_StreamingConfig
	//	*StreamingRecognizeRequest_AudioContent
	StreamingRequest     isStreamingRecognizeRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *StreamingRecognizeRequest) Reset()         { *m = StreamingRecognizeRequest{} }
func (m *StreamingRecognizeRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognizeRequest) ProtoMessage()    {}
func (*StreamingRecognizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{2}
}
func (m *StreamingRecognizeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognizeRequest.Unmarshal(m, b)
}
func (m *StreamingRecognizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognizeRequest.Marshal(b, m, deterministic)
}
func (dst *StreamingRecognizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognizeRequest.Merge(dst, src)
}
func (m *StreamingRecognizeRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognizeRequest.Size(m)
}
func (m *StreamingRecognizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognizeRequest proto.InternalMessageInfo

type isStreamingRecognizeRequest_StreamingRequest interface {
	isStreamingRecognizeRequest_StreamingRequest()
}

type StreamingRecognizeRequest_StreamingConfig struct {
	StreamingConfig *StreamingRecognitionConfig `protobuf:"bytes,1,opt,name=streaming_config,json=streamingConfig,proto3,oneof"`
}

type StreamingRecognizeRequest_AudioContent struct {
	AudioContent []byte `protobuf:"bytes,2,opt,name=audio_content,json=audioContent,proto3,oneof"`
}

func (*StreamingRecognizeRequest_StreamingConfig) isStreamingRecognizeRequest_StreamingRequest() {}

func (*StreamingRecognizeRequest_AudioContent) isStreamingRecognizeRequest_StreamingRequest() {}

func (m *StreamingRecognizeRequest) GetStreamingRequest() isStreamingRecognizeRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (m *StreamingRecognizeRequest) GetStreamingConfig() *StreamingRecognitionConfig {
	if x, ok := m.GetStreamingRequest().(*StreamingRecognizeRequest_StreamingConfig); ok {
		return x.StreamingConfig
	}
	return nil
}

func (m *StreamingRecognizeRequest) GetAudioContent() []byte {
	if x, ok := m.GetStreamingRequest().(*StreamingRecognizeRequest_AudioContent); ok {
		return x.AudioContent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StreamingRecognizeRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StreamingRecognizeRequest_OneofMarshaler, _StreamingRecognizeRequest_OneofUnmarshaler, _StreamingRecognizeRequest_OneofSizer, []interface{}{
		(*StreamingRecognizeRequest_StreamingConfig)(nil),
		(*StreamingRecognizeRequest_AudioContent)(nil),
	}
}

func _StreamingRecognizeRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StreamingRecognizeRequest)
	// streaming_request
	switch x := m.StreamingRequest.(type) {
	case *StreamingRecognizeRequest_StreamingConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StreamingConfig); err != nil {
			return err
		}
	case *StreamingRecognizeRequest_AudioContent:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.AudioContent)
	case nil:
	default:
		return fmt.Errorf("StreamingRecognizeRequest.StreamingRequest has unexpected type %T", x)
	}
	return nil
}

func _StreamingRecognizeRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StreamingRecognizeRequest)
	switch tag {
	case 1: // streaming_request.streaming_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingRecognitionConfig)
		err := b.DecodeMessage(msg)
		m.StreamingRequest = &StreamingRecognizeRequest_StreamingConfig{msg}
		return true, err
	case 2: // streaming_request.audio_content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StreamingRequest = &StreamingRecognizeRequest_AudioContent{x}
		return true, err
	default:
		return false, nil
	}
}

func _StreamingRecognizeRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StreamingRecognizeRequest)
	// streaming_request
	switch x := m.StreamingRequest.(type) {
	case *StreamingRecognizeRequest_StreamingConfig:
		s := proto.Size(x.StreamingConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StreamingRecognizeRequest_AudioContent:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.AudioContent)))
		n += len(x.AudioContent)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Provides information to the recognizer that specifies how to process the
// request.
type StreamingRecognitionConfig struct {
	// *Required* Provides information to the recognizer that specifies how to
	// process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// *Optional* If `false` or omitted, the recognizer will perform continuous
	// recognition (continuing to wait for and process audio even if the user
	// pauses speaking) until the client closes the input stream (gRPC API) or
	// until the maximum time limit has been reached. May return multiple
	// `StreamingRecognitionResult`s with the `is_final` flag set to `true`.
	//
	// If `true`, the recognizer will detect a single spoken utterance. When it
	// detects that the user has paused or stopped speaking, it will return an
	// `END_OF_SINGLE_UTTERANCE` event and cease recognition. It will return no
	// more than one `StreamingRecognitionResult` with the `is_final` flag set to
	// `true`.
	SingleUtterance bool `protobuf:"varint,2,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// *Optional* If `true`, interim results (tentative hypotheses) may be
	// returned as they become available (these interim results are indicated with
	// the `is_final=false` flag).
	// If `false` or omitted, only `is_final=true` result(s) are returned.
	InterimResults       bool     `protobuf:"varint,3,opt,name=interim_results,json=interimResults,proto3" json:"interim_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingRecognitionConfig) Reset()         { *m = StreamingRecognitionConfig{} }
func (m *StreamingRecognitionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognitionConfig) ProtoMessage()    {}
func (*StreamingRecognitionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{3}
}
func (m *StreamingRecognitionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognitionConfig.Unmarshal(m, b)
}
func (m *StreamingRecognitionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognitionConfig.Marshal(b, m, deterministic)
}
func (dst *StreamingRecognitionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognitionConfig.Merge(dst, src)
}
func (m *StreamingRecognitionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognitionConfig.Size(m)
}
func (m *StreamingRecognitionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognitionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognitionConfig proto.InternalMessageInfo

func (m *StreamingRecognitionConfig) GetConfig() *RecognitionConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *StreamingRecognitionConfig) GetSingleUtterance() bool {
	if m != nil {
		return m.SingleUtterance
	}
	return false
}

func (m *StreamingRecognitionConfig) GetInterimResults() bool {
	if m != nil {
		return m.InterimResults
	}
	return false
}

// Provides information to the recognizer that specifies how to process the
// request.
type RecognitionConfig struct {
	// *Required* Encoding of audio data sent in all `RecognitionAudio` messages.
	Encoding RecognitionConfig_AudioEncoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.cloud.speech.v1.RecognitionConfig_AudioEncoding" json:"encoding,omitempty"`
	// *Required* Sample rate in Hertz of the audio data sent in all
	// `RecognitionAudio` messages. Valid values are: 8000-48000.
	// 16000 is optimal. For best results, set the sampling rate of the audio
	// source to 16000 Hz. If that's not possible, use the native sample rate of
	// the audio source (instead of re-sampling).
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// *Optional* Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechRecognitionResult`.
	// The server may return fewer than `max_alternatives`.
	// Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
	// one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,4,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// *Optional* If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	ProfanityFilter bool `protobuf:"varint,5,opt,name=profanity_filter,json=profanityFilter,proto3" json:"profanity_filter,omitempty"`
	// *Optional* A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,6,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// *Optional* If `true`, the top result includes a list of words and
	// the start and end time offsets (timestamps) for those words. If
	// `false`, no word-level time offset information is returned. The default is
	// `false`.
	EnableWordTimeOffsets bool     `protobuf:"varint,8,opt,name=enable_word_time_offsets,json=enableWordTimeOffsets,proto3" json:"enable_word_time_offsets,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *RecognitionConfig) Reset()         { *m = RecognitionConfig{} }
func (m *RecognitionConfig) String() string { return proto.CompactTextString(m) }
func (*RecognitionConfig) ProtoMessage()    {}
func (*RecognitionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{4}
}
func (m *RecognitionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecognitionConfig.Unmarshal(m, b)
}
func (m *RecognitionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecognitionConfig.Marshal(b, m, deterministic)
}
func (dst *RecognitionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecognitionConfig.Merge(dst, src)
}
func (m *RecognitionConfig) XXX_Size() int {
	return xxx_messageInfo_RecognitionConfig.Size(m)
}
func (m *RecognitionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_RecognitionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_RecognitionConfig proto.InternalMessageInfo

func (m *RecognitionConfig) GetEncoding() RecognitionConfig_AudioEncoding {
	if m != nil {
		return m.Encoding
	}
	return RecognitionConfig_ENCODING_UNSPECIFIED
}

func (m *RecognitionConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func (m *RecognitionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *RecognitionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *RecognitionConfig) GetProfanityFilter() bool {
	if m != nil {
		return m.ProfanityFilter
	}
	return false
}

func (m *RecognitionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *RecognitionConfig) GetEnableWordTimeOffsets() bool {
	if m != nil {
		return m.EnableWordTimeOffsets
	}
	return false
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// *Optional* A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases              []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechContext) Reset()         { *m = SpeechContext{} }
func (m *SpeechContext) String() string { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()    {}
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{5}
}
func (m *SpeechContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechContext.Unmarshal(m, b)
}
func (m *SpeechContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechContext.Marshal(b, m, deterministic)
}
func (dst *SpeechContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechContext.Merge(dst, src)
}
func (m *SpeechContext) XXX_Size() int {
	return xxx_messageInfo_SpeechContext.Size(m)
}
func (m *SpeechContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechContext.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechContext proto.InternalMessageInfo

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// Contains audio data in the encoding specified in the `RecognitionConfig`.
// Either `content` or `uri` must be supplied. Supplying both or neither
// returns [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. See
// [audio limits](https://cloud.google.com/speech/limits#content).
type RecognitionAudio struct {
	// The audio source, which is either inline content or a Google Cloud
	// Storage uri.
	//
	// Types that are valid to be assigned to AudioSource:
	//	*RecognitionAudio_Content
	//	*RecognitionAudio_Uri
	AudioSource          isRecognitionAudio_AudioSource `protobuf_oneof:"audio_source"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *RecognitionAudio) Reset()         { *m = RecognitionAudio{} }
func (m *RecognitionAudio) String() string { return proto.CompactTextString(m) }
func (*RecognitionAudio) ProtoMessage()    {}
func (*RecognitionAudio) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{6}
}
func (m *RecognitionAudio) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecognitionAudio.Unmarshal(m, b)
}
func (m *RecognitionAudio) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecognitionAudio.Marshal(b, m, deterministic)
}
func (dst *RecognitionAudio) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecognitionAudio.Merge(dst, src)
}
func (m *RecognitionAudio) XXX_Size() int {
	return xxx_messageInfo_RecognitionAudio.Size(m)
}
func (m *RecognitionAudio) XXX_DiscardUnknown() {
	xxx_messageInfo_RecognitionAudio.DiscardUnknown(m)
}

var xxx_messageInfo_RecognitionAudio proto.InternalMessageInfo

type isRecognitionAudio_AudioSource interface {
	isRecognitionAudio_AudioSource()
}

type RecognitionAudio_Content struct {
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}

type RecognitionAudio_Uri struct {
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3,oneof"`
}

func (*RecognitionAudio_Content) isRecognitionAudio_AudioSource() {}

func (*RecognitionAudio_Uri) isRecognitionAudio_AudioSource() {}

func (m *RecognitionAudio) GetAudioSource() isRecognitionAudio_AudioSource {
	if m != nil {
		return m.AudioSource
	}
	return nil
}

func (m *RecognitionAudio) GetContent() []byte {
	if x, ok := m.GetAudioSource().(*RecognitionAudio_Content); ok {
		return x.Content
	}
	return nil
}

func (m *RecognitionAudio) GetUri() string {
	if x, ok := m.GetAudioSource().(*RecognitionAudio_Uri); ok {
		return x.Uri
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RecognitionAudio) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RecognitionAudio_OneofMarshaler, _RecognitionAudio_OneofUnmarshaler, _RecognitionAudio_OneofSizer, []interface{}{
		(*RecognitionAudio_Content)(nil),
		(*RecognitionAudio_Uri)(nil),
	}
}

func _RecognitionAudio_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RecognitionAudio)
	// audio_source
	switch x := m.AudioSource.(type) {
	case *RecognitionAudio_Content:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Content)
	case *RecognitionAudio_Uri:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Uri)
	case nil:
	default:
		return fmt.Errorf("RecognitionAudio.AudioSource has unexpected type %T", x)
	}
	return nil
}

func _RecognitionAudio_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RecognitionAudio)
	switch tag {
	case 1: // audio_source.content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.AudioSource = &RecognitionAudio_Content{x}
		return true, err
	case 2: // audio_source.uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.AudioSource = &RecognitionAudio_Uri{x}
		return true, err
	default:
		return false, nil
	}
}

func _RecognitionAudio_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RecognitionAudio)
	// audio_source
	switch x := m.AudioSource.(type) {
	case *RecognitionAudio_Content:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Content)))
		n += len(x.Content)
	case *RecognitionAudio_Uri:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Uri)))
		n += len(x.Uri)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The only message returned to the client by the `Recognize` method. It
// contains the result as zero or more sequential `SpeechRecognitionResult`
// messages.
type RecognizeResponse struct {
	// *Output-only* Sequential list of transcription results corresponding to
	// sequential portions of audio.
	Results              []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *RecognizeResponse) Reset()         { *m = RecognizeResponse{} }
func (m *RecognizeResponse) String() string { return proto.CompactTextString(m) }
func (*RecognizeResponse) ProtoMessage()    {}
func (*RecognizeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{7}
}
func (m *RecognizeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecognizeResponse.Unmarshal(m, b)
}
func (m *RecognizeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecognizeResponse.Marshal(b, m, deterministic)
}
func (dst *RecognizeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecognizeResponse.Merge(dst, src)
}
func (m *RecognizeResponse) XXX_Size() int {
	return xxx_messageInfo_RecognizeResponse.Size(m)
}
func (m *RecognizeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RecognizeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RecognizeResponse proto.InternalMessageInfo

func (m *RecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The only message returned to the client by the `LongRunningRecognize` method.
// It contains the result as zero or more sequential `SpeechRecognitionResult`
// messages. It is included in the `result.response` field of the `Operation`
// returned by the `GetOperation` call of the `google::longrunning::Operations`
// service.
type LongRunningRecognizeResponse struct {
	// *Output-only* Sequential list of transcription results corresponding to
	// sequential portions of audio.
	Results              []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *LongRunningRecognizeResponse) Reset()         { *m = LongRunningRecognizeResponse{} }
func (m *LongRunningRecognizeResponse) String() string { return proto.CompactTextString(m) }
func (*LongRunningRecognizeResponse) ProtoMessage()    {}
func (*LongRunningRecognizeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{8}
}
func (m *LongRunningRecognizeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LongRunningRecognizeResponse.Unmarshal(m, b)
}
func (m *LongRunningRecognizeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LongRunningRecognizeResponse.Marshal(b, m, deterministic)
}
func (dst *LongRunningRecognizeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LongRunningRecognizeResponse.Merge(dst, src)
}
func (m *LongRunningRecognizeResponse) XXX_Size() int {
	return xxx_messageInfo_LongRunningRecognizeResponse.Size(m)
}
func (m *LongRunningRecognizeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LongRunningRecognizeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LongRunningRecognizeResponse proto.InternalMessageInfo

func (m *LongRunningRecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// Describes the progress of a long-running `LongRunningRecognize` call. It is
// included in the `metadata` field of the `Operation` returned by the
// `GetOperation` call of the `google::longrunning::Operations` service.
type LongRunningRecognizeMetadata struct {
	// Approximate percentage of audio processed thus far. Guaranteed to be 100
	// when the audio is fully processed and the results are available.
	ProgressPercent int32 `protobuf:"varint,1,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent processing update.
	LastUpdateTime       *timestamp.Timestamp `protobuf:"bytes,3,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LongRunningRecognizeMetadata) Reset()         { *m = LongRunningRecognizeMetadata{} }
func (m *LongRunningRecognizeMetadata) String() string { return proto.CompactTextString(m) }
func (*LongRunningRecognizeMetadata) ProtoMessage()    {}
func (*LongRunningRecognizeMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{9}
}
func (m *LongRunningRecognizeMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LongRunningRecognizeMetadata.Unmarshal(m, b)
}
func (m *LongRunningRecognizeMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LongRunningRecognizeMetadata.Marshal(b, m, deterministic)
}
func (dst *LongRunningRecognizeMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LongRunningRecognizeMetadata.Merge(dst, src)
}
func (m *LongRunningRecognizeMetadata) XXX_Size() int {
	return xxx_messageInfo_LongRunningRecognizeMetadata.Size(m)
}
func (m *LongRunningRecognizeMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LongRunningRecognizeMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LongRunningRecognizeMetadata proto.InternalMessageInfo

func (m *LongRunningRecognizeMetadata) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *LongRunningRecognizeMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *LongRunningRecognizeMetadata) GetLastUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

// `StreamingRecognizeResponse` is the only message returned to the client by
// `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
// messages are streamed back to the client. If there is no recognizable
// audio, and `single_utterance` is set to false, then no messages are streamed
// back to the client.
//
// Here's an example of a series of ten `StreamingRecognizeResponse`s that might
// be returned while processing audio:
//
// 1. results { alternatives { transcript: "tube" } stability: 0.01 }
//
// 2. results { alternatives { transcript: "to be a" } stability: 0.01 }
//
// 3. results { alternatives { transcript: "to be" } stability: 0.9 }
//    results { alternatives { transcript: " or not to be" } stability: 0.01 }
//
// 4. results { alternatives { transcript: "to be or not to be"
//                             confidence: 0.92 }
//              alternatives { transcript: "to bee or not to bee" }
//              is_final: true }
//
// 5. results { alternatives { transcript: " that's" } stability: 0.01 }
//
// 6. results { alternatives { transcript: " that is" } stability: 0.9 }
//    results { alternatives { transcript: " the question" } stability: 0.01 }
//
// 7. results { alternatives { transcript: " that is the question"
//                             confidence: 0.98 }
//              alternatives { transcript: " that was the question" }
//              is_final: true }
//
// Notes:
//
// - Only two of the above responses #4 and #7 contain final results; they are
//   indicated by `is_final: true`. Concatenating these together generates the
//   full transcript: "to be or not to be that is the question".
//
// - The others contain interim `results`. #3 and #6 contain two interim
//   `results`: the first portion has a high stability and is less likely to
//   change; the second portion has a low stability and is very likely to
//   change. A UI designer might choose to show only high stability `results`.
//
// - The specific `stability` and `confidence` values shown above are only for
//   illustrative purposes. Actual values may vary.
//
// - In each response, only one of these fields will be set:
//     `error`,
//     `speech_event_type`, or
//     one or more (repeated) `results`.
type StreamingRecognizeResponse struct {
	// *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
	// specifies the error for the operation.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// *Output-only* This repeated list contains zero or more results that
	// correspond to consecutive portions of the audio currently being processed.
	// It contains zero or more `is_final=false` results followed by zero or one
	// `is_final=true` result (the newly settled portion).
	Results []*StreamingRecognitionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	// *Output-only* Indicates the type of speech event.
	SpeechEventType      StreamingRecognizeResponse_SpeechEventType `protobuf:"varint,4,opt,name=speech_event_type,json=speechEventType,proto3,enum=google.cloud.speech.v1.StreamingRecognizeResponse_SpeechEventType" json:"speech_event_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *StreamingRecognizeResponse) Reset()         { *m = StreamingRecognizeResponse{} }
func (m *StreamingRecognizeResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognizeResponse) ProtoMessage()    {}
func (*StreamingRecognizeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{10}
}
func (m *StreamingRecognizeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognizeResponse.Unmarshal(m, b)
}
func (m *StreamingRecognizeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognizeResponse.Marshal(b, m, deterministic)
}
func (dst *StreamingRecognizeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognizeResponse.Merge(dst, src)
}
func (m *StreamingRecognizeResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognizeResponse.Size(m)
}
func (m *StreamingRecognizeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognizeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognizeResponse proto.InternalMessageInfo

func (m *StreamingRecognizeResponse) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *StreamingRecognizeResponse) GetResults() []*StreamingRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *StreamingRecognizeResponse) GetSpeechEventType() StreamingRecognizeResponse_SpeechEventType {
	if m != nil {
		return m.SpeechEventType
	}
	return StreamingRecognizeResponse_SPEECH_EVENT_UNSPECIFIED
}

// A streaming speech recognition result corresponding to a portion of the audio
// that is currently being processed.
type StreamingRecognitionResult struct {
	// *Output-only* May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// *Output-only* If `false`, this `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, this is the final time the
	// speech service will return this particular `StreamingRecognitionResult`,
	// the recognizer will not return any further hypotheses for this portion of
	// the transcript and corresponding audio.
	IsFinal bool `protobuf:"varint,2,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// *Output-only* An estimate of the likelihood that the recognizer will not
	// change its guess about this interim result. Values range from 0.0
	// (completely unstable) to 1.0 (completely stable).
	// This field is only provided for interim results (`is_final=false`).
	// The default of 0.0 is a sentinel value indicating `stability` was not set.
	Stability            float32  `protobuf:"fixed32,3,opt,name=stability,proto3" json:"stability,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingRecognitionResult) Reset()         { *m = StreamingRecognitionResult{} }
func (m *StreamingRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognitionResult) ProtoMessage()    {}
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{11}
}
func (m *StreamingRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognitionResult.Unmarshal(m, b)
}
func (m *StreamingRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognitionResult.Marshal(b, m, deterministic)
}
func (dst *StreamingRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognitionResult.Merge(dst, src)
}
func (m *StreamingRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognitionResult.Size(m)
}
func (m *StreamingRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognitionResult proto.InternalMessageInfo

func (m *StreamingRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

func (m *StreamingRecognitionResult) GetIsFinal() bool {
	if m != nil {
		return m.IsFinal
	}
	return false
}

func (m *StreamingRecognitionResult) GetStability() float32 {
	if m != nil {
		return m.Stability
	}
	return 0
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechRecognitionResult struct {
	// *Output-only* May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	// These alternatives are ordered in terms of accuracy, with the top (first)
	// alternative being the most probable, as ranked by the recognizer.
	Alternatives         []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *SpeechRecognitionResult) Reset()         { *m = SpeechRecognitionResult{} }
func (m *SpeechRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionResult) ProtoMessage()    {}
func (*SpeechRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{12}
}
func (m *SpeechRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionResult.Unmarshal(m, b)
}
func (m *SpeechRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionResult.Marshal(b, m, deterministic)
}
func (dst *SpeechRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionResult.Merge(dst, src)
}
func (m *SpeechRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionResult.Size(m)
}
func (m *SpeechRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionResult proto.InternalMessageInfo

func (m *SpeechRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// *Output-only* Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// *Output-only* The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is typically provided only for the top hypothesis, and
	// only for `is_final=true` results. Clients should not rely on the
	// `confidence` field as it is not guaranteed to be accurate or consistent.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// *Output-only* A list of word-specific information for each recognized word.
	Words                []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SpeechRecognitionAlternative) Reset()         { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()    {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{13}
}
func (m *SpeechRecognitionAlternative) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionAlternative.Unmarshal(m, b)
}
func (m *SpeechRecognitionAlternative) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionAlternative.Marshal(b, m, deterministic)
}
func (dst *SpeechRecognitionAlternative) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionAlternative.Merge(dst, src)
}
func (m *SpeechRecognitionAlternative) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionAlternative.Size(m)
}
func (m *SpeechRecognitionAlternative) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionAlternative.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionAlternative proto.InternalMessageInfo

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	// *Output-only* Time offset relative to the beginning of the audio,
	// and corresponding to the start of the spoken word.
	// This field is only set if `enable_word_time_offsets=true` and only
	// in the top hypothesis.
	// This is an experimental feature and the accuracy of the time offset can
	// vary.
	StartTime *duration.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// *Output-only* Time offset relative to the beginning of the audio,
	// and corresponding to the end of the spoken word.
	// This field is only set if `enable_word_time_offsets=true` and only
	// in the top hypothesis.
	// This is an experimental feature and the accuracy of the time offset can
	// vary.
	EndTime *duration.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// *Output-only* The word corresponding to this set of information.
	Word                 string   `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WordInfo) Reset()         { *m = WordInfo{} }
func (m *WordInfo) String() string { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()    {}
func (*WordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_cloud_speech_0a49d136bdba2e2b, []int{14}
}
func (m *WordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WordInfo.Unmarshal(m, b)
}
func (m *WordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WordInfo.Marshal(b, m, deterministic)
}
func (dst *WordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WordInfo.Merge(dst, src)
}
func (m *WordInfo) XXX_Size() int {
	return xxx_messageInfo_WordInfo.Size(m)
}
func (m *WordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WordInfo proto.InternalMessageInfo

func (m *WordInfo) GetStartTime() *duration.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *duration.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func init() {
	proto.RegisterType((*RecognizeRequest)(nil), "google.cloud.speech.v1.RecognizeRequest")
	proto.RegisterType((*LongRunningRecognizeRequest)(nil), "google.cloud.speech.v1.LongRunningRecognizeRequest")
	proto.RegisterType((*StreamingRecognizeRequest)(nil), "google.cloud.speech.v1.StreamingRecognizeRequest")
	proto.RegisterType((*StreamingRecognitionConfig)(nil), "google.cloud.speech.v1.StreamingRecognitionConfig")
	proto.RegisterType((*RecognitionConfig)(nil), "google.cloud.speech.v1.RecognitionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.speech.v1.SpeechContext")
	proto.RegisterType((*RecognitionAudio)(nil), "google.cloud.speech.v1.RecognitionAudio")
	proto.RegisterType((*RecognizeResponse)(nil), "google.cloud.speech.v1.RecognizeResponse")
	proto.RegisterType((*LongRunningRecognizeResponse)(nil), "google.cloud.speech.v1.LongRunningRecognizeResponse")
	proto.RegisterType((*LongRunningRecognizeMetadata)(nil), "google.cloud.speech.v1.LongRunningRecognizeMetadata")
	proto.RegisterType((*StreamingRecognizeResponse)(nil), "google.cloud.speech.v1.StreamingRecognizeResponse")
	proto.RegisterType((*StreamingRecognitionResult)(nil), "google.cloud.speech.v1.StreamingRecognitionResult")
	proto.RegisterType((*SpeechRecognitionResult)(nil), "google.cloud.speech.v1.SpeechRecognitionResult")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.speech.v1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.speech.v1.WordInfo")
	proto.RegisterEnum("google.cloud.speech.v1.RecognitionConfig_AudioEncoding", RecognitionConfig_AudioEncoding_name, RecognitionConfig_AudioEncoding_value)
	proto.RegisterEnum("google.cloud.speech.v1.StreamingRecognizeResponse_SpeechEventType", StreamingRecognizeResponse_SpeechEventType_name, StreamingRecognizeResponse_SpeechEventType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SpeechClient is the client API for Speech service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpeechClient interface {
	// Performs synchronous speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error)
	// Performs asynchronous speech recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// a `LongRunningRecognizeResponse` message.
	LongRunningRecognize(ctx context.Context, in *LongRunningRecognizeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error)
}

type speechClient struct {
	cc *grpc.ClientConn
}

func NewSpeechClient(cc *grpc.ClientConn) SpeechClient {
	return &speechClient{cc}
}

func (c *speechClient) Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error) {
	out := new(RecognizeResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Speech/Recognize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) LongRunningRecognize(ctx context.Context, in *LongRunningRecognizeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Speech/LongRunningRecognize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Speech_serviceDesc.Streams[0], "/google.cloud.speech.v1.Speech/StreamingRecognize", opts...)
	if err != nil {
		return nil, err
	}
	x := &speechStreamingRecognizeClient{stream}
	return x, nil
}

type Speech_StreamingRecognizeClient interface {
	Send(*StreamingRecognizeRequest) error
	Recv() (*StreamingRecognizeResponse, error)
	grpc.ClientStream
}

type speechStreamingRecognizeClient struct {
	grpc.ClientStream
}

func (x *speechStreamingRecognizeClient) Send(m *StreamingRecognizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *speechStreamingRecognizeClient) Recv() (*StreamingRecognizeResponse, error) {
	m := new(StreamingRecognizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpeechServer is the server API for Speech service.
type SpeechServer interface {
	// Performs synchronous speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(context.Context, *RecognizeRequest) (*RecognizeResponse, error)
	// Performs asynchronous speech recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// a `LongRunningRecognizeResponse` message.
	LongRunningRecognize(context.Context, *LongRunningRecognizeRequest) (*longrunning.Operation, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(Speech_StreamingRecognizeServer) error
}

func RegisterSpeechServer(s *grpc.Server, srv SpeechServer) {
	s.RegisterService(&_Speech_serviceDesc, srv)
}

func _Speech_Recognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).Recognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Speech/Recognize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).Recognize(ctx, req.(*RecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_LongRunningRecognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LongRunningRecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).LongRunningRecognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Speech/LongRunningRecognize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).LongRunningRecognize(ctx, req.(*LongRunningRecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_StreamingRecognize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpeechServer).StreamingRecognize(&speechStreamingRecognizeServer{stream})
}

type Speech_StreamingRecognizeServer interface {
	Send(*StreamingRecognizeResponse) error
	Recv() (*StreamingRecognizeRequest, error)
	grpc.ServerStream
}

type speechStreamingRecognizeServer struct {
	grpc.ServerStream
}

func (x *speechStreamingRecognizeServer) Send(m *StreamingRecognizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *speechStreamingRecognizeServer) Recv() (*StreamingRecognizeRequest, error) {
	m := new(StreamingRecognizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Speech_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.speech.v1.Speech",
	HandlerType: (*SpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Recognize",
			Handler:    _Speech_Recognize_Handler,
		},
		{
			MethodName: "LongRunningRecognize",
			Handler:    _Speech_LongRunningRecognize_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingRecognize",
			Handler:       _Speech_StreamingRecognize_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/speech/v1/cloud_speech.proto",
}

func init() {
	proto.RegisterFile("google/cloud/speech/v1/cloud_speech.proto", fileDescriptor_cloud_speech_0a49d136bdba2e2b)
}

var fileDescriptor_cloud_speech_0a49d136bdba2e2b = []byte{
	// 1318 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0x4d, 0x6f, 0x1b, 0x45,
	0x18, 0xce, 0xc6, 0x71, 0x3e, 0xde, 0xe6, 0xc3, 0x19, 0x4a, 0xeb, 0xb8, 0xa1, 0x8d, 0xb6, 0x54,
	0x24, 0x3d, 0xd8, 0x24, 0xad, 0x5a, 0x28, 0x08, 0xc9, 0x71, 0x36, 0x89, 0x25, 0xc7, 0x89, 0xc6,
	0x0e, 0x29, 0x1c, 0x18, 0x4d, 0xec, 0xf1, 0x76, 0x25, 0x7b, 0x76, 0x99, 0x19, 0x87, 0xa6, 0x17,
	0x04, 0x57, 0x24, 0x2e, 0x88, 0x9e, 0x39, 0xf5, 0xca, 0x81, 0x0b, 0xbf, 0x81, 0x23, 0xfc, 0x05,
	0x7e, 0x04, 0x47, 0x34, 0x33, 0xbb, 0x8e, 0xed, 0xc4, 0x69, 0x2a, 0x15, 0x89, 0xdb, 0xce, 0xf3,
	0x7e, 0xcc, 0x33, 0xef, 0xbc, 0x1f, 0xb3, 0xb0, 0xe6, 0x87, 0xa1, 0xdf, 0x66, 0x85, 0x46, 0x3b,
	0xec, 0x36, 0x0b, 0x32, 0x62, 0xac, 0xf1, 0xac, 0x70, 0xb2, 0x6e, 0xd7, 0xc4, 0xae, 0xf3, 0x91,
	0x08, 0x55, 0x88, 0x6e, 0x58, 0xd5, 0xbc, 0x11, 0xe5, 0x63, 0xd1, 0xc9, 0x7a, 0x6e, 0x39, 0x76,
	0x41, 0xa3, 0xa0, 0x40, 0x39, 0x0f, 0x15, 0x55, 0x41, 0xc8, 0xa5, 0xb5, 0xca, 0xdd, 0x8d, 0xa5,
	0xed, 0x90, 0xfb, 0xa2, 0xcb, 0x79, 0xc0, 0xfd, 0x42, 0x18, 0x31, 0x31, 0xa0, 0xb4, 0x14, 0x2b,
	0x99, 0xd5, 0x71, 0xb7, 0x55, 0xa0, 0xfc, 0x34, 0x16, 0xdd, 0x1e, 0x16, 0x35, 0xbb, 0xd6, 0x36,
	0x96, 0xdf, 0x19, 0x96, 0xab, 0xa0, 0xc3, 0xa4, 0xa2, 0x9d, 0x28, 0x56, 0xb8, 0x19, 0x2b, 0x88,
	0xa8, 0x51, 0x90, 0x8a, 0xaa, 0x6e, 0xbc, 0xa9, 0xfb, 0xb3, 0x03, 0x19, 0xcc, 0x1a, 0xa1, 0xcf,
	0x83, 0x17, 0x0c, 0xb3, 0xaf, 0xbb, 0x4c, 0x2a, 0x54, 0x84, 0xc9, 0x46, 0xc8, 0x5b, 0x81, 0x9f,
	0x75, 0x56, 0x9c, 0xd5, 0x6b, 0x1b, 0x6b, 0xf9, 0x8b, 0x4f, 0x9d, 0x8f, 0x2d, 0x35, 0x93, 0x92,
	0x31, 0xc0, 0xb1, 0x21, 0xfa, 0x0c, 0xd2, 0xb4, 0xdb, 0x0c, 0xc2, 0xec, 0xb8, 0xf1, 0xb0, 0x7a,
	0x05, 0x0f, 0x45, 0xad, 0x8f, 0xad, 0x99, 0xfb, 0x8b, 0x03, 0xb7, 0x2a, 0x21, 0xf7, 0xb1, 0x8d,
	0xd6, 0xff, 0x91, 0xe2, 0xef, 0x0e, 0x2c, 0xd5, 0x94, 0x60, 0xb4, 0x73, 0x11, 0x41, 0x02, 0x19,
	0x99, 0x08, 0xc9, 0x00, 0xd5, 0x8d, 0x51, 0x1b, 0x0d, 0x3b, 0x3b, 0xe3, 0xbc, 0x3b, 0x86, 0x17,
	0x7a, 0xde, 0x2c, 0x84, 0xee, 0xc1, 0x9c, 0xe1, 0xa1, 0x9d, 0x2b, 0xc6, 0x95, 0x39, 0xc6, 0xec,
	0xee, 0x18, 0x9e, 0x35, 0x70, 0xc9, 0xa2, 0x9b, 0xef, 0xc0, 0xe2, 0x19, 0x0f, 0x61, 0xc9, 0xb9,
	0xbf, 0x39, 0x90, 0x1b, 0xbd, 0xdb, 0xdb, 0x08, 0xee, 0x1a, 0x64, 0x64, 0xc0, 0xfd, 0x36, 0x23,
	0x5d, 0xa5, 0x98, 0xa0, 0xbc, 0xc1, 0x0c, 0xc1, 0x69, 0xbc, 0x60, 0xf1, 0xc3, 0x04, 0x46, 0x1f,
	0xc0, 0x42, 0xc0, 0x15, 0x13, 0x41, 0x87, 0x08, 0x26, 0xbb, 0x6d, 0x25, 0xb3, 0x29, 0xa3, 0x39,
	0x1f, 0xc3, 0xd8, 0xa2, 0xee, 0xab, 0x09, 0x58, 0x3c, 0x4f, 0xb6, 0x06, 0xd3, 0x8c, 0x37, 0xc2,
	0x66, 0xc0, 0x2d, 0xdd, 0xf9, 0x8d, 0xc7, 0x57, 0xa6, 0x9b, 0x37, 0x17, 0xea, 0xc5, 0xe6, 0xb8,
	0xe7, 0x08, 0xdd, 0x87, 0x45, 0x49, 0x3b, 0x51, 0x9b, 0x11, 0x41, 0x15, 0x23, 0xcf, 0x98, 0x50,
	0x2f, 0x0c, 0xff, 0x34, 0x5e, 0xb0, 0x02, 0x4c, 0x15, 0xdb, 0xd5, 0x30, 0xba, 0x0b, 0x73, 0x6d,
	0xca, 0xfd, 0x2e, 0xf5, 0x19, 0x69, 0x84, 0x4d, 0x66, 0xd8, 0xcf, 0xe0, 0xd9, 0x04, 0x2c, 0x85,
	0x4d, 0xa6, 0xe3, 0xd1, 0xa1, 0xcf, 0x09, 0x6d, 0x2b, 0x26, 0x38, 0x55, 0xc1, 0x09, 0x93, 0xd9,
	0x09, 0xeb, 0xaf, 0x43, 0x9f, 0x17, 0xfb, 0x60, 0xad, 0x1a, 0x89, 0xb0, 0x45, 0x79, 0xa0, 0x4e,
	0x49, 0x2b, 0xd0, 0xa2, 0x6c, 0xda, 0x86, 0xae, 0x87, 0x6f, 0x1b, 0x18, 0x55, 0x61, 0xc1, 0x9e,
	0xce, 0x26, 0xc1, 0x73, 0x25, 0xb3, 0x93, 0x2b, 0xa9, 0xd5, 0x6b, 0x1b, 0xf7, 0x46, 0xe6, 0x98,
	0xf9, 0x2a, 0x59, 0x6d, 0x3c, 0x2f, 0xfb, 0x97, 0x12, 0x3d, 0x86, 0x2c, 0xe3, 0xf4, 0xb8, 0xcd,
	0xc8, 0x37, 0xa1, 0x68, 0x12, 0xdd, 0x45, 0x48, 0xd8, 0x6a, 0x49, 0xa6, 0x64, 0x76, 0xda, 0x50,
	0x78, 0xd7, 0xca, 0x8f, 0x42, 0xd1, 0xac, 0x07, 0x1d, 0xb6, 0x6f, 0x85, 0xee, 0x0f, 0x0e, 0xcc,
	0x0d, 0xc4, 0x12, 0x65, 0xe1, 0xba, 0x57, 0x2d, 0xed, 0x6f, 0x95, 0xab, 0x3b, 0xe4, 0xb0, 0x5a,
	0x3b, 0xf0, 0x4a, 0xe5, 0xed, 0xb2, 0xb7, 0x95, 0x19, 0x43, 0xb3, 0x30, 0x5d, 0x29, 0x57, 0xbd,
	0x22, 0x5e, 0x7f, 0x94, 0x71, 0xd0, 0x34, 0x4c, 0x6c, 0x57, 0x8a, 0xa5, 0xcc, 0x38, 0x9a, 0x81,
	0xf4, 0xde, 0x61, 0xa5, 0x78, 0x94, 0x49, 0xa1, 0x29, 0x48, 0x15, 0xf7, 0x70, 0x66, 0x02, 0x01,
	0x4c, 0x16, 0xf7, 0x30, 0x39, 0xda, 0xcc, 0xa4, 0xb5, 0xdd, 0xfe, 0xce, 0x0e, 0xd9, 0x3f, 0x38,
	0xac, 0x65, 0x26, 0x51, 0x0e, 0x6e, 0xd4, 0x0e, 0x3c, 0xef, 0x29, 0x39, 0x2a, 0xd7, 0x77, 0xc9,
	0xae, 0x57, 0xdc, 0xf2, 0x30, 0xd9, 0xfc, 0xa2, 0xee, 0x65, 0xa6, 0xdc, 0x35, 0x98, 0x1b, 0x38,
	0x27, 0xca, 0xc2, 0x54, 0xf4, 0x4c, 0x50, 0xc9, 0x64, 0xd6, 0x59, 0x49, 0xad, 0xce, 0xe0, 0x64,
	0xe9, 0xe2, 0x5e, 0xfb, 0xeb, 0xd5, 0x37, 0xca, 0xc1, 0x54, 0x52, 0x53, 0x4e, 0x5c, 0x53, 0x09,
	0x80, 0x10, 0xa4, 0xba, 0x22, 0x30, 0xa9, 0x30, 0xb3, 0x3b, 0x86, 0xf5, 0x62, 0x73, 0x1e, 0x6c,
	0xc9, 0x11, 0x19, 0x76, 0x45, 0x83, 0xb9, 0x5f, 0xf5, 0xd2, 0x54, 0xb7, 0x03, 0x19, 0x85, 0x5c,
	0x32, 0x54, 0x86, 0xa9, 0x24, 0xbb, 0xc7, 0xcd, 0x15, 0x15, 0x2e, 0xbf, 0xa2, 0x3e, 0x56, 0x36,
	0xff, 0x71, 0x62, 0xef, 0x06, 0xb0, 0x7c, 0x71, 0x6b, 0x7c, 0xfb, 0x5b, 0xfd, 0xe1, 0x5c, 0xbc,
	0xd7, 0x1e, 0x53, 0xb4, 0x49, 0x15, 0x8d, 0x93, 0xd5, 0x17, 0x4c, 0x4a, 0x12, 0x31, 0xd1, 0x48,
	0x82, 0x96, 0x36, 0xc9, 0x6a, 0xf0, 0x03, 0x0b, 0xa3, 0x8f, 0x01, 0xa4, 0xa2, 0x42, 0x99, 0xb4,
	0x8a, 0x9b, 0x6e, 0x2e, 0x61, 0x96, 0x4c, 0xae, 0x7c, 0x3d, 0x99, 0x5c, 0x78, 0xc6, 0x68, 0xeb,
	0x35, 0xda, 0x82, 0x4c, 0x9b, 0x4a, 0x45, 0xba, 0x51, 0x53, 0x97, 0xa3, 0x71, 0x90, 0x7a, 0xad,
	0x83, 0x79, 0x6d, 0x73, 0x68, 0x4c, 0x34, 0xe8, 0xfe, 0x39, 0x7e, 0xbe, 0xeb, 0xf5, 0x85, 0x6d,
	0x15, 0xd2, 0x4c, 0x88, 0x50, 0xc4, 0x4d, 0x0f, 0x25, 0x9e, 0x45, 0xd4, 0xc8, 0xd7, 0xcc, 0xcc,
	0xc4, 0x56, 0x01, 0x55, 0x86, 0x03, 0xfc, 0x46, 0x2d, 0x7d, 0x28, 0xc6, 0x88, 0xc3, 0x62, 0x5c,
	0xc4, 0xec, 0x84, 0x71, 0x45, 0xd4, 0x69, 0xc4, 0x4c, 0x6f, 0x98, 0xdf, 0xd8, 0xbc, 0xaa, 0xdf,
	0xb3, 0x63, 0xc4, 0x77, 0xea, 0x69, 0x57, 0xf5, 0xd3, 0x88, 0xe1, 0xb8, 0x43, 0xf4, 0x00, 0xb7,
	0x02, 0x0b, 0x43, 0x3a, 0x68, 0x19, 0xb2, 0xba, 0x98, 0x4a, 0xbb, 0xc4, 0xfb, 0xdc, 0xab, 0xd6,
	0x87, 0x0a, 0xf6, 0x16, 0xdc, 0xf4, 0xaa, 0x5b, 0x64, 0x7f, 0x9b, 0xd4, 0xca, 0xd5, 0x9d, 0x8a,
	0x47, 0x0e, 0xeb, 0x75, 0x0f, 0x17, 0xab, 0x25, 0x2f, 0xe3, 0xb8, 0xbf, 0x8e, 0x18, 0x25, 0xf6,
	0x94, 0xe8, 0x29, 0xcc, 0x0e, 0xf4, 0x3c, 0xc7, 0xc4, 0xeb, 0xe1, 0x95, 0x13, 0xb2, 0xaf, 0x33,
	0xe2, 0x01, 0x4f, 0x68, 0x09, 0xa6, 0x03, 0x49, 0x5a, 0x01, 0xa7, 0xed, 0x78, 0xb2, 0x4c, 0x05,
	0x72, 0x5b, 0x2f, 0xd1, 0x32, 0xe8, 0xdc, 0x39, 0x0e, 0xda, 0x81, 0x3a, 0x35, 0x79, 0x32, 0x8e,
	0xcf, 0x00, 0x57, 0xc2, 0xcd, 0x11, 0x79, 0xff, 0xdf, 0xb1, 0x75, 0x5f, 0x3a, 0xb0, 0x7c, 0x99,
	0x3a, 0xba, 0x0d, 0xa0, 0x04, 0xe5, 0xb2, 0x21, 0x82, 0xc8, 0x96, 0xd0, 0x0c, 0xee, 0x43, 0xb4,
	0xdc, 0x8c, 0xd6, 0x26, 0x4b, 0x46, 0xe9, 0x38, 0xee, 0x43, 0xd0, 0x23, 0x48, 0xeb, 0x9e, 0xad,
	0x67, 0xa7, 0xe6, 0xbc, 0x32, 0x8a, 0xb3, 0xee, 0xdc, 0x65, 0xde, 0x0a, 0xb1, 0x55, 0x77, 0x7f,
	0x74, 0x60, 0x3a, 0xc1, 0xd0, 0x47, 0x03, 0x25, 0x6a, 0xeb, 0x60, 0xe9, 0x5c, 0x85, 0x6d, 0xc5,
	0x8f, 0xcf, 0xfe, 0x0a, 0x7d, 0xa8, 0xa7, 0x70, 0xb3, 0xbf, 0xb4, 0x2f, 0xb1, 0x9b, 0x62, 0xdc,
	0x4c, 0x0f, 0x84, 0x60, 0x42, 0xb3, 0x88, 0x27, 0xa6, 0xf9, 0xde, 0x78, 0x95, 0x82, 0x49, 0x1b,
	0x29, 0xf4, 0x9d, 0x03, 0x33, 0xbd, 0x04, 0x47, 0xaf, 0x7b, 0xa0, 0xf5, 0xde, 0x5e, 0xb9, 0xb5,
	0x2b, 0x68, 0xda, 0x6a, 0x71, 0xef, 0x7c, 0xff, 0xd7, 0xdf, 0x3f, 0x8d, 0x2f, 0xb9, 0xd7, 0xf5,
	0x7b, 0xdf, 0x2a, 0x3e, 0x11, 0x89, 0xd6, 0x13, 0xe7, 0x3e, 0x7a, 0xe9, 0xc0, 0xf5, 0x8b, 0x3a,
	0x20, 0x7a, 0x30, 0x6a, 0x93, 0x4b, 0x9e, 0xad, 0xb9, 0xf7, 0x12, 0xa3, 0xbe, 0x3f, 0x81, 0xfc,
	0x7e, 0xf2, 0x27, 0xe0, 0xde, 0x37, 0x6c, 0xde, 0x77, 0xef, 0xf4, 0xb1, 0xe9, 0xd3, 0x1c, 0x20,
	0xf6, 0x2d, 0xa0, 0xf3, 0x5d, 0x00, 0xad, 0xbf, 0x49, 0xc7, 0xb0, 0x9c, 0x36, 0xde, 0xbc, 0xc9,
	0xac, 0x3a, 0x1f, 0x3a, 0x9b, 0x6d, 0xc8, 0x35, 0xc2, 0xce, 0x08, 0xe3, 0xcd, 0x6b, 0xf6, 0x0e,
	0x0f, 0xf4, 0xe5, 0x1f, 0x38, 0x5f, 0x7e, 0x1a, 0xab, 0xf9, 0xa1, 0x7e, 0x16, 0xe5, 0x43, 0xe1,
	0x17, 0x7c, 0xc6, 0x4d, 0x6a, 0x14, 0xac, 0x88, 0x46, 0x81, 0x1c, 0xfe, 0x03, 0xfb, 0xc4, 0x7e,
	0xfd, 0xe3, 0x38, 0xc7, 0x93, 0x46, 0xf7, 0xc1, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x52, 0x28,
	0xae, 0xd1, 0xac, 0x0d, 0x00, 0x00,
}
