// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/iot/v1/device_manager.proto

package iot // import "google.golang.org/genproto/googleapis/cloud/iot/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/duration"
import empty "github.com/golang/protobuf/ptypes/empty"
import _ "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import v1 "google.golang.org/genproto/googleapis/iam/v1"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request for `CreateDeviceRegistry`.
type CreateDeviceRegistryRequest struct {
	// The project and cloud region where this device registry must be created.
	// For example, `projects/example-project/locations/us-central1`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The device registry. The field `name` must be empty. The server will
	// generate that field from the device registry `id` provided and the
	// `parent` field.
	DeviceRegistry       *DeviceRegistry `protobuf:"bytes,2,opt,name=device_registry,json=deviceRegistry,proto3" json:"device_registry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CreateDeviceRegistryRequest) Reset()         { *m = CreateDeviceRegistryRequest{} }
func (m *CreateDeviceRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDeviceRegistryRequest) ProtoMessage()    {}
func (*CreateDeviceRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{0}
}
func (m *CreateDeviceRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDeviceRegistryRequest.Unmarshal(m, b)
}
func (m *CreateDeviceRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDeviceRegistryRequest.Marshal(b, m, deterministic)
}
func (dst *CreateDeviceRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDeviceRegistryRequest.Merge(dst, src)
}
func (m *CreateDeviceRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDeviceRegistryRequest.Size(m)
}
func (m *CreateDeviceRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDeviceRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDeviceRegistryRequest proto.InternalMessageInfo

func (m *CreateDeviceRegistryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDeviceRegistryRequest) GetDeviceRegistry() *DeviceRegistry {
	if m != nil {
		return m.DeviceRegistry
	}
	return nil
}

// Request for `GetDeviceRegistry`.
type GetDeviceRegistryRequest struct {
	// The name of the device registry. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDeviceRegistryRequest) Reset()         { *m = GetDeviceRegistryRequest{} }
func (m *GetDeviceRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*GetDeviceRegistryRequest) ProtoMessage()    {}
func (*GetDeviceRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{1}
}
func (m *GetDeviceRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceRegistryRequest.Unmarshal(m, b)
}
func (m *GetDeviceRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceRegistryRequest.Marshal(b, m, deterministic)
}
func (dst *GetDeviceRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceRegistryRequest.Merge(dst, src)
}
func (m *GetDeviceRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_GetDeviceRegistryRequest.Size(m)
}
func (m *GetDeviceRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceRegistryRequest proto.InternalMessageInfo

func (m *GetDeviceRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for `DeleteDeviceRegistry`.
type DeleteDeviceRegistryRequest struct {
	// The name of the device registry. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceRegistryRequest) Reset()         { *m = DeleteDeviceRegistryRequest{} }
func (m *DeleteDeviceRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceRegistryRequest) ProtoMessage()    {}
func (*DeleteDeviceRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{2}
}
func (m *DeleteDeviceRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceRegistryRequest.Unmarshal(m, b)
}
func (m *DeleteDeviceRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceRegistryRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteDeviceRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceRegistryRequest.Merge(dst, src)
}
func (m *DeleteDeviceRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceRegistryRequest.Size(m)
}
func (m *DeleteDeviceRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceRegistryRequest proto.InternalMessageInfo

func (m *DeleteDeviceRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for `UpdateDeviceRegistry`.
type UpdateDeviceRegistryRequest struct {
	// The new values for the device registry. The `id` field must be empty, and
	// the `name` field must indicate the path of the resource. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	DeviceRegistry *DeviceRegistry `protobuf:"bytes,1,opt,name=device_registry,json=deviceRegistry,proto3" json:"device_registry,omitempty"`
	// Only updates the `device_registry` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	// Mutable top-level fields: `event_notification_config`, `http_config`,
	// `mqtt_config`, and `state_notification_config`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateDeviceRegistryRequest) Reset()         { *m = UpdateDeviceRegistryRequest{} }
func (m *UpdateDeviceRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDeviceRegistryRequest) ProtoMessage()    {}
func (*UpdateDeviceRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{3}
}
func (m *UpdateDeviceRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDeviceRegistryRequest.Unmarshal(m, b)
}
func (m *UpdateDeviceRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDeviceRegistryRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateDeviceRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDeviceRegistryRequest.Merge(dst, src)
}
func (m *UpdateDeviceRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDeviceRegistryRequest.Size(m)
}
func (m *UpdateDeviceRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDeviceRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDeviceRegistryRequest proto.InternalMessageInfo

func (m *UpdateDeviceRegistryRequest) GetDeviceRegistry() *DeviceRegistry {
	if m != nil {
		return m.DeviceRegistry
	}
	return nil
}

func (m *UpdateDeviceRegistryRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for `ListDeviceRegistries`.
type ListDeviceRegistriesRequest struct {
	// The project and cloud region path. For example,
	// `projects/example-project/locations/us-central1`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of registries to return in the response. If this value
	// is zero, the service will select a default size. A call may return fewer
	// objects than requested, but if there is a non-empty `page_token`, it
	// indicates that more entries are available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListDeviceRegistriesResponse`; indicates
	// that this is a continuation of a prior `ListDeviceRegistries` call, and
	// that the system should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceRegistriesRequest) Reset()         { *m = ListDeviceRegistriesRequest{} }
func (m *ListDeviceRegistriesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceRegistriesRequest) ProtoMessage()    {}
func (*ListDeviceRegistriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{4}
}
func (m *ListDeviceRegistriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceRegistriesRequest.Unmarshal(m, b)
}
func (m *ListDeviceRegistriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceRegistriesRequest.Marshal(b, m, deterministic)
}
func (dst *ListDeviceRegistriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceRegistriesRequest.Merge(dst, src)
}
func (m *ListDeviceRegistriesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDeviceRegistriesRequest.Size(m)
}
func (m *ListDeviceRegistriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceRegistriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceRegistriesRequest proto.InternalMessageInfo

func (m *ListDeviceRegistriesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDeviceRegistriesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDeviceRegistriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for `ListDeviceRegistries`.
type ListDeviceRegistriesResponse struct {
	// The registries that matched the query.
	DeviceRegistries []*DeviceRegistry `protobuf:"bytes,1,rep,name=device_registries,json=deviceRegistries,proto3" json:"device_registries,omitempty"`
	// If not empty, indicates that there may be more registries that match the
	// request; this value should be passed in a new
	// `ListDeviceRegistriesRequest`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceRegistriesResponse) Reset()         { *m = ListDeviceRegistriesResponse{} }
func (m *ListDeviceRegistriesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceRegistriesResponse) ProtoMessage()    {}
func (*ListDeviceRegistriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{5}
}
func (m *ListDeviceRegistriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceRegistriesResponse.Unmarshal(m, b)
}
func (m *ListDeviceRegistriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceRegistriesResponse.Marshal(b, m, deterministic)
}
func (dst *ListDeviceRegistriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceRegistriesResponse.Merge(dst, src)
}
func (m *ListDeviceRegistriesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDeviceRegistriesResponse.Size(m)
}
func (m *ListDeviceRegistriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceRegistriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceRegistriesResponse proto.InternalMessageInfo

func (m *ListDeviceRegistriesResponse) GetDeviceRegistries() []*DeviceRegistry {
	if m != nil {
		return m.DeviceRegistries
	}
	return nil
}

func (m *ListDeviceRegistriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for `CreateDevice`.
type CreateDeviceRequest struct {
	// The name of the device registry where this device should be created.
	// For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The device registration details. The field `name` must be empty. The server
	// will generate that field from the device registry `id` provided and the
	// `parent` field.
	Device               *Device  `protobuf:"bytes,2,opt,name=device,proto3" json:"device,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDeviceRequest) Reset()         { *m = CreateDeviceRequest{} }
func (m *CreateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDeviceRequest) ProtoMessage()    {}
func (*CreateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{6}
}
func (m *CreateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDeviceRequest.Unmarshal(m, b)
}
func (m *CreateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDeviceRequest.Marshal(b, m, deterministic)
}
func (dst *CreateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDeviceRequest.Merge(dst, src)
}
func (m *CreateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDeviceRequest.Size(m)
}
func (m *CreateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDeviceRequest proto.InternalMessageInfo

func (m *CreateDeviceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDeviceRequest) GetDevice() *Device {
	if m != nil {
		return m.Device
	}
	return nil
}

// Request for `GetDevice`.
type GetDeviceRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fields of the `Device` resource to be returned in the response. If the
	// field mask is unset or empty, all fields are returned.
	FieldMask            *field_mask.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetDeviceRequest) Reset()         { *m = GetDeviceRequest{} }
func (m *GetDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*GetDeviceRequest) ProtoMessage()    {}
func (*GetDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{7}
}
func (m *GetDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceRequest.Unmarshal(m, b)
}
func (m *GetDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceRequest.Marshal(b, m, deterministic)
}
func (dst *GetDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceRequest.Merge(dst, src)
}
func (m *GetDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_GetDeviceRequest.Size(m)
}
func (m *GetDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceRequest proto.InternalMessageInfo

func (m *GetDeviceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetDeviceRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

// Request for `UpdateDevice`.
type UpdateDeviceRequest struct {
	// The new values for the device registry. The `id` and `num_id` fields must
	// be empty, and the field `name` must specify the name path. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0`or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Device *Device `protobuf:"bytes,2,opt,name=device,proto3" json:"device,omitempty"`
	// Only updates the `device` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	// Mutable top-level fields: `credentials`, `blocked`, and `metadata`
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateDeviceRequest) Reset()         { *m = UpdateDeviceRequest{} }
func (m *UpdateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDeviceRequest) ProtoMessage()    {}
func (*UpdateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{8}
}
func (m *UpdateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDeviceRequest.Unmarshal(m, b)
}
func (m *UpdateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDeviceRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDeviceRequest.Merge(dst, src)
}
func (m *UpdateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDeviceRequest.Size(m)
}
func (m *UpdateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDeviceRequest proto.InternalMessageInfo

func (m *UpdateDeviceRequest) GetDevice() *Device {
	if m != nil {
		return m.Device
	}
	return nil
}

func (m *UpdateDeviceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for `DeleteDevice`.
type DeleteDeviceRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceRequest) Reset()         { *m = DeleteDeviceRequest{} }
func (m *DeleteDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceRequest) ProtoMessage()    {}
func (*DeleteDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{9}
}
func (m *DeleteDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceRequest.Unmarshal(m, b)
}
func (m *DeleteDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceRequest.Merge(dst, src)
}
func (m *DeleteDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceRequest.Size(m)
}
func (m *DeleteDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceRequest proto.InternalMessageInfo

func (m *DeleteDeviceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for `ListDevices`.
type ListDevicesRequest struct {
	// The device registry path. Required. For example,
	// `projects/my-project/locations/us-central1/registries/my-registry`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A list of device numerical ids. If empty, it will ignore this field. This
	// field cannot hold more than 10,000 entries.
	DeviceNumIds []uint64 `protobuf:"varint,2,rep,packed,name=device_num_ids,json=deviceNumIds,proto3" json:"device_num_ids,omitempty"`
	// A list of device string identifiers. If empty, it will ignore this field.
	// For example, `['device0', 'device12']`. This field cannot hold more than
	// 10,000 entries.
	DeviceIds []string `protobuf:"bytes,3,rep,name=device_ids,json=deviceIds,proto3" json:"device_ids,omitempty"`
	// The fields of the `Device` resource to be returned in the response. The
	// fields `id`, and `num_id` are always returned by default, along with any
	// other fields specified.
	FieldMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The maximum number of devices to return in the response. If this value
	// is zero, the service will select a default size. A call may return fewer
	// objects than requested, but if there is a non-empty `page_token`, it
	// indicates that more entries are available.
	PageSize int32 `protobuf:"varint,100,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListDevicesResponse`; indicates
	// that this is a continuation of a prior `ListDevices` call, and
	// that the system should return the next page of data.
	PageToken            string   `protobuf:"bytes,101,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDevicesRequest) Reset()         { *m = ListDevicesRequest{} }
func (m *ListDevicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDevicesRequest) ProtoMessage()    {}
func (*ListDevicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{10}
}
func (m *ListDevicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDevicesRequest.Unmarshal(m, b)
}
func (m *ListDevicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDevicesRequest.Marshal(b, m, deterministic)
}
func (dst *ListDevicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDevicesRequest.Merge(dst, src)
}
func (m *ListDevicesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDevicesRequest.Size(m)
}
func (m *ListDevicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDevicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDevicesRequest proto.InternalMessageInfo

func (m *ListDevicesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDevicesRequest) GetDeviceNumIds() []uint64 {
	if m != nil {
		return m.DeviceNumIds
	}
	return nil
}

func (m *ListDevicesRequest) GetDeviceIds() []string {
	if m != nil {
		return m.DeviceIds
	}
	return nil
}

func (m *ListDevicesRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

func (m *ListDevicesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDevicesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for `ListDevices`.
type ListDevicesResponse struct {
	// The devices that match the request.
	Devices []*Device `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	// If not empty, indicates that there may be more devices that match the
	// request; this value should be passed in a new `ListDevicesRequest`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDevicesResponse) Reset()         { *m = ListDevicesResponse{} }
func (m *ListDevicesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDevicesResponse) ProtoMessage()    {}
func (*ListDevicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{11}
}
func (m *ListDevicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDevicesResponse.Unmarshal(m, b)
}
func (m *ListDevicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDevicesResponse.Marshal(b, m, deterministic)
}
func (dst *ListDevicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDevicesResponse.Merge(dst, src)
}
func (m *ListDevicesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDevicesResponse.Size(m)
}
func (m *ListDevicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDevicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDevicesResponse proto.InternalMessageInfo

func (m *ListDevicesResponse) GetDevices() []*Device {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *ListDevicesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for `ModifyCloudToDeviceConfig`.
type ModifyCloudToDeviceConfigRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version number to update. If this value is zero, it will not check the
	// version number of the server and will always update the current version;
	// otherwise, this update will fail if the version number found on the server
	// does not match this version number. This is used to support multiple
	// simultaneous updates without losing data.
	VersionToUpdate int64 `protobuf:"varint,2,opt,name=version_to_update,json=versionToUpdate,proto3" json:"version_to_update,omitempty"`
	// The configuration data for the device.
	BinaryData           []byte   `protobuf:"bytes,3,opt,name=binary_data,json=binaryData,proto3" json:"binary_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ModifyCloudToDeviceConfigRequest) Reset()         { *m = ModifyCloudToDeviceConfigRequest{} }
func (m *ModifyCloudToDeviceConfigRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyCloudToDeviceConfigRequest) ProtoMessage()    {}
func (*ModifyCloudToDeviceConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{12}
}
func (m *ModifyCloudToDeviceConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyCloudToDeviceConfigRequest.Unmarshal(m, b)
}
func (m *ModifyCloudToDeviceConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyCloudToDeviceConfigRequest.Marshal(b, m, deterministic)
}
func (dst *ModifyCloudToDeviceConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyCloudToDeviceConfigRequest.Merge(dst, src)
}
func (m *ModifyCloudToDeviceConfigRequest) XXX_Size() int {
	return xxx_messageInfo_ModifyCloudToDeviceConfigRequest.Size(m)
}
func (m *ModifyCloudToDeviceConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyCloudToDeviceConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyCloudToDeviceConfigRequest proto.InternalMessageInfo

func (m *ModifyCloudToDeviceConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ModifyCloudToDeviceConfigRequest) GetVersionToUpdate() int64 {
	if m != nil {
		return m.VersionToUpdate
	}
	return 0
}

func (m *ModifyCloudToDeviceConfigRequest) GetBinaryData() []byte {
	if m != nil {
		return m.BinaryData
	}
	return nil
}

// Request for `ListDeviceConfigVersions`.
type ListDeviceConfigVersionsRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The number of versions to list. Versions are listed in decreasing order of
	// the version number. The maximum number of versions retained is 10. If this
	// value is zero, it will return all the versions available.
	NumVersions          int32    `protobuf:"varint,2,opt,name=num_versions,json=numVersions,proto3" json:"num_versions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceConfigVersionsRequest) Reset()         { *m = ListDeviceConfigVersionsRequest{} }
func (m *ListDeviceConfigVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceConfigVersionsRequest) ProtoMessage()    {}
func (*ListDeviceConfigVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{13}
}
func (m *ListDeviceConfigVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceConfigVersionsRequest.Unmarshal(m, b)
}
func (m *ListDeviceConfigVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceConfigVersionsRequest.Marshal(b, m, deterministic)
}
func (dst *ListDeviceConfigVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceConfigVersionsRequest.Merge(dst, src)
}
func (m *ListDeviceConfigVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDeviceConfigVersionsRequest.Size(m)
}
func (m *ListDeviceConfigVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceConfigVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceConfigVersionsRequest proto.InternalMessageInfo

func (m *ListDeviceConfigVersionsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListDeviceConfigVersionsRequest) GetNumVersions() int32 {
	if m != nil {
		return m.NumVersions
	}
	return 0
}

// Response for `ListDeviceConfigVersions`.
type ListDeviceConfigVersionsResponse struct {
	// The device configuration for the last few versions. Versions are listed
	// in decreasing order, starting from the most recent one.
	DeviceConfigs        []*DeviceConfig `protobuf:"bytes,1,rep,name=device_configs,json=deviceConfigs,proto3" json:"device_configs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListDeviceConfigVersionsResponse) Reset()         { *m = ListDeviceConfigVersionsResponse{} }
func (m *ListDeviceConfigVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceConfigVersionsResponse) ProtoMessage()    {}
func (*ListDeviceConfigVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{14}
}
func (m *ListDeviceConfigVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceConfigVersionsResponse.Unmarshal(m, b)
}
func (m *ListDeviceConfigVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceConfigVersionsResponse.Marshal(b, m, deterministic)
}
func (dst *ListDeviceConfigVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceConfigVersionsResponse.Merge(dst, src)
}
func (m *ListDeviceConfigVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDeviceConfigVersionsResponse.Size(m)
}
func (m *ListDeviceConfigVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceConfigVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceConfigVersionsResponse proto.InternalMessageInfo

func (m *ListDeviceConfigVersionsResponse) GetDeviceConfigs() []*DeviceConfig {
	if m != nil {
		return m.DeviceConfigs
	}
	return nil
}

// Request for `ListDeviceStates`.
type ListDeviceStatesRequest struct {
	// The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The number of states to list. States are listed in descending order of
	// update time. The maximum number of states retained is 10. If this
	// value is zero, it will return all the states available.
	NumStates            int32    `protobuf:"varint,2,opt,name=num_states,json=numStates,proto3" json:"num_states,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceStatesRequest) Reset()         { *m = ListDeviceStatesRequest{} }
func (m *ListDeviceStatesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceStatesRequest) ProtoMessage()    {}
func (*ListDeviceStatesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{15}
}
func (m *ListDeviceStatesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceStatesRequest.Unmarshal(m, b)
}
func (m *ListDeviceStatesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceStatesRequest.Marshal(b, m, deterministic)
}
func (dst *ListDeviceStatesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceStatesRequest.Merge(dst, src)
}
func (m *ListDeviceStatesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDeviceStatesRequest.Size(m)
}
func (m *ListDeviceStatesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceStatesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceStatesRequest proto.InternalMessageInfo

func (m *ListDeviceStatesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListDeviceStatesRequest) GetNumStates() int32 {
	if m != nil {
		return m.NumStates
	}
	return 0
}

// Response for `ListDeviceStates`.
type ListDeviceStatesResponse struct {
	// The last few device states. States are listed in descending order of server
	// update time, starting from the most recent one.
	DeviceStates         []*DeviceState `protobuf:"bytes,1,rep,name=device_states,json=deviceStates,proto3" json:"device_states,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ListDeviceStatesResponse) Reset()         { *m = ListDeviceStatesResponse{} }
func (m *ListDeviceStatesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceStatesResponse) ProtoMessage()    {}
func (*ListDeviceStatesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_device_manager_2617478a41a48425, []int{16}
}
func (m *ListDeviceStatesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceStatesResponse.Unmarshal(m, b)
}
func (m *ListDeviceStatesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceStatesResponse.Marshal(b, m, deterministic)
}
func (dst *ListDeviceStatesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceStatesResponse.Merge(dst, src)
}
func (m *ListDeviceStatesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDeviceStatesResponse.Size(m)
}
func (m *ListDeviceStatesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceStatesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceStatesResponse proto.InternalMessageInfo

func (m *ListDeviceStatesResponse) GetDeviceStates() []*DeviceState {
	if m != nil {
		return m.DeviceStates
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateDeviceRegistryRequest)(nil), "google.cloud.iot.v1.CreateDeviceRegistryRequest")
	proto.RegisterType((*GetDeviceRegistryRequest)(nil), "google.cloud.iot.v1.GetDeviceRegistryRequest")
	proto.RegisterType((*DeleteDeviceRegistryRequest)(nil), "google.cloud.iot.v1.DeleteDeviceRegistryRequest")
	proto.RegisterType((*UpdateDeviceRegistryRequest)(nil), "google.cloud.iot.v1.UpdateDeviceRegistryRequest")
	proto.RegisterType((*ListDeviceRegistriesRequest)(nil), "google.cloud.iot.v1.ListDeviceRegistriesRequest")
	proto.RegisterType((*ListDeviceRegistriesResponse)(nil), "google.cloud.iot.v1.ListDeviceRegistriesResponse")
	proto.RegisterType((*CreateDeviceRequest)(nil), "google.cloud.iot.v1.CreateDeviceRequest")
	proto.RegisterType((*GetDeviceRequest)(nil), "google.cloud.iot.v1.GetDeviceRequest")
	proto.RegisterType((*UpdateDeviceRequest)(nil), "google.cloud.iot.v1.UpdateDeviceRequest")
	proto.RegisterType((*DeleteDeviceRequest)(nil), "google.cloud.iot.v1.DeleteDeviceRequest")
	proto.RegisterType((*ListDevicesRequest)(nil), "google.cloud.iot.v1.ListDevicesRequest")
	proto.RegisterType((*ListDevicesResponse)(nil), "google.cloud.iot.v1.ListDevicesResponse")
	proto.RegisterType((*ModifyCloudToDeviceConfigRequest)(nil), "google.cloud.iot.v1.ModifyCloudToDeviceConfigRequest")
	proto.RegisterType((*ListDeviceConfigVersionsRequest)(nil), "google.cloud.iot.v1.ListDeviceConfigVersionsRequest")
	proto.RegisterType((*ListDeviceConfigVersionsResponse)(nil), "google.cloud.iot.v1.ListDeviceConfigVersionsResponse")
	proto.RegisterType((*ListDeviceStatesRequest)(nil), "google.cloud.iot.v1.ListDeviceStatesRequest")
	proto.RegisterType((*ListDeviceStatesResponse)(nil), "google.cloud.iot.v1.ListDeviceStatesResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DeviceManagerClient is the client API for DeviceManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DeviceManagerClient interface {
	// Creates a device registry that contains devices.
	CreateDeviceRegistry(ctx context.Context, in *CreateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Gets a device registry configuration.
	GetDeviceRegistry(ctx context.Context, in *GetDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Updates a device registry configuration.
	UpdateDeviceRegistry(ctx context.Context, in *UpdateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Deletes a device registry configuration.
	DeleteDeviceRegistry(ctx context.Context, in *DeleteDeviceRegistryRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists device registries.
	ListDeviceRegistries(ctx context.Context, in *ListDeviceRegistriesRequest, opts ...grpc.CallOption) (*ListDeviceRegistriesResponse, error)
	// Creates a device in a device registry.
	CreateDevice(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Gets details about a device.
	GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Updates a device.
	UpdateDevice(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Deletes a device.
	DeleteDevice(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// List devices in a device registry.
	ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error)
	// Modifies the configuration for the device, which is eventually sent from
	// the Cloud IoT Core servers. Returns the modified configuration version and
	// its metadata.
	ModifyCloudToDeviceConfig(ctx context.Context, in *ModifyCloudToDeviceConfigRequest, opts ...grpc.CallOption) (*DeviceConfig, error)
	// Lists the last few versions of the device configuration in descending
	// order (i.e.: newest first).
	ListDeviceConfigVersions(ctx context.Context, in *ListDeviceConfigVersionsRequest, opts ...grpc.CallOption) (*ListDeviceConfigVersionsResponse, error)
	// Lists the last few versions of the device state in descending order (i.e.:
	// newest first).
	ListDeviceStates(ctx context.Context, in *ListDeviceStatesRequest, opts ...grpc.CallOption) (*ListDeviceStatesResponse, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type deviceManagerClient struct {
	cc *grpc.ClientConn
}

func NewDeviceManagerClient(cc *grpc.ClientConn) DeviceManagerClient {
	return &deviceManagerClient{cc}
}

func (c *deviceManagerClient) CreateDeviceRegistry(ctx context.Context, in *CreateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/CreateDeviceRegistry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetDeviceRegistry(ctx context.Context, in *GetDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/GetDeviceRegistry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UpdateDeviceRegistry(ctx context.Context, in *UpdateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/UpdateDeviceRegistry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) DeleteDeviceRegistry(ctx context.Context, in *DeleteDeviceRegistryRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/DeleteDeviceRegistry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceRegistries(ctx context.Context, in *ListDeviceRegistriesRequest, opts ...grpc.CallOption) (*ListDeviceRegistriesResponse, error) {
	out := new(ListDeviceRegistriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDeviceRegistries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) CreateDevice(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/CreateDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/GetDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UpdateDevice(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/UpdateDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) DeleteDevice(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/DeleteDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error) {
	out := new(ListDevicesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ModifyCloudToDeviceConfig(ctx context.Context, in *ModifyCloudToDeviceConfigRequest, opts ...grpc.CallOption) (*DeviceConfig, error) {
	out := new(DeviceConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ModifyCloudToDeviceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceConfigVersions(ctx context.Context, in *ListDeviceConfigVersionsRequest, opts ...grpc.CallOption) (*ListDeviceConfigVersionsResponse, error) {
	out := new(ListDeviceConfigVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDeviceConfigVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceStates(ctx context.Context, in *ListDeviceStatesRequest, opts ...grpc.CallOption) (*ListDeviceStatesResponse, error) {
	out := new(ListDeviceStatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDeviceStates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DeviceManagerServer is the server API for DeviceManager service.
type DeviceManagerServer interface {
	// Creates a device registry that contains devices.
	CreateDeviceRegistry(context.Context, *CreateDeviceRegistryRequest) (*DeviceRegistry, error)
	// Gets a device registry configuration.
	GetDeviceRegistry(context.Context, *GetDeviceRegistryRequest) (*DeviceRegistry, error)
	// Updates a device registry configuration.
	UpdateDeviceRegistry(context.Context, *UpdateDeviceRegistryRequest) (*DeviceRegistry, error)
	// Deletes a device registry configuration.
	DeleteDeviceRegistry(context.Context, *DeleteDeviceRegistryRequest) (*empty.Empty, error)
	// Lists device registries.
	ListDeviceRegistries(context.Context, *ListDeviceRegistriesRequest) (*ListDeviceRegistriesResponse, error)
	// Creates a device in a device registry.
	CreateDevice(context.Context, *CreateDeviceRequest) (*Device, error)
	// Gets details about a device.
	GetDevice(context.Context, *GetDeviceRequest) (*Device, error)
	// Updates a device.
	UpdateDevice(context.Context, *UpdateDeviceRequest) (*Device, error)
	// Deletes a device.
	DeleteDevice(context.Context, *DeleteDeviceRequest) (*empty.Empty, error)
	// List devices in a device registry.
	ListDevices(context.Context, *ListDevicesRequest) (*ListDevicesResponse, error)
	// Modifies the configuration for the device, which is eventually sent from
	// the Cloud IoT Core servers. Returns the modified configuration version and
	// its metadata.
	ModifyCloudToDeviceConfig(context.Context, *ModifyCloudToDeviceConfigRequest) (*DeviceConfig, error)
	// Lists the last few versions of the device configuration in descending
	// order (i.e.: newest first).
	ListDeviceConfigVersions(context.Context, *ListDeviceConfigVersionsRequest) (*ListDeviceConfigVersionsResponse, error)
	// Lists the last few versions of the device state in descending order (i.e.:
	// newest first).
	ListDeviceStates(context.Context, *ListDeviceStatesRequest) (*ListDeviceStatesResponse, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

func RegisterDeviceManagerServer(s *grpc.Server, srv DeviceManagerServer) {
	s.RegisterService(&_DeviceManager_serviceDesc, srv)
}

func _DeviceManager_CreateDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).CreateDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/CreateDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).CreateDeviceRegistry(ctx, req.(*CreateDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/GetDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetDeviceRegistry(ctx, req.(*GetDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UpdateDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UpdateDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/UpdateDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UpdateDeviceRegistry(ctx, req.(*UpdateDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_DeleteDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).DeleteDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/DeleteDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).DeleteDeviceRegistry(ctx, req.(*DeleteDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceRegistries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceRegistriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceRegistries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDeviceRegistries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceRegistries(ctx, req.(*ListDeviceRegistriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_CreateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).CreateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/CreateDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).CreateDevice(ctx, req.(*CreateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/GetDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetDevice(ctx, req.(*GetDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UpdateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UpdateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/UpdateDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UpdateDevice(ctx, req.(*UpdateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_DeleteDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).DeleteDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/DeleteDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).DeleteDevice(ctx, req.(*DeleteDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDevices(ctx, req.(*ListDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ModifyCloudToDeviceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyCloudToDeviceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ModifyCloudToDeviceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ModifyCloudToDeviceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ModifyCloudToDeviceConfig(ctx, req.(*ModifyCloudToDeviceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceConfigVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceConfigVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceConfigVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDeviceConfigVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceConfigVersions(ctx, req.(*ListDeviceConfigVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceStates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceStatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceStates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDeviceStates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceStates(ctx, req.(*ListDeviceStatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DeviceManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.iot.v1.DeviceManager",
	HandlerType: (*DeviceManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDeviceRegistry",
			Handler:    _DeviceManager_CreateDeviceRegistry_Handler,
		},
		{
			MethodName: "GetDeviceRegistry",
			Handler:    _DeviceManager_GetDeviceRegistry_Handler,
		},
		{
			MethodName: "UpdateDeviceRegistry",
			Handler:    _DeviceManager_UpdateDeviceRegistry_Handler,
		},
		{
			MethodName: "DeleteDeviceRegistry",
			Handler:    _DeviceManager_DeleteDeviceRegistry_Handler,
		},
		{
			MethodName: "ListDeviceRegistries",
			Handler:    _DeviceManager_ListDeviceRegistries_Handler,
		},
		{
			MethodName: "CreateDevice",
			Handler:    _DeviceManager_CreateDevice_Handler,
		},
		{
			MethodName: "GetDevice",
			Handler:    _DeviceManager_GetDevice_Handler,
		},
		{
			MethodName: "UpdateDevice",
			Handler:    _DeviceManager_UpdateDevice_Handler,
		},
		{
			MethodName: "DeleteDevice",
			Handler:    _DeviceManager_DeleteDevice_Handler,
		},
		{
			MethodName: "ListDevices",
			Handler:    _DeviceManager_ListDevices_Handler,
		},
		{
			MethodName: "ModifyCloudToDeviceConfig",
			Handler:    _DeviceManager_ModifyCloudToDeviceConfig_Handler,
		},
		{
			MethodName: "ListDeviceConfigVersions",
			Handler:    _DeviceManager_ListDeviceConfigVersions_Handler,
		},
		{
			MethodName: "ListDeviceStates",
			Handler:    _DeviceManager_ListDeviceStates_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DeviceManager_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DeviceManager_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DeviceManager_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/iot/v1/device_manager.proto",
}

func init() {
	proto.RegisterFile("google/cloud/iot/v1/device_manager.proto", fileDescriptor_device_manager_2617478a41a48425)
}

var fileDescriptor_device_manager_2617478a41a48425 = []byte{
	// 1432 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xcd, 0x6f, 0x1b, 0x45,
	0x14, 0xd7, 0xd8, 0xa5, 0x90, 0x17, 0x97, 0xb6, 0x93, 0xd0, 0x1a, 0xbb, 0xa5, 0xee, 0x96, 0x0f,
	0xd7, 0xa2, 0xde, 0x26, 0xfd, 0x50, 0x49, 0x05, 0x55, 0x9b, 0x96, 0xa4, 0xa8, 0xa9, 0x82, 0x13,
	0x3e, 0x64, 0x0e, 0x66, 0x62, 0x4f, 0xac, 0x6d, 0xbd, 0x3b, 0xee, 0xce, 0x38, 0x6a, 0x8a, 0x2a,
	0x24, 0x2a, 0xe0, 0xc4, 0x85, 0x70, 0xa8, 0x90, 0x50, 0x2f, 0x08, 0x71, 0xe2, 0x82, 0x84, 0xe0,
	0xc6, 0x89, 0x7f, 0x80, 0x03, 0x88, 0x33, 0x42, 0xfc, 0x09, 0x1c, 0x38, 0xa0, 0x9d, 0x99, 0x75,
	0xbc, 0x9b, 0xdd, 0xf5, 0xda, 0xa9, 0xb8, 0x79, 0xe7, 0x7d, 0xfd, 0xde, 0xef, 0xbd, 0xb7, 0xf3,
	0xbc, 0x50, 0x6e, 0x33, 0xd6, 0xee, 0x50, 0xb3, 0xd9, 0x61, 0xbd, 0x96, 0x69, 0x31, 0x61, 0x6e,
	0xcc, 0x98, 0x2d, 0xba, 0x61, 0x35, 0x69, 0xc3, 0x26, 0x0e, 0x69, 0x53, 0xb7, 0xda, 0x75, 0x99,
	0x60, 0x78, 0x4a, 0x69, 0x56, 0xa5, 0x66, 0xd5, 0x62, 0xa2, 0xba, 0x31, 0x53, 0x38, 0xa2, 0xcd,
	0x49, 0xd7, 0x32, 0x89, 0xe3, 0x30, 0x41, 0x84, 0xc5, 0x1c, 0xae, 0x4c, 0x0a, 0x27, 0xa2, 0x9c,
	0xbb, 0x94, 0xb3, 0x9e, 0xdb, 0xa4, 0xbe, 0xd2, 0x73, 0x5a, 0xc9, 0x22, 0xb6, 0x27, 0xb6, 0x88,
	0xdd, 0xe8, 0xb2, 0x8e, 0xd5, 0xdc, 0xd4, 0xf2, 0x42, 0x50, 0x1e, 0x90, 0xf9, 0xb6, 0xf2, 0x69,
	0xad, 0xb7, 0x6e, 0xb6, 0x7a, 0xae, 0x44, 0xa0, 0xe5, 0xc5, 0xb0, 0x9c, 0xda, 0x5d, 0xe1, 0x1b,
	0x97, 0xc2, 0xc2, 0x75, 0x8b, 0x76, 0x5a, 0x0d, 0x9b, 0xf0, 0xdb, 0x5a, 0xe3, 0x58, 0x58, 0x43,
	0x58, 0x36, 0xe5, 0x82, 0xd8, 0x5d, 0xa5, 0x60, 0x3c, 0x40, 0x50, 0x9c, 0x77, 0x29, 0x11, 0xf4,
	0xaa, 0xa4, 0xac, 0x46, 0xdb, 0x16, 0x17, 0xee, 0x66, 0x8d, 0xde, 0xe9, 0x51, 0x2e, 0xf0, 0x21,
	0xd8, 0xdb, 0x25, 0x2e, 0x75, 0x44, 0x1e, 0x95, 0x50, 0x79, 0xa2, 0xa6, 0x9f, 0xf0, 0x0d, 0xd8,
	0xaf, 0x39, 0x76, 0xb5, 0x45, 0x3e, 0x53, 0x42, 0xe5, 0xc9, 0xd9, 0x13, 0xd5, 0x08, 0x96, 0xab,
	0x21, 0xe7, 0x4f, 0xb7, 0x02, 0xcf, 0x46, 0x15, 0xf2, 0x0b, 0x54, 0x44, 0x23, 0xc0, 0xb0, 0xc7,
	0x21, 0x36, 0xd5, 0xf1, 0xe5, 0x6f, 0x63, 0x06, 0x8a, 0x57, 0x69, 0x87, 0xc6, 0x81, 0x8e, 0x32,
	0xf9, 0x16, 0x41, 0xf1, 0xad, 0x6e, 0x2b, 0x36, 0xd1, 0x88, 0x84, 0xd0, 0xd8, 0x09, 0xe1, 0x8b,
	0x30, 0xd9, 0x93, 0xc1, 0x64, 0x31, 0x34, 0x35, 0x05, 0xdf, 0x93, 0x5f, 0x8d, 0xea, 0xeb, 0x5e,
	0xbd, 0x96, 0x08, 0xbf, 0x5d, 0x03, 0xa5, 0xee, 0xfd, 0x36, 0xee, 0x40, 0xf1, 0x86, 0xc5, 0x83,
	0x74, 0x58, 0x94, 0x0f, 0x2b, 0x49, 0x11, 0x26, 0xba, 0xa4, 0x4d, 0x1b, 0xdc, 0xba, 0x47, 0x65,
	0xc4, 0x27, 0x6a, 0x4f, 0x79, 0x07, 0x2b, 0xd6, 0x3d, 0x8a, 0x8f, 0x02, 0x48, 0xa1, 0x60, 0xb7,
	0xa9, 0x93, 0xcf, 0x4a, 0x43, 0xa9, 0xbe, 0xea, 0x1d, 0x18, 0x0f, 0x11, 0x1c, 0x89, 0x8e, 0xc9,
	0xbb, 0xcc, 0xe1, 0x14, 0x2f, 0xc3, 0xc1, 0x20, 0x3d, 0x16, 0xe5, 0x79, 0x54, 0xca, 0xa6, 0x25,
	0xe8, 0x40, 0x2b, 0xe4, 0x19, 0xbf, 0x08, 0xfb, 0x1d, 0x7a, 0x57, 0x34, 0x06, 0x60, 0x65, 0x24,
	0xac, 0x7d, 0xde, 0xf1, 0x72, 0x1f, 0xda, 0x1a, 0x4c, 0x05, 0x1b, 0x34, 0x99, 0x85, 0x33, 0xb0,
	0x57, 0x85, 0xd2, 0xa4, 0x17, 0x93, 0xd0, 0x69, 0x55, 0x83, 0xc0, 0x81, 0x81, 0xfe, 0x8b, 0x6d,
	0x22, 0xfc, 0x0a, 0xc0, 0xf6, 0x88, 0xa5, 0xa8, 0xea, 0xc4, 0xba, 0xff, 0xd3, 0xf8, 0x14, 0xc1,
	0x54, 0xb0, 0xff, 0x54, 0x98, 0x71, 0xf0, 0x86, 0xdb, 0x2b, 0x3b, 0x52, 0x7b, 0x9d, 0x84, 0xa9,
	0xe0, 0xf0, 0xc4, 0x0f, 0xcd, 0xdf, 0x08, 0xf0, 0x76, 0x5b, 0x0c, 0xed, 0xc0, 0xe7, 0x41, 0xcf,
	0x41, 0xc3, 0xe9, 0xd9, 0x0d, 0xab, 0xc5, 0xf3, 0x99, 0x52, 0xb6, 0xbc, 0xa7, 0x96, 0x53, 0xa7,
	0x37, 0x7b, 0xf6, 0xf5, 0x16, 0xf7, 0x5a, 0x51, 0x6b, 0x79, 0x1a, 0xd9, 0x52, 0xd6, 0x6b, 0x45,
	0x75, 0xe2, 0x89, 0x83, 0x1c, 0xef, 0x19, 0x81, 0xe3, 0xe0, 0x04, 0xb4, 0x12, 0x27, 0x80, 0x86,
	0x27, 0x40, 0xc0, 0x54, 0x20, 0x53, 0xdd, 0xf7, 0xe7, 0xe0, 0x49, 0x05, 0xcd, 0xef, 0xf6, 0xc4,
	0xfa, 0xf8, 0xba, 0xa9, 0x9b, 0xfb, 0x01, 0x82, 0xd2, 0x12, 0x6b, 0x59, 0xeb, 0x9b, 0xf3, 0x9e,
	0xbb, 0x55, 0xa6, 0x1c, 0xcd, 0x33, 0x67, 0xdd, 0x6a, 0x27, 0x75, 0x62, 0x05, 0x0e, 0x6e, 0x50,
	0x97, 0x5b, 0xcc, 0x69, 0x08, 0xd6, 0x50, 0xd5, 0x95, 0x21, 0xb2, 0xb5, 0xfd, 0x5a, 0xb0, 0xca,
	0x54, 0xbf, 0xe1, 0x63, 0x30, 0xb9, 0x66, 0x39, 0xc4, 0xdd, 0x6c, 0xb4, 0x88, 0x20, 0xb2, 0x5b,
	0x72, 0x35, 0x50, 0x47, 0x57, 0x89, 0x20, 0xc6, 0xbb, 0x70, 0x6c, 0x3b, 0x77, 0x15, 0xfb, 0x6d,
	0xe5, 0x83, 0x27, 0x61, 0x38, 0x0e, 0x39, 0xaf, 0xce, 0x3a, 0x1c, 0xd7, 0xef, 0x9c, 0x49, 0xa7,
	0x67, 0xfb, 0xd6, 0x46, 0x07, 0x4a, 0xf1, 0x9e, 0x35, 0xc5, 0x8b, 0xfd, 0xae, 0x69, 0x4a, 0x05,
	0x9f, 0xe9, 0xe3, 0x09, 0x4c, 0x6b, 0x82, 0xf6, 0xb5, 0x06, 0x9e, 0xb8, 0x71, 0x03, 0x0e, 0x6f,
	0x47, 0x5b, 0x11, 0x44, 0xd0, 0x44, 0xfc, 0x47, 0x01, 0x3c, 0xfc, 0x5c, 0x2a, 0x6a, 0xf4, 0x13,
	0x4e, 0xcf, 0x56, 0x96, 0x06, 0x81, 0xfc, 0x4e, 0x6f, 0x1a, 0xf3, 0x35, 0xd0, 0xa1, 0x7d, 0x6b,
	0x05, 0xb9, 0x94, 0x00, 0x59, 0x7a, 0xf0, 0x47, 0x41, 0xb9, 0x9b, 0xdd, 0x3a, 0x02, 0xfb, 0x94,
	0x74, 0x49, 0x6d, 0x2a, 0xf8, 0x07, 0x04, 0xd3, 0x51, 0xf7, 0x31, 0x3e, 0x1d, 0xe9, 0x3a, 0xe1,
	0xea, 0x2e, 0xa4, 0x79, 0x2f, 0x1b, 0x0b, 0x1f, 0xfd, 0xfa, 0xe7, 0x56, 0xe6, 0xb2, 0x51, 0xf5,
	0x36, 0x93, 0x0f, 0xd4, 0x1c, 0xbf, 0xda, 0x75, 0xd9, 0x2d, 0xda, 0x14, 0xdc, 0xac, 0x98, 0x1d,
	0xd6, 0x54, 0x0b, 0x91, 0x59, 0xb9, 0x6f, 0x6e, 0xbf, 0xfa, 0xe7, 0xc2, 0x97, 0x25, 0x7e, 0x84,
	0xe0, 0xe0, 0x8e, 0x3b, 0x1c, 0x9f, 0x8a, 0xc4, 0x10, 0x77, 0xd7, 0xa7, 0x83, 0x7c, 0x5e, 0x42,
	0x3e, 0x8d, 0x15, 0x64, 0xaf, 0x92, 0x31, 0x80, 0x07, 0xf0, 0x9a, 0x95, 0xfb, 0xf8, 0x17, 0x04,
	0xd3, 0x51, 0x1b, 0x40, 0x0c, 0xb5, 0x09, 0xcb, 0x42, 0x3a, 0x9c, 0xef, 0x48, 0x9c, 0x6f, 0xce,
	0xbe, 0x26, 0x71, 0x86, 0xf8, 0xaa, 0xa6, 0xc6, 0xbd, 0x93, 0xea, 0x87, 0x08, 0xa6, 0xa3, 0xd6,
	0x9f, 0x98, 0x44, 0x12, 0x36, 0xa5, 0xc2, 0xa1, 0x1d, 0x2f, 0xd6, 0x6b, 0xde, 0x7e, 0xe9, 0x73,
	0x5c, 0x19, 0x95, 0xe3, 0xef, 0x11, 0x4c, 0x47, 0xed, 0x11, 0x31, 0xd0, 0x12, 0xd6, 0x9c, 0xc2,
	0xcc, 0x08, 0x16, 0x6a, 0x2a, 0x43, 0x9d, 0x91, 0xba, 0x99, 0xbd, 0xde, 0xcd, 0x0d, 0x4e, 0x12,
	0x2e, 0xa7, 0x18, 0x36, 0x85, 0x32, 0xe9, 0x3a, 0x30, 0x16, 0x25, 0x9e, 0x2b, 0xc6, 0x85, 0xe1,
	0x78, 0x82, 0x3c, 0xea, 0xff, 0x2f, 0x7c, 0xce, 0xbf, 0xf0, 0x7f, 0x43, 0x30, 0xd1, 0x9f, 0x1a,
	0xfc, 0xc2, 0xb0, 0xa9, 0x4a, 0x81, 0xed, 0x63, 0x24, 0xc1, 0x7d, 0x88, 0x2f, 0x8c, 0x54, 0x62,
	0x1f, 0x99, 0x59, 0xb9, 0x5f, 0x9f, 0xc7, 0x97, 0x47, 0xb3, 0x6d, 0xbb, 0xac, 0xd7, 0x0d, 0x3a,
	0xc1, 0xff, 0x22, 0xc8, 0x0d, 0x8e, 0x5a, 0x0c, 0xf7, 0x11, 0xab, 0x53, 0x72, 0x7e, 0x5f, 0xab,
	0xfc, 0xbe, 0x42, 0xb3, 0x97, 0x06, 0xe6, 0xaf, 0x3a, 0x46, 0x9e, 0x7e, 0x11, 0xea, 0xb5, 0xd9,
	0xc5, 0xb1, 0x5c, 0x45, 0xa4, 0xdd, 0x2f, 0xec, 0xef, 0x08, 0x72, 0x83, 0x03, 0x1a, 0x93, 0x7e,
	0xc4, 0xc2, 0x16, 0x3b, 0xbb, 0x7e, 0x65, 0x2b, 0xbb, 0xa8, 0x6c, 0xe5, 0x31, 0x54, 0xf6, 0x0f,
	0x04, 0x93, 0x03, 0x2b, 0x15, 0x7e, 0x69, 0xc8, 0x40, 0xf7, 0x27, 0xbf, 0x3c, 0x5c, 0x51, 0x0f,
	0xfc, 0x5d, 0x99, 0xa9, 0x8b, 0xc7, 0x1e, 0xb0, 0xfa, 0x79, 0x7c, 0x36, 0x85, 0xad, 0x9f, 0x5e,
	0xdf, 0x0e, 0xff, 0x98, 0x81, 0x67, 0x63, 0x17, 0x37, 0x7c, 0x2e, 0x32, 0x83, 0x61, 0x8b, 0x5e,
	0x61, 0xf8, 0xc6, 0x63, 0xfc, 0xac, 0x8a, 0xfb, 0x13, 0x32, 0x6a, 0xe3, 0x56, 0x77, 0xce, 0x8e,
	0xc3, 0x31, 0x87, 0x2a, 0xf5, 0xf7, 0x8d, 0xf7, 0x76, 0x5d, 0xfa, 0xc4, 0x08, 0xf8, 0xbb, 0xcc,
	0xe0, 0x62, 0x15, 0x5c, 0x0a, 0xf1, 0xd9, 0x21, 0xb5, 0x8f, 0xdc, 0x4e, 0x0b, 0xe7, 0x46, 0xb4,
	0xd2, 0xed, 0xd3, 0x7f, 0x47, 0xe0, 0x85, 0x71, 0xc9, 0x34, 0x9b, 0x01, 0xd7, 0xf5, 0x1a, 0x5e,
	0xde, 0x35, 0x7d, 0x21, 0x9f, 0xf8, 0x93, 0x0c, 0x1c, 0x08, 0x6f, 0xa2, 0xf8, 0xe5, 0x21, 0x29,
	0x07, 0xd6, 0xdf, 0xc2, 0xa9, 0x94, 0xda, 0x9a, 0x98, 0x2f, 0x14, 0x31, 0x9f, 0x21, 0x7c, 0x69,
	0x6c, 0x62, 0xd4, 0x62, 0x5c, 0x7f, 0x03, 0x2f, 0xee, 0x9e, 0x10, 0xe5, 0x0b, 0xff, 0x85, 0x20,
	0xb7, 0x42, 0xc5, 0x75, 0x62, 0x2f, 0xcb, 0x6f, 0x68, 0xd8, 0xf0, 0xd3, 0xb2, 0x88, 0xed, 0x25,
	0x34, 0x28, 0xf4, 0x53, 0x7f, 0x26, 0xa4, 0xa3, 0xa4, 0xc6, 0x97, 0x2a, 0xc5, 0x2d, 0x64, 0xa8,
	0x14, 0xfd, 0x8f, 0x7a, 0xe9, 0x76, 0x32, 0x3e, 0x10, 0xc8, 0x9b, 0x9a, 0x25, 0x63, 0x71, 0x64,
	0x2f, 0xdb, 0x6f, 0x95, 0xb0, 0x3b, 0x99, 0xe8, 0x42, 0x52, 0xa2, 0x0b, 0xff, 0x57, 0xa2, 0xed,
	0xc7, 0x9b, 0x68, 0xc8, 0x1d, 0xfe, 0x3c, 0x03, 0x78, 0x95, 0x72, 0x79, 0x48, 0x5d, 0xdb, 0xe2,
	0xaa, 0xe3, 0xcb, 0xa1, 0x54, 0x76, 0xaa, 0xf8, 0x49, 0x9f, 0x4c, 0xa1, 0xa9, 0x9b, 0xfa, 0x1b,
	0x45, 0xc4, 0x23, 0x64, 0x5c, 0x1b, 0x83, 0x08, 0xb1, 0xc3, 0xb1, 0x47, 0xc7, 0x8a, 0x71, 0x73,
	0x37, 0x74, 0x44, 0x3a, 0xbd, 0x72, 0x0b, 0x0e, 0x37, 0x99, 0x1d, 0x35, 0xb1, 0x57, 0x70, 0xe0,
	0xdf, 0xe2, 0xb2, 0x77, 0xf1, 0x2f, 0xa3, 0xfa, 0x79, 0xad, 0xda, 0x66, 0x1d, 0xe2, 0xb4, 0xab,
	0xcc, 0x6d, 0x9b, 0x6d, 0xea, 0xc8, 0xb5, 0xc0, 0x54, 0x22, 0xd2, 0xb5, 0x78, 0xe0, 0x23, 0xf6,
	0x45, 0x8b, 0x89, 0x7f, 0x10, 0x5a, 0xdb, 0x2b, 0xb5, 0xce, 0xfc, 0x17, 0x00, 0x00, 0xff, 0xff,
	0x97, 0x0f, 0xf8, 0xc8, 0x46, 0x17, 0x00, 0x00,
}
