// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1beta2/workflow_templates.proto

package dataproc // import "google.golang.org/genproto/googleapis/cloud/dataproc/v1beta2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The operation state.
type WorkflowMetadata_State int32

const (
	// Unused.
	WorkflowMetadata_UNKNOWN WorkflowMetadata_State = 0
	// The operation has been created.
	WorkflowMetadata_PENDING WorkflowMetadata_State = 1
	// The operation is running.
	WorkflowMetadata_RUNNING WorkflowMetadata_State = 2
	// The operation is done; either cancelled or completed.
	WorkflowMetadata_DONE WorkflowMetadata_State = 3
)

var WorkflowMetadata_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
}
var WorkflowMetadata_State_value = map[string]int32{
	"UNKNOWN": 0,
	"PENDING": 1,
	"RUNNING": 2,
	"DONE":    3,
}

func (x WorkflowMetadata_State) String() string {
	return proto.EnumName(WorkflowMetadata_State_name, int32(x))
}
func (WorkflowMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{5, 0}
}

// The workflow node state.
type WorkflowNode_NodeState int32

const (
	// State is unspecified.
	WorkflowNode_NODE_STATUS_UNSPECIFIED WorkflowNode_NodeState = 0
	// The node is awaiting prerequisite node to finish.
	WorkflowNode_BLOCKED WorkflowNode_NodeState = 1
	// The node is runnable but not running.
	WorkflowNode_RUNNABLE WorkflowNode_NodeState = 2
	// The node is running.
	WorkflowNode_RUNNING WorkflowNode_NodeState = 3
	// The node completed successfully.
	WorkflowNode_COMPLETED WorkflowNode_NodeState = 4
	// The node failed. A node can be marked FAILED because
	// its ancestor or peer failed.
	WorkflowNode_FAILED WorkflowNode_NodeState = 5
)

var WorkflowNode_NodeState_name = map[int32]string{
	0: "NODE_STATUS_UNSPECIFIED",
	1: "BLOCKED",
	2: "RUNNABLE",
	3: "RUNNING",
	4: "COMPLETED",
	5: "FAILED",
}
var WorkflowNode_NodeState_value = map[string]int32{
	"NODE_STATUS_UNSPECIFIED": 0,
	"BLOCKED":                 1,
	"RUNNABLE":                2,
	"RUNNING":                 3,
	"COMPLETED":               4,
	"FAILED":                  5,
}

func (x WorkflowNode_NodeState) String() string {
	return proto.EnumName(WorkflowNode_NodeState_name, int32(x))
}
func (WorkflowNode_NodeState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{8, 0}
}

// A Cloud Dataproc workflow template resource.
type WorkflowTemplate struct {
	// Required. The template id.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). Cannot begin or end with underscore
	// or hyphen. Must consist of between 3 and 50 characters.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The "resource name" of the template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Used to perform a consistent read-modify-write.
	//
	// This field should be left blank for a `CreateWorkflowTemplate` request. It
	// is required for an `UpdateWorkflowTemplate` request, and must match the
	// current server version. A typical update template flow would fetch the
	// current template with a `GetWorkflowTemplate` request, which will return
	// the current template with the `version` field filled in with the
	// current server version. The user updates other fields in the template,
	// then returns it as part of the `UpdateWorkflowTemplate` request.
	Version int32 `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The time template was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time template was last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The labels to associate with this template. These labels
	// will be propagated to all jobs and clusters created by the workflow
	// instance.
	//
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	//
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	//
	// No more than 32 labels can be associated with a template.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. WorkflowTemplate scheduling information.
	Placement *WorkflowTemplatePlacement `protobuf:"bytes,7,opt,name=placement,proto3" json:"placement,omitempty"`
	// Required. The Directed Acyclic Graph of Jobs to submit.
	Jobs                 []*OrderedJob `protobuf:"bytes,8,rep,name=jobs,proto3" json:"jobs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *WorkflowTemplate) Reset()         { *m = WorkflowTemplate{} }
func (m *WorkflowTemplate) String() string { return proto.CompactTextString(m) }
func (*WorkflowTemplate) ProtoMessage()    {}
func (*WorkflowTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{0}
}
func (m *WorkflowTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowTemplate.Unmarshal(m, b)
}
func (m *WorkflowTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowTemplate.Marshal(b, m, deterministic)
}
func (dst *WorkflowTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowTemplate.Merge(dst, src)
}
func (m *WorkflowTemplate) XXX_Size() int {
	return xxx_messageInfo_WorkflowTemplate.Size(m)
}
func (m *WorkflowTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowTemplate proto.InternalMessageInfo

func (m *WorkflowTemplate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *WorkflowTemplate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WorkflowTemplate) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *WorkflowTemplate) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *WorkflowTemplate) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *WorkflowTemplate) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *WorkflowTemplate) GetPlacement() *WorkflowTemplatePlacement {
	if m != nil {
		return m.Placement
	}
	return nil
}

func (m *WorkflowTemplate) GetJobs() []*OrderedJob {
	if m != nil {
		return m.Jobs
	}
	return nil
}

// Specifies workflow execution target.
//
// Either `managed_cluster` or `cluster_selector` is required.
type WorkflowTemplatePlacement struct {
	// Required. Specifies where workflow executes; either on a managed
	// cluster or an existing cluster chosen by labels.
	//
	// Types that are valid to be assigned to Placement:
	//	*WorkflowTemplatePlacement_ManagedCluster
	//	*WorkflowTemplatePlacement_ClusterSelector
	Placement            isWorkflowTemplatePlacement_Placement `protobuf_oneof:"placement"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *WorkflowTemplatePlacement) Reset()         { *m = WorkflowTemplatePlacement{} }
func (m *WorkflowTemplatePlacement) String() string { return proto.CompactTextString(m) }
func (*WorkflowTemplatePlacement) ProtoMessage()    {}
func (*WorkflowTemplatePlacement) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{1}
}
func (m *WorkflowTemplatePlacement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowTemplatePlacement.Unmarshal(m, b)
}
func (m *WorkflowTemplatePlacement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowTemplatePlacement.Marshal(b, m, deterministic)
}
func (dst *WorkflowTemplatePlacement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowTemplatePlacement.Merge(dst, src)
}
func (m *WorkflowTemplatePlacement) XXX_Size() int {
	return xxx_messageInfo_WorkflowTemplatePlacement.Size(m)
}
func (m *WorkflowTemplatePlacement) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowTemplatePlacement.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowTemplatePlacement proto.InternalMessageInfo

type isWorkflowTemplatePlacement_Placement interface {
	isWorkflowTemplatePlacement_Placement()
}

type WorkflowTemplatePlacement_ManagedCluster struct {
	ManagedCluster *ManagedCluster `protobuf:"bytes,1,opt,name=managed_cluster,json=managedCluster,proto3,oneof"`
}

type WorkflowTemplatePlacement_ClusterSelector struct {
	ClusterSelector *ClusterSelector `protobuf:"bytes,2,opt,name=cluster_selector,json=clusterSelector,proto3,oneof"`
}

func (*WorkflowTemplatePlacement_ManagedCluster) isWorkflowTemplatePlacement_Placement() {}

func (*WorkflowTemplatePlacement_ClusterSelector) isWorkflowTemplatePlacement_Placement() {}

func (m *WorkflowTemplatePlacement) GetPlacement() isWorkflowTemplatePlacement_Placement {
	if m != nil {
		return m.Placement
	}
	return nil
}

func (m *WorkflowTemplatePlacement) GetManagedCluster() *ManagedCluster {
	if x, ok := m.GetPlacement().(*WorkflowTemplatePlacement_ManagedCluster); ok {
		return x.ManagedCluster
	}
	return nil
}

func (m *WorkflowTemplatePlacement) GetClusterSelector() *ClusterSelector {
	if x, ok := m.GetPlacement().(*WorkflowTemplatePlacement_ClusterSelector); ok {
		return x.ClusterSelector
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*WorkflowTemplatePlacement) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _WorkflowTemplatePlacement_OneofMarshaler, _WorkflowTemplatePlacement_OneofUnmarshaler, _WorkflowTemplatePlacement_OneofSizer, []interface{}{
		(*WorkflowTemplatePlacement_ManagedCluster)(nil),
		(*WorkflowTemplatePlacement_ClusterSelector)(nil),
	}
}

func _WorkflowTemplatePlacement_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*WorkflowTemplatePlacement)
	// placement
	switch x := m.Placement.(type) {
	case *WorkflowTemplatePlacement_ManagedCluster:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManagedCluster); err != nil {
			return err
		}
	case *WorkflowTemplatePlacement_ClusterSelector:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterSelector); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("WorkflowTemplatePlacement.Placement has unexpected type %T", x)
	}
	return nil
}

func _WorkflowTemplatePlacement_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*WorkflowTemplatePlacement)
	switch tag {
	case 1: // placement.managed_cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ManagedCluster)
		err := b.DecodeMessage(msg)
		m.Placement = &WorkflowTemplatePlacement_ManagedCluster{msg}
		return true, err
	case 2: // placement.cluster_selector
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClusterSelector)
		err := b.DecodeMessage(msg)
		m.Placement = &WorkflowTemplatePlacement_ClusterSelector{msg}
		return true, err
	default:
		return false, nil
	}
}

func _WorkflowTemplatePlacement_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*WorkflowTemplatePlacement)
	// placement
	switch x := m.Placement.(type) {
	case *WorkflowTemplatePlacement_ManagedCluster:
		s := proto.Size(x.ManagedCluster)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *WorkflowTemplatePlacement_ClusterSelector:
		s := proto.Size(x.ClusterSelector)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Cluster that is managed by the workflow.
type ManagedCluster struct {
	// Required. The cluster name prefix. A unique cluster name will be formed by
	// appending a random suffix.
	//
	// The name must contain only lower-case letters (a-z), numbers (0-9),
	// and hyphens (-). Must begin with a letter. Cannot begin or end with
	// hyphen. Must consist of between 2 and 35 characters.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Required. The cluster configuration.
	Config *ClusterConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	// Optional. The labels to associate with this cluster.
	//
	// Label keys must be between 1 and 63 characters long, and must conform to
	// the following PCRE regular expression:
	// [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
	//
	// Label values must be between 1 and 63 characters long, and must conform to
	// the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
	//
	// No more than 32 labels can be associated with a given cluster.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ManagedCluster) Reset()         { *m = ManagedCluster{} }
func (m *ManagedCluster) String() string { return proto.CompactTextString(m) }
func (*ManagedCluster) ProtoMessage()    {}
func (*ManagedCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{2}
}
func (m *ManagedCluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManagedCluster.Unmarshal(m, b)
}
func (m *ManagedCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManagedCluster.Marshal(b, m, deterministic)
}
func (dst *ManagedCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManagedCluster.Merge(dst, src)
}
func (m *ManagedCluster) XXX_Size() int {
	return xxx_messageInfo_ManagedCluster.Size(m)
}
func (m *ManagedCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_ManagedCluster.DiscardUnknown(m)
}

var xxx_messageInfo_ManagedCluster proto.InternalMessageInfo

func (m *ManagedCluster) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ManagedCluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ManagedCluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// A selector that chooses target cluster for jobs based on metadata.
type ClusterSelector struct {
	// Optional. The zone where workflow process executes. This parameter does not
	// affect the selection of the cluster.
	//
	// If unspecified, the zone of the first cluster matching the selector
	// is used.
	Zone string `protobuf:"bytes,1,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. The cluster labels. Cluster must have all labels
	// to match.
	ClusterLabels        map[string]string `protobuf:"bytes,2,rep,name=cluster_labels,json=clusterLabels,proto3" json:"cluster_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ClusterSelector) Reset()         { *m = ClusterSelector{} }
func (m *ClusterSelector) String() string { return proto.CompactTextString(m) }
func (*ClusterSelector) ProtoMessage()    {}
func (*ClusterSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{3}
}
func (m *ClusterSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterSelector.Unmarshal(m, b)
}
func (m *ClusterSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterSelector.Marshal(b, m, deterministic)
}
func (dst *ClusterSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterSelector.Merge(dst, src)
}
func (m *ClusterSelector) XXX_Size() int {
	return xxx_messageInfo_ClusterSelector.Size(m)
}
func (m *ClusterSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterSelector.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterSelector proto.InternalMessageInfo

func (m *ClusterSelector) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ClusterSelector) GetClusterLabels() map[string]string {
	if m != nil {
		return m.ClusterLabels
	}
	return nil
}

// A job executed by the workflow.
type OrderedJob struct {
	// Required. The step id. The id must be unique among all jobs
	// within the template.
	//
	// The step id is used as prefix for job id, as job
	// `goog-dataproc-workflow-step-id` label, and in
	// [prerequisiteStepIds][google.cloud.dataproc.v1beta2.OrderedJob.prerequisite_step_ids] field from other
	// steps.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). Cannot begin or end with underscore
	// or hyphen. Must consist of between 3 and 50 characters.
	StepId string `protobuf:"bytes,1,opt,name=step_id,json=stepId,proto3" json:"step_id,omitempty"`
	// Required. The job definition.
	//
	// Types that are valid to be assigned to JobType:
	//	*OrderedJob_HadoopJob
	//	*OrderedJob_SparkJob
	//	*OrderedJob_PysparkJob
	//	*OrderedJob_HiveJob
	//	*OrderedJob_PigJob
	//	*OrderedJob_SparkSqlJob
	JobType isOrderedJob_JobType `protobuf_oneof:"job_type"`
	// Optional. The labels to associate with this job.
	//
	// Label keys must be between 1 and 63 characters long, and must conform to
	// the following regular expression:
	// [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
	//
	// Label values must be between 1 and 63 characters long, and must conform to
	// the following regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
	//
	// No more than 32 labels can be associated with a given job.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Job scheduling configuration.
	Scheduling *JobScheduling `protobuf:"bytes,9,opt,name=scheduling,proto3" json:"scheduling,omitempty"`
	// Optional. The optional list of prerequisite job step_ids.
	// If not specified, the job will start at the beginning of workflow.
	PrerequisiteStepIds  []string `protobuf:"bytes,10,rep,name=prerequisite_step_ids,json=prerequisiteStepIds,proto3" json:"prerequisite_step_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OrderedJob) Reset()         { *m = OrderedJob{} }
func (m *OrderedJob) String() string { return proto.CompactTextString(m) }
func (*OrderedJob) ProtoMessage()    {}
func (*OrderedJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{4}
}
func (m *OrderedJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OrderedJob.Unmarshal(m, b)
}
func (m *OrderedJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OrderedJob.Marshal(b, m, deterministic)
}
func (dst *OrderedJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrderedJob.Merge(dst, src)
}
func (m *OrderedJob) XXX_Size() int {
	return xxx_messageInfo_OrderedJob.Size(m)
}
func (m *OrderedJob) XXX_DiscardUnknown() {
	xxx_messageInfo_OrderedJob.DiscardUnknown(m)
}

var xxx_messageInfo_OrderedJob proto.InternalMessageInfo

func (m *OrderedJob) GetStepId() string {
	if m != nil {
		return m.StepId
	}
	return ""
}

type isOrderedJob_JobType interface {
	isOrderedJob_JobType()
}

type OrderedJob_HadoopJob struct {
	HadoopJob *HadoopJob `protobuf:"bytes,2,opt,name=hadoop_job,json=hadoopJob,proto3,oneof"`
}

type OrderedJob_SparkJob struct {
	SparkJob *SparkJob `protobuf:"bytes,3,opt,name=spark_job,json=sparkJob,proto3,oneof"`
}

type OrderedJob_PysparkJob struct {
	PysparkJob *PySparkJob `protobuf:"bytes,4,opt,name=pyspark_job,json=pysparkJob,proto3,oneof"`
}

type OrderedJob_HiveJob struct {
	HiveJob *HiveJob `protobuf:"bytes,5,opt,name=hive_job,json=hiveJob,proto3,oneof"`
}

type OrderedJob_PigJob struct {
	PigJob *PigJob `protobuf:"bytes,6,opt,name=pig_job,json=pigJob,proto3,oneof"`
}

type OrderedJob_SparkSqlJob struct {
	SparkSqlJob *SparkSqlJob `protobuf:"bytes,7,opt,name=spark_sql_job,json=sparkSqlJob,proto3,oneof"`
}

func (*OrderedJob_HadoopJob) isOrderedJob_JobType() {}

func (*OrderedJob_SparkJob) isOrderedJob_JobType() {}

func (*OrderedJob_PysparkJob) isOrderedJob_JobType() {}

func (*OrderedJob_HiveJob) isOrderedJob_JobType() {}

func (*OrderedJob_PigJob) isOrderedJob_JobType() {}

func (*OrderedJob_SparkSqlJob) isOrderedJob_JobType() {}

func (m *OrderedJob) GetJobType() isOrderedJob_JobType {
	if m != nil {
		return m.JobType
	}
	return nil
}

func (m *OrderedJob) GetHadoopJob() *HadoopJob {
	if x, ok := m.GetJobType().(*OrderedJob_HadoopJob); ok {
		return x.HadoopJob
	}
	return nil
}

func (m *OrderedJob) GetSparkJob() *SparkJob {
	if x, ok := m.GetJobType().(*OrderedJob_SparkJob); ok {
		return x.SparkJob
	}
	return nil
}

func (m *OrderedJob) GetPysparkJob() *PySparkJob {
	if x, ok := m.GetJobType().(*OrderedJob_PysparkJob); ok {
		return x.PysparkJob
	}
	return nil
}

func (m *OrderedJob) GetHiveJob() *HiveJob {
	if x, ok := m.GetJobType().(*OrderedJob_HiveJob); ok {
		return x.HiveJob
	}
	return nil
}

func (m *OrderedJob) GetPigJob() *PigJob {
	if x, ok := m.GetJobType().(*OrderedJob_PigJob); ok {
		return x.PigJob
	}
	return nil
}

func (m *OrderedJob) GetSparkSqlJob() *SparkSqlJob {
	if x, ok := m.GetJobType().(*OrderedJob_SparkSqlJob); ok {
		return x.SparkSqlJob
	}
	return nil
}

func (m *OrderedJob) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *OrderedJob) GetScheduling() *JobScheduling {
	if m != nil {
		return m.Scheduling
	}
	return nil
}

func (m *OrderedJob) GetPrerequisiteStepIds() []string {
	if m != nil {
		return m.PrerequisiteStepIds
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OrderedJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OrderedJob_OneofMarshaler, _OrderedJob_OneofUnmarshaler, _OrderedJob_OneofSizer, []interface{}{
		(*OrderedJob_HadoopJob)(nil),
		(*OrderedJob_SparkJob)(nil),
		(*OrderedJob_PysparkJob)(nil),
		(*OrderedJob_HiveJob)(nil),
		(*OrderedJob_PigJob)(nil),
		(*OrderedJob_SparkSqlJob)(nil),
	}
}

func _OrderedJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OrderedJob)
	// job_type
	switch x := m.JobType.(type) {
	case *OrderedJob_HadoopJob:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HadoopJob); err != nil {
			return err
		}
	case *OrderedJob_SparkJob:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkJob); err != nil {
			return err
		}
	case *OrderedJob_PysparkJob:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PysparkJob); err != nil {
			return err
		}
	case *OrderedJob_HiveJob:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HiveJob); err != nil {
			return err
		}
	case *OrderedJob_PigJob:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PigJob); err != nil {
			return err
		}
	case *OrderedJob_SparkSqlJob:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkSqlJob); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("OrderedJob.JobType has unexpected type %T", x)
	}
	return nil
}

func _OrderedJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OrderedJob)
	switch tag {
	case 2: // job_type.hadoop_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HadoopJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_HadoopJob{msg}
		return true, err
	case 3: // job_type.spark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_SparkJob{msg}
		return true, err
	case 4: // job_type.pyspark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PySparkJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_PysparkJob{msg}
		return true, err
	case 5: // job_type.hive_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HiveJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_HiveJob{msg}
		return true, err
	case 6: // job_type.pig_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PigJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_PigJob{msg}
		return true, err
	case 7: // job_type.spark_sql_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkSqlJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_SparkSqlJob{msg}
		return true, err
	default:
		return false, nil
	}
}

func _OrderedJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OrderedJob)
	// job_type
	switch x := m.JobType.(type) {
	case *OrderedJob_HadoopJob:
		s := proto.Size(x.HadoopJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_SparkJob:
		s := proto.Size(x.SparkJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_PysparkJob:
		s := proto.Size(x.PysparkJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_HiveJob:
		s := proto.Size(x.HiveJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_PigJob:
		s := proto.Size(x.PigJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_SparkSqlJob:
		s := proto.Size(x.SparkSqlJob)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc workflow template resource.
type WorkflowMetadata struct {
	// Output only. The "resource name" of the template.
	Template string `protobuf:"bytes,1,opt,name=template,proto3" json:"template,omitempty"`
	// Output only. The version of template at the time of
	// workflow instantiation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The create cluster operation metadata.
	CreateCluster *ClusterOperation `protobuf:"bytes,3,opt,name=create_cluster,json=createCluster,proto3" json:"create_cluster,omitempty"`
	// Output only. The workflow graph.
	Graph *WorkflowGraph `protobuf:"bytes,4,opt,name=graph,proto3" json:"graph,omitempty"`
	// Output only. The delete cluster operation metadata.
	DeleteCluster *ClusterOperation `protobuf:"bytes,5,opt,name=delete_cluster,json=deleteCluster,proto3" json:"delete_cluster,omitempty"`
	// Output only. The workflow state.
	State WorkflowMetadata_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.dataproc.v1beta2.WorkflowMetadata_State" json:"state,omitempty"`
	// Output only. The name of the managed cluster.
	ClusterName string `protobuf:"bytes,7,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Map from parameter names to values that were used for those parameters.
	Parameters           map[string]string `protobuf:"bytes,8,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *WorkflowMetadata) Reset()         { *m = WorkflowMetadata{} }
func (m *WorkflowMetadata) String() string { return proto.CompactTextString(m) }
func (*WorkflowMetadata) ProtoMessage()    {}
func (*WorkflowMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{5}
}
func (m *WorkflowMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowMetadata.Unmarshal(m, b)
}
func (m *WorkflowMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowMetadata.Marshal(b, m, deterministic)
}
func (dst *WorkflowMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowMetadata.Merge(dst, src)
}
func (m *WorkflowMetadata) XXX_Size() int {
	return xxx_messageInfo_WorkflowMetadata.Size(m)
}
func (m *WorkflowMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowMetadata proto.InternalMessageInfo

func (m *WorkflowMetadata) GetTemplate() string {
	if m != nil {
		return m.Template
	}
	return ""
}

func (m *WorkflowMetadata) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *WorkflowMetadata) GetCreateCluster() *ClusterOperation {
	if m != nil {
		return m.CreateCluster
	}
	return nil
}

func (m *WorkflowMetadata) GetGraph() *WorkflowGraph {
	if m != nil {
		return m.Graph
	}
	return nil
}

func (m *WorkflowMetadata) GetDeleteCluster() *ClusterOperation {
	if m != nil {
		return m.DeleteCluster
	}
	return nil
}

func (m *WorkflowMetadata) GetState() WorkflowMetadata_State {
	if m != nil {
		return m.State
	}
	return WorkflowMetadata_UNKNOWN
}

func (m *WorkflowMetadata) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *WorkflowMetadata) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

// The cluster operation triggered by a workflow.
type ClusterOperation struct {
	// Output only. The id of the cluster operation.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// Output only. Error, if operation failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Indicates the operation is done.
	Done                 bool     `protobuf:"varint,3,opt,name=done,proto3" json:"done,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterOperation) Reset()         { *m = ClusterOperation{} }
func (m *ClusterOperation) String() string { return proto.CompactTextString(m) }
func (*ClusterOperation) ProtoMessage()    {}
func (*ClusterOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{6}
}
func (m *ClusterOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterOperation.Unmarshal(m, b)
}
func (m *ClusterOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterOperation.Marshal(b, m, deterministic)
}
func (dst *ClusterOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterOperation.Merge(dst, src)
}
func (m *ClusterOperation) XXX_Size() int {
	return xxx_messageInfo_ClusterOperation.Size(m)
}
func (m *ClusterOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterOperation.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterOperation proto.InternalMessageInfo

func (m *ClusterOperation) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *ClusterOperation) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *ClusterOperation) GetDone() bool {
	if m != nil {
		return m.Done
	}
	return false
}

// The workflow graph.
type WorkflowGraph struct {
	// Output only. The workflow nodes.
	Nodes                []*WorkflowNode `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *WorkflowGraph) Reset()         { *m = WorkflowGraph{} }
func (m *WorkflowGraph) String() string { return proto.CompactTextString(m) }
func (*WorkflowGraph) ProtoMessage()    {}
func (*WorkflowGraph) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{7}
}
func (m *WorkflowGraph) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowGraph.Unmarshal(m, b)
}
func (m *WorkflowGraph) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowGraph.Marshal(b, m, deterministic)
}
func (dst *WorkflowGraph) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowGraph.Merge(dst, src)
}
func (m *WorkflowGraph) XXX_Size() int {
	return xxx_messageInfo_WorkflowGraph.Size(m)
}
func (m *WorkflowGraph) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowGraph.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowGraph proto.InternalMessageInfo

func (m *WorkflowGraph) GetNodes() []*WorkflowNode {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// The workflow node.
type WorkflowNode struct {
	// Output only. The name of the node.
	StepId string `protobuf:"bytes,1,opt,name=step_id,json=stepId,proto3" json:"step_id,omitempty"`
	// Output only. Node's prerequisite nodes.
	PrerequisiteStepIds []string `protobuf:"bytes,2,rep,name=prerequisite_step_ids,json=prerequisiteStepIds,proto3" json:"prerequisite_step_ids,omitempty"`
	// Output only. The job id; populated after the node enters RUNNING state.
	JobId string `protobuf:"bytes,3,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Output only. The node state.
	State WorkflowNode_NodeState `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.dataproc.v1beta2.WorkflowNode_NodeState" json:"state,omitempty"`
	// Output only. The error detail.
	Error                string   `protobuf:"bytes,6,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WorkflowNode) Reset()         { *m = WorkflowNode{} }
func (m *WorkflowNode) String() string { return proto.CompactTextString(m) }
func (*WorkflowNode) ProtoMessage()    {}
func (*WorkflowNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{8}
}
func (m *WorkflowNode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkflowNode.Unmarshal(m, b)
}
func (m *WorkflowNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkflowNode.Marshal(b, m, deterministic)
}
func (dst *WorkflowNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkflowNode.Merge(dst, src)
}
func (m *WorkflowNode) XXX_Size() int {
	return xxx_messageInfo_WorkflowNode.Size(m)
}
func (m *WorkflowNode) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkflowNode.DiscardUnknown(m)
}

var xxx_messageInfo_WorkflowNode proto.InternalMessageInfo

func (m *WorkflowNode) GetStepId() string {
	if m != nil {
		return m.StepId
	}
	return ""
}

func (m *WorkflowNode) GetPrerequisiteStepIds() []string {
	if m != nil {
		return m.PrerequisiteStepIds
	}
	return nil
}

func (m *WorkflowNode) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *WorkflowNode) GetState() WorkflowNode_NodeState {
	if m != nil {
		return m.State
	}
	return WorkflowNode_NODE_STATUS_UNSPECIFIED
}

func (m *WorkflowNode) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// A request to create a workflow template.
type CreateWorkflowTemplateRequest struct {
	// Required. The "resource name" of the region, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Dataproc workflow template to create.
	Template             *WorkflowTemplate `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateWorkflowTemplateRequest) Reset()         { *m = CreateWorkflowTemplateRequest{} }
func (m *CreateWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*CreateWorkflowTemplateRequest) ProtoMessage()    {}
func (*CreateWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{9}
}
func (m *CreateWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *CreateWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *CreateWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateWorkflowTemplateRequest.Merge(dst, src)
}
func (m *CreateWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_CreateWorkflowTemplateRequest.Size(m)
}
func (m *CreateWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateWorkflowTemplateRequest proto.InternalMessageInfo

func (m *CreateWorkflowTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateWorkflowTemplateRequest) GetTemplate() *WorkflowTemplate {
	if m != nil {
		return m.Template
	}
	return nil
}

// A request to fetch a workflow template.
type GetWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The version of workflow template to retrieve. Only previously
	// instatiated versions can be retrieved.
	//
	// If unspecified, retrieves the current version.
	Version              int32    `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetWorkflowTemplateRequest) Reset()         { *m = GetWorkflowTemplateRequest{} }
func (m *GetWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*GetWorkflowTemplateRequest) ProtoMessage()    {}
func (*GetWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{10}
}
func (m *GetWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *GetWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *GetWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkflowTemplateRequest.Merge(dst, src)
}
func (m *GetWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_GetWorkflowTemplateRequest.Size(m)
}
func (m *GetWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkflowTemplateRequest proto.InternalMessageInfo

func (m *GetWorkflowTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetWorkflowTemplateRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

// A request to instantiate a workflow template.
type InstantiateWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The version of workflow template to instantiate. If specified,
	// the workflow will be instantiated only if the current version of
	// the workflow template has the supplied version.
	//
	// This option cannot be used to instantiate a previous version of
	// workflow template.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. A tag that prevents multiple concurrent workflow
	// instances with the same tag from running. This mitigates risk of
	// concurrent instances started due to retries.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The tag must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	InstanceId           string   `protobuf:"bytes,3,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstantiateWorkflowTemplateRequest) Reset()         { *m = InstantiateWorkflowTemplateRequest{} }
func (m *InstantiateWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*InstantiateWorkflowTemplateRequest) ProtoMessage()    {}
func (*InstantiateWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{11}
}
func (m *InstantiateWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstantiateWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *InstantiateWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstantiateWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *InstantiateWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstantiateWorkflowTemplateRequest.Merge(dst, src)
}
func (m *InstantiateWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_InstantiateWorkflowTemplateRequest.Size(m)
}
func (m *InstantiateWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstantiateWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstantiateWorkflowTemplateRequest proto.InternalMessageInfo

func (m *InstantiateWorkflowTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstantiateWorkflowTemplateRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *InstantiateWorkflowTemplateRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

// A request to instantiate an inline workflow template.
type InstantiateInlineWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template region, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The workflow template to instantiate.
	Template *WorkflowTemplate `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	// Optional. A tag that prevents multiple concurrent workflow
	// instances with the same tag from running. This mitigates risk of
	// concurrent instances started due to retries.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The tag must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	InstanceId           string   `protobuf:"bytes,3,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstantiateInlineWorkflowTemplateRequest) Reset() {
	*m = InstantiateInlineWorkflowTemplateRequest{}
}
func (m *InstantiateInlineWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*InstantiateInlineWorkflowTemplateRequest) ProtoMessage()    {}
func (*InstantiateInlineWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{12}
}
func (m *InstantiateInlineWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *InstantiateInlineWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *InstantiateInlineWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.Merge(dst, src)
}
func (m *InstantiateInlineWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.Size(m)
}
func (m *InstantiateInlineWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstantiateInlineWorkflowTemplateRequest proto.InternalMessageInfo

func (m *InstantiateInlineWorkflowTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *InstantiateInlineWorkflowTemplateRequest) GetTemplate() *WorkflowTemplate {
	if m != nil {
		return m.Template
	}
	return nil
}

func (m *InstantiateInlineWorkflowTemplateRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

// A request to update a workflow template.
type UpdateWorkflowTemplateRequest struct {
	// Required. The updated workflow template.
	//
	// The `template.version` field must match the current version.
	Template             *WorkflowTemplate `protobuf:"bytes,1,opt,name=template,proto3" json:"template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateWorkflowTemplateRequest) Reset()         { *m = UpdateWorkflowTemplateRequest{} }
func (m *UpdateWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateWorkflowTemplateRequest) ProtoMessage()    {}
func (*UpdateWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{13}
}
func (m *UpdateWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *UpdateWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateWorkflowTemplateRequest.Merge(dst, src)
}
func (m *UpdateWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateWorkflowTemplateRequest.Size(m)
}
func (m *UpdateWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateWorkflowTemplateRequest proto.InternalMessageInfo

func (m *UpdateWorkflowTemplateRequest) GetTemplate() *WorkflowTemplate {
	if m != nil {
		return m.Template
	}
	return nil
}

// A request to list workflow templates in a project.
type ListWorkflowTemplatesRequest struct {
	// Required. The "resource name" of the region, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in each response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, returned by a previous call, to request the
	// next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListWorkflowTemplatesRequest) Reset()         { *m = ListWorkflowTemplatesRequest{} }
func (m *ListWorkflowTemplatesRequest) String() string { return proto.CompactTextString(m) }
func (*ListWorkflowTemplatesRequest) ProtoMessage()    {}
func (*ListWorkflowTemplatesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{14}
}
func (m *ListWorkflowTemplatesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListWorkflowTemplatesRequest.Unmarshal(m, b)
}
func (m *ListWorkflowTemplatesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListWorkflowTemplatesRequest.Marshal(b, m, deterministic)
}
func (dst *ListWorkflowTemplatesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWorkflowTemplatesRequest.Merge(dst, src)
}
func (m *ListWorkflowTemplatesRequest) XXX_Size() int {
	return xxx_messageInfo_ListWorkflowTemplatesRequest.Size(m)
}
func (m *ListWorkflowTemplatesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWorkflowTemplatesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListWorkflowTemplatesRequest proto.InternalMessageInfo

func (m *ListWorkflowTemplatesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListWorkflowTemplatesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListWorkflowTemplatesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response to a request to list workflow templates in a project.
type ListWorkflowTemplatesResponse struct {
	// Output only. WorkflowTemplates list.
	Templates []*WorkflowTemplate `protobuf:"bytes,1,rep,name=templates,proto3" json:"templates,omitempty"`
	// Output only. This token is included in the response if there are more results
	// to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent <code>ListWorkflowTemplatesRequest</code>.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListWorkflowTemplatesResponse) Reset()         { *m = ListWorkflowTemplatesResponse{} }
func (m *ListWorkflowTemplatesResponse) String() string { return proto.CompactTextString(m) }
func (*ListWorkflowTemplatesResponse) ProtoMessage()    {}
func (*ListWorkflowTemplatesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{15}
}
func (m *ListWorkflowTemplatesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListWorkflowTemplatesResponse.Unmarshal(m, b)
}
func (m *ListWorkflowTemplatesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListWorkflowTemplatesResponse.Marshal(b, m, deterministic)
}
func (dst *ListWorkflowTemplatesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWorkflowTemplatesResponse.Merge(dst, src)
}
func (m *ListWorkflowTemplatesResponse) XXX_Size() int {
	return xxx_messageInfo_ListWorkflowTemplatesResponse.Size(m)
}
func (m *ListWorkflowTemplatesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWorkflowTemplatesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListWorkflowTemplatesResponse proto.InternalMessageInfo

func (m *ListWorkflowTemplatesResponse) GetTemplates() []*WorkflowTemplate {
	if m != nil {
		return m.Templates
	}
	return nil
}

func (m *ListWorkflowTemplatesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to delete a workflow template.
//
// Currently started workflows will remain running.
type DeleteWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The version of workflow template to delete. If specified,
	// will only delete the template if the current server version matches
	// specified version.
	Version              int32    `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteWorkflowTemplateRequest) Reset()         { *m = DeleteWorkflowTemplateRequest{} }
func (m *DeleteWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteWorkflowTemplateRequest) ProtoMessage()    {}
func (*DeleteWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_workflow_templates_592be9b1ef908c67, []int{16}
}
func (m *DeleteWorkflowTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteWorkflowTemplateRequest.Unmarshal(m, b)
}
func (m *DeleteWorkflowTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteWorkflowTemplateRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteWorkflowTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteWorkflowTemplateRequest.Merge(dst, src)
}
func (m *DeleteWorkflowTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteWorkflowTemplateRequest.Size(m)
}
func (m *DeleteWorkflowTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteWorkflowTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteWorkflowTemplateRequest proto.InternalMessageInfo

func (m *DeleteWorkflowTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteWorkflowTemplateRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func init() {
	proto.RegisterType((*WorkflowTemplate)(nil), "google.cloud.dataproc.v1beta2.WorkflowTemplate")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.WorkflowTemplate.LabelsEntry")
	proto.RegisterType((*WorkflowTemplatePlacement)(nil), "google.cloud.dataproc.v1beta2.WorkflowTemplatePlacement")
	proto.RegisterType((*ManagedCluster)(nil), "google.cloud.dataproc.v1beta2.ManagedCluster")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.ManagedCluster.LabelsEntry")
	proto.RegisterType((*ClusterSelector)(nil), "google.cloud.dataproc.v1beta2.ClusterSelector")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.ClusterSelector.ClusterLabelsEntry")
	proto.RegisterType((*OrderedJob)(nil), "google.cloud.dataproc.v1beta2.OrderedJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.OrderedJob.LabelsEntry")
	proto.RegisterType((*WorkflowMetadata)(nil), "google.cloud.dataproc.v1beta2.WorkflowMetadata")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.WorkflowMetadata.ParametersEntry")
	proto.RegisterType((*ClusterOperation)(nil), "google.cloud.dataproc.v1beta2.ClusterOperation")
	proto.RegisterType((*WorkflowGraph)(nil), "google.cloud.dataproc.v1beta2.WorkflowGraph")
	proto.RegisterType((*WorkflowNode)(nil), "google.cloud.dataproc.v1beta2.WorkflowNode")
	proto.RegisterType((*CreateWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.CreateWorkflowTemplateRequest")
	proto.RegisterType((*GetWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.GetWorkflowTemplateRequest")
	proto.RegisterType((*InstantiateWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.InstantiateWorkflowTemplateRequest")
	proto.RegisterType((*InstantiateInlineWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.InstantiateInlineWorkflowTemplateRequest")
	proto.RegisterType((*UpdateWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.UpdateWorkflowTemplateRequest")
	proto.RegisterType((*ListWorkflowTemplatesRequest)(nil), "google.cloud.dataproc.v1beta2.ListWorkflowTemplatesRequest")
	proto.RegisterType((*ListWorkflowTemplatesResponse)(nil), "google.cloud.dataproc.v1beta2.ListWorkflowTemplatesResponse")
	proto.RegisterType((*DeleteWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.DeleteWorkflowTemplateRequest")
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.WorkflowMetadata_State", WorkflowMetadata_State_name, WorkflowMetadata_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.WorkflowNode_NodeState", WorkflowNode_NodeState_name, WorkflowNode_NodeState_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// WorkflowTemplateServiceClient is the client API for WorkflowTemplateService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WorkflowTemplateServiceClient interface {
	// Creates new workflow template.
	CreateWorkflowTemplate(ctx context.Context, in *CreateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error)
	// Retrieves the latest workflow template.
	//
	// Can retrieve previously instantiated template by specifying optional
	// version parameter.
	GetWorkflowTemplate(ctx context.Context, in *GetWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error)
	// Instantiates a template and begins execution.
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [operations.get][google.longrunning.Operations.GetOperation].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [operations.cancel][google.longrunning.Operations.CancelOperation].
	// This will cause any inflight jobs to be cancelled and workflow-owned
	// clusters to be deleted.
	//
	// The [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [WorkflowMetadata][google.cloud.dataproc.v1beta2.WorkflowMetadata].
	//
	// On successful completion,
	// [Operation.response][google.longrunning.Operation.response] will be
	// [Empty][google.protobuf.Empty].
	InstantiateWorkflowTemplate(ctx context.Context, in *InstantiateWorkflowTemplateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Instantiates a template and begins execution.
	//
	// This method is equivalent to executing the sequence
	// [CreateWorkflowTemplate][google.cloud.dataproc.v1beta2.WorkflowTemplateService.CreateWorkflowTemplate], [InstantiateWorkflowTemplate][google.cloud.dataproc.v1beta2.WorkflowTemplateService.InstantiateWorkflowTemplate],
	// [DeleteWorkflowTemplate][google.cloud.dataproc.v1beta2.WorkflowTemplateService.DeleteWorkflowTemplate].
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [operations.get][google.longrunning.Operations.GetOperation].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [operations.cancel][google.longrunning.Operations.CancelOperation].
	// This will cause any inflight jobs to be cancelled and workflow-owned
	// clusters to be deleted.
	//
	// The [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [WorkflowMetadata][google.cloud.dataproc.v1beta2.WorkflowMetadata].
	//
	// On successful completion,
	// [Operation.response][google.longrunning.Operation.response] will be
	// [Empty][google.protobuf.Empty].
	InstantiateInlineWorkflowTemplate(ctx context.Context, in *InstantiateInlineWorkflowTemplateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates (replaces) workflow template. The updated template
	// must contain version that matches the current server version.
	UpdateWorkflowTemplate(ctx context.Context, in *UpdateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error)
	// Lists workflows that match the specified filter in the request.
	ListWorkflowTemplates(ctx context.Context, in *ListWorkflowTemplatesRequest, opts ...grpc.CallOption) (*ListWorkflowTemplatesResponse, error)
	// Deletes a workflow template. It does not cancel in-progress workflows.
	DeleteWorkflowTemplate(ctx context.Context, in *DeleteWorkflowTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type workflowTemplateServiceClient struct {
	cc *grpc.ClientConn
}

func NewWorkflowTemplateServiceClient(cc *grpc.ClientConn) WorkflowTemplateServiceClient {
	return &workflowTemplateServiceClient{cc}
}

func (c *workflowTemplateServiceClient) CreateWorkflowTemplate(ctx context.Context, in *CreateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error) {
	out := new(WorkflowTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/CreateWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) GetWorkflowTemplate(ctx context.Context, in *GetWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error) {
	out := new(WorkflowTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/GetWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) InstantiateWorkflowTemplate(ctx context.Context, in *InstantiateWorkflowTemplateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/InstantiateWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) InstantiateInlineWorkflowTemplate(ctx context.Context, in *InstantiateInlineWorkflowTemplateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/InstantiateInlineWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) UpdateWorkflowTemplate(ctx context.Context, in *UpdateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error) {
	out := new(WorkflowTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/UpdateWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) ListWorkflowTemplates(ctx context.Context, in *ListWorkflowTemplatesRequest, opts ...grpc.CallOption) (*ListWorkflowTemplatesResponse, error) {
	out := new(ListWorkflowTemplatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/ListWorkflowTemplates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) DeleteWorkflowTemplate(ctx context.Context, in *DeleteWorkflowTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/DeleteWorkflowTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkflowTemplateServiceServer is the server API for WorkflowTemplateService service.
type WorkflowTemplateServiceServer interface {
	// Creates new workflow template.
	CreateWorkflowTemplate(context.Context, *CreateWorkflowTemplateRequest) (*WorkflowTemplate, error)
	// Retrieves the latest workflow template.
	//
	// Can retrieve previously instantiated template by specifying optional
	// version parameter.
	GetWorkflowTemplate(context.Context, *GetWorkflowTemplateRequest) (*WorkflowTemplate, error)
	// Instantiates a template and begins execution.
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [operations.get][google.longrunning.Operations.GetOperation].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [operations.cancel][google.longrunning.Operations.CancelOperation].
	// This will cause any inflight jobs to be cancelled and workflow-owned
	// clusters to be deleted.
	//
	// The [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [WorkflowMetadata][google.cloud.dataproc.v1beta2.WorkflowMetadata].
	//
	// On successful completion,
	// [Operation.response][google.longrunning.Operation.response] will be
	// [Empty][google.protobuf.Empty].
	InstantiateWorkflowTemplate(context.Context, *InstantiateWorkflowTemplateRequest) (*longrunning.Operation, error)
	// Instantiates a template and begins execution.
	//
	// This method is equivalent to executing the sequence
	// [CreateWorkflowTemplate][google.cloud.dataproc.v1beta2.WorkflowTemplateService.CreateWorkflowTemplate], [InstantiateWorkflowTemplate][google.cloud.dataproc.v1beta2.WorkflowTemplateService.InstantiateWorkflowTemplate],
	// [DeleteWorkflowTemplate][google.cloud.dataproc.v1beta2.WorkflowTemplateService.DeleteWorkflowTemplate].
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [operations.get][google.longrunning.Operations.GetOperation].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [operations.cancel][google.longrunning.Operations.CancelOperation].
	// This will cause any inflight jobs to be cancelled and workflow-owned
	// clusters to be deleted.
	//
	// The [Operation.metadata][google.longrunning.Operation.metadata] will be
	// [WorkflowMetadata][google.cloud.dataproc.v1beta2.WorkflowMetadata].
	//
	// On successful completion,
	// [Operation.response][google.longrunning.Operation.response] will be
	// [Empty][google.protobuf.Empty].
	InstantiateInlineWorkflowTemplate(context.Context, *InstantiateInlineWorkflowTemplateRequest) (*longrunning.Operation, error)
	// Updates (replaces) workflow template. The updated template
	// must contain version that matches the current server version.
	UpdateWorkflowTemplate(context.Context, *UpdateWorkflowTemplateRequest) (*WorkflowTemplate, error)
	// Lists workflows that match the specified filter in the request.
	ListWorkflowTemplates(context.Context, *ListWorkflowTemplatesRequest) (*ListWorkflowTemplatesResponse, error)
	// Deletes a workflow template. It does not cancel in-progress workflows.
	DeleteWorkflowTemplate(context.Context, *DeleteWorkflowTemplateRequest) (*empty.Empty, error)
}

func RegisterWorkflowTemplateServiceServer(s *grpc.Server, srv WorkflowTemplateServiceServer) {
	s.RegisterService(&_WorkflowTemplateService_serviceDesc, srv)
}

func _WorkflowTemplateService_CreateWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).CreateWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/CreateWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).CreateWorkflowTemplate(ctx, req.(*CreateWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_GetWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).GetWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/GetWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).GetWorkflowTemplate(ctx, req.(*GetWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_InstantiateWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstantiateWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).InstantiateWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/InstantiateWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).InstantiateWorkflowTemplate(ctx, req.(*InstantiateWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_InstantiateInlineWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstantiateInlineWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).InstantiateInlineWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/InstantiateInlineWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).InstantiateInlineWorkflowTemplate(ctx, req.(*InstantiateInlineWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_UpdateWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).UpdateWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/UpdateWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).UpdateWorkflowTemplate(ctx, req.(*UpdateWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_ListWorkflowTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkflowTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).ListWorkflowTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/ListWorkflowTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).ListWorkflowTemplates(ctx, req.(*ListWorkflowTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_DeleteWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).DeleteWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/DeleteWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).DeleteWorkflowTemplate(ctx, req.(*DeleteWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WorkflowTemplateService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1beta2.WorkflowTemplateService",
	HandlerType: (*WorkflowTemplateServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWorkflowTemplate",
			Handler:    _WorkflowTemplateService_CreateWorkflowTemplate_Handler,
		},
		{
			MethodName: "GetWorkflowTemplate",
			Handler:    _WorkflowTemplateService_GetWorkflowTemplate_Handler,
		},
		{
			MethodName: "InstantiateWorkflowTemplate",
			Handler:    _WorkflowTemplateService_InstantiateWorkflowTemplate_Handler,
		},
		{
			MethodName: "InstantiateInlineWorkflowTemplate",
			Handler:    _WorkflowTemplateService_InstantiateInlineWorkflowTemplate_Handler,
		},
		{
			MethodName: "UpdateWorkflowTemplate",
			Handler:    _WorkflowTemplateService_UpdateWorkflowTemplate_Handler,
		},
		{
			MethodName: "ListWorkflowTemplates",
			Handler:    _WorkflowTemplateService_ListWorkflowTemplates_Handler,
		},
		{
			MethodName: "DeleteWorkflowTemplate",
			Handler:    _WorkflowTemplateService_DeleteWorkflowTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1beta2/workflow_templates.proto",
}

func init() {
	proto.RegisterFile("google/cloud/dataproc/v1beta2/workflow_templates.proto", fileDescriptor_workflow_templates_592be9b1ef908c67)
}

var fileDescriptor_workflow_templates_592be9b1ef908c67 = []byte{
	// 1794 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0xcf, 0x6f, 0xe3, 0x58,
	0x1d, 0x1f, 0xbb, 0x4d, 0x9a, 0x7c, 0x33, 0x6d, 0xa3, 0xb7, 0x4c, 0x27, 0x64, 0xb6, 0xda, 0x8e,
	0x11, 0x4b, 0x29, 0x43, 0x22, 0x8a, 0x40, 0xb3, 0x9d, 0x19, 0xb1, 0x6d, 0x92, 0xce, 0xa4, 0x4d,
	0x93, 0xe0, 0xb4, 0xbb, 0xab, 0xe1, 0x10, 0x39, 0xf1, 0x1b, 0xd7, 0xad, 0xe3, 0xe7, 0xb1, 0x9d,
	0xee, 0x76, 0xd0, 0x22, 0x81, 0x56, 0x70, 0xe1, 0xc4, 0x4a, 0x7b, 0x5b, 0x38, 0x71, 0x66, 0x6f,
	0xdc, 0x91, 0xf8, 0x03, 0x10, 0x7f, 0xc0, 0x5e, 0x38, 0x23, 0x71, 0xe2, 0x8a, 0xde, 0x0f, 0x3b,
	0xce, 0x4f, 0x27, 0x2d, 0xd2, 0x5e, 0x2a, 0xbf, 0xe7, 0xf7, 0xf9, 0xf8, 0xfb, 0xfd, 0x7c, 0x7f,
	0x39, 0x2e, 0xfc, 0xd4, 0x20, 0xc4, 0xb0, 0x70, 0xb1, 0x6b, 0x91, 0xbe, 0x5e, 0xd4, 0x35, 0x5f,
	0x73, 0x5c, 0xd2, 0x2d, 0x5e, 0xfd, 0xa8, 0x83, 0x7d, 0x6d, 0xb7, 0xf8, 0x31, 0x71, 0x2f, 0x5f,
	0x59, 0xe4, 0xe3, 0xb6, 0x8f, 0x7b, 0x8e, 0xa5, 0xf9, 0xd8, 0x2b, 0x38, 0x2e, 0xf1, 0x09, 0xda,
	0xe4, 0xb8, 0x02, 0xc3, 0x15, 0x02, 0x5c, 0x41, 0xe0, 0xf2, 0x6f, 0x0b, 0x5a, 0xcd, 0x31, 0x8b,
	0x9a, 0x6d, 0x13, 0x5f, 0xf3, 0x4d, 0x62, 0x0b, 0x70, 0xfe, 0xd1, 0xec, 0x87, 0x76, 0xad, 0xbe,
	0xe7, 0x63, 0x37, 0x38, 0xbd, 0x3d, 0xfb, 0xf4, 0x05, 0xe9, 0x04, 0x27, 0xbf, 0x23, 0x4e, 0x5a,
	0xc4, 0x36, 0xdc, 0xbe, 0x6d, 0x9b, 0xb6, 0x51, 0x24, 0x0e, 0x76, 0x87, 0x1e, 0xfe, 0x40, 0x1c,
	0x62, 0xab, 0x4e, 0xff, 0x55, 0x11, 0xf7, 0x1c, 0xff, 0x5a, 0xdc, 0x7c, 0x67, 0xf4, 0xa6, 0x6f,
	0xf6, 0xb0, 0xe7, 0x6b, 0x3d, 0x87, 0x1f, 0x50, 0xfe, 0xb3, 0x04, 0xd9, 0x0f, 0x85, 0x28, 0xa7,
	0x42, 0x13, 0xb4, 0x06, 0xb2, 0xa9, 0xe7, 0xe4, 0x2d, 0x69, 0x3b, 0xad, 0xca, 0xa6, 0x8e, 0x10,
	0x2c, 0xdb, 0x5a, 0x0f, 0xe7, 0x24, 0xb6, 0xc3, 0xae, 0x51, 0x0e, 0x56, 0xae, 0xb0, 0xeb, 0x99,
	0xc4, 0xce, 0x2d, 0x6d, 0x49, 0xdb, 0x09, 0x35, 0x58, 0xa2, 0x27, 0x90, 0xe9, 0xba, 0x58, 0xf3,
	0x71, 0x9b, 0x3e, 0x2c, 0xb7, 0xbc, 0x25, 0x6d, 0x67, 0x76, 0xf3, 0x05, 0x21, 0x70, 0x60, 0x49,
	0xe1, 0x34, 0xb0, 0x44, 0x05, 0x7e, 0x9c, 0x6e, 0x50, 0x70, 0xdf, 0xd1, 0x43, 0x70, 0x22, 0x1e,
	0xcc, 0x8f, 0x33, 0x70, 0x0b, 0x92, 0x96, 0xd6, 0xc1, 0x96, 0x97, 0x4b, 0x6e, 0x2d, 0x6d, 0x67,
	0x76, 0x9f, 0x14, 0x66, 0x46, 0xb5, 0x30, 0xea, 0x78, 0xa1, 0xc6, 0xd0, 0x15, 0xdb, 0x77, 0xaf,
	0x55, 0x41, 0x85, 0x3e, 0x80, 0xb4, 0x63, 0x69, 0x5d, 0xdc, 0xc3, 0xb6, 0x9f, 0x5b, 0x61, 0xf6,
	0x3c, 0x5e, 0x90, 0xb7, 0x19, 0xe0, 0xd5, 0x01, 0x15, 0x7a, 0x06, 0xcb, 0x34, 0xd4, 0xb9, 0x14,
	0x33, 0xf5, 0xfb, 0x31, 0x94, 0x0d, 0x57, 0xc7, 0x2e, 0xd6, 0x8f, 0x48, 0x47, 0x65, 0xb0, 0xfc,
	0x7b, 0x90, 0x89, 0x58, 0x8b, 0xb2, 0xb0, 0x74, 0x89, 0xaf, 0x45, 0x84, 0xe8, 0x25, 0xfa, 0x16,
	0x24, 0xae, 0x34, 0xab, 0x8f, 0x45, 0x1c, 0xf9, 0x62, 0x4f, 0x7e, 0x2c, 0x29, 0x5f, 0x4b, 0xf0,
	0xed, 0xa9, 0x26, 0xa2, 0x8f, 0x60, 0xbd, 0xa7, 0xd9, 0x9a, 0x81, 0xf5, 0xb6, 0x48, 0x5c, 0xc6,
	0x9a, 0xd9, 0xfd, 0x61, 0x8c, 0x89, 0x27, 0x1c, 0x55, 0xe2, 0xa0, 0x17, 0x77, 0xd4, 0xb5, 0xde,
	0xd0, 0x0e, 0xfa, 0x05, 0x64, 0x05, 0x63, 0xdb, 0xc3, 0x16, 0xee, 0xfa, 0xc4, 0x65, 0xc6, 0x65,
	0x76, 0x0b, 0x31, 0xd4, 0x82, 0xa1, 0x25, 0x50, 0x2f, 0xee, 0xa8, 0xeb, 0xdd, 0xe1, 0xad, 0x83,
	0x4c, 0x24, 0x4c, 0xca, 0xef, 0x64, 0x58, 0x1b, 0x36, 0x07, 0x3d, 0x84, 0xbb, 0xc1, 0xc3, 0x59,
	0x2e, 0x73, 0x55, 0x32, 0x62, 0xaf, 0x4e, 0x53, 0xba, 0x0c, 0xc9, 0x2e, 0xb1, 0x5f, 0x99, 0x06,
	0xcb, 0xe8, 0xcc, 0xee, 0xa3, 0xf9, 0xac, 0x2a, 0x31, 0x8c, 0x2a, 0xb0, 0xe8, 0xe7, 0x61, 0x12,
	0x2e, 0xb3, 0xc8, 0xbe, 0xb7, 0x90, 0x6c, 0x93, 0x52, 0xf0, 0x36, 0xb1, 0xfe, 0x87, 0x04, 0xeb,
	0x23, 0xea, 0xd1, 0x72, 0x7e, 0x43, 0xec, 0xb0, 0x9c, 0xe9, 0x35, 0x3a, 0x87, 0xb5, 0x40, 0x1e,
	0x61, 0xbd, 0xcc, 0xac, 0xdf, 0x5f, 0x2c, 0x32, 0xc1, 0x3a, 0xea, 0xc5, 0x6a, 0x37, 0xba, 0x97,
	0x7f, 0x1f, 0xd0, 0xf8, 0xa1, 0x85, 0x7c, 0xfa, 0x6f, 0x02, 0x60, 0x50, 0x0f, 0xe8, 0x3e, 0xac,
	0x78, 0x3e, 0x76, 0xda, 0xa6, 0x2e, 0xe0, 0x49, 0xba, 0xac, 0xea, 0xa8, 0x0a, 0x70, 0xae, 0xe9,
	0x84, 0x38, 0xed, 0x0b, 0xd2, 0x11, 0x99, 0xb6, 0x1d, 0xe3, 0xcf, 0x0b, 0x06, 0x38, 0x22, 0x9d,
	0x17, 0x77, 0xd4, 0xf4, 0x79, 0xb0, 0x40, 0x87, 0x90, 0xf6, 0x1c, 0xcd, 0xbd, 0x64, 0x4c, 0x3c,
	0x3b, 0xbe, 0x17, 0xc3, 0xd4, 0xa2, 0xe7, 0x39, 0x51, 0xca, 0x13, 0xd7, 0xa8, 0x06, 0x19, 0xe7,
	0x7a, 0xc0, 0xc4, 0x7b, 0x63, 0x5c, 0xed, 0x37, 0xaf, 0x23, 0x5c, 0x20, 0xf0, 0x94, 0xad, 0x04,
	0xa9, 0x73, 0xf3, 0x0a, 0x33, 0x2a, 0xde, 0x29, 0xdf, 0x8d, 0x73, 0xcf, 0xbc, 0xc2, 0x9c, 0x67,
	0xe5, 0x9c, 0x5f, 0xa2, 0xf7, 0x61, 0xc5, 0x31, 0x0d, 0xc6, 0x91, 0x64, 0x1c, 0xdf, 0x8d, 0x33,
	0xc7, 0x34, 0x38, 0x45, 0xd2, 0x61, 0x57, 0xa8, 0x09, 0xab, 0xdc, 0x25, 0xef, 0xb5, 0xc5, 0x78,
	0x78, 0x97, 0xdc, 0x99, 0x47, 0xa0, 0xd6, 0x6b, 0x8b, 0x93, 0x65, 0xbc, 0xc1, 0x12, 0x9d, 0x84,
	0x35, 0xc4, 0xbb, 0xe3, 0x4f, 0xe6, 0xee, 0x8e, 0x13, 0x5b, 0x78, 0x0d, 0xc0, 0xeb, 0x9e, 0x63,
	0xbd, 0x6f, 0x99, 0xb6, 0x91, 0x4b, 0xcf, 0x55, 0xdc, 0x47, 0xa4, 0xd3, 0x0a, 0x31, 0x6a, 0x04,
	0x8f, 0x76, 0xe1, 0x9e, 0xe3, 0x62, 0x17, 0xbf, 0xee, 0x9b, 0x9e, 0xe9, 0xe3, 0xb6, 0x48, 0x3e,
	0x2f, 0x07, 0x5b, 0x4b, 0xdb, 0x69, 0xf5, 0xad, 0xe8, 0xcd, 0x16, 0xcb, 0xc4, 0xdb, 0x54, 0xf0,
	0x01, 0x40, 0xea, 0x82, 0x74, 0xda, 0xfe, 0xb5, 0x83, 0x95, 0xdf, 0x26, 0x06, 0xd3, 0xfa, 0x04,
	0xfb, 0x1a, 0xb5, 0x1a, 0xe5, 0x21, 0x15, 0xbc, 0xcd, 0x08, 0xc6, 0x70, 0x1d, 0x9d, 0xd2, 0xf2,
	0xf0, 0x94, 0xfe, 0x00, 0xd6, 0xc4, 0x94, 0x0e, 0xba, 0x3c, 0x4f, 0xeb, 0xe2, 0x7c, 0x05, 0xdf,
	0x08, 0x5e, 0x43, 0xd4, 0x55, 0x4e, 0x13, 0xf4, 0xd9, 0x03, 0x48, 0x18, 0xae, 0xe6, 0x9c, 0x8b,
	0xdc, 0x7e, 0x34, 0xe7, 0xa8, 0x7c, 0x4e, 0x31, 0x2a, 0x87, 0x52, 0xdb, 0x74, 0x6c, 0xe1, 0x88,
	0x6d, 0x89, 0x1b, 0xda, 0xc6, 0x69, 0x02, 0xdb, 0x8e, 0x21, 0xe1, 0xf9, 0x54, 0x26, 0x9a, 0xe8,
	0x6b, 0xb1, 0x59, 0x35, 0xaa, 0x74, 0xa1, 0x45, 0xc1, 0x2a, 0xe7, 0x18, 0x1b, 0x28, 0x2b, 0xe3,
	0x03, 0xa5, 0x0d, 0xe0, 0x68, 0xae, 0xd6, 0xc3, 0xf4, 0xed, 0x4f, 0xa4, 0xf2, 0xcf, 0x16, 0x7d,
	0x68, 0x33, 0x64, 0xe0, 0x49, 0x1d, 0xa1, 0xcc, 0x3f, 0x83, 0xf5, 0x91, 0xdb, 0x0b, 0x35, 0xd2,
	0xc7, 0x90, 0x60, 0x2e, 0xa1, 0x0c, 0xac, 0x9c, 0xd5, 0x8f, 0xeb, 0x8d, 0x0f, 0xeb, 0xd9, 0x3b,
	0x74, 0xd1, 0xac, 0xd4, 0xcb, 0xd5, 0xfa, 0xf3, 0xac, 0x44, 0x17, 0xea, 0x59, 0xbd, 0x4e, 0x17,
	0x32, 0x4a, 0xc1, 0x72, 0xb9, 0x51, 0xaf, 0x64, 0x97, 0x94, 0x36, 0x64, 0x47, 0xc5, 0xa6, 0x82,
	0x84, 0x2f, 0xa7, 0x83, 0x66, 0x9c, 0x09, 0xf7, 0xaa, 0x3a, 0x35, 0x05, 0xbb, 0xae, 0x18, 0xfb,
	0x69, 0x95, 0x2f, 0xe8, 0x3c, 0xd2, 0xe9, 0x3c, 0xa2, 0x09, 0x98, 0x52, 0xd9, 0xb5, 0xa2, 0xc2,
	0xea, 0x50, 0x6a, 0xa0, 0x7d, 0x48, 0xd8, 0x44, 0xc7, 0x5e, 0x4e, 0x62, 0x32, 0xfe, 0x60, 0x4e,
	0x19, 0xeb, 0x44, 0xc7, 0x2a, 0x47, 0x2a, 0x7f, 0x93, 0xe1, 0x6e, 0x74, 0x7f, 0xfa, 0xe4, 0x98,
	0x5a, 0xe2, 0xf2, 0xd4, 0x12, 0x47, 0xf7, 0x20, 0x49, 0xeb, 0xd4, 0xd4, 0x99, 0x1f, 0x69, 0x35,
	0x71, 0x41, 0x3a, 0x55, 0x7d, 0x90, 0x73, 0x89, 0x85, 0x72, 0x8e, 0xda, 0x57, 0xa0, 0x7f, 0x86,
	0x72, 0x2e, 0xd4, 0x2f, 0x19, 0xd1, 0x4f, 0xb9, 0x84, 0x74, 0x78, 0x12, 0x3d, 0x80, 0xfb, 0xf5,
	0x46, 0xb9, 0xd2, 0x6e, 0x9d, 0xee, 0x9f, 0x9e, 0xb5, 0xda, 0x67, 0xf5, 0x56, 0xb3, 0x52, 0xaa,
	0x1e, 0x56, 0x2b, 0x65, 0x1e, 0xda, 0x83, 0x5a, 0xa3, 0x74, 0x5c, 0x29, 0x67, 0x25, 0x74, 0x17,
	0x52, 0x34, 0xb4, 0xfb, 0x07, 0xb5, 0x4a, 0x56, 0x8e, 0x06, 0x7a, 0x09, 0xad, 0x42, 0xba, 0xd4,
	0x38, 0x69, 0xd6, 0x2a, 0xa7, 0x95, 0x72, 0x76, 0x19, 0x01, 0x24, 0x0f, 0xf7, 0xab, 0xb5, 0x4a,
	0x39, 0x9b, 0x50, 0x3e, 0x93, 0x60, 0xb3, 0xc4, 0x2a, 0x7e, 0xf4, 0x15, 0x52, 0xc5, 0xaf, 0xfb,
	0xd8, 0xf3, 0xd1, 0x06, 0x24, 0x1d, 0xcd, 0xa5, 0x6f, 0xcb, 0x42, 0x54, 0xbe, 0x42, 0xc7, 0x91,
	0x3e, 0x25, 0xcf, 0x55, 0xcf, 0x63, 0x4f, 0x08, 0x09, 0x94, 0x23, 0xc8, 0x3f, 0xc7, 0xfe, 0x34,
	0x13, 0x62, 0x7e, 0xb0, 0x0c, 0xb7, 0x42, 0xc5, 0x03, 0xa5, 0x6a, 0x7b, 0xbe, 0x66, 0xfb, 0xe6,
	0x0c, 0xb7, 0x16, 0xe2, 0x44, 0xef, 0x40, 0xc6, 0x64, 0x9c, 0x5d, 0x3c, 0x48, 0x09, 0x08, 0xb6,
	0xaa, 0xba, 0xf2, 0x95, 0x04, 0xdb, 0x91, 0xa7, 0x56, 0x6d, 0xcb, 0xb4, 0xbf, 0x51, 0x49, 0xe3,
	0x4d, 0xb6, 0x60, 0xf3, 0x8c, 0xfd, 0xd8, 0x9a, 0x66, 0xe6, 0xf1, 0xc8, 0x24, 0xba, 0x55, 0x84,
	0x5d, 0x78, 0xbb, 0x66, 0x7a, 0x63, 0x21, 0xf6, 0xe2, 0x34, 0x79, 0x00, 0x69, 0x47, 0x33, 0x70,
	0xdb, 0x33, 0xdf, 0x60, 0x11, 0x95, 0x14, 0xdd, 0x68, 0x99, 0x6f, 0x30, 0xda, 0xa4, 0x1d, 0xd9,
	0xc0, 0x6d, 0x9f, 0x5c, 0x62, 0x5b, 0xb8, 0xc8, 0x8e, 0x9f, 0xd2, 0x0d, 0xe5, 0x0b, 0x09, 0x36,
	0xa7, 0x3c, 0xd4, 0x73, 0x88, 0xed, 0x61, 0x74, 0x02, 0xe9, 0xf0, 0xd3, 0x81, 0x68, 0x45, 0x0b,
	0xfb, 0x38, 0x60, 0x40, 0xef, 0xc2, 0xba, 0x8d, 0x3f, 0xf1, 0xdb, 0x11, 0xa3, 0x78, 0x6b, 0x5c,
	0xa5, 0xdb, 0xcd, 0xd0, 0xb0, 0x13, 0xd8, 0x2c, 0xb3, 0x51, 0xf6, 0x7f, 0xc9, 0xce, 0xdd, 0xaf,
	0xd7, 0xe1, 0xfe, 0x28, 0x53, 0x0b, 0xbb, 0x57, 0x66, 0x17, 0xa3, 0x2f, 0x65, 0xd8, 0x98, 0x5c,
	0xe0, 0xe8, 0x69, 0xdc, 0xfc, 0x9d, 0xd5, 0x17, 0xf2, 0x8b, 0xea, 0xa4, 0x7c, 0x2e, 0xfd, 0xe6,
	0x9f, 0xff, 0xfa, 0x5c, 0xfe, 0xbd, 0xa4, 0x3c, 0x0e, 0xbf, 0x8e, 0xfc, 0x92, 0x47, 0xf9, 0x99,
	0xe3, 0x92, 0x0b, 0xdc, 0xf5, 0xbd, 0xe2, 0x4e, 0xd1, 0xc5, 0x86, 0x49, 0x6c, 0xaf, 0xb8, 0xf3,
	0x69, 0xf8, 0x79, 0x27, 0x8c, 0xdb, 0x5e, 0x98, 0x4f, 0x2f, 0x0f, 0x95, 0xbd, 0x59, 0x2c, 0x16,
	0xe9, 0xf2, 0xcf, 0x2a, 0x31, 0x3c, 0xe8, 0xd7, 0x32, 0xbc, 0x35, 0xa1, 0xf5, 0xa0, 0xb8, 0xdf,
	0x79, 0xd3, 0xdb, 0xd5, 0xe2, 0xca, 0xfc, 0x8a, 0x09, 0xf3, 0x09, 0x8a, 0xe8, 0x42, 0x23, 0x3e,
	0x51, 0x95, 0x71, 0x67, 0x8a, 0x3b, 0x9f, 0xbe, 0x7c, 0x8a, 0xf6, 0xa6, 0x63, 0x23, 0x5a, 0x4c,
	0x44, 0xa3, 0x3f, 0xc9, 0xf0, 0x60, 0x46, 0xcb, 0x44, 0x71, 0xbf, 0x1a, 0xe3, 0xdb, 0x6d, 0x7e,
	0x33, 0xa0, 0x88, 0x7c, 0xfc, 0x2a, 0x84, 0x2f, 0x1b, 0xca, 0x97, 0x3c, 0x37, 0xbe, 0x90, 0x94,
	0xf2, 0x4d, 0x35, 0xd8, 0x33, 0x07, 0x56, 0xec, 0x49, 0x3b, 0x2f, 0x8f, 0x95, 0xc3, 0x9b, 0x4b,
	0x32, 0x42, 0x86, 0xfe, 0x2e, 0xc3, 0xc3, 0xd8, 0xf6, 0x8e, 0x9e, 0xcf, 0xaf, 0xd3, 0xcc, 0x01,
	0x11, 0xa7, 0xd6, 0x5f, 0xb9, 0x5a, 0x5f, 0x49, 0xca, 0xd1, 0x8d, 0x2b, 0xc9, 0x1c, 0xb5, 0x25,
	0x52, 0x5b, 0x1f, 0x29, 0xb5, 0x5b, 0xd4, 0xd6, 0x0c, 0x66, 0xf4, 0x17, 0x19, 0x36, 0x26, 0x0f,
	0x9d, 0xd8, 0x6e, 0x34, 0x73, 0x56, 0x2d, 0x5e, 0x73, 0x7f, 0xe6, 0x1a, 0xfe, 0x51, 0xca, 0xef,
	0x0f, 0x7c, 0x0d, 0xec, 0x2c, 0x2c, 0x98, 0x7a, 0x03, 0xe9, 0x1a, 0xf9, 0xd2, 0x1c, 0x74, 0xb1,
	0xe9, 0x37, 0x50, 0xec, 0x0f, 0x32, 0xdc, 0x9b, 0x38, 0xc3, 0x50, 0xdc, 0xe7, 0xd0, 0x59, 0xe3,
	0x36, 0xff, 0xf4, 0x66, 0x60, 0x3e, 0x36, 0x27, 0x35, 0xac, 0xc5, 0xd2, 0x6f, 0xb8, 0x61, 0x2d,
	0x9a, 0x62, 0xe8, 0xdf, 0x12, 0x6c, 0x4c, 0x1e, 0xa0, 0xb1, 0x69, 0x34, 0x73, 0xee, 0xe6, 0x37,
	0xc6, 0x3e, 0x4d, 0x57, 0x7a, 0x8e, 0x7f, 0x1d, 0x38, 0xbc, 0x73, 0x8b, 0x0e, 0xbd, 0x73, 0x8b,
	0x0e, 0x7d, 0xf0, 0x99, 0x04, 0x0f, 0xbb, 0xa4, 0x37, 0xdb, 0xb7, 0x83, 0x8d, 0xb1, 0x88, 0x35,
	0xa9, 0x1b, 0x4d, 0xe9, 0x65, 0x45, 0x00, 0x0d, 0x62, 0x69, 0xb6, 0x51, 0x20, 0xae, 0x51, 0x34,
	0xb0, 0xcd, 0x9c, 0x2c, 0xf2, 0x5b, 0x9a, 0x63, 0x7a, 0x53, 0xfe, 0x87, 0xf1, 0x24, 0xd8, 0xe8,
	0x24, 0x19, 0xe2, 0xc7, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x10, 0x10, 0x40, 0xc7, 0x97, 0x19,
	0x00, 0x00,
}
