/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by MockGen. DO NOT EDIT.
// Source: sigs.k8s.io/cluster-api-provider-openstack/pkg/cloud/services/compute (interfaces: Client)

// Package compute is a generated GoMock package.
package compute

import (
	reflect "reflect"

	gomock "github.com/golang/mock/gomock"
	attachinterfaces "github.com/gophercloud/gophercloud/openstack/compute/v2/extensions/attachinterfaces"
	availabilityzones "github.com/gophercloud/gophercloud/openstack/compute/v2/extensions/availabilityzones"
	servers "github.com/gophercloud/gophercloud/openstack/compute/v2/servers"
	images "github.com/gophercloud/gophercloud/openstack/imageservice/v2/images"
)

// MockClient is a mock of Client interface.
type MockClient struct {
	ctrl     *gomock.Controller
	recorder *MockClientMockRecorder
}

// MockClientMockRecorder is the mock recorder for MockClient.
type MockClientMockRecorder struct {
	mock *MockClient
}

// NewMockClient creates a new mock instance.
func NewMockClient(ctrl *gomock.Controller) *MockClient {
	mock := &MockClient{ctrl: ctrl}
	mock.recorder = &MockClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockClient) EXPECT() *MockClientMockRecorder {
	return m.recorder
}

// CreateServer mocks base method.
func (m *MockClient) CreateServer(arg0 servers.CreateOptsBuilder) (*ServerExt, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateServer", arg0)
	ret0, _ := ret[0].(*ServerExt)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateServer indicates an expected call of CreateServer.
func (mr *MockClientMockRecorder) CreateServer(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateServer", reflect.TypeOf((*MockClient)(nil).CreateServer), arg0)
}

// DeleteAttachedInterface mocks base method.
func (m *MockClient) DeleteAttachedInterface(arg0, arg1 string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteAttachedInterface", arg0, arg1)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteAttachedInterface indicates an expected call of DeleteAttachedInterface.
func (mr *MockClientMockRecorder) DeleteAttachedInterface(arg0, arg1 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteAttachedInterface", reflect.TypeOf((*MockClient)(nil).DeleteAttachedInterface), arg0, arg1)
}

// DeleteServer mocks base method.
func (m *MockClient) DeleteServer(arg0 string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteServer", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteServer indicates an expected call of DeleteServer.
func (mr *MockClientMockRecorder) DeleteServer(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteServer", reflect.TypeOf((*MockClient)(nil).DeleteServer), arg0)
}

// GetFlavorIDFromName mocks base method.
func (m *MockClient) GetFlavorIDFromName(arg0 string) (string, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetFlavorIDFromName", arg0)
	ret0, _ := ret[0].(string)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetFlavorIDFromName indicates an expected call of GetFlavorIDFromName.
func (mr *MockClientMockRecorder) GetFlavorIDFromName(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetFlavorIDFromName", reflect.TypeOf((*MockClient)(nil).GetFlavorIDFromName), arg0)
}

// GetServer mocks base method.
func (m *MockClient) GetServer(arg0 string) (*ServerExt, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetServer", arg0)
	ret0, _ := ret[0].(*ServerExt)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetServer indicates an expected call of GetServer.
func (mr *MockClientMockRecorder) GetServer(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetServer", reflect.TypeOf((*MockClient)(nil).GetServer), arg0)
}

// ListAttachedInterfaces mocks base method.
func (m *MockClient) ListAttachedInterfaces(arg0 string) ([]attachinterfaces.Interface, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListAttachedInterfaces", arg0)
	ret0, _ := ret[0].([]attachinterfaces.Interface)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListAttachedInterfaces indicates an expected call of ListAttachedInterfaces.
func (mr *MockClientMockRecorder) ListAttachedInterfaces(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAttachedInterfaces", reflect.TypeOf((*MockClient)(nil).ListAttachedInterfaces), arg0)
}

// ListAvailabilityZones mocks base method.
func (m *MockClient) ListAvailabilityZones() ([]availabilityzones.AvailabilityZone, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListAvailabilityZones")
	ret0, _ := ret[0].([]availabilityzones.AvailabilityZone)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListAvailabilityZones indicates an expected call of ListAvailabilityZones.
func (mr *MockClientMockRecorder) ListAvailabilityZones() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListAvailabilityZones", reflect.TypeOf((*MockClient)(nil).ListAvailabilityZones))
}

// ListImages mocks base method.
func (m *MockClient) ListImages(arg0 images.ListOptsBuilder) ([]images.Image, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListImages", arg0)
	ret0, _ := ret[0].([]images.Image)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListImages indicates an expected call of ListImages.
func (mr *MockClientMockRecorder) ListImages(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListImages", reflect.TypeOf((*MockClient)(nil).ListImages), arg0)
}

// ListServers mocks base method.
func (m *MockClient) ListServers(arg0 servers.ListOptsBuilder) ([]ServerExt, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ListServers", arg0)
	ret0, _ := ret[0].([]ServerExt)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ListServers indicates an expected call of ListServers.
func (mr *MockClientMockRecorder) ListServers(arg0 interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ListServers", reflect.TypeOf((*MockClient)(nil).ListServers), arg0)
}
