// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/networkconnectivity/v1/hub.proto

package networkconnectivity

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The State enum represents the lifecycle stage of a Network Connectivity
// Center resource.
type State int32

const (
	// No state information available
	State_STATE_UNSPECIFIED State = 0
	// The resource's create operation is in progress
	State_CREATING State = 1
	// The resource is active
	State_ACTIVE State = 2
	// The resource's Delete operation is in progress
	State_DELETING State = 3
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[0].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes[0]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{0}
}

// A hub is essentially a collection of spokes. A single hub can contain spokes
// from multiple regions. However, all of a hub's spokes must be associated with
// resources that reside in the same VPC network.
type Hub struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the hub. Hub names must be unique. They use the
	// following form:
	//     `projects/{project_number}/locations/global/hubs/{hub_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time the hub was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the hub was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional labels in key:value format. For more information about labels, see
	// [Requirements for
	// labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An optional description of the hub.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The Google-generated UUID for the hub. This value is unique across all hub
	// resources. If a hub is deleted and another with the same name is created,
	// the new hub is assigned a different unique_id.
	UniqueId string `protobuf:"bytes,8,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
	// Output only. The current lifecycle state of this hub.
	State State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.State" json:"state,omitempty"`
	// The VPC network associated with this hub's spokes. All of the VPN tunnels,
	// VLAN attachments, and router appliance instances referenced by this hub's
	// spokes must belong to this VPC network.
	//
	// This field is read-only. Network Connectivity Center automatically
	// populates it based on the set of spokes attached to the hub.
	RoutingVpcs []*RoutingVPC `protobuf:"bytes,10,rep,name=routing_vpcs,json=routingVpcs,proto3" json:"routing_vpcs,omitempty"`
}

func (x *Hub) Reset() {
	*x = Hub{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Hub) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Hub) ProtoMessage() {}

func (x *Hub) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Hub.ProtoReflect.Descriptor instead.
func (*Hub) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{0}
}

func (x *Hub) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Hub) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Hub) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Hub) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Hub) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Hub) GetUniqueId() string {
	if x != nil {
		return x.UniqueId
	}
	return ""
}

func (x *Hub) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Hub) GetRoutingVpcs() []*RoutingVPC {
	if x != nil {
		return x.RoutingVpcs
	}
	return nil
}

// RoutingsVPC contains information about a VPC network that is associated with
// a hub's spokes.
type RoutingVPC struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of a VPC network.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *RoutingVPC) Reset() {
	*x = RoutingVPC{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoutingVPC) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoutingVPC) ProtoMessage() {}

func (x *RoutingVPC) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoutingVPC.ProtoReflect.Descriptor instead.
func (*RoutingVPC) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{1}
}

func (x *RoutingVPC) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// A spoke represents a connection between your Google Cloud network resources
// and a non-Google-Cloud network.
//
// When you create a spoke, you associate it with a hub. You must also identify
// a value for exactly one of the following fields:
//
// * linked_vpn_tunnels
// * linked_interconnect_attachments
// * linked_router_appliance_instances
type Spoke struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The name of the spoke. Spoke names must be unique. They use the
	// following form:
	//     `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time the spoke was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the spoke was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional labels in key:value format. For more information about labels, see
	// [Requirements for
	// labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An optional description of the spoke.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Immutable. The URI of the hub that this spoke is attached to.
	Hub string `protobuf:"bytes,6,opt,name=hub,proto3" json:"hub,omitempty"`
	// VPN tunnels that are associated with the spoke.
	LinkedVpnTunnels *LinkedVpnTunnels `protobuf:"bytes,17,opt,name=linked_vpn_tunnels,json=linkedVpnTunnels,proto3" json:"linked_vpn_tunnels,omitempty"`
	// VLAN attachments that are associated with the spoke.
	LinkedInterconnectAttachments *LinkedInterconnectAttachments `protobuf:"bytes,18,opt,name=linked_interconnect_attachments,json=linkedInterconnectAttachments,proto3" json:"linked_interconnect_attachments,omitempty"`
	// Router appliance instances that are associated with the spoke.
	LinkedRouterApplianceInstances *LinkedRouterApplianceInstances `protobuf:"bytes,19,opt,name=linked_router_appliance_instances,json=linkedRouterApplianceInstances,proto3" json:"linked_router_appliance_instances,omitempty"`
	// Output only. The Google-generated UUID for the spoke. This value is unique across all
	// spoke resources. If a spoke is deleted and another with the same name is
	// created, the new spoke is assigned a different unique_id.
	UniqueId string `protobuf:"bytes,11,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
	// Output only. The current lifecycle state of this spoke.
	State State `protobuf:"varint,15,opt,name=state,proto3,enum=google.cloud.networkconnectivity.v1.State" json:"state,omitempty"`
}

func (x *Spoke) Reset() {
	*x = Spoke{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Spoke) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Spoke) ProtoMessage() {}

func (x *Spoke) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Spoke.ProtoReflect.Descriptor instead.
func (*Spoke) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{2}
}

func (x *Spoke) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Spoke) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Spoke) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Spoke) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Spoke) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Spoke) GetHub() string {
	if x != nil {
		return x.Hub
	}
	return ""
}

func (x *Spoke) GetLinkedVpnTunnels() *LinkedVpnTunnels {
	if x != nil {
		return x.LinkedVpnTunnels
	}
	return nil
}

func (x *Spoke) GetLinkedInterconnectAttachments() *LinkedInterconnectAttachments {
	if x != nil {
		return x.LinkedInterconnectAttachments
	}
	return nil
}

func (x *Spoke) GetLinkedRouterApplianceInstances() *LinkedRouterApplianceInstances {
	if x != nil {
		return x.LinkedRouterApplianceInstances
	}
	return nil
}

func (x *Spoke) GetUniqueId() string {
	if x != nil {
		return x.UniqueId
	}
	return ""
}

func (x *Spoke) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

// Request for [HubService.ListHubs][google.cloud.networkconnectivity.v1.HubService.ListHubs] method.
type ListHubsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource's name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results per page that should be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the results listed in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListHubsRequest) Reset() {
	*x = ListHubsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHubsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHubsRequest) ProtoMessage() {}

func (x *ListHubsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHubsRequest.ProtoReflect.Descriptor instead.
func (*ListHubsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{3}
}

func (x *ListHubsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListHubsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListHubsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListHubsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListHubsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for [HubService.ListHubs][google.cloud.networkconnectivity.v1.HubService.ListHubs] method.
type ListHubsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested hubs.
	Hubs []*Hub `protobuf:"bytes,1,rep,name=hubs,proto3" json:"hubs,omitempty"`
	// The next pagination token in the List response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListHubsResponse) Reset() {
	*x = ListHubsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHubsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHubsResponse) ProtoMessage() {}

func (x *ListHubsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHubsResponse.ProtoReflect.Descriptor instead.
func (*ListHubsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{4}
}

func (x *ListHubsResponse) GetHubs() []*Hub {
	if x != nil {
		return x.Hubs
	}
	return nil
}

func (x *ListHubsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListHubsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for [HubService.GetHub][google.cloud.networkconnectivity.v1.HubService.GetHub] method.
type GetHubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetHubRequest) Reset() {
	*x = GetHubRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetHubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHubRequest) ProtoMessage() {}

func (x *GetHubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHubRequest.ProtoReflect.Descriptor instead.
func (*GetHubRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{5}
}

func (x *GetHubRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [HubService.CreateHub][google.cloud.networkconnectivity.v1.HubService.CreateHub] method.
type CreateHubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. A unique identifier for the hub.
	HubId string `protobuf:"bytes,2,opt,name=hub_id,json=hubId,proto3" json:"hub_id,omitempty"`
	// Required. The initial values for a new hub.
	Hub *Hub `protobuf:"bytes,3,opt,name=hub,proto3" json:"hub,omitempty"`
	// Optional. A unique request ID (optional). If you specify this ID, you can use it
	// in cases when you need to retry your request. When you need to retry, this
	// ID lets the server know that it can ignore the request if it has already
	// been completed. The server guarantees that for at least 60 minutes after
	// the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateHubRequest) Reset() {
	*x = CreateHubRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateHubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateHubRequest) ProtoMessage() {}

func (x *CreateHubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateHubRequest.ProtoReflect.Descriptor instead.
func (*CreateHubRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{6}
}

func (x *CreateHubRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateHubRequest) GetHubId() string {
	if x != nil {
		return x.HubId
	}
	return ""
}

func (x *CreateHubRequest) GetHub() *Hub {
	if x != nil {
		return x.Hub
	}
	return nil
}

func (x *CreateHubRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for [HubService.UpdateHub][google.cloud.networkconnectivity.v1.HubService.UpdateHub] method.
type UpdateHubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. In the case of an update to an existing hub, field mask is used to specify
	// the fields to be overwritten. The fields specified in the update_mask are
	// relative to the resource, not the full request. A field is overwritten if
	// it is in the mask. If the user does not provide a mask, then all fields are
	// overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The state that the hub should be in after the update.
	Hub *Hub `protobuf:"bytes,2,opt,name=hub,proto3" json:"hub,omitempty"`
	// Optional. A unique request ID (optional). If you specify this ID, you can use it
	// in cases when you need to retry your request. When you need to retry, this
	// ID lets the server know that it can ignore the request if it has already
	// been completed. The server guarantees that for at least 60 minutes after
	// the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateHubRequest) Reset() {
	*x = UpdateHubRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateHubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateHubRequest) ProtoMessage() {}

func (x *UpdateHubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateHubRequest.ProtoReflect.Descriptor instead.
func (*UpdateHubRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateHubRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateHubRequest) GetHub() *Hub {
	if x != nil {
		return x.Hub
	}
	return nil
}

func (x *UpdateHubRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for [HubService.DeleteHub][google.cloud.networkconnectivity.v1.HubService.DeleteHub].
type DeleteHubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hub to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A unique request ID (optional). If you specify this ID, you can use it
	// in cases when you need to retry your request. When you need to retry, this
	// ID lets the server know that it can ignore the request if it has already
	// been completed. The server guarantees that for at least 60 minutes after
	// the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteHubRequest) Reset() {
	*x = DeleteHubRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteHubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteHubRequest) ProtoMessage() {}

func (x *DeleteHubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteHubRequest.ProtoReflect.Descriptor instead.
func (*DeleteHubRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteHubRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteHubRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for [HubService.ListSpokes][google.cloud.networkconnectivity.v1.HubService.ListSpokes].
type ListSpokesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results per page that should be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression that filters the results listed in the response.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results by a certain order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListSpokesRequest) Reset() {
	*x = ListSpokesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSpokesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpokesRequest) ProtoMessage() {}

func (x *ListSpokesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpokesRequest.ProtoReflect.Descriptor instead.
func (*ListSpokesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{9}
}

func (x *ListSpokesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSpokesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSpokesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSpokesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSpokesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response for [HubService.ListSpokes][google.cloud.networkconnectivity.v1.HubService.ListSpokes].
type ListSpokesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested spokes.
	Spokes []*Spoke `protobuf:"bytes,1,rep,name=spokes,proto3" json:"spokes,omitempty"`
	// The next pagination token in the List response. It should be used as
	// page_token for the following request. An empty value means no more result.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListSpokesResponse) Reset() {
	*x = ListSpokesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSpokesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpokesResponse) ProtoMessage() {}

func (x *ListSpokesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpokesResponse.ProtoReflect.Descriptor instead.
func (*ListSpokesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{10}
}

func (x *ListSpokesResponse) GetSpokes() []*Spoke {
	if x != nil {
		return x.Spokes
	}
	return nil
}

func (x *ListSpokesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSpokesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request for [HubService.GetSpoke][google.cloud.networkconnectivity.v1.HubService.GetSpoke].
type GetSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the spoke resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpokeRequest) Reset() {
	*x = GetSpokeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpokeRequest) ProtoMessage() {}

func (x *GetSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpokeRequest.ProtoReflect.Descriptor instead.
func (*GetSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{11}
}

func (x *GetSpokeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for [HubService.CreateSpoke][google.cloud.networkconnectivity.v1.HubService.CreateSpoke].
type CreateSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Unique id for the spoke to create.
	SpokeId string `protobuf:"bytes,2,opt,name=spoke_id,json=spokeId,proto3" json:"spoke_id,omitempty"`
	// Required. The initial values for a new spoke.
	Spoke *Spoke `protobuf:"bytes,3,opt,name=spoke,proto3" json:"spoke,omitempty"`
	// Optional. A unique request ID (optional). If you specify this ID, you can use it
	// in cases when you need to retry your request. When you need to retry, this
	// ID lets the server know that it can ignore the request if it has already
	// been completed. The server guarantees that for at least 60 minutes after
	// the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateSpokeRequest) Reset() {
	*x = CreateSpokeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpokeRequest) ProtoMessage() {}

func (x *CreateSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpokeRequest.ProtoReflect.Descriptor instead.
func (*CreateSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{12}
}

func (x *CreateSpokeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSpokeRequest) GetSpokeId() string {
	if x != nil {
		return x.SpokeId
	}
	return ""
}

func (x *CreateSpokeRequest) GetSpoke() *Spoke {
	if x != nil {
		return x.Spoke
	}
	return nil
}

func (x *CreateSpokeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for [HubService.UpdateSpoke][google.cloud.networkconnectivity.v1.HubService.UpdateSpoke] method.
type UpdateSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. In the case of an update to an existing spoke, field mask is used to
	// specify the fields to be overwritten. The fields specified in the
	// update_mask are relative to the resource, not the full request. A field is
	// overwritten if it is in the mask. If the user does not provide a mask, then
	// all fields are overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The state that the spoke should be in after the update.
	Spoke *Spoke `protobuf:"bytes,2,opt,name=spoke,proto3" json:"spoke,omitempty"`
	// Optional. A unique request ID (optional). If you specify this ID, you can use it
	// in cases when you need to retry your request. When you need to retry, this
	// ID lets the server know that it can ignore the request if it has already
	// been completed. The server guarantees that for at least 60 minutes after
	// the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateSpokeRequest) Reset() {
	*x = UpdateSpokeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpokeRequest) ProtoMessage() {}

func (x *UpdateSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpokeRequest.ProtoReflect.Descriptor instead.
func (*UpdateSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateSpokeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSpokeRequest) GetSpoke() *Spoke {
	if x != nil {
		return x.Spoke
	}
	return nil
}

func (x *UpdateSpokeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for [HubService.DeleteSpoke][google.cloud.networkconnectivity.v1.HubService.DeleteSpoke].
type DeleteSpokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the spoke to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A unique request ID (optional). If you specify this ID, you can use it
	// in cases when you need to retry your request. When you need to retry, this
	// ID lets the server know that it can ignore the request if it has already
	// been completed. The server guarantees that for at least 60 minutes after
	// the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check to see whether the original operation
	// was received. If it was, the server ignores the second request. This
	// behavior prevents clients from mistakenly creating duplicate commitments.
	//
	// The request ID must be a valid UUID, with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteSpokeRequest) Reset() {
	*x = DeleteSpokeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSpokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSpokeRequest) ProtoMessage() {}

func (x *DeleteSpokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSpokeRequest.ProtoReflect.Descriptor instead.
func (*DeleteSpokeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteSpokeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteSpokeRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A collection of Cloud VPN tunnel resources. These resources should be
// redundant HA VPN tunnels that all advertise the same prefixes to Google
// Cloud. Alternatively, in a passive/active configuration, all tunnels
// should be capable of advertising the same prefixes.
type LinkedVpnTunnels struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URIs of linked VPN tunnel resources.
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
	// A value that controls whether site-to-site data transfer is enabled for
	// these resources. This field is set to false by default, but you must set it
	// to true. Note that data transfer is available only in supported locations.
	SiteToSiteDataTransfer bool `protobuf:"varint,2,opt,name=site_to_site_data_transfer,json=siteToSiteDataTransfer,proto3" json:"site_to_site_data_transfer,omitempty"`
}

func (x *LinkedVpnTunnels) Reset() {
	*x = LinkedVpnTunnels{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinkedVpnTunnels) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkedVpnTunnels) ProtoMessage() {}

func (x *LinkedVpnTunnels) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkedVpnTunnels.ProtoReflect.Descriptor instead.
func (*LinkedVpnTunnels) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{15}
}

func (x *LinkedVpnTunnels) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *LinkedVpnTunnels) GetSiteToSiteDataTransfer() bool {
	if x != nil {
		return x.SiteToSiteDataTransfer
	}
	return false
}

// A collection of VLAN attachment resources. These resources should
// be redundant attachments that all advertise the same prefixes to Google
// Cloud. Alternatively, in active/passive configurations, all attachments
// should be capable of advertising the same prefixes.
type LinkedInterconnectAttachments struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URIs of linked interconnect attachment resources
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
	// A value that controls whether site-to-site data transfer is enabled for
	// these resources. This field is set to false by default, but you must set it
	// to true. Note that data transfer is available only in supported locations.
	SiteToSiteDataTransfer bool `protobuf:"varint,2,opt,name=site_to_site_data_transfer,json=siteToSiteDataTransfer,proto3" json:"site_to_site_data_transfer,omitempty"`
}

func (x *LinkedInterconnectAttachments) Reset() {
	*x = LinkedInterconnectAttachments{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinkedInterconnectAttachments) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkedInterconnectAttachments) ProtoMessage() {}

func (x *LinkedInterconnectAttachments) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkedInterconnectAttachments.ProtoReflect.Descriptor instead.
func (*LinkedInterconnectAttachments) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{16}
}

func (x *LinkedInterconnectAttachments) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

func (x *LinkedInterconnectAttachments) GetSiteToSiteDataTransfer() bool {
	if x != nil {
		return x.SiteToSiteDataTransfer
	}
	return false
}

// A collection of router appliance instances. If you have multiple router
// appliance instances connected to the same site, they should all be attached
// to the same spoke.
type LinkedRouterApplianceInstances struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of router appliance instances.
	Instances []*RouterApplianceInstance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// A value that controls whether site-to-site data transfer is enabled for
	// these resources. This field is set to false by default, but you must set it
	// to true. Note that data transfer is available only in supported locations.
	SiteToSiteDataTransfer bool `protobuf:"varint,2,opt,name=site_to_site_data_transfer,json=siteToSiteDataTransfer,proto3" json:"site_to_site_data_transfer,omitempty"`
}

func (x *LinkedRouterApplianceInstances) Reset() {
	*x = LinkedRouterApplianceInstances{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinkedRouterApplianceInstances) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkedRouterApplianceInstances) ProtoMessage() {}

func (x *LinkedRouterApplianceInstances) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkedRouterApplianceInstances.ProtoReflect.Descriptor instead.
func (*LinkedRouterApplianceInstances) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{17}
}

func (x *LinkedRouterApplianceInstances) GetInstances() []*RouterApplianceInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *LinkedRouterApplianceInstances) GetSiteToSiteDataTransfer() bool {
	if x != nil {
		return x.SiteToSiteDataTransfer
	}
	return false
}

// A router appliance instance is a Compute Engine virtual machine (VM) instance
// that acts as a BGP speaker. A router appliance instance is specified by the
// URI of the VM and the internal IP address of one of the VM's network
// interfaces.
type RouterApplianceInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the VM.
	VirtualMachine string `protobuf:"bytes,1,opt,name=virtual_machine,json=virtualMachine,proto3" json:"virtual_machine,omitempty"`
	// The IP address on the VM to use for peering.
	IpAddress string `protobuf:"bytes,3,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
}

func (x *RouterApplianceInstance) Reset() {
	*x = RouterApplianceInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouterApplianceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouterApplianceInstance) ProtoMessage() {}

func (x *RouterApplianceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouterApplianceInstance.ProtoReflect.Descriptor instead.
func (*RouterApplianceInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP(), []int{18}
}

func (x *RouterApplianceInstance) GetVirtualMachine() string {
	if x != nil {
		return x.VirtualMachine
	}
	return ""
}

func (x *RouterApplianceInstance) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

var File_google_cloud_networkconnectivity_v1_hub_proto protoreflect.FileDescriptor

var file_google_cloud_networkconnectivity_v1_hub_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x68, 0x75, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xe7, 0x04, 0x0a, 0x03, 0x48, 0x75, 0x62, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x62, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x75, 0x6e,
	0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x52, 0x0a,
	0x0c, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x70, 0x63, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x50, 0x43, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x70, 0x63,
	0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x5b, 0xea, 0x41,
	0x58, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68,
	0x75, 0x62, 0x73, 0x2f, 0x7b, 0x68, 0x75, 0x62, 0x7d, 0x22, 0x43, 0x0a, 0x0a, 0x52, 0x6f, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x50, 0x43, 0x12, 0x35, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0xe6,
	0x07, 0x0a, 0x05, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b,
	0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x03, 0x68, 0x75, 0x62, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x48, 0x75, 0x62, 0x52, 0x03, 0x68, 0x75, 0x62, 0x12, 0x63, 0x0a, 0x12, 0x6c, 0x69, 0x6e,
	0x6b, 0x65, 0x64, 0x5f, 0x76, 0x70, 0x6e, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x6b,
	0x65, 0x64, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x10, 0x6c, 0x69,
	0x6e, 0x6b, 0x65, 0x64, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x8a,
	0x01, 0x0a, 0x1f, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x6e, 0x6b, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x1d, 0x6c, 0x69,
	0x6e, 0x6b, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x21,
	0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x6b, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x1e, 0x6c, 0x69,
	0x6e, 0x6b, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x09,
	0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x12, 0x45,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x65, 0xea, 0x41, 0x62, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12,
	0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x2f,
	0x7b, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x7d, 0x22, 0xc3, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74,
	0x48, 0x75, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9a, 0x01,
	0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x68, 0x75, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x62, 0x52, 0x04, 0x68, 0x75, 0x62, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x53, 0x0a, 0x0d, 0x47, 0x65,
	0x74, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xd6, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x06, 0x68, 0x75, 0x62, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x68, 0x75,
	0x62, 0x49, 0x64, 0x12, 0x3f, 0x0a, 0x03, 0x68, 0x75, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x68, 0x75, 0x62, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb9, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x3f, 0x0a, 0x03, 0x68, 0x75, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x75, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x68, 0x75, 0x62,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0x7a, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x75,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xc5, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa2, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x42, 0x0a, 0x06, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x06, 0x73, 0x70, 0x6f,
	0x6b, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x57, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x6f, 0x6b, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe2, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1e, 0x0a, 0x08, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x49, 0x64,
	0x12, 0x45, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc1, 0x01, 0x0a, 0x12,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x7e, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x89, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x73, 0x12, 0x39, 0x0a, 0x04, 0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x12,
	0x3a, 0x0a, 0x1a, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x16, 0x73, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x53, 0x69, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x22, 0xa3, 0x01, 0x0a, 0x1d,
	0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x46, 0x0a,
	0x04, 0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f,
	0x0a, 0x2d, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x04, 0x75, 0x72, 0x69, 0x73, 0x12, 0x3a, 0x0a, 0x1a, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f,
	0x5f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x73, 0x69, 0x74, 0x65, 0x54,
	0x6f, 0x53, 0x69, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x22, 0xb8, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x3a, 0x0a, 0x1a, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x74, 0x65,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x73, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x53, 0x69, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x22, 0x87, 0x01, 0x0a,
	0x17, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x0f, 0x76, 0x69, 0x72, 0x74,
	0x75, 0x61, 0x6c, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c,
	0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2a, 0x46, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x32, 0x9d,
	0x10, 0x0a, 0x0a, 0x48, 0x75, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb7, 0x01,
	0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x75, 0x62, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12,
	0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x7d, 0x2f, 0x68, 0x75, 0x62, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa4, 0x01, 0x0a, 0x06, 0x47, 0x65, 0x74, 0x48,
	0x75, 0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x48, 0x75, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x62,
	0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f,
	0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcc,
	0x01, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x75, 0x62, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f,
	0x62, 0x61, 0x6c, 0x7d, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x3a, 0x03, 0x68, 0x75, 0x62, 0xda, 0x41,
	0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x68, 0x75, 0x62, 0x2c, 0x68, 0x75, 0x62, 0x5f,
	0x69, 0x64, 0xca, 0x41, 0x18, 0x0a, 0x03, 0x48, 0x75, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xce, 0x01,
	0x0a, 0x09, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x75, 0x62, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x32, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x68, 0x75, 0x62, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x03, 0x68, 0x75,
	0x62, 0xda, 0x41, 0x0f, 0x68, 0x75, 0x62, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0xca, 0x41, 0x18, 0x0a, 0x03, 0x48, 0x75, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xcc,
	0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x75, 0x62, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61,
	0x6c, 0x2f, 0x68, 0x75, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xba, 0x01,
	0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x70, 0x6f, 0x6b, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65,
	0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa7, 0x01, 0x0a, 0x08, 0x47,
	0x65, 0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd5, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x70, 0x6f, 0x6b, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x33, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73,
	0x3a, 0x05, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x2c, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x5f, 0x69, 0x64, 0xca,
	0x41, 0x1a, 0x0a, 0x05, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd7, 0x01, 0x0a,
	0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x32, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x05,
	0x73, 0x70, 0x6f, 0x6b, 0x65, 0xda, 0x41, 0x11, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x1a, 0x0a, 0x05, 0x53, 0x70,
	0x6f, 0x6b, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xcd, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x66,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x56, 0xca, 0x41, 0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x91,
	0x05, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x42, 0x08, 0x48, 0x75, 0x62, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x31, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0xaa, 0x02,
	0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x3a,
	0x3a, 0x56, 0x31, 0xea, 0x41, 0x60, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x70,
	0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0xea, 0x41, 0x7a, 0x0a, 0x2d, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x7d, 0xea, 0x41, 0x57, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65,
	0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0xea, 0x41, 0x52,
	0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x30, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkconnectivity_v1_hub_proto_rawDescOnce sync.Once
	file_google_cloud_networkconnectivity_v1_hub_proto_rawDescData = file_google_cloud_networkconnectivity_v1_hub_proto_rawDesc
)

func file_google_cloud_networkconnectivity_v1_hub_proto_rawDescGZIP() []byte {
	file_google_cloud_networkconnectivity_v1_hub_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkconnectivity_v1_hub_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkconnectivity_v1_hub_proto_rawDescData)
	})
	return file_google_cloud_networkconnectivity_v1_hub_proto_rawDescData
}

var file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_cloud_networkconnectivity_v1_hub_proto_goTypes = []interface{}{
	(State)(0),                             // 0: google.cloud.networkconnectivity.v1.State
	(*Hub)(nil),                            // 1: google.cloud.networkconnectivity.v1.Hub
	(*RoutingVPC)(nil),                     // 2: google.cloud.networkconnectivity.v1.RoutingVPC
	(*Spoke)(nil),                          // 3: google.cloud.networkconnectivity.v1.Spoke
	(*ListHubsRequest)(nil),                // 4: google.cloud.networkconnectivity.v1.ListHubsRequest
	(*ListHubsResponse)(nil),               // 5: google.cloud.networkconnectivity.v1.ListHubsResponse
	(*GetHubRequest)(nil),                  // 6: google.cloud.networkconnectivity.v1.GetHubRequest
	(*CreateHubRequest)(nil),               // 7: google.cloud.networkconnectivity.v1.CreateHubRequest
	(*UpdateHubRequest)(nil),               // 8: google.cloud.networkconnectivity.v1.UpdateHubRequest
	(*DeleteHubRequest)(nil),               // 9: google.cloud.networkconnectivity.v1.DeleteHubRequest
	(*ListSpokesRequest)(nil),              // 10: google.cloud.networkconnectivity.v1.ListSpokesRequest
	(*ListSpokesResponse)(nil),             // 11: google.cloud.networkconnectivity.v1.ListSpokesResponse
	(*GetSpokeRequest)(nil),                // 12: google.cloud.networkconnectivity.v1.GetSpokeRequest
	(*CreateSpokeRequest)(nil),             // 13: google.cloud.networkconnectivity.v1.CreateSpokeRequest
	(*UpdateSpokeRequest)(nil),             // 14: google.cloud.networkconnectivity.v1.UpdateSpokeRequest
	(*DeleteSpokeRequest)(nil),             // 15: google.cloud.networkconnectivity.v1.DeleteSpokeRequest
	(*LinkedVpnTunnels)(nil),               // 16: google.cloud.networkconnectivity.v1.LinkedVpnTunnels
	(*LinkedInterconnectAttachments)(nil),  // 17: google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
	(*LinkedRouterApplianceInstances)(nil), // 18: google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
	(*RouterApplianceInstance)(nil),        // 19: google.cloud.networkconnectivity.v1.RouterApplianceInstance
	nil,                                    // 20: google.cloud.networkconnectivity.v1.Hub.LabelsEntry
	nil,                                    // 21: google.cloud.networkconnectivity.v1.Spoke.LabelsEntry
	(*timestamppb.Timestamp)(nil),          // 22: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),          // 23: google.protobuf.FieldMask
	(*longrunning.Operation)(nil),          // 24: google.longrunning.Operation
}
var file_google_cloud_networkconnectivity_v1_hub_proto_depIdxs = []int32{
	22, // 0: google.cloud.networkconnectivity.v1.Hub.create_time:type_name -> google.protobuf.Timestamp
	22, // 1: google.cloud.networkconnectivity.v1.Hub.update_time:type_name -> google.protobuf.Timestamp
	20, // 2: google.cloud.networkconnectivity.v1.Hub.labels:type_name -> google.cloud.networkconnectivity.v1.Hub.LabelsEntry
	0,  // 3: google.cloud.networkconnectivity.v1.Hub.state:type_name -> google.cloud.networkconnectivity.v1.State
	2,  // 4: google.cloud.networkconnectivity.v1.Hub.routing_vpcs:type_name -> google.cloud.networkconnectivity.v1.RoutingVPC
	22, // 5: google.cloud.networkconnectivity.v1.Spoke.create_time:type_name -> google.protobuf.Timestamp
	22, // 6: google.cloud.networkconnectivity.v1.Spoke.update_time:type_name -> google.protobuf.Timestamp
	21, // 7: google.cloud.networkconnectivity.v1.Spoke.labels:type_name -> google.cloud.networkconnectivity.v1.Spoke.LabelsEntry
	16, // 8: google.cloud.networkconnectivity.v1.Spoke.linked_vpn_tunnels:type_name -> google.cloud.networkconnectivity.v1.LinkedVpnTunnels
	17, // 9: google.cloud.networkconnectivity.v1.Spoke.linked_interconnect_attachments:type_name -> google.cloud.networkconnectivity.v1.LinkedInterconnectAttachments
	18, // 10: google.cloud.networkconnectivity.v1.Spoke.linked_router_appliance_instances:type_name -> google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances
	0,  // 11: google.cloud.networkconnectivity.v1.Spoke.state:type_name -> google.cloud.networkconnectivity.v1.State
	1,  // 12: google.cloud.networkconnectivity.v1.ListHubsResponse.hubs:type_name -> google.cloud.networkconnectivity.v1.Hub
	1,  // 13: google.cloud.networkconnectivity.v1.CreateHubRequest.hub:type_name -> google.cloud.networkconnectivity.v1.Hub
	23, // 14: google.cloud.networkconnectivity.v1.UpdateHubRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 15: google.cloud.networkconnectivity.v1.UpdateHubRequest.hub:type_name -> google.cloud.networkconnectivity.v1.Hub
	3,  // 16: google.cloud.networkconnectivity.v1.ListSpokesResponse.spokes:type_name -> google.cloud.networkconnectivity.v1.Spoke
	3,  // 17: google.cloud.networkconnectivity.v1.CreateSpokeRequest.spoke:type_name -> google.cloud.networkconnectivity.v1.Spoke
	23, // 18: google.cloud.networkconnectivity.v1.UpdateSpokeRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 19: google.cloud.networkconnectivity.v1.UpdateSpokeRequest.spoke:type_name -> google.cloud.networkconnectivity.v1.Spoke
	19, // 20: google.cloud.networkconnectivity.v1.LinkedRouterApplianceInstances.instances:type_name -> google.cloud.networkconnectivity.v1.RouterApplianceInstance
	4,  // 21: google.cloud.networkconnectivity.v1.HubService.ListHubs:input_type -> google.cloud.networkconnectivity.v1.ListHubsRequest
	6,  // 22: google.cloud.networkconnectivity.v1.HubService.GetHub:input_type -> google.cloud.networkconnectivity.v1.GetHubRequest
	7,  // 23: google.cloud.networkconnectivity.v1.HubService.CreateHub:input_type -> google.cloud.networkconnectivity.v1.CreateHubRequest
	8,  // 24: google.cloud.networkconnectivity.v1.HubService.UpdateHub:input_type -> google.cloud.networkconnectivity.v1.UpdateHubRequest
	9,  // 25: google.cloud.networkconnectivity.v1.HubService.DeleteHub:input_type -> google.cloud.networkconnectivity.v1.DeleteHubRequest
	10, // 26: google.cloud.networkconnectivity.v1.HubService.ListSpokes:input_type -> google.cloud.networkconnectivity.v1.ListSpokesRequest
	12, // 27: google.cloud.networkconnectivity.v1.HubService.GetSpoke:input_type -> google.cloud.networkconnectivity.v1.GetSpokeRequest
	13, // 28: google.cloud.networkconnectivity.v1.HubService.CreateSpoke:input_type -> google.cloud.networkconnectivity.v1.CreateSpokeRequest
	14, // 29: google.cloud.networkconnectivity.v1.HubService.UpdateSpoke:input_type -> google.cloud.networkconnectivity.v1.UpdateSpokeRequest
	15, // 30: google.cloud.networkconnectivity.v1.HubService.DeleteSpoke:input_type -> google.cloud.networkconnectivity.v1.DeleteSpokeRequest
	5,  // 31: google.cloud.networkconnectivity.v1.HubService.ListHubs:output_type -> google.cloud.networkconnectivity.v1.ListHubsResponse
	1,  // 32: google.cloud.networkconnectivity.v1.HubService.GetHub:output_type -> google.cloud.networkconnectivity.v1.Hub
	24, // 33: google.cloud.networkconnectivity.v1.HubService.CreateHub:output_type -> google.longrunning.Operation
	24, // 34: google.cloud.networkconnectivity.v1.HubService.UpdateHub:output_type -> google.longrunning.Operation
	24, // 35: google.cloud.networkconnectivity.v1.HubService.DeleteHub:output_type -> google.longrunning.Operation
	11, // 36: google.cloud.networkconnectivity.v1.HubService.ListSpokes:output_type -> google.cloud.networkconnectivity.v1.ListSpokesResponse
	3,  // 37: google.cloud.networkconnectivity.v1.HubService.GetSpoke:output_type -> google.cloud.networkconnectivity.v1.Spoke
	24, // 38: google.cloud.networkconnectivity.v1.HubService.CreateSpoke:output_type -> google.longrunning.Operation
	24, // 39: google.cloud.networkconnectivity.v1.HubService.UpdateSpoke:output_type -> google.longrunning.Operation
	24, // 40: google.cloud.networkconnectivity.v1.HubService.DeleteSpoke:output_type -> google.longrunning.Operation
	31, // [31:41] is the sub-list for method output_type
	21, // [21:31] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_networkconnectivity_v1_hub_proto_init() }
func file_google_cloud_networkconnectivity_v1_hub_proto_init() {
	if File_google_cloud_networkconnectivity_v1_hub_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Hub); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoutingVPC); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Spoke); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHubsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHubsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetHubRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateHubRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateHubRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteHubRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSpokesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSpokesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSpokeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSpokeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSpokeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSpokeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinkedVpnTunnels); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinkedInterconnectAttachments); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinkedRouterApplianceInstances); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouterApplianceInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkconnectivity_v1_hub_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_networkconnectivity_v1_hub_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkconnectivity_v1_hub_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkconnectivity_v1_hub_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkconnectivity_v1_hub_proto_msgTypes,
	}.Build()
	File_google_cloud_networkconnectivity_v1_hub_proto = out.File
	file_google_cloud_networkconnectivity_v1_hub_proto_rawDesc = nil
	file_google_cloud_networkconnectivity_v1_hub_proto_goTypes = nil
	file_google_cloud_networkconnectivity_v1_hub_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// HubServiceClient is the client API for HubService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HubServiceClient interface {
	// Lists hubs in a given project.
	ListHubs(ctx context.Context, in *ListHubsRequest, opts ...grpc.CallOption) (*ListHubsResponse, error)
	// Gets details about the specified hub.
	GetHub(ctx context.Context, in *GetHubRequest, opts ...grpc.CallOption) (*Hub, error)
	// Creates a new hub in the specified project.
	CreateHub(ctx context.Context, in *CreateHubRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the description and/or labels of the specified hub.
	UpdateHub(ctx context.Context, in *UpdateHubRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes the specified hub.
	DeleteHub(ctx context.Context, in *DeleteHubRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists the spokes in the specified project and location.
	ListSpokes(ctx context.Context, in *ListSpokesRequest, opts ...grpc.CallOption) (*ListSpokesResponse, error)
	// Gets details about the specified spoke.
	GetSpoke(ctx context.Context, in *GetSpokeRequest, opts ...grpc.CallOption) (*Spoke, error)
	// Creates a spoke in the specified project and location.
	CreateSpoke(ctx context.Context, in *CreateSpokeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the parameters of the specified spoke.
	UpdateSpoke(ctx context.Context, in *UpdateSpokeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes the specified spoke.
	DeleteSpoke(ctx context.Context, in *DeleteSpokeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type hubServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHubServiceClient(cc grpc.ClientConnInterface) HubServiceClient {
	return &hubServiceClient{cc}
}

func (c *hubServiceClient) ListHubs(ctx context.Context, in *ListHubsRequest, opts ...grpc.CallOption) (*ListHubsResponse, error) {
	out := new(ListHubsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/ListHubs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetHub(ctx context.Context, in *GetHubRequest, opts ...grpc.CallOption) (*Hub, error) {
	out := new(Hub)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/GetHub", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) CreateHub(ctx context.Context, in *CreateHubRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/CreateHub", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateHub(ctx context.Context, in *UpdateHubRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/UpdateHub", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) DeleteHub(ctx context.Context, in *DeleteHubRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/DeleteHub", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListSpokes(ctx context.Context, in *ListSpokesRequest, opts ...grpc.CallOption) (*ListSpokesResponse, error) {
	out := new(ListSpokesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/ListSpokes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetSpoke(ctx context.Context, in *GetSpokeRequest, opts ...grpc.CallOption) (*Spoke, error) {
	out := new(Spoke)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/GetSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) CreateSpoke(ctx context.Context, in *CreateSpokeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/CreateSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateSpoke(ctx context.Context, in *UpdateSpokeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/UpdateSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) DeleteSpoke(ctx context.Context, in *DeleteSpokeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.networkconnectivity.v1.HubService/DeleteSpoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HubServiceServer is the server API for HubService service.
type HubServiceServer interface {
	// Lists hubs in a given project.
	ListHubs(context.Context, *ListHubsRequest) (*ListHubsResponse, error)
	// Gets details about the specified hub.
	GetHub(context.Context, *GetHubRequest) (*Hub, error)
	// Creates a new hub in the specified project.
	CreateHub(context.Context, *CreateHubRequest) (*longrunning.Operation, error)
	// Updates the description and/or labels of the specified hub.
	UpdateHub(context.Context, *UpdateHubRequest) (*longrunning.Operation, error)
	// Deletes the specified hub.
	DeleteHub(context.Context, *DeleteHubRequest) (*longrunning.Operation, error)
	// Lists the spokes in the specified project and location.
	ListSpokes(context.Context, *ListSpokesRequest) (*ListSpokesResponse, error)
	// Gets details about the specified spoke.
	GetSpoke(context.Context, *GetSpokeRequest) (*Spoke, error)
	// Creates a spoke in the specified project and location.
	CreateSpoke(context.Context, *CreateSpokeRequest) (*longrunning.Operation, error)
	// Updates the parameters of the specified spoke.
	UpdateSpoke(context.Context, *UpdateSpokeRequest) (*longrunning.Operation, error)
	// Deletes the specified spoke.
	DeleteSpoke(context.Context, *DeleteSpokeRequest) (*longrunning.Operation, error)
}

// UnimplementedHubServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHubServiceServer struct {
}

func (*UnimplementedHubServiceServer) ListHubs(context.Context, *ListHubsRequest) (*ListHubsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHubs not implemented")
}
func (*UnimplementedHubServiceServer) GetHub(context.Context, *GetHubRequest) (*Hub, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHub not implemented")
}
func (*UnimplementedHubServiceServer) CreateHub(context.Context, *CreateHubRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHub not implemented")
}
func (*UnimplementedHubServiceServer) UpdateHub(context.Context, *UpdateHubRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHub not implemented")
}
func (*UnimplementedHubServiceServer) DeleteHub(context.Context, *DeleteHubRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHub not implemented")
}
func (*UnimplementedHubServiceServer) ListSpokes(context.Context, *ListSpokesRequest) (*ListSpokesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSpokes not implemented")
}
func (*UnimplementedHubServiceServer) GetSpoke(context.Context, *GetSpokeRequest) (*Spoke, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpoke not implemented")
}
func (*UnimplementedHubServiceServer) CreateSpoke(context.Context, *CreateSpokeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSpoke not implemented")
}
func (*UnimplementedHubServiceServer) UpdateSpoke(context.Context, *UpdateSpokeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpoke not implemented")
}
func (*UnimplementedHubServiceServer) DeleteSpoke(context.Context, *DeleteSpokeRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSpoke not implemented")
}

func RegisterHubServiceServer(s *grpc.Server, srv HubServiceServer) {
	s.RegisterService(&_HubService_serviceDesc, srv)
}

func _HubService_ListHubs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHubsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListHubs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/ListHubs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListHubs(ctx, req.(*ListHubsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/GetHub",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetHub(ctx, req.(*GetHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_CreateHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).CreateHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/CreateHub",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).CreateHub(ctx, req.(*CreateHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/UpdateHub",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateHub(ctx, req.(*UpdateHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_DeleteHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).DeleteHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/DeleteHub",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).DeleteHub(ctx, req.(*DeleteHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListSpokes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSpokesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListSpokes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/ListSpokes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListSpokes(ctx, req.(*ListSpokesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/GetSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetSpoke(ctx, req.(*GetSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_CreateSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).CreateSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/CreateSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).CreateSpoke(ctx, req.(*CreateSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/UpdateSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateSpoke(ctx, req.(*UpdateSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_DeleteSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).DeleteSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.networkconnectivity.v1.HubService/DeleteSpoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).DeleteSpoke(ctx, req.(*DeleteSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HubService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.HubService",
	HandlerType: (*HubServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListHubs",
			Handler:    _HubService_ListHubs_Handler,
		},
		{
			MethodName: "GetHub",
			Handler:    _HubService_GetHub_Handler,
		},
		{
			MethodName: "CreateHub",
			Handler:    _HubService_CreateHub_Handler,
		},
		{
			MethodName: "UpdateHub",
			Handler:    _HubService_UpdateHub_Handler,
		},
		{
			MethodName: "DeleteHub",
			Handler:    _HubService_DeleteHub_Handler,
		},
		{
			MethodName: "ListSpokes",
			Handler:    _HubService_ListSpokes_Handler,
		},
		{
			MethodName: "GetSpoke",
			Handler:    _HubService_GetSpoke_Handler,
		},
		{
			MethodName: "CreateSpoke",
			Handler:    _HubService_CreateSpoke_Handler,
		},
		{
			MethodName: "UpdateSpoke",
			Handler:    _HubService_UpdateSpoke_Handler,
		},
		{
			MethodName: "DeleteSpoke",
			Handler:    _HubService_DeleteSpoke_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/hub.proto",
}
