package com.redhat.openshift;

import org.acegisecurity.providers.encoding.ShaPasswordEncoder;

public class PasswordEncoder {
	public static void main(String[] args) {
		String password = args[0];
		String salt="";
		if (args.length > 1) {
			salt = args[1];	
		}
		if ("".equals(salt)) {
			StringBuilder sb = new StringBuilder(6);
			for (int i = 0; i < 6; i++)
			{
				sb.append(randomChar());
			}
			salt = sb.toString(); 
		}
		String passwordHash = salt + ":"
				+ new ShaPasswordEncoder(256).encodePassword(password, salt);
		System.out.println(passwordHash);
	}

	private static char randomChar() {
		int rnd = (int) (Math.random() * 52);
		char base = (rnd < 26) ? 'A' : 'a';
		return (char) (base + rnd % 26);
	}
}
