// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Operations operations
// swagger:model Operations
type Operations struct {

	// Name of the server boot mode a(Boot from disk using copy A), b(Boot from disk using copy B), c(Reserved for IBM lab use only), d(Boot from media/drives)
	// Enum: [a b c d]
	BootMode string `json:"bootMode,omitempty"`

	// Name of the server operating mode
	// Enum: [normal manual]
	OperatingMode string `json:"operatingMode,omitempty"`

	// Name of the job task to execute
	// Enum: [dston retrydump consoleservice iopreset remotedstoff remotedston iopdump dumprestart]
	Task string `json:"task,omitempty"`
}

// Validate validates this operations
func (m *Operations) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBootMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOperatingMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var operationsTypeBootModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["a","b","c","d"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		operationsTypeBootModePropEnum = append(operationsTypeBootModePropEnum, v)
	}
}

const (

	// OperationsBootModeA captures enum value "a"
	OperationsBootModeA string = "a"

	// OperationsBootModeB captures enum value "b"
	OperationsBootModeB string = "b"

	// OperationsBootModeC captures enum value "c"
	OperationsBootModeC string = "c"

	// OperationsBootModeD captures enum value "d"
	OperationsBootModeD string = "d"
)

// prop value enum
func (m *Operations) validateBootModeEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, operationsTypeBootModePropEnum); err != nil {
		return err
	}
	return nil
}

func (m *Operations) validateBootMode(formats strfmt.Registry) error {

	if swag.IsZero(m.BootMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateBootModeEnum("bootMode", "body", m.BootMode); err != nil {
		return err
	}

	return nil
}

var operationsTypeOperatingModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["normal","manual"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		operationsTypeOperatingModePropEnum = append(operationsTypeOperatingModePropEnum, v)
	}
}

const (

	// OperationsOperatingModeNormal captures enum value "normal"
	OperationsOperatingModeNormal string = "normal"

	// OperationsOperatingModeManual captures enum value "manual"
	OperationsOperatingModeManual string = "manual"
)

// prop value enum
func (m *Operations) validateOperatingModeEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, operationsTypeOperatingModePropEnum); err != nil {
		return err
	}
	return nil
}

func (m *Operations) validateOperatingMode(formats strfmt.Registry) error {

	if swag.IsZero(m.OperatingMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateOperatingModeEnum("operatingMode", "body", m.OperatingMode); err != nil {
		return err
	}

	return nil
}

var operationsTypeTaskPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["dston","retrydump","consoleservice","iopreset","remotedstoff","remotedston","iopdump","dumprestart"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		operationsTypeTaskPropEnum = append(operationsTypeTaskPropEnum, v)
	}
}

const (

	// OperationsTaskDston captures enum value "dston"
	OperationsTaskDston string = "dston"

	// OperationsTaskRetrydump captures enum value "retrydump"
	OperationsTaskRetrydump string = "retrydump"

	// OperationsTaskConsoleservice captures enum value "consoleservice"
	OperationsTaskConsoleservice string = "consoleservice"

	// OperationsTaskIopreset captures enum value "iopreset"
	OperationsTaskIopreset string = "iopreset"

	// OperationsTaskRemotedstoff captures enum value "remotedstoff"
	OperationsTaskRemotedstoff string = "remotedstoff"

	// OperationsTaskRemotedston captures enum value "remotedston"
	OperationsTaskRemotedston string = "remotedston"

	// OperationsTaskIopdump captures enum value "iopdump"
	OperationsTaskIopdump string = "iopdump"

	// OperationsTaskDumprestart captures enum value "dumprestart"
	OperationsTaskDumprestart string = "dumprestart"
)

// prop value enum
func (m *Operations) validateTaskEnum(path, location string, value string) error {
	if err := validate.Enum(path, location, value, operationsTypeTaskPropEnum); err != nil {
		return err
	}
	return nil
}

func (m *Operations) validateTask(formats strfmt.Registry) error {

	if swag.IsZero(m.Task) { // not required
		return nil
	}

	// value enum
	if err := m.validateTaskEnum("task", "body", m.Task); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Operations) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Operations) UnmarshalBinary(b []byte) error {
	var res Operations
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
