package managementgroups

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2018-03-01-preview/managementgroups"

// InheritedPermissions enumerates the values for inherited permissions.
type InheritedPermissions string

const (
	// Delete ...
	Delete InheritedPermissions = "delete"
	// Edit ...
	Edit InheritedPermissions = "edit"
	// Noaccess ...
	Noaccess InheritedPermissions = "noaccess"
	// View ...
	View InheritedPermissions = "view"
)

// PossibleInheritedPermissionsValues returns an array of possible values for the InheritedPermissions const type.
func PossibleInheritedPermissionsValues() []InheritedPermissions {
	return []InheritedPermissions{Delete, Edit, Noaccess, View}
}

// Permissions enumerates the values for permissions.
type Permissions string

const (
	// PermissionsDelete ...
	PermissionsDelete Permissions = "delete"
	// PermissionsEdit ...
	PermissionsEdit Permissions = "edit"
	// PermissionsNoaccess ...
	PermissionsNoaccess Permissions = "noaccess"
	// PermissionsView ...
	PermissionsView Permissions = "view"
)

// PossiblePermissionsValues returns an array of possible values for the Permissions const type.
func PossiblePermissionsValues() []Permissions {
	return []Permissions{PermissionsDelete, PermissionsEdit, PermissionsNoaccess, PermissionsView}
}

// Permissions1 enumerates the values for permissions 1.
type Permissions1 string

const (
	// Permissions1Delete ...
	Permissions1Delete Permissions1 = "delete"
	// Permissions1Edit ...
	Permissions1Edit Permissions1 = "edit"
	// Permissions1Noaccess ...
	Permissions1Noaccess Permissions1 = "noaccess"
	// Permissions1View ...
	Permissions1View Permissions1 = "view"
)

// PossiblePermissions1Values returns an array of possible values for the Permissions1 const type.
func PossiblePermissions1Values() []Permissions1 {
	return []Permissions1{Permissions1Delete, Permissions1Edit, Permissions1Noaccess, Permissions1View}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Updating}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// AlreadyExists ...
	AlreadyExists Reason = "AlreadyExists"
	// Invalid ...
	Invalid Reason = "Invalid"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{AlreadyExists, Invalid}
}

// Status enumerates the values for status.
type Status string

const (
	// Cancelled ...
	Cancelled Status = "Cancelled"
	// Completed ...
	Completed Status = "Completed"
	// Failed ...
	Failed Status = "Failed"
	// NotStarted ...
	NotStarted Status = "NotStarted"
	// NotStartedButGroupsExist ...
	NotStartedButGroupsExist Status = "NotStartedButGroupsExist"
	// Started ...
	Started Status = "Started"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Cancelled, Completed, Failed, NotStarted, NotStartedButGroupsExist, Started}
}

// Type enumerates the values for type.
type Type string

const (
	// ProvidersMicrosoftManagementmanagementGroups ...
	ProvidersMicrosoftManagementmanagementGroups Type = "/providers/Microsoft.Management/managementGroups"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{ProvidersMicrosoftManagementmanagementGroups}
}

// Type1 enumerates the values for type 1.
type Type1 string

const (
	// Type1ProvidersMicrosoftManagementmanagementGroups ...
	Type1ProvidersMicrosoftManagementmanagementGroups Type1 = "/providers/Microsoft.Management/managementGroups"
	// Type1Subscriptions ...
	Type1Subscriptions Type1 = "/subscriptions"
)

// PossibleType1Values returns an array of possible values for the Type1 const type.
func PossibleType1Values() []Type1 {
	return []Type1{Type1ProvidersMicrosoftManagementmanagementGroups, Type1Subscriptions}
}

// Type2 enumerates the values for type 2.
type Type2 string

const (
	// Type2ProvidersMicrosoftManagementmanagementGroups ...
	Type2ProvidersMicrosoftManagementmanagementGroups Type2 = "/providers/Microsoft.Management/managementGroups"
	// Type2Subscriptions ...
	Type2Subscriptions Type2 = "/subscriptions"
)

// PossibleType2Values returns an array of possible values for the Type2 const type.
func PossibleType2Values() []Type2 {
	return []Type2{Type2ProvidersMicrosoftManagementmanagementGroups, Type2Subscriptions}
}

// CheckNameAvailabilityRequest management group name availability check parameters.
type CheckNameAvailabilityRequest struct {
	// Name - the name to check for availability
	Name *string `json:"name,omitempty"`
	// Type - fully qualified resource type which includes provider namespace. Possible values include: 'ProvidersMicrosoftManagementmanagementGroups'
	Type Type `json:"type,omitempty"`
}

// CheckNameAvailabilityResult describes the result of the request to check management group name
// availability.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Required. True indicates name is valid and available. False indicates the name is invalid, unavailable, or both.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; Required if nameAvailable == false. Invalid indicates the name provided does not match the resource provider's naming requirements (incorrect length, unsupported characters, etc.) AlreadyExists indicates that the name is already in use and is therefore unavailable. Possible values include: 'Invalid', 'AlreadyExists'
	Reason Reason `json:"reason,omitempty"`
	// Message - READ-ONLY; Required if nameAvailable == false. Localized. If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`
}

// ChildInfo the child information of a management group.
type ChildInfo struct {
	// Type - The fully qualified resource type which includes provider namespace (e.g. /providers/Microsoft.Management/managementGroups). Possible values include: 'Type1ProvidersMicrosoftManagementmanagementGroups', 'Type1Subscriptions'
	Type Type1 `json:"type,omitempty"`
	// ID - The fully qualified ID for the child resource (management group or subscription).  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Name - The name of the child entity.
	Name *string `json:"name,omitempty"`
	// DisplayName - The friendly name of the child resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Roles - The roles definitions associated with the management group.
	Roles *[]string `json:"roles,omitempty"`
	// Children - The list of children.
	Children *[]ChildInfo `json:"children,omitempty"`
}

// CreateManagementGroupChildInfo the child information of a management group used during creation.
type CreateManagementGroupChildInfo struct {
	// Type - READ-ONLY; The fully qualified resource type which includes provider namespace (e.g. /providers/Microsoft.Management/managementGroups). Possible values include: 'Type2ProvidersMicrosoftManagementmanagementGroups', 'Type2Subscriptions'
	Type Type2 `json:"type,omitempty"`
	// ID - READ-ONLY; The fully qualified ID for the child resource (management group or subscription).  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the child entity.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The friendly name of the child resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Roles - READ-ONLY; The roles definitions associated with the management group.
	Roles *[]string `json:"roles,omitempty"`
	// Children - READ-ONLY; The list of children.
	Children *[]CreateManagementGroupChildInfo `json:"children,omitempty"`
}

// CreateManagementGroupDetails the details of a management group used during creation.
type CreateManagementGroupDetails struct {
	// Version - READ-ONLY; The version number of the object.
	Version *float64 `json:"version,omitempty"`
	// UpdatedTime - READ-ONLY; The date and time when this object was last updated.
	UpdatedTime *date.Time `json:"updatedTime,omitempty"`
	// UpdatedBy - READ-ONLY; The identity of the principal or process that updated the object.
	UpdatedBy *string                `json:"updatedBy,omitempty"`
	Parent    *CreateParentGroupInfo `json:"parent,omitempty"`
}

// CreateManagementGroupProperties the generic properties of a management group used during creation.
type CreateManagementGroupProperties struct {
	// TenantID - READ-ONLY; The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
	TenantID *string `json:"tenantId,omitempty"`
	// DisplayName - The friendly name of the management group. If no value is passed then this  field will be set to the groupId.
	DisplayName *string `json:"displayName,omitempty"`
	// Roles - READ-ONLY; The roles definitions associated with the management group.
	Roles   *[]string                     `json:"roles,omitempty"`
	Details *CreateManagementGroupDetails `json:"details,omitempty"`
	// Children - READ-ONLY; The list of children.
	Children *[]CreateManagementGroupChildInfo `json:"children,omitempty"`
}

// CreateManagementGroupRequest management group creation parameters.
type CreateManagementGroupRequest struct {
	// ID - READ-ONLY; The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.  For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - The name of the management group. For example, 00000000-0000-0000-0000-000000000000
	Name                             *string `json:"name,omitempty"`
	*CreateManagementGroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateManagementGroupRequest.
func (cmgr CreateManagementGroupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cmgr.Name != nil {
		objectMap["name"] = cmgr.Name
	}
	if cmgr.CreateManagementGroupProperties != nil {
		objectMap["properties"] = cmgr.CreateManagementGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateManagementGroupRequest struct.
func (cmgr *CreateManagementGroupRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cmgr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cmgr.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cmgr.Name = &name
			}
		case "properties":
			if v != nil {
				var createManagementGroupProperties CreateManagementGroupProperties
				err = json.Unmarshal(*v, &createManagementGroupProperties)
				if err != nil {
					return err
				}
				cmgr.CreateManagementGroupProperties = &createManagementGroupProperties
			}
		}
	}

	return nil
}

// CreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CreateOrUpdateFuture) Result(client Client) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managementgroups.CreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managementgroups.CreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.CreateOrUpdateResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managementgroups.CreateOrUpdateFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CreateParentGroupInfo (Optional) The ID of the parent management group used during creation.
type CreateParentGroupInfo struct {
	// ID - The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the parent management group
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The friendly name of the parent management group.
	DisplayName *string `json:"displayName,omitempty"`
}

// DeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeleteFuture) Result(client Client) (or OperationResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managementgroups.DeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managementgroups.DeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if or.Response.Response, err = future.GetResult(sender); err == nil && or.Response.Response.StatusCode != http.StatusNoContent {
		or, err = client.DeleteResponder(or.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managementgroups.DeleteFuture", "Result", or.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DescendantInfo the descendant.
type DescendantInfo struct {
	// ID - READ-ONLY; The fully qualified ID for the descendant.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000 or /subscriptions/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource. For example, /providers/Microsoft.Management/managementGroups or /subscriptions
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; The name of the descendant. For example, 00000000-0000-0000-0000-000000000000
	Name                      *string `json:"name,omitempty"`
	*DescendantInfoProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DescendantInfo.
func (di DescendantInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if di.DescendantInfoProperties != nil {
		objectMap["properties"] = di.DescendantInfoProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DescendantInfo struct.
func (di *DescendantInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				di.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				di.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				di.Name = &name
			}
		case "properties":
			if v != nil {
				var descendantInfoProperties DescendantInfoProperties
				err = json.Unmarshal(*v, &descendantInfoProperties)
				if err != nil {
					return err
				}
				di.DescendantInfoProperties = &descendantInfoProperties
			}
		}
	}

	return nil
}

// DescendantInfoProperties the generic properties of an descendant.
type DescendantInfoProperties struct {
	// DisplayName - The friendly name of the management group.
	DisplayName *string                    `json:"displayName,omitempty"`
	Parent      *DescendantParentGroupInfo `json:"parent,omitempty"`
}

// DescendantListResult describes the result of the request to view descendants.
type DescendantListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of descendants.
	Value *[]DescendantInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DescendantListResultIterator provides access to a complete listing of DescendantInfo values.
type DescendantListResultIterator struct {
	i    int
	page DescendantListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DescendantListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DescendantListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DescendantListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DescendantListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DescendantListResultIterator) Response() DescendantListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DescendantListResultIterator) Value() DescendantInfo {
	if !iter.page.NotDone() {
		return DescendantInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DescendantListResultIterator type.
func NewDescendantListResultIterator(page DescendantListResultPage) DescendantListResultIterator {
	return DescendantListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DescendantListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// descendantListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DescendantListResult) descendantListResultPreparer(ctx context.Context) (*http.Request, error) {
	if dlr.NextLink == nil || len(to.String(dlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DescendantListResultPage contains a page of DescendantInfo values.
type DescendantListResultPage struct {
	fn  func(context.Context, DescendantListResult) (DescendantListResult, error)
	dlr DescendantListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DescendantListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DescendantListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dlr)
	if err != nil {
		return err
	}
	page.dlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DescendantListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DescendantListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DescendantListResultPage) Response() DescendantListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DescendantListResultPage) Values() []DescendantInfo {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DescendantListResultPage type.
func NewDescendantListResultPage(getNextPage func(context.Context, DescendantListResult) (DescendantListResult, error)) DescendantListResultPage {
	return DescendantListResultPage{fn: getNextPage}
}

// DescendantParentGroupInfo the ID of the parent management group.
type DescendantParentGroupInfo struct {
	// ID - The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
}

// Details the details of a management group.
type Details struct {
	// Version - The version number of the object.
	Version *float64 `json:"version,omitempty"`
	// UpdatedTime - The date and time when this object was last updated.
	UpdatedTime *date.Time `json:"updatedTime,omitempty"`
	// UpdatedBy - The identity of the principal or process that updated the object.
	UpdatedBy *string          `json:"updatedBy,omitempty"`
	Parent    *ParentGroupInfo `json:"parent,omitempty"`
}

// EntityHierarchyItem the management group details for the hierarchy view.
type EntityHierarchyItem struct {
	// ID - READ-ONLY; The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.  For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; The name of the management group. For example, 00000000-0000-0000-0000-000000000000
	Name                           *string `json:"name,omitempty"`
	*EntityHierarchyItemProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityHierarchyItem.
func (ehi EntityHierarchyItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehi.EntityHierarchyItemProperties != nil {
		objectMap["properties"] = ehi.EntityHierarchyItemProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EntityHierarchyItem struct.
func (ehi *EntityHierarchyItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ehi.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ehi.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ehi.Name = &name
			}
		case "properties":
			if v != nil {
				var entityHierarchyItemProperties EntityHierarchyItemProperties
				err = json.Unmarshal(*v, &entityHierarchyItemProperties)
				if err != nil {
					return err
				}
				ehi.EntityHierarchyItemProperties = &entityHierarchyItemProperties
			}
		}
	}

	return nil
}

// EntityHierarchyItemProperties the generic properties of a management group.
type EntityHierarchyItemProperties struct {
	// DisplayName - The friendly name of the management group.
	DisplayName *string `json:"displayName,omitempty"`
	// Permissions - Possible values include: 'Permissions1Noaccess', 'Permissions1View', 'Permissions1Edit', 'Permissions1Delete'
	Permissions Permissions1 `json:"permissions,omitempty"`
	// Children - The list of children.
	Children *[]EntityHierarchyItem `json:"children,omitempty"`
}

// EntityInfo the entity.
type EntityInfo struct {
	// ID - READ-ONLY; The fully qualified ID for the entity.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource. For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; The name of the entity. For example, 00000000-0000-0000-0000-000000000000
	Name                  *string `json:"name,omitempty"`
	*EntityInfoProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityInfo.
func (ei EntityInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ei.EntityInfoProperties != nil {
		objectMap["properties"] = ei.EntityInfoProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EntityInfo struct.
func (ei *EntityInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ei.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ei.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ei.Name = &name
			}
		case "properties":
			if v != nil {
				var entityInfoProperties EntityInfoProperties
				err = json.Unmarshal(*v, &entityInfoProperties)
				if err != nil {
					return err
				}
				ei.EntityInfoProperties = &entityInfoProperties
			}
		}
	}

	return nil
}

// EntityInfoProperties the generic properties of an entity.
type EntityInfoProperties struct {
	// TenantID - The AAD Tenant ID associated with the entity. For example, 00000000-0000-0000-0000-000000000000
	TenantID *string `json:"tenantId,omitempty"`
	// DisplayName - The friendly name of the management group.
	DisplayName *string                `json:"displayName,omitempty"`
	Parent      *EntityParentGroupInfo `json:"parent,omitempty"`
	// Permissions - Possible values include: 'PermissionsNoaccess', 'PermissionsView', 'PermissionsEdit', 'PermissionsDelete'
	Permissions Permissions `json:"permissions,omitempty"`
	// InheritedPermissions - Possible values include: 'Noaccess', 'View', 'Edit', 'Delete'
	InheritedPermissions InheritedPermissions `json:"inheritedPermissions,omitempty"`
	NumberOfDescendants  *int32               `json:"numberOfDescendants,omitempty"`
	// NumberOfChildren - Number of children is the number of Groups and Subscriptions that are exactly one level underneath the current Group.
	NumberOfChildren *int32 `json:"numberOfChildren,omitempty"`
	// NumberOfChildGroups - Number of child groups is the number of Groups that are exactly one level underneath the current Group.
	NumberOfChildGroups *int32 `json:"numberOfChildGroups,omitempty"`
	// ParentDisplayNameChain - The parent display name chain from the root group to the immediate parent
	ParentDisplayNameChain *[]string `json:"parentDisplayNameChain,omitempty"`
	// ParentNameChain - The parent name chain from the root group to the immediate parent
	ParentNameChain *[]string `json:"parentNameChain,omitempty"`
}

// EntityListResult describes the result of the request to view entities.
type EntityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of entities.
	Value *[]EntityInfo `json:"value,omitempty"`
	// Count - READ-ONLY; Total count of records that match the filter
	Count *int32 `json:"count,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EntityListResultIterator provides access to a complete listing of EntityInfo values.
type EntityListResultIterator struct {
	i    int
	page EntityListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EntityListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EntityListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EntityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EntityListResultIterator) Response() EntityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EntityListResultIterator) Value() EntityInfo {
	if !iter.page.NotDone() {
		return EntityInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EntityListResultIterator type.
func NewEntityListResultIterator(page EntityListResultPage) EntityListResultIterator {
	return EntityListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EntityListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// entityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EntityListResult) entityListResultPreparer(ctx context.Context) (*http.Request, error) {
	if elr.NextLink == nil || len(to.String(elr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EntityListResultPage contains a page of EntityInfo values.
type EntityListResultPage struct {
	fn  func(context.Context, EntityListResult) (EntityListResult, error)
	elr EntityListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EntityListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.elr)
	if err != nil {
		return err
	}
	page.elr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EntityListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EntityListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EntityListResultPage) Response() EntityListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EntityListResultPage) Values() []EntityInfo {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// Creates a new instance of the EntityListResultPage type.
func NewEntityListResultPage(getNextPage func(context.Context, EntityListResult) (EntityListResult, error)) EntityListResultPage {
	return EntityListResultPage{fn: getNextPage}
}

// EntityParentGroupInfo (Optional) The ID of the parent management group.
type EntityParentGroupInfo struct {
	// ID - The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - One of a server-defined set of error codes.
	Code *string `json:"code,omitempty"`
	// Message - A human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Details - A human-readable representation of the error's details.
	Details *string `json:"details,omitempty"`
}

// ErrorResponse the error object.
type ErrorResponse struct {
	Error *ErrorDetails `json:"error,omitempty"`
}

// Info the management group resource.
type Info struct {
	// ID - READ-ONLY; The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource. For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; The name of the management group. For example, 00000000-0000-0000-0000-000000000000
	Name            *string `json:"name,omitempty"`
	*InfoProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Info.
func (i Info) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InfoProperties != nil {
		objectMap["properties"] = i.InfoProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Info struct.
func (i *Info) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "properties":
			if v != nil {
				var infoProperties InfoProperties
				err = json.Unmarshal(*v, &infoProperties)
				if err != nil {
					return err
				}
				i.InfoProperties = &infoProperties
			}
		}
	}

	return nil
}

// InfoProperties the generic properties of a management group.
type InfoProperties struct {
	// TenantID - The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
	TenantID *string `json:"tenantId,omitempty"`
	// DisplayName - The friendly name of the management group.
	DisplayName *string `json:"displayName,omitempty"`
}

// ListResult describes the result of the request to list management groups.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of management groups.
	Value *[]Info `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of Info values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() Info {
	if !iter.page.NotDone() {
		return Info{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of Info values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []Info {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{fn: getNextPage}
}

// ManagementGroup the management group details.
type ManagementGroup struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.  For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; The name of the management group. For example, 00000000-0000-0000-0000-000000000000
	Name        *string `json:"name,omitempty"`
	*Properties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementGroup.
func (mg ManagementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mg.Properties != nil {
		objectMap["properties"] = mg.Properties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagementGroup struct.
func (mg *ManagementGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mg.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mg.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mg.Name = &name
			}
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				mg.Properties = &properties
			}
		}
	}

	return nil
}

// Operation operation supported by the Microsoft.Management resource provider.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name    *string                     `json:"name,omitempty"`
	Display *OperationDisplayProperties `json:"display,omitempty"`
}

// OperationDisplayProperties the object that represents the operation.
type OperationDisplayProperties struct {
	// Provider - READ-ONLY; The name of the provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The operation that can be performed.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Operation description.
	Description *string `json:"description,omitempty"`
}

// OperationListResult describes the result of the request to list Microsoft.Management operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the Microsoft.Management resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationResults the results of an asynchronous operation.
type OperationResults struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.  For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; The name of the management group. For example, 00000000-0000-0000-0000-000000000000
	Name                        *string `json:"name,omitempty"`
	*OperationResultsProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationResults.
func (or OperationResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.OperationResultsProperties != nil {
		objectMap["properties"] = or.OperationResultsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationResults struct.
func (or *OperationResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				or.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				or.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				or.Name = &name
			}
		case "properties":
			if v != nil {
				var operationResultsProperties OperationResultsProperties
				err = json.Unmarshal(*v, &operationResultsProperties)
				if err != nil {
					return err
				}
				or.OperationResultsProperties = &operationResultsProperties
			}
		}
	}

	return nil
}

// OperationResultsProperties ...
type OperationResultsProperties struct {
	// ProvisioningState - Possible values include: 'Updating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ParentGroupInfo (Optional) The ID of the parent management group.
type ParentGroupInfo struct {
	// ID - The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Name - The name of the parent management group
	Name *string `json:"name,omitempty"`
	// DisplayName - The friendly name of the parent management group.
	DisplayName *string `json:"displayName,omitempty"`
}

// PatchManagementGroupRequest management group patch parameters.
type PatchManagementGroupRequest struct {
	// DisplayName - The friendly name of the management group.
	DisplayName *string `json:"displayName,omitempty"`
	// ParentID - (Optional) The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ParentID *string `json:"parentId,omitempty"`
}

// Properties the generic properties of a management group.
type Properties struct {
	// TenantID - The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
	TenantID *string `json:"tenantId,omitempty"`
	// DisplayName - The friendly name of the management group.
	DisplayName *string `json:"displayName,omitempty"`
	// Roles - The role definitions associated with the management group.
	Roles   *[]string `json:"roles,omitempty"`
	Details *Details  `json:"details,omitempty"`
	// Children - The list of children.
	Children *[]ChildInfo `json:"children,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// TenantBackfillStatusResult the tenant backfill status
type TenantBackfillStatusResult struct {
	autorest.Response `json:"-"`
	// TenantID - READ-ONLY; The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
	TenantID *string `json:"tenantId,omitempty"`
	// Status - READ-ONLY; The status of the Tenant Backfill. Possible values include: 'NotStarted', 'NotStartedButGroupsExist', 'Started', 'Failed', 'Cancelled', 'Completed'
	Status Status `json:"status,omitempty"`
}
