// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// OpenStack open stack
// swagger:model OpenStack
type OpenStack struct {

	// Unique identifier for the OpenStack instance
	// Required: true
	ID *string `json:"id"`

	// Internal IP address of the OpenStack instance
	// Required: true
	IPAddress *string `json:"ipAddress"`

	// Shortname of the OpenStack instance
	// Required: true
	Name *string `json:"name"`

	// Next available VLAN ID to be used for a network creation
	// Required: true
	NextVLANID *float64 `json:"nextVLANID"`

	// The region where the open stack lives
	// Required: true
	Region *string `json:"region"`
}

// Validate validates this open stack
func (m *OpenStack) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNextVLANID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *OpenStack) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *OpenStack) validateIPAddress(formats strfmt.Registry) error {

	if err := validate.Required("ipAddress", "body", m.IPAddress); err != nil {
		return err
	}

	return nil
}

func (m *OpenStack) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *OpenStack) validateNextVLANID(formats strfmt.Registry) error {

	if err := validate.Required("nextVLANID", "body", m.NextVLANID); err != nil {
		return err
	}

	return nil
}

func (m *OpenStack) validateRegion(formats strfmt.Registry) error {

	if err := validate.Required("region", "body", m.Region); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *OpenStack) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *OpenStack) UnmarshalBinary(b []byte) error {
	var res OpenStack
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
