// Code generated by go-swagger; DO NOT EDIT.

package service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/IBM-Cloud/power-go-client/power/models"
)

// NewServiceInstanceProvisionParams creates a new ServiceInstanceProvisionParams object
// with the default values initialized.
func NewServiceInstanceProvisionParams() *ServiceInstanceProvisionParams {
	var ()
	return &ServiceInstanceProvisionParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewServiceInstanceProvisionParamsWithTimeout creates a new ServiceInstanceProvisionParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewServiceInstanceProvisionParamsWithTimeout(timeout time.Duration) *ServiceInstanceProvisionParams {
	var ()
	return &ServiceInstanceProvisionParams{

		timeout: timeout,
	}
}

// NewServiceInstanceProvisionParamsWithContext creates a new ServiceInstanceProvisionParams object
// with the default values initialized, and the ability to set a context for a request
func NewServiceInstanceProvisionParamsWithContext(ctx context.Context) *ServiceInstanceProvisionParams {
	var ()
	return &ServiceInstanceProvisionParams{

		Context: ctx,
	}
}

// NewServiceInstanceProvisionParamsWithHTTPClient creates a new ServiceInstanceProvisionParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewServiceInstanceProvisionParamsWithHTTPClient(client *http.Client) *ServiceInstanceProvisionParams {
	var ()
	return &ServiceInstanceProvisionParams{
		HTTPClient: client,
	}
}

/*ServiceInstanceProvisionParams contains all the parameters to send to the API endpoint
for the service instance provision operation typically these are written to a http.Request
*/
type ServiceInstanceProvisionParams struct {

	/*XBrokerAPIOriginatingIdentity
	  identity of the user that initiated the request from the Platform

	*/
	XBrokerAPIOriginatingIdentity *string
	/*XBrokerAPIVersion
	  version number of the Service Broker API that the Platform will use

	*/
	XBrokerAPIVersion string
	/*AcceptsIncomplete
	  asynchronous operations supported

	*/
	AcceptsIncomplete *bool
	/*Body
	  parameters for the requested service instance provision

	*/
	Body *models.ServiceInstanceProvisionRequest
	/*InstanceID
	  instance id of instance to provision

	*/
	InstanceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the service instance provision params
func (o *ServiceInstanceProvisionParams) WithTimeout(timeout time.Duration) *ServiceInstanceProvisionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the service instance provision params
func (o *ServiceInstanceProvisionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the service instance provision params
func (o *ServiceInstanceProvisionParams) WithContext(ctx context.Context) *ServiceInstanceProvisionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the service instance provision params
func (o *ServiceInstanceProvisionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the service instance provision params
func (o *ServiceInstanceProvisionParams) WithHTTPClient(client *http.Client) *ServiceInstanceProvisionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the service instance provision params
func (o *ServiceInstanceProvisionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithXBrokerAPIOriginatingIdentity adds the xBrokerAPIOriginatingIdentity to the service instance provision params
func (o *ServiceInstanceProvisionParams) WithXBrokerAPIOriginatingIdentity(xBrokerAPIOriginatingIdentity *string) *ServiceInstanceProvisionParams {
	o.SetXBrokerAPIOriginatingIdentity(xBrokerAPIOriginatingIdentity)
	return o
}

// SetXBrokerAPIOriginatingIdentity adds the xBrokerApiOriginatingIdentity to the service instance provision params
func (o *ServiceInstanceProvisionParams) SetXBrokerAPIOriginatingIdentity(xBrokerAPIOriginatingIdentity *string) {
	o.XBrokerAPIOriginatingIdentity = xBrokerAPIOriginatingIdentity
}

// WithXBrokerAPIVersion adds the xBrokerAPIVersion to the service instance provision params
func (o *ServiceInstanceProvisionParams) WithXBrokerAPIVersion(xBrokerAPIVersion string) *ServiceInstanceProvisionParams {
	o.SetXBrokerAPIVersion(xBrokerAPIVersion)
	return o
}

// SetXBrokerAPIVersion adds the xBrokerApiVersion to the service instance provision params
func (o *ServiceInstanceProvisionParams) SetXBrokerAPIVersion(xBrokerAPIVersion string) {
	o.XBrokerAPIVersion = xBrokerAPIVersion
}

// WithAcceptsIncomplete adds the acceptsIncomplete to the service instance provision params
func (o *ServiceInstanceProvisionParams) WithAcceptsIncomplete(acceptsIncomplete *bool) *ServiceInstanceProvisionParams {
	o.SetAcceptsIncomplete(acceptsIncomplete)
	return o
}

// SetAcceptsIncomplete adds the acceptsIncomplete to the service instance provision params
func (o *ServiceInstanceProvisionParams) SetAcceptsIncomplete(acceptsIncomplete *bool) {
	o.AcceptsIncomplete = acceptsIncomplete
}

// WithBody adds the body to the service instance provision params
func (o *ServiceInstanceProvisionParams) WithBody(body *models.ServiceInstanceProvisionRequest) *ServiceInstanceProvisionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the service instance provision params
func (o *ServiceInstanceProvisionParams) SetBody(body *models.ServiceInstanceProvisionRequest) {
	o.Body = body
}

// WithInstanceID adds the instanceID to the service instance provision params
func (o *ServiceInstanceProvisionParams) WithInstanceID(instanceID string) *ServiceInstanceProvisionParams {
	o.SetInstanceID(instanceID)
	return o
}

// SetInstanceID adds the instanceId to the service instance provision params
func (o *ServiceInstanceProvisionParams) SetInstanceID(instanceID string) {
	o.InstanceID = instanceID
}

// WriteToRequest writes these params to a swagger request
func (o *ServiceInstanceProvisionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.XBrokerAPIOriginatingIdentity != nil {

		// header param X-Broker-API-Originating-Identity
		if err := r.SetHeaderParam("X-Broker-API-Originating-Identity", *o.XBrokerAPIOriginatingIdentity); err != nil {
			return err
		}

	}

	// header param X-Broker-API-Version
	if err := r.SetHeaderParam("X-Broker-API-Version", o.XBrokerAPIVersion); err != nil {
		return err
	}

	if o.AcceptsIncomplete != nil {

		// query param accepts_incomplete
		var qrAcceptsIncomplete bool
		if o.AcceptsIncomplete != nil {
			qrAcceptsIncomplete = *o.AcceptsIncomplete
		}
		qAcceptsIncomplete := swag.FormatBool(qrAcceptsIncomplete)
		if qAcceptsIncomplete != "" {
			if err := r.SetQueryParam("accepts_incomplete", qAcceptsIncomplete); err != nil {
				return err
			}
		}

	}

	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param instance_id
	if err := r.SetPathParam("instance_id", o.InstanceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
