// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/alert.proto

package monitoring

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Operators for combining conditions.
type AlertPolicy_ConditionCombinerType int32

const (
	// An unspecified combiner.
	AlertPolicy_COMBINE_UNSPECIFIED AlertPolicy_ConditionCombinerType = 0
	// Combine conditions using the logical `AND` operator. An
	// incident is created only if all the conditions are met
	// simultaneously. This combiner is satisfied if all conditions are
	// met, even if they are met on completely different resources.
	AlertPolicy_AND AlertPolicy_ConditionCombinerType = 1
	// Combine conditions using the logical `OR` operator. An incident
	// is created if any of the listed conditions is met.
	AlertPolicy_OR AlertPolicy_ConditionCombinerType = 2
	// Combine conditions using logical `AND` operator, but unlike the regular
	// `AND` option, an incident is created only if all conditions are met
	// simultaneously on at least one resource.
	AlertPolicy_AND_WITH_MATCHING_RESOURCE AlertPolicy_ConditionCombinerType = 3
)

var AlertPolicy_ConditionCombinerType_name = map[int32]string{
	0: "COMBINE_UNSPECIFIED",
	1: "AND",
	2: "OR",
	3: "AND_WITH_MATCHING_RESOURCE",
}

var AlertPolicy_ConditionCombinerType_value = map[string]int32{
	"COMBINE_UNSPECIFIED":        0,
	"AND":                        1,
	"OR":                         2,
	"AND_WITH_MATCHING_RESOURCE": 3,
}

func (x AlertPolicy_ConditionCombinerType) String() string {
	return proto.EnumName(AlertPolicy_ConditionCombinerType_name, int32(x))
}

func (AlertPolicy_ConditionCombinerType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_014ef0e1a0f00a00, []int{0, 0}
}

// A description of the conditions under which some aspect of your system is
// considered to be "unhealthy" and the ways to notify people or services about
// this state. For an overview of alert policies, see
// [Introduction to Alerting](https://cloud.google.com/monitoring/alerts/).
type AlertPolicy struct {
	// Required if the policy exists. The resource name for this policy. The
	// format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
	//
	// `[ALERT_POLICY_ID]` is assigned by Stackdriver Monitoring when the policy
	// is created.  When calling the
	// [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
	// method, do not include the `name` field in the alerting policy passed as
	// part of the request.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A short name or phrase used to identify the policy in dashboards,
	// notifications, and incidents. To avoid confusion, don't use the same
	// display name for multiple policies in the same project. The name is
	// limited to 512 Unicode characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Documentation that is included with notifications and incidents related to
	// this policy. Best practice is for the documentation to include information
	// to help responders understand, mitigate, escalate, and correct the
	// underlying problems detected by the alerting policy. Notification channels
	// that have limited capacity might not show this documentation.
	Documentation *AlertPolicy_Documentation `protobuf:"bytes,13,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// User-supplied key/value data to be used for organizing and
	// identifying the `AlertPolicy` objects.
	//
	// The field can contain up to 64 entries. Each key and value is limited to
	// 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
	// values can contain only lowercase letters, numerals, underscores, and
	// dashes. Keys must begin with a letter.
	UserLabels map[string]string `protobuf:"bytes,16,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A list of conditions for the policy. The conditions are combined by AND or
	// OR according to the `combiner` field. If the combined conditions evaluate
	// to true, then an incident is created. A policy can have from one to six
	// conditions.
	// If `condition_time_series_query_language` is present, it must be the only
	// `condition`.
	Conditions []*AlertPolicy_Condition `protobuf:"bytes,12,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// How to combine the results of multiple conditions to determine if an
	// incident should be opened.
	// If `condition_time_series_query_language` is present, this must be
	// `COMBINE_UNSPECIFIED`.
	Combiner AlertPolicy_ConditionCombinerType `protobuf:"varint,6,opt,name=combiner,proto3,enum=google.monitoring.v3.AlertPolicy_ConditionCombinerType" json:"combiner,omitempty"`
	// Whether or not the policy is enabled. On write, the default interpretation
	// if unset is that the policy is enabled. On read, clients should not make
	// any assumption about the state if it has not been populated. The
	// field should always be populated on List and Get operations, unless
	// a field projection has been specified that strips it out.
	Enabled *wrappers.BoolValue `protobuf:"bytes,17,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Read-only description of how the alert policy is invalid. OK if the alert
	// policy is valid. If not OK, the alert policy will not generate incidents.
	Validity *status.Status `protobuf:"bytes,18,opt,name=validity,proto3" json:"validity,omitempty"`
	// Identifies the notification channels to which notifications should be sent
	// when incidents are opened or closed or when new violations occur on
	// an already opened incident. Each element of this array corresponds to
	// the `name` field in each of the
	// [`NotificationChannel`][google.monitoring.v3.NotificationChannel]
	// objects that are returned from the [`ListNotificationChannels`]
	// [google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
	// method. The format of the entries in this field is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
	NotificationChannels []string `protobuf:"bytes,14,rep,name=notification_channels,json=notificationChannels,proto3" json:"notification_channels,omitempty"`
	// A read-only record of the creation of the alerting policy. If provided
	// in a call to create or update, this field will be ignored.
	CreationRecord *MutationRecord `protobuf:"bytes,10,opt,name=creation_record,json=creationRecord,proto3" json:"creation_record,omitempty"`
	// A read-only record of the most recent change to the alerting policy. If
	// provided in a call to create or update, this field will be ignored.
	MutationRecord       *MutationRecord `protobuf:"bytes,11,opt,name=mutation_record,json=mutationRecord,proto3" json:"mutation_record,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *AlertPolicy) Reset()         { *m = AlertPolicy{} }
func (m *AlertPolicy) String() string { return proto.CompactTextString(m) }
func (*AlertPolicy) ProtoMessage()    {}
func (*AlertPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_014ef0e1a0f00a00, []int{0}
}

func (m *AlertPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlertPolicy.Unmarshal(m, b)
}
func (m *AlertPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlertPolicy.Marshal(b, m, deterministic)
}
func (m *AlertPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertPolicy.Merge(m, src)
}
func (m *AlertPolicy) XXX_Size() int {
	return xxx_messageInfo_AlertPolicy.Size(m)
}
func (m *AlertPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_AlertPolicy proto.InternalMessageInfo

func (m *AlertPolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AlertPolicy) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *AlertPolicy) GetDocumentation() *AlertPolicy_Documentation {
	if m != nil {
		return m.Documentation
	}
	return nil
}

func (m *AlertPolicy) GetUserLabels() map[string]string {
	if m != nil {
		return m.UserLabels
	}
	return nil
}

func (m *AlertPolicy) GetConditions() []*AlertPolicy_Condition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *AlertPolicy) GetCombiner() AlertPolicy_ConditionCombinerType {
	if m != nil {
		return m.Combiner
	}
	return AlertPolicy_COMBINE_UNSPECIFIED
}

func (m *AlertPolicy) GetEnabled() *wrappers.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *AlertPolicy) GetValidity() *status.Status {
	if m != nil {
		return m.Validity
	}
	return nil
}

func (m *AlertPolicy) GetNotificationChannels() []string {
	if m != nil {
		return m.NotificationChannels
	}
	return nil
}

func (m *AlertPolicy) GetCreationRecord() *MutationRecord {
	if m != nil {
		return m.CreationRecord
	}
	return nil
}

func (m *AlertPolicy) GetMutationRecord() *MutationRecord {
	if m != nil {
		return m.MutationRecord
	}
	return nil
}

// A content string and a MIME type that describes the content string's
// format.
type AlertPolicy_Documentation struct {
	// The text of the documentation, interpreted according to `mime_type`.
	// The content may not exceed 8,192 Unicode characters and may not exceed
	// more than 10,240 bytes when encoded in UTF-8 format, whichever is
	// smaller.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The format of the `content` field. Presently, only the value
	// `"text/markdown"` is supported. See
	// [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
	MimeType             string   `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AlertPolicy_Documentation) Reset()         { *m = AlertPolicy_Documentation{} }
func (m *AlertPolicy_Documentation) String() string { return proto.CompactTextString(m) }
func (*AlertPolicy_Documentation) ProtoMessage()    {}
func (*AlertPolicy_Documentation) Descriptor() ([]byte, []int) {
	return fileDescriptor_014ef0e1a0f00a00, []int{0, 0}
}

func (m *AlertPolicy_Documentation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlertPolicy_Documentation.Unmarshal(m, b)
}
func (m *AlertPolicy_Documentation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlertPolicy_Documentation.Marshal(b, m, deterministic)
}
func (m *AlertPolicy_Documentation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertPolicy_Documentation.Merge(m, src)
}
func (m *AlertPolicy_Documentation) XXX_Size() int {
	return xxx_messageInfo_AlertPolicy_Documentation.Size(m)
}
func (m *AlertPolicy_Documentation) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertPolicy_Documentation.DiscardUnknown(m)
}

var xxx_messageInfo_AlertPolicy_Documentation proto.InternalMessageInfo

func (m *AlertPolicy_Documentation) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *AlertPolicy_Documentation) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// A condition is a true/false test that determines when an alerting policy
// should open an incident. If a condition evaluates to true, it signifies
// that something is wrong.
type AlertPolicy_Condition struct {
	// Required if the condition exists. The unique resource name for this
	// condition. Its format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
	//
	// `[CONDITION_ID]` is assigned by Stackdriver Monitoring when the
	// condition is created as part of a new or updated alerting policy.
	//
	// When calling the
	// [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
	// method, do not include the `name` field in the conditions of the
	// requested alerting policy. Stackdriver Monitoring creates the
	// condition identifiers and includes them in the new policy.
	//
	// When calling the
	// [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
	// method to update a policy, including a condition `name` causes the
	// existing condition to be updated. Conditions without names are added to
	// the updated policy. Existing conditions are deleted if they are not
	// updated.
	//
	// Best practice is to preserve `[CONDITION_ID]` if you make only small
	// changes, such as those to condition thresholds, durations, or trigger
	// values.  Otherwise, treat the change as a new condition and let the
	// existing condition be deleted.
	Name string `protobuf:"bytes,12,opt,name=name,proto3" json:"name,omitempty"`
	// A short name or phrase used to identify the condition in dashboards,
	// notifications, and incidents. To avoid confusion, don't use the same
	// display name for multiple conditions in the same policy.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Only one of the following condition types will be specified.
	//
	// Types that are valid to be assigned to Condition:
	//	*AlertPolicy_Condition_ConditionThreshold
	//	*AlertPolicy_Condition_ConditionAbsent
	Condition            isAlertPolicy_Condition_Condition `protobuf_oneof:"condition"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *AlertPolicy_Condition) Reset()         { *m = AlertPolicy_Condition{} }
func (m *AlertPolicy_Condition) String() string { return proto.CompactTextString(m) }
func (*AlertPolicy_Condition) ProtoMessage()    {}
func (*AlertPolicy_Condition) Descriptor() ([]byte, []int) {
	return fileDescriptor_014ef0e1a0f00a00, []int{0, 1}
}

func (m *AlertPolicy_Condition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlertPolicy_Condition.Unmarshal(m, b)
}
func (m *AlertPolicy_Condition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlertPolicy_Condition.Marshal(b, m, deterministic)
}
func (m *AlertPolicy_Condition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertPolicy_Condition.Merge(m, src)
}
func (m *AlertPolicy_Condition) XXX_Size() int {
	return xxx_messageInfo_AlertPolicy_Condition.Size(m)
}
func (m *AlertPolicy_Condition) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertPolicy_Condition.DiscardUnknown(m)
}

var xxx_messageInfo_AlertPolicy_Condition proto.InternalMessageInfo

func (m *AlertPolicy_Condition) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AlertPolicy_Condition) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

type isAlertPolicy_Condition_Condition interface {
	isAlertPolicy_Condition_Condition()
}

type AlertPolicy_Condition_ConditionThreshold struct {
	ConditionThreshold *AlertPolicy_Condition_MetricThreshold `protobuf:"bytes,1,opt,name=condition_threshold,json=conditionThreshold,proto3,oneof"`
}

type AlertPolicy_Condition_ConditionAbsent struct {
	ConditionAbsent *AlertPolicy_Condition_MetricAbsence `protobuf:"bytes,2,opt,name=condition_absent,json=conditionAbsent,proto3,oneof"`
}

func (*AlertPolicy_Condition_ConditionThreshold) isAlertPolicy_Condition_Condition() {}

func (*AlertPolicy_Condition_ConditionAbsent) isAlertPolicy_Condition_Condition() {}

func (m *AlertPolicy_Condition) GetCondition() isAlertPolicy_Condition_Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (m *AlertPolicy_Condition) GetConditionThreshold() *AlertPolicy_Condition_MetricThreshold {
	if x, ok := m.GetCondition().(*AlertPolicy_Condition_ConditionThreshold); ok {
		return x.ConditionThreshold
	}
	return nil
}

func (m *AlertPolicy_Condition) GetConditionAbsent() *AlertPolicy_Condition_MetricAbsence {
	if x, ok := m.GetCondition().(*AlertPolicy_Condition_ConditionAbsent); ok {
		return x.ConditionAbsent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AlertPolicy_Condition) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AlertPolicy_Condition_ConditionThreshold)(nil),
		(*AlertPolicy_Condition_ConditionAbsent)(nil),
	}
}

// Specifies how many time series must fail a predicate to trigger a
// condition. If not specified, then a `{count: 1}` trigger is used.
type AlertPolicy_Condition_Trigger struct {
	// A type of trigger.
	//
	// Types that are valid to be assigned to Type:
	//	*AlertPolicy_Condition_Trigger_Count
	//	*AlertPolicy_Condition_Trigger_Percent
	Type                 isAlertPolicy_Condition_Trigger_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *AlertPolicy_Condition_Trigger) Reset()         { *m = AlertPolicy_Condition_Trigger{} }
func (m *AlertPolicy_Condition_Trigger) String() string { return proto.CompactTextString(m) }
func (*AlertPolicy_Condition_Trigger) ProtoMessage()    {}
func (*AlertPolicy_Condition_Trigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_014ef0e1a0f00a00, []int{0, 1, 0}
}

func (m *AlertPolicy_Condition_Trigger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlertPolicy_Condition_Trigger.Unmarshal(m, b)
}
func (m *AlertPolicy_Condition_Trigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlertPolicy_Condition_Trigger.Marshal(b, m, deterministic)
}
func (m *AlertPolicy_Condition_Trigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertPolicy_Condition_Trigger.Merge(m, src)
}
func (m *AlertPolicy_Condition_Trigger) XXX_Size() int {
	return xxx_messageInfo_AlertPolicy_Condition_Trigger.Size(m)
}
func (m *AlertPolicy_Condition_Trigger) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertPolicy_Condition_Trigger.DiscardUnknown(m)
}

var xxx_messageInfo_AlertPolicy_Condition_Trigger proto.InternalMessageInfo

type isAlertPolicy_Condition_Trigger_Type interface {
	isAlertPolicy_Condition_Trigger_Type()
}

type AlertPolicy_Condition_Trigger_Count struct {
	Count int32 `protobuf:"varint,1,opt,name=count,proto3,oneof"`
}

type AlertPolicy_Condition_Trigger_Percent struct {
	Percent float64 `protobuf:"fixed64,2,opt,name=percent,proto3,oneof"`
}

func (*AlertPolicy_Condition_Trigger_Count) isAlertPolicy_Condition_Trigger_Type() {}

func (*AlertPolicy_Condition_Trigger_Percent) isAlertPolicy_Condition_Trigger_Type() {}

func (m *AlertPolicy_Condition_Trigger) GetType() isAlertPolicy_Condition_Trigger_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *AlertPolicy_Condition_Trigger) GetCount() int32 {
	if x, ok := m.GetType().(*AlertPolicy_Condition_Trigger_Count); ok {
		return x.Count
	}
	return 0
}

func (m *AlertPolicy_Condition_Trigger) GetPercent() float64 {
	if x, ok := m.GetType().(*AlertPolicy_Condition_Trigger_Percent); ok {
		return x.Percent
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AlertPolicy_Condition_Trigger) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AlertPolicy_Condition_Trigger_Count)(nil),
		(*AlertPolicy_Condition_Trigger_Percent)(nil),
	}
}

// A condition type that compares a collection of time series
// against a threshold.
type AlertPolicy_Condition_MetricThreshold struct {
	// A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
	// identifies which time series should be compared with the threshold.
	//
	// The filter is similar to the one that is specified in the
	// [`ListTimeSeries`
	// request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
	// (that call is useful to verify the time series that will be retrieved /
	// processed) and must specify the metric type and optionally may contain
	// restrictions on resource type, resource labels, and metric labels.
	// This field may not exceed 2048 Unicode characters in length.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specifies the alignment of data points in individual time series as
	// well as how to combine the retrieved time series together (such as
	// when aggregating multiple streams on each resource to a single
	// stream for each resource or when aggregating streams across all
	// members of a group of resrouces). Multiple aggregations
	// are applied in the order specified.
	//
	// This field is similar to the one in the [`ListTimeSeries`
	// request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
	// It is advisable to use the `ListTimeSeries` method when debugging this
	// field.
	Aggregations []*Aggregation `protobuf:"bytes,8,rep,name=aggregations,proto3" json:"aggregations,omitempty"`
	// A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
	// identifies a time series that should be used as the denominator of a
	// ratio that will be compared with the threshold. If a
	// `denominator_filter` is specified, the time series specified by the
	// `filter` field will be used as the numerator.
	//
	// The filter must specify the metric type and optionally may contain
	// restrictions on resource type, resource labels, and metric labels.
	// This field may not exceed 2048 Unicode characters in length.
	DenominatorFilter string `protobuf:"bytes,9,opt,name=denominator_filter,json=denominatorFilter,proto3" json:"denominator_filter,omitempty"`
	// Specifies the alignment of data points in individual time series
	// selected by `denominatorFilter` as
	// well as how to combine the retrieved time series together (such as
	// when aggregating multiple streams on each resource to a single
	// stream for each resource or when aggregating streams across all
	// members of a group of resources).
	//
	// When computing ratios, the `aggregations` and
	// `denominator_aggregations` fields must use the same alignment period
	// and produce time series that have the same periodicity and labels.
	DenominatorAggregations []*Aggregation `protobuf:"bytes,10,rep,name=denominator_aggregations,json=denominatorAggregations,proto3" json:"denominator_aggregations,omitempty"`
	// The comparison to apply between the time series (indicated by `filter`
	// and `aggregation`) and the threshold (indicated by `threshold_value`).
	// The comparison is applied on each time series, with the time series
	// on the left-hand side and the threshold on the right-hand side.
	//
	// Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
	Comparison ComparisonType `protobuf:"varint,4,opt,name=comparison,proto3,enum=google.monitoring.v3.ComparisonType" json:"comparison,omitempty"`
	// A value against which to compare the time series.
	ThresholdValue float64 `protobuf:"fixed64,5,opt,name=threshold_value,json=thresholdValue,proto3" json:"threshold_value,omitempty"`
	// The amount of time that a time series must violate the
	// threshold to be considered failing. Currently, only values
	// that are a multiple of a minute--e.g., 0, 60, 120, or 300
	// seconds--are supported. If an invalid value is given, an
	// error will be returned. When choosing a duration, it is useful to
	// keep in mind the frequency of the underlying time series data
	// (which may also be affected by any alignments specified in the
	// `aggregations` field); a good duration is long enough so that a single
	// outlier does not generate spurious alerts, but short enough that
	// unhealthy states are detected and alerted on quickly.
	Duration *duration.Duration `protobuf:"bytes,6,opt,name=duration,proto3" json:"duration,omitempty"`
	// The number/percent of time series for which the comparison must hold
	// in order for the condition to trigger. If unspecified, then the
	// condition will trigger if the comparison is true for any of the
	// time series that have been identified by `filter` and `aggregations`,
	// or by the ratio, if `denominator_filter` and `denominator_aggregations`
	// are specified.
	Trigger              *AlertPolicy_Condition_Trigger `protobuf:"bytes,7,opt,name=trigger,proto3" json:"trigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *AlertPolicy_Condition_MetricThreshold) Reset()         { *m = AlertPolicy_Condition_MetricThreshold{} }
func (m *AlertPolicy_Condition_MetricThreshold) String() string { return proto.CompactTextString(m) }
func (*AlertPolicy_Condition_MetricThreshold) ProtoMessage()    {}
func (*AlertPolicy_Condition_MetricThreshold) Descriptor() ([]byte, []int) {
	return fileDescriptor_014ef0e1a0f00a00, []int{0, 1, 1}
}

func (m *AlertPolicy_Condition_MetricThreshold) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlertPolicy_Condition_MetricThreshold.Unmarshal(m, b)
}
func (m *AlertPolicy_Condition_MetricThreshold) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlertPolicy_Condition_MetricThreshold.Marshal(b, m, deterministic)
}
func (m *AlertPolicy_Condition_MetricThreshold) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertPolicy_Condition_MetricThreshold.Merge(m, src)
}
func (m *AlertPolicy_Condition_MetricThreshold) XXX_Size() int {
	return xxx_messageInfo_AlertPolicy_Condition_MetricThreshold.Size(m)
}
func (m *AlertPolicy_Condition_MetricThreshold) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertPolicy_Condition_MetricThreshold.DiscardUnknown(m)
}

var xxx_messageInfo_AlertPolicy_Condition_MetricThreshold proto.InternalMessageInfo

func (m *AlertPolicy_Condition_MetricThreshold) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *AlertPolicy_Condition_MetricThreshold) GetAggregations() []*Aggregation {
	if m != nil {
		return m.Aggregations
	}
	return nil
}

func (m *AlertPolicy_Condition_MetricThreshold) GetDenominatorFilter() string {
	if m != nil {
		return m.DenominatorFilter
	}
	return ""
}

func (m *AlertPolicy_Condition_MetricThreshold) GetDenominatorAggregations() []*Aggregation {
	if m != nil {
		return m.DenominatorAggregations
	}
	return nil
}

func (m *AlertPolicy_Condition_MetricThreshold) GetComparison() ComparisonType {
	if m != nil {
		return m.Comparison
	}
	return ComparisonType_COMPARISON_UNSPECIFIED
}

func (m *AlertPolicy_Condition_MetricThreshold) GetThresholdValue() float64 {
	if m != nil {
		return m.ThresholdValue
	}
	return 0
}

func (m *AlertPolicy_Condition_MetricThreshold) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *AlertPolicy_Condition_MetricThreshold) GetTrigger() *AlertPolicy_Condition_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

// A condition type that checks that monitored resources
// are reporting data. The configuration defines a metric and
// a set of monitored resources. The predicate is considered in violation
// when a time series for the specified metric of a monitored
// resource does not include any data in the specified `duration`.
type AlertPolicy_Condition_MetricAbsence struct {
	// A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
	// identifies which time series should be compared with the threshold.
	//
	// The filter is similar to the one that is specified in the
	// [`ListTimeSeries`
	// request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
	// (that call is useful to verify the time series that will be retrieved /
	// processed) and must specify the metric type and optionally may contain
	// restrictions on resource type, resource labels, and metric labels.
	// This field may not exceed 2048 Unicode characters in length.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specifies the alignment of data points in individual time series as
	// well as how to combine the retrieved time series together (such as
	// when aggregating multiple streams on each resource to a single
	// stream for each resource or when aggregating streams across all
	// members of a group of resrouces). Multiple aggregations
	// are applied in the order specified.
	//
	// This field is similar to the one in the [`ListTimeSeries`
	// request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
	// It is advisable to use the `ListTimeSeries` method when debugging this
	// field.
	Aggregations []*Aggregation `protobuf:"bytes,5,rep,name=aggregations,proto3" json:"aggregations,omitempty"`
	// The amount of time that a time series must fail to report new
	// data to be considered failing. Currently, only values that
	// are a multiple of a minute--e.g.  60, 120, or 300
	// seconds--are supported. If an invalid value is given, an
	// error will be returned. The `Duration.nanos` field is
	// ignored.
	Duration *duration.Duration `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
	// The number/percent of time series for which the comparison must hold
	// in order for the condition to trigger. If unspecified, then the
	// condition will trigger if the comparison is true for any of the
	// time series that have been identified by `filter` and `aggregations`.
	Trigger              *AlertPolicy_Condition_Trigger `protobuf:"bytes,3,opt,name=trigger,proto3" json:"trigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *AlertPolicy_Condition_MetricAbsence) Reset()         { *m = AlertPolicy_Condition_MetricAbsence{} }
func (m *AlertPolicy_Condition_MetricAbsence) String() string { return proto.CompactTextString(m) }
func (*AlertPolicy_Condition_MetricAbsence) ProtoMessage()    {}
func (*AlertPolicy_Condition_MetricAbsence) Descriptor() ([]byte, []int) {
	return fileDescriptor_014ef0e1a0f00a00, []int{0, 1, 2}
}

func (m *AlertPolicy_Condition_MetricAbsence) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AlertPolicy_Condition_MetricAbsence.Unmarshal(m, b)
}
func (m *AlertPolicy_Condition_MetricAbsence) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AlertPolicy_Condition_MetricAbsence.Marshal(b, m, deterministic)
}
func (m *AlertPolicy_Condition_MetricAbsence) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertPolicy_Condition_MetricAbsence.Merge(m, src)
}
func (m *AlertPolicy_Condition_MetricAbsence) XXX_Size() int {
	return xxx_messageInfo_AlertPolicy_Condition_MetricAbsence.Size(m)
}
func (m *AlertPolicy_Condition_MetricAbsence) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertPolicy_Condition_MetricAbsence.DiscardUnknown(m)
}

var xxx_messageInfo_AlertPolicy_Condition_MetricAbsence proto.InternalMessageInfo

func (m *AlertPolicy_Condition_MetricAbsence) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *AlertPolicy_Condition_MetricAbsence) GetAggregations() []*Aggregation {
	if m != nil {
		return m.Aggregations
	}
	return nil
}

func (m *AlertPolicy_Condition_MetricAbsence) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *AlertPolicy_Condition_MetricAbsence) GetTrigger() *AlertPolicy_Condition_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.monitoring.v3.AlertPolicy_ConditionCombinerType", AlertPolicy_ConditionCombinerType_name, AlertPolicy_ConditionCombinerType_value)
	proto.RegisterType((*AlertPolicy)(nil), "google.monitoring.v3.AlertPolicy")
	proto.RegisterMapType((map[string]string)(nil), "google.monitoring.v3.AlertPolicy.UserLabelsEntry")
	proto.RegisterType((*AlertPolicy_Documentation)(nil), "google.monitoring.v3.AlertPolicy.Documentation")
	proto.RegisterType((*AlertPolicy_Condition)(nil), "google.monitoring.v3.AlertPolicy.Condition")
	proto.RegisterType((*AlertPolicy_Condition_Trigger)(nil), "google.monitoring.v3.AlertPolicy.Condition.Trigger")
	proto.RegisterType((*AlertPolicy_Condition_MetricThreshold)(nil), "google.monitoring.v3.AlertPolicy.Condition.MetricThreshold")
	proto.RegisterType((*AlertPolicy_Condition_MetricAbsence)(nil), "google.monitoring.v3.AlertPolicy.Condition.MetricAbsence")
}

func init() {
	proto.RegisterFile("google/monitoring/v3/alert.proto", fileDescriptor_014ef0e1a0f00a00)
}

var fileDescriptor_014ef0e1a0f00a00 = []byte{
	// 1109 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0xae, 0x93, 0x6d, 0xd2, 0x9c, 0xf4, 0x27, 0x3b, 0xdb, 0xdd, 0x7a, 0x8d, 0x58, 0xa5, 0x2b,
	0x10, 0xd5, 0xa2, 0xb5, 0x45, 0x03, 0x82, 0xcd, 0x0a, 0xa4, 0x34, 0x49, 0x37, 0x15, 0x24, 0xad,
	0xdc, 0x1f, 0x24, 0x54, 0xc9, 0x72, 0x9c, 0xa9, 0x6b, 0xb0, 0x67, 0xac, 0xb1, 0x5d, 0x14, 0xaa,
	0x3e, 0x05, 0x17, 0xbc, 0x03, 0x8f, 0x81, 0xc4, 0x05, 0x3c, 0x4a, 0x2f, 0xd1, 0x4a, 0xdc, 0x22,
	0x8f, 0xc7, 0x8e, 0xd3, 0x4d, 0x77, 0x37, 0xe5, 0x6e, 0xce, 0x9c, 0xef, 0x7c, 0x67, 0xce, 0x9c,
	0x6f, 0x8e, 0x0d, 0x75, 0x9b, 0x52, 0xdb, 0xc5, 0x9a, 0x47, 0x89, 0x13, 0x52, 0xe6, 0x10, 0x5b,
	0xbb, 0x68, 0x68, 0xa6, 0x8b, 0x59, 0xa8, 0xfa, 0x8c, 0x86, 0x14, 0xad, 0x27, 0x08, 0x75, 0x82,
	0x50, 0x2f, 0x1a, 0xca, 0x63, 0x11, 0x67, 0xfa, 0x8e, 0xc6, 0x70, 0x40, 0x23, 0x66, 0xe1, 0x24,
	0x40, 0xd9, 0x9c, 0x49, 0x69, 0x51, 0xcf, 0xa3, 0x44, 0x40, 0x9e, 0xcd, 0x84, 0x78, 0x51, 0x68,
	0x86, 0x0e, 0x25, 0x06, 0xc3, 0x16, 0x65, 0x23, 0x81, 0x7d, 0x22, 0xb0, 0xdc, 0x1a, 0x46, 0x67,
	0xda, 0x28, 0x62, 0x1c, 0x76, 0x9b, 0xff, 0x67, 0x66, 0xfa, 0x3e, 0x66, 0x81, 0xf0, 0x6f, 0x08,
	0x3f, 0xf3, 0x2d, 0x2d, 0x08, 0xcd, 0x30, 0x12, 0x8e, 0xa7, 0xff, 0x3e, 0x80, 0x6a, 0x2b, 0x2e,
	0xf4, 0x80, 0xba, 0x8e, 0x35, 0x46, 0x08, 0xee, 0x11, 0xd3, 0xc3, 0xb2, 0x54, 0x97, 0xb6, 0x2a,
	0x3a, 0x5f, 0xa3, 0x4d, 0x58, 0x1e, 0x39, 0x81, 0xef, 0x9a, 0x63, 0x83, 0xfb, 0x0a, 0xdc, 0x57,
	0x15, 0x7b, 0x83, 0x18, 0x72, 0x0c, 0x2b, 0x23, 0x6a, 0x45, 0x1e, 0x26, 0xc9, 0xe9, 0xe5, 0x95,
	0xba, 0xb4, 0x55, 0xdd, 0xd6, 0xd4, 0x59, 0xf7, 0xa6, 0xe6, 0x12, 0xaa, 0x9d, 0x7c, 0x98, 0x3e,
	0xcd, 0x82, 0x74, 0xa8, 0x46, 0x01, 0x66, 0x86, 0x6b, 0x0e, 0xb1, 0x1b, 0xc8, 0xb5, 0x7a, 0x71,
	0xab, 0xba, 0xfd, 0xd9, 0xbb, 0x49, 0x8f, 0x03, 0xcc, 0xbe, 0xe3, 0x31, 0x5d, 0x12, 0xb2, 0xb1,
	0x0e, 0x51, 0xb6, 0x81, 0xbe, 0x05, 0xb0, 0x28, 0x19, 0x39, 0x71, 0x82, 0x40, 0x5e, 0xe6, 0x94,
	0x9f, 0xbe, 0x9b, 0xb2, 0x9d, 0xc6, 0xe8, 0xb9, 0x70, 0x74, 0x08, 0x4b, 0x16, 0xf5, 0x86, 0x0e,
	0xc1, 0x4c, 0x2e, 0xd5, 0xa5, 0xad, 0xd5, 0xed, 0x2f, 0xe7, 0xa0, 0x6a, 0x8b, 0xd0, 0xa3, 0xb1,
	0x8f, 0xf5, 0x8c, 0x08, 0x7d, 0x0e, 0x65, 0x4c, 0xcc, 0xa1, 0x8b, 0x47, 0xf2, 0x7d, 0x7e, 0x8d,
	0x4a, 0xca, 0x99, 0xb6, 0x57, 0xdd, 0xa1, 0xd4, 0x3d, 0x31, 0xdd, 0x08, 0xeb, 0x29, 0x14, 0xa9,
	0xb0, 0x74, 0x61, 0xba, 0xce, 0xc8, 0x09, 0xc7, 0x32, 0xe2, 0x61, 0x28, 0x0d, 0x63, 0xbe, 0xa5,
	0x1e, 0xf2, 0xae, 0xeb, 0x19, 0x06, 0x35, 0xe0, 0x21, 0xa1, 0xa1, 0x73, 0xe6, 0x58, 0x89, 0xde,
	0xac, 0x73, 0x93, 0x90, 0xf8, 0x96, 0x57, 0xeb, 0xc5, 0xad, 0x8a, 0xbe, 0x9e, 0x77, 0xb6, 0x85,
	0x0f, 0xf5, 0x61, 0xcd, 0x62, 0x38, 0x2f, 0x50, 0x19, 0x78, 0xae, 0x8f, 0x66, 0x97, 0xdd, 0x17,
	0x6a, 0xd6, 0x39, 0x56, 0x5f, 0x4d, 0x83, 0x13, 0x3b, 0xa6, 0xbb, 0xa1, 0x77, 0xb9, 0x3a, 0x0f,
	0x9d, 0x37, 0x65, 0x2b, 0xbb, 0xb0, 0x32, 0x25, 0x27, 0x24, 0x43, 0xd9, 0xa2, 0x24, 0xc4, 0x24,
	0x14, 0x82, 0x4e, 0x4d, 0xf4, 0x01, 0x54, 0x3c, 0xc7, 0xc3, 0x46, 0x38, 0xf6, 0x53, 0x41, 0x2f,
	0xc5, 0x1b, 0x71, 0x2b, 0x94, 0xd7, 0x00, 0x95, 0xac, 0x49, 0xd9, 0x93, 0x58, 0x7e, 0xcb, 0x93,
	0x28, 0xbd, 0xf9, 0x24, 0x08, 0x3c, 0xc8, 0x84, 0x62, 0x84, 0xe7, 0x0c, 0x07, 0xe7, 0xd4, 0x1d,
	0xf1, 0x73, 0x54, 0xb7, 0x5f, 0xce, 0xa1, 0x12, 0xb5, 0x8f, 0x43, 0xe6, 0x58, 0x47, 0x29, 0x45,
	0x6f, 0x41, 0x47, 0x19, 0x73, 0xb6, 0x8b, 0xce, 0xa0, 0x36, 0xc9, 0x67, 0x0e, 0x83, 0xb8, 0xe8,
	0x02, 0x4f, 0xf6, 0x62, 0xfe, 0x64, 0xad, 0x38, 0xde, 0xc2, 0xbd, 0x05, 0x7d, 0x2d, 0x23, 0xe5,
	0x7b, 0xa1, 0xd2, 0x85, 0xf2, 0x11, 0x73, 0x6c, 0x1b, 0x33, 0xf4, 0x08, 0x16, 0x2d, 0x1a, 0x89,
	0xcb, 0x5d, 0xec, 0x2d, 0xe8, 0x89, 0x89, 0x14, 0x28, 0xfb, 0x98, 0x59, 0xe9, 0x09, 0xa4, 0xde,
	0x82, 0x9e, 0x6e, 0xec, 0x94, 0xe0, 0x5e, 0x7c, 0xe7, 0xca, 0x3f, 0x45, 0x58, 0xbb, 0x51, 0x18,
	0x7a, 0x04, 0xa5, 0x33, 0xc7, 0x0d, 0x31, 0x13, 0x1d, 0x11, 0x16, 0xea, 0xc2, 0xb2, 0x69, 0xdb,
	0x0c, 0xdb, 0x66, 0xf2, 0x68, 0x97, 0xf8, 0xa3, 0xdd, 0xbc, 0xa5, 0xac, 0x09, 0x52, 0x9f, 0x0a,
	0x43, 0xcf, 0x01, 0x8d, 0x30, 0xa1, 0x9e, 0x43, 0xcc, 0x90, 0x32, 0x43, 0xa4, 0xaa, 0xf0, 0x54,
	0xf7, 0x73, 0x9e, 0xdd, 0x24, 0xeb, 0x29, 0xc8, 0x79, 0xf8, 0xd4, 0x09, 0xe0, 0x7d, 0x4f, 0xb0,
	0x91, 0xa3, 0x68, 0xe5, 0x0f, 0xd3, 0x89, 0xc7, 0x90, 0xe7, 0x9b, 0xcc, 0x09, 0x28, 0x91, 0xef,
	0xf1, 0xd9, 0x71, 0x8b, 0xea, 0xdb, 0x19, 0x8e, 0x0f, 0x8a, 0x5c, 0x1c, 0xfa, 0x04, 0xd6, 0x32,
	0x69, 0x19, 0x17, 0xf1, 0x40, 0x90, 0x17, 0xe3, 0x1b, 0xd7, 0x57, 0xb3, 0x6d, 0x3e, 0x26, 0xd0,
	0x17, 0xb0, 0x94, 0x7e, 0x32, 0xb8, 0x58, 0xab, 0xdb, 0x8f, 0xdf, 0x18, 0x2a, 0x1d, 0x01, 0xd0,
	0x33, 0x28, 0xea, 0x43, 0x39, 0x4c, 0x9a, 0x2d, 0x97, 0x79, 0x54, 0x63, 0x1e, 0x2d, 0x09, 0x9d,
	0xe8, 0x29, 0x87, 0xf2, 0x5a, 0x82, 0x95, 0x29, 0x81, 0xe5, 0x5a, 0x2e, 0xbd, 0xb5, 0xe5, 0x8b,
	0x77, 0x6b, 0x79, 0xbe, 0xec, 0xc2, 0x9d, 0xca, 0x2e, 0xfe, 0xff, 0xb2, 0x9b, 0xbf, 0x15, 0xae,
	0x5b, 0xbf, 0x16, 0x20, 0x1f, 0x9c, 0xd0, 0x99, 0xbe, 0x13, 0xa8, 0x16, 0xf5, 0xb4, 0x1c, 0xd1,
	0x64, 0xf0, 0xec, 0xfa, 0x8c, 0xfe, 0x88, 0xad, 0x30, 0xd0, 0x2e, 0xc5, 0xea, 0x2a, 0xf9, 0x29,
	0xe1, 0x40, 0x07, 0x07, 0xda, 0x25, 0x37, 0x0d, 0x9f, 0x07, 0x5e, 0x69, 0x93, 0x0f, 0x93, 0x76,
	0x99, 0xad, 0xaf, 0xd0, 0x01, 0x65, 0xb6, 0x49, 0x9c, 0x5f, 0x4c, 0xe1, 0xca, 0x9b, 0x77, 0x63,
	0xec, 0x9c, 0x51, 0x77, 0x84, 0x59, 0xa0, 0x5d, 0x26, 0x8b, 0xbb, 0xb1, 0x48, 0xcf, 0x76, 0xaa,
	0x50, 0xc9, 0x36, 0x94, 0xaf, 0x61, 0xed, 0xc6, 0x87, 0x1b, 0xd5, 0xa0, 0xf8, 0x13, 0x1e, 0x0b,
	0x6d, 0xc4, 0x4b, 0xb4, 0x0e, 0x8b, 0x89, 0xce, 0x93, 0x11, 0x91, 0x18, 0xcd, 0xc2, 0x57, 0xd2,
	0x53, 0x13, 0x1e, 0xce, 0xfc, 0xb2, 0xa2, 0x0d, 0x78, 0xd0, 0xde, 0xef, 0xef, 0xec, 0x0d, 0xba,
	0xc6, 0xf1, 0xe0, 0xf0, 0xa0, 0xdb, 0xde, 0xdb, 0xdd, 0xeb, 0x76, 0x6a, 0x0b, 0xa8, 0x0c, 0xc5,
	0xd6, 0xa0, 0x53, 0x93, 0x50, 0x09, 0x0a, 0xfb, 0x7a, 0xad, 0x80, 0x9e, 0x80, 0xd2, 0x1a, 0x74,
	0x8c, 0xef, 0xf7, 0x8e, 0x7a, 0x46, 0xbf, 0x75, 0xd4, 0xee, 0xed, 0x0d, 0x5e, 0x19, 0x7a, 0xf7,
	0x70, 0xff, 0x58, 0x6f, 0x77, 0x6b, 0xc5, 0xe6, 0x5f, 0xd2, 0x75, 0xeb, 0x4f, 0x09, 0x3e, 0x7e,
	0xaf, 0x46, 0x22, 0x6d, 0xce, 0xfe, 0xa1, 0x17, 0x77, 0x6e, 0x14, 0x7a, 0x3e, 0x57, 0x47, 0xe2,
	0xab, 0xff, 0x43, 0x02, 0xd9, 0xa2, 0xde, 0x4c, 0x61, 0xef, 0x40, 0x52, 0x47, 0xfc, 0x44, 0x0e,
	0xa4, 0x1f, 0xbe, 0x11, 0x18, 0x9b, 0xba, 0x26, 0xb1, 0x55, 0xca, 0x6c, 0xcd, 0xc6, 0x84, 0x3f,
	0x20, 0x6d, 0x52, 0xff, 0xf4, 0x8f, 0xec, 0xcb, 0x89, 0xf5, 0x7b, 0x41, 0x79, 0x95, 0x10, 0xb4,
	0x5d, 0x1a, 0x8d, 0xd4, 0xfe, 0x24, 0xd5, 0x49, 0xe3, 0xef, 0xd4, 0x79, 0xca, 0x9d, 0xa7, 0x13,
	0xe7, 0xe9, 0x49, 0xe3, 0xba, 0xf0, 0x61, 0xe2, 0x6c, 0x36, 0xb9, 0xb7, 0xd9, 0x9c, 0xb8, 0x9b,
	0xcd, 0x93, 0xc6, 0xb0, 0xc4, 0x0f, 0xd1, 0xf8, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x0f, 0x6e, 0xf5,
	0xbb, 0xc2, 0x0b, 0x00, 0x00,
}
