// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/alert_service.proto

package monitoring

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The protocol for the `CreateAlertPolicy` request.
type CreateAlertPolicyRequest struct {
	// Required. The project in which to create the alerting policy. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	//
	// Note that this field names the parent container in which the alerting
	// policy will be written, not the name of the created policy. The alerting
	// policy that is returned will have a name that contains a normalized
	// representation of this name as a prefix but adds a suffix of the form
	// `/alertPolicies/[ALERT_POLICY_ID]`, identifying the policy in the
	// container.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The requested alerting policy. You should omit the `name` field in this
	// policy. The name will be returned in the new policy, including
	// a new `[ALERT_POLICY_ID]` value.
	AlertPolicy          *AlertPolicy `protobuf:"bytes,2,opt,name=alert_policy,json=alertPolicy,proto3" json:"alert_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateAlertPolicyRequest) Reset()         { *m = CreateAlertPolicyRequest{} }
func (m *CreateAlertPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAlertPolicyRequest) ProtoMessage()    {}
func (*CreateAlertPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c45362b2a456d1bf, []int{0}
}

func (m *CreateAlertPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAlertPolicyRequest.Unmarshal(m, b)
}
func (m *CreateAlertPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAlertPolicyRequest.Marshal(b, m, deterministic)
}
func (m *CreateAlertPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAlertPolicyRequest.Merge(m, src)
}
func (m *CreateAlertPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAlertPolicyRequest.Size(m)
}
func (m *CreateAlertPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAlertPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAlertPolicyRequest proto.InternalMessageInfo

func (m *CreateAlertPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateAlertPolicyRequest) GetAlertPolicy() *AlertPolicy {
	if m != nil {
		return m.AlertPolicy
	}
	return nil
}

// The protocol for the `GetAlertPolicy` request.
type GetAlertPolicyRequest struct {
	// Required. The alerting policy to retrieve. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAlertPolicyRequest) Reset()         { *m = GetAlertPolicyRequest{} }
func (m *GetAlertPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*GetAlertPolicyRequest) ProtoMessage()    {}
func (*GetAlertPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c45362b2a456d1bf, []int{1}
}

func (m *GetAlertPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAlertPolicyRequest.Unmarshal(m, b)
}
func (m *GetAlertPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAlertPolicyRequest.Marshal(b, m, deterministic)
}
func (m *GetAlertPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAlertPolicyRequest.Merge(m, src)
}
func (m *GetAlertPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_GetAlertPolicyRequest.Size(m)
}
func (m *GetAlertPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAlertPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAlertPolicyRequest proto.InternalMessageInfo

func (m *GetAlertPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The protocol for the `ListAlertPolicies` request.
type ListAlertPoliciesRequest struct {
	// Required. The project whose alert policies are to be listed. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]
	//
	// Note that this field names the parent container in which the alerting
	// policies to be listed are stored. To retrieve a single alerting policy
	// by name, use the
	// [GetAlertPolicy][google.monitoring.v3.AlertPolicyService.GetAlertPolicy]
	// operation, instead.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// If provided, this field specifies the criteria that must be met by
	// alert policies to be included in the response.
	//
	// For more details, see [sorting and
	// filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// A comma-separated list of fields by which to sort the result. Supports
	// the same set of field references as the `filter` field. Entries can be
	// prefixed with a minus sign to sort by the field in descending order.
	//
	// For more details, see [sorting and
	// filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// The maximum number of results to return in a single response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If this field is not empty then it must contain the `nextPageToken` value
	// returned by a previous call to this method.  Using this field causes the
	// method to return more results from the previous method call.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAlertPoliciesRequest) Reset()         { *m = ListAlertPoliciesRequest{} }
func (m *ListAlertPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*ListAlertPoliciesRequest) ProtoMessage()    {}
func (*ListAlertPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c45362b2a456d1bf, []int{2}
}

func (m *ListAlertPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAlertPoliciesRequest.Unmarshal(m, b)
}
func (m *ListAlertPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAlertPoliciesRequest.Marshal(b, m, deterministic)
}
func (m *ListAlertPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAlertPoliciesRequest.Merge(m, src)
}
func (m *ListAlertPoliciesRequest) XXX_Size() int {
	return xxx_messageInfo_ListAlertPoliciesRequest.Size(m)
}
func (m *ListAlertPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAlertPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAlertPoliciesRequest proto.InternalMessageInfo

func (m *ListAlertPoliciesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListAlertPoliciesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListAlertPoliciesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListAlertPoliciesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAlertPoliciesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The protocol for the `ListAlertPolicies` response.
type ListAlertPoliciesResponse struct {
	// The returned alert policies.
	AlertPolicies []*AlertPolicy `protobuf:"bytes,3,rep,name=alert_policies,json=alertPolicies,proto3" json:"alert_policies,omitempty"`
	// If there might be more results than were returned, then this field is set
	// to a non-empty value. To see the additional results,
	// use that value as `page_token` in the next call to this method.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAlertPoliciesResponse) Reset()         { *m = ListAlertPoliciesResponse{} }
func (m *ListAlertPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*ListAlertPoliciesResponse) ProtoMessage()    {}
func (*ListAlertPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c45362b2a456d1bf, []int{3}
}

func (m *ListAlertPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAlertPoliciesResponse.Unmarshal(m, b)
}
func (m *ListAlertPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAlertPoliciesResponse.Marshal(b, m, deterministic)
}
func (m *ListAlertPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAlertPoliciesResponse.Merge(m, src)
}
func (m *ListAlertPoliciesResponse) XXX_Size() int {
	return xxx_messageInfo_ListAlertPoliciesResponse.Size(m)
}
func (m *ListAlertPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAlertPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAlertPoliciesResponse proto.InternalMessageInfo

func (m *ListAlertPoliciesResponse) GetAlertPolicies() []*AlertPolicy {
	if m != nil {
		return m.AlertPolicies
	}
	return nil
}

func (m *ListAlertPoliciesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The protocol for the `UpdateAlertPolicy` request.
type UpdateAlertPolicyRequest struct {
	// Optional. A list of alerting policy field names. If this field is not
	// empty, each listed field in the existing alerting policy is set to the
	// value of the corresponding field in the supplied policy (`alert_policy`),
	// or to the field's default value if the field is not in the supplied
	// alerting policy.  Fields not listed retain their previous value.
	//
	// Examples of valid field masks include `display_name`, `documentation`,
	// `documentation.content`, `documentation.mime_type`, `user_labels`,
	// `user_label.nameofkey`, `enabled`, `conditions`, `combiner`, etc.
	//
	// If this field is empty, then the supplied alerting policy replaces the
	// existing policy. It is the same as deleting the existing policy and
	// adding the supplied policy, except for the following:
	//
	// +   The new policy will have the same `[ALERT_POLICY_ID]` as the former
	//     policy. This gives you continuity with the former policy in your
	//     notifications and incidents.
	// +   Conditions in the new policy will keep their former `[CONDITION_ID]` if
	//     the supplied condition includes the `name` field with that
	//     `[CONDITION_ID]`. If the supplied condition omits the `name` field,
	//     then a new `[CONDITION_ID]` is created.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The updated alerting policy or the updated values for the
	// fields listed in `update_mask`.
	// If `update_mask` is not empty, any fields in this policy that are
	// not in `update_mask` are ignored.
	AlertPolicy          *AlertPolicy `protobuf:"bytes,3,opt,name=alert_policy,json=alertPolicy,proto3" json:"alert_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *UpdateAlertPolicyRequest) Reset()         { *m = UpdateAlertPolicyRequest{} }
func (m *UpdateAlertPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAlertPolicyRequest) ProtoMessage()    {}
func (*UpdateAlertPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c45362b2a456d1bf, []int{4}
}

func (m *UpdateAlertPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAlertPolicyRequest.Unmarshal(m, b)
}
func (m *UpdateAlertPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAlertPolicyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateAlertPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAlertPolicyRequest.Merge(m, src)
}
func (m *UpdateAlertPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateAlertPolicyRequest.Size(m)
}
func (m *UpdateAlertPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAlertPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAlertPolicyRequest proto.InternalMessageInfo

func (m *UpdateAlertPolicyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateAlertPolicyRequest) GetAlertPolicy() *AlertPolicy {
	if m != nil {
		return m.AlertPolicy
	}
	return nil
}

// The protocol for the `DeleteAlertPolicy` request.
type DeleteAlertPolicyRequest struct {
	// Required. The alerting policy to delete. The format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
	//
	// For more information, see [AlertPolicy][google.monitoring.v3.AlertPolicy].
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAlertPolicyRequest) Reset()         { *m = DeleteAlertPolicyRequest{} }
func (m *DeleteAlertPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAlertPolicyRequest) ProtoMessage()    {}
func (*DeleteAlertPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c45362b2a456d1bf, []int{5}
}

func (m *DeleteAlertPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAlertPolicyRequest.Unmarshal(m, b)
}
func (m *DeleteAlertPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAlertPolicyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAlertPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAlertPolicyRequest.Merge(m, src)
}
func (m *DeleteAlertPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAlertPolicyRequest.Size(m)
}
func (m *DeleteAlertPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAlertPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAlertPolicyRequest proto.InternalMessageInfo

func (m *DeleteAlertPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateAlertPolicyRequest)(nil), "google.monitoring.v3.CreateAlertPolicyRequest")
	proto.RegisterType((*GetAlertPolicyRequest)(nil), "google.monitoring.v3.GetAlertPolicyRequest")
	proto.RegisterType((*ListAlertPoliciesRequest)(nil), "google.monitoring.v3.ListAlertPoliciesRequest")
	proto.RegisterType((*ListAlertPoliciesResponse)(nil), "google.monitoring.v3.ListAlertPoliciesResponse")
	proto.RegisterType((*UpdateAlertPolicyRequest)(nil), "google.monitoring.v3.UpdateAlertPolicyRequest")
	proto.RegisterType((*DeleteAlertPolicyRequest)(nil), "google.monitoring.v3.DeleteAlertPolicyRequest")
}

func init() {
	proto.RegisterFile("google/monitoring/v3/alert_service.proto", fileDescriptor_c45362b2a456d1bf)
}

var fileDescriptor_c45362b2a456d1bf = []byte{
	// 824 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x41, 0x4f, 0xdb, 0x48,
	0x18, 0x95, 0x13, 0x60, 0x61, 0x58, 0x58, 0x65, 0xb4, 0xcb, 0x3a, 0x66, 0xd1, 0x66, 0xb3, 0x62,
	0x41, 0x2c, 0xd8, 0x52, 0xb2, 0x27, 0xa3, 0x5d, 0xc9, 0x61, 0x5b, 0x5a, 0xa9, 0x48, 0x51, 0x68,
	0x39, 0x20, 0xaa, 0x68, 0xe2, 0x4c, 0xcc, 0x14, 0xc7, 0xe3, 0xda, 0x93, 0xd0, 0x50, 0x71, 0xe9,
	0xad, 0x87, 0x1e, 0xaa, 0x4a, 0x3d, 0xf6, 0xd0, 0x13, 0xed, 0xbd, 0x3f, 0xa2, 0xb4, 0xa7, 0xf6,
	0xc6, 0x89, 0x43, 0x4f, 0xfd, 0x09, 0x3d, 0x55, 0x1e, 0x3b, 0xd8, 0x49, 0x6c, 0x61, 0xb8, 0xe1,
	0xef, 0xbd, 0xf9, 0xe6, 0xcd, 0x9b, 0xf7, 0x0d, 0x01, 0xcb, 0x06, 0xa5, 0x86, 0x89, 0x95, 0x36,
	0xb5, 0x08, 0xa3, 0x0e, 0xb1, 0x0c, 0xa5, 0x5b, 0x56, 0x90, 0x89, 0x1d, 0x56, 0x77, 0xb1, 0xd3,
	0x25, 0x3a, 0x96, 0x6d, 0x87, 0x32, 0x0a, 0x7f, 0xf6, 0x99, 0x72, 0xc8, 0x94, 0xbb, 0x65, 0xe9,
	0xb7, 0x60, 0x3d, 0xb2, 0x89, 0x82, 0x2c, 0x8b, 0x32, 0xc4, 0x08, 0xb5, 0x5c, 0x7f, 0x8d, 0xf4,
	0x6b, 0x04, 0xd5, 0x4d, 0x82, 0x2d, 0x16, 0x00, 0xbf, 0x47, 0x80, 0x16, 0xc1, 0x66, 0xb3, 0xde,
	0xc0, 0xfb, 0xa8, 0x4b, 0xa8, 0x13, 0x10, 0xf2, 0x11, 0x82, 0x83, 0x5d, 0xda, 0x71, 0xfa, 0x42,
	0xa4, 0x42, 0xb2, 0xe4, 0x80, 0x31, 0x1f, 0x30, 0xf8, 0x57, 0xa3, 0xd3, 0x52, 0x70, 0xdb, 0x66,
	0xbd, 0xa1, 0xe5, 0x17, 0xa0, 0xbf, 0x7f, 0x1b, 0xb9, 0x07, 0x3e, 0xa3, 0x78, 0x22, 0x00, 0x71,
	0xc3, 0xc1, 0x88, 0x61, 0xcd, 0x6b, 0x5a, 0xa5, 0x26, 0xd1, 0x7b, 0x35, 0xfc, 0xb0, 0x83, 0x5d,
	0x06, 0x35, 0x30, 0x66, 0xa1, 0x36, 0x16, 0xb3, 0x05, 0x61, 0x79, 0xaa, 0xb2, 0x76, 0xae, 0x65,
	0xbe, 0x69, 0x4b, 0x70, 0x31, 0xe2, 0x8a, 0xdf, 0x1f, 0xd9, 0xc4, 0x95, 0x75, 0xda, 0x56, 0xa2,
	0x3d, 0xf8, 0x52, 0x78, 0x1b, 0xfc, 0xe8, 0x1b, 0x6c, 0xf3, 0xaa, 0x98, 0x29, 0x08, 0xcb, 0xd3,
	0xa5, 0x3f, 0xe4, 0x38, 0x83, 0xe5, 0xc8, 0xf2, 0x4a, 0xf6, 0x5c, 0xcb, 0xd4, 0xa6, 0x51, 0x58,
	0x29, 0xee, 0x82, 0x5f, 0x36, 0x31, 0x4b, 0x2b, 0x13, 0x5c, 0x45, 0x66, 0xf1, 0xa3, 0x00, 0xc4,
	0x3b, 0xc4, 0x8d, 0x74, 0x27, 0xd8, 0x1d, 0xee, 0x3f, 0x76, 0x7d, 0x1b, 0xe6, 0xc0, 0x44, 0x8b,
	0x98, 0x0c, 0x3b, 0xe2, 0xb8, 0xd7, 0xa4, 0x16, 0x7c, 0xc1, 0x3c, 0x98, 0xa4, 0x4e, 0x13, 0x3b,
	0xf5, 0x46, 0x4f, 0x9c, 0xe0, 0xc8, 0x0f, 0xfc, 0xbb, 0xd2, 0x83, 0xf3, 0x60, 0xca, 0x46, 0x06,
	0xae, 0xbb, 0xe4, 0x08, 0x73, 0xdb, 0xc6, 0x6b, 0x93, 0x5e, 0x61, 0x9b, 0x1c, 0x61, 0xb8, 0x00,
	0x00, 0x07, 0x19, 0x3d, 0xc0, 0x96, 0x7f, 0xf0, 0x1a, 0xa7, 0xdf, 0xf5, 0x0a, 0xc5, 0x67, 0x02,
	0xc8, 0xc7, 0x1c, 0xc7, 0xb5, 0xa9, 0xe5, 0x62, 0x78, 0x0b, 0xcc, 0x46, 0xee, 0x84, 0x60, 0x57,
	0xcc, 0x16, 0xb2, 0xa9, 0x6e, 0xa5, 0x36, 0x83, 0xa2, 0x1d, 0xe1, 0x5f, 0xe0, 0x27, 0x0b, 0x3f,
	0x62, 0xf5, 0x88, 0x96, 0x0c, 0xd7, 0x32, 0xe3, 0x95, 0xab, 0x17, 0x7a, 0x5e, 0x0b, 0x40, 0xbc,
	0x67, 0x37, 0xe3, 0x53, 0xb6, 0x0e, 0xa6, 0x3b, 0x1c, 0xe3, 0xb9, 0x0c, 0x12, 0x22, 0xf5, 0xb5,
	0xf4, 0xa3, 0x2b, 0xdf, 0xf4, 0xa2, 0xbb, 0x85, 0xdc, 0x83, 0x1a, 0xf0, 0xe9, 0xde, 0xdf, 0x23,
	0xf9, 0xca, 0x5e, 0x3f, 0x5f, 0xf7, 0x81, 0xf8, 0x3f, 0x36, 0x71, 0xfa, 0x49, 0xb8, 0x52, 0xc4,
	0x4a, 0xaf, 0x26, 0x01, 0x8c, 0x54, 0xb7, 0xfd, 0x07, 0x07, 0x9e, 0x08, 0x20, 0x37, 0x72, 0x55,
	0x50, 0x8e, 0x3f, 0x40, 0x52, 0x44, 0x25, 0x25, 0x35, 0xdf, 0xcf, 0x40, 0xb1, 0x74, 0xa6, 0x71,
	0x59, 0x4f, 0x3e, 0x7f, 0x79, 0x91, 0x59, 0x84, 0x7f, 0x7a, 0xcf, 0xca, 0x63, 0xaf, 0xf0, 0xaf,
	0xed, 0xd0, 0x07, 0x58, 0x67, 0xae, 0xb2, 0x72, 0xac, 0x0c, 0xde, 0xf6, 0x4b, 0x01, 0xcc, 0x0e,
	0x4e, 0x20, 0xfc, 0x3b, 0x7e, 0xdf, 0xd8, 0x39, 0x95, 0x2e, 0xbf, 0x95, 0xe2, 0x3f, 0x51, 0x59,
	0x4b, 0x70, 0x31, 0x4e, 0xd6, 0xa0, 0x2a, 0x65, 0xe5, 0x18, 0xbe, 0x13, 0x40, 0x6e, 0xe4, 0x11,
	0x4b, 0xf2, 0x30, 0xe9, 0xb5, 0x4b, 0x23, 0x6f, 0xeb, 0x4c, 0xcb, 0x79, 0x6a, 0x56, 0xa3, 0x99,
	0xe3, 0x5a, 0xcb, 0xc5, 0x34, 0x16, 0xaa, 0x03, 0x61, 0x85, 0xcf, 0x05, 0x90, 0x1b, 0x89, 0x5c,
	0x92, 0xee, 0xa4, 0x6c, 0x4a, 0x73, 0x23, 0xa3, 0x72, 0xc3, 0xfb, 0x17, 0x30, 0xe4, 0xe5, 0x4a,
	0x4a, 0x2f, 0x3f, 0x08, 0x20, 0x37, 0x32, 0xaa, 0x49, 0x9a, 0x92, 0x66, 0x3a, 0x8d, 0x97, 0xfa,
	0x99, 0x26, 0x46, 0xe6, 0x7e, 0xd4, 0xd2, 0x4a, 0xa9, 0xc4, 0x25, 0x47, 0x01, 0xf9, 0x32, 0xfd,
	0x83, 0x0e, 0x4b, 0x6f, 0x84, 0x53, 0x2d, 0x9f, 0x38, 0xa5, 0x9f, 0xb4, 0xa7, 0xc2, 0x3e, 0x63,
	0xb6, 0xab, 0x2a, 0xca, 0xe1, 0xe1, 0xe1, 0xf0, 0x0c, 0xa3, 0x0e, 0xdb, 0x57, 0x74, 0x93, 0x76,
	0x9a, 0x6b, 0xb6, 0x89, 0x58, 0x8b, 0x3a, 0xed, 0xd5, 0xcb, 0xe8, 0xe1, 0x5e, 0x57, 0xa0, 0xca,
	0x0e, 0x46, 0xcd, 0xca, 0x7b, 0x01, 0x88, 0x3a, 0x6d, 0xc7, 0x3a, 0x57, 0xc9, 0x71, 0xeb, 0x82,
	0x47, 0xa3, 0xea, 0x5d, 0x74, 0x55, 0xd8, 0xfd, 0x2f, 0xa0, 0x1a, 0xd4, 0x44, 0x96, 0x21, 0x53,
	0xc7, 0x50, 0x0c, 0x6c, 0xf1, 0x18, 0x28, 0xe1, 0x8e, 0x83, 0x3f, 0x1e, 0xd6, 0xc3, 0xaf, 0xb7,
	0x19, 0x69, 0xd3, 0x6f, 0xb0, 0xe1, 0x1d, 0x52, 0xde, 0x0a, 0x77, 0xdc, 0x29, 0x9f, 0xf6, 0xc1,
	0x3d, 0x0e, 0xee, 0x85, 0xe0, 0xde, 0x4e, 0xf9, 0x6b, 0x66, 0xc1, 0x07, 0x55, 0x95, 0xa3, 0xaa,
	0x1a, 0xc2, 0xaa, 0xba, 0x53, 0x6e, 0x4c, 0x70, 0x11, 0xe5, 0xef, 0x01, 0x00, 0x00, 0xff, 0xff,
	0x0b, 0x1e, 0x0e, 0x6f, 0x73, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AlertPolicyServiceClient is the client API for AlertPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AlertPolicyServiceClient interface {
	// Lists the existing alerting policies for the project.
	ListAlertPolicies(ctx context.Context, in *ListAlertPoliciesRequest, opts ...grpc.CallOption) (*ListAlertPoliciesResponse, error)
	// Gets a single alerting policy.
	GetAlertPolicy(ctx context.Context, in *GetAlertPolicyRequest, opts ...grpc.CallOption) (*AlertPolicy, error)
	// Creates a new alerting policy.
	CreateAlertPolicy(ctx context.Context, in *CreateAlertPolicyRequest, opts ...grpc.CallOption) (*AlertPolicy, error)
	// Deletes an alerting policy.
	DeleteAlertPolicy(ctx context.Context, in *DeleteAlertPolicyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates an alerting policy. You can either replace the entire policy with
	// a new one or replace only certain fields in the current alerting policy by
	// specifying the fields to be updated via `updateMask`. Returns the
	// updated alerting policy.
	UpdateAlertPolicy(ctx context.Context, in *UpdateAlertPolicyRequest, opts ...grpc.CallOption) (*AlertPolicy, error)
}

type alertPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAlertPolicyServiceClient(cc grpc.ClientConnInterface) AlertPolicyServiceClient {
	return &alertPolicyServiceClient{cc}
}

func (c *alertPolicyServiceClient) ListAlertPolicies(ctx context.Context, in *ListAlertPoliciesRequest, opts ...grpc.CallOption) (*ListAlertPoliciesResponse, error) {
	out := new(ListAlertPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.AlertPolicyService/ListAlertPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertPolicyServiceClient) GetAlertPolicy(ctx context.Context, in *GetAlertPolicyRequest, opts ...grpc.CallOption) (*AlertPolicy, error) {
	out := new(AlertPolicy)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.AlertPolicyService/GetAlertPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertPolicyServiceClient) CreateAlertPolicy(ctx context.Context, in *CreateAlertPolicyRequest, opts ...grpc.CallOption) (*AlertPolicy, error) {
	out := new(AlertPolicy)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.AlertPolicyService/CreateAlertPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertPolicyServiceClient) DeleteAlertPolicy(ctx context.Context, in *DeleteAlertPolicyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.AlertPolicyService/DeleteAlertPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertPolicyServiceClient) UpdateAlertPolicy(ctx context.Context, in *UpdateAlertPolicyRequest, opts ...grpc.CallOption) (*AlertPolicy, error) {
	out := new(AlertPolicy)
	err := c.cc.Invoke(ctx, "/google.monitoring.v3.AlertPolicyService/UpdateAlertPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AlertPolicyServiceServer is the server API for AlertPolicyService service.
type AlertPolicyServiceServer interface {
	// Lists the existing alerting policies for the project.
	ListAlertPolicies(context.Context, *ListAlertPoliciesRequest) (*ListAlertPoliciesResponse, error)
	// Gets a single alerting policy.
	GetAlertPolicy(context.Context, *GetAlertPolicyRequest) (*AlertPolicy, error)
	// Creates a new alerting policy.
	CreateAlertPolicy(context.Context, *CreateAlertPolicyRequest) (*AlertPolicy, error)
	// Deletes an alerting policy.
	DeleteAlertPolicy(context.Context, *DeleteAlertPolicyRequest) (*empty.Empty, error)
	// Updates an alerting policy. You can either replace the entire policy with
	// a new one or replace only certain fields in the current alerting policy by
	// specifying the fields to be updated via `updateMask`. Returns the
	// updated alerting policy.
	UpdateAlertPolicy(context.Context, *UpdateAlertPolicyRequest) (*AlertPolicy, error)
}

// UnimplementedAlertPolicyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAlertPolicyServiceServer struct {
}

func (*UnimplementedAlertPolicyServiceServer) ListAlertPolicies(ctx context.Context, req *ListAlertPoliciesRequest) (*ListAlertPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAlertPolicies not implemented")
}
func (*UnimplementedAlertPolicyServiceServer) GetAlertPolicy(ctx context.Context, req *GetAlertPolicyRequest) (*AlertPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAlertPolicy not implemented")
}
func (*UnimplementedAlertPolicyServiceServer) CreateAlertPolicy(ctx context.Context, req *CreateAlertPolicyRequest) (*AlertPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAlertPolicy not implemented")
}
func (*UnimplementedAlertPolicyServiceServer) DeleteAlertPolicy(ctx context.Context, req *DeleteAlertPolicyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAlertPolicy not implemented")
}
func (*UnimplementedAlertPolicyServiceServer) UpdateAlertPolicy(ctx context.Context, req *UpdateAlertPolicyRequest) (*AlertPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAlertPolicy not implemented")
}

func RegisterAlertPolicyServiceServer(s *grpc.Server, srv AlertPolicyServiceServer) {
	s.RegisterService(&_AlertPolicyService_serviceDesc, srv)
}

func _AlertPolicyService_ListAlertPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAlertPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertPolicyServiceServer).ListAlertPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.AlertPolicyService/ListAlertPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertPolicyServiceServer).ListAlertPolicies(ctx, req.(*ListAlertPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertPolicyService_GetAlertPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAlertPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertPolicyServiceServer).GetAlertPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.AlertPolicyService/GetAlertPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertPolicyServiceServer).GetAlertPolicy(ctx, req.(*GetAlertPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertPolicyService_CreateAlertPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAlertPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertPolicyServiceServer).CreateAlertPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.AlertPolicyService/CreateAlertPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertPolicyServiceServer).CreateAlertPolicy(ctx, req.(*CreateAlertPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertPolicyService_DeleteAlertPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAlertPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertPolicyServiceServer).DeleteAlertPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.AlertPolicyService/DeleteAlertPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertPolicyServiceServer).DeleteAlertPolicy(ctx, req.(*DeleteAlertPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertPolicyService_UpdateAlertPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAlertPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertPolicyServiceServer).UpdateAlertPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.monitoring.v3.AlertPolicyService/UpdateAlertPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertPolicyServiceServer).UpdateAlertPolicy(ctx, req.(*UpdateAlertPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AlertPolicyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.monitoring.v3.AlertPolicyService",
	HandlerType: (*AlertPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAlertPolicies",
			Handler:    _AlertPolicyService_ListAlertPolicies_Handler,
		},
		{
			MethodName: "GetAlertPolicy",
			Handler:    _AlertPolicyService_GetAlertPolicy_Handler,
		},
		{
			MethodName: "CreateAlertPolicy",
			Handler:    _AlertPolicyService_CreateAlertPolicy_Handler,
		},
		{
			MethodName: "DeleteAlertPolicy",
			Handler:    _AlertPolicyService_DeleteAlertPolicy_Handler,
		},
		{
			MethodName: "UpdateAlertPolicy",
			Handler:    _AlertPolicyService_UpdateAlertPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/monitoring/v3/alert_service.proto",
}
