// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptInvitationRequest method.
//    req, resp := client.AcceptInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
func (c *SecurityHub) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInvitation API operation for AWS SecurityHub.
//
// Accepts the invitation to be a member account and be monitored by the Security
// Hub master account that the invitation was sent from.
//
// This operation is only used by member accounts that are not added through
// Organizations.
//
// When the member account accepts the invitation, permission is granted to
// the master account to view findings generated in the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation
func (c *SecurityHub) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisableStandards = "BatchDisableStandards"

// BatchDisableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisableStandards for more information on using the BatchDisableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisableStandardsRequest method.
//    req, resp := client.BatchDisableStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandardsRequest(input *BatchDisableStandardsInput) (req *request.Request, output *BatchDisableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchDisableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/deregister",
	}

	if input == nil {
		input = &BatchDisableStandardsInput{}
	}

	output = &BatchDisableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisableStandards API operation for AWS SecurityHub.
//
// Disables the standards specified by the provided StandardsSubscriptionArns.
//
// For more information, see Security Standards (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html)
// section of the AWS Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchDisableStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards
func (c *SecurityHub) BatchDisableStandards(input *BatchDisableStandardsInput) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	return out, req.Send()
}

// BatchDisableStandardsWithContext is the same as BatchDisableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchDisableStandardsWithContext(ctx aws.Context, input *BatchDisableStandardsInput, opts ...request.Option) (*BatchDisableStandardsOutput, error) {
	req, out := c.BatchDisableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchEnableStandards = "BatchEnableStandards"

// BatchEnableStandardsRequest generates a "aws/request.Request" representing the
// client's request for the BatchEnableStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchEnableStandards for more information on using the BatchEnableStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchEnableStandardsRequest method.
//    req, resp := client.BatchEnableStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandardsRequest(input *BatchEnableStandardsInput) (req *request.Request, output *BatchEnableStandardsOutput) {
	op := &request.Operation{
		Name:       opBatchEnableStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/register",
	}

	if input == nil {
		input = &BatchEnableStandardsInput{}
	}

	output = &BatchEnableStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchEnableStandards API operation for AWS SecurityHub.
//
// Enables the standards specified by the provided StandardsArn. To obtain the
// ARN for a standard, use the DescribeStandards operation.
//
// For more information, see the Security Standards (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html)
// section of the AWS Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchEnableStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards
func (c *SecurityHub) BatchEnableStandards(input *BatchEnableStandardsInput) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	return out, req.Send()
}

// BatchEnableStandardsWithContext is the same as BatchEnableStandards with the addition of
// the ability to pass a context and additional request options.
//
// See BatchEnableStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchEnableStandardsWithContext(ctx aws.Context, input *BatchEnableStandardsInput, opts ...request.Option) (*BatchEnableStandardsOutput, error) {
	req, out := c.BatchEnableStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchImportFindings = "BatchImportFindings"

// BatchImportFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchImportFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchImportFindings for more information on using the BatchImportFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchImportFindingsRequest method.
//    req, resp := client.BatchImportFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindingsRequest(input *BatchImportFindingsInput) (req *request.Request, output *BatchImportFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchImportFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/import",
	}

	if input == nil {
		input = &BatchImportFindingsInput{}
	}

	output = &BatchImportFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchImportFindings API operation for AWS SecurityHub.
//
// Imports security findings generated from an integrated third-party product
// into Security Hub. This action is requested by the integrated product to
// import its findings into Security Hub.
//
// The maximum allowed size for a finding is 240 Kb. An error is returned for
// any finding larger than 240 Kb.
//
// After a finding is created, BatchImportFindings cannot be used to update
// the following finding fields and objects, which Security Hub customers use
// to manage their investigation workflow.
//
//    * Confidence
//
//    * Criticality
//
//    * Note
//
//    * RelatedFindings
//
//    * Severity
//
//    * Types
//
//    * UserDefinedFields
//
//    * VerificationState
//
//    * Workflow
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchImportFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings
func (c *SecurityHub) BatchImportFindings(input *BatchImportFindingsInput) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	return out, req.Send()
}

// BatchImportFindingsWithContext is the same as BatchImportFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchImportFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchImportFindingsWithContext(ctx aws.Context, input *BatchImportFindingsInput, opts ...request.Option) (*BatchImportFindingsOutput, error) {
	req, out := c.BatchImportFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateFindings = "BatchUpdateFindings"

// BatchUpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateFindings for more information on using the BatchUpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdateFindingsRequest method.
//    req, resp := client.BatchUpdateFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings
func (c *SecurityHub) BatchUpdateFindingsRequest(input *BatchUpdateFindingsInput) (req *request.Request, output *BatchUpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings/batchupdate",
	}

	if input == nil {
		input = &BatchUpdateFindingsInput{}
	}

	output = &BatchUpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateFindings API operation for AWS SecurityHub.
//
// Used by Security Hub customers to update information about their investigation
// into a finding. Requested by master accounts or member accounts. Master accounts
// can update findings for their account and their member accounts. Member accounts
// can update findings for their account.
//
// Updates from BatchUpdateFindings do not affect the value of UpdatedAt for
// a finding.
//
// Master and member accounts can use BatchUpdateFindings to update the following
// finding fields and objects.
//
//    * Confidence
//
//    * Criticality
//
//    * Note
//
//    * RelatedFindings
//
//    * Severity
//
//    * Types
//
//    * UserDefinedFields
//
//    * VerificationState
//
//    * Workflow
//
// You can configure IAM policies to restrict access to fields and field values.
// For example, you might not want member accounts to be able to suppress findings
// or change the finding severity. See Configuring access to BatchUpdateFindings
// (https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access)
// in the AWS Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation BatchUpdateFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings
func (c *SecurityHub) BatchUpdateFindings(input *BatchUpdateFindingsInput) (*BatchUpdateFindingsOutput, error) {
	req, out := c.BatchUpdateFindingsRequest(input)
	return out, req.Send()
}

// BatchUpdateFindingsWithContext is the same as BatchUpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) BatchUpdateFindingsWithContext(ctx aws.Context, input *BatchUpdateFindingsInput, opts ...request.Option) (*BatchUpdateFindingsOutput, error) {
	req, out := c.BatchUpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateActionTarget = "CreateActionTarget"

// CreateActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the CreateActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateActionTarget for more information on using the CreateActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateActionTargetRequest method.
//    req, resp := client.CreateActionTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget
func (c *SecurityHub) CreateActionTargetRequest(input *CreateActionTargetInput) (req *request.Request, output *CreateActionTargetOutput) {
	op := &request.Operation{
		Name:       opCreateActionTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/actionTargets",
	}

	if input == nil {
		input = &CreateActionTargetInput{}
	}

	output = &CreateActionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateActionTarget API operation for AWS SecurityHub.
//
// Creates a custom action target in Security Hub.
//
// You can use custom actions on findings and insights in Security Hub to trigger
// target actions in Amazon CloudWatch Events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateActionTarget for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget
func (c *SecurityHub) CreateActionTarget(input *CreateActionTargetInput) (*CreateActionTargetOutput, error) {
	req, out := c.CreateActionTargetRequest(input)
	return out, req.Send()
}

// CreateActionTargetWithContext is the same as CreateActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateActionTargetWithContext(ctx aws.Context, input *CreateActionTargetInput, opts ...request.Option) (*CreateActionTargetOutput, error) {
	req, out := c.CreateActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInsight = "CreateInsight"

// CreateInsightRequest generates a "aws/request.Request" representing the
// client's request for the CreateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInsight for more information on using the CreateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInsightRequest method.
//    req, resp := client.CreateInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsightRequest(input *CreateInsightInput) (req *request.Request, output *CreateInsightOutput) {
	op := &request.Operation{
		Name:       opCreateInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
	}

	if input == nil {
		input = &CreateInsightInput{}
	}

	output = &CreateInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInsight API operation for AWS SecurityHub.
//
// Creates a custom insight in Security Hub. An insight is a consolidation of
// findings that relate to a security issue that requires attention or remediation.
//
// To group the related findings in the insight, use the GroupByAttribute.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateInsight for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *SecurityHub) CreateInsight(input *CreateInsightInput) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	return out, req.Send()
}

// CreateInsightWithContext is the same as CreateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateInsightWithContext(ctx aws.Context, input *CreateInsightInput, opts ...request.Option) (*CreateInsightOutput, error) {
	req, out := c.CreateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembers = "CreateMembers"

// CreateMembersRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembers for more information on using the CreateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMembersRequest method.
//    req, resp := client.CreateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembersRequest(input *CreateMembersInput) (req *request.Request, output *CreateMembersOutput) {
	op := &request.Operation{
		Name:       opCreateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members",
	}

	if input == nil {
		input = &CreateMembersInput{}
	}

	output = &CreateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembers API operation for AWS SecurityHub.
//
// Creates a member association in Security Hub between the specified accounts
// and the account used to make the request, which is the master account. If
// you are integrated with Organizations, then the master account is the Security
// Hub administrator account that is designated by the organization management
// account.
//
// CreateMembers is always used to add accounts that are not organization members.
//
// For accounts that are part of an organization, CreateMembers is only used
// in the following cases:
//
//    * Security Hub is not configured to automatically add new accounts in
//    an organization.
//
//    * The account was disassociated or deleted in Security Hub.
//
// This action can only be used by an account that has Security Hub enabled.
// To enable Security Hub, you can use the EnableSecurityHub operation.
//
// For accounts that are not organization members, you create the account association
// and then send an invitation to the member account. To send the invitation,
// you use the InviteMembers operation. If the account owner accepts the invitation,
// the account becomes a member account in Security Hub.
//
// Accounts that are part of an organization do not receive an invitation. They
// automatically become a member account in Security Hub.
//
// A permissions policy is added that permits the master account to view the
// findings generated in the member account. When Security Hub is enabled in
// a member account, findings are sent to both the member and master accounts.
//
// To remove the association between the master and member accounts, use the
// DisassociateFromMasterAccount or DisassociateMembers operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation CreateMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers
func (c *SecurityHub) CreateMembers(input *CreateMembersInput) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	return out, req.Send()
}

// CreateMembersWithContext is the same as CreateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) CreateMembersWithContext(ctx aws.Context, input *CreateMembersInput, opts ...request.Option) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeclineInvitations = "DeclineInvitations"

// DeclineInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeclineInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeclineInvitations for more information on using the DeclineInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeclineInvitationsRequest method.
//    req, resp := client.DeclineInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitationsRequest(input *DeclineInvitationsInput) (req *request.Request, output *DeclineInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeclineInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/decline",
	}

	if input == nil {
		input = &DeclineInvitationsInput{}
	}

	output = &DeclineInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeclineInvitations API operation for AWS SecurityHub.
//
// Declines invitations to become a member account.
//
// This operation is only used by accounts that are not part of an organization.
// Organization accounts do not receive invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeclineInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations
func (c *SecurityHub) DeclineInvitations(input *DeclineInvitationsInput) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	return out, req.Send()
}

// DeclineInvitationsWithContext is the same as DeclineInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeclineInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeclineInvitationsWithContext(ctx aws.Context, input *DeclineInvitationsInput, opts ...request.Option) (*DeclineInvitationsOutput, error) {
	req, out := c.DeclineInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteActionTarget = "DeleteActionTarget"

// DeleteActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteActionTarget for more information on using the DeleteActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteActionTargetRequest method.
//    req, resp := client.DeleteActionTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget
func (c *SecurityHub) DeleteActionTargetRequest(input *DeleteActionTargetInput) (req *request.Request, output *DeleteActionTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteActionTarget,
		HTTPMethod: "DELETE",
		HTTPPath:   "/actionTargets/{ActionTargetArn+}",
	}

	if input == nil {
		input = &DeleteActionTargetInput{}
	}

	output = &DeleteActionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteActionTarget API operation for AWS SecurityHub.
//
// Deletes a custom action target from Security Hub.
//
// Deleting a custom action target does not affect any findings or insights
// that were already sent to Amazon CloudWatch Events using the custom action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteActionTarget for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget
func (c *SecurityHub) DeleteActionTarget(input *DeleteActionTargetInput) (*DeleteActionTargetOutput, error) {
	req, out := c.DeleteActionTargetRequest(input)
	return out, req.Send()
}

// DeleteActionTargetWithContext is the same as DeleteActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteActionTargetWithContext(ctx aws.Context, input *DeleteActionTargetInput, opts ...request.Option) (*DeleteActionTargetOutput, error) {
	req, out := c.DeleteActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInsight = "DeleteInsight"

// DeleteInsightRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInsight for more information on using the DeleteInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInsightRequest method.
//    req, resp := client.DeleteInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsightRequest(input *DeleteInsightInput) (req *request.Request, output *DeleteInsightOutput) {
	op := &request.Operation{
		Name:       opDeleteInsight,
		HTTPMethod: "DELETE",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &DeleteInsightInput{}
	}

	output = &DeleteInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInsight API operation for AWS SecurityHub.
//
// Deletes the insight specified by the InsightArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInsight for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight
func (c *SecurityHub) DeleteInsight(input *DeleteInsightInput) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	return out, req.Send()
}

// DeleteInsightWithContext is the same as DeleteInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInsightWithContext(ctx aws.Context, input *DeleteInsightInput, opts ...request.Option) (*DeleteInsightOutput, error) {
	req, out := c.DeleteInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInvitations = "DeleteInvitations"

// DeleteInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInvitations for more information on using the DeleteInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInvitationsRequest method.
//    req, resp := client.DeleteInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitationsRequest(input *DeleteInvitationsInput) (req *request.Request, output *DeleteInvitationsOutput) {
	op := &request.Operation{
		Name:       opDeleteInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/delete",
	}

	if input == nil {
		input = &DeleteInvitationsInput{}
	}

	output = &DeleteInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInvitations API operation for AWS SecurityHub.
//
// Deletes invitations received by the AWS account to become a member account.
//
// This operation is only used by accounts that are not part of an organization.
// Organization accounts do not receive invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations
func (c *SecurityHub) DeleteInvitations(input *DeleteInvitationsInput) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	return out, req.Send()
}

// DeleteInvitationsWithContext is the same as DeleteInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteInvitationsWithContext(ctx aws.Context, input *DeleteInvitationsInput, opts ...request.Option) (*DeleteInvitationsOutput, error) {
	req, out := c.DeleteInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembers for more information on using the DeleteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMembersRequest method.
//    req, resp := client.DeleteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembersRequest(input *DeleteMembersInput) (req *request.Request, output *DeleteMembersOutput) {
	op := &request.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/delete",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	output = &DeleteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMembers API operation for AWS SecurityHub.
//
// Deletes the specified member accounts from Security Hub.
//
// Can be used to delete member accounts that belong to an organization as well
// as member accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DeleteMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers
func (c *SecurityHub) DeleteMembers(input *DeleteMembersInput) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	return out, req.Send()
}

// DeleteMembersWithContext is the same as DeleteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DeleteMembersWithContext(ctx aws.Context, input *DeleteMembersInput, opts ...request.Option) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActionTargets = "DescribeActionTargets"

// DescribeActionTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActionTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActionTargets for more information on using the DescribeActionTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeActionTargetsRequest method.
//    req, resp := client.DescribeActionTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets
func (c *SecurityHub) DescribeActionTargetsRequest(input *DescribeActionTargetsInput) (req *request.Request, output *DescribeActionTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeActionTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/actionTargets/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeActionTargetsInput{}
	}

	output = &DescribeActionTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActionTargets API operation for AWS SecurityHub.
//
// Returns a list of the custom action targets in Security Hub in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeActionTargets for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets
func (c *SecurityHub) DescribeActionTargets(input *DescribeActionTargetsInput) (*DescribeActionTargetsOutput, error) {
	req, out := c.DescribeActionTargetsRequest(input)
	return out, req.Send()
}

// DescribeActionTargetsWithContext is the same as DescribeActionTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActionTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeActionTargetsWithContext(ctx aws.Context, input *DescribeActionTargetsInput, opts ...request.Option) (*DescribeActionTargetsOutput, error) {
	req, out := c.DescribeActionTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeActionTargetsPages iterates over the pages of a DescribeActionTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeActionTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeActionTargets operation.
//    pageNum := 0
//    err := client.DescribeActionTargetsPages(params,
//        func(page *securityhub.DescribeActionTargetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeActionTargetsPages(input *DescribeActionTargetsInput, fn func(*DescribeActionTargetsOutput, bool) bool) error {
	return c.DescribeActionTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeActionTargetsPagesWithContext same as DescribeActionTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeActionTargetsPagesWithContext(ctx aws.Context, input *DescribeActionTargetsInput, fn func(*DescribeActionTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeActionTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeActionTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeActionTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHub = "DescribeHub"

// DescribeHubRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHub for more information on using the DescribeHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHubRequest method.
//    req, resp := client.DescribeHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub
func (c *SecurityHub) DescribeHubRequest(input *DescribeHubInput) (req *request.Request, output *DescribeHubOutput) {
	op := &request.Operation{
		Name:       opDescribeHub,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &DescribeHubInput{}
	}

	output = &DescribeHubOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHub API operation for AWS SecurityHub.
//
// Returns details about the Hub resource in your account, including the HubArn
// and the time when you enabled Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeHub for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub
func (c *SecurityHub) DescribeHub(input *DescribeHubInput) (*DescribeHubOutput, error) {
	req, out := c.DescribeHubRequest(input)
	return out, req.Send()
}

// DescribeHubWithContext is the same as DescribeHub with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeHubWithContext(ctx aws.Context, input *DescribeHubInput, opts ...request.Option) (*DescribeHubOutput, error) {
	req, out := c.DescribeHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganizationConfiguration = "DescribeOrganizationConfiguration"

// DescribeOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganizationConfiguration for more information on using the DescribeOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationConfigurationRequest method.
//    req, resp := client.DescribeOrganizationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration
func (c *SecurityHub) DescribeOrganizationConfigurationRequest(input *DescribeOrganizationConfigurationInput) (req *request.Request, output *DescribeOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganizationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/organization/configuration",
	}

	if input == nil {
		input = &DescribeOrganizationConfigurationInput{}
	}

	output = &DescribeOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganizationConfiguration API operation for AWS SecurityHub.
//
// Returns information about the Organizations configuration for Security Hub.
// Can only be called from a Security Hub administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration
func (c *SecurityHub) DescribeOrganizationConfiguration(input *DescribeOrganizationConfigurationInput) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationConfigurationWithContext is the same as DescribeOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeOrganizationConfigurationWithContext(ctx aws.Context, input *DescribeOrganizationConfigurationInput, opts ...request.Option) (*DescribeOrganizationConfigurationOutput, error) {
	req, out := c.DescribeOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProducts = "DescribeProducts"

// DescribeProductsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProducts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProducts for more information on using the DescribeProducts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProductsRequest method.
//    req, resp := client.DescribeProductsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts
func (c *SecurityHub) DescribeProductsRequest(input *DescribeProductsInput) (req *request.Request, output *DescribeProductsOutput) {
	op := &request.Operation{
		Name:       opDescribeProducts,
		HTTPMethod: "GET",
		HTTPPath:   "/products",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeProductsInput{}
	}

	output = &DescribeProductsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProducts API operation for AWS SecurityHub.
//
// Returns information about the available products that you can subscribe to
// and integrate with Security Hub in order to consolidate findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeProducts for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts
func (c *SecurityHub) DescribeProducts(input *DescribeProductsInput) (*DescribeProductsOutput, error) {
	req, out := c.DescribeProductsRequest(input)
	return out, req.Send()
}

// DescribeProductsWithContext is the same as DescribeProducts with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProducts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeProductsWithContext(ctx aws.Context, input *DescribeProductsInput, opts ...request.Option) (*DescribeProductsOutput, error) {
	req, out := c.DescribeProductsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeProductsPages iterates over the pages of a DescribeProducts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeProducts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeProducts operation.
//    pageNum := 0
//    err := client.DescribeProductsPages(params,
//        func(page *securityhub.DescribeProductsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeProductsPages(input *DescribeProductsInput, fn func(*DescribeProductsOutput, bool) bool) error {
	return c.DescribeProductsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeProductsPagesWithContext same as DescribeProductsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeProductsPagesWithContext(ctx aws.Context, input *DescribeProductsInput, fn func(*DescribeProductsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeProductsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeProductsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeProductsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStandards = "DescribeStandards"

// DescribeStandardsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStandards for more information on using the DescribeStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStandardsRequest method.
//    req, resp := client.DescribeStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards
func (c *SecurityHub) DescribeStandardsRequest(input *DescribeStandardsInput) (req *request.Request, output *DescribeStandardsOutput) {
	op := &request.Operation{
		Name:       opDescribeStandards,
		HTTPMethod: "GET",
		HTTPPath:   "/standards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStandardsInput{}
	}

	output = &DescribeStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStandards API operation for AWS SecurityHub.
//
// Returns a list of the available standards in Security Hub.
//
// For each standard, the results include the standard ARN, the name, and a
// description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards
func (c *SecurityHub) DescribeStandards(input *DescribeStandardsInput) (*DescribeStandardsOutput, error) {
	req, out := c.DescribeStandardsRequest(input)
	return out, req.Send()
}

// DescribeStandardsWithContext is the same as DescribeStandards with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsWithContext(ctx aws.Context, input *DescribeStandardsInput, opts ...request.Option) (*DescribeStandardsOutput, error) {
	req, out := c.DescribeStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStandardsPages iterates over the pages of a DescribeStandards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStandards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStandards operation.
//    pageNum := 0
//    err := client.DescribeStandardsPages(params,
//        func(page *securityhub.DescribeStandardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeStandardsPages(input *DescribeStandardsInput, fn func(*DescribeStandardsOutput, bool) bool) error {
	return c.DescribeStandardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStandardsPagesWithContext same as DescribeStandardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsPagesWithContext(ctx aws.Context, input *DescribeStandardsInput, fn func(*DescribeStandardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStandardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStandardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStandardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStandardsControls = "DescribeStandardsControls"

// DescribeStandardsControlsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStandardsControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStandardsControls for more information on using the DescribeStandardsControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStandardsControlsRequest method.
//    req, resp := client.DescribeStandardsControlsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls
func (c *SecurityHub) DescribeStandardsControlsRequest(input *DescribeStandardsControlsInput) (req *request.Request, output *DescribeStandardsControlsOutput) {
	op := &request.Operation{
		Name:       opDescribeStandardsControls,
		HTTPMethod: "GET",
		HTTPPath:   "/standards/controls/{StandardsSubscriptionArn+}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStandardsControlsInput{}
	}

	output = &DescribeStandardsControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStandardsControls API operation for AWS SecurityHub.
//
// Returns a list of security standards controls.
//
// For each control, the results include information about whether it is currently
// enabled, the severity, and a link to remediation information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DescribeStandardsControls for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls
func (c *SecurityHub) DescribeStandardsControls(input *DescribeStandardsControlsInput) (*DescribeStandardsControlsOutput, error) {
	req, out := c.DescribeStandardsControlsRequest(input)
	return out, req.Send()
}

// DescribeStandardsControlsWithContext is the same as DescribeStandardsControls with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStandardsControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsControlsWithContext(ctx aws.Context, input *DescribeStandardsControlsInput, opts ...request.Option) (*DescribeStandardsControlsOutput, error) {
	req, out := c.DescribeStandardsControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeStandardsControlsPages iterates over the pages of a DescribeStandardsControls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStandardsControls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStandardsControls operation.
//    pageNum := 0
//    err := client.DescribeStandardsControlsPages(params,
//        func(page *securityhub.DescribeStandardsControlsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) DescribeStandardsControlsPages(input *DescribeStandardsControlsInput, fn func(*DescribeStandardsControlsOutput, bool) bool) error {
	return c.DescribeStandardsControlsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeStandardsControlsPagesWithContext same as DescribeStandardsControlsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DescribeStandardsControlsPagesWithContext(ctx aws.Context, input *DescribeStandardsControlsInput, fn func(*DescribeStandardsControlsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeStandardsControlsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeStandardsControlsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeStandardsControlsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisableImportFindingsForProduct = "DisableImportFindingsForProduct"

// DisableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the DisableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableImportFindingsForProduct for more information on using the DisableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableImportFindingsForProductRequest method.
//    req, resp := client.DisableImportFindingsForProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProductRequest(input *DisableImportFindingsForProductInput) (req *request.Request, output *DisableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opDisableImportFindingsForProduct,
		HTTPMethod: "DELETE",
		HTTPPath:   "/productSubscriptions/{ProductSubscriptionArn+}",
	}

	if input == nil {
		input = &DisableImportFindingsForProductInput{}
	}

	output = &DisableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Disables the integration of the specified product with Security Hub. After
// the integration is disabled, findings from that product are no longer sent
// to Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableImportFindingsForProduct for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct
func (c *SecurityHub) DisableImportFindingsForProduct(input *DisableImportFindingsForProductInput) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// DisableImportFindingsForProductWithContext is the same as DisableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See DisableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableImportFindingsForProductWithContext(ctx aws.Context, input *DisableImportFindingsForProductInput, opts ...request.Option) (*DisableImportFindingsForProductOutput, error) {
	req, out := c.DisableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableOrganizationAdminAccount = "DisableOrganizationAdminAccount"

// DisableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableOrganizationAdminAccount for more information on using the DisableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableOrganizationAdminAccountRequest method.
//    req, resp := client.DisableOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount
func (c *SecurityHub) DisableOrganizationAdminAccountRequest(input *DisableOrganizationAdminAccountInput) (req *request.Request, output *DisableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opDisableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/admin/disable",
	}

	if input == nil {
		input = &DisableOrganizationAdminAccountInput{}
	}

	output = &DisableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableOrganizationAdminAccount API operation for AWS SecurityHub.
//
// Disables a Security Hub administrator account. Can only be called by the
// organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount
func (c *SecurityHub) DisableOrganizationAdminAccount(input *DisableOrganizationAdminAccountInput) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// DisableOrganizationAdminAccountWithContext is the same as DisableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableOrganizationAdminAccountWithContext(ctx aws.Context, input *DisableOrganizationAdminAccountInput, opts ...request.Option) (*DisableOrganizationAdminAccountOutput, error) {
	req, out := c.DisableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableSecurityHub = "DisableSecurityHub"

// DisableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the DisableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableSecurityHub for more information on using the DisableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableSecurityHubRequest method.
//    req, resp := client.DisableSecurityHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHubRequest(input *DisableSecurityHubInput) (req *request.Request, output *DisableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opDisableSecurityHub,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &DisableSecurityHubInput{}
	}

	output = &DisableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableSecurityHub API operation for AWS SecurityHub.
//
// Disables Security Hub in your account only in the current Region. To disable
// Security Hub in all Regions, you must submit one request per Region where
// you have enabled Security Hub.
//
// When you disable Security Hub for a master account, it doesn't disable Security
// Hub for any associated member accounts.
//
// When you disable Security Hub, your existing findings and insights and any
// Security Hub configuration settings are deleted after 90 days and cannot
// be recovered. Any standards that were enabled are disabled, and your master
// and member account associations are removed.
//
// If you want to save your existing findings, you must export them before you
// disable Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisableSecurityHub for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub
func (c *SecurityHub) DisableSecurityHub(input *DisableSecurityHubInput) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	return out, req.Send()
}

// DisableSecurityHubWithContext is the same as DisableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See DisableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisableSecurityHubWithContext(ctx aws.Context, input *DisableSecurityHubInput, opts ...request.Option) (*DisableSecurityHubOutput, error) {
	req, out := c.DisableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFromMasterAccount = "DisassociateFromMasterAccount"

// DisassociateFromMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFromMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFromMasterAccount for more information on using the DisassociateFromMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFromMasterAccountRequest method.
//    req, resp := client.DisassociateFromMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
func (c *SecurityHub) DisassociateFromMasterAccountRequest(input *DisassociateFromMasterAccountInput) (req *request.Request, output *DisassociateFromMasterAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateFromMasterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/master/disassociate",
	}

	if input == nil {
		input = &DisassociateFromMasterAccountInput{}
	}

	output = &DisassociateFromMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFromMasterAccount API operation for AWS SecurityHub.
//
// Disassociates the current Security Hub member account from the associated
// master account.
//
// This operation is only used by accounts that are not part of an organization.
// For organization accounts, only the master account (the designated Security
// Hub administrator) can disassociate a member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateFromMasterAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount
func (c *SecurityHub) DisassociateFromMasterAccount(input *DisassociateFromMasterAccountInput) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	return out, req.Send()
}

// DisassociateFromMasterAccountWithContext is the same as DisassociateFromMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFromMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateFromMasterAccountWithContext(ctx aws.Context, input *DisassociateFromMasterAccountInput, opts ...request.Option) (*DisassociateFromMasterAccountOutput, error) {
	req, out := c.DisassociateFromMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMembers = "DisassociateMembers"

// DisassociateMembersRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMembers for more information on using the DisassociateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMembersRequest method.
//    req, resp := client.DisassociateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembersRequest(input *DisassociateMembersInput) (req *request.Request, output *DisassociateMembersOutput) {
	op := &request.Operation{
		Name:       opDisassociateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/disassociate",
	}

	if input == nil {
		input = &DisassociateMembersInput{}
	}

	output = &DisassociateMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMembers API operation for AWS SecurityHub.
//
// Disassociates the specified member accounts from the associated master account.
//
// Can be used to disassociate both accounts that are in an organization and
// accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation DisassociateMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers
func (c *SecurityHub) DisassociateMembers(input *DisassociateMembersInput) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	return out, req.Send()
}

// DisassociateMembersWithContext is the same as DisassociateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) DisassociateMembersWithContext(ctx aws.Context, input *DisassociateMembersInput, opts ...request.Option) (*DisassociateMembersOutput, error) {
	req, out := c.DisassociateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableImportFindingsForProduct = "EnableImportFindingsForProduct"

// EnableImportFindingsForProductRequest generates a "aws/request.Request" representing the
// client's request for the EnableImportFindingsForProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableImportFindingsForProduct for more information on using the EnableImportFindingsForProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableImportFindingsForProductRequest method.
//    req, resp := client.EnableImportFindingsForProductRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProductRequest(input *EnableImportFindingsForProductInput) (req *request.Request, output *EnableImportFindingsForProductOutput) {
	op := &request.Operation{
		Name:       opEnableImportFindingsForProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/productSubscriptions",
	}

	if input == nil {
		input = &EnableImportFindingsForProductInput{}
	}

	output = &EnableImportFindingsForProductOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableImportFindingsForProduct API operation for AWS SecurityHub.
//
// Enables the integration of a partner product with Security Hub. Integrated
// products send findings to Security Hub.
//
// When you enable a product integration, a permissions policy that grants permission
// for the product to send findings to Security Hub is applied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableImportFindingsForProduct for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct
func (c *SecurityHub) EnableImportFindingsForProduct(input *EnableImportFindingsForProductInput) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	return out, req.Send()
}

// EnableImportFindingsForProductWithContext is the same as EnableImportFindingsForProduct with the addition of
// the ability to pass a context and additional request options.
//
// See EnableImportFindingsForProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableImportFindingsForProductWithContext(ctx aws.Context, input *EnableImportFindingsForProductInput, opts ...request.Option) (*EnableImportFindingsForProductOutput, error) {
	req, out := c.EnableImportFindingsForProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableOrganizationAdminAccount = "EnableOrganizationAdminAccount"

// EnableOrganizationAdminAccountRequest generates a "aws/request.Request" representing the
// client's request for the EnableOrganizationAdminAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableOrganizationAdminAccount for more information on using the EnableOrganizationAdminAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableOrganizationAdminAccountRequest method.
//    req, resp := client.EnableOrganizationAdminAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount
func (c *SecurityHub) EnableOrganizationAdminAccountRequest(input *EnableOrganizationAdminAccountInput) (req *request.Request, output *EnableOrganizationAdminAccountOutput) {
	op := &request.Operation{
		Name:       opEnableOrganizationAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/admin/enable",
	}

	if input == nil {
		input = &EnableOrganizationAdminAccountInput{}
	}

	output = &EnableOrganizationAdminAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableOrganizationAdminAccount API operation for AWS SecurityHub.
//
// Designates the Security Hub administrator account for an organization. Can
// only be called by the organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableOrganizationAdminAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount
func (c *SecurityHub) EnableOrganizationAdminAccount(input *EnableOrganizationAdminAccountInput) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	return out, req.Send()
}

// EnableOrganizationAdminAccountWithContext is the same as EnableOrganizationAdminAccount with the addition of
// the ability to pass a context and additional request options.
//
// See EnableOrganizationAdminAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableOrganizationAdminAccountWithContext(ctx aws.Context, input *EnableOrganizationAdminAccountInput, opts ...request.Option) (*EnableOrganizationAdminAccountOutput, error) {
	req, out := c.EnableOrganizationAdminAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSecurityHub = "EnableSecurityHub"

// EnableSecurityHubRequest generates a "aws/request.Request" representing the
// client's request for the EnableSecurityHub operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSecurityHub for more information on using the EnableSecurityHub
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableSecurityHubRequest method.
//    req, resp := client.EnableSecurityHubRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHubRequest(input *EnableSecurityHubInput) (req *request.Request, output *EnableSecurityHubOutput) {
	op := &request.Operation{
		Name:       opEnableSecurityHub,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &EnableSecurityHubInput{}
	}

	output = &EnableSecurityHubOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableSecurityHub API operation for AWS SecurityHub.
//
// Enables Security Hub for your account in the current Region or the Region
// you specify in the request.
//
// When you enable Security Hub, you grant to Security Hub the permissions necessary
// to gather findings from other services that are integrated with Security
// Hub.
//
// When you use the EnableSecurityHub operation to enable Security Hub, you
// also automatically enable the following standards.
//
//    * CIS AWS Foundations
//
//    * AWS Foundational Security Best Practices
//
// You do not enable the Payment Card Industry Data Security Standard (PCI DSS)
// standard.
//
// To not enable the automatically enabled standards, set EnableDefaultStandards
// to false.
//
// After you enable Security Hub, to enable a standard, use the BatchEnableStandards
// operation. To disable a standard, use the BatchDisableStandards operation.
//
// To learn more, see Setting Up AWS Security Hub (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html)
// in the AWS Security Hub User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation EnableSecurityHub for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceConflictException
//   The resource specified in the request conflicts with an existing resource.
//
//   * AccessDeniedException
//   You don't have permission to perform the action specified in the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub
func (c *SecurityHub) EnableSecurityHub(input *EnableSecurityHubInput) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	return out, req.Send()
}

// EnableSecurityHubWithContext is the same as EnableSecurityHub with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSecurityHub for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) EnableSecurityHubWithContext(ctx aws.Context, input *EnableSecurityHubInput, opts ...request.Option) (*EnableSecurityHubOutput, error) {
	req, out := c.EnableSecurityHubRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnabledStandards = "GetEnabledStandards"

// GetEnabledStandardsRequest generates a "aws/request.Request" representing the
// client's request for the GetEnabledStandards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnabledStandards for more information on using the GetEnabledStandards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEnabledStandardsRequest method.
//    req, resp := client.GetEnabledStandardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandardsRequest(input *GetEnabledStandardsInput) (req *request.Request, output *GetEnabledStandardsOutput) {
	op := &request.Operation{
		Name:       opGetEnabledStandards,
		HTTPMethod: "POST",
		HTTPPath:   "/standards/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEnabledStandardsInput{}
	}

	output = &GetEnabledStandardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnabledStandards API operation for AWS SecurityHub.
//
// Returns a list of the standards that are currently enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetEnabledStandards for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards
func (c *SecurityHub) GetEnabledStandards(input *GetEnabledStandardsInput) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	return out, req.Send()
}

// GetEnabledStandardsWithContext is the same as GetEnabledStandards with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnabledStandards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetEnabledStandardsWithContext(ctx aws.Context, input *GetEnabledStandardsInput, opts ...request.Option) (*GetEnabledStandardsOutput, error) {
	req, out := c.GetEnabledStandardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEnabledStandardsPages iterates over the pages of a GetEnabledStandards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEnabledStandards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetEnabledStandards operation.
//    pageNum := 0
//    err := client.GetEnabledStandardsPages(params,
//        func(page *securityhub.GetEnabledStandardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetEnabledStandardsPages(input *GetEnabledStandardsInput, fn func(*GetEnabledStandardsOutput, bool) bool) error {
	return c.GetEnabledStandardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEnabledStandardsPagesWithContext same as GetEnabledStandardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetEnabledStandardsPagesWithContext(ctx aws.Context, input *GetEnabledStandardsInput, fn func(*GetEnabledStandardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEnabledStandardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEnabledStandardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEnabledStandardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetFindings = "GetFindings"

// GetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindings for more information on using the GetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFindingsRequest method.
//    req, resp := client.GetFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindingsRequest(input *GetFindingsInput) (req *request.Request, output *GetFindingsOutput) {
	op := &request.Operation{
		Name:       opGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	output = &GetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindings API operation for AWS SecurityHub.
//
// Returns a list of findings that match the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings
func (c *SecurityHub) GetFindings(input *GetFindingsInput) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	return out, req.Send()
}

// GetFindingsWithContext is the same as GetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsWithContext(ctx aws.Context, input *GetFindingsInput, opts ...request.Option) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFindingsPages iterates over the pages of a GetFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetFindings operation.
//    pageNum := 0
//    err := client.GetFindingsPages(params,
//        func(page *securityhub.GetFindingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetFindingsPages(input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool) error {
	return c.GetFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFindingsPagesWithContext same as GetFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetFindingsPagesWithContext(ctx aws.Context, input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInsightResults = "GetInsightResults"

// GetInsightResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsightResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsightResults for more information on using the GetInsightResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInsightResultsRequest method.
//    req, resp := client.GetInsightResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResultsRequest(input *GetInsightResultsInput) (req *request.Request, output *GetInsightResultsOutput) {
	op := &request.Operation{
		Name:       opGetInsightResults,
		HTTPMethod: "GET",
		HTTPPath:   "/insights/results/{InsightArn+}",
	}

	if input == nil {
		input = &GetInsightResultsInput{}
	}

	output = &GetInsightResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsightResults API operation for AWS SecurityHub.
//
// Lists the results of the Security Hub insight specified by the insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsightResults for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *SecurityHub) GetInsightResults(input *GetInsightResultsInput) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	return out, req.Send()
}

// GetInsightResultsWithContext is the same as GetInsightResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsightResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightResultsWithContext(ctx aws.Context, input *GetInsightResultsInput, opts ...request.Option) (*GetInsightResultsOutput, error) {
	req, out := c.GetInsightResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInsights = "GetInsights"

// GetInsightsRequest generates a "aws/request.Request" representing the
// client's request for the GetInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInsights for more information on using the GetInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInsightsRequest method.
//    req, resp := client.GetInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsightsRequest(input *GetInsightsInput) (req *request.Request, output *GetInsightsOutput) {
	op := &request.Operation{
		Name:       opGetInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights/get",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInsightsInput{}
	}

	output = &GetInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInsights API operation for AWS SecurityHub.
//
// Lists and describes insights for the specified insight ARNs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInsights for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights
func (c *SecurityHub) GetInsights(input *GetInsightsInput) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	return out, req.Send()
}

// GetInsightsWithContext is the same as GetInsights with the addition of
// the ability to pass a context and additional request options.
//
// See GetInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsWithContext(ctx aws.Context, input *GetInsightsInput, opts ...request.Option) (*GetInsightsOutput, error) {
	req, out := c.GetInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInsightsPages iterates over the pages of a GetInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetInsights operation.
//    pageNum := 0
//    err := client.GetInsightsPages(params,
//        func(page *securityhub.GetInsightsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) GetInsightsPages(input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool) error {
	return c.GetInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInsightsPagesWithContext same as GetInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInsightsPagesWithContext(ctx aws.Context, input *GetInsightsInput, fn func(*GetInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetInvitationsCount = "GetInvitationsCount"

// GetInvitationsCountRequest generates a "aws/request.Request" representing the
// client's request for the GetInvitationsCount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvitationsCount for more information on using the GetInvitationsCount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvitationsCountRequest method.
//    req, resp := client.GetInvitationsCountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCountRequest(input *GetInvitationsCountInput) (req *request.Request, output *GetInvitationsCountOutput) {
	op := &request.Operation{
		Name:       opGetInvitationsCount,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations/count",
	}

	if input == nil {
		input = &GetInvitationsCountInput{}
	}

	output = &GetInvitationsCountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvitationsCount API operation for AWS SecurityHub.
//
// Returns the count of all Security Hub membership invitations that were sent
// to the current member account, not including the currently accepted invitation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetInvitationsCount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount
func (c *SecurityHub) GetInvitationsCount(input *GetInvitationsCountInput) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	return out, req.Send()
}

// GetInvitationsCountWithContext is the same as GetInvitationsCount with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvitationsCount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetInvitationsCountWithContext(ctx aws.Context, input *GetInvitationsCountInput, opts ...request.Option) (*GetInvitationsCountOutput, error) {
	req, out := c.GetInvitationsCountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMasterAccount = "GetMasterAccount"

// GetMasterAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetMasterAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMasterAccount for more information on using the GetMasterAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMasterAccountRequest method.
//    req, resp := client.GetMasterAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
func (c *SecurityHub) GetMasterAccountRequest(input *GetMasterAccountInput) (req *request.Request, output *GetMasterAccountOutput) {
	op := &request.Operation{
		Name:       opGetMasterAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/master",
	}

	if input == nil {
		input = &GetMasterAccountInput{}
	}

	output = &GetMasterAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMasterAccount API operation for AWS SecurityHub.
//
// Provides the details for the Security Hub master account for the current
// member account.
//
// Can be used by both member accounts that are in an organization and accounts
// that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMasterAccount for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount
func (c *SecurityHub) GetMasterAccount(input *GetMasterAccountInput) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	return out, req.Send()
}

// GetMasterAccountWithContext is the same as GetMasterAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetMasterAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetMasterAccountWithContext(ctx aws.Context, input *GetMasterAccountInput, opts ...request.Option) (*GetMasterAccountOutput, error) {
	req, out := c.GetMasterAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembers = "GetMembers"

// GetMembersRequest generates a "aws/request.Request" representing the
// client's request for the GetMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembers for more information on using the GetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMembersRequest method.
//    req, resp := client.GetMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembersRequest(input *GetMembersInput) (req *request.Request, output *GetMembersOutput) {
	op := &request.Operation{
		Name:       opGetMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/get",
	}

	if input == nil {
		input = &GetMembersInput{}
	}

	output = &GetMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembers API operation for AWS SecurityHub.
//
// Returns the details for the Security Hub member accounts for the specified
// account IDs.
//
// A master account can be either a delegated Security Hub administrator account
// for an organization or a master account that enabled Security Hub manually.
//
// The results include both member accounts that are in an organization and
// accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation GetMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers
func (c *SecurityHub) GetMembers(input *GetMembersInput) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	return out, req.Send()
}

// GetMembersWithContext is the same as GetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) GetMembersWithContext(ctx aws.Context, input *GetMembersInput, opts ...request.Option) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteMembers = "InviteMembers"

// InviteMembersRequest generates a "aws/request.Request" representing the
// client's request for the InviteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteMembers for more information on using the InviteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InviteMembersRequest method.
//    req, resp := client.InviteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembersRequest(input *InviteMembersInput) (req *request.Request, output *InviteMembersOutput) {
	op := &request.Operation{
		Name:       opInviteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/invite",
	}

	if input == nil {
		input = &InviteMembersInput{}
	}

	output = &InviteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteMembers API operation for AWS SecurityHub.
//
// Invites other AWS accounts to become member accounts for the Security Hub
// master account that the invitation is sent from.
//
// This operation is only used to invite accounts that do not belong to an organization.
// Organization accounts do not receive invitations.
//
// Before you can use this action to invite a member, you must first use the
// CreateMembers action to create the member account in Security Hub.
//
// When the account owner enables Security Hub and accepts the invitation to
// become a member account, the master account can view the findings generated
// from the member account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation InviteMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *SecurityHub) InviteMembers(input *InviteMembersInput) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	return out, req.Send()
}

// InviteMembersWithContext is the same as InviteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) InviteMembersWithContext(ctx aws.Context, input *InviteMembersInput, opts ...request.Option) (*InviteMembersOutput, error) {
	req, out := c.InviteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEnabledProductsForImport = "ListEnabledProductsForImport"

// ListEnabledProductsForImportRequest generates a "aws/request.Request" representing the
// client's request for the ListEnabledProductsForImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnabledProductsForImport for more information on using the ListEnabledProductsForImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEnabledProductsForImportRequest method.
//    req, resp := client.ListEnabledProductsForImportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImportRequest(input *ListEnabledProductsForImportInput) (req *request.Request, output *ListEnabledProductsForImportOutput) {
	op := &request.Operation{
		Name:       opListEnabledProductsForImport,
		HTTPMethod: "GET",
		HTTPPath:   "/productSubscriptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnabledProductsForImportInput{}
	}

	output = &ListEnabledProductsForImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnabledProductsForImport API operation for AWS SecurityHub.
//
// Lists all findings-generating solutions (products) that you are subscribed
// to receive findings from in Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListEnabledProductsForImport for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport
func (c *SecurityHub) ListEnabledProductsForImport(input *ListEnabledProductsForImportInput) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	return out, req.Send()
}

// ListEnabledProductsForImportWithContext is the same as ListEnabledProductsForImport with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnabledProductsForImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, opts ...request.Option) (*ListEnabledProductsForImportOutput, error) {
	req, out := c.ListEnabledProductsForImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnabledProductsForImportPages iterates over the pages of a ListEnabledProductsForImport operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnabledProductsForImport method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEnabledProductsForImport operation.
//    pageNum := 0
//    err := client.ListEnabledProductsForImportPages(params,
//        func(page *securityhub.ListEnabledProductsForImportOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListEnabledProductsForImportPages(input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool) error {
	return c.ListEnabledProductsForImportPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnabledProductsForImportPagesWithContext same as ListEnabledProductsForImportPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListEnabledProductsForImportPagesWithContext(ctx aws.Context, input *ListEnabledProductsForImportInput, fn func(*ListEnabledProductsForImportOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnabledProductsForImportInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnabledProductsForImportRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnabledProductsForImportOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvitationsRequest method.
//    req, resp := client.ListInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for AWS SecurityHub.
//
// Lists all Security Hub membership invitations that were sent to the current
// AWS account.
//
// This operation is only used by accounts that do not belong to an organization.
// Organization accounts do not receive invitations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *SecurityHub) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvitations operation.
//    pageNum := 0
//    err := client.ListInvitationsPages(params,
//        func(page *securityhub.ListInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMembersRequest method.
//    req, resp := client.ListMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for AWS SecurityHub.
//
// Lists details about all member accounts for the current Security Hub master
// account.
//
// The results include both member accounts that belong to an organization and
// member accounts that were invited manually.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers
func (c *SecurityHub) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMembers operation.
//    pageNum := 0
//    err := client.ListMembersPages(params,
//        func(page *securityhub.ListMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOrganizationAdminAccounts = "ListOrganizationAdminAccounts"

// ListOrganizationAdminAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizationAdminAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizationAdminAccounts for more information on using the ListOrganizationAdminAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOrganizationAdminAccountsRequest method.
//    req, resp := client.ListOrganizationAdminAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts
func (c *SecurityHub) ListOrganizationAdminAccountsRequest(input *ListOrganizationAdminAccountsInput) (req *request.Request, output *ListOrganizationAdminAccountsOutput) {
	op := &request.Operation{
		Name:       opListOrganizationAdminAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/organization/admin",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationAdminAccountsInput{}
	}

	output = &ListOrganizationAdminAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizationAdminAccounts API operation for AWS SecurityHub.
//
// Lists the Security Hub administrator accounts. Can only be called by the
// organization management account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListOrganizationAdminAccounts for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts
func (c *SecurityHub) ListOrganizationAdminAccounts(input *ListOrganizationAdminAccountsInput) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	return out, req.Send()
}

// ListOrganizationAdminAccountsWithContext is the same as ListOrganizationAdminAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizationAdminAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListOrganizationAdminAccountsWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, opts ...request.Option) (*ListOrganizationAdminAccountsOutput, error) {
	req, out := c.ListOrganizationAdminAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationAdminAccountsPages iterates over the pages of a ListOrganizationAdminAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizationAdminAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOrganizationAdminAccounts operation.
//    pageNum := 0
//    err := client.ListOrganizationAdminAccountsPages(params,
//        func(page *securityhub.ListOrganizationAdminAccountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SecurityHub) ListOrganizationAdminAccountsPages(input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool) error {
	return c.ListOrganizationAdminAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationAdminAccountsPagesWithContext same as ListOrganizationAdminAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListOrganizationAdminAccountsPagesWithContext(ctx aws.Context, input *ListOrganizationAdminAccountsInput, fn func(*ListOrganizationAdminAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationAdminAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationAdminAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOrganizationAdminAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource
func (c *SecurityHub) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS SecurityHub.
//
// Returns a list of tags associated with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource
func (c *SecurityHub) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource
func (c *SecurityHub) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS SecurityHub.
//
// Adds one or more tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource
func (c *SecurityHub) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource
func (c *SecurityHub) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS SecurityHub.
//
// Removes one or more tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource
func (c *SecurityHub) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateActionTarget = "UpdateActionTarget"

// UpdateActionTargetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateActionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateActionTarget for more information on using the UpdateActionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateActionTargetRequest method.
//    req, resp := client.UpdateActionTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget
func (c *SecurityHub) UpdateActionTargetRequest(input *UpdateActionTargetInput) (req *request.Request, output *UpdateActionTargetOutput) {
	op := &request.Operation{
		Name:       opUpdateActionTarget,
		HTTPMethod: "PATCH",
		HTTPPath:   "/actionTargets/{ActionTargetArn+}",
	}

	if input == nil {
		input = &UpdateActionTargetInput{}
	}

	output = &UpdateActionTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateActionTarget API operation for AWS SecurityHub.
//
// Updates the name and description of a custom action target in Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateActionTarget for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget
func (c *SecurityHub) UpdateActionTarget(input *UpdateActionTargetInput) (*UpdateActionTargetOutput, error) {
	req, out := c.UpdateActionTargetRequest(input)
	return out, req.Send()
}

// UpdateActionTargetWithContext is the same as UpdateActionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateActionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateActionTargetWithContext(ctx aws.Context, input *UpdateActionTargetInput, opts ...request.Option) (*UpdateActionTargetOutput, error) {
	req, out := c.UpdateActionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFindings = "UpdateFindings"

// UpdateFindingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFindings for more information on using the UpdateFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFindingsRequest method.
//    req, resp := client.UpdateFindingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindingsRequest(input *UpdateFindingsInput) (req *request.Request, output *UpdateFindingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFindings,
		HTTPMethod: "PATCH",
		HTTPPath:   "/findings",
	}

	if input == nil {
		input = &UpdateFindingsInput{}
	}

	output = &UpdateFindingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFindings API operation for AWS SecurityHub.
//
// UpdateFindings is deprecated. Instead of UpdateFindings, use BatchUpdateFindings.
//
// Updates the Note and RecordState of the Security Hub-aggregated findings
// that the filter attributes specify. Any member account that can view the
// finding also sees the update to the finding.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateFindings for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings
func (c *SecurityHub) UpdateFindings(input *UpdateFindingsInput) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	return out, req.Send()
}

// UpdateFindingsWithContext is the same as UpdateFindings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateFindingsWithContext(ctx aws.Context, input *UpdateFindingsInput, opts ...request.Option) (*UpdateFindingsOutput, error) {
	req, out := c.UpdateFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInsight = "UpdateInsight"

// UpdateInsightRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInsight for more information on using the UpdateInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInsightRequest method.
//    req, resp := client.UpdateInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsightRequest(input *UpdateInsightInput) (req *request.Request, output *UpdateInsightOutput) {
	op := &request.Operation{
		Name:       opUpdateInsight,
		HTTPMethod: "PATCH",
		HTTPPath:   "/insights/{InsightArn+}",
	}

	if input == nil {
		input = &UpdateInsightInput{}
	}

	output = &UpdateInsightOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInsight API operation for AWS SecurityHub.
//
// Updates the Security Hub insight identified by the specified insight ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateInsight for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight
func (c *SecurityHub) UpdateInsight(input *UpdateInsightInput) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	return out, req.Send()
}

// UpdateInsightWithContext is the same as UpdateInsight with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateInsightWithContext(ctx aws.Context, input *UpdateInsightInput, opts ...request.Option) (*UpdateInsightOutput, error) {
	req, out := c.UpdateInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOrganizationConfiguration = "UpdateOrganizationConfiguration"

// UpdateOrganizationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOrganizationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOrganizationConfiguration for more information on using the UpdateOrganizationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateOrganizationConfigurationRequest method.
//    req, resp := client.UpdateOrganizationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration
func (c *SecurityHub) UpdateOrganizationConfigurationRequest(input *UpdateOrganizationConfigurationInput) (req *request.Request, output *UpdateOrganizationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateOrganizationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/organization/configuration",
	}

	if input == nil {
		input = &UpdateOrganizationConfigurationInput{}
	}

	output = &UpdateOrganizationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOrganizationConfiguration API operation for AWS SecurityHub.
//
// Used to update the configuration related to Organizations. Can only be called
// from a Security Hub administrator account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateOrganizationConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration
func (c *SecurityHub) UpdateOrganizationConfiguration(input *UpdateOrganizationConfigurationInput) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateOrganizationConfigurationWithContext is the same as UpdateOrganizationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOrganizationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateOrganizationConfigurationWithContext(ctx aws.Context, input *UpdateOrganizationConfigurationInput, opts ...request.Option) (*UpdateOrganizationConfigurationOutput, error) {
	req, out := c.UpdateOrganizationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecurityHubConfiguration = "UpdateSecurityHubConfiguration"

// UpdateSecurityHubConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecurityHubConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecurityHubConfiguration for more information on using the UpdateSecurityHubConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSecurityHubConfigurationRequest method.
//    req, resp := client.UpdateSecurityHubConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration
func (c *SecurityHub) UpdateSecurityHubConfigurationRequest(input *UpdateSecurityHubConfigurationInput) (req *request.Request, output *UpdateSecurityHubConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateSecurityHubConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &UpdateSecurityHubConfigurationInput{}
	}

	output = &UpdateSecurityHubConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSecurityHubConfiguration API operation for AWS SecurityHub.
//
// Updates configuration options for Security Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateSecurityHubConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * LimitExceededException
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account or throttling limits. The error code describes the
//   limit exceeded.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration
func (c *SecurityHub) UpdateSecurityHubConfiguration(input *UpdateSecurityHubConfigurationInput) (*UpdateSecurityHubConfigurationOutput, error) {
	req, out := c.UpdateSecurityHubConfigurationRequest(input)
	return out, req.Send()
}

// UpdateSecurityHubConfigurationWithContext is the same as UpdateSecurityHubConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecurityHubConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateSecurityHubConfigurationWithContext(ctx aws.Context, input *UpdateSecurityHubConfigurationInput, opts ...request.Option) (*UpdateSecurityHubConfigurationOutput, error) {
	req, out := c.UpdateSecurityHubConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStandardsControl = "UpdateStandardsControl"

// UpdateStandardsControlRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStandardsControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStandardsControl for more information on using the UpdateStandardsControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStandardsControlRequest method.
//    req, resp := client.UpdateStandardsControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl
func (c *SecurityHub) UpdateStandardsControlRequest(input *UpdateStandardsControlInput) (req *request.Request, output *UpdateStandardsControlOutput) {
	op := &request.Operation{
		Name:       opUpdateStandardsControl,
		HTTPMethod: "PATCH",
		HTTPPath:   "/standards/control/{StandardsControlArn+}",
	}

	if input == nil {
		input = &UpdateStandardsControlInput{}
	}

	output = &UpdateStandardsControlOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateStandardsControl API operation for AWS SecurityHub.
//
// Used to control whether an individual security standard control is enabled
// or disabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS SecurityHub's
// API operation UpdateStandardsControl for usage and error information.
//
// Returned Error Types:
//   * InternalException
//   Internal server error.
//
//   * InvalidInputException
//   The request was rejected because you supplied an invalid or out-of-range
//   value for an input parameter.
//
//   * InvalidAccessException
//   There is an issue with the account used to make the request. Either Security
//   Hub is not enabled for the account, or the account does not have permission
//   to perform this action.
//
//   * ResourceNotFoundException
//   The request was rejected because we can't find the specified resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl
func (c *SecurityHub) UpdateStandardsControl(input *UpdateStandardsControlInput) (*UpdateStandardsControlOutput, error) {
	req, out := c.UpdateStandardsControlRequest(input)
	return out, req.Send()
}

// UpdateStandardsControlWithContext is the same as UpdateStandardsControl with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStandardsControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SecurityHub) UpdateStandardsControlWithContext(ctx aws.Context, input *UpdateStandardsControlInput, opts ...request.Option) (*UpdateStandardsControlOutput, error) {
	req, out := c.UpdateStandardsControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the invitation sent from the Security Hub master account.
	//
	// InvitationId is a required field
	InvitationId *string `type:"string" required:"true"`

	// The account ID of the Security Hub master account that sent the invitation.
	//
	// MasterId is a required field
	MasterId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInvitationInput"}
	if s.InvitationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvitationId"))
	}
	if s.MasterId == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvitationId sets the InvitationId field's value.
func (s *AcceptInvitationInput) SetInvitationId(v string) *AcceptInvitationInput {
	s.InvitationId = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *AcceptInvitationInput) SetMasterId(v string) *AcceptInvitationInput {
	s.MasterId = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// You don't have permission to perform the action specified in the request.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of an AWS account.
type AccountDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The email of an AWS account.
	Email *string `type:"string"`
}

// String returns the string representation
func (s AccountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountDetails"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AccountDetails) SetAccountId(v string) *AccountDetails {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *AccountDetails) SetEmail(v string) *AccountDetails {
	s.Email = &v
	return s
}

// An ActionTarget object.
type ActionTarget struct {
	_ struct{} `type:"structure"`

	// The ARN for the target action.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `type:"string" required:"true"`

	// The description of the target action.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the action target.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ActionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionTarget) GoString() string {
	return s.String()
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *ActionTarget) SetActionTargetArn(v string) *ActionTarget {
	s.ActionTargetArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ActionTarget) SetDescription(v string) *ActionTarget {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActionTarget) SetName(v string) *ActionTarget {
	s.Name = &v
	return s
}

// Represents a Security Hub administrator account designated by an organization
// management account.
type AdminAccount struct {
	_ struct{} `type:"structure"`

	// The AWS account identifier of the Security Hub administrator account.
	AccountId *string `type:"string"`

	// The current status of the Security Hub administrator account. Indicates whether
	// the account is currently enabled as a Security Hub administrator.
	Status *string `type:"string" enum:"AdminStatus"`
}

// String returns the string representation
func (s AdminAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AdminAccount) SetAccountId(v string) *AdminAccount {
	s.AccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdminAccount) SetStatus(v string) *AdminAccount {
	s.Status = &v
	return s
}

// Information about an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The ID of the subnet. You can specify one subnet per Availability Zone.
	SubnetId *string `type:"string"`

	// The name of the Availability Zone.
	ZoneName *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *AvailabilityZone) SetSubnetId(v string) *AvailabilityZone {
	s.SubnetId = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *AvailabilityZone) SetZoneName(v string) *AvailabilityZone {
	s.ZoneName = &v
	return s
}

// Contains information about settings for logging access for the stage.
type AwsApiGatewayAccessLogSettings struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Logs log group that receives the access logs.
	DestinationArn *string `type:"string"`

	// A single-line format of the access logs of data, as specified by selected
	// $context variables. The format must include at least $context.requestId.
	Format *string `type:"string"`
}

// String returns the string representation
func (s AwsApiGatewayAccessLogSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiGatewayAccessLogSettings) GoString() string {
	return s.String()
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *AwsApiGatewayAccessLogSettings) SetDestinationArn(v string) *AwsApiGatewayAccessLogSettings {
	s.DestinationArn = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *AwsApiGatewayAccessLogSettings) SetFormat(v string) *AwsApiGatewayAccessLogSettings {
	s.Format = &v
	return s
}

// Contains information about settings for canary deployment in the stage.
type AwsApiGatewayCanarySettings struct {
	_ struct{} `type:"structure"`

	// The deployment identifier for the canary deployment.
	DeploymentId *string `type:"string"`

	// The percentage of traffic that is diverted to a canary deployment.
	PercentTraffic *float64 `type:"double"`

	// Stage variables that are overridden in the canary release deployment. The
	// variables include new stage variables that are introduced in the canary.
	//
	// Each variable is represented as a string-to-string map between the stage
	// variable name and the variable value.
	StageVariableOverrides map[string]*string `type:"map"`

	// Indicates whether the canary deployment uses the stage cache.
	UseStageCache *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsApiGatewayCanarySettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiGatewayCanarySettings) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *AwsApiGatewayCanarySettings) SetDeploymentId(v string) *AwsApiGatewayCanarySettings {
	s.DeploymentId = &v
	return s
}

// SetPercentTraffic sets the PercentTraffic field's value.
func (s *AwsApiGatewayCanarySettings) SetPercentTraffic(v float64) *AwsApiGatewayCanarySettings {
	s.PercentTraffic = &v
	return s
}

// SetStageVariableOverrides sets the StageVariableOverrides field's value.
func (s *AwsApiGatewayCanarySettings) SetStageVariableOverrides(v map[string]*string) *AwsApiGatewayCanarySettings {
	s.StageVariableOverrides = v
	return s
}

// SetUseStageCache sets the UseStageCache field's value.
func (s *AwsApiGatewayCanarySettings) SetUseStageCache(v bool) *AwsApiGatewayCanarySettings {
	s.UseStageCache = &v
	return s
}

// Contains information about the endpoints for the API.
type AwsApiGatewayEndpointConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of endpoint types for the REST API.
	//
	// For an edge-optimized API, the endpoint type is EDGE. For a Regional API,
	// the endpoint type is REGIONAL. For a private API, the endpoint type is PRIVATE.
	Types []*string `type:"list"`
}

// String returns the string representation
func (s AwsApiGatewayEndpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiGatewayEndpointConfiguration) GoString() string {
	return s.String()
}

// SetTypes sets the Types field's value.
func (s *AwsApiGatewayEndpointConfiguration) SetTypes(v []*string) *AwsApiGatewayEndpointConfiguration {
	s.Types = v
	return s
}

// Defines settings for a method for the stage.
type AwsApiGatewayMethodSettings struct {
	_ struct{} `type:"structure"`

	// Indicates whether the cached responses are encrypted.
	CacheDataEncrypted *bool `type:"boolean"`

	// Specifies the time to live (TTL), in seconds, for cached responses. The higher
	// the TTL, the longer the response is cached.
	CacheTtlInSeconds *int64 `type:"integer"`

	// Indicates whether responses are cached and returned for requests. For responses
	// to be cached, a cache cluster must be enabled on the stage.
	CachingEnabled *bool `type:"boolean"`

	// Indicates whether data trace logging is enabled for the method. Data trace
	// logging affects the log entries that are pushed to CloudWatch Logs.
	DataTraceEnabled *bool `type:"boolean"`

	// The HTTP method. You can use an asterisk (*) as a wildcard to apply method
	// settings to multiple methods.
	HttpMethod *string `type:"string"`

	// The logging level for this method. The logging level affects the log entries
	// that are pushed to CloudWatch Logs.
	//
	// If the logging level is ERROR, then the logs only include error-level entries.
	//
	// If the logging level is INFO, then the logs include both ERROR events and
	// extra informational events.
	//
	// Valid values: OFF | ERROR | INFO
	LoggingLevel *string `type:"string"`

	// Indicates whether CloudWatch metrics are enabled for the method.
	MetricsEnabled *bool `type:"boolean"`

	// Indicates whether authorization is required for a cache invalidation request.
	RequireAuthorizationForCacheControl *bool `type:"boolean"`

	// The resource path for this method. Forward slashes (/) are encoded as ~1
	// . The initial slash must include a forward slash.
	//
	// For example, the path value /resource/subresource must be encoded as /~1resource~1subresource.
	//
	// To specify the root path, use only a slash (/). You can use an asterisk (*)
	// as a wildcard to apply method settings to multiple methods.
	ResourcePath *string `type:"string"`

	// The throttling burst limit for the method.
	ThrottlingBurstLimit *int64 `type:"integer"`

	// The throttling rate limit for the method.
	ThrottlingRateLimit *float64 `type:"double"`

	// Indicates how to handle unauthorized requests for cache invalidation.
	//
	// Valid values: FAIL_WITH_403 | SUCCEED_WITH_RESPONSE_HEADER | SUCCEED_WITHOUT_RESPONSE_HEADER
	UnauthorizedCacheControlHeaderStrategy *string `type:"string"`
}

// String returns the string representation
func (s AwsApiGatewayMethodSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiGatewayMethodSettings) GoString() string {
	return s.String()
}

// SetCacheDataEncrypted sets the CacheDataEncrypted field's value.
func (s *AwsApiGatewayMethodSettings) SetCacheDataEncrypted(v bool) *AwsApiGatewayMethodSettings {
	s.CacheDataEncrypted = &v
	return s
}

// SetCacheTtlInSeconds sets the CacheTtlInSeconds field's value.
func (s *AwsApiGatewayMethodSettings) SetCacheTtlInSeconds(v int64) *AwsApiGatewayMethodSettings {
	s.CacheTtlInSeconds = &v
	return s
}

// SetCachingEnabled sets the CachingEnabled field's value.
func (s *AwsApiGatewayMethodSettings) SetCachingEnabled(v bool) *AwsApiGatewayMethodSettings {
	s.CachingEnabled = &v
	return s
}

// SetDataTraceEnabled sets the DataTraceEnabled field's value.
func (s *AwsApiGatewayMethodSettings) SetDataTraceEnabled(v bool) *AwsApiGatewayMethodSettings {
	s.DataTraceEnabled = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *AwsApiGatewayMethodSettings) SetHttpMethod(v string) *AwsApiGatewayMethodSettings {
	s.HttpMethod = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *AwsApiGatewayMethodSettings) SetLoggingLevel(v string) *AwsApiGatewayMethodSettings {
	s.LoggingLevel = &v
	return s
}

// SetMetricsEnabled sets the MetricsEnabled field's value.
func (s *AwsApiGatewayMethodSettings) SetMetricsEnabled(v bool) *AwsApiGatewayMethodSettings {
	s.MetricsEnabled = &v
	return s
}

// SetRequireAuthorizationForCacheControl sets the RequireAuthorizationForCacheControl field's value.
func (s *AwsApiGatewayMethodSettings) SetRequireAuthorizationForCacheControl(v bool) *AwsApiGatewayMethodSettings {
	s.RequireAuthorizationForCacheControl = &v
	return s
}

// SetResourcePath sets the ResourcePath field's value.
func (s *AwsApiGatewayMethodSettings) SetResourcePath(v string) *AwsApiGatewayMethodSettings {
	s.ResourcePath = &v
	return s
}

// SetThrottlingBurstLimit sets the ThrottlingBurstLimit field's value.
func (s *AwsApiGatewayMethodSettings) SetThrottlingBurstLimit(v int64) *AwsApiGatewayMethodSettings {
	s.ThrottlingBurstLimit = &v
	return s
}

// SetThrottlingRateLimit sets the ThrottlingRateLimit field's value.
func (s *AwsApiGatewayMethodSettings) SetThrottlingRateLimit(v float64) *AwsApiGatewayMethodSettings {
	s.ThrottlingRateLimit = &v
	return s
}

// SetUnauthorizedCacheControlHeaderStrategy sets the UnauthorizedCacheControlHeaderStrategy field's value.
func (s *AwsApiGatewayMethodSettings) SetUnauthorizedCacheControlHeaderStrategy(v string) *AwsApiGatewayMethodSettings {
	s.UnauthorizedCacheControlHeaderStrategy = &v
	return s
}

// contains information about a REST API in version 1 of Amazon API Gateway.
type AwsApiGatewayRestApiDetails struct {
	_ struct{} `type:"structure"`

	// The source of the API key for metering requests according to a usage plan.
	//
	// HEADER indicates whether to read the API key from the X-API-Key header of
	// a request.
	//
	// AUTHORIZER indicates whether to read the API key from the UsageIdentifierKey
	// from a custom authorizer.
	ApiKeySource *string `type:"string"`

	// The list of binary media types supported by the REST API.
	BinaryMediaTypes []*string `type:"list"`

	// Indicates when the API was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// A description of the REST API.
	Description *string `type:"string"`

	// The endpoint configuration of the REST API.
	EndpointConfiguration *AwsApiGatewayEndpointConfiguration `type:"structure"`

	// The identifier of the REST API.
	Id *string `type:"string"`

	// The minimum size in bytes of a payload before compression is enabled.
	//
	// If null, then compression is disabled.
	//
	// If 0, then all payloads are compressed.
	MinimumCompressionSize *int64 `type:"integer"`

	// The name of the REST API.
	Name *string `type:"string"`

	// The version identifier for the REST API.
	Version *string `type:"string"`
}

// String returns the string representation
func (s AwsApiGatewayRestApiDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiGatewayRestApiDetails) GoString() string {
	return s.String()
}

// SetApiKeySource sets the ApiKeySource field's value.
func (s *AwsApiGatewayRestApiDetails) SetApiKeySource(v string) *AwsApiGatewayRestApiDetails {
	s.ApiKeySource = &v
	return s
}

// SetBinaryMediaTypes sets the BinaryMediaTypes field's value.
func (s *AwsApiGatewayRestApiDetails) SetBinaryMediaTypes(v []*string) *AwsApiGatewayRestApiDetails {
	s.BinaryMediaTypes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayRestApiDetails) SetCreatedDate(v string) *AwsApiGatewayRestApiDetails {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayRestApiDetails) SetDescription(v string) *AwsApiGatewayRestApiDetails {
	s.Description = &v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *AwsApiGatewayRestApiDetails) SetEndpointConfiguration(v *AwsApiGatewayEndpointConfiguration) *AwsApiGatewayRestApiDetails {
	s.EndpointConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *AwsApiGatewayRestApiDetails) SetId(v string) *AwsApiGatewayRestApiDetails {
	s.Id = &v
	return s
}

// SetMinimumCompressionSize sets the MinimumCompressionSize field's value.
func (s *AwsApiGatewayRestApiDetails) SetMinimumCompressionSize(v int64) *AwsApiGatewayRestApiDetails {
	s.MinimumCompressionSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsApiGatewayRestApiDetails) SetName(v string) *AwsApiGatewayRestApiDetails {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsApiGatewayRestApiDetails) SetVersion(v string) *AwsApiGatewayRestApiDetails {
	s.Version = &v
	return s
}

// Provides information about a version 1 Amazon API Gateway stage.
type AwsApiGatewayStageDetails struct {
	_ struct{} `type:"structure"`

	// Settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings `type:"structure"`

	// Indicates whether a cache cluster is enabled for the stage.
	CacheClusterEnabled *bool `type:"boolean"`

	// If a cache cluster is enabled, the size of the cache cluster.
	CacheClusterSize *string `type:"string"`

	// If a cache cluster is enabled, the status of the cache cluster.
	CacheClusterStatus *string `type:"string"`

	// Information about settings for canary deployment in the stage.
	CanarySettings *AwsApiGatewayCanarySettings `type:"structure"`

	// The identifier of the client certificate for the stage.
	ClientCertificateId *string `type:"string"`

	// Indicates when the stage was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// The identifier of the deployment that the stage points to.
	DeploymentId *string `type:"string"`

	// A description of the stage.
	Description *string `type:"string"`

	// The version of the API documentation that is associated with the stage.
	DocumentationVersion *string `type:"string"`

	// Indicates when the stage was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastUpdatedDate *string `type:"string"`

	// Defines the method settings for the stage.
	MethodSettings []*AwsApiGatewayMethodSettings `type:"list"`

	// The name of the stage.
	StageName *string `type:"string"`

	// Indicates whether active tracing with AWS X-Ray is enabled for the stage.
	TracingEnabled *bool `type:"boolean"`

	// A map that defines the stage variables for the stage.
	//
	// Variable names can have alphanumeric and underscore characters.
	//
	// Variable values can contain the following characters:
	//
	//    * Uppercase and lowercase letters
	//
	//    * Numbers
	//
	//    * Special characters -._~:/?#&=,
	Variables map[string]*string `type:"map"`

	// The ARN of the web ACL associated with the stage.
	WebAclArn *string `type:"string"`
}

// String returns the string representation
func (s AwsApiGatewayStageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiGatewayStageDetails) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *AwsApiGatewayStageDetails) SetAccessLogSettings(v *AwsApiGatewayAccessLogSettings) *AwsApiGatewayStageDetails {
	s.AccessLogSettings = v
	return s
}

// SetCacheClusterEnabled sets the CacheClusterEnabled field's value.
func (s *AwsApiGatewayStageDetails) SetCacheClusterEnabled(v bool) *AwsApiGatewayStageDetails {
	s.CacheClusterEnabled = &v
	return s
}

// SetCacheClusterSize sets the CacheClusterSize field's value.
func (s *AwsApiGatewayStageDetails) SetCacheClusterSize(v string) *AwsApiGatewayStageDetails {
	s.CacheClusterSize = &v
	return s
}

// SetCacheClusterStatus sets the CacheClusterStatus field's value.
func (s *AwsApiGatewayStageDetails) SetCacheClusterStatus(v string) *AwsApiGatewayStageDetails {
	s.CacheClusterStatus = &v
	return s
}

// SetCanarySettings sets the CanarySettings field's value.
func (s *AwsApiGatewayStageDetails) SetCanarySettings(v *AwsApiGatewayCanarySettings) *AwsApiGatewayStageDetails {
	s.CanarySettings = v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *AwsApiGatewayStageDetails) SetClientCertificateId(v string) *AwsApiGatewayStageDetails {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayStageDetails) SetCreatedDate(v string) *AwsApiGatewayStageDetails {
	s.CreatedDate = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *AwsApiGatewayStageDetails) SetDeploymentId(v string) *AwsApiGatewayStageDetails {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayStageDetails) SetDescription(v string) *AwsApiGatewayStageDetails {
	s.Description = &v
	return s
}

// SetDocumentationVersion sets the DocumentationVersion field's value.
func (s *AwsApiGatewayStageDetails) SetDocumentationVersion(v string) *AwsApiGatewayStageDetails {
	s.DocumentationVersion = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *AwsApiGatewayStageDetails) SetLastUpdatedDate(v string) *AwsApiGatewayStageDetails {
	s.LastUpdatedDate = &v
	return s
}

// SetMethodSettings sets the MethodSettings field's value.
func (s *AwsApiGatewayStageDetails) SetMethodSettings(v []*AwsApiGatewayMethodSettings) *AwsApiGatewayStageDetails {
	s.MethodSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *AwsApiGatewayStageDetails) SetStageName(v string) *AwsApiGatewayStageDetails {
	s.StageName = &v
	return s
}

// SetTracingEnabled sets the TracingEnabled field's value.
func (s *AwsApiGatewayStageDetails) SetTracingEnabled(v bool) *AwsApiGatewayStageDetails {
	s.TracingEnabled = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *AwsApiGatewayStageDetails) SetVariables(v map[string]*string) *AwsApiGatewayStageDetails {
	s.Variables = v
	return s
}

// SetWebAclArn sets the WebAclArn field's value.
func (s *AwsApiGatewayStageDetails) SetWebAclArn(v string) *AwsApiGatewayStageDetails {
	s.WebAclArn = &v
	return s
}

// Contains information about a version 2 API in Amazon API Gateway.
type AwsApiGatewayV2ApiDetails struct {
	_ struct{} `type:"structure"`

	// The URI of the API.
	//
	// Uses the format <api-id>.execute-api.<region>.amazonaws.com
	//
	// The stage name is typically appended to the URI to form a complete path to
	// a deployed API stage.
	ApiEndpoint *string `type:"string"`

	// The identifier of the API.
	ApiId *string `type:"string"`

	// An API key selection expression. Supported only for WebSocket APIs.
	ApiKeySelectionExpression *string `type:"string"`

	// A cross-origin resource sharing (CORS) configuration. Supported only for
	// HTTP APIs.
	CorsConfiguration *AwsCorsConfiguration `type:"structure"`

	// Indicates when the API was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// A description of the API.
	Description *string `type:"string"`

	// The name of the API.
	Name *string `type:"string"`

	// The API protocol for the API.
	//
	// Valid values: WEBSOCKET | HTTP
	ProtocolType *string `type:"string"`

	// The route selection expression for the API.
	//
	// For HTTP APIs, must be ${request.method} ${request.path}. This is the default
	// value for HTTP APIs.
	//
	// For WebSocket APIs, there is no default value.
	RouteSelectionExpression *string `type:"string"`

	// The version identifier for the API.
	Version *string `type:"string"`
}

// String returns the string representation
func (s AwsApiGatewayV2ApiDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiGatewayV2ApiDetails) GoString() string {
	return s.String()
}

// SetApiEndpoint sets the ApiEndpoint field's value.
func (s *AwsApiGatewayV2ApiDetails) SetApiEndpoint(v string) *AwsApiGatewayV2ApiDetails {
	s.ApiEndpoint = &v
	return s
}

// SetApiId sets the ApiId field's value.
func (s *AwsApiGatewayV2ApiDetails) SetApiId(v string) *AwsApiGatewayV2ApiDetails {
	s.ApiId = &v
	return s
}

// SetApiKeySelectionExpression sets the ApiKeySelectionExpression field's value.
func (s *AwsApiGatewayV2ApiDetails) SetApiKeySelectionExpression(v string) *AwsApiGatewayV2ApiDetails {
	s.ApiKeySelectionExpression = &v
	return s
}

// SetCorsConfiguration sets the CorsConfiguration field's value.
func (s *AwsApiGatewayV2ApiDetails) SetCorsConfiguration(v *AwsCorsConfiguration) *AwsApiGatewayV2ApiDetails {
	s.CorsConfiguration = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayV2ApiDetails) SetCreatedDate(v string) *AwsApiGatewayV2ApiDetails {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayV2ApiDetails) SetDescription(v string) *AwsApiGatewayV2ApiDetails {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsApiGatewayV2ApiDetails) SetName(v string) *AwsApiGatewayV2ApiDetails {
	s.Name = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *AwsApiGatewayV2ApiDetails) SetProtocolType(v string) *AwsApiGatewayV2ApiDetails {
	s.ProtocolType = &v
	return s
}

// SetRouteSelectionExpression sets the RouteSelectionExpression field's value.
func (s *AwsApiGatewayV2ApiDetails) SetRouteSelectionExpression(v string) *AwsApiGatewayV2ApiDetails {
	s.RouteSelectionExpression = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsApiGatewayV2ApiDetails) SetVersion(v string) *AwsApiGatewayV2ApiDetails {
	s.Version = &v
	return s
}

// Contains route settings for a stage.
type AwsApiGatewayV2RouteSettings struct {
	_ struct{} `type:"structure"`

	// Indicates whether data trace logging is enabled. Data trace logging affects
	// the log entries that are pushed to CloudWatch Logs. Supported only for WebSocket
	// APIs.
	DataTraceEnabled *bool `type:"boolean"`

	// Indicates whether detailed metrics are enabled.
	DetailedMetricsEnabled *bool `type:"boolean"`

	// The logging level. The logging level affects the log entries that are pushed
	// to CloudWatch Logs. Supported only for WebSocket APIs.
	//
	// If the logging level is ERROR, then the logs only include error-level entries.
	//
	// If the logging level is INFO, then the logs include both ERROR events and
	// extra informational events.
	//
	// Valid values: OFF | ERROR | INFO
	LoggingLevel *string `type:"string"`

	// The throttling burst limit.
	ThrottlingBurstLimit *int64 `type:"integer"`

	// The throttling rate limit.
	ThrottlingRateLimit *float64 `type:"double"`
}

// String returns the string representation
func (s AwsApiGatewayV2RouteSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiGatewayV2RouteSettings) GoString() string {
	return s.String()
}

// SetDataTraceEnabled sets the DataTraceEnabled field's value.
func (s *AwsApiGatewayV2RouteSettings) SetDataTraceEnabled(v bool) *AwsApiGatewayV2RouteSettings {
	s.DataTraceEnabled = &v
	return s
}

// SetDetailedMetricsEnabled sets the DetailedMetricsEnabled field's value.
func (s *AwsApiGatewayV2RouteSettings) SetDetailedMetricsEnabled(v bool) *AwsApiGatewayV2RouteSettings {
	s.DetailedMetricsEnabled = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *AwsApiGatewayV2RouteSettings) SetLoggingLevel(v string) *AwsApiGatewayV2RouteSettings {
	s.LoggingLevel = &v
	return s
}

// SetThrottlingBurstLimit sets the ThrottlingBurstLimit field's value.
func (s *AwsApiGatewayV2RouteSettings) SetThrottlingBurstLimit(v int64) *AwsApiGatewayV2RouteSettings {
	s.ThrottlingBurstLimit = &v
	return s
}

// SetThrottlingRateLimit sets the ThrottlingRateLimit field's value.
func (s *AwsApiGatewayV2RouteSettings) SetThrottlingRateLimit(v float64) *AwsApiGatewayV2RouteSettings {
	s.ThrottlingRateLimit = &v
	return s
}

// Contains information about a version 2 stage for Amazon API Gateway.
type AwsApiGatewayV2StageDetails struct {
	_ struct{} `type:"structure"`

	// Information about settings for logging access for the stage.
	AccessLogSettings *AwsApiGatewayAccessLogSettings `type:"structure"`

	// Indicates whether the stage is managed by API Gateway.
	ApiGatewayManaged *bool `type:"boolean"`

	// Indicates whether updates to an API automatically trigger a new deployment.
	AutoDeploy *bool `type:"boolean"`

	// Indicates when the stage was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// Default route settings for the stage.
	DefaultRouteSettings *AwsApiGatewayV2RouteSettings `type:"structure"`

	// The identifier of the deployment that the stage is associated with.
	DeploymentId *string `type:"string"`

	// The description of the stage.
	Description *string `type:"string"`

	// The status of the last deployment of a stage. Supported only if the stage
	// has automatic deployment enabled.
	LastDeploymentStatusMessage *string `type:"string"`

	// Indicates when the stage was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastUpdatedDate *string `type:"string"`

	// The route settings for the stage.
	RouteSettings *AwsApiGatewayV2RouteSettings `type:"structure"`

	// The name of the stage.
	StageName *string `type:"string"`

	// A map that defines the stage variables for the stage.
	//
	// Variable names can have alphanumeric and underscore characters.
	//
	// Variable values can contain the following characters:
	//
	//    * Uppercase and lowercase letters
	//
	//    * Numbers
	//
	//    * Special characters -._~:/?#&=,
	StageVariables map[string]*string `type:"map"`
}

// String returns the string representation
func (s AwsApiGatewayV2StageDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsApiGatewayV2StageDetails) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *AwsApiGatewayV2StageDetails) SetAccessLogSettings(v *AwsApiGatewayAccessLogSettings) *AwsApiGatewayV2StageDetails {
	s.AccessLogSettings = v
	return s
}

// SetApiGatewayManaged sets the ApiGatewayManaged field's value.
func (s *AwsApiGatewayV2StageDetails) SetApiGatewayManaged(v bool) *AwsApiGatewayV2StageDetails {
	s.ApiGatewayManaged = &v
	return s
}

// SetAutoDeploy sets the AutoDeploy field's value.
func (s *AwsApiGatewayV2StageDetails) SetAutoDeploy(v bool) *AwsApiGatewayV2StageDetails {
	s.AutoDeploy = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsApiGatewayV2StageDetails) SetCreatedDate(v string) *AwsApiGatewayV2StageDetails {
	s.CreatedDate = &v
	return s
}

// SetDefaultRouteSettings sets the DefaultRouteSettings field's value.
func (s *AwsApiGatewayV2StageDetails) SetDefaultRouteSettings(v *AwsApiGatewayV2RouteSettings) *AwsApiGatewayV2StageDetails {
	s.DefaultRouteSettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *AwsApiGatewayV2StageDetails) SetDeploymentId(v string) *AwsApiGatewayV2StageDetails {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsApiGatewayV2StageDetails) SetDescription(v string) *AwsApiGatewayV2StageDetails {
	s.Description = &v
	return s
}

// SetLastDeploymentStatusMessage sets the LastDeploymentStatusMessage field's value.
func (s *AwsApiGatewayV2StageDetails) SetLastDeploymentStatusMessage(v string) *AwsApiGatewayV2StageDetails {
	s.LastDeploymentStatusMessage = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *AwsApiGatewayV2StageDetails) SetLastUpdatedDate(v string) *AwsApiGatewayV2StageDetails {
	s.LastUpdatedDate = &v
	return s
}

// SetRouteSettings sets the RouteSettings field's value.
func (s *AwsApiGatewayV2StageDetails) SetRouteSettings(v *AwsApiGatewayV2RouteSettings) *AwsApiGatewayV2StageDetails {
	s.RouteSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *AwsApiGatewayV2StageDetails) SetStageName(v string) *AwsApiGatewayV2StageDetails {
	s.StageName = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *AwsApiGatewayV2StageDetails) SetStageVariables(v map[string]*string) *AwsApiGatewayV2StageDetails {
	s.StageVariables = v
	return s
}

// Provides details about an auto scaling group.
type AwsAutoScalingAutoScalingGroupDetails struct {
	_ struct{} `type:"structure"`

	// Indicates when the auto scaling group was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string `type:"string"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// it checks the health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks.
	HealthCheckType *string `type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `type:"string"`

	// The list of load balancers associated with the group.
	LoadBalancerNames []*string `type:"list"`
}

// String returns the string representation
func (s AwsAutoScalingAutoScalingGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsAutoScalingAutoScalingGroupDetails) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetCreatedTime(v string) *AwsAutoScalingAutoScalingGroupDetails {
	s.CreatedTime = &v
	return s
}

// SetHealthCheckGracePeriod sets the HealthCheckGracePeriod field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetHealthCheckGracePeriod(v int64) *AwsAutoScalingAutoScalingGroupDetails {
	s.HealthCheckGracePeriod = &v
	return s
}

// SetHealthCheckType sets the HealthCheckType field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetHealthCheckType(v string) *AwsAutoScalingAutoScalingGroupDetails {
	s.HealthCheckType = &v
	return s
}

// SetLaunchConfigurationName sets the LaunchConfigurationName field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetLaunchConfigurationName(v string) *AwsAutoScalingAutoScalingGroupDetails {
	s.LaunchConfigurationName = &v
	return s
}

// SetLoadBalancerNames sets the LoadBalancerNames field's value.
func (s *AwsAutoScalingAutoScalingGroupDetails) SetLoadBalancerNames(v []*string) *AwsAutoScalingAutoScalingGroupDetails {
	s.LoadBalancerNames = v
	return s
}

// Provides details about an AWS Certificate Manager certificate.
type AwsCertificateManagerCertificateDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the private certificate authority (CA) that will be used to issue
	// the certificate.
	CertificateAuthorityArn *string `type:"string"`

	// Indicates when the certificate was requested.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *string `type:"string"`

	// The fully qualified domain name (FQDN), such as www.example.com, that is
	// secured by the certificate.
	DomainName *string `type:"string"`

	// Contains information about the initial validation of each domain name that
	// occurs as a result of the RequestCertificate request.
	//
	// Only provided if the certificate type is AMAZON_ISSUED.
	DomainValidationOptions []*AwsCertificateManagerCertificateDomainValidationOption `type:"list"`

	// Contains a list of Extended Key Usage X.509 v3 extension objects. Each object
	// specifies a purpose for which the certificate public key can be used and
	// consists of a name and an object identifier (OID).
	ExtendedKeyUsages []*AwsCertificateManagerCertificateExtendedKeyUsage `type:"list"`

	// For a failed certificate request, the reason for the failure.
	//
	// Valid values: NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED |
	// DOMAIN_NOT_ALLOWED | INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED | CAA_ERROR
	// | PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE | PCA_REQUEST_FAILED
	// | PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND | PCA_INVALID_ARGS
	// | PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND | OTHER
	FailureReason *string `type:"string"`

	// Indicates when the certificate was imported. Provided if the certificate
	// type is IMPORTED.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ImportedAt *string `type:"string"`

	// The list of ARNs for the AWS resources that use the certificate.
	InUseBy []*string `type:"list"`

	// Indicates when the certificate was issued. Provided if the certificate type
	// is AMAZON_ISSUED.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	IssuedAt *string `type:"string"`

	// The name of the certificate authority that issued and signed the certificate.
	Issuer *string `type:"string"`

	// The algorithm that was used to generate the public-private key pair.
	//
	// Valid values: RSA_2048 | RSA_1024 |RSA_4096 | EC_prime256v1 | EC_secp384r1
	// | EC_secp521r1
	KeyAlgorithm *string `type:"string"`

	// A list of key usage X.509 v3 extension objects.
	KeyUsages []*AwsCertificateManagerCertificateKeyUsage `type:"list"`

	// The time after which the certificate becomes invalid.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	NotAfter *string `type:"string"`

	// The time before which the certificate is not valid.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	NotBefore *string `type:"string"`

	// Provides a value that specifies whether to add the certificate to a transparency
	// log.
	Options *AwsCertificateManagerCertificateOptions `type:"structure"`

	// Whether the certificate is eligible for renewal.
	//
	// Valid values: ELIGIBLE | INELIGIBLE
	RenewalEligibility *string `type:"string"`

	// Information about the status of the AWS Certificate Manager managed renewal
	// for the certificate. Provided only when the certificate type is AMAZON_ISSUED.
	RenewalSummary *AwsCertificateManagerCertificateRenewalSummary `type:"structure"`

	// The serial number of the certificate.
	Serial *string `type:"string"`

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string `type:"string"`

	// The status of the certificate.
	//
	// Valid values: PENDING_VALIDATION | ISSUED | INACTIVE | EXPIRED | VALIDATION_TIMED_OUT
	// | REVOKED | FAILED
	Status *string `type:"string"`

	// The name of the entity that is associated with the public key contained in
	// the certificate.
	Subject *string `type:"string"`

	// One or more domain names (subject alternative names) included in the certificate.
	// This list contains the domain names that are bound to the public key that
	// is contained in the certificate.
	//
	// The subject alternative names include the canonical domain name (CN) of the
	// certificate and additional domain names that can be used to connect to the
	// website.
	SubjectAlternativeNames []*string `type:"list"`

	// The source of the certificate. For certificates that AWS Certificate Manager
	// provides, Type is AMAZON_ISSUED. For certificates that are imported with
	// ImportCertificate, Type is IMPORTED.
	//
	// Valid values: IMPORTED | AMAZON_ISSUED | PRIVATE
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsCertificateManagerCertificateDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCertificateManagerCertificateDetails) GoString() string {
	return s.String()
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *AwsCertificateManagerCertificateDetails) SetCertificateAuthorityArn(v string) *AwsCertificateManagerCertificateDetails {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsCertificateManagerCertificateDetails) SetCreatedAt(v string) *AwsCertificateManagerCertificateDetails {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCertificateManagerCertificateDetails) SetDomainName(v string) *AwsCertificateManagerCertificateDetails {
	s.DomainName = &v
	return s
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *AwsCertificateManagerCertificateDetails) SetDomainValidationOptions(v []*AwsCertificateManagerCertificateDomainValidationOption) *AwsCertificateManagerCertificateDetails {
	s.DomainValidationOptions = v
	return s
}

// SetExtendedKeyUsages sets the ExtendedKeyUsages field's value.
func (s *AwsCertificateManagerCertificateDetails) SetExtendedKeyUsages(v []*AwsCertificateManagerCertificateExtendedKeyUsage) *AwsCertificateManagerCertificateDetails {
	s.ExtendedKeyUsages = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *AwsCertificateManagerCertificateDetails) SetFailureReason(v string) *AwsCertificateManagerCertificateDetails {
	s.FailureReason = &v
	return s
}

// SetImportedAt sets the ImportedAt field's value.
func (s *AwsCertificateManagerCertificateDetails) SetImportedAt(v string) *AwsCertificateManagerCertificateDetails {
	s.ImportedAt = &v
	return s
}

// SetInUseBy sets the InUseBy field's value.
func (s *AwsCertificateManagerCertificateDetails) SetInUseBy(v []*string) *AwsCertificateManagerCertificateDetails {
	s.InUseBy = v
	return s
}

// SetIssuedAt sets the IssuedAt field's value.
func (s *AwsCertificateManagerCertificateDetails) SetIssuedAt(v string) *AwsCertificateManagerCertificateDetails {
	s.IssuedAt = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *AwsCertificateManagerCertificateDetails) SetIssuer(v string) *AwsCertificateManagerCertificateDetails {
	s.Issuer = &v
	return s
}

// SetKeyAlgorithm sets the KeyAlgorithm field's value.
func (s *AwsCertificateManagerCertificateDetails) SetKeyAlgorithm(v string) *AwsCertificateManagerCertificateDetails {
	s.KeyAlgorithm = &v
	return s
}

// SetKeyUsages sets the KeyUsages field's value.
func (s *AwsCertificateManagerCertificateDetails) SetKeyUsages(v []*AwsCertificateManagerCertificateKeyUsage) *AwsCertificateManagerCertificateDetails {
	s.KeyUsages = v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *AwsCertificateManagerCertificateDetails) SetNotAfter(v string) *AwsCertificateManagerCertificateDetails {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *AwsCertificateManagerCertificateDetails) SetNotBefore(v string) *AwsCertificateManagerCertificateDetails {
	s.NotBefore = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *AwsCertificateManagerCertificateDetails) SetOptions(v *AwsCertificateManagerCertificateOptions) *AwsCertificateManagerCertificateDetails {
	s.Options = v
	return s
}

// SetRenewalEligibility sets the RenewalEligibility field's value.
func (s *AwsCertificateManagerCertificateDetails) SetRenewalEligibility(v string) *AwsCertificateManagerCertificateDetails {
	s.RenewalEligibility = &v
	return s
}

// SetRenewalSummary sets the RenewalSummary field's value.
func (s *AwsCertificateManagerCertificateDetails) SetRenewalSummary(v *AwsCertificateManagerCertificateRenewalSummary) *AwsCertificateManagerCertificateDetails {
	s.RenewalSummary = v
	return s
}

// SetSerial sets the Serial field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSerial(v string) *AwsCertificateManagerCertificateDetails {
	s.Serial = &v
	return s
}

// SetSignatureAlgorithm sets the SignatureAlgorithm field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSignatureAlgorithm(v string) *AwsCertificateManagerCertificateDetails {
	s.SignatureAlgorithm = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCertificateManagerCertificateDetails) SetStatus(v string) *AwsCertificateManagerCertificateDetails {
	s.Status = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSubject(v string) *AwsCertificateManagerCertificateDetails {
	s.Subject = &v
	return s
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *AwsCertificateManagerCertificateDetails) SetSubjectAlternativeNames(v []*string) *AwsCertificateManagerCertificateDetails {
	s.SubjectAlternativeNames = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCertificateManagerCertificateDetails) SetType(v string) *AwsCertificateManagerCertificateDetails {
	s.Type = &v
	return s
}

// Contains information about one of the following:
//
//    * The initial validation of each domain name that occurs as a result of
//    the RequestCertificate request
//
//    * The validation of each domain name in the certificate, as it pertains
//    to AWS Certificate Manager managed renewal
type AwsCertificateManagerCertificateDomainValidationOption struct {
	_ struct{} `type:"structure"`

	// A fully qualified domain name (FQDN) in the certificate.
	DomainName *string `type:"string"`

	// The CNAME record that is added to the DNS database for domain validation.
	ResourceRecord *AwsCertificateManagerCertificateResourceRecord `type:"structure"`

	// The domain name that AWS Certificate Manager uses to send domain validation
	// emails.
	ValidationDomain *string `type:"string"`

	// A list of email addresses that AWS Certificate Manager uses to send domain
	// validation emails.
	ValidationEmails []*string `type:"list"`

	// The method used to validate the domain name.
	ValidationMethod *string `type:"string"`

	// The validation status of the domain name.
	ValidationStatus *string `type:"string"`
}

// String returns the string representation
func (s AwsCertificateManagerCertificateDomainValidationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCertificateManagerCertificateDomainValidationOption) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetDomainName(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.DomainName = &v
	return s
}

// SetResourceRecord sets the ResourceRecord field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetResourceRecord(v *AwsCertificateManagerCertificateResourceRecord) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ResourceRecord = v
	return s
}

// SetValidationDomain sets the ValidationDomain field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationDomain(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationDomain = &v
	return s
}

// SetValidationEmails sets the ValidationEmails field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationEmails(v []*string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationEmails = v
	return s
}

// SetValidationMethod sets the ValidationMethod field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationMethod(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationMethod = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *AwsCertificateManagerCertificateDomainValidationOption) SetValidationStatus(v string) *AwsCertificateManagerCertificateDomainValidationOption {
	s.ValidationStatus = &v
	return s
}

// Contains information about an extended key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateExtendedKeyUsage struct {
	_ struct{} `type:"structure"`

	// The name of an extension value. Indicates the purpose for which the certificate
	// public key can be used.
	Name *string `type:"string"`

	// An object identifier (OID) for the extension value.
	//
	// The format is numbers separated by periods.
	OId *string `type:"string"`
}

// String returns the string representation
func (s AwsCertificateManagerCertificateExtendedKeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCertificateManagerCertificateExtendedKeyUsage) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCertificateManagerCertificateExtendedKeyUsage) SetName(v string) *AwsCertificateManagerCertificateExtendedKeyUsage {
	s.Name = &v
	return s
}

// SetOId sets the OId field's value.
func (s *AwsCertificateManagerCertificateExtendedKeyUsage) SetOId(v string) *AwsCertificateManagerCertificateExtendedKeyUsage {
	s.OId = &v
	return s
}

// Contains information about a key usage X.509 v3 extension object.
type AwsCertificateManagerCertificateKeyUsage struct {
	_ struct{} `type:"structure"`

	// The key usage extension name.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AwsCertificateManagerCertificateKeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCertificateManagerCertificateKeyUsage) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCertificateManagerCertificateKeyUsage) SetName(v string) *AwsCertificateManagerCertificateKeyUsage {
	s.Name = &v
	return s
}

// Contains other options for the certificate.
type AwsCertificateManagerCertificateOptions struct {
	_ struct{} `type:"structure"`

	// Whether to add the certificate to a transparency log.
	//
	// Valid values: DISABLED | ENABLED
	CertificateTransparencyLoggingPreference *string `type:"string"`
}

// String returns the string representation
func (s AwsCertificateManagerCertificateOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCertificateManagerCertificateOptions) GoString() string {
	return s.String()
}

// SetCertificateTransparencyLoggingPreference sets the CertificateTransparencyLoggingPreference field's value.
func (s *AwsCertificateManagerCertificateOptions) SetCertificateTransparencyLoggingPreference(v string) *AwsCertificateManagerCertificateOptions {
	s.CertificateTransparencyLoggingPreference = &v
	return s
}

// Contains information about the AWS Certificate Manager managed renewal for
// an AMAZON_ISSUED certificate.
type AwsCertificateManagerCertificateRenewalSummary struct {
	_ struct{} `type:"structure"`

	// Information about the validation of each domain name in the certificate,
	// as it pertains to AWS Certificate Manager managed renewal. Provided only
	// when the certificate type is AMAZON_ISSUED.
	DomainValidationOptions []*AwsCertificateManagerCertificateDomainValidationOption `type:"list"`

	// The status of the AWS Certificate Manager managed renewal of the certificate.
	//
	// Valid values: PENDING_AUTO_RENEWAL | PENDING_VALIDATION | SUCCESS | FAILED
	RenewalStatus *string `type:"string"`

	// The reason that a renewal request was unsuccessful.
	//
	// Valid values: NO_AVAILABLE_CONTACTS | ADDITIONAL_VERIFICATION_REQUIRED |
	// DOMAIN_NOT_ALLOWED | INVALID_PUBLIC_DOMAIN | DOMAIN_VALIDATION_DENIED | CAA_ERROR
	// | PCA_LIMIT_EXCEEDED | PCA_INVALID_ARN | PCA_INVALID_STATE | PCA_REQUEST_FAILED
	// | PCA_NAME_CONSTRAINTS_VALIDATION | PCA_RESOURCE_NOT_FOUND | PCA_INVALID_ARGS
	// | PCA_INVALID_DURATION | PCA_ACCESS_DENIED | SLR_NOT_FOUND | OTHER
	RenewalStatusReason *string `type:"string"`

	// Indicates when the renewal summary was last updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	UpdatedAt *string `type:"string"`
}

// String returns the string representation
func (s AwsCertificateManagerCertificateRenewalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCertificateManagerCertificateRenewalSummary) GoString() string {
	return s.String()
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetDomainValidationOptions(v []*AwsCertificateManagerCertificateDomainValidationOption) *AwsCertificateManagerCertificateRenewalSummary {
	s.DomainValidationOptions = v
	return s
}

// SetRenewalStatus sets the RenewalStatus field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetRenewalStatus(v string) *AwsCertificateManagerCertificateRenewalSummary {
	s.RenewalStatus = &v
	return s
}

// SetRenewalStatusReason sets the RenewalStatusReason field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetRenewalStatusReason(v string) *AwsCertificateManagerCertificateRenewalSummary {
	s.RenewalStatusReason = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AwsCertificateManagerCertificateRenewalSummary) SetUpdatedAt(v string) *AwsCertificateManagerCertificateRenewalSummary {
	s.UpdatedAt = &v
	return s
}

// Provides details about the CNAME record that is added to the DNS database
// for domain validation.
type AwsCertificateManagerCertificateResourceRecord struct {
	_ struct{} `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`

	// The type of resource.
	Type *string `type:"string"`

	// The value of the resource.
	Value *string `type:"string"`
}

// String returns the string representation
func (s AwsCertificateManagerCertificateResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCertificateManagerCertificateResourceRecord) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsCertificateManagerCertificateResourceRecord) SetName(v string) *AwsCertificateManagerCertificateResourceRecord {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCertificateManagerCertificateResourceRecord) SetType(v string) *AwsCertificateManagerCertificateResourceRecord {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsCertificateManagerCertificateResourceRecord) SetValue(v string) *AwsCertificateManagerCertificateResourceRecord {
	s.Value = &v
	return s
}

// Information about a cache behavior for the distribution.
type AwsCloudFrontDistributionCacheBehavior struct {
	_ struct{} `type:"structure"`

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	//    * allow-all - Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https - CloudFront responds to HTTP requests with an HTTP
	//    status code of 301 (Moved Permanently) and the HTTPS URL. The viewer then
	//    uses the new URL to resubmit.
	//
	//    * https-only - CloudFront responds to HTTP request with an HTTP status
	//    code of 403 (Forbidden).
	ViewerProtocolPolicy *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionCacheBehavior) GoString() string {
	return s.String()
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *AwsCloudFrontDistributionCacheBehavior) SetViewerProtocolPolicy(v string) *AwsCloudFrontDistributionCacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

// Provides information about caching for the distribution.
type AwsCloudFrontDistributionCacheBehaviors struct {
	_ struct{} `type:"structure"`

	// The cache behaviors for the distribution.
	Items []*AwsCloudFrontDistributionCacheBehavior `type:"list"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionCacheBehaviors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionCacheBehaviors) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionCacheBehaviors) SetItems(v []*AwsCloudFrontDistributionCacheBehavior) *AwsCloudFrontDistributionCacheBehaviors {
	s.Items = v
	return s
}

// Contains information about the default cache configuration for the distribution.
type AwsCloudFrontDistributionDefaultCacheBehavior struct {
	_ struct{} `type:"structure"`

	// The protocol that viewers can use to access the files in an origin. You can
	// specify the following options:
	//
	//    * allow-all - Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https - CloudFront responds to HTTP requests with an HTTP
	//    status code of 301 (Moved Permanently) and the HTTPS URL. The viewer then
	//    uses the new URL to resubmit.
	//
	//    * https-only - CloudFront responds to HTTP request with an HTTP status
	//    code of 403 (Forbidden).
	ViewerProtocolPolicy *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionDefaultCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionDefaultCacheBehavior) GoString() string {
	return s.String()
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *AwsCloudFrontDistributionDefaultCacheBehavior) SetViewerProtocolPolicy(v string) *AwsCloudFrontDistributionDefaultCacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

// A distribution configuration.
type AwsCloudFrontDistributionDetails struct {
	_ struct{} `type:"structure"`

	// Provides information about the cache configuration for the distribution.
	CacheBehaviors *AwsCloudFrontDistributionCacheBehaviors `type:"structure"`

	// The default cache behavior for the configuration.
	DefaultCacheBehavior *AwsCloudFrontDistributionDefaultCacheBehavior `type:"structure"`

	// The object that CloudFront sends in response to requests from the origin
	// (for example, index.html) when a viewer requests the root URL for the distribution
	// (http://www.example.com) instead of an object in your distribution (http://www.example.com/product-description.html).
	DefaultRootObject *string `type:"string"`

	// The domain name corresponding to the distribution.
	DomainName *string `type:"string"`

	// The entity tag is a hash of the object.
	ETag *string `type:"string"`

	// Indicates when that the distribution was last modified.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastModifiedTime *string `type:"string"`

	// A complex type that controls whether access logs are written for the distribution.
	Logging *AwsCloudFrontDistributionLogging `type:"structure"`

	// Provides information about the origin groups in the distribution.
	OriginGroups *AwsCloudFrontDistributionOriginGroups `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	Origins *AwsCloudFrontDistributionOrigins `type:"structure"`

	// Indicates the current status of the distribution.
	Status *string `type:"string"`

	// A unique identifier that specifies the AWS WAF web ACL, if any, to associate
	// with this distribution.
	WebAclId *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionDetails) GoString() string {
	return s.String()
}

// SetCacheBehaviors sets the CacheBehaviors field's value.
func (s *AwsCloudFrontDistributionDetails) SetCacheBehaviors(v *AwsCloudFrontDistributionCacheBehaviors) *AwsCloudFrontDistributionDetails {
	s.CacheBehaviors = v
	return s
}

// SetDefaultCacheBehavior sets the DefaultCacheBehavior field's value.
func (s *AwsCloudFrontDistributionDetails) SetDefaultCacheBehavior(v *AwsCloudFrontDistributionDefaultCacheBehavior) *AwsCloudFrontDistributionDetails {
	s.DefaultCacheBehavior = v
	return s
}

// SetDefaultRootObject sets the DefaultRootObject field's value.
func (s *AwsCloudFrontDistributionDetails) SetDefaultRootObject(v string) *AwsCloudFrontDistributionDetails {
	s.DefaultRootObject = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCloudFrontDistributionDetails) SetDomainName(v string) *AwsCloudFrontDistributionDetails {
	s.DomainName = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *AwsCloudFrontDistributionDetails) SetETag(v string) *AwsCloudFrontDistributionDetails {
	s.ETag = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *AwsCloudFrontDistributionDetails) SetLastModifiedTime(v string) *AwsCloudFrontDistributionDetails {
	s.LastModifiedTime = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *AwsCloudFrontDistributionDetails) SetLogging(v *AwsCloudFrontDistributionLogging) *AwsCloudFrontDistributionDetails {
	s.Logging = v
	return s
}

// SetOriginGroups sets the OriginGroups field's value.
func (s *AwsCloudFrontDistributionDetails) SetOriginGroups(v *AwsCloudFrontDistributionOriginGroups) *AwsCloudFrontDistributionDetails {
	s.OriginGroups = v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *AwsCloudFrontDistributionDetails) SetOrigins(v *AwsCloudFrontDistributionOrigins) *AwsCloudFrontDistributionDetails {
	s.Origins = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsCloudFrontDistributionDetails) SetStatus(v string) *AwsCloudFrontDistributionDetails {
	s.Status = &v
	return s
}

// SetWebAclId sets the WebAclId field's value.
func (s *AwsCloudFrontDistributionDetails) SetWebAclId(v string) *AwsCloudFrontDistributionDetails {
	s.WebAclId = &v
	return s
}

// A complex type that controls whether access logs are written for the distribution.
type AwsCloudFrontDistributionLogging struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in.
	Bucket *string `type:"string"`

	// With this field, you can enable or disable the selected distribution.
	Enabled *bool `type:"boolean"`

	// Specifies whether you want CloudFront to include cookies in access logs.
	IncludeCookies *bool `type:"boolean"`

	// An optional string that you want CloudFront to use as a prefix to the access
	// log filenames for this distribution.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionLogging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionLogging) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *AwsCloudFrontDistributionLogging) SetBucket(v string) *AwsCloudFrontDistributionLogging {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AwsCloudFrontDistributionLogging) SetEnabled(v bool) *AwsCloudFrontDistributionLogging {
	s.Enabled = &v
	return s
}

// SetIncludeCookies sets the IncludeCookies field's value.
func (s *AwsCloudFrontDistributionLogging) SetIncludeCookies(v bool) *AwsCloudFrontDistributionLogging {
	s.IncludeCookies = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *AwsCloudFrontDistributionLogging) SetPrefix(v string) *AwsCloudFrontDistributionLogging {
	s.Prefix = &v
	return s
}

// Information about an origin group for the distribution.
type AwsCloudFrontDistributionOriginGroup struct {
	_ struct{} `type:"structure"`

	// Provides the criteria for an origin group to fail over.
	FailoverCriteria *AwsCloudFrontDistributionOriginGroupFailover `type:"structure"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOriginGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionOriginGroup) GoString() string {
	return s.String()
}

// SetFailoverCriteria sets the FailoverCriteria field's value.
func (s *AwsCloudFrontDistributionOriginGroup) SetFailoverCriteria(v *AwsCloudFrontDistributionOriginGroupFailover) *AwsCloudFrontDistributionOriginGroup {
	s.FailoverCriteria = v
	return s
}

// Provides information about when an origin group fails over.
type AwsCloudFrontDistributionOriginGroupFailover struct {
	_ struct{} `type:"structure"`

	// Information about the status codes that cause an origin group to fail over.
	StatusCodes *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes `type:"structure"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOriginGroupFailover) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionOriginGroupFailover) GoString() string {
	return s.String()
}

// SetStatusCodes sets the StatusCodes field's value.
func (s *AwsCloudFrontDistributionOriginGroupFailover) SetStatusCodes(v *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) *AwsCloudFrontDistributionOriginGroupFailover {
	s.StatusCodes = v
	return s
}

// The status codes that cause an origin group to fail over.
type AwsCloudFrontDistributionOriginGroupFailoverStatusCodes struct {
	_ struct{} `type:"structure"`

	// The list of status code values that can cause a failover to the next origin.
	Items []*int64 `type:"list"`

	// The number of status codes that can cause a failover.
	Quantity *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) SetItems(v []*int64) *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) SetQuantity(v int64) *AwsCloudFrontDistributionOriginGroupFailoverStatusCodes {
	s.Quantity = &v
	return s
}

// Provides information about origin groups that are associated with the distribution.
type AwsCloudFrontDistributionOriginGroups struct {
	_ struct{} `type:"structure"`

	// The list of origin groups.
	Items []*AwsCloudFrontDistributionOriginGroup `type:"list"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOriginGroups) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionOriginGroups) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOriginGroups) SetItems(v []*AwsCloudFrontDistributionOriginGroup) *AwsCloudFrontDistributionOriginGroups {
	s.Items = v
	return s
}

// A complex type that describes the Amazon S3 bucket, HTTP server (for example,
// a web server), Amazon Elemental MediaStore, or other server from which CloudFront
// gets your files.
type AwsCloudFrontDistributionOriginItem struct {
	_ struct{} `type:"structure"`

	// Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want
	// CloudFront to get objects for this origin.
	DomainName *string `type:"string"`

	// A unique identifier for the origin or origin group.
	Id *string `type:"string"`

	// An optional element that causes CloudFront to request your content from a
	// directory in your Amazon S3 bucket or your custom origin.
	OriginPath *string `type:"string"`

	// An origin that is an S3 bucket that is not configured with static website
	// hosting.
	S3OriginConfig *AwsCloudFrontDistributionOriginS3OriginConfig `type:"structure"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOriginItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionOriginItem) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetDomainName(v string) *AwsCloudFrontDistributionOriginItem {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetId(v string) *AwsCloudFrontDistributionOriginItem {
	s.Id = &v
	return s
}

// SetOriginPath sets the OriginPath field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetOriginPath(v string) *AwsCloudFrontDistributionOriginItem {
	s.OriginPath = &v
	return s
}

// SetS3OriginConfig sets the S3OriginConfig field's value.
func (s *AwsCloudFrontDistributionOriginItem) SetS3OriginConfig(v *AwsCloudFrontDistributionOriginS3OriginConfig) *AwsCloudFrontDistributionOriginItem {
	s.S3OriginConfig = v
	return s
}

// Information about an origin that is an S3 bucket that is not configured with
// static website hosting.
type AwsCloudFrontDistributionOriginS3OriginConfig struct {
	_ struct{} `type:"structure"`

	// The CloudFront origin access identity to associate with the origin.
	OriginAccessIdentity *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOriginS3OriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionOriginS3OriginConfig) GoString() string {
	return s.String()
}

// SetOriginAccessIdentity sets the OriginAccessIdentity field's value.
func (s *AwsCloudFrontDistributionOriginS3OriginConfig) SetOriginAccessIdentity(v string) *AwsCloudFrontDistributionOriginS3OriginConfig {
	s.OriginAccessIdentity = &v
	return s
}

// A complex type that contains information about origins and origin groups
// for this distribution.
type AwsCloudFrontDistributionOrigins struct {
	_ struct{} `type:"structure"`

	// A complex type that contains origins or origin groups for this distribution.
	Items []*AwsCloudFrontDistributionOriginItem `type:"list"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOrigins) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudFrontDistributionOrigins) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *AwsCloudFrontDistributionOrigins) SetItems(v []*AwsCloudFrontDistributionOriginItem) *AwsCloudFrontDistributionOrigins {
	s.Items = v
	return s
}

// Provides details about a CloudTrail trail.
type AwsCloudTrailTrailDetails struct {
	_ struct{} `type:"structure"`

	// The ARN of the log group that CloudTrail logs are delivered to.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// The ARN of the role that the CloudWatch Logs endpoint assumes when it writes
	// to the log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Indicates whether the trail has custom event selectors.
	HasCustomEventSelectors *bool `type:"boolean"`

	// The Region where the trail was created.
	HomeRegion *string `type:"string"`

	// Indicates whether the trail publishes events from global services such as
	// IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Indicates whether the trail applies only to the current Region or to all
	// Regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Whether the trail is created for all accounts in an organization in AWS Organizations,
	// or only for the current AWS account.
	IsOrganizationTrail *bool `type:"boolean"`

	// The AWS KMS key ID to use to encrypt the logs.
	KmsKeyId *string `type:"string"`

	// Indicates whether CloudTrail log file validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// The name of the trail.
	Name *string `type:"string"`

	// The name of the S3 bucket where the log files are published.
	S3BucketName *string `type:"string"`

	// The S3 key prefix. The key prefix is added after the name of the S3 bucket
	// where the log files are published.
	S3KeyPrefix *string `type:"string"`

	// The ARN of the SNS topic that is used for notifications of log file delivery.
	SnsTopicArn *string `type:"string"`

	// The name of the SNS topic that is used for notifications of log file delivery.
	SnsTopicName *string `type:"string"`

	// The ARN of the trail.
	TrailArn *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudTrailTrailDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCloudTrailTrailDetails) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *AwsCloudTrailTrailDetails) SetCloudWatchLogsLogGroupArn(v string) *AwsCloudTrailTrailDetails {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *AwsCloudTrailTrailDetails) SetCloudWatchLogsRoleArn(v string) *AwsCloudTrailTrailDetails {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetHasCustomEventSelectors sets the HasCustomEventSelectors field's value.
func (s *AwsCloudTrailTrailDetails) SetHasCustomEventSelectors(v bool) *AwsCloudTrailTrailDetails {
	s.HasCustomEventSelectors = &v
	return s
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *AwsCloudTrailTrailDetails) SetHomeRegion(v string) *AwsCloudTrailTrailDetails {
	s.HomeRegion = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *AwsCloudTrailTrailDetails) SetIncludeGlobalServiceEvents(v bool) *AwsCloudTrailTrailDetails {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *AwsCloudTrailTrailDetails) SetIsMultiRegionTrail(v bool) *AwsCloudTrailTrailDetails {
	s.IsMultiRegionTrail = &v
	return s
}

// SetIsOrganizationTrail sets the IsOrganizationTrail field's value.
func (s *AwsCloudTrailTrailDetails) SetIsOrganizationTrail(v bool) *AwsCloudTrailTrailDetails {
	s.IsOrganizationTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsCloudTrailTrailDetails) SetKmsKeyId(v string) *AwsCloudTrailTrailDetails {
	s.KmsKeyId = &v
	return s
}

// SetLogFileValidationEnabled sets the LogFileValidationEnabled field's value.
func (s *AwsCloudTrailTrailDetails) SetLogFileValidationEnabled(v bool) *AwsCloudTrailTrailDetails {
	s.LogFileValidationEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsCloudTrailTrailDetails) SetName(v string) *AwsCloudTrailTrailDetails {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *AwsCloudTrailTrailDetails) SetS3BucketName(v string) *AwsCloudTrailTrailDetails {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *AwsCloudTrailTrailDetails) SetS3KeyPrefix(v string) *AwsCloudTrailTrailDetails {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *AwsCloudTrailTrailDetails) SetSnsTopicArn(v string) *AwsCloudTrailTrailDetails {
	s.SnsTopicArn = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *AwsCloudTrailTrailDetails) SetSnsTopicName(v string) *AwsCloudTrailTrailDetails {
	s.SnsTopicName = &v
	return s
}

// SetTrailArn sets the TrailArn field's value.
func (s *AwsCloudTrailTrailDetails) SetTrailArn(v string) *AwsCloudTrailTrailDetails {
	s.TrailArn = &v
	return s
}

// Information about an AWS CodeBuild project.
type AwsCodeBuildProjectDetails struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) used to
	// encrypt the build output artifacts.
	//
	// You can specify either the Amazon Resource Name (ARN) of the CMK or, if available,
	// the CMK alias (using the format alias/alias-name).
	EncryptionKey *string `type:"string"`

	// Information about the build environment for this build project.
	Environment *AwsCodeBuildProjectEnvironment `type:"structure"`

	// The name of the build project.
	Name *string `type:"string"`

	// The ARN of the IAM role that enables AWS CodeBuild to interact with dependent
	// AWS services on behalf of the AWS account.
	ServiceRole *string `type:"string"`

	// Information about the build input source code for this build project.
	Source *AwsCodeBuildProjectSource `type:"structure"`

	// Information about the VPC configuration that AWS CodeBuild accesses.
	VpcConfig *AwsCodeBuildProjectVpcConfig `type:"structure"`
}

// String returns the string representation
func (s AwsCodeBuildProjectDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectDetails) GoString() string {
	return s.String()
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *AwsCodeBuildProjectDetails) SetEncryptionKey(v string) *AwsCodeBuildProjectDetails {
	s.EncryptionKey = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *AwsCodeBuildProjectDetails) SetEnvironment(v *AwsCodeBuildProjectEnvironment) *AwsCodeBuildProjectDetails {
	s.Environment = v
	return s
}

// SetName sets the Name field's value.
func (s *AwsCodeBuildProjectDetails) SetName(v string) *AwsCodeBuildProjectDetails {
	s.Name = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *AwsCodeBuildProjectDetails) SetServiceRole(v string) *AwsCodeBuildProjectDetails {
	s.ServiceRole = &v
	return s
}

// SetSource sets the Source field's value.
func (s *AwsCodeBuildProjectDetails) SetSource(v *AwsCodeBuildProjectSource) *AwsCodeBuildProjectDetails {
	s.Source = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *AwsCodeBuildProjectDetails) SetVpcConfig(v *AwsCodeBuildProjectVpcConfig) *AwsCodeBuildProjectDetails {
	s.VpcConfig = v
	return s
}

// Information about the build environment for this build project.
type AwsCodeBuildProjectEnvironment struct {
	_ struct{} `type:"structure"`

	// The certificate to use with this build project.
	Certificate *string `type:"string"`

	// The type of credentials AWS CodeBuild uses to pull images in your build.
	//
	// Valid values:
	//
	//    * CODEBUILD specifies that AWS CodeBuild uses its own credentials. This
	//    requires that you modify your ECR repository policy to trust the AWS CodeBuild
	//    service principal.
	//
	//    * SERVICE_ROLE specifies that AWS CodeBuild uses your build project's
	//    service role.
	//
	// When you use a cross-account or private registry image, you must use SERVICE_ROLE
	// credentials. When you use an AWS CodeBuild curated image, you must use CODEBUILD
	// credentials.
	ImagePullCredentialsType *string `type:"string"`

	// The credentials for access to a private registry.
	RegistryCredential *AwsCodeBuildProjectEnvironmentRegistryCredential `type:"structure"`

	// The type of build environment to use for related builds.
	//
	// The environment type ARM_CONTAINER is available only in Regions US East (N.
	// Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific
	// (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).
	//
	// The environment type LINUX_CONTAINER with compute type build.general1.2xlarge
	// is available only in Regions US East (N. Virginia), US East (N. Virginia),
	// US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
	// (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore),
	// Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
	//
	// The environment type LINUX_GPU_CONTAINER is available only in Regions US
	// East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central),
	// Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo),
	// Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China
	// (Beijing), and China (Ningxia).
	//
	// Valid values: WINDOWS_CONTAINER | LINUX_CONTAINER | LINUX_GPU_CONTAINER |
	// ARM_CONTAINER
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectEnvironment) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *AwsCodeBuildProjectEnvironment) SetCertificate(v string) *AwsCodeBuildProjectEnvironment {
	s.Certificate = &v
	return s
}

// SetImagePullCredentialsType sets the ImagePullCredentialsType field's value.
func (s *AwsCodeBuildProjectEnvironment) SetImagePullCredentialsType(v string) *AwsCodeBuildProjectEnvironment {
	s.ImagePullCredentialsType = &v
	return s
}

// SetRegistryCredential sets the RegistryCredential field's value.
func (s *AwsCodeBuildProjectEnvironment) SetRegistryCredential(v *AwsCodeBuildProjectEnvironmentRegistryCredential) *AwsCodeBuildProjectEnvironment {
	s.RegistryCredential = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectEnvironment) SetType(v string) *AwsCodeBuildProjectEnvironment {
	s.Type = &v
	return s
}

// The credentials for access to a private registry.
type AwsCodeBuildProjectEnvironmentRegistryCredential struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or name of credentials created using AWS Secrets
	// Manager.
	//
	// The credential can use the name of the credentials only if they exist in
	// your current AWS Region.
	Credential *string `type:"string"`

	// The service that created the credentials to access a private Docker registry.
	//
	// The valid value,SECRETS_MANAGER, is for AWS Secrets Manager.
	CredentialProvider *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *AwsCodeBuildProjectEnvironmentRegistryCredential) SetCredential(v string) *AwsCodeBuildProjectEnvironmentRegistryCredential {
	s.Credential = &v
	return s
}

// SetCredentialProvider sets the CredentialProvider field's value.
func (s *AwsCodeBuildProjectEnvironmentRegistryCredential) SetCredentialProvider(v string) *AwsCodeBuildProjectEnvironmentRegistryCredential {
	s.CredentialProvider = &v
	return s
}

// Information about the build input source code for this build project.
type AwsCodeBuildProjectSource struct {
	_ struct{} `type:"structure"`

	// Information about the Git clone depth for the build project.
	GitCloneDepth *int64 `type:"integer"`

	// Whether to ignore SSL warnings while connecting to the project source code.
	InsecureSsl *bool `type:"boolean"`

	// Information about the location of the source code to be built.
	//
	// Valid values include:
	//
	//    * For source code settings that are specified in the source action of
	//    a pipeline in AWS CodePipeline, location should not be specified. If it
	//    is specified, AWS CodePipeline ignores it. This is because AWS CodePipeline
	//    uses the settings in a pipeline's source action instead of this value.
	//
	//    * For source code in an AWS CodeCommit repository, the HTTPS clone URL
	//    to the repository that contains the source code and the build spec file
	//    (for example, https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name
	//    ).
	//
	//    * For source code in an S3 input bucket, one of the following. The path
	//    to the ZIP file that contains the source code (for example, bucket-name/path/to/object-name.zip).
	//    The path to the folder that contains the source code (for example, bucket-name/path/to/source-code/folder/).
	//
	//    * For source code in a GitHub repository, the HTTPS clone URL to the repository
	//    that contains the source and the build spec file.
	//
	//    * For source code in a Bitbucket repository, the HTTPS clone URL to the
	//    repository that contains the source and the build spec file.
	Location *string `type:"string"`

	// The type of repository that contains the source code to be built. Valid values
	// are:
	//
	//    * BITBUCKET - The source code is in a Bitbucket repository.
	//
	//    * CODECOMMIT - The source code is in an AWS CodeCommit repository.
	//
	//    * CODEPIPELINE - The source code settings are specified in the source
	//    action of a pipeline in AWS CodePipeline.
	//
	//    * GITHUB - The source code is in a GitHub repository.
	//
	//    * GITHUB_ENTERPRISE - The source code is in a GitHub Enterprise repository.
	//
	//    * NO_SOURCE - The project does not have input source code.
	//
	//    * S3 - The source code is in an S3 input bucket.
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectSource) GoString() string {
	return s.String()
}

// SetGitCloneDepth sets the GitCloneDepth field's value.
func (s *AwsCodeBuildProjectSource) SetGitCloneDepth(v int64) *AwsCodeBuildProjectSource {
	s.GitCloneDepth = &v
	return s
}

// SetInsecureSsl sets the InsecureSsl field's value.
func (s *AwsCodeBuildProjectSource) SetInsecureSsl(v bool) *AwsCodeBuildProjectSource {
	s.InsecureSsl = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *AwsCodeBuildProjectSource) SetLocation(v string) *AwsCodeBuildProjectSource {
	s.Location = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsCodeBuildProjectSource) SetType(v string) *AwsCodeBuildProjectSource {
	s.Type = &v
	return s
}

// Information about the VPC configuration that AWS CodeBuild accesses.
type AwsCodeBuildProjectVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security group IDs in your Amazon VPC.
	SecurityGroupIds []*string `type:"list"`

	// A list of one or more subnet IDs in your Amazon VPC.
	Subnets []*string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCodeBuildProjectVpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetSecurityGroupIds(v []*string) *AwsCodeBuildProjectVpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetSubnets(v []*string) *AwsCodeBuildProjectVpcConfig {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsCodeBuildProjectVpcConfig) SetVpcId(v string) *AwsCodeBuildProjectVpcConfig {
	s.VpcId = &v
	return s
}

// Contains the cross-origin resource sharing (CORS) configuration for the API.
// CORS is only supported for HTTP APIs.
type AwsCorsConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether the CORS request includes credentials.
	AllowCredentials *bool `type:"boolean"`

	// The allowed headers for CORS requests.
	AllowHeaders []*string `type:"list"`

	// The allowed methods for CORS requests.
	AllowMethods []*string `type:"list"`

	// The allowed origins for CORS requests.
	AllowOrigins []*string `type:"list"`

	// The exposed headers for CORS requests.
	ExposeHeaders []*string `type:"list"`

	// The number of seconds for which the browser caches preflight request results.
	MaxAge *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsCorsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCorsConfiguration) GoString() string {
	return s.String()
}

// SetAllowCredentials sets the AllowCredentials field's value.
func (s *AwsCorsConfiguration) SetAllowCredentials(v bool) *AwsCorsConfiguration {
	s.AllowCredentials = &v
	return s
}

// SetAllowHeaders sets the AllowHeaders field's value.
func (s *AwsCorsConfiguration) SetAllowHeaders(v []*string) *AwsCorsConfiguration {
	s.AllowHeaders = v
	return s
}

// SetAllowMethods sets the AllowMethods field's value.
func (s *AwsCorsConfiguration) SetAllowMethods(v []*string) *AwsCorsConfiguration {
	s.AllowMethods = v
	return s
}

// SetAllowOrigins sets the AllowOrigins field's value.
func (s *AwsCorsConfiguration) SetAllowOrigins(v []*string) *AwsCorsConfiguration {
	s.AllowOrigins = v
	return s
}

// SetExposeHeaders sets the ExposeHeaders field's value.
func (s *AwsCorsConfiguration) SetExposeHeaders(v []*string) *AwsCorsConfiguration {
	s.ExposeHeaders = v
	return s
}

// SetMaxAge sets the MaxAge field's value.
func (s *AwsCorsConfiguration) SetMaxAge(v int64) *AwsCorsConfiguration {
	s.MaxAge = &v
	return s
}

// Contains a definition of an attribute for the table.
type AwsDynamoDbTableAttributeDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	AttributeName *string `type:"string"`

	// The type of the attribute.
	AttributeType *string `type:"string"`
}

// String returns the string representation
func (s AwsDynamoDbTableAttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableAttributeDefinition) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *AwsDynamoDbTableAttributeDefinition) SetAttributeName(v string) *AwsDynamoDbTableAttributeDefinition {
	s.AttributeName = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *AwsDynamoDbTableAttributeDefinition) SetAttributeType(v string) *AwsDynamoDbTableAttributeDefinition {
	s.AttributeType = &v
	return s
}

// Provides information about the billing for read/write capacity on the table.
type AwsDynamoDbTableBillingModeSummary struct {
	_ struct{} `type:"structure"`

	// The method used to charge for read and write throughput and to manage capacity.
	BillingMode *string `type:"string"`

	// If the billing mode is PAY_PER_REQUEST, indicates when the billing mode was
	// set to that value.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastUpdateToPayPerRequestDateTime *string `type:"string"`
}

// String returns the string representation
func (s AwsDynamoDbTableBillingModeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableBillingModeSummary) GoString() string {
	return s.String()
}

// SetBillingMode sets the BillingMode field's value.
func (s *AwsDynamoDbTableBillingModeSummary) SetBillingMode(v string) *AwsDynamoDbTableBillingModeSummary {
	s.BillingMode = &v
	return s
}

// SetLastUpdateToPayPerRequestDateTime sets the LastUpdateToPayPerRequestDateTime field's value.
func (s *AwsDynamoDbTableBillingModeSummary) SetLastUpdateToPayPerRequestDateTime(v string) *AwsDynamoDbTableBillingModeSummary {
	s.LastUpdateToPayPerRequestDateTime = &v
	return s
}

// Provides details about a DynamoDB table.
type AwsDynamoDbTableDetails struct {
	_ struct{} `type:"structure"`

	// A list of attribute definitions for the table.
	AttributeDefinitions []*AwsDynamoDbTableAttributeDefinition `type:"list"`

	// Information about the billing for read/write capacity on the table.
	BillingModeSummary *AwsDynamoDbTableBillingModeSummary `type:"structure"`

	// Indicates when the table was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreationDateTime *string `type:"string"`

	// List of global secondary indexes for the table.
	GlobalSecondaryIndexes []*AwsDynamoDbTableGlobalSecondaryIndex `type:"list"`

	// The version of global tables being used.
	GlobalTableVersion *string `type:"string"`

	// The number of items in the table.
	ItemCount *int64 `type:"integer"`

	// The primary key structure for the table.
	KeySchema []*AwsDynamoDbTableKeySchema `type:"list"`

	// The ARN of the latest stream for the table.
	LatestStreamArn *string `type:"string"`

	// The label of the latest stream. The label is not a unique identifier.
	LatestStreamLabel *string `type:"string"`

	// The list of local secondary indexes for the table.
	LocalSecondaryIndexes []*AwsDynamoDbTableLocalSecondaryIndex `type:"list"`

	// Information about the provisioned throughput for the table.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput `type:"structure"`

	// The list of replicas of this table.
	Replicas []*AwsDynamoDbTableReplica `type:"list"`

	// Information about the restore for the table.
	RestoreSummary *AwsDynamoDbTableRestoreSummary `type:"structure"`

	// Information about the server-side encryption for the table.
	SseDescription *AwsDynamoDbTableSseDescription `type:"structure"`

	// The current DynamoDB Streams configuration for the table.
	StreamSpecification *AwsDynamoDbTableStreamSpecification `type:"structure"`

	// The identifier of the table.
	TableId *string `type:"string"`

	// The name of the table.
	TableName *string `type:"string"`

	// The total size of the table in bytes.
	TableSizeBytes *int64 `type:"long"`

	// The current status of the table.
	TableStatus *string `type:"string"`
}

// String returns the string representation
func (s AwsDynamoDbTableDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableDetails) GoString() string {
	return s.String()
}

// SetAttributeDefinitions sets the AttributeDefinitions field's value.
func (s *AwsDynamoDbTableDetails) SetAttributeDefinitions(v []*AwsDynamoDbTableAttributeDefinition) *AwsDynamoDbTableDetails {
	s.AttributeDefinitions = v
	return s
}

// SetBillingModeSummary sets the BillingModeSummary field's value.
func (s *AwsDynamoDbTableDetails) SetBillingModeSummary(v *AwsDynamoDbTableBillingModeSummary) *AwsDynamoDbTableDetails {
	s.BillingModeSummary = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *AwsDynamoDbTableDetails) SetCreationDateTime(v string) *AwsDynamoDbTableDetails {
	s.CreationDateTime = &v
	return s
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *AwsDynamoDbTableDetails) SetGlobalSecondaryIndexes(v []*AwsDynamoDbTableGlobalSecondaryIndex) *AwsDynamoDbTableDetails {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetGlobalTableVersion sets the GlobalTableVersion field's value.
func (s *AwsDynamoDbTableDetails) SetGlobalTableVersion(v string) *AwsDynamoDbTableDetails {
	s.GlobalTableVersion = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *AwsDynamoDbTableDetails) SetItemCount(v int64) *AwsDynamoDbTableDetails {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *AwsDynamoDbTableDetails) SetKeySchema(v []*AwsDynamoDbTableKeySchema) *AwsDynamoDbTableDetails {
	s.KeySchema = v
	return s
}

// SetLatestStreamArn sets the LatestStreamArn field's value.
func (s *AwsDynamoDbTableDetails) SetLatestStreamArn(v string) *AwsDynamoDbTableDetails {
	s.LatestStreamArn = &v
	return s
}

// SetLatestStreamLabel sets the LatestStreamLabel field's value.
func (s *AwsDynamoDbTableDetails) SetLatestStreamLabel(v string) *AwsDynamoDbTableDetails {
	s.LatestStreamLabel = &v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *AwsDynamoDbTableDetails) SetLocalSecondaryIndexes(v []*AwsDynamoDbTableLocalSecondaryIndex) *AwsDynamoDbTableDetails {
	s.LocalSecondaryIndexes = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *AwsDynamoDbTableDetails) SetProvisionedThroughput(v *AwsDynamoDbTableProvisionedThroughput) *AwsDynamoDbTableDetails {
	s.ProvisionedThroughput = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *AwsDynamoDbTableDetails) SetReplicas(v []*AwsDynamoDbTableReplica) *AwsDynamoDbTableDetails {
	s.Replicas = v
	return s
}

// SetRestoreSummary sets the RestoreSummary field's value.
func (s *AwsDynamoDbTableDetails) SetRestoreSummary(v *AwsDynamoDbTableRestoreSummary) *AwsDynamoDbTableDetails {
	s.RestoreSummary = v
	return s
}

// SetSseDescription sets the SseDescription field's value.
func (s *AwsDynamoDbTableDetails) SetSseDescription(v *AwsDynamoDbTableSseDescription) *AwsDynamoDbTableDetails {
	s.SseDescription = v
	return s
}

// SetStreamSpecification sets the StreamSpecification field's value.
func (s *AwsDynamoDbTableDetails) SetStreamSpecification(v *AwsDynamoDbTableStreamSpecification) *AwsDynamoDbTableDetails {
	s.StreamSpecification = v
	return s
}

// SetTableId sets the TableId field's value.
func (s *AwsDynamoDbTableDetails) SetTableId(v string) *AwsDynamoDbTableDetails {
	s.TableId = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *AwsDynamoDbTableDetails) SetTableName(v string) *AwsDynamoDbTableDetails {
	s.TableName = &v
	return s
}

// SetTableSizeBytes sets the TableSizeBytes field's value.
func (s *AwsDynamoDbTableDetails) SetTableSizeBytes(v int64) *AwsDynamoDbTableDetails {
	s.TableSizeBytes = &v
	return s
}

// SetTableStatus sets the TableStatus field's value.
func (s *AwsDynamoDbTableDetails) SetTableStatus(v string) *AwsDynamoDbTableDetails {
	s.TableStatus = &v
	return s
}

// Information abut a global secondary index for the table.
type AwsDynamoDbTableGlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// Whether the index is currently backfilling.
	Backfilling *bool `type:"boolean"`

	// The ARN of the index.
	IndexArn *string `type:"string"`

	// The name of the index.
	IndexName *string `type:"string"`

	// The total size in bytes of the index.
	IndexSizeBytes *int64 `type:"long"`

	// The current status of the index.
	IndexStatus *string `type:"string"`

	// The number of items in the index.
	ItemCount *int64 `type:"integer"`

	// The key schema for the index.
	KeySchema []*AwsDynamoDbTableKeySchema `type:"list"`

	// Attributes that are copied from the table into an index.
	Projection *AwsDynamoDbTableProjection `type:"structure"`

	// Information about the provisioned throughput settings for the indexes.
	ProvisionedThroughput *AwsDynamoDbTableProvisionedThroughput `type:"structure"`
}

// String returns the string representation
func (s AwsDynamoDbTableGlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableGlobalSecondaryIndex) GoString() string {
	return s.String()
}

// SetBackfilling sets the Backfilling field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetBackfilling(v bool) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.Backfilling = &v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexArn(v string) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexName(v string) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetIndexSizeBytes sets the IndexSizeBytes field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexSizeBytes(v int64) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexSizeBytes = &v
	return s
}

// SetIndexStatus sets the IndexStatus field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetIndexStatus(v string) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.IndexStatus = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetItemCount(v int64) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetKeySchema(v []*AwsDynamoDbTableKeySchema) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetProjection(v *AwsDynamoDbTableProjection) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *AwsDynamoDbTableGlobalSecondaryIndex) SetProvisionedThroughput(v *AwsDynamoDbTableProvisionedThroughput) *AwsDynamoDbTableGlobalSecondaryIndex {
	s.ProvisionedThroughput = v
	return s
}

// A component of the key schema for the DynamoDB table, a global secondary
// index, or a local secondary index.
type AwsDynamoDbTableKeySchema struct {
	_ struct{} `type:"structure"`

	// The name of the key schema attribute.
	AttributeName *string `type:"string"`

	// The type of key used for the key schema attribute.
	KeyType *string `type:"string"`
}

// String returns the string representation
func (s AwsDynamoDbTableKeySchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableKeySchema) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *AwsDynamoDbTableKeySchema) SetAttributeName(v string) *AwsDynamoDbTableKeySchema {
	s.AttributeName = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *AwsDynamoDbTableKeySchema) SetKeyType(v string) *AwsDynamoDbTableKeySchema {
	s.KeyType = &v
	return s
}

// Information about a local secondary index for a DynamoDB table.
type AwsDynamoDbTableLocalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The ARN of the index.
	IndexArn *string `type:"string"`

	// The name of the index.
	IndexName *string `type:"string"`

	// The complete key schema for the index.
	KeySchema []*AwsDynamoDbTableKeySchema `type:"list"`

	// Attributes that are copied from the table into the index. These are in addition
	// to the primary key attributes and index key attributes, which are automatically
	// projected.
	Projection *AwsDynamoDbTableProjection `type:"structure"`
}

// String returns the string representation
func (s AwsDynamoDbTableLocalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableLocalSecondaryIndex) GoString() string {
	return s.String()
}

// SetIndexArn sets the IndexArn field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetIndexArn(v string) *AwsDynamoDbTableLocalSecondaryIndex {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetIndexName(v string) *AwsDynamoDbTableLocalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetKeySchema(v []*AwsDynamoDbTableKeySchema) *AwsDynamoDbTableLocalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *AwsDynamoDbTableLocalSecondaryIndex) SetProjection(v *AwsDynamoDbTableProjection) *AwsDynamoDbTableLocalSecondaryIndex {
	s.Projection = v
	return s
}

// For global and local secondary indexes, identifies the attributes that are
// copied from the table into the index.
type AwsDynamoDbTableProjection struct {
	_ struct{} `type:"structure"`

	// The nonkey attributes that are projected into the index. For each attribute,
	// provide the attribute name.
	NonKeyAttributes []*string `type:"list"`

	// The types of attributes that are projected into the index.
	ProjectionType *string `type:"string"`
}

// String returns the string representation
func (s AwsDynamoDbTableProjection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableProjection) GoString() string {
	return s.String()
}

// SetNonKeyAttributes sets the NonKeyAttributes field's value.
func (s *AwsDynamoDbTableProjection) SetNonKeyAttributes(v []*string) *AwsDynamoDbTableProjection {
	s.NonKeyAttributes = v
	return s
}

// SetProjectionType sets the ProjectionType field's value.
func (s *AwsDynamoDbTableProjection) SetProjectionType(v string) *AwsDynamoDbTableProjection {
	s.ProjectionType = &v
	return s
}

// Information about the provisioned throughput for the table or for a global
// secondary index.
type AwsDynamoDbTableProvisionedThroughput struct {
	_ struct{} `type:"structure"`

	// Indicates when the provisioned throughput was last decreased.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastDecreaseDateTime *string `type:"string"`

	// Indicates when the provisioned throughput was last increased.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastIncreaseDateTime *string `type:"string"`

	// The number of times during the current UTC calendar day that the provisioned
	// throughput was decreased.
	NumberOfDecreasesToday *int64 `type:"integer"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ReadCapacityUnits *int64 `type:"integer"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	WriteCapacityUnits *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsDynamoDbTableProvisionedThroughput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableProvisionedThroughput) GoString() string {
	return s.String()
}

// SetLastDecreaseDateTime sets the LastDecreaseDateTime field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetLastDecreaseDateTime(v string) *AwsDynamoDbTableProvisionedThroughput {
	s.LastDecreaseDateTime = &v
	return s
}

// SetLastIncreaseDateTime sets the LastIncreaseDateTime field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetLastIncreaseDateTime(v string) *AwsDynamoDbTableProvisionedThroughput {
	s.LastIncreaseDateTime = &v
	return s
}

// SetNumberOfDecreasesToday sets the NumberOfDecreasesToday field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetNumberOfDecreasesToday(v int64) *AwsDynamoDbTableProvisionedThroughput {
	s.NumberOfDecreasesToday = &v
	return s
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetReadCapacityUnits(v int64) *AwsDynamoDbTableProvisionedThroughput {
	s.ReadCapacityUnits = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *AwsDynamoDbTableProvisionedThroughput) SetWriteCapacityUnits(v int64) *AwsDynamoDbTableProvisionedThroughput {
	s.WriteCapacityUnits = &v
	return s
}

// Replica-specific configuration for the provisioned throughput.
type AwsDynamoDbTableProvisionedThroughputOverride struct {
	_ struct{} `type:"structure"`

	// The read capacity units for the replica.
	ReadCapacityUnits *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsDynamoDbTableProvisionedThroughputOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableProvisionedThroughputOverride) GoString() string {
	return s.String()
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *AwsDynamoDbTableProvisionedThroughputOverride) SetReadCapacityUnits(v int64) *AwsDynamoDbTableProvisionedThroughputOverride {
	s.ReadCapacityUnits = &v
	return s
}

// Information about a replica of a DynamoDB table.
type AwsDynamoDbTableReplica struct {
	_ struct{} `type:"structure"`

	// List of global secondary indexes for the replica.
	GlobalSecondaryIndexes []*AwsDynamoDbTableReplicaGlobalSecondaryIndex `type:"list"`

	// The identifier of the AWS KMS customer master key (CMK) that will be used
	// for AWS KMS encryption for the replica.
	KmsMasterKeyId *string `type:"string"`

	// Replica-specific configuration for the provisioned throughput.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride `type:"structure"`

	// The name of the Region where the replica is located.
	RegionName *string `type:"string"`

	// The current status of the replica.
	ReplicaStatus *string `type:"string"`

	// Detailed information about the replica status.
	ReplicaStatusDescription *string `type:"string"`
}

// String returns the string representation
func (s AwsDynamoDbTableReplica) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableReplica) GoString() string {
	return s.String()
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *AwsDynamoDbTableReplica) SetGlobalSecondaryIndexes(v []*AwsDynamoDbTableReplicaGlobalSecondaryIndex) *AwsDynamoDbTableReplica {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetKmsMasterKeyId sets the KmsMasterKeyId field's value.
func (s *AwsDynamoDbTableReplica) SetKmsMasterKeyId(v string) *AwsDynamoDbTableReplica {
	s.KmsMasterKeyId = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *AwsDynamoDbTableReplica) SetProvisionedThroughputOverride(v *AwsDynamoDbTableProvisionedThroughputOverride) *AwsDynamoDbTableReplica {
	s.ProvisionedThroughputOverride = v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *AwsDynamoDbTableReplica) SetRegionName(v string) *AwsDynamoDbTableReplica {
	s.RegionName = &v
	return s
}

// SetReplicaStatus sets the ReplicaStatus field's value.
func (s *AwsDynamoDbTableReplica) SetReplicaStatus(v string) *AwsDynamoDbTableReplica {
	s.ReplicaStatus = &v
	return s
}

// SetReplicaStatusDescription sets the ReplicaStatusDescription field's value.
func (s *AwsDynamoDbTableReplica) SetReplicaStatusDescription(v string) *AwsDynamoDbTableReplica {
	s.ReplicaStatusDescription = &v
	return s
}

// Information about a global secondary index for a DynamoDB table replica.
type AwsDynamoDbTableReplicaGlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the index.
	IndexName *string `type:"string"`

	// Replica-specific configuration for the provisioned throughput for the index.
	ProvisionedThroughputOverride *AwsDynamoDbTableProvisionedThroughputOverride `type:"structure"`
}

// String returns the string representation
func (s AwsDynamoDbTableReplicaGlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableReplicaGlobalSecondaryIndex) GoString() string {
	return s.String()
}

// SetIndexName sets the IndexName field's value.
func (s *AwsDynamoDbTableReplicaGlobalSecondaryIndex) SetIndexName(v string) *AwsDynamoDbTableReplicaGlobalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetProvisionedThroughputOverride sets the ProvisionedThroughputOverride field's value.
func (s *AwsDynamoDbTableReplicaGlobalSecondaryIndex) SetProvisionedThroughputOverride(v *AwsDynamoDbTableProvisionedThroughputOverride) *AwsDynamoDbTableReplicaGlobalSecondaryIndex {
	s.ProvisionedThroughputOverride = v
	return s
}

// Information about the restore for the table.
type AwsDynamoDbTableRestoreSummary struct {
	_ struct{} `type:"structure"`

	// Indicates the point in time that the table was restored to.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	RestoreDateTime *string `type:"string"`

	// Whether a restore is currently in progress.
	RestoreInProgress *bool `type:"boolean"`

	// The ARN of the source backup from which the table was restored.
	SourceBackupArn *string `type:"string"`

	// The ARN of the source table for the backup.
	SourceTableArn *string `type:"string"`
}

// String returns the string representation
func (s AwsDynamoDbTableRestoreSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableRestoreSummary) GoString() string {
	return s.String()
}

// SetRestoreDateTime sets the RestoreDateTime field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetRestoreDateTime(v string) *AwsDynamoDbTableRestoreSummary {
	s.RestoreDateTime = &v
	return s
}

// SetRestoreInProgress sets the RestoreInProgress field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetRestoreInProgress(v bool) *AwsDynamoDbTableRestoreSummary {
	s.RestoreInProgress = &v
	return s
}

// SetSourceBackupArn sets the SourceBackupArn field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetSourceBackupArn(v string) *AwsDynamoDbTableRestoreSummary {
	s.SourceBackupArn = &v
	return s
}

// SetSourceTableArn sets the SourceTableArn field's value.
func (s *AwsDynamoDbTableRestoreSummary) SetSourceTableArn(v string) *AwsDynamoDbTableRestoreSummary {
	s.SourceTableArn = &v
	return s
}

// Information about the server-side encryption for the table.
type AwsDynamoDbTableSseDescription struct {
	_ struct{} `type:"structure"`

	// If the key is inaccessible, the date and time when DynamoDB detected that
	// the key was inaccessible.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	InaccessibleEncryptionDateTime *string `type:"string"`

	// The ARN of the AWS KMS customer master key (CMK) that is used for the AWS
	// KMS encryption.
	KmsMasterKeyArn *string `type:"string"`

	// The type of server-side encryption.
	SseType *string `type:"string"`

	// The status of the server-side encryption.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsDynamoDbTableSseDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableSseDescription) GoString() string {
	return s.String()
}

// SetInaccessibleEncryptionDateTime sets the InaccessibleEncryptionDateTime field's value.
func (s *AwsDynamoDbTableSseDescription) SetInaccessibleEncryptionDateTime(v string) *AwsDynamoDbTableSseDescription {
	s.InaccessibleEncryptionDateTime = &v
	return s
}

// SetKmsMasterKeyArn sets the KmsMasterKeyArn field's value.
func (s *AwsDynamoDbTableSseDescription) SetKmsMasterKeyArn(v string) *AwsDynamoDbTableSseDescription {
	s.KmsMasterKeyArn = &v
	return s
}

// SetSseType sets the SseType field's value.
func (s *AwsDynamoDbTableSseDescription) SetSseType(v string) *AwsDynamoDbTableSseDescription {
	s.SseType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsDynamoDbTableSseDescription) SetStatus(v string) *AwsDynamoDbTableSseDescription {
	s.Status = &v
	return s
}

// The current DynamoDB Streams configuration for the table.
type AwsDynamoDbTableStreamSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether DynamoDB Streams is enabled on the table.
	StreamEnabled *bool `type:"boolean"`

	// Determines the information that is written to the table.
	StreamViewType *string `type:"string"`
}

// String returns the string representation
func (s AwsDynamoDbTableStreamSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsDynamoDbTableStreamSpecification) GoString() string {
	return s.String()
}

// SetStreamEnabled sets the StreamEnabled field's value.
func (s *AwsDynamoDbTableStreamSpecification) SetStreamEnabled(v bool) *AwsDynamoDbTableStreamSpecification {
	s.StreamEnabled = &v
	return s
}

// SetStreamViewType sets the StreamViewType field's value.
func (s *AwsDynamoDbTableStreamSpecification) SetStreamViewType(v string) *AwsDynamoDbTableStreamSpecification {
	s.StreamViewType = &v
	return s
}

// Information about an Elastic IP address.
type AwsEc2EipDetails struct {
	_ struct{} `type:"structure"`

	// The identifier that AWS assigns to represent the allocation of the Elastic
	// IP address for use with Amazon VPC.
	AllocationId *string `type:"string"`

	// The identifier that represents the association of the Elastic IP address
	// with an EC2 instance.
	AssociationId *string `type:"string"`

	// The domain in which to allocate the address.
	//
	// If the address is for use with EC2 instances in a VPC, then Domain is vpc.
	// Otherwise, Domain is standard.
	Domain *string `type:"string"`

	// The identifier of the EC2 instance.
	InstanceId *string `type:"string"`

	// The name of the location from which the Elastic IP address is advertised.
	NetworkBorderGroup *string `type:"string"`

	// The identifier of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// The AWS account ID of the owner of the network interface.
	NetworkInterfaceOwnerId *string `type:"string"`

	// The private IP address that is associated with the Elastic IP address.
	PrivateIpAddress *string `type:"string"`

	// A public IP address that is associated with the EC2 instance.
	PublicIp *string `type:"string"`

	// The identifier of an IP address pool. This parameter allows Amazon EC2 to
	// select an IP address from the address pool.
	PublicIpv4Pool *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2EipDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2EipDetails) GoString() string {
	return s.String()
}

// SetAllocationId sets the AllocationId field's value.
func (s *AwsEc2EipDetails) SetAllocationId(v string) *AwsEc2EipDetails {
	s.AllocationId = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *AwsEc2EipDetails) SetAssociationId(v string) *AwsEc2EipDetails {
	s.AssociationId = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *AwsEc2EipDetails) SetDomain(v string) *AwsEc2EipDetails {
	s.Domain = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2EipDetails) SetInstanceId(v string) *AwsEc2EipDetails {
	s.InstanceId = &v
	return s
}

// SetNetworkBorderGroup sets the NetworkBorderGroup field's value.
func (s *AwsEc2EipDetails) SetNetworkBorderGroup(v string) *AwsEc2EipDetails {
	s.NetworkBorderGroup = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2EipDetails) SetNetworkInterfaceId(v string) *AwsEc2EipDetails {
	s.NetworkInterfaceId = &v
	return s
}

// SetNetworkInterfaceOwnerId sets the NetworkInterfaceOwnerId field's value.
func (s *AwsEc2EipDetails) SetNetworkInterfaceOwnerId(v string) *AwsEc2EipDetails {
	s.NetworkInterfaceOwnerId = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AwsEc2EipDetails) SetPrivateIpAddress(v string) *AwsEc2EipDetails {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *AwsEc2EipDetails) SetPublicIp(v string) *AwsEc2EipDetails {
	s.PublicIp = &v
	return s
}

// SetPublicIpv4Pool sets the PublicIpv4Pool field's value.
func (s *AwsEc2EipDetails) SetPublicIpv4Pool(v string) *AwsEc2EipDetails {
	s.PublicIpv4Pool = &v
	return s
}

// The details of an Amazon EC2 instance.
type AwsEc2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The IAM profile ARN of the instance.
	IamInstanceProfileArn *string `type:"string"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ImageId *string `type:"string"`

	// The IPv4 addresses associated with the instance.
	IpV4Addresses []*string `type:"list"`

	// The IPv6 addresses associated with the instance.
	IpV6Addresses []*string `type:"list"`

	// The key name associated with the instance.
	KeyName *string `type:"string"`

	// Indicates when the instance was launched.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LaunchedAt *string `type:"string"`

	// The identifier of the subnet that the instance was launched in.
	SubnetId *string `type:"string"`

	// The instance type of the instance.
	Type *string `type:"string"`

	// The identifier of the VPC that the instance was launched in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2InstanceDetails) GoString() string {
	return s.String()
}

// SetIamInstanceProfileArn sets the IamInstanceProfileArn field's value.
func (s *AwsEc2InstanceDetails) SetIamInstanceProfileArn(v string) *AwsEc2InstanceDetails {
	s.IamInstanceProfileArn = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AwsEc2InstanceDetails) SetImageId(v string) *AwsEc2InstanceDetails {
	s.ImageId = &v
	return s
}

// SetIpV4Addresses sets the IpV4Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV4Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV4Addresses = v
	return s
}

// SetIpV6Addresses sets the IpV6Addresses field's value.
func (s *AwsEc2InstanceDetails) SetIpV6Addresses(v []*string) *AwsEc2InstanceDetails {
	s.IpV6Addresses = v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AwsEc2InstanceDetails) SetKeyName(v string) *AwsEc2InstanceDetails {
	s.KeyName = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *AwsEc2InstanceDetails) SetLaunchedAt(v string) *AwsEc2InstanceDetails {
	s.LaunchedAt = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *AwsEc2InstanceDetails) SetSubnetId(v string) *AwsEc2InstanceDetails {
	s.SubnetId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsEc2InstanceDetails) SetType(v string) *AwsEc2InstanceDetails {
	s.Type = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2InstanceDetails) SetVpcId(v string) *AwsEc2InstanceDetails {
	s.VpcId = &v
	return s
}

// Information about the network interface attachment.
type AwsEc2NetworkInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// Indicates when the attachment initiated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	AttachTime *string `type:"string"`

	// The identifier of the network interface attachment
	AttachmentId *string `type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The device index of the network interface attachment on the instance.
	DeviceIndex *int64 `type:"integer"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The AWS account ID of the owner of the instance.
	InstanceOwnerId *string `type:"string"`

	// The attachment state.
	//
	// Valid values: attaching | attached | detaching | detached
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2NetworkInterfaceAttachment) GoString() string {
	return s.String()
}

// SetAttachTime sets the AttachTime field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetAttachTime(v string) *AwsEc2NetworkInterfaceAttachment {
	s.AttachTime = &v
	return s
}

// SetAttachmentId sets the AttachmentId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetAttachmentId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.AttachmentId = &v
	return s
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetDeleteOnTermination(v bool) *AwsEc2NetworkInterfaceAttachment {
	s.DeleteOnTermination = &v
	return s
}

// SetDeviceIndex sets the DeviceIndex field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetDeviceIndex(v int64) *AwsEc2NetworkInterfaceAttachment {
	s.DeviceIndex = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetInstanceId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.InstanceId = &v
	return s
}

// SetInstanceOwnerId sets the InstanceOwnerId field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetInstanceOwnerId(v string) *AwsEc2NetworkInterfaceAttachment {
	s.InstanceOwnerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2NetworkInterfaceAttachment) SetStatus(v string) *AwsEc2NetworkInterfaceAttachment {
	s.Status = &v
	return s
}

// Details about the network interface
type AwsEc2NetworkInterfaceDetails struct {
	_ struct{} `type:"structure"`

	// The network interface attachment.
	Attachment *AwsEc2NetworkInterfaceAttachment `type:"structure"`

	// The ID of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// Security groups for the network interface.
	SecurityGroups []*AwsEc2NetworkInterfaceSecurityGroup `type:"list"`

	// Indicates whether traffic to or from the instance is validated.
	SourceDestCheck *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2NetworkInterfaceDetails) GoString() string {
	return s.String()
}

// SetAttachment sets the Attachment field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetAttachment(v *AwsEc2NetworkInterfaceAttachment) *AwsEc2NetworkInterfaceDetails {
	s.Attachment = v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetNetworkInterfaceId(v string) *AwsEc2NetworkInterfaceDetails {
	s.NetworkInterfaceId = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetSecurityGroups(v []*AwsEc2NetworkInterfaceSecurityGroup) *AwsEc2NetworkInterfaceDetails {
	s.SecurityGroups = v
	return s
}

// SetSourceDestCheck sets the SourceDestCheck field's value.
func (s *AwsEc2NetworkInterfaceDetails) SetSourceDestCheck(v bool) *AwsEc2NetworkInterfaceDetails {
	s.SourceDestCheck = &v
	return s
}

// A security group associated with the network interface.
type AwsEc2NetworkInterfaceSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2NetworkInterfaceSecurityGroup) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2NetworkInterfaceSecurityGroup) SetGroupId(v string) *AwsEc2NetworkInterfaceSecurityGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2NetworkInterfaceSecurityGroup) SetGroupName(v string) *AwsEc2NetworkInterfaceSecurityGroup {
	s.GroupName = &v
	return s
}

// Details about an EC2 security group.
type AwsEc2SecurityGroupDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The inbound rules associated with the security group.
	IpPermissions []*AwsEc2SecurityGroupIpPermission `type:"list"`

	// [VPC only] The outbound rules associated with the security group.
	IpPermissionsEgress []*AwsEc2SecurityGroupIpPermission `type:"list"`

	// The AWS account ID of the owner of the security group.
	OwnerId *string `type:"string"`

	// [VPC only] The ID of the VPC for the security group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupDetails) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2SecurityGroupDetails) SetGroupId(v string) *AwsEc2SecurityGroupDetails {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2SecurityGroupDetails) SetGroupName(v string) *AwsEc2SecurityGroupDetails {
	s.GroupName = &v
	return s
}

// SetIpPermissions sets the IpPermissions field's value.
func (s *AwsEc2SecurityGroupDetails) SetIpPermissions(v []*AwsEc2SecurityGroupIpPermission) *AwsEc2SecurityGroupDetails {
	s.IpPermissions = v
	return s
}

// SetIpPermissionsEgress sets the IpPermissionsEgress field's value.
func (s *AwsEc2SecurityGroupDetails) SetIpPermissionsEgress(v []*AwsEc2SecurityGroupIpPermission) *AwsEc2SecurityGroupDetails {
	s.IpPermissionsEgress = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsEc2SecurityGroupDetails) SetOwnerId(v string) *AwsEc2SecurityGroupDetails {
	s.OwnerId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SecurityGroupDetails) SetVpcId(v string) *AwsEc2SecurityGroupDetails {
	s.VpcId = &v
	return s
}

// An IP permission for an EC2 security group.
type AwsEc2SecurityGroupIpPermission struct {
	_ struct{} `type:"structure"`

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number.
	//
	// A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	FromPort *int64 `type:"integer"`

	// The IP protocol name (tcp, udp, icmp, icmpv6) or number.
	//
	// [VPC only] Use -1 to specify all protocols.
	//
	// When authorizing security group rules, specifying -1 or a protocol number
	// other than tcp, udp, icmp, or icmpv6 allows traffic on all ports, regardless
	// of any port range you specify.
	//
	// For tcp, udp, and icmp, you must specify a port range.
	//
	// For icmpv6, the port range is optional. If you omit the port range, traffic
	// for all types and codes is allowed.
	IpProtocol *string `type:"string"`

	// The IPv4 ranges.
	IpRanges []*AwsEc2SecurityGroupIpRange `type:"list"`

	// The IPv6 ranges.
	Ipv6Ranges []*AwsEc2SecurityGroupIpv6Range `type:"list"`

	// [VPC only] The prefix list IDs for an AWS service. With outbound rules, this
	// is the AWS service to access through a VPC endpoint from instances associated
	// with the security group.
	PrefixListIds []*AwsEc2SecurityGroupPrefixListId `type:"list"`

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// code.
	//
	// A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	ToPort *int64 `type:"integer"`

	// The security group and AWS account ID pairs.
	UserIdGroupPairs []*AwsEc2SecurityGroupUserIdGroupPair `type:"list"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupIpPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupIpPermission) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetFromPort(v int64) *AwsEc2SecurityGroupIpPermission {
	s.FromPort = &v
	return s
}

// SetIpProtocol sets the IpProtocol field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpProtocol(v string) *AwsEc2SecurityGroupIpPermission {
	s.IpProtocol = &v
	return s
}

// SetIpRanges sets the IpRanges field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpRanges(v []*AwsEc2SecurityGroupIpRange) *AwsEc2SecurityGroupIpPermission {
	s.IpRanges = v
	return s
}

// SetIpv6Ranges sets the Ipv6Ranges field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetIpv6Ranges(v []*AwsEc2SecurityGroupIpv6Range) *AwsEc2SecurityGroupIpPermission {
	s.Ipv6Ranges = v
	return s
}

// SetPrefixListIds sets the PrefixListIds field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetPrefixListIds(v []*AwsEc2SecurityGroupPrefixListId) *AwsEc2SecurityGroupIpPermission {
	s.PrefixListIds = v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetToPort(v int64) *AwsEc2SecurityGroupIpPermission {
	s.ToPort = &v
	return s
}

// SetUserIdGroupPairs sets the UserIdGroupPairs field's value.
func (s *AwsEc2SecurityGroupIpPermission) SetUserIdGroupPairs(v []*AwsEc2SecurityGroupUserIdGroupPair) *AwsEc2SecurityGroupIpPermission {
	s.UserIdGroupPairs = v
	return s
}

// A range of IPv4 addresses.
type AwsEc2SecurityGroupIpRange struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv4 address, use the /32 prefix
	// length.
	CidrIp *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupIpRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupIpRange) GoString() string {
	return s.String()
}

// SetCidrIp sets the CidrIp field's value.
func (s *AwsEc2SecurityGroupIpRange) SetCidrIp(v string) *AwsEc2SecurityGroupIpRange {
	s.CidrIp = &v
	return s
}

// A range of IPv6 addresses.
type AwsEc2SecurityGroupIpv6Range struct {
	_ struct{} `type:"structure"`

	// The IPv6 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv6 address, use the /128 prefix
	// length.
	CidrIpv6 *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupIpv6Range) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupIpv6Range) GoString() string {
	return s.String()
}

// SetCidrIpv6 sets the CidrIpv6 field's value.
func (s *AwsEc2SecurityGroupIpv6Range) SetCidrIpv6(v string) *AwsEc2SecurityGroupIpv6Range {
	s.CidrIpv6 = &v
	return s
}

// A prefix list ID.
type AwsEc2SecurityGroupPrefixListId struct {
	_ struct{} `type:"structure"`

	// The ID of the prefix.
	PrefixListId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupPrefixListId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupPrefixListId) GoString() string {
	return s.String()
}

// SetPrefixListId sets the PrefixListId field's value.
func (s *AwsEc2SecurityGroupPrefixListId) SetPrefixListId(v string) *AwsEc2SecurityGroupPrefixListId {
	s.PrefixListId = &v
	return s
}

// A relationship between a security group and a user.
type AwsEc2SecurityGroupUserIdGroupPair struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The status of a VPC peering connection, if applicable.
	PeeringStatus *string `type:"string"`

	// The ID of an AWS account.
	//
	// For a referenced security group in another VPC, the account ID of the referenced
	// security group is returned in the response. If the referenced security group
	// is deleted, this value is not returned.
	//
	// [EC2-Classic] Required when adding or removing rules that reference a security
	// group in another AWS.
	UserId *string `type:"string"`

	// The ID of the VPC for the referenced security group, if applicable.
	VpcId *string `type:"string"`

	// The ID of the VPC peering connection, if applicable.
	VpcPeeringConnectionId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupUserIdGroupPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2SecurityGroupUserIdGroupPair) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetGroupId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetGroupName(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.GroupName = &v
	return s
}

// SetPeeringStatus sets the PeeringStatus field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetPeeringStatus(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.PeeringStatus = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetUserId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.UserId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetVpcId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.VpcId = &v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *AwsEc2SecurityGroupUserIdGroupPair) SetVpcPeeringConnectionId(v string) *AwsEc2SecurityGroupUserIdGroupPair {
	s.VpcPeeringConnectionId = &v
	return s
}

// An attachment to an AWS EC2 volume.
type AwsEc2VolumeAttachment struct {
	_ struct{} `type:"structure"`

	// The datetime when the attachment initiated.
	AttachTime *string `type:"string"`

	// Whether the EBS volume is deleted when the EC2 instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The identifier of the EC2 instance.
	InstanceId *string `type:"string"`

	// The attachment state of the volume.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2VolumeAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2VolumeAttachment) GoString() string {
	return s.String()
}

// SetAttachTime sets the AttachTime field's value.
func (s *AwsEc2VolumeAttachment) SetAttachTime(v string) *AwsEc2VolumeAttachment {
	s.AttachTime = &v
	return s
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *AwsEc2VolumeAttachment) SetDeleteOnTermination(v bool) *AwsEc2VolumeAttachment {
	s.DeleteOnTermination = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsEc2VolumeAttachment) SetInstanceId(v string) *AwsEc2VolumeAttachment {
	s.InstanceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2VolumeAttachment) SetStatus(v string) *AwsEc2VolumeAttachment {
	s.Status = &v
	return s
}

// Details about an EC2 volume.
type AwsEc2VolumeDetails struct {
	_ struct{} `type:"structure"`

	// The volume attachments.
	Attachments []*AwsEc2VolumeAttachment `type:"list"`

	// Indicates when the volume was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateTime *string `type:"string"`

	// Whether the volume is encrypted.
	Encrypted *bool `type:"boolean"`

	// The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK)
	// that was used to protect the volume encryption key for the volume.
	KmsKeyId *string `type:"string"`

	// The size of the volume, in GiBs.
	Size *int64 `type:"integer"`

	// The snapshot from which the volume was created.
	SnapshotId *string `type:"string"`

	// The volume state.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2VolumeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2VolumeDetails) GoString() string {
	return s.String()
}

// SetAttachments sets the Attachments field's value.
func (s *AwsEc2VolumeDetails) SetAttachments(v []*AwsEc2VolumeAttachment) *AwsEc2VolumeDetails {
	s.Attachments = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AwsEc2VolumeDetails) SetCreateTime(v string) *AwsEc2VolumeDetails {
	s.CreateTime = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsEc2VolumeDetails) SetEncrypted(v bool) *AwsEc2VolumeDetails {
	s.Encrypted = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsEc2VolumeDetails) SetKmsKeyId(v string) *AwsEc2VolumeDetails {
	s.KmsKeyId = &v
	return s
}

// SetSize sets the Size field's value.
func (s *AwsEc2VolumeDetails) SetSize(v int64) *AwsEc2VolumeDetails {
	s.Size = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *AwsEc2VolumeDetails) SetSnapshotId(v string) *AwsEc2VolumeDetails {
	s.SnapshotId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsEc2VolumeDetails) SetStatus(v string) *AwsEc2VolumeDetails {
	s.Status = &v
	return s
}

// Details about an EC2 VPC.
type AwsEc2VpcDetails struct {
	_ struct{} `type:"structure"`

	// Information about the IPv4 CIDR blocks associated with the VPC.
	CidrBlockAssociationSet []*CidrBlockAssociation `type:"list"`

	// The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options
	// that are associated with the VPC. If the default options are associated with
	// the VPC, then this is default.
	DhcpOptionsId *string `type:"string"`

	// Information about the IPv6 CIDR blocks associated with the VPC.
	Ipv6CidrBlockAssociationSet []*Ipv6CidrBlockAssociation `type:"list"`

	// The current state of the VPC.
	State *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2VpcDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsEc2VpcDetails) GoString() string {
	return s.String()
}

// SetCidrBlockAssociationSet sets the CidrBlockAssociationSet field's value.
func (s *AwsEc2VpcDetails) SetCidrBlockAssociationSet(v []*CidrBlockAssociation) *AwsEc2VpcDetails {
	s.CidrBlockAssociationSet = v
	return s
}

// SetDhcpOptionsId sets the DhcpOptionsId field's value.
func (s *AwsEc2VpcDetails) SetDhcpOptionsId(v string) *AwsEc2VpcDetails {
	s.DhcpOptionsId = &v
	return s
}

// SetIpv6CidrBlockAssociationSet sets the Ipv6CidrBlockAssociationSet field's value.
func (s *AwsEc2VpcDetails) SetIpv6CidrBlockAssociationSet(v []*Ipv6CidrBlockAssociation) *AwsEc2VpcDetails {
	s.Ipv6CidrBlockAssociationSet = v
	return s
}

// SetState sets the State field's value.
func (s *AwsEc2VpcDetails) SetState(v string) *AwsEc2VpcDetails {
	s.State = &v
	return s
}

// Information about an Elasticsearch domain.
type AwsElasticsearchDomainDetails struct {
	_ struct{} `type:"structure"`

	// IAM policy document specifying the access policies for the new Amazon ES
	// domain.
	AccessPolicies *string `type:"string"`

	// Additional options for the domain endpoint.
	DomainEndpointOptions *AwsElasticsearchDomainDomainEndpointOptions `type:"structure"`

	// Unique identifier for an Amazon ES domain.
	DomainId *string `type:"string"`

	// Name of an Amazon ES domain.
	//
	// Domain names are unique across all domains owned by the same account within
	// an AWS Region.
	//
	// Domain names must start with a lowercase letter and must be between 3 and
	// 28 characters.
	//
	// Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
	DomainName *string `type:"string"`

	// Elasticsearch version.
	ElasticsearchVersion *string `type:"string"`

	// Details about the configuration for encryption at rest.
	EncryptionAtRestOptions *AwsElasticsearchDomainEncryptionAtRestOptions `type:"structure"`

	// Domain-specific endpoint used to submit index, search, and data upload requests
	// to an Amazon ES domain.
	//
	// The endpoint is a service URL.
	Endpoint *string `type:"string"`

	// The key-value pair that exists if the Amazon ES domain uses VPC endpoints.
	Endpoints map[string]*string `type:"map"`

	// Details about the configuration for node-to-node encryption.
	NodeToNodeEncryptionOptions *AwsElasticsearchDomainNodeToNodeEncryptionOptions `type:"structure"`

	// Information that Amazon ES derives based on VPCOptions for the domain.
	VPCOptions *AwsElasticsearchDomainVPCOptions `type:"structure"`
}

// String returns the string representation
func (s AwsElasticsearchDomainDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainDetails) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *AwsElasticsearchDomainDetails) SetAccessPolicies(v string) *AwsElasticsearchDomainDetails {
	s.AccessPolicies = &v
	return s
}

// SetDomainEndpointOptions sets the DomainEndpointOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetDomainEndpointOptions(v *AwsElasticsearchDomainDomainEndpointOptions) *AwsElasticsearchDomainDetails {
	s.DomainEndpointOptions = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AwsElasticsearchDomainDetails) SetDomainId(v string) *AwsElasticsearchDomainDetails {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AwsElasticsearchDomainDetails) SetDomainName(v string) *AwsElasticsearchDomainDetails {
	s.DomainName = &v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *AwsElasticsearchDomainDetails) SetElasticsearchVersion(v string) *AwsElasticsearchDomainDetails {
	s.ElasticsearchVersion = &v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetEncryptionAtRestOptions(v *AwsElasticsearchDomainEncryptionAtRestOptions) *AwsElasticsearchDomainDetails {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsElasticsearchDomainDetails) SetEndpoint(v string) *AwsElasticsearchDomainDetails {
	s.Endpoint = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *AwsElasticsearchDomainDetails) SetEndpoints(v map[string]*string) *AwsElasticsearchDomainDetails {
	s.Endpoints = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetNodeToNodeEncryptionOptions(v *AwsElasticsearchDomainNodeToNodeEncryptionOptions) *AwsElasticsearchDomainDetails {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *AwsElasticsearchDomainDetails) SetVPCOptions(v *AwsElasticsearchDomainVPCOptions) *AwsElasticsearchDomainDetails {
	s.VPCOptions = v
	return s
}

// Additional options for the domain endpoint, such as whether to require HTTPS
// for all traffic.
type AwsElasticsearchDomainDomainEndpointOptions struct {
	_ struct{} `type:"structure"`

	// Whether to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS *bool `type:"boolean"`

	// The TLS security policy to apply to the HTTPS endpoint of the Elasticsearch
	// domain.
	//
	// Valid values:
	//
	//    * Policy-Min-TLS-1-0-2019-07, which supports TLSv1.0 and higher
	//
	//    * Policy-Min-TLS-1-2-2019-07, which only supports TLSv1.2
	TLSSecurityPolicy *string `type:"string"`
}

// String returns the string representation
func (s AwsElasticsearchDomainDomainEndpointOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainDomainEndpointOptions) GoString() string {
	return s.String()
}

// SetEnforceHTTPS sets the EnforceHTTPS field's value.
func (s *AwsElasticsearchDomainDomainEndpointOptions) SetEnforceHTTPS(v bool) *AwsElasticsearchDomainDomainEndpointOptions {
	s.EnforceHTTPS = &v
	return s
}

// SetTLSSecurityPolicy sets the TLSSecurityPolicy field's value.
func (s *AwsElasticsearchDomainDomainEndpointOptions) SetTLSSecurityPolicy(v string) *AwsElasticsearchDomainDomainEndpointOptions {
	s.TLSSecurityPolicy = &v
	return s
}

// Details about the configuration for encryption at rest.
type AwsElasticsearchDomainEncryptionAtRestOptions struct {
	_ struct{} `type:"structure"`

	// Whether encryption at rest is enabled.
	Enabled *bool `type:"boolean"`

	// The KMS key ID. Takes the form 1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a.
	KmsKeyId *string `type:"string"`
}

// String returns the string representation
func (s AwsElasticsearchDomainEncryptionAtRestOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainEncryptionAtRestOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElasticsearchDomainEncryptionAtRestOptions) SetEnabled(v bool) *AwsElasticsearchDomainEncryptionAtRestOptions {
	s.Enabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsElasticsearchDomainEncryptionAtRestOptions) SetKmsKeyId(v string) *AwsElasticsearchDomainEncryptionAtRestOptions {
	s.KmsKeyId = &v
	return s
}

// Details about the configuration for node-to-node encryption.
type AwsElasticsearchDomainNodeToNodeEncryptionOptions struct {
	_ struct{} `type:"structure"`

	// Whether node-to-node encryption is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsElasticsearchDomainNodeToNodeEncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainNodeToNodeEncryptionOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElasticsearchDomainNodeToNodeEncryptionOptions) SetEnabled(v bool) *AwsElasticsearchDomainNodeToNodeEncryptionOptions {
	s.Enabled = &v
	return s
}

// Information that Amazon ES derives based on VPCOptions for the domain.
type AwsElasticsearchDomainVPCOptions struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones associated with the VPC subnets.
	AvailabilityZones []*string `type:"list"`

	// The list of security group IDs associated with the VPC endpoints for the
	// domain.
	SecurityGroupIds []*string `type:"list"`

	// A list of subnet IDs associated with the VPC endpoints for the domain.
	SubnetIds []*string `type:"list"`

	// ID for the VPC.
	VPCId *string `type:"string"`
}

// String returns the string representation
func (s AwsElasticsearchDomainVPCOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElasticsearchDomainVPCOptions) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetAvailabilityZones(v []*string) *AwsElasticsearchDomainVPCOptions {
	s.AvailabilityZones = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetSecurityGroupIds(v []*string) *AwsElasticsearchDomainVPCOptions {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetSubnetIds(v []*string) *AwsElasticsearchDomainVPCOptions {
	s.SubnetIds = v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *AwsElasticsearchDomainVPCOptions) SetVPCId(v string) *AwsElasticsearchDomainVPCOptions {
	s.VPCId = &v
	return s
}

// Contains information about a stickiness policy that was created using CreateAppCookieStickinessPolicy.
type AwsElbAppCookieStickinessPolicy struct {
	_ struct{} `type:"structure"`

	// The name of the application cookie used for stickiness.
	CookieName *string `type:"string"`

	// The mnemonic name for the policy being created. The name must be unique within
	// the set of policies for the load balancer.
	PolicyName *string `type:"string"`
}

// String returns the string representation
func (s AwsElbAppCookieStickinessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbAppCookieStickinessPolicy) GoString() string {
	return s.String()
}

// SetCookieName sets the CookieName field's value.
func (s *AwsElbAppCookieStickinessPolicy) SetCookieName(v string) *AwsElbAppCookieStickinessPolicy {
	s.CookieName = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsElbAppCookieStickinessPolicy) SetPolicyName(v string) *AwsElbAppCookieStickinessPolicy {
	s.PolicyName = &v
	return s
}

// Contains information about a stickiness policy that was created using CreateLBCookieStickinessPolicy.
type AwsElbLbCookieStickinessPolicy struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, after which the cookie is considered stale.
	// If an expiration period is not specified, the stickiness session lasts for
	// the duration of the browser session.
	CookieExpirationPeriod *int64 `type:"long"`

	// The name of the policy. The name must be unique within the set of policies
	// for the load balancer.
	PolicyName *string `type:"string"`
}

// String returns the string representation
func (s AwsElbLbCookieStickinessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLbCookieStickinessPolicy) GoString() string {
	return s.String()
}

// SetCookieExpirationPeriod sets the CookieExpirationPeriod field's value.
func (s *AwsElbLbCookieStickinessPolicy) SetCookieExpirationPeriod(v int64) *AwsElbLbCookieStickinessPolicy {
	s.CookieExpirationPeriod = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsElbLbCookieStickinessPolicy) SetPolicyName(v string) *AwsElbLbCookieStickinessPolicy {
	s.PolicyName = &v
	return s
}

// Contains information about the access log configuration for the load balancer.
type AwsElbLoadBalancerAccessLog struct {
	_ struct{} `type:"structure"`

	// The interval in minutes for publishing the access logs.
	//
	// You can publish access logs either every 5 minutes or every 60 minutes.
	EmitInterval *int64 `type:"integer"`

	// Indicates whether access logs are enabled for the load balancer.
	Enabled *bool `type:"boolean"`

	// The name of the S3 bucket where the access logs are stored.
	S3BucketName *string `type:"string"`

	// The logical hierarchy that was created for the S3 bucket.
	//
	// If a prefix is not provided, the log is placed at the root level of the bucket.
	S3BucketPrefix *string `type:"string"`
}

// String returns the string representation
func (s AwsElbLoadBalancerAccessLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerAccessLog) GoString() string {
	return s.String()
}

// SetEmitInterval sets the EmitInterval field's value.
func (s *AwsElbLoadBalancerAccessLog) SetEmitInterval(v int64) *AwsElbLoadBalancerAccessLog {
	s.EmitInterval = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElbLoadBalancerAccessLog) SetEnabled(v bool) *AwsElbLoadBalancerAccessLog {
	s.Enabled = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *AwsElbLoadBalancerAccessLog) SetS3BucketName(v string) *AwsElbLoadBalancerAccessLog {
	s.S3BucketName = &v
	return s
}

// SetS3BucketPrefix sets the S3BucketPrefix field's value.
func (s *AwsElbLoadBalancerAccessLog) SetS3BucketPrefix(v string) *AwsElbLoadBalancerAccessLog {
	s.S3BucketPrefix = &v
	return s
}

// Contains attributes for the load balancer.
type AwsElbLoadBalancerAttributes struct {
	_ struct{} `type:"structure"`

	// Information about the access log configuration for the load balancer.
	//
	// If the access log is enabled, the load balancer captures detailed information
	// about all requests. It delivers the information to a specified S3 bucket.
	AccessLog *AwsElbLoadBalancerAccessLog `type:"structure"`

	// Information about the connection draining configuration for the load balancer.
	//
	// If connection draining is enabled, the load balancer allows existing requests
	// to complete before it shifts traffic away from a deregistered or unhealthy
	// instance.
	ConnectionDraining *AwsElbLoadBalancerConnectionDraining `type:"structure"`

	// Connection settings for the load balancer.
	//
	// If an idle timeout is configured, the load balancer allows connections to
	// remain idle for the specified duration. When a connection is idle, no data
	// is sent over the connection.
	ConnectionSettings *AwsElbLoadBalancerConnectionSettings `type:"structure"`

	// Cross-zone load balancing settings for the load balancer.
	//
	// If cross-zone load balancing is enabled, the load balancer routes the request
	// traffic evenly across all instances regardless of the Availability Zones.
	CrossZoneLoadBalancing *AwsElbLoadBalancerCrossZoneLoadBalancing `type:"structure"`
}

// String returns the string representation
func (s AwsElbLoadBalancerAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerAttributes) GoString() string {
	return s.String()
}

// SetAccessLog sets the AccessLog field's value.
func (s *AwsElbLoadBalancerAttributes) SetAccessLog(v *AwsElbLoadBalancerAccessLog) *AwsElbLoadBalancerAttributes {
	s.AccessLog = v
	return s
}

// SetConnectionDraining sets the ConnectionDraining field's value.
func (s *AwsElbLoadBalancerAttributes) SetConnectionDraining(v *AwsElbLoadBalancerConnectionDraining) *AwsElbLoadBalancerAttributes {
	s.ConnectionDraining = v
	return s
}

// SetConnectionSettings sets the ConnectionSettings field's value.
func (s *AwsElbLoadBalancerAttributes) SetConnectionSettings(v *AwsElbLoadBalancerConnectionSettings) *AwsElbLoadBalancerAttributes {
	s.ConnectionSettings = v
	return s
}

// SetCrossZoneLoadBalancing sets the CrossZoneLoadBalancing field's value.
func (s *AwsElbLoadBalancerAttributes) SetCrossZoneLoadBalancing(v *AwsElbLoadBalancerCrossZoneLoadBalancing) *AwsElbLoadBalancerAttributes {
	s.CrossZoneLoadBalancing = v
	return s
}

// Provides information about the configuration of an EC2 instance for the load
// balancer.
type AwsElbLoadBalancerBackendServerDescription struct {
	_ struct{} `type:"structure"`

	// The port on which the EC2 instance is listening.
	InstancePort *int64 `type:"integer"`

	// The names of the policies that are enabled for the EC2 instance.
	PolicyNames []*string `type:"list"`
}

// String returns the string representation
func (s AwsElbLoadBalancerBackendServerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerBackendServerDescription) GoString() string {
	return s.String()
}

// SetInstancePort sets the InstancePort field's value.
func (s *AwsElbLoadBalancerBackendServerDescription) SetInstancePort(v int64) *AwsElbLoadBalancerBackendServerDescription {
	s.InstancePort = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *AwsElbLoadBalancerBackendServerDescription) SetPolicyNames(v []*string) *AwsElbLoadBalancerBackendServerDescription {
	s.PolicyNames = v
	return s
}

// Contains information about the connection draining configuration for the
// load balancer.
type AwsElbLoadBalancerConnectionDraining struct {
	_ struct{} `type:"structure"`

	// Indicates whether connection draining is enabled for the load balancer.
	Enabled *bool `type:"boolean"`

	// The maximum time, in seconds, to keep the existing connections open before
	// deregistering the instances.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsElbLoadBalancerConnectionDraining) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerConnectionDraining) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElbLoadBalancerConnectionDraining) SetEnabled(v bool) *AwsElbLoadBalancerConnectionDraining {
	s.Enabled = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AwsElbLoadBalancerConnectionDraining) SetTimeout(v int64) *AwsElbLoadBalancerConnectionDraining {
	s.Timeout = &v
	return s
}

// Contains connection settings for the load balancer.
type AwsElbLoadBalancerConnectionSettings struct {
	_ struct{} `type:"structure"`

	// The time, in seconds, that the connection can be idle (no data is sent over
	// the connection) before it is closed by the load balancer.
	IdleTimeout *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsElbLoadBalancerConnectionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerConnectionSettings) GoString() string {
	return s.String()
}

// SetIdleTimeout sets the IdleTimeout field's value.
func (s *AwsElbLoadBalancerConnectionSettings) SetIdleTimeout(v int64) *AwsElbLoadBalancerConnectionSettings {
	s.IdleTimeout = &v
	return s
}

// Contains cross-zone load balancing settings for the load balancer.
type AwsElbLoadBalancerCrossZoneLoadBalancing struct {
	_ struct{} `type:"structure"`

	// Indicates whether cross-zone load balancing is enabled for the load balancer.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsElbLoadBalancerCrossZoneLoadBalancing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerCrossZoneLoadBalancing) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AwsElbLoadBalancerCrossZoneLoadBalancing) SetEnabled(v bool) *AwsElbLoadBalancerCrossZoneLoadBalancing {
	s.Enabled = &v
	return s
}

// Contains details about a Classic Load Balancer.
type AwsElbLoadBalancerDetails struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones for the load balancer.
	AvailabilityZones []*string `type:"list"`

	// Information about the configuration of the EC2 instances.
	BackendServerDescriptions []*AwsElbLoadBalancerBackendServerDescription `type:"list"`

	// The name of the Amazon Route 53 hosted zone for the load balancer.
	CanonicalHostedZoneName *string `type:"string"`

	// The ID of the Amazon Route 53 hosted zone for the load balancer.
	CanonicalHostedZoneNameID *string `type:"string"`

	// Indicates when the load balancer was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string `type:"string"`

	// The DNS name of the load balancer.
	DnsName *string `type:"string"`

	// Information about the health checks that are conducted on the load balancer.
	HealthCheck *AwsElbLoadBalancerHealthCheck `type:"structure"`

	// List of EC2 instances for the load balancer.
	Instances []*AwsElbLoadBalancerInstance `type:"list"`

	// The policies that are enabled for the load balancer listeners.
	ListenerDescriptions []*AwsElbLoadBalancerListenerDescription `type:"list"`

	// The attributes for a load balancer.
	LoadBalancerAttributes *AwsElbLoadBalancerAttributes `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The policies for a load balancer.
	Policies *AwsElbLoadBalancerPolicies `type:"structure"`

	// The type of load balancer. Only provided if the load balancer is in a VPC.
	//
	// If Scheme is internet-facing, the load balancer has a public DNS name that
	// resolves to a public IP address.
	//
	// If Scheme is internal, the load balancer has a public DNS name that resolves
	// to a private IP address.
	Scheme *string `type:"string"`

	// The security groups for the load balancer. Only provided if the load balancer
	// is in a VPC.
	SecurityGroups []*string `type:"list"`

	// Information about the security group for the load balancer. This is the security
	// group that is used for inbound rules.
	SourceSecurityGroup *AwsElbLoadBalancerSourceSecurityGroup `type:"structure"`

	// The list of subnet identifiers for the load balancer.
	Subnets []*string `type:"list"`

	// The identifier of the VPC for the load balancer.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsElbLoadBalancerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsElbLoadBalancerDetails) SetAvailabilityZones(v []*string) *AwsElbLoadBalancerDetails {
	s.AvailabilityZones = v
	return s
}

// SetBackendServerDescriptions sets the BackendServerDescriptions field's value.
func (s *AwsElbLoadBalancerDetails) SetBackendServerDescriptions(v []*AwsElbLoadBalancerBackendServerDescription) *AwsElbLoadBalancerDetails {
	s.BackendServerDescriptions = v
	return s
}

// SetCanonicalHostedZoneName sets the CanonicalHostedZoneName field's value.
func (s *AwsElbLoadBalancerDetails) SetCanonicalHostedZoneName(v string) *AwsElbLoadBalancerDetails {
	s.CanonicalHostedZoneName = &v
	return s
}

// SetCanonicalHostedZoneNameID sets the CanonicalHostedZoneNameID field's value.
func (s *AwsElbLoadBalancerDetails) SetCanonicalHostedZoneNameID(v string) *AwsElbLoadBalancerDetails {
	s.CanonicalHostedZoneNameID = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsElbLoadBalancerDetails) SetCreatedTime(v string) *AwsElbLoadBalancerDetails {
	s.CreatedTime = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *AwsElbLoadBalancerDetails) SetDnsName(v string) *AwsElbLoadBalancerDetails {
	s.DnsName = &v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *AwsElbLoadBalancerDetails) SetHealthCheck(v *AwsElbLoadBalancerHealthCheck) *AwsElbLoadBalancerDetails {
	s.HealthCheck = v
	return s
}

// SetInstances sets the Instances field's value.
func (s *AwsElbLoadBalancerDetails) SetInstances(v []*AwsElbLoadBalancerInstance) *AwsElbLoadBalancerDetails {
	s.Instances = v
	return s
}

// SetListenerDescriptions sets the ListenerDescriptions field's value.
func (s *AwsElbLoadBalancerDetails) SetListenerDescriptions(v []*AwsElbLoadBalancerListenerDescription) *AwsElbLoadBalancerDetails {
	s.ListenerDescriptions = v
	return s
}

// SetLoadBalancerAttributes sets the LoadBalancerAttributes field's value.
func (s *AwsElbLoadBalancerDetails) SetLoadBalancerAttributes(v *AwsElbLoadBalancerAttributes) *AwsElbLoadBalancerDetails {
	s.LoadBalancerAttributes = v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *AwsElbLoadBalancerDetails) SetLoadBalancerName(v string) *AwsElbLoadBalancerDetails {
	s.LoadBalancerName = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *AwsElbLoadBalancerDetails) SetPolicies(v *AwsElbLoadBalancerPolicies) *AwsElbLoadBalancerDetails {
	s.Policies = v
	return s
}

// SetScheme sets the Scheme field's value.
func (s *AwsElbLoadBalancerDetails) SetScheme(v string) *AwsElbLoadBalancerDetails {
	s.Scheme = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsElbLoadBalancerDetails) SetSecurityGroups(v []*string) *AwsElbLoadBalancerDetails {
	s.SecurityGroups = v
	return s
}

// SetSourceSecurityGroup sets the SourceSecurityGroup field's value.
func (s *AwsElbLoadBalancerDetails) SetSourceSecurityGroup(v *AwsElbLoadBalancerSourceSecurityGroup) *AwsElbLoadBalancerDetails {
	s.SourceSecurityGroup = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsElbLoadBalancerDetails) SetSubnets(v []*string) *AwsElbLoadBalancerDetails {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsElbLoadBalancerDetails) SetVpcId(v string) *AwsElbLoadBalancerDetails {
	s.VpcId = &v
	return s
}

// Contains information about the health checks that are conducted on the load
// balancer.
type AwsElbLoadBalancerHealthCheck struct {
	_ struct{} `type:"structure"`

	// The number of consecutive health check successes required before the instance
	// is moved to the Healthy state.
	HealthyThreshold *int64 `type:"integer"`

	// The approximate interval, in seconds, between health checks of an individual
	// instance.
	Interval *int64 `type:"integer"`

	// The instance that is being checked. The target specifies the protocol and
	// port. The available protocols are TCP, SSL, HTTP, and HTTPS. The range of
	// valid ports is 1 through 65535.
	//
	// For the HTTP and HTTPS protocols, the target also specifies the ping path.
	//
	// For the TCP protocol, the target is specified as TCP: <port> .
	//
	// For the SSL protocol, the target is specified as SSL.<port> .
	//
	// For the HTTP and HTTPS protocols, the target is specified as <protocol>:<port>/<path
	// to ping> .
	Target *string `type:"string"`

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	Timeout *int64 `type:"integer"`

	// The number of consecutive health check failures that must occur before the
	// instance is moved to the Unhealthy state.
	UnhealthyThreshold *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsElbLoadBalancerHealthCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerHealthCheck) GoString() string {
	return s.String()
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetHealthyThreshold(v int64) *AwsElbLoadBalancerHealthCheck {
	s.HealthyThreshold = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetInterval(v int64) *AwsElbLoadBalancerHealthCheck {
	s.Interval = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetTarget(v string) *AwsElbLoadBalancerHealthCheck {
	s.Target = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetTimeout(v int64) *AwsElbLoadBalancerHealthCheck {
	s.Timeout = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *AwsElbLoadBalancerHealthCheck) SetUnhealthyThreshold(v int64) *AwsElbLoadBalancerHealthCheck {
	s.UnhealthyThreshold = &v
	return s
}

// Provides information about an EC2 instance for a load balancer.
type AwsElbLoadBalancerInstance struct {
	_ struct{} `type:"structure"`

	// The instance identifier.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s AwsElbLoadBalancerInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerInstance) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *AwsElbLoadBalancerInstance) SetInstanceId(v string) *AwsElbLoadBalancerInstance {
	s.InstanceId = &v
	return s
}

// Information about a load balancer listener.
type AwsElbLoadBalancerListener struct {
	_ struct{} `type:"structure"`

	// The port on which the instance is listening.
	InstancePort *int64 `type:"integer"`

	// The protocol to use to route traffic to instances.
	//
	// Valid values: HTTP | HTTPS | TCP | SSL
	InstanceProtocol *string `type:"string"`

	// The port on which the load balancer is listening.
	//
	// On EC2-VPC, you can specify any port from the range 1-65535.
	//
	// On EC2-Classic, you can specify any port from the following list: 25, 80,
	// 443, 465, 587, 1024-65535.
	LoadBalancerPort *int64 `type:"integer"`

	// The load balancer transport protocol to use for routing.
	//
	// Valid values: HTTP | HTTPS | TCP | SSL
	Protocol *string `type:"string"`

	// The ARN of the server certificate.
	SslCertificateId *string `type:"string"`
}

// String returns the string representation
func (s AwsElbLoadBalancerListener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerListener) GoString() string {
	return s.String()
}

// SetInstancePort sets the InstancePort field's value.
func (s *AwsElbLoadBalancerListener) SetInstancePort(v int64) *AwsElbLoadBalancerListener {
	s.InstancePort = &v
	return s
}

// SetInstanceProtocol sets the InstanceProtocol field's value.
func (s *AwsElbLoadBalancerListener) SetInstanceProtocol(v string) *AwsElbLoadBalancerListener {
	s.InstanceProtocol = &v
	return s
}

// SetLoadBalancerPort sets the LoadBalancerPort field's value.
func (s *AwsElbLoadBalancerListener) SetLoadBalancerPort(v int64) *AwsElbLoadBalancerListener {
	s.LoadBalancerPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AwsElbLoadBalancerListener) SetProtocol(v string) *AwsElbLoadBalancerListener {
	s.Protocol = &v
	return s
}

// SetSslCertificateId sets the SslCertificateId field's value.
func (s *AwsElbLoadBalancerListener) SetSslCertificateId(v string) *AwsElbLoadBalancerListener {
	s.SslCertificateId = &v
	return s
}

// Lists the policies that are enabled for a load balancer listener.
type AwsElbLoadBalancerListenerDescription struct {
	_ struct{} `type:"structure"`

	// Information about the listener.
	Listener *AwsElbLoadBalancerListener `type:"structure"`

	// The policies enabled for the listener.
	PolicyNames []*string `type:"list"`
}

// String returns the string representation
func (s AwsElbLoadBalancerListenerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerListenerDescription) GoString() string {
	return s.String()
}

// SetListener sets the Listener field's value.
func (s *AwsElbLoadBalancerListenerDescription) SetListener(v *AwsElbLoadBalancerListener) *AwsElbLoadBalancerListenerDescription {
	s.Listener = v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *AwsElbLoadBalancerListenerDescription) SetPolicyNames(v []*string) *AwsElbLoadBalancerListenerDescription {
	s.PolicyNames = v
	return s
}

// Contains information about the policies for a load balancer.
type AwsElbLoadBalancerPolicies struct {
	_ struct{} `type:"structure"`

	// The stickiness policies that are created using CreateAppCookieStickinessPolicy.
	AppCookieStickinessPolicies []*AwsElbAppCookieStickinessPolicy `type:"list"`

	// The stickiness policies that are created using CreateLBCookieStickinessPolicy.
	LbCookieStickinessPolicies []*AwsElbLbCookieStickinessPolicy `type:"list"`

	// The policies other than the stickiness policies.
	OtherPolicies []*string `type:"list"`
}

// String returns the string representation
func (s AwsElbLoadBalancerPolicies) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerPolicies) GoString() string {
	return s.String()
}

// SetAppCookieStickinessPolicies sets the AppCookieStickinessPolicies field's value.
func (s *AwsElbLoadBalancerPolicies) SetAppCookieStickinessPolicies(v []*AwsElbAppCookieStickinessPolicy) *AwsElbLoadBalancerPolicies {
	s.AppCookieStickinessPolicies = v
	return s
}

// SetLbCookieStickinessPolicies sets the LbCookieStickinessPolicies field's value.
func (s *AwsElbLoadBalancerPolicies) SetLbCookieStickinessPolicies(v []*AwsElbLbCookieStickinessPolicy) *AwsElbLoadBalancerPolicies {
	s.LbCookieStickinessPolicies = v
	return s
}

// SetOtherPolicies sets the OtherPolicies field's value.
func (s *AwsElbLoadBalancerPolicies) SetOtherPolicies(v []*string) *AwsElbLoadBalancerPolicies {
	s.OtherPolicies = v
	return s
}

// Contains information about the security group for the load balancer.
type AwsElbLoadBalancerSourceSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The owner of the security group.
	OwnerAlias *string `type:"string"`
}

// String returns the string representation
func (s AwsElbLoadBalancerSourceSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbLoadBalancerSourceSecurityGroup) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *AwsElbLoadBalancerSourceSecurityGroup) SetGroupName(v string) *AwsElbLoadBalancerSourceSecurityGroup {
	s.GroupName = &v
	return s
}

// SetOwnerAlias sets the OwnerAlias field's value.
func (s *AwsElbLoadBalancerSourceSecurityGroup) SetOwnerAlias(v string) *AwsElbLoadBalancerSourceSecurityGroup {
	s.OwnerAlias = &v
	return s
}

// Information about a load balancer.
type AwsElbv2LoadBalancerDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zones for the load balancer.
	AvailabilityZones []*AvailabilityZone `type:"list"`

	// The ID of the Amazon Route 53 hosted zone associated with the load balancer.
	CanonicalHostedZoneId *string `type:"string"`

	// Indicates when the load balancer was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedTime *string `type:"string"`

	// The public DNS name of the load balancer.
	DNSName *string `type:"string"`

	// The type of IP addresses used by the subnets for your load balancer. The
	// possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and
	// IPv6 addresses).
	IpAddressType *string `type:"string"`

	// The nodes of an Internet-facing load balancer have public IP addresses.
	Scheme *string `type:"string"`

	// The IDs of the security groups for the load balancer.
	SecurityGroups []*string `type:"list"`

	// The state of the load balancer.
	State *LoadBalancerState `type:"structure"`

	// The type of load balancer.
	Type *string `type:"string"`

	// The ID of the VPC for the load balancer.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsElbv2LoadBalancerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsElbv2LoadBalancerDetails) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsElbv2LoadBalancerDetails) SetAvailabilityZones(v []*AvailabilityZone) *AwsElbv2LoadBalancerDetails {
	s.AvailabilityZones = v
	return s
}

// SetCanonicalHostedZoneId sets the CanonicalHostedZoneId field's value.
func (s *AwsElbv2LoadBalancerDetails) SetCanonicalHostedZoneId(v string) *AwsElbv2LoadBalancerDetails {
	s.CanonicalHostedZoneId = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AwsElbv2LoadBalancerDetails) SetCreatedTime(v string) *AwsElbv2LoadBalancerDetails {
	s.CreatedTime = &v
	return s
}

// SetDNSName sets the DNSName field's value.
func (s *AwsElbv2LoadBalancerDetails) SetDNSName(v string) *AwsElbv2LoadBalancerDetails {
	s.DNSName = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *AwsElbv2LoadBalancerDetails) SetIpAddressType(v string) *AwsElbv2LoadBalancerDetails {
	s.IpAddressType = &v
	return s
}

// SetScheme sets the Scheme field's value.
func (s *AwsElbv2LoadBalancerDetails) SetScheme(v string) *AwsElbv2LoadBalancerDetails {
	s.Scheme = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsElbv2LoadBalancerDetails) SetSecurityGroups(v []*string) *AwsElbv2LoadBalancerDetails {
	s.SecurityGroups = v
	return s
}

// SetState sets the State field's value.
func (s *AwsElbv2LoadBalancerDetails) SetState(v *LoadBalancerState) *AwsElbv2LoadBalancerDetails {
	s.State = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsElbv2LoadBalancerDetails) SetType(v string) *AwsElbv2LoadBalancerDetails {
	s.Type = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsElbv2LoadBalancerDetails) SetVpcId(v string) *AwsElbv2LoadBalancerDetails {
	s.VpcId = &v
	return s
}

// IAM access key details related to a finding.
type AwsIamAccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the access key.
	AccessKeyId *string `type:"string"`

	// The AWS account ID of the account for the key.
	AccountId *string `type:"string"`

	// Indicates when the IAM access key was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *string `type:"string"`

	// The ID of the principal associated with an access key.
	PrincipalId *string `type:"string"`

	// The name of the principal.
	PrincipalName *string `type:"string"`

	// The type of principal associated with an access key.
	PrincipalType *string `type:"string"`

	// Information about the session that the key was used for.
	SessionContext *AwsIamAccessKeySessionContext `type:"structure"`

	// The status of the IAM access key related to a finding.
	Status *string `type:"string" enum:"AwsIamAccessKeyStatus"`

	// The user associated with the IAM access key related to a finding.
	//
	// The UserName parameter has been replaced with the PrincipalName parameter
	// because access keys can also be assigned to principals that are not IAM users.
	//
	// Deprecated: This field is deprecated, use PrincipalName instead.
	UserName *string `deprecated:"true" type:"string"`
}

// String returns the string representation
func (s AwsIamAccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamAccessKeyDetails) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AwsIamAccessKeyDetails) SetAccessKeyId(v string) *AwsIamAccessKeyDetails {
	s.AccessKeyId = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *AwsIamAccessKeyDetails) SetAccountId(v string) *AwsIamAccessKeyDetails {
	s.AccountId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsIamAccessKeyDetails) SetCreatedAt(v string) *AwsIamAccessKeyDetails {
	s.CreatedAt = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AwsIamAccessKeyDetails) SetPrincipalId(v string) *AwsIamAccessKeyDetails {
	s.PrincipalId = &v
	return s
}

// SetPrincipalName sets the PrincipalName field's value.
func (s *AwsIamAccessKeyDetails) SetPrincipalName(v string) *AwsIamAccessKeyDetails {
	s.PrincipalName = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AwsIamAccessKeyDetails) SetPrincipalType(v string) *AwsIamAccessKeyDetails {
	s.PrincipalType = &v
	return s
}

// SetSessionContext sets the SessionContext field's value.
func (s *AwsIamAccessKeyDetails) SetSessionContext(v *AwsIamAccessKeySessionContext) *AwsIamAccessKeyDetails {
	s.SessionContext = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsIamAccessKeyDetails) SetStatus(v string) *AwsIamAccessKeyDetails {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AwsIamAccessKeyDetails) SetUserName(v string) *AwsIamAccessKeyDetails {
	s.UserName = &v
	return s
}

// Provides information about the session that the key was used for.
type AwsIamAccessKeySessionContext struct {
	_ struct{} `type:"structure"`

	// Attributes of the session that the key was used for.
	Attributes *AwsIamAccessKeySessionContextAttributes `type:"structure"`

	// Information about the entity that created the session.
	SessionIssuer *AwsIamAccessKeySessionContextSessionIssuer `type:"structure"`
}

// String returns the string representation
func (s AwsIamAccessKeySessionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamAccessKeySessionContext) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *AwsIamAccessKeySessionContext) SetAttributes(v *AwsIamAccessKeySessionContextAttributes) *AwsIamAccessKeySessionContext {
	s.Attributes = v
	return s
}

// SetSessionIssuer sets the SessionIssuer field's value.
func (s *AwsIamAccessKeySessionContext) SetSessionIssuer(v *AwsIamAccessKeySessionContextSessionIssuer) *AwsIamAccessKeySessionContext {
	s.SessionIssuer = v
	return s
}

// Attributes of the session that the key was used for.
type AwsIamAccessKeySessionContextAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates when the session was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreationDate *string `type:"string"`

	// Indicates whether the session used multi-factor authentication (MFA).
	MfaAuthenticated *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsIamAccessKeySessionContextAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamAccessKeySessionContextAttributes) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *AwsIamAccessKeySessionContextAttributes) SetCreationDate(v string) *AwsIamAccessKeySessionContextAttributes {
	s.CreationDate = &v
	return s
}

// SetMfaAuthenticated sets the MfaAuthenticated field's value.
func (s *AwsIamAccessKeySessionContextAttributes) SetMfaAuthenticated(v bool) *AwsIamAccessKeySessionContextAttributes {
	s.MfaAuthenticated = &v
	return s
}

// Information about the entity that created the session.
type AwsIamAccessKeySessionContextSessionIssuer struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS account that created the session.
	AccountId *string `type:"string"`

	// The ARN of the session.
	Arn *string `type:"string"`

	// The principal ID of the principal (user, role, or group) that created the
	// session.
	PrincipalId *string `type:"string"`

	// The type of principal (user, role, or group) that created the session.
	Type *string `type:"string"`

	// The name of the principal that created the session.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamAccessKeySessionContextSessionIssuer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamAccessKeySessionContextSessionIssuer) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetAccountId(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetArn(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.Arn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetPrincipalId(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.PrincipalId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetType(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.Type = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AwsIamAccessKeySessionContextSessionIssuer) SetUserName(v string) *AwsIamAccessKeySessionContextSessionIssuer {
	s.UserName = &v
	return s
}

// A managed policy that is attached to an IAM principal.
type AwsIamAttachedManagedPolicy struct {
	_ struct{} `type:"structure"`

	// The ARN of the policy.
	PolicyArn *string `type:"string"`

	// The name of the policy.
	PolicyName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamAttachedManagedPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamAttachedManagedPolicy) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *AwsIamAttachedManagedPolicy) SetPolicyArn(v string) *AwsIamAttachedManagedPolicy {
	s.PolicyArn = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamAttachedManagedPolicy) SetPolicyName(v string) *AwsIamAttachedManagedPolicy {
	s.PolicyName = &v
	return s
}

// Contains details about an IAM group.
type AwsIamGroupDetails struct {
	_ struct{} `type:"structure"`

	// A list of the managed policies that are attached to the IAM group.
	AttachedManagedPolicies []*AwsIamAttachedManagedPolicy `type:"list"`

	// Indicates when the IAM group was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The identifier of the IAM group.
	GroupId *string `type:"string"`

	// The name of the IAM group.
	GroupName *string `type:"string"`

	// The list of inline policies that are embedded in the group.
	GroupPolicyList []*AwsIamGroupPolicy `type:"list"`

	// The path to the group.
	Path *string `type:"string"`
}

// String returns the string representation
func (s AwsIamGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamGroupDetails) GoString() string {
	return s.String()
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *AwsIamGroupDetails) SetAttachedManagedPolicies(v []*AwsIamAttachedManagedPolicy) *AwsIamGroupDetails {
	s.AttachedManagedPolicies = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamGroupDetails) SetCreateDate(v string) *AwsIamGroupDetails {
	s.CreateDate = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *AwsIamGroupDetails) SetGroupId(v string) *AwsIamGroupDetails {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AwsIamGroupDetails) SetGroupName(v string) *AwsIamGroupDetails {
	s.GroupName = &v
	return s
}

// SetGroupPolicyList sets the GroupPolicyList field's value.
func (s *AwsIamGroupDetails) SetGroupPolicyList(v []*AwsIamGroupPolicy) *AwsIamGroupDetails {
	s.GroupPolicyList = v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamGroupDetails) SetPath(v string) *AwsIamGroupDetails {
	s.Path = &v
	return s
}

// A managed policy that is attached to the IAM group.
type AwsIamGroupPolicy struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamGroupPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamGroupPolicy) GoString() string {
	return s.String()
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamGroupPolicy) SetPolicyName(v string) *AwsIamGroupPolicy {
	s.PolicyName = &v
	return s
}

// Information about an instance profile.
type AwsIamInstanceProfile struct {
	_ struct{} `type:"structure"`

	// The ARN of the instance profile.
	Arn *string `type:"string"`

	// Indicates when the instance profile was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The identifier of the instance profile.
	InstanceProfileId *string `type:"string"`

	// The name of the instance profile.
	InstanceProfileName *string `type:"string"`

	// The path to the instance profile.
	Path *string `type:"string"`

	// The roles associated with the instance profile.
	Roles []*AwsIamInstanceProfileRole `type:"list"`
}

// String returns the string representation
func (s AwsIamInstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamInstanceProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIamInstanceProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIamInstanceProfile"}
	if s.Roles != nil {
		for i, v := range s.Roles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Roles", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AwsIamInstanceProfile) SetArn(v string) *AwsIamInstanceProfile {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamInstanceProfile) SetCreateDate(v string) *AwsIamInstanceProfile {
	s.CreateDate = &v
	return s
}

// SetInstanceProfileId sets the InstanceProfileId field's value.
func (s *AwsIamInstanceProfile) SetInstanceProfileId(v string) *AwsIamInstanceProfile {
	s.InstanceProfileId = &v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *AwsIamInstanceProfile) SetInstanceProfileName(v string) *AwsIamInstanceProfile {
	s.InstanceProfileName = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamInstanceProfile) SetPath(v string) *AwsIamInstanceProfile {
	s.Path = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *AwsIamInstanceProfile) SetRoles(v []*AwsIamInstanceProfileRole) *AwsIamInstanceProfile {
	s.Roles = v
	return s
}

// Information about a role associated with an instance profile.
type AwsIamInstanceProfileRole struct {
	_ struct{} `type:"structure"`

	// The ARN of the role.
	Arn *string `type:"string"`

	// The policy that grants an entity permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// Indicates when the role was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The path to the role.
	Path *string `type:"string"`

	// The identifier of the role.
	RoleId *string `type:"string"`

	// The name of the role.
	RoleName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamInstanceProfileRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamInstanceProfileRole) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIamInstanceProfileRole) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIamInstanceProfileRole"}
	if s.AssumeRolePolicyDocument != nil && len(*s.AssumeRolePolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssumeRolePolicyDocument", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AwsIamInstanceProfileRole) SetArn(v string) *AwsIamInstanceProfileRole {
	s.Arn = &v
	return s
}

// SetAssumeRolePolicyDocument sets the AssumeRolePolicyDocument field's value.
func (s *AwsIamInstanceProfileRole) SetAssumeRolePolicyDocument(v string) *AwsIamInstanceProfileRole {
	s.AssumeRolePolicyDocument = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamInstanceProfileRole) SetCreateDate(v string) *AwsIamInstanceProfileRole {
	s.CreateDate = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamInstanceProfileRole) SetPath(v string) *AwsIamInstanceProfileRole {
	s.Path = &v
	return s
}

// SetRoleId sets the RoleId field's value.
func (s *AwsIamInstanceProfileRole) SetRoleId(v string) *AwsIamInstanceProfileRole {
	s.RoleId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *AwsIamInstanceProfileRole) SetRoleName(v string) *AwsIamInstanceProfileRole {
	s.RoleName = &v
	return s
}

// Information about the policy used to set the permissions boundary for an
// IAM principal.
type AwsIamPermissionsBoundary struct {
	_ struct{} `type:"structure"`

	// The ARN of the policy used to set the permissions boundary.
	PermissionsBoundaryArn *string `type:"string"`

	// The usage type for the permissions boundary.
	PermissionsBoundaryType *string `type:"string"`
}

// String returns the string representation
func (s AwsIamPermissionsBoundary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamPermissionsBoundary) GoString() string {
	return s.String()
}

// SetPermissionsBoundaryArn sets the PermissionsBoundaryArn field's value.
func (s *AwsIamPermissionsBoundary) SetPermissionsBoundaryArn(v string) *AwsIamPermissionsBoundary {
	s.PermissionsBoundaryArn = &v
	return s
}

// SetPermissionsBoundaryType sets the PermissionsBoundaryType field's value.
func (s *AwsIamPermissionsBoundary) SetPermissionsBoundaryType(v string) *AwsIamPermissionsBoundary {
	s.PermissionsBoundaryType = &v
	return s
}

// Represents an IAM permissions policy.
type AwsIamPolicyDetails struct {
	_ struct{} `type:"structure"`

	// The number of users, groups, and roles that the policy is attached to.
	AttachmentCount *int64 `type:"integer"`

	// When the policy was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The identifier of the default version of the policy.
	DefaultVersionId *string `type:"string"`

	// A description of the policy.
	Description *string `type:"string"`

	// Whether the policy can be attached to a user, group, or role.
	IsAttachable *bool `type:"boolean"`

	// The path to the policy.
	Path *string `type:"string"`

	// The number of users and roles that use the policy to set the permissions
	// boundary.
	PermissionsBoundaryUsageCount *int64 `type:"integer"`

	// The unique identifier of the policy.
	PolicyId *string `type:"string"`

	// The name of the policy.
	PolicyName *string `type:"string"`

	// List of versions of the policy.
	PolicyVersionList []*AwsIamPolicyVersion `type:"list"`

	// When the policy was most recently updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	UpdateDate *string `type:"string"`
}

// String returns the string representation
func (s AwsIamPolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamPolicyDetails) GoString() string {
	return s.String()
}

// SetAttachmentCount sets the AttachmentCount field's value.
func (s *AwsIamPolicyDetails) SetAttachmentCount(v int64) *AwsIamPolicyDetails {
	s.AttachmentCount = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamPolicyDetails) SetCreateDate(v string) *AwsIamPolicyDetails {
	s.CreateDate = &v
	return s
}

// SetDefaultVersionId sets the DefaultVersionId field's value.
func (s *AwsIamPolicyDetails) SetDefaultVersionId(v string) *AwsIamPolicyDetails {
	s.DefaultVersionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsIamPolicyDetails) SetDescription(v string) *AwsIamPolicyDetails {
	s.Description = &v
	return s
}

// SetIsAttachable sets the IsAttachable field's value.
func (s *AwsIamPolicyDetails) SetIsAttachable(v bool) *AwsIamPolicyDetails {
	s.IsAttachable = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamPolicyDetails) SetPath(v string) *AwsIamPolicyDetails {
	s.Path = &v
	return s
}

// SetPermissionsBoundaryUsageCount sets the PermissionsBoundaryUsageCount field's value.
func (s *AwsIamPolicyDetails) SetPermissionsBoundaryUsageCount(v int64) *AwsIamPolicyDetails {
	s.PermissionsBoundaryUsageCount = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *AwsIamPolicyDetails) SetPolicyId(v string) *AwsIamPolicyDetails {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamPolicyDetails) SetPolicyName(v string) *AwsIamPolicyDetails {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionList sets the PolicyVersionList field's value.
func (s *AwsIamPolicyDetails) SetPolicyVersionList(v []*AwsIamPolicyVersion) *AwsIamPolicyDetails {
	s.PolicyVersionList = v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *AwsIamPolicyDetails) SetUpdateDate(v string) *AwsIamPolicyDetails {
	s.UpdateDate = &v
	return s
}

// A version of an IAM policy.
type AwsIamPolicyVersion struct {
	_ struct{} `type:"structure"`

	// Indicates when the version was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// Whether the version is the default version.
	IsDefaultVersion *bool `type:"boolean"`

	// The identifier of the policy version.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s AwsIamPolicyVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamPolicyVersion) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamPolicyVersion) SetCreateDate(v string) *AwsIamPolicyVersion {
	s.CreateDate = &v
	return s
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *AwsIamPolicyVersion) SetIsDefaultVersion(v bool) *AwsIamPolicyVersion {
	s.IsDefaultVersion = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *AwsIamPolicyVersion) SetVersionId(v string) *AwsIamPolicyVersion {
	s.VersionId = &v
	return s
}

// Contains information about an IAM role, including all of the role's policies.
type AwsIamRoleDetails struct {
	_ struct{} `type:"structure"`

	// The trust policy that grants permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// The list of the managed policies that are attached to the role.
	AttachedManagedPolicies []*AwsIamAttachedManagedPolicy `type:"list"`

	// Indicates when the role was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// The list of instance profiles that contain this role.
	InstanceProfileList []*AwsIamInstanceProfile `type:"list"`

	// The maximum session duration (in seconds) that you want to set for the specified
	// role.
	MaxSessionDuration *int64 `type:"integer"`

	// The path to the role.
	Path *string `type:"string"`

	// Information about the policy used to set the permissions boundary for an
	// IAM principal.
	PermissionsBoundary *AwsIamPermissionsBoundary `type:"structure"`

	// The stable and unique string identifying the role.
	RoleId *string `type:"string"`

	// The friendly name that identifies the role.
	RoleName *string `type:"string"`

	// The list of inline policies that are embedded in the role.
	RolePolicyList []*AwsIamRolePolicy `type:"list"`
}

// String returns the string representation
func (s AwsIamRoleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamRoleDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIamRoleDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIamRoleDetails"}
	if s.AssumeRolePolicyDocument != nil && len(*s.AssumeRolePolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssumeRolePolicyDocument", 1))
	}
	if s.InstanceProfileList != nil {
		for i, v := range s.InstanceProfileList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceProfileList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssumeRolePolicyDocument sets the AssumeRolePolicyDocument field's value.
func (s *AwsIamRoleDetails) SetAssumeRolePolicyDocument(v string) *AwsIamRoleDetails {
	s.AssumeRolePolicyDocument = &v
	return s
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *AwsIamRoleDetails) SetAttachedManagedPolicies(v []*AwsIamAttachedManagedPolicy) *AwsIamRoleDetails {
	s.AttachedManagedPolicies = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamRoleDetails) SetCreateDate(v string) *AwsIamRoleDetails {
	s.CreateDate = &v
	return s
}

// SetInstanceProfileList sets the InstanceProfileList field's value.
func (s *AwsIamRoleDetails) SetInstanceProfileList(v []*AwsIamInstanceProfile) *AwsIamRoleDetails {
	s.InstanceProfileList = v
	return s
}

// SetMaxSessionDuration sets the MaxSessionDuration field's value.
func (s *AwsIamRoleDetails) SetMaxSessionDuration(v int64) *AwsIamRoleDetails {
	s.MaxSessionDuration = &v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamRoleDetails) SetPath(v string) *AwsIamRoleDetails {
	s.Path = &v
	return s
}

// SetPermissionsBoundary sets the PermissionsBoundary field's value.
func (s *AwsIamRoleDetails) SetPermissionsBoundary(v *AwsIamPermissionsBoundary) *AwsIamRoleDetails {
	s.PermissionsBoundary = v
	return s
}

// SetRoleId sets the RoleId field's value.
func (s *AwsIamRoleDetails) SetRoleId(v string) *AwsIamRoleDetails {
	s.RoleId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *AwsIamRoleDetails) SetRoleName(v string) *AwsIamRoleDetails {
	s.RoleName = &v
	return s
}

// SetRolePolicyList sets the RolePolicyList field's value.
func (s *AwsIamRoleDetails) SetRolePolicyList(v []*AwsIamRolePolicy) *AwsIamRoleDetails {
	s.RolePolicyList = v
	return s
}

// An inline policy that is embedded in the role.
type AwsIamRolePolicy struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamRolePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamRolePolicy) GoString() string {
	return s.String()
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamRolePolicy) SetPolicyName(v string) *AwsIamRolePolicy {
	s.PolicyName = &v
	return s
}

// Information about an IAM user.
type AwsIamUserDetails struct {
	_ struct{} `type:"structure"`

	// A list of the managed policies that are attached to the user.
	AttachedManagedPolicies []*AwsIamAttachedManagedPolicy `type:"list"`

	// Indicates when the user was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreateDate *string `type:"string"`

	// A list of IAM groups that the user belongs to.
	GroupList []*string `type:"list"`

	// The path to the user.
	Path *string `type:"string"`

	// The permissions boundary for the user.
	PermissionsBoundary *AwsIamPermissionsBoundary `type:"structure"`

	// The unique identifier for the user.
	UserId *string `type:"string"`

	// The name of the user.
	UserName *string `type:"string"`

	// The list of inline policies that are embedded in the user.
	UserPolicyList []*AwsIamUserPolicy `type:"list"`
}

// String returns the string representation
func (s AwsIamUserDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamUserDetails) GoString() string {
	return s.String()
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *AwsIamUserDetails) SetAttachedManagedPolicies(v []*AwsIamAttachedManagedPolicy) *AwsIamUserDetails {
	s.AttachedManagedPolicies = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AwsIamUserDetails) SetCreateDate(v string) *AwsIamUserDetails {
	s.CreateDate = &v
	return s
}

// SetGroupList sets the GroupList field's value.
func (s *AwsIamUserDetails) SetGroupList(v []*string) *AwsIamUserDetails {
	s.GroupList = v
	return s
}

// SetPath sets the Path field's value.
func (s *AwsIamUserDetails) SetPath(v string) *AwsIamUserDetails {
	s.Path = &v
	return s
}

// SetPermissionsBoundary sets the PermissionsBoundary field's value.
func (s *AwsIamUserDetails) SetPermissionsBoundary(v *AwsIamPermissionsBoundary) *AwsIamUserDetails {
	s.PermissionsBoundary = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *AwsIamUserDetails) SetUserId(v string) *AwsIamUserDetails {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AwsIamUserDetails) SetUserName(v string) *AwsIamUserDetails {
	s.UserName = &v
	return s
}

// SetUserPolicyList sets the UserPolicyList field's value.
func (s *AwsIamUserDetails) SetUserPolicyList(v []*AwsIamUserPolicy) *AwsIamUserDetails {
	s.UserPolicyList = v
	return s
}

// Information about an inline policy that is embedded in the user.
type AwsIamUserPolicy struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	PolicyName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamUserPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsIamUserPolicy) GoString() string {
	return s.String()
}

// SetPolicyName sets the PolicyName field's value.
func (s *AwsIamUserPolicy) SetPolicyName(v string) *AwsIamUserPolicy {
	s.PolicyName = &v
	return s
}

// Contains metadata about a customer master key (CMK).
type AwsKmsKeyDetails struct {
	_ struct{} `type:"structure"`

	// The twelve-digit account ID of the AWS account that owns the CMK.
	AWSAccountId *string `type:"string"`

	// Indicates when the CMK was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreationDate *float64 `type:"double"`

	// A description of the key.
	Description *string `type:"string"`

	// The globally unique identifier for the CMK.
	KeyId *string `type:"string"`

	// The manager of the CMK. CMKs in your AWS account are either customer managed
	// or AWS managed.
	KeyManager *string `type:"string"`

	// The state of the CMK.
	KeyState *string `type:"string"`

	// The source of the CMK's key material.
	//
	// When this value is AWS_KMS, AWS KMS created the key material.
	//
	// When this value is EXTERNAL, the key material was imported from your existing
	// key management infrastructure or the CMK lacks key material.
	//
	// When this value is AWS_CLOUDHSM, the key material was created in the AWS
	// CloudHSM cluster associated with a custom key store.
	Origin *string `type:"string"`
}

// String returns the string representation
func (s AwsKmsKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsKmsKeyDetails) GoString() string {
	return s.String()
}

// SetAWSAccountId sets the AWSAccountId field's value.
func (s *AwsKmsKeyDetails) SetAWSAccountId(v string) *AwsKmsKeyDetails {
	s.AWSAccountId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *AwsKmsKeyDetails) SetCreationDate(v float64) *AwsKmsKeyDetails {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsKmsKeyDetails) SetDescription(v string) *AwsKmsKeyDetails {
	s.Description = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *AwsKmsKeyDetails) SetKeyId(v string) *AwsKmsKeyDetails {
	s.KeyId = &v
	return s
}

// SetKeyManager sets the KeyManager field's value.
func (s *AwsKmsKeyDetails) SetKeyManager(v string) *AwsKmsKeyDetails {
	s.KeyManager = &v
	return s
}

// SetKeyState sets the KeyState field's value.
func (s *AwsKmsKeyDetails) SetKeyState(v string) *AwsKmsKeyDetails {
	s.KeyState = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *AwsKmsKeyDetails) SetOrigin(v string) *AwsKmsKeyDetails {
	s.Origin = &v
	return s
}

// The code for the Lambda function. You can specify either an object in Amazon
// S3, or upload a deployment package directly.
type AwsLambdaFunctionCode struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 bucket in the same AWS Region as your function. The bucket can
	// be in a different AWS account.
	S3Bucket *string `type:"string"`

	// The Amazon S3 key of the deployment package.
	S3Key *string `type:"string"`

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string `type:"string"`

	// The base64-encoded contents of the deployment package. AWS SDK and AWS CLI
	// clients handle the encoding for you.
	ZipFile *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionCode) GoString() string {
	return s.String()
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *AwsLambdaFunctionCode) SetS3Bucket(v string) *AwsLambdaFunctionCode {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *AwsLambdaFunctionCode) SetS3Key(v string) *AwsLambdaFunctionCode {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *AwsLambdaFunctionCode) SetS3ObjectVersion(v string) *AwsLambdaFunctionCode {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *AwsLambdaFunctionCode) SetZipFile(v string) *AwsLambdaFunctionCode {
	s.ZipFile = &v
	return s
}

// The dead-letter queue for failed asynchronous invocations.
type AwsLambdaFunctionDeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
	TargetArn *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionDeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionDeadLetterConfig) GoString() string {
	return s.String()
}

// SetTargetArn sets the TargetArn field's value.
func (s *AwsLambdaFunctionDeadLetterConfig) SetTargetArn(v string) *AwsLambdaFunctionDeadLetterConfig {
	s.TargetArn = &v
	return s
}

// Details about a function's configuration.
type AwsLambdaFunctionDetails struct {
	_ struct{} `type:"structure"`

	// An AwsLambdaFunctionCode object.
	Code *AwsLambdaFunctionCode `type:"structure"`

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string `type:"string"`

	// The function's dead letter queue.
	DeadLetterConfig *AwsLambdaFunctionDeadLetterConfig `type:"structure"`

	// The function's environment variables.
	Environment *AwsLambdaFunctionEnvironment `type:"structure"`

	// The name of the function.
	FunctionName *string `type:"string"`

	// The function that Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The KMS key that's used to encrypt the function's environment variables.
	// This key is only returned if you've configured a customer managed CMK.
	KmsKeyArn *string `type:"string"`

	// Indicates when the function was last updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastModified *string `type:"string"`

	// The function's layers.
	Layers []*AwsLambdaFunctionLayer `type:"list"`

	// For Lambda@Edge functions, the ARN of the master function.
	MasterArn *string `type:"string"`

	// The memory that's allocated to the function.
	MemorySize *int64 `type:"integer"`

	// The latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// The function's execution role.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime *string `type:"string"`

	// The amount of time that Lambda allows a function to run before stopping it.
	Timeout *int64 `type:"integer"`

	// The function's AWS X-Ray tracing configuration.
	TracingConfig *AwsLambdaFunctionTracingConfig `type:"structure"`

	// The version of the Lambda function.
	Version *string `type:"string"`

	// The function's networking configuration.
	VpcConfig *AwsLambdaFunctionVpcConfig `type:"structure"`
}

// String returns the string representation
func (s AwsLambdaFunctionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AwsLambdaFunctionDetails) SetCode(v *AwsLambdaFunctionCode) *AwsLambdaFunctionDetails {
	s.Code = v
	return s
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *AwsLambdaFunctionDetails) SetCodeSha256(v string) *AwsLambdaFunctionDetails {
	s.CodeSha256 = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *AwsLambdaFunctionDetails) SetDeadLetterConfig(v *AwsLambdaFunctionDeadLetterConfig) *AwsLambdaFunctionDetails {
	s.DeadLetterConfig = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *AwsLambdaFunctionDetails) SetEnvironment(v *AwsLambdaFunctionEnvironment) *AwsLambdaFunctionDetails {
	s.Environment = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *AwsLambdaFunctionDetails) SetFunctionName(v string) *AwsLambdaFunctionDetails {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *AwsLambdaFunctionDetails) SetHandler(v string) *AwsLambdaFunctionDetails {
	s.Handler = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *AwsLambdaFunctionDetails) SetKmsKeyArn(v string) *AwsLambdaFunctionDetails {
	s.KmsKeyArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *AwsLambdaFunctionDetails) SetLastModified(v string) *AwsLambdaFunctionDetails {
	s.LastModified = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *AwsLambdaFunctionDetails) SetLayers(v []*AwsLambdaFunctionLayer) *AwsLambdaFunctionDetails {
	s.Layers = v
	return s
}

// SetMasterArn sets the MasterArn field's value.
func (s *AwsLambdaFunctionDetails) SetMasterArn(v string) *AwsLambdaFunctionDetails {
	s.MasterArn = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *AwsLambdaFunctionDetails) SetMemorySize(v int64) *AwsLambdaFunctionDetails {
	s.MemorySize = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AwsLambdaFunctionDetails) SetRevisionId(v string) *AwsLambdaFunctionDetails {
	s.RevisionId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *AwsLambdaFunctionDetails) SetRole(v string) *AwsLambdaFunctionDetails {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *AwsLambdaFunctionDetails) SetRuntime(v string) *AwsLambdaFunctionDetails {
	s.Runtime = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *AwsLambdaFunctionDetails) SetTimeout(v int64) *AwsLambdaFunctionDetails {
	s.Timeout = &v
	return s
}

// SetTracingConfig sets the TracingConfig field's value.
func (s *AwsLambdaFunctionDetails) SetTracingConfig(v *AwsLambdaFunctionTracingConfig) *AwsLambdaFunctionDetails {
	s.TracingConfig = v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsLambdaFunctionDetails) SetVersion(v string) *AwsLambdaFunctionDetails {
	s.Version = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *AwsLambdaFunctionDetails) SetVpcConfig(v *AwsLambdaFunctionVpcConfig) *AwsLambdaFunctionDetails {
	s.VpcConfig = v
	return s
}

// A function's environment variable settings.
type AwsLambdaFunctionEnvironment struct {
	_ struct{} `type:"structure"`

	// An AwsLambdaFunctionEnvironmentError object.
	Error *AwsLambdaFunctionEnvironmentError `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]*string `type:"map"`
}

// String returns the string representation
func (s AwsLambdaFunctionEnvironment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionEnvironment) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *AwsLambdaFunctionEnvironment) SetError(v *AwsLambdaFunctionEnvironmentError) *AwsLambdaFunctionEnvironment {
	s.Error = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *AwsLambdaFunctionEnvironment) SetVariables(v map[string]*string) *AwsLambdaFunctionEnvironment {
	s.Variables = v
	return s
}

// Error messages for environment variables that couldn't be applied.
type AwsLambdaFunctionEnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionEnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionEnvironmentError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AwsLambdaFunctionEnvironmentError) SetErrorCode(v string) *AwsLambdaFunctionEnvironmentError {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AwsLambdaFunctionEnvironmentError) SetMessage(v string) *AwsLambdaFunctionEnvironmentError {
	s.Message = &v
	return s
}

// An AWS Lambda layer.
type AwsLambdaFunctionLayer struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the function layer.
	Arn *string `type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsLambdaFunctionLayer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionLayer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AwsLambdaFunctionLayer) SetArn(v string) *AwsLambdaFunctionLayer {
	s.Arn = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *AwsLambdaFunctionLayer) SetCodeSize(v int64) *AwsLambdaFunctionLayer {
	s.CodeSize = &v
	return s
}

// The function's AWS X-Ray tracing configuration.
type AwsLambdaFunctionTracingConfig struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionTracingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionTracingConfig) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *AwsLambdaFunctionTracingConfig) SetMode(v string) *AwsLambdaFunctionTracingConfig {
	s.Mode = &v
	return s
}

// The VPC security groups and subnets that are attached to a Lambda function.
// For more information, see VPC Settings.
type AwsLambdaFunctionVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []*string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []*string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaFunctionVpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *AwsLambdaFunctionVpcConfig) SetSecurityGroupIds(v []*string) *AwsLambdaFunctionVpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *AwsLambdaFunctionVpcConfig) SetSubnetIds(v []*string) *AwsLambdaFunctionVpcConfig {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsLambdaFunctionVpcConfig) SetVpcId(v string) *AwsLambdaFunctionVpcConfig {
	s.VpcId = &v
	return s
}

// Details about a Lambda layer version.
type AwsLambdaLayerVersionDetails struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes. Maximum number of five items.
	//
	// Valid values: nodejs10.x | nodejs12.x | java8 | java11 | python2.7 | python3.6
	// | python3.7 | python3.8 | dotnetcore1.0 | dotnetcore2.1 | go1.x | ruby2.5
	// | provided
	CompatibleRuntimes []*string `type:"list"`

	// Indicates when the version was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedDate *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s AwsLambdaLayerVersionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsLambdaLayerVersionDetails) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *AwsLambdaLayerVersionDetails) SetCompatibleRuntimes(v []*string) *AwsLambdaLayerVersionDetails {
	s.CompatibleRuntimes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AwsLambdaLayerVersionDetails) SetCreatedDate(v string) *AwsLambdaLayerVersionDetails {
	s.CreatedDate = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AwsLambdaLayerVersionDetails) SetVersion(v int64) *AwsLambdaLayerVersionDetails {
	s.Version = &v
	return s
}

// An IAM role that is associated with the Amazon RDS DB cluster.
type AwsRdsDbClusterAssociatedRole struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role.
	RoleArn *string `type:"string"`

	// The status of the association between the IAM role and the DB cluster.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbClusterAssociatedRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbClusterAssociatedRole) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *AwsRdsDbClusterAssociatedRole) SetRoleArn(v string) *AwsRdsDbClusterAssociatedRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbClusterAssociatedRole) SetStatus(v string) *AwsRdsDbClusterAssociatedRole {
	s.Status = &v
	return s
}

// Information about an Amazon RDS DB cluster.
type AwsRdsDbClusterDetails struct {
	_ struct{} `type:"structure"`

	// The status of the database activity stream.
	ActivityStreamStatus *string `type:"string"`

	// For all database engines except Aurora, specifies the allocated storage size
	// in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// A list of the IAM roles that are associated with the DB cluster.
	AssociatedRoles []*AwsRdsDbClusterAssociatedRole `type:"list"`

	// A list of Availability Zones (AZs) where instances in the DB cluster can
	// be created.
	AvailabilityZones []*string `type:"list"`

	// The number of days for which automated backups are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Indicates when the DB cluster was created, in Universal Coordinated Time
	// (UTC).
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ClusterCreateTime *string `type:"string"`

	// Whether tags are copied from the DB cluster to snapshots of the DB cluster.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// Whether the DB cluster is a clone of a DB cluster owned by a different AWS
	// account.
	CrossAccountClone *bool `type:"boolean"`

	// A list of custom endpoints for the DB cluster.
	CustomEndpoints []*string `type:"list"`

	// The name of the database.
	DatabaseName *string `type:"string"`

	// The DB cluster identifier that the user assigned to the cluster. This identifier
	// is the unique key that identifies a DB cluster.
	DbClusterIdentifier *string `type:"string"`

	// The list of instances that make up the DB cluster.
	DbClusterMembers []*AwsRdsDbClusterMember `type:"list"`

	// The list of option group memberships for this DB cluster.
	DbClusterOptionGroupMemberships []*AwsRdsDbClusterOptionGroupMembership `type:"list"`

	// The name of the DB cluster parameter group for the DB cluster.
	DbClusterParameterGroup *string `type:"string"`

	// The identifier of the DB cluster. The identifier must be unique within each
	// AWS Region and is immutable.
	DbClusterResourceId *string `type:"string"`

	// The subnet group that is associated with the DB cluster, including the name,
	// description, and subnets in the subnet group.
	DbSubnetGroup *string `type:"string"`

	// Whether the DB cluster has deletion protection enabled.
	DeletionProtection *bool `type:"boolean"`

	// The Active Directory domain membership records that are associated with the
	// DB cluster.
	DomainMemberships []*AwsRdsDbDomainMembership `type:"list"`

	// A list of log types that this DB cluster is configured to export to CloudWatch
	// Logs.
	EnabledCloudWatchLogsExports []*string `type:"list"`

	// The connection endpoint for the primary instance of the DB cluster.
	Endpoint *string `type:"string"`

	// The name of the database engine to use for this DB cluster.
	Engine *string `type:"string"`

	// The database engine mode of the DB cluster.
	EngineMode *string `type:"string"`

	// The version number of the database engine to use.
	EngineVersion *string `type:"string"`

	// Specifies the identifier that Amazon Route 53 assigns when you create a hosted
	// zone.
	HostedZoneId *string `type:"string"`

	// Whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.
	HttpEndpointEnabled *bool `type:"boolean"`

	// Whether the mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// The ARN of the AWS KMS master key that is used to encrypt the database instances
	// in the DB cluster.
	KmsKeyId *string `type:"string"`

	// The name of the master user for the DB cluster.
	MasterUsername *string `type:"string"`

	// Whether the DB cluster has instances in multiple Availability Zones.
	MultiAz *bool `type:"boolean"`

	// The port number on which the DB instances in the DB cluster accept connections.
	Port *int64 `type:"integer"`

	// The range of time each day when automated backups are created, if automated
	// backups are enabled.
	//
	// Uses the format HH:MM-HH:MM. For example, 04:52-05:22.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Uses the format <day>:HH:MM-<day>:HH:MM.
	//
	// For the day values, use mon|tue|wed|thu|fri|sat|sun.
	//
	// For example, sun:09:32-sun:10:02.
	PreferredMaintenanceWindow *string `type:"string"`

	// The identifiers of the read replicas that are associated with this DB cluster.
	ReadReplicaIdentifiers []*string `type:"list"`

	// The reader endpoint for the DB cluster.
	ReaderEndpoint *string `type:"string"`

	// The current status of this DB cluster.
	Status *string `type:"string"`

	// Whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// A list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []*AwsRdsDbInstanceVpcSecurityGroup `type:"list"`
}

// String returns the string representation
func (s AwsRdsDbClusterDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbClusterDetails) GoString() string {
	return s.String()
}

// SetActivityStreamStatus sets the ActivityStreamStatus field's value.
func (s *AwsRdsDbClusterDetails) SetActivityStreamStatus(v string) *AwsRdsDbClusterDetails {
	s.ActivityStreamStatus = &v
	return s
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbClusterDetails) SetAllocatedStorage(v int64) *AwsRdsDbClusterDetails {
	s.AllocatedStorage = &v
	return s
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *AwsRdsDbClusterDetails) SetAssociatedRoles(v []*AwsRdsDbClusterAssociatedRole) *AwsRdsDbClusterDetails {
	s.AssociatedRoles = v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsRdsDbClusterDetails) SetAvailabilityZones(v []*string) *AwsRdsDbClusterDetails {
	s.AvailabilityZones = v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *AwsRdsDbClusterDetails) SetBackupRetentionPeriod(v int64) *AwsRdsDbClusterDetails {
	s.BackupRetentionPeriod = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *AwsRdsDbClusterDetails) SetClusterCreateTime(v string) *AwsRdsDbClusterDetails {
	s.ClusterCreateTime = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *AwsRdsDbClusterDetails) SetCopyTagsToSnapshot(v bool) *AwsRdsDbClusterDetails {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetCrossAccountClone sets the CrossAccountClone field's value.
func (s *AwsRdsDbClusterDetails) SetCrossAccountClone(v bool) *AwsRdsDbClusterDetails {
	s.CrossAccountClone = &v
	return s
}

// SetCustomEndpoints sets the CustomEndpoints field's value.
func (s *AwsRdsDbClusterDetails) SetCustomEndpoints(v []*string) *AwsRdsDbClusterDetails {
	s.CustomEndpoints = v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *AwsRdsDbClusterDetails) SetDatabaseName(v string) *AwsRdsDbClusterDetails {
	s.DatabaseName = &v
	return s
}

// SetDbClusterIdentifier sets the DbClusterIdentifier field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterIdentifier(v string) *AwsRdsDbClusterDetails {
	s.DbClusterIdentifier = &v
	return s
}

// SetDbClusterMembers sets the DbClusterMembers field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterMembers(v []*AwsRdsDbClusterMember) *AwsRdsDbClusterDetails {
	s.DbClusterMembers = v
	return s
}

// SetDbClusterOptionGroupMemberships sets the DbClusterOptionGroupMemberships field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterOptionGroupMemberships(v []*AwsRdsDbClusterOptionGroupMembership) *AwsRdsDbClusterDetails {
	s.DbClusterOptionGroupMemberships = v
	return s
}

// SetDbClusterParameterGroup sets the DbClusterParameterGroup field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterParameterGroup(v string) *AwsRdsDbClusterDetails {
	s.DbClusterParameterGroup = &v
	return s
}

// SetDbClusterResourceId sets the DbClusterResourceId field's value.
func (s *AwsRdsDbClusterDetails) SetDbClusterResourceId(v string) *AwsRdsDbClusterDetails {
	s.DbClusterResourceId = &v
	return s
}

// SetDbSubnetGroup sets the DbSubnetGroup field's value.
func (s *AwsRdsDbClusterDetails) SetDbSubnetGroup(v string) *AwsRdsDbClusterDetails {
	s.DbSubnetGroup = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *AwsRdsDbClusterDetails) SetDeletionProtection(v bool) *AwsRdsDbClusterDetails {
	s.DeletionProtection = &v
	return s
}

// SetDomainMemberships sets the DomainMemberships field's value.
func (s *AwsRdsDbClusterDetails) SetDomainMemberships(v []*AwsRdsDbDomainMembership) *AwsRdsDbClusterDetails {
	s.DomainMemberships = v
	return s
}

// SetEnabledCloudWatchLogsExports sets the EnabledCloudWatchLogsExports field's value.
func (s *AwsRdsDbClusterDetails) SetEnabledCloudWatchLogsExports(v []*string) *AwsRdsDbClusterDetails {
	s.EnabledCloudWatchLogsExports = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsRdsDbClusterDetails) SetEndpoint(v string) *AwsRdsDbClusterDetails {
	s.Endpoint = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *AwsRdsDbClusterDetails) SetEngine(v string) *AwsRdsDbClusterDetails {
	s.Engine = &v
	return s
}

// SetEngineMode sets the EngineMode field's value.
func (s *AwsRdsDbClusterDetails) SetEngineMode(v string) *AwsRdsDbClusterDetails {
	s.EngineMode = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbClusterDetails) SetEngineVersion(v string) *AwsRdsDbClusterDetails {
	s.EngineVersion = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *AwsRdsDbClusterDetails) SetHostedZoneId(v string) *AwsRdsDbClusterDetails {
	s.HostedZoneId = &v
	return s
}

// SetHttpEndpointEnabled sets the HttpEndpointEnabled field's value.
func (s *AwsRdsDbClusterDetails) SetHttpEndpointEnabled(v bool) *AwsRdsDbClusterDetails {
	s.HttpEndpointEnabled = &v
	return s
}

// SetIamDatabaseAuthenticationEnabled sets the IamDatabaseAuthenticationEnabled field's value.
func (s *AwsRdsDbClusterDetails) SetIamDatabaseAuthenticationEnabled(v bool) *AwsRdsDbClusterDetails {
	s.IamDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRdsDbClusterDetails) SetKmsKeyId(v string) *AwsRdsDbClusterDetails {
	s.KmsKeyId = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRdsDbClusterDetails) SetMasterUsername(v string) *AwsRdsDbClusterDetails {
	s.MasterUsername = &v
	return s
}

// SetMultiAz sets the MultiAz field's value.
func (s *AwsRdsDbClusterDetails) SetMultiAz(v bool) *AwsRdsDbClusterDetails {
	s.MultiAz = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbClusterDetails) SetPort(v int64) *AwsRdsDbClusterDetails {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *AwsRdsDbClusterDetails) SetPreferredBackupWindow(v string) *AwsRdsDbClusterDetails {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *AwsRdsDbClusterDetails) SetPreferredMaintenanceWindow(v string) *AwsRdsDbClusterDetails {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReadReplicaIdentifiers sets the ReadReplicaIdentifiers field's value.
func (s *AwsRdsDbClusterDetails) SetReadReplicaIdentifiers(v []*string) *AwsRdsDbClusterDetails {
	s.ReadReplicaIdentifiers = v
	return s
}

// SetReaderEndpoint sets the ReaderEndpoint field's value.
func (s *AwsRdsDbClusterDetails) SetReaderEndpoint(v string) *AwsRdsDbClusterDetails {
	s.ReaderEndpoint = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbClusterDetails) SetStatus(v string) *AwsRdsDbClusterDetails {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *AwsRdsDbClusterDetails) SetStorageEncrypted(v bool) *AwsRdsDbClusterDetails {
	s.StorageEncrypted = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *AwsRdsDbClusterDetails) SetVpcSecurityGroups(v []*AwsRdsDbInstanceVpcSecurityGroup) *AwsRdsDbClusterDetails {
	s.VpcSecurityGroups = v
	return s
}

// Information about an instance in the DB cluster.
type AwsRdsDbClusterMember struct {
	_ struct{} `type:"structure"`

	// The status of the DB cluster parameter group for this member of the DB cluster.
	DbClusterParameterGroupStatus *string `type:"string"`

	// The instance identifier for this member of the DB cluster.
	DbInstanceIdentifier *string `type:"string"`

	// Whether the cluster member is the primary instance for the DB cluster.
	IsClusterWriter *bool `type:"boolean"`

	// Specifies the order in which an Aurora replica is promoted to the primary
	// instance when the existing primary instance fails.
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsRdsDbClusterMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbClusterMember) GoString() string {
	return s.String()
}

// SetDbClusterParameterGroupStatus sets the DbClusterParameterGroupStatus field's value.
func (s *AwsRdsDbClusterMember) SetDbClusterParameterGroupStatus(v string) *AwsRdsDbClusterMember {
	s.DbClusterParameterGroupStatus = &v
	return s
}

// SetDbInstanceIdentifier sets the DbInstanceIdentifier field's value.
func (s *AwsRdsDbClusterMember) SetDbInstanceIdentifier(v string) *AwsRdsDbClusterMember {
	s.DbInstanceIdentifier = &v
	return s
}

// SetIsClusterWriter sets the IsClusterWriter field's value.
func (s *AwsRdsDbClusterMember) SetIsClusterWriter(v bool) *AwsRdsDbClusterMember {
	s.IsClusterWriter = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *AwsRdsDbClusterMember) SetPromotionTier(v int64) *AwsRdsDbClusterMember {
	s.PromotionTier = &v
	return s
}

// Information about an option group membership for a DB cluster.
type AwsRdsDbClusterOptionGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster option group.
	DbClusterOptionGroupName *string `type:"string"`

	// The status of the DB cluster option group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbClusterOptionGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbClusterOptionGroupMembership) GoString() string {
	return s.String()
}

// SetDbClusterOptionGroupName sets the DbClusterOptionGroupName field's value.
func (s *AwsRdsDbClusterOptionGroupMembership) SetDbClusterOptionGroupName(v string) *AwsRdsDbClusterOptionGroupMembership {
	s.DbClusterOptionGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbClusterOptionGroupMembership) SetStatus(v string) *AwsRdsDbClusterOptionGroupMembership {
	s.Status = &v
	return s
}

// Information about an Amazon RDS DB cluster snapshot.
type AwsRdsDbClusterSnapshotDetails struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// A list of Availability Zones where instances in the DB cluster can be created.
	AvailabilityZones []*string `type:"list"`

	// Indicates when the DB cluster was created, in Universal Coordinated Time
	// (UTC).
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ClusterCreateTime *string `type:"string"`

	// The DB cluster identifier.
	DbClusterIdentifier *string `type:"string"`

	// The identifier of the DB cluster snapshot.
	DbClusterSnapshotIdentifier *string `type:"string"`

	Engine *string `type:"string"`

	// The version of the database engine to use.
	EngineVersion *string `type:"string"`

	// Whether mapping of IAM accounts to database accounts is enabled.
	IamDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// The ARN of the AWS KMS master key that is used to encrypt the database instances
	// in the DB cluster.
	KmsKeyId *string `type:"string"`

	// The license model information for this DB cluster snapshot.
	LicenseModel *string `type:"string"`

	// The name of the master user for the DB cluster.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// The port number on which the DB instances in the DB cluster accept connections.
	Port *int64 `type:"integer"`

	// Indicates when the snapshot was taken.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	SnapshotCreateTime *string `type:"string"`

	// The type of DB cluster snapshot.
	SnapshotType *string `type:"string"`

	// The status of this DB cluster snapshot.
	Status *string `type:"string"`

	// Whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// The VPC ID that is associated with the DB cluster snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbClusterSnapshotDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbClusterSnapshotDetails) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetAllocatedStorage(v int64) *AwsRdsDbClusterSnapshotDetails {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetAvailabilityZones(v []*string) *AwsRdsDbClusterSnapshotDetails {
	s.AvailabilityZones = v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetClusterCreateTime(v string) *AwsRdsDbClusterSnapshotDetails {
	s.ClusterCreateTime = &v
	return s
}

// SetDbClusterIdentifier sets the DbClusterIdentifier field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetDbClusterIdentifier(v string) *AwsRdsDbClusterSnapshotDetails {
	s.DbClusterIdentifier = &v
	return s
}

// SetDbClusterSnapshotIdentifier sets the DbClusterSnapshotIdentifier field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetDbClusterSnapshotIdentifier(v string) *AwsRdsDbClusterSnapshotDetails {
	s.DbClusterSnapshotIdentifier = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetEngine(v string) *AwsRdsDbClusterSnapshotDetails {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetEngineVersion(v string) *AwsRdsDbClusterSnapshotDetails {
	s.EngineVersion = &v
	return s
}

// SetIamDatabaseAuthenticationEnabled sets the IamDatabaseAuthenticationEnabled field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetIamDatabaseAuthenticationEnabled(v bool) *AwsRdsDbClusterSnapshotDetails {
	s.IamDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetKmsKeyId(v string) *AwsRdsDbClusterSnapshotDetails {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetLicenseModel(v string) *AwsRdsDbClusterSnapshotDetails {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetMasterUsername(v string) *AwsRdsDbClusterSnapshotDetails {
	s.MasterUsername = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetPercentProgress(v int64) *AwsRdsDbClusterSnapshotDetails {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetPort(v int64) *AwsRdsDbClusterSnapshotDetails {
	s.Port = &v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetSnapshotCreateTime(v string) *AwsRdsDbClusterSnapshotDetails {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetSnapshotType(v string) *AwsRdsDbClusterSnapshotDetails {
	s.SnapshotType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetStatus(v string) *AwsRdsDbClusterSnapshotDetails {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetStorageEncrypted(v bool) *AwsRdsDbClusterSnapshotDetails {
	s.StorageEncrypted = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsRdsDbClusterSnapshotDetails) SetVpcId(v string) *AwsRdsDbClusterSnapshotDetails {
	s.VpcId = &v
	return s
}

// Information about an Active Directory domain membership record associated
// with the DB instance.
type AwsRdsDbDomainMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the Active Directory domain.
	Domain *string `type:"string"`

	// The fully qualified domain name of the Active Directory domain.
	Fqdn *string `type:"string"`

	// The name of the IAM role to use when making API calls to the Directory Service.
	IamRoleName *string `type:"string"`

	// The status of the Active Directory Domain membership for the DB instance.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbDomainMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbDomainMembership) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *AwsRdsDbDomainMembership) SetDomain(v string) *AwsRdsDbDomainMembership {
	s.Domain = &v
	return s
}

// SetFqdn sets the Fqdn field's value.
func (s *AwsRdsDbDomainMembership) SetFqdn(v string) *AwsRdsDbDomainMembership {
	s.Fqdn = &v
	return s
}

// SetIamRoleName sets the IamRoleName field's value.
func (s *AwsRdsDbDomainMembership) SetIamRoleName(v string) *AwsRdsDbDomainMembership {
	s.IamRoleName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbDomainMembership) SetStatus(v string) *AwsRdsDbDomainMembership {
	s.Status = &v
	return s
}

// An AWS Identity and Access Management (IAM) role associated with the DB instance.
type AwsRdsDbInstanceAssociatedRole struct {
	_ struct{} `type:"structure"`

	// The name of the feature associated with the IAM)role.
	FeatureName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB instance.
	RoleArn *string `type:"string"`

	// Describes the state of the association between the IAM role and the DB instance.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - The IAM role ARN is associated with the DB instance and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - The IAM role ARN is being associated with the DB instance.
	//
	//    * INVALID - The IAM role ARN is associated with the DB instance. But the
	//    DB instance is unable to assume the IAM role in order to access other
	//    AWS services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbInstanceAssociatedRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbInstanceAssociatedRole) GoString() string {
	return s.String()
}

// SetFeatureName sets the FeatureName field's value.
func (s *AwsRdsDbInstanceAssociatedRole) SetFeatureName(v string) *AwsRdsDbInstanceAssociatedRole {
	s.FeatureName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AwsRdsDbInstanceAssociatedRole) SetRoleArn(v string) *AwsRdsDbInstanceAssociatedRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbInstanceAssociatedRole) SetStatus(v string) *AwsRdsDbInstanceAssociatedRole {
	s.Status = &v
	return s
}

// Contains the details of an Amazon RDS DB instance.
type AwsRdsDbInstanceDetails struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to initially allocate for the DB instance.
	AllocatedStorage *int64 `type:"integer"`

	// The AWS Identity and Access Management (IAM) roles associated with the DB
	// instance.
	AssociatedRoles []*AwsRdsDbInstanceAssociatedRole `type:"list"`

	// Indicates whether minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone where the DB instance will be created.
	AvailabilityZone *string `type:"string"`

	// The number of days for which to retain automated backups.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// The name of the character set that this DB instance is associated with.
	CharacterSetName *string `type:"string"`

	// Whether to copy resource tags to snapshots of the DB instance.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// MySQL, MariaDB, SQL Server, PostgreSQL
	//
	// Contains the name of the initial database of this instance that was provided
	// at create time, if one was specified when the DB instance was created. This
	// same name is returned for the life of the DB instance.
	//
	// Oracle
	//
	// Contains the Oracle System ID (SID) of the created DB instance. Not shown
	// when the returned parameters do not apply to an Oracle DB instance.
	DBName *string `type:"string"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// The current status of the DB instance.
	DbInstanceStatus *string `type:"string"`

	// A list of the DB parameter groups to assign to the DB instance.
	DbParameterGroups []*AwsRdsDbParameterGroup `type:"list"`

	// A list of the DB security groups to assign to the DB instance.
	DbSecurityGroups []*string `type:"list"`

	// Information about the subnet group that is associated with the DB instance.
	DbSubnetGroup *AwsRdsDbSubnetGroup `type:"structure"`

	// The AWS Region-unique, immutable identifier for the DB instance. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// instance is accessed.
	DbiResourceId *string `type:"string"`

	// Indicates whether the DB instance has deletion protection enabled.
	//
	// When deletion protection is enabled, the database cannot be deleted.
	DeletionProtection *bool `type:"boolean"`

	// The Active Directory domain membership records associated with the DB instance.
	DomainMemberships []*AwsRdsDbDomainMembership `type:"list"`

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs.
	EnabledCloudWatchLogsExports []*string `type:"list"`

	// Specifies the connection endpoint.
	Endpoint *AwsRdsDbInstanceEndpoint `type:"structure"`

	// Provides the name of the database engine to use for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring
	// metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	//
	// IAM database authentication can be enabled for the following database engines.
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Indicates when the DB instance was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	InstanceCreateTime *string `type:"string"`

	// Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
	Iops *int64 `type:"integer"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB instance.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LatestRestorableTime *string `type:"string"`

	// License model information for this DB instance.
	LicenseModel *string `type:"string"`

	// Specifies the connection endpoint.
	ListenerEndpoint *AwsRdsDbInstanceEndpoint `type:"structure"`

	// The master user name of the DB instance.
	MasterUsername *string `type:"string"`

	// The upper limit to which Amazon RDS can automatically scale the storage of
	// the DB instance.
	MaxAllocatedStorage *int64 `type:"integer"`

	// The interval, in seconds, between points when enhanced monitoring metrics
	// are collected for the DB instance.
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring
	// metrics to CloudWatch Logs.
	MonitoringRoleArn *string `type:"string"`

	// Whether the DB instance is a multiple Availability Zone deployment.
	MultiAz *bool `type:"boolean"`

	// The list of option group memberships for this DB instance.
	OptionGroupMemberships []*AwsRdsDbOptionGroupMembership `type:"list"`

	// Changes to the DB instance that are currently pending.
	PendingModifiedValues *AwsRdsDbPendingModifiedValues `type:"structure"`

	// Indicates whether Performance Insights is enabled for the DB instance.
	PerformanceInsightsEnabled *bool `type:"boolean"`

	// The identifier of the AWS KMS key used to encrypt the Performance Insights
	// data.
	PerformanceInsightsKmsKeyId *string `type:"string"`

	// The number of days to retain Performance Insights data.
	PerformanceInsightsRetentionPeriod *int64 `type:"integer"`

	// The range of time each day when automated backups are created, if automated
	// backups are enabled.
	//
	// Uses the format HH:MM-HH:MM. For example, 04:52-05:22.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Uses the format <day>:HH:MM-<day>:HH:MM.
	//
	// For the day values, use mon|tue|wed|thu|fri|sat|sun.
	//
	// For example, sun:09:32-sun:10:02.
	PreferredMaintenanceWindow *string `type:"string"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []*AwsRdsDbProcessorFeature `type:"list"`

	// The order in which to promote an Aurora replica to the primary instance after
	// a failure of the existing primary instance.
	PromotionTier *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance.
	//
	// A value of true specifies an Internet-facing instance with a publicly resolvable
	// DNS name, which resolves to a public IP address.
	//
	// A value of false specifies an internal instance with a DNS name that resolves
	// to a private IP address.
	PubliclyAccessible *bool `type:"boolean"`

	// List of identifiers of Aurora DB clusters to which the RDS DB instance is
	// replicated as a read replica.
	ReadReplicaDBClusterIdentifiers []*string `type:"list"`

	// List of identifiers of the read replicas associated with this DB instance.
	ReadReplicaDBInstanceIdentifiers []*string `type:"list"`

	// If this DB instance is a read replica, contains the identifier of the source
	// DB instance.
	ReadReplicaSourceDBInstanceIdentifier *string `type:"string"`

	// For a DB instance with multi-Availability Zone support, the name of the secondary
	// Availability Zone.
	SecondaryAvailabilityZone *string `type:"string"`

	// The status of a read replica. If the instance isn't a read replica, this
	// is empty.
	StatusInfos []*AwsRdsDbStatusInfo `type:"list"`

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// The storage type for the DB instance.
	StorageType *string `type:"string"`

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the DB instance.
	Timezone *string `type:"string"`

	// A list of VPC security groups that the DB instance belongs to.
	VpcSecurityGroups []*AwsRdsDbInstanceVpcSecurityGroup `type:"list"`
}

// String returns the string representation
func (s AwsRdsDbInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbInstanceDetails) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbInstanceDetails) SetAllocatedStorage(v int64) *AwsRdsDbInstanceDetails {
	s.AllocatedStorage = &v
	return s
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *AwsRdsDbInstanceDetails) SetAssociatedRoles(v []*AwsRdsDbInstanceAssociatedRole) *AwsRdsDbInstanceDetails {
	s.AssociatedRoles = v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *AwsRdsDbInstanceDetails) SetAutoMinorVersionUpgrade(v bool) *AwsRdsDbInstanceDetails {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AwsRdsDbInstanceDetails) SetAvailabilityZone(v string) *AwsRdsDbInstanceDetails {
	s.AvailabilityZone = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *AwsRdsDbInstanceDetails) SetBackupRetentionPeriod(v int64) *AwsRdsDbInstanceDetails {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetCACertificateIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.CACertificateIdentifier = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *AwsRdsDbInstanceDetails) SetCharacterSetName(v string) *AwsRdsDbInstanceDetails {
	s.CharacterSetName = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *AwsRdsDbInstanceDetails) SetCopyTagsToSnapshot(v bool) *AwsRdsDbInstanceDetails {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetDBClusterIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *AwsRdsDbInstanceDetails) SetDBInstanceClass(v string) *AwsRdsDbInstanceDetails {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetDBInstanceIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *AwsRdsDbInstanceDetails) SetDBName(v string) *AwsRdsDbInstanceDetails {
	s.DBName = &v
	return s
}

// SetDbInstancePort sets the DbInstancePort field's value.
func (s *AwsRdsDbInstanceDetails) SetDbInstancePort(v int64) *AwsRdsDbInstanceDetails {
	s.DbInstancePort = &v
	return s
}

// SetDbInstanceStatus sets the DbInstanceStatus field's value.
func (s *AwsRdsDbInstanceDetails) SetDbInstanceStatus(v string) *AwsRdsDbInstanceDetails {
	s.DbInstanceStatus = &v
	return s
}

// SetDbParameterGroups sets the DbParameterGroups field's value.
func (s *AwsRdsDbInstanceDetails) SetDbParameterGroups(v []*AwsRdsDbParameterGroup) *AwsRdsDbInstanceDetails {
	s.DbParameterGroups = v
	return s
}

// SetDbSecurityGroups sets the DbSecurityGroups field's value.
func (s *AwsRdsDbInstanceDetails) SetDbSecurityGroups(v []*string) *AwsRdsDbInstanceDetails {
	s.DbSecurityGroups = v
	return s
}

// SetDbSubnetGroup sets the DbSubnetGroup field's value.
func (s *AwsRdsDbInstanceDetails) SetDbSubnetGroup(v *AwsRdsDbSubnetGroup) *AwsRdsDbInstanceDetails {
	s.DbSubnetGroup = v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *AwsRdsDbInstanceDetails) SetDbiResourceId(v string) *AwsRdsDbInstanceDetails {
	s.DbiResourceId = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *AwsRdsDbInstanceDetails) SetDeletionProtection(v bool) *AwsRdsDbInstanceDetails {
	s.DeletionProtection = &v
	return s
}

// SetDomainMemberships sets the DomainMemberships field's value.
func (s *AwsRdsDbInstanceDetails) SetDomainMemberships(v []*AwsRdsDbDomainMembership) *AwsRdsDbInstanceDetails {
	s.DomainMemberships = v
	return s
}

// SetEnabledCloudWatchLogsExports sets the EnabledCloudWatchLogsExports field's value.
func (s *AwsRdsDbInstanceDetails) SetEnabledCloudWatchLogsExports(v []*string) *AwsRdsDbInstanceDetails {
	s.EnabledCloudWatchLogsExports = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsRdsDbInstanceDetails) SetEndpoint(v *AwsRdsDbInstanceEndpoint) *AwsRdsDbInstanceDetails {
	s.Endpoint = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *AwsRdsDbInstanceDetails) SetEngine(v string) *AwsRdsDbInstanceDetails {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbInstanceDetails) SetEngineVersion(v string) *AwsRdsDbInstanceDetails {
	s.EngineVersion = &v
	return s
}

// SetEnhancedMonitoringResourceArn sets the EnhancedMonitoringResourceArn field's value.
func (s *AwsRdsDbInstanceDetails) SetEnhancedMonitoringResourceArn(v string) *AwsRdsDbInstanceDetails {
	s.EnhancedMonitoringResourceArn = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *AwsRdsDbInstanceDetails) SetIAMDatabaseAuthenticationEnabled(v bool) *AwsRdsDbInstanceDetails {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *AwsRdsDbInstanceDetails) SetInstanceCreateTime(v string) *AwsRdsDbInstanceDetails {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *AwsRdsDbInstanceDetails) SetIops(v int64) *AwsRdsDbInstanceDetails {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRdsDbInstanceDetails) SetKmsKeyId(v string) *AwsRdsDbInstanceDetails {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *AwsRdsDbInstanceDetails) SetLatestRestorableTime(v string) *AwsRdsDbInstanceDetails {
	s.LatestRestorableTime = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *AwsRdsDbInstanceDetails) SetLicenseModel(v string) *AwsRdsDbInstanceDetails {
	s.LicenseModel = &v
	return s
}

// SetListenerEndpoint sets the ListenerEndpoint field's value.
func (s *AwsRdsDbInstanceDetails) SetListenerEndpoint(v *AwsRdsDbInstanceEndpoint) *AwsRdsDbInstanceDetails {
	s.ListenerEndpoint = v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRdsDbInstanceDetails) SetMasterUsername(v string) *AwsRdsDbInstanceDetails {
	s.MasterUsername = &v
	return s
}

// SetMaxAllocatedStorage sets the MaxAllocatedStorage field's value.
func (s *AwsRdsDbInstanceDetails) SetMaxAllocatedStorage(v int64) *AwsRdsDbInstanceDetails {
	s.MaxAllocatedStorage = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *AwsRdsDbInstanceDetails) SetMonitoringInterval(v int64) *AwsRdsDbInstanceDetails {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *AwsRdsDbInstanceDetails) SetMonitoringRoleArn(v string) *AwsRdsDbInstanceDetails {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAz sets the MultiAz field's value.
func (s *AwsRdsDbInstanceDetails) SetMultiAz(v bool) *AwsRdsDbInstanceDetails {
	s.MultiAz = &v
	return s
}

// SetOptionGroupMemberships sets the OptionGroupMemberships field's value.
func (s *AwsRdsDbInstanceDetails) SetOptionGroupMemberships(v []*AwsRdsDbOptionGroupMembership) *AwsRdsDbInstanceDetails {
	s.OptionGroupMemberships = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *AwsRdsDbInstanceDetails) SetPendingModifiedValues(v *AwsRdsDbPendingModifiedValues) *AwsRdsDbInstanceDetails {
	s.PendingModifiedValues = v
	return s
}

// SetPerformanceInsightsEnabled sets the PerformanceInsightsEnabled field's value.
func (s *AwsRdsDbInstanceDetails) SetPerformanceInsightsEnabled(v bool) *AwsRdsDbInstanceDetails {
	s.PerformanceInsightsEnabled = &v
	return s
}

// SetPerformanceInsightsKmsKeyId sets the PerformanceInsightsKmsKeyId field's value.
func (s *AwsRdsDbInstanceDetails) SetPerformanceInsightsKmsKeyId(v string) *AwsRdsDbInstanceDetails {
	s.PerformanceInsightsKmsKeyId = &v
	return s
}

// SetPerformanceInsightsRetentionPeriod sets the PerformanceInsightsRetentionPeriod field's value.
func (s *AwsRdsDbInstanceDetails) SetPerformanceInsightsRetentionPeriod(v int64) *AwsRdsDbInstanceDetails {
	s.PerformanceInsightsRetentionPeriod = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *AwsRdsDbInstanceDetails) SetPreferredBackupWindow(v string) *AwsRdsDbInstanceDetails {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *AwsRdsDbInstanceDetails) SetPreferredMaintenanceWindow(v string) *AwsRdsDbInstanceDetails {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *AwsRdsDbInstanceDetails) SetProcessorFeatures(v []*AwsRdsDbProcessorFeature) *AwsRdsDbInstanceDetails {
	s.ProcessorFeatures = v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *AwsRdsDbInstanceDetails) SetPromotionTier(v int64) *AwsRdsDbInstanceDetails {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *AwsRdsDbInstanceDetails) SetPubliclyAccessible(v bool) *AwsRdsDbInstanceDetails {
	s.PubliclyAccessible = &v
	return s
}

// SetReadReplicaDBClusterIdentifiers sets the ReadReplicaDBClusterIdentifiers field's value.
func (s *AwsRdsDbInstanceDetails) SetReadReplicaDBClusterIdentifiers(v []*string) *AwsRdsDbInstanceDetails {
	s.ReadReplicaDBClusterIdentifiers = v
	return s
}

// SetReadReplicaDBInstanceIdentifiers sets the ReadReplicaDBInstanceIdentifiers field's value.
func (s *AwsRdsDbInstanceDetails) SetReadReplicaDBInstanceIdentifiers(v []*string) *AwsRdsDbInstanceDetails {
	s.ReadReplicaDBInstanceIdentifiers = v
	return s
}

// SetReadReplicaSourceDBInstanceIdentifier sets the ReadReplicaSourceDBInstanceIdentifier field's value.
func (s *AwsRdsDbInstanceDetails) SetReadReplicaSourceDBInstanceIdentifier(v string) *AwsRdsDbInstanceDetails {
	s.ReadReplicaSourceDBInstanceIdentifier = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *AwsRdsDbInstanceDetails) SetSecondaryAvailabilityZone(v string) *AwsRdsDbInstanceDetails {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetStatusInfos sets the StatusInfos field's value.
func (s *AwsRdsDbInstanceDetails) SetStatusInfos(v []*AwsRdsDbStatusInfo) *AwsRdsDbInstanceDetails {
	s.StatusInfos = v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *AwsRdsDbInstanceDetails) SetStorageEncrypted(v bool) *AwsRdsDbInstanceDetails {
	s.StorageEncrypted = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *AwsRdsDbInstanceDetails) SetStorageType(v string) *AwsRdsDbInstanceDetails {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *AwsRdsDbInstanceDetails) SetTdeCredentialArn(v string) *AwsRdsDbInstanceDetails {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *AwsRdsDbInstanceDetails) SetTimezone(v string) *AwsRdsDbInstanceDetails {
	s.Timezone = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *AwsRdsDbInstanceDetails) SetVpcSecurityGroups(v []*AwsRdsDbInstanceVpcSecurityGroup) *AwsRdsDbInstanceDetails {
	s.VpcSecurityGroups = v
	return s
}

// Specifies the connection endpoint.
type AwsRdsDbInstanceEndpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsRdsDbInstanceEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbInstanceEndpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *AwsRdsDbInstanceEndpoint) SetAddress(v string) *AwsRdsDbInstanceEndpoint {
	s.Address = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *AwsRdsDbInstanceEndpoint) SetHostedZoneId(v string) *AwsRdsDbInstanceEndpoint {
	s.HostedZoneId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbInstanceEndpoint) SetPort(v int64) *AwsRdsDbInstanceEndpoint {
	s.Port = &v
	return s
}

// A VPC security groups that the DB instance belongs to.
type AwsRdsDbInstanceVpcSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbInstanceVpcSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbInstanceVpcSecurityGroup) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbInstanceVpcSecurityGroup) SetStatus(v string) *AwsRdsDbInstanceVpcSecurityGroup {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *AwsRdsDbInstanceVpcSecurityGroup) SetVpcSecurityGroupId(v string) *AwsRdsDbInstanceVpcSecurityGroup {
	s.VpcSecurityGroupId = &v
	return s
}

type AwsRdsDbOptionGroupMembership struct {
	_ struct{} `type:"structure"`

	OptionGroupName *string `type:"string"`

	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbOptionGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbOptionGroupMembership) GoString() string {
	return s.String()
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *AwsRdsDbOptionGroupMembership) SetOptionGroupName(v string) *AwsRdsDbOptionGroupMembership {
	s.OptionGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbOptionGroupMembership) SetStatus(v string) *AwsRdsDbOptionGroupMembership {
	s.Status = &v
	return s
}

type AwsRdsDbParameterGroup struct {
	_ struct{} `type:"structure"`

	DbParameterGroupName *string `type:"string"`

	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbParameterGroup) GoString() string {
	return s.String()
}

// SetDbParameterGroupName sets the DbParameterGroupName field's value.
func (s *AwsRdsDbParameterGroup) SetDbParameterGroupName(v string) *AwsRdsDbParameterGroup {
	s.DbParameterGroupName = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *AwsRdsDbParameterGroup) SetParameterApplyStatus(v string) *AwsRdsDbParameterGroup {
	s.ParameterApplyStatus = &v
	return s
}

type AwsRdsDbPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	AllocatedStorage *int64 `type:"integer"`

	BackupRetentionPeriod *int64 `type:"integer"`

	CaCertificateIdentifier *string `type:"string"`

	DbInstanceClass *string `type:"string"`

	DbInstanceIdentifier *string `type:"string"`

	DbSubnetGroupName *string `type:"string"`

	EngineVersion *string `type:"string"`

	Iops *int64 `type:"integer"`

	LicenseModel *string `type:"string"`

	MasterUserPassword *string `type:"string"`

	MultiAZ *bool `type:"boolean"`

	// Identifies the log types to enable and disable.
	PendingCloudWatchLogsExports *AwsRdsPendingCloudWatchLogsExports `type:"structure"`

	Port *int64 `type:"integer"`

	ProcessorFeatures []*AwsRdsDbProcessorFeature `type:"list"`

	StorageType *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbPendingModifiedValues) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbPendingModifiedValues) SetAllocatedStorage(v int64) *AwsRdsDbPendingModifiedValues {
	s.AllocatedStorage = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *AwsRdsDbPendingModifiedValues) SetBackupRetentionPeriod(v int64) *AwsRdsDbPendingModifiedValues {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCaCertificateIdentifier sets the CaCertificateIdentifier field's value.
func (s *AwsRdsDbPendingModifiedValues) SetCaCertificateIdentifier(v string) *AwsRdsDbPendingModifiedValues {
	s.CaCertificateIdentifier = &v
	return s
}

// SetDbInstanceClass sets the DbInstanceClass field's value.
func (s *AwsRdsDbPendingModifiedValues) SetDbInstanceClass(v string) *AwsRdsDbPendingModifiedValues {
	s.DbInstanceClass = &v
	return s
}

// SetDbInstanceIdentifier sets the DbInstanceIdentifier field's value.
func (s *AwsRdsDbPendingModifiedValues) SetDbInstanceIdentifier(v string) *AwsRdsDbPendingModifiedValues {
	s.DbInstanceIdentifier = &v
	return s
}

// SetDbSubnetGroupName sets the DbSubnetGroupName field's value.
func (s *AwsRdsDbPendingModifiedValues) SetDbSubnetGroupName(v string) *AwsRdsDbPendingModifiedValues {
	s.DbSubnetGroupName = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbPendingModifiedValues) SetEngineVersion(v string) *AwsRdsDbPendingModifiedValues {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *AwsRdsDbPendingModifiedValues) SetIops(v int64) *AwsRdsDbPendingModifiedValues {
	s.Iops = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *AwsRdsDbPendingModifiedValues) SetLicenseModel(v string) *AwsRdsDbPendingModifiedValues {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *AwsRdsDbPendingModifiedValues) SetMasterUserPassword(v string) *AwsRdsDbPendingModifiedValues {
	s.MasterUserPassword = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *AwsRdsDbPendingModifiedValues) SetMultiAZ(v bool) *AwsRdsDbPendingModifiedValues {
	s.MultiAZ = &v
	return s
}

// SetPendingCloudWatchLogsExports sets the PendingCloudWatchLogsExports field's value.
func (s *AwsRdsDbPendingModifiedValues) SetPendingCloudWatchLogsExports(v *AwsRdsPendingCloudWatchLogsExports) *AwsRdsDbPendingModifiedValues {
	s.PendingCloudWatchLogsExports = v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbPendingModifiedValues) SetPort(v int64) *AwsRdsDbPendingModifiedValues {
	s.Port = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *AwsRdsDbPendingModifiedValues) SetProcessorFeatures(v []*AwsRdsDbProcessorFeature) *AwsRdsDbPendingModifiedValues {
	s.ProcessorFeatures = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *AwsRdsDbPendingModifiedValues) SetStorageType(v string) *AwsRdsDbPendingModifiedValues {
	s.StorageType = &v
	return s
}

type AwsRdsDbProcessorFeature struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbProcessorFeature) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbProcessorFeature) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsRdsDbProcessorFeature) SetName(v string) *AwsRdsDbProcessorFeature {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AwsRdsDbProcessorFeature) SetValue(v string) *AwsRdsDbProcessorFeature {
	s.Value = &v
	return s
}

type AwsRdsDbSnapshotDetails struct {
	_ struct{} `type:"structure"`

	AllocatedStorage *int64 `type:"integer"`

	AvailabilityZone *string `type:"string"`

	DbInstanceIdentifier *string `type:"string"`

	DbSnapshotIdentifier *string `type:"string"`

	DbiResourceId *string `type:"string"`

	Encrypted *bool `type:"boolean"`

	Engine *string `type:"string"`

	EngineVersion *string `type:"string"`

	IamDatabaseAuthenticationEnabled *bool `type:"boolean"`

	InstanceCreateTime *string `type:"string"`

	Iops *int64 `type:"integer"`

	KmsKeyId *string `type:"string"`

	LicenseModel *string `type:"string"`

	MasterUsername *string `type:"string"`

	OptionGroupName *string `type:"string"`

	PercentProgress *int64 `type:"integer"`

	Port *int64 `type:"integer"`

	ProcessorFeatures []*AwsRdsDbProcessorFeature `type:"list"`

	SnapshotCreateTime *string `type:"string"`

	SnapshotType *string `type:"string"`

	SourceDbSnapshotIdentifier *string `type:"string"`

	SourceRegion *string `type:"string"`

	Status *string `type:"string"`

	StorageType *string `type:"string"`

	TdeCredentialArn *string `type:"string"`

	Timezone *string `type:"string"`

	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbSnapshotDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbSnapshotDetails) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *AwsRdsDbSnapshotDetails) SetAllocatedStorage(v int64) *AwsRdsDbSnapshotDetails {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AwsRdsDbSnapshotDetails) SetAvailabilityZone(v string) *AwsRdsDbSnapshotDetails {
	s.AvailabilityZone = &v
	return s
}

// SetDbInstanceIdentifier sets the DbInstanceIdentifier field's value.
func (s *AwsRdsDbSnapshotDetails) SetDbInstanceIdentifier(v string) *AwsRdsDbSnapshotDetails {
	s.DbInstanceIdentifier = &v
	return s
}

// SetDbSnapshotIdentifier sets the DbSnapshotIdentifier field's value.
func (s *AwsRdsDbSnapshotDetails) SetDbSnapshotIdentifier(v string) *AwsRdsDbSnapshotDetails {
	s.DbSnapshotIdentifier = &v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *AwsRdsDbSnapshotDetails) SetDbiResourceId(v string) *AwsRdsDbSnapshotDetails {
	s.DbiResourceId = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsRdsDbSnapshotDetails) SetEncrypted(v bool) *AwsRdsDbSnapshotDetails {
	s.Encrypted = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *AwsRdsDbSnapshotDetails) SetEngine(v string) *AwsRdsDbSnapshotDetails {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *AwsRdsDbSnapshotDetails) SetEngineVersion(v string) *AwsRdsDbSnapshotDetails {
	s.EngineVersion = &v
	return s
}

// SetIamDatabaseAuthenticationEnabled sets the IamDatabaseAuthenticationEnabled field's value.
func (s *AwsRdsDbSnapshotDetails) SetIamDatabaseAuthenticationEnabled(v bool) *AwsRdsDbSnapshotDetails {
	s.IamDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *AwsRdsDbSnapshotDetails) SetInstanceCreateTime(v string) *AwsRdsDbSnapshotDetails {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *AwsRdsDbSnapshotDetails) SetIops(v int64) *AwsRdsDbSnapshotDetails {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRdsDbSnapshotDetails) SetKmsKeyId(v string) *AwsRdsDbSnapshotDetails {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *AwsRdsDbSnapshotDetails) SetLicenseModel(v string) *AwsRdsDbSnapshotDetails {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRdsDbSnapshotDetails) SetMasterUsername(v string) *AwsRdsDbSnapshotDetails {
	s.MasterUsername = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *AwsRdsDbSnapshotDetails) SetOptionGroupName(v string) *AwsRdsDbSnapshotDetails {
	s.OptionGroupName = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *AwsRdsDbSnapshotDetails) SetPercentProgress(v int64) *AwsRdsDbSnapshotDetails {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRdsDbSnapshotDetails) SetPort(v int64) *AwsRdsDbSnapshotDetails {
	s.Port = &v
	return s
}

// SetProcessorFeatures sets the ProcessorFeatures field's value.
func (s *AwsRdsDbSnapshotDetails) SetProcessorFeatures(v []*AwsRdsDbProcessorFeature) *AwsRdsDbSnapshotDetails {
	s.ProcessorFeatures = v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *AwsRdsDbSnapshotDetails) SetSnapshotCreateTime(v string) *AwsRdsDbSnapshotDetails {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *AwsRdsDbSnapshotDetails) SetSnapshotType(v string) *AwsRdsDbSnapshotDetails {
	s.SnapshotType = &v
	return s
}

// SetSourceDbSnapshotIdentifier sets the SourceDbSnapshotIdentifier field's value.
func (s *AwsRdsDbSnapshotDetails) SetSourceDbSnapshotIdentifier(v string) *AwsRdsDbSnapshotDetails {
	s.SourceDbSnapshotIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *AwsRdsDbSnapshotDetails) SetSourceRegion(v string) *AwsRdsDbSnapshotDetails {
	s.SourceRegion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbSnapshotDetails) SetStatus(v string) *AwsRdsDbSnapshotDetails {
	s.Status = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *AwsRdsDbSnapshotDetails) SetStorageType(v string) *AwsRdsDbSnapshotDetails {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *AwsRdsDbSnapshotDetails) SetTdeCredentialArn(v string) *AwsRdsDbSnapshotDetails {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *AwsRdsDbSnapshotDetails) SetTimezone(v string) *AwsRdsDbSnapshotDetails {
	s.Timezone = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsRdsDbSnapshotDetails) SetVpcId(v string) *AwsRdsDbSnapshotDetails {
	s.VpcId = &v
	return s
}

// Information about the status of a read replica.
type AwsRdsDbStatusInfo struct {
	_ struct{} `type:"structure"`

	// If the read replica is currently in an error state, provides the error details.
	Message *string `type:"string"`

	// Whether the read replica instance is operating normally.
	Normal *bool `type:"boolean"`

	// The status of the read replica instance.
	Status *string `type:"string"`

	// The type of status. For a read replica, the status type is read replication.
	StatusType *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbStatusInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AwsRdsDbStatusInfo) SetMessage(v string) *AwsRdsDbStatusInfo {
	s.Message = &v
	return s
}

// SetNormal sets the Normal field's value.
func (s *AwsRdsDbStatusInfo) SetNormal(v bool) *AwsRdsDbStatusInfo {
	s.Normal = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRdsDbStatusInfo) SetStatus(v string) *AwsRdsDbStatusInfo {
	s.Status = &v
	return s
}

// SetStatusType sets the StatusType field's value.
func (s *AwsRdsDbStatusInfo) SetStatusType(v string) *AwsRdsDbStatusInfo {
	s.StatusType = &v
	return s
}

// Information about the subnet group for the database instance.
type AwsRdsDbSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The ARN of the subnet group.
	DbSubnetGroupArn *string `type:"string"`

	// The description of the subnet group.
	DbSubnetGroupDescription *string `type:"string"`

	// The name of the subnet group.
	DbSubnetGroupName *string `type:"string"`

	// The status of the subnet group.
	SubnetGroupStatus *string `type:"string"`

	// A list of subnets in the subnet group.
	Subnets []*AwsRdsDbSubnetGroupSubnet `type:"list"`

	// The VPC ID of the subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbSubnetGroup) GoString() string {
	return s.String()
}

// SetDbSubnetGroupArn sets the DbSubnetGroupArn field's value.
func (s *AwsRdsDbSubnetGroup) SetDbSubnetGroupArn(v string) *AwsRdsDbSubnetGroup {
	s.DbSubnetGroupArn = &v
	return s
}

// SetDbSubnetGroupDescription sets the DbSubnetGroupDescription field's value.
func (s *AwsRdsDbSubnetGroup) SetDbSubnetGroupDescription(v string) *AwsRdsDbSubnetGroup {
	s.DbSubnetGroupDescription = &v
	return s
}

// SetDbSubnetGroupName sets the DbSubnetGroupName field's value.
func (s *AwsRdsDbSubnetGroup) SetDbSubnetGroupName(v string) *AwsRdsDbSubnetGroup {
	s.DbSubnetGroupName = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *AwsRdsDbSubnetGroup) SetSubnetGroupStatus(v string) *AwsRdsDbSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsRdsDbSubnetGroup) SetSubnets(v []*AwsRdsDbSubnetGroupSubnet) *AwsRdsDbSubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsRdsDbSubnetGroup) SetVpcId(v string) *AwsRdsDbSubnetGroup {
	s.VpcId = &v
	return s
}

// Information about a subnet in a subnet group.
type AwsRdsDbSubnetGroupSubnet struct {
	_ struct{} `type:"structure"`

	// Information about the Availability Zone for a subnet in the subnet group.
	SubnetAvailabilityZone *AwsRdsDbSubnetGroupSubnetAvailabilityZone `type:"structure"`

	// The identifier of a subnet in the subnet group.
	SubnetIdentifier *string `type:"string"`

	// The status of a subnet in the subnet group.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbSubnetGroupSubnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbSubnetGroupSubnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *AwsRdsDbSubnetGroupSubnet) SetSubnetAvailabilityZone(v *AwsRdsDbSubnetGroupSubnetAvailabilityZone) *AwsRdsDbSubnetGroupSubnet {
	s.SubnetAvailabilityZone = v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *AwsRdsDbSubnetGroupSubnet) SetSubnetIdentifier(v string) *AwsRdsDbSubnetGroupSubnet {
	s.SubnetIdentifier = &v
	return s
}

// SetSubnetStatus sets the SubnetStatus field's value.
func (s *AwsRdsDbSubnetGroupSubnet) SetSubnetStatus(v string) *AwsRdsDbSubnetGroupSubnet {
	s.SubnetStatus = &v
	return s
}

// An Availability Zone for a subnet in a subnet group.
type AwsRdsDbSubnetGroupSubnetAvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone for a subnet in the subnet group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbSubnetGroupSubnetAvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsDbSubnetGroupSubnetAvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AwsRdsDbSubnetGroupSubnetAvailabilityZone) SetName(v string) *AwsRdsDbSubnetGroupSubnetAvailabilityZone {
	s.Name = &v
	return s
}

// Identifies the log types to enable and disable.
type AwsRdsPendingCloudWatchLogsExports struct {
	_ struct{} `type:"structure"`

	// A list of log types that are being disabled.
	LogTypesToDisable []*string `type:"list"`

	// A list of log types that are being enabled.
	LogTypesToEnable []*string `type:"list"`
}

// String returns the string representation
func (s AwsRdsPendingCloudWatchLogsExports) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRdsPendingCloudWatchLogsExports) GoString() string {
	return s.String()
}

// SetLogTypesToDisable sets the LogTypesToDisable field's value.
func (s *AwsRdsPendingCloudWatchLogsExports) SetLogTypesToDisable(v []*string) *AwsRdsPendingCloudWatchLogsExports {
	s.LogTypesToDisable = v
	return s
}

// SetLogTypesToEnable sets the LogTypesToEnable field's value.
func (s *AwsRdsPendingCloudWatchLogsExports) SetLogTypesToEnable(v []*string) *AwsRdsPendingCloudWatchLogsExports {
	s.LogTypesToEnable = v
	return s
}

// A node in an Amazon Redshift cluster.
type AwsRedshiftClusterClusterNode struct {
	_ struct{} `type:"structure"`

	// The role of the node. A node might be a leader node or a compute node.
	NodeRole *string `type:"string"`

	// The private IP address of the node.
	PrivateIpAddress *string `type:"string"`

	// The public IP address of the node.
	PublicIpAddress *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterClusterNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterClusterNode) GoString() string {
	return s.String()
}

// SetNodeRole sets the NodeRole field's value.
func (s *AwsRedshiftClusterClusterNode) SetNodeRole(v string) *AwsRedshiftClusterClusterNode {
	s.NodeRole = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *AwsRedshiftClusterClusterNode) SetPrivateIpAddress(v string) *AwsRedshiftClusterClusterNode {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIpAddress sets the PublicIpAddress field's value.
func (s *AwsRedshiftClusterClusterNode) SetPublicIpAddress(v string) *AwsRedshiftClusterClusterNode {
	s.PublicIpAddress = &v
	return s
}

// A cluster parameter group that is associated with an Amazon Redshift cluster.
type AwsRedshiftClusterClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The list of parameter statuses.
	ClusterParameterStatusList []*AwsRedshiftClusterClusterParameterStatus `type:"list"`

	// The status of updates to the parameters.
	ParameterApplyStatus *string `type:"string"`

	// The name of the parameter group.
	ParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterClusterParameterGroup) GoString() string {
	return s.String()
}

// SetClusterParameterStatusList sets the ClusterParameterStatusList field's value.
func (s *AwsRedshiftClusterClusterParameterGroup) SetClusterParameterStatusList(v []*AwsRedshiftClusterClusterParameterStatus) *AwsRedshiftClusterClusterParameterGroup {
	s.ClusterParameterStatusList = v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *AwsRedshiftClusterClusterParameterGroup) SetParameterApplyStatus(v string) *AwsRedshiftClusterClusterParameterGroup {
	s.ParameterApplyStatus = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *AwsRedshiftClusterClusterParameterGroup) SetParameterGroupName(v string) *AwsRedshiftClusterClusterParameterGroup {
	s.ParameterGroupName = &v
	return s
}

// The status of a parameter in a cluster parameter group for an Amazon Redshift
// cluster.
type AwsRedshiftClusterClusterParameterStatus struct {
	_ struct{} `type:"structure"`

	// The error that prevented the parameter from being applied to the database.
	ParameterApplyErrorDescription *string `type:"string"`

	// The status of the parameter. Indicates whether the parameter is in sync with
	// the database, waiting for a cluster reboot, or encountered an error when
	// it was applied.
	//
	// Valid values: in-sync | pending-reboot | applying | invalid-parameter | apply-deferred
	// | apply-error | unknown-error
	ParameterApplyStatus *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterClusterParameterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterClusterParameterStatus) GoString() string {
	return s.String()
}

// SetParameterApplyErrorDescription sets the ParameterApplyErrorDescription field's value.
func (s *AwsRedshiftClusterClusterParameterStatus) SetParameterApplyErrorDescription(v string) *AwsRedshiftClusterClusterParameterStatus {
	s.ParameterApplyErrorDescription = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *AwsRedshiftClusterClusterParameterStatus) SetParameterApplyStatus(v string) *AwsRedshiftClusterClusterParameterStatus {
	s.ParameterApplyStatus = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *AwsRedshiftClusterClusterParameterStatus) SetParameterName(v string) *AwsRedshiftClusterClusterParameterStatus {
	s.ParameterName = &v
	return s
}

// A security group that is associated with the cluster.
type AwsRedshiftClusterClusterSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group.
	ClusterSecurityGroupName *string `type:"string"`

	// The status of the cluster security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterClusterSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterClusterSecurityGroup) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *AwsRedshiftClusterClusterSecurityGroup) SetClusterSecurityGroupName(v string) *AwsRedshiftClusterClusterSecurityGroup {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterClusterSecurityGroup) SetStatus(v string) *AwsRedshiftClusterClusterSecurityGroup {
	s.Status = &v
	return s
}

// Information about a cross-Region snapshot copy.
type AwsRedshiftClusterClusterSnapshotCopyStatus struct {
	_ struct{} `type:"structure"`

	// The destination Region that snapshots are automatically copied to when cross-Region
	// snapshot copy is enabled.
	DestinationRegion *string `type:"string"`

	// The number of days that manual snapshots are retained in the destination
	// region after they are copied from a source region.
	//
	// If the value is -1, then the manual snapshot is retained indefinitely.
	//
	// Valid values: Either -1 or an integer between 1 and 3,653
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The number of days to retain automated snapshots in the destination Region
	// after they are copied from a source Region.
	RetentionPeriod *int64 `type:"integer"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterClusterSnapshotCopyStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterClusterSnapshotCopyStatus) GoString() string {
	return s.String()
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *AwsRedshiftClusterClusterSnapshotCopyStatus) SetDestinationRegion(v string) *AwsRedshiftClusterClusterSnapshotCopyStatus {
	s.DestinationRegion = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *AwsRedshiftClusterClusterSnapshotCopyStatus) SetManualSnapshotRetentionPeriod(v int64) *AwsRedshiftClusterClusterSnapshotCopyStatus {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *AwsRedshiftClusterClusterSnapshotCopyStatus) SetRetentionPeriod(v int64) *AwsRedshiftClusterClusterSnapshotCopyStatus {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *AwsRedshiftClusterClusterSnapshotCopyStatus) SetSnapshotCopyGrantName(v string) *AwsRedshiftClusterClusterSnapshotCopyStatus {
	s.SnapshotCopyGrantName = &v
	return s
}

// A time windows during which maintenance was deferred for an Amazon Redshift
// cluster.
type AwsRedshiftClusterDeferredMaintenanceWindow struct {
	_ struct{} `type:"structure"`

	// The end of the time window for which maintenance was deferred.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	DeferMaintenanceEndTime *string `type:"string"`

	// The identifier of the maintenance window.
	DeferMaintenanceIdentifier *string `type:"string"`

	// The start of the time window for which maintenance was deferred.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	DeferMaintenanceStartTime *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterDeferredMaintenanceWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterDeferredMaintenanceWindow) GoString() string {
	return s.String()
}

// SetDeferMaintenanceEndTime sets the DeferMaintenanceEndTime field's value.
func (s *AwsRedshiftClusterDeferredMaintenanceWindow) SetDeferMaintenanceEndTime(v string) *AwsRedshiftClusterDeferredMaintenanceWindow {
	s.DeferMaintenanceEndTime = &v
	return s
}

// SetDeferMaintenanceIdentifier sets the DeferMaintenanceIdentifier field's value.
func (s *AwsRedshiftClusterDeferredMaintenanceWindow) SetDeferMaintenanceIdentifier(v string) *AwsRedshiftClusterDeferredMaintenanceWindow {
	s.DeferMaintenanceIdentifier = &v
	return s
}

// SetDeferMaintenanceStartTime sets the DeferMaintenanceStartTime field's value.
func (s *AwsRedshiftClusterDeferredMaintenanceWindow) SetDeferMaintenanceStartTime(v string) *AwsRedshiftClusterDeferredMaintenanceWindow {
	s.DeferMaintenanceStartTime = &v
	return s
}

// Details about an Amazon Redshift cluster.
type AwsRedshiftClusterDetails struct {
	_ struct{} `type:"structure"`

	// Indicates whether major version upgrades are applied automatically to the
	// cluster during the maintenance window.
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automatic cluster snapshots are retained.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The name of the Availability Zone in which the cluster is located.
	AvailabilityZone *string `type:"string"`

	// The availability status of the cluster for queries. Possible values are the
	// following:
	//
	//    * Available - The cluster is available for queries.
	//
	//    * Unavailable - The cluster is not available for queries.
	//
	//    * Maintenance - The cluster is intermittently available for queries due
	//    to maintenance activities.
	//
	//    * Modifying -The cluster is intermittently available for queries due to
	//    changes that modify the cluster.
	//
	//    * Failed - The cluster failed and is not available for queries.
	ClusterAvailabilityStatus *string `type:"string"`

	// Indicates when the cluster was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ClusterCreateTime *string `type:"string"`

	// The unique identifier of the cluster.
	ClusterIdentifier *string `type:"string"`

	// The nodes in the cluster.
	ClusterNodes []*AwsRedshiftClusterClusterNode `type:"list"`

	// The list of cluster parameter groups that are associated with this cluster.
	ClusterParameterGroups []*AwsRedshiftClusterClusterParameterGroup `type:"list"`

	// The public key for the cluster.
	ClusterPublicKey *string `type:"string"`

	// The specific revision number of the database in the cluster.
	ClusterRevisionNumber *string `type:"string"`

	// A list of cluster security groups that are associated with the cluster.
	ClusterSecurityGroups []*AwsRedshiftClusterClusterSecurityGroup `type:"list"`

	// Information about the destination Region and retention period for the cross-Region
	// snapshot copy.
	ClusterSnapshotCopyStatus *AwsRedshiftClusterClusterSnapshotCopyStatus `type:"structure"`

	// The current status of the cluster.
	//
	// Valid values: available | available, prep-for-resize | available, resize-cleanup
	// |cancelling-resize | creating | deleting | final-snapshot | hardware-failure
	// | incompatible-hsm |incompatible-network | incompatible-parameters | incompatible-restore
	// | modifying | paused | rebooting | renaming | resizing | rotating-keys |
	// storage-full | updating-hsm
	ClusterStatus *string `type:"string"`

	// The name of the subnet group that is associated with the cluster. This parameter
	// is valid only when the cluster is in a VPC.
	ClusterSubnetGroupName *string `type:"string"`

	// The version ID of the Amazon Redshift engine that runs on the cluster.
	ClusterVersion *string `type:"string"`

	// The name of the initial database that was created when the cluster was created.
	//
	// The same name is returned for the life of the cluster.
	//
	// If an initial database is not specified, a database named devdev is created
	// by default.
	DBName *string `type:"string"`

	// List of time windows during which maintenance was deferred.
	DeferredMaintenanceWindows []*AwsRedshiftClusterDeferredMaintenanceWindow `type:"list"`

	// Information about the status of the Elastic IP (EIP) address.
	ElasticIpStatus *AwsRedshiftClusterElasticIpStatus `type:"structure"`

	// The number of nodes that you can use the elastic resize method to resize
	// the cluster to.
	ElasticResizeNumberOfNodeOptions *string `type:"string"`

	// Indicates whether the data in the cluster is encrypted at rest.
	Encrypted *bool `type:"boolean"`

	// The connection endpoint.
	Endpoint *AwsRedshiftClusterEndpoint `type:"structure"`

	// Indicates whether to create the cluster with enhanced VPC routing enabled.
	EnhancedVpcRouting *bool `type:"boolean"`

	// Indicates when the next snapshot is expected to be taken. The cluster must
	// have a valid snapshot schedule and have backups enabled.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	ExpectedNextSnapshotScheduleTime *string `type:"string"`

	// The status of the next expected snapshot.
	//
	// Valid values: OnTrack | Pending
	ExpectedNextSnapshotScheduleTimeStatus *string `type:"string"`

	// Information about whether the Amazon Redshift cluster finished applying any
	// changes to hardware security module (HSM) settings that were specified in
	// a modify cluster command.
	HsmStatus *AwsRedshiftClusterHsmStatus `type:"structure"`

	// A list of IAM roles that the cluster can use to access other AWS services.
	IamRoles []*AwsRedshiftClusterIamRole `type:"list"`

	// The identifier of the AWS KMS encryption key that is used to encrypt data
	// in the cluster.
	KmsKeyId *string `type:"string"`

	// The name of the maintenance track for the cluster.
	MaintenanceTrackName *string `type:"string"`

	// The default number of days to retain a manual snapshot.
	//
	// If the value is -1, the snapshot is retained indefinitely.
	//
	// This setting doesn't change the retention period of existing snapshots.
	//
	// Valid values: Either -1 or an integer between 1 and 3,653
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// The master user name for the cluster. This name is used to connect to the
	// database that is specified in as the value of DBName.
	MasterUsername *string `type:"string"`

	// Indicates the start of the next maintenance window.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	NextMaintenanceWindowStartTime *string `type:"string"`

	// The node type for the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of compute nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// A list of cluster operations that are waiting to start.
	PendingActions []*string `type:"list"`

	// A list of changes to the cluster that are currently pending.
	PendingModifiedValues *AwsRedshiftClusterPendingModifiedValues `type:"structure"`

	// The weekly time range, in Universal Coordinated Time (UTC), during which
	// system maintenance can occur.
	//
	// Format: <day>:HH:MM-<day>:HH:MM
	//
	// For the day values, use mon | tue | wed | thu | fri | sat | sun
	//
	// For example, sun:09:32-sun:10:02
	PreferredMaintenanceWindow *string `type:"string"`

	// Whether the cluster can be accessed from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// Information about the resize operation for the cluster.
	ResizeInfo *AwsRedshiftClusterResizeInfo `type:"structure"`

	// Information about the status of a cluster restore action. Only applies to
	// a cluster that was created by restoring a snapshot.
	RestoreStatus *AwsRedshiftClusterRestoreStatus `type:"structure"`

	// A unique identifier for the cluster snapshot schedule.
	SnapshotScheduleIdentifier *string `type:"string"`

	// The current state of the cluster snapshot schedule.
	//
	// Valid values: MODIFYING | ACTIVE | FAILED
	SnapshotScheduleState *string `type:"string"`

	// The identifier of the VPC that the cluster is in, if the cluster is in a
	// VPC.
	VpcId *string `type:"string"`

	// The list of VPC security groups that the cluster belongs to, if the cluster
	// is in a VPC.
	VpcSecurityGroups []*AwsRedshiftClusterVpcSecurityGroup `type:"list"`
}

// String returns the string representation
func (s AwsRedshiftClusterDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterDetails) GoString() string {
	return s.String()
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *AwsRedshiftClusterDetails) SetAllowVersionUpgrade(v bool) *AwsRedshiftClusterDetails {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *AwsRedshiftClusterDetails) SetAutomatedSnapshotRetentionPeriod(v int64) *AwsRedshiftClusterDetails {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *AwsRedshiftClusterDetails) SetAvailabilityZone(v string) *AwsRedshiftClusterDetails {
	s.AvailabilityZone = &v
	return s
}

// SetClusterAvailabilityStatus sets the ClusterAvailabilityStatus field's value.
func (s *AwsRedshiftClusterDetails) SetClusterAvailabilityStatus(v string) *AwsRedshiftClusterDetails {
	s.ClusterAvailabilityStatus = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *AwsRedshiftClusterDetails) SetClusterCreateTime(v string) *AwsRedshiftClusterDetails {
	s.ClusterCreateTime = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *AwsRedshiftClusterDetails) SetClusterIdentifier(v string) *AwsRedshiftClusterDetails {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterNodes sets the ClusterNodes field's value.
func (s *AwsRedshiftClusterDetails) SetClusterNodes(v []*AwsRedshiftClusterClusterNode) *AwsRedshiftClusterDetails {
	s.ClusterNodes = v
	return s
}

// SetClusterParameterGroups sets the ClusterParameterGroups field's value.
func (s *AwsRedshiftClusterDetails) SetClusterParameterGroups(v []*AwsRedshiftClusterClusterParameterGroup) *AwsRedshiftClusterDetails {
	s.ClusterParameterGroups = v
	return s
}

// SetClusterPublicKey sets the ClusterPublicKey field's value.
func (s *AwsRedshiftClusterDetails) SetClusterPublicKey(v string) *AwsRedshiftClusterDetails {
	s.ClusterPublicKey = &v
	return s
}

// SetClusterRevisionNumber sets the ClusterRevisionNumber field's value.
func (s *AwsRedshiftClusterDetails) SetClusterRevisionNumber(v string) *AwsRedshiftClusterDetails {
	s.ClusterRevisionNumber = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *AwsRedshiftClusterDetails) SetClusterSecurityGroups(v []*AwsRedshiftClusterClusterSecurityGroup) *AwsRedshiftClusterDetails {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterSnapshotCopyStatus sets the ClusterSnapshotCopyStatus field's value.
func (s *AwsRedshiftClusterDetails) SetClusterSnapshotCopyStatus(v *AwsRedshiftClusterClusterSnapshotCopyStatus) *AwsRedshiftClusterDetails {
	s.ClusterSnapshotCopyStatus = v
	return s
}

// SetClusterStatus sets the ClusterStatus field's value.
func (s *AwsRedshiftClusterDetails) SetClusterStatus(v string) *AwsRedshiftClusterDetails {
	s.ClusterStatus = &v
	return s
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *AwsRedshiftClusterDetails) SetClusterSubnetGroupName(v string) *AwsRedshiftClusterDetails {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *AwsRedshiftClusterDetails) SetClusterVersion(v string) *AwsRedshiftClusterDetails {
	s.ClusterVersion = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *AwsRedshiftClusterDetails) SetDBName(v string) *AwsRedshiftClusterDetails {
	s.DBName = &v
	return s
}

// SetDeferredMaintenanceWindows sets the DeferredMaintenanceWindows field's value.
func (s *AwsRedshiftClusterDetails) SetDeferredMaintenanceWindows(v []*AwsRedshiftClusterDeferredMaintenanceWindow) *AwsRedshiftClusterDetails {
	s.DeferredMaintenanceWindows = v
	return s
}

// SetElasticIpStatus sets the ElasticIpStatus field's value.
func (s *AwsRedshiftClusterDetails) SetElasticIpStatus(v *AwsRedshiftClusterElasticIpStatus) *AwsRedshiftClusterDetails {
	s.ElasticIpStatus = v
	return s
}

// SetElasticResizeNumberOfNodeOptions sets the ElasticResizeNumberOfNodeOptions field's value.
func (s *AwsRedshiftClusterDetails) SetElasticResizeNumberOfNodeOptions(v string) *AwsRedshiftClusterDetails {
	s.ElasticResizeNumberOfNodeOptions = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *AwsRedshiftClusterDetails) SetEncrypted(v bool) *AwsRedshiftClusterDetails {
	s.Encrypted = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsRedshiftClusterDetails) SetEndpoint(v *AwsRedshiftClusterEndpoint) *AwsRedshiftClusterDetails {
	s.Endpoint = v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *AwsRedshiftClusterDetails) SetEnhancedVpcRouting(v bool) *AwsRedshiftClusterDetails {
	s.EnhancedVpcRouting = &v
	return s
}

// SetExpectedNextSnapshotScheduleTime sets the ExpectedNextSnapshotScheduleTime field's value.
func (s *AwsRedshiftClusterDetails) SetExpectedNextSnapshotScheduleTime(v string) *AwsRedshiftClusterDetails {
	s.ExpectedNextSnapshotScheduleTime = &v
	return s
}

// SetExpectedNextSnapshotScheduleTimeStatus sets the ExpectedNextSnapshotScheduleTimeStatus field's value.
func (s *AwsRedshiftClusterDetails) SetExpectedNextSnapshotScheduleTimeStatus(v string) *AwsRedshiftClusterDetails {
	s.ExpectedNextSnapshotScheduleTimeStatus = &v
	return s
}

// SetHsmStatus sets the HsmStatus field's value.
func (s *AwsRedshiftClusterDetails) SetHsmStatus(v *AwsRedshiftClusterHsmStatus) *AwsRedshiftClusterDetails {
	s.HsmStatus = v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *AwsRedshiftClusterDetails) SetIamRoles(v []*AwsRedshiftClusterIamRole) *AwsRedshiftClusterDetails {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsRedshiftClusterDetails) SetKmsKeyId(v string) *AwsRedshiftClusterDetails {
	s.KmsKeyId = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *AwsRedshiftClusterDetails) SetMaintenanceTrackName(v string) *AwsRedshiftClusterDetails {
	s.MaintenanceTrackName = &v
	return s
}

// SetManualSnapshotRetentionPeriod sets the ManualSnapshotRetentionPeriod field's value.
func (s *AwsRedshiftClusterDetails) SetManualSnapshotRetentionPeriod(v int64) *AwsRedshiftClusterDetails {
	s.ManualSnapshotRetentionPeriod = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *AwsRedshiftClusterDetails) SetMasterUsername(v string) *AwsRedshiftClusterDetails {
	s.MasterUsername = &v
	return s
}

// SetNextMaintenanceWindowStartTime sets the NextMaintenanceWindowStartTime field's value.
func (s *AwsRedshiftClusterDetails) SetNextMaintenanceWindowStartTime(v string) *AwsRedshiftClusterDetails {
	s.NextMaintenanceWindowStartTime = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *AwsRedshiftClusterDetails) SetNodeType(v string) *AwsRedshiftClusterDetails {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *AwsRedshiftClusterDetails) SetNumberOfNodes(v int64) *AwsRedshiftClusterDetails {
	s.NumberOfNodes = &v
	return s
}

// SetPendingActions sets the PendingActions field's value.
func (s *AwsRedshiftClusterDetails) SetPendingActions(v []*string) *AwsRedshiftClusterDetails {
	s.PendingActions = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *AwsRedshiftClusterDetails) SetPendingModifiedValues(v *AwsRedshiftClusterPendingModifiedValues) *AwsRedshiftClusterDetails {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *AwsRedshiftClusterDetails) SetPreferredMaintenanceWindow(v string) *AwsRedshiftClusterDetails {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *AwsRedshiftClusterDetails) SetPubliclyAccessible(v bool) *AwsRedshiftClusterDetails {
	s.PubliclyAccessible = &v
	return s
}

// SetResizeInfo sets the ResizeInfo field's value.
func (s *AwsRedshiftClusterDetails) SetResizeInfo(v *AwsRedshiftClusterResizeInfo) *AwsRedshiftClusterDetails {
	s.ResizeInfo = v
	return s
}

// SetRestoreStatus sets the RestoreStatus field's value.
func (s *AwsRedshiftClusterDetails) SetRestoreStatus(v *AwsRedshiftClusterRestoreStatus) *AwsRedshiftClusterDetails {
	s.RestoreStatus = v
	return s
}

// SetSnapshotScheduleIdentifier sets the SnapshotScheduleIdentifier field's value.
func (s *AwsRedshiftClusterDetails) SetSnapshotScheduleIdentifier(v string) *AwsRedshiftClusterDetails {
	s.SnapshotScheduleIdentifier = &v
	return s
}

// SetSnapshotScheduleState sets the SnapshotScheduleState field's value.
func (s *AwsRedshiftClusterDetails) SetSnapshotScheduleState(v string) *AwsRedshiftClusterDetails {
	s.SnapshotScheduleState = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AwsRedshiftClusterDetails) SetVpcId(v string) *AwsRedshiftClusterDetails {
	s.VpcId = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *AwsRedshiftClusterDetails) SetVpcSecurityGroups(v []*AwsRedshiftClusterVpcSecurityGroup) *AwsRedshiftClusterDetails {
	s.VpcSecurityGroups = v
	return s
}

// The status of the elastic IP (EIP) address for an Amazon Redshift cluster.
type AwsRedshiftClusterElasticIpStatus struct {
	_ struct{} `type:"structure"`

	// The elastic IP address for the cluster.
	ElasticIp *string `type:"string"`

	// The status of the elastic IP address.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterElasticIpStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterElasticIpStatus) GoString() string {
	return s.String()
}

// SetElasticIp sets the ElasticIp field's value.
func (s *AwsRedshiftClusterElasticIpStatus) SetElasticIp(v string) *AwsRedshiftClusterElasticIpStatus {
	s.ElasticIp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterElasticIpStatus) SetStatus(v string) *AwsRedshiftClusterElasticIpStatus {
	s.Status = &v
	return s
}

// The connection endpoint for an Amazon Redshift cluster.
type AwsRedshiftClusterEndpoint struct {
	_ struct{} `type:"structure"`

	// The DNS address of the cluster.
	Address *string `type:"string"`

	// The port that the database engine listens on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsRedshiftClusterEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterEndpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *AwsRedshiftClusterEndpoint) SetAddress(v string) *AwsRedshiftClusterEndpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AwsRedshiftClusterEndpoint) SetPort(v int64) *AwsRedshiftClusterEndpoint {
	s.Port = &v
	return s
}

// Information about whether an Amazon Redshift cluster finished applying any
// hardware changes to security module (HSM) settings that were specified in
// a modify cluster command.
type AwsRedshiftClusterHsmStatus struct {
	_ struct{} `type:"structure"`

	// The name of the HSM client certificate that the Amazon Redshift cluster uses
	// to retrieve the data encryption keys that are stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// The name of the HSM configuration that contains the information that the
	// Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// Indicates whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command.
	//
	// Type: String
	//
	// Valid values: active | applying
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterHsmStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterHsmStatus) GoString() string {
	return s.String()
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *AwsRedshiftClusterHsmStatus) SetHsmClientCertificateIdentifier(v string) *AwsRedshiftClusterHsmStatus {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *AwsRedshiftClusterHsmStatus) SetHsmConfigurationIdentifier(v string) *AwsRedshiftClusterHsmStatus {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterHsmStatus) SetStatus(v string) *AwsRedshiftClusterHsmStatus {
	s.Status = &v
	return s
}

// An IAM role that the cluster can use to access other AWS services.
type AwsRedshiftClusterIamRole struct {
	_ struct{} `type:"structure"`

	// The status of the IAM role's association with the cluster.
	//
	// Valid values: in-sync | adding | removing
	ApplyStatus *string `type:"string"`

	// The ARN of the IAM role.
	IamRoleArn *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterIamRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterIamRole) GoString() string {
	return s.String()
}

// SetApplyStatus sets the ApplyStatus field's value.
func (s *AwsRedshiftClusterIamRole) SetApplyStatus(v string) *AwsRedshiftClusterIamRole {
	s.ApplyStatus = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *AwsRedshiftClusterIamRole) SetIamRoleArn(v string) *AwsRedshiftClusterIamRole {
	s.IamRoleArn = &v
	return s
}

// Changes to the Amazon Redshift cluster that are currently pending.
type AwsRedshiftClusterPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The pending or in-progress change to the automated snapshot retention period.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The pending or in-progress change to the identifier for the cluster.
	ClusterIdentifier *string `type:"string"`

	// The pending or in-progress change to the cluster type.
	ClusterType *string `type:"string"`

	// The pending or in-progress change to the service version.
	ClusterVersion *string `type:"string"`

	// The encryption type for a cluster.
	EncryptionType *string `type:"string"`

	// Indicates whether to create the cluster with enhanced VPC routing enabled.
	EnhancedVpcRouting *bool `type:"boolean"`

	// The name of the maintenance track that the cluster changes to during the
	// next maintenance window.
	MaintenanceTrackName *string `type:"string"`

	// The pending or in-progress change to the master user password for the cluster.
	MasterUserPassword *string `type:"string"`

	// The pending or in-progress change to the cluster's node type.
	NodeType *string `type:"string"`

	// The pending or in-progress change to the number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// The pending or in-progress change to whether the cluster can be connected
	// to from the public network.
	PubliclyAccessible *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsRedshiftClusterPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterPendingModifiedValues) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetAutomatedSnapshotRetentionPeriod(v int64) *AwsRedshiftClusterPendingModifiedValues {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetClusterIdentifier(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetClusterType(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetClusterVersion(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.ClusterVersion = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetEncryptionType(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.EncryptionType = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetEnhancedVpcRouting(v bool) *AwsRedshiftClusterPendingModifiedValues {
	s.EnhancedVpcRouting = &v
	return s
}

// SetMaintenanceTrackName sets the MaintenanceTrackName field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetMaintenanceTrackName(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.MaintenanceTrackName = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetMasterUserPassword(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.MasterUserPassword = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetNodeType(v string) *AwsRedshiftClusterPendingModifiedValues {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetNumberOfNodes(v int64) *AwsRedshiftClusterPendingModifiedValues {
	s.NumberOfNodes = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *AwsRedshiftClusterPendingModifiedValues) SetPubliclyAccessible(v bool) *AwsRedshiftClusterPendingModifiedValues {
	s.PubliclyAccessible = &v
	return s
}

// Information about the resize operation for the cluster.
type AwsRedshiftClusterResizeInfo struct {
	_ struct{} `type:"structure"`

	// Indicates whether the resize operation can be canceled.
	AllowCancelResize *bool `type:"boolean"`

	// The type of resize operation.
	//
	// Valid values: ClassicResize
	ResizeType *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterResizeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterResizeInfo) GoString() string {
	return s.String()
}

// SetAllowCancelResize sets the AllowCancelResize field's value.
func (s *AwsRedshiftClusterResizeInfo) SetAllowCancelResize(v bool) *AwsRedshiftClusterResizeInfo {
	s.AllowCancelResize = &v
	return s
}

// SetResizeType sets the ResizeType field's value.
func (s *AwsRedshiftClusterResizeInfo) SetResizeType(v string) *AwsRedshiftClusterResizeInfo {
	s.ResizeType = &v
	return s
}

// Information about the status of a cluster restore action. It only applies
// if the cluster was created by restoring a snapshot.
type AwsRedshiftClusterRestoreStatus struct {
	_ struct{} `type:"structure"`

	// The number of megabytes per second being transferred from the backup storage.
	// Returns the average rate for a completed backup.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	CurrentRestoreRateInMegaBytesPerSecond *float64 `type:"double"`

	// The amount of time an in-progress restore has been running, or the amount
	// of time it took a completed restore to finish.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimate of the time remaining before the restore is complete. Returns
	// 0 for a completed restore.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The number of megabytes that were transferred from snapshot storage.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	ProgressInMegaBytes *int64 `type:"long"`

	// The size of the set of snapshot data that was used to restore the cluster.
	//
	// This field is only updated when you restore to DC2 and DS2 node types.
	SnapshotSizeInMegaBytes *int64 `type:"long"`

	// The status of the restore action.
	//
	// Valid values: starting | restoring | completed | failed
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterRestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterRestoreStatus) GoString() string {
	return s.String()
}

// SetCurrentRestoreRateInMegaBytesPerSecond sets the CurrentRestoreRateInMegaBytesPerSecond field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetCurrentRestoreRateInMegaBytesPerSecond(v float64) *AwsRedshiftClusterRestoreStatus {
	s.CurrentRestoreRateInMegaBytesPerSecond = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetElapsedTimeInSeconds(v int64) *AwsRedshiftClusterRestoreStatus {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEstimatedTimeToCompletionInSeconds sets the EstimatedTimeToCompletionInSeconds field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetEstimatedTimeToCompletionInSeconds(v int64) *AwsRedshiftClusterRestoreStatus {
	s.EstimatedTimeToCompletionInSeconds = &v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetProgressInMegaBytes(v int64) *AwsRedshiftClusterRestoreStatus {
	s.ProgressInMegaBytes = &v
	return s
}

// SetSnapshotSizeInMegaBytes sets the SnapshotSizeInMegaBytes field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetSnapshotSizeInMegaBytes(v int64) *AwsRedshiftClusterRestoreStatus {
	s.SnapshotSizeInMegaBytes = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterRestoreStatus) SetStatus(v string) *AwsRedshiftClusterRestoreStatus {
	s.Status = &v
	return s
}

// A VPC security group that the cluster belongs to, if the cluster is in a
// VPC.
type AwsRedshiftClusterVpcSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The identifier of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s AwsRedshiftClusterVpcSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsRedshiftClusterVpcSecurityGroup) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AwsRedshiftClusterVpcSecurityGroup) SetStatus(v string) *AwsRedshiftClusterVpcSecurityGroup {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *AwsRedshiftClusterVpcSecurityGroup) SetVpcSecurityGroupId(v string) *AwsRedshiftClusterVpcSecurityGroup {
	s.VpcSecurityGroupId = &v
	return s
}

// The details of an Amazon S3 bucket.
type AwsS3BucketDetails struct {
	_ struct{} `type:"structure"`

	// Indicates when the S3 bucket was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	CreatedAt *string `type:"string"`

	// The canonical user ID of the owner of the S3 bucket.
	OwnerId *string `type:"string"`

	// The display name of the owner of the S3 bucket.
	OwnerName *string `type:"string"`

	// The encryption rules that are applied to the S3 bucket.
	ServerSideEncryptionConfiguration *AwsS3BucketServerSideEncryptionConfiguration `type:"structure"`
}

// String returns the string representation
func (s AwsS3BucketDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsS3BucketDetails) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsS3BucketDetails) SetCreatedAt(v string) *AwsS3BucketDetails {
	s.CreatedAt = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AwsS3BucketDetails) SetOwnerId(v string) *AwsS3BucketDetails {
	s.OwnerId = &v
	return s
}

// SetOwnerName sets the OwnerName field's value.
func (s *AwsS3BucketDetails) SetOwnerName(v string) *AwsS3BucketDetails {
	s.OwnerName = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *AwsS3BucketDetails) SetServerSideEncryptionConfiguration(v *AwsS3BucketServerSideEncryptionConfiguration) *AwsS3BucketDetails {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// Specifies the default server-side encryption to apply to new objects in the
// bucket.
type AwsS3BucketServerSideEncryptionByDefault struct {
	_ struct{} `type:"structure"`

	// AWS KMS customer master key (CMK) ID to use for the default encryption.
	KMSMasterKeyID *string `type:"string"`

	// Server-side encryption algorithm to use for the default encryption.
	SSEAlgorithm *string `type:"string"`
}

// String returns the string representation
func (s AwsS3BucketServerSideEncryptionByDefault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsS3BucketServerSideEncryptionByDefault) GoString() string {
	return s.String()
}

// SetKMSMasterKeyID sets the KMSMasterKeyID field's value.
func (s *AwsS3BucketServerSideEncryptionByDefault) SetKMSMasterKeyID(v string) *AwsS3BucketServerSideEncryptionByDefault {
	s.KMSMasterKeyID = &v
	return s
}

// SetSSEAlgorithm sets the SSEAlgorithm field's value.
func (s *AwsS3BucketServerSideEncryptionByDefault) SetSSEAlgorithm(v string) *AwsS3BucketServerSideEncryptionByDefault {
	s.SSEAlgorithm = &v
	return s
}

// The encryption configuration for the S3 bucket.
type AwsS3BucketServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The encryption rules that are applied to the S3 bucket.
	Rules []*AwsS3BucketServerSideEncryptionRule `type:"list"`
}

// String returns the string representation
func (s AwsS3BucketServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsS3BucketServerSideEncryptionConfiguration) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *AwsS3BucketServerSideEncryptionConfiguration) SetRules(v []*AwsS3BucketServerSideEncryptionRule) *AwsS3BucketServerSideEncryptionConfiguration {
	s.Rules = v
	return s
}

// An encryption rule to apply to the S3 bucket.
type AwsS3BucketServerSideEncryptionRule struct {
	_ struct{} `type:"structure"`

	// Specifies the default server-side encryption to apply to new objects in the
	// bucket. If a PUT object request doesn't specify any server-side encryption,
	// this default encryption is applied.
	ApplyServerSideEncryptionByDefault *AwsS3BucketServerSideEncryptionByDefault `type:"structure"`
}

// String returns the string representation
func (s AwsS3BucketServerSideEncryptionRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsS3BucketServerSideEncryptionRule) GoString() string {
	return s.String()
}

// SetApplyServerSideEncryptionByDefault sets the ApplyServerSideEncryptionByDefault field's value.
func (s *AwsS3BucketServerSideEncryptionRule) SetApplyServerSideEncryptionByDefault(v *AwsS3BucketServerSideEncryptionByDefault) *AwsS3BucketServerSideEncryptionRule {
	s.ApplyServerSideEncryptionByDefault = v
	return s
}

// Details about an Amazon S3 object.
type AwsS3ObjectDetails struct {
	_ struct{} `type:"structure"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `type:"string"`

	// The opaque identifier assigned by a web server to a specific version of a
	// resource found at a URL.
	ETag *string `type:"string"`

	// Indicates when the object was last modified.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastModified *string `type:"string"`

	// The identifier of the AWS Key Management Service (AWS KMS) symmetric customer
	// managed customer master key (CMK) that was used for the object.
	SSEKMSKeyId *string `type:"string"`

	// If the object is stored using server-side encryption, the value of the server-side
	// encryption algorithm used when storing this object in Amazon S3.
	ServerSideEncryption *string `type:"string"`

	// The version of the object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s AwsS3ObjectDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsS3ObjectDetails) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *AwsS3ObjectDetails) SetContentType(v string) *AwsS3ObjectDetails {
	s.ContentType = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *AwsS3ObjectDetails) SetETag(v string) *AwsS3ObjectDetails {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *AwsS3ObjectDetails) SetLastModified(v string) *AwsS3ObjectDetails {
	s.LastModified = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *AwsS3ObjectDetails) SetSSEKMSKeyId(v string) *AwsS3ObjectDetails {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *AwsS3ObjectDetails) SetServerSideEncryption(v string) *AwsS3ObjectDetails {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *AwsS3ObjectDetails) SetVersionId(v string) *AwsS3ObjectDetails {
	s.VersionId = &v
	return s
}

// Details about an AWS Secrets Manager secret.
type AwsSecretsManagerSecretDetails struct {
	_ struct{} `type:"structure"`

	// Whether the secret is deleted.
	Deleted *bool `type:"boolean"`

	// The user-provided description of the secret.
	Description *string `type:"string"`

	// The ARN, Key ID, or alias of the AWS KMS customer master key (CMK) used to
	// encrypt the SecretString or SecretBinary values for versions of this secret.
	KmsKeyId *string `type:"string"`

	// The name of the secret.
	Name *string `type:"string"`

	// Whether rotation is enabled.
	RotationEnabled *bool `type:"boolean"`

	// The ARN of the Lambda function that rotates the secret.
	RotationLambdaArn *string `type:"string"`

	// Whether the rotation occurred within the specified rotation frequency.
	RotationOccurredWithinFrequency *bool `type:"boolean"`

	// Defines the rotation schedule for the secret.
	RotationRules *AwsSecretsManagerSecretRotationRules `type:"structure"`
}

// String returns the string representation
func (s AwsSecretsManagerSecretDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSecretsManagerSecretDetails) GoString() string {
	return s.String()
}

// SetDeleted sets the Deleted field's value.
func (s *AwsSecretsManagerSecretDetails) SetDeleted(v bool) *AwsSecretsManagerSecretDetails {
	s.Deleted = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsSecretsManagerSecretDetails) SetDescription(v string) *AwsSecretsManagerSecretDetails {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AwsSecretsManagerSecretDetails) SetKmsKeyId(v string) *AwsSecretsManagerSecretDetails {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsSecretsManagerSecretDetails) SetName(v string) *AwsSecretsManagerSecretDetails {
	s.Name = &v
	return s
}

// SetRotationEnabled sets the RotationEnabled field's value.
func (s *AwsSecretsManagerSecretDetails) SetRotationEnabled(v bool) *AwsSecretsManagerSecretDetails {
	s.RotationEnabled = &v
	return s
}

// SetRotationLambdaArn sets the RotationLambdaArn field's value.
func (s *AwsSecretsManagerSecretDetails) SetRotationLambdaArn(v string) *AwsSecretsManagerSecretDetails {
	s.RotationLambdaArn = &v
	return s
}

// SetRotationOccurredWithinFrequency sets the RotationOccurredWithinFrequency field's value.
func (s *AwsSecretsManagerSecretDetails) SetRotationOccurredWithinFrequency(v bool) *AwsSecretsManagerSecretDetails {
	s.RotationOccurredWithinFrequency = &v
	return s
}

// SetRotationRules sets the RotationRules field's value.
func (s *AwsSecretsManagerSecretDetails) SetRotationRules(v *AwsSecretsManagerSecretRotationRules) *AwsSecretsManagerSecretDetails {
	s.RotationRules = v
	return s
}

// Defines the rotation schedule for the secret.
type AwsSecretsManagerSecretRotationRules struct {
	_ struct{} `type:"structure"`

	// The number of days after the previous rotation to rotate the secret.
	AutomaticallyAfterDays *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsSecretsManagerSecretRotationRules) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSecretsManagerSecretRotationRules) GoString() string {
	return s.String()
}

// SetAutomaticallyAfterDays sets the AutomaticallyAfterDays field's value.
func (s *AwsSecretsManagerSecretRotationRules) SetAutomaticallyAfterDays(v int64) *AwsSecretsManagerSecretRotationRules {
	s.AutomaticallyAfterDays = &v
	return s
}

// Provides consistent format for the contents of the Security Hub-aggregated
// findings. AwsSecurityFinding format enables you to share findings between
// AWS security services and third-party solutions, and security standards checks.
//
// A finding is a potential security issue generated either by AWS services
// (Amazon GuardDuty, Amazon Inspector, and Amazon Macie) or by the integrated
// third-party solutions and standards checks.
type AwsSecurityFinding struct {
	_ struct{} `type:"structure"`

	// The AWS account ID that a finding is generated in.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// This data type is exclusive to findings that are generated as the result
	// of a check run against a specific rule in a supported security standard,
	// such as CIS AWS Foundations. Contains security standard-related finding details.
	Compliance *Compliance `type:"structure"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
	// zero percent confidence and 100 means 100 percent confidence.
	Confidence *int64 `type:"integer"`

	// Indicates when the security-findings provider created the potential security
	// issue that a finding captured.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	//
	// CreatedAt is a required field
	CreatedAt *string `type:"string" required:"true"`

	// The level of importance assigned to the resources associated with the finding.
	//
	// A score of 0 means that the underlying resources have no criticality, and
	// a score of 100 is reserved for the most critical resources.
	Criticality *int64 `type:"integer"`

	// A finding's description.
	//
	// In this release, Description is a required property.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// Indicates when the security-findings provider first observed the potential
	// security issue that a finding captured.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	FirstObservedAt *string `type:"string"`

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security-findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plugin, etc.
	//
	// GeneratorId is a required field
	GeneratorId *string `type:"string" required:"true"`

	// The security findings provider-specific identifier for a finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Indicates when the security-findings provider most recently observed the
	// potential security issue that a finding captured.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastObservedAt *string `type:"string"`

	// A list of malware related to a finding.
	Malware []*Malware `type:"list"`

	// The details of network-related information about a finding.
	Network *Network `type:"structure"`

	// Provides information about a network path that is relevant to a finding.
	// Each entry under NetworkPath represents a component of that path.
	NetworkPath []*NetworkPathComponent `type:"list"`

	// A user-defined note added to a finding.
	Note *Note `type:"structure"`

	// Provides an overview of the patch compliance status for an instance against
	// a selected compliance standard.
	PatchSummary *PatchSummary `type:"structure"`

	// The details of process-related information about a finding.
	Process *ProcessDetails `type:"structure"`

	// The ARN generated by Security Hub that uniquely identifies a product that
	// generates findings. This can be the ARN for a third-party product that is
	// integrated with Security Hub, or the ARN for a custom integration.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`

	// A data type where security-findings providers can include additional solution-specific
	// details that aren't part of the defined AwsSecurityFinding format.
	ProductFields map[string]*string `type:"map"`

	// The record state of a finding.
	RecordState *string `type:"string" enum:"RecordState"`

	// A list of related findings.
	RelatedFindings []*RelatedFinding `type:"list"`

	// A data type that describes the remediation options for a finding.
	Remediation *Remediation `type:"structure"`

	// A set of resource data types that describe the resources that the finding
	// refers to.
	//
	// Resources is a required field
	Resources []*Resource `type:"list" required:"true"`

	// The schema version that a finding is formatted for.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `type:"string" required:"true"`

	// A finding's severity.
	//
	// Severity is a required field
	Severity *Severity `type:"structure" required:"true"`

	// A URL that links to a page about the current finding in the security-findings
	// provider's solution.
	SourceUrl *string `type:"string"`

	// Threat intelligence details related to a finding.
	ThreatIntelIndicators []*ThreatIntelIndicator `type:"list"`

	// A finding's title.
	//
	// In this release, Title is a required property.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`

	// One or more finding types in the format of namespace/category/classifier
	// that classify a finding.
	//
	// Valid namespace values are: Software and Configuration Checks | TTPs | Effects
	// | Unusual Behaviors | Sensitive Data Identifications
	//
	// Types is a required field
	Types []*string `type:"list" required:"true"`

	// Indicates when the security-findings provider last updated the finding record.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields map[string]*string `type:"map"`

	// Indicates the veracity of a finding.
	VerificationState *string `type:"string" enum:"VerificationState"`

	// Provides a list of vulnerabilities associated with the findings.
	Vulnerabilities []*Vulnerability `type:"list"`

	// Provides information about the status of the investigation into a finding.
	Workflow *Workflow `type:"structure"`

	// The workflow state of a finding.
	WorkflowState *string `deprecated:"true" type:"string" enum:"WorkflowState"`
}

// String returns the string representation
func (s AwsSecurityFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSecurityFinding) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsSecurityFinding) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsSecurityFinding"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.CreatedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatedAt"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.GeneratorId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeneratorId"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}
	if s.SchemaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaVersion"))
	}
	if s.Severity == nil {
		invalidParams.Add(request.NewErrParamRequired("Severity"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Types == nil {
		invalidParams.Add(request.NewErrParamRequired("Types"))
	}
	if s.UpdatedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedAt"))
	}
	if s.Compliance != nil {
		if err := s.Compliance.Validate(); err != nil {
			invalidParams.AddNested("Compliance", err.(request.ErrInvalidParams))
		}
	}
	if s.Malware != nil {
		for i, v := range s.Malware {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Malware", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(request.ErrInvalidParams))
		}
	}
	if s.PatchSummary != nil {
		if err := s.PatchSummary.Validate(); err != nil {
			invalidParams.AddNested("PatchSummary", err.(request.ErrInvalidParams))
		}
	}
	if s.RelatedFindings != nil {
		for i, v := range s.RelatedFindings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedFindings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Vulnerabilities != nil {
		for i, v := range s.Vulnerabilities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Vulnerabilities", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *AwsSecurityFinding) SetAwsAccountId(v string) *AwsSecurityFinding {
	s.AwsAccountId = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AwsSecurityFinding) SetCompliance(v *Compliance) *AwsSecurityFinding {
	s.Compliance = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *AwsSecurityFinding) SetConfidence(v int64) *AwsSecurityFinding {
	s.Confidence = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsSecurityFinding) SetCreatedAt(v string) *AwsSecurityFinding {
	s.CreatedAt = &v
	return s
}

// SetCriticality sets the Criticality field's value.
func (s *AwsSecurityFinding) SetCriticality(v int64) *AwsSecurityFinding {
	s.Criticality = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsSecurityFinding) SetDescription(v string) *AwsSecurityFinding {
	s.Description = &v
	return s
}

// SetFirstObservedAt sets the FirstObservedAt field's value.
func (s *AwsSecurityFinding) SetFirstObservedAt(v string) *AwsSecurityFinding {
	s.FirstObservedAt = &v
	return s
}

// SetGeneratorId sets the GeneratorId field's value.
func (s *AwsSecurityFinding) SetGeneratorId(v string) *AwsSecurityFinding {
	s.GeneratorId = &v
	return s
}

// SetId sets the Id field's value.
func (s *AwsSecurityFinding) SetId(v string) *AwsSecurityFinding {
	s.Id = &v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *AwsSecurityFinding) SetLastObservedAt(v string) *AwsSecurityFinding {
	s.LastObservedAt = &v
	return s
}

// SetMalware sets the Malware field's value.
func (s *AwsSecurityFinding) SetMalware(v []*Malware) *AwsSecurityFinding {
	s.Malware = v
	return s
}

// SetNetwork sets the Network field's value.
func (s *AwsSecurityFinding) SetNetwork(v *Network) *AwsSecurityFinding {
	s.Network = v
	return s
}

// SetNetworkPath sets the NetworkPath field's value.
func (s *AwsSecurityFinding) SetNetworkPath(v []*NetworkPathComponent) *AwsSecurityFinding {
	s.NetworkPath = v
	return s
}

// SetNote sets the Note field's value.
func (s *AwsSecurityFinding) SetNote(v *Note) *AwsSecurityFinding {
	s.Note = v
	return s
}

// SetPatchSummary sets the PatchSummary field's value.
func (s *AwsSecurityFinding) SetPatchSummary(v *PatchSummary) *AwsSecurityFinding {
	s.PatchSummary = v
	return s
}

// SetProcess sets the Process field's value.
func (s *AwsSecurityFinding) SetProcess(v *ProcessDetails) *AwsSecurityFinding {
	s.Process = v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *AwsSecurityFinding) SetProductArn(v string) *AwsSecurityFinding {
	s.ProductArn = &v
	return s
}

// SetProductFields sets the ProductFields field's value.
func (s *AwsSecurityFinding) SetProductFields(v map[string]*string) *AwsSecurityFinding {
	s.ProductFields = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *AwsSecurityFinding) SetRecordState(v string) *AwsSecurityFinding {
	s.RecordState = &v
	return s
}

// SetRelatedFindings sets the RelatedFindings field's value.
func (s *AwsSecurityFinding) SetRelatedFindings(v []*RelatedFinding) *AwsSecurityFinding {
	s.RelatedFindings = v
	return s
}

// SetRemediation sets the Remediation field's value.
func (s *AwsSecurityFinding) SetRemediation(v *Remediation) *AwsSecurityFinding {
	s.Remediation = v
	return s
}

// SetResources sets the Resources field's value.
func (s *AwsSecurityFinding) SetResources(v []*Resource) *AwsSecurityFinding {
	s.Resources = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *AwsSecurityFinding) SetSchemaVersion(v string) *AwsSecurityFinding {
	s.SchemaVersion = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *AwsSecurityFinding) SetSeverity(v *Severity) *AwsSecurityFinding {
	s.Severity = v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *AwsSecurityFinding) SetSourceUrl(v string) *AwsSecurityFinding {
	s.SourceUrl = &v
	return s
}

// SetThreatIntelIndicators sets the ThreatIntelIndicators field's value.
func (s *AwsSecurityFinding) SetThreatIntelIndicators(v []*ThreatIntelIndicator) *AwsSecurityFinding {
	s.ThreatIntelIndicators = v
	return s
}

// SetTitle sets the Title field's value.
func (s *AwsSecurityFinding) SetTitle(v string) *AwsSecurityFinding {
	s.Title = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *AwsSecurityFinding) SetTypes(v []*string) *AwsSecurityFinding {
	s.Types = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AwsSecurityFinding) SetUpdatedAt(v string) *AwsSecurityFinding {
	s.UpdatedAt = &v
	return s
}

// SetUserDefinedFields sets the UserDefinedFields field's value.
func (s *AwsSecurityFinding) SetUserDefinedFields(v map[string]*string) *AwsSecurityFinding {
	s.UserDefinedFields = v
	return s
}

// SetVerificationState sets the VerificationState field's value.
func (s *AwsSecurityFinding) SetVerificationState(v string) *AwsSecurityFinding {
	s.VerificationState = &v
	return s
}

// SetVulnerabilities sets the Vulnerabilities field's value.
func (s *AwsSecurityFinding) SetVulnerabilities(v []*Vulnerability) *AwsSecurityFinding {
	s.Vulnerabilities = v
	return s
}

// SetWorkflow sets the Workflow field's value.
func (s *AwsSecurityFinding) SetWorkflow(v *Workflow) *AwsSecurityFinding {
	s.Workflow = v
	return s
}

// SetWorkflowState sets the WorkflowState field's value.
func (s *AwsSecurityFinding) SetWorkflowState(v string) *AwsSecurityFinding {
	s.WorkflowState = &v
	return s
}

// A collection of attributes that are applied to all active Security Hub-aggregated
// findings and that result in a subset of findings that are included in this
// insight.
//
// You can filter by up to 10 finding attributes. For each attribute, you can
// provide up to 20 filter values.
type AwsSecurityFindingFilters struct {
	_ struct{} `type:"structure"`

	// The AWS account ID that a finding is generated in.
	AwsAccountId []*StringFilter `type:"list"`

	// The name of the findings provider (company) that owns the solution (product)
	// that generates findings.
	CompanyName []*StringFilter `type:"list"`

	// Exclusive to findings that are generated as the result of a check run against
	// a specific rule in a supported standard, such as CIS AWS Foundations. Contains
	// security standard-related finding details.
	ComplianceStatus []*StringFilter `type:"list"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
	// zero percent confidence and 100 means 100 percent confidence.
	Confidence []*NumberFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider captured the potential security issue that a finding captured.
	CreatedAt []*DateFilter `type:"list"`

	// The level of importance assigned to the resources associated with the finding.
	//
	// A score of 0 means that the underlying resources have no criticality, and
	// a score of 100 is reserved for the most critical resources.
	Criticality []*NumberFilter `type:"list"`

	// A finding's description.
	Description []*StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider first observed the potential security issue that a finding captured.
	FirstObservedAt []*DateFilter `type:"list"`

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security-findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plugin, etc.
	GeneratorId []*StringFilter `type:"list"`

	// The security findings provider-specific identifier for a finding.
	Id []*StringFilter `type:"list"`

	// A keyword for a finding.
	Keyword []*KeywordFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider most recently observed the potential security issue that a finding
	// captured.
	LastObservedAt []*DateFilter `type:"list"`

	// The name of the malware that was observed.
	MalwareName []*StringFilter `type:"list"`

	// The filesystem path of the malware that was observed.
	MalwarePath []*StringFilter `type:"list"`

	// The state of the malware that was observed.
	MalwareState []*StringFilter `type:"list"`

	// The type of the malware that was observed.
	MalwareType []*StringFilter `type:"list"`

	// The destination domain of network-related information about a finding.
	NetworkDestinationDomain []*StringFilter `type:"list"`

	// The destination IPv4 address of network-related information about a finding.
	NetworkDestinationIpV4 []*IpFilter `type:"list"`

	// The destination IPv6 address of network-related information about a finding.
	NetworkDestinationIpV6 []*IpFilter `type:"list"`

	// The destination port of network-related information about a finding.
	NetworkDestinationPort []*NumberFilter `type:"list"`

	// Indicates the direction of network traffic associated with a finding.
	NetworkDirection []*StringFilter `type:"list"`

	// The protocol of network-related information about a finding.
	NetworkProtocol []*StringFilter `type:"list"`

	// The source domain of network-related information about a finding.
	NetworkSourceDomain []*StringFilter `type:"list"`

	// The source IPv4 address of network-related information about a finding.
	NetworkSourceIpV4 []*IpFilter `type:"list"`

	// The source IPv6 address of network-related information about a finding.
	NetworkSourceIpV6 []*IpFilter `type:"list"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	NetworkSourceMac []*StringFilter `type:"list"`

	// The source port of network-related information about a finding.
	NetworkSourcePort []*NumberFilter `type:"list"`

	// The text of a note.
	NoteText []*StringFilter `type:"list"`

	// The timestamp of when the note was updated.
	NoteUpdatedAt []*DateFilter `type:"list"`

	// The principal that created a note.
	NoteUpdatedBy []*StringFilter `type:"list"`

	// The date/time that the process was launched.
	ProcessLaunchedAt []*DateFilter `type:"list"`

	// The name of the process.
	ProcessName []*StringFilter `type:"list"`

	// The parent process ID.
	ProcessParentPid []*NumberFilter `type:"list"`

	// The path to the process executable.
	ProcessPath []*StringFilter `type:"list"`

	// The process ID.
	ProcessPid []*NumberFilter `type:"list"`

	// The date/time that the process was terminated.
	ProcessTerminatedAt []*DateFilter `type:"list"`

	// The ARN generated by Security Hub that uniquely identifies a third-party
	// company (security findings provider) after this provider's product (solution
	// that generates findings) is registered with Security Hub.
	ProductArn []*StringFilter `type:"list"`

	// A data type where security-findings providers can include additional solution-specific
	// details that aren't part of the defined AwsSecurityFinding format.
	ProductFields []*MapFilter `type:"list"`

	// The name of the solution (product) that generates findings.
	ProductName []*StringFilter `type:"list"`

	// The recommendation of what to do about the issue described in a finding.
	RecommendationText []*StringFilter `type:"list"`

	// The updated record state for the finding.
	RecordState []*StringFilter `type:"list"`

	// The solution-generated identifier for a related finding.
	RelatedFindingsId []*StringFilter `type:"list"`

	// The ARN of the solution that generated a related finding.
	RelatedFindingsProductArn []*StringFilter `type:"list"`

	// The IAM profile ARN of the instance.
	ResourceAwsEc2InstanceIamInstanceProfileArn []*StringFilter `type:"list"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ResourceAwsEc2InstanceImageId []*StringFilter `type:"list"`

	// The IPv4 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV4Addresses []*IpFilter `type:"list"`

	// The IPv6 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV6Addresses []*IpFilter `type:"list"`

	// The key name associated with the instance.
	ResourceAwsEc2InstanceKeyName []*StringFilter `type:"list"`

	// The date and time the instance was launched.
	ResourceAwsEc2InstanceLaunchedAt []*DateFilter `type:"list"`

	// The identifier of the subnet that the instance was launched in.
	ResourceAwsEc2InstanceSubnetId []*StringFilter `type:"list"`

	// The instance type of the instance.
	ResourceAwsEc2InstanceType []*StringFilter `type:"list"`

	// The identifier of the VPC that the instance was launched in.
	ResourceAwsEc2InstanceVpcId []*StringFilter `type:"list"`

	// The creation date/time of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyCreatedAt []*DateFilter `type:"list"`

	// The status of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyStatus []*StringFilter `type:"list"`

	// The user associated with the IAM access key related to a finding.
	ResourceAwsIamAccessKeyUserName []*StringFilter `type:"list"`

	// The canonical user ID of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerId []*StringFilter `type:"list"`

	// The display name of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerName []*StringFilter `type:"list"`

	// The identifier of the image related to a finding.
	ResourceContainerImageId []*StringFilter `type:"list"`

	// The name of the image related to a finding.
	ResourceContainerImageName []*StringFilter `type:"list"`

	// The date/time that the container was started.
	ResourceContainerLaunchedAt []*DateFilter `type:"list"`

	// The name of the container related to a finding.
	ResourceContainerName []*StringFilter `type:"list"`

	// The details of a resource that doesn't have a specific subfield for the resource
	// type defined.
	ResourceDetailsOther []*MapFilter `type:"list"`

	// The canonical identifier for the given resource type.
	ResourceId []*StringFilter `type:"list"`

	// The canonical AWS partition name that the Region is assigned to.
	ResourcePartition []*StringFilter `type:"list"`

	// The canonical AWS external Region name where this resource is located.
	ResourceRegion []*StringFilter `type:"list"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	ResourceTags []*MapFilter `type:"list"`

	// Specifies the type of the resource that details are provided for.
	ResourceType []*StringFilter `type:"list"`

	// The label of a finding's severity.
	SeverityLabel []*StringFilter `type:"list"`

	// The normalized severity of a finding.
	SeverityNormalized []*NumberFilter `type:"list"`

	// The native severity as defined by the security-findings provider's solution
	// that generated the finding.
	SeverityProduct []*NumberFilter `type:"list"`

	// A URL that links to a page about the current finding in the security-findings
	// provider's solution.
	SourceUrl []*StringFilter `type:"list"`

	// The category of a threat intelligence indicator.
	ThreatIntelIndicatorCategory []*StringFilter `type:"list"`

	// The date/time of the last observation of a threat intelligence indicator.
	ThreatIntelIndicatorLastObservedAt []*DateFilter `type:"list"`

	// The source of the threat intelligence.
	ThreatIntelIndicatorSource []*StringFilter `type:"list"`

	// The URL for more details from the source of the threat intelligence.
	ThreatIntelIndicatorSourceUrl []*StringFilter `type:"list"`

	// The type of a threat intelligence indicator.
	ThreatIntelIndicatorType []*StringFilter `type:"list"`

	// The value of a threat intelligence indicator.
	ThreatIntelIndicatorValue []*StringFilter `type:"list"`

	// A finding's title.
	Title []*StringFilter `type:"list"`

	// A finding type in the format of namespace/category/classifier that classifies
	// a finding.
	Type []*StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider last updated the finding record.
	UpdatedAt []*DateFilter `type:"list"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields []*MapFilter `type:"list"`

	// The veracity of a finding.
	VerificationState []*StringFilter `type:"list"`

	// The workflow state of a finding.
	//
	// Note that this field is deprecated. To search for a finding based on its
	// workflow status, use WorkflowStatus.
	WorkflowState []*StringFilter `type:"list"`

	// The status of the investigation into a finding. Allowed values are the following.
	//
	//    * NEW - The initial state of a finding, before it is reviewed.
	//
	//    * NOTIFIED - Indicates that the resource owner has been notified about
	//    the security issue. Used when the initial reviewer is not the resource
	//    owner, and needs intervention from the resource owner.
	//
	//    * SUPPRESSED - The finding will not be reviewed again and will not be
	//    acted upon.
	//
	//    * RESOLVED - The finding was reviewed and remediated and is now considered
	//    resolved.
	WorkflowStatus []*StringFilter `type:"list"`
}

// String returns the string representation
func (s AwsSecurityFindingFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSecurityFindingFilters) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *AwsSecurityFindingFilters) SetAwsAccountId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.AwsAccountId = v
	return s
}

// SetCompanyName sets the CompanyName field's value.
func (s *AwsSecurityFindingFilters) SetCompanyName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.CompanyName = v
	return s
}

// SetComplianceStatus sets the ComplianceStatus field's value.
func (s *AwsSecurityFindingFilters) SetComplianceStatus(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ComplianceStatus = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *AwsSecurityFindingFilters) SetConfidence(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.Confidence = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AwsSecurityFindingFilters) SetCreatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.CreatedAt = v
	return s
}

// SetCriticality sets the Criticality field's value.
func (s *AwsSecurityFindingFilters) SetCriticality(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.Criticality = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AwsSecurityFindingFilters) SetDescription(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Description = v
	return s
}

// SetFirstObservedAt sets the FirstObservedAt field's value.
func (s *AwsSecurityFindingFilters) SetFirstObservedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.FirstObservedAt = v
	return s
}

// SetGeneratorId sets the GeneratorId field's value.
func (s *AwsSecurityFindingFilters) SetGeneratorId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.GeneratorId = v
	return s
}

// SetId sets the Id field's value.
func (s *AwsSecurityFindingFilters) SetId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Id = v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *AwsSecurityFindingFilters) SetKeyword(v []*KeywordFilter) *AwsSecurityFindingFilters {
	s.Keyword = v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *AwsSecurityFindingFilters) SetLastObservedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.LastObservedAt = v
	return s
}

// SetMalwareName sets the MalwareName field's value.
func (s *AwsSecurityFindingFilters) SetMalwareName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwareName = v
	return s
}

// SetMalwarePath sets the MalwarePath field's value.
func (s *AwsSecurityFindingFilters) SetMalwarePath(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwarePath = v
	return s
}

// SetMalwareState sets the MalwareState field's value.
func (s *AwsSecurityFindingFilters) SetMalwareState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwareState = v
	return s
}

// SetMalwareType sets the MalwareType field's value.
func (s *AwsSecurityFindingFilters) SetMalwareType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.MalwareType = v
	return s
}

// SetNetworkDestinationDomain sets the NetworkDestinationDomain field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationDomain(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationDomain = v
	return s
}

// SetNetworkDestinationIpV4 sets the NetworkDestinationIpV4 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationIpV4(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationIpV4 = v
	return s
}

// SetNetworkDestinationIpV6 sets the NetworkDestinationIpV6 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationIpV6(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationIpV6 = v
	return s
}

// SetNetworkDestinationPort sets the NetworkDestinationPort field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDestinationPort(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.NetworkDestinationPort = v
	return s
}

// SetNetworkDirection sets the NetworkDirection field's value.
func (s *AwsSecurityFindingFilters) SetNetworkDirection(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkDirection = v
	return s
}

// SetNetworkProtocol sets the NetworkProtocol field's value.
func (s *AwsSecurityFindingFilters) SetNetworkProtocol(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkProtocol = v
	return s
}

// SetNetworkSourceDomain sets the NetworkSourceDomain field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceDomain(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceDomain = v
	return s
}

// SetNetworkSourceIpV4 sets the NetworkSourceIpV4 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceIpV4(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceIpV4 = v
	return s
}

// SetNetworkSourceIpV6 sets the NetworkSourceIpV6 field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceIpV6(v []*IpFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceIpV6 = v
	return s
}

// SetNetworkSourceMac sets the NetworkSourceMac field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourceMac(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NetworkSourceMac = v
	return s
}

// SetNetworkSourcePort sets the NetworkSourcePort field's value.
func (s *AwsSecurityFindingFilters) SetNetworkSourcePort(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.NetworkSourcePort = v
	return s
}

// SetNoteText sets the NoteText field's value.
func (s *AwsSecurityFindingFilters) SetNoteText(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NoteText = v
	return s
}

// SetNoteUpdatedAt sets the NoteUpdatedAt field's value.
func (s *AwsSecurityFindingFilters) SetNoteUpdatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.NoteUpdatedAt = v
	return s
}

// SetNoteUpdatedBy sets the NoteUpdatedBy field's value.
func (s *AwsSecurityFindingFilters) SetNoteUpdatedBy(v []*StringFilter) *AwsSecurityFindingFilters {
	s.NoteUpdatedBy = v
	return s
}

// SetProcessLaunchedAt sets the ProcessLaunchedAt field's value.
func (s *AwsSecurityFindingFilters) SetProcessLaunchedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ProcessLaunchedAt = v
	return s
}

// SetProcessName sets the ProcessName field's value.
func (s *AwsSecurityFindingFilters) SetProcessName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProcessName = v
	return s
}

// SetProcessParentPid sets the ProcessParentPid field's value.
func (s *AwsSecurityFindingFilters) SetProcessParentPid(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.ProcessParentPid = v
	return s
}

// SetProcessPath sets the ProcessPath field's value.
func (s *AwsSecurityFindingFilters) SetProcessPath(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProcessPath = v
	return s
}

// SetProcessPid sets the ProcessPid field's value.
func (s *AwsSecurityFindingFilters) SetProcessPid(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.ProcessPid = v
	return s
}

// SetProcessTerminatedAt sets the ProcessTerminatedAt field's value.
func (s *AwsSecurityFindingFilters) SetProcessTerminatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ProcessTerminatedAt = v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *AwsSecurityFindingFilters) SetProductArn(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProductArn = v
	return s
}

// SetProductFields sets the ProductFields field's value.
func (s *AwsSecurityFindingFilters) SetProductFields(v []*MapFilter) *AwsSecurityFindingFilters {
	s.ProductFields = v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *AwsSecurityFindingFilters) SetProductName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ProductName = v
	return s
}

// SetRecommendationText sets the RecommendationText field's value.
func (s *AwsSecurityFindingFilters) SetRecommendationText(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RecommendationText = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *AwsSecurityFindingFilters) SetRecordState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RecordState = v
	return s
}

// SetRelatedFindingsId sets the RelatedFindingsId field's value.
func (s *AwsSecurityFindingFilters) SetRelatedFindingsId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RelatedFindingsId = v
	return s
}

// SetRelatedFindingsProductArn sets the RelatedFindingsProductArn field's value.
func (s *AwsSecurityFindingFilters) SetRelatedFindingsProductArn(v []*StringFilter) *AwsSecurityFindingFilters {
	s.RelatedFindingsProductArn = v
	return s
}

// SetResourceAwsEc2InstanceIamInstanceProfileArn sets the ResourceAwsEc2InstanceIamInstanceProfileArn field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceIamInstanceProfileArn(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceIamInstanceProfileArn = v
	return s
}

// SetResourceAwsEc2InstanceImageId sets the ResourceAwsEc2InstanceImageId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceImageId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceImageId = v
	return s
}

// SetResourceAwsEc2InstanceIpV4Addresses sets the ResourceAwsEc2InstanceIpV4Addresses field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceIpV4Addresses(v []*IpFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceIpV4Addresses = v
	return s
}

// SetResourceAwsEc2InstanceIpV6Addresses sets the ResourceAwsEc2InstanceIpV6Addresses field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceIpV6Addresses(v []*IpFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceIpV6Addresses = v
	return s
}

// SetResourceAwsEc2InstanceKeyName sets the ResourceAwsEc2InstanceKeyName field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceKeyName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceKeyName = v
	return s
}

// SetResourceAwsEc2InstanceLaunchedAt sets the ResourceAwsEc2InstanceLaunchedAt field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceLaunchedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceLaunchedAt = v
	return s
}

// SetResourceAwsEc2InstanceSubnetId sets the ResourceAwsEc2InstanceSubnetId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceSubnetId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceSubnetId = v
	return s
}

// SetResourceAwsEc2InstanceType sets the ResourceAwsEc2InstanceType field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceType = v
	return s
}

// SetResourceAwsEc2InstanceVpcId sets the ResourceAwsEc2InstanceVpcId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsEc2InstanceVpcId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsEc2InstanceVpcId = v
	return s
}

// SetResourceAwsIamAccessKeyCreatedAt sets the ResourceAwsIamAccessKeyCreatedAt field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsIamAccessKeyCreatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsIamAccessKeyCreatedAt = v
	return s
}

// SetResourceAwsIamAccessKeyStatus sets the ResourceAwsIamAccessKeyStatus field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsIamAccessKeyStatus(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsIamAccessKeyStatus = v
	return s
}

// SetResourceAwsIamAccessKeyUserName sets the ResourceAwsIamAccessKeyUserName field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsIamAccessKeyUserName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsIamAccessKeyUserName = v
	return s
}

// SetResourceAwsS3BucketOwnerId sets the ResourceAwsS3BucketOwnerId field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsS3BucketOwnerId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsS3BucketOwnerId = v
	return s
}

// SetResourceAwsS3BucketOwnerName sets the ResourceAwsS3BucketOwnerName field's value.
func (s *AwsSecurityFindingFilters) SetResourceAwsS3BucketOwnerName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceAwsS3BucketOwnerName = v
	return s
}

// SetResourceContainerImageId sets the ResourceContainerImageId field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerImageId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerImageId = v
	return s
}

// SetResourceContainerImageName sets the ResourceContainerImageName field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerImageName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerImageName = v
	return s
}

// SetResourceContainerLaunchedAt sets the ResourceContainerLaunchedAt field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerLaunchedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerLaunchedAt = v
	return s
}

// SetResourceContainerName sets the ResourceContainerName field's value.
func (s *AwsSecurityFindingFilters) SetResourceContainerName(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceContainerName = v
	return s
}

// SetResourceDetailsOther sets the ResourceDetailsOther field's value.
func (s *AwsSecurityFindingFilters) SetResourceDetailsOther(v []*MapFilter) *AwsSecurityFindingFilters {
	s.ResourceDetailsOther = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AwsSecurityFindingFilters) SetResourceId(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceId = v
	return s
}

// SetResourcePartition sets the ResourcePartition field's value.
func (s *AwsSecurityFindingFilters) SetResourcePartition(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourcePartition = v
	return s
}

// SetResourceRegion sets the ResourceRegion field's value.
func (s *AwsSecurityFindingFilters) SetResourceRegion(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceRegion = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *AwsSecurityFindingFilters) SetResourceTags(v []*MapFilter) *AwsSecurityFindingFilters {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AwsSecurityFindingFilters) SetResourceType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ResourceType = v
	return s
}

// SetSeverityLabel sets the SeverityLabel field's value.
func (s *AwsSecurityFindingFilters) SetSeverityLabel(v []*StringFilter) *AwsSecurityFindingFilters {
	s.SeverityLabel = v
	return s
}

// SetSeverityNormalized sets the SeverityNormalized field's value.
func (s *AwsSecurityFindingFilters) SetSeverityNormalized(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.SeverityNormalized = v
	return s
}

// SetSeverityProduct sets the SeverityProduct field's value.
func (s *AwsSecurityFindingFilters) SetSeverityProduct(v []*NumberFilter) *AwsSecurityFindingFilters {
	s.SeverityProduct = v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *AwsSecurityFindingFilters) SetSourceUrl(v []*StringFilter) *AwsSecurityFindingFilters {
	s.SourceUrl = v
	return s
}

// SetThreatIntelIndicatorCategory sets the ThreatIntelIndicatorCategory field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorCategory(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorCategory = v
	return s
}

// SetThreatIntelIndicatorLastObservedAt sets the ThreatIntelIndicatorLastObservedAt field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorLastObservedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorLastObservedAt = v
	return s
}

// SetThreatIntelIndicatorSource sets the ThreatIntelIndicatorSource field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorSource(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorSource = v
	return s
}

// SetThreatIntelIndicatorSourceUrl sets the ThreatIntelIndicatorSourceUrl field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorSourceUrl(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorSourceUrl = v
	return s
}

// SetThreatIntelIndicatorType sets the ThreatIntelIndicatorType field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorType = v
	return s
}

// SetThreatIntelIndicatorValue sets the ThreatIntelIndicatorValue field's value.
func (s *AwsSecurityFindingFilters) SetThreatIntelIndicatorValue(v []*StringFilter) *AwsSecurityFindingFilters {
	s.ThreatIntelIndicatorValue = v
	return s
}

// SetTitle sets the Title field's value.
func (s *AwsSecurityFindingFilters) SetTitle(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Title = v
	return s
}

// SetType sets the Type field's value.
func (s *AwsSecurityFindingFilters) SetType(v []*StringFilter) *AwsSecurityFindingFilters {
	s.Type = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AwsSecurityFindingFilters) SetUpdatedAt(v []*DateFilter) *AwsSecurityFindingFilters {
	s.UpdatedAt = v
	return s
}

// SetUserDefinedFields sets the UserDefinedFields field's value.
func (s *AwsSecurityFindingFilters) SetUserDefinedFields(v []*MapFilter) *AwsSecurityFindingFilters {
	s.UserDefinedFields = v
	return s
}

// SetVerificationState sets the VerificationState field's value.
func (s *AwsSecurityFindingFilters) SetVerificationState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.VerificationState = v
	return s
}

// SetWorkflowState sets the WorkflowState field's value.
func (s *AwsSecurityFindingFilters) SetWorkflowState(v []*StringFilter) *AwsSecurityFindingFilters {
	s.WorkflowState = v
	return s
}

// SetWorkflowStatus sets the WorkflowStatus field's value.
func (s *AwsSecurityFindingFilters) SetWorkflowStatus(v []*StringFilter) *AwsSecurityFindingFilters {
	s.WorkflowStatus = v
	return s
}

// Identifies a finding to update using BatchUpdateFindings.
type AwsSecurityFindingIdentifier struct {
	_ struct{} `type:"structure"`

	// The identifier of the finding that was specified by the finding provider.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The ARN generated by Security Hub that uniquely identifies a product that
	// generates findings. This can be the ARN for a third-party product that is
	// integrated with Security Hub, or the ARN for a custom integration.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AwsSecurityFindingIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSecurityFindingIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsSecurityFindingIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsSecurityFindingIdentifier"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *AwsSecurityFindingIdentifier) SetId(v string) *AwsSecurityFindingIdentifier {
	s.Id = &v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *AwsSecurityFindingIdentifier) SetProductArn(v string) *AwsSecurityFindingIdentifier {
	s.ProductArn = &v
	return s
}

// A wrapper type for the topic's Amazon Resource Name (ARN).
type AwsSnsTopicDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom
	// CMK.
	KmsMasterKeyId *string `type:"string"`

	// The subscription's owner.
	Owner *string `type:"string"`

	// Subscription is an embedded property that describes the subscription endpoints
	// of an Amazon SNS topic.
	Subscription []*AwsSnsTopicSubscription `type:"list"`

	// The name of the topic.
	TopicName *string `type:"string"`
}

// String returns the string representation
func (s AwsSnsTopicDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSnsTopicDetails) GoString() string {
	return s.String()
}

// SetKmsMasterKeyId sets the KmsMasterKeyId field's value.
func (s *AwsSnsTopicDetails) SetKmsMasterKeyId(v string) *AwsSnsTopicDetails {
	s.KmsMasterKeyId = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *AwsSnsTopicDetails) SetOwner(v string) *AwsSnsTopicDetails {
	s.Owner = &v
	return s
}

// SetSubscription sets the Subscription field's value.
func (s *AwsSnsTopicDetails) SetSubscription(v []*AwsSnsTopicSubscription) *AwsSnsTopicDetails {
	s.Subscription = v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *AwsSnsTopicDetails) SetTopicName(v string) *AwsSnsTopicDetails {
	s.TopicName = &v
	return s
}

// A wrapper type for the attributes of an Amazon SNS subscription.
type AwsSnsTopicSubscription struct {
	_ struct{} `type:"structure"`

	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string `type:"string"`

	// The subscription's protocol.
	Protocol *string `type:"string"`
}

// String returns the string representation
func (s AwsSnsTopicSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSnsTopicSubscription) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *AwsSnsTopicSubscription) SetEndpoint(v string) *AwsSnsTopicSubscription {
	s.Endpoint = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AwsSnsTopicSubscription) SetProtocol(v string) *AwsSnsTopicSubscription {
	s.Protocol = &v
	return s
}

// Data about a queue.
type AwsSqsQueueDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon SQS
	// moves messages after the value of maxReceiveCount is exceeded.
	DeadLetterTargetArn *string `type:"string"`

	// The length of time, in seconds, for which Amazon SQS can reuse a data key
	// to encrypt or decrypt messages before calling AWS KMS again.
	KmsDataKeyReusePeriodSeconds *int64 `type:"integer"`

	// The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom
	// CMK.
	KmsMasterKeyId *string `type:"string"`

	// The name of the new queue.
	QueueName *string `type:"string"`
}

// String returns the string representation
func (s AwsSqsQueueDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsSqsQueueDetails) GoString() string {
	return s.String()
}

// SetDeadLetterTargetArn sets the DeadLetterTargetArn field's value.
func (s *AwsSqsQueueDetails) SetDeadLetterTargetArn(v string) *AwsSqsQueueDetails {
	s.DeadLetterTargetArn = &v
	return s
}

// SetKmsDataKeyReusePeriodSeconds sets the KmsDataKeyReusePeriodSeconds field's value.
func (s *AwsSqsQueueDetails) SetKmsDataKeyReusePeriodSeconds(v int64) *AwsSqsQueueDetails {
	s.KmsDataKeyReusePeriodSeconds = &v
	return s
}

// SetKmsMasterKeyId sets the KmsMasterKeyId field's value.
func (s *AwsSqsQueueDetails) SetKmsMasterKeyId(v string) *AwsSqsQueueDetails {
	s.KmsMasterKeyId = &v
	return s
}

// SetQueueName sets the QueueName field's value.
func (s *AwsSqsQueueDetails) SetQueueName(v string) *AwsSqsQueueDetails {
	s.QueueName = &v
	return s
}

// Details about a WAF WebACL.
type AwsWafWebAclDetails struct {
	_ struct{} `type:"structure"`

	// The action to perform if none of the rules contained in the WebACL match.
	DefaultAction *string `type:"string"`

	// A friendly name or description of the WebACL. You can't change the name of
	// a WebACL after you create it.
	Name *string `type:"string"`

	// An array that contains the action for each rule in a WebACL, the priority
	// of the rule, and the ID of the rule.
	Rules []*AwsWafWebAclRule `type:"list"`

	// A unique identifier for a WebACL.
	WebAclId *string `type:"string"`
}

// String returns the string representation
func (s AwsWafWebAclDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsWafWebAclDetails) GoString() string {
	return s.String()
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *AwsWafWebAclDetails) SetDefaultAction(v string) *AwsWafWebAclDetails {
	s.DefaultAction = &v
	return s
}

// SetName sets the Name field's value.
func (s *AwsWafWebAclDetails) SetName(v string) *AwsWafWebAclDetails {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *AwsWafWebAclDetails) SetRules(v []*AwsWafWebAclRule) *AwsWafWebAclDetails {
	s.Rules = v
	return s
}

// SetWebAclId sets the WebAclId field's value.
func (s *AwsWafWebAclDetails) SetWebAclId(v string) *AwsWafWebAclDetails {
	s.WebAclId = &v
	return s
}

// Details for a rule in a WAF WebACL.
type AwsWafWebAclRule struct {
	_ struct{} `type:"structure"`

	// Specifies the action that CloudFront or AWS WAF takes when a web request
	// matches the conditions in the rule.
	Action *WafAction `type:"structure"`

	// Rules to exclude from a rule group.
	ExcludedRules []*WafExcludedRule `type:"list"`

	// Use the OverrideAction to test your RuleGroup.
	//
	// Any rule in a RuleGroup can potentially block a request. If you set the OverrideAction
	// to None, the RuleGroup blocks a request if any individual rule in the RuleGroup
	// matches the request and is configured to block that request.
	//
	// However, if you first want to test the RuleGroup, set the OverrideAction
	// to Count. The RuleGroup then overrides any block action specified by individual
	// rules contained within the group. Instead of blocking matching requests,
	// those requests are counted.
	//
	// ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup
	// to a WebACL. In this case you do not use ActivatedRule|Action. For all other
	// update requests, ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.
	OverrideAction *WafOverrideAction `type:"structure"`

	// Specifies the order in which the rules in a WebACL are evaluated. Rules with
	// a lower value for Priority are evaluated before rules with a higher value.
	// The value must be a unique integer. If you add multiple rules to a WebACL,
	// the values do not need to be consecutive.
	Priority *int64 `type:"integer"`

	// The identifier for a rule.
	RuleId *string `type:"string"`

	// The rule type.
	//
	// Valid values: REGULAR | RATE_BASED | GROUP
	//
	// The default is REGULAR.
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsWafWebAclRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsWafWebAclRule) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *AwsWafWebAclRule) SetAction(v *WafAction) *AwsWafWebAclRule {
	s.Action = v
	return s
}

// SetExcludedRules sets the ExcludedRules field's value.
func (s *AwsWafWebAclRule) SetExcludedRules(v []*WafExcludedRule) *AwsWafWebAclRule {
	s.ExcludedRules = v
	return s
}

// SetOverrideAction sets the OverrideAction field's value.
func (s *AwsWafWebAclRule) SetOverrideAction(v *WafOverrideAction) *AwsWafWebAclRule {
	s.OverrideAction = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *AwsWafWebAclRule) SetPriority(v int64) *AwsWafWebAclRule {
	s.Priority = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *AwsWafWebAclRule) SetRuleId(v string) *AwsWafWebAclRule {
	s.RuleId = &v
	return s
}

// SetType sets the Type field's value.
func (s *AwsWafWebAclRule) SetType(v string) *AwsWafWebAclRule {
	s.Type = &v
	return s
}

type BatchDisableStandardsInput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the standards subscriptions to disable.
	//
	// StandardsSubscriptionArns is a required field
	StandardsSubscriptionArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDisableStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisableStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisableStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisableStandardsInput"}
	if s.StandardsSubscriptionArns == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsSubscriptionArns"))
	}
	if s.StandardsSubscriptionArns != nil && len(s.StandardsSubscriptionArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStandardsSubscriptionArns sets the StandardsSubscriptionArns field's value.
func (s *BatchDisableStandardsInput) SetStandardsSubscriptionArns(v []*string) *BatchDisableStandardsInput {
	s.StandardsSubscriptionArns = v
	return s
}

type BatchDisableStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the standards subscriptions that were disabled.
	StandardsSubscriptions []*StandardsSubscription `type:"list"`
}

// String returns the string representation
func (s BatchDisableStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisableStandardsOutput) GoString() string {
	return s.String()
}

// SetStandardsSubscriptions sets the StandardsSubscriptions field's value.
func (s *BatchDisableStandardsOutput) SetStandardsSubscriptions(v []*StandardsSubscription) *BatchDisableStandardsOutput {
	s.StandardsSubscriptions = v
	return s
}

type BatchEnableStandardsInput struct {
	_ struct{} `type:"structure"`

	// The list of standards checks to enable.
	//
	// StandardsSubscriptionRequests is a required field
	StandardsSubscriptionRequests []*StandardsSubscriptionRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchEnableStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEnableStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchEnableStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchEnableStandardsInput"}
	if s.StandardsSubscriptionRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsSubscriptionRequests"))
	}
	if s.StandardsSubscriptionRequests != nil && len(s.StandardsSubscriptionRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionRequests", 1))
	}
	if s.StandardsSubscriptionRequests != nil {
		for i, v := range s.StandardsSubscriptionRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StandardsSubscriptionRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStandardsSubscriptionRequests sets the StandardsSubscriptionRequests field's value.
func (s *BatchEnableStandardsInput) SetStandardsSubscriptionRequests(v []*StandardsSubscriptionRequest) *BatchEnableStandardsInput {
	s.StandardsSubscriptionRequests = v
	return s
}

type BatchEnableStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the standards subscriptions that were enabled.
	StandardsSubscriptions []*StandardsSubscription `type:"list"`
}

// String returns the string representation
func (s BatchEnableStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEnableStandardsOutput) GoString() string {
	return s.String()
}

// SetStandardsSubscriptions sets the StandardsSubscriptions field's value.
func (s *BatchEnableStandardsOutput) SetStandardsSubscriptions(v []*StandardsSubscription) *BatchEnableStandardsOutput {
	s.StandardsSubscriptions = v
	return s
}

type BatchImportFindingsInput struct {
	_ struct{} `type:"structure"`

	// A list of findings to import. To successfully import a finding, it must follow
	// the AWS Security Finding Format (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html).
	// Maximum of 100 findings per request.
	//
	// Findings is a required field
	Findings []*AwsSecurityFinding `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchImportFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchImportFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchImportFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchImportFindingsInput"}
	if s.Findings == nil {
		invalidParams.Add(request.NewErrParamRequired("Findings"))
	}
	if s.Findings != nil {
		for i, v := range s.Findings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Findings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindings sets the Findings field's value.
func (s *BatchImportFindingsInput) SetFindings(v []*AwsSecurityFinding) *BatchImportFindingsInput {
	s.Findings = v
	return s
}

type BatchImportFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The number of findings that failed to import.
	//
	// FailedCount is a required field
	FailedCount *int64 `type:"integer" required:"true"`

	// The list of findings that failed to import.
	FailedFindings []*ImportFindingsError `type:"list"`

	// The number of findings that were successfully imported.
	//
	// SuccessCount is a required field
	SuccessCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s BatchImportFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchImportFindingsOutput) GoString() string {
	return s.String()
}

// SetFailedCount sets the FailedCount field's value.
func (s *BatchImportFindingsOutput) SetFailedCount(v int64) *BatchImportFindingsOutput {
	s.FailedCount = &v
	return s
}

// SetFailedFindings sets the FailedFindings field's value.
func (s *BatchImportFindingsOutput) SetFailedFindings(v []*ImportFindingsError) *BatchImportFindingsOutput {
	s.FailedFindings = v
	return s
}

// SetSuccessCount sets the SuccessCount field's value.
func (s *BatchImportFindingsOutput) SetSuccessCount(v int64) *BatchImportFindingsOutput {
	s.SuccessCount = &v
	return s
}

type BatchUpdateFindingsInput struct {
	_ struct{} `type:"structure"`

	// The updated value for the finding confidence. Confidence is defined as the
	// likelihood that a finding accurately identifies the behavior or issue that
	// it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
	// zero percent confidence and 100 means 100 percent confidence.
	Confidence *int64 `type:"integer"`

	// The updated value for the level of importance assigned to the resources associated
	// with the findings.
	//
	// A score of 0 means that the underlying resources have no criticality, and
	// a score of 100 is reserved for the most critical resources.
	Criticality *int64 `type:"integer"`

	// The list of findings to update. BatchUpdateFindings can be used to update
	// up to 100 findings at a time.
	//
	// For each finding, the list provides the finding identifier and the ARN of
	// the finding provider.
	//
	// FindingIdentifiers is a required field
	FindingIdentifiers []*AwsSecurityFindingIdentifier `type:"list" required:"true"`

	// The updated note.
	Note *NoteUpdate `type:"structure"`

	// A list of findings that are related to the updated findings.
	RelatedFindings []*RelatedFinding `type:"list"`

	// Used to update the finding severity.
	Severity *SeverityUpdate `type:"structure"`

	// One or more finding types in the format of namespace/category/classifier
	// that classify a finding.
	//
	// Valid namespace values are as follows.
	//
	//    * Software and Configuration Checks
	//
	//    * TTPs
	//
	//    * Effects
	//
	//    * Unusual Behaviors
	//
	//    * Sensitive Data Identifications
	Types []*string `type:"list"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields map[string]*string `type:"map"`

	// Indicates the veracity of a finding.
	//
	// The available values for VerificationState are as follows.
	//
	//    * UNKNOWN – The default disposition of a security finding
	//
	//    * TRUE_POSITIVE – The security finding is confirmed
	//
	//    * FALSE_POSITIVE – The security finding was determined to be a false
	//    alarm
	//
	//    * BENIGN_POSITIVE – A special case of TRUE_POSITIVE where the finding
	//    doesn't pose any threat, is expected, or both
	VerificationState *string `type:"string" enum:"VerificationState"`

	// Used to update the workflow status of a finding.
	//
	// The workflow status indicates the progress of the investigation into the
	// finding.
	Workflow *WorkflowUpdate `type:"structure"`
}

// String returns the string representation
func (s BatchUpdateFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateFindingsInput"}
	if s.FindingIdentifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingIdentifiers"))
	}
	if s.FindingIdentifiers != nil {
		for i, v := range s.FindingIdentifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FindingIdentifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(request.ErrInvalidParams))
		}
	}
	if s.RelatedFindings != nil {
		for i, v := range s.RelatedFindings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedFindings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfidence sets the Confidence field's value.
func (s *BatchUpdateFindingsInput) SetConfidence(v int64) *BatchUpdateFindingsInput {
	s.Confidence = &v
	return s
}

// SetCriticality sets the Criticality field's value.
func (s *BatchUpdateFindingsInput) SetCriticality(v int64) *BatchUpdateFindingsInput {
	s.Criticality = &v
	return s
}

// SetFindingIdentifiers sets the FindingIdentifiers field's value.
func (s *BatchUpdateFindingsInput) SetFindingIdentifiers(v []*AwsSecurityFindingIdentifier) *BatchUpdateFindingsInput {
	s.FindingIdentifiers = v
	return s
}

// SetNote sets the Note field's value.
func (s *BatchUpdateFindingsInput) SetNote(v *NoteUpdate) *BatchUpdateFindingsInput {
	s.Note = v
	return s
}

// SetRelatedFindings sets the RelatedFindings field's value.
func (s *BatchUpdateFindingsInput) SetRelatedFindings(v []*RelatedFinding) *BatchUpdateFindingsInput {
	s.RelatedFindings = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *BatchUpdateFindingsInput) SetSeverity(v *SeverityUpdate) *BatchUpdateFindingsInput {
	s.Severity = v
	return s
}

// SetTypes sets the Types field's value.
func (s *BatchUpdateFindingsInput) SetTypes(v []*string) *BatchUpdateFindingsInput {
	s.Types = v
	return s
}

// SetUserDefinedFields sets the UserDefinedFields field's value.
func (s *BatchUpdateFindingsInput) SetUserDefinedFields(v map[string]*string) *BatchUpdateFindingsInput {
	s.UserDefinedFields = v
	return s
}

// SetVerificationState sets the VerificationState field's value.
func (s *BatchUpdateFindingsInput) SetVerificationState(v string) *BatchUpdateFindingsInput {
	s.VerificationState = &v
	return s
}

// SetWorkflow sets the Workflow field's value.
func (s *BatchUpdateFindingsInput) SetWorkflow(v *WorkflowUpdate) *BatchUpdateFindingsInput {
	s.Workflow = v
	return s
}

type BatchUpdateFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The list of findings that were updated successfully.
	//
	// ProcessedFindings is a required field
	ProcessedFindings []*AwsSecurityFindingIdentifier `type:"list" required:"true"`

	// The list of findings that were not updated.
	//
	// UnprocessedFindings is a required field
	UnprocessedFindings []*BatchUpdateFindingsUnprocessedFinding `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUpdateFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateFindingsOutput) GoString() string {
	return s.String()
}

// SetProcessedFindings sets the ProcessedFindings field's value.
func (s *BatchUpdateFindingsOutput) SetProcessedFindings(v []*AwsSecurityFindingIdentifier) *BatchUpdateFindingsOutput {
	s.ProcessedFindings = v
	return s
}

// SetUnprocessedFindings sets the UnprocessedFindings field's value.
func (s *BatchUpdateFindingsOutput) SetUnprocessedFindings(v []*BatchUpdateFindingsUnprocessedFinding) *BatchUpdateFindingsOutput {
	s.UnprocessedFindings = v
	return s
}

// A finding from a BatchUpdateFindings request that Security Hub was unable
// to update.
type BatchUpdateFindingsUnprocessedFinding struct {
	_ struct{} `type:"structure"`

	// The code associated with the error.
	//
	// ErrorCode is a required field
	ErrorCode *string `type:"string" required:"true"`

	// The message associated with the error.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The identifier of the finding that was not updated.
	//
	// FindingIdentifier is a required field
	FindingIdentifier *AwsSecurityFindingIdentifier `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchUpdateFindingsUnprocessedFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateFindingsUnprocessedFinding) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchUpdateFindingsUnprocessedFinding) SetErrorCode(v string) *BatchUpdateFindingsUnprocessedFinding {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchUpdateFindingsUnprocessedFinding) SetErrorMessage(v string) *BatchUpdateFindingsUnprocessedFinding {
	s.ErrorMessage = &v
	return s
}

// SetFindingIdentifier sets the FindingIdentifier field's value.
func (s *BatchUpdateFindingsUnprocessedFinding) SetFindingIdentifier(v *AwsSecurityFindingIdentifier) *BatchUpdateFindingsUnprocessedFinding {
	s.FindingIdentifier = v
	return s
}

// An IPv4 CIDR block association.
type CidrBlockAssociation struct {
	_ struct{} `type:"structure"`

	// The association ID for the IPv4 CIDR block.
	AssociationId *string `type:"string"`

	// The IPv4 CIDR block.
	CidrBlock *string `type:"string"`

	// Information about the state of the IPv4 CIDR block.
	CidrBlockState *string `type:"string"`
}

// String returns the string representation
func (s CidrBlockAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CidrBlockAssociation) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *CidrBlockAssociation) SetAssociationId(v string) *CidrBlockAssociation {
	s.AssociationId = &v
	return s
}

// SetCidrBlock sets the CidrBlock field's value.
func (s *CidrBlockAssociation) SetCidrBlock(v string) *CidrBlockAssociation {
	s.CidrBlock = &v
	return s
}

// SetCidrBlockState sets the CidrBlockState field's value.
func (s *CidrBlockAssociation) SetCidrBlockState(v string) *CidrBlockAssociation {
	s.CidrBlockState = &v
	return s
}

// Contains finding details that are specific to control-based findings. Only
// returned for findings generated from controls.
type Compliance struct {
	_ struct{} `type:"structure"`

	// For a control, the industry or regulatory framework requirements that are
	// related to the control. The check for that control is aligned with these
	// requirements.
	RelatedRequirements []*string `type:"list"`

	// The result of a standards check.
	//
	// The valid values for Status are as follows.
	//
	//    * PASSED - Standards check passed for all evaluated resources. WARNING
	//    - Some information is missing or this check is not supported for your
	//    configuration. FAILED - Standards check failed for at least one evaluated
	//    resource. NOT_AVAILABLE - Check could not be performed due to a service
	//    outage, API error, or because the result of the AWS Config evaluation
	//    was NOT_APPLICABLE. If the AWS Config evaluation result was NOT_APPLICABLE,
	//    then after 3 days, Security Hub automatically archives the finding.
	Status *string `type:"string" enum:"ComplianceStatus"`

	// For findings generated from controls, a list of reasons behind the value
	// of Status. For the list of status reason codes and their meanings, see Standards-related
	// information in the ASFF (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff)
	// in the AWS Security Hub User Guide.
	StatusReasons []*StatusReason `type:"list"`
}

// String returns the string representation
func (s Compliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Compliance) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Compliance) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Compliance"}
	if s.StatusReasons != nil {
		for i, v := range s.StatusReasons {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StatusReasons", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelatedRequirements sets the RelatedRequirements field's value.
func (s *Compliance) SetRelatedRequirements(v []*string) *Compliance {
	s.RelatedRequirements = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Compliance) SetStatus(v string) *Compliance {
	s.Status = &v
	return s
}

// SetStatusReasons sets the StatusReasons field's value.
func (s *Compliance) SetStatusReasons(v []*StatusReason) *Compliance {
	s.StatusReasons = v
	return s
}

// Container details related to a finding.
type ContainerDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the image related to a finding.
	ImageId *string `type:"string"`

	// The name of the image related to a finding.
	ImageName *string `type:"string"`

	// Indicates when the container started.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LaunchedAt *string `type:"string"`

	// The name of the container related to a finding.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ContainerDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerDetails) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *ContainerDetails) SetImageId(v string) *ContainerDetails {
	s.ImageId = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *ContainerDetails) SetImageName(v string) *ContainerDetails {
	s.ImageName = &v
	return s
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *ContainerDetails) SetLaunchedAt(v string) *ContainerDetails {
	s.LaunchedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContainerDetails) SetName(v string) *ContainerDetails {
	s.Name = &v
	return s
}

type CreateActionTargetInput struct {
	_ struct{} `type:"structure"`

	// The description for the custom action target.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The ID for the custom action target.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The name of the custom action target.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateActionTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActionTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateActionTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateActionTargetInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateActionTargetInput) SetDescription(v string) *CreateActionTargetInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateActionTargetInput) SetId(v string) *CreateActionTargetInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateActionTargetInput) SetName(v string) *CreateActionTargetInput {
	s.Name = &v
	return s
}

type CreateActionTargetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the custom action target.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateActionTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActionTargetOutput) GoString() string {
	return s.String()
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *CreateActionTargetOutput) SetActionTargetArn(v string) *CreateActionTargetOutput {
	s.ActionTargetArn = &v
	return s
}

type CreateInsightInput struct {
	_ struct{} `type:"structure"`

	// One or more attributes used to filter the findings included in the insight.
	// The insight only includes findings that match the criteria defined in the
	// filters.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The attribute used to group the findings for the insight. The grouping attribute
	// identifies the type of item that the insight applies to. For example, if
	// an insight is grouped by resource identifier, then the insight produces a
	// list of resource identifiers.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The name of the custom insight to create.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInsightInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.GroupByAttribute == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupByAttribute"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *CreateInsightInput) SetFilters(v *AwsSecurityFindingFilters) *CreateInsightInput {
	s.Filters = v
	return s
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *CreateInsightInput) SetGroupByAttribute(v string) *CreateInsightInput {
	s.GroupByAttribute = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInsightInput) SetName(v string) *CreateInsightInput {
	s.Name = &v
	return s
}

type CreateInsightOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight created.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInsightOutput) GoString() string {
	return s.String()
}

// SetInsightArn sets the InsightArn field's value.
func (s *CreateInsightOutput) SetInsightArn(v string) *CreateInsightOutput {
	s.InsightArn = &v
	return s
}

type CreateMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of accounts to associate with the Security Hub master account. For
	// each account, the list includes the account ID and optionally the email address.
	//
	// AccountDetails is a required field
	AccountDetails []*AccountDetails `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMembersInput"}
	if s.AccountDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountDetails"))
	}
	if s.AccountDetails != nil {
		for i, v := range s.AccountDetails {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountDetails", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountDetails sets the AccountDetails field's value.
func (s *CreateMembersInput) SetAccountDetails(v []*AccountDetails) *CreateMembersInput {
	s.AccountDetails = v
	return s
}

type CreateMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts that were not processed. For each account, the list
	// includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s CreateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *CreateMembersOutput) SetUnprocessedAccounts(v []*Result) *CreateMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// CVSS scores from the advisory related to the vulnerability.
type Cvss struct {
	_ struct{} `type:"structure"`

	// The base CVSS score.
	BaseScore *float64 `type:"double"`

	// The base scoring vector for the CVSS score.
	BaseVector *string `type:"string"`

	// The version of CVSS for the CVSS score.
	Version *string `type:"string"`
}

// String returns the string representation
func (s Cvss) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cvss) GoString() string {
	return s.String()
}

// SetBaseScore sets the BaseScore field's value.
func (s *Cvss) SetBaseScore(v float64) *Cvss {
	s.BaseScore = &v
	return s
}

// SetBaseVector sets the BaseVector field's value.
func (s *Cvss) SetBaseVector(v string) *Cvss {
	s.BaseVector = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Cvss) SetVersion(v string) *Cvss {
	s.Version = &v
	return s
}

// A date filter for querying findings.
type DateFilter struct {
	_ struct{} `type:"structure"`

	// A date range for the date filter.
	DateRange *DateRange `type:"structure"`

	// An end date for the date filter.
	End *string `type:"string"`

	// A start date for the date filter.
	Start *string `type:"string"`
}

// String returns the string representation
func (s DateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateFilter) GoString() string {
	return s.String()
}

// SetDateRange sets the DateRange field's value.
func (s *DateFilter) SetDateRange(v *DateRange) *DateFilter {
	s.DateRange = v
	return s
}

// SetEnd sets the End field's value.
func (s *DateFilter) SetEnd(v string) *DateFilter {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *DateFilter) SetStart(v string) *DateFilter {
	s.Start = &v
	return s
}

// A date range for the date filter.
type DateRange struct {
	_ struct{} `type:"structure"`

	// A date range unit for the date filter.
	Unit *string `type:"string" enum:"DateRangeUnit"`

	// A date range value for the date filter.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s DateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateRange) GoString() string {
	return s.String()
}

// SetUnit sets the Unit field's value.
func (s *DateRange) SetUnit(v string) *DateRange {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DateRange) SetValue(v int64) *DateRange {
	s.Value = &v
	return s
}

type DeclineInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The list of account IDs for the accounts from which to decline the invitations
	// to Security Hub.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeclineInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeclineInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeclineInvitationsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeclineInvitationsInput) SetAccountIds(v []*string) *DeclineInvitationsInput {
	s.AccountIds = v
	return s
}

type DeclineInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts that were not processed. For each account, the list
	// includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s DeclineInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeclineInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeclineInvitationsOutput) SetUnprocessedAccounts(v []*Result) *DeclineInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteActionTargetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom action target to delete.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `location:"uri" locationName:"ActionTargetArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteActionTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActionTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteActionTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteActionTargetInput"}
	if s.ActionTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTargetArn"))
	}
	if s.ActionTargetArn != nil && len(*s.ActionTargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionTargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *DeleteActionTargetInput) SetActionTargetArn(v string) *DeleteActionTargetInput {
	s.ActionTargetArn = &v
	return s
}

type DeleteActionTargetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom action target that was deleted.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteActionTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActionTargetOutput) GoString() string {
	return s.String()
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *DeleteActionTargetOutput) SetActionTargetArn(v string) *DeleteActionTargetOutput {
	s.ActionTargetArn = &v
	return s
}

type DeleteInsightInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight to delete.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInsightInput"}
	if s.InsightArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightArn"))
	}
	if s.InsightArn != nil && len(*s.InsightArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightArn sets the InsightArn field's value.
func (s *DeleteInsightInput) SetInsightArn(v string) *DeleteInsightInput {
	s.InsightArn = &v
	return s
}

type DeleteInsightOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight that was deleted.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInsightOutput) GoString() string {
	return s.String()
}

// SetInsightArn sets the InsightArn field's value.
func (s *DeleteInsightOutput) SetInsightArn(v string) *DeleteInsightOutput {
	s.InsightArn = &v
	return s
}

type DeleteInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The list of the account IDs that sent the invitations to delete.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInvitationsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteInvitationsInput) SetAccountIds(v []*string) *DeleteInvitationsInput {
	s.AccountIds = v
	return s
}

type DeleteInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts for which the invitations were not deleted. For
	// each account, the list includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s DeleteInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInvitationsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteInvitationsOutput) SetUnprocessedAccounts(v []*Result) *DeleteInvitationsOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of account IDs for the member accounts to delete.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteMembersInput) SetAccountIds(v []*string) *DeleteMembersInput {
	s.AccountIds = v
	return s
}

type DeleteMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts that were not deleted. For each account, the list
	// includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s DeleteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteMembersOutput) SetUnprocessedAccounts(v []*Result) *DeleteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type DescribeActionTargetsInput struct {
	_ struct{} `type:"structure"`

	// A list of custom action target ARNs for the custom action targets to retrieve.
	ActionTargetArns []*string `type:"list"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeActionTargets
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActionTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActionTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeActionTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeActionTargetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTargetArns sets the ActionTargetArns field's value.
func (s *DescribeActionTargetsInput) SetActionTargetArns(v []*string) *DescribeActionTargetsInput {
	s.ActionTargetArns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeActionTargetsInput) SetMaxResults(v int64) *DescribeActionTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeActionTargetsInput) SetNextToken(v string) *DescribeActionTargetsInput {
	s.NextToken = &v
	return s
}

type DescribeActionTargetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ActionTarget objects. Each object includes the ActionTargetArn,
	// Description, and Name of a custom action target available in Security Hub.
	//
	// ActionTargets is a required field
	ActionTargets []*ActionTarget `type:"list" required:"true"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActionTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActionTargetsOutput) GoString() string {
	return s.String()
}

// SetActionTargets sets the ActionTargets field's value.
func (s *DescribeActionTargetsOutput) SetActionTargets(v []*ActionTarget) *DescribeActionTargetsOutput {
	s.ActionTargets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeActionTargetsOutput) SetNextToken(v string) *DescribeActionTargetsOutput {
	s.NextToken = &v
	return s
}

type DescribeHubInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Hub resource to retrieve.
	HubArn *string `location:"querystring" locationName:"HubArn" type:"string"`
}

// String returns the string representation
func (s DescribeHubInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHubInput) GoString() string {
	return s.String()
}

// SetHubArn sets the HubArn field's value.
func (s *DescribeHubInput) SetHubArn(v string) *DescribeHubInput {
	s.HubArn = &v
	return s
}

type DescribeHubOutput struct {
	_ struct{} `type:"structure"`

	// Whether to automatically enable new controls when they are added to standards
	// that are enabled.
	//
	// If set to true, then new controls for enabled standards are enabled automatically.
	// If set to false, then new controls are not enabled.
	AutoEnableControls *bool `type:"boolean"`

	// The ARN of the Hub resource that was retrieved.
	HubArn *string `type:"string"`

	// The date and time when Security Hub was enabled in the account.
	SubscribedAt *string `type:"string"`
}

// String returns the string representation
func (s DescribeHubOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHubOutput) GoString() string {
	return s.String()
}

// SetAutoEnableControls sets the AutoEnableControls field's value.
func (s *DescribeHubOutput) SetAutoEnableControls(v bool) *DescribeHubOutput {
	s.AutoEnableControls = &v
	return s
}

// SetHubArn sets the HubArn field's value.
func (s *DescribeHubOutput) SetHubArn(v string) *DescribeHubOutput {
	s.HubArn = &v
	return s
}

// SetSubscribedAt sets the SubscribedAt field's value.
func (s *DescribeHubOutput) SetSubscribedAt(v string) *DescribeHubOutput {
	s.SubscribedAt = &v
	return s
}

type DescribeOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigurationInput) GoString() string {
	return s.String()
}

type DescribeOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Whether to automatically enable Security Hub for new accounts in the organization.
	//
	// If set to true, then Security Hub is enabled for new accounts. If set to
	// false, then new accounts are not added automatically.
	AutoEnable *bool `type:"boolean"`

	// Whether the maximum number of allowed member accounts are already associated
	// with the Security Hub administrator account.
	MemberAccountLimitReached *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *DescribeOrganizationConfigurationOutput) SetAutoEnable(v bool) *DescribeOrganizationConfigurationOutput {
	s.AutoEnable = &v
	return s
}

// SetMemberAccountLimitReached sets the MemberAccountLimitReached field's value.
func (s *DescribeOrganizationConfigurationOutput) SetMemberAccountLimitReached(v bool) *DescribeOrganizationConfigurationOutput {
	s.MemberAccountLimitReached = &v
	return s
}

type DescribeProductsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeProducts
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s DescribeProductsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProductsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProductsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeProductsInput) SetMaxResults(v int64) *DescribeProductsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeProductsInput) SetNextToken(v string) *DescribeProductsInput {
	s.NextToken = &v
	return s
}

type DescribeProductsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`

	// A list of products, including details for each product.
	//
	// Products is a required field
	Products []*Product `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeProductsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProductsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeProductsOutput) SetNextToken(v string) *DescribeProductsOutput {
	s.NextToken = &v
	return s
}

// SetProducts sets the Products field's value.
func (s *DescribeProductsOutput) SetProducts(v []*Product) *DescribeProductsOutput {
	s.Products = v
	return s
}

type DescribeStandardsControlsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of security standard controls to return.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeStandardsControls
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The ARN of a resource that represents your subscription to a supported standard.
	// To get the subscription ARNs of the standards you have enabled, use the GetEnabledStandards
	// operation.
	//
	// StandardsSubscriptionArn is a required field
	StandardsSubscriptionArn *string `location:"uri" locationName:"StandardsSubscriptionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStandardsControlsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStandardsControlsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStandardsControlsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStandardsControlsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StandardsSubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsSubscriptionArn"))
	}
	if s.StandardsSubscriptionArn != nil && len(*s.StandardsSubscriptionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeStandardsControlsInput) SetMaxResults(v int64) *DescribeStandardsControlsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStandardsControlsInput) SetNextToken(v string) *DescribeStandardsControlsInput {
	s.NextToken = &v
	return s
}

// SetStandardsSubscriptionArn sets the StandardsSubscriptionArn field's value.
func (s *DescribeStandardsControlsInput) SetStandardsSubscriptionArn(v string) *DescribeStandardsControlsInput {
	s.StandardsSubscriptionArn = &v
	return s
}

type DescribeStandardsControlsOutput struct {
	_ struct{} `type:"structure"`

	// A list of security standards controls.
	Controls []*StandardsControl `type:"list"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeStandardsControlsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStandardsControlsOutput) GoString() string {
	return s.String()
}

// SetControls sets the Controls field's value.
func (s *DescribeStandardsControlsOutput) SetControls(v []*StandardsControl) *DescribeStandardsControlsOutput {
	s.Controls = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStandardsControlsOutput) SetNextToken(v string) *DescribeStandardsControlsOutput {
	s.NextToken = &v
	return s
}

type DescribeStandardsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of standards to return.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeStandards
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s DescribeStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStandardsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeStandardsInput) SetMaxResults(v int64) *DescribeStandardsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStandardsInput) SetNextToken(v string) *DescribeStandardsInput {
	s.NextToken = &v
	return s
}

type DescribeStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`

	// A list of available standards.
	Standards []*Standard `type:"list"`
}

// String returns the string representation
func (s DescribeStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStandardsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStandardsOutput) SetNextToken(v string) *DescribeStandardsOutput {
	s.NextToken = &v
	return s
}

// SetStandards sets the Standards field's value.
func (s *DescribeStandardsOutput) SetStandards(v []*Standard) *DescribeStandardsOutput {
	s.Standards = v
	return s
}

type DisableImportFindingsForProductInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the integrated product to disable the integration for.
	//
	// ProductSubscriptionArn is a required field
	ProductSubscriptionArn *string `location:"uri" locationName:"ProductSubscriptionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableImportFindingsForProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableImportFindingsForProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableImportFindingsForProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableImportFindingsForProductInput"}
	if s.ProductSubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductSubscriptionArn"))
	}
	if s.ProductSubscriptionArn != nil && len(*s.ProductSubscriptionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductSubscriptionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProductSubscriptionArn sets the ProductSubscriptionArn field's value.
func (s *DisableImportFindingsForProductInput) SetProductSubscriptionArn(v string) *DisableImportFindingsForProductInput {
	s.ProductSubscriptionArn = &v
	return s
}

type DisableImportFindingsForProductOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableImportFindingsForProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableImportFindingsForProductOutput) GoString() string {
	return s.String()
}

type DisableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The AWS account identifier of the Security Hub administrator account.
	//
	// AdminAccountId is a required field
	AdminAccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableOrganizationAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableOrganizationAdminAccountInput"}
	if s.AdminAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *DisableOrganizationAdminAccountInput) SetAdminAccountId(v string) *DisableOrganizationAdminAccountInput {
	s.AdminAccountId = &v
	return s
}

type DisableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

type DisableSecurityHubInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableSecurityHubInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSecurityHubInput) GoString() string {
	return s.String()
}

type DisableSecurityHubOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableSecurityHubOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSecurityHubOutput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountInput) GoString() string {
	return s.String()
}

type DisassociateFromMasterAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFromMasterAccountOutput) GoString() string {
	return s.String()
}

type DisassociateMembersInput struct {
	_ struct{} `type:"structure"`

	// The account IDs of the member accounts to disassociate from the master account.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DisassociateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DisassociateMembersInput) SetAccountIds(v []*string) *DisassociateMembersInput {
	s.AccountIds = v
	return s
}

type DisassociateMembersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembersOutput) GoString() string {
	return s.String()
}

type EnableImportFindingsForProductInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the product to enable the integration for.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableImportFindingsForProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableImportFindingsForProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableImportFindingsForProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableImportFindingsForProductInput"}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProductArn sets the ProductArn field's value.
func (s *EnableImportFindingsForProductInput) SetProductArn(v string) *EnableImportFindingsForProductInput {
	s.ProductArn = &v
	return s
}

type EnableImportFindingsForProductOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of your subscription to the product to enable integrations for.
	ProductSubscriptionArn *string `type:"string"`
}

// String returns the string representation
func (s EnableImportFindingsForProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableImportFindingsForProductOutput) GoString() string {
	return s.String()
}

// SetProductSubscriptionArn sets the ProductSubscriptionArn field's value.
func (s *EnableImportFindingsForProductOutput) SetProductSubscriptionArn(v string) *EnableImportFindingsForProductOutput {
	s.ProductSubscriptionArn = &v
	return s
}

type EnableOrganizationAdminAccountInput struct {
	_ struct{} `type:"structure"`

	// The AWS account identifier of the account to designate as the Security Hub
	// administrator account.
	//
	// AdminAccountId is a required field
	AdminAccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableOrganizationAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableOrganizationAdminAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableOrganizationAdminAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableOrganizationAdminAccountInput"}
	if s.AdminAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminAccountId sets the AdminAccountId field's value.
func (s *EnableOrganizationAdminAccountInput) SetAdminAccountId(v string) *EnableOrganizationAdminAccountInput {
	s.AdminAccountId = &v
	return s
}

type EnableOrganizationAdminAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableOrganizationAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableOrganizationAdminAccountOutput) GoString() string {
	return s.String()
}

type EnableSecurityHubInput struct {
	_ struct{} `type:"structure"`

	// Whether to enable the security standards that Security Hub has designated
	// as automatically enabled. If you do not provide a value for EnableDefaultStandards,
	// it is set to true. To not enable the automatically enabled standards, set
	// EnableDefaultStandards to false.
	EnableDefaultStandards *bool `type:"boolean"`

	// The tags to add to the hub resource when you enable Security Hub.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s EnableSecurityHubInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSecurityHubInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableSecurityHubInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableSecurityHubInput"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableDefaultStandards sets the EnableDefaultStandards field's value.
func (s *EnableSecurityHubInput) SetEnableDefaultStandards(v bool) *EnableSecurityHubInput {
	s.EnableDefaultStandards = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EnableSecurityHubInput) SetTags(v map[string]*string) *EnableSecurityHubInput {
	s.Tags = v
	return s
}

type EnableSecurityHubOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableSecurityHubOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSecurityHubOutput) GoString() string {
	return s.String()
}

type GetEnabledStandardsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the GetEnabledStandards
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `type:"string"`

	// The list of the standards subscription ARNs for the standards to retrieve.
	StandardsSubscriptionArns []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s GetEnabledStandardsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnabledStandardsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnabledStandardsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnabledStandardsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StandardsSubscriptionArns != nil && len(s.StandardsSubscriptionArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsSubscriptionArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEnabledStandardsInput) SetMaxResults(v int64) *GetEnabledStandardsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEnabledStandardsInput) SetNextToken(v string) *GetEnabledStandardsInput {
	s.NextToken = &v
	return s
}

// SetStandardsSubscriptionArns sets the StandardsSubscriptionArns field's value.
func (s *GetEnabledStandardsInput) SetStandardsSubscriptionArns(v []*string) *GetEnabledStandardsInput {
	s.StandardsSubscriptionArns = v
	return s
}

type GetEnabledStandardsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`

	// The list of StandardsSubscriptions objects that include information about
	// the enabled standards.
	StandardsSubscriptions []*StandardsSubscription `type:"list"`
}

// String returns the string representation
func (s GetEnabledStandardsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnabledStandardsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetEnabledStandardsOutput) SetNextToken(v string) *GetEnabledStandardsOutput {
	s.NextToken = &v
	return s
}

// SetStandardsSubscriptions sets the StandardsSubscriptions field's value.
func (s *GetEnabledStandardsOutput) SetStandardsSubscriptions(v []*StandardsSubscription) *GetEnabledStandardsOutput {
	s.StandardsSubscriptions = v
	return s
}

type GetFindingsInput struct {
	_ struct{} `type:"structure"`

	// The finding attributes used to define a condition to filter the returned
	// findings.
	//
	// You can filter by up to 10 finding attributes. For each attribute, you can
	// provide up to 20 filter values.
	//
	// Note that in the available filter fields, WorkflowState is deprecated. To
	// search for a finding based on its workflow status, use WorkflowStatus.
	Filters *AwsSecurityFindingFilters `type:"structure"`

	// The maximum number of findings to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the GetFindings
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `type:"string"`

	// The finding attributes used to sort the list of returned findings.
	SortCriteria []*SortCriterion `type:"list"`
}

// String returns the string representation
func (s GetFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *GetFindingsInput) SetFilters(v *AwsSecurityFindingFilters) *GetFindingsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetFindingsInput) SetMaxResults(v int64) *GetFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFindingsInput) SetNextToken(v string) *GetFindingsInput {
	s.NextToken = &v
	return s
}

// SetSortCriteria sets the SortCriteria field's value.
func (s *GetFindingsInput) SetSortCriteria(v []*SortCriterion) *GetFindingsInput {
	s.SortCriteria = v
	return s
}

type GetFindingsOutput struct {
	_ struct{} `type:"structure"`

	// The findings that matched the filters specified in the request.
	//
	// Findings is a required field
	Findings []*AwsSecurityFinding `type:"list" required:"true"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *GetFindingsOutput) SetFindings(v []*AwsSecurityFinding) *GetFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFindingsOutput) SetNextToken(v string) *GetFindingsOutput {
	s.NextToken = &v
	return s
}

type GetInsightResultsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight for which to return results.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInsightResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInsightResultsInput"}
	if s.InsightArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightArn"))
	}
	if s.InsightArn != nil && len(*s.InsightArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightArn sets the InsightArn field's value.
func (s *GetInsightResultsInput) SetInsightArn(v string) *GetInsightResultsInput {
	s.InsightArn = &v
	return s
}

type GetInsightResultsOutput struct {
	_ struct{} `type:"structure"`

	// The insight results returned by the operation.
	//
	// InsightResults is a required field
	InsightResults *InsightResults `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetInsightResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightResultsOutput) GoString() string {
	return s.String()
}

// SetInsightResults sets the InsightResults field's value.
func (s *GetInsightResultsOutput) SetInsightResults(v *InsightResults) *GetInsightResultsOutput {
	s.InsightResults = v
	return s
}

type GetInsightsInput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the insights to describe. If you do not provide any insight ARNs,
	// then GetInsights returns all of your custom insights. It does not return
	// any managed insights.
	InsightArns []*string `type:"list"`

	// The maximum number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the GetInsights
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightArns sets the InsightArns field's value.
func (s *GetInsightsInput) SetInsightArns(v []*string) *GetInsightsInput {
	s.InsightArns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetInsightsInput) SetMaxResults(v int64) *GetInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInsightsInput) SetNextToken(v string) *GetInsightsInput {
	s.NextToken = &v
	return s
}

type GetInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The insights returned by the operation.
	//
	// Insights is a required field
	Insights []*Insight `type:"list" required:"true"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInsightsOutput) GoString() string {
	return s.String()
}

// SetInsights sets the Insights field's value.
func (s *GetInsightsOutput) SetInsights(v []*Insight) *GetInsightsOutput {
	s.Insights = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInsightsOutput) SetNextToken(v string) *GetInsightsOutput {
	s.NextToken = &v
	return s
}

type GetInvitationsCountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetInvitationsCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountInput) GoString() string {
	return s.String()
}

type GetInvitationsCountOutput struct {
	_ struct{} `type:"structure"`

	// The number of all membership invitations sent to this Security Hub member
	// account, not including the currently accepted invitation.
	InvitationsCount *int64 `type:"integer"`
}

// String returns the string representation
func (s GetInvitationsCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvitationsCountOutput) GoString() string {
	return s.String()
}

// SetInvitationsCount sets the InvitationsCount field's value.
func (s *GetInvitationsCountOutput) SetInvitationsCount(v int64) *GetInvitationsCountOutput {
	s.InvitationsCount = &v
	return s
}

type GetMasterAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountInput) GoString() string {
	return s.String()
}

type GetMasterAccountOutput struct {
	_ struct{} `type:"structure"`

	// A list of details about the Security Hub master account for the current member
	// account.
	Master *Invitation `type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMasterAccountOutput) GoString() string {
	return s.String()
}

// SetMaster sets the Master field's value.
func (s *GetMasterAccountOutput) SetMaster(v *Invitation) *GetMasterAccountOutput {
	s.Master = v
	return s
}

type GetMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of account IDs for the Security Hub member accounts to return the
	// details for.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetMembersInput) SetAccountIds(v []*string) *GetMembersInput {
	s.AccountIds = v
	return s
}

type GetMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of details about the Security Hub member accounts.
	Members []*Member `type:"list"`

	// The list of AWS accounts that could not be processed. For each account, the
	// list includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s GetMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *GetMembersOutput) SetMembers(v []*Member) *GetMembersOutput {
	s.Members = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *GetMembersOutput) SetUnprocessedAccounts(v []*Result) *GetMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// The list of the findings that cannot be imported. For each finding, the list
// provides the error.
type ImportFindingsError struct {
	_ struct{} `type:"structure"`

	// The code of the error returned by the BatchImportFindings operation.
	//
	// ErrorCode is a required field
	ErrorCode *string `type:"string" required:"true"`

	// The message of the error returned by the BatchImportFindings operation.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The identifier of the finding that could not be updated.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportFindingsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportFindingsError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ImportFindingsError) SetErrorCode(v string) *ImportFindingsError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ImportFindingsError) SetErrorMessage(v string) *ImportFindingsError {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *ImportFindingsError) SetId(v string) *ImportFindingsError {
	s.Id = &v
	return s
}

// Contains information about a Security Hub insight.
type Insight struct {
	_ struct{} `type:"structure"`

	// One or more attributes used to filter the findings included in the insight.
	// The insight only includes findings that match the criteria defined in the
	// filters.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The grouping attribute for the insight's findings. Indicates how to group
	// the matching findings, and identifies the type of item that the insight applies
	// to. For example, if an insight is grouped by resource identifier, then the
	// insight produces a list of resource identifiers.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of a Security Hub insight.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The name of a Security Hub insight.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Insight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Insight) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *Insight) SetFilters(v *AwsSecurityFindingFilters) *Insight {
	s.Filters = v
	return s
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *Insight) SetGroupByAttribute(v string) *Insight {
	s.GroupByAttribute = &v
	return s
}

// SetInsightArn sets the InsightArn field's value.
func (s *Insight) SetInsightArn(v string) *Insight {
	s.InsightArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Insight) SetName(v string) *Insight {
	s.Name = &v
	return s
}

// The insight result values returned by the GetInsightResults operation.
type InsightResultValue struct {
	_ struct{} `type:"structure"`

	// The number of findings returned for each GroupByAttributeValue.
	//
	// Count is a required field
	Count *int64 `type:"integer" required:"true"`

	// The value of the attribute that the findings are grouped by for the insight
	// whose results are returned by the GetInsightResults operation.
	//
	// GroupByAttributeValue is a required field
	GroupByAttributeValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InsightResultValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightResultValue) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *InsightResultValue) SetCount(v int64) *InsightResultValue {
	s.Count = &v
	return s
}

// SetGroupByAttributeValue sets the GroupByAttributeValue field's value.
func (s *InsightResultValue) SetGroupByAttributeValue(v string) *InsightResultValue {
	s.GroupByAttributeValue = &v
	return s
}

// The insight results returned by the GetInsightResults operation.
type InsightResults struct {
	_ struct{} `type:"structure"`

	// The attribute that the findings are grouped by for the insight whose results
	// are returned by the GetInsightResults operation.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of the insight whose results are returned by the GetInsightResults
	// operation.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The list of insight result values returned by the GetInsightResults operation.
	//
	// ResultValues is a required field
	ResultValues []*InsightResultValue `type:"list" required:"true"`
}

// String returns the string representation
func (s InsightResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightResults) GoString() string {
	return s.String()
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *InsightResults) SetGroupByAttribute(v string) *InsightResults {
	s.GroupByAttribute = &v
	return s
}

// SetInsightArn sets the InsightArn field's value.
func (s *InsightResults) SetInsightArn(v string) *InsightResults {
	s.InsightArn = &v
	return s
}

// SetResultValues sets the ResultValues field's value.
func (s *InsightResults) SetResultValues(v []*InsightResultValue) *InsightResults {
	s.ResultValues = v
	return s
}

// Internal server error.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There is an issue with the account used to make the request. Either Security
// Hub is not enabled for the account, or the account does not have permission
// to perform this action.
type InvalidAccessException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidAccessException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidAccessException) GoString() string {
	return s.String()
}

func newErrorInvalidAccessException(v protocol.ResponseMetadata) error {
	return &InvalidAccessException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidAccessException) Code() string {
	return "InvalidAccessException"
}

// Message returns the exception's message.
func (s *InvalidAccessException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidAccessException) OrigErr() error {
	return nil
}

func (s *InvalidAccessException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidAccessException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidAccessException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because you supplied an invalid or out-of-range
// value for an input parameter.
type InvalidInputException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidInputException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidInputException) GoString() string {
	return s.String()
}

func newErrorInvalidInputException(v protocol.ResponseMetadata) error {
	return &InvalidInputException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputException) Code() string {
	return "InvalidInputException"
}

// Message returns the exception's message.
func (s *InvalidInputException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputException) OrigErr() error {
	return nil
}

func (s *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about an invitation.
type Invitation struct {
	_ struct{} `type:"structure"`

	// The account ID of the Security Hub master account that the invitation was
	// sent from.
	AccountId *string `type:"string"`

	// The ID of the invitation sent to the member account.
	InvitationId *string `type:"string"`

	// The timestamp of when the invitation was sent.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The current status of the association between the member and master accounts.
	MemberStatus *string `type:"string"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invitation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Invitation) SetAccountId(v string) *Invitation {
	s.AccountId = &v
	return s
}

// SetInvitationId sets the InvitationId field's value.
func (s *Invitation) SetInvitationId(v string) *Invitation {
	s.InvitationId = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Invitation) SetInvitedAt(v time.Time) *Invitation {
	s.InvitedAt = &v
	return s
}

// SetMemberStatus sets the MemberStatus field's value.
func (s *Invitation) SetMemberStatus(v string) *Invitation {
	s.MemberStatus = &v
	return s
}

type InviteMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of account IDs of the AWS accounts to invite to Security Hub as
	// members.
	//
	// AccountIds is a required field
	AccountIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s InviteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InviteMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *InviteMembersInput) SetAccountIds(v []*string) *InviteMembersInput {
	s.AccountIds = v
	return s
}

type InviteMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts that could not be processed. For each account, the
	// list includes the account ID and the email address.
	UnprocessedAccounts []*Result `type:"list"`
}

// String returns the string representation
func (s InviteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteMembersOutput) GoString() string {
	return s.String()
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *InviteMembersOutput) SetUnprocessedAccounts(v []*Result) *InviteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// The IP filter for querying findings.
type IpFilter struct {
	_ struct{} `type:"structure"`

	// A finding's CIDR value.
	Cidr *string `type:"string"`
}

// String returns the string representation
func (s IpFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFilter) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *IpFilter) SetCidr(v string) *IpFilter {
	s.Cidr = &v
	return s
}

// An IPV6 CIDR block association.
type Ipv6CidrBlockAssociation struct {
	_ struct{} `type:"structure"`

	// The association ID for the IPv6 CIDR block.
	AssociationId *string `type:"string"`

	// Information about the state of the CIDR block.
	CidrBlockState *string `type:"string"`

	// The IPv6 CIDR block.
	Ipv6CidrBlock *string `type:"string"`
}

// String returns the string representation
func (s Ipv6CidrBlockAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ipv6CidrBlockAssociation) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *Ipv6CidrBlockAssociation) SetAssociationId(v string) *Ipv6CidrBlockAssociation {
	s.AssociationId = &v
	return s
}

// SetCidrBlockState sets the CidrBlockState field's value.
func (s *Ipv6CidrBlockAssociation) SetCidrBlockState(v string) *Ipv6CidrBlockAssociation {
	s.CidrBlockState = &v
	return s
}

// SetIpv6CidrBlock sets the Ipv6CidrBlock field's value.
func (s *Ipv6CidrBlockAssociation) SetIpv6CidrBlock(v string) *Ipv6CidrBlockAssociation {
	s.Ipv6CidrBlock = &v
	return s
}

// A keyword filter for querying findings.
type KeywordFilter struct {
	_ struct{} `type:"structure"`

	// A value for the keyword.
	Value *string `type:"string"`
}

// String returns the string representation
func (s KeywordFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeywordFilter) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *KeywordFilter) SetValue(v string) *KeywordFilter {
	s.Value = &v
	return s
}

// The request was rejected because it attempted to create resources beyond
// the current AWS account or throttling limits. The error code describes the
// limit exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListEnabledProductsForImportInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the ListEnabledProductsForImport
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListEnabledProductsForImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnabledProductsForImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnabledProductsForImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnabledProductsForImportInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnabledProductsForImportInput) SetMaxResults(v int64) *ListEnabledProductsForImportInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnabledProductsForImportInput) SetNextToken(v string) *ListEnabledProductsForImportInput {
	s.NextToken = &v
	return s
}

type ListEnabledProductsForImportOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`

	// The list of ARNs for the resources that represent your subscriptions to products.
	ProductSubscriptions []*string `type:"list"`
}

// String returns the string representation
func (s ListEnabledProductsForImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnabledProductsForImportOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnabledProductsForImportOutput) SetNextToken(v string) *ListEnabledProductsForImportOutput {
	s.NextToken = &v
	return s
}

// SetProductSubscriptions sets the ProductSubscriptions field's value.
func (s *ListEnabledProductsForImportOutput) SetProductSubscriptions(v []*string) *ListEnabledProductsForImportOutput {
	s.ProductSubscriptions = v
	return s
}

type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the ListInvitations
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvitationsInput) SetMaxResults(v int64) *ListInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsInput) SetNextToken(v string) *ListInvitationsInput {
	s.NextToken = &v
	return s
}

type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the invitations returned by the operation.
	Invitations []*Invitation `type:"list"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsOutput) GoString() string {
	return s.String()
}

// SetInvitations sets the Invitations field's value.
func (s *ListInvitationsOutput) SetInvitations(v []*Invitation) *ListInvitationsOutput {
	s.Invitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsOutput) SetNextToken(v string) *ListInvitationsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the ListMembers
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Specifies which member accounts to include in the response based on their
	// relationship status with the master account. The default value is TRUE.
	//
	// If OnlyAssociated is set to TRUE, the response includes member accounts whose
	// relationship status with the master is set to ENABLED.
	//
	// If OnlyAssociated is set to FALSE, the response includes all existing member
	// accounts.
	OnlyAssociated *bool `location:"querystring" locationName:"OnlyAssociated" type:"boolean"`
}

// String returns the string representation
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

// SetOnlyAssociated sets the OnlyAssociated field's value.
func (s *ListMembersInput) SetOnlyAssociated(v bool) *ListMembersInput {
	s.OnlyAssociated = &v
	return s
}

type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// Member details returned by the operation.
	Members []*Member `type:"list"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListMembersOutput) SetMembers(v []*Member) *ListMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

type ListOrganizationAdminAccountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the ListOrganizationAdminAccounts
	// operation, set the value of this parameter to NULL. For subsequent calls
	// to the operation, to continue listing data, set the value of this parameter
	// to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListOrganizationAdminAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationAdminAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationAdminAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationAdminAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationAdminAccountsInput) SetMaxResults(v int64) *ListOrganizationAdminAccountsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationAdminAccountsInput) SetNextToken(v string) *ListOrganizationAdminAccountsInput {
	s.NextToken = &v
	return s
}

type ListOrganizationAdminAccountsOutput struct {
	_ struct{} `type:"structure"`

	// The list of Security Hub administrator accounts.
	AdminAccounts []*AdminAccount `type:"list"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListOrganizationAdminAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationAdminAccountsOutput) GoString() string {
	return s.String()
}

// SetAdminAccounts sets the AdminAccounts field's value.
func (s *ListOrganizationAdminAccountsOutput) SetAdminAccounts(v []*AdminAccount) *ListOrganizationAdminAccountsOutput {
	s.AdminAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationAdminAccountsOutput) SetNextToken(v string) *ListOrganizationAdminAccountsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to retrieve tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with a resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about the state of the load balancer.
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The state code. The initial state of the load balancer is provisioning.
	//
	// After the load balancer is fully set up and ready to route traffic, its state
	// is active.
	//
	// If the load balancer could not be set up, its state is failed.
	Code *string `type:"string"`

	// A description of the state.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerState) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *LoadBalancerState) SetCode(v string) *LoadBalancerState {
	s.Code = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *LoadBalancerState) SetReason(v string) *LoadBalancerState {
	s.Reason = &v
	return s
}

// A list of malware related to a finding.
type Malware struct {
	_ struct{} `type:"structure"`

	// The name of the malware that was observed.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The file system path of the malware that was observed.
	Path *string `type:"string"`

	// The state of the malware that was observed.
	State *string `type:"string" enum:"MalwareState"`

	// The type of the malware that was observed.
	Type *string `type:"string" enum:"MalwareType"`
}

// String returns the string representation
func (s Malware) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Malware) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Malware) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Malware"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Malware) SetName(v string) *Malware {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Malware) SetPath(v string) *Malware {
	s.Path = &v
	return s
}

// SetState sets the State field's value.
func (s *Malware) SetState(v string) *Malware {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Malware) SetType(v string) *Malware {
	s.Type = &v
	return s
}

// A map filter for querying findings. Each map filter provides the field to
// check, the value to look for, and the comparison operator.
type MapFilter struct {
	_ struct{} `type:"structure"`

	// The condition to apply to the key value when querying for findings with a
	// map filter.
	//
	// To search for values that exactly match the filter value, use EQUALS. For
	// example, for the ResourceTags field, the filter Department EQUALS Security
	// matches findings that have the value Security for the tag Department.
	//
	// To search for values other than the filter value, use NOT_EQUALS. For example,
	// for the ResourceTags field, the filter Department NOT_EQUALS Finance matches
	// findings that do not have the value Finance for the tag Department.
	//
	// EQUALS filters on the same field are joined by OR. A finding matches if it
	// matches any one of those filters.
	//
	// NOT_EQUALS filters on the same field are joined by AND. A finding matches
	// only if it matches all of those filters.
	//
	// You cannot have both an EQUALS filter and a NOT_EQUALS filter on the same
	// field.
	Comparison *string `type:"string" enum:"MapFilterComparison"`

	// The key of the map filter. For example, for ResourceTags, Key identifies
	// the name of the tag. For UserDefinedFields, Key is the name of the field.
	Key *string `type:"string"`

	// The value for the key in the map filter. Filter values are case sensitive.
	// For example, one of the values for a tag called Department might be Security.
	// If you provide security as the filter value, then there is no match.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MapFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MapFilter) GoString() string {
	return s.String()
}

// SetComparison sets the Comparison field's value.
func (s *MapFilter) SetComparison(v string) *MapFilter {
	s.Comparison = &v
	return s
}

// SetKey sets the Key field's value.
func (s *MapFilter) SetKey(v string) *MapFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MapFilter) SetValue(v string) *MapFilter {
	s.Value = &v
	return s
}

// The details about a member account.
type Member struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the member account.
	AccountId *string `type:"string"`

	// The email address of the member account.
	Email *string `type:"string"`

	// A timestamp for the date and time when the invitation was sent to the member
	// account.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The AWS account ID of the Security Hub master account associated with this
	// member account.
	MasterId *string `type:"string"`

	// The status of the relationship between the member account and its master
	// account.
	//
	// The status can have one of the following values:
	//
	//    * CREATED - Indicates that the master account added the member account,
	//    but has not yet invited the member account.
	//
	//    * INVITED - Indicates that the master account invited the member account.
	//    The member account has not yet responded to the invitation.
	//
	//    * ENABLED - Indicates that the member account is currently active. For
	//    manually invited member accounts, indicates that the member account accepted
	//    the invitation.
	//
	//    * REMOVED - Indicates that the master account disassociated the member
	//    account.
	//
	//    * RESIGNED - Indicates that the member account disassociated themselves
	//    from the master account.
	//
	//    * DELETED - Indicates that the master account deleted the member account.
	MemberStatus *string `type:"string"`

	// The timestamp for the date and time when the member account was updated.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Member) SetAccountId(v string) *Member {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Member) SetEmail(v string) *Member {
	s.Email = &v
	return s
}

// SetInvitedAt sets the InvitedAt field's value.
func (s *Member) SetInvitedAt(v time.Time) *Member {
	s.InvitedAt = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *Member) SetMasterId(v string) *Member {
	s.MasterId = &v
	return s
}

// SetMemberStatus sets the MemberStatus field's value.
func (s *Member) SetMemberStatus(v string) *Member {
	s.MemberStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Member) SetUpdatedAt(v time.Time) *Member {
	s.UpdatedAt = &v
	return s
}

// The details of network-related information about a finding.
type Network struct {
	_ struct{} `type:"structure"`

	// The destination domain of network-related information about a finding.
	DestinationDomain *string `type:"string"`

	// The destination IPv4 address of network-related information about a finding.
	DestinationIpV4 *string `type:"string"`

	// The destination IPv6 address of network-related information about a finding.
	DestinationIpV6 *string `type:"string"`

	// The destination port of network-related information about a finding.
	DestinationPort *int64 `type:"integer"`

	// The direction of network traffic associated with a finding.
	Direction *string `type:"string" enum:"NetworkDirection"`

	// The range of open ports that is present on the network.
	OpenPortRange *PortRange `type:"structure"`

	// The protocol of network-related information about a finding.
	Protocol *string `type:"string"`

	// The source domain of network-related information about a finding.
	SourceDomain *string `type:"string"`

	// The source IPv4 address of network-related information about a finding.
	SourceIpV4 *string `type:"string"`

	// The source IPv6 address of network-related information about a finding.
	SourceIpV6 *string `type:"string"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	SourceMac *string `type:"string"`

	// The source port of network-related information about a finding.
	SourcePort *int64 `type:"integer"`
}

// String returns the string representation
func (s Network) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Network) GoString() string {
	return s.String()
}

// SetDestinationDomain sets the DestinationDomain field's value.
func (s *Network) SetDestinationDomain(v string) *Network {
	s.DestinationDomain = &v
	return s
}

// SetDestinationIpV4 sets the DestinationIpV4 field's value.
func (s *Network) SetDestinationIpV4(v string) *Network {
	s.DestinationIpV4 = &v
	return s
}

// SetDestinationIpV6 sets the DestinationIpV6 field's value.
func (s *Network) SetDestinationIpV6(v string) *Network {
	s.DestinationIpV6 = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *Network) SetDestinationPort(v int64) *Network {
	s.DestinationPort = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *Network) SetDirection(v string) *Network {
	s.Direction = &v
	return s
}

// SetOpenPortRange sets the OpenPortRange field's value.
func (s *Network) SetOpenPortRange(v *PortRange) *Network {
	s.OpenPortRange = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Network) SetProtocol(v string) *Network {
	s.Protocol = &v
	return s
}

// SetSourceDomain sets the SourceDomain field's value.
func (s *Network) SetSourceDomain(v string) *Network {
	s.SourceDomain = &v
	return s
}

// SetSourceIpV4 sets the SourceIpV4 field's value.
func (s *Network) SetSourceIpV4(v string) *Network {
	s.SourceIpV4 = &v
	return s
}

// SetSourceIpV6 sets the SourceIpV6 field's value.
func (s *Network) SetSourceIpV6(v string) *Network {
	s.SourceIpV6 = &v
	return s
}

// SetSourceMac sets the SourceMac field's value.
func (s *Network) SetSourceMac(v string) *Network {
	s.SourceMac = &v
	return s
}

// SetSourcePort sets the SourcePort field's value.
func (s *Network) SetSourcePort(v int64) *Network {
	s.SourcePort = &v
	return s
}

// Details about a network path component that occurs before or after the current
// component.
type NetworkHeader struct {
	_ struct{} `type:"structure"`

	// Information about the destination of the component.
	Destination *NetworkPathComponentDetails `type:"structure"`

	// The protocol used for the component.
	Protocol *string `type:"string"`

	// Information about the origin of the component.
	Source *NetworkPathComponentDetails `type:"structure"`
}

// String returns the string representation
func (s NetworkHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkHeader) GoString() string {
	return s.String()
}

// SetDestination sets the Destination field's value.
func (s *NetworkHeader) SetDestination(v *NetworkPathComponentDetails) *NetworkHeader {
	s.Destination = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *NetworkHeader) SetProtocol(v string) *NetworkHeader {
	s.Protocol = &v
	return s
}

// SetSource sets the Source field's value.
func (s *NetworkHeader) SetSource(v *NetworkPathComponentDetails) *NetworkHeader {
	s.Source = v
	return s
}

// Information about a network path component.
type NetworkPathComponent struct {
	_ struct{} `type:"structure"`

	// The identifier of a component in the network path.
	ComponentId *string `type:"string"`

	// The type of component.
	ComponentType *string `type:"string"`

	// Information about the component that comes after the current component in
	// the network path.
	Egress *NetworkHeader `type:"structure"`

	// Information about the component that comes before the current node in the
	// network path.
	Ingress *NetworkHeader `type:"structure"`
}

// String returns the string representation
func (s NetworkPathComponent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkPathComponent) GoString() string {
	return s.String()
}

// SetComponentId sets the ComponentId field's value.
func (s *NetworkPathComponent) SetComponentId(v string) *NetworkPathComponent {
	s.ComponentId = &v
	return s
}

// SetComponentType sets the ComponentType field's value.
func (s *NetworkPathComponent) SetComponentType(v string) *NetworkPathComponent {
	s.ComponentType = &v
	return s
}

// SetEgress sets the Egress field's value.
func (s *NetworkPathComponent) SetEgress(v *NetworkHeader) *NetworkPathComponent {
	s.Egress = v
	return s
}

// SetIngress sets the Ingress field's value.
func (s *NetworkPathComponent) SetIngress(v *NetworkHeader) *NetworkPathComponent {
	s.Ingress = v
	return s
}

// Information about the destination of the next component in the network path.
type NetworkPathComponentDetails struct {
	_ struct{} `type:"structure"`

	// The IP addresses of the destination.
	Address []*string `type:"list"`

	// A list of port ranges for the destination.
	PortRanges []*PortRange `type:"list"`
}

// String returns the string representation
func (s NetworkPathComponentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkPathComponentDetails) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *NetworkPathComponentDetails) SetAddress(v []*string) *NetworkPathComponentDetails {
	s.Address = v
	return s
}

// SetPortRanges sets the PortRanges field's value.
func (s *NetworkPathComponentDetails) SetPortRanges(v []*PortRange) *NetworkPathComponentDetails {
	s.PortRanges = v
	return s
}

// A user-defined note added to a finding.
type Note struct {
	_ struct{} `type:"structure"`

	// The text of a note.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The timestamp of when the note was updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// The principal that created a note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Note) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Note) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Note) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Note"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.UpdatedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedAt"))
	}
	if s.UpdatedBy == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *Note) SetText(v string) *Note {
	s.Text = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Note) SetUpdatedAt(v string) *Note {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *Note) SetUpdatedBy(v string) *Note {
	s.UpdatedBy = &v
	return s
}

// The updated note.
type NoteUpdate struct {
	_ struct{} `type:"structure"`

	// The updated note text.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The principal that updated the note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NoteUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoteUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NoteUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NoteUpdate"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.UpdatedBy == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *NoteUpdate) SetText(v string) *NoteUpdate {
	s.Text = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *NoteUpdate) SetUpdatedBy(v string) *NoteUpdate {
	s.UpdatedBy = &v
	return s
}

// A number filter for querying findings.
type NumberFilter struct {
	_ struct{} `type:"structure"`

	// The equal-to condition to be applied to a single field when querying for
	// findings.
	Eq *float64 `type:"double"`

	// The greater-than-equal condition to be applied to a single field when querying
	// for findings.
	Gte *float64 `type:"double"`

	// The less-than-equal condition to be applied to a single field when querying
	// for findings.
	Lte *float64 `type:"double"`
}

// String returns the string representation
func (s NumberFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberFilter) GoString() string {
	return s.String()
}

// SetEq sets the Eq field's value.
func (s *NumberFilter) SetEq(v float64) *NumberFilter {
	s.Eq = &v
	return s
}

// SetGte sets the Gte field's value.
func (s *NumberFilter) SetGte(v float64) *NumberFilter {
	s.Gte = &v
	return s
}

// SetLte sets the Lte field's value.
func (s *NumberFilter) SetLte(v float64) *NumberFilter {
	s.Lte = &v
	return s
}

// Provides an overview of the patch compliance status for an instance against
// a selected compliance standard.
type PatchSummary struct {
	_ struct{} `type:"structure"`

	// The number of patches from the compliance standard that failed to install.
	FailedCount *int64 `type:"integer"`

	// The identifier of the compliance standard that was used to determine the
	// patch compliance status.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The number of patches from the compliance standard that were installed successfully.
	InstalledCount *int64 `type:"integer"`

	// The number of installed patches that are not part of the compliance standard.
	InstalledOtherCount *int64 `type:"integer"`

	// The number of patches that were applied, but that require the instance to
	// be rebooted in order to be marked as installed.
	InstalledPendingReboot *int64 `type:"integer"`

	// The number of patches that are installed but are also on a list of patches
	// that the customer rejected.
	InstalledRejectedCount *int64 `type:"integer"`

	// The number of patches that are part of the compliance standard but are not
	// installed. The count includes patches that failed to install.
	MissingCount *int64 `type:"integer"`

	// The type of patch operation performed. For Patch Manager, the values are
	// SCAN and INSTALL.
	Operation *string `type:"string"`

	// Indicates when the operation completed.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	OperationEndTime *string `type:"string"`

	// Indicates when the operation started.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	OperationStartTime *string `type:"string"`

	// The reboot option specified for the instance.
	RebootOption *string `type:"string"`
}

// String returns the string representation
func (s PatchSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PatchSummary) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PatchSummary) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PatchSummary"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailedCount sets the FailedCount field's value.
func (s *PatchSummary) SetFailedCount(v int64) *PatchSummary {
	s.FailedCount = &v
	return s
}

// SetId sets the Id field's value.
func (s *PatchSummary) SetId(v string) *PatchSummary {
	s.Id = &v
	return s
}

// SetInstalledCount sets the InstalledCount field's value.
func (s *PatchSummary) SetInstalledCount(v int64) *PatchSummary {
	s.InstalledCount = &v
	return s
}

// SetInstalledOtherCount sets the InstalledOtherCount field's value.
func (s *PatchSummary) SetInstalledOtherCount(v int64) *PatchSummary {
	s.InstalledOtherCount = &v
	return s
}

// SetInstalledPendingReboot sets the InstalledPendingReboot field's value.
func (s *PatchSummary) SetInstalledPendingReboot(v int64) *PatchSummary {
	s.InstalledPendingReboot = &v
	return s
}

// SetInstalledRejectedCount sets the InstalledRejectedCount field's value.
func (s *PatchSummary) SetInstalledRejectedCount(v int64) *PatchSummary {
	s.InstalledRejectedCount = &v
	return s
}

// SetMissingCount sets the MissingCount field's value.
func (s *PatchSummary) SetMissingCount(v int64) *PatchSummary {
	s.MissingCount = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *PatchSummary) SetOperation(v string) *PatchSummary {
	s.Operation = &v
	return s
}

// SetOperationEndTime sets the OperationEndTime field's value.
func (s *PatchSummary) SetOperationEndTime(v string) *PatchSummary {
	s.OperationEndTime = &v
	return s
}

// SetOperationStartTime sets the OperationStartTime field's value.
func (s *PatchSummary) SetOperationStartTime(v string) *PatchSummary {
	s.OperationStartTime = &v
	return s
}

// SetRebootOption sets the RebootOption field's value.
func (s *PatchSummary) SetRebootOption(v string) *PatchSummary {
	s.RebootOption = &v
	return s
}

// A range of ports.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The first port in the port range.
	Begin *int64 `type:"integer"`

	// The last port in the port range.
	End *int64 `type:"integer"`
}

// String returns the string representation
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortRange) GoString() string {
	return s.String()
}

// SetBegin sets the Begin field's value.
func (s *PortRange) SetBegin(v int64) *PortRange {
	s.Begin = &v
	return s
}

// SetEnd sets the End field's value.
func (s *PortRange) SetEnd(v int64) *PortRange {
	s.End = &v
	return s
}

// The details of process-related information about a finding.
type ProcessDetails struct {
	_ struct{} `type:"structure"`

	// Indicates when the process was launched.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LaunchedAt *string `type:"string"`

	// The name of the process.
	Name *string `type:"string"`

	// The parent process ID.
	ParentPid *int64 `type:"integer"`

	// The path to the process executable.
	Path *string `type:"string"`

	// The process ID.
	Pid *int64 `type:"integer"`

	// Indicates when the process was terminated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	TerminatedAt *string `type:"string"`
}

// String returns the string representation
func (s ProcessDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProcessDetails) GoString() string {
	return s.String()
}

// SetLaunchedAt sets the LaunchedAt field's value.
func (s *ProcessDetails) SetLaunchedAt(v string) *ProcessDetails {
	s.LaunchedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProcessDetails) SetName(v string) *ProcessDetails {
	s.Name = &v
	return s
}

// SetParentPid sets the ParentPid field's value.
func (s *ProcessDetails) SetParentPid(v int64) *ProcessDetails {
	s.ParentPid = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ProcessDetails) SetPath(v string) *ProcessDetails {
	s.Path = &v
	return s
}

// SetPid sets the Pid field's value.
func (s *ProcessDetails) SetPid(v int64) *ProcessDetails {
	s.Pid = &v
	return s
}

// SetTerminatedAt sets the TerminatedAt field's value.
func (s *ProcessDetails) SetTerminatedAt(v string) *ProcessDetails {
	s.TerminatedAt = &v
	return s
}

// Contains details about a product.
type Product struct {
	_ struct{} `type:"structure"`

	// The URL used to activate the product.
	ActivationUrl *string `type:"string"`

	// The categories assigned to the product.
	Categories []*string `type:"list"`

	// The name of the company that provides the product.
	CompanyName *string `type:"string"`

	// A description of the product.
	Description *string `type:"string"`

	// The types of integration that the product supports. Available values are
	// the following.
	//
	//    * SEND_FINDINGS_TO_SECURITY_HUB - Indicates that the integration sends
	//    findings to Security Hub.
	//
	//    * RECEIVE_FINDINGS_FROM_SECURITY_HUB - Indicates that the integration
	//    receives findings from Security Hub.
	IntegrationTypes []*string `type:"list"`

	// The URL for the page that contains more information about the product.
	MarketplaceUrl *string `type:"string"`

	// The ARN assigned to the product.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`

	// The name of the product.
	ProductName *string `type:"string"`

	// The resource policy associated with the product.
	ProductSubscriptionResourcePolicy *string `type:"string"`
}

// String returns the string representation
func (s Product) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Product) GoString() string {
	return s.String()
}

// SetActivationUrl sets the ActivationUrl field's value.
func (s *Product) SetActivationUrl(v string) *Product {
	s.ActivationUrl = &v
	return s
}

// SetCategories sets the Categories field's value.
func (s *Product) SetCategories(v []*string) *Product {
	s.Categories = v
	return s
}

// SetCompanyName sets the CompanyName field's value.
func (s *Product) SetCompanyName(v string) *Product {
	s.CompanyName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Product) SetDescription(v string) *Product {
	s.Description = &v
	return s
}

// SetIntegrationTypes sets the IntegrationTypes field's value.
func (s *Product) SetIntegrationTypes(v []*string) *Product {
	s.IntegrationTypes = v
	return s
}

// SetMarketplaceUrl sets the MarketplaceUrl field's value.
func (s *Product) SetMarketplaceUrl(v string) *Product {
	s.MarketplaceUrl = &v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *Product) SetProductArn(v string) *Product {
	s.ProductArn = &v
	return s
}

// SetProductName sets the ProductName field's value.
func (s *Product) SetProductName(v string) *Product {
	s.ProductName = &v
	return s
}

// SetProductSubscriptionResourcePolicy sets the ProductSubscriptionResourcePolicy field's value.
func (s *Product) SetProductSubscriptionResourcePolicy(v string) *Product {
	s.ProductSubscriptionResourcePolicy = &v
	return s
}

// A recommendation on how to remediate the issue identified in a finding.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// Describes the recommended steps to take to remediate an issue identified
	// in a finding.
	Text *string `type:"string"`

	// A URL to a page or site that contains information about how to remediate
	// a finding.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Recommendation) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *Recommendation) SetText(v string) *Recommendation {
	s.Text = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Recommendation) SetUrl(v string) *Recommendation {
	s.Url = &v
	return s
}

// Details about a related finding.
type RelatedFinding struct {
	_ struct{} `type:"structure"`

	// The product-generated identifier for a related finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The ARN of the product that generated a related finding.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RelatedFinding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelatedFinding) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedFinding) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RelatedFinding"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ProductArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RelatedFinding) SetId(v string) *RelatedFinding {
	s.Id = &v
	return s
}

// SetProductArn sets the ProductArn field's value.
func (s *RelatedFinding) SetProductArn(v string) *RelatedFinding {
	s.ProductArn = &v
	return s
}

// Details about the remediation steps for a finding.
type Remediation struct {
	_ struct{} `type:"structure"`

	// A recommendation on the steps to take to remediate the issue identified by
	// a finding.
	Recommendation *Recommendation `type:"structure"`
}

// String returns the string representation
func (s Remediation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Remediation) GoString() string {
	return s.String()
}

// SetRecommendation sets the Recommendation field's value.
func (s *Remediation) SetRecommendation(v *Recommendation) *Remediation {
	s.Recommendation = v
	return s
}

// A resource related to a finding.
type Resource struct {
	_ struct{} `type:"structure"`

	// Additional details about the resource related to a finding.
	Details *ResourceDetails `type:"structure"`

	// The canonical identifier for the given resource type.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The canonical AWS partition name that the Region is assigned to.
	Partition *string `type:"string" enum:"Partition"`

	// The canonical AWS external Region name where this resource is located.
	Region *string `type:"string"`

	ResourceRole *string `type:"string"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	Tags map[string]*string `type:"map"`

	// The type of the resource that details are provided for. If possible, set
	// Type to one of the supported resource types. For example, if the resource
	// is an EC2 instance, then set Type to AwsEc2Instance.
	//
	// If the resource does not match any of the provided types, then set Type to
	// Other.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Resource"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Details != nil {
		if err := s.Details.Validate(); err != nil {
			invalidParams.AddNested("Details", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *Resource) SetDetails(v *ResourceDetails) *Resource {
	s.Details = v
	return s
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetPartition sets the Partition field's value.
func (s *Resource) SetPartition(v string) *Resource {
	s.Partition = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Resource) SetRegion(v string) *Resource {
	s.Region = &v
	return s
}

// SetResourceRole sets the ResourceRole field's value.
func (s *Resource) SetResourceRole(v string) *Resource {
	s.ResourceRole = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Resource) SetTags(v map[string]*string) *Resource {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

// The resource specified in the request conflicts with an existing resource.
type ResourceConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConflictException) GoString() string {
	return s.String()
}

func newErrorResourceConflictException(v protocol.ResponseMetadata) error {
	return &ResourceConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceConflictException) Code() string {
	return "ResourceConflictException"
}

// Message returns the exception's message.
func (s *ResourceConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceConflictException) OrigErr() error {
	return nil
}

func (s *ResourceConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Additional details about a resource related to a finding.
//
// To provide the details, use the object that corresponds to the resource type.
// For example, if the resource type is AwsEc2Instance, then you use the AwsEc2Instance
// object to provide the details.
//
// If the type-specific object does not contain all of the fields you want to
// populate, then you use the Other object to populate those additional fields.
//
// You also use the Other object to populate the details when the selected type
// does not have a corresponding object.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// contains information about a REST API in version 1 of Amazon API Gateway.
	AwsApiGatewayRestApi *AwsApiGatewayRestApiDetails `type:"structure"`

	// Provides information about a version 1 Amazon API Gateway stage.
	AwsApiGatewayStage *AwsApiGatewayStageDetails `type:"structure"`

	// Contains information about a version 2 API in Amazon API Gateway.
	AwsApiGatewayV2Api *AwsApiGatewayV2ApiDetails `type:"structure"`

	// Contains information about a version 2 stage for Amazon API Gateway.
	AwsApiGatewayV2Stage *AwsApiGatewayV2StageDetails `type:"structure"`

	// Details for an autoscaling group.
	AwsAutoScalingAutoScalingGroup *AwsAutoScalingAutoScalingGroupDetails `type:"structure"`

	// Provides details about an AWS Certificate Manager certificate.
	AwsCertificateManagerCertificate *AwsCertificateManagerCertificateDetails `type:"structure"`

	// Details about a CloudFront distribution.
	AwsCloudFrontDistribution *AwsCloudFrontDistributionDetails `type:"structure"`

	// Provides details about a CloudTrail trail.
	AwsCloudTrailTrail *AwsCloudTrailTrailDetails `type:"structure"`

	// Details for an AWS CodeBuild project.
	AwsCodeBuildProject *AwsCodeBuildProjectDetails `type:"structure"`

	// Details about a DynamoDB table.
	AwsDynamoDbTable *AwsDynamoDbTableDetails `type:"structure"`

	// Details about an Elastic IP address.
	AwsEc2Eip *AwsEc2EipDetails `type:"structure"`

	// Details about an Amazon EC2 instance related to a finding.
	AwsEc2Instance *AwsEc2InstanceDetails `type:"structure"`

	// Details for an Amazon EC2 network interface.
	AwsEc2NetworkInterface *AwsEc2NetworkInterfaceDetails `type:"structure"`

	// Details for an EC2 security group.
	AwsEc2SecurityGroup *AwsEc2SecurityGroupDetails `type:"structure"`

	// Details for an EC2 volume.
	AwsEc2Volume *AwsEc2VolumeDetails `type:"structure"`

	// Details for an EC2 VPC.
	AwsEc2Vpc *AwsEc2VpcDetails `type:"structure"`

	// Details for an Elasticsearch domain.
	AwsElasticsearchDomain *AwsElasticsearchDomainDetails `type:"structure"`

	// Contains details about a Classic Load Balancer.
	AwsElbLoadBalancer *AwsElbLoadBalancerDetails `type:"structure"`

	// Details about a load balancer.
	AwsElbv2LoadBalancer *AwsElbv2LoadBalancerDetails `type:"structure"`

	// Details about an IAM access key related to a finding.
	AwsIamAccessKey *AwsIamAccessKeyDetails `type:"structure"`

	// Contains details about an IAM group.
	AwsIamGroup *AwsIamGroupDetails `type:"structure"`

	// Details about an IAM permissions policy.
	AwsIamPolicy *AwsIamPolicyDetails `type:"structure"`

	// Details about an IAM role.
	AwsIamRole *AwsIamRoleDetails `type:"structure"`

	// Details about an IAM user.
	AwsIamUser *AwsIamUserDetails `type:"structure"`

	// Details about a KMS key.
	AwsKmsKey *AwsKmsKeyDetails `type:"structure"`

	// Details about a Lambda function.
	AwsLambdaFunction *AwsLambdaFunctionDetails `type:"structure"`

	// Details for a Lambda layer version.
	AwsLambdaLayerVersion *AwsLambdaLayerVersionDetails `type:"structure"`

	// Details about an Amazon RDS database cluster.
	AwsRdsDbCluster *AwsRdsDbClusterDetails `type:"structure"`

	// Details about an Amazon RDS database cluster snapshot.
	AwsRdsDbClusterSnapshot *AwsRdsDbClusterSnapshotDetails `type:"structure"`

	// Details about an Amazon RDS database instance.
	AwsRdsDbInstance *AwsRdsDbInstanceDetails `type:"structure"`

	// Details about an Amazon RDS database snapshot.
	AwsRdsDbSnapshot *AwsRdsDbSnapshotDetails `type:"structure"`

	// Details about an Amazon Redshift cluster.
	AwsRedshiftCluster *AwsRedshiftClusterDetails `type:"structure"`

	// Details about an Amazon S3 bucket related to a finding.
	AwsS3Bucket *AwsS3BucketDetails `type:"structure"`

	// Details about an Amazon S3 object related to a finding.
	AwsS3Object *AwsS3ObjectDetails `type:"structure"`

	// Details about a Secrets Manager secret.
	AwsSecretsManagerSecret *AwsSecretsManagerSecretDetails `type:"structure"`

	// Details about an SNS topic.
	AwsSnsTopic *AwsSnsTopicDetails `type:"structure"`

	// Details about an SQS queue.
	AwsSqsQueue *AwsSqsQueueDetails `type:"structure"`

	// Details for a WAF WebACL.
	AwsWafWebAcl *AwsWafWebAclDetails `type:"structure"`

	// Details about a container resource related to a finding.
	Container *ContainerDetails `type:"structure"`

	// Details about a resource that are not available in a type-specific details
	// object. Use the Other object in the following cases.
	//
	//    * The type-specific object does not contain all of the fields that you
	//    want to populate. In this case, first use the type-specific object to
	//    populate those fields. Use the Other object to populate the fields that
	//    are missing from the type-specific object.
	//
	//    * The resource type does not have a corresponding object. This includes
	//    resources for which the type is Other.
	Other map[string]*string `type:"map"`
}

// String returns the string representation
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceDetails"}
	if s.AwsIamRole != nil {
		if err := s.AwsIamRole.Validate(); err != nil {
			invalidParams.AddNested("AwsIamRole", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsApiGatewayRestApi sets the AwsApiGatewayRestApi field's value.
func (s *ResourceDetails) SetAwsApiGatewayRestApi(v *AwsApiGatewayRestApiDetails) *ResourceDetails {
	s.AwsApiGatewayRestApi = v
	return s
}

// SetAwsApiGatewayStage sets the AwsApiGatewayStage field's value.
func (s *ResourceDetails) SetAwsApiGatewayStage(v *AwsApiGatewayStageDetails) *ResourceDetails {
	s.AwsApiGatewayStage = v
	return s
}

// SetAwsApiGatewayV2Api sets the AwsApiGatewayV2Api field's value.
func (s *ResourceDetails) SetAwsApiGatewayV2Api(v *AwsApiGatewayV2ApiDetails) *ResourceDetails {
	s.AwsApiGatewayV2Api = v
	return s
}

// SetAwsApiGatewayV2Stage sets the AwsApiGatewayV2Stage field's value.
func (s *ResourceDetails) SetAwsApiGatewayV2Stage(v *AwsApiGatewayV2StageDetails) *ResourceDetails {
	s.AwsApiGatewayV2Stage = v
	return s
}

// SetAwsAutoScalingAutoScalingGroup sets the AwsAutoScalingAutoScalingGroup field's value.
func (s *ResourceDetails) SetAwsAutoScalingAutoScalingGroup(v *AwsAutoScalingAutoScalingGroupDetails) *ResourceDetails {
	s.AwsAutoScalingAutoScalingGroup = v
	return s
}

// SetAwsCertificateManagerCertificate sets the AwsCertificateManagerCertificate field's value.
func (s *ResourceDetails) SetAwsCertificateManagerCertificate(v *AwsCertificateManagerCertificateDetails) *ResourceDetails {
	s.AwsCertificateManagerCertificate = v
	return s
}

// SetAwsCloudFrontDistribution sets the AwsCloudFrontDistribution field's value.
func (s *ResourceDetails) SetAwsCloudFrontDistribution(v *AwsCloudFrontDistributionDetails) *ResourceDetails {
	s.AwsCloudFrontDistribution = v
	return s
}

// SetAwsCloudTrailTrail sets the AwsCloudTrailTrail field's value.
func (s *ResourceDetails) SetAwsCloudTrailTrail(v *AwsCloudTrailTrailDetails) *ResourceDetails {
	s.AwsCloudTrailTrail = v
	return s
}

// SetAwsCodeBuildProject sets the AwsCodeBuildProject field's value.
func (s *ResourceDetails) SetAwsCodeBuildProject(v *AwsCodeBuildProjectDetails) *ResourceDetails {
	s.AwsCodeBuildProject = v
	return s
}

// SetAwsDynamoDbTable sets the AwsDynamoDbTable field's value.
func (s *ResourceDetails) SetAwsDynamoDbTable(v *AwsDynamoDbTableDetails) *ResourceDetails {
	s.AwsDynamoDbTable = v
	return s
}

// SetAwsEc2Eip sets the AwsEc2Eip field's value.
func (s *ResourceDetails) SetAwsEc2Eip(v *AwsEc2EipDetails) *ResourceDetails {
	s.AwsEc2Eip = v
	return s
}

// SetAwsEc2Instance sets the AwsEc2Instance field's value.
func (s *ResourceDetails) SetAwsEc2Instance(v *AwsEc2InstanceDetails) *ResourceDetails {
	s.AwsEc2Instance = v
	return s
}

// SetAwsEc2NetworkInterface sets the AwsEc2NetworkInterface field's value.
func (s *ResourceDetails) SetAwsEc2NetworkInterface(v *AwsEc2NetworkInterfaceDetails) *ResourceDetails {
	s.AwsEc2NetworkInterface = v
	return s
}

// SetAwsEc2SecurityGroup sets the AwsEc2SecurityGroup field's value.
func (s *ResourceDetails) SetAwsEc2SecurityGroup(v *AwsEc2SecurityGroupDetails) *ResourceDetails {
	s.AwsEc2SecurityGroup = v
	return s
}

// SetAwsEc2Volume sets the AwsEc2Volume field's value.
func (s *ResourceDetails) SetAwsEc2Volume(v *AwsEc2VolumeDetails) *ResourceDetails {
	s.AwsEc2Volume = v
	return s
}

// SetAwsEc2Vpc sets the AwsEc2Vpc field's value.
func (s *ResourceDetails) SetAwsEc2Vpc(v *AwsEc2VpcDetails) *ResourceDetails {
	s.AwsEc2Vpc = v
	return s
}

// SetAwsElasticsearchDomain sets the AwsElasticsearchDomain field's value.
func (s *ResourceDetails) SetAwsElasticsearchDomain(v *AwsElasticsearchDomainDetails) *ResourceDetails {
	s.AwsElasticsearchDomain = v
	return s
}

// SetAwsElbLoadBalancer sets the AwsElbLoadBalancer field's value.
func (s *ResourceDetails) SetAwsElbLoadBalancer(v *AwsElbLoadBalancerDetails) *ResourceDetails {
	s.AwsElbLoadBalancer = v
	return s
}

// SetAwsElbv2LoadBalancer sets the AwsElbv2LoadBalancer field's value.
func (s *ResourceDetails) SetAwsElbv2LoadBalancer(v *AwsElbv2LoadBalancerDetails) *ResourceDetails {
	s.AwsElbv2LoadBalancer = v
	return s
}

// SetAwsIamAccessKey sets the AwsIamAccessKey field's value.
func (s *ResourceDetails) SetAwsIamAccessKey(v *AwsIamAccessKeyDetails) *ResourceDetails {
	s.AwsIamAccessKey = v
	return s
}

// SetAwsIamGroup sets the AwsIamGroup field's value.
func (s *ResourceDetails) SetAwsIamGroup(v *AwsIamGroupDetails) *ResourceDetails {
	s.AwsIamGroup = v
	return s
}

// SetAwsIamPolicy sets the AwsIamPolicy field's value.
func (s *ResourceDetails) SetAwsIamPolicy(v *AwsIamPolicyDetails) *ResourceDetails {
	s.AwsIamPolicy = v
	return s
}

// SetAwsIamRole sets the AwsIamRole field's value.
func (s *ResourceDetails) SetAwsIamRole(v *AwsIamRoleDetails) *ResourceDetails {
	s.AwsIamRole = v
	return s
}

// SetAwsIamUser sets the AwsIamUser field's value.
func (s *ResourceDetails) SetAwsIamUser(v *AwsIamUserDetails) *ResourceDetails {
	s.AwsIamUser = v
	return s
}

// SetAwsKmsKey sets the AwsKmsKey field's value.
func (s *ResourceDetails) SetAwsKmsKey(v *AwsKmsKeyDetails) *ResourceDetails {
	s.AwsKmsKey = v
	return s
}

// SetAwsLambdaFunction sets the AwsLambdaFunction field's value.
func (s *ResourceDetails) SetAwsLambdaFunction(v *AwsLambdaFunctionDetails) *ResourceDetails {
	s.AwsLambdaFunction = v
	return s
}

// SetAwsLambdaLayerVersion sets the AwsLambdaLayerVersion field's value.
func (s *ResourceDetails) SetAwsLambdaLayerVersion(v *AwsLambdaLayerVersionDetails) *ResourceDetails {
	s.AwsLambdaLayerVersion = v
	return s
}

// SetAwsRdsDbCluster sets the AwsRdsDbCluster field's value.
func (s *ResourceDetails) SetAwsRdsDbCluster(v *AwsRdsDbClusterDetails) *ResourceDetails {
	s.AwsRdsDbCluster = v
	return s
}

// SetAwsRdsDbClusterSnapshot sets the AwsRdsDbClusterSnapshot field's value.
func (s *ResourceDetails) SetAwsRdsDbClusterSnapshot(v *AwsRdsDbClusterSnapshotDetails) *ResourceDetails {
	s.AwsRdsDbClusterSnapshot = v
	return s
}

// SetAwsRdsDbInstance sets the AwsRdsDbInstance field's value.
func (s *ResourceDetails) SetAwsRdsDbInstance(v *AwsRdsDbInstanceDetails) *ResourceDetails {
	s.AwsRdsDbInstance = v
	return s
}

// SetAwsRdsDbSnapshot sets the AwsRdsDbSnapshot field's value.
func (s *ResourceDetails) SetAwsRdsDbSnapshot(v *AwsRdsDbSnapshotDetails) *ResourceDetails {
	s.AwsRdsDbSnapshot = v
	return s
}

// SetAwsRedshiftCluster sets the AwsRedshiftCluster field's value.
func (s *ResourceDetails) SetAwsRedshiftCluster(v *AwsRedshiftClusterDetails) *ResourceDetails {
	s.AwsRedshiftCluster = v
	return s
}

// SetAwsS3Bucket sets the AwsS3Bucket field's value.
func (s *ResourceDetails) SetAwsS3Bucket(v *AwsS3BucketDetails) *ResourceDetails {
	s.AwsS3Bucket = v
	return s
}

// SetAwsS3Object sets the AwsS3Object field's value.
func (s *ResourceDetails) SetAwsS3Object(v *AwsS3ObjectDetails) *ResourceDetails {
	s.AwsS3Object = v
	return s
}

// SetAwsSecretsManagerSecret sets the AwsSecretsManagerSecret field's value.
func (s *ResourceDetails) SetAwsSecretsManagerSecret(v *AwsSecretsManagerSecretDetails) *ResourceDetails {
	s.AwsSecretsManagerSecret = v
	return s
}

// SetAwsSnsTopic sets the AwsSnsTopic field's value.
func (s *ResourceDetails) SetAwsSnsTopic(v *AwsSnsTopicDetails) *ResourceDetails {
	s.AwsSnsTopic = v
	return s
}

// SetAwsSqsQueue sets the AwsSqsQueue field's value.
func (s *ResourceDetails) SetAwsSqsQueue(v *AwsSqsQueueDetails) *ResourceDetails {
	s.AwsSqsQueue = v
	return s
}

// SetAwsWafWebAcl sets the AwsWafWebAcl field's value.
func (s *ResourceDetails) SetAwsWafWebAcl(v *AwsWafWebAclDetails) *ResourceDetails {
	s.AwsWafWebAcl = v
	return s
}

// SetContainer sets the Container field's value.
func (s *ResourceDetails) SetContainer(v *ContainerDetails) *ResourceDetails {
	s.Container = v
	return s
}

// SetOther sets the Other field's value.
func (s *ResourceDetails) SetOther(v map[string]*string) *ResourceDetails {
	s.Other = v
	return s
}

// The request was rejected because we can't find the specified resource.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about the account that was not processed.
type Result struct {
	_ struct{} `type:"structure"`

	// An AWS account ID of the account that was not processed.
	AccountId *string `type:"string"`

	// The reason that the account was not processed.
	ProcessingResult *string `type:"string"`
}

// String returns the string representation
func (s Result) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Result) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Result) SetAccountId(v string) *Result {
	s.AccountId = &v
	return s
}

// SetProcessingResult sets the ProcessingResult field's value.
func (s *Result) SetProcessingResult(v string) *Result {
	s.ProcessingResult = &v
	return s
}

// The severity of the finding.
//
// The finding provider can provide the initial severity, but cannot update
// it after that. The severity can only be updated by a master account. It cannot
// be updated by a member account.
//
// The finding must have either Label or Normalized populated. If only one of
// these attributes is populated, then Security Hub automatically populates
// the other one. If neither attribute is populated, then the finding is invalid.
// Label is the preferred attribute.
type Severity struct {
	_ struct{} `type:"structure"`

	// The severity value of the finding. The allowed values are the following.
	//
	//    * INFORMATIONAL - No issue was found.
	//
	//    * LOW - The issue does not require action on its own.
	//
	//    * MEDIUM - The issue must be addressed but not urgently.
	//
	//    * HIGH - The issue must be addressed as a priority.
	//
	//    * CRITICAL - The issue must be remediated immediately to avoid it escalating.
	//
	// If you provide Normalized and do not provide Label, then Label is set automatically
	// as follows.
	//
	//    * 0 - INFORMATIONAL
	//
	//    * 1–39 - LOW
	//
	//    * 40–69 - MEDIUM
	//
	//    * 70–89 - HIGH
	//
	//    * 90–100 - CRITICAL
	Label *string `type:"string" enum:"SeverityLabel"`

	// Deprecated. The normalized severity of a finding. This attribute is being
	// deprecated. Instead of providing Normalized, provide Label.
	//
	// If you provide Label and do not provide Normalized, then Normalized is set
	// automatically as follows.
	//
	//    * INFORMATIONAL - 0
	//
	//    * LOW - 1
	//
	//    * MEDIUM - 40
	//
	//    * HIGH - 70
	//
	//    * CRITICAL - 90
	Normalized *int64 `type:"integer"`

	// The native severity from the finding product that generated the finding.
	Original *string `type:"string"`

	// Deprecated. This attribute is being deprecated. Instead of providing Product,
	// provide Original.
	//
	// The native severity as defined by the AWS service or integrated partner product
	// that generated the finding.
	Product *float64 `type:"double"`
}

// String returns the string representation
func (s Severity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Severity) GoString() string {
	return s.String()
}

// SetLabel sets the Label field's value.
func (s *Severity) SetLabel(v string) *Severity {
	s.Label = &v
	return s
}

// SetNormalized sets the Normalized field's value.
func (s *Severity) SetNormalized(v int64) *Severity {
	s.Normalized = &v
	return s
}

// SetOriginal sets the Original field's value.
func (s *Severity) SetOriginal(v string) *Severity {
	s.Original = &v
	return s
}

// SetProduct sets the Product field's value.
func (s *Severity) SetProduct(v float64) *Severity {
	s.Product = &v
	return s
}

// Updates to the severity information for a finding.
type SeverityUpdate struct {
	_ struct{} `type:"structure"`

	// The severity value of the finding. The allowed values are the following.
	//
	//    * INFORMATIONAL - No issue was found.
	//
	//    * LOW - The issue does not require action on its own.
	//
	//    * MEDIUM - The issue must be addressed but not urgently.
	//
	//    * HIGH - The issue must be addressed as a priority.
	//
	//    * CRITICAL - The issue must be remediated immediately to avoid it escalating.
	Label *string `type:"string" enum:"SeverityLabel"`

	// The normalized severity for the finding. This attribute is to be deprecated
	// in favor of Label.
	//
	// If you provide Normalized and do not provide Label, Label is set automatically
	// as follows.
	//
	//    * 0 - INFORMATIONAL
	//
	//    * 1–39 - LOW
	//
	//    * 40–69 - MEDIUM
	//
	//    * 70–89 - HIGH
	//
	//    * 90–100 - CRITICAL
	Normalized *int64 `type:"integer"`

	// The native severity as defined by the AWS service or integrated partner product
	// that generated the finding.
	Product *float64 `type:"double"`
}

// String returns the string representation
func (s SeverityUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SeverityUpdate) GoString() string {
	return s.String()
}

// SetLabel sets the Label field's value.
func (s *SeverityUpdate) SetLabel(v string) *SeverityUpdate {
	s.Label = &v
	return s
}

// SetNormalized sets the Normalized field's value.
func (s *SeverityUpdate) SetNormalized(v int64) *SeverityUpdate {
	s.Normalized = &v
	return s
}

// SetProduct sets the Product field's value.
func (s *SeverityUpdate) SetProduct(v float64) *SeverityUpdate {
	s.Product = &v
	return s
}

// Information about a software package.
type SoftwarePackage struct {
	_ struct{} `type:"structure"`

	// The architecture used for the software package.
	Architecture *string `type:"string"`

	// The epoch of the software package.
	Epoch *string `type:"string"`

	// The name of the software package.
	Name *string `type:"string"`

	// The release of the software package.
	Release *string `type:"string"`

	// The version of the software package.
	Version *string `type:"string"`
}

// String returns the string representation
func (s SoftwarePackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SoftwarePackage) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *SoftwarePackage) SetArchitecture(v string) *SoftwarePackage {
	s.Architecture = &v
	return s
}

// SetEpoch sets the Epoch field's value.
func (s *SoftwarePackage) SetEpoch(v string) *SoftwarePackage {
	s.Epoch = &v
	return s
}

// SetName sets the Name field's value.
func (s *SoftwarePackage) SetName(v string) *SoftwarePackage {
	s.Name = &v
	return s
}

// SetRelease sets the Release field's value.
func (s *SoftwarePackage) SetRelease(v string) *SoftwarePackage {
	s.Release = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SoftwarePackage) SetVersion(v string) *SoftwarePackage {
	s.Version = &v
	return s
}

// A collection of finding attributes used to sort findings.
type SortCriterion struct {
	_ struct{} `type:"structure"`

	// The finding attribute used to sort findings.
	Field *string `type:"string"`

	// The order used to sort findings.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s SortCriterion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SortCriterion) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *SortCriterion) SetField(v string) *SortCriterion {
	s.Field = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *SortCriterion) SetSortOrder(v string) *SortCriterion {
	s.SortOrder = &v
	return s
}

// Provides information about a specific standard.
type Standard struct {
	_ struct{} `type:"structure"`

	// A description of the standard.
	Description *string `type:"string"`

	// Whether the standard is enabled by default. When Security Hub is enabled
	// from the console, if a standard is enabled by default, the check box for
	// that standard is selected by default.
	//
	// When Security Hub is enabled using the EnableSecurityHub API operation, the
	// standard is enabled by default unless EnableDefaultStandards is set to false.
	EnabledByDefault *bool `type:"boolean"`

	// The name of the standard.
	Name *string `type:"string"`

	// The ARN of a standard.
	StandardsArn *string `type:"string"`
}

// String returns the string representation
func (s Standard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Standard) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Standard) SetDescription(v string) *Standard {
	s.Description = &v
	return s
}

// SetEnabledByDefault sets the EnabledByDefault field's value.
func (s *Standard) SetEnabledByDefault(v bool) *Standard {
	s.EnabledByDefault = &v
	return s
}

// SetName sets the Name field's value.
func (s *Standard) SetName(v string) *Standard {
	s.Name = &v
	return s
}

// SetStandardsArn sets the StandardsArn field's value.
func (s *Standard) SetStandardsArn(v string) *Standard {
	s.StandardsArn = &v
	return s
}

// Details for an individual security standard control.
type StandardsControl struct {
	_ struct{} `type:"structure"`

	// The identifier of the security standard control.
	ControlId *string `type:"string"`

	// The current status of the security standard control. Indicates whether the
	// control is enabled or disabled. Security Hub does not check against disabled
	// controls.
	ControlStatus *string `type:"string" enum:"ControlStatus"`

	// The date and time that the status of the security standard control was most
	// recently updated.
	ControlStatusUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The longer description of the security standard control. Provides information
	// about what the control is checking for.
	Description *string `type:"string"`

	// The reason provided for the most recent change in status for the control.
	DisabledReason *string `type:"string"`

	// The list of requirements that are related to this control.
	RelatedRequirements []*string `type:"list"`

	// A link to remediation information for the control in the Security Hub user
	// documentation.
	RemediationUrl *string `type:"string"`

	// The severity of findings generated from this security standard control.
	//
	// The finding severity is based on an assessment of how easy it would be to
	// compromise AWS resources if the issue is detected.
	SeverityRating *string `type:"string" enum:"SeverityRating"`

	// The ARN of the security standard control.
	StandardsControlArn *string `type:"string"`

	// The title of the security standard control.
	Title *string `type:"string"`
}

// String returns the string representation
func (s StandardsControl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardsControl) GoString() string {
	return s.String()
}

// SetControlId sets the ControlId field's value.
func (s *StandardsControl) SetControlId(v string) *StandardsControl {
	s.ControlId = &v
	return s
}

// SetControlStatus sets the ControlStatus field's value.
func (s *StandardsControl) SetControlStatus(v string) *StandardsControl {
	s.ControlStatus = &v
	return s
}

// SetControlStatusUpdatedAt sets the ControlStatusUpdatedAt field's value.
func (s *StandardsControl) SetControlStatusUpdatedAt(v time.Time) *StandardsControl {
	s.ControlStatusUpdatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StandardsControl) SetDescription(v string) *StandardsControl {
	s.Description = &v
	return s
}

// SetDisabledReason sets the DisabledReason field's value.
func (s *StandardsControl) SetDisabledReason(v string) *StandardsControl {
	s.DisabledReason = &v
	return s
}

// SetRelatedRequirements sets the RelatedRequirements field's value.
func (s *StandardsControl) SetRelatedRequirements(v []*string) *StandardsControl {
	s.RelatedRequirements = v
	return s
}

// SetRemediationUrl sets the RemediationUrl field's value.
func (s *StandardsControl) SetRemediationUrl(v string) *StandardsControl {
	s.RemediationUrl = &v
	return s
}

// SetSeverityRating sets the SeverityRating field's value.
func (s *StandardsControl) SetSeverityRating(v string) *StandardsControl {
	s.SeverityRating = &v
	return s
}

// SetStandardsControlArn sets the StandardsControlArn field's value.
func (s *StandardsControl) SetStandardsControlArn(v string) *StandardsControl {
	s.StandardsControlArn = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *StandardsControl) SetTitle(v string) *StandardsControl {
	s.Title = &v
	return s
}

// A resource that represents your subscription to a supported standard.
type StandardsSubscription struct {
	_ struct{} `type:"structure"`

	// The ARN of a standard.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	// A key-value pair of input for the standard.
	//
	// StandardsInput is a required field
	StandardsInput map[string]*string `type:"map" required:"true"`

	// The status of the standards subscription.
	//
	// StandardsStatus is a required field
	StandardsStatus *string `type:"string" required:"true" enum:"StandardsStatus"`

	// The ARN of a resource that represents your subscription to a supported standard.
	//
	// StandardsSubscriptionArn is a required field
	StandardsSubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StandardsSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardsSubscription) GoString() string {
	return s.String()
}

// SetStandardsArn sets the StandardsArn field's value.
func (s *StandardsSubscription) SetStandardsArn(v string) *StandardsSubscription {
	s.StandardsArn = &v
	return s
}

// SetStandardsInput sets the StandardsInput field's value.
func (s *StandardsSubscription) SetStandardsInput(v map[string]*string) *StandardsSubscription {
	s.StandardsInput = v
	return s
}

// SetStandardsStatus sets the StandardsStatus field's value.
func (s *StandardsSubscription) SetStandardsStatus(v string) *StandardsSubscription {
	s.StandardsStatus = &v
	return s
}

// SetStandardsSubscriptionArn sets the StandardsSubscriptionArn field's value.
func (s *StandardsSubscription) SetStandardsSubscriptionArn(v string) *StandardsSubscription {
	s.StandardsSubscriptionArn = &v
	return s
}

// The standard that you want to enable.
type StandardsSubscriptionRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the standard that you want to enable. To view the list of available
	// standards and their ARNs, use the DescribeStandards operation.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	// A key-value pair of input for the standard.
	StandardsInput map[string]*string `type:"map"`
}

// String returns the string representation
func (s StandardsSubscriptionRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardsSubscriptionRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StandardsSubscriptionRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StandardsSubscriptionRequest"}
	if s.StandardsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStandardsArn sets the StandardsArn field's value.
func (s *StandardsSubscriptionRequest) SetStandardsArn(v string) *StandardsSubscriptionRequest {
	s.StandardsArn = &v
	return s
}

// SetStandardsInput sets the StandardsInput field's value.
func (s *StandardsSubscriptionRequest) SetStandardsInput(v map[string]*string) *StandardsSubscriptionRequest {
	s.StandardsInput = v
	return s
}

// Provides additional context for the value of Compliance.Status.
type StatusReason struct {
	_ struct{} `type:"structure"`

	// The corresponding description for the status reason code.
	Description *string `type:"string"`

	// A code that represents a reason for the control status. For the list of status
	// reason codes and their meanings, see Standards-related information in the
	// ASFF (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff)
	// in the AWS Security Hub User Guide.
	//
	// ReasonCode is a required field
	ReasonCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StatusReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusReason) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatusReason) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatusReason"}
	if s.ReasonCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ReasonCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *StatusReason) SetDescription(v string) *StatusReason {
	s.Description = &v
	return s
}

// SetReasonCode sets the ReasonCode field's value.
func (s *StatusReason) SetReasonCode(v string) *StatusReason {
	s.ReasonCode = &v
	return s
}

// A string filter for querying findings.
type StringFilter struct {
	_ struct{} `type:"structure"`

	// The condition to apply to a string value when querying for findings. To search
	// for values that contain the filter criteria value, use one of the following
	// comparison operators:
	//
	//    * To search for values that exactly match the filter value, use EQUALS.
	//    For example, the filter ResourceType EQUALS AwsEc2SecurityGroup only matches
	//    findings that have a resource type of AwsEc2SecurityGroup.
	//
	//    * To search for values that start with the filter value, use PREFIX. For
	//    example, the filter ResourceType PREFIX AwsIam matches findings that have
	//    a resource type that starts with AwsIam. Findings with a resource type
	//    of AwsIamPolicy, AwsIamRole, or AwsIamUser would all match.
	//
	// EQUALS and PREFIX filters on the same field are joined by OR. A finding matches
	// if it matches any one of those filters.
	//
	// To search for values that do not contain the filter criteria value, use one
	// of the following comparison operators:
	//
	//    * To search for values that do not exactly match the filter value, use
	//    NOT_EQUALS. For example, the filter ResourceType NOT_EQUALS AwsIamPolicy
	//    matches findings that have a resource type other than AwsIamPolicy.
	//
	//    * To search for values that do not start with the filter value, use PREFIX_NOT_EQUALS.
	//    For example, the filter ResourceType PREFIX_NOT_EQUALS AwsIam matches
	//    findings that have a resource type that does not start with AwsIam. Findings
	//    with a resource type of AwsIamPolicy, AwsIamRole, or AwsIamUser would
	//    all be excluded from the results.
	//
	// NOT_EQUALS and PREFIX_NOT_EQUALS filters on the same field are joined by
	// AND. A finding matches only if it matches all of those filters.
	//
	// For filters on the same field, you cannot provide both an EQUALS filter and
	// a NOT_EQUALS or PREFIX_NOT_EQUALS filter. Combining filters in this way always
	// returns an error, even if the provided filter values would return valid results.
	//
	// You can combine PREFIX filters with NOT_EQUALS or PREFIX_NOT_EQUALS filters
	// for the same field. Security Hub first processes the PREFIX filters, then
	// the NOT_EQUALS or PREFIX_NOT_EQUALS filters.
	//
	// For example, for the following filter, Security Hub first identifies findings
	// that have resource types that start with either AwsIAM or AwsEc2. It then
	// excludes findings that have a resource type of AwsIamPolicy and findings
	// that have a resource type of AwsEc2NetworkInterface.
	//
	//    * ResourceType PREFIX AwsIam
	//
	//    * ResourceType PREFIX AwsEc2
	//
	//    * ResourceType NOT_EQUALS AwsIamPolicy
	//
	//    * ResourceType NOT_EQUALS AwsEc2NetworkInterface
	Comparison *string `type:"string" enum:"StringFilterComparison"`

	// The string filter value. Filter values are case sensitive. For example, the
	// product name for control-based findings is Security Hub. If you provide security
	// hub as the filter text, then there is no match.
	Value *string `type:"string"`
}

// String returns the string representation
func (s StringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StringFilter) GoString() string {
	return s.String()
}

// SetComparison sets the Comparison field's value.
func (s *StringFilter) SetComparison(v string) *StringFilter {
	s.Comparison = &v
	return s
}

// SetValue sets the Value field's value.
func (s *StringFilter) SetValue(v string) *StringFilter {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to apply the tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags to add to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Details about the threat intelligence related to a finding.
type ThreatIntelIndicator struct {
	_ struct{} `type:"structure"`

	// The category of a threat intelligence indicator.
	Category *string `type:"string" enum:"ThreatIntelIndicatorCategory"`

	// Indicates when the most recent instance of a threat intelligence indicator
	// was observed.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	LastObservedAt *string `type:"string"`

	// The source of the threat intelligence indicator.
	Source *string `type:"string"`

	// The URL to the page or site where you can get more information about the
	// threat intelligence indicator.
	SourceUrl *string `type:"string"`

	// The type of threat intelligence indicator.
	Type *string `type:"string" enum:"ThreatIntelIndicatorType"`

	// The value of a threat intelligence indicator.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ThreatIntelIndicator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThreatIntelIndicator) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *ThreatIntelIndicator) SetCategory(v string) *ThreatIntelIndicator {
	s.Category = &v
	return s
}

// SetLastObservedAt sets the LastObservedAt field's value.
func (s *ThreatIntelIndicator) SetLastObservedAt(v string) *ThreatIntelIndicator {
	s.LastObservedAt = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ThreatIntelIndicator) SetSource(v string) *ThreatIntelIndicator {
	s.Source = &v
	return s
}

// SetSourceUrl sets the SourceUrl field's value.
func (s *ThreatIntelIndicator) SetSourceUrl(v string) *ThreatIntelIndicator {
	s.SourceUrl = &v
	return s
}

// SetType sets the Type field's value.
func (s *ThreatIntelIndicator) SetType(v string) *ThreatIntelIndicator {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ThreatIntelIndicator) SetValue(v string) *ThreatIntelIndicator {
	s.Value = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to remove the tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tag keys associated with the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateActionTargetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom action target to update.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `location:"uri" locationName:"ActionTargetArn" type:"string" required:"true"`

	// The updated description for the custom action target.
	Description *string `type:"string"`

	// The updated name of the custom action target.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateActionTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateActionTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateActionTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateActionTargetInput"}
	if s.ActionTargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTargetArn"))
	}
	if s.ActionTargetArn != nil && len(*s.ActionTargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionTargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTargetArn sets the ActionTargetArn field's value.
func (s *UpdateActionTargetInput) SetActionTargetArn(v string) *UpdateActionTargetInput {
	s.ActionTargetArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateActionTargetInput) SetDescription(v string) *UpdateActionTargetInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateActionTargetInput) SetName(v string) *UpdateActionTargetInput {
	s.Name = &v
	return s
}

type UpdateActionTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateActionTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateActionTargetOutput) GoString() string {
	return s.String()
}

type UpdateFindingsInput struct {
	_ struct{} `type:"structure"`

	// A collection of attributes that specify which findings you want to update.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The updated note for the finding.
	Note *NoteUpdate `type:"structure"`

	// The updated record state for the finding.
	RecordState *string `type:"string" enum:"RecordState"`
}

// String returns the string representation
func (s UpdateFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFindingsInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *UpdateFindingsInput) SetFilters(v *AwsSecurityFindingFilters) *UpdateFindingsInput {
	s.Filters = v
	return s
}

// SetNote sets the Note field's value.
func (s *UpdateFindingsInput) SetNote(v *NoteUpdate) *UpdateFindingsInput {
	s.Note = v
	return s
}

// SetRecordState sets the RecordState field's value.
func (s *UpdateFindingsInput) SetRecordState(v string) *UpdateFindingsInput {
	s.RecordState = &v
	return s
}

type UpdateFindingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFindingsOutput) GoString() string {
	return s.String()
}

type UpdateInsightInput struct {
	_ struct{} `type:"structure"`

	// The updated filters that define this insight.
	Filters *AwsSecurityFindingFilters `type:"structure"`

	// The updated GroupBy attribute that defines this insight.
	GroupByAttribute *string `type:"string"`

	// The ARN of the insight that you want to update.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`

	// The updated name for the insight.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInsightInput"}
	if s.InsightArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightArn"))
	}
	if s.InsightArn != nil && len(*s.InsightArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *UpdateInsightInput) SetFilters(v *AwsSecurityFindingFilters) *UpdateInsightInput {
	s.Filters = v
	return s
}

// SetGroupByAttribute sets the GroupByAttribute field's value.
func (s *UpdateInsightInput) SetGroupByAttribute(v string) *UpdateInsightInput {
	s.GroupByAttribute = &v
	return s
}

// SetInsightArn sets the InsightArn field's value.
func (s *UpdateInsightInput) SetInsightArn(v string) *UpdateInsightInput {
	s.InsightArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateInsightInput) SetName(v string) *UpdateInsightInput {
	s.Name = &v
	return s
}

type UpdateInsightOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInsightOutput) GoString() string {
	return s.String()
}

type UpdateOrganizationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Whether to automatically enable Security Hub for new accounts in the organization.
	//
	// By default, this is false, and new accounts are not added automatically.
	//
	// To automatically enable Security Hub for new accounts, set this to true.
	//
	// AutoEnable is a required field
	AutoEnable *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s UpdateOrganizationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOrganizationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOrganizationConfigurationInput"}
	if s.AutoEnable == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoEnable"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoEnable sets the AutoEnable field's value.
func (s *UpdateOrganizationConfigurationInput) SetAutoEnable(v bool) *UpdateOrganizationConfigurationInput {
	s.AutoEnable = &v
	return s
}

type UpdateOrganizationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateOrganizationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOrganizationConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateSecurityHubConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Whether to automatically enable new controls when they are added to standards
	// that are enabled.
	//
	// By default, this is set to true, and new controls are enabled automatically.
	// To not automatically enable new controls, set this to false.
	AutoEnableControls *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateSecurityHubConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSecurityHubConfigurationInput) GoString() string {
	return s.String()
}

// SetAutoEnableControls sets the AutoEnableControls field's value.
func (s *UpdateSecurityHubConfigurationInput) SetAutoEnableControls(v bool) *UpdateSecurityHubConfigurationInput {
	s.AutoEnableControls = &v
	return s
}

type UpdateSecurityHubConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSecurityHubConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSecurityHubConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateStandardsControlInput struct {
	_ struct{} `type:"structure"`

	// The updated status of the security standard control.
	ControlStatus *string `type:"string" enum:"ControlStatus"`

	// A description of the reason why you are disabling a security standard control.
	// If you are disabling a control, then this is required.
	DisabledReason *string `type:"string"`

	// The ARN of the security standard control to enable or disable.
	//
	// StandardsControlArn is a required field
	StandardsControlArn *string `location:"uri" locationName:"StandardsControlArn" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStandardsControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStandardsControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStandardsControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStandardsControlInput"}
	if s.StandardsControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StandardsControlArn"))
	}
	if s.StandardsControlArn != nil && len(*s.StandardsControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StandardsControlArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlStatus sets the ControlStatus field's value.
func (s *UpdateStandardsControlInput) SetControlStatus(v string) *UpdateStandardsControlInput {
	s.ControlStatus = &v
	return s
}

// SetDisabledReason sets the DisabledReason field's value.
func (s *UpdateStandardsControlInput) SetDisabledReason(v string) *UpdateStandardsControlInput {
	s.DisabledReason = &v
	return s
}

// SetStandardsControlArn sets the StandardsControlArn field's value.
func (s *UpdateStandardsControlInput) SetStandardsControlArn(v string) *UpdateStandardsControlInput {
	s.StandardsControlArn = &v
	return s
}

type UpdateStandardsControlOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateStandardsControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStandardsControlOutput) GoString() string {
	return s.String()
}

// A vulnerability associated with a finding.
type Vulnerability struct {
	_ struct{} `type:"structure"`

	// CVSS scores from the advisory related to the vulnerability.
	Cvss []*Cvss `type:"list"`

	// The identifier of the vulnerability.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A list of URLs that provide additional information about the vulnerability.
	ReferenceUrls []*string `type:"list"`

	// List of vulnerabilities that are related to this vulnerability.
	RelatedVulnerabilities []*string `type:"list"`

	// Information about the vendor that generates the vulnerability report.
	Vendor *VulnerabilityVendor `type:"structure"`

	// List of software packages that have the vulnerability.
	VulnerablePackages []*SoftwarePackage `type:"list"`
}

// String returns the string representation
func (s Vulnerability) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Vulnerability) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Vulnerability) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Vulnerability"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Vendor != nil {
		if err := s.Vendor.Validate(); err != nil {
			invalidParams.AddNested("Vendor", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCvss sets the Cvss field's value.
func (s *Vulnerability) SetCvss(v []*Cvss) *Vulnerability {
	s.Cvss = v
	return s
}

// SetId sets the Id field's value.
func (s *Vulnerability) SetId(v string) *Vulnerability {
	s.Id = &v
	return s
}

// SetReferenceUrls sets the ReferenceUrls field's value.
func (s *Vulnerability) SetReferenceUrls(v []*string) *Vulnerability {
	s.ReferenceUrls = v
	return s
}

// SetRelatedVulnerabilities sets the RelatedVulnerabilities field's value.
func (s *Vulnerability) SetRelatedVulnerabilities(v []*string) *Vulnerability {
	s.RelatedVulnerabilities = v
	return s
}

// SetVendor sets the Vendor field's value.
func (s *Vulnerability) SetVendor(v *VulnerabilityVendor) *Vulnerability {
	s.Vendor = v
	return s
}

// SetVulnerablePackages sets the VulnerablePackages field's value.
func (s *Vulnerability) SetVulnerablePackages(v []*SoftwarePackage) *Vulnerability {
	s.VulnerablePackages = v
	return s
}

// A vendor that generates a vulnerability report.
type VulnerabilityVendor struct {
	_ struct{} `type:"structure"`

	// The name of the vendor.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The URL of the vulnerability advisory.
	Url *string `type:"string"`

	// Indicates when the vulnerability advisory was created.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	VendorCreatedAt *string `type:"string"`

	// The severity that the vendor assigned to the vulnerability.
	VendorSeverity *string `type:"string"`

	// Indicates when the vulnerability advisory was last updated.
	//
	// Uses the date-time format specified in RFC 3339 section 5.6, Internet Date/Time
	// Format (https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
	// contain spaces. For example, 2020-03-22T13:22:13.933Z.
	VendorUpdatedAt *string `type:"string"`
}

// String returns the string representation
func (s VulnerabilityVendor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VulnerabilityVendor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VulnerabilityVendor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VulnerabilityVendor"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *VulnerabilityVendor) SetName(v string) *VulnerabilityVendor {
	s.Name = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *VulnerabilityVendor) SetUrl(v string) *VulnerabilityVendor {
	s.Url = &v
	return s
}

// SetVendorCreatedAt sets the VendorCreatedAt field's value.
func (s *VulnerabilityVendor) SetVendorCreatedAt(v string) *VulnerabilityVendor {
	s.VendorCreatedAt = &v
	return s
}

// SetVendorSeverity sets the VendorSeverity field's value.
func (s *VulnerabilityVendor) SetVendorSeverity(v string) *VulnerabilityVendor {
	s.VendorSeverity = &v
	return s
}

// SetVendorUpdatedAt sets the VendorUpdatedAt field's value.
func (s *VulnerabilityVendor) SetVendorUpdatedAt(v string) *VulnerabilityVendor {
	s.VendorUpdatedAt = &v
	return s
}

// Details about the action that CloudFront or AWS WAF takes when a web request
// matches the conditions in the rule.
type WafAction struct {
	_ struct{} `type:"structure"`

	// Specifies how you want AWS WAF to respond to requests that match the settings
	// in a rule.
	//
	// Valid settings include the following:
	//
	//    * ALLOW - AWS WAF allows requests
	//
	//    * BLOCK - AWS WAF blocks requests
	//
	//    * COUNT - AWS WAF increments a counter of the requests that match all
	//    of the conditions in the rule. AWS WAF then continues to inspect the web
	//    request based on the remaining rules in the web ACL. You can't specify
	//    COUNT for the default action for a WebACL.
	Type *string `type:"string"`
}

// String returns the string representation
func (s WafAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WafAction) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *WafAction) SetType(v string) *WafAction {
	s.Type = &v
	return s
}

// Details about a rule to exclude from a rule group.
type WafExcludedRule struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the rule to exclude from the rule group.
	RuleId *string `type:"string"`
}

// String returns the string representation
func (s WafExcludedRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WafExcludedRule) GoString() string {
	return s.String()
}

// SetRuleId sets the RuleId field's value.
func (s *WafExcludedRule) SetRuleId(v string) *WafExcludedRule {
	s.RuleId = &v
	return s
}

// Details about an override action for a rule.
type WafOverrideAction struct {
	_ struct{} `type:"structure"`

	// COUNT overrides the action specified by the individual rule within a RuleGroup .
	//
	// If set to NONE, the rule's action takes place.
	Type *string `type:"string"`
}

// String returns the string representation
func (s WafOverrideAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WafOverrideAction) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *WafOverrideAction) SetType(v string) *WafOverrideAction {
	s.Type = &v
	return s
}

// Provides information about the status of the investigation into a finding.
type Workflow struct {
	_ struct{} `type:"structure"`

	// The status of the investigation into the finding. The allowed values are
	// the following.
	//
	//    * NEW - The initial state of a finding, before it is reviewed.
	//
	//    * NOTIFIED - Indicates that you notified the resource owner about the
	//    security issue. Used when the initial reviewer is not the resource owner,
	//    and needs intervention from the resource owner.
	//
	//    * SUPPRESSED - The finding will not be reviewed again and will not be
	//    acted upon.
	//
	//    * RESOLVED - The finding was reviewed and remediated and is now considered
	//    resolved.
	Status *string `type:"string" enum:"WorkflowStatus"`
}

// String returns the string representation
func (s Workflow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Workflow) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *Workflow) SetStatus(v string) *Workflow {
	s.Status = &v
	return s
}

// Used to update information about the investigation into the finding.
type WorkflowUpdate struct {
	_ struct{} `type:"structure"`

	// The status of the investigation into the finding. The allowed values are
	// the following.
	//
	//    * NEW - The initial state of a finding, before it is reviewed.
	//
	//    * NOTIFIED - Indicates that you notified the resource owner about the
	//    security issue. Used when the initial reviewer is not the resource owner,
	//    and needs intervention from the resource owner.
	//
	//    * RESOLVED - The finding was reviewed and remediated and is now considered
	//    resolved.
	//
	//    * SUPPRESSED - The finding will not be reviewed again and will not be
	//    acted upon.
	Status *string `type:"string" enum:"WorkflowStatus"`
}

// String returns the string representation
func (s WorkflowUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowUpdate) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *WorkflowUpdate) SetStatus(v string) *WorkflowUpdate {
	s.Status = &v
	return s
}

const (
	// AdminStatusEnabled is a AdminStatus enum value
	AdminStatusEnabled = "ENABLED"

	// AdminStatusDisableInProgress is a AdminStatus enum value
	AdminStatusDisableInProgress = "DISABLE_IN_PROGRESS"
)

// AdminStatus_Values returns all elements of the AdminStatus enum
func AdminStatus_Values() []string {
	return []string{
		AdminStatusEnabled,
		AdminStatusDisableInProgress,
	}
}

const (
	// AwsIamAccessKeyStatusActive is a AwsIamAccessKeyStatus enum value
	AwsIamAccessKeyStatusActive = "Active"

	// AwsIamAccessKeyStatusInactive is a AwsIamAccessKeyStatus enum value
	AwsIamAccessKeyStatusInactive = "Inactive"
)

// AwsIamAccessKeyStatus_Values returns all elements of the AwsIamAccessKeyStatus enum
func AwsIamAccessKeyStatus_Values() []string {
	return []string{
		AwsIamAccessKeyStatusActive,
		AwsIamAccessKeyStatusInactive,
	}
}

const (
	// ComplianceStatusPassed is a ComplianceStatus enum value
	ComplianceStatusPassed = "PASSED"

	// ComplianceStatusWarning is a ComplianceStatus enum value
	ComplianceStatusWarning = "WARNING"

	// ComplianceStatusFailed is a ComplianceStatus enum value
	ComplianceStatusFailed = "FAILED"

	// ComplianceStatusNotAvailable is a ComplianceStatus enum value
	ComplianceStatusNotAvailable = "NOT_AVAILABLE"
)

// ComplianceStatus_Values returns all elements of the ComplianceStatus enum
func ComplianceStatus_Values() []string {
	return []string{
		ComplianceStatusPassed,
		ComplianceStatusWarning,
		ComplianceStatusFailed,
		ComplianceStatusNotAvailable,
	}
}

const (
	// ControlStatusEnabled is a ControlStatus enum value
	ControlStatusEnabled = "ENABLED"

	// ControlStatusDisabled is a ControlStatus enum value
	ControlStatusDisabled = "DISABLED"
)

// ControlStatus_Values returns all elements of the ControlStatus enum
func ControlStatus_Values() []string {
	return []string{
		ControlStatusEnabled,
		ControlStatusDisabled,
	}
}

const (
	// DateRangeUnitDays is a DateRangeUnit enum value
	DateRangeUnitDays = "DAYS"
)

// DateRangeUnit_Values returns all elements of the DateRangeUnit enum
func DateRangeUnit_Values() []string {
	return []string{
		DateRangeUnitDays,
	}
}

const (
	// IntegrationTypeSendFindingsToSecurityHub is a IntegrationType enum value
	IntegrationTypeSendFindingsToSecurityHub = "SEND_FINDINGS_TO_SECURITY_HUB"

	// IntegrationTypeReceiveFindingsFromSecurityHub is a IntegrationType enum value
	IntegrationTypeReceiveFindingsFromSecurityHub = "RECEIVE_FINDINGS_FROM_SECURITY_HUB"
)

// IntegrationType_Values returns all elements of the IntegrationType enum
func IntegrationType_Values() []string {
	return []string{
		IntegrationTypeSendFindingsToSecurityHub,
		IntegrationTypeReceiveFindingsFromSecurityHub,
	}
}

const (
	// MalwareStateObserved is a MalwareState enum value
	MalwareStateObserved = "OBSERVED"

	// MalwareStateRemovalFailed is a MalwareState enum value
	MalwareStateRemovalFailed = "REMOVAL_FAILED"

	// MalwareStateRemoved is a MalwareState enum value
	MalwareStateRemoved = "REMOVED"
)

// MalwareState_Values returns all elements of the MalwareState enum
func MalwareState_Values() []string {
	return []string{
		MalwareStateObserved,
		MalwareStateRemovalFailed,
		MalwareStateRemoved,
	}
}

const (
	// MalwareTypeAdware is a MalwareType enum value
	MalwareTypeAdware = "ADWARE"

	// MalwareTypeBlendedThreat is a MalwareType enum value
	MalwareTypeBlendedThreat = "BLENDED_THREAT"

	// MalwareTypeBotnetAgent is a MalwareType enum value
	MalwareTypeBotnetAgent = "BOTNET_AGENT"

	// MalwareTypeCoinMiner is a MalwareType enum value
	MalwareTypeCoinMiner = "COIN_MINER"

	// MalwareTypeExploitKit is a MalwareType enum value
	MalwareTypeExploitKit = "EXPLOIT_KIT"

	// MalwareTypeKeylogger is a MalwareType enum value
	MalwareTypeKeylogger = "KEYLOGGER"

	// MalwareTypeMacro is a MalwareType enum value
	MalwareTypeMacro = "MACRO"

	// MalwareTypePotentiallyUnwanted is a MalwareType enum value
	MalwareTypePotentiallyUnwanted = "POTENTIALLY_UNWANTED"

	// MalwareTypeSpyware is a MalwareType enum value
	MalwareTypeSpyware = "SPYWARE"

	// MalwareTypeRansomware is a MalwareType enum value
	MalwareTypeRansomware = "RANSOMWARE"

	// MalwareTypeRemoteAccess is a MalwareType enum value
	MalwareTypeRemoteAccess = "REMOTE_ACCESS"

	// MalwareTypeRootkit is a MalwareType enum value
	MalwareTypeRootkit = "ROOTKIT"

	// MalwareTypeTrojan is a MalwareType enum value
	MalwareTypeTrojan = "TROJAN"

	// MalwareTypeVirus is a MalwareType enum value
	MalwareTypeVirus = "VIRUS"

	// MalwareTypeWorm is a MalwareType enum value
	MalwareTypeWorm = "WORM"
)

// MalwareType_Values returns all elements of the MalwareType enum
func MalwareType_Values() []string {
	return []string{
		MalwareTypeAdware,
		MalwareTypeBlendedThreat,
		MalwareTypeBotnetAgent,
		MalwareTypeCoinMiner,
		MalwareTypeExploitKit,
		MalwareTypeKeylogger,
		MalwareTypeMacro,
		MalwareTypePotentiallyUnwanted,
		MalwareTypeSpyware,
		MalwareTypeRansomware,
		MalwareTypeRemoteAccess,
		MalwareTypeRootkit,
		MalwareTypeTrojan,
		MalwareTypeVirus,
		MalwareTypeWorm,
	}
}

const (
	// MapFilterComparisonEquals is a MapFilterComparison enum value
	MapFilterComparisonEquals = "EQUALS"

	// MapFilterComparisonNotEquals is a MapFilterComparison enum value
	MapFilterComparisonNotEquals = "NOT_EQUALS"
)

// MapFilterComparison_Values returns all elements of the MapFilterComparison enum
func MapFilterComparison_Values() []string {
	return []string{
		MapFilterComparisonEquals,
		MapFilterComparisonNotEquals,
	}
}

const (
	// NetworkDirectionIn is a NetworkDirection enum value
	NetworkDirectionIn = "IN"

	// NetworkDirectionOut is a NetworkDirection enum value
	NetworkDirectionOut = "OUT"
)

// NetworkDirection_Values returns all elements of the NetworkDirection enum
func NetworkDirection_Values() []string {
	return []string{
		NetworkDirectionIn,
		NetworkDirectionOut,
	}
}

const (
	// PartitionAws is a Partition enum value
	PartitionAws = "aws"

	// PartitionAwsCn is a Partition enum value
	PartitionAwsCn = "aws-cn"

	// PartitionAwsUsGov is a Partition enum value
	PartitionAwsUsGov = "aws-us-gov"
)

// Partition_Values returns all elements of the Partition enum
func Partition_Values() []string {
	return []string{
		PartitionAws,
		PartitionAwsCn,
		PartitionAwsUsGov,
	}
}

const (
	// RecordStateActive is a RecordState enum value
	RecordStateActive = "ACTIVE"

	// RecordStateArchived is a RecordState enum value
	RecordStateArchived = "ARCHIVED"
)

// RecordState_Values returns all elements of the RecordState enum
func RecordState_Values() []string {
	return []string{
		RecordStateActive,
		RecordStateArchived,
	}
}

const (
	// SeverityLabelInformational is a SeverityLabel enum value
	SeverityLabelInformational = "INFORMATIONAL"

	// SeverityLabelLow is a SeverityLabel enum value
	SeverityLabelLow = "LOW"

	// SeverityLabelMedium is a SeverityLabel enum value
	SeverityLabelMedium = "MEDIUM"

	// SeverityLabelHigh is a SeverityLabel enum value
	SeverityLabelHigh = "HIGH"

	// SeverityLabelCritical is a SeverityLabel enum value
	SeverityLabelCritical = "CRITICAL"
)

// SeverityLabel_Values returns all elements of the SeverityLabel enum
func SeverityLabel_Values() []string {
	return []string{
		SeverityLabelInformational,
		SeverityLabelLow,
		SeverityLabelMedium,
		SeverityLabelHigh,
		SeverityLabelCritical,
	}
}

const (
	// SeverityRatingLow is a SeverityRating enum value
	SeverityRatingLow = "LOW"

	// SeverityRatingMedium is a SeverityRating enum value
	SeverityRatingMedium = "MEDIUM"

	// SeverityRatingHigh is a SeverityRating enum value
	SeverityRatingHigh = "HIGH"

	// SeverityRatingCritical is a SeverityRating enum value
	SeverityRatingCritical = "CRITICAL"
)

// SeverityRating_Values returns all elements of the SeverityRating enum
func SeverityRating_Values() []string {
	return []string{
		SeverityRatingLow,
		SeverityRatingMedium,
		SeverityRatingHigh,
		SeverityRatingCritical,
	}
}

const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "asc"

	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "desc"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAsc,
		SortOrderDesc,
	}
}

const (
	// StandardsStatusPending is a StandardsStatus enum value
	StandardsStatusPending = "PENDING"

	// StandardsStatusReady is a StandardsStatus enum value
	StandardsStatusReady = "READY"

	// StandardsStatusFailed is a StandardsStatus enum value
	StandardsStatusFailed = "FAILED"

	// StandardsStatusDeleting is a StandardsStatus enum value
	StandardsStatusDeleting = "DELETING"

	// StandardsStatusIncomplete is a StandardsStatus enum value
	StandardsStatusIncomplete = "INCOMPLETE"
)

// StandardsStatus_Values returns all elements of the StandardsStatus enum
func StandardsStatus_Values() []string {
	return []string{
		StandardsStatusPending,
		StandardsStatusReady,
		StandardsStatusFailed,
		StandardsStatusDeleting,
		StandardsStatusIncomplete,
	}
}

const (
	// StringFilterComparisonEquals is a StringFilterComparison enum value
	StringFilterComparisonEquals = "EQUALS"

	// StringFilterComparisonPrefix is a StringFilterComparison enum value
	StringFilterComparisonPrefix = "PREFIX"

	// StringFilterComparisonNotEquals is a StringFilterComparison enum value
	StringFilterComparisonNotEquals = "NOT_EQUALS"

	// StringFilterComparisonPrefixNotEquals is a StringFilterComparison enum value
	StringFilterComparisonPrefixNotEquals = "PREFIX_NOT_EQUALS"
)

// StringFilterComparison_Values returns all elements of the StringFilterComparison enum
func StringFilterComparison_Values() []string {
	return []string{
		StringFilterComparisonEquals,
		StringFilterComparisonPrefix,
		StringFilterComparisonNotEquals,
		StringFilterComparisonPrefixNotEquals,
	}
}

const (
	// ThreatIntelIndicatorCategoryBackdoor is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryBackdoor = "BACKDOOR"

	// ThreatIntelIndicatorCategoryCardStealer is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryCardStealer = "CARD_STEALER"

	// ThreatIntelIndicatorCategoryCommandAndControl is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryCommandAndControl = "COMMAND_AND_CONTROL"

	// ThreatIntelIndicatorCategoryDropSite is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryDropSite = "DROP_SITE"

	// ThreatIntelIndicatorCategoryExploitSite is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryExploitSite = "EXPLOIT_SITE"

	// ThreatIntelIndicatorCategoryKeylogger is a ThreatIntelIndicatorCategory enum value
	ThreatIntelIndicatorCategoryKeylogger = "KEYLOGGER"
)

// ThreatIntelIndicatorCategory_Values returns all elements of the ThreatIntelIndicatorCategory enum
func ThreatIntelIndicatorCategory_Values() []string {
	return []string{
		ThreatIntelIndicatorCategoryBackdoor,
		ThreatIntelIndicatorCategoryCardStealer,
		ThreatIntelIndicatorCategoryCommandAndControl,
		ThreatIntelIndicatorCategoryDropSite,
		ThreatIntelIndicatorCategoryExploitSite,
		ThreatIntelIndicatorCategoryKeylogger,
	}
}

const (
	// ThreatIntelIndicatorTypeDomain is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeDomain = "DOMAIN"

	// ThreatIntelIndicatorTypeEmailAddress is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeEmailAddress = "EMAIL_ADDRESS"

	// ThreatIntelIndicatorTypeHashMd5 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashMd5 = "HASH_MD5"

	// ThreatIntelIndicatorTypeHashSha1 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashSha1 = "HASH_SHA1"

	// ThreatIntelIndicatorTypeHashSha256 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashSha256 = "HASH_SHA256"

	// ThreatIntelIndicatorTypeHashSha512 is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeHashSha512 = "HASH_SHA512"

	// ThreatIntelIndicatorTypeIpv4Address is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeIpv4Address = "IPV4_ADDRESS"

	// ThreatIntelIndicatorTypeIpv6Address is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeIpv6Address = "IPV6_ADDRESS"

	// ThreatIntelIndicatorTypeMutex is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeMutex = "MUTEX"

	// ThreatIntelIndicatorTypeProcess is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeProcess = "PROCESS"

	// ThreatIntelIndicatorTypeUrl is a ThreatIntelIndicatorType enum value
	ThreatIntelIndicatorTypeUrl = "URL"
)

// ThreatIntelIndicatorType_Values returns all elements of the ThreatIntelIndicatorType enum
func ThreatIntelIndicatorType_Values() []string {
	return []string{
		ThreatIntelIndicatorTypeDomain,
		ThreatIntelIndicatorTypeEmailAddress,
		ThreatIntelIndicatorTypeHashMd5,
		ThreatIntelIndicatorTypeHashSha1,
		ThreatIntelIndicatorTypeHashSha256,
		ThreatIntelIndicatorTypeHashSha512,
		ThreatIntelIndicatorTypeIpv4Address,
		ThreatIntelIndicatorTypeIpv6Address,
		ThreatIntelIndicatorTypeMutex,
		ThreatIntelIndicatorTypeProcess,
		ThreatIntelIndicatorTypeUrl,
	}
}

const (
	// VerificationStateUnknown is a VerificationState enum value
	VerificationStateUnknown = "UNKNOWN"

	// VerificationStateTruePositive is a VerificationState enum value
	VerificationStateTruePositive = "TRUE_POSITIVE"

	// VerificationStateFalsePositive is a VerificationState enum value
	VerificationStateFalsePositive = "FALSE_POSITIVE"

	// VerificationStateBenignPositive is a VerificationState enum value
	VerificationStateBenignPositive = "BENIGN_POSITIVE"
)

// VerificationState_Values returns all elements of the VerificationState enum
func VerificationState_Values() []string {
	return []string{
		VerificationStateUnknown,
		VerificationStateTruePositive,
		VerificationStateFalsePositive,
		VerificationStateBenignPositive,
	}
}

const (
	// WorkflowStateNew is a WorkflowState enum value
	WorkflowStateNew = "NEW"

	// WorkflowStateAssigned is a WorkflowState enum value
	WorkflowStateAssigned = "ASSIGNED"

	// WorkflowStateInProgress is a WorkflowState enum value
	WorkflowStateInProgress = "IN_PROGRESS"

	// WorkflowStateDeferred is a WorkflowState enum value
	WorkflowStateDeferred = "DEFERRED"

	// WorkflowStateResolved is a WorkflowState enum value
	WorkflowStateResolved = "RESOLVED"
)

// WorkflowState_Values returns all elements of the WorkflowState enum
func WorkflowState_Values() []string {
	return []string{
		WorkflowStateNew,
		WorkflowStateAssigned,
		WorkflowStateInProgress,
		WorkflowStateDeferred,
		WorkflowStateResolved,
	}
}

const (
	// WorkflowStatusNew is a WorkflowStatus enum value
	WorkflowStatusNew = "NEW"

	// WorkflowStatusNotified is a WorkflowStatus enum value
	WorkflowStatusNotified = "NOTIFIED"

	// WorkflowStatusResolved is a WorkflowStatus enum value
	WorkflowStatusResolved = "RESOLVED"

	// WorkflowStatusSuppressed is a WorkflowStatus enum value
	WorkflowStatusSuppressed = "SUPPRESSED"
)

// WorkflowStatus_Values returns all elements of the WorkflowStatus enum
func WorkflowStatus_Values() []string {
	return []string{
		WorkflowStatusNew,
		WorkflowStatusNotified,
		WorkflowStatusResolved,
		WorkflowStatusSuppressed,
	}
}
