package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNatGatewayConvertStatus invokes the vpc.GetNatGatewayConvertStatus API synchronously
func (client *Client) GetNatGatewayConvertStatus(request *GetNatGatewayConvertStatusRequest) (response *GetNatGatewayConvertStatusResponse, err error) {
	response = CreateGetNatGatewayConvertStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetNatGatewayConvertStatusWithChan invokes the vpc.GetNatGatewayConvertStatus API asynchronously
func (client *Client) GetNatGatewayConvertStatusWithChan(request *GetNatGatewayConvertStatusRequest) (<-chan *GetNatGatewayConvertStatusResponse, <-chan error) {
	responseChan := make(chan *GetNatGatewayConvertStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNatGatewayConvertStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNatGatewayConvertStatusWithCallback invokes the vpc.GetNatGatewayConvertStatus API asynchronously
func (client *Client) GetNatGatewayConvertStatusWithCallback(request *GetNatGatewayConvertStatusRequest, callback func(response *GetNatGatewayConvertStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNatGatewayConvertStatusResponse
		var err error
		defer close(result)
		response, err = client.GetNatGatewayConvertStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNatGatewayConvertStatusRequest is the request struct for api GetNatGatewayConvertStatus
type GetNatGatewayConvertStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NatGatewayId         string           `position:"Query" name:"NatGatewayId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetNatGatewayConvertStatusResponse is the response struct for api GetNatGatewayConvertStatus
type GetNatGatewayConvertStatusResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	NatGatewayId string        `json:"NatGatewayId" xml:"NatGatewayId"`
	Bid          string        `json:"Bid" xml:"Bid"`
	AliUid       int64         `json:"AliUid" xml:"AliUid"`
	DstNatType   string        `json:"DstNatType" xml:"DstNatType"`
	ConvertSteps []ConvertStep `json:"ConvertSteps" xml:"ConvertSteps"`
}

// CreateGetNatGatewayConvertStatusRequest creates a request to invoke GetNatGatewayConvertStatus API
func CreateGetNatGatewayConvertStatusRequest() (request *GetNatGatewayConvertStatusRequest) {
	request = &GetNatGatewayConvertStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GetNatGatewayConvertStatus", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNatGatewayConvertStatusResponse creates a response to parse from GetNatGatewayConvertStatus response
func CreateGetNatGatewayConvertStatusResponse() (response *GetNatGatewayConvertStatusResponse) {
	response = &GetNatGatewayConvertStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
