package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchNetwork invokes the r_kvstore.SwitchNetwork API synchronously
func (client *Client) SwitchNetwork(request *SwitchNetworkRequest) (response *SwitchNetworkResponse, err error) {
	response = CreateSwitchNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchNetworkWithChan invokes the r_kvstore.SwitchNetwork API asynchronously
func (client *Client) SwitchNetworkWithChan(request *SwitchNetworkRequest) (<-chan *SwitchNetworkResponse, <-chan error) {
	responseChan := make(chan *SwitchNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchNetworkWithCallback invokes the r_kvstore.SwitchNetwork API asynchronously
func (client *Client) SwitchNetworkWithCallback(request *SwitchNetworkRequest, callback func(response *SwitchNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchNetworkResponse
		var err error
		defer close(result)
		response, err = client.SwitchNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchNetworkRequest is the request struct for api SwitchNetwork
type SwitchNetworkRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ClassicExpiredDays   string           `position:"Query" name:"ClassicExpiredDays"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VSwitchId            string           `position:"Query" name:"VSwitchId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	TargetNetworkType    string           `position:"Query" name:"TargetNetworkType"`
	RetainClassic        string           `position:"Query" name:"RetainClassic"`
	VpcId                string           `position:"Query" name:"VpcId"`
}

// SwitchNetworkResponse is the response struct for api SwitchNetwork
type SwitchNetworkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateSwitchNetworkRequest creates a request to invoke SwitchNetwork API
func CreateSwitchNetworkRequest() (request *SwitchNetworkRequest) {
	request = &SwitchNetworkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "SwitchNetwork", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchNetworkResponse creates a response to parse from SwitchNetwork response
func CreateSwitchNetworkResponse() (response *SwitchNetworkResponse) {
	response = &SwitchNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
