package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReplaceUserClusterHost invokes the r_kvstore.ReplaceUserClusterHost API synchronously
func (client *Client) ReplaceUserClusterHost(request *ReplaceUserClusterHostRequest) (response *ReplaceUserClusterHostResponse, err error) {
	response = CreateReplaceUserClusterHostResponse()
	err = client.DoAction(request, response)
	return
}

// ReplaceUserClusterHostWithChan invokes the r_kvstore.ReplaceUserClusterHost API asynchronously
func (client *Client) ReplaceUserClusterHostWithChan(request *ReplaceUserClusterHostRequest) (<-chan *ReplaceUserClusterHostResponse, <-chan error) {
	responseChan := make(chan *ReplaceUserClusterHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReplaceUserClusterHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReplaceUserClusterHostWithCallback invokes the r_kvstore.ReplaceUserClusterHost API asynchronously
func (client *Client) ReplaceUserClusterHostWithCallback(request *ReplaceUserClusterHostRequest, callback func(response *ReplaceUserClusterHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReplaceUserClusterHostResponse
		var err error
		defer close(result)
		response, err = client.ReplaceUserClusterHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReplaceUserClusterHostRequest is the request struct for api ReplaceUserClusterHost
type ReplaceUserClusterHostRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostId               string           `position:"Query" name:"HostId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	Engine               string           `position:"Query" name:"Engine"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	ClusterId            string           `position:"Query" name:"ClusterId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
}

// ReplaceUserClusterHostResponse is the response struct for api ReplaceUserClusterHost
type ReplaceUserClusterHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	NewHostId string `json:"NewHostId" xml:"NewHostId"`
}

// CreateReplaceUserClusterHostRequest creates a request to invoke ReplaceUserClusterHost API
func CreateReplaceUserClusterHostRequest() (request *ReplaceUserClusterHostRequest) {
	request = &ReplaceUserClusterHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ReplaceUserClusterHost", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReplaceUserClusterHostResponse creates a response to parse from ReplaceUserClusterHost response
func CreateReplaceUserClusterHostResponse() (response *ReplaceUserClusterHostResponse) {
	response = &ReplaceUserClusterHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
