package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTag invokes the emr.QueryTag API synchronously
func (client *Client) QueryTag(request *QueryTagRequest) (response *QueryTagResponse, err error) {
	response = CreateQueryTagResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTagWithChan invokes the emr.QueryTag API asynchronously
func (client *Client) QueryTagWithChan(request *QueryTagRequest) (<-chan *QueryTagResponse, <-chan error) {
	responseChan := make(chan *QueryTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTagWithCallback invokes the emr.QueryTag API asynchronously
func (client *Client) QueryTagWithCallback(request *QueryTagRequest, callback func(response *QueryTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTagResponse
		var err error
		defer close(result)
		response, err = client.QueryTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTagRequest is the request struct for api QueryTag
type QueryTagRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TagId           requests.Integer `position:"Query" name:"TagId"`
	EntityId        string           `position:"Query" name:"EntityId"`
	EntityType      string           `position:"Query" name:"EntityType"`
}

// QueryTagResponse is the response struct for api QueryTag
type QueryTagResponse struct {
	*responses.BaseResponse
	RequestId  string          `json:"RequestId" xml:"RequestId"`
	PageNumber int             `json:"PageNumber" xml:"PageNumber"`
	PageSize   int             `json:"PageSize" xml:"PageSize"`
	TotalCount int             `json:"TotalCount" xml:"TotalCount"`
	Items      ItemsInQueryTag `json:"Items" xml:"Items"`
}

// CreateQueryTagRequest creates a request to invoke QueryTag API
func CreateQueryTagRequest() (request *QueryTagRequest) {
	request = &QueryTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "QueryTag", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTagResponse creates a response to parse from QueryTag response
func CreateQueryTagResponse() (response *QueryTagResponse) {
	response = &QueryTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
