package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEntity invokes the emr.QueryEntity API synchronously
func (client *Client) QueryEntity(request *QueryEntityRequest) (response *QueryEntityResponse, err error) {
	response = CreateQueryEntityResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEntityWithChan invokes the emr.QueryEntity API asynchronously
func (client *Client) QueryEntityWithChan(request *QueryEntityRequest) (<-chan *QueryEntityResponse, <-chan error) {
	responseChan := make(chan *QueryEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEntityWithCallback invokes the emr.QueryEntity API asynchronously
func (client *Client) QueryEntityWithCallback(request *QueryEntityRequest, callback func(response *QueryEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEntityResponse
		var err error
		defer close(result)
		response, err = client.QueryEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEntityRequest is the request struct for api QueryEntity
type QueryEntityRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Description     string           `position:"Query" name:"Description"`
	Name            string           `position:"Query" name:"Name"`
	Id              requests.Integer `position:"Query" name:"Id"`
	Category        string           `position:"Query" name:"Category"`
}

// QueryEntityResponse is the response struct for api QueryEntity
type QueryEntityResponse struct {
	*responses.BaseResponse
	RequestId  string             `json:"RequestId" xml:"RequestId"`
	PageNumber int                `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                `json:"PageSize" xml:"PageSize"`
	TotalCount int                `json:"TotalCount" xml:"TotalCount"`
	Items      ItemsInQueryEntity `json:"Items" xml:"Items"`
}

// CreateQueryEntityRequest creates a request to invoke QueryEntity API
func CreateQueryEntityRequest() (request *QueryEntityRequest) {
	request = &QueryEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "QueryEntity", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryEntityResponse creates a response to parse from QueryEntity response
func CreateQueryEntityResponse() (response *QueryEntityResponse) {
	response = &QueryEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
