package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyScalingTaskGroup invokes the emr.ModifyScalingTaskGroup API synchronously
func (client *Client) ModifyScalingTaskGroup(request *ModifyScalingTaskGroupRequest) (response *ModifyScalingTaskGroupResponse, err error) {
	response = CreateModifyScalingTaskGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyScalingTaskGroupWithChan invokes the emr.ModifyScalingTaskGroup API asynchronously
func (client *Client) ModifyScalingTaskGroupWithChan(request *ModifyScalingTaskGroupRequest) (<-chan *ModifyScalingTaskGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyScalingTaskGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyScalingTaskGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyScalingTaskGroupWithCallback invokes the emr.ModifyScalingTaskGroup API asynchronously
func (client *Client) ModifyScalingTaskGroupWithCallback(request *ModifyScalingTaskGroupRequest, callback func(response *ModifyScalingTaskGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyScalingTaskGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyScalingTaskGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyScalingTaskGroupRequest is the request struct for api ModifyScalingTaskGroup
type ModifyScalingTaskGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	WithGrace          requests.Boolean `position:"Query" name:"WithGrace"`
	ClusterId          string           `position:"Query" name:"ClusterId"`
	MinSize            requests.Integer `position:"Query" name:"MinSize"`
	TimeoutWithGrace   requests.Integer `position:"Query" name:"TimeoutWithGrace"`
	HostGroupId        string           `position:"Query" name:"HostGroupId"`
	ActiveRuleCategory string           `position:"Query" name:"ActiveRuleCategory"`
	MaxSize            requests.Integer `position:"Query" name:"MaxSize"`
	DefaultCooldown    requests.Integer `position:"Query" name:"DefaultCooldown"`
}

// ModifyScalingTaskGroupResponse is the response struct for api ModifyScalingTaskGroup
type ModifyScalingTaskGroupResponse struct {
	*responses.BaseResponse
	HostGroupId string `json:"HostGroupId" xml:"HostGroupId"`
}

// CreateModifyScalingTaskGroupRequest creates a request to invoke ModifyScalingTaskGroup API
func CreateModifyScalingTaskGroupRequest() (request *ModifyScalingTaskGroupRequest) {
	request = &ModifyScalingTaskGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyScalingTaskGroup", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyScalingTaskGroupResponse creates a response to parse from ModifyScalingTaskGroup response
func CreateModifyScalingTaskGroupResponse() (response *ModifyScalingTaskGroupResponse) {
	response = &ModifyScalingTaskGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
