package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLibraryStatus invokes the emr.ListLibraryStatus API synchronously
func (client *Client) ListLibraryStatus(request *ListLibraryStatusRequest) (response *ListLibraryStatusResponse, err error) {
	response = CreateListLibraryStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListLibraryStatusWithChan invokes the emr.ListLibraryStatus API asynchronously
func (client *Client) ListLibraryStatusWithChan(request *ListLibraryStatusRequest) (<-chan *ListLibraryStatusResponse, <-chan error) {
	responseChan := make(chan *ListLibraryStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLibraryStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLibraryStatusWithCallback invokes the emr.ListLibraryStatus API asynchronously
func (client *Client) ListLibraryStatusWithCallback(request *ListLibraryStatusRequest, callback func(response *ListLibraryStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLibraryStatusResponse
		var err error
		defer close(result)
		response, err = client.ListLibraryStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLibraryStatusRequest is the request struct for api ListLibraryStatus
type ListLibraryStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageCount       requests.Integer `position:"Query" name:"PageCount"`
	OrderMode       string           `position:"Query" name:"OrderMode"`
	ClusterBizId    string           `position:"Query" name:"ClusterBizId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	Limit           requests.Integer `position:"Query" name:"Limit"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
	OrderField      string           `position:"Query" name:"OrderField"`
	LibraryBizId    string           `position:"Query" name:"LibraryBizId"`
}

// ListLibraryStatusResponse is the response struct for api ListLibraryStatus
type ListLibraryStatusResponse struct {
	*responses.BaseResponse
	RequestId  string                   `json:"RequestId" xml:"RequestId"`
	PageNumber int                      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                      `json:"PageSize" xml:"PageSize"`
	TotalCount int                      `json:"TotalCount" xml:"TotalCount"`
	NextToken  string                   `json:"NextToken" xml:"NextToken"`
	Items      ItemsInListLibraryStatus `json:"Items" xml:"Items"`
}

// CreateListLibraryStatusRequest creates a request to invoke ListLibraryStatus API
func CreateListLibraryStatusRequest() (request *ListLibraryStatusRequest) {
	request = &ListLibraryStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListLibraryStatus", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLibraryStatusResponse creates a response to parse from ListLibraryStatus response
func CreateListLibraryStatusResponse() (response *ListLibraryStatusResponse) {
	response = &ListLibraryStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
