package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLibraries invokes the emr.ListLibraries API synchronously
func (client *Client) ListLibraries(request *ListLibrariesRequest) (response *ListLibrariesResponse, err error) {
	response = CreateListLibrariesResponse()
	err = client.DoAction(request, response)
	return
}

// ListLibrariesWithChan invokes the emr.ListLibraries API asynchronously
func (client *Client) ListLibrariesWithChan(request *ListLibrariesRequest) (<-chan *ListLibrariesResponse, <-chan error) {
	responseChan := make(chan *ListLibrariesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLibraries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLibrariesWithCallback invokes the emr.ListLibraries API asynchronously
func (client *Client) ListLibrariesWithCallback(request *ListLibrariesRequest, callback func(response *ListLibrariesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLibrariesResponse
		var err error
		defer close(result)
		response, err = client.ListLibraries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLibrariesRequest is the request struct for api ListLibraries
type ListLibrariesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageCount       requests.Integer `position:"Query" name:"PageCount"`
	OrderMode       string           `position:"Query" name:"OrderMode"`
	ClusterBizId    string           `position:"Query" name:"ClusterBizId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	Limit           requests.Integer `position:"Query" name:"Limit"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
	OrderField      string           `position:"Query" name:"OrderField"`
}

// ListLibrariesResponse is the response struct for api ListLibraries
type ListLibrariesResponse struct {
	*responses.BaseResponse
	RequestId  string               `json:"RequestId" xml:"RequestId"`
	PageNumber int                  `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                  `json:"PageSize" xml:"PageSize"`
	TotalCount int                  `json:"TotalCount" xml:"TotalCount"`
	NextToken  string               `json:"NextToken" xml:"NextToken"`
	Items      ItemsInListLibraries `json:"Items" xml:"Items"`
}

// CreateListLibrariesRequest creates a request to invoke ListLibraries API
func CreateListLibrariesRequest() (request *ListLibrariesRequest) {
	request = &ListLibrariesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListLibraries", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLibrariesResponse creates a response to parse from ListLibraries response
func CreateListLibrariesResponse() (response *ListLibrariesResponse) {
	response = &ListLibrariesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
