package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBackups invokes the emr.ListBackups API synchronously
func (client *Client) ListBackups(request *ListBackupsRequest) (response *ListBackupsResponse, err error) {
	response = CreateListBackupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListBackupsWithChan invokes the emr.ListBackups API asynchronously
func (client *Client) ListBackupsWithChan(request *ListBackupsRequest) (<-chan *ListBackupsResponse, <-chan error) {
	responseChan := make(chan *ListBackupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBackups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBackupsWithCallback invokes the emr.ListBackups API asynchronously
func (client *Client) ListBackupsWithCallback(request *ListBackupsRequest, callback func(response *ListBackupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBackupsResponse
		var err error
		defer close(result)
		response, err = client.ListBackups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBackupsRequest is the request struct for api ListBackups
type ListBackupsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageCount       requests.Integer `position:"Query" name:"PageCount"`
	OrderMode       string           `position:"Query" name:"OrderMode"`
	BackupPlanId    string           `position:"Query" name:"BackupPlanId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	Limit           requests.Integer `position:"Query" name:"Limit"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	Id              requests.Integer `position:"Query" name:"Id"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
	BackupId        *[]string        `position:"Query" name:"BackupId"  type:"Repeated"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	MetadataType    string           `position:"Query" name:"MetadataType"`
	BizId           string           `position:"Query" name:"BizId"`
	Status          string           `position:"Query" name:"Status"`
}

// ListBackupsResponse is the response struct for api ListBackups
type ListBackupsResponse struct {
	*responses.BaseResponse
	RequestId  string             `json:"RequestId" xml:"RequestId"`
	PageNumber int                `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                `json:"PageSize" xml:"PageSize"`
	TotalCount int                `json:"TotalCount" xml:"TotalCount"`
	Items      ItemsInListBackups `json:"Items" xml:"Items"`
}

// CreateListBackupsRequest creates a request to invoke ListBackups API
func CreateListBackupsRequest() (request *ListBackupsRequest) {
	request = &ListBackupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListBackups", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListBackupsResponse creates a response to parse from ListBackups response
func CreateListBackupsResponse() (response *ListBackupsResponse) {
	response = &ListBackupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
