package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteScalingRule invokes the emr.DeleteScalingRule API synchronously
func (client *Client) DeleteScalingRule(request *DeleteScalingRuleRequest) (response *DeleteScalingRuleResponse, err error) {
	response = CreateDeleteScalingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteScalingRuleWithChan invokes the emr.DeleteScalingRule API asynchronously
func (client *Client) DeleteScalingRuleWithChan(request *DeleteScalingRuleRequest) (<-chan *DeleteScalingRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteScalingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteScalingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteScalingRuleWithCallback invokes the emr.DeleteScalingRule API asynchronously
func (client *Client) DeleteScalingRuleWithCallback(request *DeleteScalingRuleRequest, callback func(response *DeleteScalingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteScalingRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteScalingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteScalingRuleRequest is the request struct for api DeleteScalingRule
type DeleteScalingRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ScalingRuleId   string           `position:"Query" name:"ScalingRuleId"`
	HostGroupId     string           `position:"Query" name:"HostGroupId"`
}

// DeleteScalingRuleResponse is the response struct for api DeleteScalingRule
type DeleteScalingRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteScalingRuleRequest creates a request to invoke DeleteScalingRule API
func CreateDeleteScalingRuleRequest() (request *DeleteScalingRuleRequest) {
	request = &DeleteScalingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteScalingRule", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteScalingRuleResponse creates a response to parse from DeleteScalingRule response
func CreateDeleteScalingRuleResponse() (response *DeleteScalingRuleResponse) {
	response = &DeleteScalingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
