package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateScalingRule invokes the emr.CreateScalingRule API synchronously
func (client *Client) CreateScalingRule(request *CreateScalingRuleRequest) (response *CreateScalingRuleResponse, err error) {
	response = CreateCreateScalingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateScalingRuleWithChan invokes the emr.CreateScalingRule API asynchronously
func (client *Client) CreateScalingRuleWithChan(request *CreateScalingRuleRequest) (<-chan *CreateScalingRuleResponse, <-chan error) {
	responseChan := make(chan *CreateScalingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateScalingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateScalingRuleWithCallback invokes the emr.CreateScalingRule API asynchronously
func (client *Client) CreateScalingRuleWithCallback(request *CreateScalingRuleRequest, callback func(response *CreateScalingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateScalingRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateScalingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateScalingRuleRequest is the request struct for api CreateScalingRule
type CreateScalingRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	RuleName             string                                `position:"Query" name:"RuleName"`
	RecurrenceEndTime    string                                `position:"Query" name:"RecurrenceEndTime"`
	CloudWatchTrigger    *[]CreateScalingRuleCloudWatchTrigger `position:"Query" name:"CloudWatchTrigger"  type:"Repeated"`
	TimeoutWithGrace     requests.Integer                      `position:"Query" name:"TimeoutWithGrace"`
	Cooldown             requests.Integer                      `position:"Query" name:"Cooldown"`
	LaunchTime           string                                `position:"Query" name:"LaunchTime"`
	WithGrace            requests.Boolean                      `position:"Query" name:"WithGrace"`
	RuleCategory         string                                `position:"Query" name:"RuleCategory"`
	AdjustmentValue      requests.Integer                      `position:"Query" name:"AdjustmentValue"`
	AdjustmentType       string                                `position:"Query" name:"AdjustmentType"`
	ClusterId            string                                `position:"Query" name:"ClusterId"`
	LaunchExpirationTime requests.Integer                      `position:"Query" name:"LaunchExpirationTime"`
	RecurrenceValue      string                                `position:"Query" name:"RecurrenceValue"`
	HostGroupId          string                                `position:"Query" name:"HostGroupId"`
	SchedulerTrigger     *[]CreateScalingRuleSchedulerTrigger  `position:"Query" name:"SchedulerTrigger"  type:"Repeated"`
	RecurrenceType       string                                `position:"Query" name:"RecurrenceType"`
}

// CreateScalingRuleCloudWatchTrigger is a repeated param struct in CreateScalingRuleRequest
type CreateScalingRuleCloudWatchTrigger struct {
	Period             string `name:"Period"`
	EvaluationCount    string `name:"EvaluationCount"`
	Threshold          string `name:"Threshold"`
	MetricName         string `name:"MetricName"`
	ComparisonOperator string `name:"ComparisonOperator"`
	Statistics         string `name:"Statistics"`
}

// CreateScalingRuleSchedulerTrigger is a repeated param struct in CreateScalingRuleRequest
type CreateScalingRuleSchedulerTrigger struct {
	LaunchTime           string `name:"LaunchTime"`
	LaunchExpirationTime string `name:"LaunchExpirationTime"`
	RecurrenceValue      string `name:"RecurrenceValue"`
	RecurrenceEndTime    string `name:"RecurrenceEndTime"`
	RecurrenceType       string `name:"RecurrenceType"`
}

// CreateScalingRuleResponse is the response struct for api CreateScalingRule
type CreateScalingRuleResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ScalingRuleId string `json:"ScalingRuleId" xml:"ScalingRuleId"`
}

// CreateCreateScalingRuleRequest creates a request to invoke CreateScalingRule API
func CreateCreateScalingRuleRequest() (request *CreateScalingRuleRequest) {
	request = &CreateScalingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateScalingRule", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateScalingRuleResponse creates a response to parse from CreateScalingRule response
func CreateCreateScalingRuleResponse() (response *CreateScalingRuleResponse) {
	response = &CreateScalingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
