package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateClusterBootstrapAction invokes the emr.CreateClusterBootstrapAction API synchronously
func (client *Client) CreateClusterBootstrapAction(request *CreateClusterBootstrapActionRequest) (response *CreateClusterBootstrapActionResponse, err error) {
	response = CreateCreateClusterBootstrapActionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateClusterBootstrapActionWithChan invokes the emr.CreateClusterBootstrapAction API asynchronously
func (client *Client) CreateClusterBootstrapActionWithChan(request *CreateClusterBootstrapActionRequest) (<-chan *CreateClusterBootstrapActionResponse, <-chan error) {
	responseChan := make(chan *CreateClusterBootstrapActionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateClusterBootstrapAction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClusterBootstrapActionWithCallback invokes the emr.CreateClusterBootstrapAction API asynchronously
func (client *Client) CreateClusterBootstrapActionWithCallback(request *CreateClusterBootstrapActionRequest, callback func(response *CreateClusterBootstrapActionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClusterBootstrapActionResponse
		var err error
		defer close(result)
		response, err = client.CreateClusterBootstrapAction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClusterBootstrapActionRequest is the request struct for api CreateClusterBootstrapAction
type CreateClusterBootstrapActionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer                               `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string                                         `position:"Query" name:"ClusterId"`
	BootstrapAction *[]CreateClusterBootstrapActionBootstrapAction `position:"Query" name:"BootstrapAction"  type:"Repeated"`
}

// CreateClusterBootstrapActionBootstrapAction is a repeated param struct in CreateClusterBootstrapActionRequest
type CreateClusterBootstrapActionBootstrapAction struct {
	Path                  string `name:"Path"`
	ExecutionTarget       string `name:"ExecutionTarget"`
	ExecutionMoment       string `name:"ExecutionMoment"`
	Arg                   string `name:"Arg"`
	Name                  string `name:"Name"`
	ExecutionFailStrategy string `name:"ExecutionFailStrategy"`
}

// CreateClusterBootstrapActionResponse is the response struct for api CreateClusterBootstrapAction
type CreateClusterBootstrapActionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateClusterBootstrapActionRequest creates a request to invoke CreateClusterBootstrapAction API
func CreateCreateClusterBootstrapActionRequest() (request *CreateClusterBootstrapActionRequest) {
	request = &CreateClusterBootstrapActionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateClusterBootstrapAction", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateClusterBootstrapActionResponse creates a response to parse from CreateClusterBootstrapAction response
func CreateCreateClusterBootstrapActionResponse() (response *CreateClusterBootstrapActionResponse) {
	response = &CreateClusterBootstrapActionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
