package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePrefixListAttributes invokes the ecs.DescribePrefixListAttributes API synchronously
func (client *Client) DescribePrefixListAttributes(request *DescribePrefixListAttributesRequest) (response *DescribePrefixListAttributesResponse, err error) {
	response = CreateDescribePrefixListAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePrefixListAttributesWithChan invokes the ecs.DescribePrefixListAttributes API asynchronously
func (client *Client) DescribePrefixListAttributesWithChan(request *DescribePrefixListAttributesRequest) (<-chan *DescribePrefixListAttributesResponse, <-chan error) {
	responseChan := make(chan *DescribePrefixListAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePrefixListAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePrefixListAttributesWithCallback invokes the ecs.DescribePrefixListAttributes API asynchronously
func (client *Client) DescribePrefixListAttributesWithCallback(request *DescribePrefixListAttributesRequest, callback func(response *DescribePrefixListAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePrefixListAttributesResponse
		var err error
		defer close(result)
		response, err = client.DescribePrefixListAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePrefixListAttributesRequest is the request struct for api DescribePrefixListAttributes
type DescribePrefixListAttributesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PrefixListId         string           `position:"Query" name:"PrefixListId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribePrefixListAttributesResponse is the response struct for api DescribePrefixListAttributes
type DescribePrefixListAttributesResponse struct {
	*responses.BaseResponse
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	PrefixListId   string  `json:"PrefixListId" xml:"PrefixListId"`
	PrefixListName string  `json:"PrefixListName" xml:"PrefixListName"`
	AddressFamily  string  `json:"AddressFamily" xml:"AddressFamily"`
	MaxEntries     int     `json:"MaxEntries" xml:"MaxEntries"`
	Description    string  `json:"Description" xml:"Description"`
	CreationTime   string  `json:"CreationTime" xml:"CreationTime"`
	Entries        Entries `json:"Entries" xml:"Entries"`
}

// CreateDescribePrefixListAttributesRequest creates a request to invoke DescribePrefixListAttributes API
func CreateDescribePrefixListAttributesRequest() (request *DescribePrefixListAttributesRequest) {
	request = &DescribePrefixListAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribePrefixListAttributes", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePrefixListAttributesResponse creates a response to parse from DescribePrefixListAttributes response
func CreateDescribePrefixListAttributesResponse() (response *DescribePrefixListAttributesResponse) {
	response = &DescribePrefixListAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
