package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePrefixListAssociations invokes the ecs.DescribePrefixListAssociations API synchronously
func (client *Client) DescribePrefixListAssociations(request *DescribePrefixListAssociationsRequest) (response *DescribePrefixListAssociationsResponse, err error) {
	response = CreateDescribePrefixListAssociationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePrefixListAssociationsWithChan invokes the ecs.DescribePrefixListAssociations API asynchronously
func (client *Client) DescribePrefixListAssociationsWithChan(request *DescribePrefixListAssociationsRequest) (<-chan *DescribePrefixListAssociationsResponse, <-chan error) {
	responseChan := make(chan *DescribePrefixListAssociationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePrefixListAssociations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePrefixListAssociationsWithCallback invokes the ecs.DescribePrefixListAssociations API asynchronously
func (client *Client) DescribePrefixListAssociationsWithCallback(request *DescribePrefixListAssociationsRequest, callback func(response *DescribePrefixListAssociationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePrefixListAssociationsResponse
		var err error
		defer close(result)
		response, err = client.DescribePrefixListAssociations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePrefixListAssociationsRequest is the request struct for api DescribePrefixListAssociations
type DescribePrefixListAssociationsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PrefixListId         string           `position:"Query" name:"PrefixListId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribePrefixListAssociationsResponse is the response struct for api DescribePrefixListAssociations
type DescribePrefixListAssociationsResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	NextToken              string                 `json:"NextToken" xml:"NextToken"`
	PrefixListAssociations PrefixListAssociations `json:"PrefixListAssociations" xml:"PrefixListAssociations"`
}

// CreateDescribePrefixListAssociationsRequest creates a request to invoke DescribePrefixListAssociations API
func CreateDescribePrefixListAssociationsRequest() (request *DescribePrefixListAssociationsRequest) {
	request = &DescribePrefixListAssociationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribePrefixListAssociations", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePrefixListAssociationsResponse creates a response to parse from DescribePrefixListAssociations response
func CreateDescribePrefixListAssociationsResponse() (response *DescribePrefixListAssociationsResponse) {
	response = &DescribePrefixListAssociationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
