package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DestroyInstance invokes the dds.DestroyInstance API synchronously
func (client *Client) DestroyInstance(request *DestroyInstanceRequest) (response *DestroyInstanceResponse, err error) {
	response = CreateDestroyInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DestroyInstanceWithChan invokes the dds.DestroyInstance API asynchronously
func (client *Client) DestroyInstanceWithChan(request *DestroyInstanceRequest) (<-chan *DestroyInstanceResponse, <-chan error) {
	responseChan := make(chan *DestroyInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DestroyInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DestroyInstanceWithCallback invokes the dds.DestroyInstance API asynchronously
func (client *Client) DestroyInstanceWithCallback(request *DestroyInstanceRequest, callback func(response *DestroyInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DestroyInstanceResponse
		var err error
		defer close(result)
		response, err = client.DestroyInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DestroyInstanceRequest is the request struct for api DestroyInstance
type DestroyInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// DestroyInstanceResponse is the response struct for api DestroyInstance
type DestroyInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDestroyInstanceRequest creates a request to invoke DestroyInstance API
func CreateDestroyInstanceRequest() (request *DestroyInstanceRequest) {
	request = &DestroyInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DestroyInstance", "Dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDestroyInstanceResponse creates a response to parse from DestroyInstance response
func CreateDestroyInstanceResponse() (response *DestroyInstanceResponse) {
	response = &DestroyInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
