package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMongoDBLogConfig invokes the dds.DescribeMongoDBLogConfig API synchronously
func (client *Client) DescribeMongoDBLogConfig(request *DescribeMongoDBLogConfigRequest) (response *DescribeMongoDBLogConfigResponse, err error) {
	response = CreateDescribeMongoDBLogConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMongoDBLogConfigWithChan invokes the dds.DescribeMongoDBLogConfig API asynchronously
func (client *Client) DescribeMongoDBLogConfigWithChan(request *DescribeMongoDBLogConfigRequest) (<-chan *DescribeMongoDBLogConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeMongoDBLogConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMongoDBLogConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMongoDBLogConfigWithCallback invokes the dds.DescribeMongoDBLogConfig API asynchronously
func (client *Client) DescribeMongoDBLogConfigWithCallback(request *DescribeMongoDBLogConfigRequest, callback func(response *DescribeMongoDBLogConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMongoDBLogConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeMongoDBLogConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMongoDBLogConfigRequest is the request struct for api DescribeMongoDBLogConfig
type DescribeMongoDBLogConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeMongoDBLogConfigResponse is the response struct for api DescribeMongoDBLogConfig
type DescribeMongoDBLogConfigResponse struct {
	*responses.BaseResponse
	RequestId                  string `json:"RequestId" xml:"RequestId"`
	UserProjectName            string `json:"UserProjectName" xml:"UserProjectName"`
	IsUserProjectLogstoreExist int    `json:"IsUserProjectLogstoreExist" xml:"IsUserProjectLogstoreExist"`
	IsEtlMetaExist             int    `json:"IsEtlMetaExist" xml:"IsEtlMetaExist"`
}

// CreateDescribeMongoDBLogConfigRequest creates a request to invoke DescribeMongoDBLogConfig API
func CreateDescribeMongoDBLogConfigRequest() (request *DescribeMongoDBLogConfigRequest) {
	request = &DescribeMongoDBLogConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeMongoDBLogConfig", "Dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMongoDBLogConfigResponse creates a response to parse from DescribeMongoDBLogConfig response
func CreateDescribeMongoDBLogConfigResponse() (response *DescribeMongoDBLogConfigResponse) {
	response = &DescribeMongoDBLogConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
