package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyElasticBandWidth invokes the ddoscoo.ModifyElasticBandWidth API synchronously
func (client *Client) ModifyElasticBandWidth(request *ModifyElasticBandWidthRequest) (response *ModifyElasticBandWidthResponse, err error) {
	response = CreateModifyElasticBandWidthResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyElasticBandWidthWithChan invokes the ddoscoo.ModifyElasticBandWidth API asynchronously
func (client *Client) ModifyElasticBandWidthWithChan(request *ModifyElasticBandWidthRequest) (<-chan *ModifyElasticBandWidthResponse, <-chan error) {
	responseChan := make(chan *ModifyElasticBandWidthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyElasticBandWidth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyElasticBandWidthWithCallback invokes the ddoscoo.ModifyElasticBandWidth API asynchronously
func (client *Client) ModifyElasticBandWidthWithCallback(request *ModifyElasticBandWidthRequest, callback func(response *ModifyElasticBandWidthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyElasticBandWidthResponse
		var err error
		defer close(result)
		response, err = client.ModifyElasticBandWidth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyElasticBandWidthRequest is the request struct for api ModifyElasticBandWidth
type ModifyElasticBandWidthRequest struct {
	*requests.RpcRequest
	InstanceId       string           `position:"Query" name:"InstanceId"`
	SourceIp         string           `position:"Query" name:"SourceIp"`
	ElasticBandwidth requests.Integer `position:"Query" name:"ElasticBandwidth"`
}

// ModifyElasticBandWidthResponse is the response struct for api ModifyElasticBandWidth
type ModifyElasticBandWidthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyElasticBandWidthRequest creates a request to invoke ModifyElasticBandWidth API
func CreateModifyElasticBandWidthRequest() (request *ModifyElasticBandWidthRequest) {
	request = &ModifyElasticBandWidthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyElasticBandWidth", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyElasticBandWidthResponse creates a response to parse from ModifyElasticBandWidth response
func CreateModifyElasticBandWidthResponse() (response *ModifyElasticBandWidthResponse) {
	response = &ModifyElasticBandWidthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
