package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBlackholeStatus invokes the ddoscoo.DescribeBlackholeStatus API synchronously
func (client *Client) DescribeBlackholeStatus(request *DescribeBlackholeStatusRequest) (response *DescribeBlackholeStatusResponse, err error) {
	response = CreateDescribeBlackholeStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBlackholeStatusWithChan invokes the ddoscoo.DescribeBlackholeStatus API asynchronously
func (client *Client) DescribeBlackholeStatusWithChan(request *DescribeBlackholeStatusRequest) (<-chan *DescribeBlackholeStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeBlackholeStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBlackholeStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBlackholeStatusWithCallback invokes the ddoscoo.DescribeBlackholeStatus API asynchronously
func (client *Client) DescribeBlackholeStatusWithCallback(request *DescribeBlackholeStatusRequest, callback func(response *DescribeBlackholeStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBlackholeStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeBlackholeStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBlackholeStatusRequest is the request struct for api DescribeBlackholeStatus
type DescribeBlackholeStatusRequest struct {
	*requests.RpcRequest
	SourceIp    string    `position:"Query" name:"SourceIp"`
	InstanceIds *[]string `position:"Query" name:"InstanceIds"  type:"Repeated"`
}

// DescribeBlackholeStatusResponse is the response struct for api DescribeBlackholeStatus
type DescribeBlackholeStatusResponse struct {
	*responses.BaseResponse
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	BlackholeStatus []BlackholeStatusItem `json:"BlackholeStatus" xml:"BlackholeStatus"`
}

// CreateDescribeBlackholeStatusRequest creates a request to invoke DescribeBlackholeStatus API
func CreateDescribeBlackholeStatusRequest() (request *DescribeBlackholeStatusRequest) {
	request = &DescribeBlackholeStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeBlackholeStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeBlackholeStatusResponse creates a response to parse from DescribeBlackholeStatus response
func CreateDescribeBlackholeStatusResponse() (response *DescribeBlackholeStatusResponse) {
	response = &DescribeBlackholeStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
