package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateWebCert invokes the ddoscoo.AssociateWebCert API synchronously
func (client *Client) AssociateWebCert(request *AssociateWebCertRequest) (response *AssociateWebCertResponse, err error) {
	response = CreateAssociateWebCertResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateWebCertWithChan invokes the ddoscoo.AssociateWebCert API asynchronously
func (client *Client) AssociateWebCertWithChan(request *AssociateWebCertRequest) (<-chan *AssociateWebCertResponse, <-chan error) {
	responseChan := make(chan *AssociateWebCertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateWebCert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateWebCertWithCallback invokes the ddoscoo.AssociateWebCert API asynchronously
func (client *Client) AssociateWebCertWithCallback(request *AssociateWebCertRequest, callback func(response *AssociateWebCertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateWebCertResponse
		var err error
		defer close(result)
		response, err = client.AssociateWebCert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateWebCertRequest is the request struct for api AssociateWebCert
type AssociateWebCertRequest struct {
	*requests.RpcRequest
	Cert            string           `position:"Query" name:"Cert"`
	CertId          requests.Integer `position:"Query" name:"CertId"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Key             string           `position:"Query" name:"Key"`
	CertName        string           `position:"Query" name:"CertName"`
	Domain          string           `position:"Query" name:"Domain"`
}

// AssociateWebCertResponse is the response struct for api AssociateWebCert
type AssociateWebCertResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociateWebCertRequest creates a request to invoke AssociateWebCert API
func CreateAssociateWebCertRequest() (request *AssociateWebCertRequest) {
	request = &AssociateWebCertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "AssociateWebCert", "", "")
	request.Method = requests.POST
	return
}

// CreateAssociateWebCertResponse creates a response to parse from AssociateWebCert response
func CreateAssociateWebCertResponse() (response *AssociateWebCertResponse) {
	response = &AssociateWebCertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
