package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDcdnDeliverTask invokes the dcdn.UpdateDcdnDeliverTask API synchronously
func (client *Client) UpdateDcdnDeliverTask(request *UpdateDcdnDeliverTaskRequest) (response *UpdateDcdnDeliverTaskResponse, err error) {
	response = CreateUpdateDcdnDeliverTaskResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDcdnDeliverTaskWithChan invokes the dcdn.UpdateDcdnDeliverTask API asynchronously
func (client *Client) UpdateDcdnDeliverTaskWithChan(request *UpdateDcdnDeliverTaskRequest) (<-chan *UpdateDcdnDeliverTaskResponse, <-chan error) {
	responseChan := make(chan *UpdateDcdnDeliverTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDcdnDeliverTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDcdnDeliverTaskWithCallback invokes the dcdn.UpdateDcdnDeliverTask API asynchronously
func (client *Client) UpdateDcdnDeliverTaskWithCallback(request *UpdateDcdnDeliverTaskRequest, callback func(response *UpdateDcdnDeliverTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDcdnDeliverTaskResponse
		var err error
		defer close(result)
		response, err = client.UpdateDcdnDeliverTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDcdnDeliverTaskRequest is the request struct for api UpdateDcdnDeliverTask
type UpdateDcdnDeliverTaskRequest struct {
	*requests.RpcRequest
	Reports    string           `position:"Body" name:"Reports"`
	Deliver    string           `position:"Body" name:"Deliver"`
	DeliverId  requests.Integer `position:"Body" name:"DeliverId"`
	DomainName string           `position:"Body" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Schedule   string           `position:"Body" name:"Schedule"`
	Name       string           `position:"Body" name:"Name"`
	Status     string           `position:"Body" name:"Status"`
}

// UpdateDcdnDeliverTaskResponse is the response struct for api UpdateDcdnDeliverTask
type UpdateDcdnDeliverTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDcdnDeliverTaskRequest creates a request to invoke UpdateDcdnDeliverTask API
func CreateUpdateDcdnDeliverTaskRequest() (request *UpdateDcdnDeliverTaskRequest) {
	request = &UpdateDcdnDeliverTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "UpdateDcdnDeliverTask", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDcdnDeliverTaskResponse creates a response to parse from UpdateDcdnDeliverTask response
func CreateUpdateDcdnDeliverTaskResponse() (response *UpdateDcdnDeliverTaskResponse) {
	response = &UpdateDcdnDeliverTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
