package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableDcdnDomainOfflineLogDelivery invokes the dcdn.EnableDcdnDomainOfflineLogDelivery API synchronously
func (client *Client) EnableDcdnDomainOfflineLogDelivery(request *EnableDcdnDomainOfflineLogDeliveryRequest) (response *EnableDcdnDomainOfflineLogDeliveryResponse, err error) {
	response = CreateEnableDcdnDomainOfflineLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// EnableDcdnDomainOfflineLogDeliveryWithChan invokes the dcdn.EnableDcdnDomainOfflineLogDelivery API asynchronously
func (client *Client) EnableDcdnDomainOfflineLogDeliveryWithChan(request *EnableDcdnDomainOfflineLogDeliveryRequest) (<-chan *EnableDcdnDomainOfflineLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *EnableDcdnDomainOfflineLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableDcdnDomainOfflineLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableDcdnDomainOfflineLogDeliveryWithCallback invokes the dcdn.EnableDcdnDomainOfflineLogDelivery API asynchronously
func (client *Client) EnableDcdnDomainOfflineLogDeliveryWithCallback(request *EnableDcdnDomainOfflineLogDeliveryRequest, callback func(response *EnableDcdnDomainOfflineLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableDcdnDomainOfflineLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.EnableDcdnDomainOfflineLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableDcdnDomainOfflineLogDeliveryRequest is the request struct for api EnableDcdnDomainOfflineLogDelivery
type EnableDcdnDomainOfflineLogDeliveryRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Body" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// EnableDcdnDomainOfflineLogDeliveryResponse is the response struct for api EnableDcdnDomainOfflineLogDelivery
type EnableDcdnDomainOfflineLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableDcdnDomainOfflineLogDeliveryRequest creates a request to invoke EnableDcdnDomainOfflineLogDelivery API
func CreateEnableDcdnDomainOfflineLogDeliveryRequest() (request *EnableDcdnDomainOfflineLogDeliveryRequest) {
	request = &EnableDcdnDomainOfflineLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "EnableDcdnDomainOfflineLogDelivery", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableDcdnDomainOfflineLogDeliveryResponse creates a response to parse from EnableDcdnDomainOfflineLogDelivery response
func CreateEnableDcdnDomainOfflineLogDeliveryResponse() (response *EnableDcdnDomainOfflineLogDeliveryResponse) {
	response = &EnableDcdnDomainOfflineLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
