package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableDcdnDomainOfflineLogDelivery invokes the dcdn.DisableDcdnDomainOfflineLogDelivery API synchronously
func (client *Client) DisableDcdnDomainOfflineLogDelivery(request *DisableDcdnDomainOfflineLogDeliveryRequest) (response *DisableDcdnDomainOfflineLogDeliveryResponse, err error) {
	response = CreateDisableDcdnDomainOfflineLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// DisableDcdnDomainOfflineLogDeliveryWithChan invokes the dcdn.DisableDcdnDomainOfflineLogDelivery API asynchronously
func (client *Client) DisableDcdnDomainOfflineLogDeliveryWithChan(request *DisableDcdnDomainOfflineLogDeliveryRequest) (<-chan *DisableDcdnDomainOfflineLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *DisableDcdnDomainOfflineLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableDcdnDomainOfflineLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableDcdnDomainOfflineLogDeliveryWithCallback invokes the dcdn.DisableDcdnDomainOfflineLogDelivery API asynchronously
func (client *Client) DisableDcdnDomainOfflineLogDeliveryWithCallback(request *DisableDcdnDomainOfflineLogDeliveryRequest, callback func(response *DisableDcdnDomainOfflineLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableDcdnDomainOfflineLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.DisableDcdnDomainOfflineLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableDcdnDomainOfflineLogDeliveryRequest is the request struct for api DisableDcdnDomainOfflineLogDelivery
type DisableDcdnDomainOfflineLogDeliveryRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Body" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DisableDcdnDomainOfflineLogDeliveryResponse is the response struct for api DisableDcdnDomainOfflineLogDelivery
type DisableDcdnDomainOfflineLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableDcdnDomainOfflineLogDeliveryRequest creates a request to invoke DisableDcdnDomainOfflineLogDelivery API
func CreateDisableDcdnDomainOfflineLogDeliveryRequest() (request *DisableDcdnDomainOfflineLogDeliveryRequest) {
	request = &DisableDcdnDomainOfflineLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DisableDcdnDomainOfflineLogDelivery", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableDcdnDomainOfflineLogDeliveryResponse creates a response to parse from DisableDcdnDomainOfflineLogDelivery response
func CreateDisableDcdnDomainOfflineLogDeliveryResponse() (response *DisableDcdnDomainOfflineLogDeliveryResponse) {
	response = &DisableDcdnDomainOfflineLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
