package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainWebsocketHttpCodeData invokes the dcdn.DescribeDcdnDomainWebsocketHttpCodeData API synchronously
func (client *Client) DescribeDcdnDomainWebsocketHttpCodeData(request *DescribeDcdnDomainWebsocketHttpCodeDataRequest) (response *DescribeDcdnDomainWebsocketHttpCodeDataResponse, err error) {
	response = CreateDescribeDcdnDomainWebsocketHttpCodeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainWebsocketHttpCodeDataWithChan invokes the dcdn.DescribeDcdnDomainWebsocketHttpCodeData API asynchronously
func (client *Client) DescribeDcdnDomainWebsocketHttpCodeDataWithChan(request *DescribeDcdnDomainWebsocketHttpCodeDataRequest) (<-chan *DescribeDcdnDomainWebsocketHttpCodeDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainWebsocketHttpCodeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainWebsocketHttpCodeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainWebsocketHttpCodeDataWithCallback invokes the dcdn.DescribeDcdnDomainWebsocketHttpCodeData API asynchronously
func (client *Client) DescribeDcdnDomainWebsocketHttpCodeDataWithCallback(request *DescribeDcdnDomainWebsocketHttpCodeDataRequest, callback func(response *DescribeDcdnDomainWebsocketHttpCodeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainWebsocketHttpCodeDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainWebsocketHttpCodeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainWebsocketHttpCodeDataRequest is the request struct for api DescribeDcdnDomainWebsocketHttpCodeData
type DescribeDcdnDomainWebsocketHttpCodeDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Interval       string           `position:"Query" name:"Interval"`
}

// DescribeDcdnDomainWebsocketHttpCodeDataResponse is the response struct for api DescribeDcdnDomainWebsocketHttpCodeData
type DescribeDcdnDomainWebsocketHttpCodeDataResponse struct {
	*responses.BaseResponse
	RequestId       string                                                   `json:"RequestId" xml:"RequestId"`
	DomainName      string                                                   `json:"DomainName" xml:"DomainName"`
	StartTime       string                                                   `json:"StartTime" xml:"StartTime"`
	EndTime         string                                                   `json:"EndTime" xml:"EndTime"`
	DataInterval    string                                                   `json:"DataInterval" xml:"DataInterval"`
	DataPerInterval DataPerIntervalInDescribeDcdnDomainWebsocketHttpCodeData `json:"DataPerInterval" xml:"DataPerInterval"`
}

// CreateDescribeDcdnDomainWebsocketHttpCodeDataRequest creates a request to invoke DescribeDcdnDomainWebsocketHttpCodeData API
func CreateDescribeDcdnDomainWebsocketHttpCodeDataRequest() (request *DescribeDcdnDomainWebsocketHttpCodeDataRequest) {
	request = &DescribeDcdnDomainWebsocketHttpCodeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainWebsocketHttpCodeData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainWebsocketHttpCodeDataResponse creates a response to parse from DescribeDcdnDomainWebsocketHttpCodeData response
func CreateDescribeDcdnDomainWebsocketHttpCodeDataResponse() (response *DescribeDcdnDomainWebsocketHttpCodeDataResponse) {
	response = &DescribeDcdnDomainWebsocketHttpCodeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
