package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTagValueList invokes the cms.DescribeTagValueList API synchronously
func (client *Client) DescribeTagValueList(request *DescribeTagValueListRequest) (response *DescribeTagValueListResponse, err error) {
	response = CreateDescribeTagValueListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTagValueListWithChan invokes the cms.DescribeTagValueList API asynchronously
func (client *Client) DescribeTagValueListWithChan(request *DescribeTagValueListRequest) (<-chan *DescribeTagValueListResponse, <-chan error) {
	responseChan := make(chan *DescribeTagValueListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTagValueList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTagValueListWithCallback invokes the cms.DescribeTagValueList API asynchronously
func (client *Client) DescribeTagValueListWithCallback(request *DescribeTagValueListRequest, callback func(response *DescribeTagValueListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTagValueListResponse
		var err error
		defer close(result)
		response, err = client.DescribeTagValueList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTagValueListRequest is the request struct for api DescribeTagValueList
type DescribeTagValueListRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	TagKey     string           `position:"Query" name:"TagKey"`
}

// DescribeTagValueListResponse is the response struct for api DescribeTagValueList
type DescribeTagValueListResponse struct {
	*responses.BaseResponse
	Code      string    `json:"Code" xml:"Code"`
	Message   string    `json:"Message" xml:"Message"`
	Success   bool      `json:"Success" xml:"Success"`
	RequestId string    `json:"RequestId" xml:"RequestId"`
	TagValues TagValues `json:"TagValues" xml:"TagValues"`
}

// CreateDescribeTagValueListRequest creates a request to invoke DescribeTagValueList API
func CreateDescribeTagValueListRequest() (request *DescribeTagValueListRequest) {
	request = &DescribeTagValueListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeTagValueList", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTagValueListResponse creates a response to parse from DescribeTagValueList response
func CreateDescribeTagValueListResponse() (response *DescribeTagValueListResponse) {
	response = &DescribeTagValueListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
