package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogMonitorAttribute invokes the cms.DescribeLogMonitorAttribute API synchronously
func (client *Client) DescribeLogMonitorAttribute(request *DescribeLogMonitorAttributeRequest) (response *DescribeLogMonitorAttributeResponse, err error) {
	response = CreateDescribeLogMonitorAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogMonitorAttributeWithChan invokes the cms.DescribeLogMonitorAttribute API asynchronously
func (client *Client) DescribeLogMonitorAttributeWithChan(request *DescribeLogMonitorAttributeRequest) (<-chan *DescribeLogMonitorAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeLogMonitorAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogMonitorAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogMonitorAttributeWithCallback invokes the cms.DescribeLogMonitorAttribute API asynchronously
func (client *Client) DescribeLogMonitorAttributeWithCallback(request *DescribeLogMonitorAttributeRequest, callback func(response *DescribeLogMonitorAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogMonitorAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogMonitorAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogMonitorAttributeRequest is the request struct for api DescribeLogMonitorAttribute
type DescribeLogMonitorAttributeRequest struct {
	*requests.RpcRequest
	MetricName string `position:"Query" name:"MetricName"`
}

// DescribeLogMonitorAttributeResponse is the response struct for api DescribeLogMonitorAttribute
type DescribeLogMonitorAttributeResponse struct {
	*responses.BaseResponse
	Code       string     `json:"Code" xml:"Code"`
	Success    bool       `json:"Success" xml:"Success"`
	Message    string     `json:"Message" xml:"Message"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	LogMonitor LogMonitor `json:"LogMonitor" xml:"LogMonitor"`
}

// CreateDescribeLogMonitorAttributeRequest creates a request to invoke DescribeLogMonitorAttribute API
func CreateDescribeLogMonitorAttributeRequest() (request *DescribeLogMonitorAttributeRequest) {
	request = &DescribeLogMonitorAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeLogMonitorAttribute", "cms", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeLogMonitorAttributeResponse creates a response to parse from DescribeLogMonitorAttribute response
func CreateDescribeLogMonitorAttributeResponse() (response *DescribeLogMonitorAttributeResponse) {
	response = &DescribeLogMonitorAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
