package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTransitRouterPeerAttachmentAttribute invokes the cbn.UpdateTransitRouterPeerAttachmentAttribute API synchronously
func (client *Client) UpdateTransitRouterPeerAttachmentAttribute(request *UpdateTransitRouterPeerAttachmentAttributeRequest) (response *UpdateTransitRouterPeerAttachmentAttributeResponse, err error) {
	response = CreateUpdateTransitRouterPeerAttachmentAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTransitRouterPeerAttachmentAttributeWithChan invokes the cbn.UpdateTransitRouterPeerAttachmentAttribute API asynchronously
func (client *Client) UpdateTransitRouterPeerAttachmentAttributeWithChan(request *UpdateTransitRouterPeerAttachmentAttributeRequest) (<-chan *UpdateTransitRouterPeerAttachmentAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateTransitRouterPeerAttachmentAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTransitRouterPeerAttachmentAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTransitRouterPeerAttachmentAttributeWithCallback invokes the cbn.UpdateTransitRouterPeerAttachmentAttribute API asynchronously
func (client *Client) UpdateTransitRouterPeerAttachmentAttributeWithCallback(request *UpdateTransitRouterPeerAttachmentAttributeRequest, callback func(response *UpdateTransitRouterPeerAttachmentAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTransitRouterPeerAttachmentAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateTransitRouterPeerAttachmentAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTransitRouterPeerAttachmentAttributeRequest is the request struct for api UpdateTransitRouterPeerAttachmentAttribute
type UpdateTransitRouterPeerAttachmentAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                        string           `position:"Query" name:"ClientToken"`
	TransitRouterAttachmentName        string           `position:"Query" name:"TransitRouterAttachmentName"`
	AutoPublishRouteEnabled            requests.Boolean `position:"Query" name:"AutoPublishRouteEnabled"`
	DryRun                             requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount               string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth                          requests.Integer `position:"Query" name:"Bandwidth"`
	OwnerAccount                       string           `position:"Query" name:"OwnerAccount"`
	OwnerId                            requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType                       string           `position:"Query" name:"ResourceType"`
	TransitRouterAttachmentId          string           `position:"Query" name:"TransitRouterAttachmentId"`
	TransitRouterAttachmentDescription string           `position:"Query" name:"TransitRouterAttachmentDescription"`
	CenBandwidthPackageId              string           `position:"Query" name:"CenBandwidthPackageId"`
}

// UpdateTransitRouterPeerAttachmentAttributeResponse is the response struct for api UpdateTransitRouterPeerAttachmentAttribute
type UpdateTransitRouterPeerAttachmentAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTransitRouterPeerAttachmentAttributeRequest creates a request to invoke UpdateTransitRouterPeerAttachmentAttribute API
func CreateUpdateTransitRouterPeerAttachmentAttributeRequest() (request *UpdateTransitRouterPeerAttachmentAttributeRequest) {
	request = &UpdateTransitRouterPeerAttachmentAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "UpdateTransitRouterPeerAttachmentAttribute", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTransitRouterPeerAttachmentAttributeResponse creates a response to parse from UpdateTransitRouterPeerAttachmentAttribute response
func CreateUpdateTransitRouterPeerAttachmentAttributeResponse() (response *UpdateTransitRouterPeerAttachmentAttributeResponse) {
	response = &UpdateTransitRouterPeerAttachmentAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
