package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCenBandwidthPackageAttribute invokes the cbn.ModifyCenBandwidthPackageAttribute API synchronously
func (client *Client) ModifyCenBandwidthPackageAttribute(request *ModifyCenBandwidthPackageAttributeRequest) (response *ModifyCenBandwidthPackageAttributeResponse, err error) {
	response = CreateModifyCenBandwidthPackageAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCenBandwidthPackageAttributeWithChan invokes the cbn.ModifyCenBandwidthPackageAttribute API asynchronously
func (client *Client) ModifyCenBandwidthPackageAttributeWithChan(request *ModifyCenBandwidthPackageAttributeRequest) (<-chan *ModifyCenBandwidthPackageAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyCenBandwidthPackageAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCenBandwidthPackageAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCenBandwidthPackageAttributeWithCallback invokes the cbn.ModifyCenBandwidthPackageAttribute API asynchronously
func (client *Client) ModifyCenBandwidthPackageAttributeWithCallback(request *ModifyCenBandwidthPackageAttributeRequest, callback func(response *ModifyCenBandwidthPackageAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCenBandwidthPackageAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyCenBandwidthPackageAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCenBandwidthPackageAttributeRequest is the request struct for api ModifyCenBandwidthPackageAttribute
type ModifyCenBandwidthPackageAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Description           string           `position:"Query" name:"Description"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	CenBandwidthPackageId string           `position:"Query" name:"CenBandwidthPackageId"`
	Name                  string           `position:"Query" name:"Name"`
}

// ModifyCenBandwidthPackageAttributeResponse is the response struct for api ModifyCenBandwidthPackageAttribute
type ModifyCenBandwidthPackageAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCenBandwidthPackageAttributeRequest creates a request to invoke ModifyCenBandwidthPackageAttribute API
func CreateModifyCenBandwidthPackageAttributeRequest() (request *ModifyCenBandwidthPackageAttributeRequest) {
	request = &ModifyCenBandwidthPackageAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ModifyCenBandwidthPackageAttribute", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCenBandwidthPackageAttributeResponse creates a response to parse from ModifyCenBandwidthPackageAttribute response
func CreateModifyCenBandwidthPackageAttributeResponse() (response *ModifyCenBandwidthPackageAttributeResponse) {
	response = &ModifyCenBandwidthPackageAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
