package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTransitRouterRouteTable invokes the cbn.DeleteTransitRouterRouteTable API synchronously
func (client *Client) DeleteTransitRouterRouteTable(request *DeleteTransitRouterRouteTableRequest) (response *DeleteTransitRouterRouteTableResponse, err error) {
	response = CreateDeleteTransitRouterRouteTableResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTransitRouterRouteTableWithChan invokes the cbn.DeleteTransitRouterRouteTable API asynchronously
func (client *Client) DeleteTransitRouterRouteTableWithChan(request *DeleteTransitRouterRouteTableRequest) (<-chan *DeleteTransitRouterRouteTableResponse, <-chan error) {
	responseChan := make(chan *DeleteTransitRouterRouteTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTransitRouterRouteTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTransitRouterRouteTableWithCallback invokes the cbn.DeleteTransitRouterRouteTable API asynchronously
func (client *Client) DeleteTransitRouterRouteTableWithCallback(request *DeleteTransitRouterRouteTableRequest, callback func(response *DeleteTransitRouterRouteTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTransitRouterRouteTableResponse
		var err error
		defer close(result)
		response, err = client.DeleteTransitRouterRouteTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTransitRouterRouteTableRequest is the request struct for api DeleteTransitRouterRouteTable
type DeleteTransitRouterRouteTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken               string           `position:"Query" name:"ClientToken"`
	TransitRouterRouteTableId string           `position:"Query" name:"TransitRouterRouteTableId"`
	DryRun                    requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteTransitRouterRouteTableResponse is the response struct for api DeleteTransitRouterRouteTable
type DeleteTransitRouterRouteTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTransitRouterRouteTableRequest creates a request to invoke DeleteTransitRouterRouteTable API
func CreateDeleteTransitRouterRouteTableRequest() (request *DeleteTransitRouterRouteTableRequest) {
	request = &DeleteTransitRouterRouteTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DeleteTransitRouterRouteTable", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTransitRouterRouteTableResponse creates a response to parse from DeleteTransitRouterRouteTable response
func CreateDeleteTransitRouterRouteTableResponse() (response *DeleteTransitRouterRouteTableResponse) {
	response = &DeleteTransitRouterRouteTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
