package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTransitRouterVpcAttachment invokes the cbn.CreateTransitRouterVpcAttachment API synchronously
func (client *Client) CreateTransitRouterVpcAttachment(request *CreateTransitRouterVpcAttachmentRequest) (response *CreateTransitRouterVpcAttachmentResponse, err error) {
	response = CreateCreateTransitRouterVpcAttachmentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTransitRouterVpcAttachmentWithChan invokes the cbn.CreateTransitRouterVpcAttachment API asynchronously
func (client *Client) CreateTransitRouterVpcAttachmentWithChan(request *CreateTransitRouterVpcAttachmentRequest) (<-chan *CreateTransitRouterVpcAttachmentResponse, <-chan error) {
	responseChan := make(chan *CreateTransitRouterVpcAttachmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTransitRouterVpcAttachment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTransitRouterVpcAttachmentWithCallback invokes the cbn.CreateTransitRouterVpcAttachment API asynchronously
func (client *Client) CreateTransitRouterVpcAttachmentWithCallback(request *CreateTransitRouterVpcAttachmentRequest, callback func(response *CreateTransitRouterVpcAttachmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTransitRouterVpcAttachmentResponse
		var err error
		defer close(result)
		response, err = client.CreateTransitRouterVpcAttachment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTransitRouterVpcAttachmentRequest is the request struct for api CreateTransitRouterVpcAttachment
type CreateTransitRouterVpcAttachmentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                    requests.Integer                                `position:"Query" name:"ResourceOwnerId"`
	VpcOwnerId                         requests.Integer                                `position:"Query" name:"VpcOwnerId"`
	ClientToken                        string                                          `position:"Query" name:"ClientToken"`
	CenId                              string                                          `position:"Query" name:"CenId"`
	RouteTableAssociationEnabled       requests.Boolean                                `position:"Query" name:"RouteTableAssociationEnabled"`
	TransitRouterAttachmentName        string                                          `position:"Query" name:"TransitRouterAttachmentName"`
	AutoCreateVpcRoute                 requests.Boolean                                `position:"Query" name:"AutoCreateVpcRoute"`
	RouteTablePropagationEnabled       requests.Boolean                                `position:"Query" name:"RouteTablePropagationEnabled"`
	DryRun                             requests.Boolean                                `position:"Query" name:"DryRun"`
	ResourceOwnerAccount               string                                          `position:"Query" name:"ResourceOwnerAccount"`
	ZoneMappings                       *[]CreateTransitRouterVpcAttachmentZoneMappings `position:"Query" name:"ZoneMappings"  type:"Repeated"`
	OwnerAccount                       string                                          `position:"Query" name:"OwnerAccount"`
	OwnerId                            requests.Integer                                `position:"Query" name:"OwnerId"`
	TransitRouterId                    string                                          `position:"Query" name:"TransitRouterId"`
	ResourceType                       string                                          `position:"Query" name:"ResourceType"`
	TransitRouterAttachmentDescription string                                          `position:"Query" name:"TransitRouterAttachmentDescription"`
	VpcId                              string                                          `position:"Query" name:"VpcId"`
	ChargeType                         string                                          `position:"Query" name:"ChargeType"`
}

// CreateTransitRouterVpcAttachmentZoneMappings is a repeated param struct in CreateTransitRouterVpcAttachmentRequest
type CreateTransitRouterVpcAttachmentZoneMappings struct {
	VSwitchId string `name:"VSwitchId"`
	ZoneId    string `name:"ZoneId"`
}

// CreateTransitRouterVpcAttachmentResponse is the response struct for api CreateTransitRouterVpcAttachment
type CreateTransitRouterVpcAttachmentResponse struct {
	*responses.BaseResponse
	RequestId                 string `json:"RequestId" xml:"RequestId"`
	TransitRouterAttachmentId string `json:"TransitRouterAttachmentId" xml:"TransitRouterAttachmentId"`
}

// CreateCreateTransitRouterVpcAttachmentRequest creates a request to invoke CreateTransitRouterVpcAttachment API
func CreateCreateTransitRouterVpcAttachmentRequest() (request *CreateTransitRouterVpcAttachmentRequest) {
	request = &CreateTransitRouterVpcAttachmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateTransitRouterVpcAttachment", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTransitRouterVpcAttachmentResponse creates a response to parse from CreateTransitRouterVpcAttachment response
func CreateCreateTransitRouterVpcAttachmentResponse() (response *CreateTransitRouterVpcAttachmentResponse) {
	response = &CreateTransitRouterVpcAttachmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
