package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySavingsPlansInstance invokes the bssopenapi.QuerySavingsPlansInstance API synchronously
func (client *Client) QuerySavingsPlansInstance(request *QuerySavingsPlansInstanceRequest) (response *QuerySavingsPlansInstanceResponse, err error) {
	response = CreateQuerySavingsPlansInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySavingsPlansInstanceWithChan invokes the bssopenapi.QuerySavingsPlansInstance API asynchronously
func (client *Client) QuerySavingsPlansInstanceWithChan(request *QuerySavingsPlansInstanceRequest) (<-chan *QuerySavingsPlansInstanceResponse, <-chan error) {
	responseChan := make(chan *QuerySavingsPlansInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySavingsPlansInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySavingsPlansInstanceWithCallback invokes the bssopenapi.QuerySavingsPlansInstance API asynchronously
func (client *Client) QuerySavingsPlansInstanceWithCallback(request *QuerySavingsPlansInstanceRequest, callback func(response *QuerySavingsPlansInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySavingsPlansInstanceResponse
		var err error
		defer close(result)
		response, err = client.QuerySavingsPlansInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySavingsPlansInstanceRequest is the request struct for api QuerySavingsPlansInstance
type QuerySavingsPlansInstanceRequest struct {
	*requests.RpcRequest
	EndTime    string                          `position:"Query" name:"EndTime"`
	StartTime  string                          `position:"Query" name:"StartTime"`
	Locale     string                          `position:"Query" name:"Locale"`
	PageNum    requests.Integer                `position:"Query" name:"PageNum"`
	InstanceId string                          `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer                `position:"Query" name:"PageSize"`
	Tag        *[]QuerySavingsPlansInstanceTag `position:"Query" name:"Tag"  type:"Repeated"`
}

// QuerySavingsPlansInstanceTag is a repeated param struct in QuerySavingsPlansInstanceRequest
type QuerySavingsPlansInstanceTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// QuerySavingsPlansInstanceResponse is the response struct for api QuerySavingsPlansInstance
type QuerySavingsPlansInstanceResponse struct {
	*responses.BaseResponse
	Code      string                          `json:"Code" xml:"Code"`
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Success   bool                            `json:"Success" xml:"Success"`
	Message   string                          `json:"Message" xml:"Message"`
	Data      DataInQuerySavingsPlansInstance `json:"Data" xml:"Data"`
}

// CreateQuerySavingsPlansInstanceRequest creates a request to invoke QuerySavingsPlansInstance API
func CreateQuerySavingsPlansInstanceRequest() (request *QuerySavingsPlansInstanceRequest) {
	request = &QuerySavingsPlansInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QuerySavingsPlansInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySavingsPlansInstanceResponse creates a response to parse from QuerySavingsPlansInstance response
func CreateQuerySavingsPlansInstanceResponse() (response *QuerySavingsPlansInstanceResponse) {
	response = &QuerySavingsPlansInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
